/* SPDX-FileCopyrightText: 2025 - Sébastien Wilmet
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "gedit-code-comment-app-activatable.h"
#include <gedit/gedit-app.h>
#include <gedit/gedit-app-activatable.h>

struct _GeditCodeCommentAppActivatablePrivate
{
	GeditApp *app;
};

enum
{
	PROP_0,
	PROP_APP
};

static void gedit_app_activatable_iface_init (GeditAppActivatableInterface *iface);

G_DEFINE_DYNAMIC_TYPE_EXTENDED (GeditCodeCommentAppActivatable,
				gedit_code_comment_app_activatable,
				G_TYPE_OBJECT,
				0,
				G_ADD_PRIVATE_DYNAMIC (GeditCodeCommentAppActivatable)
				G_IMPLEMENT_INTERFACE_DYNAMIC (GEDIT_TYPE_APP_ACTIVATABLE,
							       gedit_app_activatable_iface_init))

static void
gedit_code_comment_app_activatable_get_property (GObject    *object,
						 guint       prop_id,
						 GValue     *value,
						 GParamSpec *pspec)
{
	GeditCodeCommentAppActivatable *activatable = GEDIT_CODE_COMMENT_APP_ACTIVATABLE (object);

	switch (prop_id)
	{
		case PROP_APP:
			g_value_set_object (value, activatable->priv->app);
			break;

		default:
			G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
			break;
	}
}

static void
gedit_code_comment_app_activatable_set_property (GObject      *object,
						 guint         prop_id,
						 const GValue *value,
						 GParamSpec   *pspec)
{
	GeditCodeCommentAppActivatable *activatable = GEDIT_CODE_COMMENT_APP_ACTIVATABLE (object);

	switch (prop_id)
	{
		case PROP_APP:
			g_assert (activatable->priv->app == NULL);
			activatable->priv->app = GEDIT_APP (g_value_dup_object (value));
			break;

		default:
			G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
			break;
	}
}

static void
gedit_code_comment_app_activatable_dispose (GObject *object)
{
	GeditCodeCommentAppActivatable *activatable = GEDIT_CODE_COMMENT_APP_ACTIVATABLE (object);

	g_clear_object (&activatable->priv->app);

	G_OBJECT_CLASS (gedit_code_comment_app_activatable_parent_class)->dispose (object);
}

static void
gedit_code_comment_app_activatable_class_init (GeditCodeCommentAppActivatableClass *klass)
{
	GObjectClass *object_class = G_OBJECT_CLASS (klass);

	object_class->get_property = gedit_code_comment_app_activatable_get_property;
	object_class->set_property = gedit_code_comment_app_activatable_set_property;
	object_class->dispose = gedit_code_comment_app_activatable_dispose;

	g_object_class_override_property (object_class, PROP_APP, "app");
}

static void
gedit_code_comment_app_activatable_class_finalize (GeditCodeCommentAppActivatableClass *klass)
{
}

static void
gedit_code_comment_app_activatable_init (GeditCodeCommentAppActivatable *activatable)
{
	activatable->priv = gedit_code_comment_app_activatable_get_instance_private (activatable);
}

static void
add_accels (GtkApplication *app)
{
	const gchar *accels[2];

	accels[0] = "<Control>M";
	accels[1] = NULL;
	gtk_application_set_accels_for_action (app, "win.code-comment-plugin-comment", accels);

	accels[0] = "<Control><Shift>M";
	gtk_application_set_accels_for_action (app, "win.code-comment-plugin-uncomment", accels);
}

static void
remove_accels (GtkApplication *app)
{
	const gchar *null_accels[] = { NULL };

	gtk_application_set_accels_for_action (app, "win.code-comment-plugin-comment", null_accels);
	gtk_application_set_accels_for_action (app, "win.code-comment-plugin-uncomment", null_accels);
}

static void
gedit_code_comment_app_activatable_activate (GeditAppActivatable *activatable)
{
	GeditCodeCommentAppActivatable *self = GEDIT_CODE_COMMENT_APP_ACTIVATABLE (activatable);

	add_accels (GTK_APPLICATION (self->priv->app));
}

static void
gedit_code_comment_app_activatable_deactivate (GeditAppActivatable *activatable)
{
	GeditCodeCommentAppActivatable *self = GEDIT_CODE_COMMENT_APP_ACTIVATABLE (activatable);

	remove_accels (GTK_APPLICATION (self->priv->app));
}

static void
gedit_app_activatable_iface_init (GeditAppActivatableInterface *iface)
{
	iface->activate = gedit_code_comment_app_activatable_activate;
	iface->deactivate = gedit_code_comment_app_activatable_deactivate;
}

void
gedit_code_comment_app_activatable_register (PeasObjectModule *module)
{
	gedit_code_comment_app_activatable_register_type (G_TYPE_MODULE (module));

	peas_object_module_register_extension_type (module,
						    GEDIT_TYPE_APP_ACTIVATABLE,
						    GEDIT_TYPE_CODE_COMMENT_APP_ACTIVATABLE);
}
