/* gitg-remote-manager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-remote-manager.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2012 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include "libgitg-ext.h"
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "libgitg.h"
#include <gtk/gtk.h>
#include <libgit2-glib/ggit.h>
#include <stdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GITG_TYPE_REMOTE_MANAGER (gitg_remote_manager_get_type ())
#define GITG_REMOTE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REMOTE_MANAGER, GitgRemoteManager))
#define GITG_REMOTE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_REMOTE_MANAGER, GitgRemoteManagerClass))
#define GITG_IS_REMOTE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REMOTE_MANAGER))
#define GITG_IS_REMOTE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_REMOTE_MANAGER))
#define GITG_REMOTE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_REMOTE_MANAGER, GitgRemoteManagerClass))

typedef struct _GitgRemoteManager GitgRemoteManager;
typedef struct _GitgRemoteManagerClass GitgRemoteManagerClass;
typedef struct _GitgRemoteManagerPrivate GitgRemoteManagerPrivate;

#define GITG_REMOTE_MANAGER_TYPE_INSTEAD_OF (gitg_remote_manager_instead_of_get_type ())
typedef struct _GitgRemoteManagerInsteadOf GitgRemoteManagerInsteadOf;

#define GITG_TYPE_WINDOW (gitg_window_get_type ())
#define GITG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_WINDOW, GitgWindow))
#define GITG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_WINDOW, GitgWindowClass))
#define GITG_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_WINDOW))
#define GITG_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_WINDOW))
#define GITG_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_WINDOW, GitgWindowClass))

typedef struct _GitgWindow GitgWindow;
typedef struct _GitgWindowClass GitgWindowClass;
enum  {
	GITG_REMOTE_MANAGER_0_PROPERTY,
	GITG_REMOTE_MANAGER_NUM_PROPERTIES
};
static GParamSpec* gitg_remote_manager_properties[GITG_REMOTE_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define GITG_REMOTE_MANAGER_TYPE_UI_CREDENTIALS_PROVIDER (gitg_remote_manager_ui_credentials_provider_get_type ())
#define GITG_REMOTE_MANAGER_UI_CREDENTIALS_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_REMOTE_MANAGER_TYPE_UI_CREDENTIALS_PROVIDER, GitgRemoteManagerUICredentialsProvider))
#define GITG_REMOTE_MANAGER_UI_CREDENTIALS_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_REMOTE_MANAGER_TYPE_UI_CREDENTIALS_PROVIDER, GitgRemoteManagerUICredentialsProviderClass))
#define GITG_REMOTE_MANAGER_IS_UI_CREDENTIALS_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_REMOTE_MANAGER_TYPE_UI_CREDENTIALS_PROVIDER))
#define GITG_REMOTE_MANAGER_IS_UI_CREDENTIALS_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_REMOTE_MANAGER_TYPE_UI_CREDENTIALS_PROVIDER))
#define GITG_REMOTE_MANAGER_UI_CREDENTIALS_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_REMOTE_MANAGER_TYPE_UI_CREDENTIALS_PROVIDER, GitgRemoteManagerUICredentialsProviderClass))

typedef struct _GitgRemoteManagerUICredentialsProvider GitgRemoteManagerUICredentialsProvider;
typedef struct _GitgRemoteManagerUICredentialsProviderClass GitgRemoteManagerUICredentialsProviderClass;
typedef struct _GitgRemoteManagerUICredentialsProviderPrivate GitgRemoteManagerUICredentialsProviderPrivate;
enum  {
	GITG_REMOTE_MANAGER_UI_CREDENTIALS_PROVIDER_0_PROPERTY,
	GITG_REMOTE_MANAGER_UI_CREDENTIALS_PROVIDER_NUM_PROPERTIES
};
static GParamSpec* gitg_remote_manager_ui_credentials_provider_properties[GITG_REMOTE_MANAGER_UI_CREDENTIALS_PROVIDER_NUM_PROPERTIES];
#define _gitg_credentials_manager_unref0(var) ((var == NULL) ? NULL : (var = (gitg_credentials_manager_unref (var), NULL)))

struct _GitgRemoteManager {
	GObject parent_instance;
	GitgRemoteManagerPrivate * priv;
};

struct _GitgRemoteManagerClass {
	GObjectClass parent_class;
};

struct _GitgRemoteManagerInsteadOf {
	gchar* prefix;
	gchar* replacement;
};

struct _GitgRemoteManagerPrivate {
	GeeHashMap* d_remotes;
	GitgRemoteManagerInsteadOf* d_insteadof;
	gint d_insteadof_length1;
	gint _d_insteadof_size_;
	GitgWindow* d_window;
};

struct _GitgRemoteManagerUICredentialsProvider {
	GObject parent_instance;
	GitgRemoteManagerUICredentialsProviderPrivate * priv;
};

struct _GitgRemoteManagerUICredentialsProviderClass {
	GObjectClass parent_class;
};

struct _GitgRemoteManagerUICredentialsProviderPrivate {
	GitgCredentialsManager* d_credentials;
};

static gint GitgRemoteManager_private_offset;
static gpointer gitg_remote_manager_parent_class = NULL;
static gint GitgRemoteManagerUICredentialsProvider_private_offset;
static gpointer gitg_remote_manager_ui_credentials_provider_parent_class = NULL;
static GitgCredentialsProviderIface * gitg_remote_manager_ui_credentials_provider_gitg_credentials_provider_parent_iface = NULL;
static GitgExtRemoteLookupIface * gitg_remote_manager_gitg_ext_remote_lookup_parent_iface = NULL;

VALA_EXTERN GType gitg_remote_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgRemoteManager, g_object_unref)
static GType gitg_remote_manager_instead_of_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GitgRemoteManagerInsteadOf* gitg_remote_manager_instead_of_dup (const GitgRemoteManagerInsteadOf* self);
static void gitg_remote_manager_instead_of_free (GitgRemoteManagerInsteadOf* self);
static void gitg_remote_manager_instead_of_copy (const GitgRemoteManagerInsteadOf* self,
                                          GitgRemoteManagerInsteadOf* dest);
static void gitg_remote_manager_instead_of_destroy (GitgRemoteManagerInsteadOf* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (GitgRemoteManagerInsteadOf, gitg_remote_manager_instead_of_destroy)
VALA_EXTERN GType gitg_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgWindow, g_object_unref)
static void _vala_GitgRemoteManagerInsteadOf_array_free (GitgRemoteManagerInsteadOf * array,
                                                  gssize array_length);
VALA_EXTERN GitgRemoteManager* gitg_remote_manager_new (GitgWindow* window);
VALA_EXTERN GitgRemoteManager* gitg_remote_manager_construct (GType object_type,
                                                  GitgWindow* window);
static void gitg_remote_manager_extract_insteadof (GitgRemoteManager* self);
static gint ___lambda173_ (GitgRemoteManager* self,
                    GMatchInfo* info,
                    const gchar* value);
static void _vala_array_add27 (GitgRemoteManagerInsteadOf* * array,
                        gint* length,
                        gint* size,
                        const GitgRemoteManagerInsteadOf* value);
static gint ____lambda173__ggit_config_match_callback (GMatchInfo* match_info,
                                                const gchar* value,
                                                gpointer self);
static GitgRemote* gitg_remote_manager_real_lookup (GitgExtRemoteLookup* base,
                                             const gchar* name);
static GitgRemoteManagerUICredentialsProvider* gitg_remote_manager_ui_credentials_provider_new (GitgRemote* remote,
                                                                                         GtkWindow* window);
static GitgRemoteManagerUICredentialsProvider* gitg_remote_manager_ui_credentials_provider_construct (GType object_type,
                                                                                               GitgRemote* remote,
                                                                                               GtkWindow* window);
static GType gitg_remote_manager_ui_credentials_provider_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgRemoteManagerUICredentialsProvider, g_object_unref)
static GgitCred* gitg_remote_manager_ui_credentials_provider_real_credentials (GitgCredentialsProvider* base,
                                                                        const gchar* url,
                                                                        const gchar* username_from_url,
                                                                        GgitCredtype allowed_types,
                                                                        GError** error);
static void gitg_remote_manager_ui_credentials_provider_finalize (GObject * obj);
static GType gitg_remote_manager_ui_credentials_provider_get_type_once (void);
static void gitg_remote_manager_finalize (GObject * obj);
static GType gitg_remote_manager_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
gitg_remote_manager_get_instance_private (GitgRemoteManager* self)
{
	return G_STRUCT_MEMBER_P (self, GitgRemoteManager_private_offset);
}

static void
_vala_GitgRemoteManagerInsteadOf_array_free (GitgRemoteManagerInsteadOf * array,
                                             gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			gitg_remote_manager_instead_of_destroy (&array[i]);
		}
	}
	g_free (array);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GitgRemoteManager*
gitg_remote_manager_construct (GType object_type,
                               GitgWindow* window)
{
	GitgRemoteManager * self = NULL;
	GitgWindow* _tmp0_;
	GeeHashMap* _tmp1_;
	g_return_val_if_fail (window != NULL, NULL);
	self = (GitgRemoteManager*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (window);
	_g_object_unref0 (self->priv->d_window);
	self->priv->d_window = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GITG_TYPE_REMOTE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->d_remotes);
	self->priv->d_remotes = _tmp1_;
	gitg_remote_manager_extract_insteadof (self);
	return self;
}

GitgRemoteManager*
gitg_remote_manager_new (GitgWindow* window)
{
	return gitg_remote_manager_construct (GITG_TYPE_REMOTE_MANAGER, window);
}

static void
_vala_array_add27 (GitgRemoteManagerInsteadOf* * array,
                   gint* length,
                   gint* size,
                   const GitgRemoteManagerInsteadOf* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GitgRemoteManagerInsteadOf, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static gint
___lambda173_ (GitgRemoteManager* self,
               GMatchInfo* info,
               const gchar* value)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GitgRemoteManagerInsteadOf _tmp2_ = {0};
	gint result;
	g_return_val_if_fail (info != NULL, 0);
	g_return_val_if_fail (value != NULL, 0);
	_tmp0_ = g_strdup (value);
	_tmp1_ = g_match_info_fetch (info, 1);
	memset (&_tmp2_, 0, sizeof (GitgRemoteManagerInsteadOf));
	_g_free0 (_tmp2_.prefix);
	_tmp2_.prefix = _tmp0_;
	_g_free0 (_tmp2_.replacement);
	_tmp2_.replacement = _tmp1_;
	_vala_array_add27 (&self->priv->d_insteadof, &self->priv->d_insteadof_length1, &self->priv->_d_insteadof_size_, &_tmp2_);
	result = 0;
	return result;
}

static gint
____lambda173__ggit_config_match_callback (GMatchInfo* match_info,
                                           const gchar* value,
                                           gpointer self)
{
	gint result;
	result = ___lambda173_ ((GitgRemoteManager*) self, match_info, value);
	return result;
}

static void
gitg_remote_manager_extract_insteadof (GitgRemoteManager* self)
{
	GitgRemoteManagerInsteadOf* _tmp0_;
	GitgWindow* _tmp1_;
	GitgRepository* _tmp2_;
	GitgRepository* _tmp3_;
	GitgRepository* _tmp4_;
	gboolean _tmp5_;
	GgitConfig* config = NULL;
	GRegex* r = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (GitgRemoteManagerInsteadOf, 10);
	self->priv->d_insteadof = (_vala_GitgRemoteManagerInsteadOf_array_free (self->priv->d_insteadof, self->priv->d_insteadof_length1), NULL);
	self->priv->d_insteadof = _tmp0_;
	self->priv->d_insteadof_length1 = 10;
	self->priv->_d_insteadof_size_ = self->priv->d_insteadof_length1;
	self->priv->d_insteadof_length1 = 0;
	_tmp1_ = self->priv->d_window;
	_tmp2_ = gitg_ext_application_get_repository ((GitgExtApplication*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_ == NULL;
	_g_object_unref0 (_tmp4_);
	if (_tmp5_) {
		return;
	}
	{
		GgitConfig* _tmp6_ = NULL;
		GitgWindow* _tmp7_;
		GitgRepository* _tmp8_;
		GitgRepository* _tmp9_;
		GitgRepository* _tmp10_;
		GgitConfig* _tmp11_;
		GgitConfig* _tmp12_;
		GgitConfig* _tmp13_ = NULL;
		GgitConfig* _tmp14_;
		GgitConfig* _tmp15_;
		_tmp7_ = self->priv->d_window;
		_tmp8_ = gitg_ext_application_get_repository ((GitgExtApplication*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_;
		_tmp11_ = ggit_repository_get_config ((GgitRepository*) _tmp10_, &_inner_error0_);
		_tmp12_ = _tmp11_;
		_g_object_unref0 (_tmp10_);
		_tmp6_ = _tmp12_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp14_ = ggit_config_snapshot (_tmp6_, &_inner_error0_);
		_tmp13_ = _tmp14_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp6_);
			goto __catch0_g_error;
		}
		_tmp15_ = _tmp13_;
		_tmp13_ = NULL;
		_g_object_unref0 (config);
		config = _tmp15_;
		_g_object_unref0 (_tmp13_);
		_g_object_unref0 (_tmp6_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		_g_object_unref0 (config);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	{
		GRegex* _tmp16_ = NULL;
		GRegex* _tmp17_;
		GRegex* _tmp18_;
		_tmp17_ = g_regex_new ("url\\.(.*)\\.insteadof", 0, 0, &_inner_error0_);
		_tmp16_ = _tmp17_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp18_ = _tmp16_;
		_tmp16_ = NULL;
		_g_regex_unref0 (r);
		r = _tmp18_;
		_g_regex_unref0 (_tmp16_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		FILE* _tmp19_;
		GError* _tmp20_;
		const gchar* _tmp21_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp19_ = stderr;
		_tmp20_ = e;
		_tmp21_ = _tmp20_->message;
		fprintf (_tmp19_, "Failed to compile regex: %s\n", _tmp21_);
		_g_error_free0 (e);
		_g_regex_unref0 (r);
		_g_object_unref0 (config);
		return;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_regex_unref0 (r);
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	{
		GgitConfig* _tmp22_;
		GRegex* _tmp23_;
		_tmp22_ = config;
		_tmp23_ = r;
		ggit_config_match_foreach (_tmp22_, _tmp23_, ____lambda173__ggit_config_match_callback, self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_regex_unref0 (r);
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_regex_unref0 (r);
	_g_object_unref0 (config);
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static GitgRemote*
gitg_remote_manager_real_lookup (GitgExtRemoteLookup* base,
                                 const gchar* name)
{
	GitgRemoteManager * self;
	GitgWindow* _tmp0_;
	GitgRepository* _tmp1_;
	GitgRepository* _tmp2_;
	GitgRepository* _tmp3_;
	gboolean _tmp4_;
	GeeHashMap* _tmp5_;
	GeeHashMap* _tmp7_;
	GitgRemote* remote = NULL;
	gchar* url = NULL;
	GitgRemote* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	GitgRemoteManagerInsteadOf* _tmp21_;
	gint _tmp21__length1;
	GitgRemote* _tmp64_;
	GitgRemote* _tmp65_;
	GitgWindow* _tmp66_;
	GitgRemoteManagerUICredentialsProvider* _tmp67_;
	GitgRemoteManagerUICredentialsProvider* _tmp68_;
	GeeHashMap* _tmp69_;
	GitgRemote* _tmp70_;
	GError* _inner_error0_ = NULL;
	GitgRemote* result;
	self = (GitgRemoteManager*) base;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->d_window;
	_tmp1_ = gitg_ext_application_get_repository ((GitgExtApplication*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_ == NULL;
	_g_object_unref0 (_tmp3_);
	if (_tmp4_) {
		result = NULL;
		return result;
	}
	_tmp5_ = self->priv->d_remotes;
	if (_tmp5_ == NULL) {
		GeeHashMap* _tmp6_;
		_tmp6_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GITG_TYPE_REMOTE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (self->priv->d_remotes);
		self->priv->d_remotes = _tmp6_;
	}
	_tmp7_ = self->priv->d_remotes;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp7_, name)) {
		GeeHashMap* _tmp8_;
		gpointer _tmp9_;
		_tmp8_ = self->priv->d_remotes;
		_tmp9_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp8_, name);
		result = (GitgRemote*) _tmp9_;
		return result;
	}
	{
		GgitRemote* _tmp10_ = NULL;
		GitgWindow* _tmp11_;
		GitgRepository* _tmp12_;
		GitgRepository* _tmp13_;
		GitgRepository* _tmp14_;
		GgitRemote* _tmp15_;
		GgitRemote* _tmp16_;
		GitgRemote* _tmp17_;
		_tmp11_ = self->priv->d_window;
		_tmp12_ = gitg_ext_application_get_repository ((GitgExtApplication*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _tmp13_;
		_tmp15_ = ggit_repository_lookup_remote ((GgitRepository*) _tmp14_, name, &_inner_error0_);
		_tmp16_ = _tmp15_;
		_g_object_unref0 (_tmp14_);
		_tmp10_ = _tmp16_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, GITG_TYPE_REMOTE) ? ((GitgRemote*) _tmp10_) : NULL);
		_g_object_unref0 (remote);
		remote = _tmp17_;
		_g_object_unref0 (_tmp10_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = NULL;
		_g_object_unref0 (remote);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (remote);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp18_ = remote;
	_tmp19_ = ggit_remote_get_url ((GgitRemote*) _tmp18_);
	_tmp20_ = g_strdup (_tmp19_);
	url = _tmp20_;
	_tmp21_ = self->priv->d_insteadof;
	_tmp21__length1 = self->priv->d_insteadof_length1;
	{
		GitgRemoteManagerInsteadOf* io_collection = NULL;
		gint io_collection_length1 = 0;
		gint _io_collection_size_ = 0;
		gint io_it = 0;
		io_collection = _tmp21_;
		io_collection_length1 = _tmp21__length1;
		for (io_it = 0; io_it < io_collection_length1; io_it = io_it + 1) {
			GitgRemoteManagerInsteadOf _tmp22_;
			GitgRemoteManagerInsteadOf _tmp23_ = {0};
			GitgRemoteManagerInsteadOf io = {0};
			_tmp22_ = io_collection[io_it];
			gitg_remote_manager_instead_of_copy (&_tmp22_, &_tmp23_);
			io = _tmp23_;
			{
				const gchar* _tmp24_;
				GitgRemoteManagerInsteadOf _tmp25_;
				const gchar* _tmp26_;
				_tmp24_ = url;
				_tmp25_ = io;
				_tmp26_ = _tmp25_.prefix;
				if (g_str_has_prefix (_tmp24_, _tmp26_)) {
					GitgRemoteManagerInsteadOf _tmp27_;
					const gchar* _tmp28_;
					const gchar* _tmp29_;
					GitgRemoteManagerInsteadOf _tmp30_;
					const gchar* _tmp31_;
					gint _tmp32_;
					gint _tmp33_;
					gchar* _tmp34_;
					gchar* _tmp35_;
					gchar* _tmp36_;
					gchar** fetch_specs = NULL;
					gint fetch_specs_length1 = 0;
					gint _fetch_specs_size_ = 0;
					gchar** push_specs = NULL;
					gint push_specs_length1 = 0;
					gint _push_specs_size_ = 0;
					GitgRemote* _tmp37_;
					gchar** _tmp38_;
					gint _tmp38__length1;
					gint _tmp39_ = 0;
					gchar** _tmp40_;
					gint _tmp40__length1;
					GitgRemote* _tmp41_;
					gchar** _tmp42_;
					gint _tmp42__length1;
					gint _tmp43_ = 0;
					gchar** _tmp44_;
					gint _tmp44__length1;
					GitgRemote* tmp = NULL;
					GitgRemote* _tmp57_;
					GitgRemote* _tmp58_;
					gchar** _tmp59_;
					gint _tmp59__length1;
					GitgRemote* _tmp60_;
					gchar** _tmp61_;
					gint _tmp61__length1;
					GitgRemote* _tmp62_;
					GitgRemote* _tmp63_;
					_tmp27_ = io;
					_tmp28_ = _tmp27_.replacement;
					_tmp29_ = url;
					_tmp30_ = io;
					_tmp31_ = _tmp30_.prefix;
					_tmp32_ = strlen (_tmp31_);
					_tmp33_ = _tmp32_;
					_tmp34_ = string_substring (_tmp29_, (glong) _tmp33_, (glong) -1);
					_tmp35_ = _tmp34_;
					_tmp36_ = g_strconcat (_tmp28_, _tmp35_, NULL);
					_g_free0 (url);
					url = _tmp36_;
					_g_free0 (_tmp35_);
					_tmp37_ = remote;
					_tmp38_ = gitg_remote_get_fetch_specs (_tmp37_, &_tmp39_);
					_tmp38__length1 = _tmp39_;
					_tmp40_ = _tmp38_;
					_tmp40__length1 = _tmp38__length1;
					fetch_specs = (_vala_array_free (fetch_specs, fetch_specs_length1, (GDestroyNotify) g_free), NULL);
					fetch_specs = _tmp40_;
					fetch_specs_length1 = _tmp40__length1;
					_fetch_specs_size_ = fetch_specs_length1;
					_tmp41_ = remote;
					_tmp42_ = gitg_remote_get_push_specs (_tmp41_, &_tmp43_);
					_tmp42__length1 = _tmp43_;
					_tmp44_ = _tmp42_;
					_tmp44__length1 = _tmp42__length1;
					push_specs = (_vala_array_free (push_specs, push_specs_length1, (GDestroyNotify) g_free), NULL);
					push_specs = _tmp44_;
					push_specs_length1 = _tmp44__length1;
					_push_specs_size_ = push_specs_length1;
					tmp = NULL;
					{
						GgitRemote* _tmp45_ = NULL;
						GitgWindow* _tmp46_;
						GitgRepository* _tmp47_;
						GitgRepository* _tmp48_;
						GitgRepository* _tmp49_;
						const gchar* _tmp50_;
						GgitRemote* _tmp51_;
						GgitRemote* _tmp52_;
						GitgRemote* _tmp53_;
						_tmp46_ = self->priv->d_window;
						_tmp47_ = gitg_ext_application_get_repository ((GitgExtApplication*) _tmp46_);
						_tmp48_ = _tmp47_;
						_tmp49_ = _tmp48_;
						_tmp50_ = url;
						_tmp51_ = ggit_remote_new_anonymous ((GgitRepository*) _tmp49_, _tmp50_, &_inner_error0_);
						_tmp52_ = _tmp51_;
						_g_object_unref0 (_tmp49_);
						_tmp45_ = _tmp52_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							goto __catch1_g_error;
						}
						_tmp53_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp45_, GITG_TYPE_REMOTE) ? ((GitgRemote*) _tmp45_) : NULL);
						_g_object_unref0 (tmp);
						tmp = _tmp53_;
						_g_object_unref0 (_tmp45_);
					}
					goto __finally1;
					__catch1_g_error:
					{
						GError* e = NULL;
						FILE* _tmp54_;
						GError* _tmp55_;
						const gchar* _tmp56_;
						e = _inner_error0_;
						_inner_error0_ = NULL;
						_tmp54_ = stderr;
						_tmp55_ = e;
						_tmp56_ = _tmp55_->message;
						fprintf (_tmp54_, "Failed to create remote: %s\n", _tmp56_);
						_g_error_free0 (e);
					}
					__finally1:
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (tmp);
						push_specs = (_vala_array_free (push_specs, push_specs_length1, (GDestroyNotify) g_free), NULL);
						fetch_specs = (_vala_array_free (fetch_specs, fetch_specs_length1, (GDestroyNotify) g_free), NULL);
						gitg_remote_manager_instead_of_destroy (&io);
						_g_free0 (url);
						_g_object_unref0 (remote);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
					_tmp57_ = tmp;
					if (_tmp57_ == NULL) {
						_g_object_unref0 (tmp);
						push_specs = (_vala_array_free (push_specs, push_specs_length1, (GDestroyNotify) g_free), NULL);
						fetch_specs = (_vala_array_free (fetch_specs, fetch_specs_length1, (GDestroyNotify) g_free), NULL);
						gitg_remote_manager_instead_of_destroy (&io);
						break;
					}
					_tmp58_ = tmp;
					_tmp59_ = fetch_specs;
					_tmp59__length1 = fetch_specs_length1;
					gitg_remote_set_fetch_specs (_tmp58_, _tmp59_, _tmp59__length1);
					_tmp60_ = tmp;
					_tmp61_ = push_specs;
					_tmp61__length1 = push_specs_length1;
					gitg_remote_set_push_specs (_tmp60_, _tmp61_, _tmp61__length1);
					_tmp62_ = tmp;
					_tmp63_ = _g_object_ref0 (_tmp62_);
					_g_object_unref0 (remote);
					remote = _tmp63_;
					_g_object_unref0 (tmp);
					push_specs = (_vala_array_free (push_specs, push_specs_length1, (GDestroyNotify) g_free), NULL);
					fetch_specs = (_vala_array_free (fetch_specs, fetch_specs_length1, (GDestroyNotify) g_free), NULL);
					gitg_remote_manager_instead_of_destroy (&io);
					break;
				}
				gitg_remote_manager_instead_of_destroy (&io);
			}
		}
	}
	_tmp64_ = remote;
	_tmp65_ = remote;
	_tmp66_ = self->priv->d_window;
	_tmp67_ = gitg_remote_manager_ui_credentials_provider_new (_tmp65_, (GtkWindow*) _tmp66_);
	_tmp68_ = _tmp67_;
	gitg_remote_set_credentials_provider (_tmp64_, (GitgCredentialsProvider*) _tmp68_);
	_g_object_unref0 (_tmp68_);
	_tmp69_ = self->priv->d_remotes;
	_tmp70_ = remote;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp69_, name, _tmp70_);
	result = remote;
	_g_free0 (url);
	return result;
}

static inline gpointer
gitg_remote_manager_ui_credentials_provider_get_instance_private (GitgRemoteManagerUICredentialsProvider* self)
{
	return G_STRUCT_MEMBER_P (self, GitgRemoteManagerUICredentialsProvider_private_offset);
}

static GitgRemoteManagerUICredentialsProvider*
gitg_remote_manager_ui_credentials_provider_construct (GType object_type,
                                                       GitgRemote* remote,
                                                       GtkWindow* window)
{
	GitgRemoteManagerUICredentialsProvider * self = NULL;
	GgitConfig* config = NULL;
	GgitConfig* _tmp6_;
	GitgCredentialsManager* _tmp7_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (remote != NULL, NULL);
	g_return_val_if_fail (window != NULL, NULL);
	self = (GitgRemoteManagerUICredentialsProvider*) g_object_new (object_type, NULL);
	config = NULL;
	{
		GgitConfig* _tmp0_ = NULL;
		GgitRepository* _tmp1_;
		GgitRepository* _tmp2_;
		GgitConfig* _tmp3_;
		GgitConfig* _tmp4_;
		GgitConfig* _tmp5_;
		_tmp1_ = ggit_remote_get_owner ((GgitRemote*) remote);
		_tmp2_ = _tmp1_;
		_tmp3_ = ggit_repository_get_config (_tmp2_, &_inner_error0_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (config);
		config = _tmp5_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp6_ = config;
	_tmp7_ = gitg_credentials_manager_new (_tmp6_, window, TRUE);
	_gitg_credentials_manager_unref0 (self->priv->d_credentials);
	self->priv->d_credentials = _tmp7_;
	_g_object_unref0 (config);
	return self;
}

static GitgRemoteManagerUICredentialsProvider*
gitg_remote_manager_ui_credentials_provider_new (GitgRemote* remote,
                                                 GtkWindow* window)
{
	return gitg_remote_manager_ui_credentials_provider_construct (GITG_REMOTE_MANAGER_TYPE_UI_CREDENTIALS_PROVIDER, remote, window);
}

static GgitCred*
gitg_remote_manager_ui_credentials_provider_real_credentials (GitgCredentialsProvider* base,
                                                              const gchar* url,
                                                              const gchar* username_from_url,
                                                              GgitCredtype allowed_types,
                                                              GError** error)
{
	GitgRemoteManagerUICredentialsProvider * self;
	GgitCred* _tmp0_ = NULL;
	GitgCredentialsManager* _tmp1_;
	GgitCred* _tmp2_;
	GgitCred* _tmp3_;
	GError* _inner_error0_ = NULL;
	GgitCred* result;
	self = (GitgRemoteManagerUICredentialsProvider*) base;
	g_return_val_if_fail (url != NULL, NULL);
	_tmp1_ = self->priv->d_credentials;
	_tmp2_ = gitg_credentials_manager_credentials (_tmp1_, url, username_from_url, allowed_types, &_inner_error0_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp3_;
	_g_object_unref0 (_tmp0_);
	return result;
}

static void
gitg_remote_manager_ui_credentials_provider_class_init (GitgRemoteManagerUICredentialsProviderClass * klass,
                                                        gpointer klass_data)
{
	gitg_remote_manager_ui_credentials_provider_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgRemoteManagerUICredentialsProvider_private_offset);
	G_OBJECT_CLASS (klass)->finalize = gitg_remote_manager_ui_credentials_provider_finalize;
}

static void
gitg_remote_manager_ui_credentials_provider_gitg_credentials_provider_interface_init (GitgCredentialsProviderIface * iface,
                                                                                      gpointer iface_data)
{
	gitg_remote_manager_ui_credentials_provider_gitg_credentials_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->credentials = (GgitCred* (*) (GitgCredentialsProvider*, const gchar*, const gchar*, GgitCredtype, GError**)) gitg_remote_manager_ui_credentials_provider_real_credentials;
}

static void
gitg_remote_manager_ui_credentials_provider_instance_init (GitgRemoteManagerUICredentialsProvider * self,
                                                           gpointer klass)
{
	self->priv = gitg_remote_manager_ui_credentials_provider_get_instance_private (self);
}

static void
gitg_remote_manager_ui_credentials_provider_finalize (GObject * obj)
{
	GitgRemoteManagerUICredentialsProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_REMOTE_MANAGER_TYPE_UI_CREDENTIALS_PROVIDER, GitgRemoteManagerUICredentialsProvider);
	_gitg_credentials_manager_unref0 (self->priv->d_credentials);
	G_OBJECT_CLASS (gitg_remote_manager_ui_credentials_provider_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_remote_manager_ui_credentials_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgRemoteManagerUICredentialsProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_remote_manager_ui_credentials_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgRemoteManagerUICredentialsProvider), 0, (GInstanceInitFunc) gitg_remote_manager_ui_credentials_provider_instance_init, NULL };
	static const GInterfaceInfo gitg_credentials_provider_info = { (GInterfaceInitFunc) gitg_remote_manager_ui_credentials_provider_gitg_credentials_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gitg_remote_manager_ui_credentials_provider_type_id;
	gitg_remote_manager_ui_credentials_provider_type_id = g_type_register_static (G_TYPE_OBJECT, "GitgRemoteManagerUICredentialsProvider", &g_define_type_info, 0);
	g_type_add_interface_static (gitg_remote_manager_ui_credentials_provider_type_id, GITG_TYPE_CREDENTIALS_PROVIDER, &gitg_credentials_provider_info);
	GitgRemoteManagerUICredentialsProvider_private_offset = g_type_add_instance_private (gitg_remote_manager_ui_credentials_provider_type_id, sizeof (GitgRemoteManagerUICredentialsProviderPrivate));
	return gitg_remote_manager_ui_credentials_provider_type_id;
}

static GType
gitg_remote_manager_ui_credentials_provider_get_type (void)
{
	static gsize gitg_remote_manager_ui_credentials_provider_type_id__once = 0;
	if (g_once_init_enter (&gitg_remote_manager_ui_credentials_provider_type_id__once)) {
		GType gitg_remote_manager_ui_credentials_provider_type_id;
		gitg_remote_manager_ui_credentials_provider_type_id = gitg_remote_manager_ui_credentials_provider_get_type_once ();
		g_once_init_leave (&gitg_remote_manager_ui_credentials_provider_type_id__once, gitg_remote_manager_ui_credentials_provider_type_id);
	}
	return gitg_remote_manager_ui_credentials_provider_type_id__once;
}

static void
gitg_remote_manager_instead_of_copy (const GitgRemoteManagerInsteadOf* self,
                                     GitgRemoteManagerInsteadOf* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = (*self).prefix;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).prefix);
	(*dest).prefix = _tmp1_;
	_tmp2_ = (*self).replacement;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).replacement);
	(*dest).replacement = _tmp3_;
}

static void
gitg_remote_manager_instead_of_destroy (GitgRemoteManagerInsteadOf* self)
{
	_g_free0 ((*self).prefix);
	_g_free0 ((*self).replacement);
}

static GitgRemoteManagerInsteadOf*
gitg_remote_manager_instead_of_dup (const GitgRemoteManagerInsteadOf* self)
{
	GitgRemoteManagerInsteadOf* dup;
	dup = g_new0 (GitgRemoteManagerInsteadOf, 1);
	gitg_remote_manager_instead_of_copy (self, dup);
	return dup;
}

static void
gitg_remote_manager_instead_of_free (GitgRemoteManagerInsteadOf* self)
{
	gitg_remote_manager_instead_of_destroy (self);
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
gitg_remote_manager_instead_of_get_type_once (void)
{
	GType gitg_remote_manager_instead_of_type_id;
	gitg_remote_manager_instead_of_type_id = g_boxed_type_register_static ("GitgRemoteManagerInsteadOf", (GBoxedCopyFunc) gitg_remote_manager_instead_of_dup, (GBoxedFreeFunc) gitg_remote_manager_instead_of_free);
	return gitg_remote_manager_instead_of_type_id;
}

static GType
gitg_remote_manager_instead_of_get_type (void)
{
	static gsize gitg_remote_manager_instead_of_type_id__once = 0;
	if (g_once_init_enter (&gitg_remote_manager_instead_of_type_id__once)) {
		GType gitg_remote_manager_instead_of_type_id;
		gitg_remote_manager_instead_of_type_id = gitg_remote_manager_instead_of_get_type_once ();
		g_once_init_leave (&gitg_remote_manager_instead_of_type_id__once, gitg_remote_manager_instead_of_type_id);
	}
	return gitg_remote_manager_instead_of_type_id__once;
}

static void
gitg_remote_manager_class_init (GitgRemoteManagerClass * klass,
                                gpointer klass_data)
{
	gitg_remote_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgRemoteManager_private_offset);
	G_OBJECT_CLASS (klass)->finalize = gitg_remote_manager_finalize;
}

static void
gitg_remote_manager_gitg_ext_remote_lookup_interface_init (GitgExtRemoteLookupIface * iface,
                                                           gpointer iface_data)
{
	gitg_remote_manager_gitg_ext_remote_lookup_parent_iface = g_type_interface_peek_parent (iface);
	iface->lookup = (GitgRemote* (*) (GitgExtRemoteLookup*, const gchar*)) gitg_remote_manager_real_lookup;
}

static void
gitg_remote_manager_instance_init (GitgRemoteManager * self,
                                   gpointer klass)
{
	self->priv = gitg_remote_manager_get_instance_private (self);
}

static void
gitg_remote_manager_finalize (GObject * obj)
{
	GitgRemoteManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_REMOTE_MANAGER, GitgRemoteManager);
	_g_object_unref0 (self->priv->d_remotes);
	self->priv->d_insteadof = (_vala_GitgRemoteManagerInsteadOf_array_free (self->priv->d_insteadof, self->priv->d_insteadof_length1), NULL);
	_g_object_unref0 (self->priv->d_window);
	G_OBJECT_CLASS (gitg_remote_manager_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_remote_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgRemoteManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_remote_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgRemoteManager), 0, (GInstanceInitFunc) gitg_remote_manager_instance_init, NULL };
	static const GInterfaceInfo gitg_ext_remote_lookup_info = { (GInterfaceInitFunc) gitg_remote_manager_gitg_ext_remote_lookup_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gitg_remote_manager_type_id;
	gitg_remote_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "GitgRemoteManager", &g_define_type_info, 0);
	g_type_add_interface_static (gitg_remote_manager_type_id, GITG_EXT_TYPE_REMOTE_LOOKUP, &gitg_ext_remote_lookup_info);
	GitgRemoteManager_private_offset = g_type_add_instance_private (gitg_remote_manager_type_id, sizeof (GitgRemoteManagerPrivate));
	return gitg_remote_manager_type_id;
}

GType
gitg_remote_manager_get_type (void)
{
	static gsize gitg_remote_manager_type_id__once = 0;
	if (g_once_init_enter (&gitg_remote_manager_type_id__once)) {
		GType gitg_remote_manager_type_id;
		gitg_remote_manager_type_id = gitg_remote_manager_get_type_once ();
		g_once_init_leave (&gitg_remote_manager_type_id__once, gitg_remote_manager_type_id);
	}
	return gitg_remote_manager_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

