

-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Atk.Callbacks
    ( 

 -- * Signals


-- ** EventListener #signal:EventListener#

    C_EventListener                         ,
    EventListener                           ,
    dynamic_EventListener                   ,
    genClosure_EventListener                ,
    mk_EventListener                        ,
    noEventListener                         ,
    wrap_EventListener                      ,


-- ** EventListenerInit #signal:EventListenerInit#

    C_EventListenerInit                     ,
    EventListenerInit                       ,
    dynamic_EventListenerInit               ,
    genClosure_EventListenerInit            ,
    mk_EventListenerInit                    ,
    noEventListenerInit                     ,
    wrap_EventListenerInit                  ,


-- ** FocusHandler #signal:FocusHandler#

    C_FocusHandler                          ,
    FocusHandler                            ,
    dynamic_FocusHandler                    ,
    genClosure_FocusHandler                 ,
    mk_FocusHandler                         ,
    noFocusHandler                          ,
    wrap_FocusHandler                       ,


-- ** Function #signal:Function#

    C_Function                              ,
    Function                                ,
    Function_WithClosures                   ,
    drop_closures_Function                  ,
    dynamic_Function                        ,
    genClosure_Function                     ,
    mk_Function                             ,
    noFunction                              ,
    noFunction_WithClosures                 ,
    wrap_Function                           ,


-- ** KeySnoopFunc #signal:KeySnoopFunc#

    C_KeySnoopFunc                          ,
    KeySnoopFunc                            ,
    KeySnoopFunc_WithClosures               ,
    drop_closures_KeySnoopFunc              ,
    dynamic_KeySnoopFunc                    ,
    genClosure_KeySnoopFunc                 ,
    mk_KeySnoopFunc                         ,
    noKeySnoopFunc                          ,
    noKeySnoopFunc_WithClosures             ,
    wrap_KeySnoopFunc                       ,


-- ** PropertyChangeHandler #signal:PropertyChangeHandler#

    C_PropertyChangeHandler                 ,
    PropertyChangeHandler                   ,
    dynamic_PropertyChangeHandler           ,
    genClosure_PropertyChangeHandler        ,
    mk_PropertyChangeHandler                ,
    noPropertyChangeHandler                 ,
    wrap_PropertyChangeHandler              ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.Atk.Enums as Atk.Enums
import {-# SOURCE #-} qualified GI.Atk.Objects.Object as Atk.Object
import {-# SOURCE #-} qualified GI.Atk.Objects.Relation as Atk.Relation
import {-# SOURCE #-} qualified GI.Atk.Objects.RelationSet as Atk.RelationSet
import {-# SOURCE #-} qualified GI.Atk.Objects.StateSet as Atk.StateSet
import {-# SOURCE #-} qualified GI.Atk.Structs.KeyEventStruct as Atk.KeyEventStruct
import {-# SOURCE #-} qualified GI.Atk.Structs.PropertyValues as Atk.PropertyValues
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.GObject.Structs.ValueArray as GObject.ValueArray

#else
import {-# SOURCE #-} qualified GI.Atk.Objects.Object as Atk.Object
import {-# SOURCE #-} qualified GI.Atk.Structs.KeyEventStruct as Atk.KeyEventStruct
import {-# SOURCE #-} qualified GI.Atk.Structs.PropertyValues as Atk.PropertyValues

#endif

-- callback PropertyChangeHandler
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "obj"
          , argType = TInterface Name { namespace = "Atk" , name = "Object" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "atkobject which property changes"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "vals"
          , argType =
              TInterface Name { namespace = "Atk" , name = "PropertyValues" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "values changed" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated =
      Just
        DeprecationInfo
          { deprecatedSinceVersion = Nothing
          , deprecationMessage = Just "Since 2.12."
          }
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "An AtkPropertyChangeHandler is a function which is executed when an\nAtkObject's property changes value. It is specified in a call to\natk_object_connect_property_change_handler()."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_PropertyChangeHandler =
    Ptr Atk.Object.Object ->
    Ptr Atk.PropertyValues.PropertyValues ->
    IO ()

-- Args: [ Arg
--           { argCName = "obj"
--           , argType = TInterface Name { namespace = "Atk" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "atkobject which property changes"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "vals"
--           , argType =
--               TInterface Name { namespace = "Atk" , name = "PropertyValues" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "values changed" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_PropertyChangeHandler :: FunPtr C_PropertyChangeHandler -> C_PropertyChangeHandler

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_PropertyChangeHandler ::
    (B.CallStack.HasCallStack, MonadIO m, Atk.Object.IsObject a) =>
    FunPtr C_PropertyChangeHandler
    -> a
    -- ^ /@obj@/: atkobject which property changes
    -> Atk.PropertyValues.PropertyValues
    -- ^ /@vals@/: values changed
    -> m ()
dynamic_PropertyChangeHandler __funPtr obj vals = liftIO $ do
    obj' <- unsafeManagedPtrCastPtr obj
    vals' <- unsafeManagedPtrGetPtr vals
    (__dynamic_C_PropertyChangeHandler __funPtr) obj' vals'
    touchManagedPtr obj
    touchManagedPtr vals
    return ()

-- | Generate a function pointer callable from C code, from a `C_PropertyChangeHandler`.
foreign import ccall "wrapper"
    mk_PropertyChangeHandler :: C_PropertyChangeHandler -> IO (FunPtr C_PropertyChangeHandler)

{-# DEPRECATED PropertyChangeHandler ["Since 2.12."] #-}
-- | An AtkPropertyChangeHandler is a function which is executed when an
-- AtkObject\'s property changes value. It is specified in a call to
-- @/atk_object_connect_property_change_handler()/@.
type PropertyChangeHandler =
    Atk.Object.Object
    -- ^ /@obj@/: atkobject which property changes
    -> Atk.PropertyValues.PropertyValues
    -- ^ /@vals@/: values changed
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `PropertyChangeHandler`@.
noPropertyChangeHandler :: Maybe PropertyChangeHandler
noPropertyChangeHandler = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_PropertyChangeHandler :: MonadIO m => PropertyChangeHandler -> m (GClosure C_PropertyChangeHandler)
genClosure_PropertyChangeHandler cb = liftIO $ do
    let cb' = wrap_PropertyChangeHandler Nothing cb
    mk_PropertyChangeHandler cb' >>= B.GClosure.newGClosure


-- | Wrap a `PropertyChangeHandler` into a `C_PropertyChangeHandler`.
wrap_PropertyChangeHandler :: 
    Maybe (Ptr (FunPtr C_PropertyChangeHandler)) ->
    PropertyChangeHandler ->
    C_PropertyChangeHandler
wrap_PropertyChangeHandler gi'funptrptr gi'cb obj vals = do
    obj' <- (newObject Atk.Object.Object) obj
    vals' <- (newPtr Atk.PropertyValues.PropertyValues) vals
    gi'cb  obj' vals'
    maybeReleaseFunPtr gi'funptrptr


-- callback KeySnoopFunc
{- Callable
  { returnType = Just (TBasicType TInt)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "TRUE (nonzero) if the event emission should be stopped and the event\ndiscarded without being passed to the normal GUI recipient; FALSE (zero) if the\nevent dispatch to the client application should proceed as normal.\n\nsee [id@atk_add_key_event_listener]"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "event"
          , argType =
              TInterface Name { namespace = "Atk" , name = "KeyEventStruct" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "an AtkKeyEventStruct containing information about the key event for which\nnotification is being given."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "a block of data which will be passed to the event listener, on notification."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "An #AtkKeySnoopFunc is a type of callback which is called whenever a key event occurs,\nif registered via atk_add_key_event_listener.  It allows for pre-emptive\ninterception of key events via the return code as described below."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_KeySnoopFunc =
    Ptr Atk.KeyEventStruct.KeyEventStruct ->
    Ptr () ->
    IO Int32

-- Args: [ Arg
--           { argCName = "event"
--           , argType =
--               TInterface Name { namespace = "Atk" , name = "KeyEventStruct" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "an AtkKeyEventStruct containing information about the key event for which\nnotification is being given."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a block of data which will be passed to the event listener, on notification."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_KeySnoopFunc :: FunPtr C_KeySnoopFunc -> C_KeySnoopFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_KeySnoopFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_KeySnoopFunc
    -> Atk.KeyEventStruct.KeyEventStruct
    -- ^ /@event@/: an AtkKeyEventStruct containing information about the key event for which
    -- notification is being given.
    -> Ptr ()
    -- ^ /@userData@/: a block of data which will be passed to the event listener, on notification.
    -> m Int32
    -- ^ __Returns:__ TRUE (nonzero) if the event emission should be stopped and the event
    -- discarded without being passed to the normal GUI recipient; FALSE (zero) if the
    -- event dispatch to the client application should proceed as normal.
    -- 
    -- see @/atk_add_key_event_listener()/@
dynamic_KeySnoopFunc __funPtr event userData = liftIO $ do
    event' <- unsafeManagedPtrGetPtr event
    result <- (__dynamic_C_KeySnoopFunc __funPtr) event' userData
    touchManagedPtr event
    return result

-- | Generate a function pointer callable from C code, from a `C_KeySnoopFunc`.
foreign import ccall "wrapper"
    mk_KeySnoopFunc :: C_KeySnoopFunc -> IO (FunPtr C_KeySnoopFunc)

-- | An t'GI.Atk.Callbacks.KeySnoopFunc' is a type of callback which is called whenever a key event occurs,
-- if registered via atk_add_key_event_listener.  It allows for pre-emptive
-- interception of key events via the return code as described below.
type KeySnoopFunc =
    Atk.KeyEventStruct.KeyEventStruct
    -- ^ /@event@/: an AtkKeyEventStruct containing information about the key event for which
    -- notification is being given.
    -> IO Int32
    -- ^ __Returns:__ TRUE (nonzero) if the event emission should be stopped and the event
    -- discarded without being passed to the normal GUI recipient; FALSE (zero) if the
    -- event dispatch to the client application should proceed as normal.
    -- 
    -- see @/atk_add_key_event_listener()/@

-- | A convenience synonym for @`Nothing` :: `Maybe` `KeySnoopFunc`@.
noKeySnoopFunc :: Maybe KeySnoopFunc
noKeySnoopFunc = Nothing

-- | An t'GI.Atk.Callbacks.KeySnoopFunc' is a type of callback which is called whenever a key event occurs,
-- if registered via atk_add_key_event_listener.  It allows for pre-emptive
-- interception of key events via the return code as described below.
type KeySnoopFunc_WithClosures =
    Atk.KeyEventStruct.KeyEventStruct
    -- ^ /@event@/: an AtkKeyEventStruct containing information about the key event for which
    -- notification is being given.
    -> Ptr ()
    -- ^ /@userData@/: a block of data which will be passed to the event listener, on notification.
    -> IO Int32
    -- ^ __Returns:__ TRUE (nonzero) if the event emission should be stopped and the event
    -- discarded without being passed to the normal GUI recipient; FALSE (zero) if the
    -- event dispatch to the client application should proceed as normal.
    -- 
    -- see @/atk_add_key_event_listener()/@

-- | A convenience synonym for @`Nothing` :: `Maybe` `KeySnoopFunc_WithClosures`@.
noKeySnoopFunc_WithClosures :: Maybe KeySnoopFunc_WithClosures
noKeySnoopFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_KeySnoopFunc :: KeySnoopFunc -> KeySnoopFunc_WithClosures
drop_closures_KeySnoopFunc _f event _ = _f event

-- | Wrap the callback into a `GClosure`.
genClosure_KeySnoopFunc :: MonadIO m => KeySnoopFunc -> m (GClosure C_KeySnoopFunc)
genClosure_KeySnoopFunc cb = liftIO $ do
    let cb' = drop_closures_KeySnoopFunc cb
    let cb'' = wrap_KeySnoopFunc Nothing cb'
    mk_KeySnoopFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `KeySnoopFunc` into a `C_KeySnoopFunc`.
wrap_KeySnoopFunc :: 
    Maybe (Ptr (FunPtr C_KeySnoopFunc)) ->
    KeySnoopFunc_WithClosures ->
    C_KeySnoopFunc
wrap_KeySnoopFunc gi'funptrptr gi'cb event userData = do
    event' <- (newPtr Atk.KeyEventStruct.KeyEventStruct) event
    result <- gi'cb  event' userData
    maybeReleaseFunPtr gi'funptrptr
    return result


-- callback Function
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "not used" , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "custom data defined by the user"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "An AtkFunction is a function definition used for padding which has\nbeen added to class and interface structures to allow for expansion\nin the future."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_Function =
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "custom data defined by the user"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_Function :: FunPtr C_Function -> C_Function

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_Function ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_Function
    -> Ptr ()
    -- ^ /@userData@/: custom data defined by the user
    -> m Bool
    -- ^ __Returns:__ not used
dynamic_Function __funPtr userData = liftIO $ do
    result <- (__dynamic_C_Function __funPtr) userData
    let result' = (/= 0) result
    return result'

-- | Generate a function pointer callable from C code, from a `C_Function`.
foreign import ccall "wrapper"
    mk_Function :: C_Function -> IO (FunPtr C_Function)

-- | An AtkFunction is a function definition used for padding which has
-- been added to class and interface structures to allow for expansion
-- in the future.
type Function =
    IO Bool
    -- ^ __Returns:__ not used

-- | A convenience synonym for @`Nothing` :: `Maybe` `Function`@.
noFunction :: Maybe Function
noFunction = Nothing

-- | An AtkFunction is a function definition used for padding which has
-- been added to class and interface structures to allow for expansion
-- in the future.
type Function_WithClosures =
    Ptr ()
    -- ^ /@userData@/: custom data defined by the user
    -> IO Bool
    -- ^ __Returns:__ not used

-- | A convenience synonym for @`Nothing` :: `Maybe` `Function_WithClosures`@.
noFunction_WithClosures :: Maybe Function_WithClosures
noFunction_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_Function :: Function -> Function_WithClosures
drop_closures_Function _f _ = _f 

-- | Wrap the callback into a `GClosure`.
genClosure_Function :: MonadIO m => Function -> m (GClosure C_Function)
genClosure_Function cb = liftIO $ do
    let cb' = drop_closures_Function cb
    let cb'' = wrap_Function Nothing cb'
    mk_Function cb'' >>= B.GClosure.newGClosure


-- | Wrap a `Function` into a `C_Function`.
wrap_Function :: 
    Maybe (Ptr (FunPtr C_Function)) ->
    Function_WithClosures ->
    C_Function
wrap_Function gi'funptrptr gi'cb userData = do
    result <- gi'cb  userData
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback FocusHandler
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "object"
          , argType = TInterface Name { namespace = "Atk" , name = "Object" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the #AtkObject that receives/lose the focus"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "focus_in"
          , argType = TBasicType TBoolean
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "TRUE if the object receives the focus"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated =
      Just
        DeprecationInfo
          { deprecatedSinceVersion = Just "2.9.4"
          , deprecationMessage =
              Just
                "Deprecated with atk_component_add_focus_handler()\nand atk_component_remove_focus_handler(). See those\nmethods for more information."
          }
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "The type of callback function used for\natk_component_add_focus_handler() and\natk_component_remove_focus_handler()"
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_FocusHandler =
    Ptr Atk.Object.Object ->
    CInt ->
    IO ()

-- Args: [ Arg
--           { argCName = "object"
--           , argType = TInterface Name { namespace = "Atk" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #AtkObject that receives/lose the focus"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "focus_in"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "TRUE if the object receives the focus"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_FocusHandler :: FunPtr C_FocusHandler -> C_FocusHandler

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_FocusHandler ::
    (B.CallStack.HasCallStack, MonadIO m, Atk.Object.IsObject a) =>
    FunPtr C_FocusHandler
    -> a
    -- ^ /@object@/: the t'GI.Atk.Objects.Object.Object' that receives\/lose the focus
    -> Bool
    -- ^ /@focusIn@/: TRUE if the object receives the focus
    -> m ()
dynamic_FocusHandler __funPtr object focusIn = liftIO $ do
    object' <- unsafeManagedPtrCastPtr object
    let focusIn' = (P.fromIntegral . P.fromEnum) focusIn
    (__dynamic_C_FocusHandler __funPtr) object' focusIn'
    touchManagedPtr object
    return ()

-- | Generate a function pointer callable from C code, from a `C_FocusHandler`.
foreign import ccall "wrapper"
    mk_FocusHandler :: C_FocusHandler -> IO (FunPtr C_FocusHandler)

{-# DEPRECATED FocusHandler ["(Since version 2.9.4)","Deprecated with @/atk_component_add_focus_handler()/@","and 'GI.Atk.Interfaces.Component.componentRemoveFocusHandler'. See those","methods for more information."] #-}
-- | The type of callback function used for
-- @/atk_component_add_focus_handler()/@ and
-- 'GI.Atk.Interfaces.Component.componentRemoveFocusHandler'
type FocusHandler =
    Atk.Object.Object
    -- ^ /@object@/: the t'GI.Atk.Objects.Object.Object' that receives\/lose the focus
    -> Bool
    -- ^ /@focusIn@/: TRUE if the object receives the focus
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `FocusHandler`@.
noFocusHandler :: Maybe FocusHandler
noFocusHandler = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_FocusHandler :: MonadIO m => FocusHandler -> m (GClosure C_FocusHandler)
genClosure_FocusHandler cb = liftIO $ do
    let cb' = wrap_FocusHandler Nothing cb
    mk_FocusHandler cb' >>= B.GClosure.newGClosure


-- | Wrap a `FocusHandler` into a `C_FocusHandler`.
wrap_FocusHandler :: 
    Maybe (Ptr (FunPtr C_FocusHandler)) ->
    FocusHandler ->
    C_FocusHandler
wrap_FocusHandler gi'funptrptr gi'cb object focusIn = do
    object' <- (newObject Atk.Object.Object) object
    let focusIn' = (/= 0) focusIn
    gi'cb  object' focusIn'
    maybeReleaseFunPtr gi'funptrptr


-- callback EventListenerInit
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args = []
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "An #AtkEventListenerInit function is a special function that is\ncalled in order to initialize the per-object event registration system\nused by #AtkEventListener, if any preparation is required.\n\nsee [id@atk_focus_tracker_init]"
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_EventListenerInit =
    IO ()

-- Args: []
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_EventListenerInit :: FunPtr C_EventListenerInit -> C_EventListenerInit

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_EventListenerInit ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_EventListenerInit
    -> m ()
dynamic_EventListenerInit __funPtr = liftIO $ do
    (__dynamic_C_EventListenerInit __funPtr)
    return ()

-- | Generate a function pointer callable from C code, from a `C_EventListenerInit`.
foreign import ccall "wrapper"
    mk_EventListenerInit :: C_EventListenerInit -> IO (FunPtr C_EventListenerInit)

-- | An t'GI.Atk.Callbacks.EventListenerInit' function is a special function that is
-- called in order to initialize the per-object event registration system
-- used by t'GI.Atk.Callbacks.EventListener', if any preparation is required.
-- 
-- see @/atk_focus_tracker_init()/@
type EventListenerInit =
    IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `EventListenerInit`@.
noEventListenerInit :: Maybe EventListenerInit
noEventListenerInit = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_EventListenerInit :: MonadIO m => EventListenerInit -> m (GClosure C_EventListenerInit)
genClosure_EventListenerInit cb = liftIO $ do
    let cb' = wrap_EventListenerInit Nothing cb
    mk_EventListenerInit cb' >>= B.GClosure.newGClosure


-- | Wrap a `EventListenerInit` into a `C_EventListenerInit`.
wrap_EventListenerInit :: 
    Maybe (Ptr (FunPtr C_EventListenerInit)) ->
    EventListenerInit ->
    C_EventListenerInit
wrap_EventListenerInit gi'funptrptr gi'cb = do
    gi'cb 
    maybeReleaseFunPtr gi'funptrptr


-- callback EventListener
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "obj"
          , argType = TInterface Name { namespace = "Atk" , name = "Object" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "An #AtkObject instance for whom the callback will be called when\nthe specified event (e.g. 'focus:') takes place."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A function which is called when an object emits a matching event,\nas used in #atk_add_focus_tracker.\nCurrently the only events for which object-specific handlers are\nsupported are events of type \"focus:\".  Most clients of ATK will prefer to\nattach signal handlers for the various ATK signals instead.\n\nsee [id@atk_add_focus_tracker]"
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_EventListener =
    Ptr Atk.Object.Object ->
    IO ()

-- Args: [ Arg
--           { argCName = "obj"
--           , argType = TInterface Name { namespace = "Atk" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "An #AtkObject instance for whom the callback will be called when\nthe specified event (e.g. 'focus:') takes place."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_EventListener :: FunPtr C_EventListener -> C_EventListener

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_EventListener ::
    (B.CallStack.HasCallStack, MonadIO m, Atk.Object.IsObject a) =>
    FunPtr C_EventListener
    -> a
    -- ^ /@obj@/: An t'GI.Atk.Objects.Object.Object' instance for whom the callback will be called when
    -- the specified event (e.g. \'focus:\') takes place.
    -> m ()
dynamic_EventListener __funPtr obj = liftIO $ do
    obj' <- unsafeManagedPtrCastPtr obj
    (__dynamic_C_EventListener __funPtr) obj'
    touchManagedPtr obj
    return ()

-- | Generate a function pointer callable from C code, from a `C_EventListener`.
foreign import ccall "wrapper"
    mk_EventListener :: C_EventListener -> IO (FunPtr C_EventListener)

-- | A function which is called when an object emits a matching event,
-- as used in @/atk_add_focus_tracker/@.
-- Currently the only events for which object-specific handlers are
-- supported are events of type \"focus:\".  Most clients of ATK will prefer to
-- attach signal handlers for the various ATK signals instead.
-- 
-- see @/atk_add_focus_tracker()/@
type EventListener =
    Atk.Object.Object
    -- ^ /@obj@/: An t'GI.Atk.Objects.Object.Object' instance for whom the callback will be called when
    -- the specified event (e.g. \'focus:\') takes place.
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `EventListener`@.
noEventListener :: Maybe EventListener
noEventListener = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_EventListener :: MonadIO m => EventListener -> m (GClosure C_EventListener)
genClosure_EventListener cb = liftIO $ do
    let cb' = wrap_EventListener Nothing cb
    mk_EventListener cb' >>= B.GClosure.newGClosure


-- | Wrap a `EventListener` into a `C_EventListener`.
wrap_EventListener :: 
    Maybe (Ptr (FunPtr C_EventListener)) ->
    EventListener ->
    C_EventListener
wrap_EventListener gi'funptrptr gi'cb obj = do
    obj' <- (newObject Atk.Object.Object) obj
    gi'cb  obj'
    maybeReleaseFunPtr gi'funptrptr



