{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Used for button press and button release events. The
-- /@type@/ field will be one of 'GI.Gdk.Enums.EventTypeButtonPress',
-- 'GI.Gdk.Enums.EventType2buttonPress', 'GI.Gdk.Enums.EventType3buttonPress' or 'GI.Gdk.Enums.EventTypeButtonRelease',
-- 
-- Double and triple-clicks result in a sequence of events being received.
-- For double-clicks the order of events will be:
-- 
-- * 'GI.Gdk.Enums.EventTypeButtonPress'
-- * 'GI.Gdk.Enums.EventTypeButtonRelease'
-- * 'GI.Gdk.Enums.EventTypeButtonPress'
-- * 'GI.Gdk.Enums.EventType2buttonPress'
-- * 'GI.Gdk.Enums.EventTypeButtonRelease'
-- 
-- 
-- Note that the first click is received just like a normal
-- button press, while the second click results in a 'GI.Gdk.Enums.EventType2buttonPress'
-- being received just after the 'GI.Gdk.Enums.EventTypeButtonPress'.
-- 
-- Triple-clicks are very similar to double-clicks, except that
-- 'GI.Gdk.Enums.EventType3buttonPress' is inserted after the third click. The order of the
-- events is:
-- 
-- * 'GI.Gdk.Enums.EventTypeButtonPress'
-- * 'GI.Gdk.Enums.EventTypeButtonRelease'
-- * 'GI.Gdk.Enums.EventTypeButtonPress'
-- * 'GI.Gdk.Enums.EventType2buttonPress'
-- * 'GI.Gdk.Enums.EventTypeButtonRelease'
-- * 'GI.Gdk.Enums.EventTypeButtonPress'
-- * 'GI.Gdk.Enums.EventType3buttonPress'
-- * 'GI.Gdk.Enums.EventTypeButtonRelease'
-- 
-- 
-- For a double click to occur, the second button press must occur within
-- 1\/4 of a second of the first. For a triple click to occur, the third
-- button press must also occur within 1\/2 second of the first button press.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Structs.EventButton
    ( 

-- * Exported types
    EventButton(..)                         ,
    newZeroEventButton                      ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveEventButtonMethod                ,
#endif



 -- * Properties


-- ** axes #attr:axes#
-- | /@x@/, /@y@/ translated to the axes of /@device@/, or 'P.Nothing' if /@device@/ is
--   the mouse.

#if defined(ENABLE_OVERLOADING)
    eventButton_axes                        ,
#endif
    getEventButtonAxes                      ,
    setEventButtonAxes                      ,


-- ** button #attr:button#
-- | the button which was pressed or released, numbered from 1 to 5.
--   Normally button 1 is the left mouse button, 2 is the middle button,
--   and 3 is the right button. On 2-button mice, the middle button can
--   often be simulated by pressing both mouse buttons together.

#if defined(ENABLE_OVERLOADING)
    eventButton_button                      ,
#endif
    getEventButtonButton                    ,
    setEventButtonButton                    ,


-- ** device #attr:device#
-- | the master device that the event originated from. Use
-- 'GI.Gdk.Unions.Event.eventGetSourceDevice' to get the slave device.

    clearEventButtonDevice                  ,
#if defined(ENABLE_OVERLOADING)
    eventButton_device                      ,
#endif
    getEventButtonDevice                    ,
    setEventButtonDevice                    ,


-- ** sendEvent #attr:sendEvent#
-- | 'P.True' if the event was sent explicitly.

#if defined(ENABLE_OVERLOADING)
    eventButton_sendEvent                   ,
#endif
    getEventButtonSendEvent                 ,
    setEventButtonSendEvent                 ,


-- ** state #attr:state#
-- | a bit-mask representing the state of
--   the modifier keys (e.g. Control, Shift and Alt) and the pointer
--   buttons. See t'GI.Gdk.Flags.ModifierType'.

#if defined(ENABLE_OVERLOADING)
    eventButton_state                       ,
#endif
    getEventButtonState                     ,
    setEventButtonState                     ,


-- ** time #attr:time#
-- | the time of the event in milliseconds.

#if defined(ENABLE_OVERLOADING)
    eventButton_time                        ,
#endif
    getEventButtonTime                      ,
    setEventButtonTime                      ,


-- ** type #attr:type#
-- | the type of the event ('GI.Gdk.Enums.EventTypeButtonPress', 'GI.Gdk.Enums.EventType2buttonPress',
--   'GI.Gdk.Enums.EventType3buttonPress' or 'GI.Gdk.Enums.EventTypeButtonRelease').

#if defined(ENABLE_OVERLOADING)
    eventButton_type                        ,
#endif
    getEventButtonType                      ,
    setEventButtonType                      ,


-- ** window #attr:window#
-- | the window which received the event.

    clearEventButtonWindow                  ,
#if defined(ENABLE_OVERLOADING)
    eventButton_window                      ,
#endif
    getEventButtonWindow                    ,
    setEventButtonWindow                    ,


-- ** x #attr:x#
-- | the x coordinate of the pointer relative to the window.

#if defined(ENABLE_OVERLOADING)
    eventButton_x                           ,
#endif
    getEventButtonX                         ,
    setEventButtonX                         ,


-- ** xRoot #attr:xRoot#
-- | the x coordinate of the pointer relative to the root of the
--   screen.

#if defined(ENABLE_OVERLOADING)
    eventButton_xRoot                       ,
#endif
    getEventButtonXRoot                     ,
    setEventButtonXRoot                     ,


-- ** y #attr:y#
-- | the y coordinate of the pointer relative to the window.

#if defined(ENABLE_OVERLOADING)
    eventButton_y                           ,
#endif
    getEventButtonY                         ,
    setEventButtonY                         ,


-- ** yRoot #attr:yRoot#
-- | the y coordinate of the pointer relative to the root of the
--   screen.

#if defined(ENABLE_OVERLOADING)
    eventButton_yRoot                       ,
#endif
    getEventButtonYRoot                     ,
    setEventButtonYRoot                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.Cairo.Structs.Pattern as Cairo.Pattern
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceManager as Gdk.DeviceManager
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DragContext as Gdk.DragContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawingContext as Gdk.DrawingContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Screen as Gdk.Screen
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Visual as Gdk.Visual
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.Gdk.Structs.Atom as Gdk.Atom
import {-# SOURCE #-} qualified GI.Gdk.Structs.Color as Gdk.Color
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventAny as Gdk.EventAny
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventConfigure as Gdk.EventConfigure
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventCrossing as Gdk.EventCrossing
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventDND as Gdk.EventDND
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventExpose as Gdk.EventExpose
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventFocus as Gdk.EventFocus
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventGrabBroken as Gdk.EventGrabBroken
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventKey as Gdk.EventKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventMotion as Gdk.EventMotion
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventOwnerChange as Gdk.EventOwnerChange
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadAxis as Gdk.EventPadAxis
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadButton as Gdk.EventPadButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadGroupMode as Gdk.EventPadGroupMode
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProperty as Gdk.EventProperty
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProximity as Gdk.EventProximity
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventScroll as Gdk.EventScroll
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSelection as Gdk.EventSelection
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSetting as Gdk.EventSetting
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouch as Gdk.EventTouch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadPinch as Gdk.EventTouchpadPinch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadSwipe as Gdk.EventTouchpadSwipe
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventVisibility as Gdk.EventVisibility
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventWindowState as Gdk.EventWindowState
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.Geometry as Gdk.Geometry
import {-# SOURCE #-} qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.WindowAttr as Gdk.WindowAttr
import {-# SOURCE #-} qualified GI.Gdk.Unions.Event as Gdk.Event
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext

#else
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window

#endif

-- | Memory-managed wrapper type.
newtype EventButton = EventButton (SP.ManagedPtr EventButton)
    deriving (Eq)

instance SP.ManagedPtrNewtype EventButton where
    toManagedPtr (EventButton p) = p

instance BoxedPtr EventButton where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 80 >=> B.ManagedPtr.wrapPtr EventButton)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr EventButton where
    boxedPtrCalloc = callocBytes 80


-- | Construct a t'EventButton' struct initialized to zero.
newZeroEventButton :: MonadIO m => m EventButton
newZeroEventButton = liftIO $ boxedPtrCalloc >>= wrapPtr EventButton

instance tag ~ 'AttrSet => Constructible EventButton tag where
    new _ attrs = do
        o <- newZeroEventButton
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventButton #type
-- @
getEventButtonType :: MonadIO m => EventButton -> m Gdk.Enums.EventType
getEventButtonType s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CInt
    let val' = (toEnum . fromIntegral) val
    return val'

-- | Set the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventButton [ #type 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventButtonType :: MonadIO m => EventButton -> Gdk.Enums.EventType -> m ()
setEventButtonType s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (fromIntegral . fromEnum) val
    poke (ptr `plusPtr` 0) (val' :: CInt)

#if defined(ENABLE_OVERLOADING)
data EventButtonTypeFieldInfo
instance AttrInfo EventButtonTypeFieldInfo where
    type AttrBaseTypeConstraint EventButtonTypeFieldInfo = (~) EventButton
    type AttrAllowedOps EventButtonTypeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventButtonTypeFieldInfo = (~) Gdk.Enums.EventType
    type AttrTransferTypeConstraint EventButtonTypeFieldInfo = (~)Gdk.Enums.EventType
    type AttrTransferType EventButtonTypeFieldInfo = Gdk.Enums.EventType
    type AttrGetType EventButtonTypeFieldInfo = Gdk.Enums.EventType
    type AttrLabel EventButtonTypeFieldInfo = "type"
    type AttrOrigin EventButtonTypeFieldInfo = EventButton
    attrGet = getEventButtonType
    attrSet = setEventButtonType
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventButton.type"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventButton.html#g:attr:type"
        })

eventButton_type :: AttrLabelProxy "type"
eventButton_type = AttrLabelProxy

#endif


-- | Get the value of the “@window@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventButton #window
-- @
getEventButtonWindow :: MonadIO m => EventButton -> m (Maybe Gdk.Window.Window)
getEventButtonWindow s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO (Ptr Gdk.Window.Window)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newObject Gdk.Window.Window) val'
        return val''
    return result

-- | Set the value of the “@window@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventButton [ #window 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventButtonWindow :: MonadIO m => EventButton -> Ptr Gdk.Window.Window -> m ()
setEventButtonWindow s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Ptr Gdk.Window.Window)

-- | Set the value of the “@window@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #window
-- @
clearEventButtonWindow :: MonadIO m => EventButton -> m ()
clearEventButtonWindow s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullPtr :: Ptr Gdk.Window.Window)

#if defined(ENABLE_OVERLOADING)
data EventButtonWindowFieldInfo
instance AttrInfo EventButtonWindowFieldInfo where
    type AttrBaseTypeConstraint EventButtonWindowFieldInfo = (~) EventButton
    type AttrAllowedOps EventButtonWindowFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint EventButtonWindowFieldInfo = (~) (Ptr Gdk.Window.Window)
    type AttrTransferTypeConstraint EventButtonWindowFieldInfo = (~)(Ptr Gdk.Window.Window)
    type AttrTransferType EventButtonWindowFieldInfo = (Ptr Gdk.Window.Window)
    type AttrGetType EventButtonWindowFieldInfo = Maybe Gdk.Window.Window
    type AttrLabel EventButtonWindowFieldInfo = "window"
    type AttrOrigin EventButtonWindowFieldInfo = EventButton
    attrGet = getEventButtonWindow
    attrSet = setEventButtonWindow
    attrConstruct = undefined
    attrClear = clearEventButtonWindow
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventButton.window"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventButton.html#g:attr:window"
        })

eventButton_window :: AttrLabelProxy "window"
eventButton_window = AttrLabelProxy

#endif


-- | Get the value of the “@send_event@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventButton #sendEvent
-- @
getEventButtonSendEvent :: MonadIO m => EventButton -> m Int8
getEventButtonSendEvent s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO Int8
    return val

-- | Set the value of the “@send_event@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventButton [ #sendEvent 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventButtonSendEvent :: MonadIO m => EventButton -> Int8 -> m ()
setEventButtonSendEvent s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Int8)

#if defined(ENABLE_OVERLOADING)
data EventButtonSendEventFieldInfo
instance AttrInfo EventButtonSendEventFieldInfo where
    type AttrBaseTypeConstraint EventButtonSendEventFieldInfo = (~) EventButton
    type AttrAllowedOps EventButtonSendEventFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventButtonSendEventFieldInfo = (~) Int8
    type AttrTransferTypeConstraint EventButtonSendEventFieldInfo = (~)Int8
    type AttrTransferType EventButtonSendEventFieldInfo = Int8
    type AttrGetType EventButtonSendEventFieldInfo = Int8
    type AttrLabel EventButtonSendEventFieldInfo = "send_event"
    type AttrOrigin EventButtonSendEventFieldInfo = EventButton
    attrGet = getEventButtonSendEvent
    attrSet = setEventButtonSendEvent
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventButton.sendEvent"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventButton.html#g:attr:sendEvent"
        })

eventButton_sendEvent :: AttrLabelProxy "sendEvent"
eventButton_sendEvent = AttrLabelProxy

#endif


-- | Get the value of the “@time@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventButton #time
-- @
getEventButtonTime :: MonadIO m => EventButton -> m Word32
getEventButtonTime s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 20) :: IO Word32
    return val

-- | Set the value of the “@time@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventButton [ #time 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventButtonTime :: MonadIO m => EventButton -> Word32 -> m ()
setEventButtonTime s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 20) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data EventButtonTimeFieldInfo
instance AttrInfo EventButtonTimeFieldInfo where
    type AttrBaseTypeConstraint EventButtonTimeFieldInfo = (~) EventButton
    type AttrAllowedOps EventButtonTimeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventButtonTimeFieldInfo = (~) Word32
    type AttrTransferTypeConstraint EventButtonTimeFieldInfo = (~)Word32
    type AttrTransferType EventButtonTimeFieldInfo = Word32
    type AttrGetType EventButtonTimeFieldInfo = Word32
    type AttrLabel EventButtonTimeFieldInfo = "time"
    type AttrOrigin EventButtonTimeFieldInfo = EventButton
    attrGet = getEventButtonTime
    attrSet = setEventButtonTime
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventButton.time"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventButton.html#g:attr:time"
        })

eventButton_time :: AttrLabelProxy "time"
eventButton_time = AttrLabelProxy

#endif


-- | Get the value of the “@x@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventButton #x
-- @
getEventButtonX :: MonadIO m => EventButton -> m Double
getEventButtonX s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@x@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventButton [ #x 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventButtonX :: MonadIO m => EventButton -> Double -> m ()
setEventButtonX s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 24) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data EventButtonXFieldInfo
instance AttrInfo EventButtonXFieldInfo where
    type AttrBaseTypeConstraint EventButtonXFieldInfo = (~) EventButton
    type AttrAllowedOps EventButtonXFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventButtonXFieldInfo = (~) Double
    type AttrTransferTypeConstraint EventButtonXFieldInfo = (~)Double
    type AttrTransferType EventButtonXFieldInfo = Double
    type AttrGetType EventButtonXFieldInfo = Double
    type AttrLabel EventButtonXFieldInfo = "x"
    type AttrOrigin EventButtonXFieldInfo = EventButton
    attrGet = getEventButtonX
    attrSet = setEventButtonX
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventButton.x"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventButton.html#g:attr:x"
        })

eventButton_x :: AttrLabelProxy "x"
eventButton_x = AttrLabelProxy

#endif


-- | Get the value of the “@y@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventButton #y
-- @
getEventButtonY :: MonadIO m => EventButton -> m Double
getEventButtonY s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 32) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@y@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventButton [ #y 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventButtonY :: MonadIO m => EventButton -> Double -> m ()
setEventButtonY s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 32) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data EventButtonYFieldInfo
instance AttrInfo EventButtonYFieldInfo where
    type AttrBaseTypeConstraint EventButtonYFieldInfo = (~) EventButton
    type AttrAllowedOps EventButtonYFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventButtonYFieldInfo = (~) Double
    type AttrTransferTypeConstraint EventButtonYFieldInfo = (~)Double
    type AttrTransferType EventButtonYFieldInfo = Double
    type AttrGetType EventButtonYFieldInfo = Double
    type AttrLabel EventButtonYFieldInfo = "y"
    type AttrOrigin EventButtonYFieldInfo = EventButton
    attrGet = getEventButtonY
    attrSet = setEventButtonY
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventButton.y"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventButton.html#g:attr:y"
        })

eventButton_y :: AttrLabelProxy "y"
eventButton_y = AttrLabelProxy

#endif


-- | Get the value of the “@axes@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventButton #axes
-- @
getEventButtonAxes :: MonadIO m => EventButton -> m Double
getEventButtonAxes s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 40) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@axes@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventButton [ #axes 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventButtonAxes :: MonadIO m => EventButton -> Double -> m ()
setEventButtonAxes s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 40) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data EventButtonAxesFieldInfo
instance AttrInfo EventButtonAxesFieldInfo where
    type AttrBaseTypeConstraint EventButtonAxesFieldInfo = (~) EventButton
    type AttrAllowedOps EventButtonAxesFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventButtonAxesFieldInfo = (~) Double
    type AttrTransferTypeConstraint EventButtonAxesFieldInfo = (~)Double
    type AttrTransferType EventButtonAxesFieldInfo = Double
    type AttrGetType EventButtonAxesFieldInfo = Double
    type AttrLabel EventButtonAxesFieldInfo = "axes"
    type AttrOrigin EventButtonAxesFieldInfo = EventButton
    attrGet = getEventButtonAxes
    attrSet = setEventButtonAxes
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventButton.axes"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventButton.html#g:attr:axes"
        })

eventButton_axes :: AttrLabelProxy "axes"
eventButton_axes = AttrLabelProxy

#endif


-- | Get the value of the “@state@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventButton #state
-- @
getEventButtonState :: MonadIO m => EventButton -> m [Gdk.Flags.ModifierType]
getEventButtonState s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 48) :: IO CUInt
    let val' = wordToGFlags val
    return val'

-- | Set the value of the “@state@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventButton [ #state 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventButtonState :: MonadIO m => EventButton -> [Gdk.Flags.ModifierType] -> m ()
setEventButtonState s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = gflagsToWord val
    poke (ptr `plusPtr` 48) (val' :: CUInt)

#if defined(ENABLE_OVERLOADING)
data EventButtonStateFieldInfo
instance AttrInfo EventButtonStateFieldInfo where
    type AttrBaseTypeConstraint EventButtonStateFieldInfo = (~) EventButton
    type AttrAllowedOps EventButtonStateFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventButtonStateFieldInfo = (~) [Gdk.Flags.ModifierType]
    type AttrTransferTypeConstraint EventButtonStateFieldInfo = (~)[Gdk.Flags.ModifierType]
    type AttrTransferType EventButtonStateFieldInfo = [Gdk.Flags.ModifierType]
    type AttrGetType EventButtonStateFieldInfo = [Gdk.Flags.ModifierType]
    type AttrLabel EventButtonStateFieldInfo = "state"
    type AttrOrigin EventButtonStateFieldInfo = EventButton
    attrGet = getEventButtonState
    attrSet = setEventButtonState
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventButton.state"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventButton.html#g:attr:state"
        })

eventButton_state :: AttrLabelProxy "state"
eventButton_state = AttrLabelProxy

#endif


-- | Get the value of the “@button@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventButton #button
-- @
getEventButtonButton :: MonadIO m => EventButton -> m Word32
getEventButtonButton s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 52) :: IO Word32
    return val

-- | Set the value of the “@button@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventButton [ #button 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventButtonButton :: MonadIO m => EventButton -> Word32 -> m ()
setEventButtonButton s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 52) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data EventButtonButtonFieldInfo
instance AttrInfo EventButtonButtonFieldInfo where
    type AttrBaseTypeConstraint EventButtonButtonFieldInfo = (~) EventButton
    type AttrAllowedOps EventButtonButtonFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventButtonButtonFieldInfo = (~) Word32
    type AttrTransferTypeConstraint EventButtonButtonFieldInfo = (~)Word32
    type AttrTransferType EventButtonButtonFieldInfo = Word32
    type AttrGetType EventButtonButtonFieldInfo = Word32
    type AttrLabel EventButtonButtonFieldInfo = "button"
    type AttrOrigin EventButtonButtonFieldInfo = EventButton
    attrGet = getEventButtonButton
    attrSet = setEventButtonButton
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventButton.button"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventButton.html#g:attr:button"
        })

eventButton_button :: AttrLabelProxy "button"
eventButton_button = AttrLabelProxy

#endif


-- | Get the value of the “@device@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventButton #device
-- @
getEventButtonDevice :: MonadIO m => EventButton -> m (Maybe Gdk.Device.Device)
getEventButtonDevice s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 56) :: IO (Ptr Gdk.Device.Device)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newObject Gdk.Device.Device) val'
        return val''
    return result

-- | Set the value of the “@device@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventButton [ #device 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventButtonDevice :: MonadIO m => EventButton -> Ptr Gdk.Device.Device -> m ()
setEventButtonDevice s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 56) (val :: Ptr Gdk.Device.Device)

-- | Set the value of the “@device@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #device
-- @
clearEventButtonDevice :: MonadIO m => EventButton -> m ()
clearEventButtonDevice s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 56) (FP.nullPtr :: Ptr Gdk.Device.Device)

#if defined(ENABLE_OVERLOADING)
data EventButtonDeviceFieldInfo
instance AttrInfo EventButtonDeviceFieldInfo where
    type AttrBaseTypeConstraint EventButtonDeviceFieldInfo = (~) EventButton
    type AttrAllowedOps EventButtonDeviceFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint EventButtonDeviceFieldInfo = (~) (Ptr Gdk.Device.Device)
    type AttrTransferTypeConstraint EventButtonDeviceFieldInfo = (~)(Ptr Gdk.Device.Device)
    type AttrTransferType EventButtonDeviceFieldInfo = (Ptr Gdk.Device.Device)
    type AttrGetType EventButtonDeviceFieldInfo = Maybe Gdk.Device.Device
    type AttrLabel EventButtonDeviceFieldInfo = "device"
    type AttrOrigin EventButtonDeviceFieldInfo = EventButton
    attrGet = getEventButtonDevice
    attrSet = setEventButtonDevice
    attrConstruct = undefined
    attrClear = clearEventButtonDevice
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventButton.device"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventButton.html#g:attr:device"
        })

eventButton_device :: AttrLabelProxy "device"
eventButton_device = AttrLabelProxy

#endif


-- | Get the value of the “@x_root@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventButton #xRoot
-- @
getEventButtonXRoot :: MonadIO m => EventButton -> m Double
getEventButtonXRoot s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 64) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@x_root@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventButton [ #xRoot 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventButtonXRoot :: MonadIO m => EventButton -> Double -> m ()
setEventButtonXRoot s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 64) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data EventButtonXRootFieldInfo
instance AttrInfo EventButtonXRootFieldInfo where
    type AttrBaseTypeConstraint EventButtonXRootFieldInfo = (~) EventButton
    type AttrAllowedOps EventButtonXRootFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventButtonXRootFieldInfo = (~) Double
    type AttrTransferTypeConstraint EventButtonXRootFieldInfo = (~)Double
    type AttrTransferType EventButtonXRootFieldInfo = Double
    type AttrGetType EventButtonXRootFieldInfo = Double
    type AttrLabel EventButtonXRootFieldInfo = "x_root"
    type AttrOrigin EventButtonXRootFieldInfo = EventButton
    attrGet = getEventButtonXRoot
    attrSet = setEventButtonXRoot
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventButton.xRoot"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventButton.html#g:attr:xRoot"
        })

eventButton_xRoot :: AttrLabelProxy "xRoot"
eventButton_xRoot = AttrLabelProxy

#endif


-- | Get the value of the “@y_root@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventButton #yRoot
-- @
getEventButtonYRoot :: MonadIO m => EventButton -> m Double
getEventButtonYRoot s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 72) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@y_root@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventButton [ #yRoot 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventButtonYRoot :: MonadIO m => EventButton -> Double -> m ()
setEventButtonYRoot s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 72) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data EventButtonYRootFieldInfo
instance AttrInfo EventButtonYRootFieldInfo where
    type AttrBaseTypeConstraint EventButtonYRootFieldInfo = (~) EventButton
    type AttrAllowedOps EventButtonYRootFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventButtonYRootFieldInfo = (~) Double
    type AttrTransferTypeConstraint EventButtonYRootFieldInfo = (~)Double
    type AttrTransferType EventButtonYRootFieldInfo = Double
    type AttrGetType EventButtonYRootFieldInfo = Double
    type AttrLabel EventButtonYRootFieldInfo = "y_root"
    type AttrOrigin EventButtonYRootFieldInfo = EventButton
    attrGet = getEventButtonYRoot
    attrSet = setEventButtonYRoot
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventButton.yRoot"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventButton.html#g:attr:yRoot"
        })

eventButton_yRoot :: AttrLabelProxy "yRoot"
eventButton_yRoot = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList EventButton
type instance O.AttributeList EventButton = EventButtonAttributeList
type EventButtonAttributeList = ('[ '("type", EventButtonTypeFieldInfo), '("window", EventButtonWindowFieldInfo), '("sendEvent", EventButtonSendEventFieldInfo), '("time", EventButtonTimeFieldInfo), '("x", EventButtonXFieldInfo), '("y", EventButtonYFieldInfo), '("axes", EventButtonAxesFieldInfo), '("state", EventButtonStateFieldInfo), '("button", EventButtonButtonFieldInfo), '("device", EventButtonDeviceFieldInfo), '("xRoot", EventButtonXRootFieldInfo), '("yRoot", EventButtonYRootFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveEventButtonMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveEventButtonMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveEventButtonMethod t EventButton, O.OverloadedMethod info EventButton p) => OL.IsLabel t (EventButton -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveEventButtonMethod t EventButton, O.OverloadedMethod info EventButton p, R.HasField t EventButton p) => R.HasField t EventButton p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveEventButtonMethod t EventButton, O.OverloadedMethodInfo info EventButton) => OL.IsLabel t (O.MethodProxy info EventButton) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


