{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- An interface for style information used by t'GI.Gtk.Objects.StyleContext.StyleContext'.
-- 
-- See 'GI.Gtk.Objects.StyleContext.styleContextAddProvider' and
-- 'GI.Gtk.Objects.StyleContext.styleContextAddProviderForDisplay' for
-- adding @GtkStyleProviders@.
-- 
-- GTK uses the @GtkStyleProvider@ implementation for CSS in
-- t'GI.Gtk.Objects.CssProvider.CssProvider'.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Interfaces.StyleProvider
    ( 

-- * Exported types
    StyleProvider(..)                       ,
    IsStyleProvider                         ,
    toStyleProvider                         ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveStyleProviderMethod              ,
#endif



 -- * Signals


-- ** gtkPrivateChanged #signal:gtkPrivateChanged#

    StyleProviderGtkPrivateChangedCallback  ,
#if defined(ENABLE_OVERLOADING)
    StyleProviderGtkPrivateChangedSignalInfo,
#endif
    afterStyleProviderGtkPrivateChanged     ,
    onStyleProviderGtkPrivateChanged        ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object

#else
import qualified GI.GObject.Objects.Object as GObject.Object

#endif

-- interface StyleProvider 
-- | Memory-managed wrapper type.
newtype StyleProvider = StyleProvider (SP.ManagedPtr StyleProvider)
    deriving (Eq)

instance SP.ManagedPtrNewtype StyleProvider where
    toManagedPtr (StyleProvider p) = p

foreign import ccall "gtk_style_provider_get_type"
    c_gtk_style_provider_get_type :: IO B.Types.GType

instance B.Types.TypedObject StyleProvider where
    glibType = c_gtk_style_provider_get_type

instance B.Types.GObject StyleProvider

-- | Type class for types which can be safely cast to t'StyleProvider', for instance with `toStyleProvider`.
class (SP.GObject o, O.IsDescendantOf StyleProvider o) => IsStyleProvider o
instance (SP.GObject o, O.IsDescendantOf StyleProvider o) => IsStyleProvider o

instance O.HasParentTypes StyleProvider
type instance O.ParentTypes StyleProvider = '[GObject.Object.Object]

-- | Cast to t'StyleProvider', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toStyleProvider :: (MIO.MonadIO m, IsStyleProvider o) => o -> m StyleProvider
toStyleProvider = MIO.liftIO . B.ManagedPtr.unsafeCastTo StyleProvider

-- | Convert t'StyleProvider' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe StyleProvider) where
    gvalueGType_ = c_gtk_style_provider_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr StyleProvider)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr StyleProvider)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject StyleProvider ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList StyleProvider
type instance O.AttributeList StyleProvider = StyleProviderAttributeList
type StyleProviderAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveStyleProviderMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveStyleProviderMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveStyleProviderMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveStyleProviderMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveStyleProviderMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveStyleProviderMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveStyleProviderMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveStyleProviderMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveStyleProviderMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveStyleProviderMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveStyleProviderMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveStyleProviderMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveStyleProviderMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveStyleProviderMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveStyleProviderMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveStyleProviderMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveStyleProviderMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveStyleProviderMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveStyleProviderMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveStyleProviderMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveStyleProviderMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveStyleProviderMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveStyleProviderMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveStyleProviderMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveStyleProviderMethod t StyleProvider, O.OverloadedMethod info StyleProvider p) => OL.IsLabel t (StyleProvider -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveStyleProviderMethod t StyleProvider, O.OverloadedMethod info StyleProvider p, R.HasField t StyleProvider p) => R.HasField t StyleProvider p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveStyleProviderMethod t StyleProvider, O.OverloadedMethodInfo info StyleProvider) => OL.IsLabel t (O.MethodProxy info StyleProvider) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal StyleProvider::gtk-private-changed
-- | /No description available in the introspection data./
type StyleProviderGtkPrivateChangedCallback =
    IO ()

type C_StyleProviderGtkPrivateChangedCallback =
    Ptr StyleProvider ->                    -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_StyleProviderGtkPrivateChangedCallback`.
foreign import ccall "wrapper"
    mk_StyleProviderGtkPrivateChangedCallback :: C_StyleProviderGtkPrivateChangedCallback -> IO (FunPtr C_StyleProviderGtkPrivateChangedCallback)

wrap_StyleProviderGtkPrivateChangedCallback :: 
    GObject a => (a -> StyleProviderGtkPrivateChangedCallback) ->
    C_StyleProviderGtkPrivateChangedCallback
wrap_StyleProviderGtkPrivateChangedCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [gtkPrivateChanged](#signal:gtkPrivateChanged) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' styleProvider #gtkPrivateChanged callback
-- @
-- 
-- 
onStyleProviderGtkPrivateChanged :: (IsStyleProvider a, MonadIO m) => a -> ((?self :: a) => StyleProviderGtkPrivateChangedCallback) -> m SignalHandlerId
onStyleProviderGtkPrivateChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_StyleProviderGtkPrivateChangedCallback wrapped
    wrapped'' <- mk_StyleProviderGtkPrivateChangedCallback wrapped'
    connectSignalFunPtr obj "gtk-private-changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [gtkPrivateChanged](#signal:gtkPrivateChanged) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' styleProvider #gtkPrivateChanged callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterStyleProviderGtkPrivateChanged :: (IsStyleProvider a, MonadIO m) => a -> ((?self :: a) => StyleProviderGtkPrivateChangedCallback) -> m SignalHandlerId
afterStyleProviderGtkPrivateChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_StyleProviderGtkPrivateChangedCallback wrapped
    wrapped'' <- mk_StyleProviderGtkPrivateChangedCallback wrapped'
    connectSignalFunPtr obj "gtk-private-changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data StyleProviderGtkPrivateChangedSignalInfo
instance SignalInfo StyleProviderGtkPrivateChangedSignalInfo where
    type HaskellCallbackType StyleProviderGtkPrivateChangedSignalInfo = StyleProviderGtkPrivateChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_StyleProviderGtkPrivateChangedCallback cb
        cb'' <- mk_StyleProviderGtkPrivateChangedCallback cb'
        connectSignalFunPtr obj "gtk-private-changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.StyleProvider::gtk-private-changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Interfaces-StyleProvider.html#g:signal:gtkPrivateChanged"})

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList StyleProvider = StyleProviderSignalList
type StyleProviderSignalList = ('[ '("gtkPrivateChanged", StyleProviderGtkPrivateChangedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif


