{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The t'GI.HarfBuzz.Structs.GlyphInfoT.GlyphInfoT' is the structure that holds information about the
-- glyphs and their relation to input text.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.HarfBuzz.Structs.GlyphInfoT
    ( 

-- * Exported types
    GlyphInfoT(..)                          ,
    newZeroGlyphInfoT                       ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveGlyphInfoTMethod                 ,
#endif



 -- * Properties


-- ** cluster #attr:cluster#
-- | the index of the character in the original text that corresponds
--           to this t'GI.HarfBuzz.Structs.GlyphInfoT.GlyphInfoT', or whatever the client passes to
--           'GI.HarfBuzz.Functions.bufferAdd'. More than one t'GI.HarfBuzz.Structs.GlyphInfoT.GlyphInfoT' can have the same
--           /@cluster@/ value, if they resulted from the same character (e.g. one
--           to many glyph substitution), and when more than one character gets
--           merged in the same glyph (e.g. many to one glyph substitution) the
--           t'GI.HarfBuzz.Structs.GlyphInfoT.GlyphInfoT' will have the smallest cluster value of them.
--           By default some characters are merged into the same cluster
--           (e.g. combining marks have the same cluster as their bases)
--           even if they are separate glyphs, 'GI.HarfBuzz.Functions.bufferSetClusterLevel'
--           allow selecting more fine-grained cluster handling.

    getGlyphInfoTCluster                    ,
#if defined(ENABLE_OVERLOADING)
    glyphInfoT_cluster                      ,
#endif
    setGlyphInfoTCluster                    ,


-- ** codepoint #attr:codepoint#
-- | either a Unicode code point (before shaping) or a glyph index
--             (after shaping).

    getGlyphInfoTCodepoint                  ,
#if defined(ENABLE_OVERLOADING)
    glyphInfoT_codepoint                    ,
#endif
    setGlyphInfoTCodepoint                  ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype GlyphInfoT = GlyphInfoT (SP.ManagedPtr GlyphInfoT)
    deriving (Eq)

instance SP.ManagedPtrNewtype GlyphInfoT where
    toManagedPtr (GlyphInfoT p) = p

foreign import ccall "hb_gobject_glyph_info_get_type" c_hb_gobject_glyph_info_get_type :: 
    IO GType

type instance O.ParentTypes GlyphInfoT = '[]
instance O.HasParentTypes GlyphInfoT

instance B.Types.TypedObject GlyphInfoT where
    glibType = c_hb_gobject_glyph_info_get_type

instance B.Types.GBoxed GlyphInfoT

-- | Convert t'GlyphInfoT' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe GlyphInfoT) where
    gvalueGType_ = c_hb_gobject_glyph_info_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr GlyphInfoT)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr GlyphInfoT)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed GlyphInfoT ptr
        else return P.Nothing
        
    

-- | Construct a t'GlyphInfoT' struct initialized to zero.
newZeroGlyphInfoT :: MonadIO m => m GlyphInfoT
newZeroGlyphInfoT = liftIO $ callocBoxedBytes 20 >>= wrapBoxed GlyphInfoT

instance tag ~ 'AttrSet => Constructible GlyphInfoT tag where
    new _ attrs = do
        o <- newZeroGlyphInfoT
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@codepoint@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' glyphInfoT #codepoint
-- @
getGlyphInfoTCodepoint :: MonadIO m => GlyphInfoT -> m Word32
getGlyphInfoTCodepoint s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Word32
    return val

-- | Set the value of the “@codepoint@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' glyphInfoT [ #codepoint 'Data.GI.Base.Attributes.:=' value ]
-- @
setGlyphInfoTCodepoint :: MonadIO m => GlyphInfoT -> Word32 -> m ()
setGlyphInfoTCodepoint s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data GlyphInfoTCodepointFieldInfo
instance AttrInfo GlyphInfoTCodepointFieldInfo where
    type AttrBaseTypeConstraint GlyphInfoTCodepointFieldInfo = (~) GlyphInfoT
    type AttrAllowedOps GlyphInfoTCodepointFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint GlyphInfoTCodepointFieldInfo = (~) Word32
    type AttrTransferTypeConstraint GlyphInfoTCodepointFieldInfo = (~)Word32
    type AttrTransferType GlyphInfoTCodepointFieldInfo = Word32
    type AttrGetType GlyphInfoTCodepointFieldInfo = Word32
    type AttrLabel GlyphInfoTCodepointFieldInfo = "codepoint"
    type AttrOrigin GlyphInfoTCodepointFieldInfo = GlyphInfoT
    attrGet = getGlyphInfoTCodepoint
    attrSet = setGlyphInfoTCodepoint
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.GlyphInfoT.codepoint"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-GlyphInfoT.html#g:attr:codepoint"
        })

glyphInfoT_codepoint :: AttrLabelProxy "codepoint"
glyphInfoT_codepoint = AttrLabelProxy

#endif


-- | Get the value of the “@cluster@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' glyphInfoT #cluster
-- @
getGlyphInfoTCluster :: MonadIO m => GlyphInfoT -> m Word32
getGlyphInfoTCluster s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO Word32
    return val

-- | Set the value of the “@cluster@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' glyphInfoT [ #cluster 'Data.GI.Base.Attributes.:=' value ]
-- @
setGlyphInfoTCluster :: MonadIO m => GlyphInfoT -> Word32 -> m ()
setGlyphInfoTCluster s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data GlyphInfoTClusterFieldInfo
instance AttrInfo GlyphInfoTClusterFieldInfo where
    type AttrBaseTypeConstraint GlyphInfoTClusterFieldInfo = (~) GlyphInfoT
    type AttrAllowedOps GlyphInfoTClusterFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint GlyphInfoTClusterFieldInfo = (~) Word32
    type AttrTransferTypeConstraint GlyphInfoTClusterFieldInfo = (~)Word32
    type AttrTransferType GlyphInfoTClusterFieldInfo = Word32
    type AttrGetType GlyphInfoTClusterFieldInfo = Word32
    type AttrLabel GlyphInfoTClusterFieldInfo = "cluster"
    type AttrOrigin GlyphInfoTClusterFieldInfo = GlyphInfoT
    attrGet = getGlyphInfoTCluster
    attrSet = setGlyphInfoTCluster
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.GlyphInfoT.cluster"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-GlyphInfoT.html#g:attr:cluster"
        })

glyphInfoT_cluster :: AttrLabelProxy "cluster"
glyphInfoT_cluster = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList GlyphInfoT
type instance O.AttributeList GlyphInfoT = GlyphInfoTAttributeList
type GlyphInfoTAttributeList = ('[ '("codepoint", GlyphInfoTCodepointFieldInfo), '("cluster", GlyphInfoTClusterFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveGlyphInfoTMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveGlyphInfoTMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveGlyphInfoTMethod t GlyphInfoT, O.OverloadedMethod info GlyphInfoT p) => OL.IsLabel t (GlyphInfoT -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveGlyphInfoTMethod t GlyphInfoT, O.OverloadedMethod info GlyphInfoT p, R.HasField t GlyphInfoT p) => R.HasField t GlyphInfoT p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveGlyphInfoTMethod t GlyphInfoT, O.OverloadedMethodInfo info GlyphInfoT) => OL.IsLabel t (O.MethodProxy info GlyphInfoT) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


