#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 152
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 76
#define ALIAS_COUNT 0
#define TOKEN_COUNT 29
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 7
#define MAX_ALIAS_SEQUENCE_LENGTH 5
#define PRODUCTION_ID_COUNT 11

enum {
  sym_identifier = 1,
  aux_sym_markdown_token1 = 2,
  sym_tag_start = 3,
  sym_tag_end = 4,
  anon_sym_SLASH = 5,
  anon_sym_EQ = 6,
  anon_sym_DOT = 7,
  anon_sym_POUND = 8,
  sym_null = 9,
  anon_sym_true = 10,
  anon_sym_false = 11,
  sym_number = 12,
  anon_sym_DQUOTE = 13,
  sym__string_character = 14,
  sym__string_escape_sequence = 15,
  anon_sym_LBRACK = 16,
  anon_sym_RBRACK = 17,
  anon_sym_COMMA = 18,
  anon_sym_LBRACE = 19,
  anon_sym_RBRACE = 20,
  anon_sym_COLON = 21,
  anon_sym_DOLLAR = 22,
  anon_sym_AT = 23,
  anon_sym_LPAREN = 24,
  anon_sym_RPAREN = 25,
  anon_sym_TAB = 26,
  anon_sym_ = 27,
  anon_sym_LF = 28,
  sym_content = 29,
  sym_markdown = 30,
  sym_tag = 31,
  sym_tag_interior = 32,
  sym_tag_open = 33,
  sym_tag_self_closing = 34,
  sym_tag_close = 35,
  sym_attribute = 36,
  sym__attribute_full = 37,
  sym__attribute_shorthand = 38,
  sym__shorthand_sigil = 39,
  sym_annotation = 40,
  sym_interpolation = 41,
  sym_value = 42,
  sym_primitive = 43,
  sym_boolean = 44,
  sym_string = 45,
  sym__string_element = 46,
  sym_compound = 47,
  sym_array = 48,
  sym__array_item = 49,
  sym__array_item_with_optional_comma = 50,
  sym_hash = 51,
  sym__hash_item = 52,
  sym__hash_key_value = 53,
  sym__hash_item_with_optional_comma = 54,
  sym_hash_key = 55,
  sym_variable = 56,
  sym_variable_tail = 57,
  sym_variable_segment_value = 58,
  sym_variable_sigil = 59,
  sym_function = 60,
  sym_function_parameters = 61,
  sym_function_parameter_tail = 62,
  sym_function_parameter = 63,
  sym_function_parameter_named = 64,
  aux_sym__space = 65,
  aux_sym_content_repeat1 = 66,
  aux_sym_tag_open_repeat1 = 67,
  aux_sym_annotation_repeat1 = 68,
  aux_sym_interpolation_repeat1 = 69,
  aux_sym_string_repeat1 = 70,
  aux_sym_array_repeat1 = 71,
  aux_sym_hash_repeat1 = 72,
  aux_sym_variable_repeat1 = 73,
  aux_sym_function_repeat1 = 74,
  aux_sym_function_parameters_repeat1 = 75,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [aux_sym_markdown_token1] = "markdown_token1",
  [sym_tag_start] = "tag_start",
  [sym_tag_end] = "tag_end",
  [anon_sym_SLASH] = "/",
  [anon_sym_EQ] = "=",
  [anon_sym_DOT] = ".",
  [anon_sym_POUND] = "#",
  [sym_null] = "null",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [sym_number] = "number",
  [anon_sym_DQUOTE] = "\"",
  [sym__string_character] = "_string_character",
  [sym__string_escape_sequence] = "_string_escape_sequence",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_COMMA] = ",",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_COLON] = ":",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_AT] = "@",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_TAB] = "\t",
  [anon_sym_] = " ",
  [anon_sym_LF] = "\n",
  [sym_content] = "content",
  [sym_markdown] = "markdown",
  [sym_tag] = "tag",
  [sym_tag_interior] = "tag_interior",
  [sym_tag_open] = "tag_open",
  [sym_tag_self_closing] = "tag_self_closing",
  [sym_tag_close] = "tag_close",
  [sym_attribute] = "attribute",
  [sym__attribute_full] = "_attribute_full",
  [sym__attribute_shorthand] = "_attribute_shorthand",
  [sym__shorthand_sigil] = "_shorthand_sigil",
  [sym_annotation] = "annotation",
  [sym_interpolation] = "interpolation",
  [sym_value] = "value",
  [sym_primitive] = "primitive",
  [sym_boolean] = "boolean",
  [sym_string] = "string",
  [sym__string_element] = "_string_element",
  [sym_compound] = "compound",
  [sym_array] = "array",
  [sym__array_item] = "_array_item",
  [sym__array_item_with_optional_comma] = "_array_item_with_optional_comma",
  [sym_hash] = "hash",
  [sym__hash_item] = "_hash_item",
  [sym__hash_key_value] = "_hash_key_value",
  [sym__hash_item_with_optional_comma] = "_hash_item_with_optional_comma",
  [sym_hash_key] = "hash_key",
  [sym_variable] = "variable",
  [sym_variable_tail] = "variable_tail",
  [sym_variable_segment_value] = "variable_segment_value",
  [sym_variable_sigil] = "variable_sigil",
  [sym_function] = "function",
  [sym_function_parameters] = "function_parameters",
  [sym_function_parameter_tail] = "function_parameter_tail",
  [sym_function_parameter] = "function_parameter",
  [sym_function_parameter_named] = "function_parameter_named",
  [aux_sym__space] = "_space",
  [aux_sym_content_repeat1] = "content_repeat1",
  [aux_sym_tag_open_repeat1] = "tag_open_repeat1",
  [aux_sym_annotation_repeat1] = "annotation_repeat1",
  [aux_sym_interpolation_repeat1] = "interpolation_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_array_repeat1] = "array_repeat1",
  [aux_sym_hash_repeat1] = "hash_repeat1",
  [aux_sym_variable_repeat1] = "variable_repeat1",
  [aux_sym_function_repeat1] = "function_repeat1",
  [aux_sym_function_parameters_repeat1] = "function_parameters_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [aux_sym_markdown_token1] = aux_sym_markdown_token1,
  [sym_tag_start] = sym_tag_start,
  [sym_tag_end] = sym_tag_end,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_POUND] = anon_sym_POUND,
  [sym_null] = sym_null,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [sym_number] = sym_number,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [sym__string_character] = sym__string_character,
  [sym__string_escape_sequence] = sym__string_escape_sequence,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_TAB] = anon_sym_TAB,
  [anon_sym_] = anon_sym_,
  [anon_sym_LF] = anon_sym_LF,
  [sym_content] = sym_content,
  [sym_markdown] = sym_markdown,
  [sym_tag] = sym_tag,
  [sym_tag_interior] = sym_tag_interior,
  [sym_tag_open] = sym_tag_open,
  [sym_tag_self_closing] = sym_tag_self_closing,
  [sym_tag_close] = sym_tag_close,
  [sym_attribute] = sym_attribute,
  [sym__attribute_full] = sym__attribute_full,
  [sym__attribute_shorthand] = sym__attribute_shorthand,
  [sym__shorthand_sigil] = sym__shorthand_sigil,
  [sym_annotation] = sym_annotation,
  [sym_interpolation] = sym_interpolation,
  [sym_value] = sym_value,
  [sym_primitive] = sym_primitive,
  [sym_boolean] = sym_boolean,
  [sym_string] = sym_string,
  [sym__string_element] = sym__string_element,
  [sym_compound] = sym_compound,
  [sym_array] = sym_array,
  [sym__array_item] = sym__array_item,
  [sym__array_item_with_optional_comma] = sym__array_item_with_optional_comma,
  [sym_hash] = sym_hash,
  [sym__hash_item] = sym__hash_item,
  [sym__hash_key_value] = sym__hash_key_value,
  [sym__hash_item_with_optional_comma] = sym__hash_item_with_optional_comma,
  [sym_hash_key] = sym_hash_key,
  [sym_variable] = sym_variable,
  [sym_variable_tail] = sym_variable_tail,
  [sym_variable_segment_value] = sym_variable_segment_value,
  [sym_variable_sigil] = sym_variable_sigil,
  [sym_function] = sym_function,
  [sym_function_parameters] = sym_function_parameters,
  [sym_function_parameter_tail] = sym_function_parameter_tail,
  [sym_function_parameter] = sym_function_parameter,
  [sym_function_parameter_named] = sym_function_parameter_named,
  [aux_sym__space] = aux_sym__space,
  [aux_sym_content_repeat1] = aux_sym_content_repeat1,
  [aux_sym_tag_open_repeat1] = aux_sym_tag_open_repeat1,
  [aux_sym_annotation_repeat1] = aux_sym_annotation_repeat1,
  [aux_sym_interpolation_repeat1] = aux_sym_interpolation_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_array_repeat1] = aux_sym_array_repeat1,
  [aux_sym_hash_repeat1] = aux_sym_hash_repeat1,
  [aux_sym_variable_repeat1] = aux_sym_variable_repeat1,
  [aux_sym_function_repeat1] = aux_sym_function_repeat1,
  [aux_sym_function_parameters_repeat1] = aux_sym_function_parameters_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_markdown_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_tag_start] = {
    .visible = true,
    .named = true,
  },
  [sym_tag_end] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym__string_character] = {
    .visible = false,
    .named = true,
  },
  [sym__string_escape_sequence] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TAB] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [sym_content] = {
    .visible = true,
    .named = true,
  },
  [sym_markdown] = {
    .visible = true,
    .named = true,
  },
  [sym_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_tag_interior] = {
    .visible = true,
    .named = true,
  },
  [sym_tag_open] = {
    .visible = true,
    .named = true,
  },
  [sym_tag_self_closing] = {
    .visible = true,
    .named = true,
  },
  [sym_tag_close] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym__attribute_full] = {
    .visible = false,
    .named = true,
  },
  [sym__attribute_shorthand] = {
    .visible = false,
    .named = true,
  },
  [sym__shorthand_sigil] = {
    .visible = false,
    .named = true,
  },
  [sym_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_interpolation] = {
    .visible = true,
    .named = true,
  },
  [sym_value] = {
    .visible = true,
    .named = true,
  },
  [sym_primitive] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym__string_element] = {
    .visible = false,
    .named = true,
  },
  [sym_compound] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym__array_item] = {
    .visible = false,
    .named = true,
  },
  [sym__array_item_with_optional_comma] = {
    .visible = false,
    .named = true,
  },
  [sym_hash] = {
    .visible = true,
    .named = true,
  },
  [sym__hash_item] = {
    .visible = false,
    .named = true,
  },
  [sym__hash_key_value] = {
    .visible = false,
    .named = true,
  },
  [sym__hash_item_with_optional_comma] = {
    .visible = false,
    .named = true,
  },
  [sym_hash_key] = {
    .visible = true,
    .named = true,
  },
  [sym_variable] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_tail] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_segment_value] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_sigil] = {
    .visible = true,
    .named = true,
  },
  [sym_function] = {
    .visible = true,
    .named = true,
  },
  [sym_function_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_function_parameter_tail] = {
    .visible = true,
    .named = true,
  },
  [sym_function_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_function_parameter_named] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__space] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_content_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tag_open_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_annotation_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_interpolation_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_hash_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_function_name = 1,
  field_key = 2,
  field_parameter = 3,
  field_property = 4,
  field_shorthand = 5,
  field_tag_name = 6,
  field_variable = 7,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_function_name] = "function_name",
  [field_key] = "key",
  [field_parameter] = "parameter",
  [field_property] = "property",
  [field_shorthand] = "shorthand",
  [field_tag_name] = "tag_name",
  [field_variable] = "variable",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [3] = {.index = 2, .length = 1},
  [4] = {.index = 3, .length = 1},
  [5] = {.index = 4, .length = 2},
  [6] = {.index = 6, .length = 1},
  [7] = {.index = 7, .length = 1},
  [8] = {.index = 8, .length = 1},
  [9] = {.index = 9, .length = 1},
  [10] = {.index = 10, .length = 1},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_tag_name, 0},
  [1] =
    {field_key, 0, .inherited = true},
  [2] =
    {field_shorthand, 0, .inherited = true},
  [3] =
    {field_tag_name, 1},
  [4] =
    {field_shorthand, 0},
    {field_shorthand, 1},
  [6] =
    {field_key, 0},
  [7] =
    {field_variable, 1},
  [8] =
    {field_function_name, 0},
  [9] =
    {field_property, 1},
  [10] =
    {field_parameter, 0},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 4,
  [6] = 3,
  [7] = 7,
  [8] = 8,
  [9] = 7,
  [10] = 10,
  [11] = 11,
  [12] = 11,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 20,
  [53] = 53,
  [54] = 22,
  [55] = 55,
  [56] = 56,
  [57] = 21,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 25,
  [64] = 60,
  [65] = 61,
  [66] = 24,
  [67] = 30,
  [68] = 68,
  [69] = 40,
  [70] = 70,
  [71] = 71,
  [72] = 41,
  [73] = 73,
  [74] = 26,
  [75] = 29,
  [76] = 76,
  [77] = 27,
  [78] = 38,
  [79] = 79,
  [80] = 37,
  [81] = 28,
  [82] = 32,
  [83] = 83,
  [84] = 70,
  [85] = 23,
  [86] = 31,
  [87] = 36,
  [88] = 88,
  [89] = 89,
  [90] = 34,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 100,
  [103] = 99,
  [104] = 104,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 110,
  [111] = 111,
  [112] = 112,
  [113] = 113,
  [114] = 114,
  [115] = 115,
  [116] = 116,
  [117] = 117,
  [118] = 118,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 122,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 127,
  [128] = 128,
  [129] = 129,
  [130] = 130,
  [131] = 131,
  [132] = 132,
  [133] = 133,
  [134] = 134,
  [135] = 135,
  [136] = 121,
  [137] = 137,
  [138] = 138,
  [139] = 139,
  [140] = 140,
  [141] = 141,
  [142] = 142,
  [143] = 138,
  [144] = 144,
  [145] = 145,
  [146] = 131,
  [147] = 130,
  [148] = 127,
  [149] = 122,
  [150] = 120,
  [151] = 141,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(11);
      if (lookahead == '"') ADVANCE(21);
      if (lookahead == '#') ADVANCE(18);
      if (lookahead == '$') ADVANCE(31);
      if (lookahead == '%') ADVANCE(5);
      if (lookahead == '(') ADVANCE(33);
      if (lookahead == ')') ADVANCE(34);
      if (lookahead == ',') ADVANCE(26);
      if (lookahead == '-') ADVANCE(7);
      if (lookahead == '.') ADVANCE(17);
      if (lookahead == '/') ADVANCE(15);
      if (lookahead == ':') ADVANCE(30);
      if (lookahead == '=') ADVANCE(16);
      if (lookahead == '@') ADVANCE(32);
      if (lookahead == '[') ADVANCE(24);
      if (lookahead == '\\') ADVANCE(6);
      if (lookahead == ']') ADVANCE(25);
      if (lookahead == '{') ADVANCE(28);
      if (lookahead == '}') ADVANCE(29);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(9)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(19);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(35);
      END_STATE();
    case 1:
      if (lookahead == '\t') ADVANCE(36);
      if (lookahead == '\n') ADVANCE(38);
      if (lookahead == '\r') SKIP(1)
      if (lookahead == ' ') ADVANCE(37);
      if (lookahead == '"') ADVANCE(21);
      if (lookahead == '#') ADVANCE(18);
      if (lookahead == '$') ADVANCE(31);
      if (lookahead == '%') ADVANCE(5);
      if (lookahead == '(') ADVANCE(33);
      if (lookahead == '-') ADVANCE(7);
      if (lookahead == '.') ADVANCE(17);
      if (lookahead == '/') ADVANCE(15);
      if (lookahead == '=') ADVANCE(16);
      if (lookahead == '@') ADVANCE(32);
      if (lookahead == '[') ADVANCE(24);
      if (lookahead == '{') ADVANCE(27);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(19);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(35);
      END_STATE();
    case 2:
      if (lookahead == '"') ADVANCE(21);
      if (lookahead == '$') ADVANCE(31);
      if (lookahead == ')') ADVANCE(34);
      if (lookahead == ',') ADVANCE(26);
      if (lookahead == '-') ADVANCE(7);
      if (lookahead == '.') ADVANCE(17);
      if (lookahead == ':') ADVANCE(30);
      if (lookahead == '@') ADVANCE(32);
      if (lookahead == '[') ADVANCE(24);
      if (lookahead == ']') ADVANCE(25);
      if (lookahead == '{') ADVANCE(27);
      if (lookahead == '}') ADVANCE(29);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(2)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(19);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(35);
      END_STATE();
    case 3:
      if (lookahead == '"') ADVANCE(21);
      if (lookahead == '\\') ADVANCE(6);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(22);
      if (lookahead != 0) ADVANCE(22);
      END_STATE();
    case 4:
      if (lookahead == '%') ADVANCE(13);
      END_STATE();
    case 5:
      if (lookahead == '}') ADVANCE(14);
      END_STATE();
    case 6:
      if (lookahead == '"' ||
          lookahead == '\\' ||
          lookahead == 'n' ||
          lookahead == 'r' ||
          lookahead == 't') ADVANCE(23);
      END_STATE();
    case 7:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(19);
      END_STATE();
    case 8:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(20);
      END_STATE();
    case 9:
      if (eof) ADVANCE(11);
      if (lookahead == '"') ADVANCE(21);
      if (lookahead == '#') ADVANCE(18);
      if (lookahead == '$') ADVANCE(31);
      if (lookahead == '%') ADVANCE(5);
      if (lookahead == '(') ADVANCE(33);
      if (lookahead == ')') ADVANCE(34);
      if (lookahead == ',') ADVANCE(26);
      if (lookahead == '-') ADVANCE(7);
      if (lookahead == '.') ADVANCE(17);
      if (lookahead == '/') ADVANCE(15);
      if (lookahead == ':') ADVANCE(30);
      if (lookahead == '=') ADVANCE(16);
      if (lookahead == '@') ADVANCE(32);
      if (lookahead == '[') ADVANCE(24);
      if (lookahead == ']') ADVANCE(25);
      if (lookahead == '{') ADVANCE(28);
      if (lookahead == '}') ADVANCE(29);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(9)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(19);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(35);
      END_STATE();
    case 10:
      if (eof) ADVANCE(11);
      if (lookahead == '{') ADVANCE(4);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(10)
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 11:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 12:
      ACCEPT_TOKEN(aux_sym_markdown_token1);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(12);
      if (lookahead != 0 &&
          lookahead != '{') ADVANCE(12);
      END_STATE();
    case 13:
      ACCEPT_TOKEN(sym_tag_start);
      END_STATE();
    case 14:
      ACCEPT_TOKEN(sym_tag_end);
      END_STATE();
    case 15:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 16:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 17:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 18:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(8);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(19);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(sym_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(20);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(sym__string_character);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(sym__string_escape_sequence);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      if (lookahead == '%') ADVANCE(13);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(35);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_TAB);
      if (lookahead == '\t') ADVANCE(36);
      if (lookahead == '\n') ADVANCE(38);
      if (lookahead == ' ') ADVANCE(37);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_);
      if (lookahead == '\t') ADVANCE(36);
      if (lookahead == '\n') ADVANCE(38);
      if (lookahead == ' ') ADVANCE(37);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\t') ADVANCE(36);
      if (lookahead == '\n') ADVANCE(38);
      if (lookahead == ' ') ADVANCE(37);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'f') ADVANCE(1);
      if (lookahead == 'n') ADVANCE(2);
      if (lookahead == 't') ADVANCE(3);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'a') ADVANCE(4);
      END_STATE();
    case 2:
      if (lookahead == 'u') ADVANCE(5);
      END_STATE();
    case 3:
      if (lookahead == 'r') ADVANCE(6);
      END_STATE();
    case 4:
      if (lookahead == 'l') ADVANCE(7);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(8);
      END_STATE();
    case 6:
      if (lookahead == 'u') ADVANCE(9);
      END_STATE();
    case 7:
      if (lookahead == 's') ADVANCE(10);
      END_STATE();
    case 8:
      if (lookahead == 'l') ADVANCE(11);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(12);
      END_STATE();
    case 10:
      if (lookahead == 'e') ADVANCE(13);
      END_STATE();
    case 11:
      ACCEPT_TOKEN(sym_null);
      END_STATE();
    case 12:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 13:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 10},
  [2] = {.lex_state = 1},
  [3] = {.lex_state = 2},
  [4] = {.lex_state = 2},
  [5] = {.lex_state = 2},
  [6] = {.lex_state = 2},
  [7] = {.lex_state = 2},
  [8] = {.lex_state = 2},
  [9] = {.lex_state = 2},
  [10] = {.lex_state = 2},
  [11] = {.lex_state = 2},
  [12] = {.lex_state = 2},
  [13] = {.lex_state = 2},
  [14] = {.lex_state = 1},
  [15] = {.lex_state = 2},
  [16] = {.lex_state = 2},
  [17] = {.lex_state = 2},
  [18] = {.lex_state = 1},
  [19] = {.lex_state = 1},
  [20] = {.lex_state = 2},
  [21] = {.lex_state = 2},
  [22] = {.lex_state = 2},
  [23] = {.lex_state = 2},
  [24] = {.lex_state = 2},
  [25] = {.lex_state = 2},
  [26] = {.lex_state = 2},
  [27] = {.lex_state = 2},
  [28] = {.lex_state = 2},
  [29] = {.lex_state = 2},
  [30] = {.lex_state = 2},
  [31] = {.lex_state = 2},
  [32] = {.lex_state = 2},
  [33] = {.lex_state = 2},
  [34] = {.lex_state = 2},
  [35] = {.lex_state = 2},
  [36] = {.lex_state = 2},
  [37] = {.lex_state = 2},
  [38] = {.lex_state = 2},
  [39] = {.lex_state = 2},
  [40] = {.lex_state = 2},
  [41] = {.lex_state = 2},
  [42] = {.lex_state = 1},
  [43] = {.lex_state = 1},
  [44] = {.lex_state = 1},
  [45] = {.lex_state = 1},
  [46] = {.lex_state = 1},
  [47] = {.lex_state = 2},
  [48] = {.lex_state = 2},
  [49] = {.lex_state = 1},
  [50] = {.lex_state = 2},
  [51] = {.lex_state = 1},
  [52] = {.lex_state = 1},
  [53] = {.lex_state = 2},
  [54] = {.lex_state = 1},
  [55] = {.lex_state = 1},
  [56] = {.lex_state = 1},
  [57] = {.lex_state = 1},
  [58] = {.lex_state = 2},
  [59] = {.lex_state = 1},
  [60] = {.lex_state = 0},
  [61] = {.lex_state = 0},
  [62] = {.lex_state = 1},
  [63] = {.lex_state = 1},
  [64] = {.lex_state = 0},
  [65] = {.lex_state = 0},
  [66] = {.lex_state = 1},
  [67] = {.lex_state = 1},
  [68] = {.lex_state = 1},
  [69] = {.lex_state = 1},
  [70] = {.lex_state = 0},
  [71] = {.lex_state = 1},
  [72] = {.lex_state = 1},
  [73] = {.lex_state = 10},
  [74] = {.lex_state = 1},
  [75] = {.lex_state = 1},
  [76] = {.lex_state = 1},
  [77] = {.lex_state = 1},
  [78] = {.lex_state = 1},
  [79] = {.lex_state = 1},
  [80] = {.lex_state = 1},
  [81] = {.lex_state = 1},
  [82] = {.lex_state = 1},
  [83] = {.lex_state = 1},
  [84] = {.lex_state = 0},
  [85] = {.lex_state = 1},
  [86] = {.lex_state = 1},
  [87] = {.lex_state = 1},
  [88] = {.lex_state = 0},
  [89] = {.lex_state = 10},
  [90] = {.lex_state = 1},
  [91] = {.lex_state = 1},
  [92] = {.lex_state = 1},
  [93] = {.lex_state = 1},
  [94] = {.lex_state = 1},
  [95] = {.lex_state = 1},
  [96] = {.lex_state = 1},
  [97] = {.lex_state = 1},
  [98] = {.lex_state = 3},
  [99] = {.lex_state = 3},
  [100] = {.lex_state = 3},
  [101] = {.lex_state = 1},
  [102] = {.lex_state = 3},
  [103] = {.lex_state = 3},
  [104] = {.lex_state = 1},
  [105] = {.lex_state = 0},
  [106] = {.lex_state = 10},
  [107] = {.lex_state = 10},
  [108] = {.lex_state = 10},
  [109] = {.lex_state = 10},
  [110] = {.lex_state = 0},
  [111] = {.lex_state = 10},
  [112] = {.lex_state = 10},
  [113] = {.lex_state = 10},
  [114] = {.lex_state = 0},
  [115] = {.lex_state = 0},
  [116] = {.lex_state = 0},
  [117] = {.lex_state = 0},
  [118] = {.lex_state = 0},
  [119] = {.lex_state = 0},
  [120] = {.lex_state = 0},
  [121] = {.lex_state = 0},
  [122] = {.lex_state = 0},
  [123] = {.lex_state = 0},
  [124] = {.lex_state = 0},
  [125] = {.lex_state = 0},
  [126] = {.lex_state = 0},
  [127] = {.lex_state = 0},
  [128] = {.lex_state = 0},
  [129] = {.lex_state = 0},
  [130] = {.lex_state = 0},
  [131] = {.lex_state = 0},
  [132] = {.lex_state = 0},
  [133] = {.lex_state = 0},
  [134] = {.lex_state = 0},
  [135] = {.lex_state = 0},
  [136] = {.lex_state = 0},
  [137] = {.lex_state = 0},
  [138] = {.lex_state = 0},
  [139] = {.lex_state = 0},
  [140] = {.lex_state = 0},
  [141] = {.lex_state = 0},
  [142] = {.lex_state = 0},
  [143] = {.lex_state = 0},
  [144] = {.lex_state = 0},
  [145] = {.lex_state = 0},
  [146] = {.lex_state = 0},
  [147] = {.lex_state = 0},
  [148] = {.lex_state = 0},
  [149] = {.lex_state = 0},
  [150] = {.lex_state = 0},
  [151] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_tag_start] = ACTIONS(1),
    [sym_tag_end] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [sym__string_escape_sequence] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
  },
  [1] = {
    [sym_content] = STATE(145),
    [sym_markdown] = STATE(73),
    [sym_tag] = STATE(73),
    [sym_annotation] = STATE(73),
    [sym_interpolation] = STATE(73),
    [aux_sym_content_repeat1] = STATE(73),
    [ts_builtin_sym_end] = ACTIONS(3),
    [aux_sym_markdown_token1] = ACTIONS(5),
    [sym_tag_start] = ACTIONS(7),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 20,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      anon_sym_LBRACE,
    STATE(18), 1,
      aux_sym__space,
    STATE(79), 1,
      sym__attribute_full,
    STATE(83), 1,
      sym__attribute_shorthand,
    STATE(95), 1,
      sym_value,
    STATE(101), 1,
      sym_attribute,
    STATE(129), 1,
      sym__shorthand_sigil,
    STATE(136), 1,
      sym_variable_sigil,
    ACTIONS(11), 2,
      sym_tag_end,
      anon_sym_SLASH,
    ACTIONS(13), 2,
      anon_sym_DOT,
      anon_sym_POUND,
    ACTIONS(15), 2,
      sym_null,
      sym_number,
    ACTIONS(17), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(25), 2,
      anon_sym_DOLLAR,
      anon_sym_AT,
    STATE(75), 2,
      sym_boolean,
      sym_string,
    STATE(81), 2,
      sym_array,
      sym_hash,
    ACTIONS(27), 3,
      anon_sym_TAB,
      anon_sym_,
      anon_sym_LF,
    STATE(82), 4,
      sym_primitive,
      sym_compound,
      sym_variable,
      sym_function,
  [73] = 16,
    ACTIONS(29), 1,
      sym_identifier,
    ACTIONS(31), 1,
      sym_null,
    ACTIONS(35), 1,
      sym_number,
    ACTIONS(37), 1,
      anon_sym_DQUOTE,
    ACTIONS(39), 1,
      anon_sym_LBRACK,
    ACTIONS(41), 1,
      anon_sym_RBRACK,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    STATE(118), 1,
      sym_value,
    STATE(121), 1,
      sym_variable_sigil,
    STATE(141), 1,
      sym__array_item_with_optional_comma,
    ACTIONS(33), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 2,
      anon_sym_DOLLAR,
      anon_sym_AT,
    STATE(4), 2,
      sym__array_item,
      aux_sym_array_repeat1,
    STATE(28), 2,
      sym_array,
      sym_hash,
    STATE(29), 2,
      sym_boolean,
      sym_string,
    STATE(32), 4,
      sym_primitive,
      sym_compound,
      sym_variable,
      sym_function,
  [130] = 16,
    ACTIONS(29), 1,
      sym_identifier,
    ACTIONS(31), 1,
      sym_null,
    ACTIONS(35), 1,
      sym_number,
    ACTIONS(37), 1,
      anon_sym_DQUOTE,
    ACTIONS(39), 1,
      anon_sym_LBRACK,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(47), 1,
      anon_sym_RBRACK,
    STATE(118), 1,
      sym_value,
    STATE(121), 1,
      sym_variable_sigil,
    STATE(147), 1,
      sym__array_item_with_optional_comma,
    ACTIONS(33), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 2,
      anon_sym_DOLLAR,
      anon_sym_AT,
    STATE(10), 2,
      sym__array_item,
      aux_sym_array_repeat1,
    STATE(28), 2,
      sym_array,
      sym_hash,
    STATE(29), 2,
      sym_boolean,
      sym_string,
    STATE(32), 4,
      sym_primitive,
      sym_compound,
      sym_variable,
      sym_function,
  [187] = 16,
    ACTIONS(29), 1,
      sym_identifier,
    ACTIONS(31), 1,
      sym_null,
    ACTIONS(35), 1,
      sym_number,
    ACTIONS(37), 1,
      anon_sym_DQUOTE,
    ACTIONS(39), 1,
      anon_sym_LBRACK,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(49), 1,
      anon_sym_RBRACK,
    STATE(118), 1,
      sym_value,
    STATE(121), 1,
      sym_variable_sigil,
    STATE(130), 1,
      sym__array_item_with_optional_comma,
    ACTIONS(33), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 2,
      anon_sym_DOLLAR,
      anon_sym_AT,
    STATE(10), 2,
      sym__array_item,
      aux_sym_array_repeat1,
    STATE(28), 2,
      sym_array,
      sym_hash,
    STATE(29), 2,
      sym_boolean,
      sym_string,
    STATE(32), 4,
      sym_primitive,
      sym_compound,
      sym_variable,
      sym_function,
  [244] = 16,
    ACTIONS(29), 1,
      sym_identifier,
    ACTIONS(31), 1,
      sym_null,
    ACTIONS(35), 1,
      sym_number,
    ACTIONS(37), 1,
      anon_sym_DQUOTE,
    ACTIONS(39), 1,
      anon_sym_LBRACK,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_RBRACK,
    STATE(118), 1,
      sym_value,
    STATE(121), 1,
      sym_variable_sigil,
    STATE(151), 1,
      sym__array_item_with_optional_comma,
    ACTIONS(33), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 2,
      anon_sym_DOLLAR,
      anon_sym_AT,
    STATE(5), 2,
      sym__array_item,
      aux_sym_array_repeat1,
    STATE(28), 2,
      sym_array,
      sym_hash,
    STATE(29), 2,
      sym_boolean,
      sym_string,
    STATE(32), 4,
      sym_primitive,
      sym_compound,
      sym_variable,
      sym_function,
  [301] = 15,
    ACTIONS(29), 1,
      sym_identifier,
    ACTIONS(31), 1,
      sym_null,
    ACTIONS(35), 1,
      sym_number,
    ACTIONS(37), 1,
      anon_sym_DQUOTE,
    ACTIONS(39), 1,
      anon_sym_LBRACK,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(53), 1,
      anon_sym_RPAREN,
    STATE(35), 1,
      sym_value,
    STATE(121), 1,
      sym_variable_sigil,
    ACTIONS(33), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 2,
      anon_sym_DOLLAR,
      anon_sym_AT,
    STATE(11), 2,
      sym_function_parameters,
      aux_sym_function_repeat1,
    STATE(28), 2,
      sym_array,
      sym_hash,
    STATE(29), 2,
      sym_boolean,
      sym_string,
    STATE(32), 4,
      sym_primitive,
      sym_compound,
      sym_variable,
      sym_function,
  [355] = 15,
    ACTIONS(55), 1,
      sym_identifier,
    ACTIONS(58), 1,
      sym_null,
    ACTIONS(64), 1,
      sym_number,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(70), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(79), 1,
      anon_sym_RPAREN,
    STATE(35), 1,
      sym_value,
    STATE(121), 1,
      sym_variable_sigil,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(76), 2,
      anon_sym_DOLLAR,
      anon_sym_AT,
    STATE(8), 2,
      sym_function_parameters,
      aux_sym_function_repeat1,
    STATE(28), 2,
      sym_array,
      sym_hash,
    STATE(29), 2,
      sym_boolean,
      sym_string,
    STATE(32), 4,
      sym_primitive,
      sym_compound,
      sym_variable,
      sym_function,
  [409] = 15,
    ACTIONS(29), 1,
      sym_identifier,
    ACTIONS(31), 1,
      sym_null,
    ACTIONS(35), 1,
      sym_number,
    ACTIONS(37), 1,
      anon_sym_DQUOTE,
    ACTIONS(39), 1,
      anon_sym_LBRACK,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(81), 1,
      anon_sym_RPAREN,
    STATE(35), 1,
      sym_value,
    STATE(121), 1,
      sym_variable_sigil,
    ACTIONS(33), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 2,
      anon_sym_DOLLAR,
      anon_sym_AT,
    STATE(12), 2,
      sym_function_parameters,
      aux_sym_function_repeat1,
    STATE(28), 2,
      sym_array,
      sym_hash,
    STATE(29), 2,
      sym_boolean,
      sym_string,
    STATE(32), 4,
      sym_primitive,
      sym_compound,
      sym_variable,
      sym_function,
  [463] = 15,
    ACTIONS(83), 1,
      sym_identifier,
    ACTIONS(86), 1,
      sym_null,
    ACTIONS(92), 1,
      sym_number,
    ACTIONS(95), 1,
      anon_sym_DQUOTE,
    ACTIONS(98), 1,
      anon_sym_LBRACK,
    ACTIONS(101), 1,
      anon_sym_RBRACK,
    ACTIONS(103), 1,
      anon_sym_LBRACE,
    STATE(121), 1,
      sym_variable_sigil,
    STATE(128), 1,
      sym_value,
    ACTIONS(89), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(106), 2,
      anon_sym_DOLLAR,
      anon_sym_AT,
    STATE(10), 2,
      sym__array_item,
      aux_sym_array_repeat1,
    STATE(28), 2,
      sym_array,
      sym_hash,
    STATE(29), 2,
      sym_boolean,
      sym_string,
    STATE(32), 4,
      sym_primitive,
      sym_compound,
      sym_variable,
      sym_function,
  [517] = 15,
    ACTIONS(29), 1,
      sym_identifier,
    ACTIONS(31), 1,
      sym_null,
    ACTIONS(35), 1,
      sym_number,
    ACTIONS(37), 1,
      anon_sym_DQUOTE,
    ACTIONS(39), 1,
      anon_sym_LBRACK,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(109), 1,
      anon_sym_RPAREN,
    STATE(35), 1,
      sym_value,
    STATE(121), 1,
      sym_variable_sigil,
    ACTIONS(33), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 2,
      anon_sym_DOLLAR,
      anon_sym_AT,
    STATE(8), 2,
      sym_function_parameters,
      aux_sym_function_repeat1,
    STATE(28), 2,
      sym_array,
      sym_hash,
    STATE(29), 2,
      sym_boolean,
      sym_string,
    STATE(32), 4,
      sym_primitive,
      sym_compound,
      sym_variable,
      sym_function,
  [571] = 15,
    ACTIONS(29), 1,
      sym_identifier,
    ACTIONS(31), 1,
      sym_null,
    ACTIONS(35), 1,
      sym_number,
    ACTIONS(37), 1,
      anon_sym_DQUOTE,
    ACTIONS(39), 1,
      anon_sym_LBRACK,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(111), 1,
      anon_sym_RPAREN,
    STATE(35), 1,
      sym_value,
    STATE(121), 1,
      sym_variable_sigil,
    ACTIONS(33), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 2,
      anon_sym_DOLLAR,
      anon_sym_AT,
    STATE(8), 2,
      sym_function_parameters,
      aux_sym_function_repeat1,
    STATE(28), 2,
      sym_array,
      sym_hash,
    STATE(29), 2,
      sym_boolean,
      sym_string,
    STATE(32), 4,
      sym_primitive,
      sym_compound,
      sym_variable,
      sym_function,
  [625] = 14,
    ACTIONS(31), 1,
      sym_null,
    ACTIONS(35), 1,
      sym_number,
    ACTIONS(37), 1,
      anon_sym_DQUOTE,
    ACTIONS(39), 1,
      anon_sym_LBRACK,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(113), 1,
      sym_identifier,
    STATE(48), 1,
      sym_function_parameter,
    STATE(121), 1,
      sym_variable_sigil,
    ACTIONS(33), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 2,
      anon_sym_DOLLAR,
      anon_sym_AT,
    STATE(28), 2,
      sym_array,
      sym_hash,
    STATE(29), 2,
      sym_boolean,
      sym_string,
    STATE(47), 2,
      sym_value,
      sym_function_parameter_named,
    STATE(32), 4,
      sym_primitive,
      sym_compound,
      sym_variable,
      sym_function,
  [676] = 15,
    ACTIONS(115), 1,
      sym_identifier,
    ACTIONS(117), 1,
      anon_sym_SLASH,
    STATE(18), 1,
      aux_sym__space,
    STATE(79), 1,
      sym__attribute_full,
    STATE(83), 1,
      sym__attribute_shorthand,
    STATE(91), 1,
      sym_attribute,
    STATE(117), 1,
      sym_tag_open,
    STATE(129), 1,
      sym__shorthand_sigil,
    STATE(133), 1,
      sym_tag_interior,
    STATE(136), 1,
      sym_variable_sigil,
    ACTIONS(13), 2,
      anon_sym_DOT,
      anon_sym_POUND,
    ACTIONS(25), 2,
      anon_sym_DOLLAR,
      anon_sym_AT,
    STATE(104), 2,
      sym_variable,
      sym_function,
    STATE(132), 2,
      sym_tag_self_closing,
      sym_tag_close,
    ACTIONS(27), 3,
      anon_sym_TAB,
      anon_sym_,
      anon_sym_LF,
  [728] = 13,
    ACTIONS(29), 1,
      sym_identifier,
    ACTIONS(31), 1,
      sym_null,
    ACTIONS(35), 1,
      sym_number,
    ACTIONS(37), 1,
      anon_sym_DQUOTE,
    ACTIONS(39), 1,
      anon_sym_LBRACK,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    STATE(114), 1,
      sym_value,
    STATE(121), 1,
      sym_variable_sigil,
    ACTIONS(33), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 2,
      anon_sym_DOLLAR,
      anon_sym_AT,
    STATE(28), 2,
      sym_array,
      sym_hash,
    STATE(29), 2,
      sym_boolean,
      sym_string,
    STATE(32), 4,
      sym_primitive,
      sym_compound,
      sym_variable,
      sym_function,
  [775] = 13,
    ACTIONS(15), 1,
      sym_null,
    ACTIONS(119), 1,
      sym_identifier,
    ACTIONS(121), 1,
      sym_number,
    ACTIONS(123), 1,
      anon_sym_DQUOTE,
    ACTIONS(125), 1,
      anon_sym_LBRACK,
    ACTIONS(127), 1,
      anon_sym_LBRACE,
    STATE(68), 1,
      sym_value,
    STATE(136), 1,
      sym_variable_sigil,
    ACTIONS(17), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 2,
      anon_sym_DOLLAR,
      anon_sym_AT,
    STATE(75), 2,
      sym_boolean,
      sym_string,
    STATE(81), 2,
      sym_array,
      sym_hash,
    STATE(82), 4,
      sym_primitive,
      sym_compound,
      sym_variable,
      sym_function,
  [822] = 13,
    ACTIONS(29), 1,
      sym_identifier,
    ACTIONS(31), 1,
      sym_null,
    ACTIONS(35), 1,
      sym_number,
    ACTIONS(37), 1,
      anon_sym_DQUOTE,
    ACTIONS(39), 1,
      anon_sym_LBRACK,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    STATE(50), 1,
      sym_value,
    STATE(121), 1,
      sym_variable_sigil,
    ACTIONS(33), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 2,
      anon_sym_DOLLAR,
      anon_sym_AT,
    STATE(28), 2,
      sym_array,
      sym_hash,
    STATE(29), 2,
      sym_boolean,
      sym_string,
    STATE(32), 4,
      sym_primitive,
      sym_compound,
      sym_variable,
      sym_function,
  [869] = 3,
    STATE(18), 1,
      aux_sym__space,
    ACTIONS(131), 3,
      anon_sym_TAB,
      anon_sym_,
      anon_sym_LF,
    ACTIONS(129), 14,
      sym_tag_end,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_POUND,
      sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
  [894] = 13,
    ACTIONS(117), 1,
      anon_sym_SLASH,
    ACTIONS(134), 1,
      sym_identifier,
    STATE(14), 1,
      aux_sym__space,
    STATE(79), 1,
      sym__attribute_full,
    STATE(83), 1,
      sym__attribute_shorthand,
    STATE(96), 1,
      aux_sym_interpolation_repeat1,
    STATE(117), 1,
      sym_tag_open,
    STATE(129), 1,
      sym__shorthand_sigil,
    STATE(134), 1,
      sym_tag_interior,
    ACTIONS(13), 2,
      anon_sym_DOT,
      anon_sym_POUND,
    STATE(43), 2,
      sym_attribute,
      aux_sym_annotation_repeat1,
    STATE(132), 2,
      sym_tag_self_closing,
      sym_tag_close,
    ACTIONS(136), 3,
      anon_sym_TAB,
      anon_sym_,
      anon_sym_LF,
  [939] = 5,
    ACTIONS(140), 1,
      anon_sym_DOT,
    ACTIONS(144), 1,
      anon_sym_LBRACK,
    STATE(21), 2,
      sym_variable_tail,
      aux_sym_variable_repeat1,
    ACTIONS(138), 4,
      sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(142), 9,
      sym_number,
      anon_sym_DQUOTE,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOLLAR,
      anon_sym_AT,
      anon_sym_RPAREN,
  [967] = 5,
    ACTIONS(148), 1,
      anon_sym_DOT,
    ACTIONS(153), 1,
      anon_sym_LBRACK,
    STATE(21), 2,
      sym_variable_tail,
      aux_sym_variable_repeat1,
    ACTIONS(146), 4,
      sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(151), 9,
      sym_number,
      anon_sym_DQUOTE,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOLLAR,
      anon_sym_AT,
      anon_sym_RPAREN,
  [995] = 5,
    ACTIONS(140), 1,
      anon_sym_DOT,
    ACTIONS(144), 1,
      anon_sym_LBRACK,
    STATE(20), 2,
      sym_variable_tail,
      aux_sym_variable_repeat1,
    ACTIONS(156), 4,
      sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(158), 9,
      sym_number,
      anon_sym_DQUOTE,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOLLAR,
      anon_sym_AT,
      anon_sym_RPAREN,
  [1023] = 2,
    ACTIONS(160), 4,
      sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(162), 11,
      sym_number,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_DOLLAR,
      anon_sym_AT,
      anon_sym_RPAREN,
  [1043] = 2,
    ACTIONS(164), 4,
      sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(166), 11,
      anon_sym_DOT,
      sym_number,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOLLAR,
      anon_sym_AT,
      anon_sym_RPAREN,
  [1063] = 2,
    ACTIONS(168), 4,
      sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(170), 11,
      anon_sym_DOT,
      sym_number,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOLLAR,
      anon_sym_AT,
      anon_sym_RPAREN,
  [1083] = 2,
    ACTIONS(172), 4,
      sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(174), 11,
      sym_number,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_DOLLAR,
      anon_sym_AT,
      anon_sym_RPAREN,
  [1103] = 2,
    ACTIONS(176), 4,
      sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(178), 10,
      sym_number,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOLLAR,
      anon_sym_AT,
      anon_sym_RPAREN,
  [1122] = 2,
    ACTIONS(180), 4,
      sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(182), 10,
      sym_number,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOLLAR,
      anon_sym_AT,
      anon_sym_RPAREN,
  [1141] = 2,
    ACTIONS(184), 4,
      sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(186), 10,
      sym_number,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOLLAR,
      anon_sym_AT,
      anon_sym_RPAREN,
  [1160] = 2,
    ACTIONS(188), 4,
      sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(190), 10,
      sym_number,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOLLAR,
      anon_sym_AT,
      anon_sym_RPAREN,
  [1179] = 2,
    ACTIONS(192), 4,
      sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(194), 10,
      sym_number,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOLLAR,
      anon_sym_AT,
      anon_sym_RPAREN,
  [1198] = 2,
    ACTIONS(196), 4,
      sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(198), 10,
      sym_number,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOLLAR,
      anon_sym_AT,
      anon_sym_RPAREN,
  [1217] = 4,
    ACTIONS(204), 1,
      anon_sym_COMMA,
    STATE(33), 2,
      sym_function_parameter_tail,
      aux_sym_function_parameters_repeat1,
    ACTIONS(200), 4,
      sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(202), 7,
      sym_number,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_DOLLAR,
      anon_sym_AT,
      anon_sym_RPAREN,
  [1240] = 2,
    ACTIONS(207), 4,
      sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(209), 10,
      sym_number,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOLLAR,
      anon_sym_AT,
      anon_sym_RPAREN,
  [1259] = 4,
    ACTIONS(215), 1,
      anon_sym_COMMA,
    STATE(39), 2,
      sym_function_parameter_tail,
      aux_sym_function_parameters_repeat1,
    ACTIONS(211), 4,
      sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(213), 7,
      sym_number,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_DOLLAR,
      anon_sym_AT,
      anon_sym_RPAREN,
  [1282] = 2,
    ACTIONS(217), 4,
      sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(219), 10,
      sym_number,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOLLAR,
      anon_sym_AT,
      anon_sym_RPAREN,
  [1301] = 2,
    ACTIONS(221), 4,
      sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(223), 10,
      sym_number,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOLLAR,
      anon_sym_AT,
      anon_sym_RPAREN,
  [1320] = 2,
    ACTIONS(225), 4,
      sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(227), 10,
      sym_number,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOLLAR,
      anon_sym_AT,
      anon_sym_RPAREN,
  [1339] = 4,
    ACTIONS(215), 1,
      anon_sym_COMMA,
    STATE(33), 2,
      sym_function_parameter_tail,
      aux_sym_function_parameters_repeat1,
    ACTIONS(229), 4,
      sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(231), 7,
      sym_number,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_DOLLAR,
      anon_sym_AT,
      anon_sym_RPAREN,
  [1362] = 2,
    ACTIONS(233), 4,
      sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(235), 10,
      sym_number,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOLLAR,
      anon_sym_AT,
      anon_sym_RPAREN,
  [1381] = 2,
    ACTIONS(237), 4,
      sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(239), 10,
      sym_number,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOLLAR,
      anon_sym_AT,
      anon_sym_RPAREN,
  [1400] = 9,
    ACTIONS(241), 1,
      sym_identifier,
    STATE(18), 1,
      aux_sym__space,
    STATE(79), 1,
      sym__attribute_full,
    STATE(83), 1,
      sym__attribute_shorthand,
    STATE(101), 1,
      sym_attribute,
    STATE(129), 1,
      sym__shorthand_sigil,
    ACTIONS(13), 2,
      anon_sym_DOT,
      anon_sym_POUND,
    ACTIONS(243), 2,
      sym_tag_end,
      anon_sym_SLASH,
    ACTIONS(27), 3,
      anon_sym_TAB,
      anon_sym_,
      anon_sym_LF,
  [1432] = 9,
    ACTIONS(241), 1,
      sym_identifier,
    ACTIONS(245), 1,
      sym_tag_end,
    STATE(49), 1,
      aux_sym__space,
    STATE(79), 1,
      sym__attribute_full,
    STATE(83), 1,
      sym__attribute_shorthand,
    STATE(129), 1,
      sym__shorthand_sigil,
    ACTIONS(13), 2,
      anon_sym_DOT,
      anon_sym_POUND,
    STATE(44), 2,
      sym_attribute,
      aux_sym_annotation_repeat1,
    ACTIONS(247), 3,
      anon_sym_TAB,
      anon_sym_,
      anon_sym_LF,
  [1464] = 9,
    ACTIONS(249), 1,
      sym_identifier,
    ACTIONS(252), 1,
      sym_tag_end,
    STATE(55), 1,
      aux_sym__space,
    STATE(79), 1,
      sym__attribute_full,
    STATE(83), 1,
      sym__attribute_shorthand,
    STATE(129), 1,
      sym__shorthand_sigil,
    ACTIONS(254), 2,
      anon_sym_DOT,
      anon_sym_POUND,
    STATE(44), 2,
      sym_attribute,
      aux_sym_annotation_repeat1,
    ACTIONS(257), 3,
      anon_sym_TAB,
      anon_sym_,
      anon_sym_LF,
  [1496] = 9,
    ACTIONS(241), 1,
      sym_identifier,
    STATE(18), 1,
      aux_sym__space,
    STATE(79), 1,
      sym__attribute_full,
    STATE(83), 1,
      sym__attribute_shorthand,
    STATE(101), 1,
      sym_attribute,
    STATE(129), 1,
      sym__shorthand_sigil,
    ACTIONS(13), 2,
      anon_sym_DOT,
      anon_sym_POUND,
    ACTIONS(260), 2,
      sym_tag_end,
      anon_sym_SLASH,
    ACTIONS(27), 3,
      anon_sym_TAB,
      anon_sym_,
      anon_sym_LF,
  [1528] = 9,
    ACTIONS(241), 1,
      sym_identifier,
    STATE(18), 1,
      aux_sym__space,
    STATE(79), 1,
      sym__attribute_full,
    STATE(83), 1,
      sym__attribute_shorthand,
    STATE(101), 1,
      sym_attribute,
    STATE(129), 1,
      sym__shorthand_sigil,
    ACTIONS(13), 2,
      anon_sym_DOT,
      anon_sym_POUND,
    ACTIONS(262), 2,
      sym_tag_end,
      anon_sym_SLASH,
    ACTIONS(27), 3,
      anon_sym_TAB,
      anon_sym_,
      anon_sym_LF,
  [1560] = 2,
    ACTIONS(264), 4,
      sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(266), 8,
      sym_number,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_DOLLAR,
      anon_sym_AT,
      anon_sym_RPAREN,
  [1577] = 2,
    ACTIONS(268), 4,
      sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(270), 8,
      sym_number,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_DOLLAR,
      anon_sym_AT,
      anon_sym_RPAREN,
  [1594] = 9,
    ACTIONS(241), 1,
      sym_identifier,
    ACTIONS(272), 1,
      sym_tag_end,
    STATE(18), 1,
      aux_sym__space,
    STATE(79), 1,
      sym__attribute_full,
    STATE(83), 1,
      sym__attribute_shorthand,
    STATE(91), 1,
      sym_attribute,
    STATE(129), 1,
      sym__shorthand_sigil,
    ACTIONS(13), 2,
      anon_sym_DOT,
      anon_sym_POUND,
    ACTIONS(27), 3,
      anon_sym_TAB,
      anon_sym_,
      anon_sym_LF,
  [1625] = 2,
    ACTIONS(274), 4,
      sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(276), 8,
      sym_number,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_DOLLAR,
      anon_sym_AT,
      anon_sym_RPAREN,
  [1642] = 8,
    ACTIONS(241), 1,
      sym_identifier,
    STATE(18), 1,
      aux_sym__space,
    STATE(79), 1,
      sym__attribute_full,
    STATE(83), 1,
      sym__attribute_shorthand,
    STATE(101), 1,
      sym_attribute,
    STATE(129), 1,
      sym__shorthand_sigil,
    ACTIONS(13), 2,
      anon_sym_DOT,
      anon_sym_POUND,
    ACTIONS(27), 3,
      anon_sym_TAB,
      anon_sym_,
      anon_sym_LF,
  [1670] = 4,
    ACTIONS(278), 1,
      anon_sym_DOT,
    ACTIONS(280), 1,
      anon_sym_LBRACK,
    STATE(57), 2,
      sym_variable_tail,
      aux_sym_variable_repeat1,
    ACTIONS(138), 7,
      sym_tag_end,
      anon_sym_SLASH,
      anon_sym_POUND,
      sym_identifier,
      anon_sym_TAB,
      anon_sym_,
      anon_sym_LF,
  [1690] = 2,
    ACTIONS(282), 4,
      sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(284), 7,
      sym_number,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOLLAR,
      anon_sym_AT,
  [1706] = 4,
    ACTIONS(278), 1,
      anon_sym_DOT,
    ACTIONS(280), 1,
      anon_sym_LBRACK,
    STATE(52), 2,
      sym_variable_tail,
      aux_sym_variable_repeat1,
    ACTIONS(156), 7,
      sym_tag_end,
      anon_sym_SLASH,
      anon_sym_POUND,
      sym_identifier,
      anon_sym_TAB,
      anon_sym_,
      anon_sym_LF,
  [1726] = 8,
    ACTIONS(241), 1,
      sym_identifier,
    STATE(18), 1,
      aux_sym__space,
    STATE(79), 1,
      sym__attribute_full,
    STATE(83), 1,
      sym__attribute_shorthand,
    STATE(91), 1,
      sym_attribute,
    STATE(129), 1,
      sym__shorthand_sigil,
    ACTIONS(13), 2,
      anon_sym_DOT,
      anon_sym_POUND,
    ACTIONS(27), 3,
      anon_sym_TAB,
      anon_sym_,
      anon_sym_LF,
  [1754] = 7,
    ACTIONS(119), 1,
      sym_identifier,
    ACTIONS(286), 1,
      sym_tag_end,
    STATE(18), 1,
      aux_sym__space,
    STATE(136), 1,
      sym_variable_sigil,
    ACTIONS(25), 2,
      anon_sym_DOLLAR,
      anon_sym_AT,
    STATE(104), 2,
      sym_variable,
      sym_function,
    ACTIONS(27), 3,
      anon_sym_TAB,
      anon_sym_,
      anon_sym_LF,
  [1780] = 4,
    ACTIONS(288), 1,
      anon_sym_DOT,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    STATE(57), 2,
      sym_variable_tail,
      aux_sym_variable_repeat1,
    ACTIONS(146), 7,
      sym_tag_end,
      anon_sym_SLASH,
      anon_sym_POUND,
      sym_identifier,
      anon_sym_TAB,
      anon_sym_,
      anon_sym_LF,
  [1800] = 2,
    ACTIONS(282), 4,
      sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(284), 7,
      sym_number,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOLLAR,
      anon_sym_AT,
  [1816] = 6,
    ACTIONS(119), 1,
      sym_identifier,
    STATE(18), 1,
      aux_sym__space,
    STATE(136), 1,
      sym_variable_sigil,
    ACTIONS(25), 2,
      anon_sym_DOLLAR,
      anon_sym_AT,
    STATE(104), 2,
      sym_variable,
      sym_function,
    ACTIONS(27), 3,
      anon_sym_TAB,
      anon_sym_,
      anon_sym_LF,
  [1839] = 8,
    ACTIONS(37), 1,
      anon_sym_DQUOTE,
    ACTIONS(294), 1,
      sym_identifier,
    ACTIONS(296), 1,
      anon_sym_RBRACE,
    STATE(115), 1,
      sym__hash_key_value,
    STATE(137), 1,
      sym_hash_key,
    STATE(142), 1,
      sym_string,
    STATE(148), 1,
      sym__hash_item_with_optional_comma,
    STATE(88), 2,
      sym__hash_item,
      aux_sym_hash_repeat1,
  [1865] = 8,
    ACTIONS(37), 1,
      anon_sym_DQUOTE,
    ACTIONS(294), 1,
      sym_identifier,
    ACTIONS(298), 1,
      anon_sym_RBRACE,
    STATE(115), 1,
      sym__hash_key_value,
    STATE(137), 1,
      sym_hash_key,
    STATE(142), 1,
      sym_string,
    STATE(143), 1,
      sym__hash_item_with_optional_comma,
    STATE(60), 2,
      sym__hash_item,
      aux_sym_hash_repeat1,
  [1891] = 6,
    ACTIONS(302), 1,
      anon_sym_EQ,
    ACTIONS(304), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      aux_sym__space,
    STATE(92), 1,
      aux_sym_tag_open_repeat1,
    ACTIONS(300), 2,
      sym_tag_end,
      anon_sym_SLASH,
    ACTIONS(306), 3,
      anon_sym_TAB,
      anon_sym_,
      anon_sym_LF,
  [1913] = 1,
    ACTIONS(168), 9,
      sym_tag_end,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      sym_identifier,
      anon_sym_TAB,
      anon_sym_,
      anon_sym_LF,
  [1925] = 8,
    ACTIONS(37), 1,
      anon_sym_DQUOTE,
    ACTIONS(294), 1,
      sym_identifier,
    ACTIONS(308), 1,
      anon_sym_RBRACE,
    STATE(115), 1,
      sym__hash_key_value,
    STATE(127), 1,
      sym__hash_item_with_optional_comma,
    STATE(137), 1,
      sym_hash_key,
    STATE(142), 1,
      sym_string,
    STATE(88), 2,
      sym__hash_item,
      aux_sym_hash_repeat1,
  [1951] = 8,
    ACTIONS(37), 1,
      anon_sym_DQUOTE,
    ACTIONS(294), 1,
      sym_identifier,
    ACTIONS(310), 1,
      anon_sym_RBRACE,
    STATE(115), 1,
      sym__hash_key_value,
    STATE(137), 1,
      sym_hash_key,
    STATE(138), 1,
      sym__hash_item_with_optional_comma,
    STATE(142), 1,
      sym_string,
    STATE(64), 2,
      sym__hash_item,
      aux_sym_hash_repeat1,
  [1977] = 1,
    ACTIONS(164), 9,
      sym_tag_end,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      sym_identifier,
      anon_sym_TAB,
      anon_sym_,
      anon_sym_LF,
  [1989] = 1,
    ACTIONS(188), 8,
      sym_tag_end,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_POUND,
      sym_identifier,
      anon_sym_TAB,
      anon_sym_,
      anon_sym_LF,
  [2000] = 1,
    ACTIONS(312), 8,
      sym_tag_end,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_POUND,
      sym_identifier,
      anon_sym_TAB,
      anon_sym_,
      anon_sym_LF,
  [2011] = 1,
    ACTIONS(233), 8,
      sym_tag_end,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_POUND,
      sym_identifier,
      anon_sym_TAB,
      anon_sym_,
      anon_sym_LF,
  [2022] = 6,
    ACTIONS(37), 1,
      anon_sym_DQUOTE,
    ACTIONS(314), 1,
      sym_number,
    STATE(121), 1,
      sym_variable_sigil,
    STATE(149), 1,
      sym_variable_segment_value,
    ACTIONS(45), 2,
      anon_sym_DOLLAR,
      anon_sym_AT,
    STATE(125), 2,
      sym_string,
      sym_variable,
  [2043] = 1,
    ACTIONS(316), 8,
      sym_tag_end,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_POUND,
      sym_identifier,
      anon_sym_TAB,
      anon_sym_,
      anon_sym_LF,
  [2054] = 1,
    ACTIONS(237), 8,
      sym_tag_end,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_POUND,
      sym_identifier,
      anon_sym_TAB,
      anon_sym_,
      anon_sym_LF,
  [2065] = 4,
    ACTIONS(5), 1,
      aux_sym_markdown_token1,
    ACTIONS(7), 1,
      sym_tag_start,
    ACTIONS(318), 1,
      ts_builtin_sym_end,
    STATE(89), 5,
      sym_markdown,
      sym_tag,
      sym_annotation,
      sym_interpolation,
      aux_sym_content_repeat1,
  [2082] = 1,
    ACTIONS(172), 8,
      sym_tag_end,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_POUND,
      sym_identifier,
      anon_sym_TAB,
      anon_sym_,
      anon_sym_LF,
  [2093] = 1,
    ACTIONS(184), 8,
      sym_tag_end,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_POUND,
      sym_identifier,
      anon_sym_TAB,
      anon_sym_,
      anon_sym_LF,
  [2104] = 5,
    ACTIONS(302), 1,
      anon_sym_EQ,
    STATE(2), 1,
      aux_sym__space,
    STATE(92), 1,
      aux_sym_tag_open_repeat1,
    ACTIONS(300), 2,
      sym_tag_end,
      anon_sym_SLASH,
    ACTIONS(306), 3,
      anon_sym_TAB,
      anon_sym_,
      anon_sym_LF,
  [2123] = 1,
    ACTIONS(176), 8,
      sym_tag_end,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_POUND,
      sym_identifier,
      anon_sym_TAB,
      anon_sym_,
      anon_sym_LF,
  [2134] = 1,
    ACTIONS(225), 8,
      sym_tag_end,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_POUND,
      sym_identifier,
      anon_sym_TAB,
      anon_sym_,
      anon_sym_LF,
  [2145] = 1,
    ACTIONS(320), 8,
      sym_tag_end,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_POUND,
      sym_identifier,
      anon_sym_TAB,
      anon_sym_,
      anon_sym_LF,
  [2156] = 1,
    ACTIONS(221), 8,
      sym_tag_end,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_POUND,
      sym_identifier,
      anon_sym_TAB,
      anon_sym_,
      anon_sym_LF,
  [2167] = 1,
    ACTIONS(180), 8,
      sym_tag_end,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_POUND,
      sym_identifier,
      anon_sym_TAB,
      anon_sym_,
      anon_sym_LF,
  [2178] = 1,
    ACTIONS(196), 8,
      sym_tag_end,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_POUND,
      sym_identifier,
      anon_sym_TAB,
      anon_sym_,
      anon_sym_LF,
  [2189] = 1,
    ACTIONS(322), 8,
      sym_tag_end,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_POUND,
      sym_identifier,
      anon_sym_TAB,
      anon_sym_,
      anon_sym_LF,
  [2200] = 6,
    ACTIONS(37), 1,
      anon_sym_DQUOTE,
    ACTIONS(314), 1,
      sym_number,
    STATE(121), 1,
      sym_variable_sigil,
    STATE(122), 1,
      sym_variable_segment_value,
    ACTIONS(45), 2,
      anon_sym_DOLLAR,
      anon_sym_AT,
    STATE(125), 2,
      sym_string,
      sym_variable,
  [2221] = 1,
    ACTIONS(160), 8,
      sym_tag_end,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_POUND,
      sym_identifier,
      anon_sym_TAB,
      anon_sym_,
      anon_sym_LF,
  [2232] = 1,
    ACTIONS(192), 8,
      sym_tag_end,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_POUND,
      sym_identifier,
      anon_sym_TAB,
      anon_sym_,
      anon_sym_LF,
  [2243] = 1,
    ACTIONS(217), 8,
      sym_tag_end,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_POUND,
      sym_identifier,
      anon_sym_TAB,
      anon_sym_,
      anon_sym_LF,
  [2254] = 7,
    ACTIONS(324), 1,
      sym_identifier,
    ACTIONS(327), 1,
      anon_sym_DQUOTE,
    ACTIONS(330), 1,
      anon_sym_RBRACE,
    STATE(124), 1,
      sym__hash_key_value,
    STATE(137), 1,
      sym_hash_key,
    STATE(142), 1,
      sym_string,
    STATE(88), 2,
      sym__hash_item,
      aux_sym_hash_repeat1,
  [2277] = 4,
    ACTIONS(332), 1,
      ts_builtin_sym_end,
    ACTIONS(334), 1,
      aux_sym_markdown_token1,
    ACTIONS(337), 1,
      sym_tag_start,
    STATE(89), 5,
      sym_markdown,
      sym_tag,
      sym_annotation,
      sym_interpolation,
      aux_sym_content_repeat1,
  [2294] = 1,
    ACTIONS(207), 8,
      sym_tag_end,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_POUND,
      sym_identifier,
      anon_sym_TAB,
      anon_sym_,
      anon_sym_LF,
  [2305] = 1,
    ACTIONS(252), 7,
      sym_tag_end,
      anon_sym_DOT,
      anon_sym_POUND,
      sym_identifier,
      anon_sym_TAB,
      anon_sym_,
      anon_sym_LF,
  [2315] = 4,
    STATE(45), 1,
      aux_sym__space,
    STATE(94), 1,
      aux_sym_tag_open_repeat1,
    ACTIONS(11), 2,
      sym_tag_end,
      anon_sym_SLASH,
    ACTIONS(340), 3,
      anon_sym_TAB,
      anon_sym_,
      anon_sym_LF,
  [2331] = 4,
    STATE(42), 1,
      aux_sym__space,
    STATE(94), 1,
      aux_sym_tag_open_repeat1,
    ACTIONS(262), 2,
      sym_tag_end,
      anon_sym_SLASH,
    ACTIONS(342), 3,
      anon_sym_TAB,
      anon_sym_,
      anon_sym_LF,
  [2347] = 4,
    STATE(51), 1,
      aux_sym__space,
    STATE(94), 1,
      aux_sym_tag_open_repeat1,
    ACTIONS(344), 2,
      sym_tag_end,
      anon_sym_SLASH,
    ACTIONS(346), 3,
      anon_sym_TAB,
      anon_sym_,
      anon_sym_LF,
  [2363] = 4,
    STATE(46), 1,
      aux_sym__space,
    STATE(93), 1,
      aux_sym_tag_open_repeat1,
    ACTIONS(260), 2,
      sym_tag_end,
      anon_sym_SLASH,
    ACTIONS(349), 3,
      anon_sym_TAB,
      anon_sym_,
      anon_sym_LF,
  [2379] = 4,
    ACTIONS(351), 1,
      sym_tag_end,
    STATE(56), 1,
      aux_sym__space,
    STATE(97), 1,
      aux_sym_interpolation_repeat1,
    ACTIONS(353), 3,
      anon_sym_TAB,
      anon_sym_,
      anon_sym_LF,
  [2394] = 4,
    ACTIONS(355), 1,
      sym_tag_end,
    STATE(59), 1,
      aux_sym__space,
    STATE(97), 1,
      aux_sym_interpolation_repeat1,
    ACTIONS(357), 3,
      anon_sym_TAB,
      anon_sym_,
      anon_sym_LF,
  [2409] = 3,
    ACTIONS(360), 1,
      anon_sym_DQUOTE,
    ACTIONS(362), 2,
      sym__string_character,
      sym__string_escape_sequence,
    STATE(98), 2,
      sym__string_element,
      aux_sym_string_repeat1,
  [2421] = 3,
    ACTIONS(365), 1,
      anon_sym_DQUOTE,
    ACTIONS(367), 2,
      sym__string_character,
      sym__string_escape_sequence,
    STATE(100), 2,
      sym__string_element,
      aux_sym_string_repeat1,
  [2433] = 3,
    ACTIONS(369), 1,
      anon_sym_DQUOTE,
    ACTIONS(371), 2,
      sym__string_character,
      sym__string_escape_sequence,
    STATE(98), 2,
      sym__string_element,
      aux_sym_string_repeat1,
  [2445] = 1,
    ACTIONS(344), 5,
      sym_tag_end,
      anon_sym_SLASH,
      anon_sym_TAB,
      anon_sym_,
      anon_sym_LF,
  [2453] = 3,
    ACTIONS(373), 1,
      anon_sym_DQUOTE,
    ACTIONS(371), 2,
      sym__string_character,
      sym__string_escape_sequence,
    STATE(98), 2,
      sym__string_element,
      aux_sym_string_repeat1,
  [2465] = 3,
    ACTIONS(375), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 2,
      sym__string_character,
      sym__string_escape_sequence,
    STATE(102), 2,
      sym__string_element,
      aux_sym_string_repeat1,
  [2477] = 1,
    ACTIONS(355), 4,
      sym_tag_end,
      anon_sym_TAB,
      anon_sym_,
      anon_sym_LF,
  [2484] = 1,
    ACTIONS(379), 3,
      anon_sym_DQUOTE,
      anon_sym_RBRACE,
      sym_identifier,
  [2490] = 1,
    ACTIONS(381), 3,
      ts_builtin_sym_end,
      aux_sym_markdown_token1,
      sym_tag_start,
  [2496] = 1,
    ACTIONS(383), 3,
      ts_builtin_sym_end,
      aux_sym_markdown_token1,
      sym_tag_start,
  [2502] = 1,
    ACTIONS(385), 3,
      ts_builtin_sym_end,
      aux_sym_markdown_token1,
      sym_tag_start,
  [2508] = 1,
    ACTIONS(387), 3,
      ts_builtin_sym_end,
      aux_sym_markdown_token1,
      sym_tag_start,
  [2514] = 1,
    ACTIONS(379), 3,
      anon_sym_DQUOTE,
      anon_sym_RBRACE,
      sym_identifier,
  [2520] = 1,
    ACTIONS(389), 3,
      ts_builtin_sym_end,
      aux_sym_markdown_token1,
      sym_tag_start,
  [2526] = 1,
    ACTIONS(391), 3,
      ts_builtin_sym_end,
      aux_sym_markdown_token1,
      sym_tag_start,
  [2532] = 1,
    ACTIONS(393), 3,
      ts_builtin_sym_end,
      aux_sym_markdown_token1,
      sym_tag_start,
  [2538] = 1,
    ACTIONS(395), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [2543] = 2,
    ACTIONS(397), 1,
      anon_sym_COMMA,
    ACTIONS(399), 1,
      anon_sym_RBRACE,
  [2550] = 2,
    ACTIONS(401), 1,
      anon_sym_EQ,
    ACTIONS(403), 1,
      anon_sym_LPAREN,
  [2557] = 2,
    ACTIONS(405), 1,
      sym_tag_end,
    ACTIONS(407), 1,
      anon_sym_SLASH,
  [2564] = 2,
    ACTIONS(409), 1,
      anon_sym_RBRACK,
    ACTIONS(411), 1,
      anon_sym_COMMA,
  [2571] = 2,
    ACTIONS(413), 1,
      anon_sym_EQ,
    ACTIONS(415), 1,
      anon_sym_LPAREN,
  [2578] = 1,
    ACTIONS(415), 1,
      anon_sym_LPAREN,
  [2582] = 1,
    ACTIONS(417), 1,
      sym_identifier,
  [2586] = 1,
    ACTIONS(419), 1,
      anon_sym_RBRACK,
  [2590] = 1,
    ACTIONS(421), 1,
      sym_tag_end,
  [2594] = 1,
    ACTIONS(423), 1,
      anon_sym_COMMA,
  [2598] = 1,
    ACTIONS(425), 1,
      anon_sym_RBRACK,
  [2602] = 1,
    ACTIONS(427), 1,
      sym_tag_end,
  [2606] = 1,
    ACTIONS(429), 1,
      anon_sym_RBRACE,
  [2610] = 1,
    ACTIONS(431), 1,
      anon_sym_COMMA,
  [2614] = 1,
    ACTIONS(433), 1,
      sym_identifier,
  [2618] = 1,
    ACTIONS(435), 1,
      anon_sym_RBRACK,
  [2622] = 1,
    ACTIONS(437), 1,
      sym_identifier,
  [2626] = 1,
    ACTIONS(405), 1,
      sym_tag_end,
  [2630] = 1,
    ACTIONS(439), 1,
      sym_tag_end,
  [2634] = 1,
    ACTIONS(441), 1,
      sym_tag_end,
  [2638] = 1,
    ACTIONS(443), 1,
      sym_identifier,
  [2642] = 1,
    ACTIONS(445), 1,
      sym_identifier,
  [2646] = 1,
    ACTIONS(447), 1,
      anon_sym_COLON,
  [2650] = 1,
    ACTIONS(308), 1,
      anon_sym_RBRACE,
  [2654] = 1,
    ACTIONS(449), 1,
      sym_identifier,
  [2658] = 1,
    ACTIONS(413), 1,
      anon_sym_EQ,
  [2662] = 1,
    ACTIONS(47), 1,
      anon_sym_RBRACK,
  [2666] = 1,
    ACTIONS(451), 1,
      anon_sym_COLON,
  [2670] = 1,
    ACTIONS(296), 1,
      anon_sym_RBRACE,
  [2674] = 1,
    ACTIONS(453), 1,
      anon_sym_COLON,
  [2678] = 1,
    ACTIONS(455), 1,
      ts_builtin_sym_end,
  [2682] = 1,
    ACTIONS(457), 1,
      sym_identifier,
  [2686] = 1,
    ACTIONS(459), 1,
      anon_sym_RBRACK,
  [2690] = 1,
    ACTIONS(461), 1,
      anon_sym_RBRACE,
  [2694] = 1,
    ACTIONS(463), 1,
      anon_sym_RBRACK,
  [2698] = 1,
    ACTIONS(403), 1,
      anon_sym_LPAREN,
  [2702] = 1,
    ACTIONS(49), 1,
      anon_sym_RBRACK,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 73,
  [SMALL_STATE(4)] = 130,
  [SMALL_STATE(5)] = 187,
  [SMALL_STATE(6)] = 244,
  [SMALL_STATE(7)] = 301,
  [SMALL_STATE(8)] = 355,
  [SMALL_STATE(9)] = 409,
  [SMALL_STATE(10)] = 463,
  [SMALL_STATE(11)] = 517,
  [SMALL_STATE(12)] = 571,
  [SMALL_STATE(13)] = 625,
  [SMALL_STATE(14)] = 676,
  [SMALL_STATE(15)] = 728,
  [SMALL_STATE(16)] = 775,
  [SMALL_STATE(17)] = 822,
  [SMALL_STATE(18)] = 869,
  [SMALL_STATE(19)] = 894,
  [SMALL_STATE(20)] = 939,
  [SMALL_STATE(21)] = 967,
  [SMALL_STATE(22)] = 995,
  [SMALL_STATE(23)] = 1023,
  [SMALL_STATE(24)] = 1043,
  [SMALL_STATE(25)] = 1063,
  [SMALL_STATE(26)] = 1083,
  [SMALL_STATE(27)] = 1103,
  [SMALL_STATE(28)] = 1122,
  [SMALL_STATE(29)] = 1141,
  [SMALL_STATE(30)] = 1160,
  [SMALL_STATE(31)] = 1179,
  [SMALL_STATE(32)] = 1198,
  [SMALL_STATE(33)] = 1217,
  [SMALL_STATE(34)] = 1240,
  [SMALL_STATE(35)] = 1259,
  [SMALL_STATE(36)] = 1282,
  [SMALL_STATE(37)] = 1301,
  [SMALL_STATE(38)] = 1320,
  [SMALL_STATE(39)] = 1339,
  [SMALL_STATE(40)] = 1362,
  [SMALL_STATE(41)] = 1381,
  [SMALL_STATE(42)] = 1400,
  [SMALL_STATE(43)] = 1432,
  [SMALL_STATE(44)] = 1464,
  [SMALL_STATE(45)] = 1496,
  [SMALL_STATE(46)] = 1528,
  [SMALL_STATE(47)] = 1560,
  [SMALL_STATE(48)] = 1577,
  [SMALL_STATE(49)] = 1594,
  [SMALL_STATE(50)] = 1625,
  [SMALL_STATE(51)] = 1642,
  [SMALL_STATE(52)] = 1670,
  [SMALL_STATE(53)] = 1690,
  [SMALL_STATE(54)] = 1706,
  [SMALL_STATE(55)] = 1726,
  [SMALL_STATE(56)] = 1754,
  [SMALL_STATE(57)] = 1780,
  [SMALL_STATE(58)] = 1800,
  [SMALL_STATE(59)] = 1816,
  [SMALL_STATE(60)] = 1839,
  [SMALL_STATE(61)] = 1865,
  [SMALL_STATE(62)] = 1891,
  [SMALL_STATE(63)] = 1913,
  [SMALL_STATE(64)] = 1925,
  [SMALL_STATE(65)] = 1951,
  [SMALL_STATE(66)] = 1977,
  [SMALL_STATE(67)] = 1989,
  [SMALL_STATE(68)] = 2000,
  [SMALL_STATE(69)] = 2011,
  [SMALL_STATE(70)] = 2022,
  [SMALL_STATE(71)] = 2043,
  [SMALL_STATE(72)] = 2054,
  [SMALL_STATE(73)] = 2065,
  [SMALL_STATE(74)] = 2082,
  [SMALL_STATE(75)] = 2093,
  [SMALL_STATE(76)] = 2104,
  [SMALL_STATE(77)] = 2123,
  [SMALL_STATE(78)] = 2134,
  [SMALL_STATE(79)] = 2145,
  [SMALL_STATE(80)] = 2156,
  [SMALL_STATE(81)] = 2167,
  [SMALL_STATE(82)] = 2178,
  [SMALL_STATE(83)] = 2189,
  [SMALL_STATE(84)] = 2200,
  [SMALL_STATE(85)] = 2221,
  [SMALL_STATE(86)] = 2232,
  [SMALL_STATE(87)] = 2243,
  [SMALL_STATE(88)] = 2254,
  [SMALL_STATE(89)] = 2277,
  [SMALL_STATE(90)] = 2294,
  [SMALL_STATE(91)] = 2305,
  [SMALL_STATE(92)] = 2315,
  [SMALL_STATE(93)] = 2331,
  [SMALL_STATE(94)] = 2347,
  [SMALL_STATE(95)] = 2363,
  [SMALL_STATE(96)] = 2379,
  [SMALL_STATE(97)] = 2394,
  [SMALL_STATE(98)] = 2409,
  [SMALL_STATE(99)] = 2421,
  [SMALL_STATE(100)] = 2433,
  [SMALL_STATE(101)] = 2445,
  [SMALL_STATE(102)] = 2453,
  [SMALL_STATE(103)] = 2465,
  [SMALL_STATE(104)] = 2477,
  [SMALL_STATE(105)] = 2484,
  [SMALL_STATE(106)] = 2490,
  [SMALL_STATE(107)] = 2496,
  [SMALL_STATE(108)] = 2502,
  [SMALL_STATE(109)] = 2508,
  [SMALL_STATE(110)] = 2514,
  [SMALL_STATE(111)] = 2520,
  [SMALL_STATE(112)] = 2526,
  [SMALL_STATE(113)] = 2532,
  [SMALL_STATE(114)] = 2538,
  [SMALL_STATE(115)] = 2543,
  [SMALL_STATE(116)] = 2550,
  [SMALL_STATE(117)] = 2557,
  [SMALL_STATE(118)] = 2564,
  [SMALL_STATE(119)] = 2571,
  [SMALL_STATE(120)] = 2578,
  [SMALL_STATE(121)] = 2582,
  [SMALL_STATE(122)] = 2586,
  [SMALL_STATE(123)] = 2590,
  [SMALL_STATE(124)] = 2594,
  [SMALL_STATE(125)] = 2598,
  [SMALL_STATE(126)] = 2602,
  [SMALL_STATE(127)] = 2606,
  [SMALL_STATE(128)] = 2610,
  [SMALL_STATE(129)] = 2614,
  [SMALL_STATE(130)] = 2618,
  [SMALL_STATE(131)] = 2622,
  [SMALL_STATE(132)] = 2626,
  [SMALL_STATE(133)] = 2630,
  [SMALL_STATE(134)] = 2634,
  [SMALL_STATE(135)] = 2638,
  [SMALL_STATE(136)] = 2642,
  [SMALL_STATE(137)] = 2646,
  [SMALL_STATE(138)] = 2650,
  [SMALL_STATE(139)] = 2654,
  [SMALL_STATE(140)] = 2658,
  [SMALL_STATE(141)] = 2662,
  [SMALL_STATE(142)] = 2666,
  [SMALL_STATE(143)] = 2670,
  [SMALL_STATE(144)] = 2674,
  [SMALL_STATE(145)] = 2678,
  [SMALL_STATE(146)] = 2682,
  [SMALL_STATE(147)] = 2686,
  [SMALL_STATE(148)] = 2690,
  [SMALL_STATE(149)] = 2694,
  [SMALL_STATE(150)] = 2698,
  [SMALL_STATE(151)] = 2702,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_content, 0),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(119),
  [11] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tag_open, 2, .production_id = 1),
  [13] = {.entry = {.count = 1, .reusable = false}}, SHIFT(129),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(75),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(78),
  [19] = {.entry = {.count = 1, .reusable = false}}, SHIFT(99),
  [21] = {.entry = {.count = 1, .reusable = false}}, SHIFT(6),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(65),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(135),
  [27] = {.entry = {.count = 1, .reusable = false}}, SHIFT(18),
  [29] = {.entry = {.count = 1, .reusable = false}}, SHIFT(150),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(29),
  [33] = {.entry = {.count = 1, .reusable = false}}, SHIFT(38),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [39] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [43] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [47] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [49] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [51] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [53] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [55] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_repeat1, 2), SHIFT_REPEAT(150),
  [58] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_repeat1, 2), SHIFT_REPEAT(29),
  [61] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_repeat1, 2), SHIFT_REPEAT(38),
  [64] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_repeat1, 2), SHIFT_REPEAT(29),
  [67] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_repeat1, 2), SHIFT_REPEAT(103),
  [70] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_repeat1, 2), SHIFT_REPEAT(3),
  [73] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_repeat1, 2), SHIFT_REPEAT(61),
  [76] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_repeat1, 2), SHIFT_REPEAT(135),
  [79] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_function_repeat1, 2),
  [81] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [83] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_array_repeat1, 2), SHIFT_REPEAT(150),
  [86] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_array_repeat1, 2), SHIFT_REPEAT(29),
  [89] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_array_repeat1, 2), SHIFT_REPEAT(38),
  [92] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_array_repeat1, 2), SHIFT_REPEAT(29),
  [95] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_array_repeat1, 2), SHIFT_REPEAT(103),
  [98] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_array_repeat1, 2), SHIFT_REPEAT(3),
  [101] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_array_repeat1, 2),
  [103] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_array_repeat1, 2), SHIFT_REPEAT(61),
  [106] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_array_repeat1, 2), SHIFT_REPEAT(135),
  [109] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [111] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [113] = {.entry = {.count = 1, .reusable = false}}, SHIFT(116),
  [115] = {.entry = {.count = 1, .reusable = false}}, SHIFT(62),
  [117] = {.entry = {.count = 1, .reusable = false}}, SHIFT(139),
  [119] = {.entry = {.count = 1, .reusable = false}}, SHIFT(120),
  [121] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [123] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [125] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [127] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [129] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__space, 2),
  [131] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__space, 2), SHIFT_REPEAT(18),
  [134] = {.entry = {.count = 1, .reusable = false}}, SHIFT(76),
  [136] = {.entry = {.count = 1, .reusable = false}}, SHIFT(14),
  [138] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable, 3, .production_id = 7),
  [140] = {.entry = {.count = 1, .reusable = true}}, SHIFT(146),
  [142] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable, 3, .production_id = 7),
  [144] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [146] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_variable_repeat1, 2),
  [148] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_variable_repeat1, 2), SHIFT_REPEAT(146),
  [151] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_variable_repeat1, 2),
  [153] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_variable_repeat1, 2), SHIFT_REPEAT(70),
  [156] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable, 2, .production_id = 7),
  [158] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable, 2, .production_id = 7),
  [160] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 3),
  [162] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 3),
  [164] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_tail, 2, .production_id = 9),
  [166] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_tail, 2, .production_id = 9),
  [168] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_tail, 3),
  [170] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_tail, 3),
  [172] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 2),
  [174] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 2),
  [176] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function, 4, .production_id = 8),
  [178] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function, 4, .production_id = 8),
  [180] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_compound, 1),
  [182] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_compound, 1),
  [184] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_primitive, 1),
  [186] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_primitive, 1),
  [188] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_array, 4),
  [190] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array, 4),
  [192] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_hash, 4),
  [194] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_hash, 4),
  [196] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_value, 1),
  [198] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_value, 1),
  [200] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_function_parameters_repeat1, 2),
  [202] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_function_parameters_repeat1, 2),
  [204] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_parameters_repeat1, 2), SHIFT_REPEAT(13),
  [207] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_hash, 3),
  [209] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_hash, 3),
  [211] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_parameters, 1),
  [213] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_parameters, 1),
  [215] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [217] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_array, 3),
  [219] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array, 3),
  [221] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function, 3, .production_id = 8),
  [223] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function, 3, .production_id = 8),
  [225] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_boolean, 1),
  [227] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_boolean, 1),
  [229] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_parameters, 2),
  [231] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_parameters, 2),
  [233] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_array, 2),
  [235] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array, 2),
  [237] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_hash, 2),
  [239] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_hash, 2),
  [241] = {.entry = {.count = 1, .reusable = false}}, SHIFT(140),
  [243] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tag_open, 5, .production_id = 1),
  [245] = {.entry = {.count = 1, .reusable = false}}, SHIFT(112),
  [247] = {.entry = {.count = 1, .reusable = false}}, SHIFT(49),
  [249] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_annotation_repeat1, 2), SHIFT_REPEAT(140),
  [252] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_annotation_repeat1, 2),
  [254] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_annotation_repeat1, 2), SHIFT_REPEAT(129),
  [257] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_annotation_repeat1, 2), SHIFT_REPEAT(55),
  [260] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tag_open, 3, .production_id = 1),
  [262] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tag_open, 4, .production_id = 1),
  [264] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_parameter, 1),
  [266] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_parameter, 1),
  [268] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_parameter_tail, 2),
  [270] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_parameter_tail, 2),
  [272] = {.entry = {.count = 1, .reusable = false}}, SHIFT(109),
  [274] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_parameter_named, 3, .production_id = 10),
  [276] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_parameter_named, 3, .production_id = 10),
  [278] = {.entry = {.count = 1, .reusable = false}}, SHIFT(131),
  [280] = {.entry = {.count = 1, .reusable = false}}, SHIFT(84),
  [282] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__array_item, 2),
  [284] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__array_item, 2),
  [286] = {.entry = {.count = 1, .reusable = false}}, SHIFT(108),
  [288] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_variable_repeat1, 2), SHIFT_REPEAT(131),
  [291] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_variable_repeat1, 2), SHIFT_REPEAT(84),
  [294] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [296] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [298] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [300] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tag_open, 1, .production_id = 1),
  [302] = {.entry = {.count = 1, .reusable = false}}, SHIFT(16),
  [304] = {.entry = {.count = 1, .reusable = false}}, SHIFT(9),
  [306] = {.entry = {.count = 1, .reusable = false}}, SHIFT(2),
  [308] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [310] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [312] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__attribute_full, 3, .production_id = 6),
  [314] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [316] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__attribute_shorthand, 2, .production_id = 5),
  [318] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_content, 1),
  [320] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attribute, 1, .production_id = 2),
  [322] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attribute, 1, .production_id = 3),
  [324] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_hash_repeat1, 2), SHIFT_REPEAT(144),
  [327] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_hash_repeat1, 2), SHIFT_REPEAT(103),
  [330] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_hash_repeat1, 2),
  [332] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_content_repeat1, 2),
  [334] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_content_repeat1, 2), SHIFT_REPEAT(111),
  [337] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_content_repeat1, 2), SHIFT_REPEAT(19),
  [340] = {.entry = {.count = 1, .reusable = false}}, SHIFT(45),
  [342] = {.entry = {.count = 1, .reusable = false}}, SHIFT(42),
  [344] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_tag_open_repeat1, 2),
  [346] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_tag_open_repeat1, 2), SHIFT_REPEAT(51),
  [349] = {.entry = {.count = 1, .reusable = false}}, SHIFT(46),
  [351] = {.entry = {.count = 1, .reusable = false}}, SHIFT(107),
  [353] = {.entry = {.count = 1, .reusable = false}}, SHIFT(56),
  [355] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_interpolation_repeat1, 2),
  [357] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_interpolation_repeat1, 2), SHIFT_REPEAT(59),
  [360] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_string_repeat1, 2),
  [362] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_repeat1, 2), SHIFT_REPEAT(98),
  [365] = {.entry = {.count = 1, .reusable = false}}, SHIFT(74),
  [367] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [369] = {.entry = {.count = 1, .reusable = false}}, SHIFT(85),
  [371] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [373] = {.entry = {.count = 1, .reusable = false}}, SHIFT(23),
  [375] = {.entry = {.count = 1, .reusable = false}}, SHIFT(26),
  [377] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [379] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__hash_item, 2),
  [381] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tag, 4),
  [383] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interpolation, 3),
  [385] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interpolation, 4),
  [387] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_annotation, 4),
  [389] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_markdown, 1),
  [391] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_annotation, 3),
  [393] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tag, 3),
  [395] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__hash_key_value, 3),
  [397] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [399] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__hash_item_with_optional_comma, 1),
  [401] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [403] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [405] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tag_interior, 1),
  [407] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [409] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__array_item_with_optional_comma, 1),
  [411] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [413] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [415] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [417] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [419] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [421] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tag_self_closing, 2),
  [423] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [425] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_segment_value, 1),
  [427] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tag_close, 2, .production_id = 4),
  [429] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [431] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [433] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [435] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [437] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [439] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [441] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [443] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_sigil, 1),
  [445] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [447] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [449] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [451] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_hash_key, 1),
  [453] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_hash_key, 1, .production_id = 6),
  [455] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [457] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [459] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [461] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [463] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_markdoc(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym_identifier,
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
