#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 314
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 96
#define ALIAS_COUNT 1
#define TOKEN_COUNT 47
#define EXTERNAL_TOKEN_COUNT 12
#define FIELD_COUNT 0
#define MAX_ALIAS_SEQUENCE_LENGTH 8
#define PRODUCTION_ID_COUNT 3

enum {
  anon_sym_LT = 1,
  anon_sym_GT = 2,
  anon_sym_SLASH_GT = 3,
  anon_sym_LT_SLASH = 4,
  anon_sym_EQ = 5,
  aux_sym_attribute_name_token1 = 6,
  anon_sym_SQUOTE = 7,
  aux_sym_quoted_attribute_value_token1 = 8,
  anon_sym_DQUOTE = 9,
  aux_sym_quoted_attribute_value_token2 = 10,
  aux_sym__text_token1 = 11,
  anon_sym_LBRACE_RBRACE = 12,
  anon_sym_LBRACE = 13,
  anon_sym_RBRACE = 14,
  anon_sym_AT = 15,
  anon_sym_html = 16,
  anon_sym_const = 17,
  anon_sym_render = 18,
  aux_sym_render_expr_token1 = 19,
  anon_sym_LPAREN = 20,
  aux_sym_render_expr_token2 = 21,
  anon_sym_RPAREN = 22,
  anon_sym_debug = 23,
  anon_sym_POUND = 24,
  anon_sym_if = 25,
  anon_sym_COLON = 26,
  anon_sym_else = 27,
  anon_sym_SLASH = 28,
  anon_sym_each = 29,
  anon_sym_as = 30,
  anon_sym_await = 31,
  anon_sym_then = 32,
  anon_sym_catch = 33,
  anon_sym_snippet = 34,
  anon_sym_key = 35,
  sym__start_tag_name = 36,
  sym__script_start_tag_name = 37,
  sym__style_start_tag_name = 38,
  sym__end_tag_name = 39,
  sym_erroneous_end_tag_name = 40,
  sym__implicit_end_tag = 41,
  sym_raw_text = 42,
  sym_raw_text_expr = 43,
  sym_raw_text_await = 44,
  sym_raw_text_each = 45,
  sym_comment = 46,
  sym_document = 47,
  sym__node = 48,
  sym__statement = 49,
  sym_element = 50,
  sym_start_tag = 51,
  sym_self_closing_tag = 52,
  sym_end_tag = 53,
  sym_script_element = 54,
  sym_script_start_tag = 55,
  sym_style_element = 56,
  sym_style_start_tag = 57,
  sym_attribute = 58,
  sym_attribute_name = 59,
  sym_attribute_value = 60,
  sym_expr_attribute_value = 61,
  sym_quoted_attribute_value = 62,
  sym__text = 63,
  sym__expression = 64,
  sym_expression = 65,
  sym_html_expr = 66,
  sym_const_expr = 67,
  sym_render_expr = 68,
  sym_debug_expr = 69,
  sym_if_statement = 70,
  sym_else_if_statement = 71,
  sym_else_statement = 72,
  sym_if_start_expr = 73,
  sym_else_expr = 74,
  sym_else_if_expr = 75,
  sym_if_end_expr = 76,
  sym_each_statement = 77,
  sym_each_start_expr = 78,
  sym_else_each_statement = 79,
  sym_each_end_expr = 80,
  sym_await_statement = 81,
  sym_then_statement = 82,
  sym_catch_statement = 83,
  sym_await_start_expr = 84,
  sym_then_expr = 85,
  sym_catch_expr = 86,
  sym_await_end_expr = 87,
  sym_snippet_statement = 88,
  sym_snippet_start_expr = 89,
  sym_snippet_end_expr = 90,
  sym_key_statement = 91,
  sym_key_start_expr = 92,
  sym_key_end_expr = 93,
  aux_sym_document_repeat1 = 94,
  aux_sym_start_tag_repeat1 = 95,
  alias_sym_then = 96,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_SLASH_GT] = "/>",
  [anon_sym_LT_SLASH] = "</",
  [anon_sym_EQ] = "=",
  [aux_sym_attribute_name_token1] = "attribute_name_token1",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_quoted_attribute_value_token1] = "attribute_value",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_quoted_attribute_value_token2] = "attribute_value",
  [aux_sym__text_token1] = "text",
  [anon_sym_LBRACE_RBRACE] = "expression",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_AT] = "@",
  [anon_sym_html] = "special_block_keyword",
  [anon_sym_const] = "special_block_keyword",
  [anon_sym_render] = "special_block_keyword",
  [aux_sym_render_expr_token1] = "snippet_name",
  [anon_sym_LPAREN] = "(",
  [aux_sym_render_expr_token2] = "raw_text_expr",
  [anon_sym_RPAREN] = ")",
  [anon_sym_debug] = "special_block_keyword",
  [anon_sym_POUND] = "#",
  [anon_sym_if] = "special_block_keyword",
  [anon_sym_COLON] = ":",
  [anon_sym_else] = "special_block_keyword",
  [anon_sym_SLASH] = "/",
  [anon_sym_each] = "special_block_keyword",
  [anon_sym_as] = "as",
  [anon_sym_await] = "special_block_keyword",
  [anon_sym_then] = "special_block_keyword",
  [anon_sym_catch] = "special_block_keyword",
  [anon_sym_snippet] = "special_block_keyword",
  [anon_sym_key] = "special_block_keyword",
  [sym__start_tag_name] = "tag_name",
  [sym__script_start_tag_name] = "tag_name",
  [sym__style_start_tag_name] = "tag_name",
  [sym__end_tag_name] = "tag_name",
  [sym_erroneous_end_tag_name] = "erroneous_end_tag_name",
  [sym__implicit_end_tag] = "_implicit_end_tag",
  [sym_raw_text] = "raw_text",
  [sym_raw_text_expr] = "raw_text_expr",
  [sym_raw_text_await] = "raw_text_await",
  [sym_raw_text_each] = "raw_text_each",
  [sym_comment] = "comment",
  [sym_document] = "document",
  [sym__node] = "_node",
  [sym__statement] = "_statement",
  [sym_element] = "element",
  [sym_start_tag] = "start_tag",
  [sym_self_closing_tag] = "self_closing_tag",
  [sym_end_tag] = "end_tag",
  [sym_script_element] = "script_element",
  [sym_script_start_tag] = "start_tag",
  [sym_style_element] = "style_element",
  [sym_style_start_tag] = "start_tag",
  [sym_attribute] = "attribute",
  [sym_attribute_name] = "attribute_name",
  [sym_attribute_value] = "attribute_value",
  [sym_expr_attribute_value] = "expr_attribute_value",
  [sym_quoted_attribute_value] = "quoted_attribute_value",
  [sym__text] = "_text",
  [sym__expression] = "_expression",
  [sym_expression] = "expression",
  [sym_html_expr] = "html_expr",
  [sym_const_expr] = "const_expr",
  [sym_render_expr] = "render_expr",
  [sym_debug_expr] = "debug_expr",
  [sym_if_statement] = "if_statement",
  [sym_else_if_statement] = "else_if_statement",
  [sym_else_statement] = "else_statement",
  [sym_if_start_expr] = "if_start_expr",
  [sym_else_expr] = "else_expr",
  [sym_else_if_expr] = "else_if_expr",
  [sym_if_end_expr] = "if_end_expr",
  [sym_each_statement] = "each_statement",
  [sym_each_start_expr] = "each_start_expr",
  [sym_else_each_statement] = "else_each_statement",
  [sym_each_end_expr] = "each_end_expr",
  [sym_await_statement] = "await_statement",
  [sym_then_statement] = "then_statement",
  [sym_catch_statement] = "catch_statement",
  [sym_await_start_expr] = "await_start_expr",
  [sym_then_expr] = "then_expr",
  [sym_catch_expr] = "catch_expr",
  [sym_await_end_expr] = "await_end_expr",
  [sym_snippet_statement] = "snippet_statement",
  [sym_snippet_start_expr] = "snippet_start_expr",
  [sym_snippet_end_expr] = "snippet_end_expr",
  [sym_key_statement] = "key_statement",
  [sym_key_start_expr] = "key_start_expr",
  [sym_key_end_expr] = "key_end_expr",
  [aux_sym_document_repeat1] = "document_repeat1",
  [aux_sym_start_tag_repeat1] = "start_tag_repeat1",
  [alias_sym_then] = "then",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_SLASH_GT] = anon_sym_SLASH_GT,
  [anon_sym_LT_SLASH] = anon_sym_LT_SLASH,
  [anon_sym_EQ] = anon_sym_EQ,
  [aux_sym_attribute_name_token1] = aux_sym_attribute_name_token1,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_quoted_attribute_value_token1] = sym_attribute_value,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_quoted_attribute_value_token2] = sym_attribute_value,
  [aux_sym__text_token1] = aux_sym__text_token1,
  [anon_sym_LBRACE_RBRACE] = sym_expression,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_html] = anon_sym_html,
  [anon_sym_const] = anon_sym_html,
  [anon_sym_render] = anon_sym_html,
  [aux_sym_render_expr_token1] = aux_sym_render_expr_token1,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [aux_sym_render_expr_token2] = sym_raw_text_expr,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_debug] = anon_sym_html,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_if] = anon_sym_html,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_else] = anon_sym_html,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_each] = anon_sym_html,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_await] = anon_sym_html,
  [anon_sym_then] = anon_sym_html,
  [anon_sym_catch] = anon_sym_html,
  [anon_sym_snippet] = anon_sym_html,
  [anon_sym_key] = anon_sym_html,
  [sym__start_tag_name] = sym__start_tag_name,
  [sym__script_start_tag_name] = sym__start_tag_name,
  [sym__style_start_tag_name] = sym__start_tag_name,
  [sym__end_tag_name] = sym__start_tag_name,
  [sym_erroneous_end_tag_name] = sym_erroneous_end_tag_name,
  [sym__implicit_end_tag] = sym__implicit_end_tag,
  [sym_raw_text] = sym_raw_text,
  [sym_raw_text_expr] = sym_raw_text_expr,
  [sym_raw_text_await] = sym_raw_text_await,
  [sym_raw_text_each] = sym_raw_text_each,
  [sym_comment] = sym_comment,
  [sym_document] = sym_document,
  [sym__node] = sym__node,
  [sym__statement] = sym__statement,
  [sym_element] = sym_element,
  [sym_start_tag] = sym_start_tag,
  [sym_self_closing_tag] = sym_self_closing_tag,
  [sym_end_tag] = sym_end_tag,
  [sym_script_element] = sym_script_element,
  [sym_script_start_tag] = sym_start_tag,
  [sym_style_element] = sym_style_element,
  [sym_style_start_tag] = sym_start_tag,
  [sym_attribute] = sym_attribute,
  [sym_attribute_name] = sym_attribute_name,
  [sym_attribute_value] = sym_attribute_value,
  [sym_expr_attribute_value] = sym_expr_attribute_value,
  [sym_quoted_attribute_value] = sym_quoted_attribute_value,
  [sym__text] = sym__text,
  [sym__expression] = sym__expression,
  [sym_expression] = sym_expression,
  [sym_html_expr] = sym_html_expr,
  [sym_const_expr] = sym_const_expr,
  [sym_render_expr] = sym_render_expr,
  [sym_debug_expr] = sym_debug_expr,
  [sym_if_statement] = sym_if_statement,
  [sym_else_if_statement] = sym_else_if_statement,
  [sym_else_statement] = sym_else_statement,
  [sym_if_start_expr] = sym_if_start_expr,
  [sym_else_expr] = sym_else_expr,
  [sym_else_if_expr] = sym_else_if_expr,
  [sym_if_end_expr] = sym_if_end_expr,
  [sym_each_statement] = sym_each_statement,
  [sym_each_start_expr] = sym_each_start_expr,
  [sym_else_each_statement] = sym_else_each_statement,
  [sym_each_end_expr] = sym_each_end_expr,
  [sym_await_statement] = sym_await_statement,
  [sym_then_statement] = sym_then_statement,
  [sym_catch_statement] = sym_catch_statement,
  [sym_await_start_expr] = sym_await_start_expr,
  [sym_then_expr] = sym_then_expr,
  [sym_catch_expr] = sym_catch_expr,
  [sym_await_end_expr] = sym_await_end_expr,
  [sym_snippet_statement] = sym_snippet_statement,
  [sym_snippet_start_expr] = sym_snippet_start_expr,
  [sym_snippet_end_expr] = sym_snippet_end_expr,
  [sym_key_statement] = sym_key_statement,
  [sym_key_start_expr] = sym_key_start_expr,
  [sym_key_end_expr] = sym_key_end_expr,
  [aux_sym_document_repeat1] = aux_sym_document_repeat1,
  [aux_sym_start_tag_repeat1] = aux_sym_start_tag_repeat1,
  [alias_sym_then] = alias_sym_then,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_attribute_name_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_quoted_attribute_value_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_quoted_attribute_value_token2] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__text_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACE_RBRACE] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_html] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_render] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_render_expr_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_render_expr_token2] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_debug] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_each] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_then] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_snippet] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_key] = {
    .visible = true,
    .named = true,
  },
  [sym__start_tag_name] = {
    .visible = true,
    .named = true,
  },
  [sym__script_start_tag_name] = {
    .visible = true,
    .named = true,
  },
  [sym__style_start_tag_name] = {
    .visible = true,
    .named = true,
  },
  [sym__end_tag_name] = {
    .visible = true,
    .named = true,
  },
  [sym_erroneous_end_tag_name] = {
    .visible = true,
    .named = true,
  },
  [sym__implicit_end_tag] = {
    .visible = false,
    .named = true,
  },
  [sym_raw_text] = {
    .visible = true,
    .named = true,
  },
  [sym_raw_text_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_raw_text_await] = {
    .visible = true,
    .named = true,
  },
  [sym_raw_text_each] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_document] = {
    .visible = true,
    .named = true,
  },
  [sym__node] = {
    .visible = false,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym_element] = {
    .visible = true,
    .named = true,
  },
  [sym_start_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_self_closing_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_end_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_script_element] = {
    .visible = true,
    .named = true,
  },
  [sym_script_start_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_style_element] = {
    .visible = true,
    .named = true,
  },
  [sym_style_start_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_name] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_value] = {
    .visible = true,
    .named = true,
  },
  [sym_expr_attribute_value] = {
    .visible = true,
    .named = true,
  },
  [sym_quoted_attribute_value] = {
    .visible = true,
    .named = true,
  },
  [sym__text] = {
    .visible = false,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_html_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_const_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_render_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_debug_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_else_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_else_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_start_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_else_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_else_if_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_if_end_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_each_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_each_start_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_else_each_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_each_end_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_await_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_then_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_await_start_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_then_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_await_end_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_snippet_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_snippet_start_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_snippet_end_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_key_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_key_start_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_key_end_expr] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_document_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_start_tag_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_then] = {
    .visible = true,
    .named = true,
  },
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_attribute_name,
  },
  [2] = {
    [4] = alias_sym_then,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_expression, 2,
    sym_expression,
    sym_attribute_name,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 2,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 3,
  [9] = 6,
  [10] = 5,
  [11] = 11,
  [12] = 11,
  [13] = 7,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 15,
  [21] = 16,
  [22] = 17,
  [23] = 14,
  [24] = 19,
  [25] = 18,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 27,
  [32] = 32,
  [33] = 32,
  [34] = 28,
  [35] = 35,
  [36] = 36,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 39,
  [41] = 38,
  [42] = 42,
  [43] = 29,
  [44] = 42,
  [45] = 37,
  [46] = 36,
  [47] = 35,
  [48] = 26,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 49,
  [54] = 51,
  [55] = 50,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 52,
  [72] = 72,
  [73] = 73,
  [74] = 74,
  [75] = 75,
  [76] = 76,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 81,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 102,
  [103] = 103,
  [104] = 104,
  [105] = 105,
  [106] = 85,
  [107] = 93,
  [108] = 70,
  [109] = 78,
  [110] = 69,
  [111] = 105,
  [112] = 103,
  [113] = 100,
  [114] = 99,
  [115] = 98,
  [116] = 97,
  [117] = 96,
  [118] = 94,
  [119] = 91,
  [120] = 68,
  [121] = 90,
  [122] = 89,
  [123] = 67,
  [124] = 56,
  [125] = 88,
  [126] = 87,
  [127] = 66,
  [128] = 84,
  [129] = 83,
  [130] = 82,
  [131] = 57,
  [132] = 65,
  [133] = 64,
  [134] = 79,
  [135] = 76,
  [136] = 75,
  [137] = 74,
  [138] = 73,
  [139] = 72,
  [140] = 95,
  [141] = 63,
  [142] = 62,
  [143] = 80,
  [144] = 61,
  [145] = 86,
  [146] = 59,
  [147] = 81,
  [148] = 92,
  [149] = 149,
  [150] = 150,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 154,
  [155] = 155,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 166,
  [167] = 165,
  [168] = 168,
  [169] = 155,
  [170] = 170,
  [171] = 171,
  [172] = 150,
  [173] = 164,
  [174] = 174,
  [175] = 90,
  [176] = 176,
  [177] = 177,
  [178] = 178,
  [179] = 179,
  [180] = 180,
  [181] = 180,
  [182] = 182,
  [183] = 183,
  [184] = 184,
  [185] = 185,
  [186] = 151,
  [187] = 182,
  [188] = 188,
  [189] = 176,
  [190] = 190,
  [191] = 177,
  [192] = 152,
  [193] = 184,
  [194] = 194,
  [195] = 183,
  [196] = 196,
  [197] = 90,
  [198] = 179,
  [199] = 188,
  [200] = 185,
  [201] = 178,
  [202] = 190,
  [203] = 194,
  [204] = 204,
  [205] = 204,
  [206] = 196,
  [207] = 207,
  [208] = 208,
  [209] = 208,
  [210] = 207,
  [211] = 211,
  [212] = 212,
  [213] = 213,
  [214] = 214,
  [215] = 215,
  [216] = 216,
  [217] = 213,
  [218] = 215,
  [219] = 219,
  [220] = 220,
  [221] = 221,
  [222] = 222,
  [223] = 223,
  [224] = 224,
  [225] = 225,
  [226] = 216,
  [227] = 212,
  [228] = 228,
  [229] = 225,
  [230] = 230,
  [231] = 231,
  [232] = 232,
  [233] = 233,
  [234] = 234,
  [235] = 228,
  [236] = 230,
  [237] = 237,
  [238] = 238,
  [239] = 239,
  [240] = 240,
  [241] = 241,
  [242] = 242,
  [243] = 243,
  [244] = 244,
  [245] = 245,
  [246] = 246,
  [247] = 247,
  [248] = 248,
  [249] = 249,
  [250] = 250,
  [251] = 251,
  [252] = 252,
  [253] = 253,
  [254] = 254,
  [255] = 255,
  [256] = 256,
  [257] = 257,
  [258] = 258,
  [259] = 259,
  [260] = 260,
  [261] = 261,
  [262] = 262,
  [263] = 263,
  [264] = 264,
  [265] = 265,
  [266] = 266,
  [267] = 249,
  [268] = 250,
  [269] = 269,
  [270] = 270,
  [271] = 271,
  [272] = 272,
  [273] = 273,
  [274] = 274,
  [275] = 237,
  [276] = 262,
  [277] = 240,
  [278] = 253,
  [279] = 258,
  [280] = 265,
  [281] = 269,
  [282] = 282,
  [283] = 283,
  [284] = 284,
  [285] = 285,
  [286] = 286,
  [287] = 283,
  [288] = 250,
  [289] = 250,
  [290] = 290,
  [291] = 291,
  [292] = 292,
  [293] = 261,
  [294] = 238,
  [295] = 242,
  [296] = 256,
  [297] = 297,
  [298] = 263,
  [299] = 299,
  [300] = 266,
  [301] = 286,
  [302] = 302,
  [303] = 270,
  [304] = 273,
  [305] = 285,
  [306] = 302,
  [307] = 284,
  [308] = 274,
  [309] = 309,
  [310] = 310,
  [311] = 311,
  [312] = 271,
  [313] = 241,
};

static inline bool aux_sym_attribute_name_token1_character_set_1(int32_t c) {
  return (c < '\''
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\n')
      : (c <= '\r' || (c < '"'
        ? c == ' '
        : c <= '"')))
    : (c <= '\'' || (c < '{'
      ? (c < '<'
        ? c == '/'
        : c <= '>')
      : (c <= '{' || c == '}'))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(49);
      if (lookahead == '"') ADVANCE(59);
      if (lookahead == '#') ADVANCE(77);
      if (lookahead == '\'') ADVANCE(56);
      if (lookahead == '(') ADVANCE(72);
      if (lookahead == ')') ADVANCE(75);
      if (lookahead == '/') ADVANCE(82);
      if (lookahead == ':') ADVANCE(79);
      if (lookahead == '<') ADVANCE(50);
      if (lookahead == '=') ADVANCE(54);
      if (lookahead == '>') ADVANCE(51);
      if (lookahead == '@') ADVANCE(67);
      if (lookahead == 'a') ADVANCE(37);
      if (lookahead == 'c') ADVANCE(8);
      if (lookahead == 'd') ADVANCE(14);
      if (lookahead == 'e') ADVANCE(7);
      if (lookahead == 'h') ADVANCE(40);
      if (lookahead == 'i') ADVANCE(21);
      if (lookahead == 'k') ADVANCE(15);
      if (lookahead == 'r') ADVANCE(18);
      if (lookahead == 's') ADVANCE(30);
      if (lookahead == 't') ADVANCE(25);
      if (lookahead == '{') ADVANCE(65);
      if (lookahead == '}') ADVANCE(66);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == '"') ADVANCE(59);
      if (lookahead == '\'') ADVANCE(56);
      if (lookahead == '/') ADVANCE(6);
      if (lookahead == '=') ADVANCE(54);
      if (lookahead == '>') ADVANCE(51);
      if (lookahead == '{') ADVANCE(64);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(1)
      if (lookahead != 0 &&
          lookahead != '<' &&
          lookahead != '}') ADVANCE(55);
      END_STATE();
    case 2:
      if (lookahead == '"') ADVANCE(59);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(60);
      if (lookahead != 0) ADVANCE(61);
      END_STATE();
    case 3:
      if (lookahead == '#') ADVANCE(77);
      if (lookahead == '/') ADVANCE(81);
      if (lookahead == ':') ADVANCE(79);
      if (lookahead == '@') ADVANCE(67);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(71);
      END_STATE();
    case 4:
      if (lookahead == '\'') ADVANCE(56);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(57);
      if (lookahead != 0) ADVANCE(58);
      END_STATE();
    case 5:
      if (lookahead == ')') ADVANCE(75);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(73);
      if (lookahead != 0) ADVANCE(74);
      END_STATE();
    case 6:
      if (lookahead == '>') ADVANCE(52);
      END_STATE();
    case 7:
      if (lookahead == 'a') ADVANCE(11);
      if (lookahead == 'l') ADVANCE(38);
      END_STATE();
    case 8:
      if (lookahead == 'a') ADVANCE(44);
      if (lookahead == 'o') ADVANCE(33);
      END_STATE();
    case 9:
      if (lookahead == 'a') ADVANCE(27);
      END_STATE();
    case 10:
      if (lookahead == 'b') ADVANCE(45);
      END_STATE();
    case 11:
      if (lookahead == 'c') ADVANCE(23);
      END_STATE();
    case 12:
      if (lookahead == 'c') ADVANCE(24);
      END_STATE();
    case 13:
      if (lookahead == 'd') ADVANCE(17);
      END_STATE();
    case 14:
      if (lookahead == 'e') ADVANCE(10);
      END_STATE();
    case 15:
      if (lookahead == 'e') ADVANCE(46);
      END_STATE();
    case 16:
      if (lookahead == 'e') ADVANCE(80);
      END_STATE();
    case 17:
      if (lookahead == 'e') ADVANCE(36);
      END_STATE();
    case 18:
      if (lookahead == 'e') ADVANCE(31);
      END_STATE();
    case 19:
      if (lookahead == 'e') ADVANCE(32);
      END_STATE();
    case 20:
      if (lookahead == 'e') ADVANCE(43);
      END_STATE();
    case 21:
      if (lookahead == 'f') ADVANCE(78);
      END_STATE();
    case 22:
      if (lookahead == 'g') ADVANCE(76);
      END_STATE();
    case 23:
      if (lookahead == 'h') ADVANCE(83);
      END_STATE();
    case 24:
      if (lookahead == 'h') ADVANCE(87);
      END_STATE();
    case 25:
      if (lookahead == 'h') ADVANCE(19);
      END_STATE();
    case 26:
      if (lookahead == 'i') ADVANCE(34);
      END_STATE();
    case 27:
      if (lookahead == 'i') ADVANCE(41);
      END_STATE();
    case 28:
      if (lookahead == 'l') ADVANCE(68);
      END_STATE();
    case 29:
      if (lookahead == 'm') ADVANCE(28);
      END_STATE();
    case 30:
      if (lookahead == 'n') ADVANCE(26);
      END_STATE();
    case 31:
      if (lookahead == 'n') ADVANCE(13);
      END_STATE();
    case 32:
      if (lookahead == 'n') ADVANCE(86);
      END_STATE();
    case 33:
      if (lookahead == 'n') ADVANCE(39);
      END_STATE();
    case 34:
      if (lookahead == 'p') ADVANCE(35);
      END_STATE();
    case 35:
      if (lookahead == 'p') ADVANCE(20);
      END_STATE();
    case 36:
      if (lookahead == 'r') ADVANCE(70);
      END_STATE();
    case 37:
      if (lookahead == 's') ADVANCE(84);
      if (lookahead == 'w') ADVANCE(9);
      END_STATE();
    case 38:
      if (lookahead == 's') ADVANCE(16);
      END_STATE();
    case 39:
      if (lookahead == 's') ADVANCE(42);
      END_STATE();
    case 40:
      if (lookahead == 't') ADVANCE(29);
      END_STATE();
    case 41:
      if (lookahead == 't') ADVANCE(85);
      END_STATE();
    case 42:
      if (lookahead == 't') ADVANCE(69);
      END_STATE();
    case 43:
      if (lookahead == 't') ADVANCE(88);
      END_STATE();
    case 44:
      if (lookahead == 't') ADVANCE(12);
      END_STATE();
    case 45:
      if (lookahead == 'u') ADVANCE(22);
      END_STATE();
    case 46:
      if (lookahead == 'y') ADVANCE(89);
      END_STATE();
    case 47:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(47);
      if (lookahead != 0 &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(62);
      END_STATE();
    case 48:
      if (eof) ADVANCE(49);
      if (lookahead == '<') ADVANCE(50);
      if (lookahead == '{') ADVANCE(65);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(48)
      if (lookahead != 0 &&
          lookahead != '>' &&
          lookahead != '}') ADVANCE(62);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '/') ADVANCE(53);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_SLASH_GT);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_LT_SLASH);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(aux_sym_attribute_name_token1);
      if (!aux_sym_attribute_name_token1_character_set_1(lookahead)) ADVANCE(55);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(aux_sym_quoted_attribute_value_token1);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(57);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(58);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(aux_sym_quoted_attribute_value_token1);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(58);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(aux_sym_quoted_attribute_value_token2);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(60);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(61);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(aux_sym_quoted_attribute_value_token2);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(61);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(aux_sym__text_token1);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(47);
      if (lookahead != 0 &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(62);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_LBRACE_RBRACE);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      if (lookahead == '}') ADVANCE(63);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_html);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_render);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(aux_sym_render_expr_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(71);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(aux_sym_render_expr_token2);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(73);
      if (lookahead != 0 &&
          lookahead != ')') ADVANCE(74);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(aux_sym_render_expr_token2);
      if (lookahead != 0 &&
          lookahead != ')') ADVANCE(74);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_debug);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '>') ADVANCE(52);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_each);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_as);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_then);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_snippet);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_key);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 48, .external_lex_state = 2},
  [2] = {.lex_state = 48, .external_lex_state = 2},
  [3] = {.lex_state = 48, .external_lex_state = 2},
  [4] = {.lex_state = 48, .external_lex_state = 2},
  [5] = {.lex_state = 48, .external_lex_state = 2},
  [6] = {.lex_state = 48, .external_lex_state = 2},
  [7] = {.lex_state = 48, .external_lex_state = 2},
  [8] = {.lex_state = 48, .external_lex_state = 2},
  [9] = {.lex_state = 48, .external_lex_state = 2},
  [10] = {.lex_state = 48, .external_lex_state = 2},
  [11] = {.lex_state = 48, .external_lex_state = 2},
  [12] = {.lex_state = 48, .external_lex_state = 2},
  [13] = {.lex_state = 48, .external_lex_state = 2},
  [14] = {.lex_state = 48, .external_lex_state = 2},
  [15] = {.lex_state = 48, .external_lex_state = 2},
  [16] = {.lex_state = 48, .external_lex_state = 2},
  [17] = {.lex_state = 48, .external_lex_state = 3},
  [18] = {.lex_state = 48, .external_lex_state = 3},
  [19] = {.lex_state = 48, .external_lex_state = 2},
  [20] = {.lex_state = 48, .external_lex_state = 2},
  [21] = {.lex_state = 48, .external_lex_state = 2},
  [22] = {.lex_state = 48, .external_lex_state = 3},
  [23] = {.lex_state = 48, .external_lex_state = 2},
  [24] = {.lex_state = 48, .external_lex_state = 2},
  [25] = {.lex_state = 48, .external_lex_state = 3},
  [26] = {.lex_state = 48, .external_lex_state = 3},
  [27] = {.lex_state = 48, .external_lex_state = 2},
  [28] = {.lex_state = 48, .external_lex_state = 2},
  [29] = {.lex_state = 48, .external_lex_state = 2},
  [30] = {.lex_state = 48, .external_lex_state = 2},
  [31] = {.lex_state = 48, .external_lex_state = 2},
  [32] = {.lex_state = 48, .external_lex_state = 2},
  [33] = {.lex_state = 48, .external_lex_state = 2},
  [34] = {.lex_state = 48, .external_lex_state = 2},
  [35] = {.lex_state = 48, .external_lex_state = 2},
  [36] = {.lex_state = 48, .external_lex_state = 2},
  [37] = {.lex_state = 48, .external_lex_state = 2},
  [38] = {.lex_state = 48, .external_lex_state = 2},
  [39] = {.lex_state = 48, .external_lex_state = 2},
  [40] = {.lex_state = 48, .external_lex_state = 2},
  [41] = {.lex_state = 48, .external_lex_state = 2},
  [42] = {.lex_state = 48, .external_lex_state = 2},
  [43] = {.lex_state = 48, .external_lex_state = 2},
  [44] = {.lex_state = 48, .external_lex_state = 2},
  [45] = {.lex_state = 48, .external_lex_state = 2},
  [46] = {.lex_state = 48, .external_lex_state = 2},
  [47] = {.lex_state = 48, .external_lex_state = 2},
  [48] = {.lex_state = 48, .external_lex_state = 2},
  [49] = {.lex_state = 1, .external_lex_state = 4},
  [50] = {.lex_state = 1, .external_lex_state = 4},
  [51] = {.lex_state = 1},
  [52] = {.lex_state = 1, .external_lex_state = 4},
  [53] = {.lex_state = 1, .external_lex_state = 4},
  [54] = {.lex_state = 1},
  [55] = {.lex_state = 1, .external_lex_state = 4},
  [56] = {.lex_state = 48, .external_lex_state = 3},
  [57] = {.lex_state = 48, .external_lex_state = 3},
  [58] = {.lex_state = 1},
  [59] = {.lex_state = 48, .external_lex_state = 3},
  [60] = {.lex_state = 1},
  [61] = {.lex_state = 48, .external_lex_state = 3},
  [62] = {.lex_state = 48, .external_lex_state = 3},
  [63] = {.lex_state = 48, .external_lex_state = 3},
  [64] = {.lex_state = 48, .external_lex_state = 3},
  [65] = {.lex_state = 48, .external_lex_state = 3},
  [66] = {.lex_state = 48, .external_lex_state = 3},
  [67] = {.lex_state = 48, .external_lex_state = 3},
  [68] = {.lex_state = 48, .external_lex_state = 3},
  [69] = {.lex_state = 48, .external_lex_state = 3},
  [70] = {.lex_state = 48, .external_lex_state = 3},
  [71] = {.lex_state = 1},
  [72] = {.lex_state = 48, .external_lex_state = 3},
  [73] = {.lex_state = 48, .external_lex_state = 3},
  [74] = {.lex_state = 48, .external_lex_state = 3},
  [75] = {.lex_state = 48, .external_lex_state = 3},
  [76] = {.lex_state = 48, .external_lex_state = 3},
  [77] = {.lex_state = 1},
  [78] = {.lex_state = 48, .external_lex_state = 3},
  [79] = {.lex_state = 48, .external_lex_state = 3},
  [80] = {.lex_state = 48, .external_lex_state = 3},
  [81] = {.lex_state = 48, .external_lex_state = 3},
  [82] = {.lex_state = 48, .external_lex_state = 3},
  [83] = {.lex_state = 48, .external_lex_state = 3},
  [84] = {.lex_state = 48, .external_lex_state = 3},
  [85] = {.lex_state = 48, .external_lex_state = 3},
  [86] = {.lex_state = 48, .external_lex_state = 3},
  [87] = {.lex_state = 48, .external_lex_state = 3},
  [88] = {.lex_state = 48, .external_lex_state = 3},
  [89] = {.lex_state = 48, .external_lex_state = 3},
  [90] = {.lex_state = 48, .external_lex_state = 3},
  [91] = {.lex_state = 48, .external_lex_state = 3},
  [92] = {.lex_state = 48, .external_lex_state = 3},
  [93] = {.lex_state = 48, .external_lex_state = 3},
  [94] = {.lex_state = 48, .external_lex_state = 3},
  [95] = {.lex_state = 48, .external_lex_state = 3},
  [96] = {.lex_state = 48, .external_lex_state = 3},
  [97] = {.lex_state = 48, .external_lex_state = 3},
  [98] = {.lex_state = 48, .external_lex_state = 3},
  [99] = {.lex_state = 48, .external_lex_state = 3},
  [100] = {.lex_state = 48, .external_lex_state = 3},
  [101] = {.lex_state = 48, .external_lex_state = 3},
  [102] = {.lex_state = 48, .external_lex_state = 3},
  [103] = {.lex_state = 48, .external_lex_state = 3},
  [104] = {.lex_state = 1},
  [105] = {.lex_state = 48, .external_lex_state = 3},
  [106] = {.lex_state = 48, .external_lex_state = 2},
  [107] = {.lex_state = 48, .external_lex_state = 2},
  [108] = {.lex_state = 48, .external_lex_state = 2},
  [109] = {.lex_state = 48, .external_lex_state = 2},
  [110] = {.lex_state = 48, .external_lex_state = 2},
  [111] = {.lex_state = 48, .external_lex_state = 2},
  [112] = {.lex_state = 48, .external_lex_state = 2},
  [113] = {.lex_state = 48, .external_lex_state = 2},
  [114] = {.lex_state = 48, .external_lex_state = 2},
  [115] = {.lex_state = 48, .external_lex_state = 2},
  [116] = {.lex_state = 48, .external_lex_state = 2},
  [117] = {.lex_state = 48, .external_lex_state = 2},
  [118] = {.lex_state = 48, .external_lex_state = 2},
  [119] = {.lex_state = 48, .external_lex_state = 2},
  [120] = {.lex_state = 48, .external_lex_state = 2},
  [121] = {.lex_state = 48, .external_lex_state = 2},
  [122] = {.lex_state = 48, .external_lex_state = 2},
  [123] = {.lex_state = 48, .external_lex_state = 2},
  [124] = {.lex_state = 48, .external_lex_state = 2},
  [125] = {.lex_state = 48, .external_lex_state = 2},
  [126] = {.lex_state = 48, .external_lex_state = 2},
  [127] = {.lex_state = 48, .external_lex_state = 2},
  [128] = {.lex_state = 48, .external_lex_state = 2},
  [129] = {.lex_state = 48, .external_lex_state = 2},
  [130] = {.lex_state = 48, .external_lex_state = 2},
  [131] = {.lex_state = 48, .external_lex_state = 2},
  [132] = {.lex_state = 48, .external_lex_state = 2},
  [133] = {.lex_state = 48, .external_lex_state = 2},
  [134] = {.lex_state = 48, .external_lex_state = 2},
  [135] = {.lex_state = 48, .external_lex_state = 2},
  [136] = {.lex_state = 48, .external_lex_state = 2},
  [137] = {.lex_state = 48, .external_lex_state = 2},
  [138] = {.lex_state = 48, .external_lex_state = 2},
  [139] = {.lex_state = 48, .external_lex_state = 2},
  [140] = {.lex_state = 48, .external_lex_state = 2},
  [141] = {.lex_state = 48, .external_lex_state = 2},
  [142] = {.lex_state = 48, .external_lex_state = 2},
  [143] = {.lex_state = 48, .external_lex_state = 2},
  [144] = {.lex_state = 48, .external_lex_state = 2},
  [145] = {.lex_state = 48, .external_lex_state = 2},
  [146] = {.lex_state = 48, .external_lex_state = 2},
  [147] = {.lex_state = 48, .external_lex_state = 2},
  [148] = {.lex_state = 48, .external_lex_state = 2},
  [149] = {.lex_state = 48, .external_lex_state = 2},
  [150] = {.lex_state = 3, .external_lex_state = 5},
  [151] = {.lex_state = 1, .external_lex_state = 4},
  [152] = {.lex_state = 1, .external_lex_state = 4},
  [153] = {.lex_state = 48, .external_lex_state = 2},
  [154] = {.lex_state = 48, .external_lex_state = 2},
  [155] = {.lex_state = 3, .external_lex_state = 5},
  [156] = {.lex_state = 48, .external_lex_state = 2},
  [157] = {.lex_state = 0},
  [158] = {.lex_state = 48, .external_lex_state = 2},
  [159] = {.lex_state = 48, .external_lex_state = 2},
  [160] = {.lex_state = 48, .external_lex_state = 2},
  [161] = {.lex_state = 48, .external_lex_state = 2},
  [162] = {.lex_state = 48, .external_lex_state = 2},
  [163] = {.lex_state = 48, .external_lex_state = 2},
  [164] = {.lex_state = 3, .external_lex_state = 5},
  [165] = {.lex_state = 3, .external_lex_state = 5},
  [166] = {.lex_state = 48, .external_lex_state = 2},
  [167] = {.lex_state = 3, .external_lex_state = 5},
  [168] = {.lex_state = 48, .external_lex_state = 2},
  [169] = {.lex_state = 3, .external_lex_state = 5},
  [170] = {.lex_state = 48, .external_lex_state = 2},
  [171] = {.lex_state = 48, .external_lex_state = 2},
  [172] = {.lex_state = 3, .external_lex_state = 5},
  [173] = {.lex_state = 3, .external_lex_state = 5},
  [174] = {.lex_state = 48, .external_lex_state = 2},
  [175] = {.lex_state = 1, .external_lex_state = 4},
  [176] = {.lex_state = 0},
  [177] = {.lex_state = 3, .external_lex_state = 5},
  [178] = {.lex_state = 1, .external_lex_state = 4},
  [179] = {.lex_state = 1, .external_lex_state = 4},
  [180] = {.lex_state = 3, .external_lex_state = 5},
  [181] = {.lex_state = 3, .external_lex_state = 5},
  [182] = {.lex_state = 3, .external_lex_state = 5},
  [183] = {.lex_state = 3, .external_lex_state = 5},
  [184] = {.lex_state = 3, .external_lex_state = 5},
  [185] = {.lex_state = 1, .external_lex_state = 4},
  [186] = {.lex_state = 1},
  [187] = {.lex_state = 3, .external_lex_state = 5},
  [188] = {.lex_state = 1, .external_lex_state = 4},
  [189] = {.lex_state = 0},
  [190] = {.lex_state = 1, .external_lex_state = 4},
  [191] = {.lex_state = 3, .external_lex_state = 5},
  [192] = {.lex_state = 1},
  [193] = {.lex_state = 3, .external_lex_state = 5},
  [194] = {.lex_state = 1, .external_lex_state = 4},
  [195] = {.lex_state = 3, .external_lex_state = 5},
  [196] = {.lex_state = 0, .external_lex_state = 6},
  [197] = {.lex_state = 1},
  [198] = {.lex_state = 1},
  [199] = {.lex_state = 1},
  [200] = {.lex_state = 1},
  [201] = {.lex_state = 1},
  [202] = {.lex_state = 1},
  [203] = {.lex_state = 1},
  [204] = {.lex_state = 0, .external_lex_state = 6},
  [205] = {.lex_state = 0, .external_lex_state = 6},
  [206] = {.lex_state = 0, .external_lex_state = 6},
  [207] = {.lex_state = 0, .external_lex_state = 5},
  [208] = {.lex_state = 0, .external_lex_state = 7},
  [209] = {.lex_state = 0, .external_lex_state = 7},
  [210] = {.lex_state = 0, .external_lex_state = 5},
  [211] = {.lex_state = 0, .external_lex_state = 5},
  [212] = {.lex_state = 4},
  [213] = {.lex_state = 0},
  [214] = {.lex_state = 0, .external_lex_state = 5},
  [215] = {.lex_state = 0},
  [216] = {.lex_state = 2},
  [217] = {.lex_state = 0},
  [218] = {.lex_state = 0},
  [219] = {.lex_state = 0, .external_lex_state = 6},
  [220] = {.lex_state = 0, .external_lex_state = 8},
  [221] = {.lex_state = 0, .external_lex_state = 9},
  [222] = {.lex_state = 0, .external_lex_state = 6},
  [223] = {.lex_state = 0},
  [224] = {.lex_state = 0},
  [225] = {.lex_state = 0, .external_lex_state = 5},
  [226] = {.lex_state = 2},
  [227] = {.lex_state = 4},
  [228] = {.lex_state = 0, .external_lex_state = 5},
  [229] = {.lex_state = 0, .external_lex_state = 5},
  [230] = {.lex_state = 5},
  [231] = {.lex_state = 0, .external_lex_state = 6},
  [232] = {.lex_state = 0, .external_lex_state = 6},
  [233] = {.lex_state = 0, .external_lex_state = 5},
  [234] = {.lex_state = 5},
  [235] = {.lex_state = 0, .external_lex_state = 5},
  [236] = {.lex_state = 5},
  [237] = {.lex_state = 0},
  [238] = {.lex_state = 0, .external_lex_state = 5},
  [239] = {.lex_state = 0, .external_lex_state = 5},
  [240] = {.lex_state = 0},
  [241] = {.lex_state = 3},
  [242] = {.lex_state = 0, .external_lex_state = 5},
  [243] = {.lex_state = 0, .external_lex_state = 5},
  [244] = {.lex_state = 0},
  [245] = {.lex_state = 3},
  [246] = {.lex_state = 0},
  [247] = {.lex_state = 0, .external_lex_state = 5},
  [248] = {.lex_state = 0},
  [249] = {.lex_state = 0},
  [250] = {.lex_state = 0},
  [251] = {.lex_state = 0},
  [252] = {.lex_state = 0},
  [253] = {.lex_state = 0},
  [254] = {.lex_state = 0},
  [255] = {.lex_state = 0},
  [256] = {.lex_state = 0},
  [257] = {.lex_state = 0},
  [258] = {.lex_state = 0},
  [259] = {.lex_state = 0},
  [260] = {.lex_state = 0},
  [261] = {.lex_state = 0, .external_lex_state = 10},
  [262] = {.lex_state = 0},
  [263] = {.lex_state = 0},
  [264] = {.lex_state = 0},
  [265] = {.lex_state = 0},
  [266] = {.lex_state = 0},
  [267] = {.lex_state = 0},
  [268] = {.lex_state = 0},
  [269] = {.lex_state = 0},
  [270] = {.lex_state = 0},
  [271] = {.lex_state = 0},
  [272] = {.lex_state = 0},
  [273] = {.lex_state = 0},
  [274] = {.lex_state = 0},
  [275] = {.lex_state = 0},
  [276] = {.lex_state = 0},
  [277] = {.lex_state = 0},
  [278] = {.lex_state = 0},
  [279] = {.lex_state = 0},
  [280] = {.lex_state = 0},
  [281] = {.lex_state = 0},
  [282] = {.lex_state = 0},
  [283] = {.lex_state = 0},
  [284] = {.lex_state = 0},
  [285] = {.lex_state = 0},
  [286] = {.lex_state = 0},
  [287] = {.lex_state = 0},
  [288] = {.lex_state = 0},
  [289] = {.lex_state = 0},
  [290] = {.lex_state = 0},
  [291] = {.lex_state = 0},
  [292] = {.lex_state = 0},
  [293] = {.lex_state = 0, .external_lex_state = 10},
  [294] = {.lex_state = 0, .external_lex_state = 5},
  [295] = {.lex_state = 0, .external_lex_state = 5},
  [296] = {.lex_state = 0},
  [297] = {.lex_state = 0},
  [298] = {.lex_state = 0},
  [299] = {.lex_state = 0},
  [300] = {.lex_state = 0},
  [301] = {.lex_state = 0},
  [302] = {.lex_state = 0},
  [303] = {.lex_state = 0},
  [304] = {.lex_state = 0},
  [305] = {.lex_state = 0},
  [306] = {.lex_state = 0},
  [307] = {.lex_state = 0},
  [308] = {.lex_state = 0},
  [309] = {.lex_state = 0},
  [310] = {.lex_state = 0},
  [311] = {.lex_state = 0, .external_lex_state = 5},
  [312] = {.lex_state = 0},
  [313] = {.lex_state = 3},
};

enum {
  ts_external_token__start_tag_name = 0,
  ts_external_token__script_start_tag_name = 1,
  ts_external_token__style_start_tag_name = 2,
  ts_external_token__end_tag_name = 3,
  ts_external_token_erroneous_end_tag_name = 4,
  ts_external_token_SLASH_GT = 5,
  ts_external_token__implicit_end_tag = 6,
  ts_external_token_raw_text = 7,
  ts_external_token_raw_text_expr = 8,
  ts_external_token_raw_text_await = 9,
  ts_external_token_raw_text_each = 10,
  ts_external_token_comment = 11,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__start_tag_name] = sym__start_tag_name,
  [ts_external_token__script_start_tag_name] = sym__script_start_tag_name,
  [ts_external_token__style_start_tag_name] = sym__style_start_tag_name,
  [ts_external_token__end_tag_name] = sym__end_tag_name,
  [ts_external_token_erroneous_end_tag_name] = sym_erroneous_end_tag_name,
  [ts_external_token_SLASH_GT] = anon_sym_SLASH_GT,
  [ts_external_token__implicit_end_tag] = sym__implicit_end_tag,
  [ts_external_token_raw_text] = sym_raw_text,
  [ts_external_token_raw_text_expr] = sym_raw_text_expr,
  [ts_external_token_raw_text_await] = sym_raw_text_await,
  [ts_external_token_raw_text_each] = sym_raw_text_each,
  [ts_external_token_comment] = sym_comment,
};

static const bool ts_external_scanner_states[11][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__start_tag_name] = true,
    [ts_external_token__script_start_tag_name] = true,
    [ts_external_token__style_start_tag_name] = true,
    [ts_external_token__end_tag_name] = true,
    [ts_external_token_erroneous_end_tag_name] = true,
    [ts_external_token_SLASH_GT] = true,
    [ts_external_token__implicit_end_tag] = true,
    [ts_external_token_raw_text] = true,
    [ts_external_token_raw_text_expr] = true,
    [ts_external_token_raw_text_await] = true,
    [ts_external_token_raw_text_each] = true,
    [ts_external_token_comment] = true,
  },
  [2] = {
    [ts_external_token_comment] = true,
  },
  [3] = {
    [ts_external_token__implicit_end_tag] = true,
    [ts_external_token_comment] = true,
  },
  [4] = {
    [ts_external_token_SLASH_GT] = true,
  },
  [5] = {
    [ts_external_token_raw_text_expr] = true,
  },
  [6] = {
    [ts_external_token_raw_text] = true,
  },
  [7] = {
    [ts_external_token__start_tag_name] = true,
    [ts_external_token__script_start_tag_name] = true,
    [ts_external_token__style_start_tag_name] = true,
  },
  [8] = {
    [ts_external_token_raw_text_expr] = true,
    [ts_external_token_raw_text_await] = true,
  },
  [9] = {
    [ts_external_token_raw_text_expr] = true,
    [ts_external_token_raw_text_each] = true,
  },
  [10] = {
    [ts_external_token__end_tag_name] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_SLASH_GT] = ACTIONS(1),
    [anon_sym_LT_SLASH] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_LBRACE_RBRACE] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_html] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_render] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_debug] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_each] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_await] = ACTIONS(1),
    [anon_sym_then] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_snippet] = ACTIONS(1),
    [anon_sym_key] = ACTIONS(1),
    [sym__start_tag_name] = ACTIONS(1),
    [sym__script_start_tag_name] = ACTIONS(1),
    [sym__style_start_tag_name] = ACTIONS(1),
    [sym__end_tag_name] = ACTIONS(1),
    [sym_erroneous_end_tag_name] = ACTIONS(1),
    [sym__implicit_end_tag] = ACTIONS(1),
    [sym_raw_text] = ACTIONS(1),
    [sym_raw_text_expr] = ACTIONS(1),
    [sym_raw_text_await] = ACTIONS(1),
    [sym_raw_text_each] = ACTIONS(1),
    [sym_comment] = ACTIONS(1),
  },
  [1] = {
    [sym_document] = STATE(272),
    [sym__node] = STATE(30),
    [sym__statement] = STATE(30),
    [sym_element] = STATE(30),
    [sym_start_tag] = STATE(18),
    [sym_self_closing_tag] = STATE(109),
    [sym_script_element] = STATE(30),
    [sym_script_start_tag] = STATE(204),
    [sym_style_element] = STATE(30),
    [sym_style_start_tag] = STATE(196),
    [sym__text] = STATE(30),
    [sym__expression] = STATE(30),
    [sym_expression] = STATE(30),
    [sym_html_expr] = STATE(30),
    [sym_const_expr] = STATE(30),
    [sym_render_expr] = STATE(30),
    [sym_debug_expr] = STATE(30),
    [sym_if_statement] = STATE(30),
    [sym_if_start_expr] = STATE(9),
    [sym_each_statement] = STATE(30),
    [sym_each_start_expr] = STATE(16),
    [sym_await_statement] = STATE(30),
    [sym_await_start_expr] = STATE(10),
    [sym_snippet_statement] = STATE(30),
    [sym_snippet_start_expr] = STATE(42),
    [sym_key_statement] = STATE(30),
    [sym_key_start_expr] = STATE(29),
    [aux_sym_document_repeat1] = STATE(30),
    [ts_builtin_sym_end] = ACTIONS(3),
    [anon_sym_LT] = ACTIONS(5),
    [aux_sym__text_token1] = ACTIONS(7),
    [anon_sym_LBRACE_RBRACE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(9),
    [sym_comment] = ACTIONS(7),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 16,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    STATE(2), 1,
      sym_else_if_expr,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(10), 1,
      sym_await_start_expr,
    STATE(16), 1,
      sym_each_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(29), 1,
      sym_key_start_expr,
    STATE(39), 1,
      sym_else_expr,
    STATE(42), 1,
      sym_snippet_start_expr,
    STATE(109), 1,
      sym_self_closing_tag,
    STATE(196), 1,
      sym_style_start_tag,
    STATE(204), 1,
      sym_script_start_tag,
    ACTIONS(11), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(84), 3,
      sym_else_if_statement,
      sym_else_statement,
      sym_if_end_expr,
    STATE(7), 18,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_const_expr,
      sym_render_expr,
      sym_debug_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_snippet_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [70] = 16,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(10), 1,
      sym_await_start_expr,
    STATE(16), 1,
      sym_each_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(23), 1,
      sym_then_expr,
    STATE(29), 1,
      sym_key_start_expr,
    STATE(37), 1,
      sym_catch_expr,
    STATE(42), 1,
      sym_snippet_start_expr,
    STATE(109), 1,
      sym_self_closing_tag,
    STATE(196), 1,
      sym_style_start_tag,
    STATE(204), 1,
      sym_script_start_tag,
    ACTIONS(15), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(75), 3,
      sym_then_statement,
      sym_catch_statement,
      sym_await_end_expr,
    STATE(48), 18,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_const_expr,
      sym_render_expr,
      sym_debug_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_snippet_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [140] = 16,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    STATE(4), 1,
      sym_else_if_expr,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(10), 1,
      sym_await_start_expr,
    STATE(16), 1,
      sym_each_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(29), 1,
      sym_key_start_expr,
    STATE(40), 1,
      sym_else_expr,
    STATE(42), 1,
      sym_snippet_start_expr,
    STATE(109), 1,
      sym_self_closing_tag,
    STATE(196), 1,
      sym_style_start_tag,
    STATE(204), 1,
      sym_script_start_tag,
    ACTIONS(19), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(128), 3,
      sym_else_if_statement,
      sym_else_statement,
      sym_if_end_expr,
    STATE(13), 18,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_const_expr,
      sym_render_expr,
      sym_debug_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_snippet_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [210] = 16,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(10), 1,
      sym_await_start_expr,
    STATE(16), 1,
      sym_each_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(23), 1,
      sym_then_expr,
    STATE(29), 1,
      sym_key_start_expr,
    STATE(37), 1,
      sym_catch_expr,
    STATE(42), 1,
      sym_snippet_start_expr,
    STATE(109), 1,
      sym_self_closing_tag,
    STATE(196), 1,
      sym_style_start_tag,
    STATE(204), 1,
      sym_script_start_tag,
    ACTIONS(23), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(97), 3,
      sym_then_statement,
      sym_catch_statement,
      sym_await_end_expr,
    STATE(3), 18,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_const_expr,
      sym_render_expr,
      sym_debug_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_snippet_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [280] = 16,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    STATE(2), 1,
      sym_else_if_expr,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(10), 1,
      sym_await_start_expr,
    STATE(16), 1,
      sym_each_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(29), 1,
      sym_key_start_expr,
    STATE(39), 1,
      sym_else_expr,
    STATE(42), 1,
      sym_snippet_start_expr,
    STATE(109), 1,
      sym_self_closing_tag,
    STATE(196), 1,
      sym_style_start_tag,
    STATE(204), 1,
      sym_script_start_tag,
    ACTIONS(25), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(99), 3,
      sym_else_if_statement,
      sym_else_statement,
      sym_if_end_expr,
    STATE(12), 18,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_const_expr,
      sym_render_expr,
      sym_debug_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_snippet_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [350] = 16,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    STATE(2), 1,
      sym_else_if_expr,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(10), 1,
      sym_await_start_expr,
    STATE(16), 1,
      sym_each_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(29), 1,
      sym_key_start_expr,
    STATE(39), 1,
      sym_else_expr,
    STATE(42), 1,
      sym_snippet_start_expr,
    STATE(109), 1,
      sym_self_closing_tag,
    STATE(196), 1,
      sym_style_start_tag,
    STATE(204), 1,
      sym_script_start_tag,
    ACTIONS(15), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(56), 3,
      sym_else_if_statement,
      sym_else_statement,
      sym_if_end_expr,
    STATE(48), 18,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_const_expr,
      sym_render_expr,
      sym_debug_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_snippet_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [420] = 16,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(10), 1,
      sym_await_start_expr,
    STATE(14), 1,
      sym_then_expr,
    STATE(16), 1,
      sym_each_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(29), 1,
      sym_key_start_expr,
    STATE(42), 1,
      sym_snippet_start_expr,
    STATE(45), 1,
      sym_catch_expr,
    STATE(109), 1,
      sym_self_closing_tag,
    STATE(196), 1,
      sym_style_start_tag,
    STATE(204), 1,
      sym_script_start_tag,
    ACTIONS(15), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(136), 3,
      sym_then_statement,
      sym_catch_statement,
      sym_await_end_expr,
    STATE(48), 18,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_const_expr,
      sym_render_expr,
      sym_debug_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_snippet_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [490] = 16,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    STATE(4), 1,
      sym_else_if_expr,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(10), 1,
      sym_await_start_expr,
    STATE(16), 1,
      sym_each_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(29), 1,
      sym_key_start_expr,
    STATE(40), 1,
      sym_else_expr,
    STATE(42), 1,
      sym_snippet_start_expr,
    STATE(109), 1,
      sym_self_closing_tag,
    STATE(196), 1,
      sym_style_start_tag,
    STATE(204), 1,
      sym_script_start_tag,
    ACTIONS(29), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(114), 3,
      sym_else_if_statement,
      sym_else_statement,
      sym_if_end_expr,
    STATE(11), 18,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_const_expr,
      sym_render_expr,
      sym_debug_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_snippet_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [560] = 16,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(10), 1,
      sym_await_start_expr,
    STATE(14), 1,
      sym_then_expr,
    STATE(16), 1,
      sym_each_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(29), 1,
      sym_key_start_expr,
    STATE(42), 1,
      sym_snippet_start_expr,
    STATE(45), 1,
      sym_catch_expr,
    STATE(109), 1,
      sym_self_closing_tag,
    STATE(196), 1,
      sym_style_start_tag,
    STATE(204), 1,
      sym_script_start_tag,
    ACTIONS(31), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(116), 3,
      sym_then_statement,
      sym_catch_statement,
      sym_await_end_expr,
    STATE(8), 18,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_const_expr,
      sym_render_expr,
      sym_debug_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_snippet_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [630] = 16,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    STATE(4), 1,
      sym_else_if_expr,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(10), 1,
      sym_await_start_expr,
    STATE(16), 1,
      sym_each_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(29), 1,
      sym_key_start_expr,
    STATE(40), 1,
      sym_else_expr,
    STATE(42), 1,
      sym_snippet_start_expr,
    STATE(109), 1,
      sym_self_closing_tag,
    STATE(196), 1,
      sym_style_start_tag,
    STATE(204), 1,
      sym_script_start_tag,
    ACTIONS(15), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(129), 3,
      sym_else_if_statement,
      sym_else_statement,
      sym_if_end_expr,
    STATE(48), 18,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_const_expr,
      sym_render_expr,
      sym_debug_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_snippet_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [700] = 16,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    STATE(2), 1,
      sym_else_if_expr,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(10), 1,
      sym_await_start_expr,
    STATE(16), 1,
      sym_each_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(29), 1,
      sym_key_start_expr,
    STATE(39), 1,
      sym_else_expr,
    STATE(42), 1,
      sym_snippet_start_expr,
    STATE(109), 1,
      sym_self_closing_tag,
    STATE(196), 1,
      sym_style_start_tag,
    STATE(204), 1,
      sym_script_start_tag,
    ACTIONS(15), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(83), 3,
      sym_else_if_statement,
      sym_else_statement,
      sym_if_end_expr,
    STATE(48), 18,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_const_expr,
      sym_render_expr,
      sym_debug_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_snippet_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [770] = 16,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    STATE(4), 1,
      sym_else_if_expr,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(10), 1,
      sym_await_start_expr,
    STATE(16), 1,
      sym_each_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(29), 1,
      sym_key_start_expr,
    STATE(40), 1,
      sym_else_expr,
    STATE(42), 1,
      sym_snippet_start_expr,
    STATE(109), 1,
      sym_self_closing_tag,
    STATE(196), 1,
      sym_style_start_tag,
    STATE(204), 1,
      sym_script_start_tag,
    ACTIONS(15), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(124), 3,
      sym_else_if_statement,
      sym_else_statement,
      sym_if_end_expr,
    STATE(48), 18,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_const_expr,
      sym_render_expr,
      sym_debug_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_snippet_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [840] = 15,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(10), 1,
      sym_await_start_expr,
    STATE(16), 1,
      sym_each_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(29), 1,
      sym_key_start_expr,
    STATE(42), 1,
      sym_snippet_start_expr,
    STATE(45), 1,
      sym_catch_expr,
    STATE(109), 1,
      sym_self_closing_tag,
    STATE(196), 1,
      sym_style_start_tag,
    STATE(204), 1,
      sym_script_start_tag,
    STATE(134), 2,
      sym_catch_statement,
      sym_await_end_expr,
    ACTIONS(33), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(15), 18,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_const_expr,
      sym_render_expr,
      sym_debug_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_snippet_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [906] = 15,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(10), 1,
      sym_await_start_expr,
    STATE(16), 1,
      sym_each_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(29), 1,
      sym_key_start_expr,
    STATE(42), 1,
      sym_snippet_start_expr,
    STATE(45), 1,
      sym_catch_expr,
    STATE(109), 1,
      sym_self_closing_tag,
    STATE(196), 1,
      sym_style_start_tag,
    STATE(204), 1,
      sym_script_start_tag,
    STATE(132), 2,
      sym_catch_statement,
      sym_await_end_expr,
    ACTIONS(15), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(48), 18,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_const_expr,
      sym_render_expr,
      sym_debug_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_snippet_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [972] = 15,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(10), 1,
      sym_await_start_expr,
    STATE(16), 1,
      sym_each_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(29), 1,
      sym_key_start_expr,
    STATE(41), 1,
      sym_else_expr,
    STATE(42), 1,
      sym_snippet_start_expr,
    STATE(109), 1,
      sym_self_closing_tag,
    STATE(196), 1,
      sym_style_start_tag,
    STATE(204), 1,
      sym_script_start_tag,
    STATE(115), 2,
      sym_else_each_statement,
      sym_each_end_expr,
    ACTIONS(37), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(19), 18,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_const_expr,
      sym_render_expr,
      sym_debug_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_snippet_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [1038] = 16,
    ACTIONS(41), 1,
      anon_sym_LT,
    ACTIONS(43), 1,
      anon_sym_LT_SLASH,
    ACTIONS(47), 1,
      anon_sym_LBRACE,
    ACTIONS(49), 1,
      sym__implicit_end_tag,
    STATE(5), 1,
      sym_await_start_expr,
    STATE(6), 1,
      sym_if_start_expr,
    STATE(21), 1,
      sym_each_start_expr,
    STATE(25), 1,
      sym_start_tag,
    STATE(43), 1,
      sym_key_start_expr,
    STATE(44), 1,
      sym_snippet_start_expr,
    STATE(78), 1,
      sym_self_closing_tag,
    STATE(89), 1,
      sym_end_tag,
    STATE(205), 1,
      sym_script_start_tag,
    STATE(206), 1,
      sym_style_start_tag,
    ACTIONS(45), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(26), 18,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_const_expr,
      sym_render_expr,
      sym_debug_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_snippet_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [1106] = 16,
    ACTIONS(41), 1,
      anon_sym_LT,
    ACTIONS(47), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_LT_SLASH,
    ACTIONS(55), 1,
      sym__implicit_end_tag,
    STATE(5), 1,
      sym_await_start_expr,
    STATE(6), 1,
      sym_if_start_expr,
    STATE(21), 1,
      sym_each_start_expr,
    STATE(25), 1,
      sym_start_tag,
    STATE(43), 1,
      sym_key_start_expr,
    STATE(44), 1,
      sym_snippet_start_expr,
    STATE(78), 1,
      sym_self_closing_tag,
    STATE(111), 1,
      sym_end_tag,
    STATE(205), 1,
      sym_script_start_tag,
    STATE(206), 1,
      sym_style_start_tag,
    ACTIONS(53), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(22), 18,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_const_expr,
      sym_render_expr,
      sym_debug_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_snippet_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [1174] = 15,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(39), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(10), 1,
      sym_await_start_expr,
    STATE(16), 1,
      sym_each_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(29), 1,
      sym_key_start_expr,
    STATE(41), 1,
      sym_else_expr,
    STATE(42), 1,
      sym_snippet_start_expr,
    STATE(109), 1,
      sym_self_closing_tag,
    STATE(196), 1,
      sym_style_start_tag,
    STATE(204), 1,
      sym_script_start_tag,
    STATE(131), 2,
      sym_else_each_statement,
      sym_each_end_expr,
    ACTIONS(15), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(48), 18,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_const_expr,
      sym_render_expr,
      sym_debug_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_snippet_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [1240] = 15,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(57), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(10), 1,
      sym_await_start_expr,
    STATE(16), 1,
      sym_each_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(29), 1,
      sym_key_start_expr,
    STATE(37), 1,
      sym_catch_expr,
    STATE(42), 1,
      sym_snippet_start_expr,
    STATE(109), 1,
      sym_self_closing_tag,
    STATE(196), 1,
      sym_style_start_tag,
    STATE(204), 1,
      sym_script_start_tag,
    STATE(65), 2,
      sym_catch_statement,
      sym_await_end_expr,
    ACTIONS(15), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(48), 18,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_const_expr,
      sym_render_expr,
      sym_debug_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_snippet_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [1306] = 15,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(10), 1,
      sym_await_start_expr,
    STATE(16), 1,
      sym_each_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(29), 1,
      sym_key_start_expr,
    STATE(38), 1,
      sym_else_expr,
    STATE(42), 1,
      sym_snippet_start_expr,
    STATE(109), 1,
      sym_self_closing_tag,
    STATE(196), 1,
      sym_style_start_tag,
    STATE(204), 1,
      sym_script_start_tag,
    STATE(98), 2,
      sym_else_each_statement,
      sym_each_end_expr,
    ACTIONS(59), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(24), 18,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_const_expr,
      sym_render_expr,
      sym_debug_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_snippet_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [1372] = 16,
    ACTIONS(41), 1,
      anon_sym_LT,
    ACTIONS(47), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      anon_sym_LT_SLASH,
    ACTIONS(63), 1,
      sym__implicit_end_tag,
    STATE(5), 1,
      sym_await_start_expr,
    STATE(6), 1,
      sym_if_start_expr,
    STATE(21), 1,
      sym_each_start_expr,
    STATE(25), 1,
      sym_start_tag,
    STATE(43), 1,
      sym_key_start_expr,
    STATE(44), 1,
      sym_snippet_start_expr,
    STATE(78), 1,
      sym_self_closing_tag,
    STATE(122), 1,
      sym_end_tag,
    STATE(205), 1,
      sym_script_start_tag,
    STATE(206), 1,
      sym_style_start_tag,
    ACTIONS(45), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(26), 18,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_const_expr,
      sym_render_expr,
      sym_debug_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_snippet_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [1440] = 15,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(57), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(10), 1,
      sym_await_start_expr,
    STATE(16), 1,
      sym_each_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(29), 1,
      sym_key_start_expr,
    STATE(37), 1,
      sym_catch_expr,
    STATE(42), 1,
      sym_snippet_start_expr,
    STATE(109), 1,
      sym_self_closing_tag,
    STATE(196), 1,
      sym_style_start_tag,
    STATE(204), 1,
      sym_script_start_tag,
    STATE(79), 2,
      sym_catch_statement,
      sym_await_end_expr,
    ACTIONS(65), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(20), 18,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_const_expr,
      sym_render_expr,
      sym_debug_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_snippet_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [1506] = 15,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(10), 1,
      sym_await_start_expr,
    STATE(16), 1,
      sym_each_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(29), 1,
      sym_key_start_expr,
    STATE(38), 1,
      sym_else_expr,
    STATE(42), 1,
      sym_snippet_start_expr,
    STATE(109), 1,
      sym_self_closing_tag,
    STATE(196), 1,
      sym_style_start_tag,
    STATE(204), 1,
      sym_script_start_tag,
    STATE(57), 2,
      sym_else_each_statement,
      sym_each_end_expr,
    ACTIONS(15), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(48), 18,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_const_expr,
      sym_render_expr,
      sym_debug_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_snippet_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [1572] = 16,
    ACTIONS(41), 1,
      anon_sym_LT,
    ACTIONS(43), 1,
      anon_sym_LT_SLASH,
    ACTIONS(47), 1,
      anon_sym_LBRACE,
    ACTIONS(69), 1,
      sym__implicit_end_tag,
    STATE(5), 1,
      sym_await_start_expr,
    STATE(6), 1,
      sym_if_start_expr,
    STATE(21), 1,
      sym_each_start_expr,
    STATE(25), 1,
      sym_start_tag,
    STATE(43), 1,
      sym_key_start_expr,
    STATE(44), 1,
      sym_snippet_start_expr,
    STATE(78), 1,
      sym_self_closing_tag,
    STATE(105), 1,
      sym_end_tag,
    STATE(205), 1,
      sym_script_start_tag,
    STATE(206), 1,
      sym_style_start_tag,
    ACTIONS(67), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(17), 18,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_const_expr,
      sym_render_expr,
      sym_debug_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_snippet_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [1640] = 14,
    ACTIONS(71), 1,
      anon_sym_LT,
    ACTIONS(79), 1,
      anon_sym_LBRACE,
    STATE(5), 1,
      sym_await_start_expr,
    STATE(6), 1,
      sym_if_start_expr,
    STATE(21), 1,
      sym_each_start_expr,
    STATE(25), 1,
      sym_start_tag,
    STATE(43), 1,
      sym_key_start_expr,
    STATE(44), 1,
      sym_snippet_start_expr,
    STATE(78), 1,
      sym_self_closing_tag,
    STATE(205), 1,
      sym_script_start_tag,
    STATE(206), 1,
      sym_style_start_tag,
    ACTIONS(74), 2,
      sym__implicit_end_tag,
      anon_sym_LT_SLASH,
    ACTIONS(76), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(26), 18,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_const_expr,
      sym_render_expr,
      sym_debug_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_snippet_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [1703] = 14,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(82), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(10), 1,
      sym_await_start_expr,
    STATE(16), 1,
      sym_each_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(29), 1,
      sym_key_start_expr,
    STATE(42), 1,
      sym_snippet_start_expr,
    STATE(109), 1,
      sym_self_closing_tag,
    STATE(123), 1,
      sym_if_end_expr,
    STATE(196), 1,
      sym_style_start_tag,
    STATE(204), 1,
      sym_script_start_tag,
    ACTIONS(15), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(48), 18,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_const_expr,
      sym_render_expr,
      sym_debug_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_snippet_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [1765] = 14,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(84), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(10), 1,
      sym_await_start_expr,
    STATE(16), 1,
      sym_each_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(29), 1,
      sym_key_start_expr,
    STATE(42), 1,
      sym_snippet_start_expr,
    STATE(109), 1,
      sym_self_closing_tag,
    STATE(133), 1,
      sym_await_end_expr,
    STATE(196), 1,
      sym_style_start_tag,
    STATE(204), 1,
      sym_script_start_tag,
    ACTIONS(15), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(48), 18,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_const_expr,
      sym_render_expr,
      sym_debug_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_snippet_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [1827] = 14,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(88), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(10), 1,
      sym_await_start_expr,
    STATE(16), 1,
      sym_each_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(29), 1,
      sym_key_start_expr,
    STATE(42), 1,
      sym_snippet_start_expr,
    STATE(109), 1,
      sym_self_closing_tag,
    STATE(118), 1,
      sym_key_end_expr,
    STATE(196), 1,
      sym_style_start_tag,
    STATE(204), 1,
      sym_script_start_tag,
    ACTIONS(86), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(47), 18,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_const_expr,
      sym_render_expr,
      sym_debug_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_snippet_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [1889] = 14,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(9), 1,
      anon_sym_LBRACE,
    ACTIONS(90), 1,
      ts_builtin_sym_end,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(10), 1,
      sym_await_start_expr,
    STATE(16), 1,
      sym_each_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(29), 1,
      sym_key_start_expr,
    STATE(42), 1,
      sym_snippet_start_expr,
    STATE(109), 1,
      sym_self_closing_tag,
    STATE(196), 1,
      sym_style_start_tag,
    STATE(204), 1,
      sym_script_start_tag,
    ACTIONS(15), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(48), 18,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_const_expr,
      sym_render_expr,
      sym_debug_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_snippet_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [1951] = 14,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(92), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(10), 1,
      sym_await_start_expr,
    STATE(16), 1,
      sym_each_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(29), 1,
      sym_key_start_expr,
    STATE(42), 1,
      sym_snippet_start_expr,
    STATE(67), 1,
      sym_if_end_expr,
    STATE(109), 1,
      sym_self_closing_tag,
    STATE(196), 1,
      sym_style_start_tag,
    STATE(204), 1,
      sym_script_start_tag,
    ACTIONS(15), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(48), 18,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_const_expr,
      sym_render_expr,
      sym_debug_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_snippet_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [2013] = 14,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(94), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(10), 1,
      sym_await_start_expr,
    STATE(16), 1,
      sym_each_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(29), 1,
      sym_key_start_expr,
    STATE(42), 1,
      sym_snippet_start_expr,
    STATE(109), 1,
      sym_self_closing_tag,
    STATE(127), 1,
      sym_each_end_expr,
    STATE(196), 1,
      sym_style_start_tag,
    STATE(204), 1,
      sym_script_start_tag,
    ACTIONS(15), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(48), 18,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_const_expr,
      sym_render_expr,
      sym_debug_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_snippet_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [2075] = 14,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(96), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(10), 1,
      sym_await_start_expr,
    STATE(16), 1,
      sym_each_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(29), 1,
      sym_key_start_expr,
    STATE(42), 1,
      sym_snippet_start_expr,
    STATE(66), 1,
      sym_each_end_expr,
    STATE(109), 1,
      sym_self_closing_tag,
    STATE(196), 1,
      sym_style_start_tag,
    STATE(204), 1,
      sym_script_start_tag,
    ACTIONS(15), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(48), 18,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_const_expr,
      sym_render_expr,
      sym_debug_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_snippet_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [2137] = 14,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(98), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(10), 1,
      sym_await_start_expr,
    STATE(16), 1,
      sym_each_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(29), 1,
      sym_key_start_expr,
    STATE(42), 1,
      sym_snippet_start_expr,
    STATE(64), 1,
      sym_await_end_expr,
    STATE(109), 1,
      sym_self_closing_tag,
    STATE(196), 1,
      sym_style_start_tag,
    STATE(204), 1,
      sym_script_start_tag,
    ACTIONS(15), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(48), 18,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_const_expr,
      sym_render_expr,
      sym_debug_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_snippet_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [2199] = 14,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(100), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(10), 1,
      sym_await_start_expr,
    STATE(16), 1,
      sym_each_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(29), 1,
      sym_key_start_expr,
    STATE(42), 1,
      sym_snippet_start_expr,
    STATE(73), 1,
      sym_key_end_expr,
    STATE(109), 1,
      sym_self_closing_tag,
    STATE(196), 1,
      sym_style_start_tag,
    STATE(204), 1,
      sym_script_start_tag,
    ACTIONS(15), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(48), 18,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_const_expr,
      sym_render_expr,
      sym_debug_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_snippet_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [2261] = 14,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(102), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(10), 1,
      sym_await_start_expr,
    STATE(16), 1,
      sym_each_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(29), 1,
      sym_key_start_expr,
    STATE(42), 1,
      sym_snippet_start_expr,
    STATE(74), 1,
      sym_snippet_end_expr,
    STATE(109), 1,
      sym_self_closing_tag,
    STATE(196), 1,
      sym_style_start_tag,
    STATE(204), 1,
      sym_script_start_tag,
    ACTIONS(15), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(48), 18,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_const_expr,
      sym_render_expr,
      sym_debug_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_snippet_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [2323] = 14,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(98), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(10), 1,
      sym_await_start_expr,
    STATE(16), 1,
      sym_each_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(29), 1,
      sym_key_start_expr,
    STATE(42), 1,
      sym_snippet_start_expr,
    STATE(76), 1,
      sym_await_end_expr,
    STATE(109), 1,
      sym_self_closing_tag,
    STATE(196), 1,
      sym_style_start_tag,
    STATE(204), 1,
      sym_script_start_tag,
    ACTIONS(104), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(34), 18,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_const_expr,
      sym_render_expr,
      sym_debug_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_snippet_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [2385] = 14,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(96), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(10), 1,
      sym_await_start_expr,
    STATE(16), 1,
      sym_each_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(29), 1,
      sym_key_start_expr,
    STATE(42), 1,
      sym_snippet_start_expr,
    STATE(82), 1,
      sym_each_end_expr,
    STATE(109), 1,
      sym_self_closing_tag,
    STATE(196), 1,
      sym_style_start_tag,
    STATE(204), 1,
      sym_script_start_tag,
    ACTIONS(106), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(33), 18,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_const_expr,
      sym_render_expr,
      sym_debug_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_snippet_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [2447] = 14,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(92), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(10), 1,
      sym_await_start_expr,
    STATE(16), 1,
      sym_each_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(29), 1,
      sym_key_start_expr,
    STATE(42), 1,
      sym_snippet_start_expr,
    STATE(85), 1,
      sym_if_end_expr,
    STATE(109), 1,
      sym_self_closing_tag,
    STATE(196), 1,
      sym_style_start_tag,
    STATE(204), 1,
      sym_script_start_tag,
    ACTIONS(108), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(31), 18,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_const_expr,
      sym_render_expr,
      sym_debug_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_snippet_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [2509] = 14,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(82), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(10), 1,
      sym_await_start_expr,
    STATE(16), 1,
      sym_each_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(29), 1,
      sym_key_start_expr,
    STATE(42), 1,
      sym_snippet_start_expr,
    STATE(106), 1,
      sym_if_end_expr,
    STATE(109), 1,
      sym_self_closing_tag,
    STATE(196), 1,
      sym_style_start_tag,
    STATE(204), 1,
      sym_script_start_tag,
    ACTIONS(110), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(27), 18,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_const_expr,
      sym_render_expr,
      sym_debug_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_snippet_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [2571] = 14,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(94), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(10), 1,
      sym_await_start_expr,
    STATE(16), 1,
      sym_each_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(29), 1,
      sym_key_start_expr,
    STATE(42), 1,
      sym_snippet_start_expr,
    STATE(109), 1,
      sym_self_closing_tag,
    STATE(130), 1,
      sym_each_end_expr,
    STATE(196), 1,
      sym_style_start_tag,
    STATE(204), 1,
      sym_script_start_tag,
    ACTIONS(112), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(32), 18,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_const_expr,
      sym_render_expr,
      sym_debug_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_snippet_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [2633] = 14,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(116), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(10), 1,
      sym_await_start_expr,
    STATE(16), 1,
      sym_each_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(29), 1,
      sym_key_start_expr,
    STATE(42), 1,
      sym_snippet_start_expr,
    STATE(109), 1,
      sym_self_closing_tag,
    STATE(117), 1,
      sym_snippet_end_expr,
    STATE(196), 1,
      sym_style_start_tag,
    STATE(204), 1,
      sym_script_start_tag,
    ACTIONS(114), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(46), 18,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_const_expr,
      sym_render_expr,
      sym_debug_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_snippet_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [2695] = 14,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(100), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(10), 1,
      sym_await_start_expr,
    STATE(16), 1,
      sym_each_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(29), 1,
      sym_key_start_expr,
    STATE(42), 1,
      sym_snippet_start_expr,
    STATE(94), 1,
      sym_key_end_expr,
    STATE(109), 1,
      sym_self_closing_tag,
    STATE(196), 1,
      sym_style_start_tag,
    STATE(204), 1,
      sym_script_start_tag,
    ACTIONS(118), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(35), 18,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_const_expr,
      sym_render_expr,
      sym_debug_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_snippet_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [2757] = 14,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(102), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(10), 1,
      sym_await_start_expr,
    STATE(16), 1,
      sym_each_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(29), 1,
      sym_key_start_expr,
    STATE(42), 1,
      sym_snippet_start_expr,
    STATE(96), 1,
      sym_snippet_end_expr,
    STATE(109), 1,
      sym_self_closing_tag,
    STATE(196), 1,
      sym_style_start_tag,
    STATE(204), 1,
      sym_script_start_tag,
    ACTIONS(120), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(36), 18,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_const_expr,
      sym_render_expr,
      sym_debug_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_snippet_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [2819] = 14,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(84), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(10), 1,
      sym_await_start_expr,
    STATE(16), 1,
      sym_each_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(29), 1,
      sym_key_start_expr,
    STATE(42), 1,
      sym_snippet_start_expr,
    STATE(109), 1,
      sym_self_closing_tag,
    STATE(135), 1,
      sym_await_end_expr,
    STATE(196), 1,
      sym_style_start_tag,
    STATE(204), 1,
      sym_script_start_tag,
    ACTIONS(122), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(28), 18,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_const_expr,
      sym_render_expr,
      sym_debug_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_snippet_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [2881] = 14,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(116), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(10), 1,
      sym_await_start_expr,
    STATE(16), 1,
      sym_each_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(29), 1,
      sym_key_start_expr,
    STATE(42), 1,
      sym_snippet_start_expr,
    STATE(109), 1,
      sym_self_closing_tag,
    STATE(137), 1,
      sym_snippet_end_expr,
    STATE(196), 1,
      sym_style_start_tag,
    STATE(204), 1,
      sym_script_start_tag,
    ACTIONS(15), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(48), 18,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_const_expr,
      sym_render_expr,
      sym_debug_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_snippet_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [2943] = 14,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(88), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(10), 1,
      sym_await_start_expr,
    STATE(16), 1,
      sym_each_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(29), 1,
      sym_key_start_expr,
    STATE(42), 1,
      sym_snippet_start_expr,
    STATE(109), 1,
      sym_self_closing_tag,
    STATE(138), 1,
      sym_key_end_expr,
    STATE(196), 1,
      sym_style_start_tag,
    STATE(204), 1,
      sym_script_start_tag,
    ACTIONS(15), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(48), 18,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_const_expr,
      sym_render_expr,
      sym_debug_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_snippet_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [3005] = 14,
    ACTIONS(74), 1,
      ts_builtin_sym_end,
    ACTIONS(124), 1,
      anon_sym_LT,
    ACTIONS(130), 1,
      anon_sym_LBRACE,
    STATE(9), 1,
      sym_if_start_expr,
    STATE(10), 1,
      sym_await_start_expr,
    STATE(16), 1,
      sym_each_start_expr,
    STATE(18), 1,
      sym_start_tag,
    STATE(29), 1,
      sym_key_start_expr,
    STATE(42), 1,
      sym_snippet_start_expr,
    STATE(109), 1,
      sym_self_closing_tag,
    STATE(196), 1,
      sym_style_start_tag,
    STATE(204), 1,
      sym_script_start_tag,
    ACTIONS(127), 3,
      sym_comment,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
    STATE(48), 18,
      sym__node,
      sym__statement,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym__text,
      sym__expression,
      sym_expression,
      sym_html_expr,
      sym_const_expr,
      sym_render_expr,
      sym_debug_expr,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_snippet_statement,
      sym_key_statement,
      aux_sym_document_repeat1,
  [3067] = 7,
    ACTIONS(133), 1,
      anon_sym_GT,
    ACTIONS(135), 1,
      anon_sym_SLASH_GT,
    ACTIONS(137), 1,
      aux_sym_attribute_name_token1,
    ACTIONS(139), 1,
      anon_sym_LBRACE,
    STATE(152), 1,
      sym_attribute_name,
    STATE(188), 1,
      sym_expression,
    STATE(50), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [3090] = 7,
    ACTIONS(137), 1,
      aux_sym_attribute_name_token1,
    ACTIONS(139), 1,
      anon_sym_LBRACE,
    ACTIONS(141), 1,
      anon_sym_GT,
    ACTIONS(143), 1,
      anon_sym_SLASH_GT,
    STATE(152), 1,
      sym_attribute_name,
    STATE(188), 1,
      sym_expression,
    STATE(52), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [3113] = 6,
    ACTIONS(139), 1,
      anon_sym_LBRACE,
    ACTIONS(145), 1,
      aux_sym_attribute_name_token1,
    ACTIONS(147), 1,
      anon_sym_SQUOTE,
    ACTIONS(149), 1,
      anon_sym_DQUOTE,
    STATE(178), 1,
      sym_expression,
    STATE(190), 3,
      sym_attribute_value,
      sym_expr_attribute_value,
      sym_quoted_attribute_value,
  [3134] = 6,
    ACTIONS(153), 1,
      aux_sym_attribute_name_token1,
    ACTIONS(156), 1,
      anon_sym_LBRACE,
    STATE(152), 1,
      sym_attribute_name,
    STATE(188), 1,
      sym_expression,
    ACTIONS(151), 2,
      anon_sym_GT,
      anon_sym_SLASH_GT,
    STATE(52), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [3155] = 7,
    ACTIONS(133), 1,
      anon_sym_GT,
    ACTIONS(137), 1,
      aux_sym_attribute_name_token1,
    ACTIONS(139), 1,
      anon_sym_LBRACE,
    ACTIONS(159), 1,
      anon_sym_SLASH_GT,
    STATE(152), 1,
      sym_attribute_name,
    STATE(188), 1,
      sym_expression,
    STATE(55), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [3178] = 6,
    ACTIONS(161), 1,
      aux_sym_attribute_name_token1,
    ACTIONS(163), 1,
      anon_sym_SQUOTE,
    ACTIONS(165), 1,
      anon_sym_DQUOTE,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    STATE(201), 1,
      sym_expression,
    STATE(202), 3,
      sym_attribute_value,
      sym_expr_attribute_value,
      sym_quoted_attribute_value,
  [3199] = 7,
    ACTIONS(137), 1,
      aux_sym_attribute_name_token1,
    ACTIONS(139), 1,
      anon_sym_LBRACE,
    ACTIONS(141), 1,
      anon_sym_GT,
    ACTIONS(169), 1,
      anon_sym_SLASH_GT,
    STATE(152), 1,
      sym_attribute_name,
    STATE(188), 1,
      sym_expression,
    STATE(52), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [3222] = 2,
    ACTIONS(171), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(173), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3234] = 2,
    ACTIONS(175), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(177), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3246] = 6,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(179), 1,
      anon_sym_GT,
    ACTIONS(181), 1,
      aux_sym_attribute_name_token1,
    STATE(192), 1,
      sym_attribute_name,
    STATE(199), 1,
      sym_expression,
    STATE(71), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [3266] = 2,
    ACTIONS(183), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(185), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3278] = 6,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(181), 1,
      aux_sym_attribute_name_token1,
    ACTIONS(187), 1,
      anon_sym_GT,
    STATE(192), 1,
      sym_attribute_name,
    STATE(199), 1,
      sym_expression,
    STATE(71), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [3298] = 2,
    ACTIONS(189), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(191), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3310] = 2,
    ACTIONS(193), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(195), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3322] = 2,
    ACTIONS(197), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(199), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3334] = 2,
    ACTIONS(201), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(203), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3346] = 2,
    ACTIONS(205), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(207), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3358] = 2,
    ACTIONS(209), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(211), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3370] = 2,
    ACTIONS(213), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(215), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3382] = 2,
    ACTIONS(217), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(219), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3394] = 2,
    ACTIONS(221), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(223), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3406] = 2,
    ACTIONS(225), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(227), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3418] = 6,
    ACTIONS(151), 1,
      anon_sym_GT,
    ACTIONS(229), 1,
      aux_sym_attribute_name_token1,
    ACTIONS(232), 1,
      anon_sym_LBRACE,
    STATE(192), 1,
      sym_attribute_name,
    STATE(199), 1,
      sym_expression,
    STATE(71), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [3438] = 2,
    ACTIONS(235), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(237), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3450] = 2,
    ACTIONS(239), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(241), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3462] = 2,
    ACTIONS(243), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(245), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3474] = 2,
    ACTIONS(247), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(249), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3486] = 2,
    ACTIONS(251), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(253), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3498] = 6,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(181), 1,
      aux_sym_attribute_name_token1,
    ACTIONS(255), 1,
      anon_sym_GT,
    STATE(192), 1,
      sym_attribute_name,
    STATE(199), 1,
      sym_expression,
    STATE(58), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [3518] = 2,
    ACTIONS(257), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(259), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3530] = 2,
    ACTIONS(261), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(263), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3542] = 2,
    ACTIONS(265), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(267), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3554] = 2,
    ACTIONS(269), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(271), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3566] = 2,
    ACTIONS(273), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(275), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3578] = 2,
    ACTIONS(277), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(279), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3590] = 2,
    ACTIONS(281), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(283), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3602] = 2,
    ACTIONS(285), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(287), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3614] = 2,
    ACTIONS(289), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(291), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3626] = 2,
    ACTIONS(293), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(295), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3638] = 2,
    ACTIONS(297), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(299), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3650] = 2,
    ACTIONS(301), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(303), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3662] = 2,
    ACTIONS(305), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(307), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3674] = 2,
    ACTIONS(309), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(311), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3686] = 2,
    ACTIONS(313), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(315), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3698] = 2,
    ACTIONS(317), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(319), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3710] = 2,
    ACTIONS(321), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(323), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3722] = 2,
    ACTIONS(325), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(327), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3734] = 2,
    ACTIONS(329), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(331), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3746] = 2,
    ACTIONS(333), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(335), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3758] = 2,
    ACTIONS(337), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(339), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3770] = 2,
    ACTIONS(341), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(343), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3782] = 2,
    ACTIONS(345), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(347), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3794] = 2,
    ACTIONS(349), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(351), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3806] = 2,
    ACTIONS(353), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(355), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3818] = 2,
    ACTIONS(357), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(359), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3830] = 6,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(181), 1,
      aux_sym_attribute_name_token1,
    ACTIONS(361), 1,
      anon_sym_GT,
    STATE(192), 1,
      sym_attribute_name,
    STATE(199), 1,
      sym_expression,
    STATE(60), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [3850] = 2,
    ACTIONS(363), 2,
      anon_sym_LT,
      anon_sym_LBRACE,
    ACTIONS(365), 5,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3862] = 2,
    ACTIONS(285), 1,
      anon_sym_LBRACE,
    ACTIONS(287), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3873] = 2,
    ACTIONS(317), 1,
      anon_sym_LBRACE,
    ACTIONS(319), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3884] = 2,
    ACTIONS(225), 1,
      anon_sym_LBRACE,
    ACTIONS(227), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3895] = 2,
    ACTIONS(257), 1,
      anon_sym_LBRACE,
    ACTIONS(259), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3906] = 2,
    ACTIONS(221), 1,
      anon_sym_LBRACE,
    ACTIONS(223), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3917] = 2,
    ACTIONS(363), 1,
      anon_sym_LBRACE,
    ACTIONS(365), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3928] = 2,
    ACTIONS(357), 1,
      anon_sym_LBRACE,
    ACTIONS(359), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3939] = 2,
    ACTIONS(345), 1,
      anon_sym_LBRACE,
    ACTIONS(347), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3950] = 2,
    ACTIONS(341), 1,
      anon_sym_LBRACE,
    ACTIONS(343), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3961] = 2,
    ACTIONS(337), 1,
      anon_sym_LBRACE,
    ACTIONS(339), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3972] = 2,
    ACTIONS(333), 1,
      anon_sym_LBRACE,
    ACTIONS(335), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3983] = 2,
    ACTIONS(329), 1,
      anon_sym_LBRACE,
    ACTIONS(331), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [3994] = 2,
    ACTIONS(321), 1,
      anon_sym_LBRACE,
    ACTIONS(323), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [4005] = 2,
    ACTIONS(309), 1,
      anon_sym_LBRACE,
    ACTIONS(311), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [4016] = 2,
    ACTIONS(217), 1,
      anon_sym_LBRACE,
    ACTIONS(219), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [4027] = 2,
    ACTIONS(305), 1,
      anon_sym_LBRACE,
    ACTIONS(307), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [4038] = 2,
    ACTIONS(301), 1,
      anon_sym_LBRACE,
    ACTIONS(303), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [4049] = 2,
    ACTIONS(213), 1,
      anon_sym_LBRACE,
    ACTIONS(215), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [4060] = 2,
    ACTIONS(171), 1,
      anon_sym_LBRACE,
    ACTIONS(173), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [4071] = 2,
    ACTIONS(297), 1,
      anon_sym_LBRACE,
    ACTIONS(299), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [4082] = 2,
    ACTIONS(293), 1,
      anon_sym_LBRACE,
    ACTIONS(295), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [4093] = 2,
    ACTIONS(209), 1,
      anon_sym_LBRACE,
    ACTIONS(211), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [4104] = 2,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(283), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [4115] = 2,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [4126] = 2,
    ACTIONS(273), 1,
      anon_sym_LBRACE,
    ACTIONS(275), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [4137] = 2,
    ACTIONS(175), 1,
      anon_sym_LBRACE,
    ACTIONS(177), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [4148] = 2,
    ACTIONS(205), 1,
      anon_sym_LBRACE,
    ACTIONS(207), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [4159] = 2,
    ACTIONS(201), 1,
      anon_sym_LBRACE,
    ACTIONS(203), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [4170] = 2,
    ACTIONS(261), 1,
      anon_sym_LBRACE,
    ACTIONS(263), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [4181] = 2,
    ACTIONS(251), 1,
      anon_sym_LBRACE,
    ACTIONS(253), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [4192] = 2,
    ACTIONS(247), 1,
      anon_sym_LBRACE,
    ACTIONS(249), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [4203] = 2,
    ACTIONS(243), 1,
      anon_sym_LBRACE,
    ACTIONS(245), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [4214] = 2,
    ACTIONS(239), 1,
      anon_sym_LBRACE,
    ACTIONS(241), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [4225] = 2,
    ACTIONS(235), 1,
      anon_sym_LBRACE,
    ACTIONS(237), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [4236] = 2,
    ACTIONS(325), 1,
      anon_sym_LBRACE,
    ACTIONS(327), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [4247] = 2,
    ACTIONS(197), 1,
      anon_sym_LBRACE,
    ACTIONS(199), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [4258] = 2,
    ACTIONS(193), 1,
      anon_sym_LBRACE,
    ACTIONS(195), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [4269] = 2,
    ACTIONS(265), 1,
      anon_sym_LBRACE,
    ACTIONS(267), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [4280] = 2,
    ACTIONS(189), 1,
      anon_sym_LBRACE,
    ACTIONS(191), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [4291] = 2,
    ACTIONS(289), 1,
      anon_sym_LBRACE,
    ACTIONS(291), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [4302] = 2,
    ACTIONS(183), 1,
      anon_sym_LBRACE,
    ACTIONS(185), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [4313] = 2,
    ACTIONS(269), 1,
      anon_sym_LBRACE,
    ACTIONS(271), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [4324] = 2,
    ACTIONS(313), 1,
      anon_sym_LBRACE,
    ACTIONS(315), 5,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [4335] = 2,
    ACTIONS(369), 1,
      anon_sym_LBRACE,
    ACTIONS(367), 4,
      sym_comment,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [4345] = 5,
    ACTIONS(371), 1,
      anon_sym_AT,
    ACTIONS(373), 1,
      anon_sym_POUND,
    ACTIONS(375), 1,
      anon_sym_COLON,
    ACTIONS(377), 1,
      anon_sym_SLASH,
    ACTIONS(379), 1,
      sym_raw_text_expr,
  [4361] = 1,
    ACTIONS(381), 5,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      anon_sym_EQ,
      aux_sym_attribute_name_token1,
      anon_sym_LBRACE,
  [4369] = 2,
    ACTIONS(385), 1,
      anon_sym_EQ,
    ACTIONS(383), 4,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      aux_sym_attribute_name_token1,
      anon_sym_LBRACE,
  [4379] = 2,
    ACTIONS(389), 1,
      anon_sym_LBRACE,
    ACTIONS(387), 4,
      sym_comment,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [4389] = 2,
    ACTIONS(393), 1,
      anon_sym_LBRACE,
    ACTIONS(391), 4,
      sym_comment,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [4399] = 5,
    ACTIONS(371), 1,
      anon_sym_AT,
    ACTIONS(373), 1,
      anon_sym_POUND,
    ACTIONS(379), 1,
      sym_raw_text_expr,
    ACTIONS(395), 1,
      anon_sym_COLON,
    ACTIONS(397), 1,
      anon_sym_SLASH,
  [4415] = 2,
    ACTIONS(401), 1,
      anon_sym_LBRACE,
    ACTIONS(399), 4,
      sym_comment,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [4425] = 5,
    ACTIONS(403), 1,
      anon_sym_if,
    ACTIONS(405), 1,
      anon_sym_each,
    ACTIONS(407), 1,
      anon_sym_await,
    ACTIONS(409), 1,
      anon_sym_snippet,
    ACTIONS(411), 1,
      anon_sym_key,
  [4441] = 2,
    ACTIONS(415), 1,
      anon_sym_LBRACE,
    ACTIONS(413), 4,
      sym_comment,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [4451] = 2,
    ACTIONS(419), 1,
      anon_sym_LBRACE,
    ACTIONS(417), 4,
      sym_comment,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [4461] = 2,
    ACTIONS(423), 1,
      anon_sym_LBRACE,
    ACTIONS(421), 4,
      sym_comment,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [4471] = 2,
    ACTIONS(427), 1,
      anon_sym_LBRACE,
    ACTIONS(425), 4,
      sym_comment,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [4481] = 2,
    ACTIONS(431), 1,
      anon_sym_LBRACE,
    ACTIONS(429), 4,
      sym_comment,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [4491] = 2,
    ACTIONS(435), 1,
      anon_sym_LBRACE,
    ACTIONS(433), 4,
      sym_comment,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [4501] = 5,
    ACTIONS(371), 1,
      anon_sym_AT,
    ACTIONS(373), 1,
      anon_sym_POUND,
    ACTIONS(379), 1,
      sym_raw_text_expr,
    ACTIONS(437), 1,
      anon_sym_COLON,
    ACTIONS(439), 1,
      anon_sym_SLASH,
  [4517] = 5,
    ACTIONS(371), 1,
      anon_sym_AT,
    ACTIONS(373), 1,
      anon_sym_POUND,
    ACTIONS(379), 1,
      sym_raw_text_expr,
    ACTIONS(441), 1,
      anon_sym_COLON,
    ACTIONS(443), 1,
      anon_sym_SLASH,
  [4533] = 2,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(445), 4,
      sym_comment,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [4543] = 5,
    ACTIONS(371), 1,
      anon_sym_AT,
    ACTIONS(373), 1,
      anon_sym_POUND,
    ACTIONS(379), 1,
      sym_raw_text_expr,
    ACTIONS(441), 1,
      anon_sym_COLON,
    ACTIONS(449), 1,
      anon_sym_SLASH,
  [4559] = 2,
    ACTIONS(453), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 4,
      sym_comment,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [4569] = 5,
    ACTIONS(371), 1,
      anon_sym_AT,
    ACTIONS(373), 1,
      anon_sym_POUND,
    ACTIONS(377), 1,
      anon_sym_SLASH,
    ACTIONS(379), 1,
      sym_raw_text_expr,
    ACTIONS(395), 1,
      anon_sym_COLON,
  [4585] = 2,
    ACTIONS(457), 1,
      anon_sym_LBRACE,
    ACTIONS(455), 4,
      sym_comment,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [4595] = 2,
    ACTIONS(461), 1,
      anon_sym_LBRACE,
    ACTIONS(459), 4,
      sym_comment,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [4605] = 5,
    ACTIONS(371), 1,
      anon_sym_AT,
    ACTIONS(373), 1,
      anon_sym_POUND,
    ACTIONS(375), 1,
      anon_sym_COLON,
    ACTIONS(379), 1,
      sym_raw_text_expr,
    ACTIONS(397), 1,
      anon_sym_SLASH,
  [4621] = 5,
    ACTIONS(371), 1,
      anon_sym_AT,
    ACTIONS(373), 1,
      anon_sym_POUND,
    ACTIONS(379), 1,
      sym_raw_text_expr,
    ACTIONS(437), 1,
      anon_sym_COLON,
    ACTIONS(463), 1,
      anon_sym_SLASH,
  [4637] = 2,
    ACTIONS(467), 1,
      anon_sym_LBRACE,
    ACTIONS(465), 4,
      sym_comment,
      anon_sym_LT,
      aux_sym__text_token1,
      anon_sym_LBRACE_RBRACE,
  [4647] = 1,
    ACTIONS(307), 4,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      aux_sym_attribute_name_token1,
      anon_sym_LBRACE,
  [4654] = 4,
    ACTIONS(469), 1,
      anon_sym_html,
    ACTIONS(471), 1,
      anon_sym_const,
    ACTIONS(473), 1,
      anon_sym_render,
    ACTIONS(475), 1,
      anon_sym_debug,
  [4667] = 4,
    ACTIONS(371), 1,
      anon_sym_AT,
    ACTIONS(373), 1,
      anon_sym_POUND,
    ACTIONS(379), 1,
      sym_raw_text_expr,
    ACTIONS(477), 1,
      anon_sym_SLASH,
  [4680] = 1,
    ACTIONS(479), 4,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      aux_sym_attribute_name_token1,
      anon_sym_LBRACE,
  [4687] = 1,
    ACTIONS(481), 4,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      aux_sym_attribute_name_token1,
      anon_sym_LBRACE,
  [4694] = 4,
    ACTIONS(371), 1,
      anon_sym_AT,
    ACTIONS(373), 1,
      anon_sym_POUND,
    ACTIONS(379), 1,
      sym_raw_text_expr,
    ACTIONS(449), 1,
      anon_sym_SLASH,
  [4707] = 4,
    ACTIONS(371), 1,
      anon_sym_AT,
    ACTIONS(373), 1,
      anon_sym_POUND,
    ACTIONS(379), 1,
      sym_raw_text_expr,
    ACTIONS(443), 1,
      anon_sym_SLASH,
  [4720] = 4,
    ACTIONS(371), 1,
      anon_sym_AT,
    ACTIONS(373), 1,
      anon_sym_POUND,
    ACTIONS(379), 1,
      sym_raw_text_expr,
    ACTIONS(439), 1,
      anon_sym_SLASH,
  [4733] = 4,
    ACTIONS(371), 1,
      anon_sym_AT,
    ACTIONS(373), 1,
      anon_sym_POUND,
    ACTIONS(377), 1,
      anon_sym_SLASH,
    ACTIONS(379), 1,
      sym_raw_text_expr,
  [4746] = 4,
    ACTIONS(371), 1,
      anon_sym_AT,
    ACTIONS(373), 1,
      anon_sym_POUND,
    ACTIONS(379), 1,
      sym_raw_text_expr,
    ACTIONS(483), 1,
      anon_sym_SLASH,
  [4759] = 1,
    ACTIONS(485), 4,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      aux_sym_attribute_name_token1,
      anon_sym_LBRACE,
  [4766] = 1,
    ACTIONS(381), 4,
      anon_sym_GT,
      anon_sym_EQ,
      aux_sym_attribute_name_token1,
      anon_sym_LBRACE,
  [4773] = 4,
    ACTIONS(371), 1,
      anon_sym_AT,
    ACTIONS(373), 1,
      anon_sym_POUND,
    ACTIONS(379), 1,
      sym_raw_text_expr,
    ACTIONS(463), 1,
      anon_sym_SLASH,
  [4786] = 1,
    ACTIONS(487), 4,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      aux_sym_attribute_name_token1,
      anon_sym_LBRACE,
  [4793] = 4,
    ACTIONS(489), 1,
      anon_sym_html,
    ACTIONS(491), 1,
      anon_sym_const,
    ACTIONS(493), 1,
      anon_sym_render,
    ACTIONS(495), 1,
      anon_sym_debug,
  [4806] = 1,
    ACTIONS(497), 4,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      aux_sym_attribute_name_token1,
      anon_sym_LBRACE,
  [4813] = 4,
    ACTIONS(371), 1,
      anon_sym_AT,
    ACTIONS(373), 1,
      anon_sym_POUND,
    ACTIONS(379), 1,
      sym_raw_text_expr,
    ACTIONS(499), 1,
      anon_sym_SLASH,
  [4826] = 2,
    ACTIONS(501), 1,
      anon_sym_EQ,
    ACTIONS(383), 3,
      anon_sym_GT,
      aux_sym_attribute_name_token1,
      anon_sym_LBRACE,
  [4835] = 4,
    ACTIONS(371), 1,
      anon_sym_AT,
    ACTIONS(373), 1,
      anon_sym_POUND,
    ACTIONS(379), 1,
      sym_raw_text_expr,
    ACTIONS(503), 1,
      anon_sym_SLASH,
  [4848] = 1,
    ACTIONS(505), 4,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      aux_sym_attribute_name_token1,
      anon_sym_LBRACE,
  [4855] = 4,
    ACTIONS(371), 1,
      anon_sym_AT,
    ACTIONS(373), 1,
      anon_sym_POUND,
    ACTIONS(379), 1,
      sym_raw_text_expr,
    ACTIONS(397), 1,
      anon_sym_SLASH,
  [4868] = 3,
    ACTIONS(51), 1,
      anon_sym_LT_SLASH,
    ACTIONS(507), 1,
      sym_raw_text,
    STATE(113), 1,
      sym_end_tag,
  [4878] = 1,
    ACTIONS(307), 3,
      anon_sym_GT,
      aux_sym_attribute_name_token1,
      anon_sym_LBRACE,
  [4884] = 1,
    ACTIONS(481), 3,
      anon_sym_GT,
      aux_sym_attribute_name_token1,
      anon_sym_LBRACE,
  [4890] = 1,
    ACTIONS(487), 3,
      anon_sym_GT,
      aux_sym_attribute_name_token1,
      anon_sym_LBRACE,
  [4896] = 1,
    ACTIONS(485), 3,
      anon_sym_GT,
      aux_sym_attribute_name_token1,
      anon_sym_LBRACE,
  [4902] = 1,
    ACTIONS(479), 3,
      anon_sym_GT,
      aux_sym_attribute_name_token1,
      anon_sym_LBRACE,
  [4908] = 1,
    ACTIONS(497), 3,
      anon_sym_GT,
      aux_sym_attribute_name_token1,
      anon_sym_LBRACE,
  [4914] = 1,
    ACTIONS(505), 3,
      anon_sym_GT,
      aux_sym_attribute_name_token1,
      anon_sym_LBRACE,
  [4920] = 3,
    ACTIONS(51), 1,
      anon_sym_LT_SLASH,
    ACTIONS(509), 1,
      sym_raw_text,
    STATE(112), 1,
      sym_end_tag,
  [4930] = 3,
    ACTIONS(43), 1,
      anon_sym_LT_SLASH,
    ACTIONS(511), 1,
      sym_raw_text,
    STATE(103), 1,
      sym_end_tag,
  [4940] = 3,
    ACTIONS(43), 1,
      anon_sym_LT_SLASH,
    ACTIONS(513), 1,
      sym_raw_text,
    STATE(100), 1,
      sym_end_tag,
  [4950] = 3,
    ACTIONS(373), 1,
      anon_sym_POUND,
    ACTIONS(515), 1,
      anon_sym_AT,
    ACTIONS(517), 1,
      sym_raw_text_expr,
  [4960] = 3,
    ACTIONS(519), 1,
      sym__start_tag_name,
    ACTIONS(521), 1,
      sym__script_start_tag_name,
    ACTIONS(523), 1,
      sym__style_start_tag_name,
  [4970] = 3,
    ACTIONS(521), 1,
      sym__script_start_tag_name,
    ACTIONS(523), 1,
      sym__style_start_tag_name,
    ACTIONS(525), 1,
      sym__start_tag_name,
  [4980] = 3,
    ACTIONS(371), 1,
      anon_sym_AT,
    ACTIONS(373), 1,
      anon_sym_POUND,
    ACTIONS(379), 1,
      sym_raw_text_expr,
  [4990] = 2,
    ACTIONS(527), 1,
      anon_sym_RBRACE,
    ACTIONS(529), 1,
      sym_raw_text_expr,
  [4997] = 2,
    ACTIONS(531), 1,
      anon_sym_SQUOTE,
    ACTIONS(533), 1,
      aux_sym_quoted_attribute_value_token1,
  [5004] = 2,
    ACTIONS(43), 1,
      anon_sym_LT_SLASH,
    STATE(87), 1,
      sym_end_tag,
  [5011] = 2,
    ACTIONS(535), 1,
      anon_sym_RBRACE,
    ACTIONS(537), 1,
      sym_raw_text_expr,
  [5018] = 2,
    ACTIONS(43), 1,
      anon_sym_LT_SLASH,
    STATE(88), 1,
      sym_end_tag,
  [5025] = 2,
    ACTIONS(531), 1,
      anon_sym_DQUOTE,
    ACTIONS(539), 1,
      aux_sym_quoted_attribute_value_token2,
  [5032] = 2,
    ACTIONS(51), 1,
      anon_sym_LT_SLASH,
    STATE(126), 1,
      sym_end_tag,
  [5039] = 2,
    ACTIONS(51), 1,
      anon_sym_LT_SLASH,
    STATE(125), 1,
      sym_end_tag,
  [5046] = 1,
    ACTIONS(541), 2,
      sym_raw_text,
      anon_sym_LT_SLASH,
  [5051] = 2,
    ACTIONS(543), 1,
      sym_raw_text_expr,
    ACTIONS(545), 1,
      sym_raw_text_await,
  [5058] = 2,
    ACTIONS(547), 1,
      sym_raw_text_expr,
    ACTIONS(549), 1,
      sym_raw_text_each,
  [5065] = 1,
    ACTIONS(551), 2,
      sym_raw_text,
      anon_sym_LT_SLASH,
  [5070] = 2,
    ACTIONS(553), 1,
      anon_sym_RBRACE,
    ACTIONS(555), 1,
      anon_sym_if,
  [5077] = 2,
    ACTIONS(557), 1,
      anon_sym_then,
    ACTIONS(559), 1,
      anon_sym_catch,
  [5084] = 2,
    ACTIONS(561), 1,
      anon_sym_RBRACE,
    ACTIONS(563), 1,
      sym_raw_text_expr,
  [5091] = 2,
    ACTIONS(565), 1,
      anon_sym_DQUOTE,
    ACTIONS(567), 1,
      aux_sym_quoted_attribute_value_token2,
  [5098] = 2,
    ACTIONS(565), 1,
      anon_sym_SQUOTE,
    ACTIONS(569), 1,
      aux_sym_quoted_attribute_value_token1,
  [5105] = 2,
    ACTIONS(571), 1,
      anon_sym_RBRACE,
    ACTIONS(573), 1,
      sym_raw_text_expr,
  [5112] = 2,
    ACTIONS(575), 1,
      anon_sym_RBRACE,
    ACTIONS(577), 1,
      sym_raw_text_expr,
  [5119] = 2,
    ACTIONS(579), 1,
      aux_sym_render_expr_token2,
    ACTIONS(581), 1,
      anon_sym_RPAREN,
  [5126] = 1,
    ACTIONS(583), 2,
      sym_raw_text,
      anon_sym_LT_SLASH,
  [5131] = 1,
    ACTIONS(585), 2,
      sym_raw_text,
      anon_sym_LT_SLASH,
  [5136] = 2,
    ACTIONS(587), 1,
      anon_sym_RBRACE,
    ACTIONS(589), 1,
      sym_raw_text_expr,
  [5143] = 2,
    ACTIONS(591), 1,
      aux_sym_render_expr_token2,
    ACTIONS(593), 1,
      anon_sym_RPAREN,
  [5150] = 2,
    ACTIONS(595), 1,
      anon_sym_RBRACE,
    ACTIONS(597), 1,
      sym_raw_text_expr,
  [5157] = 2,
    ACTIONS(599), 1,
      aux_sym_render_expr_token2,
    ACTIONS(601), 1,
      anon_sym_RPAREN,
  [5164] = 1,
    ACTIONS(603), 1,
      anon_sym_RBRACE,
  [5168] = 1,
    ACTIONS(605), 1,
      sym_raw_text_expr,
  [5172] = 1,
    ACTIONS(607), 1,
      sym_raw_text_expr,
  [5176] = 1,
    ACTIONS(609), 1,
      anon_sym_RBRACE,
  [5180] = 1,
    ACTIONS(611), 1,
      aux_sym_render_expr_token1,
  [5184] = 1,
    ACTIONS(613), 1,
      sym_raw_text_expr,
  [5188] = 1,
    ACTIONS(615), 1,
      sym_raw_text_expr,
  [5192] = 1,
    ACTIONS(617), 1,
      anon_sym_RBRACE,
  [5196] = 1,
    ACTIONS(619), 1,
      aux_sym_render_expr_token1,
  [5200] = 1,
    ACTIONS(621), 1,
      anon_sym_LPAREN,
  [5204] = 1,
    ACTIONS(623), 1,
      sym_raw_text_expr,
  [5208] = 1,
    ACTIONS(625), 1,
      anon_sym_then,
  [5212] = 1,
    ACTIONS(627), 1,
      anon_sym_GT,
  [5216] = 1,
    ACTIONS(629), 1,
      anon_sym_RBRACE,
  [5220] = 1,
    ACTIONS(631), 1,
      anon_sym_RBRACE,
  [5224] = 1,
    ACTIONS(553), 1,
      anon_sym_RBRACE,
  [5228] = 1,
    ACTIONS(633), 1,
      anon_sym_RBRACE,
  [5232] = 1,
    ACTIONS(635), 1,
      anon_sym_else,
  [5236] = 1,
    ACTIONS(637), 1,
      anon_sym_as,
  [5240] = 1,
    ACTIONS(639), 1,
      anon_sym_if,
  [5244] = 1,
    ACTIONS(641), 1,
      anon_sym_RBRACE,
  [5248] = 1,
    ACTIONS(643), 1,
      anon_sym_RBRACE,
  [5252] = 1,
    ACTIONS(645), 1,
      anon_sym_RBRACE,
  [5256] = 1,
    ACTIONS(647), 1,
      anon_sym_else,
  [5260] = 1,
    ACTIONS(649), 1,
      sym__end_tag_name,
  [5264] = 1,
    ACTIONS(651), 1,
      anon_sym_RBRACE,
  [5268] = 1,
    ACTIONS(653), 1,
      anon_sym_each,
  [5272] = 1,
    ACTIONS(559), 1,
      anon_sym_catch,
  [5276] = 1,
    ACTIONS(655), 1,
      anon_sym_RBRACE,
  [5280] = 1,
    ACTIONS(657), 1,
      anon_sym_await,
  [5284] = 1,
    ACTIONS(659), 1,
      anon_sym_GT,
  [5288] = 1,
    ACTIONS(661), 1,
      anon_sym_RBRACE,
  [5292] = 1,
    ACTIONS(663), 1,
      anon_sym_RBRACE,
  [5296] = 1,
    ACTIONS(665), 1,
      anon_sym_snippet,
  [5300] = 1,
    ACTIONS(667), 1,
      anon_sym_LPAREN,
  [5304] = 1,
    ACTIONS(669), 1,
      ts_builtin_sym_end,
  [5308] = 1,
    ACTIONS(671), 1,
      anon_sym_key,
  [5312] = 1,
    ACTIONS(673), 1,
      anon_sym_RBRACE,
  [5316] = 1,
    ACTIONS(675), 1,
      anon_sym_RBRACE,
  [5320] = 1,
    ACTIONS(677), 1,
      anon_sym_RBRACE,
  [5324] = 1,
    ACTIONS(679), 1,
      anon_sym_RBRACE,
  [5328] = 1,
    ACTIONS(681), 1,
      anon_sym_RBRACE,
  [5332] = 1,
    ACTIONS(683), 1,
      anon_sym_RBRACE,
  [5336] = 1,
    ACTIONS(685), 1,
      anon_sym_RBRACE,
  [5340] = 1,
    ACTIONS(687), 1,
      anon_sym_RBRACE,
  [5344] = 1,
    ACTIONS(689), 1,
      anon_sym_RBRACE,
  [5348] = 1,
    ACTIONS(691), 1,
      anon_sym_RBRACE,
  [5352] = 1,
    ACTIONS(693), 1,
      anon_sym_SQUOTE,
  [5356] = 1,
    ACTIONS(693), 1,
      anon_sym_DQUOTE,
  [5360] = 1,
    ACTIONS(695), 1,
      anon_sym_RBRACE,
  [5364] = 1,
    ACTIONS(697), 1,
      anon_sym_RBRACE,
  [5368] = 1,
    ACTIONS(699), 1,
      anon_sym_RBRACE,
  [5372] = 1,
    ACTIONS(701), 1,
      anon_sym_RBRACE,
  [5376] = 1,
    ACTIONS(703), 1,
      anon_sym_RBRACE,
  [5380] = 1,
    ACTIONS(705), 1,
      anon_sym_RBRACE,
  [5384] = 1,
    ACTIONS(707), 1,
      anon_sym_RPAREN,
  [5388] = 1,
    ACTIONS(709), 1,
      sym__end_tag_name,
  [5392] = 1,
    ACTIONS(711), 1,
      sym_raw_text_expr,
  [5396] = 1,
    ACTIONS(713), 1,
      sym_raw_text_expr,
  [5400] = 1,
    ACTIONS(715), 1,
      anon_sym_if,
  [5404] = 1,
    ACTIONS(717), 1,
      anon_sym_RBRACE,
  [5408] = 1,
    ACTIONS(719), 1,
      anon_sym_each,
  [5412] = 1,
    ACTIONS(721), 1,
      anon_sym_RBRACE,
  [5416] = 1,
    ACTIONS(723), 1,
      anon_sym_await,
  [5420] = 1,
    ACTIONS(725), 1,
      anon_sym_RBRACE,
  [5424] = 1,
    ACTIONS(727), 1,
      anon_sym_RPAREN,
  [5428] = 1,
    ACTIONS(729), 1,
      anon_sym_snippet,
  [5432] = 1,
    ACTIONS(731), 1,
      anon_sym_key,
  [5436] = 1,
    ACTIONS(733), 1,
      anon_sym_DQUOTE,
  [5440] = 1,
    ACTIONS(735), 1,
      anon_sym_RPAREN,
  [5444] = 1,
    ACTIONS(733), 1,
      anon_sym_SQUOTE,
  [5448] = 1,
    ACTIONS(737), 1,
      anon_sym_RBRACE,
  [5452] = 1,
    ACTIONS(739), 1,
      anon_sym_RBRACE,
  [5456] = 1,
    ACTIONS(741), 1,
      anon_sym_RBRACE,
  [5460] = 1,
    ACTIONS(743), 1,
      sym_raw_text_expr,
  [5464] = 1,
    ACTIONS(745), 1,
      anon_sym_LPAREN,
  [5468] = 1,
    ACTIONS(747), 1,
      aux_sym_render_expr_token1,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 70,
  [SMALL_STATE(4)] = 140,
  [SMALL_STATE(5)] = 210,
  [SMALL_STATE(6)] = 280,
  [SMALL_STATE(7)] = 350,
  [SMALL_STATE(8)] = 420,
  [SMALL_STATE(9)] = 490,
  [SMALL_STATE(10)] = 560,
  [SMALL_STATE(11)] = 630,
  [SMALL_STATE(12)] = 700,
  [SMALL_STATE(13)] = 770,
  [SMALL_STATE(14)] = 840,
  [SMALL_STATE(15)] = 906,
  [SMALL_STATE(16)] = 972,
  [SMALL_STATE(17)] = 1038,
  [SMALL_STATE(18)] = 1106,
  [SMALL_STATE(19)] = 1174,
  [SMALL_STATE(20)] = 1240,
  [SMALL_STATE(21)] = 1306,
  [SMALL_STATE(22)] = 1372,
  [SMALL_STATE(23)] = 1440,
  [SMALL_STATE(24)] = 1506,
  [SMALL_STATE(25)] = 1572,
  [SMALL_STATE(26)] = 1640,
  [SMALL_STATE(27)] = 1703,
  [SMALL_STATE(28)] = 1765,
  [SMALL_STATE(29)] = 1827,
  [SMALL_STATE(30)] = 1889,
  [SMALL_STATE(31)] = 1951,
  [SMALL_STATE(32)] = 2013,
  [SMALL_STATE(33)] = 2075,
  [SMALL_STATE(34)] = 2137,
  [SMALL_STATE(35)] = 2199,
  [SMALL_STATE(36)] = 2261,
  [SMALL_STATE(37)] = 2323,
  [SMALL_STATE(38)] = 2385,
  [SMALL_STATE(39)] = 2447,
  [SMALL_STATE(40)] = 2509,
  [SMALL_STATE(41)] = 2571,
  [SMALL_STATE(42)] = 2633,
  [SMALL_STATE(43)] = 2695,
  [SMALL_STATE(44)] = 2757,
  [SMALL_STATE(45)] = 2819,
  [SMALL_STATE(46)] = 2881,
  [SMALL_STATE(47)] = 2943,
  [SMALL_STATE(48)] = 3005,
  [SMALL_STATE(49)] = 3067,
  [SMALL_STATE(50)] = 3090,
  [SMALL_STATE(51)] = 3113,
  [SMALL_STATE(52)] = 3134,
  [SMALL_STATE(53)] = 3155,
  [SMALL_STATE(54)] = 3178,
  [SMALL_STATE(55)] = 3199,
  [SMALL_STATE(56)] = 3222,
  [SMALL_STATE(57)] = 3234,
  [SMALL_STATE(58)] = 3246,
  [SMALL_STATE(59)] = 3266,
  [SMALL_STATE(60)] = 3278,
  [SMALL_STATE(61)] = 3298,
  [SMALL_STATE(62)] = 3310,
  [SMALL_STATE(63)] = 3322,
  [SMALL_STATE(64)] = 3334,
  [SMALL_STATE(65)] = 3346,
  [SMALL_STATE(66)] = 3358,
  [SMALL_STATE(67)] = 3370,
  [SMALL_STATE(68)] = 3382,
  [SMALL_STATE(69)] = 3394,
  [SMALL_STATE(70)] = 3406,
  [SMALL_STATE(71)] = 3418,
  [SMALL_STATE(72)] = 3438,
  [SMALL_STATE(73)] = 3450,
  [SMALL_STATE(74)] = 3462,
  [SMALL_STATE(75)] = 3474,
  [SMALL_STATE(76)] = 3486,
  [SMALL_STATE(77)] = 3498,
  [SMALL_STATE(78)] = 3518,
  [SMALL_STATE(79)] = 3530,
  [SMALL_STATE(80)] = 3542,
  [SMALL_STATE(81)] = 3554,
  [SMALL_STATE(82)] = 3566,
  [SMALL_STATE(83)] = 3578,
  [SMALL_STATE(84)] = 3590,
  [SMALL_STATE(85)] = 3602,
  [SMALL_STATE(86)] = 3614,
  [SMALL_STATE(87)] = 3626,
  [SMALL_STATE(88)] = 3638,
  [SMALL_STATE(89)] = 3650,
  [SMALL_STATE(90)] = 3662,
  [SMALL_STATE(91)] = 3674,
  [SMALL_STATE(92)] = 3686,
  [SMALL_STATE(93)] = 3698,
  [SMALL_STATE(94)] = 3710,
  [SMALL_STATE(95)] = 3722,
  [SMALL_STATE(96)] = 3734,
  [SMALL_STATE(97)] = 3746,
  [SMALL_STATE(98)] = 3758,
  [SMALL_STATE(99)] = 3770,
  [SMALL_STATE(100)] = 3782,
  [SMALL_STATE(101)] = 3794,
  [SMALL_STATE(102)] = 3806,
  [SMALL_STATE(103)] = 3818,
  [SMALL_STATE(104)] = 3830,
  [SMALL_STATE(105)] = 3850,
  [SMALL_STATE(106)] = 3862,
  [SMALL_STATE(107)] = 3873,
  [SMALL_STATE(108)] = 3884,
  [SMALL_STATE(109)] = 3895,
  [SMALL_STATE(110)] = 3906,
  [SMALL_STATE(111)] = 3917,
  [SMALL_STATE(112)] = 3928,
  [SMALL_STATE(113)] = 3939,
  [SMALL_STATE(114)] = 3950,
  [SMALL_STATE(115)] = 3961,
  [SMALL_STATE(116)] = 3972,
  [SMALL_STATE(117)] = 3983,
  [SMALL_STATE(118)] = 3994,
  [SMALL_STATE(119)] = 4005,
  [SMALL_STATE(120)] = 4016,
  [SMALL_STATE(121)] = 4027,
  [SMALL_STATE(122)] = 4038,
  [SMALL_STATE(123)] = 4049,
  [SMALL_STATE(124)] = 4060,
  [SMALL_STATE(125)] = 4071,
  [SMALL_STATE(126)] = 4082,
  [SMALL_STATE(127)] = 4093,
  [SMALL_STATE(128)] = 4104,
  [SMALL_STATE(129)] = 4115,
  [SMALL_STATE(130)] = 4126,
  [SMALL_STATE(131)] = 4137,
  [SMALL_STATE(132)] = 4148,
  [SMALL_STATE(133)] = 4159,
  [SMALL_STATE(134)] = 4170,
  [SMALL_STATE(135)] = 4181,
  [SMALL_STATE(136)] = 4192,
  [SMALL_STATE(137)] = 4203,
  [SMALL_STATE(138)] = 4214,
  [SMALL_STATE(139)] = 4225,
  [SMALL_STATE(140)] = 4236,
  [SMALL_STATE(141)] = 4247,
  [SMALL_STATE(142)] = 4258,
  [SMALL_STATE(143)] = 4269,
  [SMALL_STATE(144)] = 4280,
  [SMALL_STATE(145)] = 4291,
  [SMALL_STATE(146)] = 4302,
  [SMALL_STATE(147)] = 4313,
  [SMALL_STATE(148)] = 4324,
  [SMALL_STATE(149)] = 4335,
  [SMALL_STATE(150)] = 4345,
  [SMALL_STATE(151)] = 4361,
  [SMALL_STATE(152)] = 4369,
  [SMALL_STATE(153)] = 4379,
  [SMALL_STATE(154)] = 4389,
  [SMALL_STATE(155)] = 4399,
  [SMALL_STATE(156)] = 4415,
  [SMALL_STATE(157)] = 4425,
  [SMALL_STATE(158)] = 4441,
  [SMALL_STATE(159)] = 4451,
  [SMALL_STATE(160)] = 4461,
  [SMALL_STATE(161)] = 4471,
  [SMALL_STATE(162)] = 4481,
  [SMALL_STATE(163)] = 4491,
  [SMALL_STATE(164)] = 4501,
  [SMALL_STATE(165)] = 4517,
  [SMALL_STATE(166)] = 4533,
  [SMALL_STATE(167)] = 4543,
  [SMALL_STATE(168)] = 4559,
  [SMALL_STATE(169)] = 4569,
  [SMALL_STATE(170)] = 4585,
  [SMALL_STATE(171)] = 4595,
  [SMALL_STATE(172)] = 4605,
  [SMALL_STATE(173)] = 4621,
  [SMALL_STATE(174)] = 4637,
  [SMALL_STATE(175)] = 4647,
  [SMALL_STATE(176)] = 4654,
  [SMALL_STATE(177)] = 4667,
  [SMALL_STATE(178)] = 4680,
  [SMALL_STATE(179)] = 4687,
  [SMALL_STATE(180)] = 4694,
  [SMALL_STATE(181)] = 4707,
  [SMALL_STATE(182)] = 4720,
  [SMALL_STATE(183)] = 4733,
  [SMALL_STATE(184)] = 4746,
  [SMALL_STATE(185)] = 4759,
  [SMALL_STATE(186)] = 4766,
  [SMALL_STATE(187)] = 4773,
  [SMALL_STATE(188)] = 4786,
  [SMALL_STATE(189)] = 4793,
  [SMALL_STATE(190)] = 4806,
  [SMALL_STATE(191)] = 4813,
  [SMALL_STATE(192)] = 4826,
  [SMALL_STATE(193)] = 4835,
  [SMALL_STATE(194)] = 4848,
  [SMALL_STATE(195)] = 4855,
  [SMALL_STATE(196)] = 4868,
  [SMALL_STATE(197)] = 4878,
  [SMALL_STATE(198)] = 4884,
  [SMALL_STATE(199)] = 4890,
  [SMALL_STATE(200)] = 4896,
  [SMALL_STATE(201)] = 4902,
  [SMALL_STATE(202)] = 4908,
  [SMALL_STATE(203)] = 4914,
  [SMALL_STATE(204)] = 4920,
  [SMALL_STATE(205)] = 4930,
  [SMALL_STATE(206)] = 4940,
  [SMALL_STATE(207)] = 4950,
  [SMALL_STATE(208)] = 4960,
  [SMALL_STATE(209)] = 4970,
  [SMALL_STATE(210)] = 4980,
  [SMALL_STATE(211)] = 4990,
  [SMALL_STATE(212)] = 4997,
  [SMALL_STATE(213)] = 5004,
  [SMALL_STATE(214)] = 5011,
  [SMALL_STATE(215)] = 5018,
  [SMALL_STATE(216)] = 5025,
  [SMALL_STATE(217)] = 5032,
  [SMALL_STATE(218)] = 5039,
  [SMALL_STATE(219)] = 5046,
  [SMALL_STATE(220)] = 5051,
  [SMALL_STATE(221)] = 5058,
  [SMALL_STATE(222)] = 5065,
  [SMALL_STATE(223)] = 5070,
  [SMALL_STATE(224)] = 5077,
  [SMALL_STATE(225)] = 5084,
  [SMALL_STATE(226)] = 5091,
  [SMALL_STATE(227)] = 5098,
  [SMALL_STATE(228)] = 5105,
  [SMALL_STATE(229)] = 5112,
  [SMALL_STATE(230)] = 5119,
  [SMALL_STATE(231)] = 5126,
  [SMALL_STATE(232)] = 5131,
  [SMALL_STATE(233)] = 5136,
  [SMALL_STATE(234)] = 5143,
  [SMALL_STATE(235)] = 5150,
  [SMALL_STATE(236)] = 5157,
  [SMALL_STATE(237)] = 5164,
  [SMALL_STATE(238)] = 5168,
  [SMALL_STATE(239)] = 5172,
  [SMALL_STATE(240)] = 5176,
  [SMALL_STATE(241)] = 5180,
  [SMALL_STATE(242)] = 5184,
  [SMALL_STATE(243)] = 5188,
  [SMALL_STATE(244)] = 5192,
  [SMALL_STATE(245)] = 5196,
  [SMALL_STATE(246)] = 5200,
  [SMALL_STATE(247)] = 5204,
  [SMALL_STATE(248)] = 5208,
  [SMALL_STATE(249)] = 5212,
  [SMALL_STATE(250)] = 5216,
  [SMALL_STATE(251)] = 5220,
  [SMALL_STATE(252)] = 5224,
  [SMALL_STATE(253)] = 5228,
  [SMALL_STATE(254)] = 5232,
  [SMALL_STATE(255)] = 5236,
  [SMALL_STATE(256)] = 5240,
  [SMALL_STATE(257)] = 5244,
  [SMALL_STATE(258)] = 5248,
  [SMALL_STATE(259)] = 5252,
  [SMALL_STATE(260)] = 5256,
  [SMALL_STATE(261)] = 5260,
  [SMALL_STATE(262)] = 5264,
  [SMALL_STATE(263)] = 5268,
  [SMALL_STATE(264)] = 5272,
  [SMALL_STATE(265)] = 5276,
  [SMALL_STATE(266)] = 5280,
  [SMALL_STATE(267)] = 5284,
  [SMALL_STATE(268)] = 5288,
  [SMALL_STATE(269)] = 5292,
  [SMALL_STATE(270)] = 5296,
  [SMALL_STATE(271)] = 5300,
  [SMALL_STATE(272)] = 5304,
  [SMALL_STATE(273)] = 5308,
  [SMALL_STATE(274)] = 5312,
  [SMALL_STATE(275)] = 5316,
  [SMALL_STATE(276)] = 5320,
  [SMALL_STATE(277)] = 5324,
  [SMALL_STATE(278)] = 5328,
  [SMALL_STATE(279)] = 5332,
  [SMALL_STATE(280)] = 5336,
  [SMALL_STATE(281)] = 5340,
  [SMALL_STATE(282)] = 5344,
  [SMALL_STATE(283)] = 5348,
  [SMALL_STATE(284)] = 5352,
  [SMALL_STATE(285)] = 5356,
  [SMALL_STATE(286)] = 5360,
  [SMALL_STATE(287)] = 5364,
  [SMALL_STATE(288)] = 5368,
  [SMALL_STATE(289)] = 5372,
  [SMALL_STATE(290)] = 5376,
  [SMALL_STATE(291)] = 5380,
  [SMALL_STATE(292)] = 5384,
  [SMALL_STATE(293)] = 5388,
  [SMALL_STATE(294)] = 5392,
  [SMALL_STATE(295)] = 5396,
  [SMALL_STATE(296)] = 5400,
  [SMALL_STATE(297)] = 5404,
  [SMALL_STATE(298)] = 5408,
  [SMALL_STATE(299)] = 5412,
  [SMALL_STATE(300)] = 5416,
  [SMALL_STATE(301)] = 5420,
  [SMALL_STATE(302)] = 5424,
  [SMALL_STATE(303)] = 5428,
  [SMALL_STATE(304)] = 5432,
  [SMALL_STATE(305)] = 5436,
  [SMALL_STATE(306)] = 5440,
  [SMALL_STATE(307)] = 5444,
  [SMALL_STATE(308)] = 5448,
  [SMALL_STATE(309)] = 5452,
  [SMALL_STATE(310)] = 5456,
  [SMALL_STATE(311)] = 5460,
  [SMALL_STATE(312)] = 5464,
  [SMALL_STATE(313)] = 5468,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_document, 0),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(210),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [13] = {.entry = {.count = 1, .reusable = false}}, SHIFT(165),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(150),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [21] = {.entry = {.count = 1, .reusable = false}}, SHIFT(167),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [27] = {.entry = {.count = 1, .reusable = false}}, SHIFT(172),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [35] = {.entry = {.count = 1, .reusable = false}}, SHIFT(155),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [39] = {.entry = {.count = 1, .reusable = false}}, SHIFT(173),
  [41] = {.entry = {.count = 1, .reusable = false}}, SHIFT(208),
  [43] = {.entry = {.count = 1, .reusable = true}}, SHIFT(293),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [47] = {.entry = {.count = 1, .reusable = false}}, SHIFT(207),
  [49] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [51] = {.entry = {.count = 1, .reusable = true}}, SHIFT(261),
  [53] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [55] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [57] = {.entry = {.count = 1, .reusable = false}}, SHIFT(169),
  [59] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [61] = {.entry = {.count = 1, .reusable = false}}, SHIFT(164),
  [63] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [65] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [67] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [69] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [71] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(208),
  [74] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2),
  [76] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(26),
  [79] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(207),
  [82] = {.entry = {.count = 1, .reusable = false}}, SHIFT(180),
  [84] = {.entry = {.count = 1, .reusable = false}}, SHIFT(195),
  [86] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [88] = {.entry = {.count = 1, .reusable = false}}, SHIFT(184),
  [90] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_document, 1),
  [92] = {.entry = {.count = 1, .reusable = false}}, SHIFT(181),
  [94] = {.entry = {.count = 1, .reusable = false}}, SHIFT(187),
  [96] = {.entry = {.count = 1, .reusable = false}}, SHIFT(182),
  [98] = {.entry = {.count = 1, .reusable = false}}, SHIFT(183),
  [100] = {.entry = {.count = 1, .reusable = false}}, SHIFT(193),
  [102] = {.entry = {.count = 1, .reusable = false}}, SHIFT(191),
  [104] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [106] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [108] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [110] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [112] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [114] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [116] = {.entry = {.count = 1, .reusable = false}}, SHIFT(177),
  [118] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [120] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [122] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [124] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(209),
  [127] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(48),
  [130] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(210),
  [133] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [135] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [137] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [139] = {.entry = {.count = 1, .reusable = true}}, SHIFT(238),
  [141] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [143] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [145] = {.entry = {.count = 1, .reusable = true}}, SHIFT(194),
  [147] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [149] = {.entry = {.count = 1, .reusable = true}}, SHIFT(226),
  [151] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_start_tag_repeat1, 2),
  [153] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_start_tag_repeat1, 2), SHIFT_REPEAT(151),
  [156] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_start_tag_repeat1, 2), SHIFT_REPEAT(238),
  [159] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [161] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [163] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(216),
  [167] = {.entry = {.count = 1, .reusable = true}}, SHIFT(294),
  [169] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [171] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_if_statement, 3),
  [173] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_if_statement, 3),
  [175] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_each_statement, 3),
  [177] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_each_statement, 3),
  [179] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [181] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [183] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_end_expr, 4),
  [185] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_end_expr, 4),
  [187] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [189] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_debug_expr, 5),
  [191] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_debug_expr, 5),
  [193] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_const_expr, 5),
  [195] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_const_expr, 5),
  [197] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_html_expr, 5),
  [199] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_html_expr, 5),
  [201] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_catch_statement, 3),
  [203] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_catch_statement, 3),
  [205] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_then_statement, 3),
  [207] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_then_statement, 3),
  [209] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_each_statement, 3),
  [211] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_each_statement, 3),
  [213] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_statement, 3),
  [215] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_statement, 3),
  [217] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_end_tag, 3),
  [219] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_end_tag, 3),
  [221] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_const_expr, 4),
  [223] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_const_expr, 4),
  [225] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_html_expr, 4),
  [227] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_html_expr, 4),
  [229] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_start_tag_repeat1, 2), SHIFT_REPEAT(186),
  [232] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_start_tag_repeat1, 2), SHIFT_REPEAT(294),
  [235] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_self_closing_tag, 4),
  [237] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_self_closing_tag, 4),
  [239] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_key_statement, 3),
  [241] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_key_statement, 3),
  [243] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_snippet_statement, 3),
  [245] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_snippet_statement, 3),
  [247] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_await_statement, 3),
  [249] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_await_statement, 3),
  [251] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_catch_statement, 2),
  [253] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_catch_statement, 2),
  [255] = {.entry = {.count = 1, .reusable = true}}, SHIFT(232),
  [257] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_element, 1),
  [259] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_element, 1),
  [261] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_then_statement, 2),
  [263] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_then_statement, 2),
  [265] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_await_end_expr, 4),
  [267] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_await_end_expr, 4),
  [269] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_each_end_expr, 4),
  [271] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_each_end_expr, 4),
  [273] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_each_statement, 2),
  [275] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_each_statement, 2),
  [277] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 3),
  [279] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 3),
  [281] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_if_statement, 2),
  [283] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_if_statement, 2),
  [285] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_statement, 2),
  [287] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_statement, 2),
  [289] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_snippet_end_expr, 4),
  [291] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_snippet_end_expr, 4),
  [293] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_style_element, 3),
  [295] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_style_element, 3),
  [297] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_script_element, 3),
  [299] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_script_element, 3),
  [301] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_element, 3),
  [303] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_element, 3),
  [305] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expression, 3),
  [307] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expression, 3),
  [309] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_self_closing_tag, 3),
  [311] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_self_closing_tag, 3),
  [313] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_key_end_expr, 4),
  [315] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_key_end_expr, 4),
  [317] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_render_expr, 7),
  [319] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_render_expr, 7),
  [321] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_key_statement, 2),
  [323] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_key_statement, 2),
  [325] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_render_expr, 8),
  [327] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_render_expr, 8),
  [329] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_snippet_statement, 2),
  [331] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_snippet_statement, 2),
  [333] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_await_statement, 2),
  [335] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_await_statement, 2),
  [337] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_each_statement, 2),
  [339] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_each_statement, 2),
  [341] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 2),
  [343] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 2),
  [345] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_style_element, 2),
  [347] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_style_element, 2),
  [349] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_start_tag, 3),
  [351] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_start_tag, 3),
  [353] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_start_tag, 4),
  [355] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_start_tag, 4),
  [357] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_script_element, 2),
  [359] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_script_element, 2),
  [361] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [363] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_element, 2),
  [365] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_element, 2),
  [367] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_catch_expr, 4),
  [369] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_catch_expr, 4),
  [371] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [373] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [375] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [377] = {.entry = {.count = 1, .reusable = true}}, SHIFT(300),
  [379] = {.entry = {.count = 1, .reusable = true}}, SHIFT(268),
  [381] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute_name, 1),
  [383] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute, 1),
  [385] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [387] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_start_expr, 5),
  [389] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_start_expr, 5),
  [391] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_each_start_expr, 5),
  [393] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_each_start_expr, 5),
  [395] = {.entry = {.count = 1, .reusable = true}}, SHIFT(264),
  [397] = {.entry = {.count = 1, .reusable = true}}, SHIFT(266),
  [399] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_await_start_expr, 5),
  [401] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_await_start_expr, 5),
  [403] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [405] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
  [407] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [409] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [411] = {.entry = {.count = 1, .reusable = true}}, SHIFT(247),
  [413] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_snippet_start_expr, 8),
  [415] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_snippet_start_expr, 8),
  [417] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_key_start_expr, 5),
  [419] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_key_start_expr, 5),
  [421] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_expr, 4),
  [423] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_expr, 4),
  [425] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_if_expr, 6),
  [427] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_if_expr, 6),
  [429] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_then_expr, 5),
  [431] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_then_expr, 5),
  [433] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_then_expr, 4),
  [435] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_then_expr, 4),
  [437] = {.entry = {.count = 1, .reusable = true}}, SHIFT(260),
  [439] = {.entry = {.count = 1, .reusable = true}}, SHIFT(298),
  [441] = {.entry = {.count = 1, .reusable = true}}, SHIFT(254),
  [443] = {.entry = {.count = 1, .reusable = true}}, SHIFT(296),
  [445] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_snippet_start_expr, 7),
  [447] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_snippet_start_expr, 7),
  [449] = {.entry = {.count = 1, .reusable = true}}, SHIFT(256),
  [451] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_await_start_expr, 7, .production_id = 2),
  [453] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_await_start_expr, 7, .production_id = 2),
  [455] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_each_start_expr, 7),
  [457] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_each_start_expr, 7),
  [459] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_catch_expr, 5),
  [461] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_catch_expr, 5),
  [463] = {.entry = {.count = 1, .reusable = true}}, SHIFT(263),
  [465] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_if_expr, 5),
  [467] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_if_expr, 5),
  [469] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [471] = {.entry = {.count = 1, .reusable = true}}, SHIFT(235),
  [473] = {.entry = {.count = 1, .reusable = true}}, SHIFT(313),
  [475] = {.entry = {.count = 1, .reusable = true}}, SHIFT(295),
  [477] = {.entry = {.count = 1, .reusable = true}}, SHIFT(270),
  [479] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr_attribute_value, 1),
  [481] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quoted_attribute_value, 3),
  [483] = {.entry = {.count = 1, .reusable = true}}, SHIFT(273),
  [485] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quoted_attribute_value, 2),
  [487] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute, 1, .production_id = 1),
  [489] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [491] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [493] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [495] = {.entry = {.count = 1, .reusable = true}}, SHIFT(242),
  [497] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute, 3),
  [499] = {.entry = {.count = 1, .reusable = true}}, SHIFT(303),
  [501] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [503] = {.entry = {.count = 1, .reusable = true}}, SHIFT(304),
  [505] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute_value, 1),
  [507] = {.entry = {.count = 1, .reusable = true}}, SHIFT(217),
  [509] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [511] = {.entry = {.count = 1, .reusable = true}}, SHIFT(215),
  [513] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [515] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [517] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [519] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [521] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [523] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [525] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [527] = {.entry = {.count = 1, .reusable = true}}, SHIFT(149),
  [529] = {.entry = {.count = 1, .reusable = true}}, SHIFT(309),
  [531] = {.entry = {.count = 1, .reusable = false}}, SHIFT(200),
  [533] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [535] = {.entry = {.count = 1, .reusable = true}}, SHIFT(163),
  [537] = {.entry = {.count = 1, .reusable = true}}, SHIFT(310),
  [539] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [541] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_style_start_tag, 4),
  [543] = {.entry = {.count = 1, .reusable = true}}, SHIFT(251),
  [545] = {.entry = {.count = 1, .reusable = true}}, SHIFT(248),
  [547] = {.entry = {.count = 1, .reusable = true}}, SHIFT(257),
  [549] = {.entry = {.count = 1, .reusable = true}}, SHIFT(255),
  [551] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_script_start_tag, 4),
  [553] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [555] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [557] = {.entry = {.count = 1, .reusable = true}}, SHIFT(214),
  [559] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [561] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [563] = {.entry = {.count = 1, .reusable = true}}, SHIFT(274),
  [565] = {.entry = {.count = 1, .reusable = false}}, SHIFT(185),
  [567] = {.entry = {.count = 1, .reusable = true}}, SHIFT(305),
  [569] = {.entry = {.count = 1, .reusable = true}}, SHIFT(307),
  [571] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [573] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [575] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [577] = {.entry = {.count = 1, .reusable = true}}, SHIFT(308),
  [579] = {.entry = {.count = 1, .reusable = true}}, SHIFT(306),
  [581] = {.entry = {.count = 1, .reusable = false}}, SHIFT(286),
  [583] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_style_start_tag, 3),
  [585] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_script_start_tag, 3),
  [587] = {.entry = {.count = 1, .reusable = true}}, SHIFT(174),
  [589] = {.entry = {.count = 1, .reusable = true}}, SHIFT(290),
  [591] = {.entry = {.count = 1, .reusable = true}}, SHIFT(292),
  [593] = {.entry = {.count = 1, .reusable = false}}, SHIFT(291),
  [595] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [597] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [599] = {.entry = {.count = 1, .reusable = true}}, SHIFT(302),
  [601] = {.entry = {.count = 1, .reusable = false}}, SHIFT(301),
  [603] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [605] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [607] = {.entry = {.count = 1, .reusable = true}}, SHIFT(299),
  [609] = {.entry = {.count = 1, .reusable = true}}, SHIFT(146),
  [611] = {.entry = {.count = 1, .reusable = true}}, SHIFT(271),
  [613] = {.entry = {.count = 1, .reusable = true}}, SHIFT(262),
  [615] = {.entry = {.count = 1, .reusable = true}}, SHIFT(259),
  [617] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [619] = {.entry = {.count = 1, .reusable = true}}, SHIFT(246),
  [621] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [623] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [625] = {.entry = {.count = 1, .reusable = true}}, SHIFT(311),
  [627] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [629] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [631] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [633] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [635] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [637] = {.entry = {.count = 1, .reusable = true}}, SHIFT(239),
  [639] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [641] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [643] = {.entry = {.count = 1, .reusable = true}}, SHIFT(143),
  [645] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [647] = {.entry = {.count = 1, .reusable = true}}, SHIFT(252),
  [649] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [651] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [653] = {.entry = {.count = 1, .reusable = true}}, SHIFT(253),
  [655] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [657] = {.entry = {.count = 1, .reusable = true}}, SHIFT(258),
  [659] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [661] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [663] = {.entry = {.count = 1, .reusable = true}}, SHIFT(148),
  [665] = {.entry = {.count = 1, .reusable = true}}, SHIFT(265),
  [667] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [669] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [671] = {.entry = {.count = 1, .reusable = true}}, SHIFT(269),
  [673] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [675] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [677] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [679] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [681] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [683] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [685] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [687] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [689] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [691] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [693] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [695] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [697] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [699] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [701] = {.entry = {.count = 1, .reusable = true}}, SHIFT(197),
  [703] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [705] = {.entry = {.count = 1, .reusable = true}}, SHIFT(166),
  [707] = {.entry = {.count = 1, .reusable = true}}, SHIFT(282),
  [709] = {.entry = {.count = 1, .reusable = true}}, SHIFT(267),
  [711] = {.entry = {.count = 1, .reusable = true}}, SHIFT(289),
  [713] = {.entry = {.count = 1, .reusable = true}}, SHIFT(276),
  [715] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [717] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [719] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [721] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [723] = {.entry = {.count = 1, .reusable = true}}, SHIFT(279),
  [725] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [727] = {.entry = {.count = 1, .reusable = true}}, SHIFT(283),
  [729] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [731] = {.entry = {.count = 1, .reusable = true}}, SHIFT(281),
  [733] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [735] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [737] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [739] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [741] = {.entry = {.count = 1, .reusable = true}}, SHIFT(162),
  [743] = {.entry = {.count = 1, .reusable = true}}, SHIFT(297),
  [745] = {.entry = {.count = 1, .reusable = true}}, SHIFT(230),
  [747] = {.entry = {.count = 1, .reusable = true}}, SHIFT(312),
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_svelte_external_scanner_create(void);
void tree_sitter_svelte_external_scanner_destroy(void *);
bool tree_sitter_svelte_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_svelte_external_scanner_serialize(void *, char *);
void tree_sitter_svelte_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_svelte(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .external_scanner = {
      &ts_external_scanner_states[0][0],
      ts_external_scanner_symbol_map,
      tree_sitter_svelte_external_scanner_create,
      tree_sitter_svelte_external_scanner_destroy,
      tree_sitter_svelte_external_scanner_scan,
      tree_sitter_svelte_external_scanner_serialize,
      tree_sitter_svelte_external_scanner_deserialize,
    },
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
