/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	corev1 "k8s.io/api/core/v1"
)

// ContainerRestartRuleApplyConfiguration represents a declarative configuration of the ContainerRestartRule type for use
// with apply.
//
// ContainerRestartRule describes how a container exit is handled.
type ContainerRestartRuleApplyConfiguration struct {
	// Specifies the action taken on a container exit if the requirements
	// are satisfied. The only possible value is "Restart" to restart the
	// container.
	Action *corev1.ContainerRestartRuleAction `json:"action,omitempty"`
	// Represents the exit codes to check on container exits.
	ExitCodes *ContainerRestartRuleOnExitCodesApplyConfiguration `json:"exitCodes,omitempty"`
}

// ContainerRestartRuleApplyConfiguration constructs a declarative configuration of the ContainerRestartRule type for use with
// apply.
func ContainerRestartRule() *ContainerRestartRuleApplyConfiguration {
	return &ContainerRestartRuleApplyConfiguration{}
}

// WithAction sets the Action field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Action field is set to the value of the last call.
func (b *ContainerRestartRuleApplyConfiguration) WithAction(value corev1.ContainerRestartRuleAction) *ContainerRestartRuleApplyConfiguration {
	b.Action = &value
	return b
}

// WithExitCodes sets the ExitCodes field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ExitCodes field is set to the value of the last call.
func (b *ContainerRestartRuleApplyConfiguration) WithExitCodes(value *ContainerRestartRuleOnExitCodesApplyConfiguration) *ContainerRestartRuleApplyConfiguration {
	b.ExitCodes = value
	return b
}
