
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "ktoolbarpopupaction_wrapper.h"

// Wrappers providing overrides
#include "kxyselector_wrapper.h"
#include "ktoolbarspaceraction_wrapper.h"

// Argument includes
#include <QString>
#include <ktoolbarpopupaction.h>
#include <qcoreevent.h>
#include <qicon.h>
#include <qmenu.h>
#include <qmetaobject.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qwidget.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KToolBarPopupAction_Type = nullptr;
static PyTypeObject *Sbk_KToolBarPopupAction_TypeF(void)
{
    return _Sbk_KToolBarPopupAction_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KToolBarPopupActionWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KToolBarPopupActionWrapper::KToolBarPopupActionWrapper(const ::QIcon & icon, const ::QString & text, ::QObject * parent) : KToolBarPopupAction(icon, text, parent)
{
}

void KToolBarPopupActionWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KToolBarPopupAction_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KToolBarPopupAction", funcName, gil, pyOverride, event);
}

void KToolBarPopupActionWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KToolBarPopupAction_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KToolBarPopupAction", funcName, gil, pyOverride, signal);
}

::QWidget * KToolBarPopupActionWrapper::createWidget(::QWidget * parent)
{
    static const char *funcName = "createWidget";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KToolBarPopupAction_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::KToolBarPopupAction::createWidget(parent);
    }
    return KToolBarSpacerActionWrapper::sbk_o_createWidget("KToolBarPopupAction", funcName, gil, pyOverride, parent);
}

void KToolBarPopupActionWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KToolBarPopupAction_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KToolBarPopupAction", funcName, gil, pyOverride, event);
}

void KToolBarPopupActionWrapper::deleteWidget(::QWidget * widget)
{
    static const char *funcName = "deleteWidget";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KToolBarPopupAction_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidgetAction::deleteWidget(widget);
    }
    KToolBarSpacerActionWrapper::sbk_o_deleteWidget("KToolBarPopupAction", funcName, gil, pyOverride, widget);
}

void KToolBarPopupActionWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KToolBarPopupAction_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KToolBarPopupAction", funcName, gil, pyOverride, signal);
}

bool KToolBarPopupActionWrapper::event(::QEvent * arg__1)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KToolBarPopupAction_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidgetAction::event(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_event("KToolBarPopupAction", funcName, gil, pyOverride, arg__1);
}

bool KToolBarPopupActionWrapper::eventFilter(::QObject * arg__1, ::QEvent * arg__2)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KToolBarPopupAction_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidgetAction::eventFilter(arg__1, arg__2);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KToolBarPopupAction", funcName, gil, pyOverride, arg__1, arg__2);
}

void KToolBarPopupActionWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KToolBarPopupAction_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KToolBarPopupAction", funcName, gil, pyOverride, event);
}

const QMetaObject *KToolBarPopupActionWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KToolBarPopupAction::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KToolBarPopupActionWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KToolBarPopupAction::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KToolBarPopupActionWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KToolBarPopupActionWrapper *>(this));
    }
    return KToolBarPopupAction::qt_metacast(_clname);
}

KToolBarPopupActionWrapper::~KToolBarPopupActionWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KToolBarPopupAction_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KToolBarPopupAction_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KToolBarPopupAction >()))
        return -1;

    KToolBarPopupActionWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "KToolBarPopupAction", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KToolBarPopupAction::KToolBarPopupAction(QIcon,QString,QObject*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[2])))) {
        overloadId = 0; // KToolBarPopupAction(QIcon,QString,QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KToolBarPopupAction_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KToolBarPopupAction_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QIcon cppArg0_local;
        ::QIcon *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return -1;
        ::QObject *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KToolBarPopupAction(QIcon,QString,QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KToolBarPopupActionWrapper(*cppArg0, cppArg1, cppArg2);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KToolBarPopupActionWrapper(*cppArg0, cppArg1, cppArg2);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KToolBarPopupAction >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KToolBarPopupAction_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KToolBarPopupAction_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KToolBarPopupActionFunc_createWidget(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KToolBarPopupAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KToolBarPopupAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidgetAction::createWidget(QWidget*)->QWidget*
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArg)))) {
        overloadId = 0; // createWidget(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "createWidget", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KToolBarPopupAction_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // createWidget(QWidget*)
            QWidget * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KToolBarPopupAction::createWidget(cppArg0)
                : cppSelf->createWidget(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KToolBarPopupActionFunc_popupMenu(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KToolBarPopupAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KToolBarPopupAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // popupMenu()const
        QMenu * cppResult = const_cast<const ::KToolBarPopupAction *>(cppSelf)->popupMenu();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QMenu_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KToolBarPopupActionFunc_popupMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KToolBarPopupAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KToolBarPopupAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // popupMode()const
        KToolBarPopupAction::PopupMode cppResult = const_cast<const ::KToolBarPopupAction *>(cppSelf)->popupMode();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KToolBarPopupAction_PopupMode_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KToolBarPopupActionFunc_setPopupMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KToolBarPopupAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KToolBarPopupAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KToolBarPopupAction::setPopupMode(KToolBarPopupAction::PopupMode)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KToolBarPopupAction_PopupMode_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // setPopupMode(KToolBarPopupAction::PopupMode)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setPopupMode", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KToolBarPopupAction_IDX]);

    // Call function/method
    {
        ::KToolBarPopupAction::PopupMode cppArg0{KToolBarPopupAction::DelayedPopup};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setPopupMode(KToolBarPopupAction::PopupMode)
            cppSelf->setPopupMode(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KToolBarPopupAction_PropertyStrings[] = {
    "popupMode::",
    nullptr // Sentinel
};

static const char *Sbk_KToolBarPopupAction_EnumFlagInfo[] = {
    "PopupMode:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KToolBarPopupAction_methods[] = {
    {"createWidget", reinterpret_cast<PyCFunction>(Sbk_KToolBarPopupActionFunc_createWidget), METH_O, nullptr},
    {"popupMenu", reinterpret_cast<PyCFunction>(Sbk_KToolBarPopupActionFunc_popupMenu), METH_NOARGS, nullptr},
    {"popupMode", reinterpret_cast<PyCFunction>(Sbk_KToolBarPopupActionFunc_popupMode), METH_NOARGS, nullptr},
    {"setPopupMode", reinterpret_cast<PyCFunction>(Sbk_KToolBarPopupActionFunc_setPopupMode), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KToolBarPopupAction_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KToolBarPopupAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KToolBarPopupAction_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KToolBarPopupActionWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KToolBarPopupAction_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KToolBarPopupAction_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KToolBarPopupAction_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KToolBarPopupAction_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KToolBarPopupAction_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KToolBarPopupAction_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KToolBarPopupAction_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KToolBarPopupAction_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KToolBarPopupAction_spec = {
    "1:KWidgetsAddons.KToolBarPopupAction",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KToolBarPopupAction_slots
};

} //extern "C"

static void *Sbk_KToolBarPopupAction_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KToolBarPopupAction *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KToolBarPopupAction_PopupMode(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KToolBarPopupAction::PopupMode>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KToolBarPopupAction::PopupMode *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KToolBarPopupAction_PopupMode_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KToolBarPopupAction_PopupMode_IDX])))
        return Enum_PythonToCpp_KToolBarPopupAction_PopupMode;
    return {};
}

static PyObject *KToolBarPopupAction_PopupMode_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KToolBarPopupAction::PopupMode>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KToolBarPopupAction::PopupMode *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KToolBarPopupAction_PythonToCpp_KToolBarPopupAction_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KToolBarPopupAction_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KToolBarPopupAction_PythonToCpp_KToolBarPopupAction_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KToolBarPopupAction_TypeF()))
        return KToolBarPopupAction_PythonToCpp_KToolBarPopupAction_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KToolBarPopupAction_PTR_CppToPython_KToolBarPopupAction(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KToolBarPopupAction *>(const_cast<void *>(cppIn)), Sbk_KToolBarPopupAction_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KToolBarPopupAction_SignatureStrings[] = {
    "KWidgetsAddons.KToolBarPopupAction(self,icon:typing.Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap],text:QString,parent:PySide6.QtCore.QObject,*:KeywordOnly=None,popupMode:KWidgetsAddons.KToolBarPopupAction.PopupMode=None)",
    "KWidgetsAddons.KToolBarPopupAction.createWidget(self,parent:PySide6.QtWidgets.QWidget)->PySide6.QtWidgets.QWidget",
    "KWidgetsAddons.KToolBarPopupAction.popupMenu(self)->PySide6.QtWidgets.QMenu",
    "KWidgetsAddons.KToolBarPopupAction.popupMode(self)->KWidgetsAddons.KToolBarPopupAction.PopupMode",
    "KWidgetsAddons.KToolBarPopupAction.setPopupMode(self,popupMode:KWidgetsAddons.KToolBarPopupAction.PopupMode)",
    nullptr}; // Sentinel
#else
static constexpr size_t KToolBarPopupAction_SignatureByteSize = 220;
static constexpr uint8_t KToolBarPopupAction_SignatureBytes[220] = {
    0x78, 0xda, 0x9d, 0x51, 0xbd, 0x6e, 0xc2, 0x30, 0x10, 0xde, 0x79, 0x0a, 0xc6, 0xa6, 0x72, 0x3d,
    0x32, 0x58, 0x2a, 0x12, 0xed, 0x80, 0x50, 0x04, 0xd8, 0xa2, 0x88, 0x01, 0x31, 0xa4, 0xf1, 0x11,
    0x19, 0x85, 0x3b, 0xcb, 0xb9, 0x08, 0xf2, 0xf6, 0x0d, 0x04, 0x84, 0x28, 0x54, 0xa4, 0x6c, 0xd6,
    0xdd, 0xf7, 0x7b, 0x8e, 0x17, 0xce, 0x66, 0xc0, 0xc5, 0xc0, 0x5a, 0xc2, 0x42, 0xc6, 0x5f, 0x44,
    0xf9, 0x47, 0x12, 0x34, 0xf9, 0xd2, 0x0f, 0x52, 0x76, 0x84, 0x2f, 0x05, 0xe4, 0x6b, 0xe1, 0x52,
    0x42, 0xc5, 0x95, 0x77, 0x98, 0xc9, 0x39, 0xd6, 0xe3, 0xa5, 0xae, 0x66, 0xce, 0x42, 0x4f, 0x1a,
    0x1e, 0x96, 0x4e, 0x9a, 0x51, 0x0d, 0x10, 0xdd, 0x5f, 0x43, 0xed, 0xf6, 0xdb, 0xc4, 0xaf, 0x04,
    0xc3, 0x9e, 0x95, 0x99, 0x71, 0xa8, 0xe9, 0xc2, 0x27, 0x01, 0x90, 0xd5, 0x05, 0xfa, 0x49, 0x01,
    0xa4, 0x99, 0x7e, 0x6f, 0x20, 0x65, 0xf1, 0xaa, 0x62, 0xa8, 0x76, 0x14, 0xec, 0x14, 0xf3, 0xea,
    0x7d, 0x42, 0x08, 0xc2, 0x1f, 0xc2, 0x8c, 0xc9, 0x82, 0x8a, 0x1f, 0xa6, 0x95, 0xfa, 0x0c, 0x3e,
    0x72, 0xa3, 0x4e, 0x0b, 0x4a, 0x1a, 0x20, 0x61, 0x68, 0x70, 0x4d, 0xdb, 0x9b, 0x88, 0x27, 0x11,
    0x69, 0x9a, 0x47, 0xf4, 0xd6, 0xff, 0x73, 0xd7, 0xc6, 0xb1, 0x69, 0x04, 0x58, 0x1e, 0xed, 0xee,
    0xab, 0x1d, 0xd6, 0xed, 0xb5, 0xea, 0xc2, 0x67, 0xad, 0xff, 0x1c, 0xa9, 0x8d, 0x41, 0x01, 0xac,
    0xaf, 0x3c, 0x9e, 0xfc, 0x90, 0xa8, 0xf3, 0x03, 0x48, 0xe9, 0xe5, 0xde
};
#endif

PyTypeObject *init_KToolBarPopupAction(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KToolBarPopupAction_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KToolBarPopupAction_IDX].type;

    Shiboken::AutoDecRef Sbk_KToolBarPopupAction_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidgetAction_IDX]))));

    _Sbk_KToolBarPopupAction_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KToolBarPopupAction",
        "KToolBarPopupAction*",
        &Sbk_KToolBarPopupAction_spec,
        &Shiboken::callCppDestructor< KToolBarPopupAction >,
        Sbk_KToolBarPopupAction_Type_bases.object(),
        0);
    auto *pyType = _Sbk_KToolBarPopupAction_Type; // references _Sbk_KToolBarPopupAction_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KToolBarPopupAction_SignatureStrings);
#else
    InitSignatureBytes(pyType, KToolBarPopupAction_SignatureBytes, KToolBarPopupAction_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KToolBarPopupAction_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KToolBarPopupAction_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KToolBarPopupAction_PythonToCpp_KToolBarPopupAction_PTR,
        is_KToolBarPopupAction_PythonToCpp_KToolBarPopupAction_PTR_Convertible,
        KToolBarPopupAction_PTR_CppToPython_KToolBarPopupAction);

    Shiboken::Conversions::registerConverterName(converter, "KToolBarPopupAction");
    Shiboken::Conversions::registerConverterName(converter, "KToolBarPopupAction*");
    Shiboken::Conversions::registerConverterName(converter, "KToolBarPopupAction&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KToolBarPopupAction).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KToolBarPopupActionWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KToolBarPopupAction_TypeF(), &Sbk_KToolBarPopupAction_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KToolBarPopupAction_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'PopupMode'.
    const char *PopupMode_Initializer[] = {
        "NoPopup",
        "DelayedPopup",
        "MenuButtonPopup",
        "InstantPopup",
        nullptr};
    // "int8_t" used instead of "int"
    constexpr int8_t PopupMode_InitializerValues[] = {
        int8_t(KToolBarPopupAction::PopupMode::NoPopup),         // -0x01 -1
        int8_t(KToolBarPopupAction::PopupMode::DelayedPopup),    //  0x00  0
        int8_t(KToolBarPopupAction::PopupMode::MenuButtonPopup), //  0x01  1
        int8_t(KToolBarPopupAction::PopupMode::InstantPopup)     //  0x02  2
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KToolBarPopupAction_TypeF(),
        "1:KWidgetsAddons.KToolBarPopupAction.PopupMode",
        PopupMode_Initializer, PopupMode_InitializerValues);
    SbkKWidgetsAddonsTypeStructs[SBK_KToolBarPopupAction_PopupMode_IDX].type = EType;
    // Register converter for enum 'KToolBarPopupAction::PopupMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KToolBarPopupAction_PopupMode_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KToolBarPopupAction_PopupMode,
            is_Enum_PythonToCpp_KToolBarPopupAction_PopupMode_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KToolBarPopupAction::PopupMode");
        Shiboken::Conversions::registerConverterAlias(converter, "PopupMode");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'PopupMode' enum.

    qRegisterMetaType< ::KToolBarPopupAction::PopupMode >("KToolBarPopupAction::PopupMode");
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KToolBarPopupAction::staticMetaObject, sizeof(KToolBarPopupActionWrapper));

    return pyType;
}
