/**
 * GENERATED FILE, DO NOT EDIT
 *
 * SPDX-License-Identifier: MIT
 */



#pragma once

#ifdef _cplusplus
extern "C" {
#endif

#include <stdint.h>
#include <brei-proto.h>
/**
 * Forward declarations. This file is intended to be compile-able without including
 * any of the actual sources files.
 */

struct eis_client;

/* Interface declarations */
struct eis_handshake;
struct eis_connection;
struct eis_callback;
struct eis_pingpong;
struct eis_seat;
struct eis_device;
struct eis_pointer;
struct eis_pointer_absolute;
struct eis_scroll;
struct eis_button;
struct eis_keyboard;
struct eis_touchscreen;

extern const struct brei_interface eis_handshake_proto_interface;
extern const struct brei_interface eis_connection_proto_interface;
extern const struct brei_interface eis_callback_proto_interface;
extern const struct brei_interface eis_pingpong_proto_interface;
extern const struct brei_interface eis_seat_proto_interface;
extern const struct brei_interface eis_device_proto_interface;
extern const struct brei_interface eis_pointer_proto_interface;
extern const struct brei_interface eis_pointer_absolute_proto_interface;
extern const struct brei_interface eis_scroll_proto_interface;
extern const struct brei_interface eis_button_proto_interface;
extern const struct brei_interface eis_keyboard_proto_interface;
extern const struct brei_interface eis_touchscreen_proto_interface;

#define EIS_HANDSHAKE_INTERFACE_NAME "ei_handshake"
#define EIS_CONNECTION_INTERFACE_NAME "ei_connection"
#define EIS_CALLBACK_INTERFACE_NAME "ei_callback"
#define EIS_PINGPONG_INTERFACE_NAME "ei_pingpong"
#define EIS_SEAT_INTERFACE_NAME "ei_seat"
#define EIS_DEVICE_INTERFACE_NAME "ei_device"
#define EIS_POINTER_INTERFACE_NAME "ei_pointer"
#define EIS_POINTER_ABSOLUTE_INTERFACE_NAME "ei_pointer_absolute"
#define EIS_SCROLL_INTERFACE_NAME "ei_scroll"
#define EIS_BUTTON_INTERFACE_NAME "ei_button"
#define EIS_KEYBOARD_INTERFACE_NAME "ei_keyboard"
#define EIS_TOUCHSCREEN_INTERFACE_NAME "ei_touchscreen"

__attribute__((unused))
static const char *EIS_INTERFACE_NAMES[] = {
	EIS_HANDSHAKE_INTERFACE_NAME,
	EIS_CONNECTION_INTERFACE_NAME,
	EIS_CALLBACK_INTERFACE_NAME,
	EIS_PINGPONG_INTERFACE_NAME,
	EIS_SEAT_INTERFACE_NAME,
	EIS_DEVICE_INTERFACE_NAME,
	EIS_POINTER_INTERFACE_NAME,
	EIS_POINTER_ABSOLUTE_INTERFACE_NAME,
	EIS_SCROLL_INTERFACE_NAME,
	EIS_BUTTON_INTERFACE_NAME,
	EIS_KEYBOARD_INTERFACE_NAME,
	EIS_TOUCHSCREEN_INTERFACE_NAME,
};

/* Interface indices as used in the protocol.xml file */
#define EIS_HANDSHAKE_INTERFACE_INDEX 0
#define EIS_CONNECTION_INTERFACE_INDEX 1
#define EIS_CALLBACK_INTERFACE_INDEX 2
#define EIS_PINGPONG_INTERFACE_INDEX 3
#define EIS_SEAT_INTERFACE_INDEX 4
#define EIS_DEVICE_INTERFACE_INDEX 5
#define EIS_POINTER_INTERFACE_INDEX 6
#define EIS_POINTER_ABSOLUTE_INTERFACE_INDEX 7
#define EIS_SCROLL_INTERFACE_INDEX 8
#define EIS_BUTTON_INTERFACE_INDEX 9
#define EIS_KEYBOARD_INTERFACE_INDEX 10
#define EIS_TOUCHSCREEN_INTERFACE_INDEX 11
#define EIS_INTERFACE_COUNT 12


/**                                 eis_handshake                                           **/

#define EIS_HANDSHAKE_REQUEST_HANDSHAKE_VERSION_SINCE_VERSION 1
#define EIS_HANDSHAKE_REQUEST_FINISH_SINCE_VERSION 1
#define EIS_HANDSHAKE_REQUEST_CONTEXT_TYPE_SINCE_VERSION 1
#define EIS_HANDSHAKE_REQUEST_NAME_SINCE_VERSION 1
#define EIS_HANDSHAKE_REQUEST_INTERFACE_VERSION_SINCE_VERSION 1

#define EIS_HANDSHAKE_EVENT_HANDSHAKE_VERSION_SINCE_VERSION 1
#define EIS_HANDSHAKE_EVENT_INTERFACE_VERSION_SINCE_VERSION 1
#define EIS_HANDSHAKE_EVENT_CONNECTION_SINCE_VERSION 1

enum eis_handshake_context_type {
	EIS_HANDSHAKE_CONTEXT_TYPE_RECEIVER = 1,
	EIS_HANDSHAKE_CONTEXT_TYPE_SENDER = 2,
};

#define EIS_HANDSHAKE_CONTEXT_TYPE_RECEIVER_SINCE_VERSION 1
#define EIS_HANDSHAKE_CONTEXT_TYPE_SENDER_SINCE_VERSION 1

/* Message sender functions */
extern int
eis_handshake_event_handshake_version(struct eis_handshake * eis_handshake, uint32_t version);

extern int
eis_handshake_event_interface_version(struct eis_handshake * eis_handshake, const char * name, uint32_t version);

extern int
eis_handshake_event_connection(struct eis_handshake * eis_handshake, uint32_t serial, new_id_t connection, uint32_t version);


/**
 * Interface to handle incoming messages for objects of type eis_handshake.
 *
 * After parsing the wire message, the data is dispatched into the functions below.
 */
struct eis_handshake_interface {
   struct brei_result * (*handshake_version)(struct eis_handshake * eis_handshake, uint32_t version);
   struct brei_result * (*finish)(struct eis_handshake * eis_handshake);
   struct brei_result * (*context_type)(struct eis_handshake * eis_handshake, uint32_t context_type);
   struct brei_result * (*name)(struct eis_handshake * eis_handshake, const char * name);
   struct brei_result * (*interface_version)(struct eis_handshake * eis_handshake, const char * name, uint32_t version);
};

/**                                 eis_connection                                           **/

#define EIS_CONNECTION_REQUEST_SYNC_SINCE_VERSION 1
#define EIS_CONNECTION_REQUEST_DISCONNECT_SINCE_VERSION 1

#define EIS_CONNECTION_EVENT_DISCONNECTED_SINCE_VERSION 1
#define EIS_CONNECTION_EVENT_SEAT_SINCE_VERSION 1
#define EIS_CONNECTION_EVENT_INVALID_OBJECT_SINCE_VERSION 1
#define EIS_CONNECTION_EVENT_PING_SINCE_VERSION 1

enum eis_connection_disconnect_reason {
	EIS_CONNECTION_DISCONNECT_REASON_DISCONNECTED = 0,
	EIS_CONNECTION_DISCONNECT_REASON_ERROR = 1,
	EIS_CONNECTION_DISCONNECT_REASON_MODE = 2,
	EIS_CONNECTION_DISCONNECT_REASON_PROTOCOL = 3,
	EIS_CONNECTION_DISCONNECT_REASON_VALUE = 4,
	EIS_CONNECTION_DISCONNECT_REASON_TRANSPORT = 5,
};

#define EIS_CONNECTION_DISCONNECT_REASON_DISCONNECTED_SINCE_VERSION 1
#define EIS_CONNECTION_DISCONNECT_REASON_ERROR_SINCE_VERSION 1
#define EIS_CONNECTION_DISCONNECT_REASON_MODE_SINCE_VERSION 1
#define EIS_CONNECTION_DISCONNECT_REASON_PROTOCOL_SINCE_VERSION 1
#define EIS_CONNECTION_DISCONNECT_REASON_VALUE_SINCE_VERSION 1
#define EIS_CONNECTION_DISCONNECT_REASON_TRANSPORT_SINCE_VERSION 1

/* Message sender functions */
extern int
eis_connection_event_disconnected(struct eis_connection * eis_connection, uint32_t last_serial, uint32_t reason, const char * explanation);

extern int
eis_connection_event_seat(struct eis_connection * eis_connection, new_id_t seat, uint32_t version);

extern int
eis_connection_event_invalid_object(struct eis_connection * eis_connection, uint32_t last_serial, uint64_t invalid_id);

extern int
eis_connection_event_ping(struct eis_connection * eis_connection, new_id_t ping, uint32_t version);


/**
 * Interface to handle incoming messages for objects of type eis_connection.
 *
 * After parsing the wire message, the data is dispatched into the functions below.
 */
struct eis_connection_interface {
   struct brei_result * (*sync)(struct eis_connection * eis_connection, new_id_t callback, uint32_t version);
   struct brei_result * (*disconnect)(struct eis_connection * eis_connection);
};

/**                                 eis_callback                                           **/


#define EIS_CALLBACK_EVENT_DONE_SINCE_VERSION 1


/* Message sender functions */
extern int
eis_callback_event_done(struct eis_callback * eis_callback, uint64_t callback_data);


/**
 * Interface to handle incoming messages for objects of type eis_callback.
 *
 * After parsing the wire message, the data is dispatched into the functions below.
 */
struct eis_callback_interface {
};

/**                                 eis_pingpong                                           **/

#define EIS_PINGPONG_REQUEST_DONE_SINCE_VERSION 1



/* Message sender functions */

/**
 * Interface to handle incoming messages for objects of type eis_pingpong.
 *
 * After parsing the wire message, the data is dispatched into the functions below.
 */
struct eis_pingpong_interface {
   struct brei_result * (*done)(struct eis_pingpong * eis_pingpong, uint64_t callback_data);
};

/**                                 eis_seat                                           **/

#define EIS_SEAT_REQUEST_RELEASE_SINCE_VERSION 1
#define EIS_SEAT_REQUEST_BIND_SINCE_VERSION 1

#define EIS_SEAT_EVENT_DESTROYED_SINCE_VERSION 1
#define EIS_SEAT_EVENT_NAME_SINCE_VERSION 1
#define EIS_SEAT_EVENT_CAPABILITY_SINCE_VERSION 1
#define EIS_SEAT_EVENT_DONE_SINCE_VERSION 1
#define EIS_SEAT_EVENT_DEVICE_SINCE_VERSION 1


/* Message sender functions */
extern int
eis_seat_event_destroyed(struct eis_seat * eis_seat, uint32_t serial);

extern int
eis_seat_event_name(struct eis_seat * eis_seat, const char * name);

extern int
eis_seat_event_capability(struct eis_seat * eis_seat, uint64_t mask, const char * interface);

extern int
eis_seat_event_done(struct eis_seat * eis_seat);

extern int
eis_seat_event_device(struct eis_seat * eis_seat, new_id_t device, uint32_t version);


/**
 * Interface to handle incoming messages for objects of type eis_seat.
 *
 * After parsing the wire message, the data is dispatched into the functions below.
 */
struct eis_seat_interface {
   struct brei_result * (*release)(struct eis_seat * eis_seat);
   struct brei_result * (*bind)(struct eis_seat * eis_seat, uint64_t capabilities);
};

/**                                 eis_device                                           **/

#define EIS_DEVICE_REQUEST_RELEASE_SINCE_VERSION 1
#define EIS_DEVICE_REQUEST_START_EMULATING_SINCE_VERSION 1
#define EIS_DEVICE_REQUEST_STOP_EMULATING_SINCE_VERSION 1
#define EIS_DEVICE_REQUEST_FRAME_SINCE_VERSION 1

#define EIS_DEVICE_EVENT_DESTROYED_SINCE_VERSION 1
#define EIS_DEVICE_EVENT_NAME_SINCE_VERSION 1
#define EIS_DEVICE_EVENT_DEVICE_TYPE_SINCE_VERSION 1
#define EIS_DEVICE_EVENT_DIMENSIONS_SINCE_VERSION 1
#define EIS_DEVICE_EVENT_REGION_SINCE_VERSION 1
#define EIS_DEVICE_EVENT_INTERFACE_SINCE_VERSION 1
#define EIS_DEVICE_EVENT_DONE_SINCE_VERSION 1
#define EIS_DEVICE_EVENT_RESUMED_SINCE_VERSION 1
#define EIS_DEVICE_EVENT_PAUSED_SINCE_VERSION 1
#define EIS_DEVICE_EVENT_START_EMULATING_SINCE_VERSION 1
#define EIS_DEVICE_EVENT_STOP_EMULATING_SINCE_VERSION 1
#define EIS_DEVICE_EVENT_FRAME_SINCE_VERSION 1
#define EIS_DEVICE_EVENT_REGION_MAPPING_ID_SINCE_VERSION 2

enum eis_device_device_type {
	EIS_DEVICE_DEVICE_TYPE_VIRTUAL = 1,
	EIS_DEVICE_DEVICE_TYPE_PHYSICAL = 2,
};

#define EIS_DEVICE_DEVICE_TYPE_VIRTUAL_SINCE_VERSION 1
#define EIS_DEVICE_DEVICE_TYPE_PHYSICAL_SINCE_VERSION 1

/* Message sender functions */
extern int
eis_device_event_destroyed(struct eis_device * eis_device, uint32_t serial);

extern int
eis_device_event_name(struct eis_device * eis_device, const char * name);

extern int
eis_device_event_device_type(struct eis_device * eis_device, uint32_t device_type);

extern int
eis_device_event_dimensions(struct eis_device * eis_device, uint32_t width, uint32_t height);

extern int
eis_device_event_region(struct eis_device * eis_device, uint32_t offset_x, uint32_t offset_y, uint32_t width, uint32_t hight, float scale);

extern int
eis_device_event_interface(struct eis_device * eis_device, new_id_t object, const char * interface_name, uint32_t version);

extern int
eis_device_event_done(struct eis_device * eis_device);

extern int
eis_device_event_resumed(struct eis_device * eis_device, uint32_t serial);

extern int
eis_device_event_paused(struct eis_device * eis_device, uint32_t serial);

extern int
eis_device_event_start_emulating(struct eis_device * eis_device, uint32_t serial, uint32_t sequence);

extern int
eis_device_event_stop_emulating(struct eis_device * eis_device, uint32_t serial);

extern int
eis_device_event_frame(struct eis_device * eis_device, uint32_t serial, uint64_t timestamp);

extern int
eis_device_event_region_mapping_id(struct eis_device * eis_device, const char * mapping_id);


/**
 * Interface to handle incoming messages for objects of type eis_device.
 *
 * After parsing the wire message, the data is dispatched into the functions below.
 */
struct eis_device_interface {
   struct brei_result * (*release)(struct eis_device * eis_device);
   struct brei_result * (*start_emulating)(struct eis_device * eis_device, uint32_t last_serial, uint32_t sequence);
   struct brei_result * (*stop_emulating)(struct eis_device * eis_device, uint32_t last_serial);
   struct brei_result * (*frame)(struct eis_device * eis_device, uint32_t last_serial, uint64_t timestamp);
};

/**                                 eis_pointer                                           **/

#define EIS_POINTER_REQUEST_RELEASE_SINCE_VERSION 1
#define EIS_POINTER_REQUEST_MOTION_RELATIVE_SINCE_VERSION 1

#define EIS_POINTER_EVENT_DESTROYED_SINCE_VERSION 1
#define EIS_POINTER_EVENT_MOTION_RELATIVE_SINCE_VERSION 1


/* Message sender functions */
extern int
eis_pointer_event_destroyed(struct eis_pointer * eis_pointer, uint32_t serial);

extern int
eis_pointer_event_motion_relative(struct eis_pointer * eis_pointer, float x, float y);


/**
 * Interface to handle incoming messages for objects of type eis_pointer.
 *
 * After parsing the wire message, the data is dispatched into the functions below.
 */
struct eis_pointer_interface {
   struct brei_result * (*release)(struct eis_pointer * eis_pointer);
   struct brei_result * (*motion_relative)(struct eis_pointer * eis_pointer, float x, float y);
};

/**                                 eis_pointer_absolute                                           **/

#define EIS_POINTER_ABSOLUTE_REQUEST_RELEASE_SINCE_VERSION 1
#define EIS_POINTER_ABSOLUTE_REQUEST_MOTION_ABSOLUTE_SINCE_VERSION 1

#define EIS_POINTER_ABSOLUTE_EVENT_DESTROYED_SINCE_VERSION 1
#define EIS_POINTER_ABSOLUTE_EVENT_MOTION_ABSOLUTE_SINCE_VERSION 1


/* Message sender functions */
extern int
eis_pointer_absolute_event_destroyed(struct eis_pointer_absolute * eis_pointer_absolute, uint32_t serial);

extern int
eis_pointer_absolute_event_motion_absolute(struct eis_pointer_absolute * eis_pointer_absolute, float x, float y);


/**
 * Interface to handle incoming messages for objects of type eis_pointer_absolute.
 *
 * After parsing the wire message, the data is dispatched into the functions below.
 */
struct eis_pointer_absolute_interface {
   struct brei_result * (*release)(struct eis_pointer_absolute * eis_pointer_absolute);
   struct brei_result * (*motion_absolute)(struct eis_pointer_absolute * eis_pointer_absolute, float x, float y);
};

/**                                 eis_scroll                                           **/

#define EIS_SCROLL_REQUEST_RELEASE_SINCE_VERSION 1
#define EIS_SCROLL_REQUEST_SCROLL_SINCE_VERSION 1
#define EIS_SCROLL_REQUEST_SCROLL_DISCRETE_SINCE_VERSION 1
#define EIS_SCROLL_REQUEST_SCROLL_STOP_SINCE_VERSION 1

#define EIS_SCROLL_EVENT_DESTROYED_SINCE_VERSION 1
#define EIS_SCROLL_EVENT_SCROLL_SINCE_VERSION 1
#define EIS_SCROLL_EVENT_SCROLL_DISCRETE_SINCE_VERSION 1
#define EIS_SCROLL_EVENT_SCROLL_STOP_SINCE_VERSION 1


/* Message sender functions */
extern int
eis_scroll_event_destroyed(struct eis_scroll * eis_scroll, uint32_t serial);

extern int
eis_scroll_event_scroll(struct eis_scroll * eis_scroll, float x, float y);

extern int
eis_scroll_event_scroll_discrete(struct eis_scroll * eis_scroll, int32_t x, int32_t y);

extern int
eis_scroll_event_scroll_stop(struct eis_scroll * eis_scroll, uint32_t x, uint32_t y, uint32_t is_cancel);


/**
 * Interface to handle incoming messages for objects of type eis_scroll.
 *
 * After parsing the wire message, the data is dispatched into the functions below.
 */
struct eis_scroll_interface {
   struct brei_result * (*release)(struct eis_scroll * eis_scroll);
   struct brei_result * (*scroll)(struct eis_scroll * eis_scroll, float x, float y);
   struct brei_result * (*scroll_discrete)(struct eis_scroll * eis_scroll, int32_t x, int32_t y);
   struct brei_result * (*scroll_stop)(struct eis_scroll * eis_scroll, uint32_t x, uint32_t y, uint32_t is_cancel);
};

/**                                 eis_button                                           **/

#define EIS_BUTTON_REQUEST_RELEASE_SINCE_VERSION 1
#define EIS_BUTTON_REQUEST_BUTTON_SINCE_VERSION 1

#define EIS_BUTTON_EVENT_DESTROYED_SINCE_VERSION 1
#define EIS_BUTTON_EVENT_BUTTON_SINCE_VERSION 1

enum eis_button_button_state {
	EIS_BUTTON_BUTTON_STATE_RELEASED = 0,
	EIS_BUTTON_BUTTON_STATE_PRESS = 1,
};

#define EIS_BUTTON_BUTTON_STATE_RELEASED_SINCE_VERSION 1
#define EIS_BUTTON_BUTTON_STATE_PRESS_SINCE_VERSION 1

/* Message sender functions */
extern int
eis_button_event_destroyed(struct eis_button * eis_button, uint32_t serial);

extern int
eis_button_event_button(struct eis_button * eis_button, uint32_t button, uint32_t state);


/**
 * Interface to handle incoming messages for objects of type eis_button.
 *
 * After parsing the wire message, the data is dispatched into the functions below.
 */
struct eis_button_interface {
   struct brei_result * (*release)(struct eis_button * eis_button);
   struct brei_result * (*button)(struct eis_button * eis_button, uint32_t button, uint32_t state);
};

/**                                 eis_keyboard                                           **/

#define EIS_KEYBOARD_REQUEST_RELEASE_SINCE_VERSION 1
#define EIS_KEYBOARD_REQUEST_KEY_SINCE_VERSION 1

#define EIS_KEYBOARD_EVENT_DESTROYED_SINCE_VERSION 1
#define EIS_KEYBOARD_EVENT_KEYMAP_SINCE_VERSION 1
#define EIS_KEYBOARD_EVENT_KEY_SINCE_VERSION 1
#define EIS_KEYBOARD_EVENT_MODIFIERS_SINCE_VERSION 1

enum eis_keyboard_key_state {
	EIS_KEYBOARD_KEY_STATE_RELEASED = 0,
	EIS_KEYBOARD_KEY_STATE_PRESS = 1,
};

#define EIS_KEYBOARD_KEY_STATE_RELEASED_SINCE_VERSION 1
#define EIS_KEYBOARD_KEY_STATE_PRESS_SINCE_VERSION 1
enum eis_keyboard_keymap_type {
	EIS_KEYBOARD_KEYMAP_TYPE_XKB = 1,
};

#define EIS_KEYBOARD_KEYMAP_TYPE_XKB_SINCE_VERSION 1

/* Message sender functions */
extern int
eis_keyboard_event_destroyed(struct eis_keyboard * eis_keyboard, uint32_t serial);

extern int
eis_keyboard_event_keymap(struct eis_keyboard * eis_keyboard, uint32_t keymap_type, uint32_t size, int keymap);

extern int
eis_keyboard_event_key(struct eis_keyboard * eis_keyboard, uint32_t key, uint32_t state);

extern int
eis_keyboard_event_modifiers(struct eis_keyboard * eis_keyboard, uint32_t serial, uint32_t depressed, uint32_t locked, uint32_t latched, uint32_t group);


/**
 * Interface to handle incoming messages for objects of type eis_keyboard.
 *
 * After parsing the wire message, the data is dispatched into the functions below.
 */
struct eis_keyboard_interface {
   struct brei_result * (*release)(struct eis_keyboard * eis_keyboard);
   struct brei_result * (*key)(struct eis_keyboard * eis_keyboard, uint32_t key, uint32_t state);
};

/**                                 eis_touchscreen                                           **/

#define EIS_TOUCHSCREEN_REQUEST_RELEASE_SINCE_VERSION 1
#define EIS_TOUCHSCREEN_REQUEST_DOWN_SINCE_VERSION 1
#define EIS_TOUCHSCREEN_REQUEST_MOTION_SINCE_VERSION 1
#define EIS_TOUCHSCREEN_REQUEST_UP_SINCE_VERSION 1
#define EIS_TOUCHSCREEN_REQUEST_CANCEL_SINCE_VERSION 2

#define EIS_TOUCHSCREEN_EVENT_DESTROYED_SINCE_VERSION 1
#define EIS_TOUCHSCREEN_EVENT_DOWN_SINCE_VERSION 1
#define EIS_TOUCHSCREEN_EVENT_MOTION_SINCE_VERSION 1
#define EIS_TOUCHSCREEN_EVENT_UP_SINCE_VERSION 1
#define EIS_TOUCHSCREEN_EVENT_CANCEL_SINCE_VERSION 2


/* Message sender functions */
extern int
eis_touchscreen_event_destroyed(struct eis_touchscreen * eis_touchscreen, uint32_t serial);

extern int
eis_touchscreen_event_down(struct eis_touchscreen * eis_touchscreen, uint32_t touchid, float x, float y);

extern int
eis_touchscreen_event_motion(struct eis_touchscreen * eis_touchscreen, uint32_t touchid, float x, float y);

extern int
eis_touchscreen_event_up(struct eis_touchscreen * eis_touchscreen, uint32_t touchid);

extern int
eis_touchscreen_event_cancel(struct eis_touchscreen * eis_touchscreen, uint32_t touchid);


/**
 * Interface to handle incoming messages for objects of type eis_touchscreen.
 *
 * After parsing the wire message, the data is dispatched into the functions below.
 */
struct eis_touchscreen_interface {
   struct brei_result * (*release)(struct eis_touchscreen * eis_touchscreen);
   struct brei_result * (*down)(struct eis_touchscreen * eis_touchscreen, uint32_t touchid, float x, float y);
   struct brei_result * (*motion)(struct eis_touchscreen * eis_touchscreen, uint32_t touchid, float x, float y);
   struct brei_result * (*up)(struct eis_touchscreen * eis_touchscreen, uint32_t touchid);
   struct brei_result * (*cancel)(struct eis_touchscreen * eis_touchscreen, uint32_t touchid);
};

#ifdef _cplusplus
}
#endif