/* dict.c generated by valac 0.56.17, the Vala compiler
 * generated from dict.vala, do not modify */

/*
 * Copyright (C) 2011-2018 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2018 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "libskk/libskk.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SKK_DICT_0_PROPERTY,
	SKK_DICT_READ_ONLY_PROPERTY,
	SKK_DICT_NUM_PROPERTIES
};
static GParamSpec* skk_dict_properties[SKK_DICT_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	SKK_EMPTY_DICT_0_PROPERTY,
	SKK_EMPTY_DICT_READ_ONLY_PROPERTY,
	SKK_EMPTY_DICT_NUM_PROPERTIES
};
static GParamSpec* skk_empty_dict_properties[SKK_EMPTY_DICT_NUM_PROPERTIES];

#define SKK_TYPE_SKK_DICT_ERROR (skk_skk_dict_error_get_type ())

typedef enum  {
	SKK_SKK_DICT_ERROR_NOT_READABLE,
	SKK_SKK_DICT_ERROR_MALFORMED_INPUT
} SkkSkkDictError;
#define SKK_SKK_DICT_ERROR skk_skk_dict_error_quark ()

static gpointer skk_dict_parent_class = NULL;
static gpointer skk_empty_dict_parent_class = NULL;

static void skk_dict_real_reload (SkkDict* self,
                           GError** error);
static SkkCandidate** skk_dict_real_lookup (SkkDict* self,
                                     const gchar* midasi,
                                     gboolean okuri,
                                     gint* result_length1);
static gchar** skk_dict_real_complete (SkkDict* self,
                                const gchar* midasi,
                                gint* result_length1);
static gboolean skk_dict_real_select_candidate (SkkDict* self,
                                         SkkCandidate* candidate);
static gboolean skk_dict_real_purge_candidate (SkkDict* self,
                                        SkkCandidate* candidate);
static void skk_dict_real_save (SkkDict* self,
                         GError** error);
static GType skk_dict_get_type_once (void);
static void _vala_skk_dict_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec);
static void skk_empty_dict_real_reload (SkkDict* base,
                                 GError** error);
static SkkCandidate** skk_empty_dict_real_lookup (SkkDict* base,
                                           const gchar* midasi,
                                           gboolean okuri,
                                           gint* result_length1);
static gchar** skk_empty_dict_real_complete (SkkDict* base,
                                      const gchar* midasi,
                                      gint* result_length1);
static GType skk_empty_dict_get_type_once (void);
static void _vala_skk_empty_dict_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
VALA_EXTERN GQuark skk_skk_dict_error_quark (void);
VALA_EXTERN GType skk_skk_dict_error_get_type (void) G_GNUC_CONST ;
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

/**
         * Parse a line consisting of candidates separated by "/".
         *
         * @param line a line consisting of candidates
         * @return an array of Candidates
         */
static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

SkkCandidate**
skk_dict_split_candidates (SkkDict* self,
                           const gchar* midasi,
                           gboolean okuri,
                           const gchar* line,
                           gint* result_length1)
{
	gchar** strv = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gint strv_length1;
	gint _strv_size_;
	SkkCandidate** candidates = NULL;
	gchar** _tmp7_;
	gint _tmp7__length1;
	SkkCandidate** _tmp8_;
	gint candidates_length1;
	gint _candidates_size_;
	SkkCandidate** _tmp30_;
	gint _tmp30__length1;
	SkkCandidate** result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (midasi != NULL, NULL);
	g_return_val_if_fail (line != NULL, NULL);
	_tmp0_ = string_strip (line);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_slice (_tmp1_, (glong) 1, (glong) -1);
	_tmp3_ = _tmp2_;
	_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, "/", 0);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _vala_array_length (_tmp4_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	strv = _tmp6_;
	strv_length1 = _tmp6__length1;
	_strv_size_ = strv_length1;
	_tmp7_ = strv;
	_tmp7__length1 = strv_length1;
	_tmp8_ = g_new0 (SkkCandidate*, _tmp7__length1 + 1);
	candidates = _tmp8_;
	candidates_length1 = _tmp7__length1;
	_candidates_size_ = candidates_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				gchar** _tmp11_;
				gint _tmp11__length1;
				gchar** text_annotation = NULL;
				gchar** _tmp12_;
				gint _tmp12__length1;
				const gchar* _tmp13_;
				gchar** _tmp14_;
				gchar** _tmp15_;
				gint text_annotation_length1;
				gint _text_annotation_size_;
				gchar* text = NULL;
				gchar* annotation = NULL;
				gchar** _tmp16_;
				gint _tmp16__length1;
				SkkCandidate** _tmp26_;
				gint _tmp26__length1;
				const gchar* _tmp27_;
				const gchar* _tmp28_;
				SkkCandidate* _tmp29_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp11_ = strv;
				_tmp11__length1 = strv_length1;
				if (!(i < _tmp11__length1)) {
					break;
				}
				_tmp12_ = strv;
				_tmp12__length1 = strv_length1;
				_tmp13_ = _tmp12_[i];
				_tmp15_ = _tmp14_ = g_strsplit (_tmp13_, ";", 2);
				text_annotation = _tmp15_;
				text_annotation_length1 = _vala_array_length (_tmp14_);
				_text_annotation_size_ = text_annotation_length1;
				_tmp16_ = text_annotation;
				_tmp16__length1 = text_annotation_length1;
				if (_tmp16__length1 == 2) {
					gchar** _tmp17_;
					gint _tmp17__length1;
					const gchar* _tmp18_;
					gchar* _tmp19_;
					gchar** _tmp20_;
					gint _tmp20__length1;
					const gchar* _tmp21_;
					gchar* _tmp22_;
					_tmp17_ = text_annotation;
					_tmp17__length1 = text_annotation_length1;
					_tmp18_ = _tmp17_[0];
					_tmp19_ = g_strdup (_tmp18_);
					_g_free0 (text);
					text = _tmp19_;
					_tmp20_ = text_annotation;
					_tmp20__length1 = text_annotation_length1;
					_tmp21_ = _tmp20_[1];
					_tmp22_ = g_strdup (_tmp21_);
					_g_free0 (annotation);
					annotation = _tmp22_;
				} else {
					gchar** _tmp23_;
					gint _tmp23__length1;
					const gchar* _tmp24_;
					gchar* _tmp25_;
					_tmp23_ = strv;
					_tmp23__length1 = strv_length1;
					_tmp24_ = _tmp23_[i];
					_tmp25_ = g_strdup (_tmp24_);
					_g_free0 (text);
					text = _tmp25_;
					_g_free0 (annotation);
					annotation = NULL;
				}
				_tmp26_ = candidates;
				_tmp26__length1 = candidates_length1;
				_tmp27_ = text;
				_tmp28_ = annotation;
				_tmp29_ = skk_candidate_new (midasi, okuri, _tmp27_, _tmp28_, NULL);
				_g_object_unref0 (_tmp26_[i]);
				_tmp26_[i] = _tmp29_;
				_g_free0 (annotation);
				_g_free0 (text);
				text_annotation = (_vala_array_free (text_annotation, text_annotation_length1, (GDestroyNotify) g_free), NULL);
			}
		}
	}
	_tmp30_ = candidates;
	_tmp30__length1 = candidates_length1;
	if (result_length1) {
		*result_length1 = _tmp30__length1;
	}
	result = _tmp30_;
	strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

/**
         * Format an array of Candidates to be saved in a dictionary file.
         *
         * @param candidates an array of Candidate
         * @return a string
         */
static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

gchar*
skk_dict_join_candidates (SkkDict* self,
                          SkkCandidate** candidates,
                          gint candidates_length1)
{
	gchar** strv = NULL;
	gchar** _tmp0_;
	gint strv_length1;
	gint _strv_size_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, candidates_length1 + 1);
	strv = _tmp0_;
	strv_length1 = candidates_length1;
	_strv_size_ = strv_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gchar** _tmp3_;
				gint _tmp3__length1;
				SkkCandidate* _tmp4_;
				gchar* _tmp5_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < candidates_length1)) {
					break;
				}
				_tmp3_ = strv;
				_tmp3__length1 = strv_length1;
				_tmp4_ = candidates[i];
				_tmp5_ = skk_candidate_to_string (_tmp4_);
				_g_free0 (_tmp3_[i]);
				_tmp3_[i] = _tmp5_;
			}
		}
	}
	_tmp6_ = strv;
	_tmp6__length1 = strv_length1;
	_tmp7_ = _vala_g_strjoinv ("/", _tmp6_, (gint) _tmp6__length1);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat ("/", _tmp8_, NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strconcat (_tmp10_, "/", NULL);
	_tmp12_ = _tmp11_;
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	result = _tmp12_;
	strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

/**
         * Reload the dictionary.
         *
         * @throws GLib.Error when reading the dictionary failed.
         */
static void
skk_dict_real_reload (SkkDict* self,
                      GError** error)
{
	g_critical ("Type `%s' does not implement abstract method `skk_dict_reload'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
skk_dict_reload (SkkDict* self,
                 GError** error)
{
	SkkDictClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = SKK_DICT_GET_CLASS (self);
	if (_klass_->reload) {
		_klass_->reload (self, error);
	}
}

/**
         * Lookup candidates in the dictionary.
         *
         * @param midasi a midasi (title) string to lookup
         * @param okuri whether to search okuri-ari entries or
         * okuri-nasi entries
         *
         * @return an array of Candidate
         */
static SkkCandidate**
skk_dict_real_lookup (SkkDict* self,
                      const gchar* midasi,
                      gboolean okuri,
                      gint* result_length1)
{
	g_critical ("Type `%s' does not implement abstract method `skk_dict_lookup'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

SkkCandidate**
skk_dict_lookup (SkkDict* self,
                 const gchar* midasi,
                 gboolean okuri,
                 gint* result_length1)
{
	SkkDictClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = SKK_DICT_GET_CLASS (self);
	if (_klass_->lookup) {
		return _klass_->lookup (self, midasi, okuri, result_length1);
	}
	return NULL;
}

/**
         * Return an array of strings which matches midasi.
         *
         * @param midasi a midasi (title) string to lookup
         *
         * @return an array of strings
         */
static gchar**
skk_dict_real_complete (SkkDict* self,
                        const gchar* midasi,
                        gint* result_length1)
{
	g_critical ("Type `%s' does not implement abstract method `skk_dict_complete'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar**
skk_dict_complete (SkkDict* self,
                   const gchar* midasi,
                   gint* result_length1)
{
	SkkDictClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = SKK_DICT_GET_CLASS (self);
	if (_klass_->complete) {
		return _klass_->complete (self, midasi, result_length1);
	}
	return NULL;
}

/**
         * Select a candidate in the dictionary.
         *
         * @param candidate an Candidate
         *
         * @return `true` if the dictionary is modified, `false` otherwise.
         */
static gboolean
skk_dict_real_select_candidate (SkkDict* self,
                                SkkCandidate* candidate)
{
	gboolean result;
	g_return_val_if_fail (candidate != NULL, FALSE);
	result = FALSE;
	return result;
}

gboolean
skk_dict_select_candidate (SkkDict* self,
                           SkkCandidate* candidate)
{
	SkkDictClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = SKK_DICT_GET_CLASS (self);
	if (_klass_->select_candidate) {
		return _klass_->select_candidate (self, candidate);
	}
	return FALSE;
}

/**
         * Purge a candidate in the dictionary.
         *
         * @param candidate an Candidate
         *
         * @return `true` if the dictionary is modified, `false` otherwise.
         */
static gboolean
skk_dict_real_purge_candidate (SkkDict* self,
                               SkkCandidate* candidate)
{
	gboolean result;
	g_return_val_if_fail (candidate != NULL, FALSE);
	result = FALSE;
	return result;
}

gboolean
skk_dict_purge_candidate (SkkDict* self,
                          SkkCandidate* candidate)
{
	SkkDictClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = SKK_DICT_GET_CLASS (self);
	if (_klass_->purge_candidate) {
		return _klass_->purge_candidate (self, candidate);
	}
	return FALSE;
}

/**
         * Save the dictionary on disk.
         *
         * @throws GLib.Error if the dictionary cannot be saved.
         */
static void
skk_dict_real_save (SkkDict* self,
                    GError** error)
{
}

void
skk_dict_save (SkkDict* self,
               GError** error)
{
	SkkDictClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = SKK_DICT_GET_CLASS (self);
	if (_klass_->save) {
		_klass_->save (self, error);
	}
}

SkkDict*
skk_dict_construct (GType object_type)
{
	SkkDict * self = NULL;
	self = (SkkDict*) g_object_new (object_type, NULL);
	return self;
}

gboolean
skk_dict_get_read_only (SkkDict* self)
{
	SkkDictClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = SKK_DICT_GET_CLASS (self);
	if (_klass_->get_read_only) {
		return _klass_->get_read_only (self);
	}
	return FALSE;
}

static void
skk_dict_class_init (SkkDictClass * klass,
                     gpointer klass_data)
{
	skk_dict_parent_class = g_type_class_peek_parent (klass);
	((SkkDictClass *) klass)->reload = (void (*) (SkkDict*, GError**)) skk_dict_real_reload;
	((SkkDictClass *) klass)->lookup = (SkkCandidate** (*) (SkkDict*, const gchar*, gboolean, gint*)) skk_dict_real_lookup;
	((SkkDictClass *) klass)->complete = (gchar** (*) (SkkDict*, const gchar*, gint*)) skk_dict_real_complete;
	((SkkDictClass *) klass)->select_candidate = (gboolean (*) (SkkDict*, SkkCandidate*)) skk_dict_real_select_candidate;
	((SkkDictClass *) klass)->purge_candidate = (gboolean (*) (SkkDict*, SkkCandidate*)) skk_dict_real_purge_candidate;
	((SkkDictClass *) klass)->save = (void (*) (SkkDict*, GError**)) skk_dict_real_save;
	G_OBJECT_CLASS (klass)->get_property = _vala_skk_dict_get_property;
	/**
	         * Flag to indicate whether the dictionary is read only.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_DICT_READ_ONLY_PROPERTY, skk_dict_properties[SKK_DICT_READ_ONLY_PROPERTY] = g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
skk_dict_instance_init (SkkDict * self,
                        gpointer klass)
{
}

/**
     * Base abstract class of dictionaries.
     */
static GType
skk_dict_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SkkDictClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_dict_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkDict), 0, (GInstanceInitFunc) skk_dict_instance_init, NULL };
	GType skk_dict_type_id;
	skk_dict_type_id = g_type_register_static (G_TYPE_OBJECT, "SkkDict", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return skk_dict_type_id;
}

GType
skk_dict_get_type (void)
{
	static volatile gsize skk_dict_type_id__once = 0;
	if (g_once_init_enter (&skk_dict_type_id__once)) {
		GType skk_dict_type_id;
		skk_dict_type_id = skk_dict_get_type_once ();
		g_once_init_leave (&skk_dict_type_id__once, skk_dict_type_id);
	}
	return skk_dict_type_id__once;
}

static void
_vala_skk_dict_get_property (GObject * object,
                             guint property_id,
                             GValue * value,
                             GParamSpec * pspec)
{
	SkkDict * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SKK_TYPE_DICT, SkkDict);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

/**
         * {@inheritDoc}
         */
static void
skk_empty_dict_real_reload (SkkDict* base,
                            GError** error)
{
	SkkEmptyDict * self;
	self = (SkkEmptyDict*) base;
}

/**
         * {@inheritDoc}
         */
static SkkCandidate**
skk_empty_dict_real_lookup (SkkDict* base,
                            const gchar* midasi,
                            gboolean okuri,
                            gint* result_length1)
{
	SkkEmptyDict * self;
	SkkCandidate** _tmp0_;
	SkkCandidate** _tmp1_;
	gint _tmp1__length1;
	SkkCandidate** result;
	self = (SkkEmptyDict*) base;
	g_return_val_if_fail (midasi != NULL, NULL);
	_tmp0_ = g_new0 (SkkCandidate*, 0 + 1);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 0;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

/**
         * {@inheritDoc}
         */
static gchar**
skk_empty_dict_real_complete (SkkDict* base,
                              const gchar* midasi,
                              gint* result_length1)
{
	SkkEmptyDict * self;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** result;
	self = (SkkEmptyDict*) base;
	g_return_val_if_fail (midasi != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 0;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

SkkEmptyDict*
skk_empty_dict_construct (GType object_type)
{
	SkkEmptyDict * self = NULL;
	self = (SkkEmptyDict*) skk_dict_construct (object_type);
	return self;
}

SkkEmptyDict*
skk_empty_dict_new (void)
{
	return skk_empty_dict_construct (SKK_TYPE_EMPTY_DICT);
}

static gboolean
skk_empty_dict_real_get_read_only (SkkDict* base)
{
	gboolean result;
	SkkEmptyDict* self;
	self = (SkkEmptyDict*) base;
	result = TRUE;
	return result;
}

static void
skk_empty_dict_class_init (SkkEmptyDictClass * klass,
                           gpointer klass_data)
{
	skk_empty_dict_parent_class = g_type_class_peek_parent (klass);
	((SkkDictClass *) klass)->reload = (void (*) (SkkDict*, GError**)) skk_empty_dict_real_reload;
	((SkkDictClass *) klass)->lookup = (SkkCandidate** (*) (SkkDict*, const gchar*, gboolean, gint*)) skk_empty_dict_real_lookup;
	((SkkDictClass *) klass)->complete = (gchar** (*) (SkkDict*, const gchar*, gint*)) skk_empty_dict_real_complete;
	SKK_DICT_CLASS (klass)->get_read_only = (gboolean (*) (SkkDict*)) skk_empty_dict_real_get_read_only;
	G_OBJECT_CLASS (klass)->get_property = _vala_skk_empty_dict_get_property;
	/**
	         * {@inheritDoc}
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_EMPTY_DICT_READ_ONLY_PROPERTY, skk_empty_dict_properties[SKK_EMPTY_DICT_READ_ONLY_PROPERTY] = g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
skk_empty_dict_instance_init (SkkEmptyDict * self,
                              gpointer klass)
{
}

/**
     * Null implementation of Dict.
     */
static GType
skk_empty_dict_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SkkEmptyDictClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_empty_dict_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkEmptyDict), 0, (GInstanceInitFunc) skk_empty_dict_instance_init, NULL };
	GType skk_empty_dict_type_id;
	skk_empty_dict_type_id = g_type_register_static (SKK_TYPE_DICT, "SkkEmptyDict", &g_define_type_info, 0);
	return skk_empty_dict_type_id;
}

GType
skk_empty_dict_get_type (void)
{
	static volatile gsize skk_empty_dict_type_id__once = 0;
	if (g_once_init_enter (&skk_empty_dict_type_id__once)) {
		GType skk_empty_dict_type_id;
		skk_empty_dict_type_id = skk_empty_dict_get_type_once ();
		g_once_init_leave (&skk_empty_dict_type_id__once, skk_empty_dict_type_id);
	}
	return skk_empty_dict_type_id__once;
}

static void
_vala_skk_empty_dict_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	SkkEmptyDict * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SKK_TYPE_EMPTY_DICT, SkkEmptyDict);
	switch (property_id) {
		case SKK_EMPTY_DICT_READ_ONLY_PROPERTY:
		g_value_set_boolean (value, skk_dict_get_read_only ((SkkDict*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

GQuark
skk_skk_dict_error_quark (void)
{
	return g_quark_from_static_string ("skk-skk-dict-error-quark");
}

static GType
skk_skk_dict_error_get_type_once (void)
{
	static const GEnumValue values[] = {{SKK_SKK_DICT_ERROR_NOT_READABLE, "SKK_SKK_DICT_ERROR_NOT_READABLE", "not-readable"}, {SKK_SKK_DICT_ERROR_MALFORMED_INPUT, "SKK_SKK_DICT_ERROR_MALFORMED_INPUT", "malformed-input"}, {0, NULL, NULL}};
	GType skk_skk_dict_error_type_id;
	skk_skk_dict_error_type_id = g_enum_register_static ("SkkSkkDictError", values);
	return skk_skk_dict_error_type_id;
}

GType
skk_skk_dict_error_get_type (void)
{
	static volatile gsize skk_skk_dict_error_type_id__once = 0;
	if (g_once_init_enter (&skk_skk_dict_error_type_id__once)) {
		GType skk_skk_dict_error_type_id;
		skk_skk_dict_error_type_id = skk_skk_dict_error_get_type_once ();
		g_once_init_leave (&skk_skk_dict_error_type_id__once, skk_skk_dict_error_type_id);
	}
	return skk_skk_dict_error_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

