/***********************************************************************
 * This file was generated by /build/libuhd/src/uhd/host/lib/ic_reg_maps/gen_adf5355_regs.py on Sat Dec 13 19:39:22 2025
 **********************************************************************/

#ifndef INCLUDED_ADF5355_REGS_HPP
#define INCLUDED_ADF5355_REGS_HPP

#include <uhd/config.hpp>
#include <uhd/exception.hpp>
#include <set>
#include <vector>
#include <stdint.h>

class adf5355_regs_t{
public:
    uint16_t int_16_bit;
    enum prescaler_t{
        PRESCALER_4_5 = 0,
        PRESCALER_8_9 = 1
    };
    prescaler_t prescaler;
    enum autocal_en_t{
        AUTOCAL_EN_DISABLED = 0,
        AUTOCAL_EN_ENABLED = 1
    };
    autocal_en_t autocal_en;
    uint16_t reg0_reserved0;
    uint32_t frac1_24_bit;
    uint8_t reg1_reserved0;
    uint16_t mod2_14_bit;
    uint16_t frac2_14_bit;
    uint32_t phase_24_bit;
    enum phase_adjust_t{
        PHASE_ADJUST_DISABLED = 0,
        PHASE_ADJUST_ENABLED = 1
    };
    phase_adjust_t phase_adjust;
    enum phase_resync_t{
        PHASE_RESYNC_DISABLED = 0,
        PHASE_RESYNC_ENABLED = 1
    };
    phase_resync_t phase_resync;
    enum sd_load_reset_t{
        SD_LOAD_RESET_ON_REG0_UPDATE = 0,
        SD_LOAD_RESET_DISABLED = 1
    };
    sd_load_reset_t sd_load_reset;
    enum counter_reset_t{
        COUNTER_RESET_DISABLED = 0,
        COUNTER_RESET_ENABLED = 1
    };
    counter_reset_t counter_reset;
    enum cp_three_state_t{
        CP_THREE_STATE_DISABLED = 0,
        CP_THREE_STATE_ENABLED = 1
    };
    cp_three_state_t cp_three_state;
    enum power_down_t{
        POWER_DOWN_DISABLED = 0,
        POWER_DOWN_ENABLED = 1
    };
    power_down_t power_down;
    enum pd_polarity_t{
        PD_POLARITY_NEGATIVE = 0,
        PD_POLARITY_POSITIVE = 1
    };
    pd_polarity_t pd_polarity;
    enum mux_logic_t{
        MUX_LOGIC_1_8V = 0,
        MUX_LOGIC_3_3V = 1
    };
    mux_logic_t mux_logic;
    enum ref_mode_t{
        REF_MODE_SINGLE = 0,
        REF_MODE_DIFF = 1
    };
    ref_mode_t ref_mode;
    enum charge_pump_current_t{
        CHARGE_PUMP_CURRENT_0_31MA = 0,
        CHARGE_PUMP_CURRENT_0_63MA = 1,
        CHARGE_PUMP_CURRENT_0_94MA = 2,
        CHARGE_PUMP_CURRENT_1_25MA = 3,
        CHARGE_PUMP_CURRENT_1_56MA = 4,
        CHARGE_PUMP_CURRENT_1_88MA = 5,
        CHARGE_PUMP_CURRENT_2_19MA = 6,
        CHARGE_PUMP_CURRENT_2_50MA = 7,
        CHARGE_PUMP_CURRENT_2_81MA = 8,
        CHARGE_PUMP_CURRENT_3_13MA = 9,
        CHARGE_PUMP_CURRENT_3_44MA = 10,
        CHARGE_PUMP_CURRENT_3_75MA = 11,
        CHARGE_PUMP_CURRENT_4_07MA = 12,
        CHARGE_PUMP_CURRENT_4_38MA = 13,
        CHARGE_PUMP_CURRENT_4_69MA = 14,
        CHARGE_PUMP_CURRENT_5_00MA = 15
    };
    charge_pump_current_t charge_pump_current;
    enum double_buff_div_t{
        DOUBLE_BUFF_DIV_DISABLED = 0,
        DOUBLE_BUFF_DIV_ENABLED = 1
    };
    double_buff_div_t double_buff_div;
    uint16_t r_counter_10_bit;
    enum reference_divide_by_2_t{
        REFERENCE_DIVIDE_BY_2_DISABLED = 0,
        REFERENCE_DIVIDE_BY_2_ENABLED = 1
    };
    reference_divide_by_2_t reference_divide_by_2;
    enum reference_doubler_t{
        REFERENCE_DOUBLER_DISABLED = 0,
        REFERENCE_DOUBLER_ENABLED = 1
    };
    reference_doubler_t reference_doubler;
    enum muxout_t{
        MUXOUT_3STATE = 0,
        MUXOUT_DVDD = 1,
        MUXOUT_DGND = 2,
        MUXOUT_RDIV = 3,
        MUXOUT_NDIV = 4,
        MUXOUT_ANALOG_LD = 5,
        MUXOUT_DLD = 6,
        MUXOUT_RESERVED = 7
    };
    muxout_t muxout;
    uint8_t reg4_reserved0;
    uint32_t reg5_reserved0;
    enum output_power_t{
        OUTPUT_POWER_M4DBM = 0,
        OUTPUT_POWER_M1DBM = 1,
        OUTPUT_POWER_2DBM = 2,
        OUTPUT_POWER_5DBM = 3
    };
    output_power_t output_power;
    enum rf_out_a_enabled_t{
        RF_OUT_A_ENABLED_DISABLED = 0,
        RF_OUT_A_ENABLED_ENABLED = 1
    };
    rf_out_a_enabled_t rf_out_a_enabled;
    uint8_t reg6_reserved0;
    enum rf_out_b_enabled_t{
        RF_OUT_B_ENABLED_ENABLED = 0,
        RF_OUT_B_ENABLED_DISABLED = 1
    };
    rf_out_b_enabled_t rf_out_b_enabled;
    enum mute_till_lock_detect_t{
        MUTE_TILL_LOCK_DETECT_MUTE_DISABLED = 0,
        MUTE_TILL_LOCK_DETECT_MUTE_ENABLED = 1
    };
    mute_till_lock_detect_t mute_till_lock_detect;
    uint8_t reg6_reserved1;
    uint8_t cp_bleed_current;
    enum rf_divider_select_t{
        RF_DIVIDER_SELECT_DIV1 = 0,
        RF_DIVIDER_SELECT_DIV2 = 1,
        RF_DIVIDER_SELECT_DIV4 = 2,
        RF_DIVIDER_SELECT_DIV8 = 3,
        RF_DIVIDER_SELECT_DIV16 = 4,
        RF_DIVIDER_SELECT_DIV32 = 5,
        RF_DIVIDER_SELECT_DIV64 = 6
    };
    rf_divider_select_t rf_divider_select;
    enum feedback_select_t{
        FEEDBACK_SELECT_DIVIDED = 0,
        FEEDBACK_SELECT_FUNDAMENTAL = 1
    };
    feedback_select_t feedback_select;
    uint8_t reg6_reserved2;
    enum negative_bleed_t{
        NEGATIVE_BLEED_DISABLED = 0,
        NEGATIVE_BLEED_ENABLED = 1
    };
    negative_bleed_t negative_bleed;
    enum gated_bleed_t{
        GATED_BLEED_DISABLED = 0,
        GATED_BLEED_ENABLED = 1
    };
    gated_bleed_t gated_bleed;
    uint8_t reg6_reserved3;
    enum ld_mode_t{
        LD_MODE_FRAC_N = 0,
        LD_MODE_INT_N = 1
    };
    ld_mode_t ld_mode;
    enum frac_n_ld_precision_t{
        FRAC_N_LD_PRECISION_5NS = 0,
        FRAC_N_LD_PRECISION_6NS = 1,
        FRAC_N_LD_PRECISION_8NS = 2,
        FRAC_N_LD_PRECISION_12NS = 3
    };
    frac_n_ld_precision_t frac_n_ld_precision;
    enum loss_of_lock_mode_t{
        LOSS_OF_LOCK_MODE_DISABLED = 0,
        LOSS_OF_LOCK_MODE_ENABLED = 1
    };
    loss_of_lock_mode_t loss_of_lock_mode;
    enum ld_cyc_count_t{
        LD_CYC_COUNT_1024 = 0,
        LD_CYC_COUNT_2048 = 1,
        LD_CYC_COUNT_4096 = 2,
        LD_CYC_COUNT_8192 = 3
    };
    ld_cyc_count_t ld_cyc_count;
    uint16_t reg7_reserved0;
    enum le_sync_t{
        LE_SYNC_DISABLED = 0,
        LE_SYNC_LE_SYNCED_TO_REFIN = 1
    };
    le_sync_t le_sync;
    uint8_t reg7_reserved1;
    uint32_t reg8_reserved0;
    uint8_t synth_lock_timeout;
    uint8_t auto_level_timeout;
    uint16_t timeout;
    uint8_t vco_band_div;
    enum adc_enable_t{
        ADC_ENABLE_DISABLED = 0,
        ADC_ENABLE_ENABLED = 1
    };
    adc_enable_t adc_enable;
    enum adc_conversion_t{
        ADC_CONVERSION_DISABLED = 0,
        ADC_CONVERSION_ENABLED = 1
    };
    adc_conversion_t adc_conversion;
    uint8_t adc_clock_divider;
    uint32_t reg10_reserved0;
    uint32_t reg11_reserved0;
    uint16_t reg12_reserved0;
    uint16_t phase_resync_clk_div;

    adf5355_regs_t(void){
        _state = NULL;
        int_16_bit = 0;
        prescaler = PRESCALER_4_5;
        autocal_en = AUTOCAL_EN_ENABLED;
        reg0_reserved0 = 0;
        frac1_24_bit = 0;
        reg1_reserved0 = 0;
        mod2_14_bit = 0;
        frac2_14_bit = 0;
        phase_24_bit = 0;
        phase_adjust = PHASE_ADJUST_DISABLED;
        phase_resync = PHASE_RESYNC_DISABLED;
        sd_load_reset = SD_LOAD_RESET_ON_REG0_UPDATE;
        counter_reset = COUNTER_RESET_DISABLED;
        cp_three_state = CP_THREE_STATE_DISABLED;
        power_down = POWER_DOWN_DISABLED;
        pd_polarity = PD_POLARITY_POSITIVE;
        mux_logic = MUX_LOGIC_3_3V;
        ref_mode = REF_MODE_SINGLE;
        charge_pump_current = CHARGE_PUMP_CURRENT_0_94MA;
        double_buff_div = DOUBLE_BUFF_DIV_DISABLED;
        r_counter_10_bit = 0;
        reference_divide_by_2 = REFERENCE_DIVIDE_BY_2_DISABLED;
        reference_doubler = REFERENCE_DOUBLER_DISABLED;
        muxout = MUXOUT_DVDD;
        reg4_reserved0 = 0;
        reg5_reserved0 = 524290;
        output_power = OUTPUT_POWER_M4DBM;
        rf_out_a_enabled = RF_OUT_A_ENABLED_DISABLED;
        reg6_reserved0 = 0;
        rf_out_b_enabled = RF_OUT_B_ENABLED_DISABLED;
        mute_till_lock_detect = MUTE_TILL_LOCK_DETECT_MUTE_DISABLED;
        reg6_reserved1 = 0;
        cp_bleed_current = 2;
        rf_divider_select = RF_DIVIDER_SELECT_DIV1;
        feedback_select = FEEDBACK_SELECT_DIVIDED;
        reg6_reserved2 = 10;
        negative_bleed = NEGATIVE_BLEED_DISABLED;
        gated_bleed = GATED_BLEED_DISABLED;
        reg6_reserved3 = 0;
        ld_mode = LD_MODE_FRAC_N;
        frac_n_ld_precision = FRAC_N_LD_PRECISION_5NS;
        loss_of_lock_mode = LOSS_OF_LOCK_MODE_DISABLED;
        ld_cyc_count = LD_CYC_COUNT_1024;
        reg7_reserved0 = 0;
        le_sync = LE_SYNC_LE_SYNCED_TO_REFIN;
        reg7_reserved1 = 4;
        reg8_reserved0 = 16962562;
        synth_lock_timeout = 0;
        auto_level_timeout = 0;
        timeout = 0;
        vco_band_div = 0;
        adc_enable = ADC_ENABLE_DISABLED;
        adc_conversion = ADC_CONVERSION_DISABLED;
        adc_clock_divider = 1;
        reg10_reserved0 = 768;
        reg11_reserved0 = 398080;
        reg12_reserved0 = 65;
        phase_resync_clk_div = 0;
    }

    ~adf5355_regs_t(void){
        delete _state;
    }

    enum addr_t{
        ADDR_R0 = 0,
        ADDR_R1 = 1,
        ADDR_R2 = 2,
        ADDR_R3 = 3,
        ADDR_R4 = 4,
        ADDR_R5 = 5,
        ADDR_R6 = 6,
        ADDR_R7 = 7,
        ADDR_R8 = 8,
        ADDR_R9 = 9,
        ADDR_R10 = 10,
        ADDR_R11 = 11,
        ADDR_R12 = 12
    };
    
    uint32_t get_reg(uint8_t addr){
        uint32_t reg = addr & 0xF;
        switch(addr){
        case 0:
            reg |= (uint32_t(int_16_bit) & 0xffff) << 4;
            reg |= (uint32_t(prescaler) & 0x1) << 20;
            reg |= (uint32_t(autocal_en) & 0x1) << 21;
            reg |= (uint32_t(reg0_reserved0) & 0x3ff) << 22;
            break;
        case 1:
            reg |= (uint32_t(frac1_24_bit) & 0xffffff) << 4;
            reg |= (uint32_t(reg1_reserved0) & 0xf) << 28;
            break;
        case 2:
            reg |= (uint32_t(mod2_14_bit) & 0x3fff) << 4;
            reg |= (uint32_t(frac2_14_bit) & 0x3fff) << 18;
            break;
        case 3:
            reg |= (uint32_t(phase_24_bit) & 0xffffff) << 4;
            reg |= (uint32_t(phase_adjust) & 0x1) << 28;
            reg |= (uint32_t(phase_resync) & 0x1) << 29;
            reg |= (uint32_t(sd_load_reset) & 0x1) << 30;
            break;
        case 4:
            reg |= (uint32_t(counter_reset) & 0x1) << 4;
            reg |= (uint32_t(cp_three_state) & 0x1) << 5;
            reg |= (uint32_t(power_down) & 0x1) << 6;
            reg |= (uint32_t(pd_polarity) & 0x1) << 7;
            reg |= (uint32_t(mux_logic) & 0x1) << 8;
            reg |= (uint32_t(ref_mode) & 0x1) << 9;
            reg |= (uint32_t(charge_pump_current) & 0xf) << 10;
            reg |= (uint32_t(double_buff_div) & 0x1) << 14;
            reg |= (uint32_t(r_counter_10_bit) & 0x3ff) << 15;
            reg |= (uint32_t(reference_divide_by_2) & 0x1) << 25;
            reg |= (uint32_t(reference_doubler) & 0x1) << 26;
            reg |= (uint32_t(muxout) & 0x7) << 27;
            reg |= (uint32_t(reg4_reserved0) & 0x3) << 30;
            break;
        case 5:
            reg |= (uint32_t(reg5_reserved0) & 0xfffffff) << 4;
            break;
        case 6:
            reg |= (uint32_t(output_power) & 0x3) << 4;
            reg |= (uint32_t(rf_out_a_enabled) & 0x1) << 6;
            reg |= (uint32_t(reg6_reserved0) & 0x7) << 7;
            reg |= (uint32_t(rf_out_b_enabled) & 0x1) << 10;
            reg |= (uint32_t(mute_till_lock_detect) & 0x1) << 11;
            reg |= (uint32_t(reg6_reserved1) & 0x1) << 12;
            reg |= (uint32_t(cp_bleed_current) & 0xff) << 13;
            reg |= (uint32_t(rf_divider_select) & 0x7) << 21;
            reg |= (uint32_t(feedback_select) & 0x1) << 24;
            reg |= (uint32_t(reg6_reserved2) & 0xf) << 25;
            reg |= (uint32_t(negative_bleed) & 0x1) << 29;
            reg |= (uint32_t(gated_bleed) & 0x1) << 30;
            reg |= (uint32_t(reg6_reserved3) & 0x1) << 31;
            break;
        case 7:
            reg |= (uint32_t(ld_mode) & 0x1) << 4;
            reg |= (uint32_t(frac_n_ld_precision) & 0x3) << 5;
            reg |= (uint32_t(loss_of_lock_mode) & 0x1) << 7;
            reg |= (uint32_t(ld_cyc_count) & 0x3) << 8;
            reg |= (uint32_t(reg7_reserved0) & 0x7fff) << 10;
            reg |= (uint32_t(le_sync) & 0x1) << 25;
            reg |= (uint32_t(reg7_reserved1) & 0x3f) << 26;
            break;
        case 8:
            reg |= (uint32_t(reg8_reserved0) & 0xfffffff) << 4;
            break;
        case 9:
            reg |= (uint32_t(synth_lock_timeout) & 0x1f) << 4;
            reg |= (uint32_t(auto_level_timeout) & 0x1f) << 9;
            reg |= (uint32_t(timeout) & 0x3ff) << 14;
            reg |= (uint32_t(vco_band_div) & 0xff) << 24;
            break;
        case 10:
            reg |= (uint32_t(adc_enable) & 0x1) << 4;
            reg |= (uint32_t(adc_conversion) & 0x1) << 5;
            reg |= (uint32_t(adc_clock_divider) & 0xff) << 6;
            reg |= (uint32_t(reg10_reserved0) & 0x3ffff) << 14;
            break;
        case 11:
            reg |= (uint32_t(reg11_reserved0) & 0xfffffff) << 4;
            break;
        case 12:
            reg |= (uint32_t(reg12_reserved0) & 0xfff) << 4;
            reg |= (uint32_t(phase_resync_clk_div) & 0xffff) << 16;
            break;
        }
        return reg;
    }

    void save_state(void){
        if (_state == NULL) _state = new adf5355_regs_t();
        _state->int_16_bit = this->int_16_bit;
        _state->prescaler = this->prescaler;
        _state->autocal_en = this->autocal_en;
        _state->reg0_reserved0 = this->reg0_reserved0;
        _state->frac1_24_bit = this->frac1_24_bit;
        _state->reg1_reserved0 = this->reg1_reserved0;
        _state->mod2_14_bit = this->mod2_14_bit;
        _state->frac2_14_bit = this->frac2_14_bit;
        _state->phase_24_bit = this->phase_24_bit;
        _state->phase_adjust = this->phase_adjust;
        _state->phase_resync = this->phase_resync;
        _state->sd_load_reset = this->sd_load_reset;
        _state->counter_reset = this->counter_reset;
        _state->cp_three_state = this->cp_three_state;
        _state->power_down = this->power_down;
        _state->pd_polarity = this->pd_polarity;
        _state->mux_logic = this->mux_logic;
        _state->ref_mode = this->ref_mode;
        _state->charge_pump_current = this->charge_pump_current;
        _state->double_buff_div = this->double_buff_div;
        _state->r_counter_10_bit = this->r_counter_10_bit;
        _state->reference_divide_by_2 = this->reference_divide_by_2;
        _state->reference_doubler = this->reference_doubler;
        _state->muxout = this->muxout;
        _state->reg4_reserved0 = this->reg4_reserved0;
        _state->reg5_reserved0 = this->reg5_reserved0;
        _state->output_power = this->output_power;
        _state->rf_out_a_enabled = this->rf_out_a_enabled;
        _state->reg6_reserved0 = this->reg6_reserved0;
        _state->rf_out_b_enabled = this->rf_out_b_enabled;
        _state->mute_till_lock_detect = this->mute_till_lock_detect;
        _state->reg6_reserved1 = this->reg6_reserved1;
        _state->cp_bleed_current = this->cp_bleed_current;
        _state->rf_divider_select = this->rf_divider_select;
        _state->feedback_select = this->feedback_select;
        _state->reg6_reserved2 = this->reg6_reserved2;
        _state->negative_bleed = this->negative_bleed;
        _state->gated_bleed = this->gated_bleed;
        _state->reg6_reserved3 = this->reg6_reserved3;
        _state->ld_mode = this->ld_mode;
        _state->frac_n_ld_precision = this->frac_n_ld_precision;
        _state->loss_of_lock_mode = this->loss_of_lock_mode;
        _state->ld_cyc_count = this->ld_cyc_count;
        _state->reg7_reserved0 = this->reg7_reserved0;
        _state->le_sync = this->le_sync;
        _state->reg7_reserved1 = this->reg7_reserved1;
        _state->reg8_reserved0 = this->reg8_reserved0;
        _state->synth_lock_timeout = this->synth_lock_timeout;
        _state->auto_level_timeout = this->auto_level_timeout;
        _state->timeout = this->timeout;
        _state->vco_band_div = this->vco_band_div;
        _state->adc_enable = this->adc_enable;
        _state->adc_conversion = this->adc_conversion;
        _state->adc_clock_divider = this->adc_clock_divider;
        _state->reg10_reserved0 = this->reg10_reserved0;
        _state->reg11_reserved0 = this->reg11_reserved0;
        _state->reg12_reserved0 = this->reg12_reserved0;
        _state->phase_resync_clk_div = this->phase_resync_clk_div;
    }

    uint16_t get_state_int_16_bit(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->int_16_bit;
    }

    prescaler_t get_state_prescaler(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->prescaler;
    }

    autocal_en_t get_state_autocal_en(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->autocal_en;
    }

    uint16_t get_state_reg0_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg0_reserved0;
    }

    uint32_t get_state_frac1_24_bit(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->frac1_24_bit;
    }

    uint8_t get_state_reg1_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg1_reserved0;
    }

    uint16_t get_state_mod2_14_bit(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->mod2_14_bit;
    }

    uint16_t get_state_frac2_14_bit(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->frac2_14_bit;
    }

    uint32_t get_state_phase_24_bit(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->phase_24_bit;
    }

    phase_adjust_t get_state_phase_adjust(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->phase_adjust;
    }

    phase_resync_t get_state_phase_resync(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->phase_resync;
    }

    sd_load_reset_t get_state_sd_load_reset(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->sd_load_reset;
    }

    counter_reset_t get_state_counter_reset(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->counter_reset;
    }

    cp_three_state_t get_state_cp_three_state(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->cp_three_state;
    }

    power_down_t get_state_power_down(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->power_down;
    }

    pd_polarity_t get_state_pd_polarity(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->pd_polarity;
    }

    mux_logic_t get_state_mux_logic(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->mux_logic;
    }

    ref_mode_t get_state_ref_mode(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ref_mode;
    }

    charge_pump_current_t get_state_charge_pump_current(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->charge_pump_current;
    }

    double_buff_div_t get_state_double_buff_div(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->double_buff_div;
    }

    uint16_t get_state_r_counter_10_bit(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->r_counter_10_bit;
    }

    reference_divide_by_2_t get_state_reference_divide_by_2(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reference_divide_by_2;
    }

    reference_doubler_t get_state_reference_doubler(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reference_doubler;
    }

    muxout_t get_state_muxout(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->muxout;
    }

    uint8_t get_state_reg4_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg4_reserved0;
    }

    uint32_t get_state_reg5_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg5_reserved0;
    }

    output_power_t get_state_output_power(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->output_power;
    }

    rf_out_a_enabled_t get_state_rf_out_a_enabled(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->rf_out_a_enabled;
    }

    uint8_t get_state_reg6_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg6_reserved0;
    }

    rf_out_b_enabled_t get_state_rf_out_b_enabled(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->rf_out_b_enabled;
    }

    mute_till_lock_detect_t get_state_mute_till_lock_detect(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->mute_till_lock_detect;
    }

    uint8_t get_state_reg6_reserved1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg6_reserved1;
    }

    uint8_t get_state_cp_bleed_current(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->cp_bleed_current;
    }

    rf_divider_select_t get_state_rf_divider_select(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->rf_divider_select;
    }

    feedback_select_t get_state_feedback_select(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->feedback_select;
    }

    uint8_t get_state_reg6_reserved2(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg6_reserved2;
    }

    negative_bleed_t get_state_negative_bleed(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->negative_bleed;
    }

    gated_bleed_t get_state_gated_bleed(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->gated_bleed;
    }

    uint8_t get_state_reg6_reserved3(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg6_reserved3;
    }

    ld_mode_t get_state_ld_mode(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ld_mode;
    }

    frac_n_ld_precision_t get_state_frac_n_ld_precision(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->frac_n_ld_precision;
    }

    loss_of_lock_mode_t get_state_loss_of_lock_mode(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->loss_of_lock_mode;
    }

    ld_cyc_count_t get_state_ld_cyc_count(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ld_cyc_count;
    }

    uint16_t get_state_reg7_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg7_reserved0;
    }

    le_sync_t get_state_le_sync(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->le_sync;
    }

    uint8_t get_state_reg7_reserved1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg7_reserved1;
    }

    uint32_t get_state_reg8_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg8_reserved0;
    }

    uint8_t get_state_synth_lock_timeout(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->synth_lock_timeout;
    }

    uint8_t get_state_auto_level_timeout(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->auto_level_timeout;
    }

    uint16_t get_state_timeout(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->timeout;
    }

    uint8_t get_state_vco_band_div(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->vco_band_div;
    }

    adc_enable_t get_state_adc_enable(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->adc_enable;
    }

    adc_conversion_t get_state_adc_conversion(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->adc_conversion;
    }

    uint8_t get_state_adc_clock_divider(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->adc_clock_divider;
    }

    uint32_t get_state_reg10_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg10_reserved0;
    }

    uint32_t get_state_reg11_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg11_reserved0;
    }

    uint16_t get_state_reg12_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg12_reserved0;
    }

    uint16_t get_state_phase_resync_clk_div(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->phase_resync_clk_div;
    }


    template<typename T> std::set<T> get_changed_addrs(bool include_ro = false) {
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        //check each register for changes
        std::set<T> addrs;
        if (include_ro || !false) {
            if(_state->int_16_bit != this->int_16_bit) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->prescaler != this->prescaler) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->autocal_en != this->autocal_en) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->reg0_reserved0 != this->reg0_reserved0) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->frac1_24_bit != this->frac1_24_bit) {
                addrs.insert(1);
            }
        }
        if (include_ro || !false) {
            if(_state->reg1_reserved0 != this->reg1_reserved0) {
                addrs.insert(1);
            }
        }
        if (include_ro || !false) {
            if(_state->mod2_14_bit != this->mod2_14_bit) {
                addrs.insert(2);
            }
        }
        if (include_ro || !false) {
            if(_state->frac2_14_bit != this->frac2_14_bit) {
                addrs.insert(2);
            }
        }
        if (include_ro || !false) {
            if(_state->phase_24_bit != this->phase_24_bit) {
                addrs.insert(3);
            }
        }
        if (include_ro || !false) {
            if(_state->phase_adjust != this->phase_adjust) {
                addrs.insert(3);
            }
        }
        if (include_ro || !false) {
            if(_state->phase_resync != this->phase_resync) {
                addrs.insert(3);
            }
        }
        if (include_ro || !false) {
            if(_state->sd_load_reset != this->sd_load_reset) {
                addrs.insert(3);
            }
        }
        if (include_ro || !false) {
            if(_state->counter_reset != this->counter_reset) {
                addrs.insert(4);
            }
        }
        if (include_ro || !false) {
            if(_state->cp_three_state != this->cp_three_state) {
                addrs.insert(4);
            }
        }
        if (include_ro || !false) {
            if(_state->power_down != this->power_down) {
                addrs.insert(4);
            }
        }
        if (include_ro || !false) {
            if(_state->pd_polarity != this->pd_polarity) {
                addrs.insert(4);
            }
        }
        if (include_ro || !false) {
            if(_state->mux_logic != this->mux_logic) {
                addrs.insert(4);
            }
        }
        if (include_ro || !false) {
            if(_state->ref_mode != this->ref_mode) {
                addrs.insert(4);
            }
        }
        if (include_ro || !false) {
            if(_state->charge_pump_current != this->charge_pump_current) {
                addrs.insert(4);
            }
        }
        if (include_ro || !false) {
            if(_state->double_buff_div != this->double_buff_div) {
                addrs.insert(4);
            }
        }
        if (include_ro || !false) {
            if(_state->r_counter_10_bit != this->r_counter_10_bit) {
                addrs.insert(4);
            }
        }
        if (include_ro || !false) {
            if(_state->reference_divide_by_2 != this->reference_divide_by_2) {
                addrs.insert(4);
            }
        }
        if (include_ro || !false) {
            if(_state->reference_doubler != this->reference_doubler) {
                addrs.insert(4);
            }
        }
        if (include_ro || !false) {
            if(_state->muxout != this->muxout) {
                addrs.insert(4);
            }
        }
        if (include_ro || !false) {
            if(_state->reg4_reserved0 != this->reg4_reserved0) {
                addrs.insert(4);
            }
        }
        if (include_ro || !false) {
            if(_state->reg5_reserved0 != this->reg5_reserved0) {
                addrs.insert(5);
            }
        }
        if (include_ro || !false) {
            if(_state->output_power != this->output_power) {
                addrs.insert(6);
            }
        }
        if (include_ro || !false) {
            if(_state->rf_out_a_enabled != this->rf_out_a_enabled) {
                addrs.insert(6);
            }
        }
        if (include_ro || !false) {
            if(_state->reg6_reserved0 != this->reg6_reserved0) {
                addrs.insert(6);
            }
        }
        if (include_ro || !false) {
            if(_state->rf_out_b_enabled != this->rf_out_b_enabled) {
                addrs.insert(6);
            }
        }
        if (include_ro || !false) {
            if(_state->mute_till_lock_detect != this->mute_till_lock_detect) {
                addrs.insert(6);
            }
        }
        if (include_ro || !false) {
            if(_state->reg6_reserved1 != this->reg6_reserved1) {
                addrs.insert(6);
            }
        }
        if (include_ro || !false) {
            if(_state->cp_bleed_current != this->cp_bleed_current) {
                addrs.insert(6);
            }
        }
        if (include_ro || !false) {
            if(_state->rf_divider_select != this->rf_divider_select) {
                addrs.insert(6);
            }
        }
        if (include_ro || !false) {
            if(_state->feedback_select != this->feedback_select) {
                addrs.insert(6);
            }
        }
        if (include_ro || !false) {
            if(_state->reg6_reserved2 != this->reg6_reserved2) {
                addrs.insert(6);
            }
        }
        if (include_ro || !false) {
            if(_state->negative_bleed != this->negative_bleed) {
                addrs.insert(6);
            }
        }
        if (include_ro || !false) {
            if(_state->gated_bleed != this->gated_bleed) {
                addrs.insert(6);
            }
        }
        if (include_ro || !false) {
            if(_state->reg6_reserved3 != this->reg6_reserved3) {
                addrs.insert(6);
            }
        }
        if (include_ro || !false) {
            if(_state->ld_mode != this->ld_mode) {
                addrs.insert(7);
            }
        }
        if (include_ro || !false) {
            if(_state->frac_n_ld_precision != this->frac_n_ld_precision) {
                addrs.insert(7);
            }
        }
        if (include_ro || !false) {
            if(_state->loss_of_lock_mode != this->loss_of_lock_mode) {
                addrs.insert(7);
            }
        }
        if (include_ro || !false) {
            if(_state->ld_cyc_count != this->ld_cyc_count) {
                addrs.insert(7);
            }
        }
        if (include_ro || !false) {
            if(_state->reg7_reserved0 != this->reg7_reserved0) {
                addrs.insert(7);
            }
        }
        if (include_ro || !false) {
            if(_state->le_sync != this->le_sync) {
                addrs.insert(7);
            }
        }
        if (include_ro || !false) {
            if(_state->reg7_reserved1 != this->reg7_reserved1) {
                addrs.insert(7);
            }
        }
        if (include_ro || !false) {
            if(_state->reg8_reserved0 != this->reg8_reserved0) {
                addrs.insert(8);
            }
        }
        if (include_ro || !false) {
            if(_state->synth_lock_timeout != this->synth_lock_timeout) {
                addrs.insert(9);
            }
        }
        if (include_ro || !false) {
            if(_state->auto_level_timeout != this->auto_level_timeout) {
                addrs.insert(9);
            }
        }
        if (include_ro || !false) {
            if(_state->timeout != this->timeout) {
                addrs.insert(9);
            }
        }
        if (include_ro || !false) {
            if(_state->vco_band_div != this->vco_band_div) {
                addrs.insert(9);
            }
        }
        if (include_ro || !false) {
            if(_state->adc_enable != this->adc_enable) {
                addrs.insert(10);
            }
        }
        if (include_ro || !false) {
            if(_state->adc_conversion != this->adc_conversion) {
                addrs.insert(10);
            }
        }
        if (include_ro || !false) {
            if(_state->adc_clock_divider != this->adc_clock_divider) {
                addrs.insert(10);
            }
        }
        if (include_ro || !false) {
            if(_state->reg10_reserved0 != this->reg10_reserved0) {
                addrs.insert(10);
            }
        }
        if (include_ro || !false) {
            if(_state->reg11_reserved0 != this->reg11_reserved0) {
                addrs.insert(11);
            }
        }
        if (include_ro || !false) {
            if(_state->reg12_reserved0 != this->reg12_reserved0) {
                addrs.insert(12);
            }
        }
        if (include_ro || !false) {
            if(_state->phase_resync_clk_div != this->phase_resync_clk_div) {
                addrs.insert(12);
            }
        }
        return addrs;
    }

private:
    adf5355_regs_t *_state;
};

#endif /* INCLUDED_ADF5355_REGS_HPP */
