use gio::prelude::ToVariant;
use glib::Boxed;
use news_flash::models::FeedID;
use std::fmt;

#[derive(Clone, Debug, Eq, Boxed)]
#[boxed_type(name = "GFeedID")]
pub struct GFeedID(FeedID);

impl From<FeedID> for GFeedID {
    fn from(id: FeedID) -> Self {
        Self(id)
    }
}

impl AsRef<FeedID> for GFeedID {
    fn as_ref(&self) -> &FeedID {
        &self.0
    }
}

impl From<GFeedID> for FeedID {
    fn from(id: GFeedID) -> Self {
        id.0
    }
}

impl Default for GFeedID {
    fn default() -> Self {
        FeedID::from_owned(String::new()).into()
    }
}

impl ToVariant for GFeedID {
    fn to_variant(&self) -> glib::Variant {
        self.0.as_str().to_variant()
    }
}

impl fmt::Display for GFeedID {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        write!(f, "{}", self.0)
    }
}

impl PartialEq for GFeedID {
    fn eq(&self, other: &GFeedID) -> bool {
        self.0 == other.0
    }
}
