/* converter-data.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from converter-data.vala, do not modify */

/*
* Copyright (c) 2022 elementary LLC.
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Jeremy Wootten <jeremywootten@gmail.com>
*/

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include "slingshot.h"

#define SYNAPSE_MASS "unit of mass"
#define SYNAPSE_LENGTH "unit of length"
#define SYNAPSE_AREA "unit of area"
#define SYNAPSE_VOLUME "unit of volume"
#define SYNAPSE_TIME "unit of time"
#define SYNAPSE_VELOCITY "unit of velocity"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define SYNAPSE_TYPE_SI_PREFIX (synapse_si_prefix_get_type ())
typedef struct _SynapseSIPrefix SynapseSIPrefix;
typedef enum  {
	SYNAPSE_UNIT_SYSTEM_SI,
	SYNAPSE_UNIT_SYSTEM_IMPERIAL,
	SYNAPSE_UNIT_SYSTEM_IMPERIAL_UK,
	SYNAPSE_UNIT_SYSTEM_IMPERIAL_US
} SynapseUnitSystem;

#define SYNAPSE_TYPE_UNIT_SYSTEM (synapse_unit_system_get_type ())
typedef enum  {
	SYNAPSE_UNIT_TYPE_MASS,
	SYNAPSE_UNIT_TYPE_DIMENSION,
	SYNAPSE_UNIT_TYPE_TIME,
	SYNAPSE_UNIT_TYPE_VELOCITY
} SynapseUnitType;

#define SYNAPSE_TYPE_UNIT_TYPE (synapse_unit_type_get_type ())

#define SYNAPSE_TYPE_UNIT (synapse_unit_get_type ())
typedef struct _SynapseUnit SynapseUnit;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _SynapseSIPrefix {
	gchar* prefix;
	gchar* abbrev;
	gdouble factor;
};

struct _SynapseUnit {
	SynapseUnitType type;
	SynapseUnitSystem system;
	gchar* uid;
	gchar* abbreviations;
	gchar* description;
	gchar* size_s;
	gchar* base_unit;
};

VALA_EXTERN GType synapse_si_prefix_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SynapseSIPrefix* synapse_si_prefix_dup (const SynapseSIPrefix* self);
VALA_EXTERN void synapse_si_prefix_free (SynapseSIPrefix* self);
VALA_EXTERN void synapse_si_prefix_copy (const SynapseSIPrefix* self,
                             SynapseSIPrefix* dest);
VALA_EXTERN void synapse_si_prefix_destroy (SynapseSIPrefix* self);
VALA_EXTERN GType synapse_unit_system_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType synapse_unit_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType synapse_unit_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SynapseUnit* synapse_unit_dup (const SynapseUnit* self);
VALA_EXTERN void synapse_unit_free (SynapseUnit* self);
VALA_EXTERN void synapse_unit_copy (const SynapseUnit* self,
                        SynapseUnit* dest);
VALA_EXTERN void synapse_unit_destroy (SynapseUnit* self);
VALA_EXTERN gdouble synapse_unit_get_factor (SynapseUnit *self);
VALA_EXTERN void synapse_si_prefix_get_default (SynapseSIPrefix* result);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

const SynapseSIPrefix SYNAPSE_PREFIXES[20] = {{"yotta", "Y", 1E24}, {"zetta", "Z", 1E21}, {"exa", "E", 1E18}, {"peta", "P", 1E15}, {"tera", "T", 1E12}, {"giga", "G", 1E9}, {"mega", "M", 1E6}, {"kilo", "k", (gdouble) 1000}, {"hecto", "h", (gdouble) 100}, {"deca", "da", (gdouble) 10}, {"deci", "d", 0.1}, {"centi", "c", 0.01}, {"milli", "m", 0.001}, {"micro", "u", 1E-6}, {"nano", "n", 1E-9}, {"pico", "p", 1E-12}, {"femto", "f", 1E-15}, {"atto", "a", 1E-18}, {"zepto", "z", 1E-21}, {"yocto", "y", 1E-24}};
const SynapseUnit SYNAPSE_UNITS[75] = {{SYNAPSE_UNIT_TYPE_MASS, SYNAPSE_UNIT_SYSTEM_SI, "gram", "g|gm|gramme", NC_ (SYNAPSE_MASS, "SI gram"), "1", ""}, {SYNAPSE_UNIT_TYPE_MASS, SYNAPSE_UNIT_SYSTEM_SI, "kilogram", "kilo", NC_ (SYNAPSE_MASS, "kilogram"), "1000", "gram"}, {SYNAPSE_UNIT_TYPE_MASS, SYNAPSE_UNIT_SYSTEM_SI, "tonne", "t|ton", NC_ (SYNAPSE_MASS, "SI tonne"), "1E6", "gram"}, {SYNAPSE_UNIT_TYPE_MASS, SYNAPSE_UNIT_SYSTEM_SI, "metriccarat", "carat|ct", NC_ (SYNAPSE_MASS, "metric carat"), "0.2", "gram"}, {SYNAPSE_UNIT_TYPE_MASS, SYNAPSE_UNIT_SYSTEM_SI, "metricgrain", "grain|gr", NC_ (SYNAPSE_MASS, "metric grain"), "1/4", "metriccarat"}, {SYNAPSE_UNIT_TYPE_MASS, SYNAPSE_UNIT_SYSTEM_IMPERIAL, "pound", "lb", NC_ (SYNAPSE_MASS, "pound"), "454", "gram"}, {SYNAPSE_UNIT_TYPE_MASS, SYNAPSE_UNIT_SYSTEM_IMPERIAL, "stone", "st", NC_ (SYNAPSE_MASS, "stone"), "14", "pound"}, {SYNAPSE_UNIT_TYPE_MASS, SYNAPSE_UNIT_SYSTEM_IMPERIAL, "ounce", "oz", NC_ (SYNAPSE_MASS, "ounce"), "1/16", "pound"}, {SYNAPSE_UNIT_TYPE_MASS, SYNAPSE_UNIT_SYSTEM_IMPERIAL, "dram", "dr", NC_ (SYNAPSE_MASS, "dram"), "1/16", "ounce"}, {SYNAPSE_UNIT_TYPE_MASS, SYNAPSE_UNIT_SYSTEM_IMPERIAL, "grain", "gr", NC_ (SYNAPSE_MASS, "grain"), "1/7000", "pound"}, {SYNAPSE_UNIT_TYPE_MASS, SYNAPSE_UNIT_SYSTEM_IMPERIAL_UK, "brhundredweight", "hundredweight|cwt", NC_ (SYNAPSE_MASS, "British hundredweight"), "8", "stone"}, {SYNAPSE_UNIT_TYPE_MASS, SYNAPSE_UNIT_SYSTEM_IMPERIAL_US, "ushundredweight", "hundredweight|cwt", NC_ (SYNAPSE_MASS, "US hundredweight"), "100", "pound"}, {SYNAPSE_UNIT_TYPE_MASS, SYNAPSE_UNIT_SYSTEM_IMPERIAL_US, "ukton", "t|ton|longton", NC_ (SYNAPSE_MASS, "British ton"), "20", "brhundredweight"}, {SYNAPSE_UNIT_TYPE_MASS, SYNAPSE_UNIT_SYSTEM_IMPERIAL_UK, "uston", "t|ton|shortton", NC_ (SYNAPSE_MASS, "US ton"), "2000", "pound"}, {SYNAPSE_UNIT_TYPE_DIMENSION, SYNAPSE_UNIT_SYSTEM_SI, "meter", "m", NC_ (SYNAPSE_LENGTH, "meter"), "1", ""}, {SYNAPSE_UNIT_TYPE_DIMENSION, SYNAPSE_UNIT_SYSTEM_SI, "click", "", NC_ (SYNAPSE_LENGTH, "kilometer"), "1000", "meter"}, {SYNAPSE_UNIT_TYPE_DIMENSION, SYNAPSE_UNIT_SYSTEM_SI, "astronomicalunit", "au", NC_ (SYNAPSE_LENGTH, "astronomical unit"), "49597870700", "meter"}, {SYNAPSE_UNIT_TYPE_DIMENSION, SYNAPSE_UNIT_SYSTEM_SI, "parsec", "pc", NC_ (SYNAPSE_LENGTH, "parsec"), "206264.806247096", "astronomicalunit"}, {SYNAPSE_UNIT_TYPE_DIMENSION, SYNAPSE_UNIT_SYSTEM_SI, "lightyear", "ly", NC_ (SYNAPSE_LENGTH, "light year"), "9.46073047258E15", "meter"}, {SYNAPSE_UNIT_TYPE_DIMENSION, SYNAPSE_UNIT_SYSTEM_IMPERIAL, "inch", "in", NC_ (SYNAPSE_LENGTH, "International inch"), "0.0254", "meter"}, {SYNAPSE_UNIT_TYPE_DIMENSION, SYNAPSE_UNIT_SYSTEM_IMPERIAL, "yard", "yd", NC_ (SYNAPSE_LENGTH, "International yard"), "3", "foot"}, {SYNAPSE_UNIT_TYPE_DIMENSION, SYNAPSE_UNIT_SYSTEM_IMPERIAL, "foot", "ft", NC_ (SYNAPSE_LENGTH, "International foot"), "12", "inch"}, {SYNAPSE_UNIT_TYPE_DIMENSION, SYNAPSE_UNIT_SYSTEM_IMPERIAL, "fathom", "", NC_ (SYNAPSE_LENGTH, "fathom"), "6", "foot"}, {SYNAPSE_UNIT_TYPE_DIMENSION, SYNAPSE_UNIT_SYSTEM_IMPERIAL, "chain", "ch", NC_ (SYNAPSE_LENGTH, "chain"), "66", "foot"}, {SYNAPSE_UNIT_TYPE_DIMENSION, SYNAPSE_UNIT_SYSTEM_IMPERIAL, "surveyorschain", "surveyorchain|ch", NC_ (SYNAPSE_LENGTH, "US surveyors chain"), "66", "surveyfoot"}, {SYNAPSE_UNIT_TYPE_DIMENSION, SYNAPSE_UNIT_SYSTEM_IMPERIAL_US, "surveyfoot", "surveyft|ft", NC_ (SYNAPSE_LENGTH, "US survey foot"), "1200/3937", "meter"}, {SYNAPSE_UNIT_TYPE_DIMENSION, SYNAPSE_UNIT_SYSTEM_IMPERIAL, "link", "", NC_ (SYNAPSE_LENGTH, "link"), "1/100", "chain"}, {SYNAPSE_UNIT_TYPE_DIMENSION, SYNAPSE_UNIT_SYSTEM_IMPERIAL, "furlong", "", NC_ (SYNAPSE_LENGTH, "furlong"), "1/8", "imile"}, {SYNAPSE_UNIT_TYPE_DIMENSION, SYNAPSE_UNIT_SYSTEM_IMPERIAL, "imile", "mi|mile", NC_ (SYNAPSE_LENGTH, "mile"), "1760", "yard"}, {SYNAPSE_UNIT_TYPE_DIMENSION, SYNAPSE_UNIT_SYSTEM_IMPERIAL, "nmile", "mi|nmi|mile", NC_ (SYNAPSE_LENGTH, "nautical mile"), "1852", "yard"}, {SYNAPSE_UNIT_TYPE_DIMENSION, SYNAPSE_UNIT_SYSTEM_IMPERIAL, "cmile", "mi|cmi|mile", NC_ (SYNAPSE_LENGTH, "country mile"), "2200", "yard"}, {SYNAPSE_UNIT_TYPE_DIMENSION, SYNAPSE_UNIT_SYSTEM_IMPERIAL, "iacre", "acre", NC_ (SYNAPSE_AREA, "International acre"), "10", "chain2"}, {SYNAPSE_UNIT_TYPE_DIMENSION, SYNAPSE_UNIT_SYSTEM_IMPERIAL_US, "usacre", "acre", NC_ (SYNAPSE_AREA, "US acre"), "10", "surveyorschain2"}, {SYNAPSE_UNIT_TYPE_DIMENSION, SYNAPSE_UNIT_SYSTEM_SI, "liter", "l", NC_ (SYNAPSE_VOLUME, "liter"), "0.001", "meter3"}, {SYNAPSE_UNIT_TYPE_DIMENSION, SYNAPSE_UNIT_SYSTEM_IMPERIAL_UK, "ukgal", "gal|gallon", NC_ (SYNAPSE_VOLUME, "British gallon"), "4.54609", "liter"}, {SYNAPSE_UNIT_TYPE_DIMENSION, SYNAPSE_UNIT_SYSTEM_IMPERIAL_UK, "ukqt", "qt|quart", NC_ (SYNAPSE_VOLUME, "British quart"), "1/4", "ukgal"}, {SYNAPSE_UNIT_TYPE_DIMENSION, SYNAPSE_UNIT_SYSTEM_IMPERIAL_UK, "ukpint", "pt|pint", NC_ (SYNAPSE_VOLUME, "British pint"), "1/8", "ukgal"}, {SYNAPSE_UNIT_TYPE_DIMENSION, SYNAPSE_UNIT_SYSTEM_IMPERIAL_UK, "ukfluidounce", "ukflozfloz", NC_ (SYNAPSE_VOLUME, "British fluid ounce"), "1/20", "ukpint"}, {SYNAPSE_UNIT_TYPE_DIMENSION, SYNAPSE_UNIT_SYSTEM_IMPERIAL_UK, "gill", "", NC_ (SYNAPSE_VOLUME, "gill"), "1/4", "ukpint"}, {SYNAPSE_UNIT_TYPE_DIMENSION, SYNAPSE_UNIT_SYSTEM_IMPERIAL_UK, "ukcup", "cup", NC_ (SYNAPSE_VOLUME, "British cup"), "1/2", "ukpint"}, {SYNAPSE_UNIT_TYPE_DIMENSION, SYNAPSE_UNIT_SYSTEM_IMPERIAL_UK, "ukteacup", "teacup", NC_ (SYNAPSE_VOLUME, "British teacup"), "1/3", "ukpint"}, {SYNAPSE_UNIT_TYPE_DIMENSION, SYNAPSE_UNIT_SYSTEM_IMPERIAL_UK, "uktbsp", "tbsp", NC_ (SYNAPSE_VOLUME, "British tablespoon"), "15/1000", "liter"}, {SYNAPSE_UNIT_TYPE_DIMENSION, SYNAPSE_UNIT_SYSTEM_IMPERIAL_UK, "uktsp", "tsp", NC_ (SYNAPSE_VOLUME, "British teaspoon"), "1/3", "uktbsp"}, {SYNAPSE_UNIT_TYPE_DIMENSION, SYNAPSE_UNIT_SYSTEM_IMPERIAL_UK, "uksmalltsp", "tsp", NC_ (SYNAPSE_VOLUME, "British small teaspoon"), "1/4", "uktbsp"}, {SYNAPSE_UNIT_TYPE_DIMENSION, SYNAPSE_UNIT_SYSTEM_IMPERIAL_UK, "ukdessertspoon", "dsp", NC_ (SYNAPSE_VOLUME, "British dessertspoon"), "2", "ukteaspoon"}, {SYNAPSE_UNIT_TYPE_DIMENSION, SYNAPSE_UNIT_SYSTEM_IMPERIAL_US, "usgal", "gal|gallon", NC_ (SYNAPSE_VOLUME, "US liquid gallon"), "231", "inch3"}, {SYNAPSE_UNIT_TYPE_DIMENSION, SYNAPSE_UNIT_SYSTEM_IMPERIAL_US, "usqt", "qt|quart", NC_ (SYNAPSE_VOLUME, "US liquid quart"), "1/4", "usgal"}, {SYNAPSE_UNIT_TYPE_DIMENSION, SYNAPSE_UNIT_SYSTEM_IMPERIAL_US, "uspint", "pt|pint", NC_ (SYNAPSE_VOLUME, "US liquid pint"), "1/8", "usgal"}, {SYNAPSE_UNIT_TYPE_DIMENSION, SYNAPSE_UNIT_SYSTEM_IMPERIAL_US, "usfluidounce", "usfloz|floz", NC_ (SYNAPSE_VOLUME, "US fluid ounce"), "1/16", "uspint"}, {SYNAPSE_UNIT_TYPE_DIMENSION, SYNAPSE_UNIT_SYSTEM_IMPERIAL_US, "uscup", "cup", NC_ (SYNAPSE_VOLUME, "US cup"), "8", "usfluidounce"}, {SYNAPSE_UNIT_TYPE_DIMENSION, SYNAPSE_UNIT_SYSTEM_IMPERIAL_US, "uslegalcup", "legalcup|cup", NC_ (SYNAPSE_VOLUME, "US legal cup"), "240/1000", "liter"}, {SYNAPSE_UNIT_TYPE_DIMENSION, SYNAPSE_UNIT_SYSTEM_IMPERIAL_US, "metriccup", "cup", NC_ (SYNAPSE_VOLUME, "US metric cup"), "250/1000", "liter"}, {SYNAPSE_UNIT_TYPE_DIMENSION, SYNAPSE_UNIT_SYSTEM_IMPERIAL_US, "ustablespoon", "ustbsp|tbsp", NC_ (SYNAPSE_VOLUME, "US tablespoon"), "1/16", "uscup"}, {SYNAPSE_UNIT_TYPE_DIMENSION, SYNAPSE_UNIT_SYSTEM_IMPERIAL_US, "uslegaltablespoon", "legaltbsp|tbsp", NC_ (SYNAPSE_VOLUME, "US legal tablespoon"), "1/16", "uslegalcup"}, {SYNAPSE_UNIT_TYPE_DIMENSION, SYNAPSE_UNIT_SYSTEM_IMPERIAL_US, "usteaspoon", "ustsp|tsp", NC_ (SYNAPSE_VOLUME, "US teaspoon"), "1/3", "ustablespoon"}, {SYNAPSE_UNIT_TYPE_TIME, SYNAPSE_UNIT_SYSTEM_SI, "second", "sec|s", NC_ (SYNAPSE_TIME, "second"), "1", ""}, {SYNAPSE_UNIT_TYPE_TIME, SYNAPSE_UNIT_SYSTEM_SI, "minute", "min|m", NC_ (SYNAPSE_TIME, "minute"), "60", "second"}, {SYNAPSE_UNIT_TYPE_TIME, SYNAPSE_UNIT_SYSTEM_SI, "hour", "hr|h", NC_ (SYNAPSE_TIME, "hour"), "60", "minute"}, {SYNAPSE_UNIT_TYPE_TIME, SYNAPSE_UNIT_SYSTEM_SI, "day", "da|d", NC_ (SYNAPSE_TIME, "day"), "24", "hour"}, {SYNAPSE_UNIT_TYPE_TIME, SYNAPSE_UNIT_SYSTEM_SI, "week", "wk", NC_ (SYNAPSE_TIME, "week"), "7", "day"}, {SYNAPSE_UNIT_TYPE_TIME, SYNAPSE_UNIT_SYSTEM_SI, "fortnight", "", NC_ (SYNAPSE_TIME, "fortnight"), "14", "day"}, {SYNAPSE_UNIT_TYPE_TIME, SYNAPSE_UNIT_SYSTEM_SI, "commonyear", "calendaryear|year|yr", NC_ (SYNAPSE_TIME, "Common year"), "365", "day"}, {SYNAPSE_UNIT_TYPE_TIME, SYNAPSE_UNIT_SYSTEM_SI, "leapyear", "yr", NC_ (SYNAPSE_TIME, "leap year"), "366", "day"}, {SYNAPSE_UNIT_TYPE_TIME, SYNAPSE_UNIT_SYSTEM_SI, "julianyear", "yr", NC_ (SYNAPSE_TIME, "Julian year"), "365.25", "day"}, {SYNAPSE_UNIT_TYPE_TIME, SYNAPSE_UNIT_SYSTEM_SI, "gregorianyear", "yr", NC_ (SYNAPSE_TIME, "Gregorian year"), "366.2425", "day"}, {SYNAPSE_UNIT_TYPE_TIME, SYNAPSE_UNIT_SYSTEM_SI, "islamicyear", "yr", NC_ (SYNAPSE_TIME, "Islamic year"), "354", "day"}, {SYNAPSE_UNIT_TYPE_TIME, SYNAPSE_UNIT_SYSTEM_SI, "islamicleapyear", "yr", NC_ (SYNAPSE_TIME, "Islamic leap year"), "354", "day"}, {SYNAPSE_UNIT_TYPE_TIME, SYNAPSE_UNIT_SYSTEM_SI, "decade", "", NC_ (SYNAPSE_TIME, "decade"), "10", "commonyear"}, {SYNAPSE_UNIT_TYPE_TIME, SYNAPSE_UNIT_SYSTEM_SI, "century", "", NC_ (SYNAPSE_TIME, "century"), "100", "commonyear"}, {SYNAPSE_UNIT_TYPE_TIME, SYNAPSE_UNIT_SYSTEM_SI, "millenium", "", NC_ (SYNAPSE_TIME, "millenium"), "1000", "commonyear"}, {SYNAPSE_UNIT_TYPE_VELOCITY, SYNAPSE_UNIT_SYSTEM_SI, "meterpersecond", "m/s", NC_ (SYNAPSE_VELOCITY, "meters per second"), "1", ""}, {SYNAPSE_UNIT_TYPE_VELOCITY, SYNAPSE_UNIT_SYSTEM_SI, "lightspeed", "c", NC_ (SYNAPSE_VELOCITY, "speed of light"), "299792458", "meterpersecond"}, {SYNAPSE_UNIT_TYPE_VELOCITY, SYNAPSE_UNIT_SYSTEM_SI, "kilometersperhour", "km/h|kph", NC_ (SYNAPSE_VELOCITY, "kilometers per hour"), "1000/3600", "meterpersecond"}, {SYNAPSE_UNIT_TYPE_VELOCITY, SYNAPSE_UNIT_SYSTEM_SI, "milesperhour", "m/h|mph", NC_ (SYNAPSE_VELOCITY, "miles per hour"), "1609.34/3600", "meterpersecond"}, {SYNAPSE_UNIT_TYPE_VELOCITY, SYNAPSE_UNIT_SYSTEM_SI, "mach", "", NC_ (SYNAPSE_VELOCITY, "Mach (speed of sound)"), "331.46", "meterpersecond"}};

static GType
synapse_unit_system_get_type_once (void)
{
	static const GEnumValue values[] = {{SYNAPSE_UNIT_SYSTEM_SI, "SYNAPSE_UNIT_SYSTEM_SI", "si"}, {SYNAPSE_UNIT_SYSTEM_IMPERIAL, "SYNAPSE_UNIT_SYSTEM_IMPERIAL", "imperial"}, {SYNAPSE_UNIT_SYSTEM_IMPERIAL_UK, "SYNAPSE_UNIT_SYSTEM_IMPERIAL_UK", "imperial-uk"}, {SYNAPSE_UNIT_SYSTEM_IMPERIAL_US, "SYNAPSE_UNIT_SYSTEM_IMPERIAL_US", "imperial-us"}, {0, NULL, NULL}};
	GType synapse_unit_system_type_id;
	synapse_unit_system_type_id = g_enum_register_static ("SynapseUnitSystem", values);
	return synapse_unit_system_type_id;
}

GType
synapse_unit_system_get_type (void)
{
	static volatile gsize synapse_unit_system_type_id__once = 0;
	if (g_once_init_enter (&synapse_unit_system_type_id__once)) {
		GType synapse_unit_system_type_id;
		synapse_unit_system_type_id = synapse_unit_system_get_type_once ();
		g_once_init_leave (&synapse_unit_system_type_id__once, synapse_unit_system_type_id);
	}
	return synapse_unit_system_type_id__once;
}

static GType
synapse_unit_type_get_type_once (void)
{
	static const GEnumValue values[] = {{SYNAPSE_UNIT_TYPE_MASS, "SYNAPSE_UNIT_TYPE_MASS", "mass"}, {SYNAPSE_UNIT_TYPE_DIMENSION, "SYNAPSE_UNIT_TYPE_DIMENSION", "dimension"}, {SYNAPSE_UNIT_TYPE_TIME, "SYNAPSE_UNIT_TYPE_TIME", "time"}, {SYNAPSE_UNIT_TYPE_VELOCITY, "SYNAPSE_UNIT_TYPE_VELOCITY", "velocity"}, {0, NULL, NULL}};
	GType synapse_unit_type_type_id;
	synapse_unit_type_type_id = g_enum_register_static ("SynapseUnitType", values);
	return synapse_unit_type_type_id;
}

GType
synapse_unit_type_get_type (void)
{
	static volatile gsize synapse_unit_type_type_id__once = 0;
	if (g_once_init_enter (&synapse_unit_type_type_id__once)) {
		GType synapse_unit_type_type_id;
		synapse_unit_type_type_id = synapse_unit_type_get_type_once ();
		g_once_init_leave (&synapse_unit_type_type_id__once, synapse_unit_type_type_id);
	}
	return synapse_unit_type_type_id__once;
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

gdouble
synapse_unit_get_factor (SynapseUnit *self)
{
	gchar** parts = NULL;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint parts_length1;
	gint _parts_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gdouble result;
	_tmp0_ = (*self).size_s;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, "/", 0);
	parts = _tmp2_;
	parts_length1 = _vala_array_length (_tmp1_);
	_parts_size_ = parts_length1;
	_tmp3_ = parts;
	_tmp3__length1 = parts_length1;
	switch (_tmp3__length1) {
		case 1:
		{
			gchar** _tmp4_;
			gint _tmp4__length1;
			const gchar* _tmp5_;
			_tmp4_ = parts;
			_tmp4__length1 = parts_length1;
			_tmp5_ = _tmp4_[0];
			result = double_parse (_tmp5_);
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
		case 2:
		{
			gdouble divisor = 0.0;
			gchar** _tmp6_;
			gint _tmp6__length1;
			const gchar* _tmp7_;
			gdouble _tmp8_ = 0.0;
			_tmp6_ = parts;
			_tmp6__length1 = parts_length1;
			_tmp7_ = _tmp6_[1];
			divisor = double_parse (_tmp7_);
			if (divisor != 0.0) {
				gchar** _tmp9_;
				gint _tmp9__length1;
				const gchar* _tmp10_;
				_tmp9_ = parts;
				_tmp9__length1 = parts_length1;
				_tmp10_ = _tmp9_[0];
				_tmp8_ = double_parse (_tmp10_) / divisor;
			} else {
				_tmp8_ = 0.0;
			}
			result = _tmp8_;
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
		default:
		{
			result = 0.0;
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
	}
}

void
synapse_unit_copy (const SynapseUnit* self,
                   SynapseUnit* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	(*dest).type = (*self).type;
	(*dest).system = (*self).system;
	_tmp0_ = (*self).uid;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).uid);
	(*dest).uid = _tmp1_;
	_tmp2_ = (*self).abbreviations;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).abbreviations);
	(*dest).abbreviations = _tmp3_;
	_tmp4_ = (*self).description;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 ((*dest).description);
	(*dest).description = _tmp5_;
	_tmp6_ = (*self).size_s;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 ((*dest).size_s);
	(*dest).size_s = _tmp7_;
	_tmp8_ = (*self).base_unit;
	_tmp9_ = g_strdup (_tmp8_);
	_g_free0 ((*dest).base_unit);
	(*dest).base_unit = _tmp9_;
}

void
synapse_unit_destroy (SynapseUnit* self)
{
	_g_free0 ((*self).uid);
	_g_free0 ((*self).abbreviations);
	_g_free0 ((*self).description);
	_g_free0 ((*self).size_s);
	_g_free0 ((*self).base_unit);
}

SynapseUnit*
synapse_unit_dup (const SynapseUnit* self)
{
	SynapseUnit* dup;
	dup = g_new0 (SynapseUnit, 1);
	synapse_unit_copy (self, dup);
	return dup;
}

void
synapse_unit_free (SynapseUnit* self)
{
	synapse_unit_destroy (self);
	g_free (self);
}

static GType
synapse_unit_get_type_once (void)
{
	GType synapse_unit_type_id;
	synapse_unit_type_id = g_boxed_type_register_static ("SynapseUnit", (GBoxedCopyFunc) synapse_unit_dup, (GBoxedFreeFunc) synapse_unit_free);
	return synapse_unit_type_id;
}

GType
synapse_unit_get_type (void)
{
	static volatile gsize synapse_unit_type_id__once = 0;
	if (g_once_init_enter (&synapse_unit_type_id__once)) {
		GType synapse_unit_type_id;
		synapse_unit_type_id = synapse_unit_get_type_once ();
		g_once_init_leave (&synapse_unit_type_id__once, synapse_unit_type_id);
	}
	return synapse_unit_type_id__once;
}

void
synapse_si_prefix_get_default (SynapseSIPrefix* result)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	SynapseSIPrefix _tmp2_ = {0};
	_tmp0_ = g_strdup ("");
	_tmp1_ = g_strdup ("");
	_g_free0 (_tmp2_.prefix);
	_tmp2_.prefix = _tmp0_;
	_g_free0 (_tmp2_.abbrev);
	_tmp2_.abbrev = _tmp1_;
	_tmp2_.factor = 1.0;
	*result = _tmp2_;
	return;
}

void
synapse_si_prefix_copy (const SynapseSIPrefix* self,
                        SynapseSIPrefix* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = (*self).prefix;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).prefix);
	(*dest).prefix = _tmp1_;
	_tmp2_ = (*self).abbrev;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).abbrev);
	(*dest).abbrev = _tmp3_;
	(*dest).factor = (*self).factor;
}

void
synapse_si_prefix_destroy (SynapseSIPrefix* self)
{
	_g_free0 ((*self).prefix);
	_g_free0 ((*self).abbrev);
}

SynapseSIPrefix*
synapse_si_prefix_dup (const SynapseSIPrefix* self)
{
	SynapseSIPrefix* dup;
	dup = g_new0 (SynapseSIPrefix, 1);
	synapse_si_prefix_copy (self, dup);
	return dup;
}

void
synapse_si_prefix_free (SynapseSIPrefix* self)
{
	synapse_si_prefix_destroy (self);
	g_free (self);
}

static GType
synapse_si_prefix_get_type_once (void)
{
	GType synapse_si_prefix_type_id;
	synapse_si_prefix_type_id = g_boxed_type_register_static ("SynapseSIPrefix", (GBoxedCopyFunc) synapse_si_prefix_dup, (GBoxedFreeFunc) synapse_si_prefix_free);
	return synapse_si_prefix_type_id;
}

GType
synapse_si_prefix_get_type (void)
{
	static volatile gsize synapse_si_prefix_type_id__once = 0;
	if (g_once_init_enter (&synapse_si_prefix_type_id__once)) {
		GType synapse_si_prefix_type_id;
		synapse_si_prefix_type_id = synapse_si_prefix_get_type_once ();
		g_once_init_leave (&synapse_si_prefix_type_id__once, synapse_si_prefix_type_id);
	}
	return synapse_si_prefix_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

