/* fuzzy-search-popover.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from fuzzy-search-popover.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2023 elementary, Inc. <https://elementary.io>
 *
 * Authored by: Marvin Ahlgrimm
 *              Colin Kiama <colinkiama@gmail.com>
 */

#include "fuzzy-search.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <gio/gio.h>
#include "codecore.h"
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SCRATCH_FUZZY_SEARCH_POPOVER_0_PROPERTY,
	SCRATCH_FUZZY_SEARCH_POPOVER_CURRENT_WINDOW_PROPERTY,
	SCRATCH_FUZZY_SEARCH_POPOVER_SIDEBAR_IS_VISIBLE_PROPERTY,
	SCRATCH_FUZZY_SEARCH_POPOVER_NUM_PROPERTIES
};
static GParamSpec* scratch_fuzzy_search_popover_properties[SCRATCH_FUZZY_SEARCH_POPOVER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _scratch_services_fuzzy_finder_unref0(var) ((var == NULL) ? NULL : (var = (scratch_services_fuzzy_finder_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block10Data Block10Data;
typedef struct _Block11Data Block11Data;
#define _search_result_unref0(var) ((var == NULL) ? NULL : (var = (search_result_unref (var), NULL)))
enum  {
	SCRATCH_FUZZY_SEARCH_POPOVER_OPEN_FILE_SIGNAL,
	SCRATCH_FUZZY_SEARCH_POPOVER_CLOSE_SEARCH_SIGNAL,
	SCRATCH_FUZZY_SEARCH_POPOVER_NUM_SIGNALS
};
static guint scratch_fuzzy_search_popover_signals[SCRATCH_FUZZY_SEARCH_POPOVER_NUM_SIGNALS] = {0};

struct _ScratchFuzzySearchPopoverPrivate {
	GtkSearchEntry* search_term_entry;
	ScratchServicesFuzzyFinder* fuzzy_finder;
	GtkListBox* search_result_container;
	gint preselected_index;
	GtkScrolledWindow* scrolled;
	GeeArrayList* items;
	ScratchServicesFuzzySearchIndexer* indexer;
	gint window_height;
	gint max_items;
	GeeLinkedList* cancellables;
	GtkEventControllerKey* search_term_entry_key_controller;
	GtkLabel* title_label;
	ScratchMainWindow* _current_window;
	gboolean _sidebar_is_visible;
};

struct _Block10Data {
	int _ref_count_;
	ScratchFuzzySearchPopover* self;
	gchar* previous_text;
};

struct _Block11Data {
	int _ref_count_;
	Block10Data * _data10_;
	GCancellable* next_cancellable;
};

static gint ScratchFuzzySearchPopover_private_offset;
static gpointer scratch_fuzzy_search_popover_parent_class = NULL;
static GType scratch_fuzzy_search_popover_type_id = 0;

static void scratch_fuzzy_search_popover_calculate_scroll_offset (ScratchFuzzySearchPopover* self,
                                                           gint old_position,
                                                           gint new_position);
static void scratch_fuzzy_search_popover_handle_item_selection (ScratchFuzzySearchPopover* self,
                                                         gint index);
static void scratch_fuzzy_search_popover_preselect_new_item (ScratchFuzzySearchPopover* self,
                                                      FileItem* old_item,
                                                      FileItem* new_item);
static gchar* scratch_fuzzy_search_popover_get_current_project (ScratchFuzzySearchPopover* self);
static GObject * scratch_fuzzy_search_popover_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties);
static void _scratch_fuzzy_search_popover___lambda19_ (ScratchFuzzySearchPopover* self,
                                                GtkListBoxRow* row);
static void __scratch_fuzzy_search_popover___lambda19__gtk_list_box_row_activated (GtkListBox* _sender,
                                                                            GtkListBoxRow* row,
                                                                            gpointer self);
static gboolean _scratch_fuzzy_search_popover___lambda20_ (ScratchFuzzySearchPopover* self,
                                                    guint keyval,
                                                    guint keycode,
                                                    GdkModifierType state);
static gboolean __scratch_fuzzy_search_popover___lambda20__gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                                          guint keyval,
                                                                                          guint keycode,
                                                                                          GdkModifierType state,
                                                                                          gpointer self);
static void _scratch_fuzzy_search_popover___lambda21_ (ScratchFuzzySearchPopover* self);
static void __scratch_fuzzy_search_popover___lambda21__gtk_entry_activate (GtkEntry* _sender,
                                                                    gpointer self);
static void _scratch_fuzzy_search_popover___lambda22_ (ScratchFuzzySearchPopover* self,
                                                GtkEditable* e);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static gboolean ___lambda23_ (Block10Data* _data10_);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
static void __lambda24_ (Block11Data* _data11_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda24__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static gboolean ____lambda23__gsource_func (gpointer self);
static void __scratch_fuzzy_search_popover___lambda22__gtk_editable_changed (GtkEditable* _sender,
                                                                      gpointer self);
static void scratch_fuzzy_search_popover_finalize (GObject * obj);
static void _vala_scratch_fuzzy_search_popover_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_scratch_fuzzy_search_popover_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
scratch_fuzzy_search_popover_get_instance_private (ScratchFuzzySearchPopover* self)
{
	return G_STRUCT_MEMBER_P (self, ScratchFuzzySearchPopover_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

ScratchFuzzySearchPopover*
scratch_fuzzy_search_popover_construct (GType object_type,
                                        ScratchServicesFuzzySearchIndexer* search_indexer,
                                        ScratchMainWindow* window)
{
	ScratchFuzzySearchPopover * self = NULL;
	ScratchWidgetsDocumentView* _tmp0_;
	gint height = 0;
	ScratchMainWindow* _tmp1_;
	gint _tmp2_ = 0;
	GeeHashMap* _tmp3_;
	GeeHashMap* _tmp4_;
	ScratchServicesFuzzyFinder* _tmp5_;
	ScratchServicesFuzzySearchIndexer* _tmp6_;
	GeeArrayList* _tmp7_;
	GeeLinkedList* _tmp8_;
	GtkScrolledWindow* _tmp9_;
	g_return_val_if_fail (search_indexer != NULL, NULL);
	g_return_val_if_fail (window != NULL, NULL);
	_tmp0_ = window->document_view;
	self = (ScratchFuzzySearchPopover*) g_object_new (object_type, "modal", TRUE, "relative-to", _tmp0_, "width-request", 500, "current-window", window, NULL);
	_tmp1_ = self->priv->_current_window;
	gtk_window_get_size ((GtkWindow*) _tmp1_, NULL, &_tmp2_);
	height = _tmp2_;
	self->priv->window_height = height;
	_tmp3_ = scratch_services_fuzzy_search_indexer_get_project_paths (search_indexer);
	_tmp4_ = _tmp3_;
	_tmp5_ = scratch_services_fuzzy_finder_new (_tmp4_, 10, 256);
	_scratch_services_fuzzy_finder_unref0 (self->priv->fuzzy_finder);
	self->priv->fuzzy_finder = _tmp5_;
	_tmp6_ = _g_object_ref0 (search_indexer);
	_g_object_unref0 (self->priv->indexer);
	self->priv->indexer = _tmp6_;
	_tmp7_ = gee_array_list_new (TYPE_FILE_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->items);
	self->priv->items = _tmp7_;
	_tmp8_ = gee_linked_list_new (g_cancellable_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->cancellables);
	self->priv->cancellables = _tmp8_;
	if (self->priv->window_height > 400) {
		self->priv->max_items = 5;
	} else {
		self->priv->max_items = 3;
	}
	_tmp9_ = self->priv->scrolled;
	gtk_scrolled_window_set_max_content_height (_tmp9_, 45 * self->priv->max_items);
	return self;
}

ScratchFuzzySearchPopover*
scratch_fuzzy_search_popover_new (ScratchServicesFuzzySearchIndexer* search_indexer,
                                  ScratchMainWindow* window)
{
	return scratch_fuzzy_search_popover_construct (SCRATCH_TYPE_FUZZY_SEARCH_POPOVER, search_indexer, window);
}

static void
scratch_fuzzy_search_popover_calculate_scroll_offset (ScratchFuzzySearchPopover* self,
                                                      gint old_position,
                                                      gint new_position)
{
	gboolean _tmp0_ = FALSE;
	gdouble size_box = 0.0;
	GtkScrolledWindow* _tmp14_;
	GtkAdjustment* _tmp15_;
	GtkAdjustment* _tmp16_;
	GeeArrayList* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gdouble current_top = 0.0;
	GtkScrolledWindow* _tmp20_;
	GtkAdjustment* _tmp21_;
	GtkAdjustment* _tmp22_;
	gdouble _tmp23_;
	gdouble _tmp24_;
	gdouble current_bottom = 0.0;
	g_return_if_fail (self != NULL);
	if (new_position == 0) {
		_tmp0_ = old_position > new_position;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkScrolledWindow* _tmp1_;
		GtkAdjustment* _tmp2_;
		GtkAdjustment* _tmp3_;
		_tmp1_ = self->priv->scrolled;
		_tmp2_ = gtk_scrolled_window_get_vadjustment (_tmp1_);
		_tmp3_ = _tmp2_;
		gtk_adjustment_set_value (_tmp3_, (gdouble) 0);
		return;
	} else {
		gboolean _tmp4_ = FALSE;
		if (old_position == 0) {
			GeeArrayList* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			_tmp5_ = self->priv->items;
			_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
			_tmp7_ = _tmp6_;
			_tmp4_ = new_position == (_tmp7_ - 1);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			GtkScrolledWindow* _tmp8_;
			GtkAdjustment* _tmp9_;
			GtkAdjustment* _tmp10_;
			GtkScrolledWindow* _tmp11_;
			GtkAdjustment* _tmp12_;
			GtkAdjustment* _tmp13_;
			_tmp8_ = self->priv->scrolled;
			_tmp9_ = gtk_scrolled_window_get_vadjustment (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = self->priv->scrolled;
			_tmp12_ = gtk_scrolled_window_get_vadjustment (_tmp11_);
			_tmp13_ = _tmp12_;
			gtk_adjustment_set_value (_tmp10_, gtk_adjustment_get_upper (_tmp13_));
			return;
		}
	}
	_tmp14_ = self->priv->scrolled;
	_tmp15_ = gtk_scrolled_window_get_vadjustment (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = self->priv->items;
	_tmp18_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp17_);
	_tmp19_ = _tmp18_;
	size_box = gtk_adjustment_get_upper (_tmp16_) / _tmp19_;
	_tmp20_ = self->priv->scrolled;
	_tmp21_ = gtk_scrolled_window_get_vadjustment (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = gtk_adjustment_get_value (_tmp22_);
	_tmp24_ = _tmp23_;
	current_top = _tmp24_;
	current_bottom = current_top + (size_box * (self->priv->max_items - 2));
	if (old_position < new_position) {
		gdouble new_adjust = 0.0;
		new_adjust = size_box * self->priv->preselected_index;
		if (new_adjust >= current_bottom) {
			GtkScrolledWindow* _tmp25_;
			GtkAdjustment* _tmp26_;
			GtkAdjustment* _tmp27_;
			_tmp25_ = self->priv->scrolled;
			_tmp26_ = gtk_scrolled_window_get_vadjustment (_tmp25_);
			_tmp27_ = _tmp26_;
			gtk_adjustment_set_value (_tmp27_, size_box * (self->priv->preselected_index - (self->priv->max_items - 1)));
		}
	} else {
		if (old_position > new_position) {
			gdouble new_adjust = 0.0;
			new_adjust = size_box * self->priv->preselected_index;
			if (new_adjust < current_top) {
				GtkScrolledWindow* _tmp28_;
				GtkAdjustment* _tmp29_;
				GtkAdjustment* _tmp30_;
				_tmp28_ = self->priv->scrolled;
				_tmp29_ = gtk_scrolled_window_get_vadjustment (_tmp28_);
				_tmp30_ = _tmp29_;
				gtk_adjustment_set_value (_tmp30_, new_adjust);
			}
		}
	}
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
scratch_fuzzy_search_popover_handle_item_selection (ScratchFuzzySearchPopover* self,
                                                    gint index)
{
	FileItem* item = NULL;
	GeeArrayList* _tmp0_;
	gpointer _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->items;
	_tmp1_ = gee_abstract_list_get ((GeeAbstractList*) _tmp0_, index);
	item = (FileItem*) _tmp1_;
	_tmp2_ = file_item_get_filepath (item);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_strip (_tmp3_);
	_tmp5_ = _tmp4_;
	g_signal_emit (self, scratch_fuzzy_search_popover_signals[SCRATCH_FUZZY_SEARCH_POPOVER_OPEN_FILE_SIGNAL], 0, _tmp5_);
	_g_free0 (_tmp5_);
	_g_object_unref0 (item);
}

static void
scratch_fuzzy_search_popover_preselect_new_item (ScratchFuzzySearchPopover* self,
                                                 FileItem* old_item,
                                                 FileItem* new_item)
{
	gchar* class_name = NULL;
	gchar* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkStyleContext* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (old_item != NULL);
	g_return_if_fail (new_item != NULL);
	_tmp0_ = g_strdup ("preselect-fuzzy");
	class_name = _tmp0_;
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) old_item);
	gtk_style_context_remove_class (_tmp1_, class_name);
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) new_item);
	gtk_style_context_add_class (_tmp2_, class_name);
	_g_free0 (class_name);
}

static gchar*
scratch_fuzzy_search_popover_get_current_project (ScratchFuzzySearchPopover* self)
{
	ScratchServicesDocument* current_document = NULL;
	ScratchMainWindow* _tmp0_;
	ScratchWidgetsDocumentView* _tmp1_;
	ScratchServicesDocument* _tmp2_;
	ScratchServicesDocument* _tmp3_;
	ScratchServicesDocument* _tmp4_;
	ScratchServicesDocument* _tmp5_;
	ScratchServicesDocument* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	gchar* file_path = NULL;
	ScratchServicesDocument* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	gchar* _tmp14_;
	GeeIterator* iter = NULL;
	ScratchServicesFuzzySearchIndexer* _tmp15_;
	GeeHashMap* _tmp16_;
	GeeHashMap* _tmp17_;
	GeeSet* _tmp18_;
	GeeSet* _tmp19_;
	GeeSet* _tmp20_;
	GeeIterator* _tmp21_;
	GeeIterator* _tmp22_;
	gchar* _tmp28_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_window;
	_tmp1_ = _tmp0_->document_view;
	_tmp2_ = scratch_widgets_document_view_get_current_document (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	current_document = _tmp4_;
	_tmp5_ = current_document;
	if (_tmp5_ == NULL) {
		gchar* _tmp6_;
		_tmp6_ = g_strdup ("");
		result = _tmp6_;
		_g_object_unref0 (current_document);
		return result;
	}
	_tmp7_ = current_document;
	_tmp8_ = scratch_services_document_get_is_file_temporary (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_) {
		gchar* _tmp10_;
		_tmp10_ = g_strdup ("");
		result = _tmp10_;
		_g_object_unref0 (current_document);
		return result;
	}
	_tmp11_ = current_document;
	_tmp12_ = scratch_services_document_get_file (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_file_get_path (_tmp13_);
	file_path = _tmp14_;
	_tmp15_ = self->priv->indexer;
	_tmp16_ = scratch_services_fuzzy_search_indexer_get_project_paths (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = gee_abstract_map_get_keys ((GeeAbstractMap*) _tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = _tmp19_;
	_tmp21_ = gee_iterable_iterator ((GeeIterable*) _tmp20_);
	_tmp22_ = _tmp21_;
	_g_object_unref0 (_tmp20_);
	iter = _tmp22_;
	while (TRUE) {
		GeeIterator* _tmp23_;
		gchar* project_path = NULL;
		GeeIterator* _tmp24_;
		gpointer _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		_tmp23_ = iter;
		if (!gee_iterator_next (_tmp23_)) {
			break;
		}
		_tmp24_ = iter;
		_tmp25_ = gee_iterator_get (_tmp24_);
		project_path = (gchar*) _tmp25_;
		_tmp26_ = file_path;
		_tmp27_ = project_path;
		if (g_str_has_prefix (_tmp26_, _tmp27_)) {
			result = project_path;
			_g_object_unref0 (iter);
			_g_free0 (file_path);
			_g_object_unref0 (current_document);
			return result;
		}
		_g_free0 (project_path);
	}
	_tmp28_ = g_strdup ("");
	result = _tmp28_;
	_g_object_unref0 (iter);
	_g_free0 (file_path);
	_g_object_unref0 (current_document);
	return result;
}

ScratchMainWindow*
scratch_fuzzy_search_popover_get_current_window (ScratchFuzzySearchPopover* self)
{
	ScratchMainWindow* result;
	ScratchMainWindow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_window;
	result = _tmp0_;
	return result;
}

static void
scratch_fuzzy_search_popover_set_current_window (ScratchFuzzySearchPopover* self,
                                                 ScratchMainWindow* value)
{
	ScratchMainWindow* old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_fuzzy_search_popover_get_current_window (self);
	if (old_value != value) {
		ScratchMainWindow* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_current_window);
		self->priv->_current_window = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_fuzzy_search_popover_properties[SCRATCH_FUZZY_SEARCH_POPOVER_CURRENT_WINDOW_PROPERTY]);
	}
}

gboolean
scratch_fuzzy_search_popover_get_sidebar_is_visible (ScratchFuzzySearchPopover* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_sidebar_is_visible;
	return result;
}

void
scratch_fuzzy_search_popover_set_sidebar_is_visible (ScratchFuzzySearchPopover* self,
                                                     gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_fuzzy_search_popover_get_sidebar_is_visible (self);
	if (old_value != value) {
		self->priv->_sidebar_is_visible = value;
		g_object_notify_by_pspec ((GObject *) self, scratch_fuzzy_search_popover_properties[SCRATCH_FUZZY_SEARCH_POPOVER_SIDEBAR_IS_VISIBLE_PROPERTY]);
	}
}

static void
_scratch_fuzzy_search_popover___lambda19_ (ScratchFuzzySearchPopover* self,
                                           GtkListBoxRow* row)
{
	FileItem* file_item = NULL;
	FileItem* _tmp0_;
	FileItem* _tmp1_;
	GeeArrayList* _tmp2_;
	FileItem* _tmp3_;
	g_return_if_fail (row != NULL);
	_tmp0_ = _g_object_ref0 (IS_FILE_ITEM (row) ? ((FileItem*) row) : NULL);
	file_item = _tmp0_;
	_tmp1_ = file_item;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (file_item);
		return;
	}
	_tmp2_ = self->priv->items;
	_tmp3_ = file_item;
	scratch_fuzzy_search_popover_handle_item_selection (self, gee_abstract_list_index_of ((GeeAbstractList*) _tmp2_, _tmp3_));
	_g_object_unref0 (file_item);
}

static void
__scratch_fuzzy_search_popover___lambda19__gtk_list_box_row_activated (GtkListBox* _sender,
                                                                       GtkListBoxRow* row,
                                                                       gpointer self)
{
	_scratch_fuzzy_search_popover___lambda19_ ((ScratchFuzzySearchPopover*) self, row);
}

static gboolean
_scratch_fuzzy_search_popover___lambda20_ (ScratchFuzzySearchPopover* self,
                                           guint keyval,
                                           guint keycode,
                                           GdkModifierType state)
{
	gboolean result;
	switch (keyval) {
		case GDK_KEY_Down:
		{
			GeeArrayList* _tmp0_;
			gint _tmp1_;
			gint _tmp2_;
			_tmp0_ = self->priv->items;
			_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
			_tmp2_ = _tmp1_;
			if (_tmp2_ > 0) {
				gint old_index = 0;
				FileItem* item = NULL;
				GeeArrayList* _tmp3_;
				gint _tmp4_;
				gpointer _tmp5_;
				GeeArrayList* _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				FileItem* next_item = NULL;
				GeeArrayList* _tmp9_;
				gpointer _tmp10_;
				FileItem* _tmp11_;
				FileItem* _tmp12_;
				old_index = self->priv->preselected_index;
				_tmp3_ = self->priv->items;
				_tmp4_ = self->priv->preselected_index;
				self->priv->preselected_index = _tmp4_ + 1;
				_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _tmp3_, _tmp4_);
				item = (FileItem*) _tmp5_;
				_tmp6_ = self->priv->items;
				_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
				_tmp8_ = _tmp7_;
				if (self->priv->preselected_index >= _tmp8_) {
					self->priv->preselected_index = 0;
				}
				_tmp9_ = self->priv->items;
				_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, self->priv->preselected_index);
				next_item = (FileItem*) _tmp10_;
				_tmp11_ = item;
				_tmp12_ = next_item;
				scratch_fuzzy_search_popover_preselect_new_item (self, _tmp11_, _tmp12_);
				scratch_fuzzy_search_popover_calculate_scroll_offset (self, old_index, self->priv->preselected_index);
				_g_object_unref0 (next_item);
				_g_object_unref0 (item);
			}
			result = TRUE;
			return result;
		}
		case GDK_KEY_Up:
		{
			GeeArrayList* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			_tmp13_ = self->priv->items;
			_tmp14_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp13_);
			_tmp15_ = _tmp14_;
			if (_tmp15_ > 0) {
				gint old_index = 0;
				FileItem* item = NULL;
				GeeArrayList* _tmp16_;
				gint _tmp17_;
				gpointer _tmp18_;
				FileItem* next_item = NULL;
				GeeArrayList* _tmp22_;
				gpointer _tmp23_;
				FileItem* _tmp24_;
				FileItem* _tmp25_;
				old_index = self->priv->preselected_index;
				_tmp16_ = self->priv->items;
				_tmp17_ = self->priv->preselected_index;
				self->priv->preselected_index = _tmp17_ - 1;
				_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _tmp17_);
				item = (FileItem*) _tmp18_;
				if (self->priv->preselected_index < 0) {
					GeeArrayList* _tmp19_;
					gint _tmp20_;
					gint _tmp21_;
					_tmp19_ = self->priv->items;
					_tmp20_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp19_);
					_tmp21_ = _tmp20_;
					self->priv->preselected_index = _tmp21_ - 1;
				}
				_tmp22_ = self->priv->items;
				_tmp23_ = gee_abstract_list_get ((GeeAbstractList*) _tmp22_, self->priv->preselected_index);
				next_item = (FileItem*) _tmp23_;
				_tmp24_ = item;
				_tmp25_ = next_item;
				scratch_fuzzy_search_popover_preselect_new_item (self, _tmp24_, _tmp25_);
				scratch_fuzzy_search_popover_calculate_scroll_offset (self, old_index, self->priv->preselected_index);
				_g_object_unref0 (next_item);
				_g_object_unref0 (item);
			}
			result = TRUE;
			return result;
		}
		case GDK_KEY_Escape:
		{
			g_signal_emit (self, scratch_fuzzy_search_popover_signals[SCRATCH_FUZZY_SEARCH_POPOVER_CLOSE_SEARCH_SIGNAL], 0);
			result = TRUE;
			return result;
		}
		default:
		{
			break;
		}
	}
	result = FALSE;
	return result;
}

static gboolean
__scratch_fuzzy_search_popover___lambda20__gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                                 guint keyval,
                                                                                 guint keycode,
                                                                                 GdkModifierType state,
                                                                                 gpointer self)
{
	gboolean result;
	result = _scratch_fuzzy_search_popover___lambda20_ ((ScratchFuzzySearchPopover*) self, keyval, keycode, state);
	return result;
}

static void
_scratch_fuzzy_search_popover___lambda21_ (ScratchFuzzySearchPopover* self)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	_tmp0_ = self->priv->items;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ > 0) {
		scratch_fuzzy_search_popover_handle_item_selection (self, self->priv->preselected_index);
	}
}

static void
__scratch_fuzzy_search_popover___lambda21__gtk_entry_activate (GtkEntry* _sender,
                                                               gpointer self)
{
	_scratch_fuzzy_search_popover___lambda21_ ((ScratchFuzzySearchPopover*) self);
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		ScratchFuzzySearchPopover* self;
		self = _data10_->self;
		_g_free0 (_data10_->previous_text);
		_g_object_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}

static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}

static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		ScratchFuzzySearchPopover* self;
		self = _data11_->_data10_->self;
		_g_object_unref0 (_data11_->next_cancellable);
		block10_data_unref (_data11_->_data10_);
		_data11_->_data10_ = NULL;
		g_slice_free (Block11Data, _data11_);
	}
}

static void
__lambda24_ (Block11Data* _data11_,
             GObject* obj,
             GAsyncResult* res)
{
	Block10Data* _data10_;
	ScratchFuzzySearchPopover* self;
	GCancellable* _tmp0_;
	GeeArrayList* results = NULL;
	ScratchServicesFuzzyFinder* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	gboolean first = FALSE;
	GtkListBox* _tmp6_;
	GList* _tmp7_;
	GeeArrayList* _tmp10_;
	GtkScrolledWindow* _tmp33_;
	GtkScrolledWindow* _tmp34_;
	GtkScrolledWindow* _tmp35_;
	GtkAdjustment* _tmp36_;
	GtkAdjustment* _tmp37_;
	_data10_ = _data11_->_data10_;
	self = _data10_->self;
	g_return_if_fail (res != NULL);
	_tmp0_ = _data11_->next_cancellable;
	if (g_cancellable_is_cancelled (_tmp0_)) {
		GeeLinkedList* _tmp1_;
		GCancellable* _tmp2_;
		_tmp1_ = self->priv->cancellables;
		_tmp2_ = _data11_->next_cancellable;
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp1_, _tmp2_);
		return;
	}
	_tmp3_ = self->priv->fuzzy_finder;
	_tmp4_ = scratch_services_fuzzy_finder_fuzzy_find_finish (_tmp3_, res);
	results = _tmp4_;
	_tmp5_ = results;
	if (_tmp5_ == NULL) {
		_g_object_unref0 (results);
		return;
	}
	first = TRUE;
	_tmp6_ = self->priv->search_result_container;
	_tmp7_ = gtk_container_get_children ((GtkContainer*) _tmp6_);
	{
		GList* c_collection = NULL;
		GList* c_it = NULL;
		c_collection = _tmp7_;
		for (c_it = c_collection; c_it != NULL; c_it = c_it->next) {
			GtkWidget* c = NULL;
			c = (GtkWidget*) c_it->data;
			{
				GtkListBox* _tmp8_;
				GtkWidget* _tmp9_;
				_tmp8_ = self->priv->search_result_container;
				_tmp9_ = c;
				gtk_container_remove ((GtkContainer*) _tmp8_, _tmp9_);
			}
		}
		(c_collection == NULL) ? NULL : (c_collection = (g_list_free (c_collection), NULL));
	}
	_tmp10_ = self->priv->items;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp10_);
	{
		GeeArrayList* _result_list = NULL;
		GeeArrayList* _tmp11_;
		gint _result_size = 0;
		GeeArrayList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _result_index = 0;
		_tmp11_ = results;
		_result_list = _tmp11_;
		_tmp12_ = _result_list;
		_tmp13_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_result_size = _tmp14_;
		_result_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			SearchResult* _result_ = NULL;
			GeeArrayList* _tmp17_;
			gpointer _tmp18_;
			FileItem* file_item = NULL;
			SearchResult* _tmp19_;
			ScratchServicesFuzzySearchIndexer* _tmp20_;
			GeeHashMap* _tmp21_;
			GeeHashMap* _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			FileItem* _tmp25_;
			FileItem* _tmp26_;
			GtkListBox* _tmp29_;
			FileItem* _tmp30_;
			GeeArrayList* _tmp31_;
			FileItem* _tmp32_;
			_result_index = _result_index + 1;
			_tmp15_ = _result_index;
			_tmp16_ = _result_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _result_list;
			_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp17_, _result_index);
			_result_ = (SearchResult*) _tmp18_;
			_tmp19_ = _result_;
			_tmp20_ = self->priv->indexer;
			_tmp21_ = scratch_services_fuzzy_search_indexer_get_project_paths (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = file_item_new (_tmp19_, _tmp24_ > 1);
			g_object_ref_sink (_tmp25_);
			file_item = _tmp25_;
			_tmp26_ = file_item;
			gtk_widget_set_can_focus ((GtkWidget*) _tmp26_, FALSE);
			if (first) {
				FileItem* _tmp27_;
				GtkStyleContext* _tmp28_;
				first = FALSE;
				_tmp27_ = file_item;
				_tmp28_ = gtk_widget_get_style_context ((GtkWidget*) _tmp27_);
				gtk_style_context_add_class (_tmp28_, "preselect-fuzzy");
				self->priv->preselected_index = 0;
			}
			_tmp29_ = self->priv->search_result_container;
			_tmp30_ = file_item;
			gtk_container_add ((GtkContainer*) _tmp29_, (GtkWidget*) _tmp30_);
			_tmp31_ = self->priv->items;
			_tmp32_ = file_item;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp31_, _tmp32_);
			_g_object_unref0 (file_item);
			_search_result_unref0 (_result_);
		}
	}
	_tmp33_ = self->priv->scrolled;
	gtk_widget_hide ((GtkWidget*) _tmp33_);
	_tmp34_ = self->priv->scrolled;
	gtk_widget_show_all ((GtkWidget*) _tmp34_);
	_tmp35_ = self->priv->scrolled;
	_tmp36_ = gtk_scrolled_window_get_vadjustment (_tmp35_);
	_tmp37_ = _tmp36_;
	gtk_adjustment_set_value (_tmp37_, (gdouble) 0);
	_g_object_unref0 (results);
}

static void
___lambda24__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda24_ (self, source_object, res);
	block11_data_unref (self);
}

static gboolean
___lambda23_ (Block10Data* _data10_)
{
	ScratchFuzzySearchPopover* self;
	Block11Data* _data11_;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GCancellable* _tmp8_;
	GeeLinkedList* _tmp9_;
	GCancellable* _tmp10_;
	gint dir_length = 0;
	gchar* term = NULL;
	GtkSearchEntry* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar** parts = NULL;
	const gchar* _tmp15_;
	gchar** _tmp16_;
	gchar** _tmp17_;
	gint parts_length1;
	gint _parts_size_;
	gchar** rev_parts = NULL;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar** _tmp21_;
	gchar** _tmp22_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	gint rev_parts_length1;
	gint _rev_parts_size_;
	gchar** _tmp24_;
	gint _tmp24__length1;
	ScratchServicesFuzzyFinder* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	GCancellable* _tmp33_;
	gboolean result;
	self = _data10_->self;
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->_data10_ = block10_data_ref (_data10_);
	_tmp1_ = _data10_->previous_text;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp4_;
		GtkSearchEntry* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp4_ = _data10_->previous_text;
		_tmp5_ = self->priv->search_term_entry;
		_tmp6_ = gtk_entry_get_text ((GtkEntry*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp0_ = g_strcmp0 (_tmp4_, _tmp7_) != 0;
	}
	if (_tmp0_) {
		result = G_SOURCE_REMOVE;
		block11_data_unref (_data11_);
		_data11_ = NULL;
		return result;
	}
	_tmp8_ = g_cancellable_new ();
	_data11_->next_cancellable = _tmp8_;
	_tmp9_ = self->priv->cancellables;
	_tmp10_ = _data11_->next_cancellable;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, _tmp10_);
	dir_length = 0;
	_tmp11_ = self->priv->search_term_entry;
	_tmp12_ = gtk_entry_get_text ((GtkEntry*) _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strdup (_tmp13_);
	term = _tmp14_;
	_tmp15_ = term;
	_tmp17_ = _tmp16_ = g_strsplit (_tmp15_, G_DIR_SEPARATOR_S, 0);
	parts = _tmp17_;
	parts_length1 = _vala_array_length (_tmp16_);
	_parts_size_ = parts_length1;
	_tmp18_ = term;
	_tmp19_ = g_utf8_strreverse (_tmp18_, (gssize) -1);
	_tmp20_ = _tmp19_;
	_tmp22_ = _tmp21_ = g_strsplit (_tmp20_, G_DIR_SEPARATOR_S, 2);
	_tmp23_ = _tmp22_;
	_tmp23__length1 = _vala_array_length (_tmp21_);
	_g_free0 (_tmp20_);
	rev_parts = _tmp23_;
	rev_parts_length1 = _tmp23__length1;
	_rev_parts_size_ = rev_parts_length1;
	_tmp24_ = rev_parts;
	_tmp24__length1 = rev_parts_length1;
	if (_tmp24__length1 == 2) {
		gchar** _tmp25_;
		gint _tmp25__length1;
		const gchar* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		_tmp25_ = rev_parts;
		_tmp25__length1 = rev_parts_length1;
		_tmp26_ = _tmp25_[0];
		_tmp27_ = strlen (_tmp26_);
		_tmp28_ = _tmp27_;
		dir_length = _tmp28_ + 1;
	}
	_tmp29_ = self->priv->fuzzy_finder;
	_tmp30_ = term;
	_tmp31_ = scratch_fuzzy_search_popover_get_current_project (self);
	_tmp32_ = _tmp31_;
	_tmp33_ = _data11_->next_cancellable;
	scratch_services_fuzzy_finder_fuzzy_find_async (_tmp29_, _tmp30_, (guint) dir_length, _tmp32_, _tmp33_, ___lambda24__gasync_ready_callback, block11_data_ref (_data11_));
	_g_free0 (_tmp32_);
	result = G_SOURCE_REMOVE;
	rev_parts = (_vala_array_free (rev_parts, rev_parts_length1, (GDestroyNotify) g_free), NULL);
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (term);
	block11_data_unref (_data11_);
	_data11_ = NULL;
	return result;
}

static gboolean
____lambda23__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda23_ (self);
	return result;
}

static void
_scratch_fuzzy_search_popover___lambda22_ (ScratchFuzzySearchPopover* self,
                                           GtkEditable* e)
{
	GtkSearchEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_if_fail (e != NULL);
	_tmp0_ = self->priv->search_term_entry;
	_tmp1_ = gtk_entry_get_text ((GtkEntry*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ >= 1) {
		Block10Data* _data10_;
		GtkSearchEntry* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		GeeLinkedList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		_data10_ = g_slice_new0 (Block10Data);
		_data10_->_ref_count_ = 1;
		_data10_->self = g_object_ref (self);
		_tmp5_ = self->priv->search_term_entry;
		_tmp6_ = gtk_entry_get_text ((GtkEntry*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup (_tmp7_);
		_data10_->previous_text = _tmp8_;
		_tmp9_ = self->priv->cancellables;
		_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		if (_tmp11_ > 0) {
			GCancellable* last_cancellable = NULL;
			GeeLinkedList* _tmp12_;
			gpointer _tmp13_;
			GCancellable* _tmp14_;
			_tmp12_ = self->priv->cancellables;
			_tmp13_ = gee_linked_list_last (_tmp12_);
			last_cancellable = (GCancellable*) _tmp13_;
			_tmp14_ = last_cancellable;
			g_cancellable_cancel (_tmp14_);
			_g_object_unref0 (last_cancellable);
		}
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 1, ____lambda23__gsource_func, block10_data_ref (_data10_), block10_data_unref);
		block10_data_unref (_data10_);
		_data10_ = NULL;
	} else {
		GtkListBox* _tmp15_;
		GList* _tmp16_;
		GeeArrayList* _tmp19_;
		GtkScrolledWindow* _tmp20_;
		_tmp15_ = self->priv->search_result_container;
		_tmp16_ = gtk_container_get_children ((GtkContainer*) _tmp15_);
		{
			GList* c_collection = NULL;
			GList* c_it = NULL;
			c_collection = _tmp16_;
			for (c_it = c_collection; c_it != NULL; c_it = c_it->next) {
				GtkWidget* c = NULL;
				c = (GtkWidget*) c_it->data;
				{
					GtkListBox* _tmp17_;
					GtkWidget* _tmp18_;
					_tmp17_ = self->priv->search_result_container;
					_tmp18_ = c;
					gtk_container_remove ((GtkContainer*) _tmp17_, _tmp18_);
				}
			}
			(c_collection == NULL) ? NULL : (c_collection = (g_list_free (c_collection), NULL));
		}
		_tmp19_ = self->priv->items;
		gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp19_);
		_tmp20_ = self->priv->scrolled;
		gtk_widget_hide ((GtkWidget*) _tmp20_);
	}
}

static void
__scratch_fuzzy_search_popover___lambda22__gtk_editable_changed (GtkEditable* _sender,
                                                                 gpointer self)
{
	_scratch_fuzzy_search_popover___lambda22_ ((ScratchFuzzySearchPopover*) self, _sender);
}

static GObject *
scratch_fuzzy_search_popover_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ScratchFuzzySearchPopover * self;
	GdkRectangle _tmp0_ = {0};
	GtkStyleContext* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	GtkStyleContext* _tmp5_;
	GtkSearchEntry* _tmp6_;
	GtkSearchEntry* _tmp7_;
	GtkSearchEntry* _tmp8_;
	GtkListBox* _tmp9_ = NULL;
	GtkListBox* _tmp10_;
	GtkStyleContext* _tmp11_;
	GtkListBox* _tmp12_;
	GtkSearchEntry* _tmp13_;
	GtkEventControllerKey* _tmp14_;
	GtkEventControllerKey* _tmp15_;
	GtkSearchEntry* _tmp16_;
	GtkSearchEntry* _tmp17_;
	GtkBox* entry_layout = NULL;
	GtkBox* _tmp18_;
	GtkBox* _tmp19_;
	GtkBox* _tmp20_;
	GtkLabel* _tmp21_;
	GtkBox* _tmp22_;
	GtkSearchEntry* _tmp23_;
	GtkSearchEntry* _tmp24_;
	GtkScrolledWindow* _tmp25_ = NULL;
	GtkScrolledWindow* _tmp26_;
	GtkListBox* _tmp27_;
	GtkBox* box = NULL;
	GtkBox* _tmp28_;
	GtkBox* _tmp29_;
	GtkBox* _tmp30_;
	GtkBox* _tmp31_;
	GtkScrolledWindow* _tmp32_;
	GtkBox* _tmp33_;
	GtkScrolledWindow* _tmp34_;
	GtkBox* _tmp35_;
	parent_class = G_OBJECT_CLASS (scratch_fuzzy_search_popover_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_TYPE_FUZZY_SEARCH_POPOVER, ScratchFuzzySearchPopover);
	_tmp0_.x = 0;
	_tmp0_.y = 32;
	_tmp0_.width = 1;
	_tmp0_.height = 1;
	g_object_set ((GtkPopover*) self, "pointing-to", &_tmp0_, NULL);
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp1_, "fuzzy-popover");
	_tmp2_ = (GtkLabel*) gtk_label_new (_ ("Find project files"));
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->title_label);
	self->priv->title_label = _tmp2_;
	_tmp3_ = self->priv->title_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp3_, GTK_ALIGN_START);
	_tmp4_ = self->priv->title_label;
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) _tmp4_);
	gtk_style_context_add_class (_tmp5_, "h4");
	_tmp6_ = (GtkSearchEntry*) gtk_search_entry_new ();
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->search_term_entry);
	self->priv->search_term_entry = _tmp6_;
	_tmp7_ = self->priv->search_term_entry;
	gtk_widget_set_halign ((GtkWidget*) _tmp7_, GTK_ALIGN_FILL);
	_tmp8_ = self->priv->search_term_entry;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp8_, TRUE);
	_tmp9_ = (GtkListBox*) gtk_list_box_new ();
	gtk_list_box_set_selection_mode (_tmp9_, GTK_SELECTION_NONE);
	gtk_list_box_set_activate_on_single_click (_tmp9_, TRUE);
	gtk_widget_set_can_focus ((GtkWidget*) _tmp9_, FALSE);
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->search_result_container);
	self->priv->search_result_container = _tmp9_;
	_tmp10_ = self->priv->search_result_container;
	_tmp11_ = gtk_widget_get_style_context ((GtkWidget*) _tmp10_);
	gtk_style_context_add_class (_tmp11_, "fuzzy-list");
	_tmp12_ = self->priv->search_result_container;
	g_signal_connect_object (_tmp12_, "row-activated", (GCallback) __scratch_fuzzy_search_popover___lambda19__gtk_list_box_row_activated, self, 0);
	_tmp13_ = self->priv->search_term_entry;
	_tmp14_ = (GtkEventControllerKey*) gtk_event_controller_key_new ((GtkWidget*) _tmp13_);
	_g_object_unref0 (self->priv->search_term_entry_key_controller);
	self->priv->search_term_entry_key_controller = _tmp14_;
	_tmp15_ = self->priv->search_term_entry_key_controller;
	g_signal_connect_object (_tmp15_, "key-pressed", (GCallback) __scratch_fuzzy_search_popover___lambda20__gtk_event_controller_key_key_pressed, self, 0);
	_tmp16_ = self->priv->search_term_entry;
	g_signal_connect_object ((GtkEntry*) _tmp16_, "activate", (GCallback) __scratch_fuzzy_search_popover___lambda21__gtk_entry_activate, self, 0);
	_tmp17_ = self->priv->search_term_entry;
	g_signal_connect_object ((GtkEditable*) _tmp17_, "changed", (GCallback) __scratch_fuzzy_search_popover___lambda22__gtk_editable_changed, self, 0);
	_tmp18_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp18_);
	entry_layout = _tmp18_;
	_tmp19_ = entry_layout;
	gtk_widget_set_valign ((GtkWidget*) _tmp19_, GTK_ALIGN_START);
	_tmp20_ = entry_layout;
	_tmp21_ = self->priv->title_label;
	gtk_container_add ((GtkContainer*) _tmp20_, (GtkWidget*) _tmp21_);
	_tmp22_ = entry_layout;
	_tmp23_ = self->priv->search_term_entry;
	gtk_container_add ((GtkContainer*) _tmp22_, (GtkWidget*) _tmp23_);
	_tmp24_ = self->priv->search_term_entry;
	gtk_widget_set_valign ((GtkWidget*) _tmp24_, GTK_ALIGN_START);
	_tmp25_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_propagate_natural_height (_tmp25_, TRUE);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp25_, TRUE);
	g_object_ref_sink (_tmp25_);
	_g_object_unref0 (self->priv->scrolled);
	self->priv->scrolled = _tmp25_;
	_tmp26_ = self->priv->scrolled;
	_tmp27_ = self->priv->search_result_container;
	gtk_container_add ((GtkContainer*) _tmp26_, (GtkWidget*) _tmp27_);
	_tmp28_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp28_);
	box = _tmp28_;
	_tmp29_ = box;
	_tmp30_ = entry_layout;
	gtk_box_pack_start (_tmp29_, (GtkWidget*) _tmp30_, FALSE, FALSE, (guint) 0);
	_tmp31_ = box;
	_tmp32_ = self->priv->scrolled;
	gtk_box_pack_end (_tmp31_, (GtkWidget*) _tmp32_, TRUE, TRUE, (guint) 0);
	_tmp33_ = box;
	gtk_widget_show_all ((GtkWidget*) _tmp33_);
	_tmp34_ = self->priv->scrolled;
	gtk_widget_hide ((GtkWidget*) _tmp34_);
	_tmp35_ = box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp35_);
	_g_object_unref0 (box);
	_g_object_unref0 (entry_layout);
	return obj;
}

static void
scratch_fuzzy_search_popover_class_init (ScratchFuzzySearchPopoverClass * klass,
                                         gpointer klass_data)
{
	scratch_fuzzy_search_popover_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ScratchFuzzySearchPopover_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_scratch_fuzzy_search_popover_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_scratch_fuzzy_search_popover_set_property;
	G_OBJECT_CLASS (klass)->constructor = scratch_fuzzy_search_popover_constructor;
	G_OBJECT_CLASS (klass)->finalize = scratch_fuzzy_search_popover_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_FUZZY_SEARCH_POPOVER_CURRENT_WINDOW_PROPERTY, scratch_fuzzy_search_popover_properties[SCRATCH_FUZZY_SEARCH_POPOVER_CURRENT_WINDOW_PROPERTY] = g_param_spec_object ("current-window", "current-window", "current-window", SCRATCH_TYPE_MAIN_WINDOW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_FUZZY_SEARCH_POPOVER_SIDEBAR_IS_VISIBLE_PROPERTY, scratch_fuzzy_search_popover_properties[SCRATCH_FUZZY_SEARCH_POPOVER_SIDEBAR_IS_VISIBLE_PROPERTY] = g_param_spec_boolean ("sidebar-is-visible", "sidebar-is-visible", "sidebar-is-visible", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	scratch_fuzzy_search_popover_signals[SCRATCH_FUZZY_SEARCH_POPOVER_OPEN_FILE_SIGNAL] = g_signal_new ("open-file", SCRATCH_TYPE_FUZZY_SEARCH_POPOVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	scratch_fuzzy_search_popover_signals[SCRATCH_FUZZY_SEARCH_POPOVER_CLOSE_SEARCH_SIGNAL] = g_signal_new ("close-search", SCRATCH_TYPE_FUZZY_SEARCH_POPOVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
scratch_fuzzy_search_popover_instance_init (ScratchFuzzySearchPopover * self,
                                            gpointer klass)
{
	self->priv = scratch_fuzzy_search_popover_get_instance_private (self);
}

static void
scratch_fuzzy_search_popover_finalize (GObject * obj)
{
	ScratchFuzzySearchPopover * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_TYPE_FUZZY_SEARCH_POPOVER, ScratchFuzzySearchPopover);
	_g_object_unref0 (self->priv->search_term_entry);
	_scratch_services_fuzzy_finder_unref0 (self->priv->fuzzy_finder);
	_g_object_unref0 (self->priv->search_result_container);
	_g_object_unref0 (self->priv->scrolled);
	_g_object_unref0 (self->priv->items);
	_g_object_unref0 (self->priv->indexer);
	_g_object_unref0 (self->priv->cancellables);
	_g_object_unref0 (self->priv->search_term_entry_key_controller);
	_g_object_unref0 (self->priv->title_label);
	_g_object_unref0 (self->priv->_current_window);
	G_OBJECT_CLASS (scratch_fuzzy_search_popover_parent_class)->finalize (obj);
}

GType
scratch_fuzzy_search_popover_get_type (void)
{
	return scratch_fuzzy_search_popover_type_id;
}

GType
scratch_fuzzy_search_popover_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScratchFuzzySearchPopoverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scratch_fuzzy_search_popover_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScratchFuzzySearchPopover), 0, (GInstanceInitFunc) scratch_fuzzy_search_popover_instance_init, NULL };
	scratch_fuzzy_search_popover_type_id = g_type_module_register_type (module, gtk_popover_get_type (), "ScratchFuzzySearchPopover", &g_define_type_info, 0);
	ScratchFuzzySearchPopover_private_offset = sizeof (ScratchFuzzySearchPopoverPrivate);
	return scratch_fuzzy_search_popover_type_id;
}

static void
_vala_scratch_fuzzy_search_popover_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	ScratchFuzzySearchPopover * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_TYPE_FUZZY_SEARCH_POPOVER, ScratchFuzzySearchPopover);
	switch (property_id) {
		case SCRATCH_FUZZY_SEARCH_POPOVER_CURRENT_WINDOW_PROPERTY:
		g_value_set_object (value, scratch_fuzzy_search_popover_get_current_window (self));
		break;
		case SCRATCH_FUZZY_SEARCH_POPOVER_SIDEBAR_IS_VISIBLE_PROPERTY:
		g_value_set_boolean (value, scratch_fuzzy_search_popover_get_sidebar_is_visible (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_scratch_fuzzy_search_popover_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	ScratchFuzzySearchPopover * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_TYPE_FUZZY_SEARCH_POPOVER, ScratchFuzzySearchPopover);
	switch (property_id) {
		case SCRATCH_FUZZY_SEARCH_POPOVER_CURRENT_WINDOW_PROPERTY:
		scratch_fuzzy_search_popover_set_current_window (self, g_value_get_object (value));
		break;
		case SCRATCH_FUZZY_SEARCH_POPOVER_SIDEBAR_IS_VISIBLE_PROPERTY:
		scratch_fuzzy_search_popover_set_sidebar_is_visible (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

