/* plugin.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from plugin.vala, do not modify */

/*
 * Copyright (c) 2011 Lucas Baudin <xapantu@gmail.com>
 *
 * This is a free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; see the file COPYING.  If not,
 * write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 *
 */

#include "word-completion.h"
#include <glib-object.h>
#include <glib.h>
#include <gtksourceview/gtksource.h>
#include "codecore.h"
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <libpeas.h>

#define SCRATCH_PLUGINS_COMPLETION_REFRESH_SHORTCUT GDK_KEY_bar
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SCRATCH_PLUGINS_COMPLETION_0_PROPERTY,
	SCRATCH_PLUGINS_COMPLETION_OBJECT_PROPERTY,
	SCRATCH_PLUGINS_COMPLETION_PARSER_PROPERTY,
	SCRATCH_PLUGINS_COMPLETION_CURRENT_VIEW_PROPERTY,
	SCRATCH_PLUGINS_COMPLETION_CURRENT_DOCUMENT_PROPERTY,
	SCRATCH_PLUGINS_COMPLETION_NUM_PROPERTIES
};
static GParamSpec* scratch_plugins_completion_properties[SCRATCH_PLUGINS_COMPLETION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ScratchPluginsCompletionPrivate {
	GObject* _object;
	GList* text_view_list;
	EuclideCompletionParser* _parser;
	GtkSourceView* _current_view;
	ScratchServicesDocument* _current_document;
	ScratchMainWindow* main_window;
	ScratchServicesInterface* plugins;
	gboolean completion_in_progress;
	guint timeout_id;
};

static gint ScratchPluginsCompletion_private_offset;
static gpointer scratch_plugins_completion_parent_class = NULL;
static ScratchServicesActivatablePluginIface * scratch_plugins_completion_scratch_services_activatable_plugin_parent_iface = NULL;
static GType scratch_plugins_completion_type_id = 0;

static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void scratch_plugins_completion_real_activate (ScratchServicesActivatablePlugin* base);
static void scratch_plugins_completion_set_parser (ScratchPluginsCompletion* self,
                                            EuclideCompletionParser* value);
static void __lambda5_ (ScratchPluginsCompletion* self,
                 ScratchMainWindow* w);
static void ___lambda5__scratch_services_interface_hook_window (ScratchServicesInterface* _sender,
                                                         ScratchMainWindow* window,
                                                         gpointer self);
static void _scratch_plugins_completion_on_new_source_view_scratch_services_interface_hook_document (ScratchServicesInterface* _sender,
                                                                                              ScratchServicesDocument* doc,
                                                                                              gpointer self);
static void scratch_plugins_completion_real_deactivate (ScratchServicesActivatablePlugin* base);
static void scratch_plugins_completion_cleanup (ScratchPluginsCompletion* self,
                                         GtkSourceView* view);
static void _scratch_plugins_completion_cleanup_gfunc (gconstpointer data,
                                                gpointer self);
static void scratch_plugins_completion_real_update_state (ScratchServicesActivatablePlugin* base);
static void scratch_plugins_completion_set_current_document (ScratchPluginsCompletion* self,
                                                      ScratchServicesDocument* value);
static void scratch_plugins_completion_set_current_view (ScratchPluginsCompletion* self,
                                                  GtkSourceView* value);
static gboolean scratch_plugins_completion_on_key_press (ScratchPluginsCompletion* self,
                                                  GtkWidget* view,
                                                  GdkEventKey* event);
static gboolean _scratch_plugins_completion_on_key_press_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                              GdkEventKey* event,
                                                                              gpointer self);
static void __lambda7_ (ScratchPluginsCompletion* self);
static void ___lambda7__gtk_source_completion_show (GtkSourceCompletion* _sender,
                                             gpointer self);
static void __lambda8_ (ScratchPluginsCompletion* self);
static void ___lambda8__gtk_source_completion_hide (GtkSourceCompletion* _sender,
                                             gpointer self);
static gboolean scratch_plugins_completion_on_timeout_update (ScratchPluginsCompletion* self);
static gboolean _scratch_plugins_completion_on_timeout_update_gsource_func (gpointer self);
static void* ___lambda9_ (ScratchPluginsCompletion* self);
static gpointer ____lambda9__gthread_func (gpointer self);
static gchar* scratch_plugins_completion_provider_name_from_document (ScratchPluginsCompletion* self,
                                                               ScratchServicesDocument* doc);
static void __lambda6_ (ScratchPluginsCompletion* self,
                 GtkSourceCompletionProvider* p);
static void ___lambda6__gfunc (gconstpointer data,
                        gpointer self);
static void scratch_plugins_completion_finalize (GObject * obj);
static void _vala_scratch_plugins_completion_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_scratch_plugins_completion_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);
GType scratch_plugins_prefix_tree_register_type (GTypeModule * module);
GType scratch_plugins_prefix_node_register_type (GTypeModule * module);
GType scratch_plugins_completion_provider_register_type (GTypeModule * module);
GType euclide_completion_parser_register_type (GTypeModule * module);

static const guint SCRATCH_PLUGINS_COMPLETION_ACTIVATE_KEYS[6] = {GDK_KEY_Return, GDK_KEY_KP_Enter, GDK_KEY_ISO_Enter, GDK_KEY_Tab, GDK_KEY_KP_Tab, GDK_KEY_ISO_Left_Tab};

static inline gpointer
scratch_plugins_completion_get_instance_private (ScratchPluginsCompletion* self)
{
	return G_STRUCT_MEMBER_P (self, ScratchPluginsCompletion_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda5_ (ScratchPluginsCompletion* self,
            ScratchMainWindow* w)
{
	ScratchMainWindow* _tmp0_;
	g_return_if_fail (w != NULL);
	_tmp0_ = _g_object_ref0 (w);
	_g_object_unref0 (self->priv->main_window);
	self->priv->main_window = _tmp0_;
}

static void
___lambda5__scratch_services_interface_hook_window (ScratchServicesInterface* _sender,
                                                    ScratchMainWindow* window,
                                                    gpointer self)
{
	__lambda5_ ((ScratchPluginsCompletion*) self, window);
}

static void
_scratch_plugins_completion_on_new_source_view_scratch_services_interface_hook_document (ScratchServicesInterface* _sender,
                                                                                         ScratchServicesDocument* doc,
                                                                                         gpointer self)
{
	scratch_plugins_completion_on_new_source_view ((ScratchPluginsCompletion*) self, doc);
}

static void
scratch_plugins_completion_real_activate (ScratchServicesActivatablePlugin* base)
{
	ScratchPluginsCompletion * self;
	GObject* _tmp0_;
	GObject* _tmp1_;
	EuclideCompletionParser* _tmp2_;
	EuclideCompletionParser* _tmp3_;
	ScratchServicesInterface* _tmp4_;
	ScratchServicesInterface* _tmp5_;
	self = (ScratchPluginsCompletion*) base;
	_tmp0_ = scratch_services_activatable_plugin_get_object ((ScratchServicesActivatablePlugin*) self);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->plugins);
	self->priv->plugins = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, SCRATCH_SERVICES_TYPE_INTERFACE, ScratchServicesInterface);
	_tmp2_ = euclide_completion_parser_new ();
	_tmp3_ = _tmp2_;
	scratch_plugins_completion_set_parser (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = self->priv->plugins;
	g_signal_connect_object (_tmp4_, "hook-window", (GCallback) ___lambda5__scratch_services_interface_hook_window, self, 0);
	_tmp5_ = self->priv->plugins;
	g_signal_connect_object (_tmp5_, "hook-document", (GCallback) _scratch_plugins_completion_on_new_source_view_scratch_services_interface_hook_document, self, 0);
}

static void
_scratch_plugins_completion_cleanup_gfunc (gconstpointer data,
                                           gpointer self)
{
	scratch_plugins_completion_cleanup ((ScratchPluginsCompletion*) self, (GtkSourceView*) data);
}

static void
scratch_plugins_completion_real_deactivate (ScratchServicesActivatablePlugin* base)
{
	ScratchPluginsCompletion * self;
	GList* _tmp0_;
	self = (ScratchPluginsCompletion*) base;
	_tmp0_ = self->priv->text_view_list;
	g_list_foreach (_tmp0_, _scratch_plugins_completion_cleanup_gfunc, self);
}

static void
scratch_plugins_completion_real_update_state (ScratchServicesActivatablePlugin* base)
{
	ScratchPluginsCompletion * self;
	self = (ScratchPluginsCompletion*) base;
}

static gboolean
_scratch_plugins_completion_on_key_press_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                     GdkEventKey* event,
                                                                     gpointer self)
{
	gboolean result;
	result = scratch_plugins_completion_on_key_press ((ScratchPluginsCompletion*) self, _sender, event);
	return result;
}

static void
__lambda7_ (ScratchPluginsCompletion* self)
{
	self->priv->completion_in_progress = TRUE;
}

static void
___lambda7__gtk_source_completion_show (GtkSourceCompletion* _sender,
                                        gpointer self)
{
	__lambda7_ ((ScratchPluginsCompletion*) self);
}

static void
__lambda8_ (ScratchPluginsCompletion* self)
{
	self->priv->completion_in_progress = FALSE;
}

static void
___lambda8__gtk_source_completion_hide (GtkSourceCompletion* _sender,
                                        gpointer self)
{
	__lambda8_ ((ScratchPluginsCompletion*) self);
}

static gboolean
_scratch_plugins_completion_on_timeout_update_gsource_func (gpointer self)
{
	gboolean result;
	result = scratch_plugins_completion_on_timeout_update ((ScratchPluginsCompletion*) self);
	return result;
}

void
scratch_plugins_completion_on_new_source_view (ScratchPluginsCompletion* self,
                                               ScratchServicesDocument* doc)
{
	GtkSourceView* _tmp0_;
	ScratchWidgetsSourceView* _tmp6_;
	ScratchWidgetsSourceView* _tmp7_;
	GtkSourceView* _tmp8_;
	GtkSourceView* _tmp9_;
	GtkSourceCompletion* _tmp10_;
	GtkSourceCompletion* _tmp11_;
	GtkSourceView* _tmp12_;
	GtkSourceCompletion* _tmp13_;
	GtkSourceCompletion* _tmp14_;
	GList* _tmp15_;
	GtkSourceView* _tmp16_;
	GList* _tmp17_;
	ScratchPluginsCompletionProvider* comp_provider = NULL;
	EuclideCompletionParser* _tmp20_;
	ScratchPluginsCompletionProvider* _tmp21_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (doc != NULL);
	_tmp0_ = self->priv->_current_view;
	if (_tmp0_ != NULL) {
		GtkSourceView* _tmp1_;
		ScratchWidgetsSourceView* _tmp2_;
		ScratchWidgetsSourceView* _tmp3_;
		EuclideCompletionParser* _tmp4_;
		GtkSourceView* _tmp5_;
		_tmp1_ = self->priv->_current_view;
		_tmp2_ = scratch_services_document_get_source_view (doc);
		_tmp3_ = _tmp2_;
		if (_tmp1_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_source_view_get_type (), GtkSourceView)) {
			return;
		}
		_tmp4_ = self->priv->_parser;
		euclide_completion_parser_cancel_parsing (_tmp4_);
		if (self->priv->timeout_id > ((guint) 0)) {
			g_source_remove (self->priv->timeout_id);
		}
		_tmp5_ = self->priv->_current_view;
		scratch_plugins_completion_cleanup (self, _tmp5_);
	}
	scratch_plugins_completion_set_current_document (self, doc);
	_tmp6_ = scratch_services_document_get_source_view (doc);
	_tmp7_ = _tmp6_;
	scratch_plugins_completion_set_current_view (self, (GtkSourceView*) _tmp7_);
	_tmp8_ = self->priv->_current_view;
	g_signal_connect_object ((GtkWidget*) _tmp8_, "key-press-event", (GCallback) _scratch_plugins_completion_on_key_press_gtk_widget_key_press_event, self, 0);
	_tmp9_ = self->priv->_current_view;
	_tmp10_ = gtk_source_view_get_completion (_tmp9_);
	_tmp11_ = _tmp10_;
	g_signal_connect_object (_tmp11_, "show", (GCallback) ___lambda7__gtk_source_completion_show, self, 0);
	_tmp12_ = self->priv->_current_view;
	_tmp13_ = gtk_source_view_get_completion (_tmp12_);
	_tmp14_ = _tmp13_;
	g_signal_connect_object (_tmp14_, "hide", (GCallback) ___lambda8__gtk_source_completion_hide, self, 0);
	_tmp15_ = self->priv->text_view_list;
	_tmp16_ = self->priv->_current_view;
	_tmp17_ = g_list_find (_tmp15_, _tmp16_);
	if (_tmp17_ == NULL) {
		GtkSourceView* _tmp18_;
		GtkSourceView* _tmp19_;
		_tmp18_ = self->priv->_current_view;
		_tmp19_ = _g_object_ref0 (_tmp18_);
		self->priv->text_view_list = g_list_append (self->priv->text_view_list, _tmp19_);
	}
	_tmp20_ = self->priv->_parser;
	_tmp21_ = scratch_plugins_completion_provider_new (_tmp20_, doc);
	comp_provider = _tmp21_;
	{
		GtkSourceView* _tmp22_;
		GtkSourceCompletion* _tmp23_;
		GtkSourceCompletion* _tmp24_;
		ScratchPluginsCompletionProvider* _tmp25_;
		GtkSourceView* _tmp26_;
		GtkSourceCompletion* _tmp27_;
		GtkSourceCompletion* _tmp28_;
		GtkSourceView* _tmp29_;
		GtkSourceCompletion* _tmp30_;
		GtkSourceCompletion* _tmp31_;
		_tmp22_ = self->priv->_current_view;
		_tmp23_ = gtk_source_view_get_completion (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = comp_provider;
		gtk_source_completion_add_provider (_tmp24_, (GtkSourceCompletionProvider*) _tmp25_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp26_ = self->priv->_current_view;
		_tmp27_ = gtk_source_view_get_completion (_tmp26_);
		_tmp28_ = _tmp27_;
		g_object_set (_tmp28_, "show-headers", TRUE, NULL);
		_tmp29_ = self->priv->_current_view;
		_tmp30_ = gtk_source_view_get_completion (_tmp29_);
		_tmp31_ = _tmp30_;
		g_object_set (_tmp31_, "show-icons", TRUE, NULL);
		self->priv->timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 1000, _scratch_plugins_completion_on_timeout_update_gsource_func, g_object_ref (self), g_object_unref);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp32_;
		const gchar* _tmp33_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp32_ = e;
		_tmp33_ = _tmp32_->message;
		g_warning ("plugin.vala:103: %s", _tmp33_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (comp_provider);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (comp_provider);
}

static void*
___lambda9_ (ScratchPluginsCompletion* self)
{
	GtkSourceView* _tmp0_;
	void* result;
	_tmp0_ = self->priv->_current_view;
	if (_tmp0_ != NULL) {
		EuclideCompletionParser* _tmp1_;
		GtkSourceView* _tmp2_;
		_tmp1_ = self->priv->_parser;
		_tmp2_ = self->priv->_current_view;
		euclide_completion_parser_parse_text_view (_tmp1_, G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_text_view_get_type ()) ? ((GtkTextView*) _tmp2_) : NULL);
	}
	result = NULL;
	return result;
}

static gpointer
____lambda9__gthread_func (gpointer self)
{
	gpointer result;
	result = ___lambda9_ ((ScratchPluginsCompletion*) self);
	g_object_unref (self);
	return result;
}

static gboolean
scratch_plugins_completion_on_timeout_update (ScratchPluginsCompletion* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		GThread* _tmp0_;
		GThread* _tmp1_;
		_tmp0_ = g_thread_try_new ("word-completion-thread", ____lambda9__gthread_func, g_object_ref (self), &_inner_error0_);
		_tmp1_ = _tmp0_;
		_g_thread_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("plugin.vala:116: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp4_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
	self->priv->timeout_id = (guint) 0;
	result = FALSE;
	return result;
}

static gboolean
scratch_plugins_completion_on_key_press (ScratchPluginsCompletion* self,
                                         GtkWidget* view,
                                         GdkEventKey* event)
{
	guint kv = 0U;
	GdkModifierType mods = 0U;
	gunichar uc = 0U;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (view != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	kv = event->keyval;
	mods = ((event->state & GDK_MODIFIER_MASK) & (~GDK_SHIFT_MASK)) & (~GDK_LOCK_MASK);
	if (mods > 0) {
		gboolean _tmp0_ = FALSE;
		if ((mods & GDK_CONTROL_MASK) > 0) {
			_tmp0_ = kv == SCRATCH_PLUGINS_COMPLETION_REFRESH_SHORTCUT;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			EuclideCompletionParser* _tmp1_;
			GtkSourceView* _tmp2_;
			GtkSourceView* _tmp3_;
			_tmp1_ = self->priv->_parser;
			_tmp2_ = self->priv->_current_view;
			euclide_completion_parser_rebuild_word_list (_tmp1_, (GtkTextView*) _tmp2_);
			_tmp3_ = self->priv->_current_view;
			g_signal_emit_by_name (_tmp3_, "show-completion");
			result = TRUE;
			return result;
		}
	}
	uc = (gunichar) gdk_keyval_to_unicode (kv);
	if (!self->priv->completion_in_progress) {
		_tmp5_ = euclide_completion_parser_is_delimiter (uc);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		gboolean _tmp6_ = FALSE;
		if (g_unichar_isprint (uc)) {
			_tmp6_ = TRUE;
		} else {
			_tmp6_ = g_unichar_isspace (uc);
		}
		_tmp4_ = _tmp6_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		GtkTextBuffer* buffer = NULL;
		GtkSourceView* _tmp7_;
		GtkTextBuffer* _tmp8_;
		GtkTextBuffer* _tmp9_;
		GtkTextBuffer* _tmp10_;
		GtkTextMark* mark = NULL;
		GtkTextBuffer* _tmp11_;
		GtkTextMark* _tmp12_;
		GtkTextMark* _tmp13_;
		GtkTextIter cursor_iter = {0};
		GtkTextBuffer* _tmp14_;
		GtkTextMark* _tmp15_;
		GtkTextIter _tmp16_ = {0};
		GtkTextIter word_start = {0};
		GtkTextIter _tmp17_;
		gchar* word = NULL;
		GtkTextBuffer* _tmp18_;
		GtkTextIter _tmp19_;
		GtkTextIter _tmp20_;
		gchar* _tmp21_;
		EuclideCompletionParser* _tmp22_;
		const gchar* _tmp23_;
		_tmp7_ = self->priv->_current_view;
		_tmp8_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _g_object_ref0 (_tmp9_);
		buffer = _tmp10_;
		_tmp11_ = buffer;
		_tmp12_ = gtk_text_buffer_get_insert (_tmp11_);
		_tmp13_ = _g_object_ref0 (_tmp12_);
		mark = _tmp13_;
		_tmp14_ = buffer;
		_tmp15_ = mark;
		gtk_text_buffer_get_iter_at_mark (_tmp14_, &_tmp16_, _tmp15_);
		cursor_iter = _tmp16_;
		_tmp17_ = cursor_iter;
		word_start = _tmp17_;
		euclide_completion_parser_back_to_word_start (&word_start);
		_tmp18_ = buffer;
		_tmp19_ = word_start;
		_tmp20_ = cursor_iter;
		_tmp21_ = gtk_text_buffer_get_text (_tmp18_, &_tmp19_, &_tmp20_, FALSE);
		word = _tmp21_;
		_tmp22_ = self->priv->_parser;
		_tmp23_ = word;
		euclide_completion_parser_add_word (_tmp22_, _tmp23_);
		_g_free0 (word);
		_g_object_unref0 (mark);
		_g_object_unref0 (buffer);
	}
	result = FALSE;
	return result;
}

static gchar*
scratch_plugins_completion_provider_name_from_document (ScratchPluginsCompletion* self,
                                                        ScratchServicesDocument* doc)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (doc != NULL, NULL);
	_tmp0_ = scratch_services_document_get_basename (doc);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf (_ ("%s - Word Completion"), _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

static void
__lambda6_ (ScratchPluginsCompletion* self,
            GtkSourceCompletionProvider* p)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (p != NULL);
	{
		gchar* _tmp0_;
		gchar* _tmp1_;
		ScratchServicesDocument* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gboolean _tmp5_;
		_tmp0_ = gtk_source_completion_provider_get_name (p);
		_tmp1_ = _tmp0_;
		_tmp2_ = self->priv->_current_document;
		_tmp3_ = scratch_plugins_completion_provider_name_from_document (self, _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strcmp0 (_tmp1_, _tmp4_) == 0;
		_g_free0 (_tmp4_);
		_g_free0 (_tmp1_);
		if (_tmp5_) {
			gchar* _tmp6_;
			gchar* _tmp7_;
			GtkSourceView* _tmp8_;
			GtkSourceCompletion* _tmp9_;
			GtkSourceCompletion* _tmp10_;
			_tmp6_ = gtk_source_completion_provider_get_name (p);
			_tmp7_ = _tmp6_;
			g_debug ("plugin.vala:175: removing provider %s", _tmp7_);
			_g_free0 (_tmp7_);
			_tmp8_ = self->priv->_current_view;
			_tmp9_ = gtk_source_view_get_completion (_tmp8_);
			_tmp10_ = _tmp9_;
			gtk_source_completion_remove_provider (_tmp10_, p, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_warning ("plugin.vala:179: %s", _tmp12_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda6__gfunc (gconstpointer data,
                   gpointer self)
{
	__lambda6_ ((ScratchPluginsCompletion*) self, (GtkSourceCompletionProvider*) data);
}

static void
scratch_plugins_completion_cleanup (ScratchPluginsCompletion* self,
                                    GtkSourceView* view)
{
	GtkSourceView* _tmp0_;
	guint _tmp1_;
	GtkSourceView* _tmp2_;
	GtkSourceCompletion* _tmp3_;
	GtkSourceCompletion* _tmp4_;
	GList* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	_tmp0_ = self->priv->_current_view;
	g_signal_parse_name ("key-press-event", gtk_widget_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _scratch_plugins_completion_on_key_press_gtk_widget_key_press_event, self);
	_tmp2_ = self->priv->_current_view;
	_tmp3_ = gtk_source_view_get_completion (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = gtk_source_completion_get_providers (_tmp4_);
	g_list_foreach (_tmp5_, ___lambda6__gfunc, self);
}

ScratchPluginsCompletion*
scratch_plugins_completion_construct (GType object_type)
{
	ScratchPluginsCompletion * self = NULL;
	self = (ScratchPluginsCompletion*) g_object_new (object_type, NULL);
	return self;
}

ScratchPluginsCompletion*
scratch_plugins_completion_new (void)
{
	return scratch_plugins_completion_construct (SCRATCH_PLUGINS_TYPE_COMPLETION);
}

static GObject*
scratch_plugins_completion_real_get_object (ScratchServicesActivatablePlugin* base)
{
	GObject* result;
	ScratchPluginsCompletion* self;
	GObject* _tmp0_;
	GObject* _tmp1_;
	self = (ScratchPluginsCompletion*) base;
	_tmp0_ = self->priv->_object;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
scratch_plugins_completion_real_set_object (ScratchServicesActivatablePlugin* base,
                                            GObject* value)
{
	ScratchPluginsCompletion* self;
	GObject* old_value;
	self = (ScratchPluginsCompletion*) base;
	old_value = scratch_plugins_completion_real_get_object (base);
	if (old_value != value) {
		GObject* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_object);
		self->priv->_object = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_plugins_completion_properties[SCRATCH_PLUGINS_COMPLETION_OBJECT_PROPERTY]);
	}
	_g_object_unref0 (old_value);
}

EuclideCompletionParser*
scratch_plugins_completion_get_parser (ScratchPluginsCompletion* self)
{
	EuclideCompletionParser* result;
	EuclideCompletionParser* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_parser;
	result = _tmp0_;
	return result;
}

static void
scratch_plugins_completion_set_parser (ScratchPluginsCompletion* self,
                                       EuclideCompletionParser* value)
{
	EuclideCompletionParser* old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_plugins_completion_get_parser (self);
	if (old_value != value) {
		EuclideCompletionParser* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_parser);
		self->priv->_parser = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_plugins_completion_properties[SCRATCH_PLUGINS_COMPLETION_PARSER_PROPERTY]);
	}
}

GtkSourceView*
scratch_plugins_completion_get_current_view (ScratchPluginsCompletion* self)
{
	GtkSourceView* result;
	GtkSourceView* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_view;
	result = _tmp0_;
	return result;
}

static void
scratch_plugins_completion_set_current_view (ScratchPluginsCompletion* self,
                                             GtkSourceView* value)
{
	GtkSourceView* old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_plugins_completion_get_current_view (self);
	if (old_value != value) {
		GtkSourceView* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_current_view);
		self->priv->_current_view = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_plugins_completion_properties[SCRATCH_PLUGINS_COMPLETION_CURRENT_VIEW_PROPERTY]);
	}
}

ScratchServicesDocument*
scratch_plugins_completion_get_current_document (ScratchPluginsCompletion* self)
{
	ScratchServicesDocument* result;
	ScratchServicesDocument* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_document;
	result = _tmp0_;
	return result;
}

static void
scratch_plugins_completion_set_current_document (ScratchPluginsCompletion* self,
                                                 ScratchServicesDocument* value)
{
	ScratchServicesDocument* old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_plugins_completion_get_current_document (self);
	if (old_value != value) {
		ScratchServicesDocument* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_current_document);
		self->priv->_current_document = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_plugins_completion_properties[SCRATCH_PLUGINS_COMPLETION_CURRENT_DOCUMENT_PROPERTY]);
	}
}

static void
scratch_plugins_completion_class_init (ScratchPluginsCompletionClass * klass,
                                       gpointer klass_data)
{
	scratch_plugins_completion_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ScratchPluginsCompletion_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_scratch_plugins_completion_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_scratch_plugins_completion_set_property;
	G_OBJECT_CLASS (klass)->finalize = scratch_plugins_completion_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_PLUGINS_COMPLETION_OBJECT_PROPERTY, scratch_plugins_completion_properties[SCRATCH_PLUGINS_COMPLETION_OBJECT_PROPERTY] = g_param_spec_object ("object", "object", "object", G_TYPE_OBJECT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_PLUGINS_COMPLETION_PARSER_PROPERTY, scratch_plugins_completion_properties[SCRATCH_PLUGINS_COMPLETION_PARSER_PROPERTY] = g_param_spec_object ("parser", "parser", "parser", EUCLIDE_COMPLETION_TYPE_PARSER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_PLUGINS_COMPLETION_CURRENT_VIEW_PROPERTY, scratch_plugins_completion_properties[SCRATCH_PLUGINS_COMPLETION_CURRENT_VIEW_PROPERTY] = g_param_spec_object ("current-view", "current-view", "current-view", gtk_source_view_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_PLUGINS_COMPLETION_CURRENT_DOCUMENT_PROPERTY, scratch_plugins_completion_properties[SCRATCH_PLUGINS_COMPLETION_CURRENT_DOCUMENT_PROPERTY] = g_param_spec_object ("current-document", "current-document", "current-document", SCRATCH_SERVICES_TYPE_DOCUMENT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
scratch_plugins_completion_scratch_services_activatable_plugin_interface_init (ScratchServicesActivatablePluginIface * iface,
                                                                               gpointer iface_data)
{
	scratch_plugins_completion_scratch_services_activatable_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate = (void (*) (ScratchServicesActivatablePlugin*)) scratch_plugins_completion_real_activate;
	iface->deactivate = (void (*) (ScratchServicesActivatablePlugin*)) scratch_plugins_completion_real_deactivate;
	iface->update_state = (void (*) (ScratchServicesActivatablePlugin*)) scratch_plugins_completion_real_update_state;
	iface->get_object = scratch_plugins_completion_real_get_object;
	iface->set_object = scratch_plugins_completion_real_set_object;
}

static void
scratch_plugins_completion_instance_init (ScratchPluginsCompletion * self,
                                          gpointer klass)
{
	self->priv = scratch_plugins_completion_get_instance_private (self);
	self->priv->text_view_list = NULL;
	self->priv->completion_in_progress = FALSE;
	self->priv->timeout_id = (guint) 0;
}

static void
scratch_plugins_completion_finalize (GObject * obj)
{
	ScratchPluginsCompletion * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_PLUGINS_TYPE_COMPLETION, ScratchPluginsCompletion);
	_g_object_unref0 (self->priv->_object);
	(self->priv->text_view_list == NULL) ? NULL : (self->priv->text_view_list = (_g_list_free__g_object_unref0_ (self->priv->text_view_list), NULL));
	_g_object_unref0 (self->priv->_parser);
	_g_object_unref0 (self->priv->_current_view);
	_g_object_unref0 (self->priv->_current_document);
	_g_object_unref0 (self->priv->main_window);
	_g_object_unref0 (self->priv->plugins);
	G_OBJECT_CLASS (scratch_plugins_completion_parent_class)->finalize (obj);
}

GType
scratch_plugins_completion_get_type (void)
{
	return scratch_plugins_completion_type_id;
}

GType
scratch_plugins_completion_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScratchPluginsCompletionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scratch_plugins_completion_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScratchPluginsCompletion), 0, (GInstanceInitFunc) scratch_plugins_completion_instance_init, NULL };
	static const GInterfaceInfo scratch_services_activatable_plugin_info = { (GInterfaceInitFunc) scratch_plugins_completion_scratch_services_activatable_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	scratch_plugins_completion_type_id = g_type_module_register_type (module, peas_extension_base_get_type (), "ScratchPluginsCompletion", &g_define_type_info, 0);
	g_type_module_add_interface (module, scratch_plugins_completion_type_id, SCRATCH_SERVICES_TYPE_ACTIVATABLE_PLUGIN, &scratch_services_activatable_plugin_info);
	ScratchPluginsCompletion_private_offset = sizeof (ScratchPluginsCompletionPrivate);
	return scratch_plugins_completion_type_id;
}

static void
_vala_scratch_plugins_completion_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	ScratchPluginsCompletion * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_PLUGINS_TYPE_COMPLETION, ScratchPluginsCompletion);
	switch (property_id) {
		case SCRATCH_PLUGINS_COMPLETION_OBJECT_PROPERTY:
		g_value_take_object (value, scratch_services_activatable_plugin_get_object ((ScratchServicesActivatablePlugin*) self));
		break;
		case SCRATCH_PLUGINS_COMPLETION_PARSER_PROPERTY:
		g_value_set_object (value, scratch_plugins_completion_get_parser (self));
		break;
		case SCRATCH_PLUGINS_COMPLETION_CURRENT_VIEW_PROPERTY:
		g_value_set_object (value, scratch_plugins_completion_get_current_view (self));
		break;
		case SCRATCH_PLUGINS_COMPLETION_CURRENT_DOCUMENT_PROPERTY:
		g_value_set_object (value, scratch_plugins_completion_get_current_document (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_scratch_plugins_completion_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	ScratchPluginsCompletion * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_PLUGINS_TYPE_COMPLETION, ScratchPluginsCompletion);
	switch (property_id) {
		case SCRATCH_PLUGINS_COMPLETION_OBJECT_PROPERTY:
		scratch_services_activatable_plugin_set_object ((ScratchServicesActivatablePlugin*) self, g_value_get_object (value));
		break;
		case SCRATCH_PLUGINS_COMPLETION_PARSER_PROPERTY:
		scratch_plugins_completion_set_parser (self, g_value_get_object (value));
		break;
		case SCRATCH_PLUGINS_COMPLETION_CURRENT_VIEW_PROPERTY:
		scratch_plugins_completion_set_current_view (self, g_value_get_object (value));
		break;
		case SCRATCH_PLUGINS_COMPLETION_CURRENT_DOCUMENT_PROPERTY:
		scratch_plugins_completion_set_current_document (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* objmodule = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	scratch_plugins_prefix_tree_register_type (module);
	scratch_plugins_prefix_node_register_type (module);
	scratch_plugins_completion_provider_register_type (module);
	scratch_plugins_completion_register_type (module);
	euclide_completion_parser_register_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	objmodule = _tmp0_;
	peas_object_module_register_extension_type (objmodule, SCRATCH_SERVICES_TYPE_ACTIVATABLE_PLUGIN, SCRATCH_PLUGINS_TYPE_COMPLETION);
	_g_object_unref0 (objmodule);
}

