/* FdoActionGroup.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from FdoActionGroup.vala, do not modify */

/*
 * Copyright 2023-2025 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 * Author: Gustavo Marques <pushstarttocontinue@outlook.com>
 */
/* RefString don't subclass string in vala, however they ctype is char**/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define NOTIFICATIONS_FDO_TYPE_ACTION_GROUP (notifications_fdo_action_group_get_type ())
#define NOTIFICATIONS_FDO_ACTION_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOTIFICATIONS_FDO_TYPE_ACTION_GROUP, NotificationsFdoActionGroup))
#define NOTIFICATIONS_FDO_ACTION_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NOTIFICATIONS_FDO_TYPE_ACTION_GROUP, NotificationsFdoActionGroupClass))
#define NOTIFICATIONS_FDO_IS_ACTION_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOTIFICATIONS_FDO_TYPE_ACTION_GROUP))
#define NOTIFICATIONS_FDO_IS_ACTION_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NOTIFICATIONS_FDO_TYPE_ACTION_GROUP))
#define NOTIFICATIONS_FDO_ACTION_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NOTIFICATIONS_FDO_TYPE_ACTION_GROUP, NotificationsFdoActionGroupClass))

typedef struct _NotificationsFdoActionGroup NotificationsFdoActionGroup;
typedef struct _NotificationsFdoActionGroupClass NotificationsFdoActionGroupClass;
typedef struct _NotificationsFdoActionGroupPrivate NotificationsFdoActionGroupPrivate;

#define NOTIFICATIONS_TYPE_SERVER (notifications_server_get_type ())
#define NOTIFICATIONS_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOTIFICATIONS_TYPE_SERVER, NotificationsServer))
#define NOTIFICATIONS_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NOTIFICATIONS_TYPE_SERVER, NotificationsServerClass))
#define NOTIFICATIONS_IS_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOTIFICATIONS_TYPE_SERVER))
#define NOTIFICATIONS_IS_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NOTIFICATIONS_TYPE_SERVER))
#define NOTIFICATIONS_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NOTIFICATIONS_TYPE_SERVER, NotificationsServerClass))

typedef struct _NotificationsServer NotificationsServer;
typedef struct _NotificationsServerClass NotificationsServerClass;
enum  {
	NOTIFICATIONS_FDO_ACTION_GROUP_0_PROPERTY,
	NOTIFICATIONS_FDO_ACTION_GROUP_NUM_PROPERTIES
};
static GParamSpec* notifications_fdo_action_group_properties[NOTIFICATIONS_FDO_ACTION_GROUP_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_ref_string_release0(var) ((var == NULL) ? NULL : (var = (g_ref_string_release (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_strv_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_strv_builder_unref (var), NULL)))
typedef enum  {
	NOTIFICATIONS_CLOSE_REASON_EXPIRED = 1,
	NOTIFICATIONS_CLOSE_REASON_DISMISSED = 2,
	NOTIFICATIONS_CLOSE_REASON_CLOSE_NOTIFICATION_CALL = 3,
	NOTIFICATIONS_CLOSE_REASON_UNDEFINED = 4
} NotificationsCloseReason;

#define NOTIFICATIONS_TYPE_CLOSE_REASON (notifications_close_reason_get_type ())
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _NotificationsFdoActionGroup {
	GObject parent_instance;
	NotificationsFdoActionGroupPrivate * priv;
};

struct _NotificationsFdoActionGroupClass {
	GObjectClass parent_class;
};

struct _NotificationsFdoActionGroupPrivate {
	GeeCollection* actions;
	NotificationsServer* server;
};

static gint NotificationsFdoActionGroup_private_offset;
static gpointer notifications_fdo_action_group_parent_class = NULL;
static GVariantType* notifications_fdo_action_group_close_parameter_type;
static GVariantType* notifications_fdo_action_group_close_parameter_type = NULL;
static GActionGroupInterface * notifications_fdo_action_group_g_action_group_parent_iface = NULL;

VALA_EXTERN GType notifications_fdo_action_group_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NotificationsFdoActionGroup, g_object_unref)
VALA_EXTERN GType notifications_server_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NotificationsServer, g_object_unref)
VALA_EXTERN guint notifications_server_register_object (void* object,
                                            GDBusConnection* connection,
                                            const gchar* path,
                                            GError** error);
VALA_EXTERN NotificationsFdoActionGroup* notifications_fdo_action_group_new (NotificationsServer* server);
VALA_EXTERN NotificationsFdoActionGroup* notifications_fdo_action_group_construct (GType object_type,
                                                                       NotificationsServer* server);
static guint _g_str_hash_gee_hash_data_func (gconstpointer v,
                                      gpointer self);
static gboolean _g_str_equal_gee_equal_data_func (gconstpointer a,
                                           gconstpointer b,
                                           gpointer self);
VALA_EXTERN const gchar* notifications_fdo_action_group_add_action (NotificationsFdoActionGroup* self,
                                                        guint32 id,
                                                        const gchar* action);
VALA_EXTERN void notifications_fdo_action_group_remove_actions (NotificationsFdoActionGroup* self,
                                                    guint32 id);
static gboolean notifications_fdo_action_group_real_query_action (GActionGroup* base,
                                                           const gchar* action_name,
                                                           gboolean* enabled,
                                                           const GVariantType** parameter_type,
                                                           const GVariantType** state_type,
                                                           GVariant** state_hint,
                                                           GVariant** state);
static gchar** notifications_fdo_action_group_real_list_actions (GActionGroup* base);
static void notifications_fdo_action_group_real_activate_action (GActionGroup* base,
                                                          const gchar* action,
                                                          GVariant* target);
VALA_EXTERN GType notifications_close_reason_get_type (void) G_GNUC_CONST ;
static void notifications_fdo_action_group_real_change_action_state (GActionGroup* base,
                                                              const gchar* action_name,
                                                              GVariant* value);
static gboolean notifications_fdo_action_group_real_has_action (GActionGroup* base,
                                                         const gchar* action_name);
static gboolean notifications_fdo_action_group_real_get_action_enabled (GActionGroup* base,
                                                                 const gchar* action_name);
static const GVariantType* notifications_fdo_action_group_real_get_action_parameter_type (GActionGroup* base,
                                                                                   const gchar* action_name);
static const GVariantType* notifications_fdo_action_group_real_get_action_state_type (GActionGroup* base,
                                                                               const gchar* action_name);
static GVariant* notifications_fdo_action_group_real_get_action_state_hint (GActionGroup* base,
                                                                     const gchar* action_name);
static GVariant* notifications_fdo_action_group_real_get_action_state (GActionGroup* base,
                                                                const gchar* action_name);
static void notifications_fdo_action_group_finalize (GObject * obj);
static GType notifications_fdo_action_group_get_type_once (void);
static gssize _vala_array_length (gpointer array);

static inline gpointer
notifications_fdo_action_group_get_instance_private (NotificationsFdoActionGroup* self)
{
	return G_STRUCT_MEMBER_P (self, NotificationsFdoActionGroup_private_offset);
}

static guint
_g_str_hash_gee_hash_data_func (gconstpointer v,
                                gpointer self)
{
	guint result;
	result = g_str_hash ((GRefString*) v);
	return result;
}

static gboolean
_g_str_equal_gee_equal_data_func (gconstpointer a,
                                  gconstpointer b,
                                  gpointer self)
{
	gboolean result;
	result = g_str_equal ((GRefString*) a, (GRefString*) b);
	return result;
}

NotificationsFdoActionGroup*
notifications_fdo_action_group_construct (GType object_type,
                                          NotificationsServer* server)
{
	NotificationsFdoActionGroup * self = NULL;
	GeeHashSet* _tmp0_;
	GeeCollection* _tmp1_;
	GRefString* _tmp2_;
	GRefString* _tmp3_;
	g_return_val_if_fail (server != NULL, NULL);
	self = (NotificationsFdoActionGroup*) g_object_new (object_type, NULL);
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_ref_string_acquire, (GDestroyNotify) g_ref_string_release, _g_str_hash_gee_hash_data_func, NULL, NULL, _g_str_equal_gee_equal_data_func, NULL, NULL);
	_g_object_unref0 (self->priv->actions);
	self->priv->actions = (GeeCollection*) _tmp0_;
	self->priv->server = server;
	_tmp1_ = self->priv->actions;
	_tmp2_ = g_ref_string_new_intern ("close");
	_tmp3_ = _tmp2_;
	gee_collection_add (_tmp1_, _tmp3_);
	_g_ref_string_release0 (_tmp3_);
	return self;
}

NotificationsFdoActionGroup*
notifications_fdo_action_group_new (NotificationsServer* server)
{
	return notifications_fdo_action_group_construct (NOTIFICATIONS_FDO_TYPE_ACTION_GROUP, server);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

const gchar*
notifications_fdo_action_group_add_action (NotificationsFdoActionGroup* self,
                                           guint32 id,
                                           const gchar* action)
{
	GRefString* action_name = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GRefString* _tmp5_;
	GRefString* _tmp6_;
	GeeCollection* _tmp7_;
	GRefString* _tmp8_;
	GRefString* _tmp11_;
	const gchar* _tmp12_;
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (action != NULL, NULL);
	_tmp0_ = g_strdup_printf ("%u", id);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_to_string (action);
	_tmp3_ = g_strconcat (_tmp1_, ".", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_ref_string_new_intern (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
	action_name = _tmp6_;
	_tmp7_ = self->priv->actions;
	_tmp8_ = action_name;
	if (gee_collection_add (_tmp7_, _tmp8_)) {
		GRefString* _tmp9_;
		const gchar* _tmp10_;
		_tmp9_ = action_name;
		_tmp10_ = (const char*) (_tmp9_);
		g_action_group_action_added ((GActionGroup*) self, _tmp10_);
	}
	_tmp11_ = action_name;
	_tmp12_ = (const char*) (_tmp11_);
	result = _tmp12_;
	_g_ref_string_release0 (action_name);
	return result;
}

void
notifications_fdo_action_group_remove_actions (NotificationsFdoActionGroup* self,
                                               guint32 id)
{
	GeeIterator* iter = NULL;
	GeeCollection* _tmp0_;
	GeeIterator* _tmp1_;
	gchar* prefix = NULL;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->actions;
	_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
	iter = _tmp1_;
	_tmp2_ = g_strdup_printf ("%u", id);
	prefix = _tmp2_;
	while (TRUE) {
		GeeIterator* _tmp3_;
		gchar* action = NULL;
		GeeIterator* _tmp4_;
		gpointer _tmp5_;
		GRefString* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		GeeIterator* _tmp13_;
		_tmp3_ = iter;
		if (!gee_iterator_next (_tmp3_)) {
			break;
		}
		_tmp4_ = iter;
		_tmp5_ = gee_iterator_get (_tmp4_);
		_tmp6_ = (GRefString*) _tmp5_;
		_tmp7_ = (const char*) (_tmp6_);
		_tmp8_ = g_strdup (_tmp7_);
		_tmp9_ = _tmp8_;
		_g_ref_string_release0 (_tmp6_);
		action = _tmp9_;
		_tmp10_ = action;
		_tmp11_ = prefix;
		if (!g_str_has_prefix (_tmp10_, _tmp11_)) {
			_g_free0 (action);
			continue;
		}
		_tmp12_ = action;
		g_action_group_action_removed ((GActionGroup*) self, _tmp12_);
		_tmp13_ = iter;
		gee_iterator_remove (_tmp13_);
		_g_free0 (action);
	}
	_g_free0 (prefix);
	_g_object_unref0 (iter);
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

static gboolean
notifications_fdo_action_group_real_query_action (GActionGroup* base,
                                                  const gchar* action_name,
                                                  gboolean* enabled,
                                                  const GVariantType** parameter_type,
                                                  const GVariantType** state_type,
                                                  GVariant** state_hint,
                                                  GVariant** state)
{
	NotificationsFdoActionGroup * self;
	gboolean _vala_enabled = FALSE;
	const GVariantType* _vala_parameter_type = NULL;
	const GVariantType* _vala_state_type = NULL;
	GVariant* _vala_state_hint = NULL;
	GVariant* _vala_state = NULL;
	const GVariantType* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	GeeCollection* _tmp3_;
	gboolean result;
	self = (NotificationsFdoActionGroup*) base;
	g_return_val_if_fail (action_name != NULL, FALSE);
	_vala_state_type = NULL;
	_tmp0_ = _vala_state_type;
	_vala_parameter_type = _tmp0_;
	_g_variant_unref0 (_vala_state);
	_vala_state = NULL;
	_tmp1_ = _vala_state;
	_tmp2_ = _g_variant_ref0 (_tmp1_);
	_g_variant_unref0 (_vala_state_hint);
	_vala_state_hint = _tmp2_;
	_tmp3_ = self->priv->actions;
	_vala_enabled = gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection), action_name);
	if (g_strcmp0 (action_name, "close") == 0) {
		const GVariantType* _tmp4_;
		_tmp4_ = notifications_fdo_action_group_close_parameter_type;
		_vala_parameter_type = _tmp4_;
	}
	result = _vala_enabled;
	if (enabled) {
		*enabled = _vala_enabled;
	}
	if (parameter_type) {
		*parameter_type = _vala_parameter_type;
	}
	if (state_type) {
		*state_type = _vala_state_type;
	}
	if (state_hint) {
		*state_hint = _vala_state_hint;
	} else {
		_g_variant_unref0 (_vala_state_hint);
	}
	if (state) {
		*state = _vala_state;
	} else {
		_g_variant_unref0 (_vala_state);
	}
	return result;
}

static gchar**
notifications_fdo_action_group_real_list_actions (GActionGroup* base)
{
	NotificationsFdoActionGroup * self;
	GStrvBuilder* builder = NULL;
	GStrvBuilder* _tmp0_;
	GStrvBuilder* _tmp11_;
	gchar** _tmp12_;
	gchar** _tmp13_;
	gchar** result;
	self = (NotificationsFdoActionGroup*) base;
	_tmp0_ = g_strv_builder_new ();
	builder = _tmp0_;
	{
		GeeIterator* _action_it = NULL;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
		_tmp1_ = self->priv->actions;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_action_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			GRefString* action = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			GStrvBuilder* _tmp6_;
			GRefString* _tmp7_;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp3_ = _action_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _action_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			action = (GRefString*) _tmp5_;
			_tmp6_ = builder;
			_tmp7_ = action;
			_tmp8_ = (const char*) (_tmp7_);
			_tmp9_ = g_strdup (_tmp8_);
			_tmp10_ = _tmp9_;
			g_strv_builder_add (_tmp6_, _tmp10_);
			_g_free0 (_tmp10_);
			_g_ref_string_release0 (action);
		}
		_g_object_unref0 (_action_it);
	}
	_tmp11_ = builder;
	_tmp13_ = _tmp12_ = g_strv_builder_end (_tmp11_);
	result = _tmp13_;
	_g_strv_builder_unref0 (builder);
	return result;
}

static gboolean
uint_try_parse (const gchar* str,
                guint* _result_,
                const gchar** unparsed,
                guint _base)
{
	guint _vala__result_ = 0U;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	gulong ulong_result = 0UL;
	gchar* _tmp0_ = NULL;
	gulong _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gulong _tmp6_;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	errno = 0;
	_tmp1_ = strtoul (str, &_tmp0_, (gint) _base);
	endptr = _tmp0_;
	ulong_result = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		_vala_unparsed = "";
	} else {
		gchar* _tmp5_;
		_tmp5_ = endptr;
		_vala_unparsed = (const gchar*) _tmp5_;
	}
	_tmp6_ = ulong_result;
	if ((((gulong) 0) <= _tmp6_) && (_tmp6_ <= ((gulong) G_MAXUINT))) {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		_vala__result_ = (guint) ulong_result;
		if (errno != ERANGE) {
			_tmp8_ = errno != EINVAL;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			const gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp9_ = _vala_unparsed;
			_tmp10_ = endptr;
			_tmp7_ = _tmp9_ != _tmp10_;
		} else {
			_tmp7_ = FALSE;
		}
		result = _tmp7_;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		_vala__result_ = G_MAXUINT;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static void
notifications_fdo_action_group_real_activate_action (GActionGroup* base,
                                                     const gchar* action,
                                                     GVariant* target)
{
	NotificationsFdoActionGroup * self;
	gchar* action_name = NULL;
	guint32 id = 0U;
	guint _tmp5_ = 0U;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	NotificationsServer* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	self = (NotificationsFdoActionGroup*) base;
	g_return_if_fail (action != NULL);
	_vala_return_if_fail (g_action_group_has_action ((GActionGroup*) self, action), "has_action (action)");
	if (g_strcmp0 (action, "close") == 0) {
		GVariantIter* iter = NULL;
		GVariantIter* _tmp0_;
		guint32 id = 0U;
		_tmp0_ = g_variant_iter_new (target);
		iter = _tmp0_;
		while (TRUE) {
			GVariantIter* _tmp1_;
			guint32 _tmp2_ = 0U;
			gboolean _tmp3_;
			NotificationsServer* _tmp4_;
			_tmp1_ = iter;
			_tmp3_ = g_variant_iter_next (_tmp1_, "u", &_tmp2_, NULL);
			id = _tmp2_;
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = self->priv->server;
			g_signal_emit_by_name (_tmp4_, "notification-closed", id, (guint32) NOTIFICATIONS_CLOSE_REASON_DISMISSED);
		}
		_g_variant_iter_free0 (iter);
		return;
	}
	uint_try_parse (action, &_tmp5_, &_tmp6_, (guint) 0);
	id = (guint32) _tmp5_;
	_g_free0 (action_name);
	_tmp7_ = g_strdup (_tmp6_);
	action_name = _tmp7_;
	if (id == ((guint32) 0)) {
		g_warning ("FdoActionGroup.vala:109: failed to activate action '%s': failed to par" \
"se notification id", action);
		_g_free0 (action_name);
		return;
	}
	_tmp8_ = action_name;
	_tmp9_ = action_name;
	_tmp10_ = strlen (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = string_slice (_tmp9_, (glong) 1, (glong) _tmp11_);
	_tmp13_ = _tmp12_;
	g_debug ("FdoActionGroup.vala:113: activating action '%s' for notification id '%" \
"u'", _tmp13_, (guint) id);
	_g_free0 (_tmp13_);
	_tmp14_ = self->priv->server;
	_tmp15_ = action_name;
	_tmp16_ = action_name;
	_tmp17_ = strlen (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = string_slice (_tmp16_, (glong) 1, (glong) _tmp18_);
	_tmp20_ = _tmp19_;
	g_signal_emit_by_name (_tmp14_, "action-invoked", id, _tmp20_);
	_g_free0 (_tmp20_);
	_g_free0 (action_name);
}

static void
notifications_fdo_action_group_real_change_action_state (GActionGroup* base,
                                                         const gchar* action_name,
                                                         GVariant* value)
{
	NotificationsFdoActionGroup * self;
	self = (NotificationsFdoActionGroup*) base;
	g_return_if_fail (action_name != NULL);
	g_return_if_fail (value != NULL);
}

static gboolean
notifications_fdo_action_group_real_has_action (GActionGroup* base,
                                                const gchar* action_name)
{
	NotificationsFdoActionGroup * self;
	GeeCollection* _tmp0_;
	gboolean result;
	self = (NotificationsFdoActionGroup*) base;
	g_return_val_if_fail (action_name != NULL, FALSE);
	_tmp0_ = self->priv->actions;
	result = gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), action_name);
	return result;
}

static gboolean
notifications_fdo_action_group_real_get_action_enabled (GActionGroup* base,
                                                        const gchar* action_name)
{
	NotificationsFdoActionGroup * self;
	gboolean result;
	self = (NotificationsFdoActionGroup*) base;
	g_return_val_if_fail (action_name != NULL, FALSE);
	result = g_action_group_has_action ((GActionGroup*) self, action_name);
	return result;
}

static const GVariantType*
notifications_fdo_action_group_real_get_action_parameter_type (GActionGroup* base,
                                                               const gchar* action_name)
{
	NotificationsFdoActionGroup * self;
	const GVariantType* result;
	self = (NotificationsFdoActionGroup*) base;
	g_return_val_if_fail (action_name != NULL, NULL);
	if (g_strcmp0 (action_name, "close") == 0) {
		const GVariantType* _tmp0_;
		_tmp0_ = notifications_fdo_action_group_close_parameter_type;
		result = _tmp0_;
		return result;
	}
	result = NULL;
	return result;
}

static const GVariantType*
notifications_fdo_action_group_real_get_action_state_type (GActionGroup* base,
                                                           const gchar* action_name)
{
	NotificationsFdoActionGroup * self;
	const GVariantType* result;
	self = (NotificationsFdoActionGroup*) base;
	g_return_val_if_fail (action_name != NULL, NULL);
	result = NULL;
	return result;
}

static GVariant*
notifications_fdo_action_group_real_get_action_state_hint (GActionGroup* base,
                                                           const gchar* action_name)
{
	NotificationsFdoActionGroup * self;
	GVariant* result;
	self = (NotificationsFdoActionGroup*) base;
	g_return_val_if_fail (action_name != NULL, NULL);
	result = NULL;
	return result;
}

static GVariant*
notifications_fdo_action_group_real_get_action_state (GActionGroup* base,
                                                      const gchar* action_name)
{
	NotificationsFdoActionGroup * self;
	GVariant* result;
	self = (NotificationsFdoActionGroup*) base;
	g_return_val_if_fail (action_name != NULL, NULL);
	result = NULL;
	return result;
}

static void
notifications_fdo_action_group_class_init (NotificationsFdoActionGroupClass * klass,
                                           gpointer klass_data)
{
	const GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	notifications_fdo_action_group_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NotificationsFdoActionGroup_private_offset);
	G_OBJECT_CLASS (klass)->finalize = notifications_fdo_action_group_finalize;
	_tmp0_ = G_VARIANT_TYPE_UINT32;
	_tmp1_ = g_variant_type_new_array (_tmp0_);
	notifications_fdo_action_group_close_parameter_type = _tmp1_;
}

static void
notifications_fdo_action_group_g_action_group_interface_init (GActionGroupInterface * iface,
                                                              gpointer iface_data)
{
	notifications_fdo_action_group_g_action_group_parent_iface = g_type_interface_peek_parent (iface);
	iface->query_action = (gboolean (*) (GActionGroup*, const gchar*, gboolean*, const GVariantType**, const GVariantType**, GVariant**, GVariant**)) notifications_fdo_action_group_real_query_action;
	iface->list_actions = (gchar** (*) (GActionGroup*)) notifications_fdo_action_group_real_list_actions;
	iface->activate_action = (void (*) (GActionGroup*, const gchar*, GVariant*)) notifications_fdo_action_group_real_activate_action;
	iface->change_action_state = (void (*) (GActionGroup*, const gchar*, GVariant*)) notifications_fdo_action_group_real_change_action_state;
	iface->has_action = (gboolean (*) (GActionGroup*, const gchar*)) notifications_fdo_action_group_real_has_action;
	iface->get_action_enabled = (gboolean (*) (GActionGroup*, const gchar*)) notifications_fdo_action_group_real_get_action_enabled;
	iface->get_action_parameter_type = (const GVariantType* (*) (GActionGroup*, const gchar*)) notifications_fdo_action_group_real_get_action_parameter_type;
	iface->get_action_state_type = (const GVariantType* (*) (GActionGroup*, const gchar*)) notifications_fdo_action_group_real_get_action_state_type;
	iface->get_action_state_hint = (GVariant* (*) (GActionGroup*, const gchar*)) notifications_fdo_action_group_real_get_action_state_hint;
	iface->get_action_state = (GVariant* (*) (GActionGroup*, const gchar*)) notifications_fdo_action_group_real_get_action_state;
}

static void
notifications_fdo_action_group_instance_init (NotificationsFdoActionGroup * self,
                                              gpointer klass)
{
	self->priv = notifications_fdo_action_group_get_instance_private (self);
}

static void
notifications_fdo_action_group_finalize (GObject * obj)
{
	NotificationsFdoActionGroup * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NOTIFICATIONS_FDO_TYPE_ACTION_GROUP, NotificationsFdoActionGroup);
	_g_object_unref0 (self->priv->actions);
	G_OBJECT_CLASS (notifications_fdo_action_group_parent_class)->finalize (obj);
}

/**
 * A implementation of GLib.ActionGroup meant to be used by external programs
 * to trigger the signals in the org.freedesktop.Notifications interface.
 *
 * notification actions follow the "id.action" format, a "close(@au ids)" action
 * exist to trigger the NotificationClosed signal.
 */
static GType
notifications_fdo_action_group_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NotificationsFdoActionGroupClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notifications_fdo_action_group_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotificationsFdoActionGroup), 0, (GInstanceInitFunc) notifications_fdo_action_group_instance_init, NULL };
	static const GInterfaceInfo g_action_group_info = { (GInterfaceInitFunc) notifications_fdo_action_group_g_action_group_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType notifications_fdo_action_group_type_id;
	notifications_fdo_action_group_type_id = g_type_register_static (G_TYPE_OBJECT, "NotificationsFdoActionGroup", &g_define_type_info, 0);
	g_type_add_interface_static (notifications_fdo_action_group_type_id, g_action_group_get_type (), &g_action_group_info);
	NotificationsFdoActionGroup_private_offset = g_type_add_instance_private (notifications_fdo_action_group_type_id, sizeof (NotificationsFdoActionGroupPrivate));
	return notifications_fdo_action_group_type_id;
}

GType
notifications_fdo_action_group_get_type (void)
{
	static volatile gsize notifications_fdo_action_group_type_id__once = 0;
	if (g_once_init_enter (&notifications_fdo_action_group_type_id__once)) {
		GType notifications_fdo_action_group_type_id;
		notifications_fdo_action_group_type_id = notifications_fdo_action_group_get_type_once ();
		g_once_init_leave (&notifications_fdo_action_group_type_id__once, notifications_fdo_action_group_type_id);
	}
	return notifications_fdo_action_group_type_id__once;
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

