/* rygel-gst-transcoder.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from rygel-gst-transcoder.vala, do not modify */

/*
 * Copyright (C) 2009-2012 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *         Prasanna Modem <prasanna@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-media-engine-gst.h"
#include <glib-object.h>
#include "rygel-server.h"
#include <glib.h>
#include <gst/pbutils/pbutils.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <gio/gio.h>

#define RYGEL_GST_TRANSCODER_DEFAULT_ENCODING_PRESET "Rygel DLNA preset"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define RYGEL_TYPE_GST_TRANSCODER (rygel_gst_transcoder_get_type ())
#define RYGEL_GST_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoder))
#define RYGEL_GST_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoderClass))
#define RYGEL_IS_GST_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_GST_TRANSCODER))
#define RYGEL_IS_GST_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_GST_TRANSCODER))
#define RYGEL_GST_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoderClass))

typedef struct _RygelGstTranscoder RygelGstTranscoder;
typedef struct _RygelGstTranscoderClass RygelGstTranscoderClass;
typedef struct _RygelGstTranscoderPrivate RygelGstTranscoderPrivate;
enum  {
	RYGEL_GST_TRANSCODER_0_PROPERTY,
	RYGEL_GST_TRANSCODER_NAME_PROPERTY,
	RYGEL_GST_TRANSCODER_MIME_TYPE_PROPERTY,
	RYGEL_GST_TRANSCODER_DLNA_PROFILE_PROPERTY,
	RYGEL_GST_TRANSCODER_EXTENSION_PROPERTY,
	RYGEL_GST_TRANSCODER_PRESET_PROPERTY,
	RYGEL_GST_TRANSCODER_NUM_PROPERTIES
};
static GParamSpec* rygel_gst_transcoder_properties[RYGEL_GST_TRANSCODER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_GST_DATA_SOURCE (rygel_gst_data_source_get_type ())
#define RYGEL_GST_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSource))
#define RYGEL_GST_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSourceClass))
#define RYGEL_IS_GST_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_GST_DATA_SOURCE))
#define RYGEL_IS_GST_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_GST_DATA_SOURCE))
#define RYGEL_GST_DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSourceClass))

typedef struct _RygelGstDataSource RygelGstDataSource;
typedef struct _RygelGstDataSourceClass RygelGstDataSourceClass;

#define RYGEL_TYPE_TRANSCODING_GST_DATA_SOURCE (rygel_transcoding_gst_data_source_get_type ())
#define RYGEL_TRANSCODING_GST_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODING_GST_DATA_SOURCE, RygelTranscodingGstDataSource))
#define RYGEL_TRANSCODING_GST_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODING_GST_DATA_SOURCE, RygelTranscodingGstDataSourceClass))
#define RYGEL_IS_TRANSCODING_GST_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODING_GST_DATA_SOURCE))
#define RYGEL_IS_TRANSCODING_GST_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODING_GST_DATA_SOURCE))
#define RYGEL_TRANSCODING_GST_DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODING_GST_DATA_SOURCE, RygelTranscodingGstDataSourceClass))

typedef struct _RygelTranscodingGstDataSource RygelTranscodingGstDataSource;
typedef struct _RygelTranscodingGstDataSourceClass RygelTranscodingGstDataSourceClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _RygelGstTranscoder {
	GObject parent_instance;
	RygelGstTranscoderPrivate * priv;
};

struct _RygelGstTranscoderClass {
	GObjectClass parent_class;
	RygelMediaResource* (*get_resource_for_item) (RygelGstTranscoder* self, RygelMediaFileItem* item);
	guint (*get_distance) (RygelGstTranscoder* self, RygelMediaFileItem* item);
	GstEncodingProfile* (*get_encoding_profile) (RygelGstTranscoder* self, RygelMediaFileItem* item);
};

struct _RygelGstTranscoderPrivate {
	gchar* _name;
	gchar* _mime_type;
	gchar* _dlna_profile;
	gchar* _extension;
	gchar* _preset;
};

static gint RygelGstTranscoder_private_offset;
static gpointer rygel_gst_transcoder_parent_class = NULL;

VALA_EXTERN GType rygel_gst_transcoder_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RygelMediaResource* rygel_gst_transcoder_get_resource_for_item (RygelGstTranscoder* self,
                                                                RygelMediaFileItem* item);
VALA_EXTERN guint rygel_gst_transcoder_get_distance (RygelGstTranscoder* self,
                                         RygelMediaFileItem* item);
VALA_EXTERN GstEncodingProfile* rygel_gst_transcoder_get_encoding_profile (RygelGstTranscoder* self,
                                                               RygelMediaFileItem* item);
VALA_EXTERN RygelGstTranscoder* rygel_gst_transcoder_construct (GType object_type,
                                                    const gchar* name,
                                                    const gchar* mime_type,
                                                    const gchar* dlna_profile,
                                                    const gchar* extension);
static void rygel_gst_transcoder_real_constructed (GObject* base);
static RygelMediaResource* rygel_gst_transcoder_real_get_resource_for_item (RygelGstTranscoder* self,
                                                                     RygelMediaFileItem* item);
VALA_EXTERN const gchar* rygel_gst_transcoder_get_name (RygelGstTranscoder* self);
VALA_EXTERN const gchar* rygel_gst_transcoder_get_mime_type (RygelGstTranscoder* self);
VALA_EXTERN const gchar* rygel_gst_transcoder_get_dlna_profile (RygelGstTranscoder* self);
VALA_EXTERN const gchar* rygel_gst_transcoder_get_extension (RygelGstTranscoder* self);
static guint rygel_gst_transcoder_real_get_distance (RygelGstTranscoder* self,
                                              RygelMediaFileItem* item);
VALA_EXTERN GType rygel_gst_data_source_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RygelGstDataSource* rygel_gst_transcoder_create_source (RygelGstTranscoder* self,
                                                        RygelMediaFileItem* item,
                                                        RygelDataSource* src,
                                                        GError** error);
VALA_EXTERN GType rygel_transcoding_gst_data_source_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RygelTranscodingGstDataSource* rygel_transcoding_gst_data_source_new (RygelDataSource* src,
                                                                      GstEncodingProfile* profile,
                                                                      GError** error);
VALA_EXTERN RygelTranscodingGstDataSource* rygel_transcoding_gst_data_source_construct (GType object_type,
                                                                            RygelDataSource* src,
                                                                            GstEncodingProfile* profile,
                                                                            GError** error);
static GstEncodingProfile* rygel_gst_transcoder_real_get_encoding_profile (RygelGstTranscoder* self,
                                                                    RygelMediaFileItem* item);
VALA_EXTERN gboolean rygel_gst_transcoder_transcoding_necessary (RygelGstTranscoder* self,
                                                     RygelMediaFileItem* item);
VALA_EXTERN gboolean rygel_gst_transcoder_mime_type_is_a (RygelGstTranscoder* self,
                                              const gchar* mime_type1,
                                              const gchar* mime_type2);
static void rygel_gst_transcoder_set_name (RygelGstTranscoder* self,
                                    const gchar* value);
static void rygel_gst_transcoder_set_mime_type (RygelGstTranscoder* self,
                                         const gchar* value);
static void rygel_gst_transcoder_set_dlna_profile (RygelGstTranscoder* self,
                                            const gchar* value);
static void rygel_gst_transcoder_set_extension (RygelGstTranscoder* self,
                                         const gchar* value);
VALA_EXTERN const gchar* rygel_gst_transcoder_get_preset (RygelGstTranscoder* self);
VALA_EXTERN void rygel_gst_transcoder_set_preset (RygelGstTranscoder* self,
                                      const gchar* value);
static void rygel_gst_transcoder_finalize (GObject * obj);
static GType rygel_gst_transcoder_get_type_once (void);
static void _vala_rygel_gst_transcoder_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_rygel_gst_transcoder_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);

GQuark
rygel_gst_transcoder_error_quark (void)
{
	return g_quark_from_static_string ("rygel-gst-transcoder-error-quark");
}

 G_GNUC_NO_INLINE static GType
rygel_gst_transcoder_error_get_type_once (void)
{
	static const GEnumValue values[] = {{RYGEL_GST_TRANSCODER_ERROR_CANT_TRANSCODE, "RYGEL_GST_TRANSCODER_ERROR_CANT_TRANSCODE", "cant-transcode"}, {0, NULL, NULL}};
	GType rygel_gst_transcoder_error_type_id;
	rygel_gst_transcoder_error_type_id = g_enum_register_static ("RygelGstTranscoderError", values);
	return rygel_gst_transcoder_error_type_id;
}

GType
rygel_gst_transcoder_error_get_type (void)
{
	static volatile gsize rygel_gst_transcoder_error_type_id__once = 0;
	if (g_once_init_enter (&rygel_gst_transcoder_error_type_id__once)) {
		GType rygel_gst_transcoder_error_type_id;
		rygel_gst_transcoder_error_type_id = rygel_gst_transcoder_error_get_type_once ();
		g_once_init_leave (&rygel_gst_transcoder_error_type_id__once, rygel_gst_transcoder_error_type_id);
	}
	return rygel_gst_transcoder_error_type_id__once;
}

static inline gpointer
rygel_gst_transcoder_get_instance_private (RygelGstTranscoder* self)
{
	return G_STRUCT_MEMBER_P (self, RygelGstTranscoder_private_offset);
}

RygelGstTranscoder*
rygel_gst_transcoder_construct (GType object_type,
                                const gchar* name,
                                const gchar* mime_type,
                                const gchar* dlna_profile,
                                const gchar* extension)
{
	RygelGstTranscoder * self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (mime_type != NULL, NULL);
	g_return_val_if_fail (dlna_profile != NULL, NULL);
	g_return_val_if_fail (extension != NULL, NULL);
	self = (RygelGstTranscoder*) g_object_new (object_type, "name", name, "mime-type", mime_type, "dlna-profile", dlna_profile, "extension", extension, NULL);
	return self;
}

static void
rygel_gst_transcoder_real_constructed (GObject* base)
{
	RygelGstTranscoder * self;
	self = (RygelGstTranscoder*) base;
	G_OBJECT_CLASS (rygel_gst_transcoder_parent_class)->constructed (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
}

/**
     * Get the supported (transcoded) MediaResource for the given content item
     *
     * @return A MediaResources or null if the transcoder cannot
     * transcode this media item
     */
static RygelMediaResource*
rygel_gst_transcoder_real_get_resource_for_item (RygelGstTranscoder* self,
                                                 RygelMediaFileItem* item)
{
	RygelMediaResource* res = NULL;
	const gchar* _tmp0_;
	RygelMediaResource* _tmp1_;
	RygelMediaResource* _tmp2_;
	const gchar* _tmp3_;
	RygelMediaResource* _tmp4_;
	const gchar* _tmp5_;
	RygelMediaResource* _tmp6_;
	const gchar* _tmp7_;
	RygelMediaResource* _tmp8_;
	RygelMediaResource* _tmp9_;
	RygelMediaResource* _tmp10_;
	RygelMediaResource* result;
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = self->priv->_name;
	_tmp1_ = rygel_media_resource_new (_tmp0_);
	res = _tmp1_;
	_tmp2_ = res;
	_tmp3_ = self->priv->_mime_type;
	rygel_media_resource_set_mime_type (_tmp2_, _tmp3_);
	_tmp4_ = res;
	_tmp5_ = self->priv->_dlna_profile;
	rygel_media_resource_set_dlna_profile (_tmp4_, _tmp5_);
	_tmp6_ = res;
	_tmp7_ = self->priv->_extension;
	rygel_media_resource_set_extension (_tmp6_, _tmp7_);
	_tmp8_ = res;
	rygel_media_resource_set_dlna_conversion (_tmp8_, GUPNP_DLNA_CONVERSION_TRANSCODED);
	_tmp9_ = res;
	rygel_media_resource_set_dlna_flags (_tmp9_, ((GUPNP_DLNA_FLAGS_DLNA_V15 | GUPNP_DLNA_FLAGS_STREAMING_TRANSFER_MODE) | GUPNP_DLNA_FLAGS_BACKGROUND_TRANSFER_MODE) | GUPNP_DLNA_FLAGS_CONNECTION_STALL);
	_tmp10_ = res;
	rygel_media_resource_set_dlna_operation (_tmp10_, GUPNP_DLNA_OPERATION_TIMESEEK);
	if (G_TYPE_CHECK_INSTANCE_TYPE (item, RYGEL_TYPE_AUDIO_ITEM)) {
		RygelMediaResource* _tmp11_;
		glong _tmp12_;
		glong _tmp13_;
		_tmp11_ = res;
		_tmp12_ = rygel_audio_item_get_duration (G_TYPE_CHECK_INSTANCE_CAST (item, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem));
		_tmp13_ = _tmp12_;
		rygel_media_resource_set_duration (_tmp11_, _tmp13_);
	}
	result = res;
	return result;
}

RygelMediaResource*
rygel_gst_transcoder_get_resource_for_item (RygelGstTranscoder* self,
                                            RygelMediaFileItem* item)
{
	RygelGstTranscoderClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = RYGEL_GST_TRANSCODER_GET_CLASS (self);
	if (_klass_->get_resource_for_item) {
		return _klass_->get_resource_for_item (self, item);
	}
	return NULL;
}

/**
     * Gets a numeric value that gives an gives an estimate of how hard
     * it would be for this transcoder to trancode @item to the target profile of
     * this transcoder.
     *
     * @param item the media item to calculate the distance for
     *
     * @return      the distance from the @item, uint.MIN if providing such a
     *              value is impossible or uint.MAX if it doesn't make any
     *              sense to use this transcoder for @item
     */
static guint
rygel_gst_transcoder_real_get_distance (RygelGstTranscoder* self,
                                        RygelMediaFileItem* item)
{
	guint _tmp0_ = 0U;
	g_critical ("Type `%s' does not implement abstract method `rygel_gst_transcoder_get_distance'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

guint
rygel_gst_transcoder_get_distance (RygelGstTranscoder* self,
                                   RygelMediaFileItem* item)
{
	RygelGstTranscoderClass* _klass_;
	g_return_val_if_fail (self != NULL, 0U);
	_klass_ = RYGEL_GST_TRANSCODER_GET_CLASS (self);
	if (_klass_->get_distance) {
		return _klass_->get_distance (self, item);
	}
	return 0U;
}

/**
     * Creates a transcoding source.
     *
     * @param src the media item to create the transcoding source for
     * @param src the original (non-transcoding) source
     *
     * @return      the new transcoding source
     */
RygelGstDataSource*
rygel_gst_transcoder_create_source (RygelGstTranscoder* self,
                                    RygelMediaFileItem* item,
                                    RygelDataSource* src,
                                    GError** error)
{
	RygelTranscodingGstDataSource* _tmp0_ = NULL;
	GstEncodingProfile* _tmp1_;
	GstEncodingProfile* _tmp2_;
	RygelTranscodingGstDataSource* _tmp3_;
	RygelTranscodingGstDataSource* _tmp4_;
	RygelTranscodingGstDataSource* _tmp5_;
	GError* _inner_error0_ = NULL;
	RygelGstDataSource* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	g_return_val_if_fail (src != NULL, NULL);
	_vala_assert (RYGEL_IS_GST_DATA_SOURCE (src), "src is GstDataSource");
	_tmp1_ = rygel_gst_transcoder_get_encoding_profile (self, item);
	_tmp2_ = _tmp1_;
	_tmp3_ = rygel_transcoding_gst_data_source_new (src, _tmp2_, &_inner_error0_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	_tmp0_ = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp5_ = _tmp0_;
	_tmp0_ = NULL;
	result = (RygelGstDataSource*) _tmp5_;
	_g_object_unref0 (_tmp0_);
	return result;
}

/**
     * Gets the Gst.EncodingProfile for this transcoder.
     *
     * @return      the Gst.EncodingProfile for this transcoder.
     */
static GstEncodingProfile*
rygel_gst_transcoder_real_get_encoding_profile (RygelGstTranscoder* self,
                                                RygelMediaFileItem* item)
{
	g_critical ("Type `%s' does not implement abstract method `rygel_gst_transcoder_get_encoding_profile'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GstEncodingProfile*
rygel_gst_transcoder_get_encoding_profile (RygelGstTranscoder* self,
                                           RygelMediaFileItem* item)
{
	RygelGstTranscoderClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = RYGEL_GST_TRANSCODER_GET_CLASS (self);
	if (_klass_->get_encoding_profile) {
		return _klass_->get_encoding_profile (self, item);
	}
	return NULL;
}

gboolean
rygel_gst_transcoder_transcoding_necessary (RygelGstTranscoder* self,
                                            RygelMediaFileItem* item)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (item != NULL, FALSE);
	_tmp1_ = self->priv->_mime_type;
	_tmp2_ = rygel_media_file_item_get_mime_type (item);
	_tmp3_ = _tmp2_;
	if (rygel_gst_transcoder_mime_type_is_a (self, _tmp1_, _tmp3_)) {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = self->priv->_dlna_profile;
		_tmp5_ = rygel_media_file_item_get_dlna_profile (item);
		_tmp6_ = _tmp5_;
		_tmp0_ = g_strcmp0 (_tmp4_, _tmp6_) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = !_tmp0_;
	return result;
}

gboolean
rygel_gst_transcoder_mime_type_is_a (RygelGstTranscoder* self,
                                     const gchar* mime_type1,
                                     const gchar* mime_type2)
{
	gchar* content_type1 = NULL;
	gchar* _tmp0_;
	gchar* content_type2 = NULL;
	gchar* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (mime_type1 != NULL, FALSE);
	g_return_val_if_fail (mime_type2 != NULL, FALSE);
	_tmp0_ = g_content_type_get_mime_type (mime_type1);
	content_type1 = _tmp0_;
	_tmp1_ = g_content_type_get_mime_type (mime_type2);
	content_type2 = _tmp1_;
	result = g_content_type_is_a (content_type1, content_type2);
	_g_free0 (content_type2);
	_g_free0 (content_type1);
	return result;
}

const gchar*
rygel_gst_transcoder_get_name (RygelGstTranscoder* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
rygel_gst_transcoder_set_name (RygelGstTranscoder* self,
                               const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_gst_transcoder_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_gst_transcoder_properties[RYGEL_GST_TRANSCODER_NAME_PROPERTY]);
	}
}

const gchar*
rygel_gst_transcoder_get_mime_type (RygelGstTranscoder* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_mime_type;
	result = _tmp0_;
	return result;
}

static void
rygel_gst_transcoder_set_mime_type (RygelGstTranscoder* self,
                                    const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_gst_transcoder_get_mime_type (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_mime_type);
		self->priv->_mime_type = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_gst_transcoder_properties[RYGEL_GST_TRANSCODER_MIME_TYPE_PROPERTY]);
	}
}

const gchar*
rygel_gst_transcoder_get_dlna_profile (RygelGstTranscoder* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_dlna_profile;
	result = _tmp0_;
	return result;
}

static void
rygel_gst_transcoder_set_dlna_profile (RygelGstTranscoder* self,
                                       const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_gst_transcoder_get_dlna_profile (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_dlna_profile);
		self->priv->_dlna_profile = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_gst_transcoder_properties[RYGEL_GST_TRANSCODER_DLNA_PROFILE_PROPERTY]);
	}
}

const gchar*
rygel_gst_transcoder_get_extension (RygelGstTranscoder* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_extension;
	result = _tmp0_;
	return result;
}

static void
rygel_gst_transcoder_set_extension (RygelGstTranscoder* self,
                                    const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_gst_transcoder_get_extension (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_extension);
		self->priv->_extension = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_gst_transcoder_properties[RYGEL_GST_TRANSCODER_EXTENSION_PROPERTY]);
	}
}

const gchar*
rygel_gst_transcoder_get_preset (RygelGstTranscoder* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_preset;
	result = _tmp0_;
	return result;
}

void
rygel_gst_transcoder_set_preset (RygelGstTranscoder* self,
                                 const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_gst_transcoder_get_preset (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_preset);
		self->priv->_preset = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_gst_transcoder_properties[RYGEL_GST_TRANSCODER_PRESET_PROPERTY]);
	}
}

static void
rygel_gst_transcoder_class_init (RygelGstTranscoderClass * klass,
                                 gpointer klass_data)
{
	rygel_gst_transcoder_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelGstTranscoder_private_offset);
	((GObjectClass *) klass)->constructed = (void (*) (GObject*)) rygel_gst_transcoder_real_constructed;
	((RygelGstTranscoderClass *) klass)->get_resource_for_item = (RygelMediaResource* (*) (RygelGstTranscoder*, RygelMediaFileItem*)) rygel_gst_transcoder_real_get_resource_for_item;
	((RygelGstTranscoderClass *) klass)->get_distance = (guint (*) (RygelGstTranscoder*, RygelMediaFileItem*)) rygel_gst_transcoder_real_get_distance;
	((RygelGstTranscoderClass *) klass)->get_encoding_profile = (GstEncodingProfile* (*) (RygelGstTranscoder*, RygelMediaFileItem*)) rygel_gst_transcoder_real_get_encoding_profile;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_gst_transcoder_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_gst_transcoder_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_gst_transcoder_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_GST_TRANSCODER_NAME_PROPERTY, rygel_gst_transcoder_properties[RYGEL_GST_TRANSCODER_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_GST_TRANSCODER_MIME_TYPE_PROPERTY, rygel_gst_transcoder_properties[RYGEL_GST_TRANSCODER_MIME_TYPE_PROPERTY] = g_param_spec_string ("mime-type", "mime-type", "mime-type", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_GST_TRANSCODER_DLNA_PROFILE_PROPERTY, rygel_gst_transcoder_properties[RYGEL_GST_TRANSCODER_DLNA_PROFILE_PROPERTY] = g_param_spec_string ("dlna-profile", "dlna-profile", "dlna-profile", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_GST_TRANSCODER_EXTENSION_PROPERTY, rygel_gst_transcoder_properties[RYGEL_GST_TRANSCODER_EXTENSION_PROPERTY] = g_param_spec_string ("extension", "extension", "extension", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_GST_TRANSCODER_PRESET_PROPERTY, rygel_gst_transcoder_properties[RYGEL_GST_TRANSCODER_PRESET_PROPERTY] = g_param_spec_string ("preset", "preset", "preset", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
rygel_gst_transcoder_instance_init (RygelGstTranscoder * self,
                                    gpointer klass)
{
	gchar* _tmp0_;
	self->priv = rygel_gst_transcoder_get_instance_private (self);
	_tmp0_ = g_strdup (RYGEL_GST_TRANSCODER_DEFAULT_ENCODING_PRESET);
	self->priv->_preset = _tmp0_;
}

static void
rygel_gst_transcoder_finalize (GObject * obj)
{
	RygelGstTranscoder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoder);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_mime_type);
	_g_free0 (self->priv->_dlna_profile);
	_g_free0 (self->priv->_extension);
	_g_free0 (self->priv->_preset);
	G_OBJECT_CLASS (rygel_gst_transcoder_parent_class)->finalize (obj);
}

/**
 * The base Transcoder class used by gstreamer media engine.
 * Each implementation derives from it and must
 * implement get_resources_for_item and get_encoding_profile methods.
 */
 G_GNUC_NO_INLINE static GType
rygel_gst_transcoder_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelGstTranscoderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_gst_transcoder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelGstTranscoder), 0, (GInstanceInitFunc) rygel_gst_transcoder_instance_init, NULL };
	GType rygel_gst_transcoder_type_id;
	rygel_gst_transcoder_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelGstTranscoder", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	RygelGstTranscoder_private_offset = g_type_add_instance_private (rygel_gst_transcoder_type_id, sizeof (RygelGstTranscoderPrivate));
	return rygel_gst_transcoder_type_id;
}

GType
rygel_gst_transcoder_get_type (void)
{
	static volatile gsize rygel_gst_transcoder_type_id__once = 0;
	if (g_once_init_enter (&rygel_gst_transcoder_type_id__once)) {
		GType rygel_gst_transcoder_type_id;
		rygel_gst_transcoder_type_id = rygel_gst_transcoder_get_type_once ();
		g_once_init_leave (&rygel_gst_transcoder_type_id__once, rygel_gst_transcoder_type_id);
	}
	return rygel_gst_transcoder_type_id__once;
}

static void
_vala_rygel_gst_transcoder_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	RygelGstTranscoder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoder);
	switch (property_id) {
		case RYGEL_GST_TRANSCODER_NAME_PROPERTY:
		g_value_set_string (value, rygel_gst_transcoder_get_name (self));
		break;
		case RYGEL_GST_TRANSCODER_MIME_TYPE_PROPERTY:
		g_value_set_string (value, rygel_gst_transcoder_get_mime_type (self));
		break;
		case RYGEL_GST_TRANSCODER_DLNA_PROFILE_PROPERTY:
		g_value_set_string (value, rygel_gst_transcoder_get_dlna_profile (self));
		break;
		case RYGEL_GST_TRANSCODER_EXTENSION_PROPERTY:
		g_value_set_string (value, rygel_gst_transcoder_get_extension (self));
		break;
		case RYGEL_GST_TRANSCODER_PRESET_PROPERTY:
		g_value_set_string (value, rygel_gst_transcoder_get_preset (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_gst_transcoder_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	RygelGstTranscoder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoder);
	switch (property_id) {
		case RYGEL_GST_TRANSCODER_NAME_PROPERTY:
		rygel_gst_transcoder_set_name (self, g_value_get_string (value));
		break;
		case RYGEL_GST_TRANSCODER_MIME_TYPE_PROPERTY:
		rygel_gst_transcoder_set_mime_type (self, g_value_get_string (value));
		break;
		case RYGEL_GST_TRANSCODER_DLNA_PROFILE_PROPERTY:
		rygel_gst_transcoder_set_dlna_profile (self, g_value_get_string (value));
		break;
		case RYGEL_GST_TRANSCODER_EXTENSION_PROPERTY:
		rygel_gst_transcoder_set_extension (self, g_value_get_string (value));
		break;
		case RYGEL_GST_TRANSCODER_PRESET_PROPERTY:
		rygel_gst_transcoder_set_preset (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

