/* s3 compat server functions auto-generated by pidl */
#include "bin/default/librpc/gen_ndr/ndr_eventlog.h"
#include "bin/default/librpc/gen_ndr/ndr_eventlog_scompat.h"
#include <librpc/rpc/dcesrv_core.h>
#include <rpc_server/rpc_config.h>
#include <rpc_server/rpc_server.h>
#include <util/debug.h>

enum s3compat_rpc_dispatch {
	S3COMPAT_RPC_DISPATCH_EXTERNAL = 0x00000001,
	S3COMPAT_RPC_DISPATCH_INTERNAL = 0x00000002,
};

/* eventlog - dcerpc server boilerplate generated by pidl */
static NTSTATUS eventlog__op_bind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_EVENTLOG_BIND
	return DCESRV_INTERFACE_EVENTLOG_BIND(context,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void eventlog__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_EVENTLOG_UNBIND
	DCESRV_INTERFACE_EVENTLOG_UNBIND(context, iface);
#else
	return;
#endif
}

NTSTATUS eventlog__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= ndr_table_eventlog.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_named(mem_ctx, ndr_table_eventlog.calls[opnum].struct_size, "struct %s", ndr_table_eventlog.calls[opnum].name);
	NT_STATUS_HAVE_NO_MEMORY(*r);

	/* unravel the NDR for the packet */
	ndr_err = ndr_table_eventlog.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS eventlog__op_dispatch_internal(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r, enum s3compat_rpc_dispatch dispatch)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;
	struct pipes_struct *p = NULL;
	NTSTATUS status = NT_STATUS_OK;
	bool impersonated = false;

	/* Retrieve pipes struct */
	p = dcesrv_get_pipes_struct(dce_call->conn);
	p->dce_call = dce_call;
	p->mem_ctx = mem_ctx;
	/* Reset pipes struct fault state */
	p->fault_state = 0;

	/* Impersonate */
	if (dispatch == S3COMPAT_RPC_DISPATCH_EXTERNAL) {
		impersonated = become_authenticated_pipe_user(dce_call->auth_state->session_info);
		if (!impersonated) {
			dce_call->fault_code = DCERPC_FAULT_ACCESS_DENIED;
			status = NT_STATUS_NET_WRITE_FAULT;
			goto fail;
		}
	}

	switch (opnum) {
	case 0: { /* eventlog_ClearEventLogW */
		struct eventlog_ClearEventLogW *r2 = (struct eventlog_ClearEventLogW *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_ClearEventLogW, NDR_IN, r2);
		}
		r2->out.result = _eventlog_ClearEventLogW(p, r2);
		break;
	}
	case 1: { /* eventlog_BackupEventLogW */
		struct eventlog_BackupEventLogW *r2 = (struct eventlog_BackupEventLogW *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_BackupEventLogW, NDR_IN, r2);
		}
		r2->out.result = _eventlog_BackupEventLogW(p, r2);
		break;
	}
	case 2: { /* eventlog_CloseEventLog */
		struct eventlog_CloseEventLog *r2 = (struct eventlog_CloseEventLog *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_CloseEventLog, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.handle = r2->in.handle;
		r2->out.result = _eventlog_CloseEventLog(p, r2);
		break;
	}
	case 3: { /* eventlog_DeregisterEventSource */
		struct eventlog_DeregisterEventSource *r2 = (struct eventlog_DeregisterEventSource *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_DeregisterEventSource, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.handle = r2->in.handle;
		r2->out.result = _eventlog_DeregisterEventSource(p, r2);
		break;
	}
	case 4: { /* eventlog_GetNumRecords */
		struct eventlog_GetNumRecords *r2 = (struct eventlog_GetNumRecords *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_GetNumRecords, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.number = talloc_zero(r2, uint32_t);
		if (r2->out.number == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _eventlog_GetNumRecords(p, r2);
		break;
	}
	case 5: { /* eventlog_GetOldestRecord */
		struct eventlog_GetOldestRecord *r2 = (struct eventlog_GetOldestRecord *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_GetOldestRecord, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.oldest_entry = talloc_zero(r2, uint32_t);
		if (r2->out.oldest_entry == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _eventlog_GetOldestRecord(p, r2);
		break;
	}
	case 6: { /* eventlog_ChangeNotify */
		struct eventlog_ChangeNotify *r2 = (struct eventlog_ChangeNotify *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_ChangeNotify, NDR_IN, r2);
		}
		r2->out.result = _eventlog_ChangeNotify(p, r2);
		break;
	}
	case 7: { /* eventlog_OpenEventLogW */
		struct eventlog_OpenEventLogW *r2 = (struct eventlog_OpenEventLogW *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_OpenEventLogW, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.handle = talloc_zero(r2, struct policy_handle);
		if (r2->out.handle == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _eventlog_OpenEventLogW(p, r2);
		break;
	}
	case 8: { /* eventlog_RegisterEventSourceW */
		struct eventlog_RegisterEventSourceW *r2 = (struct eventlog_RegisterEventSourceW *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_RegisterEventSourceW, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.log_handle = talloc_zero(r2, struct policy_handle);
		if (r2->out.log_handle == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _eventlog_RegisterEventSourceW(p, r2);
		break;
	}
	case 9: { /* eventlog_OpenBackupEventLogW */
		struct eventlog_OpenBackupEventLogW *r2 = (struct eventlog_OpenBackupEventLogW *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_OpenBackupEventLogW, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.handle = talloc_zero(r2, struct policy_handle);
		if (r2->out.handle == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _eventlog_OpenBackupEventLogW(p, r2);
		break;
	}
	case 10: { /* eventlog_ReadEventLogW */
		struct eventlog_ReadEventLogW *r2 = (struct eventlog_ReadEventLogW *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_ReadEventLogW, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.data = talloc_zero_array(r2, uint8_t, r2->in.number_of_bytes);
		if (r2->out.data == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.sent_size = talloc_zero(r2, uint32_t);
		if (r2->out.sent_size == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.real_size = talloc_zero(r2, uint32_t);
		if (r2->out.real_size == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _eventlog_ReadEventLogW(p, r2);
		break;
	}
	case 11: { /* eventlog_ReportEventW */
		struct eventlog_ReportEventW *r2 = (struct eventlog_ReportEventW *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_ReportEventW, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.record_number = r2->in.record_number;
		r2->out.time_written = r2->in.time_written;
		r2->out.result = _eventlog_ReportEventW(p, r2);
		break;
	}
	case 12: { /* eventlog_ClearEventLogA */
		struct eventlog_ClearEventLogA *r2 = (struct eventlog_ClearEventLogA *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_ClearEventLogA, NDR_IN, r2);
		}
		r2->out.result = _eventlog_ClearEventLogA(p, r2);
		break;
	}
	case 13: { /* eventlog_BackupEventLogA */
		struct eventlog_BackupEventLogA *r2 = (struct eventlog_BackupEventLogA *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_BackupEventLogA, NDR_IN, r2);
		}
		r2->out.result = _eventlog_BackupEventLogA(p, r2);
		break;
	}
	case 14: { /* eventlog_OpenEventLogA */
		struct eventlog_OpenEventLogA *r2 = (struct eventlog_OpenEventLogA *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_OpenEventLogA, NDR_IN, r2);
		}
		r2->out.result = _eventlog_OpenEventLogA(p, r2);
		break;
	}
	case 15: { /* eventlog_RegisterEventSourceA */
		struct eventlog_RegisterEventSourceA *r2 = (struct eventlog_RegisterEventSourceA *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_RegisterEventSourceA, NDR_IN, r2);
		}
		r2->out.result = _eventlog_RegisterEventSourceA(p, r2);
		break;
	}
	case 16: { /* eventlog_OpenBackupEventLogA */
		struct eventlog_OpenBackupEventLogA *r2 = (struct eventlog_OpenBackupEventLogA *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_OpenBackupEventLogA, NDR_IN, r2);
		}
		r2->out.result = _eventlog_OpenBackupEventLogA(p, r2);
		break;
	}
	case 17: { /* eventlog_ReadEventLogA */
		struct eventlog_ReadEventLogA *r2 = (struct eventlog_ReadEventLogA *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_ReadEventLogA, NDR_IN, r2);
		}
		r2->out.result = _eventlog_ReadEventLogA(p, r2);
		break;
	}
	case 18: { /* eventlog_ReportEventA */
		struct eventlog_ReportEventA *r2 = (struct eventlog_ReportEventA *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_ReportEventA, NDR_IN, r2);
		}
		r2->out.result = _eventlog_ReportEventA(p, r2);
		break;
	}
	case 19: { /* eventlog_RegisterClusterSvc */
		struct eventlog_RegisterClusterSvc *r2 = (struct eventlog_RegisterClusterSvc *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_RegisterClusterSvc, NDR_IN, r2);
		}
		r2->out.result = _eventlog_RegisterClusterSvc(p, r2);
		break;
	}
	case 20: { /* eventlog_DeregisterClusterSvc */
		struct eventlog_DeregisterClusterSvc *r2 = (struct eventlog_DeregisterClusterSvc *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_DeregisterClusterSvc, NDR_IN, r2);
		}
		r2->out.result = _eventlog_DeregisterClusterSvc(p, r2);
		break;
	}
	case 21: { /* eventlog_WriteClusterEvents */
		struct eventlog_WriteClusterEvents *r2 = (struct eventlog_WriteClusterEvents *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_WriteClusterEvents, NDR_IN, r2);
		}
		r2->out.result = _eventlog_WriteClusterEvents(p, r2);
		break;
	}
	case 22: { /* eventlog_GetLogInformation */
		struct eventlog_GetLogInformation *r2 = (struct eventlog_GetLogInformation *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_GetLogInformation, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.buffer = talloc_zero_array(r2, uint8_t, r2->in.buf_size);
		if (r2->out.buffer == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.bytes_needed = talloc_zero(r2, uint32_t);
		if (r2->out.bytes_needed == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _eventlog_GetLogInformation(p, r2);
		break;
	}
	case 23: { /* eventlog_FlushEventLog */
		struct eventlog_FlushEventLog *r2 = (struct eventlog_FlushEventLog *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_FlushEventLog, NDR_IN, r2);
		}
		r2->out.result = _eventlog_FlushEventLog(p, r2);
		break;
	}
	case 24: { /* eventlog_ReportEventAndSourceW */
		struct eventlog_ReportEventAndSourceW *r2 = (struct eventlog_ReportEventAndSourceW *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_ReportEventAndSourceW, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.record_number = r2->in.record_number;
		r2->out.time_written = r2->in.time_written;
		r2->out.result = _eventlog_ReportEventAndSourceW(p, r2);
		break;
	}
	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

fail:
	/* Unimpersonate */
	if (impersonated) {
		unbecome_authenticated_pipe_user();
	}

	p->dce_call = NULL;
	p->mem_ctx = NULL;
	/* Check pipes struct fault state */
	if (p->fault_state != 0) {
		dce_call->fault_code = p->fault_state;
	}
	if (dce_call->fault_code != 0) {
		status = NT_STATUS_NET_WRITE_FAULT;
	}

	return status;
}

NTSTATUS eventlog__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	return eventlog__op_dispatch_internal(dce_call, mem_ctx, r, S3COMPAT_RPC_DISPATCH_EXTERNAL);
}

NTSTATUS eventlog__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: { /* eventlog_ClearEventLogW */
		struct eventlog_ClearEventLogW *r2 = (struct eventlog_ClearEventLogW *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog_ClearEventLogW replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_ClearEventLogW, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in eventlog_ClearEventLogW\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 1: { /* eventlog_BackupEventLogW */
		struct eventlog_BackupEventLogW *r2 = (struct eventlog_BackupEventLogW *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog_BackupEventLogW replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_BackupEventLogW, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in eventlog_BackupEventLogW\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 2: { /* eventlog_CloseEventLog */
		struct eventlog_CloseEventLog *r2 = (struct eventlog_CloseEventLog *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog_CloseEventLog replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_CloseEventLog, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in eventlog_CloseEventLog\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 3: { /* eventlog_DeregisterEventSource */
		struct eventlog_DeregisterEventSource *r2 = (struct eventlog_DeregisterEventSource *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog_DeregisterEventSource replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_DeregisterEventSource, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in eventlog_DeregisterEventSource\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 4: { /* eventlog_GetNumRecords */
		struct eventlog_GetNumRecords *r2 = (struct eventlog_GetNumRecords *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog_GetNumRecords replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_GetNumRecords, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in eventlog_GetNumRecords\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 5: { /* eventlog_GetOldestRecord */
		struct eventlog_GetOldestRecord *r2 = (struct eventlog_GetOldestRecord *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog_GetOldestRecord replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_GetOldestRecord, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in eventlog_GetOldestRecord\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 6: { /* eventlog_ChangeNotify */
		struct eventlog_ChangeNotify *r2 = (struct eventlog_ChangeNotify *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog_ChangeNotify replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_ChangeNotify, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in eventlog_ChangeNotify\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 7: { /* eventlog_OpenEventLogW */
		struct eventlog_OpenEventLogW *r2 = (struct eventlog_OpenEventLogW *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog_OpenEventLogW replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_OpenEventLogW, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in eventlog_OpenEventLogW\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 8: { /* eventlog_RegisterEventSourceW */
		struct eventlog_RegisterEventSourceW *r2 = (struct eventlog_RegisterEventSourceW *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog_RegisterEventSourceW replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_RegisterEventSourceW, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in eventlog_RegisterEventSourceW\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 9: { /* eventlog_OpenBackupEventLogW */
		struct eventlog_OpenBackupEventLogW *r2 = (struct eventlog_OpenBackupEventLogW *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog_OpenBackupEventLogW replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_OpenBackupEventLogW, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in eventlog_OpenBackupEventLogW\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 10: { /* eventlog_ReadEventLogW */
		struct eventlog_ReadEventLogW *r2 = (struct eventlog_ReadEventLogW *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog_ReadEventLogW replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_ReadEventLogW, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in eventlog_ReadEventLogW\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 11: { /* eventlog_ReportEventW */
		struct eventlog_ReportEventW *r2 = (struct eventlog_ReportEventW *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog_ReportEventW replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_ReportEventW, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in eventlog_ReportEventW\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 12: { /* eventlog_ClearEventLogA */
		struct eventlog_ClearEventLogA *r2 = (struct eventlog_ClearEventLogA *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog_ClearEventLogA replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_ClearEventLogA, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in eventlog_ClearEventLogA\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 13: { /* eventlog_BackupEventLogA */
		struct eventlog_BackupEventLogA *r2 = (struct eventlog_BackupEventLogA *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog_BackupEventLogA replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_BackupEventLogA, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in eventlog_BackupEventLogA\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 14: { /* eventlog_OpenEventLogA */
		struct eventlog_OpenEventLogA *r2 = (struct eventlog_OpenEventLogA *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog_OpenEventLogA replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_OpenEventLogA, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in eventlog_OpenEventLogA\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 15: { /* eventlog_RegisterEventSourceA */
		struct eventlog_RegisterEventSourceA *r2 = (struct eventlog_RegisterEventSourceA *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog_RegisterEventSourceA replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_RegisterEventSourceA, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in eventlog_RegisterEventSourceA\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 16: { /* eventlog_OpenBackupEventLogA */
		struct eventlog_OpenBackupEventLogA *r2 = (struct eventlog_OpenBackupEventLogA *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog_OpenBackupEventLogA replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_OpenBackupEventLogA, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in eventlog_OpenBackupEventLogA\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 17: { /* eventlog_ReadEventLogA */
		struct eventlog_ReadEventLogA *r2 = (struct eventlog_ReadEventLogA *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog_ReadEventLogA replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_ReadEventLogA, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in eventlog_ReadEventLogA\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 18: { /* eventlog_ReportEventA */
		struct eventlog_ReportEventA *r2 = (struct eventlog_ReportEventA *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog_ReportEventA replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_ReportEventA, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in eventlog_ReportEventA\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 19: { /* eventlog_RegisterClusterSvc */
		struct eventlog_RegisterClusterSvc *r2 = (struct eventlog_RegisterClusterSvc *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog_RegisterClusterSvc replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_RegisterClusterSvc, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in eventlog_RegisterClusterSvc\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 20: { /* eventlog_DeregisterClusterSvc */
		struct eventlog_DeregisterClusterSvc *r2 = (struct eventlog_DeregisterClusterSvc *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog_DeregisterClusterSvc replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_DeregisterClusterSvc, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in eventlog_DeregisterClusterSvc\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 21: { /* eventlog_WriteClusterEvents */
		struct eventlog_WriteClusterEvents *r2 = (struct eventlog_WriteClusterEvents *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog_WriteClusterEvents replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_WriteClusterEvents, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in eventlog_WriteClusterEvents\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 22: { /* eventlog_GetLogInformation */
		struct eventlog_GetLogInformation *r2 = (struct eventlog_GetLogInformation *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog_GetLogInformation replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_GetLogInformation, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in eventlog_GetLogInformation\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 23: { /* eventlog_FlushEventLog */
		struct eventlog_FlushEventLog *r2 = (struct eventlog_FlushEventLog *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog_FlushEventLog replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_FlushEventLog, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in eventlog_FlushEventLog\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 24: { /* eventlog_ReportEventAndSourceW */
		struct eventlog_ReportEventAndSourceW *r2 = (struct eventlog_ReportEventAndSourceW *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog_ReportEventAndSourceW replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog_ReportEventAndSourceW, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in eventlog_ReportEventAndSourceW\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

NTSTATUS eventlog__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	ndr_err = ndr_table_eventlog.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

NTSTATUS eventlog__op_local(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	return eventlog__op_dispatch_internal(dce_call, mem_ctx, r, S3COMPAT_RPC_DISPATCH_INTERNAL);
}

static const struct dcesrv_interface dcesrv_eventlog_interface = {
	.name      = "eventlog",
	.syntax_id = {{0x82273fdc,0xe32a,0x18c3,{0x3f,0x78},{0x82,0x79,0x29,0xdc,0x23,0xea}},0.0},
	.bind      = eventlog__op_bind,
	.unbind    = eventlog__op_unbind,
	.ndr_pull  = eventlog__op_ndr_pull,
	.dispatch  = eventlog__op_dispatch,
	.reply     = eventlog__op_reply,
	.ndr_push  = eventlog__op_ndr_push,
	.local     = eventlog__op_local,
#ifdef DCESRV_INTERFACE_EVENTLOG_FLAGS
	.flags     = DCESRV_INTERFACE_EVENTLOG_FLAGS
#else
	.flags     = 0
#endif
};

static NTSTATUS eventlog__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	uint32_t i;
	NTSTATUS ret;

#ifdef DCESRV_INTERFACE_EVENTLOG_NCACN_NP_SECONDARY_ENDPOINT
	const char *ncacn_np_secondary_endpoint = DCESRV_INTERFACE_EVENTLOG_NCACN_NP_SECONDARY_ENDPOINT;
#else
	const char *ncacn_np_secondary_endpoint = NULL;
#endif

	for (i=0;i<ndr_table_eventlog.endpoints->count;i++) {
		const char *name = ndr_table_eventlog.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, ncacn_np_secondary_endpoint, &dcesrv_eventlog_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DBG_ERR("Failed to register endpoint '%s'\n",name);
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static NTSTATUS eventlog__op_shutdown_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	return NT_STATUS_OK;
}

static bool eventlog__op_interface_by_uuid(struct dcesrv_interface *iface, const struct GUID *uuid, uint32_t if_version)
{
	if (dcesrv_eventlog_interface.syntax_id.if_version == if_version && GUID_equal(&dcesrv_eventlog_interface.syntax_id.uuid, uuid)) {
		memcpy(iface,&dcesrv_eventlog_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static bool eventlog__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcesrv_eventlog_interface.name, name)==0) {
		memcpy(iface, &dcesrv_eventlog_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static const struct dcesrv_endpoint_server eventlog_ep_server = {
	/* fill in our name */
	.name = "eventlog",

	/* Initialization flag */
	.initialized = false,

	/* fill in all the operations */
#ifdef DCESRV_INTERFACE_EVENTLOG_INIT_SERVER
	.init_server = DCESRV_INTERFACE_EVENTLOG_INIT_SERVER,
#else
	.init_server = eventlog__op_init_server,
#endif
#ifdef DCESRV_INTERFACE_EVENTLOG_SHUTDOWN_SERVER
	.shutdown_server = DCESRV_INTERFACE_EVENTLOG_SHUTDOWN_SERVER,
#else
	.shutdown_server = eventlog__op_shutdown_server,
#endif
	.interface_by_uuid = eventlog__op_interface_by_uuid,
	.interface_by_name = eventlog__op_interface_by_name
};

const struct dcesrv_endpoint_server *eventlog_get_ep_server(void)
{
	return &eventlog_ep_server;
}
