/* umockdev-ioctl.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from umockdev-ioctl.vala, do not modify */

/**
 * UMockdevIoctlClient:
 *
 * The #UMockdevIoctlClient struct represents an opened client side FD in order
 * to emulate ioctl calls on this device.
 *
 * Since: 0.16
 */
/**
 * UMockdevIoctlClient::handle-ioctl:
 * @client: A #UMockdevIoctlClient
 *
 * Called when an ioctl is requested by the client.
 *
 * This is the per-client signal. See #UMockdevIoctlBase::handle-ioctl on #UMockdevIoctlBase.
 *
 * Since: 0.16
 */
/**
 * UMockdevIoctlClient::handle-read:
 * @client: A #UMockdevIoctlClient
 *
 * Called when a read is requested by the client.
 *
 * This is the per-client signal. See #UMockdevIoctlBase::handle-read on #UMockdevIoctlBase.
 *
 * Since: 0.16
 */
/**
 * UMockdevIoctlBaseClass:
 * @handle_ioctl: Override ioctl emulation
 * @handle_read: Override read emulation
 * @handle_write: Override write_emulation
 * @client_connected: A device was opened
 * @client_vanished: A device was closed
 *
 * The base class for an device ioctl and read/write handling. You can either
 * override the corresponding vfuncs or connect to the signals to customize
 * the emulation.
 *
 * Since: 0.16
 */
/**
 * UMockdevIoctlBase:
 *
 * The #UMockdevIoctlBase class is a base class to emulate and record ioctl
 * operations of a client. It can be attached to an emulated device in the
 * testbed and will then be used.
 *
 * Since: 0.16
 */
/**
 * UMockdevIoctlBase::handle-ioctl:
 * @handler: A #UMockdevIoctlBase
 * @client: A #UMockdevIoctlClient
 *
 * Called when an ioctl is requested by the client.
 *
 * Access the #UMockdevIoctlClient:arg property of @client to retrieve the
 * argument of the ioctl. This is a pointer sized buffer initially with the
 * original argument passed to the ioctl. If this is pointing to a struct, use
 * umockdev_ioctl_data_resolve() to retrieve the underlying memory and update
 * the pointer. Resolve any further pointers in the structure in the same way.
 *
 * After resolving the memory, you can access it as if it was local. The memory
 * will be synced back to the client automatically if it has been modified
 * locally.
 *
 * Once processing is done, use umockdev_ioctl_client_complete() to let the
 * client continue with the result of the emulation. You can also use
 * umockdev_ioctl_client_abort() to kill the client. Note that this handling
 * does not need to be immediate. It is valid to immediately return #TRUE from
 * this function and call umockdev_ioctl_client_complete() at a later point.
 *
 * Note that this function will be called from a worker thread with a private
 * #GMainContext for the #UMockdevTestbed. Do not block this context for longer
 * periods. The complete handler may be called from a different thread.
 *
 * Returns: #TRUE if the request is being handled, #FALSE otherwise.
 * Since: 0.16
 */
/**
 * UMockdevIoctlBase::handle-read:
 * @handler: A #UMockdevIoctlBase
 * @client: A #UMockdevIoctlClient
 *
 * Called when a read is requested by the client.
 *
 * The result buffer is represented by #UMockdevIoctlClient:arg of @client.
 * Retrieve its length to find out the requested read length. The content of
 * the buffer has already been retrieved, and you can freely use and update it.
 *
 * See #UMockdevIoctlBase::handle-ioctl for some more information.
 *
 * Returns: #TRUE if the request is being handled, #FALSE otherwise.
 * Since: 0.16
 */

#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <string.h>
#include <stdlib.h>
#include "ioctl_tree.h"
#include "linux/ioctl.h"
#include <errno.h>
#include <gobject/gvaluecollector.h>
#include <glib/gstdio.h>
#include <gio/gunixsocketaddress.h>
#include <unistd.h>
#include <stdio.h>
#include "cros_ec.h"
#include "linux/usbdevice_fs.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define UMOCKDEV_TYPE_IOCTL_DATA (umockdev_ioctl_data_get_type ())
#define UMOCKDEV_IOCTL_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UMOCKDEV_TYPE_IOCTL_DATA, UMockdevIoctlData))
#define UMOCKDEV_IOCTL_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UMOCKDEV_TYPE_IOCTL_DATA, UMockdevIoctlDataClass))
#define UMOCKDEV_IS_IOCTL_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UMOCKDEV_TYPE_IOCTL_DATA))
#define UMOCKDEV_IS_IOCTL_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UMOCKDEV_TYPE_IOCTL_DATA))
#define UMOCKDEV_IOCTL_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UMOCKDEV_TYPE_IOCTL_DATA, UMockdevIoctlDataClass))

typedef struct _UMockdevIoctlData UMockdevIoctlData;
typedef struct _UMockdevIoctlDataClass UMockdevIoctlDataClass;
typedef struct _UMockdevIoctlDataPrivate UMockdevIoctlDataPrivate;
enum  {
	UMOCKDEV_IOCTL_DATA_0_PROPERTY,
	UMOCKDEV_IOCTL_DATA_NUM_PROPERTIES
};
static GParamSpec* umockdev_ioctl_data_properties[UMOCKDEV_IOCTL_DATA_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _UmockdevIoctlDataFlushData UmockdevIoctlDataFlushData;

#define UMOCKDEV_TYPE_IOCTL_CLIENT (umockdev_ioctl_client_get_type ())
#define UMOCKDEV_IOCTL_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UMOCKDEV_TYPE_IOCTL_CLIENT, UMockdevIoctlClient))
#define UMOCKDEV_IOCTL_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UMOCKDEV_TYPE_IOCTL_CLIENT, UMockdevIoctlClientClass))
#define UMOCKDEV_IS_IOCTL_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UMOCKDEV_TYPE_IOCTL_CLIENT))
#define UMOCKDEV_IS_IOCTL_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UMOCKDEV_TYPE_IOCTL_CLIENT))
#define UMOCKDEV_IOCTL_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UMOCKDEV_TYPE_IOCTL_CLIENT, UMockdevIoctlClientClass))

typedef struct _UMockdevIoctlClient UMockdevIoctlClient;
typedef struct _UMockdevIoctlClientClass UMockdevIoctlClientClass;
typedef struct _UMockdevIoctlClientPrivate UMockdevIoctlClientPrivate;

#define UMOCKDEV_TYPE_IOCTL_BASE (umockdev_ioctl_base_get_type ())
#define UMOCKDEV_IOCTL_BASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UMOCKDEV_TYPE_IOCTL_BASE, UMockdevIoctlBase))
#define UMOCKDEV_IOCTL_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UMOCKDEV_TYPE_IOCTL_BASE, UMockdevIoctlBaseClass))
#define UMOCKDEV_IS_IOCTL_BASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UMOCKDEV_TYPE_IOCTL_BASE))
#define UMOCKDEV_IS_IOCTL_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UMOCKDEV_TYPE_IOCTL_BASE))
#define UMOCKDEV_IOCTL_BASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UMOCKDEV_TYPE_IOCTL_BASE, UMockdevIoctlBaseClass))

typedef struct _UMockdevIoctlBase UMockdevIoctlBase;
typedef struct _UMockdevIoctlBaseClass UMockdevIoctlBaseClass;
enum  {
	UMOCKDEV_IOCTL_CLIENT_0_PROPERTY,
	UMOCKDEV_IOCTL_CLIENT_DEVNODE_PROPERTY,
	UMOCKDEV_IOCTL_CLIENT_REQUEST_PROPERTY,
	UMOCKDEV_IOCTL_CLIENT_ARG_PROPERTY,
	UMOCKDEV_IOCTL_CLIENT_CONNECTED_PROPERTY,
	UMOCKDEV_IOCTL_CLIENT_NUM_PROPERTIES
};
static GParamSpec* umockdev_ioctl_client_properties[UMOCKDEV_IOCTL_CLIENT_NUM_PROPERTIES];
#define _g_main_context_unref0(var) ((var == NULL) ? NULL : (var = (g_main_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _UmockdevIoctlClientCompleteAsyncData UmockdevIoctlClientCompleteAsyncData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _ioctl_tree_free0(var) ((var == NULL) ? NULL : (var = (ioctl_tree_free (var), NULL)))
typedef struct _UmockdevIoctlClientReadIoctlData UmockdevIoctlClientReadIoctlData;

#define UMOCKDEV_TYPE_START_LISTEN_CLOSURE (umockdev_start_listen_closure_get_type ())
#define UMOCKDEV_START_LISTEN_CLOSURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UMOCKDEV_TYPE_START_LISTEN_CLOSURE, UMockdevStartListenClosure))
#define UMOCKDEV_START_LISTEN_CLOSURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UMOCKDEV_TYPE_START_LISTEN_CLOSURE, UMockdevStartListenClosureClass))
#define UMOCKDEV_IS_START_LISTEN_CLOSURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UMOCKDEV_TYPE_START_LISTEN_CLOSURE))
#define UMOCKDEV_IS_START_LISTEN_CLOSURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UMOCKDEV_TYPE_START_LISTEN_CLOSURE))
#define UMOCKDEV_START_LISTEN_CLOSURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UMOCKDEV_TYPE_START_LISTEN_CLOSURE, UMockdevStartListenClosureClass))

typedef struct _UMockdevStartListenClosure UMockdevStartListenClosure;
typedef struct _UMockdevStartListenClosureClass UMockdevStartListenClosureClass;
typedef struct _UMockdevStartListenClosurePrivate UMockdevStartListenClosurePrivate;
typedef struct _UMockdevParamSpecStartListenClosure UMockdevParamSpecStartListenClosure;
typedef struct _UMockdevIoctlBasePrivate UMockdevIoctlBasePrivate;
enum  {
	UMOCKDEV_IOCTL_BASE_0_PROPERTY,
	UMOCKDEV_IOCTL_BASE_NUM_PROPERTIES
};
static GParamSpec* umockdev_ioctl_base_properties[UMOCKDEV_IOCTL_BASE_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _UmockdevIoctlBaseSocketListenData UmockdevIoctlBaseSocketListenData;
#define _umockdev_start_listen_closure_unref0(var) ((var == NULL) ? NULL : (var = (umockdev_start_listen_closure_unref (var), NULL)))
enum  {
	UMOCKDEV_IOCTL_BASE_CLIENT_CONNECTED_SIGNAL,
	UMOCKDEV_IOCTL_BASE_CLIENT_VANISHED_SIGNAL,
	UMOCKDEV_IOCTL_BASE_NUM_SIGNALS
};
static guint umockdev_ioctl_base_signals[UMOCKDEV_IOCTL_BASE_NUM_SIGNALS] = {0};

#define UMOCKDEV_TYPE_IOCTL_TREE_HANDLER (umockdev_ioctl_tree_handler_get_type ())
#define UMOCKDEV_IOCTL_TREE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UMOCKDEV_TYPE_IOCTL_TREE_HANDLER, UMockdevIoctlTreeHandler))
#define UMOCKDEV_IOCTL_TREE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UMOCKDEV_TYPE_IOCTL_TREE_HANDLER, UMockdevIoctlTreeHandlerClass))
#define UMOCKDEV_IS_IOCTL_TREE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UMOCKDEV_TYPE_IOCTL_TREE_HANDLER))
#define UMOCKDEV_IS_IOCTL_TREE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UMOCKDEV_TYPE_IOCTL_TREE_HANDLER))
#define UMOCKDEV_IOCTL_TREE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UMOCKDEV_TYPE_IOCTL_TREE_HANDLER, UMockdevIoctlTreeHandlerClass))

typedef struct _UMockdevIoctlTreeHandler UMockdevIoctlTreeHandler;
typedef struct _UMockdevIoctlTreeHandlerClass UMockdevIoctlTreeHandlerClass;
typedef struct _UMockdevIoctlTreeHandlerPrivate UMockdevIoctlTreeHandlerPrivate;
enum  {
	UMOCKDEV_IOCTL_TREE_HANDLER_0_PROPERTY,
	UMOCKDEV_IOCTL_TREE_HANDLER_NUM_PROPERTIES
};
static GParamSpec* umockdev_ioctl_tree_handler_properties[UMOCKDEV_IOCTL_TREE_HANDLER_NUM_PROPERTIES];
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))

#define UMOCKDEV_TYPE_IOCTL_TREE_RECORDER (umockdev_ioctl_tree_recorder_get_type ())
#define UMOCKDEV_IOCTL_TREE_RECORDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UMOCKDEV_TYPE_IOCTL_TREE_RECORDER, UMockdevIoctlTreeRecorder))
#define UMOCKDEV_IOCTL_TREE_RECORDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UMOCKDEV_TYPE_IOCTL_TREE_RECORDER, UMockdevIoctlTreeRecorderClass))
#define UMOCKDEV_IS_IOCTL_TREE_RECORDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UMOCKDEV_TYPE_IOCTL_TREE_RECORDER))
#define UMOCKDEV_IS_IOCTL_TREE_RECORDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UMOCKDEV_TYPE_IOCTL_TREE_RECORDER))
#define UMOCKDEV_IOCTL_TREE_RECORDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UMOCKDEV_TYPE_IOCTL_TREE_RECORDER, UMockdevIoctlTreeRecorderClass))

typedef struct _UMockdevIoctlTreeRecorder UMockdevIoctlTreeRecorder;
typedef struct _UMockdevIoctlTreeRecorderClass UMockdevIoctlTreeRecorderClass;
typedef struct _UMockdevIoctlTreeRecorderPrivate UMockdevIoctlTreeRecorderPrivate;
enum  {
	UMOCKDEV_IOCTL_TREE_RECORDER_0_PROPERTY,
	UMOCKDEV_IOCTL_TREE_RECORDER_NUM_PROPERTIES
};
static GParamSpec* umockdev_ioctl_tree_recorder_properties[UMOCKDEV_IOCTL_TREE_RECORDER_NUM_PROPERTIES];
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _UMockdevIoctlData {
	GObject parent_instance;
	guint8* data;
	gint data_len;
	gulong client_addr;
	UMockdevIoctlDataPrivate * priv;
};

struct _UMockdevIoctlDataClass {
	GObjectClass parent_class;
};

struct _UMockdevIoctlDataPrivate {
	guint8* client_data;
	gint client_data_length1;
	gint _client_data_size_;
	GIOStream* stream;
	UMockdevIoctlData** children;
	gint children_length1;
	gint _children_size_;
	gsize* children_offset;
	gint children_offset_length1;
	gint _children_offset_size_;
};

struct _UmockdevIoctlDataFlushData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	UMockdevIoctlData* self;
	guint8* submit_data;
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_;
	gint _tmp1__length1;
	gint submit_data_length1;
	gint _submit_data_size_;
	gint i;
	gboolean _tmp2_;
	gint _tmp3_;
	UMockdevIoctlData** _tmp4_;
	gint _tmp4__length1;
	UMockdevIoctlData** _tmp5_;
	gint _tmp5__length1;
	UMockdevIoctlData* _tmp6_;
	guint8* _tmp7_;
	gint _tmp7__length1;
	gsize* _tmp8_;
	gint _tmp8__length1;
	gsize _tmp9_;
	UMockdevIoctlData** _tmp10_;
	gint _tmp10__length1;
	UMockdevIoctlData* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	guint8* _tmp14_;
	gint _tmp14__length1;
	guint8* _tmp15_;
	gint _tmp15__length1;
	guint8* _tmp16_;
	gint _tmp16__length1;
	guint8* _tmp17_;
	gint _tmp17__length1;
	guint8* _tmp18_;
	gint _tmp18__length1;
	GOutputStream* output;
	GIOStream* _tmp19_;
	GOutputStream* _tmp20_;
	GOutputStream* _tmp21_;
	gulong args[3];
	guint8* _tmp22_;
	gint _tmp22__length1;
	GOutputStream* _tmp23_;
	GOutputStream* _tmp24_;
	guint8* _tmp25_;
	gint _tmp25__length1;
	GError* _inner_error0_;
};

struct _UMockdevIoctlClient {
	GObject parent_instance;
	UMockdevIoctlClientPrivate * priv;
};

struct _UMockdevIoctlClientClass {
	GObjectClass parent_class;
};

struct _UMockdevIoctlClientPrivate {
	UMockdevIoctlBase* handler;
	GIOStream* stream;
	GMainContext* _ctx;
	gchar* _devnode;
	gulong _request;
	UMockdevIoctlData* _arg;
	gulong _cmd;
	gboolean _abort;
	glong result;
	gint result_errno;
};

struct _UmockdevIoctlClientCompleteAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	UMockdevIoctlClient* self;
	GOutputStream* output;
	GIOStream* _tmp0_;
	GOutputStream* _tmp1_;
	GOutputStream* _tmp2_;
	gulong args[3];
	UMockdevIoctlData* _tmp3_;
	GOutputStream* _tmp4_;
	GError* _inner_error0_;
};

struct _UmockdevIoctlClientReadIoctlData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	UMockdevIoctlClient* self;
	GInputStream* input;
	GIOStream* _tmp0_;
	GInputStream* _tmp1_;
	GInputStream* _tmp2_;
	gsize bytes;
	gulong args[3];
	GInputStream* _tmp3_;
	gsize _tmp4_;
	GIOStream* _tmp5_;
	gboolean _tmp6_;
	GInputStream* _tmp7_;
	GIOStream* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	gulong _tmp11_;
	gulong _tmp12_;
	gulong _tmp13_;
	gulong _tmp14_;
	gulong _tmp15_;
	gulong _tmp16_;
	GIOStream* _tmp17_;
	UMockdevIoctlData* _tmp18_;
	UMockdevIoctlData* _tmp19_;
	guint8* _tmp20_;
	UMockdevIoctlData* _tmp21_;
	guint8* _tmp22_;
	gint _tmp22__length1;
	gulong _tmp23_;
	GIOStream* _tmp24_;
	UMockdevIoctlData* _tmp25_;
	UMockdevIoctlData* _tmp26_;
	gulong _tmp27_;
	guint8* _tmp28_;
	UMockdevIoctlData* _tmp29_;
	gulong _tmp30_;
	UMockdevIoctlData* _tmp31_;
	GError* e;
	GError* _tmp32_;
	const gchar* _tmp33_;
	gboolean handled;
	gulong _tmp34_;
	gboolean _tmp35_;
	gulong _tmp36_;
	gboolean _tmp37_;
	gboolean _tmp38_;
	gulong _tmp39_;
	UMockdevIoctlBase* _tmp40_;
	gboolean _tmp41_;
	gulong _tmp42_;
	UMockdevIoctlBase* _tmp43_;
	gboolean _tmp44_;
	UMockdevIoctlBase* _tmp45_;
	gboolean _tmp46_;
	gboolean _tmp47_;
	gulong _tmp48_;
	ioctl_tree* tree;
	UMockdevIoctlData* data;
	gulong size;
	gulong type;
	gint ret;
	gint my_errno;
	UMockdevIoctlData* _tmp49_;
	UMockdevIoctlData* _tmp50_;
	UMockdevIoctlData* _tmp51_;
	UMockdevIoctlData* _tmp52_;
	GError* _vala1_e;
	GError* _tmp53_;
	const gchar* _tmp54_;
	ioctl_tree* _tmp55_;
	UMockdevIoctlData* _tmp56_;
	guint8* _tmp57_;
	gint _tmp57__length1;
	gint _tmp58_;
	GError* _inner_error0_;
};

struct _UMockdevStartListenClosure {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UMockdevIoctlBase* handler;
	GSocketListener* listener;
	gchar* devnode;
	UMockdevStartListenClosurePrivate * priv;
};

struct _UMockdevStartListenClosureClass {
	GTypeClass parent_class;
	void (*finalize) (UMockdevStartListenClosure *self);
};

struct _UMockdevParamSpecStartListenClosure {
	GParamSpec parent_instance;
};

struct _UMockdevIoctlBase {
	GObject parent_instance;
	UMockdevIoctlBasePrivate * priv;
};

struct _UMockdevIoctlBaseClass {
	GObjectClass parent_class;
	gboolean (*handle_ioctl) (UMockdevIoctlBase* self, UMockdevIoctlClient* client);
	gboolean (*handle_read) (UMockdevIoctlBase* self, UMockdevIoctlClient* client);
	gboolean (*handle_write) (UMockdevIoctlBase* self, UMockdevIoctlClient* client);
	void (*client_connected) (UMockdevIoctlBase* self, UMockdevIoctlClient* client);
	void (*client_vanished) (UMockdevIoctlBase* self, UMockdevIoctlClient* client);
};

struct _UMockdevIoctlBasePrivate {
	GHashTable* listeners;
	GRecMutex __lock_listeners;
};

struct _UmockdevIoctlBaseSocketListenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	UMockdevIoctlBase* self;
	GSocketListener* listener;
	gchar* devnode;
	GCancellable* cancellable;
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	gconstpointer _tmp2_;
	GCancellable* _tmp3_;
	GHashTable* _tmp4_;
	GSocketConnection* connection;
	UMockdevIoctlClient* client;
	GSocketConnection* _tmp5_;
	GSocketConnection* _tmp6_;
	GSocketConnection* _tmp7_;
	GSocketConnection* _tmp8_;
	UMockdevIoctlClient* _tmp9_;
	UMockdevIoctlClient* _tmp10_;
	UMockdevIoctlClient* _tmp11_;
	GError* e;
	const gchar* _tmp12_;
	GError* _inner_error0_;
};

struct _UMockdevIoctlTreeHandler {
	UMockdevIoctlBase parent_instance;
	UMockdevIoctlTreeHandlerPrivate * priv;
};

struct _UMockdevIoctlTreeHandlerClass {
	UMockdevIoctlBaseClass parent_class;
};

struct _UMockdevIoctlTreeHandlerPrivate {
	ioctl_tree* tree;
};

struct _UMockdevIoctlTreeRecorder {
	UMockdevIoctlBase parent_instance;
	UMockdevIoctlTreeRecorderPrivate * priv;
};

struct _UMockdevIoctlTreeRecorderClass {
	UMockdevIoctlBaseClass parent_class;
};

struct _UMockdevIoctlTreeRecorderPrivate {
	gboolean write_log;
	gchar* logfile;
	gchar* device;
	ioctl_tree* tree;
};

static gint UMockdevIoctlData_private_offset;
static gpointer umockdev_ioctl_data_parent_class = NULL;
static gint UMockdevIoctlClient_private_offset;
static gpointer umockdev_ioctl_client_parent_class = NULL;
static gpointer umockdev_start_listen_closure_parent_class = NULL;
static gint UMockdevIoctlBase_private_offset;
static gpointer umockdev_ioctl_base_parent_class = NULL;
VALA_EXTERN UMockdevIoctlData* umockdev_last_submit_urb;
UMockdevIoctlData* umockdev_last_submit_urb = NULL;
static gint UMockdevIoctlTreeHandler_private_offset;
static gpointer umockdev_ioctl_tree_handler_parent_class = NULL;
static gint UMockdevIoctlTreeRecorder_private_offset;
static gpointer umockdev_ioctl_tree_recorder_parent_class = NULL;

VALA_EXTERN gboolean umockdev_signal_accumulator_true_handled (GSignalInvocationHint* ihint,
                                                   GValue* return_accu,
                                                   GValue* handler_return,
                                                   void* data);
VALA_EXTERN GType umockdev_ioctl_data_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UMockdevIoctlData, g_object_unref)
VALA_EXTERN UMockdevIoctlData* umockdev_ioctl_data_new (GIOStream* stream);
VALA_EXTERN UMockdevIoctlData* umockdev_ioctl_data_construct (GType object_type,
                                                  GIOStream* stream);
VALA_EXTERN UMockdevIoctlData* umockdev_ioctl_data_ref (UMockdevIoctlData* self);
VALA_EXTERN void umockdev_ioctl_data_unref (UMockdevIoctlData* self);
VALA_EXTERN UMockdevIoctlData* umockdev_ioctl_data_resolve (UMockdevIoctlData* self,
                                                gsize offset,
                                                gsize len,
                                                GError** error);
static void _vala_array_add1 (UMockdevIoctlData** * array,
                       gint* length,
                       gint* size,
                       UMockdevIoctlData* value);
static void _vala_array_add2 (gsize* * array,
                       gint* length,
                       gint* size,
                       gsize value);
VALA_EXTERN void umockdev_ioctl_data_load_data (UMockdevIoctlData* self,
                                    GError** error);
VALA_EXTERN gboolean umockdev_ioctl_data_set_ptr (UMockdevIoctlData* self,
                                      gsize offset,
                                      UMockdevIoctlData* child);
static void _vala_array_add3 (UMockdevIoctlData** * array,
                       gint* length,
                       gint* size,
                       UMockdevIoctlData* value);
static void _vala_array_add4 (gsize* * array,
                       gint* length,
                       gint* size,
                       gsize value);
VALA_EXTERN gboolean umockdev_ioctl_data_reload (UMockdevIoctlData* self,
                                     GError** error);
VALA_EXTERN void umockdev_ioctl_data_update (UMockdevIoctlData* self,
                                 gsize offset,
                                 guint8* new_data,
                                 gint new_data_length1);
VALA_EXTERN void umockdev_ioctl_data_retrieve (UMockdevIoctlData* self,
                                   guint8** read_data,
                                   gint* read_data_length1);
static guint8* _vala_array_dup1 (guint8* self,
                          gssize length);
static void umockdev_ioctl_data_flush_data_free (gpointer _data);
VALA_EXTERN void umockdev_ioctl_data_flush (UMockdevIoctlData* self,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_);
VALA_EXTERN void umockdev_ioctl_data_flush_finish (UMockdevIoctlData* self,
                                       GAsyncResult* _res_,
                                       GError** error);
static gboolean umockdev_ioctl_data_flush_co (UmockdevIoctlDataFlushData* _data_);
static guint8* _vala_array_dup2 (guint8* self,
                          gssize length);
static void umockdev_ioctl_data_flush_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_);
VALA_EXTERN void umockdev_ioctl_data_flush_sync (UMockdevIoctlData* self,
                                     GError** error);
static guint8* _vala_array_dup3 (guint8* self,
                          gssize length);
static void umockdev_ioctl_data_finalize (GObject * obj);
static GType umockdev_ioctl_data_get_type_once (void);
VALA_EXTERN GType umockdev_ioctl_client_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UMockdevIoctlClient, g_object_unref)
VALA_EXTERN GType umockdev_ioctl_base_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UMockdevIoctlBase, g_object_unref)
VALA_EXTERN const gchar* umockdev_ioctl_client_get_devnode (UMockdevIoctlClient* self);
VALA_EXTERN gulong umockdev_ioctl_client_get_request (UMockdevIoctlClient* self);
VALA_EXTERN UMockdevIoctlData* umockdev_ioctl_client_get_arg (UMockdevIoctlClient* self);
VALA_EXTERN gboolean umockdev_ioctl_client_get_connected (UMockdevIoctlClient* self);
VALA_EXTERN gint umockdev_ioctl_client_execute (UMockdevIoctlClient* self,
                                    gint* errno_,
                                    GError** error);
VALA_EXTERN void umockdev_ioctl_client_complete (UMockdevIoctlClient* self,
                                     glong res,
                                     gint errno_);
static gboolean umockdev_ioctl_client_complete_idle (UMockdevIoctlClient* self);
static gboolean _umockdev_ioctl_client_complete_idle_gsource_func (gpointer self);
VALA_EXTERN void umockdev_ioctl_client_abort (UMockdevIoctlClient* self);
static void umockdev_ioctl_client_complete_async_data_free (gpointer _data);
static void umockdev_ioctl_client_complete_async (UMockdevIoctlClient* self,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static void umockdev_ioctl_client_complete_finish (UMockdevIoctlClient* self,
                                            GAsyncResult* _res_,
                                            GError** error);
static gboolean umockdev_ioctl_client_complete_async_co (UmockdevIoctlClientCompleteAsyncData* _data_);
static void umockdev_ioctl_client_complete_async_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_);
VALA_EXTERN void umockdev_ioctl_client_read_ioctl (UMockdevIoctlClient* self,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
VALA_EXTERN void umockdev_ioctl_client_read_ioctl_finish (UMockdevIoctlClient* self,
                                              GAsyncResult* _res_);
static void umockdev_ioctl_client_read_ioctl_data_free (gpointer _data);
static gboolean umockdev_ioctl_client_read_ioctl_co (UmockdevIoctlClientReadIoctlData* _data_);
static void umockdev_ioctl_client_read_ioctl_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
static gboolean umockdev_ioctl_client_notify_closed_idle (UMockdevIoctlClient* self);
static void umockdev_ioctl_client_notify_closed_cb (UMockdevIoctlClient* self);
static gboolean _umockdev_ioctl_client_notify_closed_idle_gsource_func (gpointer self);
VALA_EXTERN UMockdevIoctlClient* umockdev_ioctl_client_new (UMockdevIoctlBase* handler,
                                                GIOStream* stream,
                                                const gchar* devnode);
VALA_EXTERN UMockdevIoctlClient* umockdev_ioctl_client_construct (GType object_type,
                                                      UMockdevIoctlBase* handler,
                                                      GIOStream* stream,
                                                      const gchar* devnode);
static gboolean _umockdev_signal_accumulator_true_handled_gsignal_accumulator (GSignalInvocationHint* ihint,
                                                                        GValue* return_accu,
                                                                        GValue* handler_return,
                                                                        void* data);
static void umockdev_ioctl_client_finalize (GObject * obj);
static GType umockdev_ioctl_client_get_type_once (void);
static void _vala_umockdev_ioctl_client_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
VALA_EXTERN gpointer umockdev_start_listen_closure_ref (gpointer instance);
VALA_EXTERN void umockdev_start_listen_closure_unref (gpointer instance);
VALA_EXTERN GParamSpec* umockdev_param_spec_start_listen_closure (const gchar* name,
                                                      const gchar* nick,
                                                      const gchar* blurb,
                                                      GType object_type,
                                                      GParamFlags flags);
VALA_EXTERN void umockdev_value_set_start_listen_closure (GValue* value,
                                              gpointer v_object);
VALA_EXTERN void umockdev_value_take_start_listen_closure (GValue* value,
                                               gpointer v_object);
VALA_EXTERN gpointer umockdev_value_get_start_listen_closure (const GValue* value);
VALA_EXTERN GType umockdev_start_listen_closure_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UMockdevStartListenClosure, umockdev_start_listen_closure_unref)
VALA_EXTERN UMockdevStartListenClosure* umockdev_start_listen_closure_new (UMockdevIoctlBase* handler,
                                                               GSocketListener* listener,
                                                               const gchar* devnode);
VALA_EXTERN UMockdevStartListenClosure* umockdev_start_listen_closure_construct (GType object_type,
                                                                     UMockdevIoctlBase* handler,
                                                                     GSocketListener* listener,
                                                                     const gchar* devnode);
VALA_EXTERN gboolean umockdev_start_listen_closure_cb (UMockdevStartListenClosure* self);
VALA_EXTERN void umockdev_ioctl_base_socket_listen (UMockdevIoctlBase* self,
                                        GSocketListener* listener,
                                        const gchar* devnode,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
VALA_EXTERN void umockdev_ioctl_base_socket_listen_finish (UMockdevIoctlBase* self,
                                               GAsyncResult* _res_);
static void umockdev_start_listen_closure_finalize (UMockdevStartListenClosure * obj);
static GType umockdev_start_listen_closure_get_type_once (void);
VALA_EXTERN gboolean umockdev_ioctl_base_handle_ioctl (UMockdevIoctlBase* self,
                                           UMockdevIoctlClient* client);
VALA_EXTERN gboolean umockdev_ioctl_base_handle_read (UMockdevIoctlBase* self,
                                          UMockdevIoctlClient* client);
VALA_EXTERN gboolean umockdev_ioctl_base_handle_write (UMockdevIoctlBase* self,
                                           UMockdevIoctlClient* client);
static void umockdev_ioctl_base_socket_listen_data_free (gpointer _data);
static gboolean umockdev_ioctl_base_socket_listen_co (UmockdevIoctlBaseSocketListenData* _data_);
static void umockdev_ioctl_base_socket_listen_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
VALA_EXTERN void umockdev_ioctl_base_register_path (UMockdevIoctlBase* self,
                                        GMainContext* ctx,
                                        const gchar* devnode,
                                        const gchar* sockpath);
static gboolean _umockdev_start_listen_closure_cb_gsource_func (gpointer self);
VALA_EXTERN void umockdev_ioctl_base_unregister_all (UMockdevIoctlBase* self);
static gboolean ___lambda4_ (UMockdevIoctlBase* self,
                      const gchar* key,
                      GCancellable* val);
static gboolean ____lambda4__ghr_func (gconstpointer key,
                                gconstpointer value,
                                gpointer self);
static gboolean umockdev_ioctl_base_real_handle_ioctl (UMockdevIoctlBase* self,
                                                UMockdevIoctlClient* client);
static gboolean umockdev_ioctl_base_real_handle_read (UMockdevIoctlBase* self,
                                               UMockdevIoctlClient* client);
static gboolean umockdev_ioctl_base_real_handle_write (UMockdevIoctlBase* self,
                                                UMockdevIoctlClient* client);
static void umockdev_ioctl_base_real_client_connected (UMockdevIoctlBase* self,
                                                UMockdevIoctlClient* client);
static void umockdev_ioctl_base_real_client_vanished (UMockdevIoctlBase* self,
                                               UMockdevIoctlClient* client);
VALA_EXTERN UMockdevIoctlBase* umockdev_ioctl_base_new (void);
VALA_EXTERN UMockdevIoctlBase* umockdev_ioctl_base_construct (GType object_type);
static GObject * umockdev_ioctl_base_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void umockdev_ioctl_base_finalize (GObject * obj);
static GType umockdev_ioctl_base_get_type_once (void);
VALA_EXTERN GType umockdev_ioctl_tree_handler_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UMockdevIoctlTreeHandler, g_object_unref)
VALA_EXTERN UMockdevIoctlTreeHandler* umockdev_ioctl_tree_handler_new (const gchar* file);
VALA_EXTERN UMockdevIoctlTreeHandler* umockdev_ioctl_tree_handler_construct (GType object_type,
                                                                 const gchar* file);
static gboolean umockdev_ioctl_tree_handler_real_handle_ioctl (UMockdevIoctlBase* base,
                                                        UMockdevIoctlClient* client);
static void umockdev_ioctl_tree_handler_finalize (GObject * obj);
static GType umockdev_ioctl_tree_handler_get_type_once (void);
VALA_EXTERN GType umockdev_ioctl_tree_recorder_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UMockdevIoctlTreeRecorder, g_object_unref)
VALA_EXTERN void umockdev_ioctl_base_client_connected (UMockdevIoctlBase* self,
                                           UMockdevIoctlClient* client);
static void umockdev_ioctl_tree_recorder_flush_log (UMockdevIoctlTreeRecorder* self);
VALA_EXTERN UMockdevIoctlTreeRecorder* umockdev_ioctl_tree_recorder_new (const gchar* device,
                                                             const gchar* file);
VALA_EXTERN UMockdevIoctlTreeRecorder* umockdev_ioctl_tree_recorder_construct (GType object_type,
                                                                   const gchar* device,
                                                                   const gchar* file);
static gboolean umockdev_ioctl_tree_recorder_real_handle_ioctl (UMockdevIoctlBase* base,
                                                         UMockdevIoctlClient* client);
static void umockdev_ioctl_tree_recorder_real_client_connected (UMockdevIoctlBase* base,
                                                         UMockdevIoctlClient* client);
static void umockdev_ioctl_tree_recorder_finalize (GObject * obj);
static GType umockdev_ioctl_tree_recorder_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

/**
 * SECTION:umockdev-ioctl
 * @title: umockdev-ioctl
 * @short_description: Emulate ioctl and read/write calls for devices.
 *
 * These classes permit emulation of ioctl and read/write calls including
 * fully customizing the behaviour by creating an #UMockdevIoctlBase instance or
 * subclass instance and attaching it using umockdev_testbed_attach_ioctl().
 */
gboolean
umockdev_signal_accumulator_true_handled (GSignalInvocationHint* ihint,
                                          GValue* return_accu,
                                          GValue* handler_return,
                                          void* data)
{
	gboolean handled = FALSE;
	gboolean continue_emission = FALSE;
	gboolean result;
	g_return_val_if_fail (ihint != NULL, FALSE);
	g_return_val_if_fail (return_accu != NULL, FALSE);
	g_return_val_if_fail (handler_return != NULL, FALSE);
	handled = g_value_get_boolean (handler_return);
	g_value_set_boolean (return_accu, handled);
	continue_emission = !handled;
	result = continue_emission;
	return result;
}

static inline gpointer
umockdev_ioctl_data_get_instance_private (UMockdevIoctlData* self)
{
	return G_STRUCT_MEMBER_P (self, UMockdevIoctlData_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

UMockdevIoctlData*
umockdev_ioctl_data_construct (GType object_type,
                               GIOStream* stream)
{
	UMockdevIoctlData * self = NULL;
	GIOStream* _tmp0_;
	g_return_val_if_fail (stream != NULL, NULL);
	self = (UMockdevIoctlData*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (stream);
	_g_object_unref0 (self->priv->stream);
	self->priv->stream = _tmp0_;
	return self;
}

UMockdevIoctlData*
umockdev_ioctl_data_new (GIOStream* stream)
{
	return umockdev_ioctl_data_construct (UMOCKDEV_TYPE_IOCTL_DATA, stream);
}

/**
     * umockdev_ioctl_data_ref:
     * @self: A #UMockdevIoctlData
     *
     * Deprecated, same as g_object_ref().
     */
UMockdevIoctlData*
umockdev_ioctl_data_ref (UMockdevIoctlData* self)
{
	UMockdevIoctlData* _tmp0_;
	UMockdevIoctlData* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (self, UMOCKDEV_TYPE_IOCTL_DATA, UMockdevIoctlData));
	result = _tmp0_;
	return result;
}

/**
     * umockdev_ioctl_data_unref:
     * @self: A #UMockdevIoctlData
     *
     * Deprecated, same as g_object_unref().
     */
void
umockdev_ioctl_data_unref (UMockdevIoctlData* self)
{
	g_return_if_fail (self != NULL);
	g_object_unref ((GObject*) self);
}

/**
     * umockdev_ioctl_data_resolve:
     * @self: A #UMockdevIoctlData
     * @offset: Byte offset of pointer inside data
     * @len: Length of the to be resolved data
     * @error: return location for a GError, or %NULL
     *
     * Resolve an address inside the data. After this operation, the pointer
     * inside data points to a local copy of the memory. Any local modifications
     * will be synced back by umockdev_ioctl_client_complete() and
     * umockdev_ioctl_client_execute().
     *
     * You may call this multiple times on the same pointer in order to fetch
     * the existing information.
     *
     * Returns: #UMockdevIoctlData, or #NULL on error
     * Since: 0.16
     */
static void
_vala_array_add1 (UMockdevIoctlData** * array,
                  gint* length,
                  gint* size,
                  UMockdevIoctlData* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (UMockdevIoctlData*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add2 (gsize* * array,
                  gint* length,
                  gint* size,
                  gsize value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gsize, *array, *size);
	}
	(*array)[(*length)++] = value;
}

UMockdevIoctlData*
umockdev_ioctl_data_resolve (UMockdevIoctlData* self,
                             gsize offset,
                             gsize len,
                             GError** error)
{
	UMockdevIoctlData* res = NULL;
	guint8* _tmp8_;
	gint _tmp8__length1;
	GIOStream* _tmp9_;
	UMockdevIoctlData* _tmp10_;
	UMockdevIoctlData* _tmp11_;
	guint8* _tmp12_;
	UMockdevIoctlData* _tmp13_;
	guint8* _tmp14_;
	gint _tmp14__length1;
	UMockdevIoctlData* _tmp15_;
	UMockdevIoctlData* _tmp16_;
	gboolean _tmp17_ = FALSE;
	UMockdevIoctlData* _tmp18_;
	guint8* _tmp19_;
	gint _tmp19__length1;
	UMockdevIoctlData* _tmp20_;
	guint8* _tmp21_;
	gint _tmp21__length1;
	UMockdevIoctlData* _tmp22_;
	GError* _inner_error0_ = NULL;
	UMockdevIoctlData* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				UMockdevIoctlData** _tmp2_;
				gint _tmp2__length1;
				gsize* _tmp3_;
				gint _tmp3__length1;
				gsize _tmp4_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->children;
				_tmp2__length1 = self->priv->children_length1;
				if (!(i < _tmp2__length1)) {
					break;
				}
				_tmp3_ = self->priv->children_offset;
				_tmp3__length1 = self->priv->children_offset_length1;
				_tmp4_ = _tmp3_[i];
				if (_tmp4_ == offset) {
					UMockdevIoctlData** _tmp5_;
					gint _tmp5__length1;
					UMockdevIoctlData* _tmp6_;
					UMockdevIoctlData* _tmp7_;
					_tmp5_ = self->priv->children;
					_tmp5__length1 = self->priv->children_length1;
					_tmp6_ = _tmp5_[i];
					_tmp7_ = _g_object_ref0 (_tmp6_);
					result = _tmp7_;
					_g_object_unref0 (res);
					return result;
				}
			}
		}
	}
	_tmp8_ = self->data;
	_tmp8__length1 = self->data_len;
	if ((offset + sizeof (gsize)) > ((gsize) _tmp8__length1)) {
		result = NULL;
		_g_object_unref0 (res);
		return result;
	}
	_tmp9_ = self->priv->stream;
	_tmp10_ = umockdev_ioctl_data_new (_tmp9_);
	_g_object_unref0 (res);
	res = _tmp10_;
	_tmp11_ = res;
	_tmp12_ = g_new0 (guint8, len);
	_tmp11_->data = (g_free (_tmp11_->data), NULL);
	_tmp11_->data = _tmp12_;
	_tmp11_->data_len = len;
	_tmp13_ = res;
	_tmp14_ = self->data;
	_tmp14__length1 = self->data_len;
	_tmp13_->client_addr = (gulong) (*((gsize*) (&_tmp14_[offset])));
	_tmp15_ = res;
	_tmp16_ = _g_object_ref0 (_tmp15_);
	_vala_array_add1 (&self->priv->children, &self->priv->children_length1, &self->priv->_children_size_, _tmp16_);
	_vala_array_add2 (&self->priv->children_offset, &self->priv->children_offset_length1, &self->priv->_children_offset_size_, offset);
	_tmp18_ = res;
	if (_tmp18_->client_addr == ((gulong) 0)) {
		_tmp17_ = TRUE;
	} else {
		_tmp17_ = len == ((gsize) 0);
	}
	if (_tmp17_) {
		result = NULL;
		_g_object_unref0 (res);
		return result;
	}
	_tmp19_ = self->data;
	_tmp19__length1 = self->data_len;
	_tmp20_ = res;
	_tmp21_ = _tmp20_->data;
	_tmp21__length1 = _tmp20_->data_len;
	*((gsize*) (&_tmp19_[offset])) = (gsize) _tmp21_;
	_tmp22_ = res;
	umockdev_ioctl_data_load_data (_tmp22_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (res);
			return NULL;
		} else {
			_g_object_unref0 (res);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = res;
	return result;
}

/**
     * umockdev_ioctl_data_set_ptr:
     * @self: A #UMockdevIoctlData
     * @offset: Byte offset of pointer inside data
     * @child: Memory block that the pointer should point to
     * @error: return location for a GError, or %NULL
     *
     * Basically the reverse operation of umockdev_ioctl_data_resolve(). It sets
     * the pointer at @offset to point to the data from @child in a way that
     * can be synchronised back to the client.
     *
     * Use of this is rare, but e.g. required to reap USB URBs.
     *
     * The function will only work correctly for pointer elements that have not
     * been resolved before.
     *
     * Returns: %TRUE on success, %FALSE
     * Since: 0.16
     */
static void
_vala_array_add3 (UMockdevIoctlData** * array,
                  gint* length,
                  gint* size,
                  UMockdevIoctlData* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (UMockdevIoctlData*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add4 (gsize* * array,
                  gint* length,
                  gint* size,
                  gsize value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gsize, *array, *size);
	}
	(*array)[(*length)++] = value;
}

gboolean
umockdev_ioctl_data_set_ptr (UMockdevIoctlData* self,
                             gsize offset,
                             UMockdevIoctlData* child)
{
	gsize* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_;
	gint _tmp1__length1;
	UMockdevIoctlData* _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (child != NULL, FALSE);
	_tmp0_ = self->priv->children_offset;
	_tmp0__length1 = self->priv->children_offset_length1;
	{
		gsize* o_collection = NULL;
		gint o_collection_length1 = 0;
		gint _o_collection_size_ = 0;
		gint o_it = 0;
		o_collection = _tmp0_;
		o_collection_length1 = _tmp0__length1;
		for (o_it = 0; o_it < o_collection_length1; o_it = o_it + 1) {
			gsize o = 0UL;
			o = o_collection[o_it];
			{
				_vala_assert (o != offset, "o != offset");
			}
		}
	}
	_tmp1_ = self->data;
	_tmp1__length1 = self->data_len;
	_vala_assert ((offset + sizeof (gsize)) <= ((gsize) _tmp1__length1), "offset + sizeof(size_t) <= data.length");
	_tmp2_ = _g_object_ref0 (child);
	_vala_array_add3 (&self->priv->children, &self->priv->children_length1, &self->priv->_children_size_, _tmp2_);
	_vala_array_add4 (&self->priv->children_offset, &self->priv->children_offset_length1, &self->priv->_children_offset_size_, offset);
	_tmp3_ = self->data;
	_tmp3__length1 = self->data_len;
	_tmp4_ = child->data;
	_tmp4__length1 = child->data_len;
	*((gsize*) (&_tmp3_[offset])) = (gsize) _tmp4_;
	result = TRUE;
	return result;
}

/**
     * umockdev_ioctl_data_reload:
     * @self: A #UMockdevIoctlData
     * @error: return location for a GError, or %NULL
     *
     * This function allows reloading the data from the client side in case
     * you expect client modifications to have happened in the meantime (e.g.
     * between two separate ioctl's).
     * It is very unlikely that such an explicit reload is needed.
     *
     * Doing this unresolves any resolved pointers. Take care to re-resolve
     * them and use the newly resolved #UMockdevIoctlData in case you need to
     * access the data.
     *
     * Returns: #TRUE on success, #FALSE otherwise
     * Since: 0.16
     */
gboolean
umockdev_ioctl_data_reload (UMockdevIoctlData* self,
                            GError** error)
{
	gint _tmp2_;
	gint _tmp3_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	umockdev_ioctl_data_load_data (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_IO_ERROR) {
			gboolean _tmp0_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			return _tmp0_;
		} else {
			gboolean _tmp1_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp1_;
		}
	}
	_tmp2_ = 0;
	self->priv->children = g_renew (UMockdevIoctlData*, self->priv->children, 0);
	(_tmp2_ > self->priv->children_length1) ? memset (self->priv->children + self->priv->children_length1, 0, sizeof (UMockdevIoctlData*) * (_tmp2_ - self->priv->children_length1)) : NULL;
	self->priv->children_length1 = _tmp2_;
	self->priv->_children_size_ = _tmp2_;
	_tmp3_ = 0;
	self->priv->children_offset = g_renew (gsize, self->priv->children_offset, 0);
	(_tmp3_ > self->priv->children_offset_length1) ? memset (self->priv->children_offset + self->priv->children_offset_length1, 0, sizeof (gsize) * (_tmp3_ - self->priv->children_offset_length1)) : NULL;
	self->priv->children_offset_length1 = _tmp3_;
	self->priv->_children_offset_size_ = _tmp3_;
	result = TRUE;
	return result;
}

/**
     * umockdev_ioctl_update:
     * @self: A #UMockdevIoctlData
     * @offset: Offset into data
     * @new_data: (array length=length): Data to set
     * @new_data_length1: Lenght of binary data, must be smaller or equal to actual length
     *
     * Set data to a specific value. This is essentially a memcpy call, it is
     * only useful for e.g. python where the bindings cannot make the data
     * writable otherwise.
     *
     * Since: 0.18
     */
void
umockdev_ioctl_data_update (UMockdevIoctlData* self,
                            gsize offset,
                            guint8* new_data,
                            gint new_data_length1)
{
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_;
	gint _tmp1__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->data;
	_tmp0__length1 = self->data_len;
	_vala_assert ((offset + new_data_length1) <= ((gsize) _tmp0__length1), "offset + new_data.length <= data.length");
	_tmp1_ = self->data;
	_tmp1__length1 = self->data_len;
	memcpy (&_tmp1_[offset], new_data, (gsize) new_data_length1);
}

/**
     * umockdev_ioctl_retrieve:
     * @self: A #UMockdevIoctlData
     * @read_data: (array length=length) (out): Data to set
     * @read_data_length1: (out): Lenght of binary data, must be smaller or equal to actual length
     *
     * Simply returns the data struct member. This function purely exists for
     * GIR based bindings, as the vala generated bindings do not correctly
     * tag the array length, and direct access to the struct member is not
     * possible.
     *
     * Since: 0.18
     */
static guint8*
_vala_array_dup1 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

void
umockdev_ioctl_data_retrieve (UMockdevIoctlData* self,
                              guint8** read_data,
                              gint* read_data_length1)
{
	guint8* _vala_read_data = NULL;
	gint _vala_read_data_length1 = 0;
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_;
	gint _tmp1__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->data;
	_tmp0__length1 = self->data_len;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup1 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_vala_read_data = (g_free (_vala_read_data), NULL);
	_vala_read_data = _tmp1_;
	_vala_read_data_length1 = _tmp1__length1;
	if (read_data) {
		*read_data = _vala_read_data;
	} else {
		_vala_read_data = (g_free (_vala_read_data), NULL);
	}
	if (read_data_length1) {
		*read_data_length1 = _vala_read_data_length1;
	}
}

void
umockdev_ioctl_data_load_data (UMockdevIoctlData* self,
                               GError** error)
{
	GOutputStream* output = NULL;
	GIOStream* _tmp0_;
	GOutputStream* _tmp1_;
	GOutputStream* _tmp2_;
	GInputStream* input = NULL;
	GIOStream* _tmp3_;
	GInputStream* _tmp4_;
	GInputStream* _tmp5_;
	gulong args[3] = {0};
	guint8* _tmp6_;
	gint _tmp6__length1;
	guint8* _tmp7_;
	guint8* _tmp8_;
	gint _tmp8__length1;
	GOutputStream* _tmp9_;
	GInputStream* _tmp10_;
	guint8* _tmp11_;
	gint _tmp11__length1;
	guint8* _tmp12_;
	gint _tmp12__length1;
	guint8* _tmp13_;
	gint _tmp13__length1;
	guint8* _tmp14_;
	gint _tmp14__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stream;
	_tmp1_ = g_io_stream_get_output_stream (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	output = _tmp2_;
	_tmp3_ = self->priv->stream;
	_tmp4_ = g_io_stream_get_input_stream (_tmp3_);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	input = _tmp5_;
	if (self->client_addr == ((gulong) 0)) {
		_g_object_unref0 (input);
		_g_object_unref0 (output);
		return;
	}
	_tmp6_ = self->data;
	_tmp6__length1 = self->data_len;
	_tmp7_ = g_new0 (guint8, _tmp6__length1);
	self->priv->client_data = (g_free (self->priv->client_data), NULL);
	self->priv->client_data = _tmp7_;
	self->priv->client_data_length1 = _tmp6__length1;
	self->priv->_client_data_size_ = self->priv->client_data_length1;
	args[0] = (gulong) 5;
	args[1] = self->client_addr;
	_tmp8_ = self->data;
	_tmp8__length1 = self->data_len;
	args[2] = (gulong) _tmp8__length1;
	_tmp9_ = output;
	g_output_stream_write_all (_tmp9_, (guint8*) args, (gsize) ((3 * sizeof (gulong)) / sizeof (guint8)), NULL, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (input);
			_g_object_unref0 (output);
			return;
		} else {
			_g_object_unref0 (input);
			_g_object_unref0 (output);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp10_ = input;
	_tmp11_ = self->priv->client_data;
	_tmp11__length1 = self->priv->client_data_length1;
	g_input_stream_read_all (_tmp10_, _tmp11_, (gsize) _tmp11__length1, NULL, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (input);
			_g_object_unref0 (output);
			return;
		} else {
			_g_object_unref0 (input);
			_g_object_unref0 (output);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp12_ = self->data;
	_tmp12__length1 = self->data_len;
	_tmp13_ = self->priv->client_data;
	_tmp13__length1 = self->priv->client_data_length1;
	_tmp14_ = self->data;
	_tmp14__length1 = self->data_len;
	memcpy (_tmp12_, _tmp13_, (gsize) _tmp14__length1);
	_g_object_unref0 (input);
	_g_object_unref0 (output);
}

static void
umockdev_ioctl_data_flush_data_free (gpointer _data)
{
	UmockdevIoctlDataFlushData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (UmockdevIoctlDataFlushData, _data_);
}

void
umockdev_ioctl_data_flush (UMockdevIoctlData* self,
                           GAsyncReadyCallback _callback_,
                           gpointer _user_data_)
{
	UmockdevIoctlDataFlushData* _data_;
	UMockdevIoctlData* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (UmockdevIoctlDataFlushData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, umockdev_ioctl_data_flush_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	umockdev_ioctl_data_flush_co (_data_);
}

void
umockdev_ioctl_data_flush_finish (UMockdevIoctlData* self,
                                  GAsyncResult* _res_,
                                  GError** error)
{
	UmockdevIoctlDataFlushData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static guint8*
_vala_array_dup2 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

static void
umockdev_ioctl_data_flush_ready (GObject* source_object,
                                 GAsyncResult* _res_,
                                 gpointer _user_data_)
{
	UmockdevIoctlDataFlushData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	umockdev_ioctl_data_flush_co (_data_);
}

static gboolean
umockdev_ioctl_data_flush_co (UmockdevIoctlDataFlushData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->data;
	_data_->_tmp0__length1 = _data_->self->data_len;
	_data_->_tmp1_ = (_data_->_tmp0_ != NULL) ? _vala_array_dup2 (_data_->_tmp0_, _data_->_tmp0__length1) : _data_->_tmp0_;
	_data_->_tmp1__length1 = _data_->_tmp0__length1;
	_data_->submit_data = _data_->_tmp1_;
	_data_->submit_data_length1 = _data_->_tmp1__length1;
	_data_->_submit_data_size_ = _data_->submit_data_length1;
	{
		_data_->i = 0;
		{
			_data_->_tmp2_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp2_) {
					_data_->_tmp3_ = _data_->i;
					_data_->i = _data_->_tmp3_ + 1;
				}
				_data_->_tmp2_ = FALSE;
				_data_->_tmp4_ = _data_->self->priv->children;
				_data_->_tmp4__length1 = _data_->self->priv->children_length1;
				if (!(_data_->i < _data_->_tmp4__length1)) {
					break;
				}
				_data_->_tmp5_ = _data_->self->priv->children;
				_data_->_tmp5__length1 = _data_->self->priv->children_length1;
				_data_->_tmp6_ = _data_->_tmp5_[_data_->i];
				_data_->_state_ = 1;
				umockdev_ioctl_data_flush (_data_->_tmp6_, umockdev_ioctl_data_flush_ready, _data_);
				return FALSE;
				_state_1:
				umockdev_ioctl_data_flush_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
					_data_->submit_data = (g_free (_data_->submit_data), NULL);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_data_->_tmp7_ = _data_->submit_data;
				_data_->_tmp7__length1 = _data_->submit_data_length1;
				_data_->_tmp8_ = _data_->self->priv->children_offset;
				_data_->_tmp8__length1 = _data_->self->priv->children_offset_length1;
				_data_->_tmp9_ = _data_->_tmp8_[_data_->i];
				_data_->_tmp10_ = _data_->self->priv->children;
				_data_->_tmp10__length1 = _data_->self->priv->children_length1;
				_data_->_tmp11_ = _data_->_tmp10_[_data_->i];
				*((gsize*) (&_data_->_tmp7_[_data_->_tmp9_])) = (gsize) _data_->_tmp11_->client_addr;
			}
		}
	}
	if (_data_->self->client_addr != ((gulong) 0)) {
		_data_->_tmp14_ = _data_->submit_data;
		_data_->_tmp14__length1 = _data_->submit_data_length1;
		_data_->_tmp15_ = _data_->self->priv->client_data;
		_data_->_tmp15__length1 = _data_->self->priv->client_data_length1;
		_data_->_tmp13_ = _data_->_tmp14__length1 == _data_->_tmp15__length1;
	} else {
		_data_->_tmp13_ = FALSE;
	}
	if (_data_->_tmp13_) {
		_data_->_tmp16_ = _data_->submit_data;
		_data_->_tmp16__length1 = _data_->submit_data_length1;
		_data_->_tmp17_ = _data_->self->priv->client_data;
		_data_->_tmp17__length1 = _data_->self->priv->client_data_length1;
		_data_->_tmp18_ = _data_->submit_data;
		_data_->_tmp18__length1 = _data_->submit_data_length1;
		_data_->_tmp12_ = memcmp (_data_->_tmp16_, _data_->_tmp17_, (gsize) _data_->_tmp18__length1) != 0;
	} else {
		_data_->_tmp12_ = FALSE;
	}
	if (_data_->_tmp12_) {
		_data_->_tmp19_ = _data_->self->priv->stream;
		_data_->_tmp20_ = g_io_stream_get_output_stream (_data_->_tmp19_);
		_data_->_tmp21_ = _g_object_ref0 (_data_->_tmp20_);
		_data_->output = _data_->_tmp21_;
		_data_->args[0] = (gulong) 6;
		_data_->args[1] = _data_->self->client_addr;
		_data_->_tmp22_ = _data_->submit_data;
		_data_->_tmp22__length1 = _data_->submit_data_length1;
		_data_->args[2] = (gulong) _data_->_tmp22__length1;
		_data_->_tmp23_ = _data_->output;
		_data_->_state_ = 2;
		g_output_stream_write_all_async (_data_->_tmp23_, (guint8*) _data_->args, (gsize) ((3 * sizeof (gulong)) / sizeof (guint8)), 0, NULL, umockdev_ioctl_data_flush_ready, _data_);
		return FALSE;
		_state_2:
		g_output_stream_write_all_finish (_data_->_tmp23_, _data_->_res_, NULL, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->output);
			_data_->submit_data = (g_free (_data_->submit_data), NULL);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp24_ = _data_->output;
		_data_->_tmp25_ = _data_->submit_data;
		_data_->_tmp25__length1 = _data_->submit_data_length1;
		_data_->_state_ = 3;
		g_output_stream_write_all_async (_data_->_tmp24_, _data_->_tmp25_, (gsize) _data_->_tmp25__length1, 0, NULL, umockdev_ioctl_data_flush_ready, _data_);
		return FALSE;
		_state_3:
		g_output_stream_write_all_finish (_data_->_tmp24_, _data_->_res_, NULL, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->output);
			_data_->submit_data = (g_free (_data_->submit_data), NULL);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_object_unref0 (_data_->output);
	}
	_data_->submit_data = (g_free (_data_->submit_data), NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static guint8*
_vala_array_dup3 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

void
umockdev_ioctl_data_flush_sync (UMockdevIoctlData* self,
                                GError** error)
{
	guint8* submit_data = NULL;
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_;
	gint _tmp1__length1;
	gint submit_data_length1;
	gint _submit_data_size_;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->data;
	_tmp0__length1 = self->data_len;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup3 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	submit_data = _tmp1_;
	submit_data_length1 = _tmp1__length1;
	_submit_data_size_ = submit_data_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				UMockdevIoctlData** _tmp4_;
				gint _tmp4__length1;
				UMockdevIoctlData** _tmp5_;
				gint _tmp5__length1;
				UMockdevIoctlData* _tmp6_;
				guint8* _tmp7_;
				gint _tmp7__length1;
				gsize* _tmp8_;
				gint _tmp8__length1;
				gsize _tmp9_;
				UMockdevIoctlData** _tmp10_;
				gint _tmp10__length1;
				UMockdevIoctlData* _tmp11_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = self->priv->children;
				_tmp4__length1 = self->priv->children_length1;
				if (!(i < _tmp4__length1)) {
					break;
				}
				_tmp5_ = self->priv->children;
				_tmp5__length1 = self->priv->children_length1;
				_tmp6_ = _tmp5_[i];
				umockdev_ioctl_data_flush_sync (_tmp6_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == G_IO_ERROR) {
						g_propagate_error (error, _inner_error0_);
						submit_data = (g_free (submit_data), NULL);
						return;
					} else {
						submit_data = (g_free (submit_data), NULL);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				_tmp7_ = submit_data;
				_tmp7__length1 = submit_data_length1;
				_tmp8_ = self->priv->children_offset;
				_tmp8__length1 = self->priv->children_offset_length1;
				_tmp9_ = _tmp8_[i];
				_tmp10_ = self->priv->children;
				_tmp10__length1 = self->priv->children_length1;
				_tmp11_ = _tmp10_[i];
				*((gulong*) (&_tmp7_[_tmp9_])) = _tmp11_->client_addr;
			}
		}
	}
	if (self->client_addr != ((gulong) 0)) {
		guint8* _tmp14_;
		gint _tmp14__length1;
		guint8* _tmp15_;
		gint _tmp15__length1;
		_tmp14_ = submit_data;
		_tmp14__length1 = submit_data_length1;
		_tmp15_ = self->priv->client_data;
		_tmp15__length1 = self->priv->client_data_length1;
		_tmp13_ = _tmp14__length1 == _tmp15__length1;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		guint8* _tmp16_;
		gint _tmp16__length1;
		guint8* _tmp17_;
		gint _tmp17__length1;
		guint8* _tmp18_;
		gint _tmp18__length1;
		_tmp16_ = submit_data;
		_tmp16__length1 = submit_data_length1;
		_tmp17_ = self->priv->client_data;
		_tmp17__length1 = self->priv->client_data_length1;
		_tmp18_ = submit_data;
		_tmp18__length1 = submit_data_length1;
		_tmp12_ = memcmp (_tmp16_, _tmp17_, (gsize) _tmp18__length1) != 0;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		GOutputStream* output = NULL;
		GIOStream* _tmp19_;
		GOutputStream* _tmp20_;
		GOutputStream* _tmp21_;
		gulong args[3] = {0};
		guint8* _tmp22_;
		gint _tmp22__length1;
		GOutputStream* _tmp23_;
		GOutputStream* _tmp24_;
		guint8* _tmp25_;
		gint _tmp25__length1;
		_tmp19_ = self->priv->stream;
		_tmp20_ = g_io_stream_get_output_stream (_tmp19_);
		_tmp21_ = _g_object_ref0 (_tmp20_);
		output = _tmp21_;
		args[0] = (gulong) 6;
		args[1] = self->client_addr;
		_tmp22_ = submit_data;
		_tmp22__length1 = submit_data_length1;
		args[2] = (gulong) _tmp22__length1;
		_tmp23_ = output;
		g_output_stream_write_all (_tmp23_, (guint8*) args, (gsize) ((3 * sizeof (gulong)) / sizeof (guint8)), NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (output);
				submit_data = (g_free (submit_data), NULL);
				return;
			} else {
				_g_object_unref0 (output);
				submit_data = (g_free (submit_data), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_tmp24_ = output;
		_tmp25_ = submit_data;
		_tmp25__length1 = submit_data_length1;
		g_output_stream_write_all (_tmp24_, _tmp25_, (gsize) _tmp25__length1, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (output);
				submit_data = (g_free (submit_data), NULL);
				return;
			} else {
				_g_object_unref0 (output);
				submit_data = (g_free (submit_data), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_g_object_unref0 (output);
	}
	submit_data = (g_free (submit_data), NULL);
}

static void
umockdev_ioctl_data_class_init (UMockdevIoctlDataClass * klass,
                                gpointer klass_data)
{
	umockdev_ioctl_data_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UMockdevIoctlData_private_offset);
	G_OBJECT_CLASS (klass)->finalize = umockdev_ioctl_data_finalize;
}

static void
umockdev_ioctl_data_instance_init (UMockdevIoctlData * self,
                                   gpointer klass)
{
	self->priv = umockdev_ioctl_data_get_instance_private (self);
}

static void
umockdev_ioctl_data_finalize (GObject * obj)
{
	UMockdevIoctlData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, UMOCKDEV_TYPE_IOCTL_DATA, UMockdevIoctlData);
	self->priv->client_data = (g_free (self->priv->client_data), NULL);
	self->data = (g_free (self->data), NULL);
	_g_object_unref0 (self->priv->stream);
	self->priv->children = (_vala_array_free (self->priv->children, self->priv->children_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->children_offset = (g_free (self->priv->children_offset), NULL);
	G_OBJECT_CLASS (umockdev_ioctl_data_parent_class)->finalize (obj);
}

/**
 * UMockdevIoctlData:
 *
 * The #UMockdevIoctlData struct is a container designed to read and write
 * memory from the client process.
 *
 * After memory has been resolved, the corresponding pointer will point to
 * local memory that can be used normally. The memory will automatically be
 * synced back by umockdev_ioctl_client_complete().
 *
 * Since: 0.16
 */
static GType
umockdev_ioctl_data_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UMockdevIoctlDataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) umockdev_ioctl_data_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UMockdevIoctlData), 0, (GInstanceInitFunc) umockdev_ioctl_data_instance_init, NULL };
	GType umockdev_ioctl_data_type_id;
	umockdev_ioctl_data_type_id = g_type_register_static (G_TYPE_OBJECT, "UMockdevIoctlData", &g_define_type_info, 0);
	UMockdevIoctlData_private_offset = g_type_add_instance_private (umockdev_ioctl_data_type_id, sizeof (UMockdevIoctlDataPrivate));
	return umockdev_ioctl_data_type_id;
}

GType
umockdev_ioctl_data_get_type (void)
{
	static volatile gsize umockdev_ioctl_data_type_id__once = 0;
	if (g_once_init_enter (&umockdev_ioctl_data_type_id__once)) {
		GType umockdev_ioctl_data_type_id;
		umockdev_ioctl_data_type_id = umockdev_ioctl_data_get_type_once ();
		g_once_init_leave (&umockdev_ioctl_data_type_id__once, umockdev_ioctl_data_type_id);
	}
	return umockdev_ioctl_data_type_id__once;
}

static inline gpointer
umockdev_ioctl_client_get_instance_private (UMockdevIoctlClient* self)
{
	return G_STRUCT_MEMBER_P (self, UMockdevIoctlClient_private_offset);
}

const gchar*
umockdev_ioctl_client_get_devnode (UMockdevIoctlClient* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_devnode;
	result = _tmp0_;
	return result;
}

gulong
umockdev_ioctl_client_get_request (UMockdevIoctlClient* self)
{
	gulong result;
	g_return_val_if_fail (self != NULL, 0UL);
	result = self->priv->_request;
	return result;
}

UMockdevIoctlData*
umockdev_ioctl_client_get_arg (UMockdevIoctlClient* self)
{
	UMockdevIoctlData* result;
	UMockdevIoctlData* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_arg;
	result = _tmp0_;
	return result;
}

gboolean
umockdev_ioctl_client_get_connected (UMockdevIoctlClient* self)
{
	gboolean result;
	GIOStream* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->stream;
	result = !g_io_stream_is_closed (_tmp0_);
	return result;
}

/**
     * umockdev_ioctl_client_execute:
     * @self: A #UMockdevIoctlClient
     * @errno_: Return location for errno
     * @error: return location for a GError, or %NULL
     *
     * This function is not generally useful. It exists for umockdev itself
     * in order to implement recording.
     *
     * Execute the ioctl on the client side. Note that this flushes any
     * modifications of the ioctl data. As such, pointers that were already
     * resolved (including the initial ioctl argument itself) need to be
     * resolved again.
     *
     * It is only valid to call this while an uncompleted command is being
     * processed.
     *
     * This call is thread-safe.
     *
     * Returns: The client side result of the ioctl call
     *
     * Since: 0.16
     */
gint
umockdev_ioctl_client_execute (UMockdevIoctlClient* self,
                               gint* errno_,
                               GError** error)
{
	gint _vala_errno_ = 0;
	GOutputStream* output = NULL;
	GIOStream* _tmp0_;
	GOutputStream* _tmp1_;
	GOutputStream* _tmp2_;
	GInputStream* input = NULL;
	GIOStream* _tmp3_;
	GInputStream* _tmp4_;
	GInputStream* _tmp5_;
	gulong args[3] = {0};
	UMockdevIoctlData* _tmp6_;
	GOutputStream* _tmp9_;
	GInputStream* _tmp12_;
	gulong _tmp15_;
	UMockdevIoctlData* _tmp16_;
	gulong _tmp19_;
	gulong _tmp20_;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->stream;
	_tmp1_ = g_io_stream_get_output_stream (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	output = _tmp2_;
	_tmp3_ = self->priv->stream;
	_tmp4_ = g_io_stream_get_input_stream (_tmp3_);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	input = _tmp5_;
	_vala_assert (self->priv->_cmd != ((gulong) 0), "_cmd != 0");
	_tmp6_ = self->priv->_arg;
	umockdev_ioctl_data_flush_sync (_tmp6_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_IO_ERROR) {
			gint _tmp7_ = -1;
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (input);
			_g_object_unref0 (output);
			return _tmp7_;
		} else {
			gint _tmp8_ = -1;
			_g_object_unref0 (input);
			_g_object_unref0 (output);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp8_;
		}
	}
	args[0] = (gulong) 4;
	args[1] = (gulong) 0;
	args[2] = (gulong) 0;
	_tmp9_ = output;
	g_output_stream_write_all (_tmp9_, (guint8*) args, (gsize) ((3 * sizeof (gulong)) / sizeof (guint8)), NULL, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_IO_ERROR) {
			gint _tmp10_ = -1;
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (input);
			_g_object_unref0 (output);
			return _tmp10_;
		} else {
			gint _tmp11_ = -1;
			_g_object_unref0 (input);
			_g_object_unref0 (output);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp11_;
		}
	}
	_tmp12_ = input;
	g_input_stream_read_all (_tmp12_, (guint8*) args, (gsize) ((3 * sizeof (gulong)) / sizeof (guint8)), NULL, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_IO_ERROR) {
			gint _tmp13_ = -1;
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (input);
			_g_object_unref0 (output);
			return _tmp13_;
		} else {
			gint _tmp14_ = -1;
			_g_object_unref0 (input);
			_g_object_unref0 (output);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp14_;
		}
	}
	_tmp15_ = args[0];
	_vala_assert (_tmp15_ == ((gulong) 2), "args[0] == 2");
	_tmp16_ = self->priv->_arg;
	umockdev_ioctl_data_reload (_tmp16_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_IO_ERROR) {
			gint _tmp17_ = -1;
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (input);
			_g_object_unref0 (output);
			return _tmp17_;
		} else {
			gint _tmp18_ = -1;
			_g_object_unref0 (input);
			_g_object_unref0 (output);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp18_;
		}
	}
	_tmp19_ = args[2];
	_vala_errno_ = (gint) _tmp19_;
	_tmp20_ = args[1];
	result = (gint) _tmp20_;
	_g_object_unref0 (input);
	_g_object_unref0 (output);
	if (errno_) {
		*errno_ = _vala_errno_;
	}
	return result;
}

/**
     * umockdev_ioctl_client_complete:
     * @self: A #UMockdevIoctlClient
     * @res: Return value of ioctl
     * @errno_: errno of ioctl
     *
     * Asynchronously completes the ioctl invocation of the client. This is
     * equivalent to calling umockdev_ioctl_client_complete() with the
     * invocation.
     *
     * This call is thread-safe.
     *
     * Since: 0.16
     */
static gboolean
_umockdev_ioctl_client_complete_idle_gsource_func (gpointer self)
{
	gboolean result;
	result = umockdev_ioctl_client_complete_idle ((UMockdevIoctlClient*) self);
	return result;
}

void
umockdev_ioctl_client_complete (UMockdevIoctlClient* self,
                                glong res,
                                gint errno_)
{
	GMainContext* _tmp0_;
	g_return_if_fail (self != NULL);
	_vala_assert (self->priv->_cmd != ((gulong) 0), "_cmd != 0");
	self->priv->_cmd = (gulong) 0;
	self->priv->_request = (gulong) 0;
	self->priv->result = res;
	self->priv->result_errno = errno_;
	_tmp0_ = self->priv->_ctx;
	g_main_context_invoke_full (_tmp0_, G_PRIORITY_DEFAULT, _umockdev_ioctl_client_complete_idle_gsource_func, g_object_ref (self), g_object_unref);
}

/**
     * umockdev_ioctl_client_abort:
     * @self: A #UMockdevIoctlClient
     *
     * Asynchronously terminates the child by asking it to execute exit(1).
     *
     * This call is thread-safe.
     *
     * Since: 0.16
     */
void
umockdev_ioctl_client_abort (UMockdevIoctlClient* self)
{
	g_return_if_fail (self != NULL);
	self->priv->_abort = TRUE;
	umockdev_ioctl_client_complete (self, (glong) 0, 0);
}

static void
umockdev_ioctl_client_complete_async_data_free (gpointer _data)
{
	UmockdevIoctlClientCompleteAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (UmockdevIoctlClientCompleteAsyncData, _data_);
}

static void
umockdev_ioctl_client_complete_async (UMockdevIoctlClient* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	UmockdevIoctlClientCompleteAsyncData* _data_;
	UMockdevIoctlClient* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (UmockdevIoctlClientCompleteAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, umockdev_ioctl_client_complete_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	umockdev_ioctl_client_complete_async_co (_data_);
}

static void
umockdev_ioctl_client_complete_finish (UMockdevIoctlClient* self,
                                       GAsyncResult* _res_,
                                       GError** error)
{
	UmockdevIoctlClientCompleteAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
umockdev_ioctl_client_complete_async_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_)
{
	UmockdevIoctlClientCompleteAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	umockdev_ioctl_client_complete_async_co (_data_);
}

static gboolean
umockdev_ioctl_client_complete_async_co (UmockdevIoctlClientCompleteAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->stream;
	_data_->_tmp1_ = g_io_stream_get_output_stream (_data_->_tmp0_);
	_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
	_data_->output = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->self->priv->_arg;
	_data_->_state_ = 1;
	umockdev_ioctl_data_flush (_data_->_tmp3_, umockdev_ioctl_client_complete_async_ready, _data_);
	return FALSE;
	_state_1:
	umockdev_ioctl_data_flush_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->output);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (!_data_->self->priv->_abort) {
		_data_->args[0] = (gulong) 3;
		_data_->args[1] = (gulong) _data_->self->priv->result;
		_data_->args[2] = (gulong) _data_->self->priv->result_errno;
	} else {
		_data_->args[0] = (gulong) 0xff;
		_data_->args[1] = (gulong) 0;
		_data_->args[2] = (gulong) 0;
	}
	_data_->self->priv->_cmd = (gulong) 0;
	_data_->self->priv->_request = (gulong) 0;
	_g_object_unref0 (_data_->self->priv->_arg);
	_data_->self->priv->_arg = NULL;
	_data_->self->priv->result = (glong) 0;
	_data_->self->priv->result_errno = 0;
	_data_->_tmp4_ = _data_->output;
	_data_->_state_ = 2;
	g_output_stream_write_all_async (_data_->_tmp4_, (guint8*) _data_->args, (gsize) ((3 * sizeof (gulong)) / sizeof (guint8)), 0, NULL, umockdev_ioctl_client_complete_async_ready, _data_);
	return FALSE;
	_state_2:
	g_output_stream_write_all_finish (_data_->_tmp4_, _data_->_res_, NULL, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->output);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	umockdev_ioctl_client_read_ioctl (_data_->self, NULL, NULL);
	_g_object_unref0 (_data_->output);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
umockdev_ioctl_client_read_ioctl_data_free (gpointer _data)
{
	UmockdevIoctlClientReadIoctlData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (UmockdevIoctlClientReadIoctlData, _data_);
}

void
umockdev_ioctl_client_read_ioctl (UMockdevIoctlClient* self,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	UmockdevIoctlClientReadIoctlData* _data_;
	UMockdevIoctlClient* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (UmockdevIoctlClientReadIoctlData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, umockdev_ioctl_client_read_ioctl_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	umockdev_ioctl_client_read_ioctl_co (_data_);
}

void
umockdev_ioctl_client_read_ioctl_finish (UMockdevIoctlClient* self,
                                         GAsyncResult* _res_)
{
	UmockdevIoctlClientReadIoctlData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
umockdev_ioctl_client_read_ioctl_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	UmockdevIoctlClientReadIoctlData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	umockdev_ioctl_client_read_ioctl_co (_data_);
}

static gboolean
umockdev_ioctl_client_read_ioctl_co (UmockdevIoctlClientReadIoctlData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->stream;
	_data_->_tmp1_ = g_io_stream_get_input_stream (_data_->_tmp0_);
	_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
	_data_->input = _data_->_tmp2_;
	{
		_data_->_tmp3_ = _data_->input;
		_data_->_tmp4_ = 0UL;
		_data_->_state_ = 1;
		g_input_stream_read_all_async (_data_->_tmp3_, (guint8*) _data_->args, (gsize) ((3 * sizeof (gulong)) / sizeof (guint8)), 0, NULL, umockdev_ioctl_client_read_ioctl_ready, _data_);
		return FALSE;
		_state_1:
		g_input_stream_read_all_finish (_data_->_tmp3_, _data_->_res_, &_data_->_tmp4_, &_data_->_inner_error0_);
		_data_->bytes = _data_->_tmp4_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_data_->_inner_error0_);
		{
			_data_->_tmp5_ = _data_->self->priv->stream;
			_data_->_state_ = 2;
			g_io_stream_close_async (_data_->_tmp5_, G_PRIORITY_DEFAULT, NULL, umockdev_ioctl_client_read_ioctl_ready, _data_);
			return FALSE;
			_state_2:
			g_io_stream_close_finish (_data_->_tmp5_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				if (_data_->_inner_error0_->domain == G_IO_ERROR) {
					goto __catch1_g_io_error;
				}
				_g_object_unref0 (_data_->input);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		goto __finally1;
		__catch1_g_io_error:
		{
			g_clear_error (&_data_->_inner_error0_);
		}
		__finally1:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->input);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_object_unref0 (_data_->input);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->input);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = _data_->input;
	if (g_input_stream_is_closed (_data_->_tmp7_)) {
		_data_->_tmp6_ = TRUE;
	} else {
		_data_->_tmp6_ = _data_->bytes == ((gsize) 0);
	}
	if (_data_->_tmp6_) {
		{
			_data_->_tmp8_ = _data_->self->priv->stream;
			_data_->_state_ = 3;
			g_io_stream_close_async (_data_->_tmp8_, G_PRIORITY_DEFAULT, NULL, umockdev_ioctl_client_read_ioctl_ready, _data_);
			return FALSE;
			_state_3:
			g_io_stream_close_finish (_data_->_tmp8_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				if (_data_->_inner_error0_->domain == G_IO_ERROR) {
					goto __catch2_g_io_error;
				}
				_g_object_unref0 (_data_->input);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		goto __finally2;
		__catch2_g_io_error:
		{
			g_clear_error (&_data_->_inner_error0_);
		}
		__finally2:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->input);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_object_unref0 (_data_->input);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp11_ = _data_->args[0];
	if (_data_->_tmp11_ == ((gulong) 1)) {
		_data_->_tmp10_ = TRUE;
	} else {
		_data_->_tmp12_ = _data_->args[0];
		_data_->_tmp10_ = _data_->_tmp12_ == ((gulong) 7);
	}
	if (_data_->_tmp10_) {
		_data_->_tmp9_ = TRUE;
	} else {
		_data_->_tmp13_ = _data_->args[0];
		_data_->_tmp9_ = _data_->_tmp13_ == ((gulong) 8);
	}
	_vala_assert (_data_->_tmp9_, "args[0] == 1 || args[0] == 7 || args[0] == 8");
	_data_->_tmp14_ = _data_->args[0];
	_data_->self->priv->_cmd = _data_->_tmp14_;
	_data_->_tmp15_ = _data_->args[0];
	if (_data_->_tmp15_ == ((gulong) 1)) {
		_data_->_tmp16_ = _data_->args[1];
		_data_->self->priv->_request = _data_->_tmp16_;
		_data_->_tmp17_ = _data_->self->priv->stream;
		_data_->_tmp18_ = umockdev_ioctl_data_new (_data_->_tmp17_);
		_g_object_unref0 (_data_->self->priv->_arg);
		_data_->self->priv->_arg = _data_->_tmp18_;
		_data_->_tmp19_ = _data_->self->priv->_arg;
		_data_->_tmp20_ = g_new0 (guint8, sizeof (gulong));
		_data_->_tmp19_->data = (g_free (_data_->_tmp19_->data), NULL);
		_data_->_tmp19_->data = _data_->_tmp20_;
		_data_->_tmp19_->data_len = sizeof (gulong);
		_data_->_tmp21_ = _data_->self->priv->_arg;
		_data_->_tmp22_ = _data_->_tmp21_->data;
		_data_->_tmp22__length1 = _data_->_tmp21_->data_len;
		_data_->_tmp23_ = _data_->args[2];
		*((gulong*) _data_->_tmp22_) = _data_->_tmp23_;
	} else {
		_data_->self->priv->_request = (gulong) 0;
		_data_->_tmp24_ = _data_->self->priv->stream;
		_data_->_tmp25_ = umockdev_ioctl_data_new (_data_->_tmp24_);
		_g_object_unref0 (_data_->self->priv->_arg);
		_data_->self->priv->_arg = _data_->_tmp25_;
		_data_->_tmp26_ = _data_->self->priv->_arg;
		_data_->_tmp27_ = _data_->args[2];
		_data_->_tmp28_ = g_new0 (guint8, _data_->_tmp27_);
		_data_->_tmp26_->data = (g_free (_data_->_tmp26_->data), NULL);
		_data_->_tmp26_->data = _data_->_tmp28_;
		_data_->_tmp26_->data_len = _data_->_tmp27_;
		_data_->_tmp29_ = _data_->self->priv->_arg;
		_data_->_tmp30_ = _data_->args[1];
		_data_->_tmp29_->client_addr = _data_->_tmp30_;
		{
			_data_->_tmp31_ = _data_->self->priv->_arg;
			umockdev_ioctl_data_load_data (_data_->_tmp31_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				if (_data_->_inner_error0_->domain == G_IO_ERROR) {
					goto __catch3_g_io_error;
				}
				_g_object_unref0 (_data_->input);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		goto __finally3;
		__catch3_g_io_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp32_ = _data_->e;
			_data_->_tmp33_ = _data_->_tmp32_->message;
			g_warning ("umockdev-ioctl.vala:546: Error resolving IOCtl data: %s", _data_->_tmp33_);
			umockdev_ioctl_client_complete (_data_->self, (glong) -100, 0);
			_g_error_free0 (_data_->e);
			_g_object_unref0 (_data_->input);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		__finally3:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->input);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->handled = FALSE;
	_data_->_tmp34_ = _data_->args[0];
	if (_data_->_tmp34_ == ((gulong) 1)) {
		_data_->_tmp35_ = FALSE;
		g_signal_emit_by_name (_data_->self, "handle-ioctl", &_data_->_tmp35_, NULL);
		_data_->handled = _data_->_tmp35_;
	} else {
		_data_->_tmp36_ = _data_->args[0];
		if (_data_->_tmp36_ == ((gulong) 7)) {
			_data_->_tmp37_ = FALSE;
			g_signal_emit_by_name (_data_->self, "handle-read", &_data_->_tmp37_, NULL);
			_data_->handled = _data_->_tmp37_;
		} else {
			_data_->_tmp38_ = FALSE;
			g_signal_emit_by_name (_data_->self, "handle-write", &_data_->_tmp38_, NULL);
			_data_->handled = _data_->_tmp38_;
		}
	}
	if (!_data_->handled) {
		_data_->_tmp39_ = _data_->args[0];
		if (_data_->_tmp39_ == ((gulong) 1)) {
			_data_->_tmp40_ = _data_->self->priv->handler;
			_data_->_tmp41_ = FALSE;
			g_signal_emit_by_name (_data_->_tmp40_, "handle-ioctl", _data_->self, &_data_->_tmp41_, NULL);
			_data_->handled = _data_->_tmp41_;
		} else {
			_data_->_tmp42_ = _data_->args[0];
			if (_data_->_tmp42_ == ((gulong) 7)) {
				_data_->_tmp43_ = _data_->self->priv->handler;
				_data_->_tmp44_ = FALSE;
				g_signal_emit_by_name (_data_->_tmp43_, "handle-read", _data_->self, &_data_->_tmp44_, NULL);
				_data_->handled = _data_->_tmp44_;
			} else {
				_data_->_tmp45_ = _data_->self->priv->handler;
				_data_->_tmp46_ = FALSE;
				g_signal_emit_by_name (_data_->_tmp45_, "handle-write", _data_->self, &_data_->_tmp46_, NULL);
				_data_->handled = _data_->_tmp46_;
			}
		}
	}
	if (!_data_->handled) {
		_data_->_tmp48_ = _data_->args[0];
		_data_->_tmp47_ = _data_->_tmp48_ == ((gulong) 1);
	} else {
		_data_->_tmp47_ = FALSE;
	}
	if (_data_->_tmp47_) {
		_data_->tree = NULL;
		_data_->data = NULL;
		_data_->size = (gulong) ioctl_data_size_by_id (_data_->self->priv->_request);
		_data_->type = (_data_->self->priv->_request >> _IOC_TYPESHIFT) & ((1 << _IOC_TYPEBITS) - 1);
		{
			if (_data_->size > ((gulong) 0)) {
				_data_->_tmp50_ = _data_->self->priv->_arg;
				_data_->_tmp51_ = umockdev_ioctl_data_resolve (_data_->_tmp50_, (gsize) 0, (gsize) _data_->size, &_data_->_inner_error0_);
				_data_->_tmp49_ = _data_->_tmp51_;
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					if (_data_->_inner_error0_->domain == G_IO_ERROR) {
						goto __catch4_g_io_error;
					}
					_g_object_unref0 (_data_->data);
					_ioctl_tree_free0 (_data_->tree);
					_g_object_unref0 (_data_->input);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
					g_clear_error (&_data_->_inner_error0_);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_data_->_tmp52_ = _data_->_tmp49_;
				_data_->_tmp49_ = NULL;
				_g_object_unref0 (_data_->data);
				_data_->data = _data_->_tmp52_;
				_g_object_unref0 (_data_->_tmp49_);
			}
		}
		goto __finally4;
		__catch4_g_io_error:
		{
			_data_->_vala1_e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp53_ = _data_->_vala1_e;
			_data_->_tmp54_ = _data_->_tmp53_->message;
			g_warning ("umockdev-ioctl.vala:582: Error resolving IOCtl data: %s", _data_->_tmp54_);
			umockdev_ioctl_client_complete (_data_->self, (glong) -100, 0);
			_g_error_free0 (_data_->_vala1_e);
			_g_object_unref0 (_data_->data);
			_ioctl_tree_free0 (_data_->tree);
			_g_object_unref0 (_data_->input);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		__finally4:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->data);
			_ioctl_tree_free0 (_data_->tree);
			_g_object_unref0 (_data_->input);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		if (((gchar) _data_->type) == 'E') {
			errno = ENOENT;
		} else {
			errno = ENOTTY;
		}
		_data_->_tmp55_ = _data_->tree;
		_data_->_tmp56_ = _data_->self->priv->_arg;
		_data_->_tmp57_ = _data_->_tmp56_->data;
		_data_->_tmp57__length1 = _data_->_tmp56_->data_len;
		_data_->_tmp58_ = 0;
		ioctl_tree_execute (_data_->_tmp55_, NULL, _data_->self->priv->_request, *((void**) _data_->_tmp57_), &_data_->_tmp58_);
		_data_->ret = _data_->_tmp58_;
		_data_->my_errno = errno;
		errno = 0;
		if (_data_->ret != -1) {
			_data_->my_errno = 0;
		}
		umockdev_ioctl_client_complete (_data_->self, (glong) _data_->ret, _data_->my_errno);
		_g_object_unref0 (_data_->data);
		_ioctl_tree_free0 (_data_->tree);
	} else {
		if (!_data_->handled) {
			umockdev_ioctl_client_complete (_data_->self, (glong) -100, 0);
		}
	}
	_g_object_unref0 (_data_->input);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gboolean
umockdev_ioctl_client_complete_idle (UMockdevIoctlClient* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	umockdev_ioctl_client_complete_async (self, NULL, NULL);
	result = FALSE;
	return result;
}

static gboolean
umockdev_ioctl_client_notify_closed_idle (UMockdevIoctlClient* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_object_notify ((GObject*) self, "connected");
	result = FALSE;
	return result;
}

static gboolean
_umockdev_ioctl_client_notify_closed_idle_gsource_func (gpointer self)
{
	gboolean result;
	result = umockdev_ioctl_client_notify_closed_idle ((UMockdevIoctlClient*) self);
	return result;
}

static void
umockdev_ioctl_client_notify_closed_cb (UMockdevIoctlClient* self)
{
	GMainContext* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_ctx;
	g_main_context_invoke_full (_tmp0_, G_PRIORITY_DEFAULT, _umockdev_ioctl_client_notify_closed_idle_gsource_func, g_object_ref (self), g_object_unref);
}

static gpointer
_g_main_context_ref0 (gpointer self)
{
	return self ? g_main_context_ref (self) : NULL;
}

UMockdevIoctlClient*
umockdev_ioctl_client_construct (GType object_type,
                                 UMockdevIoctlBase* handler,
                                 GIOStream* stream,
                                 const gchar* devnode)
{
	UMockdevIoctlClient * self = NULL;
	UMockdevIoctlBase* _tmp0_;
	GIOStream* _tmp1_;
	gchar* _tmp2_;
	GMainContext* _tmp3_;
	GMainContext* _tmp4_;
	GIOStream* _tmp5_;
	g_return_val_if_fail (handler != NULL, NULL);
	g_return_val_if_fail (stream != NULL, NULL);
	g_return_val_if_fail (devnode != NULL, NULL);
	self = (UMockdevIoctlClient*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (handler);
	_g_object_unref0 (self->priv->handler);
	self->priv->handler = _tmp0_;
	_tmp1_ = _g_object_ref0 (stream);
	_g_object_unref0 (self->priv->stream);
	self->priv->stream = _tmp1_;
	_tmp2_ = g_strdup (devnode);
	_g_free0 (self->priv->_devnode);
	self->priv->_devnode = _tmp2_;
	_tmp3_ = g_main_context_get_thread_default ();
	_tmp4_ = _g_main_context_ref0 (_tmp3_);
	_g_main_context_unref0 (self->priv->_ctx);
	self->priv->_ctx = _tmp4_;
	_tmp5_ = self->priv->stream;
	g_signal_connect_object (_tmp5_, "notify::closed", (GCallback) umockdev_ioctl_client_notify_closed_cb, (GObject*) self, G_CONNECT_SWAPPED);
	return self;
}

UMockdevIoctlClient*
umockdev_ioctl_client_new (UMockdevIoctlBase* handler,
                           GIOStream* stream,
                           const gchar* devnode)
{
	return umockdev_ioctl_client_construct (UMOCKDEV_TYPE_IOCTL_CLIENT, handler, stream, devnode);
}

static gboolean
_umockdev_signal_accumulator_true_handled_gsignal_accumulator (GSignalInvocationHint* ihint,
                                                               GValue* return_accu,
                                                               GValue* handler_return,
                                                               void* data)
{
	gboolean result;
	result = umockdev_signal_accumulator_true_handled (ihint, return_accu, handler_return, data);
	return result;
}

static void
umockdev_ioctl_client_class_init (UMockdevIoctlClientClass * klass,
                                  gpointer klass_data)
{
	umockdev_ioctl_client_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UMockdevIoctlClient_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_umockdev_ioctl_client_get_property;
	G_OBJECT_CLASS (klass)->finalize = umockdev_ioctl_client_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UMOCKDEV_IOCTL_CLIENT_DEVNODE_PROPERTY, umockdev_ioctl_client_properties[UMOCKDEV_IOCTL_CLIENT_DEVNODE_PROPERTY] = g_param_spec_string ("devnode", "device node", "The device node the client opened", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UMOCKDEV_IOCTL_CLIENT_REQUEST_PROPERTY, umockdev_ioctl_client_properties[UMOCKDEV_IOCTL_CLIENT_REQUEST_PROPERTY] = g_param_spec_ulong ("request", "request", "The current ioctl request", 0, G_MAXULONG, 0UL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UMOCKDEV_IOCTL_CLIENT_ARG_PROPERTY, umockdev_ioctl_client_properties[UMOCKDEV_IOCTL_CLIENT_ARG_PROPERTY] = g_param_spec_object ("arg", "argument", "The ioctl argument, for read/write the passed buffer", UMOCKDEV_TYPE_IOCTL_DATA, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UMOCKDEV_IOCTL_CLIENT_CONNECTED_PROPERTY, umockdev_ioctl_client_properties[UMOCKDEV_IOCTL_CLIENT_CONNECTED_PROPERTY] = g_param_spec_boolean ("connected", "connected", "Whether the client is still connected", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_signal_new ("handle-ioctl", UMOCKDEV_TYPE_IOCTL_CLIENT, G_SIGNAL_RUN_LAST, (guint) 0, _umockdev_signal_accumulator_true_handled_gsignal_accumulator, NULL, NULL, G_TYPE_BOOLEAN, (guint) 0, NULL);
	g_signal_new ("handle-read", UMOCKDEV_TYPE_IOCTL_CLIENT, G_SIGNAL_RUN_LAST, (guint) 0, _umockdev_signal_accumulator_true_handled_gsignal_accumulator, NULL, NULL, G_TYPE_BOOLEAN, (guint) 0, NULL);
	g_signal_new ("handle-write", UMOCKDEV_TYPE_IOCTL_CLIENT, G_SIGNAL_RUN_LAST, (guint) 0, _umockdev_signal_accumulator_true_handled_gsignal_accumulator, NULL, NULL, G_TYPE_BOOLEAN, (guint) 0, NULL);
}

static void
umockdev_ioctl_client_instance_init (UMockdevIoctlClient * self,
                                     gpointer klass)
{
	self->priv = umockdev_ioctl_client_get_instance_private (self);
}

static void
umockdev_ioctl_client_finalize (GObject * obj)
{
	UMockdevIoctlClient * self;
	GIOStream* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, UMOCKDEV_TYPE_IOCTL_CLIENT, UMockdevIoctlClient);
	_tmp0_ = self->priv->stream;
	if (!g_io_stream_is_closed (_tmp0_)) {
		g_critical ("umockdev-ioctl.vala:643: Destroying IoctlClient with open stream!");
	}
	_g_object_unref0 (self->priv->handler);
	_g_object_unref0 (self->priv->stream);
	_g_main_context_unref0 (self->priv->_ctx);
	_g_free0 (self->priv->_devnode);
	_g_object_unref0 (self->priv->_arg);
	G_OBJECT_CLASS (umockdev_ioctl_client_parent_class)->finalize (obj);
}

/**
 * UMockdevIoctlClient::handle-write:
 * @client: A #UMockdevIoctlClient
 *
 * Called when a write is requested by the client.
 *
 * This is the per-client signal. See #UMockdevIoctlBase::handle-write on #UMockdevIoctlBase.
 *
 * Since: 0.16
 */
static GType
umockdev_ioctl_client_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UMockdevIoctlClientClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) umockdev_ioctl_client_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UMockdevIoctlClient), 0, (GInstanceInitFunc) umockdev_ioctl_client_instance_init, NULL };
	GType umockdev_ioctl_client_type_id;
	umockdev_ioctl_client_type_id = g_type_register_static (G_TYPE_OBJECT, "UMockdevIoctlClient", &g_define_type_info, 0);
	UMockdevIoctlClient_private_offset = g_type_add_instance_private (umockdev_ioctl_client_type_id, sizeof (UMockdevIoctlClientPrivate));
	return umockdev_ioctl_client_type_id;
}

GType
umockdev_ioctl_client_get_type (void)
{
	static volatile gsize umockdev_ioctl_client_type_id__once = 0;
	if (g_once_init_enter (&umockdev_ioctl_client_type_id__once)) {
		GType umockdev_ioctl_client_type_id;
		umockdev_ioctl_client_type_id = umockdev_ioctl_client_get_type_once ();
		g_once_init_leave (&umockdev_ioctl_client_type_id__once, umockdev_ioctl_client_type_id);
	}
	return umockdev_ioctl_client_type_id__once;
}

static void
_vala_umockdev_ioctl_client_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	UMockdevIoctlClient * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, UMOCKDEV_TYPE_IOCTL_CLIENT, UMockdevIoctlClient);
	switch (property_id) {
		case UMOCKDEV_IOCTL_CLIENT_DEVNODE_PROPERTY:
		g_value_set_string (value, umockdev_ioctl_client_get_devnode (self));
		break;
		case UMOCKDEV_IOCTL_CLIENT_REQUEST_PROPERTY:
		g_value_set_ulong (value, umockdev_ioctl_client_get_request (self));
		break;
		case UMOCKDEV_IOCTL_CLIENT_ARG_PROPERTY:
		g_value_set_object (value, umockdev_ioctl_client_get_arg (self));
		break;
		case UMOCKDEV_IOCTL_CLIENT_CONNECTED_PROPERTY:
		g_value_set_boolean (value, umockdev_ioctl_client_get_connected (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

UMockdevStartListenClosure*
umockdev_start_listen_closure_construct (GType object_type,
                                         UMockdevIoctlBase* handler,
                                         GSocketListener* listener,
                                         const gchar* devnode)
{
	UMockdevStartListenClosure* self = NULL;
	UMockdevIoctlBase* _tmp0_;
	GSocketListener* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (handler != NULL, NULL);
	g_return_val_if_fail (listener != NULL, NULL);
	g_return_val_if_fail (devnode != NULL, NULL);
	self = (UMockdevStartListenClosure*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (handler);
	_g_object_unref0 (self->handler);
	self->handler = _tmp0_;
	_tmp1_ = _g_object_ref0 (listener);
	_g_object_unref0 (self->listener);
	self->listener = _tmp1_;
	_tmp2_ = g_strdup (devnode);
	_g_free0 (self->devnode);
	self->devnode = _tmp2_;
	return self;
}

UMockdevStartListenClosure*
umockdev_start_listen_closure_new (UMockdevIoctlBase* handler,
                                   GSocketListener* listener,
                                   const gchar* devnode)
{
	return umockdev_start_listen_closure_construct (UMOCKDEV_TYPE_START_LISTEN_CLOSURE, handler, listener, devnode);
}

gboolean
umockdev_start_listen_closure_cb (UMockdevStartListenClosure* self)
{
	UMockdevIoctlBase* _tmp0_;
	GSocketListener* _tmp1_;
	const gchar* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->handler;
	_tmp1_ = self->listener;
	_tmp2_ = self->devnode;
	umockdev_ioctl_base_socket_listen (_tmp0_, _tmp1_, _tmp2_, NULL, NULL);
	result = FALSE;
	return result;
}

static void
umockdev_value_start_listen_closure_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
umockdev_value_start_listen_closure_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		umockdev_start_listen_closure_unref (value->data[0].v_pointer);
	}
}

static void
umockdev_value_start_listen_closure_copy_value (const GValue* src_value,
                                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = umockdev_start_listen_closure_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
umockdev_value_start_listen_closure_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
umockdev_value_start_listen_closure_collect_value (GValue* value,
                                                   guint n_collect_values,
                                                   GTypeCValue* collect_values,
                                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		UMockdevStartListenClosure * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = umockdev_start_listen_closure_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
umockdev_value_start_listen_closure_lcopy_value (const GValue* value,
                                                 guint n_collect_values,
                                                 GTypeCValue* collect_values,
                                                 guint collect_flags)
{
	UMockdevStartListenClosure ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = umockdev_start_listen_closure_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
umockdev_param_spec_start_listen_closure (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags)
{
	UMockdevParamSpecStartListenClosure* spec;
	g_return_val_if_fail (g_type_is_a (object_type, UMOCKDEV_TYPE_START_LISTEN_CLOSURE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
umockdev_value_get_start_listen_closure (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UMOCKDEV_TYPE_START_LISTEN_CLOSURE), NULL);
	return value->data[0].v_pointer;
}

void
umockdev_value_set_start_listen_closure (GValue* value,
                                         gpointer v_object)
{
	UMockdevStartListenClosure * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UMOCKDEV_TYPE_START_LISTEN_CLOSURE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UMOCKDEV_TYPE_START_LISTEN_CLOSURE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		umockdev_start_listen_closure_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		umockdev_start_listen_closure_unref (old);
	}
}

void
umockdev_value_take_start_listen_closure (GValue* value,
                                          gpointer v_object)
{
	UMockdevStartListenClosure * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UMOCKDEV_TYPE_START_LISTEN_CLOSURE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UMOCKDEV_TYPE_START_LISTEN_CLOSURE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		umockdev_start_listen_closure_unref (old);
	}
}

static void
umockdev_start_listen_closure_class_init (UMockdevStartListenClosureClass * klass,
                                          gpointer klass_data)
{
	umockdev_start_listen_closure_parent_class = g_type_class_peek_parent (klass);
	((UMockdevStartListenClosureClass *) klass)->finalize = umockdev_start_listen_closure_finalize;
}

static void
umockdev_start_listen_closure_instance_init (UMockdevStartListenClosure * self,
                                             gpointer klass)
{
	self->ref_count = 1;
}

static void
umockdev_start_listen_closure_finalize (UMockdevStartListenClosure * obj)
{
	UMockdevStartListenClosure * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, UMOCKDEV_TYPE_START_LISTEN_CLOSURE, UMockdevStartListenClosure);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->handler);
	_g_object_unref0 (self->listener);
	_g_free0 (self->devnode);
}

/**
 * UMockdevIoctlBase::handle-write:
 * @handler: A #UMockdevIoctlBase
 * @client: A #UMockdevIoctlClient
 *
 * Called when a write is requested by the client.
 *
 * The written buffer is represented by #UMockdevIoctlClient:arg of @client.
 * Retrieve its length to find out the requested write length. The content of
 * the buffer has already been retrieved, and you can freely use it.
 *
 * See #UMockdevIoctlBase::handle-ioctl for some more information.
 *
 * Returns: #TRUE if the request is being handled, #FALSE otherwise.
 * Since: 0.16
 */
static GType
umockdev_start_listen_closure_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { umockdev_value_start_listen_closure_init, umockdev_value_start_listen_closure_free_value, umockdev_value_start_listen_closure_copy_value, umockdev_value_start_listen_closure_peek_pointer, "p", umockdev_value_start_listen_closure_collect_value, "p", umockdev_value_start_listen_closure_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (UMockdevStartListenClosureClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) umockdev_start_listen_closure_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UMockdevStartListenClosure), 0, (GInstanceInitFunc) umockdev_start_listen_closure_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType umockdev_start_listen_closure_type_id;
	umockdev_start_listen_closure_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UMockdevStartListenClosure", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return umockdev_start_listen_closure_type_id;
}

GType
umockdev_start_listen_closure_get_type (void)
{
	static volatile gsize umockdev_start_listen_closure_type_id__once = 0;
	if (g_once_init_enter (&umockdev_start_listen_closure_type_id__once)) {
		GType umockdev_start_listen_closure_type_id;
		umockdev_start_listen_closure_type_id = umockdev_start_listen_closure_get_type_once ();
		g_once_init_leave (&umockdev_start_listen_closure_type_id__once, umockdev_start_listen_closure_type_id);
	}
	return umockdev_start_listen_closure_type_id__once;
}

gpointer
umockdev_start_listen_closure_ref (gpointer instance)
{
	UMockdevStartListenClosure * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
umockdev_start_listen_closure_unref (gpointer instance)
{
	UMockdevStartListenClosure * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		UMOCKDEV_START_LISTEN_CLOSURE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
umockdev_ioctl_base_get_instance_private (UMockdevIoctlBase* self)
{
	return G_STRUCT_MEMBER_P (self, UMockdevIoctlBase_private_offset);
}

static void
umockdev_ioctl_base_socket_listen_data_free (gpointer _data)
{
	UmockdevIoctlBaseSocketListenData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->listener);
	_g_free0 (_data_->devnode);
	_g_object_unref0 (_data_->self);
	g_slice_free (UmockdevIoctlBaseSocketListenData, _data_);
}

void
umockdev_ioctl_base_socket_listen (UMockdevIoctlBase* self,
                                   GSocketListener* listener,
                                   const gchar* devnode,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	UmockdevIoctlBaseSocketListenData* _data_;
	UMockdevIoctlBase* _tmp0_;
	GSocketListener* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (listener != NULL);
	g_return_if_fail (devnode != NULL);
	_data_ = g_slice_new0 (UmockdevIoctlBaseSocketListenData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, umockdev_ioctl_base_socket_listen_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (listener);
	_g_object_unref0 (_data_->listener);
	_data_->listener = _tmp1_;
	_tmp2_ = g_strdup (devnode);
	_g_free0 (_data_->devnode);
	_data_->devnode = _tmp2_;
	umockdev_ioctl_base_socket_listen_co (_data_);
}

void
umockdev_ioctl_base_socket_listen_finish (UMockdevIoctlBase* self,
                                          GAsyncResult* _res_)
{
	UmockdevIoctlBaseSocketListenData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
umockdev_ioctl_base_socket_listen_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	UmockdevIoctlBaseSocketListenData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	umockdev_ioctl_base_socket_listen_co (_data_);
}

static gboolean
umockdev_ioctl_base_socket_listen_co (UmockdevIoctlBaseSocketListenData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->listeners;
		g_rec_mutex_lock (&_data_->self->priv->__lock_listeners);
		{
			_data_->_tmp1_ = _data_->self->priv->listeners;
			_data_->_tmp2_ = g_hash_table_lookup (_data_->_tmp1_, _data_->devnode);
			_data_->_tmp3_ = _g_object_ref0 ((GCancellable*) _data_->_tmp2_);
			_g_object_unref0 (_data_->cancellable);
			_data_->cancellable = _data_->_tmp3_;
		}
		__finally0:
		{
			_data_->_tmp4_ = _data_->self->priv->listeners;
			g_rec_mutex_unlock (&_data_->self->priv->__lock_listeners);
		}
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->cancellable);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	{
		while (TRUE) {
			_data_->_state_ = 1;
			g_socket_listener_accept_async (_data_->listener, _data_->cancellable, umockdev_ioctl_base_socket_listen_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp6_ = g_socket_listener_accept_finish (_data_->listener, _data_->_res_, NULL, &_data_->_inner_error0_);
			_data_->_tmp5_ = _data_->_tmp6_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->client);
				_g_object_unref0 (_data_->connection);
				goto __catch1_g_error;
			}
			_data_->_tmp7_ = _data_->_tmp5_;
			_data_->_tmp5_ = NULL;
			_g_object_unref0 (_data_->connection);
			_data_->connection = _data_->_tmp7_;
			_data_->_tmp8_ = _data_->connection;
			_data_->_tmp9_ = umockdev_ioctl_client_new (_data_->self, (GIOStream*) _data_->_tmp8_, _data_->devnode);
			_g_object_unref0 (_data_->client);
			_data_->client = _data_->_tmp9_;
			_data_->_tmp10_ = _data_->client;
			g_signal_emit (_data_->self, umockdev_ioctl_base_signals[UMOCKDEV_IOCTL_BASE_CLIENT_CONNECTED_SIGNAL], 0, _data_->_tmp10_);
			_data_->_tmp11_ = _data_->client;
			umockdev_ioctl_client_read_ioctl (_data_->_tmp11_, NULL, NULL);
			_g_object_unref0 (_data_->_tmp5_);
			_g_object_unref0 (_data_->client);
			_g_object_unref0 (_data_->connection);
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		if (!g_error_matches (_data_->e, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
			_data_->_tmp12_ = _data_->e->message;
			g_error ("umockdev-ioctl.vala:797: Could not accept new connection: %s", _data_->_tmp12_);
		}
		_g_error_free0 (_data_->e);
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->cancellable);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_socket_listener_close (_data_->listener);
	_g_object_unref0 (_data_->cancellable);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gboolean
_umockdev_start_listen_closure_cb_gsource_func (gpointer self)
{
	gboolean result;
	result = umockdev_start_listen_closure_cb ((UMockdevStartListenClosure*) self);
	return result;
}

void
umockdev_ioctl_base_register_path (UMockdevIoctlBase* self,
                                   GMainContext* ctx,
                                   const gchar* devnode,
                                   const gchar* sockpath)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GCancellable* cancellable = NULL;
	GCancellable* _tmp2_;
	GCancellable* _tmp3_;
	gchar* _tmp4_;
	GSocketListener* listener = NULL;
	GSocketAddress* addr = NULL;
	GSocketListener* _tmp5_;
	GUnixSocketAddress* _tmp6_;
	UMockdevStartListenClosure* tmp = NULL;
	GSocketListener* _tmp15_;
	UMockdevStartListenClosure* _tmp16_;
	UMockdevStartListenClosure* _tmp17_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devnode != NULL);
	g_return_if_fail (sockpath != NULL);
	_tmp0_ = g_path_get_dirname (sockpath);
	_tmp1_ = _tmp0_;
	_vala_assert (g_mkdir_with_parents (_tmp1_, 0755) == 0, "DirUtils.create_with_parents(Path.get_dirname(sockpath), 0755) == 0");
	_g_free0 (_tmp1_);
	_tmp2_ = g_cancellable_new ();
	cancellable = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = g_strdup (sockpath);
	g_object_set_data_full ((GObject*) _tmp3_, "sockpath", _tmp4_, g_free);
	_tmp5_ = g_socket_listener_new ();
	_g_object_unref0 (listener);
	listener = _tmp5_;
	_tmp6_ = (GUnixSocketAddress*) g_unix_socket_address_new (sockpath);
	_g_object_unref0 (addr);
	addr = (GSocketAddress*) _tmp6_;
	{
		GSocketListener* _tmp7_;
		GSocketAddress* _tmp8_;
		_tmp7_ = listener;
		_tmp8_ = addr;
		g_socket_listener_add_address (_tmp7_, _tmp8_, G_SOCKET_TYPE_STREAM, G_SOCKET_PROTOCOL_DEFAULT, (GObject*) self, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		g_warning ("umockdev-ioctl.vala:822: Error listening on ioctl socket for %s", devnode);
		_g_object_unref0 (addr);
		_g_object_unref0 (listener);
		_g_object_unref0 (cancellable);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (addr);
		_g_object_unref0 (listener);
		_g_object_unref0 (cancellable);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	{
		GHashTable* _tmp9_;
		_tmp9_ = self->priv->listeners;
		g_rec_mutex_lock (&self->priv->__lock_listeners);
		{
			GHashTable* _tmp10_;
			gchar* _tmp11_;
			GCancellable* _tmp12_;
			GCancellable* _tmp13_;
			_tmp10_ = self->priv->listeners;
			_tmp11_ = g_strdup (devnode);
			_tmp12_ = cancellable;
			_tmp13_ = _g_object_ref0 (_tmp12_);
			g_hash_table_insert (_tmp10_, _tmp11_, _tmp13_);
		}
		__finally1:
		{
			GHashTable* _tmp14_;
			_tmp14_ = self->priv->listeners;
			g_rec_mutex_unlock (&self->priv->__lock_listeners);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (addr);
			_g_object_unref0 (listener);
			_g_object_unref0 (cancellable);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp15_ = listener;
	_tmp16_ = umockdev_start_listen_closure_new (self, _tmp15_, devnode);
	tmp = _tmp16_;
	_tmp17_ = tmp;
	g_main_context_invoke_full (ctx, G_PRIORITY_DEFAULT, _umockdev_start_listen_closure_cb_gsource_func, umockdev_start_listen_closure_ref (_tmp17_), umockdev_start_listen_closure_unref);
	_umockdev_start_listen_closure_unref0 (tmp);
	_g_object_unref0 (addr);
	_g_object_unref0 (listener);
	_g_object_unref0 (cancellable);
}

static gboolean
___lambda4_ (UMockdevIoctlBase* self,
             const gchar* key,
             GCancellable* val)
{
	gconstpointer _tmp0_;
	gboolean result;
	g_return_val_if_fail (key != NULL, FALSE);
	g_return_val_if_fail (val != NULL, FALSE);
	g_cancellable_cancel (val);
	_tmp0_ = g_object_get_data ((GObject*) val, "sockpath");
	unlink ((const gchar*) _tmp0_);
	result = TRUE;
	return result;
}

static gboolean
____lambda4__ghr_func (gconstpointer key,
                       gconstpointer value,
                       gpointer self)
{
	gboolean result;
	result = ___lambda4_ ((UMockdevIoctlBase*) self, (const gchar*) key, (GCancellable*) value);
	return result;
}

void
umockdev_ioctl_base_unregister_all (UMockdevIoctlBase* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GHashTable* _tmp0_;
		_tmp0_ = self->priv->listeners;
		g_rec_mutex_lock (&self->priv->__lock_listeners);
		{
			GHashTable* _tmp1_;
			_tmp1_ = self->priv->listeners;
			g_hash_table_foreach_remove (_tmp1_, ____lambda4__ghr_func, self);
		}
		__finally0:
		{
			GHashTable* _tmp2_;
			_tmp2_ = self->priv->listeners;
			g_rec_mutex_unlock (&self->priv->__lock_listeners);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static gboolean
umockdev_ioctl_base_real_handle_ioctl (UMockdevIoctlBase* self,
                                       UMockdevIoctlClient* client)
{
	gboolean result;
	g_return_val_if_fail (client != NULL, FALSE);
	result = FALSE;
	return result;
}

gboolean
umockdev_ioctl_base_handle_ioctl (UMockdevIoctlBase* self,
                                  UMockdevIoctlClient* client)
{
	UMockdevIoctlBaseClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = UMOCKDEV_IOCTL_BASE_GET_CLASS (self);
	if (_klass_->handle_ioctl) {
		return _klass_->handle_ioctl (self, client);
	}
	return FALSE;
}

static gboolean
umockdev_ioctl_base_real_handle_read (UMockdevIoctlBase* self,
                                      UMockdevIoctlClient* client)
{
	gboolean result;
	g_return_val_if_fail (client != NULL, FALSE);
	result = FALSE;
	return result;
}

gboolean
umockdev_ioctl_base_handle_read (UMockdevIoctlBase* self,
                                 UMockdevIoctlClient* client)
{
	UMockdevIoctlBaseClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = UMOCKDEV_IOCTL_BASE_GET_CLASS (self);
	if (_klass_->handle_read) {
		return _klass_->handle_read (self, client);
	}
	return FALSE;
}

static gboolean
umockdev_ioctl_base_real_handle_write (UMockdevIoctlBase* self,
                                       UMockdevIoctlClient* client)
{
	gboolean result;
	g_return_val_if_fail (client != NULL, FALSE);
	result = FALSE;
	return result;
}

gboolean
umockdev_ioctl_base_handle_write (UMockdevIoctlBase* self,
                                  UMockdevIoctlClient* client)
{
	UMockdevIoctlBaseClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = UMOCKDEV_IOCTL_BASE_GET_CLASS (self);
	if (_klass_->handle_write) {
		return _klass_->handle_write (self, client);
	}
	return FALSE;
}

static void
umockdev_ioctl_base_real_client_connected (UMockdevIoctlBase* self,
                                           UMockdevIoctlClient* client)
{
	g_return_if_fail (client != NULL);
}

static void
umockdev_ioctl_base_real_client_vanished (UMockdevIoctlBase* self,
                                          UMockdevIoctlClient* client)
{
	g_return_if_fail (client != NULL);
}

UMockdevIoctlBase*
umockdev_ioctl_base_construct (GType object_type)
{
	UMockdevIoctlBase * self = NULL;
	self = (UMockdevIoctlBase*) g_object_new (object_type, NULL);
	return self;
}

UMockdevIoctlBase*
umockdev_ioctl_base_new (void)
{
	return umockdev_ioctl_base_construct (UMOCKDEV_TYPE_IOCTL_BASE);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static GObject *
umockdev_ioctl_base_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	UMockdevIoctlBase * self;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	parent_class = G_OBJECT_CLASS (umockdev_ioctl_base_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, UMOCKDEV_TYPE_IOCTL_BASE, UMockdevIoctlBase);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->listeners);
	self->priv->listeners = _tmp2_;
	return obj;
}

static void
umockdev_ioctl_base_class_init (UMockdevIoctlBaseClass * klass,
                                gpointer klass_data)
{
	umockdev_ioctl_base_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UMockdevIoctlBase_private_offset);
	((UMockdevIoctlBaseClass *) klass)->handle_ioctl = (gboolean (*) (UMockdevIoctlBase*, UMockdevIoctlClient*)) umockdev_ioctl_base_real_handle_ioctl;
	((UMockdevIoctlBaseClass *) klass)->handle_read = (gboolean (*) (UMockdevIoctlBase*, UMockdevIoctlClient*)) umockdev_ioctl_base_real_handle_read;
	((UMockdevIoctlBaseClass *) klass)->handle_write = (gboolean (*) (UMockdevIoctlBase*, UMockdevIoctlClient*)) umockdev_ioctl_base_real_handle_write;
	((UMockdevIoctlBaseClass *) klass)->client_connected = umockdev_ioctl_base_real_client_connected;
	((UMockdevIoctlBaseClass *) klass)->client_vanished = umockdev_ioctl_base_real_client_vanished;
	G_OBJECT_CLASS (klass)->constructor = umockdev_ioctl_base_constructor;
	G_OBJECT_CLASS (klass)->finalize = umockdev_ioctl_base_finalize;
	umockdev_ioctl_base_signals[UMOCKDEV_IOCTL_BASE_CLIENT_CONNECTED_SIGNAL] = g_signal_new ("client-connected", UMOCKDEV_TYPE_IOCTL_BASE, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (UMockdevIoctlBaseClass, client_connected), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, UMOCKDEV_TYPE_IOCTL_CLIENT);
	umockdev_ioctl_base_signals[UMOCKDEV_IOCTL_BASE_CLIENT_VANISHED_SIGNAL] = g_signal_new ("client-vanished", UMOCKDEV_TYPE_IOCTL_BASE, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (UMockdevIoctlBaseClass, client_vanished), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, UMOCKDEV_TYPE_IOCTL_CLIENT);
	g_signal_new ("handle-ioctl", UMOCKDEV_TYPE_IOCTL_BASE, G_SIGNAL_RUN_LAST, (guint) G_STRUCT_OFFSET(UMockdevIoctlBaseClass, handle_ioctl), _umockdev_signal_accumulator_true_handled_gsignal_accumulator, NULL, NULL, G_TYPE_BOOLEAN, (guint) 1, UMOCKDEV_TYPE_IOCTL_CLIENT, NULL);
	g_signal_new ("handle-read", UMOCKDEV_TYPE_IOCTL_BASE, G_SIGNAL_RUN_LAST, (guint) G_STRUCT_OFFSET(UMockdevIoctlBaseClass, handle_read), _umockdev_signal_accumulator_true_handled_gsignal_accumulator, NULL, NULL, G_TYPE_BOOLEAN, (guint) 1, UMOCKDEV_TYPE_IOCTL_CLIENT, NULL);
	g_signal_new ("handle-write", UMOCKDEV_TYPE_IOCTL_BASE, G_SIGNAL_RUN_LAST, (guint) G_STRUCT_OFFSET(UMockdevIoctlBaseClass, handle_write), _umockdev_signal_accumulator_true_handled_gsignal_accumulator, NULL, NULL, G_TYPE_BOOLEAN, (guint) 1, UMOCKDEV_TYPE_IOCTL_CLIENT, NULL);
}

static void
umockdev_ioctl_base_instance_init (UMockdevIoctlBase * self,
                                   gpointer klass)
{
	self->priv = umockdev_ioctl_base_get_instance_private (self);
	g_rec_mutex_init (&self->priv->__lock_listeners);
}

static void
umockdev_ioctl_base_finalize (GObject * obj)
{
	UMockdevIoctlBase * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, UMOCKDEV_TYPE_IOCTL_BASE, UMockdevIoctlBase);
	g_rec_mutex_clear (&self->priv->__lock_listeners);
	_g_hash_table_unref0 (self->priv->listeners);
	G_OBJECT_CLASS (umockdev_ioctl_base_parent_class)->finalize (obj);
}

static GType
umockdev_ioctl_base_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UMockdevIoctlBaseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) umockdev_ioctl_base_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UMockdevIoctlBase), 0, (GInstanceInitFunc) umockdev_ioctl_base_instance_init, NULL };
	GType umockdev_ioctl_base_type_id;
	umockdev_ioctl_base_type_id = g_type_register_static (G_TYPE_OBJECT, "UMockdevIoctlBase", &g_define_type_info, 0);
	UMockdevIoctlBase_private_offset = g_type_add_instance_private (umockdev_ioctl_base_type_id, sizeof (UMockdevIoctlBasePrivate));
	return umockdev_ioctl_base_type_id;
}

GType
umockdev_ioctl_base_get_type (void)
{
	static volatile gsize umockdev_ioctl_base_type_id__once = 0;
	if (g_once_init_enter (&umockdev_ioctl_base_type_id__once)) {
		GType umockdev_ioctl_base_type_id;
		umockdev_ioctl_base_type_id = umockdev_ioctl_base_get_type_once ();
		g_once_init_leave (&umockdev_ioctl_base_type_id__once, umockdev_ioctl_base_type_id);
	}
	return umockdev_ioctl_base_type_id__once;
}

static inline gpointer
umockdev_ioctl_tree_handler_get_instance_private (UMockdevIoctlTreeHandler* self)
{
	return G_STRUCT_MEMBER_P (self, UMockdevIoctlTreeHandler_private_offset);
}

UMockdevIoctlTreeHandler*
umockdev_ioctl_tree_handler_construct (GType object_type,
                                       const gchar* file)
{
	UMockdevIoctlTreeHandler * self = NULL;
	FILE* f = NULL;
	FILE* _tmp0_;
	ioctl_tree* _tmp1_;
	g_return_val_if_fail (file != NULL, NULL);
	self = (UMockdevIoctlTreeHandler*) umockdev_ioctl_base_construct (object_type);
	_tmp0_ = fopen (file, "r");
	f = _tmp0_;
	_tmp1_ = ioctl_tree_read (f);
	_ioctl_tree_free0 (self->priv->tree);
	self->priv->tree = _tmp1_;
	_fclose0 (f);
	return self;
}

UMockdevIoctlTreeHandler*
umockdev_ioctl_tree_handler_new (const gchar* file)
{
	return umockdev_ioctl_tree_handler_construct (UMOCKDEV_TYPE_IOCTL_TREE_HANDLER, file);
}

static gboolean
umockdev_ioctl_tree_handler_real_handle_ioctl (UMockdevIoctlBase* base,
                                               UMockdevIoctlClient* client)
{
	UMockdevIoctlTreeHandler * self;
	void* last = NULL;
	UMockdevIoctlData* data = NULL;
	gulong request = 0UL;
	gulong _tmp0_;
	gulong _tmp1_;
	gulong size = 0UL;
	gulong type = 0UL;
	gint ret = 0;
	gint my_errno = 0;
	ioctl_tree* _tmp2_;
	gconstpointer _tmp5_;
	ioctl_tree* _tmp26_;
	void* _tmp27_;
	UMockdevIoctlData* _tmp28_;
	UMockdevIoctlData* _tmp29_;
	guint8* _tmp30_;
	gint _tmp30__length1;
	gint _tmp31_ = 0;
	void* _tmp32_;
	void* _tmp33_;
	gboolean _tmp35_ = FALSE;
	gboolean _tmp38_ = FALSE;
	gboolean _tmp39_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (UMockdevIoctlTreeHandler*) base;
	g_return_val_if_fail (client != NULL, FALSE);
	last = NULL;
	data = NULL;
	_tmp0_ = umockdev_ioctl_client_get_request (client);
	_tmp1_ = _tmp0_;
	request = _tmp1_;
	size = (gulong) ioctl_data_size_by_id (request);
	type = (request >> _IOC_TYPESHIFT) & ((1 << _IOC_TYPEBITS) - 1);
	_tmp2_ = self->priv->tree;
	if (_tmp2_ == NULL) {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = umockdev_ioctl_client_get_devnode (client);
		_tmp4_ = _tmp3_;
		g_debug ("umockdev-ioctl.vala:904: Aborting client because ioctl tree for %s is " \
"empty", _tmp4_);
		umockdev_ioctl_client_abort (client);
		result = TRUE;
		_g_object_unref0 (data);
		return result;
	}
	_tmp5_ = g_object_get_data ((GObject*) client, "last");
	last = _tmp5_;
	{
		UMockdevIoctlData* _tmp14_;
		if (request == ((gulong) CROS_EC_DEV_IOCXCMD_V2)) {
			ioctl_tree* _tmp6_;
			void* _tmp7_;
			_tmp6_ = self->priv->tree;
			_tmp7_ = last;
			size += (gulong) ioctl_tree_next_ret (_tmp6_, _tmp7_);
		}
		if (size > ((gulong) 0)) {
			UMockdevIoctlData* _tmp8_ = NULL;
			UMockdevIoctlData* _tmp9_;
			UMockdevIoctlData* _tmp10_;
			UMockdevIoctlData* _tmp11_;
			UMockdevIoctlData* _tmp13_;
			_tmp9_ = umockdev_ioctl_client_get_arg (client);
			_tmp10_ = _tmp9_;
			_tmp11_ = umockdev_ioctl_data_resolve (_tmp10_, (gsize) 0, (gsize) size, &_inner_error0_);
			_tmp8_ = _tmp11_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp12_ = FALSE;
				if (_inner_error0_->domain == G_IO_ERROR) {
					goto __catch0_g_io_error;
				}
				_g_object_unref0 (data);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp12_;
			}
			_tmp13_ = _tmp8_;
			_tmp8_ = NULL;
			_g_object_unref0 (data);
			data = _tmp13_;
			_g_object_unref0 (_tmp8_);
		}
		_tmp14_ = data;
		if (_tmp14_ != NULL) {
			if (request == ((gulong) USBDEVFS_SUBMITURB)) {
				struct usbdevfs_urb* urb = NULL;
				UMockdevIoctlData* _tmp15_;
				guint8* _tmp16_;
				gint _tmp16__length1;
				gsize offset = 0UL;
				struct usbdevfs_urb* _tmp17_;
				UMockdevIoctlData* _tmp18_;
				struct usbdevfs_urb* _tmp19_;
				UMockdevIoctlData* _tmp20_;
				UMockdevIoctlData* _tmp21_;
				_tmp15_ = data;
				_tmp16_ = _tmp15_->data;
				_tmp16__length1 = _tmp15_->data_len;
				urb = (struct usbdevfs_urb*) _tmp16_;
				_tmp17_ = urb;
				offset = (gsize) (((gulong) (&(*urb).buffer)) - ((gulong) _tmp17_));
				_tmp18_ = data;
				_tmp19_ = urb;
				_tmp20_ = umockdev_ioctl_data_resolve (_tmp18_, offset, (gsize) (*_tmp19_).buffer_length, &_inner_error0_);
				_tmp21_ = _tmp20_;
				_g_object_unref0 (_tmp21_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					gboolean _tmp22_ = FALSE;
					if (_inner_error0_->domain == G_IO_ERROR) {
						goto __catch0_g_io_error;
					}
					_g_object_unref0 (data);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp22_;
				}
			}
		}
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp23_;
		const gchar* _tmp24_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp23_ = e;
		_tmp24_ = _tmp23_->message;
		g_warning ("umockdev-ioctl.vala:932: Error resolving IOCtl data: %s", _tmp24_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (data);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp25_ = FALSE;
		_g_object_unref0 (data);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp25_;
	}
	if (((gchar) type) == 'E') {
		errno = ENOENT;
	} else {
		errno = ENOTTY;
	}
	_tmp26_ = self->priv->tree;
	_tmp27_ = last;
	_tmp28_ = umockdev_ioctl_client_get_arg (client);
	_tmp29_ = _tmp28_;
	_tmp30_ = _tmp29_->data;
	_tmp30__length1 = _tmp29_->data_len;
	_tmp32_ = ioctl_tree_execute (_tmp26_, _tmp27_, request, *((void**) _tmp30_), &_tmp31_);
	ret = _tmp31_;
	last = _tmp32_;
	my_errno = errno;
	errno = 0;
	_tmp33_ = last;
	if (_tmp33_ != NULL) {
		void* _tmp34_;
		_tmp34_ = last;
		g_object_set_data_full ((GObject*) client, "last", _tmp34_, NULL);
	}
	if (ret != -1) {
		my_errno = 0;
	}
	if (request == ((gulong) USBDEVFS_SUBMITURB)) {
		_tmp35_ = ret == 0;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		UMockdevIoctlData* _tmp36_;
		UMockdevIoctlData* _tmp37_;
		_tmp36_ = data;
		_tmp37_ = _g_object_ref0 (_tmp36_);
		_g_object_unref0 (umockdev_last_submit_urb);
		umockdev_last_submit_urb = _tmp37_;
	}
	if (request == ((gulong) USBDEVFS_REAPURB)) {
		_tmp39_ = TRUE;
	} else {
		_tmp39_ = request == ((gulong) USBDEVFS_REAPURBNDELAY);
	}
	if (_tmp39_) {
		UMockdevIoctlData* _tmp40_;
		_tmp40_ = umockdev_last_submit_urb;
		_tmp38_ = _tmp40_ != NULL;
	} else {
		_tmp38_ = FALSE;
	}
	if (_tmp38_) {
		UMockdevIoctlData* _tmp41_;
		guint8* _tmp42_;
		gint _tmp42__length1;
		UMockdevIoctlData* _tmp43_;
		guint8* _tmp44_;
		gint _tmp44__length1;
		_tmp41_ = data;
		_tmp42_ = _tmp41_->data;
		_tmp42__length1 = _tmp41_->data_len;
		_tmp43_ = umockdev_last_submit_urb;
		_tmp44_ = _tmp43_->data;
		_tmp44__length1 = _tmp43_->data_len;
		if ((*((void**) _tmp42_)) == ((void*) _tmp44_)) {
			UMockdevIoctlData* _tmp45_;
			UMockdevIoctlData* _tmp46_;
			_tmp45_ = data;
			_tmp46_ = umockdev_last_submit_urb;
			umockdev_ioctl_data_set_ptr (_tmp45_, (gsize) 0, _tmp46_);
			_g_object_unref0 (umockdev_last_submit_urb);
			umockdev_last_submit_urb = NULL;
		}
	}
	umockdev_ioctl_client_complete (client, (glong) ret, my_errno);
	result = TRUE;
	_g_object_unref0 (data);
	return result;
}

static void
umockdev_ioctl_tree_handler_class_init (UMockdevIoctlTreeHandlerClass * klass,
                                        gpointer klass_data)
{
	umockdev_ioctl_tree_handler_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UMockdevIoctlTreeHandler_private_offset);
	((UMockdevIoctlBaseClass *) klass)->handle_ioctl = (gboolean (*) (UMockdevIoctlBase*, UMockdevIoctlClient*)) umockdev_ioctl_tree_handler_real_handle_ioctl;
	G_OBJECT_CLASS (klass)->finalize = umockdev_ioctl_tree_handler_finalize;
}

static void
umockdev_ioctl_tree_handler_instance_init (UMockdevIoctlTreeHandler * self,
                                           gpointer klass)
{
	self->priv = umockdev_ioctl_tree_handler_get_instance_private (self);
}

static void
umockdev_ioctl_tree_handler_finalize (GObject * obj)
{
	UMockdevIoctlTreeHandler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, UMOCKDEV_TYPE_IOCTL_TREE_HANDLER, UMockdevIoctlTreeHandler);
	_ioctl_tree_free0 (self->priv->tree);
	G_OBJECT_CLASS (umockdev_ioctl_tree_handler_parent_class)->finalize (obj);
}

static GType
umockdev_ioctl_tree_handler_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UMockdevIoctlTreeHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) umockdev_ioctl_tree_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UMockdevIoctlTreeHandler), 0, (GInstanceInitFunc) umockdev_ioctl_tree_handler_instance_init, NULL };
	GType umockdev_ioctl_tree_handler_type_id;
	umockdev_ioctl_tree_handler_type_id = g_type_register_static (UMOCKDEV_TYPE_IOCTL_BASE, "UMockdevIoctlTreeHandler", &g_define_type_info, 0);
	UMockdevIoctlTreeHandler_private_offset = g_type_add_instance_private (umockdev_ioctl_tree_handler_type_id, sizeof (UMockdevIoctlTreeHandlerPrivate));
	return umockdev_ioctl_tree_handler_type_id;
}

GType
umockdev_ioctl_tree_handler_get_type (void)
{
	static volatile gsize umockdev_ioctl_tree_handler_type_id__once = 0;
	if (g_once_init_enter (&umockdev_ioctl_tree_handler_type_id__once)) {
		GType umockdev_ioctl_tree_handler_type_id;
		umockdev_ioctl_tree_handler_type_id = umockdev_ioctl_tree_handler_get_type_once ();
		g_once_init_leave (&umockdev_ioctl_tree_handler_type_id__once, umockdev_ioctl_tree_handler_type_id);
	}
	return umockdev_ioctl_tree_handler_type_id__once;
}

static inline gpointer
umockdev_ioctl_tree_recorder_get_instance_private (UMockdevIoctlTreeRecorder* self)
{
	return G_STRUCT_MEMBER_P (self, UMockdevIoctlTreeRecorder_private_offset);
}

UMockdevIoctlTreeRecorder*
umockdev_ioctl_tree_recorder_construct (GType object_type,
                                        const gchar* device,
                                        const gchar* file)
{
	UMockdevIoctlTreeRecorder * self = NULL;
	gchar* existing_device_path = NULL;
	FILE* log = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	FILE* _tmp3_;
	FILE* _tmp4_;
	gboolean _tmp5_ = FALSE;
	FILE* _tmp6_;
	FILE* _tmp8_;
	ioctl_tree* _tmp9_;
	g_return_val_if_fail (device != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	existing_device_path = NULL;
	self = (UMockdevIoctlTreeRecorder*) umockdev_ioctl_base_construct (object_type);
	_tmp0_ = g_strdup (file);
	_g_free0 (self->priv->logfile);
	self->priv->logfile = _tmp0_;
	_tmp1_ = g_strdup (device);
	_g_free0 (self->priv->device);
	self->priv->device = _tmp1_;
	_tmp2_ = self->priv->logfile;
	_tmp3_ = fopen (_tmp2_, "r");
	_fclose0 (log);
	log = _tmp3_;
	_tmp4_ = log;
	if (_tmp4_ == NULL) {
		_fclose0 (log);
		_g_free0 (existing_device_path);
		return self;
	}
	_tmp6_ = log;
	if (fscanf (_tmp6_, "@DEV %ms\n", &existing_device_path) == 1) {
		const gchar* _tmp7_;
		_tmp7_ = existing_device_path;
		_tmp5_ = g_strcmp0 (_tmp7_, device) != 0;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		g_error ("umockdev-ioctl.vala:996: attempt to record two different devices to th" \
"e same ioctl recording");
	}
	_tmp8_ = log;
	_tmp9_ = ioctl_tree_read (_tmp8_);
	_ioctl_tree_free0 (self->priv->tree);
	self->priv->tree = _tmp9_;
	_fclose0 (log);
	_g_free0 (existing_device_path);
	return self;
}

UMockdevIoctlTreeRecorder*
umockdev_ioctl_tree_recorder_new (const gchar* device,
                                  const gchar* file)
{
	return umockdev_ioctl_tree_recorder_construct (UMOCKDEV_TYPE_IOCTL_TREE_RECORDER, device, file);
}

static void
umockdev_ioctl_tree_recorder_flush_log (UMockdevIoctlTreeRecorder* self)
{
	FILE* log = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	FILE* _tmp2_;
	FILE* _tmp3_;
	const gchar* _tmp4_;
	ioctl_tree* _tmp5_;
	FILE* _tmp6_;
	g_return_if_fail (self != NULL);
	if (!self->priv->write_log) {
		_fclose0 (log);
		return;
	}
	_tmp0_ = self->priv->device;
	_vala_assert (_tmp0_ != NULL, "device != null");
	_tmp1_ = self->priv->logfile;
	_tmp2_ = fopen (_tmp1_, "w+");
	_fclose0 (log);
	log = _tmp2_;
	_tmp3_ = log;
	_tmp4_ = self->priv->device;
	fprintf (_tmp3_, "@DEV %s\n", _tmp4_);
	_tmp5_ = self->priv->tree;
	_tmp6_ = log;
	ioctl_tree_write (_tmp6_, _tmp5_);
	_fclose0 (log);
}

static gboolean
umockdev_ioctl_tree_recorder_real_handle_ioctl (UMockdevIoctlBase* base,
                                                UMockdevIoctlClient* client)
{
	UMockdevIoctlTreeRecorder * self;
	gulong request = 0UL;
	gulong _tmp0_;
	gulong _tmp1_;
	gulong size = 0UL;
	UMockdevIoctlData* data = NULL;
	ioctl_tree* node = NULL;
	gint ret = 0;
	gint my_errno = 0;
	UMockdevIoctlData* _tmp33_;
	UMockdevIoctlData* _tmp34_;
	guint8* _tmp35_;
	gint _tmp35__length1;
	ioctl_tree* _tmp36_;
	ioctl_tree* _tmp37_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (UMockdevIoctlTreeRecorder*) base;
	g_return_val_if_fail (client != NULL, FALSE);
	_tmp0_ = umockdev_ioctl_client_get_request (client);
	_tmp1_ = _tmp0_;
	request = _tmp1_;
	size = (gulong) ioctl_data_size_by_id (request);
	data = NULL;
	{
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		gint _tmp4_;
		UMockdevIoctlData* _tmp12_;
		_tmp4_ = umockdev_ioctl_client_execute (client, &_tmp3_, &_inner_error0_);
		my_errno = _tmp3_;
		_tmp2_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp5_ = FALSE;
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			_ioctl_tree_free0 (node);
			_g_object_unref0 (data);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp5_;
		}
		ret = _tmp2_;
		if (ret == -1) {
			umockdev_ioctl_client_complete (client, (glong) ret, my_errno);
			result = TRUE;
			_ioctl_tree_free0 (node);
			_g_object_unref0 (data);
			return result;
		}
		if (request == ((gulong) CROS_EC_DEV_IOCXCMD_V2)) {
			size += (gulong) ret;
		}
		if (size > ((gulong) 0)) {
			UMockdevIoctlData* _tmp6_ = NULL;
			UMockdevIoctlData* _tmp7_;
			UMockdevIoctlData* _tmp8_;
			UMockdevIoctlData* _tmp9_;
			UMockdevIoctlData* _tmp11_;
			_tmp7_ = umockdev_ioctl_client_get_arg (client);
			_tmp8_ = _tmp7_;
			_tmp9_ = umockdev_ioctl_data_resolve (_tmp8_, (gsize) 0, (gsize) size, &_inner_error0_);
			_tmp6_ = _tmp9_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp10_ = FALSE;
				if (_inner_error0_->domain == G_IO_ERROR) {
					goto __catch0_g_io_error;
				}
				_ioctl_tree_free0 (node);
				_g_object_unref0 (data);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp10_;
			}
			_tmp11_ = _tmp6_;
			_tmp6_ = NULL;
			_g_object_unref0 (data);
			data = _tmp11_;
			_g_object_unref0 (_tmp6_);
		}
		_tmp12_ = data;
		if (_tmp12_ != NULL) {
			UMockdevIoctlData* urb_data = NULL;
			gboolean _tmp13_ = FALSE;
			UMockdevIoctlData* _tmp21_;
			urb_data = NULL;
			if (request == ((gulong) USBDEVFS_REAPURB)) {
				_tmp13_ = TRUE;
			} else {
				_tmp13_ = request == ((gulong) USBDEVFS_REAPURBNDELAY);
			}
			if (_tmp13_) {
				UMockdevIoctlData* _tmp14_ = NULL;
				UMockdevIoctlData* _tmp15_;
				UMockdevIoctlData* _tmp16_;
				UMockdevIoctlData* _tmp18_;
				_tmp15_ = data;
				_tmp16_ = umockdev_ioctl_data_resolve (_tmp15_, (gsize) 0, (gsize) sizeof (struct usbdevfs_urb), &_inner_error0_);
				_tmp14_ = _tmp16_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					gboolean _tmp17_ = FALSE;
					_g_object_unref0 (urb_data);
					if (_inner_error0_->domain == G_IO_ERROR) {
						goto __catch0_g_io_error;
					}
					_ioctl_tree_free0 (node);
					_g_object_unref0 (data);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp17_;
				}
				_tmp18_ = _tmp14_;
				_tmp14_ = NULL;
				_g_object_unref0 (urb_data);
				urb_data = _tmp18_;
				_g_object_unref0 (_tmp14_);
			} else {
				if (request == ((gulong) USBDEVFS_SUBMITURB)) {
					UMockdevIoctlData* _tmp19_;
					UMockdevIoctlData* _tmp20_;
					_tmp19_ = data;
					_tmp20_ = _g_object_ref0 (_tmp19_);
					_g_object_unref0 (urb_data);
					urb_data = _tmp20_;
				}
			}
			_tmp21_ = urb_data;
			if (_tmp21_ != NULL) {
				struct usbdevfs_urb* urb = NULL;
				UMockdevIoctlData* _tmp22_;
				guint8* _tmp23_;
				gint _tmp23__length1;
				gsize offset = 0UL;
				struct usbdevfs_urb* _tmp24_;
				UMockdevIoctlData* _tmp25_;
				struct usbdevfs_urb* _tmp26_;
				UMockdevIoctlData* _tmp27_;
				UMockdevIoctlData* _tmp28_;
				_tmp22_ = urb_data;
				_tmp23_ = _tmp22_->data;
				_tmp23__length1 = _tmp22_->data_len;
				urb = (struct usbdevfs_urb*) _tmp23_;
				_tmp24_ = urb;
				offset = (gsize) (((gulong) (&(*urb).buffer)) - ((gulong) _tmp24_));
				_tmp25_ = urb_data;
				_tmp26_ = urb;
				_tmp27_ = umockdev_ioctl_data_resolve (_tmp25_, offset, (gsize) (*_tmp26_).buffer_length, &_inner_error0_);
				_tmp28_ = _tmp27_;
				_g_object_unref0 (_tmp28_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					gboolean _tmp29_ = FALSE;
					_g_object_unref0 (urb_data);
					if (_inner_error0_->domain == G_IO_ERROR) {
						goto __catch0_g_io_error;
					}
					_ioctl_tree_free0 (node);
					_g_object_unref0 (data);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp29_;
				}
			}
			_g_object_unref0 (urb_data);
		}
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp30_;
		const gchar* _tmp31_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp30_ = e;
		_tmp31_ = _tmp30_->message;
		g_warning ("umockdev-ioctl.vala:1068: Error executing and recording ioctl: %s", _tmp31_);
		result = FALSE;
		_g_error_free0 (e);
		_ioctl_tree_free0 (node);
		_g_object_unref0 (data);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp32_ = FALSE;
		_ioctl_tree_free0 (node);
		_g_object_unref0 (data);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp32_;
	}
	_tmp33_ = umockdev_ioctl_client_get_arg (client);
	_tmp34_ = _tmp33_;
	_tmp35_ = _tmp34_->data;
	_tmp35__length1 = _tmp34_->data_len;
	_tmp36_ = ioctl_tree_new_from_bin (request, *((void**) _tmp35_), ret);
	_ioctl_tree_free0 (node);
	node = _tmp36_;
	_tmp37_ = node;
	if (_tmp37_ != NULL) {
		ioctl_tree* _tmp38_;
		_tmp38_ = node;
		node = NULL;
		self->priv->tree = ioctl_tree_insert (self->priv->tree, _tmp38_);
	}
	umockdev_ioctl_client_complete (client, (glong) ret, my_errno);
	result = TRUE;
	_ioctl_tree_free0 (node);
	_g_object_unref0 (data);
	return result;
}

static void
umockdev_ioctl_tree_recorder_real_client_connected (UMockdevIoctlBase* base,
                                                    UMockdevIoctlClient* client)
{
	UMockdevIoctlTreeRecorder * self;
	self = (UMockdevIoctlTreeRecorder*) base;
	g_return_if_fail (client != NULL);
	self->priv->write_log = TRUE;
}

static void
umockdev_ioctl_tree_recorder_class_init (UMockdevIoctlTreeRecorderClass * klass,
                                         gpointer klass_data)
{
	umockdev_ioctl_tree_recorder_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UMockdevIoctlTreeRecorder_private_offset);
	((UMockdevIoctlBaseClass *) klass)->handle_ioctl = (gboolean (*) (UMockdevIoctlBase*, UMockdevIoctlClient*)) umockdev_ioctl_tree_recorder_real_handle_ioctl;
	((UMockdevIoctlBaseClass *) klass)->client_connected = (void (*) (UMockdevIoctlBase*, UMockdevIoctlClient*)) umockdev_ioctl_tree_recorder_real_client_connected;
	G_OBJECT_CLASS (klass)->finalize = umockdev_ioctl_tree_recorder_finalize;
}

static void
umockdev_ioctl_tree_recorder_instance_init (UMockdevIoctlTreeRecorder * self,
                                            gpointer klass)
{
	self->priv = umockdev_ioctl_tree_recorder_get_instance_private (self);
}

static void
umockdev_ioctl_tree_recorder_finalize (GObject * obj)
{
	UMockdevIoctlTreeRecorder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, UMOCKDEV_TYPE_IOCTL_TREE_RECORDER, UMockdevIoctlTreeRecorder);
	umockdev_ioctl_tree_recorder_flush_log (self);
	_g_free0 (self->priv->logfile);
	_g_free0 (self->priv->device);
	_ioctl_tree_free0 (self->priv->tree);
	G_OBJECT_CLASS (umockdev_ioctl_tree_recorder_parent_class)->finalize (obj);
}

static GType
umockdev_ioctl_tree_recorder_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UMockdevIoctlTreeRecorderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) umockdev_ioctl_tree_recorder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UMockdevIoctlTreeRecorder), 0, (GInstanceInitFunc) umockdev_ioctl_tree_recorder_instance_init, NULL };
	GType umockdev_ioctl_tree_recorder_type_id;
	umockdev_ioctl_tree_recorder_type_id = g_type_register_static (UMOCKDEV_TYPE_IOCTL_BASE, "UMockdevIoctlTreeRecorder", &g_define_type_info, 0);
	UMockdevIoctlTreeRecorder_private_offset = g_type_add_instance_private (umockdev_ioctl_tree_recorder_type_id, sizeof (UMockdevIoctlTreeRecorderPrivate));
	return umockdev_ioctl_tree_recorder_type_id;
}

GType
umockdev_ioctl_tree_recorder_get_type (void)
{
	static volatile gsize umockdev_ioctl_tree_recorder_type_id__once = 0;
	if (g_once_init_enter (&umockdev_ioctl_tree_recorder_type_id__once)) {
		GType umockdev_ioctl_tree_recorder_type_id;
		umockdev_ioctl_tree_recorder_type_id = umockdev_ioctl_tree_recorder_get_type_once ();
		g_once_init_leave (&umockdev_ioctl_tree_recorder_type_id__once, umockdev_ioctl_tree_recorder_type_id);
	}
	return umockdev_ioctl_tree_recorder_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

