// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from qml_group.h.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#pragma once

// clang-format off
#include <QJSValue>
#include <QObject>
#include <QProperty>
#include <qqmlregistration.h>


#include <properties/StyleProperty.h>

#include "LayoutPropertyGroup.h"
#include "TextPropertyGroup.h"
#include "IconPropertyGroup.h"
#include "BackgroundPropertyGroup.h"
#include "BorderPropertyGroup.h"
#include "OutlinePropertyGroup.h"
#include "CornersPropertyGroup.h"
#include "ShadowPropertyGroup.h"
// clang-format on

class QuickStyle;

/*!
 * \qmltype StylePropertyGroup
 * \inqmlmodule org.kde.union.impl
 * \ingroup qtquick-properties
 *
 * \brief A group object exposing the properties of StyleProperty to QML.
 */
class StylePropertyGroup : public QObject
{
    Q_OBJECT
    QML_ANONYMOUS

public:
    explicit StylePropertyGroup(QuickStyle *style);

    void update(const std::optional<Union::Properties::StyleProperty> &newState);
    Q_SIGNAL void updated();

    /*!
     * \qmlproperty LayoutPropertyGroup StylePropertyGroup::layout
     *
     * Exposes StyleProperty::LayoutProperty to QML.
     */
    Q_PROPERTY(LayoutPropertyGroup *layout READ layout CONSTANT)
    LayoutPropertyGroup *layout() const;

    /*!
     * \qmlproperty TextPropertyGroup StylePropertyGroup::text
     *
     * Exposes StyleProperty::TextProperty to QML.
     */
    Q_PROPERTY(TextPropertyGroup *text READ text CONSTANT)
    TextPropertyGroup *text() const;

    /*!
     * \qmlproperty IconPropertyGroup StylePropertyGroup::icon
     *
     * Exposes StyleProperty::IconProperty to QML.
     */
    Q_PROPERTY(IconPropertyGroup *icon READ icon CONSTANT)
    IconPropertyGroup *icon() const;

    /*!
     * \qmlproperty BackgroundPropertyGroup StylePropertyGroup::background
     *
     * Exposes StyleProperty::BackgroundProperty to QML.
     */
    Q_PROPERTY(BackgroundPropertyGroup *background READ background CONSTANT)
    BackgroundPropertyGroup *background() const;

    /*!
     * \qmlproperty BorderPropertyGroup StylePropertyGroup::border
     *
     * Exposes StyleProperty::BorderProperty to QML.
     */
    Q_PROPERTY(BorderPropertyGroup *border READ border CONSTANT)
    BorderPropertyGroup *border() const;

    /*!
     * \qmlproperty OutlinePropertyGroup StylePropertyGroup::outline
     *
     * Exposes StyleProperty::OutlineProperty to QML.
     */
    Q_PROPERTY(OutlinePropertyGroup *outline READ outline CONSTANT)
    OutlinePropertyGroup *outline() const;

    /*!
     * \qmlproperty CornersPropertyGroup StylePropertyGroup::corners
     *
     * Exposes StyleProperty::CornersProperty to QML.
     */
    Q_PROPERTY(CornersPropertyGroup *corners READ corners CONSTANT)
    CornersPropertyGroup *corners() const;

    /*!
     * \qmlproperty ShadowPropertyGroup StylePropertyGroup::shadow
     *
     * Exposes StyleProperty::ShadowProperty to QML.
     */
    Q_PROPERTY(ShadowPropertyGroup *shadow READ shadow CONSTANT)
    ShadowPropertyGroup *shadow() const;

private:
    QuickStyle *m_style = nullptr;
    std::unique_ptr<LayoutPropertyGroup> m_layout;
    std::unique_ptr<TextPropertyGroup> m_text;
    std::unique_ptr<IconPropertyGroup> m_icon;
    std::unique_ptr<BackgroundPropertyGroup> m_background;
    std::unique_ptr<BorderPropertyGroup> m_border;
    std::unique_ptr<OutlinePropertyGroup> m_outline;
    std::unique_ptr<CornersPropertyGroup> m_corners;
    std::unique_ptr<ShadowPropertyGroup> m_shadow;

    inline static std::optional<Union::Properties::StyleProperty> nullValue = std::nullopt;
    std::optional<Union::Properties::StyleProperty> &m_state = nullValue;
};