// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from property.cpp.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#include "TextProperty.h"

#include "PropertiesTypes.h"

using namespace Union::Properties;
using namespace Qt::StringLiterals;

class Union::Properties::TextPropertyPrivate
{
public:
    std::optional<AlignmentProperty> alignment;
    std::optional<QFont> font;
    std::optional<Union::Color> color;
};

TextProperty::TextProperty()
    : d(std::make_unique<TextPropertyPrivate>())
{
}

TextProperty::TextProperty(const TextProperty &other)
    : d(std::make_unique<TextPropertyPrivate>())
{
    d->alignment = other.d->alignment;
    d->font = other.d->font;
    d->color = other.d->color;
}

TextProperty::TextProperty(TextProperty &&other)
    : d(std::move(other.d))
{
}

TextProperty::~TextProperty() = default;

TextProperty &TextProperty::operator=(const TextProperty &other)
{
    if (this != &other) {
        d->alignment = other.d->alignment;
        d->font = other.d->font;
        d->color = other.d->color;
    }
    return *this;
}

TextProperty &TextProperty::operator=(TextProperty &&other)
{
    std::swap(d, other.d);
    return *this;
}

std::optional<AlignmentProperty> TextProperty::alignment() const
{
    return d->alignment;
}

AlignmentProperty TextProperty::alignment_or_new() const
{
    return d->alignment.value_or(AlignmentProperty{});
}

void TextProperty::setAlignment(const std::optional<AlignmentProperty> &newValue)
{
    if (newValue == d->alignment) {
        return;
    }

    d->alignment = newValue;
}
std::optional<QFont> TextProperty::font() const
{
    return d->font;
}

void TextProperty::setFont(const std::optional<QFont> &newValue)
{
    if (newValue == d->font) {
        return;
    }

    d->font = newValue;
}
std::optional<Union::Color> TextProperty::color() const
{
    return d->color;
}

void TextProperty::setColor(const std::optional<Union::Color> &newValue)
{
    if (newValue == d->color) {
        return;
    }

    d->color = newValue;
}

bool TextProperty::hasAnyValue() const
{
    if (d->alignment.has_value() && d->alignment->hasAnyValue()) {
        return true;
    }
    if (d->font.has_value()) {
        return true;
    }
    if (d->color.has_value()) {
        return true;
    }
    return false;
}

bool TextProperty::isEmpty() const
{
    if (!hasAnyValue()) {
        return true;
    }

    if (d->alignment.has_value() && !d->alignment->isEmpty()) {
        return false;
    }
    if (d->font.has_value() && d->font.value() != emptyValue<QFont>()) {
        return false;
    }
    if (d->color.has_value() && d->color.value() != emptyValue<Union::Color>()) {
        return false;
    }

    return true;
}

void TextProperty::resolveProperties(const TextProperty &source, TextProperty &destination)
{
    if (source.d->alignment.has_value()) {
        AlignmentProperty property;
        if (destination.d->alignment.has_value()) {
            property = destination.d->alignment.value();
        }
        AlignmentProperty::resolveProperties(source.d->alignment.value(), property);
        if (property.hasAnyValue()) {
            destination.d->alignment = property;
        }
    }
    if (!destination.d->font.has_value()) {
        destination.d->font = source.d->font;
    }
    if (!destination.d->color.has_value()) {
        destination.d->color = source.d->color;
    }
}

TextProperty TextProperty::empty()
{
    TextProperty result;
    result.d->alignment = emptyValue<AlignmentProperty>();
    result.d->font = emptyValue<QFont>();
    result.d->color = emptyValue<Union::Color>();
    return result;
}

bool Union::Properties::operator==(const TextProperty &left, const TextProperty &right)
{
    if (left.alignment() != right.alignment()) {
        return false;
    }
    if (left.font() != right.font()) {
        return false;
    }
    if (left.color() != right.color()) {
        return false;
    }
    return true;
}

QDebug operator<<(QDebug debug, const Union::Properties::TextProperty &type)
{
    QDebugStateSaver saver(debug);
    debug.nospace() << "TextProperty(" //
                    << "alignment: " << type.alignment() //
                    << ", font: " << type.font() //
                    << ", color: " << type.color() //
                    << ")";
    return debug;
}