/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSPermissionStatus.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "EventNames.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "JSPermissionName.h"
#include "JSPermissionState.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsPermissionStatusConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPermissionStatus_state);
static JSC_DECLARE_CUSTOM_GETTER(jsPermissionStatus_name);
static JSC_DECLARE_CUSTOM_GETTER(jsPermissionStatus_onchange);
static JSC_DECLARE_CUSTOM_SETTER(setJSPermissionStatus_onchange);

class JSPermissionStatusPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSPermissionStatusPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSPermissionStatusPrototype* ptr = new (NotNull, JSC::allocateCell<JSPermissionStatusPrototype>(vm)) JSPermissionStatusPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSPermissionStatusPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSPermissionStatusPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSPermissionStatusPrototype, JSPermissionStatusPrototype::Base);

using JSPermissionStatusDOMConstructor = JSDOMConstructorNotConstructable<JSPermissionStatus>;

template<> const ClassInfo JSPermissionStatusDOMConstructor::s_info = { "PermissionStatus"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPermissionStatusDOMConstructor) };

template<> JSValue JSPermissionStatusDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSPermissionStatusDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "PermissionStatus"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSPermissionStatus::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 4> JSPermissionStatusPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPermissionStatusConstructor, 0 } },
    HashTableValue { "state"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPermissionStatus_state, 0 } },
    HashTableValue { "name"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPermissionStatus_name, 0 } },
    HashTableValue { "onchange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPermissionStatus_onchange, setJSPermissionStatus_onchange } },
};

const ClassInfo JSPermissionStatusPrototype::s_info = { "PermissionStatus"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPermissionStatusPrototype) };

void JSPermissionStatusPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSPermissionStatus::info(), JSPermissionStatusPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSPermissionStatus::s_info = { "PermissionStatus"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPermissionStatus) };

JSPermissionStatus::JSPermissionStatus(Structure* structure, JSDOMGlobalObject& globalObject, Ref<PermissionStatus>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

Ref<PermissionStatus> JSPermissionStatus::protectedWrapped() const
{
    return wrapped();
}

static_assert(std::is_base_of<ActiveDOMObject, PermissionStatus>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSPermissionStatus::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSPermissionStatusPrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSPermissionStatusPrototype::create(vm, &globalObject, structure);
}

JSObject* JSPermissionStatus::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSPermissionStatus>(vm, globalObject);
}

JSValue JSPermissionStatus::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSPermissionStatusDOMConstructor, DOMConstructorID::PermissionStatus>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsPermissionStatusConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSPermissionStatusPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSPermissionStatus::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsPermissionStatus_stateGetter(JSGlobalObject& lexicalGlobalObject, JSPermissionStatus& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<PermissionState>>(lexicalGlobalObject, throwScope, impl.state())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPermissionStatus_state, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPermissionStatus>::get<jsPermissionStatus_stateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPermissionStatus_nameGetter(JSGlobalObject& lexicalGlobalObject, JSPermissionStatus& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<PermissionName>>(lexicalGlobalObject, throwScope, impl.name())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPermissionStatus_name, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPermissionStatus>::get<jsPermissionStatus_nameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPermissionStatus_onchangeGetter(JSGlobalObject& lexicalGlobalObject, JSPermissionStatus& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().changeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsPermissionStatus_onchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPermissionStatus>::get<jsPermissionStatus_onchangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSPermissionStatus_onchangeSetter(JSGlobalObject& lexicalGlobalObject, JSPermissionStatus& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().changeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSPermissionStatus_onchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSPermissionStatus>::set<setJSPermissionStatus_onchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSPermissionStatus::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSPermissionStatus, UseCustomHeapCellType::No>(vm, "JSPermissionStatus"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForPermissionStatus.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForPermissionStatus = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForPermissionStatus.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForPermissionStatus = std::forward<decltype(space)>(space); }
    );
}

void JSPermissionStatus::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSPermissionStatus*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSPermissionStatusOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    SUPPRESS_UNCOUNTED_LOCAL auto* jsPermissionStatus = jsCast<JSPermissionStatus*>(handle.slot()->asCell());
    SUPPRESS_UNCOUNTED_LOCAL auto& wrapped = jsPermissionStatus->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (reason) [[unlikely]]
            *reason = "ActiveDOMObject with pending activity"_s;
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSPermissionStatusOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsPermissionStatus = static_cast<JSPermissionStatus*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsPermissionStatus->protectedWrapped().ptr(), jsPermissionStatus);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7PermissionStatus@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore16PermissionStatusE[]; }
#endif
template<std::same_as<PermissionStatus> T>
static inline void verifyVTable(PermissionStatus* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7PermissionStatus@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore16PermissionStatusE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // PermissionStatus has subclasses. If PermissionStatus has subclasses that get passed
        // to toJS() we currently require PermissionStatus you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<PermissionStatus>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<PermissionStatus>(impl.ptr());
#endif
    return createWrapper<PermissionStatus>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, PermissionStatus& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

PermissionStatus* JSPermissionStatus::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSPermissionStatus*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
