/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWebTransportDatagramStats.h"

#include "JSDOMConvertNumbers.h"
#include <JavaScriptCore/JSCInlines.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<WebTransportDatagramStats>> convertDictionary<WebTransportDatagramStats>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    WebTransportDatagramStats result;
    JSValue droppedIncomingValue;
    if (isNullOrUndefined)
        droppedIncomingValue = jsUndefined();
    else {
        droppedIncomingValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "droppedIncoming"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!droppedIncomingValue.isUndefined()) {
        auto droppedIncomingConversionResult = convert<IDLUnsignedLongLong>(lexicalGlobalObject, droppedIncomingValue);
        if (droppedIncomingConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.droppedIncoming = droppedIncomingConversionResult.releaseReturnValue();
    }
    JSValue expiredOutgoingValue;
    if (isNullOrUndefined)
        expiredOutgoingValue = jsUndefined();
    else {
        expiredOutgoingValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "expiredOutgoing"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!expiredOutgoingValue.isUndefined()) {
        auto expiredOutgoingConversionResult = convert<IDLUnsignedLongLong>(lexicalGlobalObject, expiredOutgoingValue);
        if (expiredOutgoingConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.expiredOutgoing = expiredOutgoingConversionResult.releaseReturnValue();
    }
    JSValue lostOutgoingValue;
    if (isNullOrUndefined)
        lostOutgoingValue = jsUndefined();
    else {
        lostOutgoingValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "lostOutgoing"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!lostOutgoingValue.isUndefined()) {
        auto lostOutgoingConversionResult = convert<IDLUnsignedLongLong>(lexicalGlobalObject, lostOutgoingValue);
        if (lostOutgoingConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.lostOutgoing = lostOutgoingConversionResult.releaseReturnValue();
    }
    JSValue timestampValue;
    if (isNullOrUndefined)
        timestampValue = jsUndefined();
    else {
        timestampValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "timestamp"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!timestampValue.isUndefined()) {
        auto timestampConversionResult = convert<IDLDouble>(lexicalGlobalObject, timestampValue);
        if (timestampConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.timestamp = timestampConversionResult.releaseReturnValue();
    }
    return result;
}

} // namespace WebCore

