/* Device.c generated by valac 0.56.17, the Vala compiler
 * generated from Device.vala, do not modify */

/*-
 * Copyright (c) 2015-2023 elementary LLC. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "bluetooth.h"
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <pango/pango.h>

#define BLUETOOTH_INDICATOR_WIDGETS_DEVICE_DEFAULT_ICON "bluetooth"
#define BLUETOOTH_INDICATOR_WIDGETS_DEVICE_OBEX_AGENT "org.bluez.obex.Agent1"
#define BLUETOOTH_INDICATOR_WIDGETS_DEVICE_OBEX_PATH "/org/bluez/obex/elementary"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BLUETOOTH_INDICATOR_WIDGETS_DEVICE_0_PROPERTY,
	BLUETOOTH_INDICATOR_WIDGETS_DEVICE_DEVICE_PROPERTY,
	BLUETOOTH_INDICATOR_WIDGETS_DEVICE_OBEX_MANAGER_PROPERTY,
	BLUETOOTH_INDICATOR_WIDGETS_DEVICE_NUM_PROPERTIES
};
static GParamSpec* bluetooth_indicator_widgets_device_properties[BLUETOOTH_INDICATOR_WIDGETS_DEVICE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BluetoothIndicatorWidgetsDeviceToggleDeviceData BluetoothIndicatorWidgetsDeviceToggleDeviceData;
enum  {
	BLUETOOTH_INDICATOR_WIDGETS_DEVICE_SHOW_DEVICE_SIGNAL,
	BLUETOOTH_INDICATOR_WIDGETS_DEVICE_NUM_SIGNALS
};
static guint bluetooth_indicator_widgets_device_signals[BLUETOOTH_INDICATOR_WIDGETS_DEVICE_NUM_SIGNALS] = {0};

struct _BluetoothIndicatorWidgetsDevicePrivate {
	BluetoothIndicatorServicesDevice* _device;
	BluetoothIndicatorServicesObexManager* _obex_manager;
	GtkLabel* status_label;
	GtkLabel* name_label;
	GtkLabel* progress_label;
	GtkLabel* file_label;
	GtkImage* icon_image;
	GtkImage* status_image;
	GtkSpinner* spinner;
	GtkRevealer* progress_revealer;
	GtkProgressBar* progressbar;
};

struct _BluetoothIndicatorWidgetsDeviceToggleDeviceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BluetoothIndicatorWidgetsDevice* self;
	GtkRevealer* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GDBusConnection* connection;
	GDBusConnection* _tmp3_;
	GDBusConnection* _tmp4_;
	BluetoothIndicatorServicesObexTransfer* _tmp5_;
	char* _tmp6_;
	char* _tmp7_;
	char* _tmp8_;
	GVariant* _tmp9_;
	GVariant* _tmp10_;
	GVariant* _tmp11_;
	GVariant* _tmp12_;
	GError* e;
	GError* _tmp13_;
	const gchar* _tmp14_;
	GtkSpinner* _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	GtkSpinner* _tmp18_;
	GtkImage* _tmp19_;
	BluetoothIndicatorServicesDevice* _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	GtkLabel* _tmp23_;
	BluetoothIndicatorServicesDevice* _tmp24_;
	GtkLabel* _tmp25_;
	BluetoothIndicatorServicesDevice* _tmp26_;
	GError* _vala1_e;
	GError* _tmp27_;
	const gchar* _tmp28_;
	GtkLabel* _tmp29_;
	GtkImage* _tmp30_;
	GtkSpinner* _tmp31_;
	GError* _inner_error0_;
};

static gint BluetoothIndicatorWidgetsDevice_private_offset;
static gpointer bluetooth_indicator_widgets_device_parent_class = NULL;

static void bluetooth_indicator_widgets_device_on_obex_transfer_removed (BluetoothIndicatorWidgetsDevice* self,
                                                                  BluetoothIndicatorServicesObexTransfer* transfer);
static void bluetooth_indicator_widgets_device_on_obex_transfer_active (BluetoothIndicatorWidgetsDevice* self,
                                                                 const gchar* address);
static void bluetooth_indicator_widgets_device_update_transfer_progress (BluetoothIndicatorWidgetsDevice* self);
static void bluetooth_indicator_widgets_device_on_obex_transfer_added (BluetoothIndicatorWidgetsDevice* self,
                                                                const gchar* address,
                                                                BluetoothIndicatorServicesObexTransfer* transfer);
static gboolean bluetooth_indicator_widgets_device_bt_status (BluetoothIndicatorWidgetsDevice* self,
                                                       const gchar* filename);
static void bluetooth_indicator_widgets_device_toggle_device_data_free (gpointer _data);
static gboolean bluetooth_indicator_widgets_device_toggle_device_co (BluetoothIndicatorWidgetsDeviceToggleDeviceData* _data_);
static void bluetooth_indicator_widgets_device_toggle_device_ready (GObject* source_object,
                                                             GAsyncResult* _res_,
                                                             gpointer _user_data_);
static void bluetooth_indicator_widgets_device_update_status (BluetoothIndicatorWidgetsDevice* self);
static GObject * bluetooth_indicator_widgets_device_constructor (GType type,
                                                          guint n_construct_properties,
                                                          GObjectConstructParam * construct_properties);
static void _bluetooth_indicator_widgets_device_on_obex_transfer_added_bluetooth_indicator_services_obex_manager_transfer_added (BluetoothIndicatorServicesObexManager* _sender,
                                                                                                                          const gchar* address,
                                                                                                                          BluetoothIndicatorServicesObexTransfer* transfer,
                                                                                                                          gpointer self);
static void _bluetooth_indicator_widgets_device_on_obex_transfer_removed_bluetooth_indicator_services_obex_manager_transfer_removed (BluetoothIndicatorServicesObexManager* _sender,
                                                                                                                              BluetoothIndicatorServicesObexTransfer* transfer,
                                                                                                                              gpointer self);
static void _bluetooth_indicator_widgets_device_on_obex_transfer_active_bluetooth_indicator_services_obex_manager_transfer_active (BluetoothIndicatorServicesObexManager* _sender,
                                                                                                                            const gchar* address,
                                                                                                                            gpointer self);
static void _bluetooth_indicator_widgets_device_update_status_g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                                                          GVariant* changed_properties,
                                                                                          gchar** invalidated_properties,
                                                                                          gpointer self);
static void _bluetooth_indicator_widgets_device___lambda22_ (BluetoothIndicatorWidgetsDevice* self,
                                                      BluetoothIndicatorServicesObexTransfer* transfer,
                                                      const gchar* address);
static void __bluetooth_indicator_widgets_device___lambda22__gh_func (gconstpointer key,
                                                               gconstpointer value,
                                                               gpointer self);
static void bluetooth_indicator_widgets_device_finalize (GObject * obj);
static GType bluetooth_indicator_widgets_device_get_type_once (void);
static void _vala_bluetooth_indicator_widgets_device_get_property (GObject * object,
                                                            guint property_id,
                                                            GValue * value,
                                                            GParamSpec * pspec);
static void _vala_bluetooth_indicator_widgets_device_set_property (GObject * object,
                                                            guint property_id,
                                                            const GValue * value,
                                                            GParamSpec * pspec);

static inline gpointer
bluetooth_indicator_widgets_device_get_instance_private (BluetoothIndicatorWidgetsDevice* self)
{
	return G_STRUCT_MEMBER_P (self, BluetoothIndicatorWidgetsDevice_private_offset);
}

BluetoothIndicatorWidgetsDevice*
bluetooth_indicator_widgets_device_construct (GType object_type,
                                              BluetoothIndicatorServicesDevice* device,
                                              BluetoothIndicatorServicesObexManager* obex_manager)
{
	BluetoothIndicatorWidgetsDevice * self = NULL;
	g_return_val_if_fail (device != NULL, NULL);
	g_return_val_if_fail (obex_manager != NULL, NULL);
	self = (BluetoothIndicatorWidgetsDevice*) g_object_new (object_type, "device", device, "obex-manager", obex_manager, NULL);
	return self;
}

BluetoothIndicatorWidgetsDevice*
bluetooth_indicator_widgets_device_new (BluetoothIndicatorServicesDevice* device,
                                        BluetoothIndicatorServicesObexManager* obex_manager)
{
	return bluetooth_indicator_widgets_device_construct (BLUETOOTH_INDICATOR_WIDGETS_TYPE_DEVICE, device, obex_manager);
}

static void
bluetooth_indicator_widgets_device_on_obex_transfer_removed (BluetoothIndicatorWidgetsDevice* self,
                                                             BluetoothIndicatorServicesObexTransfer* transfer)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (transfer != NULL);
	bluetooth_indicator_widgets_device_hide_action (self);
}

static void
bluetooth_indicator_widgets_device_on_obex_transfer_active (BluetoothIndicatorWidgetsDevice* self,
                                                            const gchar* address)
{
	BluetoothIndicatorServicesDevice* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (address != NULL);
	_tmp0_ = self->priv->_device;
	_tmp1_ = bluetooth_indicator_services_device_get_address (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (address, _tmp3_) == 0;
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		bluetooth_indicator_widgets_device_update_transfer_progress (self);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
bluetooth_indicator_widgets_device_on_obex_transfer_added (BluetoothIndicatorWidgetsDevice* self,
                                                           const gchar* address,
                                                           BluetoothIndicatorServicesObexTransfer* transfer)
{
	BluetoothIndicatorServicesDevice* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (address != NULL);
	g_return_if_fail (transfer != NULL);
	_tmp0_ = self->priv->_device;
	_tmp1_ = bluetooth_indicator_services_device_get_address (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (address, _tmp3_) == 0;
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		BluetoothIndicatorServicesObexTransfer* _tmp5_;
		_tmp5_ = _g_object_ref0 (transfer);
		_g_object_unref0 (self->transfer);
		self->transfer = _tmp5_;
	}
}

static void
bluetooth_indicator_widgets_device_update_transfer_progress (BluetoothIndicatorWidgetsDevice* self)
{
	BluetoothIndicatorServicesObexTransfer* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GQuark _tmp5_ = 0U;
	static GQuark _tmp4_label0 = 0;
	static GQuark _tmp4_label1 = 0;
	static GQuark _tmp4_label2 = 0;
	static GQuark _tmp4_label3 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->transfer;
	_tmp1_ = bluetooth_indicator_services_obex_transfer_get_status (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp5_ = (NULL == _tmp3_) ? 0 : g_quark_from_string (_tmp3_);
	g_free (_tmp3_);
	if (_tmp5_ == ((0 != _tmp4_label0) ? _tmp4_label0 : (_tmp4_label0 = g_quark_from_static_string ("error")))) {
		switch (0) {
			default:
			{
				bluetooth_indicator_widgets_device_hide_action (self);
				break;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label1) ? _tmp4_label1 : (_tmp4_label1 = g_quark_from_static_string ("queued")))) {
		switch (0) {
			default:
			{
				bluetooth_indicator_widgets_device_hide_action (self);
				break;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label2) ? _tmp4_label2 : (_tmp4_label2 = g_quark_from_static_string ("active")))) {
		switch (0) {
			default:
			{
				GtkProgressBar* _tmp6_;
				BluetoothIndicatorServicesObexTransfer* _tmp7_;
				guint64 _tmp8_;
				guint64 _tmp9_;
				BluetoothIndicatorServicesObexTransfer* _tmp10_;
				guint64 _tmp11_;
				guint64 _tmp12_;
				GtkRevealer* _tmp13_;
				gchar* name = NULL;
				BluetoothIndicatorServicesObexTransfer* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				const gchar* _tmp17_;
				gchar* filename = NULL;
				BluetoothIndicatorServicesObexTransfer* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				const gchar* _tmp27_;
				_tmp6_ = self->priv->progressbar;
				_tmp7_ = self->transfer;
				_tmp8_ = bluetooth_indicator_services_obex_transfer_get_transferred (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = self->transfer;
				_tmp11_ = bluetooth_indicator_services_obex_transfer_get_size (_tmp10_);
				_tmp12_ = _tmp11_;
				gtk_progress_bar_set_fraction (_tmp6_, ((gdouble) _tmp9_) / ((gdouble) _tmp12_));
				_tmp13_ = self->priv->progress_revealer;
				gtk_revealer_set_reveal_child (_tmp13_, TRUE);
				_tmp14_ = self->transfer;
				_tmp15_ = bluetooth_indicator_services_obex_transfer_get_name (_tmp14_);
				_tmp16_ = _tmp15_;
				name = _tmp16_;
				_tmp17_ = name;
				if (_tmp17_ != NULL) {
					GtkLabel* _tmp18_;
					const gchar* _tmp19_;
					gchar* _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					_tmp18_ = self->priv->file_label;
					_tmp19_ = name;
					_tmp20_ = g_markup_escape_text (_tmp19_, (gssize) -1);
					_tmp21_ = _tmp20_;
					_tmp22_ = g_strdup_printf (_ ("<b>Filename</b>: %s"), _tmp21_);
					_tmp23_ = _tmp22_;
					gtk_label_set_markup (_tmp18_, _tmp23_);
					_g_free0 (_tmp23_);
					_g_free0 (_tmp21_);
				}
				_tmp24_ = self->transfer;
				_tmp25_ = bluetooth_indicator_services_obex_transfer_get_filename (_tmp24_);
				_tmp26_ = _tmp25_;
				filename = _tmp26_;
				_tmp27_ = filename;
				if (_tmp27_ != NULL) {
					const gchar* _tmp28_;
					_tmp28_ = filename;
					if (bluetooth_indicator_widgets_device_bt_status (self, _tmp28_)) {
						GtkLabel* _tmp29_;
						BluetoothIndicatorServicesObexTransfer* _tmp30_;
						guint64 _tmp31_;
						guint64 _tmp32_;
						gchar* _tmp33_;
						gchar* _tmp34_;
						BluetoothIndicatorServicesObexTransfer* _tmp35_;
						guint64 _tmp36_;
						guint64 _tmp37_;
						gchar* _tmp38_;
						gchar* _tmp39_;
						gchar* _tmp40_;
						gchar* _tmp41_;
						_tmp29_ = self->priv->progress_label;
						_tmp30_ = self->transfer;
						_tmp31_ = bluetooth_indicator_services_obex_transfer_get_transferred (_tmp30_);
						_tmp32_ = _tmp31_;
						_tmp33_ = g_format_size_full (_tmp32_, G_FORMAT_SIZE_DEFAULT);
						_tmp34_ = _tmp33_;
						_tmp35_ = self->transfer;
						_tmp36_ = bluetooth_indicator_services_obex_transfer_get_size (_tmp35_);
						_tmp37_ = _tmp36_;
						_tmp38_ = g_format_size_full (_tmp37_, G_FORMAT_SIZE_DEFAULT);
						_tmp39_ = _tmp38_;
						_tmp40_ = g_strdup_printf (_ ("Receiving… %s of %s"), _tmp34_, _tmp39_);
						_tmp41_ = _tmp40_;
						gtk_label_set_label (_tmp29_, _tmp41_);
						_g_free0 (_tmp41_);
						_g_free0 (_tmp39_);
						_g_free0 (_tmp34_);
					} else {
						GtkLabel* _tmp42_;
						BluetoothIndicatorServicesObexTransfer* _tmp43_;
						guint64 _tmp44_;
						guint64 _tmp45_;
						gchar* _tmp46_;
						gchar* _tmp47_;
						BluetoothIndicatorServicesObexTransfer* _tmp48_;
						guint64 _tmp49_;
						guint64 _tmp50_;
						gchar* _tmp51_;
						gchar* _tmp52_;
						gchar* _tmp53_;
						gchar* _tmp54_;
						_tmp42_ = self->priv->progress_label;
						_tmp43_ = self->transfer;
						_tmp44_ = bluetooth_indicator_services_obex_transfer_get_transferred (_tmp43_);
						_tmp45_ = _tmp44_;
						_tmp46_ = g_format_size_full (_tmp45_, G_FORMAT_SIZE_DEFAULT);
						_tmp47_ = _tmp46_;
						_tmp48_ = self->transfer;
						_tmp49_ = bluetooth_indicator_services_obex_transfer_get_size (_tmp48_);
						_tmp50_ = _tmp49_;
						_tmp51_ = g_format_size_full (_tmp50_, G_FORMAT_SIZE_DEFAULT);
						_tmp52_ = _tmp51_;
						_tmp53_ = g_strdup_printf (_ ("Sending… %s of %s"), _tmp47_, _tmp52_);
						_tmp54_ = _tmp53_;
						gtk_label_set_label (_tmp42_, _tmp54_);
						_g_free0 (_tmp54_);
						_g_free0 (_tmp52_);
						_g_free0 (_tmp47_);
					}
				}
				_g_free0 (filename);
				_g_free0 (name);
				break;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label3) ? _tmp4_label3 : (_tmp4_label3 = g_quark_from_static_string ("complete")))) {
		switch (0) {
			default:
			{
				bluetooth_indicator_widgets_device_hide_action (self);
				break;
			}
		}
	}
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
bluetooth_indicator_widgets_device_bt_status (BluetoothIndicatorWidgetsDevice* self,
                                              const gchar* filename)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (filename != NULL, FALSE);
	if (string_contains (filename, "/.cache/obexd")) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

void
bluetooth_indicator_widgets_device_hide_action (BluetoothIndicatorWidgetsDevice* self)
{
	GtkLabel* _tmp0_;
	GtkRevealer* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->progress_label;
	gtk_label_set_label (_tmp0_, "");
	_tmp1_ = self->priv->progress_revealer;
	gtk_revealer_set_reveal_child (_tmp1_, FALSE);
}

static void
bluetooth_indicator_widgets_device_toggle_device_data_free (gpointer _data)
{
	BluetoothIndicatorWidgetsDeviceToggleDeviceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BluetoothIndicatorWidgetsDeviceToggleDeviceData, _data_);
}

void
bluetooth_indicator_widgets_device_toggle_device (BluetoothIndicatorWidgetsDevice* self,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	BluetoothIndicatorWidgetsDeviceToggleDeviceData* _data_;
	BluetoothIndicatorWidgetsDevice* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BluetoothIndicatorWidgetsDeviceToggleDeviceData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, bluetooth_indicator_widgets_device_toggle_device_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	bluetooth_indicator_widgets_device_toggle_device_co (_data_);
}

void
bluetooth_indicator_widgets_device_toggle_device_finish (BluetoothIndicatorWidgetsDevice* self,
                                                         GAsyncResult* _res_)
{
	BluetoothIndicatorWidgetsDeviceToggleDeviceData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
bluetooth_indicator_widgets_device_toggle_device_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_)
{
	BluetoothIndicatorWidgetsDeviceToggleDeviceData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	bluetooth_indicator_widgets_device_toggle_device_co (_data_);
}

static gboolean
bluetooth_indicator_widgets_device_toggle_device_co (BluetoothIndicatorWidgetsDeviceToggleDeviceData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->progress_revealer;
	_data_->_tmp1_ = gtk_revealer_get_child_revealed (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	if (_data_->_tmp2_) {
		{
			_data_->_state_ = 1;
			g_bus_get (G_BUS_TYPE_SESSION, NULL, bluetooth_indicator_widgets_device_toggle_device_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp3_ = g_bus_get_finish (_data_->_res_, &_data_->_inner_error0_);
			_data_->connection = _data_->_tmp3_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->_tmp4_ = _data_->connection;
			_data_->_tmp5_ = _data_->self->transfer;
			_data_->_tmp6_ = bluetooth_indicator_services_obex_transfer_get_session (_data_->_tmp5_);
			_data_->_tmp7_ = _data_->_tmp6_;
			_data_->_tmp8_ = _data_->_tmp7_;
			_data_->_tmp9_ = g_variant_new ("(s)", _data_->_tmp8_, NULL);
			g_variant_ref_sink (_data_->_tmp9_);
			_data_->_tmp10_ = _data_->_tmp9_;
			_data_->_state_ = 2;
			g_dbus_connection_call (_data_->_tmp4_, BLUETOOTH_INDICATOR_WIDGETS_DEVICE_OBEX_AGENT, BLUETOOTH_INDICATOR_WIDGETS_DEVICE_OBEX_PATH, BLUETOOTH_INDICATOR_WIDGETS_DEVICE_OBEX_AGENT, "TransferActive", _data_->_tmp10_, NULL, G_DBUS_CALL_FLAGS_NONE, -1, NULL, bluetooth_indicator_widgets_device_toggle_device_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp11_ = g_dbus_connection_call_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp12_ = _data_->_tmp11_;
			_g_variant_unref0 (_data_->_tmp12_);
			_g_variant_unref0 (_data_->_tmp10_);
			_g_free0 (_data_->_tmp8_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->connection);
				goto __catch0_g_error;
			}
			_g_object_unref0 (_data_->connection);
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp13_ = _data_->e;
			_data_->_tmp14_ = _data_->_tmp13_->message;
			g_critical ("Device.vala:209: %s", _data_->_tmp14_);
			_g_error_free0 (_data_->e);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp15_ = _data_->self->priv->spinner;
	g_object_get (_data_->_tmp15_, "active", &_data_->_tmp16_, NULL);
	_data_->_tmp17_ = _data_->_tmp16_;
	if (_data_->_tmp17_) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp18_ = _data_->self->priv->spinner;
	g_object_set (_data_->_tmp18_, "active", TRUE, NULL);
	_data_->_tmp19_ = _data_->self->priv->status_image;
	g_object_set (_data_->_tmp19_, "icon-name", "emblem-mixed", NULL);
	{
		_data_->_tmp20_ = _data_->self->priv->_device;
		_data_->_tmp21_ = bluetooth_indicator_services_device_get_connected (_data_->_tmp20_);
		_data_->_tmp22_ = _data_->_tmp21_;
		if (!_data_->_tmp22_) {
			_data_->_tmp23_ = _data_->self->priv->status_label;
			gtk_label_set_label (_data_->_tmp23_, _ ("Connecting…"));
			_data_->_tmp24_ = _data_->self->priv->_device;
			_data_->_state_ = 3;
			bluetooth_indicator_services_device_connect (_data_->_tmp24_, bluetooth_indicator_widgets_device_toggle_device_ready, _data_);
			return FALSE;
			_state_3:
			bluetooth_indicator_services_device_connect_finish (_data_->_tmp24_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		} else {
			_data_->_tmp25_ = _data_->self->priv->status_label;
			gtk_label_set_label (_data_->_tmp25_, _ ("Disconnecting…"));
			_data_->_tmp26_ = _data_->self->priv->_device;
			_data_->_state_ = 4;
			bluetooth_indicator_services_device_disconnect (_data_->_tmp26_, bluetooth_indicator_widgets_device_toggle_device_ready, _data_);
			return FALSE;
			_state_4:
			bluetooth_indicator_services_device_disconnect_finish (_data_->_tmp26_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->_vala1_e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp27_ = _data_->_vala1_e;
		_data_->_tmp28_ = _data_->_tmp27_->message;
		g_critical ("Device.vala:228: %s", _data_->_tmp28_);
		_data_->_tmp29_ = _data_->self->priv->status_label;
		gtk_label_set_label (_data_->_tmp29_, _ ("Unable to Connect"));
		_data_->_tmp30_ = _data_->self->priv->status_image;
		g_object_set (_data_->_tmp30_, "icon-name", "emblem-error", NULL);
		_g_error_free0 (_data_->_vala1_e);
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp31_ = _data_->self->priv->spinner;
	g_object_set (_data_->_tmp31_, "active", FALSE, NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
bluetooth_indicator_widgets_device_update_status (BluetoothIndicatorWidgetsDevice* self)
{
	gchar* device_name = NULL;
	BluetoothIndicatorServicesDevice* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	GtkLabel* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	BluetoothIndicatorServicesDevice* _tmp35_;
	gboolean _tmp36_;
	gboolean _tmp37_;
	gchar* _tmp42_ = NULL;
	BluetoothIndicatorServicesDevice* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gboolean _tmp47_;
	GtkImage* _tmp52_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_device;
	_tmp1_ = bluetooth_indicator_services_device_get_alias (_tmp0_);
	_tmp2_ = _tmp1_;
	device_name = _tmp2_;
	_tmp3_ = device_name;
	if (_tmp3_ == NULL) {
		BluetoothIndicatorServicesDevice* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gboolean _tmp8_;
		_tmp4_ = self->priv->_device;
		_tmp5_ = bluetooth_indicator_services_device_get_icon (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_ != NULL;
		_g_free0 (_tmp7_);
		if (_tmp8_) {
			BluetoothIndicatorServicesDevice* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			GQuark _tmp14_ = 0U;
			static GQuark _tmp13_label0 = 0;
			static GQuark _tmp13_label1 = 0;
			static GQuark _tmp13_label2 = 0;
			static GQuark _tmp13_label3 = 0;
			static GQuark _tmp13_label4 = 0;
			static GQuark _tmp13_label5 = 0;
			static GQuark _tmp13_label6 = 0;
			static GQuark _tmp13_label7 = 0;
			_tmp9_ = self->priv->_device;
			_tmp10_ = bluetooth_indicator_services_device_get_icon (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = _tmp11_;
			_tmp14_ = (NULL == _tmp12_) ? 0 : g_quark_from_string (_tmp12_);
			g_free (_tmp12_);
			if (_tmp14_ == ((0 != _tmp13_label0) ? _tmp13_label0 : (_tmp13_label0 = g_quark_from_static_string ("audio-card")))) {
				switch (0) {
					default:
					{
						gchar* _tmp15_;
						_tmp15_ = g_strdup (_ ("Speaker"));
						_g_free0 (device_name);
						device_name = _tmp15_;
						break;
					}
				}
			} else if (_tmp14_ == ((0 != _tmp13_label1) ? _tmp13_label1 : (_tmp13_label1 = g_quark_from_static_string ("audio-headphones")))) {
				switch (0) {
					default:
					{
						gchar* _tmp16_;
						_tmp16_ = g_strdup (_ ("Headphones"));
						_g_free0 (device_name);
						device_name = _tmp16_;
						break;
					}
				}
			} else if (_tmp14_ == ((0 != _tmp13_label2) ? _tmp13_label2 : (_tmp13_label2 = g_quark_from_static_string ("input-gaming")))) {
				switch (0) {
					default:
					{
						gchar* _tmp17_;
						_tmp17_ = g_strdup (_ ("Controller"));
						_g_free0 (device_name);
						device_name = _tmp17_;
						break;
					}
				}
			} else if (_tmp14_ == ((0 != _tmp13_label3) ? _tmp13_label3 : (_tmp13_label3 = g_quark_from_static_string ("input-keyboard")))) {
				switch (0) {
					default:
					{
						gchar* _tmp18_;
						_tmp18_ = g_strdup (_ ("Keyboard"));
						_g_free0 (device_name);
						device_name = _tmp18_;
						break;
					}
				}
			} else if (_tmp14_ == ((0 != _tmp13_label4) ? _tmp13_label4 : (_tmp13_label4 = g_quark_from_static_string ("input-mouse")))) {
				switch (0) {
					default:
					{
						gchar* _tmp19_;
						_tmp19_ = g_strdup (_ ("Mouse"));
						_g_free0 (device_name);
						device_name = _tmp19_;
						break;
					}
				}
			} else if (_tmp14_ == ((0 != _tmp13_label5) ? _tmp13_label5 : (_tmp13_label5 = g_quark_from_static_string ("input-tablet")))) {
				switch (0) {
					default:
					{
						gchar* _tmp20_;
						_tmp20_ = g_strdup (_ ("Tablet"));
						_g_free0 (device_name);
						device_name = _tmp20_;
						break;
					}
				}
			} else if (_tmp14_ == ((0 != _tmp13_label6) ? _tmp13_label6 : (_tmp13_label6 = g_quark_from_static_string ("input-touchpad")))) {
				switch (0) {
					default:
					{
						gchar* _tmp21_;
						_tmp21_ = g_strdup (_ ("Touchpad"));
						_g_free0 (device_name);
						device_name = _tmp21_;
						break;
					}
				}
			} else if (_tmp14_ == ((0 != _tmp13_label7) ? _tmp13_label7 : (_tmp13_label7 = g_quark_from_static_string ("phone")))) {
				switch (0) {
					default:
					{
						gchar* _tmp22_;
						_tmp22_ = g_strdup (_ ("Phone"));
						_g_free0 (device_name);
						device_name = _tmp22_;
						break;
					}
				}
			} else {
				switch (0) {
					default:
					{
						BluetoothIndicatorServicesDevice* _tmp23_;
						gchar* _tmp24_;
						gchar* _tmp25_;
						_tmp23_ = self->priv->_device;
						_tmp24_ = bluetooth_indicator_services_device_get_address (_tmp23_);
						_tmp25_ = _tmp24_;
						_g_free0 (device_name);
						device_name = _tmp25_;
						break;
					}
				}
			}
		} else {
			BluetoothIndicatorServicesDevice* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			_tmp26_ = self->priv->_device;
			_tmp27_ = bluetooth_indicator_services_device_get_address (_tmp26_);
			_tmp28_ = _tmp27_;
			_g_free0 (device_name);
			device_name = _tmp28_;
		}
	}
	_tmp29_ = self->priv->name_label;
	_tmp30_ = device_name;
	_tmp31_ = g_markup_escape_text (_tmp30_, (gssize) -1);
	_tmp32_ = _tmp31_;
	_tmp33_ = g_strdup_printf ("<b>%s</b>", _tmp32_);
	_tmp34_ = _tmp33_;
	gtk_label_set_label (_tmp29_, _tmp34_);
	_g_free0 (_tmp34_);
	_g_free0 (_tmp32_);
	_tmp35_ = self->priv->_device;
	_tmp36_ = bluetooth_indicator_services_device_get_connected (_tmp35_);
	_tmp37_ = _tmp36_;
	if (_tmp37_) {
		GtkLabel* _tmp38_;
		GtkImage* _tmp39_;
		_tmp38_ = self->priv->status_label;
		gtk_label_set_label (_tmp38_, _ ("Connected"));
		_tmp39_ = self->priv->status_image;
		g_object_set (_tmp39_, "icon-name", "emblem-enabled", NULL);
	} else {
		GtkLabel* _tmp40_;
		GtkImage* _tmp41_;
		_tmp40_ = self->priv->status_label;
		gtk_label_set_label (_tmp40_, _ ("Not Connected"));
		_tmp41_ = self->priv->status_image;
		g_object_set (_tmp41_, "icon-name", "emblem-disabled", NULL);
	}
	_tmp43_ = self->priv->_device;
	_tmp44_ = bluetooth_indicator_services_device_get_icon (_tmp43_);
	_tmp45_ = _tmp44_;
	_tmp46_ = _tmp45_;
	_tmp47_ = _tmp46_ == NULL;
	_g_free0 (_tmp46_);
	if (_tmp47_) {
		gchar* _tmp48_;
		_tmp48_ = g_strdup (BLUETOOTH_INDICATOR_WIDGETS_DEVICE_DEFAULT_ICON);
		_g_free0 (_tmp42_);
		_tmp42_ = _tmp48_;
	} else {
		BluetoothIndicatorServicesDevice* _tmp49_;
		gchar* _tmp50_;
		gchar* _tmp51_;
		_tmp49_ = self->priv->_device;
		_tmp50_ = bluetooth_indicator_services_device_get_icon (_tmp49_);
		_tmp51_ = _tmp50_;
		_g_free0 (_tmp42_);
		_tmp42_ = _tmp51_;
	}
	_tmp52_ = self->priv->icon_image;
	g_object_set (_tmp52_, "icon-name", _tmp42_, NULL);
	_g_free0 (_tmp42_);
	_g_free0 (device_name);
}

BluetoothIndicatorServicesDevice*
bluetooth_indicator_widgets_device_get_device (BluetoothIndicatorWidgetsDevice* self)
{
	BluetoothIndicatorServicesDevice* result;
	BluetoothIndicatorServicesDevice* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_device;
	result = _tmp0_;
	return result;
}

static void
bluetooth_indicator_widgets_device_set_device (BluetoothIndicatorWidgetsDevice* self,
                                               BluetoothIndicatorServicesDevice* value)
{
	BluetoothIndicatorServicesDevice* old_value;
	g_return_if_fail (self != NULL);
	old_value = bluetooth_indicator_widgets_device_get_device (self);
	if (old_value != value) {
		BluetoothIndicatorServicesDevice* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_device);
		self->priv->_device = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, bluetooth_indicator_widgets_device_properties[BLUETOOTH_INDICATOR_WIDGETS_DEVICE_DEVICE_PROPERTY]);
	}
}

BluetoothIndicatorServicesObexManager*
bluetooth_indicator_widgets_device_get_obex_manager (BluetoothIndicatorWidgetsDevice* self)
{
	BluetoothIndicatorServicesObexManager* result;
	BluetoothIndicatorServicesObexManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_obex_manager;
	result = _tmp0_;
	return result;
}

static void
bluetooth_indicator_widgets_device_set_obex_manager (BluetoothIndicatorWidgetsDevice* self,
                                                     BluetoothIndicatorServicesObexManager* value)
{
	BluetoothIndicatorServicesObexManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = bluetooth_indicator_widgets_device_get_obex_manager (self);
	if (old_value != value) {
		BluetoothIndicatorServicesObexManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_obex_manager);
		self->priv->_obex_manager = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, bluetooth_indicator_widgets_device_properties[BLUETOOTH_INDICATOR_WIDGETS_DEVICE_OBEX_MANAGER_PROPERTY]);
	}
}

static void
_bluetooth_indicator_widgets_device_on_obex_transfer_added_bluetooth_indicator_services_obex_manager_transfer_added (BluetoothIndicatorServicesObexManager* _sender,
                                                                                                                     const gchar* address,
                                                                                                                     BluetoothIndicatorServicesObexTransfer* transfer,
                                                                                                                     gpointer self)
{
	bluetooth_indicator_widgets_device_on_obex_transfer_added ((BluetoothIndicatorWidgetsDevice*) self, address, transfer);
}

static void
_bluetooth_indicator_widgets_device_on_obex_transfer_removed_bluetooth_indicator_services_obex_manager_transfer_removed (BluetoothIndicatorServicesObexManager* _sender,
                                                                                                                         BluetoothIndicatorServicesObexTransfer* transfer,
                                                                                                                         gpointer self)
{
	bluetooth_indicator_widgets_device_on_obex_transfer_removed ((BluetoothIndicatorWidgetsDevice*) self, transfer);
}

static void
_bluetooth_indicator_widgets_device_on_obex_transfer_active_bluetooth_indicator_services_obex_manager_transfer_active (BluetoothIndicatorServicesObexManager* _sender,
                                                                                                                       const gchar* address,
                                                                                                                       gpointer self)
{
	bluetooth_indicator_widgets_device_on_obex_transfer_active ((BluetoothIndicatorWidgetsDevice*) self, address);
}

static void
_bluetooth_indicator_widgets_device_update_status_g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                                                     GVariant* changed_properties,
                                                                                     gchar** invalidated_properties,
                                                                                     gpointer self)
{
	bluetooth_indicator_widgets_device_update_status ((BluetoothIndicatorWidgetsDevice*) self);
}

static void
_bluetooth_indicator_widgets_device___lambda22_ (BluetoothIndicatorWidgetsDevice* self,
                                                 BluetoothIndicatorServicesObexTransfer* transfer,
                                                 const gchar* address)
{
	g_return_if_fail (transfer != NULL);
	g_return_if_fail (address != NULL);
	bluetooth_indicator_widgets_device_on_obex_transfer_added (self, address, transfer);
}

static void
__bluetooth_indicator_widgets_device___lambda22__gh_func (gconstpointer key,
                                                          gconstpointer value,
                                                          gpointer self)
{
	_bluetooth_indicator_widgets_device___lambda22_ ((BluetoothIndicatorWidgetsDevice*) self, (BluetoothIndicatorServicesObexTransfer*) key, (const gchar*) value);
}

static GObject *
bluetooth_indicator_widgets_device_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BluetoothIndicatorWidgetsDevice * self;
	BluetoothIndicatorServicesObexManager* _tmp0_;
	BluetoothIndicatorServicesObexManager* _tmp1_;
	BluetoothIndicatorServicesObexManager* _tmp2_;
	GtkLabel* _tmp3_ = NULL;
	GtkLabel* _tmp4_ = NULL;
	GtkSpinner* _tmp5_ = NULL;
	GtkSizeGroup* size_group = NULL;
	GtkSizeGroup* _tmp6_;
	GtkSizeGroup* _tmp7_;
	GtkLabel* _tmp8_;
	GtkSizeGroup* _tmp9_;
	GtkSpinner* _tmp10_;
	gchar* _tmp11_ = NULL;
	BluetoothIndicatorServicesDevice* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gboolean _tmp16_;
	GtkImage* _tmp21_;
	GtkImage* _tmp22_ = NULL;
	GtkLabel* _tmp23_ = NULL;
	GtkProgressBar* _tmp24_ = NULL;
	GtkLabel* _tmp25_ = NULL;
	GtkGrid* content_grid = NULL;
	GtkGrid* _tmp26_;
	GtkGrid* _tmp27_;
	GtkLabel* _tmp28_;
	GtkGrid* _tmp29_;
	GtkProgressBar* _tmp30_;
	GtkGrid* _tmp31_;
	GtkLabel* _tmp32_;
	GtkRevealer* _tmp33_ = NULL;
	GtkRevealer* _tmp34_;
	GtkGrid* _tmp35_;
	GtkOverlay* overlay = NULL;
	GtkOverlay* _tmp36_;
	GtkOverlay* _tmp37_;
	GtkImage* _tmp38_;
	GtkOverlay* _tmp39_;
	GtkImage* _tmp40_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp41_ = NULL;
	GtkGrid* _tmp42_;
	GtkOverlay* _tmp43_;
	GtkGrid* _tmp44_;
	GtkLabel* _tmp45_;
	GtkGrid* _tmp46_;
	GtkLabel* _tmp47_;
	GtkGrid* _tmp48_;
	GtkSpinner* _tmp49_;
	GtkGrid* box_grid = NULL;
	GtkGrid* _tmp50_;
	GtkGrid* _tmp51_;
	GtkGrid* _tmp52_;
	GtkGrid* _tmp53_;
	GtkRevealer* _tmp54_;
	GtkGrid* _tmp55_;
	BluetoothIndicatorServicesDevice* _tmp56_;
	GtkStyleContext* _tmp57_;
	BluetoothIndicatorServicesObexManager* _tmp58_;
	GHashTable* _tmp59_;
	parent_class = G_OBJECT_CLASS (bluetooth_indicator_widgets_device_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BLUETOOTH_INDICATOR_WIDGETS_TYPE_DEVICE, BluetoothIndicatorWidgetsDevice);
	_tmp0_ = self->priv->_obex_manager;
	g_signal_connect_object (_tmp0_, "transfer-added", (GCallback) _bluetooth_indicator_widgets_device_on_obex_transfer_added_bluetooth_indicator_services_obex_manager_transfer_added, self, 0);
	_tmp1_ = self->priv->_obex_manager;
	g_signal_connect_object (_tmp1_, "transfer-removed", (GCallback) _bluetooth_indicator_widgets_device_on_obex_transfer_removed_bluetooth_indicator_services_obex_manager_transfer_removed, self, 0);
	_tmp2_ = self->priv->_obex_manager;
	g_signal_connect_object (_tmp2_, "transfer-active", (GCallback) _bluetooth_indicator_widgets_device_on_obex_transfer_active_bluetooth_indicator_services_obex_manager_transfer_active, self, 0);
	_tmp3_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_widget_set_halign ((GtkWidget*) _tmp3_, GTK_ALIGN_START);
	gtk_label_set_use_markup (_tmp3_, TRUE);
	gtk_widget_set_valign ((GtkWidget*) _tmp3_, GTK_ALIGN_END);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp3_, TRUE);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->name_label);
	self->priv->name_label = _tmp3_;
	_tmp4_ = (GtkLabel*) gtk_label_new (_ ("Not Connected"));
	gtk_widget_set_halign ((GtkWidget*) _tmp4_, GTK_ALIGN_START);
	gtk_widget_set_valign ((GtkWidget*) _tmp4_, GTK_ALIGN_START);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp4_, TRUE);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->status_label);
	self->priv->status_label = _tmp4_;
	_tmp5_ = (GtkSpinner*) gtk_spinner_new ();
	gtk_widget_set_halign ((GtkWidget*) _tmp5_, GTK_ALIGN_START);
	gtk_widget_set_valign ((GtkWidget*) _tmp5_, GTK_ALIGN_START);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp5_, TRUE);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->spinner);
	self->priv->spinner = _tmp5_;
	_tmp6_ = gtk_size_group_new (GTK_SIZE_GROUP_VERTICAL);
	size_group = _tmp6_;
	_tmp7_ = size_group;
	_tmp8_ = self->priv->status_label;
	gtk_size_group_add_widget (_tmp7_, (GtkWidget*) _tmp8_);
	_tmp9_ = size_group;
	_tmp10_ = self->priv->spinner;
	gtk_size_group_add_widget (_tmp9_, (GtkWidget*) _tmp10_);
	_tmp12_ = self->priv->_device;
	_tmp13_ = bluetooth_indicator_services_device_get_icon (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = _tmp14_;
	_tmp16_ = _tmp15_ == NULL;
	_g_free0 (_tmp15_);
	if (_tmp16_) {
		gchar* _tmp17_;
		_tmp17_ = g_strdup (BLUETOOTH_INDICATOR_WIDGETS_DEVICE_DEFAULT_ICON);
		_g_free0 (_tmp11_);
		_tmp11_ = _tmp17_;
	} else {
		BluetoothIndicatorServicesDevice* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = self->priv->_device;
		_tmp19_ = bluetooth_indicator_services_device_get_icon (_tmp18_);
		_tmp20_ = _tmp19_;
		_g_free0 (_tmp11_);
		_tmp11_ = _tmp20_;
	}
	_tmp21_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp11_, (GtkIconSize) GTK_ICON_SIZE_DIALOG);
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->priv->icon_image);
	self->priv->icon_image = _tmp21_;
	_tmp22_ = (GtkImage*) gtk_image_new_from_icon_name ("emblem-disabled", (GtkIconSize) GTK_ICON_SIZE_MENU);
	gtk_widget_set_halign ((GtkWidget*) _tmp22_, GTK_ALIGN_END);
	gtk_widget_set_valign ((GtkWidget*) _tmp22_, GTK_ALIGN_END);
	g_object_ref_sink (_tmp22_);
	_g_object_unref0 (self->priv->status_image);
	self->priv->status_image = _tmp22_;
	_tmp23_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_widget_set_halign ((GtkWidget*) _tmp23_, GTK_ALIGN_START);
	gtk_widget_set_valign ((GtkWidget*) _tmp23_, GTK_ALIGN_END);
	gtk_label_set_use_markup (_tmp23_, TRUE);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp23_, TRUE);
	g_object_ref_sink (_tmp23_);
	_g_object_unref0 (self->priv->progress_label);
	self->priv->progress_label = _tmp23_;
	_tmp24_ = (GtkProgressBar*) gtk_progress_bar_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp24_, TRUE);
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (self->priv->progressbar);
	self->priv->progressbar = _tmp24_;
	_tmp25_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_label_set_ellipsize (_tmp25_, PANGO_ELLIPSIZE_MIDDLE);
	gtk_widget_set_halign ((GtkWidget*) _tmp25_, GTK_ALIGN_START);
	gtk_widget_set_valign ((GtkWidget*) _tmp25_, GTK_ALIGN_END);
	gtk_label_set_use_markup (_tmp25_, TRUE);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp25_, TRUE);
	g_object_ref_sink (_tmp25_);
	_g_object_unref0 (self->priv->file_label);
	self->priv->file_label = _tmp25_;
	_tmp26_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp26_);
	content_grid = _tmp26_;
	_tmp27_ = content_grid;
	_tmp28_ = self->priv->file_label;
	gtk_grid_attach (_tmp27_, (GtkWidget*) _tmp28_, 0, 0, 1, 1);
	_tmp29_ = content_grid;
	_tmp30_ = self->priv->progressbar;
	gtk_grid_attach (_tmp29_, (GtkWidget*) _tmp30_, 0, 1, 1, 1);
	_tmp31_ = content_grid;
	_tmp32_ = self->priv->progress_label;
	gtk_grid_attach (_tmp31_, (GtkWidget*) _tmp32_, 0, 2, 1, 1);
	_tmp33_ = (GtkRevealer*) gtk_revealer_new ();
	gtk_revealer_set_transition_type (_tmp33_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_DOWN);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp33_, 5);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp33_, 5);
	g_object_ref_sink (_tmp33_);
	_g_object_unref0 (self->priv->progress_revealer);
	self->priv->progress_revealer = _tmp33_;
	_tmp34_ = self->priv->progress_revealer;
	_tmp35_ = content_grid;
	gtk_container_add ((GtkContainer*) _tmp34_, (GtkWidget*) _tmp35_);
	_tmp36_ = (GtkOverlay*) gtk_overlay_new ();
	g_object_ref_sink (_tmp36_);
	overlay = _tmp36_;
	_tmp37_ = overlay;
	_tmp38_ = self->priv->icon_image;
	gtk_container_add ((GtkContainer*) _tmp37_, (GtkWidget*) _tmp38_);
	_tmp39_ = overlay;
	_tmp40_ = self->priv->status_image;
	gtk_overlay_add_overlay (_tmp39_, (GtkWidget*) _tmp40_);
	_tmp41_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp41_, 5);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp41_, 5);
	g_object_ref_sink (_tmp41_);
	grid = _tmp41_;
	_tmp42_ = grid;
	_tmp43_ = overlay;
	gtk_grid_attach (_tmp42_, (GtkWidget*) _tmp43_, 0, 0, 1, 2);
	_tmp44_ = grid;
	_tmp45_ = self->priv->name_label;
	gtk_grid_attach (_tmp44_, (GtkWidget*) _tmp45_, 1, 0, 2, 1);
	_tmp46_ = grid;
	_tmp47_ = self->priv->status_label;
	gtk_grid_attach (_tmp46_, (GtkWidget*) _tmp47_, 1, 1, 1, 1);
	_tmp48_ = grid;
	_tmp49_ = self->priv->spinner;
	gtk_grid_attach (_tmp48_, (GtkWidget*) _tmp49_, 2, 1, 1, 1);
	_tmp50_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp50_);
	box_grid = _tmp50_;
	_tmp51_ = box_grid;
	_tmp52_ = grid;
	gtk_grid_attach (_tmp51_, (GtkWidget*) _tmp52_, 0, 0, 1, 1);
	_tmp53_ = box_grid;
	_tmp54_ = self->priv->progress_revealer;
	gtk_grid_attach (_tmp53_, (GtkWidget*) _tmp54_, 0, 1, 1, 1);
	_tmp55_ = box_grid;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp55_);
	_tmp56_ = self->priv->_device;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, g_dbus_proxy_get_type (), GDBusProxy), "g-properties-changed", (GCallback) _bluetooth_indicator_widgets_device_update_status_g_dbus_proxy_g_properties_changed, self, 0);
	bluetooth_indicator_widgets_device_update_status (self);
	_tmp57_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp57_, GTK_STYLE_CLASS_MENUITEM);
	gtk_list_box_row_set_selectable ((GtkListBoxRow*) self, FALSE);
	_tmp58_ = self->priv->_obex_manager;
	_tmp59_ = _tmp58_->active_transfers;
	g_hash_table_foreach (_tmp59_, __bluetooth_indicator_widgets_device___lambda22__gh_func, self);
	_g_object_unref0 (box_grid);
	_g_object_unref0 (grid);
	_g_object_unref0 (overlay);
	_g_object_unref0 (content_grid);
	_g_free0 (_tmp11_);
	_g_object_unref0 (size_group);
	return obj;
}

static void
bluetooth_indicator_widgets_device_class_init (BluetoothIndicatorWidgetsDeviceClass * klass,
                                               gpointer klass_data)
{
	bluetooth_indicator_widgets_device_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BluetoothIndicatorWidgetsDevice_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_bluetooth_indicator_widgets_device_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_bluetooth_indicator_widgets_device_set_property;
	G_OBJECT_CLASS (klass)->constructor = bluetooth_indicator_widgets_device_constructor;
	G_OBJECT_CLASS (klass)->finalize = bluetooth_indicator_widgets_device_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BLUETOOTH_INDICATOR_WIDGETS_DEVICE_DEVICE_PROPERTY, bluetooth_indicator_widgets_device_properties[BLUETOOTH_INDICATOR_WIDGETS_DEVICE_DEVICE_PROPERTY] = g_param_spec_object ("device", "device", "device", BLUETOOTH_INDICATOR_SERVICES_TYPE_DEVICE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BLUETOOTH_INDICATOR_WIDGETS_DEVICE_OBEX_MANAGER_PROPERTY, bluetooth_indicator_widgets_device_properties[BLUETOOTH_INDICATOR_WIDGETS_DEVICE_OBEX_MANAGER_PROPERTY] = g_param_spec_object ("obex-manager", "obex-manager", "obex-manager", BLUETOOTH_INDICATOR_SERVICES_TYPE_OBEX_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	bluetooth_indicator_widgets_device_signals[BLUETOOTH_INDICATOR_WIDGETS_DEVICE_SHOW_DEVICE_SIGNAL] = g_signal_new ("show-device", BLUETOOTH_INDICATOR_WIDGETS_TYPE_DEVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, BLUETOOTH_INDICATOR_SERVICES_TYPE_DEVICE);
}

static void
bluetooth_indicator_widgets_device_instance_init (BluetoothIndicatorWidgetsDevice * self,
                                                  gpointer klass)
{
	self->priv = bluetooth_indicator_widgets_device_get_instance_private (self);
}

static void
bluetooth_indicator_widgets_device_finalize (GObject * obj)
{
	BluetoothIndicatorWidgetsDevice * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BLUETOOTH_INDICATOR_WIDGETS_TYPE_DEVICE, BluetoothIndicatorWidgetsDevice);
	_g_object_unref0 (self->priv->_device);
	_g_object_unref0 (self->priv->_obex_manager);
	_g_object_unref0 (self->transfer);
	_g_object_unref0 (self->priv->status_label);
	_g_object_unref0 (self->priv->name_label);
	_g_object_unref0 (self->priv->progress_label);
	_g_object_unref0 (self->priv->file_label);
	_g_object_unref0 (self->priv->icon_image);
	_g_object_unref0 (self->priv->status_image);
	_g_object_unref0 (self->priv->spinner);
	_g_object_unref0 (self->priv->progress_revealer);
	_g_object_unref0 (self->priv->progressbar);
	G_OBJECT_CLASS (bluetooth_indicator_widgets_device_parent_class)->finalize (obj);
}

static GType
bluetooth_indicator_widgets_device_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BluetoothIndicatorWidgetsDeviceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bluetooth_indicator_widgets_device_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BluetoothIndicatorWidgetsDevice), 0, (GInstanceInitFunc) bluetooth_indicator_widgets_device_instance_init, NULL };
	GType bluetooth_indicator_widgets_device_type_id;
	bluetooth_indicator_widgets_device_type_id = g_type_register_static (gtk_list_box_row_get_type (), "BluetoothIndicatorWidgetsDevice", &g_define_type_info, 0);
	BluetoothIndicatorWidgetsDevice_private_offset = g_type_add_instance_private (bluetooth_indicator_widgets_device_type_id, sizeof (BluetoothIndicatorWidgetsDevicePrivate));
	return bluetooth_indicator_widgets_device_type_id;
}

GType
bluetooth_indicator_widgets_device_get_type (void)
{
	static volatile gsize bluetooth_indicator_widgets_device_type_id__once = 0;
	if (g_once_init_enter (&bluetooth_indicator_widgets_device_type_id__once)) {
		GType bluetooth_indicator_widgets_device_type_id;
		bluetooth_indicator_widgets_device_type_id = bluetooth_indicator_widgets_device_get_type_once ();
		g_once_init_leave (&bluetooth_indicator_widgets_device_type_id__once, bluetooth_indicator_widgets_device_type_id);
	}
	return bluetooth_indicator_widgets_device_type_id__once;
}

static void
_vala_bluetooth_indicator_widgets_device_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec)
{
	BluetoothIndicatorWidgetsDevice * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BLUETOOTH_INDICATOR_WIDGETS_TYPE_DEVICE, BluetoothIndicatorWidgetsDevice);
	switch (property_id) {
		case BLUETOOTH_INDICATOR_WIDGETS_DEVICE_DEVICE_PROPERTY:
		g_value_set_object (value, bluetooth_indicator_widgets_device_get_device (self));
		break;
		case BLUETOOTH_INDICATOR_WIDGETS_DEVICE_OBEX_MANAGER_PROPERTY:
		g_value_set_object (value, bluetooth_indicator_widgets_device_get_obex_manager (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_bluetooth_indicator_widgets_device_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec)
{
	BluetoothIndicatorWidgetsDevice * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BLUETOOTH_INDICATOR_WIDGETS_TYPE_DEVICE, BluetoothIndicatorWidgetsDevice);
	switch (property_id) {
		case BLUETOOTH_INDICATOR_WIDGETS_DEVICE_DEVICE_PROPERTY:
		bluetooth_indicator_widgets_device_set_device (self, g_value_get_object (value));
		break;
		case BLUETOOTH_INDICATOR_WIDGETS_DEVICE_OBEX_MANAGER_PROPERTY:
		bluetooth_indicator_widgets_device_set_obex_manager (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

