/* PlayerList.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from PlayerList.vala, do not modify */

/*
 * Copyright 2015-2020 elementary, Inc. (https://elementary.io)
 *           2014 Ikey Doherty <ikey.doherty@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "sound.h"
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SOUND_WIDGETS_PLAYER_LIST_0_PROPERTY,
	SOUND_WIDGETS_PLAYER_LIST_NUM_PROPERTIES
};
static GParamSpec* sound_widgets_player_list_properties[SOUND_WIDGETS_PLAYER_LIST_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _Block3Data Block3Data;
enum  {
	SOUND_WIDGETS_PLAYER_LIST_CLOSE_SIGNAL,
	SOUND_WIDGETS_PLAYER_LIST_NUM_SIGNALS
};
static guint sound_widgets_player_list_signals[SOUND_WIDGETS_PLAYER_LIST_NUM_SIGNALS] = {0};

struct _SoundWidgetsPlayerListPrivate {
	GAppInfo* default_player;
	SoundWidgetsPlayerRow* bluetooth_widget;
	SoundWidgetsPlayerRow* default_widget;
	GHashTable* ifaces;
	SoundServicesDBusImpl* impl;
};

struct _Block3Data {
	int _ref_count_;
	SoundWidgetsPlayerList* self;
	gchar* n;
};

static gint SoundWidgetsPlayerList_private_offset;
static gpointer sound_widgets_player_list_parent_class = NULL;

static void ___lambda33_ (SoundWidgetsPlayerList* self);
static void ____lambda33__sound_widgets_player_row_close (SoundWidgetsPlayerRow* _sender,
                                                   gpointer self);
static void sound_widgets_player_list_add_iface (SoundWidgetsPlayerList* self,
                                          const gchar* name,
                                          SoundServicesMprisClient* iface);
static void ___lambda34_ (SoundWidgetsPlayerList* self);
static void ____lambda34__sound_widgets_player_row_close (SoundWidgetsPlayerRow* _sender,
                                                   gpointer self);
static void sound_widgets_player_list_destroy_iface (SoundWidgetsPlayerList* self,
                                              const gchar* name);
static void ___lambda35_ (SoundWidgetsPlayerList* self,
                   const gchar* n,
                   const gchar* o,
                   const gchar* ne);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gboolean ____lambda36_ (Block3Data* _data3_);
static gboolean _____lambda36__gsource_func (gpointer self);
static gboolean ____lambda37_ (Block3Data* _data3_);
static gboolean _____lambda37__gsource_func (gpointer self);
static void ____lambda35__sound_services_dbus_impl_name_owner_changed (SoundServicesDBusImpl* _sender,
                                                                const gchar* name,
                                                                const gchar* old_owner,
                                                                const gchar* new_owner,
                                                                gpointer self);
static GObject * sound_widgets_player_list_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static gboolean _sound_widgets_player_list___lambda38_ (SoundWidgetsPlayerList* self);
static gboolean __sound_widgets_player_list___lambda38__gsource_func (gpointer self);
static void _sound_widgets_player_list___lambda39_ (SoundWidgetsPlayerList* self,
                                             SoundServicesMediaPlayer* media_player,
                                             const gchar* name,
                                             const gchar* icon);
static void __lambda40_ (SoundWidgetsPlayerList* self);
static void ___lambda40__sound_widgets_player_row_close (SoundWidgetsPlayerRow* _sender,
                                                  gpointer self);
static void __sound_widgets_player_list___lambda39__sound_services_object_manager_media_player_added (SoundServicesObjectManager* _sender,
                                                                                               SoundServicesMediaPlayer* media_player,
                                                                                               const gchar* name,
                                                                                               const gchar* icon,
                                                                                               gpointer self);
static void _sound_widgets_player_list___lambda41_ (SoundWidgetsPlayerList* self,
                                             SoundServicesMediaPlayer* media_player);
static void __sound_widgets_player_list___lambda41__sound_services_object_manager_media_player_removed (SoundServicesObjectManager* _sender,
                                                                                                 SoundServicesMediaPlayer* media_player,
                                                                                                 gpointer self);
static void _sound_widgets_player_list___lambda42_ (SoundWidgetsPlayerList* self,
                                             const gchar* status,
                                             const gchar* title,
                                             const gchar* artist);
static void __sound_widgets_player_list___lambda42__sound_services_object_manager_media_player_status_changed (SoundServicesObjectManager* _sender,
                                                                                                        const gchar* status,
                                                                                                        const gchar* title,
                                                                                                        const gchar* album,
                                                                                                        gpointer self);
static void sound_widgets_player_list_finalize (GObject * obj);
static GType sound_widgets_player_list_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
sound_widgets_player_list_get_instance_private (SoundWidgetsPlayerList* self)
{
	return G_STRUCT_MEMBER_P (self, SoundWidgetsPlayerList_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
___lambda33_ (SoundWidgetsPlayerList* self)
{
	g_signal_emit (self, sound_widgets_player_list_signals[SOUND_WIDGETS_PLAYER_LIST_CLOSE_SIGNAL], 0);
}

static void
____lambda33__sound_widgets_player_row_close (SoundWidgetsPlayerRow* _sender,
                                              gpointer self)
{
	___lambda33_ ((SoundWidgetsPlayerList*) self);
}

void
sound_widgets_player_list_update_default_player (SoundWidgetsPlayerList* self)
{
	GAppInfo* new_player = NULL;
	GAppInfo* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GAppInfo* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_app_info_get_default_for_type ("audio/x-vorbis+ogg", FALSE);
	new_player = _tmp0_;
	_tmp2_ = new_player;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		GAppInfo* _tmp4_;
		_tmp4_ = self->priv->default_player;
		if (_tmp4_ == NULL) {
			_tmp3_ = TRUE;
		} else {
			GAppInfo* _tmp5_;
			const gchar* _tmp6_;
			GAppInfo* _tmp7_;
			const gchar* _tmp8_;
			_tmp5_ = new_player;
			_tmp6_ = g_app_info_get_id (_tmp5_);
			_tmp7_ = self->priv->default_player;
			_tmp8_ = g_app_info_get_id (_tmp7_);
			_tmp3_ = g_strcmp0 (_tmp6_, _tmp8_) != 0;
		}
		_tmp1_ = _tmp3_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GAppInfo* _tmp9_;
		GAppInfo* _tmp10_;
		SoundWidgetsPlayerRow* _tmp11_;
		GAppInfo* _tmp13_;
		SoundWidgetsPlayerRow* _tmp14_;
		SoundWidgetsPlayerRow* _tmp15_;
		SoundWidgetsPlayerRow* _tmp16_;
		SoundWidgetsPlayerRow* _tmp17_;
		_tmp9_ = new_player;
		_tmp10_ = _g_object_ref0 (_tmp9_);
		_g_object_unref0 (self->priv->default_player);
		self->priv->default_player = _tmp10_;
		_tmp11_ = self->priv->default_widget;
		if (_tmp11_ != NULL) {
			SoundWidgetsPlayerRow* _tmp12_;
			_tmp12_ = self->priv->default_widget;
			gtk_widget_destroy ((GtkWidget*) _tmp12_);
		}
		_tmp13_ = new_player;
		_tmp14_ = sound_widgets_player_row_new_default (_tmp13_);
		g_object_ref_sink (_tmp14_);
		_g_object_unref0 (self->priv->default_widget);
		self->priv->default_widget = _tmp14_;
		_tmp15_ = self->priv->default_widget;
		g_signal_connect_object (_tmp15_, "close", (GCallback) ____lambda33__sound_widgets_player_row_close, self, 0);
		_tmp16_ = self->priv->default_widget;
		gtk_widget_show_all ((GtkWidget*) _tmp16_);
		_tmp17_ = self->priv->default_widget;
		gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp17_, FALSE, FALSE, (guint) 0);
	}
	_g_object_unref0 (new_player);
}

void
sound_widgets_player_list_pause_all (SoundWidgetsPlayerList* self)
{
	GHashTable* _tmp0_;
	GList* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->ifaces;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	{
		GList* cw_collection = NULL;
		GList* cw_it = NULL;
		cw_collection = _tmp1_;
		for (cw_it = cw_collection; cw_it != NULL; cw_it = cw_it->next) {
			SoundWidgetsPlayerRow* cw = NULL;
			cw = (SoundWidgetsPlayerRow*) cw_it->data;
			{
				{
					SoundWidgetsPlayerRow* _tmp2_;
					SoundServicesMprisClient* _tmp3_;
					SoundServicesMprisClient* _tmp4_;
					SoundServicesPlayerIface* _tmp5_;
					SoundServicesPlayerIface* _tmp6_;
					_tmp2_ = cw;
					_tmp3_ = sound_widgets_player_row_get_client (_tmp2_);
					_tmp4_ = _tmp3_;
					_tmp5_ = sound_services_mpris_client_get_player (_tmp4_);
					_tmp6_ = _tmp5_;
					sound_services_player_iface_pause (_tmp6_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* e = NULL;
					GError* _tmp7_;
					const gchar* _tmp8_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp7_ = e;
					_tmp8_ = _tmp7_->message;
					g_warning ("PlayerList.vala:97: Could not pause: %s", _tmp8_);
					_g_error_free0 (e);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					(cw_collection == NULL) ? NULL : (cw_collection = (g_list_free (cw_collection), NULL));
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
		}
		(cw_collection == NULL) ? NULL : (cw_collection = (g_list_free (cw_collection), NULL));
	}
}

/**
     * Add an interface handler/widget to known list and UI
     *
     * @param name DBUS name (object path)
     * @param iface The constructed MprisClient instance
     */
static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
___lambda34_ (SoundWidgetsPlayerList* self)
{
	g_signal_emit (self, sound_widgets_player_list_signals[SOUND_WIDGETS_PLAYER_LIST_CLOSE_SIGNAL], 0);
}

static void
____lambda34__sound_widgets_player_row_close (SoundWidgetsPlayerRow* _sender,
                                              gpointer self)
{
	___lambda34_ ((SoundWidgetsPlayerList*) self);
}

static void
sound_widgets_player_list_add_iface (SoundWidgetsPlayerList* self,
                                     const gchar* name,
                                     SoundServicesMprisClient* iface)
{
	gboolean _tmp0_ = FALSE;
	GAppInfo* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (iface != NULL);
	_tmp1_ = self->priv->default_player;
	if (_tmp1_ != NULL) {
		SoundServicesPlayerIface* _tmp2_;
		SoundServicesPlayerIface* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		GAppInfo* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp2_ = sound_services_mpris_client_get_player (iface);
		_tmp3_ = _tmp2_;
		_tmp4_ = sound_services_mpris_iface_get_desktop_entry ((SoundServicesMprisIface*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = _tmp5_;
		_tmp7_ = self->priv->default_player;
		_tmp8_ = g_app_info_get_id (_tmp7_);
		_tmp9_ = string_replace (_tmp8_, ".desktop", "");
		_tmp10_ = _tmp9_;
		_tmp0_ = g_strcmp0 (_tmp6_, _tmp10_) == 0;
		_g_free0 (_tmp10_);
		_g_free0 (_tmp6_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		SoundWidgetsPlayerRow* _tmp11_;
		gchar* _tmp12_;
		SoundWidgetsPlayerRow* _tmp13_;
		GHashTable* _tmp14_;
		gchar* _tmp15_;
		SoundWidgetsPlayerRow* _tmp16_;
		SoundWidgetsPlayerRow* _tmp17_;
		SoundWidgetsPlayerRow* _tmp18_;
		SoundWidgetsPlayerRow* _tmp19_;
		_tmp11_ = self->priv->default_widget;
		_tmp12_ = g_strdup (name);
		_g_free0 (_tmp11_->mpris_name);
		_tmp11_->mpris_name = _tmp12_;
		_tmp13_ = self->priv->default_widget;
		sound_widgets_player_row_set_client (_tmp13_, iface);
		_tmp14_ = self->priv->ifaces;
		_tmp15_ = g_strdup (name);
		_tmp16_ = self->priv->default_widget;
		_tmp17_ = _g_object_ref0 (_tmp16_);
		g_hash_table_insert (_tmp14_, _tmp15_, _tmp17_);
		_tmp18_ = self->priv->default_widget;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp18_, FALSE);
		_tmp19_ = self->priv->default_widget;
		gtk_widget_set_visible ((GtkWidget*) _tmp19_, TRUE);
	} else {
		SoundWidgetsPlayerRow* _tmp20_;
		const gchar* _tmp21_;
		SoundWidgetsPlayerRow* widg = NULL;
		SoundWidgetsPlayerRow* _tmp24_;
		SoundWidgetsPlayerRow* _tmp25_;
		SoundWidgetsPlayerRow* _tmp26_;
		SoundWidgetsPlayerRow* _tmp27_;
		GHashTable* _tmp28_;
		gchar* _tmp29_;
		SoundWidgetsPlayerRow* _tmp30_;
		SoundWidgetsPlayerRow* _tmp31_;
		_tmp20_ = self->priv->default_widget;
		_tmp21_ = _tmp20_->mpris_name;
		if (g_strcmp0 (_tmp21_, "") == 0) {
			SoundWidgetsPlayerRow* _tmp22_;
			SoundWidgetsPlayerRow* _tmp23_;
			_tmp22_ = self->priv->default_widget;
			gtk_widget_set_no_show_all ((GtkWidget*) _tmp22_, TRUE);
			_tmp23_ = self->priv->default_widget;
			gtk_widget_set_visible ((GtkWidget*) _tmp23_, FALSE);
		}
		_tmp24_ = sound_widgets_player_row_new (iface);
		g_object_ref_sink (_tmp24_);
		widg = _tmp24_;
		_tmp25_ = widg;
		g_signal_connect_object (_tmp25_, "close", (GCallback) ____lambda34__sound_widgets_player_row_close, self, 0);
		_tmp26_ = widg;
		gtk_widget_show_all ((GtkWidget*) _tmp26_);
		_tmp27_ = widg;
		gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp27_, FALSE, FALSE, (guint) 0);
		_tmp28_ = self->priv->ifaces;
		_tmp29_ = g_strdup (name);
		_tmp30_ = widg;
		_tmp31_ = _g_object_ref0 (_tmp30_);
		g_hash_table_insert (_tmp28_, _tmp29_, _tmp31_);
		_g_object_unref0 (widg);
	}
}

/**
     * Destroy an interface handler and remove from UI
     *
     * @param name DBUS name to remove handler for
     */
static void
sound_widgets_player_list_destroy_iface (SoundWidgetsPlayerList* self,
                                         const gchar* name)
{
	SoundWidgetsPlayerRow* _tmp0_;
	const gchar* _tmp1_;
	GHashTable* _tmp8_;
	gboolean _tmp9_ = FALSE;
	GHashTable* _tmp10_;
	guint _tmp11_;
	guint _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->default_widget;
	_tmp1_ = _tmp0_->mpris_name;
	if (g_strcmp0 (_tmp1_, name) == 0) {
		SoundWidgetsPlayerRow* _tmp2_;
		_tmp2_ = self->priv->default_widget;
		sound_widgets_player_row_set_client (_tmp2_, NULL);
	} else {
		SoundWidgetsPlayerRow* widg = NULL;
		GHashTable* _tmp3_;
		gconstpointer _tmp4_;
		SoundWidgetsPlayerRow* _tmp5_;
		SoundWidgetsPlayerRow* _tmp6_;
		_tmp3_ = self->priv->ifaces;
		_tmp4_ = g_hash_table_lookup (_tmp3_, name);
		_tmp5_ = _g_object_ref0 ((SoundWidgetsPlayerRow*) _tmp4_);
		widg = _tmp5_;
		_tmp6_ = widg;
		if (_tmp6_ != NULL) {
			SoundWidgetsPlayerRow* _tmp7_;
			_tmp7_ = widg;
			gtk_container_remove ((GtkContainer*) self, (GtkWidget*) _tmp7_);
		}
		_g_object_unref0 (widg);
	}
	_tmp8_ = self->priv->ifaces;
	g_hash_table_remove (_tmp8_, name);
	_tmp10_ = self->priv->ifaces;
	_tmp11_ = g_hash_table_size (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_ != ((guint) 0)) {
		SoundWidgetsPlayerRow* _tmp13_;
		const gchar* _tmp14_;
		_tmp13_ = self->priv->default_widget;
		_tmp14_ = _tmp13_->mpris_name;
		_tmp9_ = g_strcmp0 (_tmp14_, "") == 0;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		SoundWidgetsPlayerRow* _tmp15_;
		SoundWidgetsPlayerRow* _tmp16_;
		_tmp15_ = self->priv->default_widget;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp15_, TRUE);
		_tmp16_ = self->priv->default_widget;
		gtk_widget_set_visible ((GtkWidget*) _tmp16_, FALSE);
	} else {
		SoundWidgetsPlayerRow* _tmp17_;
		SoundWidgetsPlayerRow* _tmp18_;
		_tmp17_ = self->priv->default_widget;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp17_, FALSE);
		_tmp18_ = self->priv->default_widget;
		gtk_widget_set_visible ((GtkWidget*) _tmp18_, TRUE);
		gtk_widget_show_all ((GtkWidget*) self);
	}
}

/**
     * Do basic dbus initialisation
     */
static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		SoundWidgetsPlayerList* self;
		self = _data3_->self;
		_g_free0 (_data3_->n);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static gboolean
____lambda36_ (Block3Data* _data3_)
{
	SoundWidgetsPlayerList* self;
	GHashTable* _tmp0_;
	GList* _tmp1_;
	SoundServicesMprisClient* iface = NULL;
	SoundServicesMprisClient* _tmp6_;
	SoundServicesMprisClient* _tmp7_;
	gboolean result;
	self = _data3_->self;
	_tmp0_ = self->priv->ifaces;
	_tmp1_ = g_hash_table_get_keys (_tmp0_);
	{
		GList* name_collection = NULL;
		GList* name_it = NULL;
		name_collection = _tmp1_;
		for (name_it = name_collection; name_it != NULL; name_it = name_it->next) {
			gchar* _tmp2_;
			gchar* name = NULL;
			_tmp2_ = g_strdup ((const gchar*) name_it->data);
			name = _tmp2_;
			{
				gboolean _tmp3_ = FALSE;
				const gchar* _tmp4_;
				_tmp4_ = name;
				if (g_str_has_prefix (_tmp4_, _data3_->n)) {
					_tmp3_ = TRUE;
				} else {
					const gchar* _tmp5_;
					_tmp5_ = name;
					_tmp3_ = g_str_has_prefix (_data3_->n, _tmp5_);
				}
				if (_tmp3_) {
					result = FALSE;
					_g_free0 (name);
					(name_collection == NULL) ? NULL : (name_collection = (g_list_free (name_collection), NULL));
					return result;
				}
				_g_free0 (name);
			}
		}
		(name_collection == NULL) ? NULL : (name_collection = (g_list_free (name_collection), NULL));
	}
	_tmp6_ = sound_widgets_player_list_new_iface (self, _data3_->n);
	iface = _tmp6_;
	_tmp7_ = iface;
	if (_tmp7_ != NULL) {
		SoundServicesMprisClient* _tmp8_;
		_tmp8_ = iface;
		sound_widgets_player_list_add_iface (self, _data3_->n, _tmp8_);
	}
	result = FALSE;
	_g_object_unref0 (iface);
	return result;
}

static gboolean
_____lambda36__gsource_func (gpointer self)
{
	gboolean result;
	result = ____lambda36_ (self);
	return result;
}

static gboolean
____lambda37_ (Block3Data* _data3_)
{
	SoundWidgetsPlayerList* self;
	gboolean result;
	self = _data3_->self;
	sound_widgets_player_list_destroy_iface (self, _data3_->n);
	result = FALSE;
	return result;
}

static gboolean
_____lambda37__gsource_func (gpointer self)
{
	gboolean result;
	result = ____lambda37_ (self);
	return result;
}

static void
___lambda35_ (SoundWidgetsPlayerList* self,
              const gchar* n,
              const gchar* o,
              const gchar* ne)
{
	Block3Data* _data3_;
	gchar* _tmp0_;
	g_return_if_fail (n != NULL);
	g_return_if_fail (o != NULL);
	g_return_if_fail (ne != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = g_strdup (n);
	_g_free0 (_data3_->n);
	_data3_->n = _tmp0_;
	if (g_str_has_prefix (_data3_->n, "org.mpris.MediaPlayer2.")) {
		if (g_strcmp0 (o, "") == 0) {
			g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, _____lambda36__gsource_func, block3_data_ref (_data3_), block3_data_unref);
		} else {
			g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _____lambda37__gsource_func, block3_data_ref (_data3_), block3_data_unref);
		}
	}
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static void
____lambda35__sound_services_dbus_impl_name_owner_changed (SoundServicesDBusImpl* _sender,
                                                           const gchar* name,
                                                           const gchar* old_owner,
                                                           const gchar* new_owner,
                                                           gpointer self)
{
	___lambda35_ ((SoundWidgetsPlayerList*) self, name, old_owner, new_owner);
}

void
sound_widgets_player_list_setup_dbus (SoundWidgetsPlayerList* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		SoundServicesDBusImpl* _tmp0_ = NULL;
		SoundServicesDBusImpl* _tmp1_;
		SoundServicesDBusImpl* _tmp2_;
		gchar** names = NULL;
		SoundServicesDBusImpl* _tmp3_;
		gint _tmp4_ = 0;
		gchar** _tmp5_;
		gint names_length1;
		gint _names_size_;
		gchar** _tmp6_;
		gint _tmp6__length1;
		SoundServicesDBusImpl* _tmp22_;
		_tmp1_ = (SoundServicesDBusImpl*) g_initable_new (SOUND_SERVICES_TYPE_DBUS_IMPL_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", "org.freedesktop.DBus", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/freedesktop/DBus", "g-interface-name", "org.freedesktop.DBus", NULL);
		_tmp0_ = (SoundServicesDBusImpl*) _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->impl);
		self->priv->impl = _tmp2_;
		_tmp3_ = self->priv->impl;
		_tmp5_ = sound_services_dbus_impl_list_names (_tmp3_, &_tmp4_, &_inner_error0_);
		names = _tmp5_;
		names_length1 = _tmp4_;
		_names_size_ = names_length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp6_ = names;
		_tmp6__length1 = names_length1;
		{
			gchar** name_collection = NULL;
			gint name_collection_length1 = 0;
			gint _name_collection_size_ = 0;
			gint name_it = 0;
			name_collection = _tmp6_;
			name_collection_length1 = _tmp6__length1;
			for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
				gchar* _tmp7_;
				gchar* name = NULL;
				_tmp7_ = g_strdup (name_collection[name_it]);
				name = _tmp7_;
				{
					const gchar* _tmp8_;
					_tmp8_ = name;
					if (g_str_has_prefix (_tmp8_, "org.mpris.MediaPlayer2.")) {
						gboolean add = FALSE;
						GHashTable* _tmp9_;
						GList* _tmp10_;
						add = TRUE;
						_tmp9_ = self->priv->ifaces;
						_tmp10_ = g_hash_table_get_keys (_tmp9_);
						{
							GList* name2_collection = NULL;
							GList* name2_it = NULL;
							name2_collection = _tmp10_;
							for (name2_it = name2_collection; name2_it != NULL; name2_it = name2_it->next) {
								gchar* _tmp11_;
								gchar* name2 = NULL;
								_tmp11_ = g_strdup ((const gchar*) name2_it->data);
								name2 = _tmp11_;
								{
									gboolean _tmp12_ = FALSE;
									const gchar* _tmp13_;
									const gchar* _tmp14_;
									_tmp13_ = name2;
									_tmp14_ = name;
									if (g_str_has_prefix (_tmp13_, _tmp14_)) {
										_tmp12_ = TRUE;
									} else {
										const gchar* _tmp15_;
										const gchar* _tmp16_;
										_tmp15_ = name;
										_tmp16_ = name2;
										_tmp12_ = g_str_has_prefix (_tmp15_, _tmp16_);
									}
									if (_tmp12_) {
										add = FALSE;
									}
									_g_free0 (name2);
								}
							}
							(name2_collection == NULL) ? NULL : (name2_collection = (g_list_free (name2_collection), NULL));
						}
						if (add) {
							SoundServicesMprisClient* iface = NULL;
							const gchar* _tmp17_;
							SoundServicesMprisClient* _tmp18_;
							SoundServicesMprisClient* _tmp19_;
							_tmp17_ = name;
							_tmp18_ = sound_widgets_player_list_new_iface (self, _tmp17_);
							iface = _tmp18_;
							_tmp19_ = iface;
							if (_tmp19_ != NULL) {
								const gchar* _tmp20_;
								SoundServicesMprisClient* _tmp21_;
								_tmp20_ = name;
								_tmp21_ = iface;
								sound_widgets_player_list_add_iface (self, _tmp20_, _tmp21_);
							}
							_g_object_unref0 (iface);
						}
					}
					_g_free0 (name);
				}
			}
		}
		_tmp22_ = self->priv->impl;
		g_signal_connect_object (_tmp22_, "name-owner-changed", (GCallback) ____lambda35__sound_services_dbus_impl_name_owner_changed, self, 0);
		names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp23_;
		const gchar* _tmp24_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp23_ = e;
		_tmp24_ = _tmp23_->message;
		g_warning ("PlayerList.vala:215: Failed to initialise dbus: %s", _tmp24_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

/**
     * Utility function, return a new iface instance, i.e. deal
     * with all the dbus cruft
     *
     * @param busname The busname to instaniate ifaces from
     * @return a new MprisClient, or null if errors occurred.
     */
SoundServicesMprisClient*
sound_widgets_player_list_new_iface (SoundWidgetsPlayerList* self,
                                     const gchar* busname)
{
	SoundServicesPlayerIface* play = NULL;
	SoundServicesMprisClient* cl = NULL;
	SoundServicesDbusPropIface* prop = NULL;
	SoundServicesPlayerIface* _tmp10_;
	SoundServicesDbusPropIface* _tmp11_;
	SoundServicesMprisClient* _tmp12_;
	GError* _inner_error0_ = NULL;
	SoundServicesMprisClient* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (busname != NULL, NULL);
	play = NULL;
	cl = NULL;
	prop = NULL;
	{
		SoundServicesPlayerIface* _tmp0_ = NULL;
		SoundServicesPlayerIface* _tmp1_;
		SoundServicesPlayerIface* _tmp2_;
		_tmp1_ = (SoundServicesPlayerIface*) g_initable_new (SOUND_SERVICES_TYPE_PLAYER_IFACE_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", busname, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/mpris/MediaPlayer2", "g-interface-name", "org.mpris.MediaPlayer2.Player", NULL);
		_tmp0_ = (SoundServicesPlayerIface*) _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (play);
		play = _tmp2_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_message ("PlayerList.vala:234: %s", _tmp4_);
		result = NULL;
		_g_error_free0 (e);
		_g_object_unref0 (prop);
		_g_object_unref0 (cl);
		_g_object_unref0 (play);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (prop);
		_g_object_unref0 (cl);
		_g_object_unref0 (play);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	{
		SoundServicesDbusPropIface* _tmp5_ = NULL;
		SoundServicesDbusPropIface* _tmp6_;
		SoundServicesDbusPropIface* _tmp7_;
		_tmp6_ = (SoundServicesDbusPropIface*) g_initable_new (SOUND_SERVICES_TYPE_DBUS_PROP_IFACE_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", busname, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/mpris/MediaPlayer2", "g-interface-name", "org.freedesktop.DBus.Properties", NULL);
		_tmp5_ = (SoundServicesDbusPropIface*) _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp7_ = _tmp5_;
		_tmp5_ = NULL;
		_g_object_unref0 (prop);
		prop = _tmp7_;
		_g_object_unref0 (_tmp5_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_message ("PlayerList.vala:240: %s", _tmp9_);
		result = NULL;
		_g_error_free0 (e);
		_g_object_unref0 (prop);
		_g_object_unref0 (cl);
		_g_object_unref0 (play);
		return result;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (prop);
		_g_object_unref0 (cl);
		_g_object_unref0 (play);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp10_ = play;
	_tmp11_ = prop;
	_tmp12_ = sound_services_mpris_client_new (_tmp10_, _tmp11_);
	_g_object_unref0 (cl);
	cl = _tmp12_;
	result = cl;
	_g_object_unref0 (prop);
	_g_object_unref0 (play);
	return result;
}

SoundWidgetsPlayerList*
sound_widgets_player_list_construct (GType object_type)
{
	SoundWidgetsPlayerList * self = NULL;
	self = (SoundWidgetsPlayerList*) g_object_new (object_type, NULL);
	return self;
}

SoundWidgetsPlayerList*
sound_widgets_player_list_new (void)
{
	return sound_widgets_player_list_construct (SOUND_WIDGETS_TYPE_PLAYER_LIST);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static gboolean
_sound_widgets_player_list___lambda38_ (SoundWidgetsPlayerList* self)
{
	gboolean result;
	sound_widgets_player_list_setup_dbus (self);
	result = FALSE;
	return result;
}

static gboolean
__sound_widgets_player_list___lambda38__gsource_func (gpointer self)
{
	gboolean result;
	result = _sound_widgets_player_list___lambda38_ ((SoundWidgetsPlayerList*) self);
	return result;
}

static void
__lambda40_ (SoundWidgetsPlayerList* self)
{
	g_signal_emit (self, sound_widgets_player_list_signals[SOUND_WIDGETS_PLAYER_LIST_CLOSE_SIGNAL], 0);
}

static void
___lambda40__sound_widgets_player_row_close (SoundWidgetsPlayerRow* _sender,
                                             gpointer self)
{
	__lambda40_ ((SoundWidgetsPlayerList*) self);
}

static void
_sound_widgets_player_list___lambda39_ (SoundWidgetsPlayerList* self,
                                        SoundServicesMediaPlayer* media_player,
                                        const gchar* name,
                                        const gchar* icon)
{
	SoundWidgetsPlayerRow* _tmp0_;
	SoundWidgetsPlayerRow* _tmp1_;
	SoundWidgetsPlayerRow* _tmp2_;
	SoundWidgetsPlayerRow* _tmp3_;
	g_return_if_fail (media_player != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (icon != NULL);
	_tmp0_ = sound_widgets_player_row_new_bluetooth (media_player, name, icon);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->bluetooth_widget);
	self->priv->bluetooth_widget = _tmp0_;
	_tmp1_ = self->priv->bluetooth_widget;
	g_signal_connect_object (_tmp1_, "close", (GCallback) ___lambda40__sound_widgets_player_row_close, self, 0);
	_tmp2_ = self->priv->bluetooth_widget;
	gtk_widget_show_all ((GtkWidget*) _tmp2_);
	_tmp3_ = self->priv->bluetooth_widget;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp3_, FALSE, FALSE, (guint) 0);
}

static void
__sound_widgets_player_list___lambda39__sound_services_object_manager_media_player_added (SoundServicesObjectManager* _sender,
                                                                                          SoundServicesMediaPlayer* media_player,
                                                                                          const gchar* name,
                                                                                          const gchar* icon,
                                                                                          gpointer self)
{
	_sound_widgets_player_list___lambda39_ ((SoundWidgetsPlayerList*) self, media_player, name, icon);
}

static void
_sound_widgets_player_list___lambda41_ (SoundWidgetsPlayerList* self,
                                        SoundServicesMediaPlayer* media_player)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	SoundWidgetsPlayerRow* _tmp3_;
	g_return_if_fail (media_player != NULL);
	_tmp0_ = sound_services_media_player_get_name (media_player);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	g_debug ("PlayerList.vala:52: Media player %s removed", _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = self->priv->bluetooth_widget;
	gtk_widget_destroy ((GtkWidget*) _tmp3_);
}

static void
__sound_widgets_player_list___lambda41__sound_services_object_manager_media_player_removed (SoundServicesObjectManager* _sender,
                                                                                            SoundServicesMediaPlayer* media_player,
                                                                                            gpointer self)
{
	_sound_widgets_player_list___lambda41_ ((SoundWidgetsPlayerList*) self, media_player);
}

static void
_sound_widgets_player_list___lambda42_ (SoundWidgetsPlayerList* self,
                                        const gchar* status,
                                        const gchar* title,
                                        const gchar* artist)
{
	SoundWidgetsPlayerRow* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (status != NULL);
	g_return_if_fail (title != NULL);
	g_return_if_fail (artist != NULL);
	_tmp0_ = self->priv->bluetooth_widget;
	sound_widgets_player_row_update_play (_tmp0_, status, title, artist);
	if (g_strcmp0 (status, "playing") == 0) {
		SoundWidgetsPlayerRow* _tmp2_;
		SoundServicesMprisClient* _tmp3_;
		SoundServicesMprisClient* _tmp4_;
		SoundServicesPlayerIface* _tmp5_;
		SoundServicesPlayerIface* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp2_ = self->priv->default_widget;
		_tmp3_ = sound_widgets_player_row_get_client (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = sound_services_mpris_client_get_player (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = sound_services_player_iface_get_playback_status (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		_tmp1_ = g_strcmp0 (_tmp9_, "Playing") == 0;
		_g_free0 (_tmp9_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		{
			SoundWidgetsPlayerRow* _tmp10_;
			SoundServicesMprisClient* _tmp11_;
			SoundServicesMprisClient* _tmp12_;
			SoundServicesPlayerIface* _tmp13_;
			SoundServicesPlayerIface* _tmp14_;
			_tmp10_ = self->priv->default_widget;
			_tmp11_ = sound_widgets_player_row_get_client (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = sound_services_mpris_client_get_player (_tmp12_);
			_tmp14_ = _tmp13_;
			sound_services_player_iface_play_pause (_tmp14_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp15_;
			const gchar* _tmp16_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp15_ = e;
			_tmp16_ = _tmp15_->message;
			g_critical ("PlayerList.vala:62: %s", _tmp16_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
__sound_widgets_player_list___lambda42__sound_services_object_manager_media_player_status_changed (SoundServicesObjectManager* _sender,
                                                                                                   const gchar* status,
                                                                                                   const gchar* title,
                                                                                                   const gchar* album,
                                                                                                   gpointer self)
{
	_sound_widgets_player_list___lambda42_ ((SoundWidgetsPlayerList*) self, status, title, album);
}

static GObject *
sound_widgets_player_list_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SoundWidgetsPlayerList * self;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	SoundServicesObjectManager* _tmp3_;
	SoundServicesObjectManager* _tmp4_;
	SoundServicesObjectManager* _tmp5_;
	SoundServicesObjectManager* _tmp6_;
	SoundServicesObjectManager* _tmp7_;
	parent_class = G_OBJECT_CLASS (sound_widgets_player_list_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SOUND_WIDGETS_TYPE_PLAYER_LIST, SoundWidgetsPlayerList);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->ifaces);
	self->priv->ifaces = _tmp2_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __sound_widgets_player_list___lambda38__gsource_func, g_object_ref (self), g_object_unref);
	_tmp3_ = sound_services_object_manager_new ();
	_g_object_unref0 (self->object_manager);
	self->object_manager = _tmp3_;
	_tmp4_ = self->object_manager;
	g_object_bind_property_with_closures ((GObject*) _tmp4_, "has-object", (GObject*) self, "visible", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp5_ = self->object_manager;
	g_signal_connect_object (_tmp5_, "media-player-added", (GCallback) __sound_widgets_player_list___lambda39__sound_services_object_manager_media_player_added, self, 0);
	_tmp6_ = self->object_manager;
	g_signal_connect_object (_tmp6_, "media-player-removed", (GCallback) __sound_widgets_player_list___lambda41__sound_services_object_manager_media_player_removed, self, 0);
	_tmp7_ = self->object_manager;
	g_signal_connect_object (_tmp7_, "media-player-status-changed", (GCallback) __sound_widgets_player_list___lambda42__sound_services_object_manager_media_player_status_changed, self, 0);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	gtk_widget_set_margin_bottom ((GtkWidget*) self, 3);
	gtk_widget_show_all ((GtkWidget*) self);
	return obj;
}

static void
sound_widgets_player_list_class_init (SoundWidgetsPlayerListClass * klass,
                                      gpointer klass_data)
{
	sound_widgets_player_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SoundWidgetsPlayerList_private_offset);
	G_OBJECT_CLASS (klass)->constructor = sound_widgets_player_list_constructor;
	G_OBJECT_CLASS (klass)->finalize = sound_widgets_player_list_finalize;
	sound_widgets_player_list_signals[SOUND_WIDGETS_PLAYER_LIST_CLOSE_SIGNAL] = g_signal_new ("close", SOUND_WIDGETS_TYPE_PLAYER_LIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
sound_widgets_player_list_instance_init (SoundWidgetsPlayerList * self,
                                         gpointer klass)
{
	self->priv = sound_widgets_player_list_get_instance_private (self);
}

static void
sound_widgets_player_list_finalize (GObject * obj)
{
	SoundWidgetsPlayerList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SOUND_WIDGETS_TYPE_PLAYER_LIST, SoundWidgetsPlayerList);
	_g_object_unref0 (self->object_manager);
	_g_object_unref0 (self->priv->default_player);
	_g_object_unref0 (self->priv->bluetooth_widget);
	_g_object_unref0 (self->priv->default_widget);
	_g_hash_table_unref0 (self->priv->ifaces);
	_g_object_unref0 (self->priv->impl);
	G_OBJECT_CLASS (sound_widgets_player_list_parent_class)->finalize (obj);
}

static GType
sound_widgets_player_list_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SoundWidgetsPlayerListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sound_widgets_player_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SoundWidgetsPlayerList), 0, (GInstanceInitFunc) sound_widgets_player_list_instance_init, NULL };
	GType sound_widgets_player_list_type_id;
	sound_widgets_player_list_type_id = g_type_register_static (gtk_box_get_type (), "SoundWidgetsPlayerList", &g_define_type_info, 0);
	SoundWidgetsPlayerList_private_offset = g_type_add_instance_private (sound_widgets_player_list_type_id, sizeof (SoundWidgetsPlayerListPrivate));
	return sound_widgets_player_list_type_id;
}

GType
sound_widgets_player_list_get_type (void)
{
	static volatile gsize sound_widgets_player_list_type_id__once = 0;
	if (g_once_init_enter (&sound_widgets_player_list_type_id__once)) {
		GType sound_widgets_player_list_type_id;
		sound_widgets_player_list_type_id = sound_widgets_player_list_get_type_once ();
		g_once_init_leave (&sound_widgets_player_list_type_id__once, sound_widgets_player_list_type_id);
	}
	return sound_widgets_player_list_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

