/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1beta1

// MutatingAdmissionPolicyBindingSpecApplyConfiguration represents a declarative configuration of the MutatingAdmissionPolicyBindingSpec type for use
// with apply.
//
// MutatingAdmissionPolicyBindingSpec is the specification of the MutatingAdmissionPolicyBinding.
type MutatingAdmissionPolicyBindingSpecApplyConfiguration struct {
	// policyName references a MutatingAdmissionPolicy name which the MutatingAdmissionPolicyBinding binds to.
	// If the referenced resource does not exist, this binding is considered invalid and will be ignored
	// Required.
	PolicyName *string `json:"policyName,omitempty"`
	// paramRef specifies the parameter resource used to configure the admission control policy.
	// It should point to a resource of the type specified in spec.ParamKind of the bound MutatingAdmissionPolicy.
	// If the policy specifies a ParamKind and the resource referred to by ParamRef does not exist, this binding is considered mis-configured and the FailurePolicy of the MutatingAdmissionPolicy applied.
	// If the policy does not specify a ParamKind then this field is ignored, and the rules are evaluated without a param.
	ParamRef *ParamRefApplyConfiguration `json:"paramRef,omitempty"`
	// matchResources limits what resources match this binding and may be mutated by it.
	// Note that if matchResources matches a resource, the resource must also match a policy's matchConstraints and
	// matchConditions before the resource may be mutated.
	// When matchResources is unset, it does not constrain resource matching, and only the policy's matchConstraints
	// and matchConditions must match for the resource to be mutated.
	// Additionally, matchResources.resourceRules are optional and do not constraint matching when unset.
	// Note that this is differs from MutatingAdmissionPolicy matchConstraints, where resourceRules are required.
	// The CREATE, UPDATE and CONNECT operations are allowed.  The DELETE operation may not be matched.
	// '*' matches CREATE, UPDATE and CONNECT.
	MatchResources *MatchResourcesApplyConfiguration `json:"matchResources,omitempty"`
}

// MutatingAdmissionPolicyBindingSpecApplyConfiguration constructs a declarative configuration of the MutatingAdmissionPolicyBindingSpec type for use with
// apply.
func MutatingAdmissionPolicyBindingSpec() *MutatingAdmissionPolicyBindingSpecApplyConfiguration {
	return &MutatingAdmissionPolicyBindingSpecApplyConfiguration{}
}

// WithPolicyName sets the PolicyName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PolicyName field is set to the value of the last call.
func (b *MutatingAdmissionPolicyBindingSpecApplyConfiguration) WithPolicyName(value string) *MutatingAdmissionPolicyBindingSpecApplyConfiguration {
	b.PolicyName = &value
	return b
}

// WithParamRef sets the ParamRef field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ParamRef field is set to the value of the last call.
func (b *MutatingAdmissionPolicyBindingSpecApplyConfiguration) WithParamRef(value *ParamRefApplyConfiguration) *MutatingAdmissionPolicyBindingSpecApplyConfiguration {
	b.ParamRef = value
	return b
}

// WithMatchResources sets the MatchResources field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MatchResources field is set to the value of the last call.
func (b *MutatingAdmissionPolicyBindingSpecApplyConfiguration) WithMatchResources(value *MatchResourcesApplyConfiguration) *MutatingAdmissionPolicyBindingSpecApplyConfiguration {
	b.MatchResources = value
	return b
}
