/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// CertificateSigningRequestStatusApplyConfiguration represents a declarative configuration of the CertificateSigningRequestStatus type for use
// with apply.
//
// CertificateSigningRequestStatus contains conditions used to indicate
// approved/denied/failed status of the request, and the issued certificate.
type CertificateSigningRequestStatusApplyConfiguration struct {
	// conditions applied to the request. Known conditions are "Approved", "Denied", and "Failed".
	Conditions []CertificateSigningRequestConditionApplyConfiguration `json:"conditions,omitempty"`
	// certificate is populated with an issued certificate by the signer after an Approved condition is present.
	// This field is set via the /status subresource. Once populated, this field is immutable.
	//
	// If the certificate signing request is denied, a condition of type "Denied" is added and this field remains empty.
	// If the signer cannot issue the certificate, a condition of type "Failed" is added and this field remains empty.
	//
	// Validation requirements:
	// 1. certificate must contain one or more PEM blocks.
	// 2. All PEM blocks must have the "CERTIFICATE" label, contain no headers, and the encoded data
	// must be a BER-encoded ASN.1 Certificate structure as described in section 4 of RFC5280.
	// 3. Non-PEM content may appear before or after the "CERTIFICATE" PEM blocks and is unvalidated,
	// to allow for explanatory text as described in section 5.2 of RFC7468.
	//
	// If more than one PEM block is present, and the definition of the requested spec.signerName
	// does not indicate otherwise, the first block is the issued certificate,
	// and subsequent blocks should be treated as intermediate certificates and presented in TLS handshakes.
	//
	// The certificate is encoded in PEM format.
	//
	// When serialized as JSON or YAML, the data is additionally base64-encoded, so it consists of:
	//
	// base64(
	// -----BEGIN CERTIFICATE-----
	// ...
	// -----END CERTIFICATE-----
	// )
	Certificate []byte `json:"certificate,omitempty"`
}

// CertificateSigningRequestStatusApplyConfiguration constructs a declarative configuration of the CertificateSigningRequestStatus type for use with
// apply.
func CertificateSigningRequestStatus() *CertificateSigningRequestStatusApplyConfiguration {
	return &CertificateSigningRequestStatusApplyConfiguration{}
}

// WithConditions adds the given value to the Conditions field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Conditions field.
func (b *CertificateSigningRequestStatusApplyConfiguration) WithConditions(values ...*CertificateSigningRequestConditionApplyConfiguration) *CertificateSigningRequestStatusApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithConditions")
		}
		b.Conditions = append(b.Conditions, *values[i])
	}
	return b
}

// WithCertificate adds the given value to the Certificate field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Certificate field.
func (b *CertificateSigningRequestStatusApplyConfiguration) WithCertificate(values ...byte) *CertificateSigningRequestStatusApplyConfiguration {
	for i := range values {
		b.Certificate = append(b.Certificate, values[i])
	}
	return b
}
