﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/workspaces/WorkSpaces_EXPORTS.h>

namespace Aws {
namespace WorkSpaces {
namespace Model {
enum class WorkspacesPoolErrorCode {
  NOT_SET,
  IAM_SERVICE_ROLE_IS_MISSING,
  IAM_SERVICE_ROLE_MISSING_ENI_DESCRIBE_ACTION,
  IAM_SERVICE_ROLE_MISSING_ENI_CREATE_ACTION,
  IAM_SERVICE_ROLE_MISSING_ENI_DELETE_ACTION,
  NETWORK_INTERFACE_LIMIT_EXCEEDED,
  INTERNAL_SERVICE_ERROR,
  MACHINE_ROLE_IS_MISSING,
  STS_DISABLED_IN_REGION,
  SUBNET_HAS_INSUFFICIENT_IP_ADDRESSES,
  IAM_SERVICE_ROLE_MISSING_DESCRIBE_SUBNET_ACTION,
  SUBNET_NOT_FOUND,
  IMAGE_NOT_FOUND,
  INVALID_SUBNET_CONFIGURATION,
  SECURITY_GROUPS_NOT_FOUND,
  IGW_NOT_ATTACHED,
  IAM_SERVICE_ROLE_MISSING_DESCRIBE_SECURITY_GROUPS_ACTION,
  WORKSPACES_POOL_STOPPED,
  WORKSPACES_POOL_INSTANCE_PROVISIONING_FAILURE,
  DOMAIN_JOIN_ERROR_FILE_NOT_FOUND,
  DOMAIN_JOIN_ERROR_ACCESS_DENIED,
  DOMAIN_JOIN_ERROR_LOGON_FAILURE,
  DOMAIN_JOIN_ERROR_INVALID_PARAMETER,
  DOMAIN_JOIN_ERROR_MORE_DATA,
  DOMAIN_JOIN_ERROR_NO_SUCH_DOMAIN,
  DOMAIN_JOIN_ERROR_NOT_SUPPORTED,
  DOMAIN_JOIN_NERR_INVALID_WORKGROUP_NAME,
  DOMAIN_JOIN_NERR_WORKSTATION_NOT_STARTED,
  DOMAIN_JOIN_ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED,
  DOMAIN_JOIN_NERR_PASSWORD_EXPIRED,
  DOMAIN_JOIN_INTERNAL_SERVICE_ERROR,
  DOMAIN_JOIN_ERROR_SECRET_ACTION_PERMISSION_IS_MISSING,
  DOMAIN_JOIN_ERROR_SECRET_DECRYPTION_FAILURE,
  DOMAIN_JOIN_ERROR_SECRET_STATE_INVALID,
  DOMAIN_JOIN_ERROR_SECRET_NOT_FOUND,
  DOMAIN_JOIN_ERROR_SECRET_VALUE_KEY_NOT_FOUND,
  DOMAIN_JOIN_ERROR_SECRET_INVALID,
  BUNDLE_NOT_FOUND,
  DIRECTORY_NOT_FOUND,
  INSUFFICIENT_PERMISSIONS_ERROR,
  DEFAULT_OU_IS_MISSING
};

namespace WorkspacesPoolErrorCodeMapper {
AWS_WORKSPACES_API WorkspacesPoolErrorCode GetWorkspacesPoolErrorCodeForName(const Aws::String& name);

AWS_WORKSPACES_API Aws::String GetNameForWorkspacesPoolErrorCode(WorkspacesPoolErrorCode value);
}  // namespace WorkspacesPoolErrorCodeMapper
}  // namespace Model
}  // namespace WorkSpaces
}  // namespace Aws
