/**
 * Copyright (c) 2021, The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.view.contentcapture;

import android.content.ContentCaptureOptions;

/**
  * Callback for changes to content capture options made by ContentCaptureService.
  * Callback interface used by IContentCaptureManager to send asynchronous
  * notifications back to its clients.  Note that this is a
  * one-way interface so the server does not block waiting for the client.
  *
  * @hide
  */
oneway interface IContentCaptureOptionsCallback {
    void setContentCaptureOptions(in ContentCaptureOptions options);
}
