# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._azure_machine_learning_workspaces_enums import *


class WorkspaceConnectionPropertiesV2(msrest.serialization.Model):
    """WorkspaceConnectionPropertiesV2.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AccessKeyAuthTypeWorkspaceConnectionProperties, ManagedIdentityAuthTypeWorkspaceConnectionProperties, NoneAuthTypeWorkspaceConnectionProperties, PATAuthTypeWorkspaceConnectionProperties, SASAuthTypeWorkspaceConnectionProperties, ServicePrincipalAuthTypeWorkspaceConnectionProperties, UsernamePasswordAuthTypeWorkspaceConnectionProperties.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Required. Authentication type of the connection target.Constant filled by
     server. Possible values include: "PAT", "ManagedIdentity", "UsernamePassword", "None", "SAS",
     "ServicePrincipal", "AccessKey".
    :vartype auth_type: str or ~azure.mgmt.machinelearningservices.models.ConnectionAuthType
    :ivar category: Category of the connection.
    :vartype category: str
    :ivar target:
    :vartype target: str
    :ivar value: Value details of the workspace connection.
    :vartype value: str
    :ivar value_format: format for the workspace connection value. Possible values include: "JSON".
    :vartype value_format: str or ~azure.mgmt.machinelearningservices.models.ValueFormat
    """

    _validation = {
        'auth_type': {'required': True},
    }

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'value_format': {'key': 'valueFormat', 'type': 'str'},
    }

    _subtype_map = {
        'auth_type': {'AccessKey': 'AccessKeyAuthTypeWorkspaceConnectionProperties', 'ManagedIdentity': 'ManagedIdentityAuthTypeWorkspaceConnectionProperties', 'None': 'NoneAuthTypeWorkspaceConnectionProperties', 'PAT': 'PATAuthTypeWorkspaceConnectionProperties', 'SAS': 'SASAuthTypeWorkspaceConnectionProperties', 'ServicePrincipal': 'ServicePrincipalAuthTypeWorkspaceConnectionProperties', 'UsernamePassword': 'UsernamePasswordAuthTypeWorkspaceConnectionProperties'}
    }

    def __init__(
        self,
        *,
        category: Optional[str] = None,
        target: Optional[str] = None,
        value: Optional[str] = None,
        value_format: Optional[Union[str, "ValueFormat"]] = None,
        **kwargs
    ):
        """
        :keyword category: Category of the connection.
        :paramtype category: str
        :keyword target:
        :paramtype target: str
        :keyword value: Value details of the workspace connection.
        :paramtype value: str
        :keyword value_format: format for the workspace connection value. Possible values include:
         "JSON".
        :paramtype value_format: str or ~azure.mgmt.machinelearningservices.models.ValueFormat
        """
        super(WorkspaceConnectionPropertiesV2, self).__init__(**kwargs)
        self.auth_type = None  # type: Optional[str]
        self.category = category
        self.target = target
        self.value = value
        self.value_format = value_format


class AccessKeyAuthTypeWorkspaceConnectionProperties(WorkspaceConnectionPropertiesV2):
    """AccessKeyAuthTypeWorkspaceConnectionProperties.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Required. Authentication type of the connection target.Constant filled by
     server. Possible values include: "PAT", "ManagedIdentity", "UsernamePassword", "None", "SAS",
     "ServicePrincipal", "AccessKey".
    :vartype auth_type: str or ~azure.mgmt.machinelearningservices.models.ConnectionAuthType
    :ivar category: Category of the connection.
    :vartype category: str
    :ivar target:
    :vartype target: str
    :ivar value: Value details of the workspace connection.
    :vartype value: str
    :ivar value_format: format for the workspace connection value. Possible values include: "JSON".
    :vartype value_format: str or ~azure.mgmt.machinelearningservices.models.ValueFormat
    :ivar credentials:
    :vartype credentials: ~azure.mgmt.machinelearningservices.models.WorkspaceConnectionAccessKey
    """

    _validation = {
        'auth_type': {'required': True},
    }

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'value_format': {'key': 'valueFormat', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'WorkspaceConnectionAccessKey'},
    }

    def __init__(
        self,
        *,
        category: Optional[str] = None,
        target: Optional[str] = None,
        value: Optional[str] = None,
        value_format: Optional[Union[str, "ValueFormat"]] = None,
        credentials: Optional["WorkspaceConnectionAccessKey"] = None,
        **kwargs
    ):
        """
        :keyword category: Category of the connection.
        :paramtype category: str
        :keyword target:
        :paramtype target: str
        :keyword value: Value details of the workspace connection.
        :paramtype value: str
        :keyword value_format: format for the workspace connection value. Possible values include:
         "JSON".
        :paramtype value_format: str or ~azure.mgmt.machinelearningservices.models.ValueFormat
        :keyword credentials:
        :paramtype credentials: ~azure.mgmt.machinelearningservices.models.WorkspaceConnectionAccessKey
        """
        super(AccessKeyAuthTypeWorkspaceConnectionProperties, self).__init__(category=category, target=target, value=value, value_format=value_format, **kwargs)
        self.auth_type = 'AccessKey'  # type: str
        self.credentials = credentials


class DatastoreCredentials(msrest.serialization.Model):
    """Base definition for datastore credentials.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AccountKeyDatastoreCredentials, CertificateDatastoreCredentials, KerberosKeytabCredentials, KerberosPasswordCredentials, NoneDatastoreCredentials, SasDatastoreCredentials, ServicePrincipalDatastoreCredentials.

    All required parameters must be populated in order to send to Azure.

    :ivar credentials_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "AccountKey", "Certificate",
     "None", "Sas", "ServicePrincipal", "KerberosKeytab", "KerberosPassword".
    :vartype credentials_type: str or ~azure.mgmt.machinelearningservices.models.CredentialsType
    """

    _validation = {
        'credentials_type': {'required': True},
    }

    _attribute_map = {
        'credentials_type': {'key': 'credentialsType', 'type': 'str'},
    }

    _subtype_map = {
        'credentials_type': {'AccountKey': 'AccountKeyDatastoreCredentials', 'Certificate': 'CertificateDatastoreCredentials', 'KerberosKeytab': 'KerberosKeytabCredentials', 'KerberosPassword': 'KerberosPasswordCredentials', 'None': 'NoneDatastoreCredentials', 'Sas': 'SasDatastoreCredentials', 'ServicePrincipal': 'ServicePrincipalDatastoreCredentials'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(DatastoreCredentials, self).__init__(**kwargs)
        self.credentials_type = None  # type: Optional[str]


class AccountKeyDatastoreCredentials(DatastoreCredentials):
    """Account key datastore credentials configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar credentials_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "AccountKey", "Certificate",
     "None", "Sas", "ServicePrincipal", "KerberosKeytab", "KerberosPassword".
    :vartype credentials_type: str or ~azure.mgmt.machinelearningservices.models.CredentialsType
    :ivar secrets: Required. [Required] Storage account secrets.
    :vartype secrets: ~azure.mgmt.machinelearningservices.models.AccountKeyDatastoreSecrets
    """

    _validation = {
        'credentials_type': {'required': True},
        'secrets': {'required': True},
    }

    _attribute_map = {
        'credentials_type': {'key': 'credentialsType', 'type': 'str'},
        'secrets': {'key': 'secrets', 'type': 'AccountKeyDatastoreSecrets'},
    }

    def __init__(
        self,
        *,
        secrets: "AccountKeyDatastoreSecrets",
        **kwargs
    ):
        """
        :keyword secrets: Required. [Required] Storage account secrets.
        :paramtype secrets: ~azure.mgmt.machinelearningservices.models.AccountKeyDatastoreSecrets
        """
        super(AccountKeyDatastoreCredentials, self).__init__(**kwargs)
        self.credentials_type = 'AccountKey'  # type: str
        self.secrets = secrets


class DatastoreSecrets(msrest.serialization.Model):
    """Base definition for datastore secrets.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AccountKeyDatastoreSecrets, CertificateDatastoreSecrets, KerberosKeytabSecrets, KerberosPasswordSecrets, SasDatastoreSecrets, ServicePrincipalDatastoreSecrets.

    All required parameters must be populated in order to send to Azure.

    :ivar secrets_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "AccountKey", "Certificate", "Sas",
     "ServicePrincipal", "KerberosPassword", "KerberosKeytab".
    :vartype secrets_type: str or ~azure.mgmt.machinelearningservices.models.SecretsType
    """

    _validation = {
        'secrets_type': {'required': True},
    }

    _attribute_map = {
        'secrets_type': {'key': 'secretsType', 'type': 'str'},
    }

    _subtype_map = {
        'secrets_type': {'AccountKey': 'AccountKeyDatastoreSecrets', 'Certificate': 'CertificateDatastoreSecrets', 'KerberosKeytab': 'KerberosKeytabSecrets', 'KerberosPassword': 'KerberosPasswordSecrets', 'Sas': 'SasDatastoreSecrets', 'ServicePrincipal': 'ServicePrincipalDatastoreSecrets'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(DatastoreSecrets, self).__init__(**kwargs)
        self.secrets_type = None  # type: Optional[str]


class AccountKeyDatastoreSecrets(DatastoreSecrets):
    """Datastore account key secrets.

    All required parameters must be populated in order to send to Azure.

    :ivar secrets_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "AccountKey", "Certificate", "Sas",
     "ServicePrincipal", "KerberosPassword", "KerberosKeytab".
    :vartype secrets_type: str or ~azure.mgmt.machinelearningservices.models.SecretsType
    :ivar key: Storage account key.
    :vartype key: str
    """

    _validation = {
        'secrets_type': {'required': True},
    }

    _attribute_map = {
        'secrets_type': {'key': 'secretsType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword key: Storage account key.
        :paramtype key: str
        """
        super(AccountKeyDatastoreSecrets, self).__init__(**kwargs)
        self.secrets_type = 'AccountKey'  # type: str
        self.key = key


class AcrDetails(msrest.serialization.Model):
    """Details of ACR account to be used for the Registry.

    :ivar system_created_acr_account:
    :vartype system_created_acr_account:
     ~azure.mgmt.machinelearningservices.models.SystemCreatedAcrAccount
    :ivar user_created_acr_account:
    :vartype user_created_acr_account:
     ~azure.mgmt.machinelearningservices.models.UserCreatedAcrAccount
    """

    _attribute_map = {
        'system_created_acr_account': {'key': 'systemCreatedAcrAccount', 'type': 'SystemCreatedAcrAccount'},
        'user_created_acr_account': {'key': 'userCreatedAcrAccount', 'type': 'UserCreatedAcrAccount'},
    }

    def __init__(
        self,
        *,
        system_created_acr_account: Optional["SystemCreatedAcrAccount"] = None,
        user_created_acr_account: Optional["UserCreatedAcrAccount"] = None,
        **kwargs
    ):
        """
        :keyword system_created_acr_account:
        :paramtype system_created_acr_account:
         ~azure.mgmt.machinelearningservices.models.SystemCreatedAcrAccount
        :keyword user_created_acr_account:
        :paramtype user_created_acr_account:
         ~azure.mgmt.machinelearningservices.models.UserCreatedAcrAccount
        """
        super(AcrDetails, self).__init__(**kwargs)
        self.system_created_acr_account = system_created_acr_account
        self.user_created_acr_account = user_created_acr_account


class AKSSchema(msrest.serialization.Model):
    """AKSSchema.

    :ivar properties: AKS properties.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.AKSSchemaProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'AKSSchemaProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["AKSSchemaProperties"] = None,
        **kwargs
    ):
        """
        :keyword properties: AKS properties.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.AKSSchemaProperties
        """
        super(AKSSchema, self).__init__(**kwargs)
        self.properties = properties


class Compute(msrest.serialization.Model):
    """Machine Learning compute object.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AKS, AmlCompute, ComputeInstance, DataFactory, DataLakeAnalytics, Databricks, HDInsight, Kubernetes, SynapseSpark, VirtualMachine.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar compute_type: Required. The type of compute.Constant filled by server. Possible values
     include: "AKS", "Kubernetes", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine",
     "HDInsight", "Databricks", "DataLakeAnalytics", "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :ivar compute_location: Location for the underlying compute.
    :vartype compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values are Unknown,
     Updating, Provisioning, Succeeded, and Failed. Possible values include: "Unknown", "Updating",
     "Creating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ComputeProvisioningState
    :ivar description: The description of the Machine Learning compute.
    :vartype description: str
    :ivar created_on: The time at which the compute was created.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: The time at which the compute was last modified.
    :vartype modified_on: ~datetime.datetime
    :ivar resource_id: ARM resource id of the underlying compute.
    :vartype resource_id: str
    :ivar provisioning_errors: Errors during provisioning.
    :vartype provisioning_errors: list[~azure.mgmt.machinelearningservices.models.ErrorResponse]
    :ivar is_attached_compute: Indicating whether the compute was provisioned by user and brought
     from outside if true, or machine learning service provisioned it if false.
    :vartype is_attached_compute: bool
    :ivar disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI
     and AAD exclusively for authentication.
    :vartype disable_local_auth: bool
    """

    _validation = {
        'compute_type': {'required': True},
        'compute_location': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'modified_on': {'readonly': True},
        'provisioning_errors': {'readonly': True},
        'is_attached_compute': {'readonly': True},
        'disable_local_auth': {'readonly': True},
    }

    _attribute_map = {
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'compute_location': {'key': 'computeLocation', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'modified_on': {'key': 'modifiedOn', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'provisioning_errors': {'key': 'provisioningErrors', 'type': '[ErrorResponse]'},
        'is_attached_compute': {'key': 'isAttachedCompute', 'type': 'bool'},
        'disable_local_auth': {'key': 'disableLocalAuth', 'type': 'bool'},
    }

    _subtype_map = {
        'compute_type': {'AKS': 'AKS', 'AmlCompute': 'AmlCompute', 'ComputeInstance': 'ComputeInstance', 'DataFactory': 'DataFactory', 'DataLakeAnalytics': 'DataLakeAnalytics', 'Databricks': 'Databricks', 'HDInsight': 'HDInsight', 'Kubernetes': 'Kubernetes', 'SynapseSpark': 'SynapseSpark', 'VirtualMachine': 'VirtualMachine'}
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        resource_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword description: The description of the Machine Learning compute.
        :paramtype description: str
        :keyword resource_id: ARM resource id of the underlying compute.
        :paramtype resource_id: str
        """
        super(Compute, self).__init__(**kwargs)
        self.compute_type = None  # type: Optional[str]
        self.compute_location = None
        self.provisioning_state = None
        self.description = description
        self.created_on = None
        self.modified_on = None
        self.resource_id = resource_id
        self.provisioning_errors = None
        self.is_attached_compute = None
        self.disable_local_auth = None


class AKS(Compute, AKSSchema):
    """A Machine Learning compute based on AKS.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar properties: AKS properties.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.AKSSchemaProperties
    :ivar compute_type: Required. The type of compute.Constant filled by server. Possible values
     include: "AKS", "Kubernetes", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine",
     "HDInsight", "Databricks", "DataLakeAnalytics", "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :ivar compute_location: Location for the underlying compute.
    :vartype compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values are Unknown,
     Updating, Provisioning, Succeeded, and Failed. Possible values include: "Unknown", "Updating",
     "Creating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ComputeProvisioningState
    :ivar description: The description of the Machine Learning compute.
    :vartype description: str
    :ivar created_on: The time at which the compute was created.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: The time at which the compute was last modified.
    :vartype modified_on: ~datetime.datetime
    :ivar resource_id: ARM resource id of the underlying compute.
    :vartype resource_id: str
    :ivar provisioning_errors: Errors during provisioning.
    :vartype provisioning_errors: list[~azure.mgmt.machinelearningservices.models.ErrorResponse]
    :ivar is_attached_compute: Indicating whether the compute was provisioned by user and brought
     from outside if true, or machine learning service provisioned it if false.
    :vartype is_attached_compute: bool
    :ivar disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI
     and AAD exclusively for authentication.
    :vartype disable_local_auth: bool
    """

    _validation = {
        'compute_type': {'required': True},
        'compute_location': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'modified_on': {'readonly': True},
        'provisioning_errors': {'readonly': True},
        'is_attached_compute': {'readonly': True},
        'disable_local_auth': {'readonly': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'AKSSchemaProperties'},
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'compute_location': {'key': 'computeLocation', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'modified_on': {'key': 'modifiedOn', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'provisioning_errors': {'key': 'provisioningErrors', 'type': '[ErrorResponse]'},
        'is_attached_compute': {'key': 'isAttachedCompute', 'type': 'bool'},
        'disable_local_auth': {'key': 'disableLocalAuth', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        properties: Optional["AKSSchemaProperties"] = None,
        description: Optional[str] = None,
        resource_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword properties: AKS properties.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.AKSSchemaProperties
        :keyword description: The description of the Machine Learning compute.
        :paramtype description: str
        :keyword resource_id: ARM resource id of the underlying compute.
        :paramtype resource_id: str
        """
        super(AKS, self).__init__(description=description, resource_id=resource_id, properties=properties, **kwargs)
        self.properties = properties
        self.compute_type = 'AKS'  # type: str
        self.compute_location = None
        self.provisioning_state = None
        self.description = description
        self.created_on = None
        self.modified_on = None
        self.resource_id = resource_id
        self.provisioning_errors = None
        self.is_attached_compute = None
        self.disable_local_auth = None


class AksComputeSecretsProperties(msrest.serialization.Model):
    """Properties of AksComputeSecrets.

    :ivar user_kube_config: Content of kubeconfig file that can be used to connect to the
     Kubernetes cluster.
    :vartype user_kube_config: str
    :ivar admin_kube_config: Content of kubeconfig file that can be used to connect to the
     Kubernetes cluster.
    :vartype admin_kube_config: str
    :ivar image_pull_secret_name: Image registry pull secret.
    :vartype image_pull_secret_name: str
    """

    _attribute_map = {
        'user_kube_config': {'key': 'userKubeConfig', 'type': 'str'},
        'admin_kube_config': {'key': 'adminKubeConfig', 'type': 'str'},
        'image_pull_secret_name': {'key': 'imagePullSecretName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        user_kube_config: Optional[str] = None,
        admin_kube_config: Optional[str] = None,
        image_pull_secret_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword user_kube_config: Content of kubeconfig file that can be used to connect to the
         Kubernetes cluster.
        :paramtype user_kube_config: str
        :keyword admin_kube_config: Content of kubeconfig file that can be used to connect to the
         Kubernetes cluster.
        :paramtype admin_kube_config: str
        :keyword image_pull_secret_name: Image registry pull secret.
        :paramtype image_pull_secret_name: str
        """
        super(AksComputeSecretsProperties, self).__init__(**kwargs)
        self.user_kube_config = user_kube_config
        self.admin_kube_config = admin_kube_config
        self.image_pull_secret_name = image_pull_secret_name


class ComputeSecrets(msrest.serialization.Model):
    """Secrets related to a Machine Learning compute. Might differ for every type of compute.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AksComputeSecrets, DatabricksComputeSecrets, VirtualMachineSecrets.

    All required parameters must be populated in order to send to Azure.

    :ivar compute_type: Required. The type of compute.Constant filled by server. Possible values
     include: "AKS", "Kubernetes", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine",
     "HDInsight", "Databricks", "DataLakeAnalytics", "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    """

    _validation = {
        'compute_type': {'required': True},
    }

    _attribute_map = {
        'compute_type': {'key': 'computeType', 'type': 'str'},
    }

    _subtype_map = {
        'compute_type': {'AKS': 'AksComputeSecrets', 'Databricks': 'DatabricksComputeSecrets', 'VirtualMachine': 'VirtualMachineSecrets'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ComputeSecrets, self).__init__(**kwargs)
        self.compute_type = None  # type: Optional[str]


class AksComputeSecrets(ComputeSecrets, AksComputeSecretsProperties):
    """Secrets related to a Machine Learning compute based on AKS.

    All required parameters must be populated in order to send to Azure.

    :ivar user_kube_config: Content of kubeconfig file that can be used to connect to the
     Kubernetes cluster.
    :vartype user_kube_config: str
    :ivar admin_kube_config: Content of kubeconfig file that can be used to connect to the
     Kubernetes cluster.
    :vartype admin_kube_config: str
    :ivar image_pull_secret_name: Image registry pull secret.
    :vartype image_pull_secret_name: str
    :ivar compute_type: Required. The type of compute.Constant filled by server. Possible values
     include: "AKS", "Kubernetes", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine",
     "HDInsight", "Databricks", "DataLakeAnalytics", "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    """

    _validation = {
        'compute_type': {'required': True},
    }

    _attribute_map = {
        'user_kube_config': {'key': 'userKubeConfig', 'type': 'str'},
        'admin_kube_config': {'key': 'adminKubeConfig', 'type': 'str'},
        'image_pull_secret_name': {'key': 'imagePullSecretName', 'type': 'str'},
        'compute_type': {'key': 'computeType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        user_kube_config: Optional[str] = None,
        admin_kube_config: Optional[str] = None,
        image_pull_secret_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword user_kube_config: Content of kubeconfig file that can be used to connect to the
         Kubernetes cluster.
        :paramtype user_kube_config: str
        :keyword admin_kube_config: Content of kubeconfig file that can be used to connect to the
         Kubernetes cluster.
        :paramtype admin_kube_config: str
        :keyword image_pull_secret_name: Image registry pull secret.
        :paramtype image_pull_secret_name: str
        """
        super(AksComputeSecrets, self).__init__(user_kube_config=user_kube_config, admin_kube_config=admin_kube_config, image_pull_secret_name=image_pull_secret_name, **kwargs)
        self.user_kube_config = user_kube_config
        self.admin_kube_config = admin_kube_config
        self.image_pull_secret_name = image_pull_secret_name
        self.compute_type = 'AKS'  # type: str


class AksNetworkingConfiguration(msrest.serialization.Model):
    """Advance configuration for AKS networking.

    :ivar subnet_id: Virtual network subnet resource ID the compute nodes belong to.
    :vartype subnet_id: str
    :ivar service_cidr: A CIDR notation IP range from which to assign service cluster IPs. It must
     not overlap with any Subnet IP ranges.
    :vartype service_cidr: str
    :ivar dns_service_ip: An IP address assigned to the Kubernetes DNS service. It must be within
     the Kubernetes service address range specified in serviceCidr.
    :vartype dns_service_ip: str
    :ivar docker_bridge_cidr: A CIDR notation IP range assigned to the Docker bridge network. It
     must not overlap with any Subnet IP ranges or the Kubernetes service address range.
    :vartype docker_bridge_cidr: str
    """

    _validation = {
        'service_cidr': {'pattern': r'^([0-9]{1,3}\.){3}[0-9]{1,3}(\/([0-9]|[1-2][0-9]|3[0-2]))?$'},
        'dns_service_ip': {'pattern': r'^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$'},
        'docker_bridge_cidr': {'pattern': r'^([0-9]{1,3}\.){3}[0-9]{1,3}(\/([0-9]|[1-2][0-9]|3[0-2]))?$'},
    }

    _attribute_map = {
        'subnet_id': {'key': 'subnetId', 'type': 'str'},
        'service_cidr': {'key': 'serviceCidr', 'type': 'str'},
        'dns_service_ip': {'key': 'dnsServiceIP', 'type': 'str'},
        'docker_bridge_cidr': {'key': 'dockerBridgeCidr', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        subnet_id: Optional[str] = None,
        service_cidr: Optional[str] = None,
        dns_service_ip: Optional[str] = None,
        docker_bridge_cidr: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword subnet_id: Virtual network subnet resource ID the compute nodes belong to.
        :paramtype subnet_id: str
        :keyword service_cidr: A CIDR notation IP range from which to assign service cluster IPs. It
         must not overlap with any Subnet IP ranges.
        :paramtype service_cidr: str
        :keyword dns_service_ip: An IP address assigned to the Kubernetes DNS service. It must be
         within the Kubernetes service address range specified in serviceCidr.
        :paramtype dns_service_ip: str
        :keyword docker_bridge_cidr: A CIDR notation IP range assigned to the Docker bridge network. It
         must not overlap with any Subnet IP ranges or the Kubernetes service address range.
        :paramtype docker_bridge_cidr: str
        """
        super(AksNetworkingConfiguration, self).__init__(**kwargs)
        self.subnet_id = subnet_id
        self.service_cidr = service_cidr
        self.dns_service_ip = dns_service_ip
        self.docker_bridge_cidr = docker_bridge_cidr


class AKSSchemaProperties(msrest.serialization.Model):
    """AKS properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar cluster_fqdn: Cluster full qualified domain name.
    :vartype cluster_fqdn: str
    :ivar system_services: System services.
    :vartype system_services: list[~azure.mgmt.machinelearningservices.models.SystemService]
    :ivar agent_count: Number of agents.
    :vartype agent_count: int
    :ivar agent_vm_size: Agent virtual machine size.
    :vartype agent_vm_size: str
    :ivar cluster_purpose: Intended usage of the cluster. Possible values include: "FastProd",
     "DenseProd", "DevTest". Default value: "FastProd".
    :vartype cluster_purpose: str or ~azure.mgmt.machinelearningservices.models.ClusterPurpose
    :ivar ssl_configuration: SSL configuration.
    :vartype ssl_configuration: ~azure.mgmt.machinelearningservices.models.SslConfiguration
    :ivar aks_networking_configuration: AKS networking configuration for vnet.
    :vartype aks_networking_configuration:
     ~azure.mgmt.machinelearningservices.models.AksNetworkingConfiguration
    :ivar load_balancer_type: Load Balancer Type. Possible values include: "PublicIp",
     "InternalLoadBalancer". Default value: "PublicIp".
    :vartype load_balancer_type: str or ~azure.mgmt.machinelearningservices.models.LoadBalancerType
    :ivar load_balancer_subnet: Load Balancer Subnet.
    :vartype load_balancer_subnet: str
    """

    _validation = {
        'system_services': {'readonly': True},
        'agent_count': {'minimum': 0},
    }

    _attribute_map = {
        'cluster_fqdn': {'key': 'clusterFqdn', 'type': 'str'},
        'system_services': {'key': 'systemServices', 'type': '[SystemService]'},
        'agent_count': {'key': 'agentCount', 'type': 'int'},
        'agent_vm_size': {'key': 'agentVmSize', 'type': 'str'},
        'cluster_purpose': {'key': 'clusterPurpose', 'type': 'str'},
        'ssl_configuration': {'key': 'sslConfiguration', 'type': 'SslConfiguration'},
        'aks_networking_configuration': {'key': 'aksNetworkingConfiguration', 'type': 'AksNetworkingConfiguration'},
        'load_balancer_type': {'key': 'loadBalancerType', 'type': 'str'},
        'load_balancer_subnet': {'key': 'loadBalancerSubnet', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        cluster_fqdn: Optional[str] = None,
        agent_count: Optional[int] = None,
        agent_vm_size: Optional[str] = None,
        cluster_purpose: Optional[Union[str, "ClusterPurpose"]] = "FastProd",
        ssl_configuration: Optional["SslConfiguration"] = None,
        aks_networking_configuration: Optional["AksNetworkingConfiguration"] = None,
        load_balancer_type: Optional[Union[str, "LoadBalancerType"]] = "PublicIp",
        load_balancer_subnet: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword cluster_fqdn: Cluster full qualified domain name.
        :paramtype cluster_fqdn: str
        :keyword agent_count: Number of agents.
        :paramtype agent_count: int
        :keyword agent_vm_size: Agent virtual machine size.
        :paramtype agent_vm_size: str
        :keyword cluster_purpose: Intended usage of the cluster. Possible values include: "FastProd",
         "DenseProd", "DevTest". Default value: "FastProd".
        :paramtype cluster_purpose: str or ~azure.mgmt.machinelearningservices.models.ClusterPurpose
        :keyword ssl_configuration: SSL configuration.
        :paramtype ssl_configuration: ~azure.mgmt.machinelearningservices.models.SslConfiguration
        :keyword aks_networking_configuration: AKS networking configuration for vnet.
        :paramtype aks_networking_configuration:
         ~azure.mgmt.machinelearningservices.models.AksNetworkingConfiguration
        :keyword load_balancer_type: Load Balancer Type. Possible values include: "PublicIp",
         "InternalLoadBalancer". Default value: "PublicIp".
        :paramtype load_balancer_type: str or
         ~azure.mgmt.machinelearningservices.models.LoadBalancerType
        :keyword load_balancer_subnet: Load Balancer Subnet.
        :paramtype load_balancer_subnet: str
        """
        super(AKSSchemaProperties, self).__init__(**kwargs)
        self.cluster_fqdn = cluster_fqdn
        self.system_services = None
        self.agent_count = agent_count
        self.agent_vm_size = agent_vm_size
        self.cluster_purpose = cluster_purpose
        self.ssl_configuration = ssl_configuration
        self.aks_networking_configuration = aks_networking_configuration
        self.load_balancer_type = load_balancer_type
        self.load_balancer_subnet = load_balancer_subnet


class Nodes(msrest.serialization.Model):
    """Abstract Nodes definition.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AllNodes.

    All required parameters must be populated in order to send to Azure.

    :ivar nodes_value_type: Required. [Required] Type of the Nodes value.Constant filled by server.
     Possible values include: "All", "Custom".
    :vartype nodes_value_type: str or ~azure.mgmt.machinelearningservices.models.NodesValueType
    """

    _validation = {
        'nodes_value_type': {'required': True},
    }

    _attribute_map = {
        'nodes_value_type': {'key': 'nodesValueType', 'type': 'str'},
    }

    _subtype_map = {
        'nodes_value_type': {'All': 'AllNodes'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Nodes, self).__init__(**kwargs)
        self.nodes_value_type = None  # type: Optional[str]


class AllNodes(Nodes):
    """All nodes means the service will be running on all of the nodes of the job.

    All required parameters must be populated in order to send to Azure.

    :ivar nodes_value_type: Required. [Required] Type of the Nodes value.Constant filled by server.
     Possible values include: "All", "Custom".
    :vartype nodes_value_type: str or ~azure.mgmt.machinelearningservices.models.NodesValueType
    """

    _validation = {
        'nodes_value_type': {'required': True},
    }

    _attribute_map = {
        'nodes_value_type': {'key': 'nodesValueType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AllNodes, self).__init__(**kwargs)
        self.nodes_value_type = 'All'  # type: str


class AmlComputeSchema(msrest.serialization.Model):
    """Properties(top level) of AmlCompute.

    :ivar properties: Properties of AmlCompute.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.AmlComputeProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'AmlComputeProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["AmlComputeProperties"] = None,
        **kwargs
    ):
        """
        :keyword properties: Properties of AmlCompute.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.AmlComputeProperties
        """
        super(AmlComputeSchema, self).__init__(**kwargs)
        self.properties = properties


class AmlCompute(Compute, AmlComputeSchema):
    """An Azure Machine Learning compute.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar properties: Properties of AmlCompute.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.AmlComputeProperties
    :ivar compute_type: Required. The type of compute.Constant filled by server. Possible values
     include: "AKS", "Kubernetes", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine",
     "HDInsight", "Databricks", "DataLakeAnalytics", "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :ivar compute_location: Location for the underlying compute.
    :vartype compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values are Unknown,
     Updating, Provisioning, Succeeded, and Failed. Possible values include: "Unknown", "Updating",
     "Creating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ComputeProvisioningState
    :ivar description: The description of the Machine Learning compute.
    :vartype description: str
    :ivar created_on: The time at which the compute was created.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: The time at which the compute was last modified.
    :vartype modified_on: ~datetime.datetime
    :ivar resource_id: ARM resource id of the underlying compute.
    :vartype resource_id: str
    :ivar provisioning_errors: Errors during provisioning.
    :vartype provisioning_errors: list[~azure.mgmt.machinelearningservices.models.ErrorResponse]
    :ivar is_attached_compute: Indicating whether the compute was provisioned by user and brought
     from outside if true, or machine learning service provisioned it if false.
    :vartype is_attached_compute: bool
    :ivar disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI
     and AAD exclusively for authentication.
    :vartype disable_local_auth: bool
    """

    _validation = {
        'compute_type': {'required': True},
        'compute_location': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'modified_on': {'readonly': True},
        'provisioning_errors': {'readonly': True},
        'is_attached_compute': {'readonly': True},
        'disable_local_auth': {'readonly': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'AmlComputeProperties'},
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'compute_location': {'key': 'computeLocation', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'modified_on': {'key': 'modifiedOn', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'provisioning_errors': {'key': 'provisioningErrors', 'type': '[ErrorResponse]'},
        'is_attached_compute': {'key': 'isAttachedCompute', 'type': 'bool'},
        'disable_local_auth': {'key': 'disableLocalAuth', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        properties: Optional["AmlComputeProperties"] = None,
        description: Optional[str] = None,
        resource_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword properties: Properties of AmlCompute.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.AmlComputeProperties
        :keyword description: The description of the Machine Learning compute.
        :paramtype description: str
        :keyword resource_id: ARM resource id of the underlying compute.
        :paramtype resource_id: str
        """
        super(AmlCompute, self).__init__(description=description, resource_id=resource_id, properties=properties, **kwargs)
        self.properties = properties
        self.compute_type = 'AmlCompute'  # type: str
        self.compute_location = None
        self.provisioning_state = None
        self.description = description
        self.created_on = None
        self.modified_on = None
        self.resource_id = resource_id
        self.provisioning_errors = None
        self.is_attached_compute = None
        self.disable_local_auth = None


class AmlComputeNodeInformation(msrest.serialization.Model):
    """Compute node information related to a AmlCompute.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar node_id: ID of the compute node.
    :vartype node_id: str
    :ivar private_ip_address: Private IP address of the compute node.
    :vartype private_ip_address: str
    :ivar public_ip_address: Public IP address of the compute node.
    :vartype public_ip_address: str
    :ivar port: SSH port number of the node.
    :vartype port: int
    :ivar node_state: State of the compute node. Values are idle, running, preparing, unusable,
     leaving and preempted. Possible values include: "idle", "running", "preparing", "unusable",
     "leaving", "preempted".
    :vartype node_state: str or ~azure.mgmt.machinelearningservices.models.NodeState
    :ivar run_id: ID of the Experiment running on the node, if any else null.
    :vartype run_id: str
    """

    _validation = {
        'node_id': {'readonly': True},
        'private_ip_address': {'readonly': True},
        'public_ip_address': {'readonly': True},
        'port': {'readonly': True},
        'node_state': {'readonly': True},
        'run_id': {'readonly': True},
    }

    _attribute_map = {
        'node_id': {'key': 'nodeId', 'type': 'str'},
        'private_ip_address': {'key': 'privateIpAddress', 'type': 'str'},
        'public_ip_address': {'key': 'publicIpAddress', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
        'node_state': {'key': 'nodeState', 'type': 'str'},
        'run_id': {'key': 'runId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AmlComputeNodeInformation, self).__init__(**kwargs)
        self.node_id = None
        self.private_ip_address = None
        self.public_ip_address = None
        self.port = None
        self.node_state = None
        self.run_id = None


class AmlComputeNodesInformation(msrest.serialization.Model):
    """Result of AmlCompute Nodes.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar nodes: The collection of returned AmlCompute nodes details.
    :vartype nodes: list[~azure.mgmt.machinelearningservices.models.AmlComputeNodeInformation]
    :ivar next_link: The continuation token.
    :vartype next_link: str
    """

    _validation = {
        'nodes': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'nodes': {'key': 'nodes', 'type': '[AmlComputeNodeInformation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AmlComputeNodesInformation, self).__init__(**kwargs)
        self.nodes = None
        self.next_link = None


class AmlComputeProperties(msrest.serialization.Model):
    """AML Compute properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar os_type: Compute OS Type. Possible values include: "Linux", "Windows". Default value:
     "Linux".
    :vartype os_type: str or ~azure.mgmt.machinelearningservices.models.OsType
    :ivar vm_size: Virtual Machine Size.
    :vartype vm_size: str
    :ivar vm_priority: Virtual Machine priority. Possible values include: "Dedicated",
     "LowPriority".
    :vartype vm_priority: str or ~azure.mgmt.machinelearningservices.models.VmPriority
    :ivar virtual_machine_image: Virtual Machine image for AML Compute - windows only.
    :vartype virtual_machine_image: ~azure.mgmt.machinelearningservices.models.VirtualMachineImage
    :ivar isolated_network: Network is isolated or not.
    :vartype isolated_network: bool
    :ivar scale_settings: Scale settings for AML Compute.
    :vartype scale_settings: ~azure.mgmt.machinelearningservices.models.ScaleSettings
    :ivar user_account_credentials: Credentials for an administrator user account that will be
     created on each compute node.
    :vartype user_account_credentials:
     ~azure.mgmt.machinelearningservices.models.UserAccountCredentials
    :ivar subnet: Virtual network subnet resource ID the compute nodes belong to.
    :vartype subnet: ~azure.mgmt.machinelearningservices.models.ResourceId
    :ivar remote_login_port_public_access: State of the public SSH port. Possible values are:
     Disabled - Indicates that the public ssh port is closed on all nodes of the cluster. Enabled -
     Indicates that the public ssh port is open on all nodes of the cluster. NotSpecified -
     Indicates that the public ssh port is closed on all nodes of the cluster if VNet is defined,
     else is open all public nodes. It can be default only during cluster creation time, after
     creation it will be either enabled or disabled. Possible values include: "Enabled", "Disabled",
     "NotSpecified". Default value: "NotSpecified".
    :vartype remote_login_port_public_access: str or
     ~azure.mgmt.machinelearningservices.models.RemoteLoginPortPublicAccess
    :ivar allocation_state: Allocation state of the compute. Possible values are: steady -
     Indicates that the compute is not resizing. There are no changes to the number of compute nodes
     in the compute in progress. A compute enters this state when it is created and when no
     operations are being performed on the compute to change the number of compute nodes. resizing -
     Indicates that the compute is resizing; that is, compute nodes are being added to or removed
     from the compute. Possible values include: "Steady", "Resizing".
    :vartype allocation_state: str or ~azure.mgmt.machinelearningservices.models.AllocationState
    :ivar allocation_state_transition_time: The time at which the compute entered its current
     allocation state.
    :vartype allocation_state_transition_time: ~datetime.datetime
    :ivar errors: Collection of errors encountered by various compute nodes during node setup.
    :vartype errors: list[~azure.mgmt.machinelearningservices.models.ErrorResponse]
    :ivar current_node_count: The number of compute nodes currently assigned to the compute.
    :vartype current_node_count: int
    :ivar target_node_count: The target number of compute nodes for the compute. If the
     allocationState is resizing, this property denotes the target node count for the ongoing resize
     operation. If the allocationState is steady, this property denotes the target node count for
     the previous resize operation.
    :vartype target_node_count: int
    :ivar node_state_counts: Counts of various node states on the compute.
    :vartype node_state_counts: ~azure.mgmt.machinelearningservices.models.NodeStateCounts
    :ivar enable_node_public_ip: Enable or disable node public IP address provisioning. Possible
     values are: Possible values are: true - Indicates that the compute nodes will have public IPs
     provisioned. false - Indicates that the compute nodes will have a private endpoint and no
     public IPs.
    :vartype enable_node_public_ip: bool
    :ivar property_bag: A property bag containing additional properties.
    :vartype property_bag: any
    """

    _validation = {
        'allocation_state': {'readonly': True},
        'allocation_state_transition_time': {'readonly': True},
        'errors': {'readonly': True},
        'current_node_count': {'readonly': True},
        'target_node_count': {'readonly': True},
        'node_state_counts': {'readonly': True},
    }

    _attribute_map = {
        'os_type': {'key': 'osType', 'type': 'str'},
        'vm_size': {'key': 'vmSize', 'type': 'str'},
        'vm_priority': {'key': 'vmPriority', 'type': 'str'},
        'virtual_machine_image': {'key': 'virtualMachineImage', 'type': 'VirtualMachineImage'},
        'isolated_network': {'key': 'isolatedNetwork', 'type': 'bool'},
        'scale_settings': {'key': 'scaleSettings', 'type': 'ScaleSettings'},
        'user_account_credentials': {'key': 'userAccountCredentials', 'type': 'UserAccountCredentials'},
        'subnet': {'key': 'subnet', 'type': 'ResourceId'},
        'remote_login_port_public_access': {'key': 'remoteLoginPortPublicAccess', 'type': 'str'},
        'allocation_state': {'key': 'allocationState', 'type': 'str'},
        'allocation_state_transition_time': {'key': 'allocationStateTransitionTime', 'type': 'iso-8601'},
        'errors': {'key': 'errors', 'type': '[ErrorResponse]'},
        'current_node_count': {'key': 'currentNodeCount', 'type': 'int'},
        'target_node_count': {'key': 'targetNodeCount', 'type': 'int'},
        'node_state_counts': {'key': 'nodeStateCounts', 'type': 'NodeStateCounts'},
        'enable_node_public_ip': {'key': 'enableNodePublicIp', 'type': 'bool'},
        'property_bag': {'key': 'propertyBag', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        os_type: Optional[Union[str, "OsType"]] = "Linux",
        vm_size: Optional[str] = None,
        vm_priority: Optional[Union[str, "VmPriority"]] = None,
        virtual_machine_image: Optional["VirtualMachineImage"] = None,
        isolated_network: Optional[bool] = None,
        scale_settings: Optional["ScaleSettings"] = None,
        user_account_credentials: Optional["UserAccountCredentials"] = None,
        subnet: Optional["ResourceId"] = None,
        remote_login_port_public_access: Optional[Union[str, "RemoteLoginPortPublicAccess"]] = "NotSpecified",
        enable_node_public_ip: Optional[bool] = True,
        property_bag: Optional[Any] = None,
        **kwargs
    ):
        """
        :keyword os_type: Compute OS Type. Possible values include: "Linux", "Windows". Default value:
         "Linux".
        :paramtype os_type: str or ~azure.mgmt.machinelearningservices.models.OsType
        :keyword vm_size: Virtual Machine Size.
        :paramtype vm_size: str
        :keyword vm_priority: Virtual Machine priority. Possible values include: "Dedicated",
         "LowPriority".
        :paramtype vm_priority: str or ~azure.mgmt.machinelearningservices.models.VmPriority
        :keyword virtual_machine_image: Virtual Machine image for AML Compute - windows only.
        :paramtype virtual_machine_image:
         ~azure.mgmt.machinelearningservices.models.VirtualMachineImage
        :keyword isolated_network: Network is isolated or not.
        :paramtype isolated_network: bool
        :keyword scale_settings: Scale settings for AML Compute.
        :paramtype scale_settings: ~azure.mgmt.machinelearningservices.models.ScaleSettings
        :keyword user_account_credentials: Credentials for an administrator user account that will be
         created on each compute node.
        :paramtype user_account_credentials:
         ~azure.mgmt.machinelearningservices.models.UserAccountCredentials
        :keyword subnet: Virtual network subnet resource ID the compute nodes belong to.
        :paramtype subnet: ~azure.mgmt.machinelearningservices.models.ResourceId
        :keyword remote_login_port_public_access: State of the public SSH port. Possible values are:
         Disabled - Indicates that the public ssh port is closed on all nodes of the cluster. Enabled -
         Indicates that the public ssh port is open on all nodes of the cluster. NotSpecified -
         Indicates that the public ssh port is closed on all nodes of the cluster if VNet is defined,
         else is open all public nodes. It can be default only during cluster creation time, after
         creation it will be either enabled or disabled. Possible values include: "Enabled", "Disabled",
         "NotSpecified". Default value: "NotSpecified".
        :paramtype remote_login_port_public_access: str or
         ~azure.mgmt.machinelearningservices.models.RemoteLoginPortPublicAccess
        :keyword enable_node_public_ip: Enable or disable node public IP address provisioning. Possible
         values are: Possible values are: true - Indicates that the compute nodes will have public IPs
         provisioned. false - Indicates that the compute nodes will have a private endpoint and no
         public IPs.
        :paramtype enable_node_public_ip: bool
        :keyword property_bag: A property bag containing additional properties.
        :paramtype property_bag: any
        """
        super(AmlComputeProperties, self).__init__(**kwargs)
        self.os_type = os_type
        self.vm_size = vm_size
        self.vm_priority = vm_priority
        self.virtual_machine_image = virtual_machine_image
        self.isolated_network = isolated_network
        self.scale_settings = scale_settings
        self.user_account_credentials = user_account_credentials
        self.subnet = subnet
        self.remote_login_port_public_access = remote_login_port_public_access
        self.allocation_state = None
        self.allocation_state_transition_time = None
        self.errors = None
        self.current_node_count = None
        self.target_node_count = None
        self.node_state_counts = None
        self.enable_node_public_ip = enable_node_public_ip
        self.property_bag = property_bag


class AmlOperation(msrest.serialization.Model):
    """Azure Machine Learning REST API operation.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: Display name of operation.
    :vartype display: ~azure.mgmt.machinelearningservices.models.AmlOperationDisplay
    :ivar is_data_action: Indicates whether the operation applies to data-plane.
    :vartype is_data_action: bool
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'AmlOperationDisplay'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["AmlOperationDisplay"] = None,
        is_data_action: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword name: Operation name: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword display: Display name of operation.
        :paramtype display: ~azure.mgmt.machinelearningservices.models.AmlOperationDisplay
        :keyword is_data_action: Indicates whether the operation applies to data-plane.
        :paramtype is_data_action: bool
        """
        super(AmlOperation, self).__init__(**kwargs)
        self.name = name
        self.display = display
        self.is_data_action = is_data_action


class AmlOperationDisplay(msrest.serialization.Model):
    """Display name of operation.

    :ivar provider: The resource provider name: Microsoft.MachineLearningExperimentation.
    :vartype provider: str
    :ivar resource: The resource on which the operation is performed.
    :vartype resource: str
    :ivar operation: The operation that users can perform.
    :vartype operation: str
    :ivar description: The description for the operation.
    :vartype description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provider: The resource provider name: Microsoft.MachineLearningExperimentation.
        :paramtype provider: str
        :keyword resource: The resource on which the operation is performed.
        :paramtype resource: str
        :keyword operation: The operation that users can perform.
        :paramtype operation: str
        :keyword description: The description for the operation.
        :paramtype description: str
        """
        super(AmlOperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class AmlOperationListResult(msrest.serialization.Model):
    """An array of operations supported by the resource provider.

    :ivar value: List of AML operations supported by the AML resource provider.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.AmlOperation]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AmlOperation]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["AmlOperation"]] = None,
        **kwargs
    ):
        """
        :keyword value: List of AML operations supported by the AML resource provider.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.AmlOperation]
        """
        super(AmlOperationListResult, self).__init__(**kwargs)
        self.value = value


class IdentityConfiguration(msrest.serialization.Model):
    """Base definition for identity configuration.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AmlToken, ManagedIdentity, UserIdentity.

    All required parameters must be populated in order to send to Azure.

    :ivar identity_type: Required. [Required] Specifies the type of identity framework.Constant
     filled by server. Possible values include: "Managed", "AMLToken", "UserIdentity".
    :vartype identity_type: str or
     ~azure.mgmt.machinelearningservices.models.IdentityConfigurationType
    """

    _validation = {
        'identity_type': {'required': True},
    }

    _attribute_map = {
        'identity_type': {'key': 'identityType', 'type': 'str'},
    }

    _subtype_map = {
        'identity_type': {'AMLToken': 'AmlToken', 'Managed': 'ManagedIdentity', 'UserIdentity': 'UserIdentity'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(IdentityConfiguration, self).__init__(**kwargs)
        self.identity_type = None  # type: Optional[str]


class AmlToken(IdentityConfiguration):
    """AML Token identity configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar identity_type: Required. [Required] Specifies the type of identity framework.Constant
     filled by server. Possible values include: "Managed", "AMLToken", "UserIdentity".
    :vartype identity_type: str or
     ~azure.mgmt.machinelearningservices.models.IdentityConfigurationType
    """

    _validation = {
        'identity_type': {'required': True},
    }

    _attribute_map = {
        'identity_type': {'key': 'identityType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AmlToken, self).__init__(**kwargs)
        self.identity_type = 'AMLToken'  # type: str


class AmlUserFeature(msrest.serialization.Model):
    """Features enabled for a workspace.

    :ivar id: Specifies the feature ID.
    :vartype id: str
    :ivar display_name: Specifies the feature name.
    :vartype display_name: str
    :ivar description: Describes the feature for user experience.
    :vartype description: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Specifies the feature ID.
        :paramtype id: str
        :keyword display_name: Specifies the feature name.
        :paramtype display_name: str
        :keyword description: Describes the feature for user experience.
        :paramtype description: str
        """
        super(AmlUserFeature, self).__init__(**kwargs)
        self.id = id
        self.display_name = display_name
        self.description = description


class ArmResourceId(msrest.serialization.Model):
    """ARM ResourceId of a resource.

    :ivar resource_id: Arm ResourceId is in the format
     "/subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Storage/storageAccounts/{StorageAccountName}"
     or
     "/subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{AcrName}".
    :vartype resource_id: str
    """

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword resource_id: Arm ResourceId is in the format
         "/subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Storage/storageAccounts/{StorageAccountName}"
         or
         "/subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{AcrName}".
        :paramtype resource_id: str
        """
        super(ArmResourceId, self).__init__(**kwargs)
        self.resource_id = resource_id


class ResourceBase(msrest.serialization.Model):
    """ResourceBase.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        """
        super(ResourceBase, self).__init__(**kwargs)
        self.description = description
        self.properties = properties
        self.tags = tags


class AssetBase(ResourceBase):
    """AssetBase.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_anonymous: If the name version are system generated (anonymous registration).
    :vartype is_anonymous: bool
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_anonymous': {'key': 'isAnonymous', 'type': 'bool'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        is_anonymous: Optional[bool] = False,
        is_archived: Optional[bool] = False,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_anonymous: If the name version are system generated (anonymous registration).
        :paramtype is_anonymous: bool
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        """
        super(AssetBase, self).__init__(description=description, properties=properties, tags=tags, **kwargs)
        self.is_anonymous = is_anonymous
        self.is_archived = is_archived


class AssetContainer(ResourceBase):
    """AssetContainer.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar latest_version: The latest version inside this container.
    :vartype latest_version: str
    :ivar next_version: The next auto incremental version.
    :vartype next_version: str
    """

    _validation = {
        'latest_version': {'readonly': True},
        'next_version': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'latest_version': {'key': 'latestVersion', 'type': 'str'},
        'next_version': {'key': 'nextVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        is_archived: Optional[bool] = False,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        """
        super(AssetContainer, self).__init__(description=description, properties=properties, tags=tags, **kwargs)
        self.is_archived = is_archived
        self.latest_version = None
        self.next_version = None


class AssetJobInput(msrest.serialization.Model):
    """Asset input type.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
     "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
    :ivar uri: Required. [Required] Input Asset URI.
    :vartype uri: str
    """

    _validation = {
        'uri': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        uri: str,
        mode: Optional[Union[str, "InputDeliveryMode"]] = None,
        **kwargs
    ):
        """
        :keyword mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
         "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
        :keyword uri: Required. [Required] Input Asset URI.
        :paramtype uri: str
        """
        super(AssetJobInput, self).__init__(**kwargs)
        self.mode = mode
        self.uri = uri


class AssetJobOutput(msrest.serialization.Model):
    """Asset output type.

    :ivar mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload",
     "Direct".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
    :ivar uri: Output Asset URI.
    :vartype uri: str
    """

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        mode: Optional[Union[str, "OutputDeliveryMode"]] = None,
        uri: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload",
         "Direct".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
        :keyword uri: Output Asset URI.
        :paramtype uri: str
        """
        super(AssetJobOutput, self).__init__(**kwargs)
        self.mode = mode
        self.uri = uri


class AssetReferenceBase(msrest.serialization.Model):
    """Base definition for asset references.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DataPathAssetReference, IdAssetReference, OutputPathAssetReference.

    All required parameters must be populated in order to send to Azure.

    :ivar reference_type: Required. [Required] Specifies the type of asset reference.Constant
     filled by server. Possible values include: "Id", "DataPath", "OutputPath".
    :vartype reference_type: str or ~azure.mgmt.machinelearningservices.models.ReferenceType
    """

    _validation = {
        'reference_type': {'required': True},
    }

    _attribute_map = {
        'reference_type': {'key': 'referenceType', 'type': 'str'},
    }

    _subtype_map = {
        'reference_type': {'DataPath': 'DataPathAssetReference', 'Id': 'IdAssetReference', 'OutputPath': 'OutputPathAssetReference'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AssetReferenceBase, self).__init__(**kwargs)
        self.reference_type = None  # type: Optional[str]


class AssignedUser(msrest.serialization.Model):
    """A user that can be assigned to a compute instance.

    All required parameters must be populated in order to send to Azure.

    :ivar object_id: Required. User’s AAD Object Id.
    :vartype object_id: str
    :ivar tenant_id: Required. User’s AAD Tenant Id.
    :vartype tenant_id: str
    """

    _validation = {
        'object_id': {'required': True},
        'tenant_id': {'required': True},
    }

    _attribute_map = {
        'object_id': {'key': 'objectId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        object_id: str,
        tenant_id: str,
        **kwargs
    ):
        """
        :keyword object_id: Required. User’s AAD Object Id.
        :paramtype object_id: str
        :keyword tenant_id: Required. User’s AAD Tenant Id.
        :paramtype tenant_id: str
        """
        super(AssignedUser, self).__init__(**kwargs)
        self.object_id = object_id
        self.tenant_id = tenant_id


class ForecastHorizon(msrest.serialization.Model):
    """The desired maximum forecast horizon in units of time-series frequency.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AutoForecastHorizon, CustomForecastHorizon.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Required. [Required] Set forecast horizon value selection mode.Constant filled by
     server. Possible values include: "Auto", "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.ForecastHorizonMode
    """

    _validation = {
        'mode': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
    }

    _subtype_map = {
        'mode': {'Auto': 'AutoForecastHorizon', 'Custom': 'CustomForecastHorizon'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ForecastHorizon, self).__init__(**kwargs)
        self.mode = None  # type: Optional[str]


class AutoForecastHorizon(ForecastHorizon):
    """Forecast horizon determined automatically by system.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Required. [Required] Set forecast horizon value selection mode.Constant filled by
     server. Possible values include: "Auto", "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.ForecastHorizonMode
    """

    _validation = {
        'mode': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AutoForecastHorizon, self).__init__(**kwargs)
        self.mode = 'Auto'  # type: str


class AutologgerSettings(msrest.serialization.Model):
    """Settings for Autologger.

    All required parameters must be populated in order to send to Azure.

    :ivar mlflow_autologger: Required. [Required] Indicates whether mlflow autologger is enabled.
     Possible values include: "Enabled", "Disabled".
    :vartype mlflow_autologger: str or
     ~azure.mgmt.machinelearningservices.models.MLFlowAutologgerState
    """

    _validation = {
        'mlflow_autologger': {'required': True},
    }

    _attribute_map = {
        'mlflow_autologger': {'key': 'mlflowAutologger', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        mlflow_autologger: Union[str, "MLFlowAutologgerState"],
        **kwargs
    ):
        """
        :keyword mlflow_autologger: Required. [Required] Indicates whether mlflow autologger is
         enabled. Possible values include: "Enabled", "Disabled".
        :paramtype mlflow_autologger: str or
         ~azure.mgmt.machinelearningservices.models.MLFlowAutologgerState
        """
        super(AutologgerSettings, self).__init__(**kwargs)
        self.mlflow_autologger = mlflow_autologger


class JobBaseProperties(ResourceBase):
    """Base definition for a job.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AutoMLJob, CommandJob, LabelingJobProperties, PipelineJob, SparkJob, SweepJob.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar component_id: ARM resource ID of the component resource.
    :vartype component_id: str
    :ivar compute_id: ARM resource ID of the compute resource.
    :vartype compute_id: str
    :ivar display_name: Display name of job.
    :vartype display_name: str
    :ivar experiment_name: The name of the experiment the job belongs to. If not set, the job is
     placed in the "Default" experiment.
    :vartype experiment_name: str
    :ivar identity: Identity configuration. If set, this should be one of AmlToken,
     ManagedIdentity, UserIdentity or null.
     Defaults to AmlToken if null.
    :vartype identity: ~azure.mgmt.machinelearningservices.models.IdentityConfiguration
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar job_type: Required. [Required] Specifies the type of job.Constant filled by server.
     Possible values include: "AutoML", "Command", "Labeling", "Sweep", "Pipeline", "Spark".
    :vartype job_type: str or ~azure.mgmt.machinelearningservices.models.JobType
    :ivar services: List of JobEndpoints.
     For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
    :vartype services: dict[str, ~azure.mgmt.machinelearningservices.models.JobService]
    :ivar status: Status of the job. Possible values include: "NotStarted", "Starting",
     "Provisioning", "Preparing", "Queued", "Running", "Finalizing", "CancelRequested", "Completed",
     "Failed", "Canceled", "NotResponding", "Paused", "Unknown", "Scheduled".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.JobStatus
    """

    _validation = {
        'job_type': {'required': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'component_id': {'key': 'componentId', 'type': 'str'},
        'compute_id': {'key': 'computeId', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'experiment_name': {'key': 'experimentName', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'IdentityConfiguration'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'job_type': {'key': 'jobType', 'type': 'str'},
        'services': {'key': 'services', 'type': '{JobService}'},
        'status': {'key': 'status', 'type': 'str'},
    }

    _subtype_map = {
        'job_type': {'AutoML': 'AutoMLJob', 'Command': 'CommandJob', 'Labeling': 'LabelingJobProperties', 'Pipeline': 'PipelineJob', 'Spark': 'SparkJob', 'Sweep': 'SweepJob'}
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        component_id: Optional[str] = None,
        compute_id: Optional[str] = None,
        display_name: Optional[str] = None,
        experiment_name: Optional[str] = "Default",
        identity: Optional["IdentityConfiguration"] = None,
        is_archived: Optional[bool] = False,
        services: Optional[Dict[str, "JobService"]] = None,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword component_id: ARM resource ID of the component resource.
        :paramtype component_id: str
        :keyword compute_id: ARM resource ID of the compute resource.
        :paramtype compute_id: str
        :keyword display_name: Display name of job.
        :paramtype display_name: str
        :keyword experiment_name: The name of the experiment the job belongs to. If not set, the job is
         placed in the "Default" experiment.
        :paramtype experiment_name: str
        :keyword identity: Identity configuration. If set, this should be one of AmlToken,
         ManagedIdentity, UserIdentity or null.
         Defaults to AmlToken if null.
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.IdentityConfiguration
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword services: List of JobEndpoints.
         For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        :paramtype services: dict[str, ~azure.mgmt.machinelearningservices.models.JobService]
        """
        super(JobBaseProperties, self).__init__(description=description, properties=properties, tags=tags, **kwargs)
        self.component_id = component_id
        self.compute_id = compute_id
        self.display_name = display_name
        self.experiment_name = experiment_name
        self.identity = identity
        self.is_archived = is_archived
        self.job_type = 'JobBaseProperties'  # type: str
        self.services = services
        self.status = None


class AutoMLJob(JobBaseProperties):
    """AutoMLJob class.
Use this class for executing AutoML tasks like Classification/Regression etc.
See TaskType enum for all the tasks supported.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar component_id: ARM resource ID of the component resource.
    :vartype component_id: str
    :ivar compute_id: ARM resource ID of the compute resource.
    :vartype compute_id: str
    :ivar display_name: Display name of job.
    :vartype display_name: str
    :ivar experiment_name: The name of the experiment the job belongs to. If not set, the job is
     placed in the "Default" experiment.
    :vartype experiment_name: str
    :ivar identity: Identity configuration. If set, this should be one of AmlToken,
     ManagedIdentity, UserIdentity or null.
     Defaults to AmlToken if null.
    :vartype identity: ~azure.mgmt.machinelearningservices.models.IdentityConfiguration
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar job_type: Required. [Required] Specifies the type of job.Constant filled by server.
     Possible values include: "AutoML", "Command", "Labeling", "Sweep", "Pipeline", "Spark".
    :vartype job_type: str or ~azure.mgmt.machinelearningservices.models.JobType
    :ivar services: List of JobEndpoints.
     For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
    :vartype services: dict[str, ~azure.mgmt.machinelearningservices.models.JobService]
    :ivar status: Status of the job. Possible values include: "NotStarted", "Starting",
     "Provisioning", "Preparing", "Queued", "Running", "Finalizing", "CancelRequested", "Completed",
     "Failed", "Canceled", "NotResponding", "Paused", "Unknown", "Scheduled".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.JobStatus
    :ivar environment_id: The ARM resource ID of the Environment specification for the job.
     This is optional value to provide, if not provided, AutoML will default this to Production
     AutoML curated environment version when running the job.
    :vartype environment_id: str
    :ivar environment_variables: Environment variables included in the job.
    :vartype environment_variables: dict[str, str]
    :ivar outputs: Mapping of output data bindings used in the job.
    :vartype outputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobOutput]
    :ivar resources: Compute Resource configuration for the job.
    :vartype resources: ~azure.mgmt.machinelearningservices.models.JobResourceConfiguration
    :ivar task_details: Required. [Required] This represents scenario which can be one of
     Tables/NLP/Image.
    :vartype task_details: ~azure.mgmt.machinelearningservices.models.AutoMLVertical
    """

    _validation = {
        'job_type': {'required': True},
        'status': {'readonly': True},
        'task_details': {'required': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'component_id': {'key': 'componentId', 'type': 'str'},
        'compute_id': {'key': 'computeId', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'experiment_name': {'key': 'experimentName', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'IdentityConfiguration'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'job_type': {'key': 'jobType', 'type': 'str'},
        'services': {'key': 'services', 'type': '{JobService}'},
        'status': {'key': 'status', 'type': 'str'},
        'environment_id': {'key': 'environmentId', 'type': 'str'},
        'environment_variables': {'key': 'environmentVariables', 'type': '{str}'},
        'outputs': {'key': 'outputs', 'type': '{JobOutput}'},
        'resources': {'key': 'resources', 'type': 'JobResourceConfiguration'},
        'task_details': {'key': 'taskDetails', 'type': 'AutoMLVertical'},
    }

    def __init__(
        self,
        *,
        task_details: "AutoMLVertical",
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        component_id: Optional[str] = None,
        compute_id: Optional[str] = None,
        display_name: Optional[str] = None,
        experiment_name: Optional[str] = "Default",
        identity: Optional["IdentityConfiguration"] = None,
        is_archived: Optional[bool] = False,
        services: Optional[Dict[str, "JobService"]] = None,
        environment_id: Optional[str] = None,
        environment_variables: Optional[Dict[str, str]] = None,
        outputs: Optional[Dict[str, "JobOutput"]] = None,
        resources: Optional["JobResourceConfiguration"] = None,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword component_id: ARM resource ID of the component resource.
        :paramtype component_id: str
        :keyword compute_id: ARM resource ID of the compute resource.
        :paramtype compute_id: str
        :keyword display_name: Display name of job.
        :paramtype display_name: str
        :keyword experiment_name: The name of the experiment the job belongs to. If not set, the job is
         placed in the "Default" experiment.
        :paramtype experiment_name: str
        :keyword identity: Identity configuration. If set, this should be one of AmlToken,
         ManagedIdentity, UserIdentity or null.
         Defaults to AmlToken if null.
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.IdentityConfiguration
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword services: List of JobEndpoints.
         For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        :paramtype services: dict[str, ~azure.mgmt.machinelearningservices.models.JobService]
        :keyword environment_id: The ARM resource ID of the Environment specification for the job.
         This is optional value to provide, if not provided, AutoML will default this to Production
         AutoML curated environment version when running the job.
        :paramtype environment_id: str
        :keyword environment_variables: Environment variables included in the job.
        :paramtype environment_variables: dict[str, str]
        :keyword outputs: Mapping of output data bindings used in the job.
        :paramtype outputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobOutput]
        :keyword resources: Compute Resource configuration for the job.
        :paramtype resources: ~azure.mgmt.machinelearningservices.models.JobResourceConfiguration
        :keyword task_details: Required. [Required] This represents scenario which can be one of
         Tables/NLP/Image.
        :paramtype task_details: ~azure.mgmt.machinelearningservices.models.AutoMLVertical
        """
        super(AutoMLJob, self).__init__(description=description, properties=properties, tags=tags, component_id=component_id, compute_id=compute_id, display_name=display_name, experiment_name=experiment_name, identity=identity, is_archived=is_archived, services=services, **kwargs)
        self.job_type = 'AutoML'  # type: str
        self.environment_id = environment_id
        self.environment_variables = environment_variables
        self.outputs = outputs
        self.resources = resources
        self.task_details = task_details


class AutoMLVertical(msrest.serialization.Model):
    """AutoML vertical class.
Base class for AutoML verticals - TableVertical/ImageVertical/NLPVertical.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: Classification, Forecasting, ImageClassification, ImageClassificationMultilabel, ImageInstanceSegmentation, ImageObjectDetection, Regression, TextClassification, TextClassificationMultilabel, TextNer.

    All required parameters must be populated in order to send to Azure.

    :ivar log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
     "Info", "Warning", "Error", "Critical".
    :vartype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
    :ivar target_column_name: Target column name: This is prediction values column.
     Also known as label column name in context of classification tasks.
    :vartype target_column_name: str
    :ivar task_type: Required. [Required] Task type for AutoMLJob.Constant filled by server.
     Possible values include: "Classification", "Regression", "Forecasting", "ImageClassification",
     "ImageClassificationMultilabel", "ImageObjectDetection", "ImageInstanceSegmentation",
     "TextClassification", "TextClassificationMultilabel", "TextNER".
    :vartype task_type: str or ~azure.mgmt.machinelearningservices.models.TaskType
    :ivar training_data: Required. [Required] Training data input.
    :vartype training_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    """

    _validation = {
        'task_type': {'required': True},
        'training_data': {'required': True},
    }

    _attribute_map = {
        'log_verbosity': {'key': 'logVerbosity', 'type': 'str'},
        'target_column_name': {'key': 'targetColumnName', 'type': 'str'},
        'task_type': {'key': 'taskType', 'type': 'str'},
        'training_data': {'key': 'trainingData', 'type': 'MLTableJobInput'},
    }

    _subtype_map = {
        'task_type': {'Classification': 'Classification', 'Forecasting': 'Forecasting', 'ImageClassification': 'ImageClassification', 'ImageClassificationMultilabel': 'ImageClassificationMultilabel', 'ImageInstanceSegmentation': 'ImageInstanceSegmentation', 'ImageObjectDetection': 'ImageObjectDetection', 'Regression': 'Regression', 'TextClassification': 'TextClassification', 'TextClassificationMultilabel': 'TextClassificationMultilabel', 'TextNER': 'TextNer'}
    }

    def __init__(
        self,
        *,
        training_data: "MLTableJobInput",
        log_verbosity: Optional[Union[str, "LogVerbosity"]] = None,
        target_column_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
         "Info", "Warning", "Error", "Critical".
        :paramtype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
        :keyword target_column_name: Target column name: This is prediction values column.
         Also known as label column name in context of classification tasks.
        :paramtype target_column_name: str
        :keyword training_data: Required. [Required] Training data input.
        :paramtype training_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        """
        super(AutoMLVertical, self).__init__(**kwargs)
        self.log_verbosity = log_verbosity
        self.target_column_name = target_column_name
        self.task_type = None  # type: Optional[str]
        self.training_data = training_data


class NCrossValidations(msrest.serialization.Model):
    """N-Cross validations value.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AutoNCrossValidations, CustomNCrossValidations.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Required. [Required] Mode for determining N-Cross validations.Constant filled by
     server. Possible values include: "Auto", "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.NCrossValidationsMode
    """

    _validation = {
        'mode': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
    }

    _subtype_map = {
        'mode': {'Auto': 'AutoNCrossValidations', 'Custom': 'CustomNCrossValidations'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(NCrossValidations, self).__init__(**kwargs)
        self.mode = None  # type: Optional[str]


class AutoNCrossValidations(NCrossValidations):
    """N-Cross validations determined automatically.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Required. [Required] Mode for determining N-Cross validations.Constant filled by
     server. Possible values include: "Auto", "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.NCrossValidationsMode
    """

    _validation = {
        'mode': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AutoNCrossValidations, self).__init__(**kwargs)
        self.mode = 'Auto'  # type: str


class AutoPauseProperties(msrest.serialization.Model):
    """Auto pause properties.

    :ivar delay_in_minutes:
    :vartype delay_in_minutes: int
    :ivar enabled:
    :vartype enabled: bool
    """

    _attribute_map = {
        'delay_in_minutes': {'key': 'delayInMinutes', 'type': 'int'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        delay_in_minutes: Optional[int] = None,
        enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword delay_in_minutes:
        :paramtype delay_in_minutes: int
        :keyword enabled:
        :paramtype enabled: bool
        """
        super(AutoPauseProperties, self).__init__(**kwargs)
        self.delay_in_minutes = delay_in_minutes
        self.enabled = enabled


class AutoScaleProperties(msrest.serialization.Model):
    """Auto scale properties.

    :ivar min_node_count:
    :vartype min_node_count: int
    :ivar enabled:
    :vartype enabled: bool
    :ivar max_node_count:
    :vartype max_node_count: int
    """

    _attribute_map = {
        'min_node_count': {'key': 'minNodeCount', 'type': 'int'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'max_node_count': {'key': 'maxNodeCount', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        min_node_count: Optional[int] = None,
        enabled: Optional[bool] = None,
        max_node_count: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword min_node_count:
        :paramtype min_node_count: int
        :keyword enabled:
        :paramtype enabled: bool
        :keyword max_node_count:
        :paramtype max_node_count: int
        """
        super(AutoScaleProperties, self).__init__(**kwargs)
        self.min_node_count = min_node_count
        self.enabled = enabled
        self.max_node_count = max_node_count


class Seasonality(msrest.serialization.Model):
    """Forecasting seasonality.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AutoSeasonality, CustomSeasonality.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Required. [Required] Seasonality mode.Constant filled by server. Possible values
     include: "Auto", "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.SeasonalityMode
    """

    _validation = {
        'mode': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
    }

    _subtype_map = {
        'mode': {'Auto': 'AutoSeasonality', 'Custom': 'CustomSeasonality'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Seasonality, self).__init__(**kwargs)
        self.mode = None  # type: Optional[str]


class AutoSeasonality(Seasonality):
    """AutoSeasonality.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Required. [Required] Seasonality mode.Constant filled by server. Possible values
     include: "Auto", "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.SeasonalityMode
    """

    _validation = {
        'mode': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AutoSeasonality, self).__init__(**kwargs)
        self.mode = 'Auto'  # type: str


class TargetLags(msrest.serialization.Model):
    """The number of past periods to lag from the target column.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AutoTargetLags, CustomTargetLags.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Required. [Required] Set target lags mode - Auto/Custom.Constant filled by server.
     Possible values include: "Auto", "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.TargetLagsMode
    """

    _validation = {
        'mode': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
    }

    _subtype_map = {
        'mode': {'Auto': 'AutoTargetLags', 'Custom': 'CustomTargetLags'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(TargetLags, self).__init__(**kwargs)
        self.mode = None  # type: Optional[str]


class AutoTargetLags(TargetLags):
    """AutoTargetLags.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Required. [Required] Set target lags mode - Auto/Custom.Constant filled by server.
     Possible values include: "Auto", "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.TargetLagsMode
    """

    _validation = {
        'mode': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AutoTargetLags, self).__init__(**kwargs)
        self.mode = 'Auto'  # type: str


class TargetRollingWindowSize(msrest.serialization.Model):
    """Forecasting target rolling window size.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AutoTargetRollingWindowSize, CustomTargetRollingWindowSize.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Required. [Required] TargetRollingWindowSiz detection mode.Constant filled by
     server. Possible values include: "Auto", "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.TargetRollingWindowSizeMode
    """

    _validation = {
        'mode': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
    }

    _subtype_map = {
        'mode': {'Auto': 'AutoTargetRollingWindowSize', 'Custom': 'CustomTargetRollingWindowSize'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(TargetRollingWindowSize, self).__init__(**kwargs)
        self.mode = None  # type: Optional[str]


class AutoTargetRollingWindowSize(TargetRollingWindowSize):
    """Target lags rolling window determined automatically.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Required. [Required] TargetRollingWindowSiz detection mode.Constant filled by
     server. Possible values include: "Auto", "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.TargetRollingWindowSizeMode
    """

    _validation = {
        'mode': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AutoTargetRollingWindowSize, self).__init__(**kwargs)
        self.mode = 'Auto'  # type: str


class AzureDatastore(msrest.serialization.Model):
    """Base definition for Azure datastore contents configuration.

    :ivar resource_group: Azure Resource Group name.
    :vartype resource_group: str
    :ivar subscription_id: Azure Subscription Id.
    :vartype subscription_id: str
    """

    _attribute_map = {
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        resource_group: Optional[str] = None,
        subscription_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword resource_group: Azure Resource Group name.
        :paramtype resource_group: str
        :keyword subscription_id: Azure Subscription Id.
        :paramtype subscription_id: str
        """
        super(AzureDatastore, self).__init__(**kwargs)
        self.resource_group = resource_group
        self.subscription_id = subscription_id


class DatastoreProperties(ResourceBase):
    """Base definition for datastore contents configuration.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureBlobDatastore, AzureDataLakeGen1Datastore, AzureDataLakeGen2Datastore, AzureFileDatastore, HdfsDatastore.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar credentials: Required. [Required] Account credentials.
    :vartype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
    :ivar datastore_type: Required. [Required] Storage type backing the datastore.Constant filled
     by server. Possible values include: "AzureBlob", "AzureDataLakeGen1", "AzureDataLakeGen2",
     "AzureFile", "Hdfs".
    :vartype datastore_type: str or ~azure.mgmt.machinelearningservices.models.DatastoreType
    :ivar is_default: Readonly property to indicate if datastore is the workspace default
     datastore.
    :vartype is_default: bool
    """

    _validation = {
        'credentials': {'required': True},
        'datastore_type': {'required': True},
        'is_default': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'credentials': {'key': 'credentials', 'type': 'DatastoreCredentials'},
        'datastore_type': {'key': 'datastoreType', 'type': 'str'},
        'is_default': {'key': 'isDefault', 'type': 'bool'},
    }

    _subtype_map = {
        'datastore_type': {'AzureBlob': 'AzureBlobDatastore', 'AzureDataLakeGen1': 'AzureDataLakeGen1Datastore', 'AzureDataLakeGen2': 'AzureDataLakeGen2Datastore', 'AzureFile': 'AzureFileDatastore', 'Hdfs': 'HdfsDatastore'}
    }

    def __init__(
        self,
        *,
        credentials: "DatastoreCredentials",
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword credentials: Required. [Required] Account credentials.
        :paramtype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
        """
        super(DatastoreProperties, self).__init__(description=description, properties=properties, tags=tags, **kwargs)
        self.credentials = credentials
        self.datastore_type = 'DatastoreProperties'  # type: str
        self.is_default = None


class AzureBlobDatastore(DatastoreProperties, AzureDatastore):
    """Azure Blob datastore configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar resource_group: Azure Resource Group name.
    :vartype resource_group: str
    :ivar subscription_id: Azure Subscription Id.
    :vartype subscription_id: str
    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar credentials: Required. [Required] Account credentials.
    :vartype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
    :ivar datastore_type: Required. [Required] Storage type backing the datastore.Constant filled
     by server. Possible values include: "AzureBlob", "AzureDataLakeGen1", "AzureDataLakeGen2",
     "AzureFile", "Hdfs".
    :vartype datastore_type: str or ~azure.mgmt.machinelearningservices.models.DatastoreType
    :ivar is_default: Readonly property to indicate if datastore is the workspace default
     datastore.
    :vartype is_default: bool
    :ivar account_name: Storage account name.
    :vartype account_name: str
    :ivar container_name: Storage account container name.
    :vartype container_name: str
    :ivar endpoint: Azure cloud endpoint for the storage account.
    :vartype endpoint: str
    :ivar protocol: Protocol used to communicate with the storage account.
    :vartype protocol: str
    :ivar service_data_access_auth_identity: Indicates which identity to use to authenticate
     service data access to customer's storage. Possible values include: "None",
     "WorkspaceSystemAssignedIdentity", "WorkspaceUserAssignedIdentity".
    :vartype service_data_access_auth_identity: str or
     ~azure.mgmt.machinelearningservices.models.ServiceDataAccessAuthIdentity
    """

    _validation = {
        'credentials': {'required': True},
        'datastore_type': {'required': True},
        'is_default': {'readonly': True},
    }

    _attribute_map = {
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'credentials': {'key': 'credentials', 'type': 'DatastoreCredentials'},
        'datastore_type': {'key': 'datastoreType', 'type': 'str'},
        'is_default': {'key': 'isDefault', 'type': 'bool'},
        'account_name': {'key': 'accountName', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'endpoint': {'key': 'endpoint', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'str'},
        'service_data_access_auth_identity': {'key': 'serviceDataAccessAuthIdentity', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        credentials: "DatastoreCredentials",
        resource_group: Optional[str] = None,
        subscription_id: Optional[str] = None,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        account_name: Optional[str] = None,
        container_name: Optional[str] = None,
        endpoint: Optional[str] = None,
        protocol: Optional[str] = None,
        service_data_access_auth_identity: Optional[Union[str, "ServiceDataAccessAuthIdentity"]] = None,
        **kwargs
    ):
        """
        :keyword resource_group: Azure Resource Group name.
        :paramtype resource_group: str
        :keyword subscription_id: Azure Subscription Id.
        :paramtype subscription_id: str
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword credentials: Required. [Required] Account credentials.
        :paramtype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
        :keyword account_name: Storage account name.
        :paramtype account_name: str
        :keyword container_name: Storage account container name.
        :paramtype container_name: str
        :keyword endpoint: Azure cloud endpoint for the storage account.
        :paramtype endpoint: str
        :keyword protocol: Protocol used to communicate with the storage account.
        :paramtype protocol: str
        :keyword service_data_access_auth_identity: Indicates which identity to use to authenticate
         service data access to customer's storage. Possible values include: "None",
         "WorkspaceSystemAssignedIdentity", "WorkspaceUserAssignedIdentity".
        :paramtype service_data_access_auth_identity: str or
         ~azure.mgmt.machinelearningservices.models.ServiceDataAccessAuthIdentity
        """
        super(AzureBlobDatastore, self).__init__(description=description, properties=properties, tags=tags, credentials=credentials, resource_group=resource_group, subscription_id=subscription_id, **kwargs)
        self.resource_group = resource_group
        self.subscription_id = subscription_id
        self.datastore_type = 'AzureBlob'  # type: str
        self.account_name = account_name
        self.container_name = container_name
        self.endpoint = endpoint
        self.protocol = protocol
        self.service_data_access_auth_identity = service_data_access_auth_identity
        self.description = description
        self.properties = properties
        self.tags = tags
        self.credentials = credentials
        self.is_default = None


class AzureDataLakeGen1Datastore(DatastoreProperties, AzureDatastore):
    """Azure Data Lake Gen1 datastore configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar resource_group: Azure Resource Group name.
    :vartype resource_group: str
    :ivar subscription_id: Azure Subscription Id.
    :vartype subscription_id: str
    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar credentials: Required. [Required] Account credentials.
    :vartype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
    :ivar datastore_type: Required. [Required] Storage type backing the datastore.Constant filled
     by server. Possible values include: "AzureBlob", "AzureDataLakeGen1", "AzureDataLakeGen2",
     "AzureFile", "Hdfs".
    :vartype datastore_type: str or ~azure.mgmt.machinelearningservices.models.DatastoreType
    :ivar is_default: Readonly property to indicate if datastore is the workspace default
     datastore.
    :vartype is_default: bool
    :ivar service_data_access_auth_identity: Indicates which identity to use to authenticate
     service data access to customer's storage. Possible values include: "None",
     "WorkspaceSystemAssignedIdentity", "WorkspaceUserAssignedIdentity".
    :vartype service_data_access_auth_identity: str or
     ~azure.mgmt.machinelearningservices.models.ServiceDataAccessAuthIdentity
    :ivar store_name: Required. [Required] Azure Data Lake store name.
    :vartype store_name: str
    """

    _validation = {
        'credentials': {'required': True},
        'datastore_type': {'required': True},
        'is_default': {'readonly': True},
        'store_name': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'credentials': {'key': 'credentials', 'type': 'DatastoreCredentials'},
        'datastore_type': {'key': 'datastoreType', 'type': 'str'},
        'is_default': {'key': 'isDefault', 'type': 'bool'},
        'service_data_access_auth_identity': {'key': 'serviceDataAccessAuthIdentity', 'type': 'str'},
        'store_name': {'key': 'storeName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        credentials: "DatastoreCredentials",
        store_name: str,
        resource_group: Optional[str] = None,
        subscription_id: Optional[str] = None,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        service_data_access_auth_identity: Optional[Union[str, "ServiceDataAccessAuthIdentity"]] = None,
        **kwargs
    ):
        """
        :keyword resource_group: Azure Resource Group name.
        :paramtype resource_group: str
        :keyword subscription_id: Azure Subscription Id.
        :paramtype subscription_id: str
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword credentials: Required. [Required] Account credentials.
        :paramtype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
        :keyword service_data_access_auth_identity: Indicates which identity to use to authenticate
         service data access to customer's storage. Possible values include: "None",
         "WorkspaceSystemAssignedIdentity", "WorkspaceUserAssignedIdentity".
        :paramtype service_data_access_auth_identity: str or
         ~azure.mgmt.machinelearningservices.models.ServiceDataAccessAuthIdentity
        :keyword store_name: Required. [Required] Azure Data Lake store name.
        :paramtype store_name: str
        """
        super(AzureDataLakeGen1Datastore, self).__init__(description=description, properties=properties, tags=tags, credentials=credentials, resource_group=resource_group, subscription_id=subscription_id, **kwargs)
        self.resource_group = resource_group
        self.subscription_id = subscription_id
        self.datastore_type = 'AzureDataLakeGen1'  # type: str
        self.service_data_access_auth_identity = service_data_access_auth_identity
        self.store_name = store_name
        self.description = description
        self.properties = properties
        self.tags = tags
        self.credentials = credentials
        self.is_default = None


class AzureDataLakeGen2Datastore(DatastoreProperties, AzureDatastore):
    """Azure Data Lake Gen2 datastore configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar resource_group: Azure Resource Group name.
    :vartype resource_group: str
    :ivar subscription_id: Azure Subscription Id.
    :vartype subscription_id: str
    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar credentials: Required. [Required] Account credentials.
    :vartype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
    :ivar datastore_type: Required. [Required] Storage type backing the datastore.Constant filled
     by server. Possible values include: "AzureBlob", "AzureDataLakeGen1", "AzureDataLakeGen2",
     "AzureFile", "Hdfs".
    :vartype datastore_type: str or ~azure.mgmt.machinelearningservices.models.DatastoreType
    :ivar is_default: Readonly property to indicate if datastore is the workspace default
     datastore.
    :vartype is_default: bool
    :ivar account_name: Required. [Required] Storage account name.
    :vartype account_name: str
    :ivar endpoint: Azure cloud endpoint for the storage account.
    :vartype endpoint: str
    :ivar filesystem: Required. [Required] The name of the Data Lake Gen2 filesystem.
    :vartype filesystem: str
    :ivar protocol: Protocol used to communicate with the storage account.
    :vartype protocol: str
    :ivar service_data_access_auth_identity: Indicates which identity to use to authenticate
     service data access to customer's storage. Possible values include: "None",
     "WorkspaceSystemAssignedIdentity", "WorkspaceUserAssignedIdentity".
    :vartype service_data_access_auth_identity: str or
     ~azure.mgmt.machinelearningservices.models.ServiceDataAccessAuthIdentity
    """

    _validation = {
        'credentials': {'required': True},
        'datastore_type': {'required': True},
        'is_default': {'readonly': True},
        'account_name': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'filesystem': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'credentials': {'key': 'credentials', 'type': 'DatastoreCredentials'},
        'datastore_type': {'key': 'datastoreType', 'type': 'str'},
        'is_default': {'key': 'isDefault', 'type': 'bool'},
        'account_name': {'key': 'accountName', 'type': 'str'},
        'endpoint': {'key': 'endpoint', 'type': 'str'},
        'filesystem': {'key': 'filesystem', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'str'},
        'service_data_access_auth_identity': {'key': 'serviceDataAccessAuthIdentity', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        credentials: "DatastoreCredentials",
        account_name: str,
        filesystem: str,
        resource_group: Optional[str] = None,
        subscription_id: Optional[str] = None,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        endpoint: Optional[str] = None,
        protocol: Optional[str] = None,
        service_data_access_auth_identity: Optional[Union[str, "ServiceDataAccessAuthIdentity"]] = None,
        **kwargs
    ):
        """
        :keyword resource_group: Azure Resource Group name.
        :paramtype resource_group: str
        :keyword subscription_id: Azure Subscription Id.
        :paramtype subscription_id: str
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword credentials: Required. [Required] Account credentials.
        :paramtype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
        :keyword account_name: Required. [Required] Storage account name.
        :paramtype account_name: str
        :keyword endpoint: Azure cloud endpoint for the storage account.
        :paramtype endpoint: str
        :keyword filesystem: Required. [Required] The name of the Data Lake Gen2 filesystem.
        :paramtype filesystem: str
        :keyword protocol: Protocol used to communicate with the storage account.
        :paramtype protocol: str
        :keyword service_data_access_auth_identity: Indicates which identity to use to authenticate
         service data access to customer's storage. Possible values include: "None",
         "WorkspaceSystemAssignedIdentity", "WorkspaceUserAssignedIdentity".
        :paramtype service_data_access_auth_identity: str or
         ~azure.mgmt.machinelearningservices.models.ServiceDataAccessAuthIdentity
        """
        super(AzureDataLakeGen2Datastore, self).__init__(description=description, properties=properties, tags=tags, credentials=credentials, resource_group=resource_group, subscription_id=subscription_id, **kwargs)
        self.resource_group = resource_group
        self.subscription_id = subscription_id
        self.datastore_type = 'AzureDataLakeGen2'  # type: str
        self.account_name = account_name
        self.endpoint = endpoint
        self.filesystem = filesystem
        self.protocol = protocol
        self.service_data_access_auth_identity = service_data_access_auth_identity
        self.description = description
        self.properties = properties
        self.tags = tags
        self.credentials = credentials
        self.is_default = None


class AzureFileDatastore(DatastoreProperties, AzureDatastore):
    """Azure File datastore configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar resource_group: Azure Resource Group name.
    :vartype resource_group: str
    :ivar subscription_id: Azure Subscription Id.
    :vartype subscription_id: str
    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar credentials: Required. [Required] Account credentials.
    :vartype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
    :ivar datastore_type: Required. [Required] Storage type backing the datastore.Constant filled
     by server. Possible values include: "AzureBlob", "AzureDataLakeGen1", "AzureDataLakeGen2",
     "AzureFile", "Hdfs".
    :vartype datastore_type: str or ~azure.mgmt.machinelearningservices.models.DatastoreType
    :ivar is_default: Readonly property to indicate if datastore is the workspace default
     datastore.
    :vartype is_default: bool
    :ivar account_name: Required. [Required] Storage account name.
    :vartype account_name: str
    :ivar endpoint: Azure cloud endpoint for the storage account.
    :vartype endpoint: str
    :ivar file_share_name: Required. [Required] The name of the Azure file share that the datastore
     points to.
    :vartype file_share_name: str
    :ivar protocol: Protocol used to communicate with the storage account.
    :vartype protocol: str
    :ivar service_data_access_auth_identity: Indicates which identity to use to authenticate
     service data access to customer's storage. Possible values include: "None",
     "WorkspaceSystemAssignedIdentity", "WorkspaceUserAssignedIdentity".
    :vartype service_data_access_auth_identity: str or
     ~azure.mgmt.machinelearningservices.models.ServiceDataAccessAuthIdentity
    """

    _validation = {
        'credentials': {'required': True},
        'datastore_type': {'required': True},
        'is_default': {'readonly': True},
        'account_name': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'file_share_name': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'credentials': {'key': 'credentials', 'type': 'DatastoreCredentials'},
        'datastore_type': {'key': 'datastoreType', 'type': 'str'},
        'is_default': {'key': 'isDefault', 'type': 'bool'},
        'account_name': {'key': 'accountName', 'type': 'str'},
        'endpoint': {'key': 'endpoint', 'type': 'str'},
        'file_share_name': {'key': 'fileShareName', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'str'},
        'service_data_access_auth_identity': {'key': 'serviceDataAccessAuthIdentity', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        credentials: "DatastoreCredentials",
        account_name: str,
        file_share_name: str,
        resource_group: Optional[str] = None,
        subscription_id: Optional[str] = None,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        endpoint: Optional[str] = None,
        protocol: Optional[str] = None,
        service_data_access_auth_identity: Optional[Union[str, "ServiceDataAccessAuthIdentity"]] = None,
        **kwargs
    ):
        """
        :keyword resource_group: Azure Resource Group name.
        :paramtype resource_group: str
        :keyword subscription_id: Azure Subscription Id.
        :paramtype subscription_id: str
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword credentials: Required. [Required] Account credentials.
        :paramtype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
        :keyword account_name: Required. [Required] Storage account name.
        :paramtype account_name: str
        :keyword endpoint: Azure cloud endpoint for the storage account.
        :paramtype endpoint: str
        :keyword file_share_name: Required. [Required] The name of the Azure file share that the
         datastore points to.
        :paramtype file_share_name: str
        :keyword protocol: Protocol used to communicate with the storage account.
        :paramtype protocol: str
        :keyword service_data_access_auth_identity: Indicates which identity to use to authenticate
         service data access to customer's storage. Possible values include: "None",
         "WorkspaceSystemAssignedIdentity", "WorkspaceUserAssignedIdentity".
        :paramtype service_data_access_auth_identity: str or
         ~azure.mgmt.machinelearningservices.models.ServiceDataAccessAuthIdentity
        """
        super(AzureFileDatastore, self).__init__(description=description, properties=properties, tags=tags, credentials=credentials, resource_group=resource_group, subscription_id=subscription_id, **kwargs)
        self.resource_group = resource_group
        self.subscription_id = subscription_id
        self.datastore_type = 'AzureFile'  # type: str
        self.account_name = account_name
        self.endpoint = endpoint
        self.file_share_name = file_share_name
        self.protocol = protocol
        self.service_data_access_auth_identity = service_data_access_auth_identity
        self.description = description
        self.properties = properties
        self.tags = tags
        self.credentials = credentials
        self.is_default = None


class EarlyTerminationPolicy(msrest.serialization.Model):
    """Early termination policies enable canceling poor-performing runs before they complete.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: BanditPolicy, MedianStoppingPolicy, TruncationSelectionPolicy.

    All required parameters must be populated in order to send to Azure.

    :ivar delay_evaluation: Number of intervals by which to delay the first evaluation.
    :vartype delay_evaluation: int
    :ivar evaluation_interval: Interval (number of runs) between policy evaluations.
    :vartype evaluation_interval: int
    :ivar policy_type: Required. [Required] Name of policy configuration.Constant filled by server.
     Possible values include: "Bandit", "MedianStopping", "TruncationSelection".
    :vartype policy_type: str or
     ~azure.mgmt.machinelearningservices.models.EarlyTerminationPolicyType
    """

    _validation = {
        'policy_type': {'required': True},
    }

    _attribute_map = {
        'delay_evaluation': {'key': 'delayEvaluation', 'type': 'int'},
        'evaluation_interval': {'key': 'evaluationInterval', 'type': 'int'},
        'policy_type': {'key': 'policyType', 'type': 'str'},
    }

    _subtype_map = {
        'policy_type': {'Bandit': 'BanditPolicy', 'MedianStopping': 'MedianStoppingPolicy', 'TruncationSelection': 'TruncationSelectionPolicy'}
    }

    def __init__(
        self,
        *,
        delay_evaluation: Optional[int] = 0,
        evaluation_interval: Optional[int] = 0,
        **kwargs
    ):
        """
        :keyword delay_evaluation: Number of intervals by which to delay the first evaluation.
        :paramtype delay_evaluation: int
        :keyword evaluation_interval: Interval (number of runs) between policy evaluations.
        :paramtype evaluation_interval: int
        """
        super(EarlyTerminationPolicy, self).__init__(**kwargs)
        self.delay_evaluation = delay_evaluation
        self.evaluation_interval = evaluation_interval
        self.policy_type = None  # type: Optional[str]


class BanditPolicy(EarlyTerminationPolicy):
    """Defines an early termination policy based on slack criteria, and a frequency and delay interval for evaluation.

    All required parameters must be populated in order to send to Azure.

    :ivar delay_evaluation: Number of intervals by which to delay the first evaluation.
    :vartype delay_evaluation: int
    :ivar evaluation_interval: Interval (number of runs) between policy evaluations.
    :vartype evaluation_interval: int
    :ivar policy_type: Required. [Required] Name of policy configuration.Constant filled by server.
     Possible values include: "Bandit", "MedianStopping", "TruncationSelection".
    :vartype policy_type: str or
     ~azure.mgmt.machinelearningservices.models.EarlyTerminationPolicyType
    :ivar slack_amount: Absolute distance allowed from the best performing run.
    :vartype slack_amount: float
    :ivar slack_factor: Ratio of the allowed distance from the best performing run.
    :vartype slack_factor: float
    """

    _validation = {
        'policy_type': {'required': True},
    }

    _attribute_map = {
        'delay_evaluation': {'key': 'delayEvaluation', 'type': 'int'},
        'evaluation_interval': {'key': 'evaluationInterval', 'type': 'int'},
        'policy_type': {'key': 'policyType', 'type': 'str'},
        'slack_amount': {'key': 'slackAmount', 'type': 'float'},
        'slack_factor': {'key': 'slackFactor', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        delay_evaluation: Optional[int] = 0,
        evaluation_interval: Optional[int] = 0,
        slack_amount: Optional[float] = 0,
        slack_factor: Optional[float] = 0,
        **kwargs
    ):
        """
        :keyword delay_evaluation: Number of intervals by which to delay the first evaluation.
        :paramtype delay_evaluation: int
        :keyword evaluation_interval: Interval (number of runs) between policy evaluations.
        :paramtype evaluation_interval: int
        :keyword slack_amount: Absolute distance allowed from the best performing run.
        :paramtype slack_amount: float
        :keyword slack_factor: Ratio of the allowed distance from the best performing run.
        :paramtype slack_factor: float
        """
        super(BanditPolicy, self).__init__(delay_evaluation=delay_evaluation, evaluation_interval=evaluation_interval, **kwargs)
        self.policy_type = 'Bandit'  # type: str
        self.slack_amount = slack_amount
        self.slack_factor = slack_factor


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        """
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = tags
        self.location = location


class BatchDeployment(TrackedResource):
    """BatchDeployment.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
    :ivar kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type.
    :vartype kind: str
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.BatchDeploymentProperties
    :ivar sku: Sku details required for ARM contract for Autoscaling.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.Sku
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'kind': {'key': 'kind', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'BatchDeploymentProperties'},
        'sku': {'key': 'sku', 'type': 'Sku'},
    }

    def __init__(
        self,
        *,
        location: str,
        properties: "BatchDeploymentProperties",
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["ManagedServiceIdentity"] = None,
        kind: Optional[str] = None,
        sku: Optional["Sku"] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword identity: Managed service identity (system assigned and/or user assigned identities).
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
        :keyword kind: Metadata used by portal/tooling/etc to render different UX experiences for
         resources of the same type.
        :paramtype kind: str
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.BatchDeploymentProperties
        :keyword sku: Sku details required for ARM contract for Autoscaling.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.Sku
        """
        super(BatchDeployment, self).__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.kind = kind
        self.properties = properties
        self.sku = sku


class EndpointDeploymentPropertiesBase(msrest.serialization.Model):
    """Base definition for endpoint deployment.

    :ivar code_configuration: Code configuration for the endpoint deployment.
    :vartype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
    :ivar description: Description of the endpoint deployment.
    :vartype description: str
    :ivar environment_id: ARM resource ID of the environment specification for the endpoint
     deployment.
    :vartype environment_id: str
    :ivar environment_variables: Environment variables configuration for the deployment.
    :vartype environment_variables: dict[str, str]
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    """

    _attribute_map = {
        'code_configuration': {'key': 'codeConfiguration', 'type': 'CodeConfiguration'},
        'description': {'key': 'description', 'type': 'str'},
        'environment_id': {'key': 'environmentId', 'type': 'str'},
        'environment_variables': {'key': 'environmentVariables', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        code_configuration: Optional["CodeConfiguration"] = None,
        description: Optional[str] = None,
        environment_id: Optional[str] = None,
        environment_variables: Optional[Dict[str, str]] = None,
        properties: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword code_configuration: Code configuration for the endpoint deployment.
        :paramtype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
        :keyword description: Description of the endpoint deployment.
        :paramtype description: str
        :keyword environment_id: ARM resource ID of the environment specification for the endpoint
         deployment.
        :paramtype environment_id: str
        :keyword environment_variables: Environment variables configuration for the deployment.
        :paramtype environment_variables: dict[str, str]
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        """
        super(EndpointDeploymentPropertiesBase, self).__init__(**kwargs)
        self.code_configuration = code_configuration
        self.description = description
        self.environment_id = environment_id
        self.environment_variables = environment_variables
        self.properties = properties


class BatchDeploymentProperties(EndpointDeploymentPropertiesBase):
    """Batch inference settings per deployment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code_configuration: Code configuration for the endpoint deployment.
    :vartype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
    :ivar description: Description of the endpoint deployment.
    :vartype description: str
    :ivar environment_id: ARM resource ID of the environment specification for the endpoint
     deployment.
    :vartype environment_id: str
    :ivar environment_variables: Environment variables configuration for the deployment.
    :vartype environment_variables: dict[str, str]
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar compute: Compute target for batch inference operation.
    :vartype compute: str
    :ivar error_threshold: Error threshold, if the error count for the entire input goes above this
     value,
     the batch inference will be aborted. Range is [-1, int.MaxValue].
     For FileDataset, this value is the count of file failures.
     For TabularDataset, this value is the count of record failures.
     If set to -1 (the lower bound), all failures during batch inference will be ignored.
    :vartype error_threshold: int
    :ivar logging_level: Logging level for batch inference operation. Possible values include:
     "Info", "Warning", "Debug".
    :vartype logging_level: str or ~azure.mgmt.machinelearningservices.models.BatchLoggingLevel
    :ivar max_concurrency_per_instance: Indicates maximum number of parallelism per instance.
    :vartype max_concurrency_per_instance: int
    :ivar mini_batch_size: Size of the mini-batch passed to each batch invocation.
     For FileDataset, this is the number of files per mini-batch.
     For TabularDataset, this is the size of the records in bytes, per mini-batch.
    :vartype mini_batch_size: long
    :ivar model: Reference to the model asset for the endpoint deployment.
    :vartype model: ~azure.mgmt.machinelearningservices.models.AssetReferenceBase
    :ivar output_action: Indicates how the output will be organized. Possible values include:
     "SummaryOnly", "AppendRow".
    :vartype output_action: str or ~azure.mgmt.machinelearningservices.models.BatchOutputAction
    :ivar output_file_name: Customized output file name for append_row output action.
    :vartype output_file_name: str
    :ivar provisioning_state: Provisioning state for the endpoint deployment. Possible values
     include: "Creating", "Deleting", "Scaling", "Updating", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.DeploymentProvisioningState
    :ivar resources: Indicates compute configuration for the job.
     If not provided, will default to the defaults defined in ResourceConfiguration.
    :vartype resources: ~azure.mgmt.machinelearningservices.models.DeploymentResourceConfiguration
    :ivar retry_settings: Retry Settings for the batch inference operation.
     If not provided, will default to the defaults defined in BatchRetrySettings.
    :vartype retry_settings: ~azure.mgmt.machinelearningservices.models.BatchRetrySettings
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'code_configuration': {'key': 'codeConfiguration', 'type': 'CodeConfiguration'},
        'description': {'key': 'description', 'type': 'str'},
        'environment_id': {'key': 'environmentId', 'type': 'str'},
        'environment_variables': {'key': 'environmentVariables', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'compute': {'key': 'compute', 'type': 'str'},
        'error_threshold': {'key': 'errorThreshold', 'type': 'int'},
        'logging_level': {'key': 'loggingLevel', 'type': 'str'},
        'max_concurrency_per_instance': {'key': 'maxConcurrencyPerInstance', 'type': 'int'},
        'mini_batch_size': {'key': 'miniBatchSize', 'type': 'long'},
        'model': {'key': 'model', 'type': 'AssetReferenceBase'},
        'output_action': {'key': 'outputAction', 'type': 'str'},
        'output_file_name': {'key': 'outputFileName', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'resources': {'key': 'resources', 'type': 'DeploymentResourceConfiguration'},
        'retry_settings': {'key': 'retrySettings', 'type': 'BatchRetrySettings'},
    }

    def __init__(
        self,
        *,
        code_configuration: Optional["CodeConfiguration"] = None,
        description: Optional[str] = None,
        environment_id: Optional[str] = None,
        environment_variables: Optional[Dict[str, str]] = None,
        properties: Optional[Dict[str, str]] = None,
        compute: Optional[str] = None,
        error_threshold: Optional[int] = -1,
        logging_level: Optional[Union[str, "BatchLoggingLevel"]] = None,
        max_concurrency_per_instance: Optional[int] = 1,
        mini_batch_size: Optional[int] = 10,
        model: Optional["AssetReferenceBase"] = None,
        output_action: Optional[Union[str, "BatchOutputAction"]] = None,
        output_file_name: Optional[str] = "predictions.csv",
        resources: Optional["DeploymentResourceConfiguration"] = None,
        retry_settings: Optional["BatchRetrySettings"] = None,
        **kwargs
    ):
        """
        :keyword code_configuration: Code configuration for the endpoint deployment.
        :paramtype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
        :keyword description: Description of the endpoint deployment.
        :paramtype description: str
        :keyword environment_id: ARM resource ID of the environment specification for the endpoint
         deployment.
        :paramtype environment_id: str
        :keyword environment_variables: Environment variables configuration for the deployment.
        :paramtype environment_variables: dict[str, str]
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        :keyword compute: Compute target for batch inference operation.
        :paramtype compute: str
        :keyword error_threshold: Error threshold, if the error count for the entire input goes above
         this value,
         the batch inference will be aborted. Range is [-1, int.MaxValue].
         For FileDataset, this value is the count of file failures.
         For TabularDataset, this value is the count of record failures.
         If set to -1 (the lower bound), all failures during batch inference will be ignored.
        :paramtype error_threshold: int
        :keyword logging_level: Logging level for batch inference operation. Possible values include:
         "Info", "Warning", "Debug".
        :paramtype logging_level: str or ~azure.mgmt.machinelearningservices.models.BatchLoggingLevel
        :keyword max_concurrency_per_instance: Indicates maximum number of parallelism per instance.
        :paramtype max_concurrency_per_instance: int
        :keyword mini_batch_size: Size of the mini-batch passed to each batch invocation.
         For FileDataset, this is the number of files per mini-batch.
         For TabularDataset, this is the size of the records in bytes, per mini-batch.
        :paramtype mini_batch_size: long
        :keyword model: Reference to the model asset for the endpoint deployment.
        :paramtype model: ~azure.mgmt.machinelearningservices.models.AssetReferenceBase
        :keyword output_action: Indicates how the output will be organized. Possible values include:
         "SummaryOnly", "AppendRow".
        :paramtype output_action: str or ~azure.mgmt.machinelearningservices.models.BatchOutputAction
        :keyword output_file_name: Customized output file name for append_row output action.
        :paramtype output_file_name: str
        :keyword resources: Indicates compute configuration for the job.
         If not provided, will default to the defaults defined in ResourceConfiguration.
        :paramtype resources:
         ~azure.mgmt.machinelearningservices.models.DeploymentResourceConfiguration
        :keyword retry_settings: Retry Settings for the batch inference operation.
         If not provided, will default to the defaults defined in BatchRetrySettings.
        :paramtype retry_settings: ~azure.mgmt.machinelearningservices.models.BatchRetrySettings
        """
        super(BatchDeploymentProperties, self).__init__(code_configuration=code_configuration, description=description, environment_id=environment_id, environment_variables=environment_variables, properties=properties, **kwargs)
        self.compute = compute
        self.error_threshold = error_threshold
        self.logging_level = logging_level
        self.max_concurrency_per_instance = max_concurrency_per_instance
        self.mini_batch_size = mini_batch_size
        self.model = model
        self.output_action = output_action
        self.output_file_name = output_file_name
        self.provisioning_state = None
        self.resources = resources
        self.retry_settings = retry_settings


class BatchDeploymentTrackedResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of BatchDeployment entities.

    :ivar next_link: The link to the next page of BatchDeployment objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type BatchDeployment.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.BatchDeployment]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[BatchDeployment]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["BatchDeployment"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of BatchDeployment objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type BatchDeployment.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.BatchDeployment]
        """
        super(BatchDeploymentTrackedResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class BatchEndpoint(TrackedResource):
    """BatchEndpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
    :ivar kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type.
    :vartype kind: str
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.BatchEndpointProperties
    :ivar sku: Sku details required for ARM contract for Autoscaling.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.Sku
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'kind': {'key': 'kind', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'BatchEndpointProperties'},
        'sku': {'key': 'sku', 'type': 'Sku'},
    }

    def __init__(
        self,
        *,
        location: str,
        properties: "BatchEndpointProperties",
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["ManagedServiceIdentity"] = None,
        kind: Optional[str] = None,
        sku: Optional["Sku"] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword identity: Managed service identity (system assigned and/or user assigned identities).
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
        :keyword kind: Metadata used by portal/tooling/etc to render different UX experiences for
         resources of the same type.
        :paramtype kind: str
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.BatchEndpointProperties
        :keyword sku: Sku details required for ARM contract for Autoscaling.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.Sku
        """
        super(BatchEndpoint, self).__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.kind = kind
        self.properties = properties
        self.sku = sku


class BatchEndpointDefaults(msrest.serialization.Model):
    """Batch endpoint default values.

    :ivar deployment_name: Name of the deployment that will be default for the endpoint.
     This deployment will end up getting 100% traffic when the endpoint scoring URL is invoked.
    :vartype deployment_name: str
    """

    _attribute_map = {
        'deployment_name': {'key': 'deploymentName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        deployment_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword deployment_name: Name of the deployment that will be default for the endpoint.
         This deployment will end up getting 100% traffic when the endpoint scoring URL is invoked.
        :paramtype deployment_name: str
        """
        super(BatchEndpointDefaults, self).__init__(**kwargs)
        self.deployment_name = deployment_name


class EndpointPropertiesBase(msrest.serialization.Model):
    """Inference Endpoint base definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_mode: Required. [Required] Use 'Key' for key based authentication and 'AMLToken' for
     Azure Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken' does.
     Possible values include: "AMLToken", "Key", "AADToken".
    :vartype auth_mode: str or ~azure.mgmt.machinelearningservices.models.EndpointAuthMode
    :ivar description: Description of the inference endpoint.
    :vartype description: str
    :ivar keys: EndpointAuthKeys to set initially on an Endpoint.
     This property will always be returned as null. AuthKey values must be retrieved using the
     ListKeys API.
    :vartype keys: ~azure.mgmt.machinelearningservices.models.EndpointAuthKeys
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar scoring_uri: Endpoint URI.
    :vartype scoring_uri: str
    :ivar swagger_uri: Endpoint Swagger URI.
    :vartype swagger_uri: str
    """

    _validation = {
        'auth_mode': {'required': True},
        'scoring_uri': {'readonly': True},
        'swagger_uri': {'readonly': True},
    }

    _attribute_map = {
        'auth_mode': {'key': 'authMode', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'keys': {'key': 'keys', 'type': 'EndpointAuthKeys'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'scoring_uri': {'key': 'scoringUri', 'type': 'str'},
        'swagger_uri': {'key': 'swaggerUri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        auth_mode: Union[str, "EndpointAuthMode"],
        description: Optional[str] = None,
        keys: Optional["EndpointAuthKeys"] = None,
        properties: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword auth_mode: Required. [Required] Use 'Key' for key based authentication and 'AMLToken'
         for Azure Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken'
         does. Possible values include: "AMLToken", "Key", "AADToken".
        :paramtype auth_mode: str or ~azure.mgmt.machinelearningservices.models.EndpointAuthMode
        :keyword description: Description of the inference endpoint.
        :paramtype description: str
        :keyword keys: EndpointAuthKeys to set initially on an Endpoint.
         This property will always be returned as null. AuthKey values must be retrieved using the
         ListKeys API.
        :paramtype keys: ~azure.mgmt.machinelearningservices.models.EndpointAuthKeys
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        """
        super(EndpointPropertiesBase, self).__init__(**kwargs)
        self.auth_mode = auth_mode
        self.description = description
        self.keys = keys
        self.properties = properties
        self.scoring_uri = None
        self.swagger_uri = None


class BatchEndpointProperties(EndpointPropertiesBase):
    """Batch endpoint configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_mode: Required. [Required] Use 'Key' for key based authentication and 'AMLToken' for
     Azure Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken' does.
     Possible values include: "AMLToken", "Key", "AADToken".
    :vartype auth_mode: str or ~azure.mgmt.machinelearningservices.models.EndpointAuthMode
    :ivar description: Description of the inference endpoint.
    :vartype description: str
    :ivar keys: EndpointAuthKeys to set initially on an Endpoint.
     This property will always be returned as null. AuthKey values must be retrieved using the
     ListKeys API.
    :vartype keys: ~azure.mgmt.machinelearningservices.models.EndpointAuthKeys
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar scoring_uri: Endpoint URI.
    :vartype scoring_uri: str
    :ivar swagger_uri: Endpoint Swagger URI.
    :vartype swagger_uri: str
    :ivar defaults: Default values for Batch Endpoint.
    :vartype defaults: ~azure.mgmt.machinelearningservices.models.BatchEndpointDefaults
    :ivar provisioning_state: Provisioning state for the endpoint. Possible values include:
     "Creating", "Deleting", "Succeeded", "Failed", "Updating", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.EndpointProvisioningState
    """

    _validation = {
        'auth_mode': {'required': True},
        'scoring_uri': {'readonly': True},
        'swagger_uri': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'auth_mode': {'key': 'authMode', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'keys': {'key': 'keys', 'type': 'EndpointAuthKeys'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'scoring_uri': {'key': 'scoringUri', 'type': 'str'},
        'swagger_uri': {'key': 'swaggerUri', 'type': 'str'},
        'defaults': {'key': 'defaults', 'type': 'BatchEndpointDefaults'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        auth_mode: Union[str, "EndpointAuthMode"],
        description: Optional[str] = None,
        keys: Optional["EndpointAuthKeys"] = None,
        properties: Optional[Dict[str, str]] = None,
        defaults: Optional["BatchEndpointDefaults"] = None,
        **kwargs
    ):
        """
        :keyword auth_mode: Required. [Required] Use 'Key' for key based authentication and 'AMLToken'
         for Azure Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken'
         does. Possible values include: "AMLToken", "Key", "AADToken".
        :paramtype auth_mode: str or ~azure.mgmt.machinelearningservices.models.EndpointAuthMode
        :keyword description: Description of the inference endpoint.
        :paramtype description: str
        :keyword keys: EndpointAuthKeys to set initially on an Endpoint.
         This property will always be returned as null. AuthKey values must be retrieved using the
         ListKeys API.
        :paramtype keys: ~azure.mgmt.machinelearningservices.models.EndpointAuthKeys
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        :keyword defaults: Default values for Batch Endpoint.
        :paramtype defaults: ~azure.mgmt.machinelearningservices.models.BatchEndpointDefaults
        """
        super(BatchEndpointProperties, self).__init__(auth_mode=auth_mode, description=description, keys=keys, properties=properties, **kwargs)
        self.defaults = defaults
        self.provisioning_state = None


class BatchEndpointTrackedResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of BatchEndpoint entities.

    :ivar next_link: The link to the next page of BatchEndpoint objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type BatchEndpoint.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.BatchEndpoint]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[BatchEndpoint]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["BatchEndpoint"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of BatchEndpoint objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type BatchEndpoint.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.BatchEndpoint]
        """
        super(BatchEndpointTrackedResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class BatchRetrySettings(msrest.serialization.Model):
    """Retry settings for a batch inference operation.

    :ivar max_retries: Maximum retry count for a mini-batch.
    :vartype max_retries: int
    :ivar timeout: Invocation timeout for a mini-batch, in ISO 8601 format.
    :vartype timeout: ~datetime.timedelta
    """

    _attribute_map = {
        'max_retries': {'key': 'maxRetries', 'type': 'int'},
        'timeout': {'key': 'timeout', 'type': 'duration'},
    }

    def __init__(
        self,
        *,
        max_retries: Optional[int] = 3,
        timeout: Optional[datetime.timedelta] = "PT30S",
        **kwargs
    ):
        """
        :keyword max_retries: Maximum retry count for a mini-batch.
        :paramtype max_retries: int
        :keyword timeout: Invocation timeout for a mini-batch, in ISO 8601 format.
        :paramtype timeout: ~datetime.timedelta
        """
        super(BatchRetrySettings, self).__init__(**kwargs)
        self.max_retries = max_retries
        self.timeout = timeout


class SamplingAlgorithm(msrest.serialization.Model):
    """The Sampling Algorithm used to generate hyperparameter values, along with properties to
configure the algorithm.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: BayesianSamplingAlgorithm, GridSamplingAlgorithm, RandomSamplingAlgorithm.

    All required parameters must be populated in order to send to Azure.

    :ivar sampling_algorithm_type: Required. [Required] The algorithm used for generating
     hyperparameter values, along with configuration properties.Constant filled by server. Possible
     values include: "Grid", "Random", "Bayesian".
    :vartype sampling_algorithm_type: str or
     ~azure.mgmt.machinelearningservices.models.SamplingAlgorithmType
    """

    _validation = {
        'sampling_algorithm_type': {'required': True},
    }

    _attribute_map = {
        'sampling_algorithm_type': {'key': 'samplingAlgorithmType', 'type': 'str'},
    }

    _subtype_map = {
        'sampling_algorithm_type': {'Bayesian': 'BayesianSamplingAlgorithm', 'Grid': 'GridSamplingAlgorithm', 'Random': 'RandomSamplingAlgorithm'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(SamplingAlgorithm, self).__init__(**kwargs)
        self.sampling_algorithm_type = None  # type: Optional[str]


class BayesianSamplingAlgorithm(SamplingAlgorithm):
    """Defines a Sampling Algorithm that generates values based on previous values.

    All required parameters must be populated in order to send to Azure.

    :ivar sampling_algorithm_type: Required. [Required] The algorithm used for generating
     hyperparameter values, along with configuration properties.Constant filled by server. Possible
     values include: "Grid", "Random", "Bayesian".
    :vartype sampling_algorithm_type: str or
     ~azure.mgmt.machinelearningservices.models.SamplingAlgorithmType
    """

    _validation = {
        'sampling_algorithm_type': {'required': True},
    }

    _attribute_map = {
        'sampling_algorithm_type': {'key': 'samplingAlgorithmType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(BayesianSamplingAlgorithm, self).__init__(**kwargs)
        self.sampling_algorithm_type = 'Bayesian'  # type: str


class BindOptions(msrest.serialization.Model):
    """BindOptions.

    :ivar propagation: Type of Bind Option.
    :vartype propagation: str
    :ivar create_host_path: Indicate whether to create host path.
    :vartype create_host_path: bool
    :ivar selinux: Mention the selinux options.
    :vartype selinux: str
    """

    _attribute_map = {
        'propagation': {'key': 'propagation', 'type': 'str'},
        'create_host_path': {'key': 'createHostPath', 'type': 'bool'},
        'selinux': {'key': 'selinux', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        propagation: Optional[str] = None,
        create_host_path: Optional[bool] = None,
        selinux: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword propagation: Type of Bind Option.
        :paramtype propagation: str
        :keyword create_host_path: Indicate whether to create host path.
        :paramtype create_host_path: bool
        :keyword selinux: Mention the selinux options.
        :paramtype selinux: str
        """
        super(BindOptions, self).__init__(**kwargs)
        self.propagation = propagation
        self.create_host_path = create_host_path
        self.selinux = selinux


class BuildContext(msrest.serialization.Model):
    """Configuration settings for Docker build context.

    All required parameters must be populated in order to send to Azure.

    :ivar context_uri: Required. [Required] URI of the Docker build context used to build the
     image. Supports blob URIs on environment creation and may return blob or Git URIs.


     .. raw:: html

        <seealso
     href="https://docs.docker.com/engine/reference/commandline/build/#extended-description" />.
    :vartype context_uri: str
    :ivar dockerfile_path: Path to the Dockerfile in the build context.


     .. raw:: html

        <seealso href="https://docs.docker.com/engine/reference/builder/" />.
    :vartype dockerfile_path: str
    """

    _validation = {
        'context_uri': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'context_uri': {'key': 'contextUri', 'type': 'str'},
        'dockerfile_path': {'key': 'dockerfilePath', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        context_uri: str,
        dockerfile_path: Optional[str] = "Dockerfile",
        **kwargs
    ):
        """
        :keyword context_uri: Required. [Required] URI of the Docker build context used to build the
         image. Supports blob URIs on environment creation and may return blob or Git URIs.


         .. raw:: html

            <seealso
         href="https://docs.docker.com/engine/reference/commandline/build/#extended-description" />.
        :paramtype context_uri: str
        :keyword dockerfile_path: Path to the Dockerfile in the build context.


         .. raw:: html

            <seealso href="https://docs.docker.com/engine/reference/builder/" />.
        :paramtype dockerfile_path: str
        """
        super(BuildContext, self).__init__(**kwargs)
        self.context_uri = context_uri
        self.dockerfile_path = dockerfile_path


class CertificateDatastoreCredentials(DatastoreCredentials):
    """Certificate datastore credentials configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar credentials_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "AccountKey", "Certificate",
     "None", "Sas", "ServicePrincipal", "KerberosKeytab", "KerberosPassword".
    :vartype credentials_type: str or ~azure.mgmt.machinelearningservices.models.CredentialsType
    :ivar authority_url: Authority URL used for authentication.
    :vartype authority_url: str
    :ivar client_id: Required. [Required] Service principal client ID.
    :vartype client_id: str
    :ivar resource_url: Resource the service principal has access to.
    :vartype resource_url: str
    :ivar secrets: Required. [Required] Service principal secrets.
    :vartype secrets: ~azure.mgmt.machinelearningservices.models.CertificateDatastoreSecrets
    :ivar tenant_id: Required. [Required] ID of the tenant to which the service principal belongs.
    :vartype tenant_id: str
    :ivar thumbprint: Required. [Required] Thumbprint of the certificate used for authentication.
    :vartype thumbprint: str
    """

    _validation = {
        'credentials_type': {'required': True},
        'client_id': {'required': True},
        'secrets': {'required': True},
        'tenant_id': {'required': True},
        'thumbprint': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'credentials_type': {'key': 'credentialsType', 'type': 'str'},
        'authority_url': {'key': 'authorityUrl', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
        'resource_url': {'key': 'resourceUrl', 'type': 'str'},
        'secrets': {'key': 'secrets', 'type': 'CertificateDatastoreSecrets'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        client_id: str,
        secrets: "CertificateDatastoreSecrets",
        tenant_id: str,
        thumbprint: str,
        authority_url: Optional[str] = None,
        resource_url: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword authority_url: Authority URL used for authentication.
        :paramtype authority_url: str
        :keyword client_id: Required. [Required] Service principal client ID.
        :paramtype client_id: str
        :keyword resource_url: Resource the service principal has access to.
        :paramtype resource_url: str
        :keyword secrets: Required. [Required] Service principal secrets.
        :paramtype secrets: ~azure.mgmt.machinelearningservices.models.CertificateDatastoreSecrets
        :keyword tenant_id: Required. [Required] ID of the tenant to which the service principal
         belongs.
        :paramtype tenant_id: str
        :keyword thumbprint: Required. [Required] Thumbprint of the certificate used for
         authentication.
        :paramtype thumbprint: str
        """
        super(CertificateDatastoreCredentials, self).__init__(**kwargs)
        self.credentials_type = 'Certificate'  # type: str
        self.authority_url = authority_url
        self.client_id = client_id
        self.resource_url = resource_url
        self.secrets = secrets
        self.tenant_id = tenant_id
        self.thumbprint = thumbprint


class CertificateDatastoreSecrets(DatastoreSecrets):
    """Datastore certificate secrets.

    All required parameters must be populated in order to send to Azure.

    :ivar secrets_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "AccountKey", "Certificate", "Sas",
     "ServicePrincipal", "KerberosPassword", "KerberosKeytab".
    :vartype secrets_type: str or ~azure.mgmt.machinelearningservices.models.SecretsType
    :ivar certificate: Service principal certificate.
    :vartype certificate: str
    """

    _validation = {
        'secrets_type': {'required': True},
    }

    _attribute_map = {
        'secrets_type': {'key': 'secretsType', 'type': 'str'},
        'certificate': {'key': 'certificate', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        certificate: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword certificate: Service principal certificate.
        :paramtype certificate: str
        """
        super(CertificateDatastoreSecrets, self).__init__(**kwargs)
        self.secrets_type = 'Certificate'  # type: str
        self.certificate = certificate


class TableVertical(msrest.serialization.Model):
    """Abstract class for AutoML tasks that use table dataset as input - such as Classification/Regression/Forecasting.

    :ivar cv_split_column_names: Columns to use for CVSplit data.
    :vartype cv_split_column_names: list[str]
    :ivar featurization_settings: Featurization inputs needed for AutoML job.
    :vartype featurization_settings:
     ~azure.mgmt.machinelearningservices.models.TableVerticalFeaturizationSettings
    :ivar fixed_parameters: Model/training parameters that will remain constant throughout
     training.
    :vartype fixed_parameters: ~azure.mgmt.machinelearningservices.models.TableFixedParameters
    :ivar limit_settings: Execution constraints for AutoMLJob.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.TableVerticalLimitSettings
    :ivar n_cross_validations: Number of cross validation folds to be applied on training dataset
     when validation dataset is not provided.
    :vartype n_cross_validations: ~azure.mgmt.machinelearningservices.models.NCrossValidations
    :ivar search_space: Search space for sampling different combinations of models and their
     hyperparameters.
    :vartype search_space: list[~azure.mgmt.machinelearningservices.models.TableParameterSubspace]
    :ivar sweep_settings: Settings for model sweeping and hyperparameter tuning.
    :vartype sweep_settings: ~azure.mgmt.machinelearningservices.models.TableSweepSettings
    :ivar test_data: Test data input.
    :vartype test_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar test_data_size: The fraction of test dataset that needs to be set aside for validation
     purpose.
     Values between (0.0 , 1.0)
     Applied when validation dataset is not provided.
    :vartype test_data_size: float
    :ivar validation_data: Validation data inputs.
    :vartype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar validation_data_size: The fraction of training dataset that needs to be set aside for
     validation purpose.
     Values between (0.0 , 1.0)
     Applied when validation dataset is not provided.
    :vartype validation_data_size: float
    :ivar weight_column_name: The name of the sample weight column. Automated ML supports a
     weighted column as an input, causing rows in the data to be weighted up or down.
    :vartype weight_column_name: str
    """

    _attribute_map = {
        'cv_split_column_names': {'key': 'cvSplitColumnNames', 'type': '[str]'},
        'featurization_settings': {'key': 'featurizationSettings', 'type': 'TableVerticalFeaturizationSettings'},
        'fixed_parameters': {'key': 'fixedParameters', 'type': 'TableFixedParameters'},
        'limit_settings': {'key': 'limitSettings', 'type': 'TableVerticalLimitSettings'},
        'n_cross_validations': {'key': 'nCrossValidations', 'type': 'NCrossValidations'},
        'search_space': {'key': 'searchSpace', 'type': '[TableParameterSubspace]'},
        'sweep_settings': {'key': 'sweepSettings', 'type': 'TableSweepSettings'},
        'test_data': {'key': 'testData', 'type': 'MLTableJobInput'},
        'test_data_size': {'key': 'testDataSize', 'type': 'float'},
        'validation_data': {'key': 'validationData', 'type': 'MLTableJobInput'},
        'validation_data_size': {'key': 'validationDataSize', 'type': 'float'},
        'weight_column_name': {'key': 'weightColumnName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        cv_split_column_names: Optional[List[str]] = None,
        featurization_settings: Optional["TableVerticalFeaturizationSettings"] = None,
        fixed_parameters: Optional["TableFixedParameters"] = None,
        limit_settings: Optional["TableVerticalLimitSettings"] = None,
        n_cross_validations: Optional["NCrossValidations"] = None,
        search_space: Optional[List["TableParameterSubspace"]] = None,
        sweep_settings: Optional["TableSweepSettings"] = None,
        test_data: Optional["MLTableJobInput"] = None,
        test_data_size: Optional[float] = None,
        validation_data: Optional["MLTableJobInput"] = None,
        validation_data_size: Optional[float] = None,
        weight_column_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword cv_split_column_names: Columns to use for CVSplit data.
        :paramtype cv_split_column_names: list[str]
        :keyword featurization_settings: Featurization inputs needed for AutoML job.
        :paramtype featurization_settings:
         ~azure.mgmt.machinelearningservices.models.TableVerticalFeaturizationSettings
        :keyword fixed_parameters: Model/training parameters that will remain constant throughout
         training.
        :paramtype fixed_parameters: ~azure.mgmt.machinelearningservices.models.TableFixedParameters
        :keyword limit_settings: Execution constraints for AutoMLJob.
        :paramtype limit_settings:
         ~azure.mgmt.machinelearningservices.models.TableVerticalLimitSettings
        :keyword n_cross_validations: Number of cross validation folds to be applied on training
         dataset
         when validation dataset is not provided.
        :paramtype n_cross_validations: ~azure.mgmt.machinelearningservices.models.NCrossValidations
        :keyword search_space: Search space for sampling different combinations of models and their
         hyperparameters.
        :paramtype search_space:
         list[~azure.mgmt.machinelearningservices.models.TableParameterSubspace]
        :keyword sweep_settings: Settings for model sweeping and hyperparameter tuning.
        :paramtype sweep_settings: ~azure.mgmt.machinelearningservices.models.TableSweepSettings
        :keyword test_data: Test data input.
        :paramtype test_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword test_data_size: The fraction of test dataset that needs to be set aside for validation
         purpose.
         Values between (0.0 , 1.0)
         Applied when validation dataset is not provided.
        :paramtype test_data_size: float
        :keyword validation_data: Validation data inputs.
        :paramtype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword validation_data_size: The fraction of training dataset that needs to be set aside for
         validation purpose.
         Values between (0.0 , 1.0)
         Applied when validation dataset is not provided.
        :paramtype validation_data_size: float
        :keyword weight_column_name: The name of the sample weight column. Automated ML supports a
         weighted column as an input, causing rows in the data to be weighted up or down.
        :paramtype weight_column_name: str
        """
        super(TableVertical, self).__init__(**kwargs)
        self.cv_split_column_names = cv_split_column_names
        self.featurization_settings = featurization_settings
        self.fixed_parameters = fixed_parameters
        self.limit_settings = limit_settings
        self.n_cross_validations = n_cross_validations
        self.search_space = search_space
        self.sweep_settings = sweep_settings
        self.test_data = test_data
        self.test_data_size = test_data_size
        self.validation_data = validation_data
        self.validation_data_size = validation_data_size
        self.weight_column_name = weight_column_name


class Classification(AutoMLVertical, TableVertical):
    """Classification task in AutoML Table vertical.

    All required parameters must be populated in order to send to Azure.

    :ivar cv_split_column_names: Columns to use for CVSplit data.
    :vartype cv_split_column_names: list[str]
    :ivar featurization_settings: Featurization inputs needed for AutoML job.
    :vartype featurization_settings:
     ~azure.mgmt.machinelearningservices.models.TableVerticalFeaturizationSettings
    :ivar fixed_parameters: Model/training parameters that will remain constant throughout
     training.
    :vartype fixed_parameters: ~azure.mgmt.machinelearningservices.models.TableFixedParameters
    :ivar limit_settings: Execution constraints for AutoMLJob.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.TableVerticalLimitSettings
    :ivar n_cross_validations: Number of cross validation folds to be applied on training dataset
     when validation dataset is not provided.
    :vartype n_cross_validations: ~azure.mgmt.machinelearningservices.models.NCrossValidations
    :ivar search_space: Search space for sampling different combinations of models and their
     hyperparameters.
    :vartype search_space: list[~azure.mgmt.machinelearningservices.models.TableParameterSubspace]
    :ivar sweep_settings: Settings for model sweeping and hyperparameter tuning.
    :vartype sweep_settings: ~azure.mgmt.machinelearningservices.models.TableSweepSettings
    :ivar test_data: Test data input.
    :vartype test_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar test_data_size: The fraction of test dataset that needs to be set aside for validation
     purpose.
     Values between (0.0 , 1.0)
     Applied when validation dataset is not provided.
    :vartype test_data_size: float
    :ivar validation_data: Validation data inputs.
    :vartype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar validation_data_size: The fraction of training dataset that needs to be set aside for
     validation purpose.
     Values between (0.0 , 1.0)
     Applied when validation dataset is not provided.
    :vartype validation_data_size: float
    :ivar weight_column_name: The name of the sample weight column. Automated ML supports a
     weighted column as an input, causing rows in the data to be weighted up or down.
    :vartype weight_column_name: str
    :ivar log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
     "Info", "Warning", "Error", "Critical".
    :vartype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
    :ivar target_column_name: Target column name: This is prediction values column.
     Also known as label column name in context of classification tasks.
    :vartype target_column_name: str
    :ivar task_type: Required. [Required] Task type for AutoMLJob.Constant filled by server.
     Possible values include: "Classification", "Regression", "Forecasting", "ImageClassification",
     "ImageClassificationMultilabel", "ImageObjectDetection", "ImageInstanceSegmentation",
     "TextClassification", "TextClassificationMultilabel", "TextNER".
    :vartype task_type: str or ~azure.mgmt.machinelearningservices.models.TaskType
    :ivar training_data: Required. [Required] Training data input.
    :vartype training_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar positive_label: Positive label for binary metrics calculation.
    :vartype positive_label: str
    :ivar primary_metric: Primary metric for the task. Possible values include: "AUCWeighted",
     "Accuracy", "NormMacroRecall", "AveragePrecisionScoreWeighted", "PrecisionScoreWeighted".
    :vartype primary_metric: str or
     ~azure.mgmt.machinelearningservices.models.ClassificationPrimaryMetrics
    :ivar training_settings: Inputs for training phase for an AutoML Job.
    :vartype training_settings:
     ~azure.mgmt.machinelearningservices.models.ClassificationTrainingSettings
    """

    _validation = {
        'task_type': {'required': True},
        'training_data': {'required': True},
    }

    _attribute_map = {
        'cv_split_column_names': {'key': 'cvSplitColumnNames', 'type': '[str]'},
        'featurization_settings': {'key': 'featurizationSettings', 'type': 'TableVerticalFeaturizationSettings'},
        'fixed_parameters': {'key': 'fixedParameters', 'type': 'TableFixedParameters'},
        'limit_settings': {'key': 'limitSettings', 'type': 'TableVerticalLimitSettings'},
        'n_cross_validations': {'key': 'nCrossValidations', 'type': 'NCrossValidations'},
        'search_space': {'key': 'searchSpace', 'type': '[TableParameterSubspace]'},
        'sweep_settings': {'key': 'sweepSettings', 'type': 'TableSweepSettings'},
        'test_data': {'key': 'testData', 'type': 'MLTableJobInput'},
        'test_data_size': {'key': 'testDataSize', 'type': 'float'},
        'validation_data': {'key': 'validationData', 'type': 'MLTableJobInput'},
        'validation_data_size': {'key': 'validationDataSize', 'type': 'float'},
        'weight_column_name': {'key': 'weightColumnName', 'type': 'str'},
        'log_verbosity': {'key': 'logVerbosity', 'type': 'str'},
        'target_column_name': {'key': 'targetColumnName', 'type': 'str'},
        'task_type': {'key': 'taskType', 'type': 'str'},
        'training_data': {'key': 'trainingData', 'type': 'MLTableJobInput'},
        'positive_label': {'key': 'positiveLabel', 'type': 'str'},
        'primary_metric': {'key': 'primaryMetric', 'type': 'str'},
        'training_settings': {'key': 'trainingSettings', 'type': 'ClassificationTrainingSettings'},
    }

    def __init__(
        self,
        *,
        training_data: "MLTableJobInput",
        cv_split_column_names: Optional[List[str]] = None,
        featurization_settings: Optional["TableVerticalFeaturizationSettings"] = None,
        fixed_parameters: Optional["TableFixedParameters"] = None,
        limit_settings: Optional["TableVerticalLimitSettings"] = None,
        n_cross_validations: Optional["NCrossValidations"] = None,
        search_space: Optional[List["TableParameterSubspace"]] = None,
        sweep_settings: Optional["TableSweepSettings"] = None,
        test_data: Optional["MLTableJobInput"] = None,
        test_data_size: Optional[float] = None,
        validation_data: Optional["MLTableJobInput"] = None,
        validation_data_size: Optional[float] = None,
        weight_column_name: Optional[str] = None,
        log_verbosity: Optional[Union[str, "LogVerbosity"]] = None,
        target_column_name: Optional[str] = None,
        positive_label: Optional[str] = None,
        primary_metric: Optional[Union[str, "ClassificationPrimaryMetrics"]] = None,
        training_settings: Optional["ClassificationTrainingSettings"] = None,
        **kwargs
    ):
        """
        :keyword cv_split_column_names: Columns to use for CVSplit data.
        :paramtype cv_split_column_names: list[str]
        :keyword featurization_settings: Featurization inputs needed for AutoML job.
        :paramtype featurization_settings:
         ~azure.mgmt.machinelearningservices.models.TableVerticalFeaturizationSettings
        :keyword fixed_parameters: Model/training parameters that will remain constant throughout
         training.
        :paramtype fixed_parameters: ~azure.mgmt.machinelearningservices.models.TableFixedParameters
        :keyword limit_settings: Execution constraints for AutoMLJob.
        :paramtype limit_settings:
         ~azure.mgmt.machinelearningservices.models.TableVerticalLimitSettings
        :keyword n_cross_validations: Number of cross validation folds to be applied on training
         dataset
         when validation dataset is not provided.
        :paramtype n_cross_validations: ~azure.mgmt.machinelearningservices.models.NCrossValidations
        :keyword search_space: Search space for sampling different combinations of models and their
         hyperparameters.
        :paramtype search_space:
         list[~azure.mgmt.machinelearningservices.models.TableParameterSubspace]
        :keyword sweep_settings: Settings for model sweeping and hyperparameter tuning.
        :paramtype sweep_settings: ~azure.mgmt.machinelearningservices.models.TableSweepSettings
        :keyword test_data: Test data input.
        :paramtype test_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword test_data_size: The fraction of test dataset that needs to be set aside for validation
         purpose.
         Values between (0.0 , 1.0)
         Applied when validation dataset is not provided.
        :paramtype test_data_size: float
        :keyword validation_data: Validation data inputs.
        :paramtype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword validation_data_size: The fraction of training dataset that needs to be set aside for
         validation purpose.
         Values between (0.0 , 1.0)
         Applied when validation dataset is not provided.
        :paramtype validation_data_size: float
        :keyword weight_column_name: The name of the sample weight column. Automated ML supports a
         weighted column as an input, causing rows in the data to be weighted up or down.
        :paramtype weight_column_name: str
        :keyword log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
         "Info", "Warning", "Error", "Critical".
        :paramtype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
        :keyword target_column_name: Target column name: This is prediction values column.
         Also known as label column name in context of classification tasks.
        :paramtype target_column_name: str
        :keyword training_data: Required. [Required] Training data input.
        :paramtype training_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword positive_label: Positive label for binary metrics calculation.
        :paramtype positive_label: str
        :keyword primary_metric: Primary metric for the task. Possible values include: "AUCWeighted",
         "Accuracy", "NormMacroRecall", "AveragePrecisionScoreWeighted", "PrecisionScoreWeighted".
        :paramtype primary_metric: str or
         ~azure.mgmt.machinelearningservices.models.ClassificationPrimaryMetrics
        :keyword training_settings: Inputs for training phase for an AutoML Job.
        :paramtype training_settings:
         ~azure.mgmt.machinelearningservices.models.ClassificationTrainingSettings
        """
        super(Classification, self).__init__(log_verbosity=log_verbosity, target_column_name=target_column_name, training_data=training_data, cv_split_column_names=cv_split_column_names, featurization_settings=featurization_settings, fixed_parameters=fixed_parameters, limit_settings=limit_settings, n_cross_validations=n_cross_validations, search_space=search_space, sweep_settings=sweep_settings, test_data=test_data, test_data_size=test_data_size, validation_data=validation_data, validation_data_size=validation_data_size, weight_column_name=weight_column_name, **kwargs)
        self.cv_split_column_names = cv_split_column_names
        self.featurization_settings = featurization_settings
        self.fixed_parameters = fixed_parameters
        self.limit_settings = limit_settings
        self.n_cross_validations = n_cross_validations
        self.search_space = search_space
        self.sweep_settings = sweep_settings
        self.test_data = test_data
        self.test_data_size = test_data_size
        self.validation_data = validation_data
        self.validation_data_size = validation_data_size
        self.weight_column_name = weight_column_name
        self.task_type = 'Classification'  # type: str
        self.positive_label = positive_label
        self.primary_metric = primary_metric
        self.training_settings = training_settings
        self.log_verbosity = log_verbosity
        self.target_column_name = target_column_name
        self.training_data = training_data


class TrainingSettings(msrest.serialization.Model):
    """Training related configuration.

    :ivar enable_dnn_training: Enable recommendation of DNN models.
    :vartype enable_dnn_training: bool
    :ivar enable_model_explainability: Flag to turn on explainability on best model.
    :vartype enable_model_explainability: bool
    :ivar enable_onnx_compatible_models: Flag for enabling onnx compatible models.
    :vartype enable_onnx_compatible_models: bool
    :ivar enable_stack_ensemble: Enable stack ensemble run.
    :vartype enable_stack_ensemble: bool
    :ivar enable_vote_ensemble: Enable voting ensemble run.
    :vartype enable_vote_ensemble: bool
    :ivar ensemble_model_download_timeout: During VotingEnsemble and StackEnsemble model
     generation, multiple fitted models from the previous child runs are downloaded.
     Configure this parameter with a higher value than 300 secs, if more time is needed.
    :vartype ensemble_model_download_timeout: ~datetime.timedelta
    :ivar stack_ensemble_settings: Stack ensemble settings for stack ensemble run.
    :vartype stack_ensemble_settings:
     ~azure.mgmt.machinelearningservices.models.StackEnsembleSettings
    """

    _attribute_map = {
        'enable_dnn_training': {'key': 'enableDnnTraining', 'type': 'bool'},
        'enable_model_explainability': {'key': 'enableModelExplainability', 'type': 'bool'},
        'enable_onnx_compatible_models': {'key': 'enableOnnxCompatibleModels', 'type': 'bool'},
        'enable_stack_ensemble': {'key': 'enableStackEnsemble', 'type': 'bool'},
        'enable_vote_ensemble': {'key': 'enableVoteEnsemble', 'type': 'bool'},
        'ensemble_model_download_timeout': {'key': 'ensembleModelDownloadTimeout', 'type': 'duration'},
        'stack_ensemble_settings': {'key': 'stackEnsembleSettings', 'type': 'StackEnsembleSettings'},
    }

    def __init__(
        self,
        *,
        enable_dnn_training: Optional[bool] = False,
        enable_model_explainability: Optional[bool] = True,
        enable_onnx_compatible_models: Optional[bool] = False,
        enable_stack_ensemble: Optional[bool] = True,
        enable_vote_ensemble: Optional[bool] = True,
        ensemble_model_download_timeout: Optional[datetime.timedelta] = "PT5M",
        stack_ensemble_settings: Optional["StackEnsembleSettings"] = None,
        **kwargs
    ):
        """
        :keyword enable_dnn_training: Enable recommendation of DNN models.
        :paramtype enable_dnn_training: bool
        :keyword enable_model_explainability: Flag to turn on explainability on best model.
        :paramtype enable_model_explainability: bool
        :keyword enable_onnx_compatible_models: Flag for enabling onnx compatible models.
        :paramtype enable_onnx_compatible_models: bool
        :keyword enable_stack_ensemble: Enable stack ensemble run.
        :paramtype enable_stack_ensemble: bool
        :keyword enable_vote_ensemble: Enable voting ensemble run.
        :paramtype enable_vote_ensemble: bool
        :keyword ensemble_model_download_timeout: During VotingEnsemble and StackEnsemble model
         generation, multiple fitted models from the previous child runs are downloaded.
         Configure this parameter with a higher value than 300 secs, if more time is needed.
        :paramtype ensemble_model_download_timeout: ~datetime.timedelta
        :keyword stack_ensemble_settings: Stack ensemble settings for stack ensemble run.
        :paramtype stack_ensemble_settings:
         ~azure.mgmt.machinelearningservices.models.StackEnsembleSettings
        """
        super(TrainingSettings, self).__init__(**kwargs)
        self.enable_dnn_training = enable_dnn_training
        self.enable_model_explainability = enable_model_explainability
        self.enable_onnx_compatible_models = enable_onnx_compatible_models
        self.enable_stack_ensemble = enable_stack_ensemble
        self.enable_vote_ensemble = enable_vote_ensemble
        self.ensemble_model_download_timeout = ensemble_model_download_timeout
        self.stack_ensemble_settings = stack_ensemble_settings


class ClassificationTrainingSettings(TrainingSettings):
    """Classification Training related configuration.

    :ivar enable_dnn_training: Enable recommendation of DNN models.
    :vartype enable_dnn_training: bool
    :ivar enable_model_explainability: Flag to turn on explainability on best model.
    :vartype enable_model_explainability: bool
    :ivar enable_onnx_compatible_models: Flag for enabling onnx compatible models.
    :vartype enable_onnx_compatible_models: bool
    :ivar enable_stack_ensemble: Enable stack ensemble run.
    :vartype enable_stack_ensemble: bool
    :ivar enable_vote_ensemble: Enable voting ensemble run.
    :vartype enable_vote_ensemble: bool
    :ivar ensemble_model_download_timeout: During VotingEnsemble and StackEnsemble model
     generation, multiple fitted models from the previous child runs are downloaded.
     Configure this parameter with a higher value than 300 secs, if more time is needed.
    :vartype ensemble_model_download_timeout: ~datetime.timedelta
    :ivar stack_ensemble_settings: Stack ensemble settings for stack ensemble run.
    :vartype stack_ensemble_settings:
     ~azure.mgmt.machinelearningservices.models.StackEnsembleSettings
    :ivar allowed_training_algorithms: Allowed models for classification task.
    :vartype allowed_training_algorithms: list[str or
     ~azure.mgmt.machinelearningservices.models.ClassificationModels]
    :ivar blocked_training_algorithms: Blocked models for classification task.
    :vartype blocked_training_algorithms: list[str or
     ~azure.mgmt.machinelearningservices.models.ClassificationModels]
    """

    _attribute_map = {
        'enable_dnn_training': {'key': 'enableDnnTraining', 'type': 'bool'},
        'enable_model_explainability': {'key': 'enableModelExplainability', 'type': 'bool'},
        'enable_onnx_compatible_models': {'key': 'enableOnnxCompatibleModels', 'type': 'bool'},
        'enable_stack_ensemble': {'key': 'enableStackEnsemble', 'type': 'bool'},
        'enable_vote_ensemble': {'key': 'enableVoteEnsemble', 'type': 'bool'},
        'ensemble_model_download_timeout': {'key': 'ensembleModelDownloadTimeout', 'type': 'duration'},
        'stack_ensemble_settings': {'key': 'stackEnsembleSettings', 'type': 'StackEnsembleSettings'},
        'allowed_training_algorithms': {'key': 'allowedTrainingAlgorithms', 'type': '[str]'},
        'blocked_training_algorithms': {'key': 'blockedTrainingAlgorithms', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        enable_dnn_training: Optional[bool] = False,
        enable_model_explainability: Optional[bool] = True,
        enable_onnx_compatible_models: Optional[bool] = False,
        enable_stack_ensemble: Optional[bool] = True,
        enable_vote_ensemble: Optional[bool] = True,
        ensemble_model_download_timeout: Optional[datetime.timedelta] = "PT5M",
        stack_ensemble_settings: Optional["StackEnsembleSettings"] = None,
        allowed_training_algorithms: Optional[List[Union[str, "ClassificationModels"]]] = None,
        blocked_training_algorithms: Optional[List[Union[str, "ClassificationModels"]]] = None,
        **kwargs
    ):
        """
        :keyword enable_dnn_training: Enable recommendation of DNN models.
        :paramtype enable_dnn_training: bool
        :keyword enable_model_explainability: Flag to turn on explainability on best model.
        :paramtype enable_model_explainability: bool
        :keyword enable_onnx_compatible_models: Flag for enabling onnx compatible models.
        :paramtype enable_onnx_compatible_models: bool
        :keyword enable_stack_ensemble: Enable stack ensemble run.
        :paramtype enable_stack_ensemble: bool
        :keyword enable_vote_ensemble: Enable voting ensemble run.
        :paramtype enable_vote_ensemble: bool
        :keyword ensemble_model_download_timeout: During VotingEnsemble and StackEnsemble model
         generation, multiple fitted models from the previous child runs are downloaded.
         Configure this parameter with a higher value than 300 secs, if more time is needed.
        :paramtype ensemble_model_download_timeout: ~datetime.timedelta
        :keyword stack_ensemble_settings: Stack ensemble settings for stack ensemble run.
        :paramtype stack_ensemble_settings:
         ~azure.mgmt.machinelearningservices.models.StackEnsembleSettings
        :keyword allowed_training_algorithms: Allowed models for classification task.
        :paramtype allowed_training_algorithms: list[str or
         ~azure.mgmt.machinelearningservices.models.ClassificationModels]
        :keyword blocked_training_algorithms: Blocked models for classification task.
        :paramtype blocked_training_algorithms: list[str or
         ~azure.mgmt.machinelearningservices.models.ClassificationModels]
        """
        super(ClassificationTrainingSettings, self).__init__(enable_dnn_training=enable_dnn_training, enable_model_explainability=enable_model_explainability, enable_onnx_compatible_models=enable_onnx_compatible_models, enable_stack_ensemble=enable_stack_ensemble, enable_vote_ensemble=enable_vote_ensemble, ensemble_model_download_timeout=ensemble_model_download_timeout, stack_ensemble_settings=stack_ensemble_settings, **kwargs)
        self.allowed_training_algorithms = allowed_training_algorithms
        self.blocked_training_algorithms = blocked_training_algorithms


class ClusterUpdateParameters(msrest.serialization.Model):
    """AmlCompute update parameters.

    :ivar properties: Properties of ClusterUpdate.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.ScaleSettingsInformation
    """

    _attribute_map = {
        'properties': {'key': 'properties.properties', 'type': 'ScaleSettingsInformation'},
    }

    def __init__(
        self,
        *,
        properties: Optional["ScaleSettingsInformation"] = None,
        **kwargs
    ):
        """
        :keyword properties: Properties of ClusterUpdate.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.ScaleSettingsInformation
        """
        super(ClusterUpdateParameters, self).__init__(**kwargs)
        self.properties = properties


class ExportSummary(msrest.serialization.Model):
    """ExportSummary.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CsvExportSummary, CocoExportSummary, DatasetExportSummary.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar end_date_time: The time when the export was completed.
    :vartype end_date_time: ~datetime.datetime
    :ivar exported_row_count: The total number of labeled datapoints exported.
    :vartype exported_row_count: long
    :ivar format: Required. [Required] The format of exported labels, also as the
     discriminator.Constant filled by server. Possible values include: "Dataset", "Coco", "CSV".
    :vartype format: str or ~azure.mgmt.machinelearningservices.models.ExportFormatType
    :ivar labeling_job_id: Name and identifier of the job containing exported labels.
    :vartype labeling_job_id: str
    :ivar start_date_time: The time when the export was requested.
    :vartype start_date_time: ~datetime.datetime
    """

    _validation = {
        'end_date_time': {'readonly': True},
        'exported_row_count': {'readonly': True},
        'format': {'required': True},
        'labeling_job_id': {'readonly': True},
        'start_date_time': {'readonly': True},
    }

    _attribute_map = {
        'end_date_time': {'key': 'endDateTime', 'type': 'iso-8601'},
        'exported_row_count': {'key': 'exportedRowCount', 'type': 'long'},
        'format': {'key': 'format', 'type': 'str'},
        'labeling_job_id': {'key': 'labelingJobId', 'type': 'str'},
        'start_date_time': {'key': 'startDateTime', 'type': 'iso-8601'},
    }

    _subtype_map = {
        'format': {'CSV': 'CsvExportSummary', 'Coco': 'CocoExportSummary', 'Dataset': 'DatasetExportSummary'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ExportSummary, self).__init__(**kwargs)
        self.end_date_time = None
        self.exported_row_count = None
        self.format = None  # type: Optional[str]
        self.labeling_job_id = None
        self.start_date_time = None


class CocoExportSummary(ExportSummary):
    """CocoExportSummary.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar end_date_time: The time when the export was completed.
    :vartype end_date_time: ~datetime.datetime
    :ivar exported_row_count: The total number of labeled datapoints exported.
    :vartype exported_row_count: long
    :ivar format: Required. [Required] The format of exported labels, also as the
     discriminator.Constant filled by server. Possible values include: "Dataset", "Coco", "CSV".
    :vartype format: str or ~azure.mgmt.machinelearningservices.models.ExportFormatType
    :ivar labeling_job_id: Name and identifier of the job containing exported labels.
    :vartype labeling_job_id: str
    :ivar start_date_time: The time when the export was requested.
    :vartype start_date_time: ~datetime.datetime
    :ivar container_name: The container name to which the labels will be exported.
    :vartype container_name: str
    :ivar snapshot_path: The output path where the labels will be exported.
    :vartype snapshot_path: str
    """

    _validation = {
        'end_date_time': {'readonly': True},
        'exported_row_count': {'readonly': True},
        'format': {'required': True},
        'labeling_job_id': {'readonly': True},
        'start_date_time': {'readonly': True},
        'container_name': {'readonly': True},
        'snapshot_path': {'readonly': True},
    }

    _attribute_map = {
        'end_date_time': {'key': 'endDateTime', 'type': 'iso-8601'},
        'exported_row_count': {'key': 'exportedRowCount', 'type': 'long'},
        'format': {'key': 'format', 'type': 'str'},
        'labeling_job_id': {'key': 'labelingJobId', 'type': 'str'},
        'start_date_time': {'key': 'startDateTime', 'type': 'iso-8601'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'snapshot_path': {'key': 'snapshotPath', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(CocoExportSummary, self).__init__(**kwargs)
        self.format = 'Coco'  # type: str
        self.container_name = None
        self.snapshot_path = None


class CodeConfiguration(msrest.serialization.Model):
    """Configuration for a scoring code asset.

    All required parameters must be populated in order to send to Azure.

    :ivar code_id: ARM resource ID of the code asset.
    :vartype code_id: str
    :ivar scoring_script: Required. [Required] The script to execute on startup. eg. "score.py".
    :vartype scoring_script: str
    """

    _validation = {
        'scoring_script': {'required': True, 'min_length': 1, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'code_id': {'key': 'codeId', 'type': 'str'},
        'scoring_script': {'key': 'scoringScript', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        scoring_script: str,
        code_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword code_id: ARM resource ID of the code asset.
        :paramtype code_id: str
        :keyword scoring_script: Required. [Required] The script to execute on startup. eg. "score.py".
        :paramtype scoring_script: str
        """
        super(CodeConfiguration, self).__init__(**kwargs)
        self.code_id = code_id
        self.scoring_script = scoring_script


class CodeContainer(Resource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.CodeContainerProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'CodeContainerProperties'},
    }

    def __init__(
        self,
        *,
        properties: "CodeContainerProperties",
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.CodeContainerProperties
        """
        super(CodeContainer, self).__init__(**kwargs)
        self.properties = properties


class CodeContainerProperties(AssetContainer):
    """Container for code asset versions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar latest_version: The latest version inside this container.
    :vartype latest_version: str
    :ivar next_version: The next auto incremental version.
    :vartype next_version: str
    :ivar provisioning_state: Provisioning state for the code container. Possible values include:
     "Succeeded", "Failed", "Canceled", "Creating", "Updating", "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.AssetProvisioningState
    """

    _validation = {
        'latest_version': {'readonly': True},
        'next_version': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'latest_version': {'key': 'latestVersion', 'type': 'str'},
        'next_version': {'key': 'nextVersion', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        is_archived: Optional[bool] = False,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        """
        super(CodeContainerProperties, self).__init__(description=description, properties=properties, tags=tags, is_archived=is_archived, **kwargs)
        self.provisioning_state = None


class CodeContainerResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of CodeContainer entities.

    :ivar next_link: The link to the next page of CodeContainer objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type CodeContainer.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.CodeContainer]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[CodeContainer]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["CodeContainer"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of CodeContainer objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type CodeContainer.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.CodeContainer]
        """
        super(CodeContainerResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class CodeVersion(Resource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.CodeVersionProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'CodeVersionProperties'},
    }

    def __init__(
        self,
        *,
        properties: "CodeVersionProperties",
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.CodeVersionProperties
        """
        super(CodeVersion, self).__init__(**kwargs)
        self.properties = properties


class CodeVersionProperties(AssetBase):
    """Code asset version details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_anonymous: If the name version are system generated (anonymous registration).
    :vartype is_anonymous: bool
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar code_uri: Uri where code is located.
    :vartype code_uri: str
    :ivar provisioning_state: Provisioning state for the code version. Possible values include:
     "Succeeded", "Failed", "Canceled", "Creating", "Updating", "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.AssetProvisioningState
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_anonymous': {'key': 'isAnonymous', 'type': 'bool'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'code_uri': {'key': 'codeUri', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        is_anonymous: Optional[bool] = False,
        is_archived: Optional[bool] = False,
        code_uri: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_anonymous: If the name version are system generated (anonymous registration).
        :paramtype is_anonymous: bool
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword code_uri: Uri where code is located.
        :paramtype code_uri: str
        """
        super(CodeVersionProperties, self).__init__(description=description, properties=properties, tags=tags, is_anonymous=is_anonymous, is_archived=is_archived, **kwargs)
        self.code_uri = code_uri
        self.provisioning_state = None


class CodeVersionResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of CodeVersion entities.

    :ivar next_link: The link to the next page of CodeVersion objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type CodeVersion.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.CodeVersion]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[CodeVersion]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["CodeVersion"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of CodeVersion objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type CodeVersion.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.CodeVersion]
        """
        super(CodeVersionResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class ColumnTransformer(msrest.serialization.Model):
    """Column transformer parameters.

    :ivar fields: Fields to apply transformer logic on.
    :vartype fields: list[str]
    :ivar parameters: Different properties to be passed to transformer.
     Input expected is dictionary of key,value pairs in JSON format.
    :vartype parameters: any
    """

    _attribute_map = {
        'fields': {'key': 'fields', 'type': '[str]'},
        'parameters': {'key': 'parameters', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        fields: Optional[List[str]] = None,
        parameters: Optional[Any] = None,
        **kwargs
    ):
        """
        :keyword fields: Fields to apply transformer logic on.
        :paramtype fields: list[str]
        :keyword parameters: Different properties to be passed to transformer.
         Input expected is dictionary of key,value pairs in JSON format.
        :paramtype parameters: any
        """
        super(ColumnTransformer, self).__init__(**kwargs)
        self.fields = fields
        self.parameters = parameters


class CommandJob(JobBaseProperties):
    """Command job definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar component_id: ARM resource ID of the component resource.
    :vartype component_id: str
    :ivar compute_id: ARM resource ID of the compute resource.
    :vartype compute_id: str
    :ivar display_name: Display name of job.
    :vartype display_name: str
    :ivar experiment_name: The name of the experiment the job belongs to. If not set, the job is
     placed in the "Default" experiment.
    :vartype experiment_name: str
    :ivar identity: Identity configuration. If set, this should be one of AmlToken,
     ManagedIdentity, UserIdentity or null.
     Defaults to AmlToken if null.
    :vartype identity: ~azure.mgmt.machinelearningservices.models.IdentityConfiguration
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar job_type: Required. [Required] Specifies the type of job.Constant filled by server.
     Possible values include: "AutoML", "Command", "Labeling", "Sweep", "Pipeline", "Spark".
    :vartype job_type: str or ~azure.mgmt.machinelearningservices.models.JobType
    :ivar services: List of JobEndpoints.
     For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
    :vartype services: dict[str, ~azure.mgmt.machinelearningservices.models.JobService]
    :ivar status: Status of the job. Possible values include: "NotStarted", "Starting",
     "Provisioning", "Preparing", "Queued", "Running", "Finalizing", "CancelRequested", "Completed",
     "Failed", "Canceled", "NotResponding", "Paused", "Unknown", "Scheduled".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.JobStatus
    :ivar autologger_settings: Distribution configuration of the job. If set, this should be one of
     Mpi, Tensorflow, PyTorch, or null.
    :vartype autologger_settings: ~azure.mgmt.machinelearningservices.models.AutologgerSettings
    :ivar code_id: ARM resource ID of the code asset.
    :vartype code_id: str
    :ivar command: Required. [Required] The command to execute on startup of the job. eg. "python
     train.py".
    :vartype command: str
    :ivar distribution: Distribution configuration of the job. If set, this should be one of Mpi,
     Tensorflow, PyTorch, or null.
    :vartype distribution: ~azure.mgmt.machinelearningservices.models.DistributionConfiguration
    :ivar environment_id: Required. [Required] The ARM resource ID of the Environment specification
     for the job.
    :vartype environment_id: str
    :ivar environment_variables: Environment variables included in the job.
    :vartype environment_variables: dict[str, str]
    :ivar inputs: Mapping of input data bindings used in the job.
    :vartype inputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobInput]
    :ivar limits: Command Job limit.
    :vartype limits: ~azure.mgmt.machinelearningservices.models.CommandJobLimits
    :ivar outputs: Mapping of output data bindings used in the job.
    :vartype outputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobOutput]
    :ivar parameters: Input parameters.
    :vartype parameters: any
    :ivar resources: Compute Resource configuration for the job.
    :vartype resources: ~azure.mgmt.machinelearningservices.models.JobResourceConfiguration
    """

    _validation = {
        'job_type': {'required': True},
        'status': {'readonly': True},
        'command': {'required': True, 'min_length': 1, 'pattern': r'[a-zA-Z0-9_]'},
        'environment_id': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'parameters': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'component_id': {'key': 'componentId', 'type': 'str'},
        'compute_id': {'key': 'computeId', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'experiment_name': {'key': 'experimentName', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'IdentityConfiguration'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'job_type': {'key': 'jobType', 'type': 'str'},
        'services': {'key': 'services', 'type': '{JobService}'},
        'status': {'key': 'status', 'type': 'str'},
        'autologger_settings': {'key': 'autologgerSettings', 'type': 'AutologgerSettings'},
        'code_id': {'key': 'codeId', 'type': 'str'},
        'command': {'key': 'command', 'type': 'str'},
        'distribution': {'key': 'distribution', 'type': 'DistributionConfiguration'},
        'environment_id': {'key': 'environmentId', 'type': 'str'},
        'environment_variables': {'key': 'environmentVariables', 'type': '{str}'},
        'inputs': {'key': 'inputs', 'type': '{JobInput}'},
        'limits': {'key': 'limits', 'type': 'CommandJobLimits'},
        'outputs': {'key': 'outputs', 'type': '{JobOutput}'},
        'parameters': {'key': 'parameters', 'type': 'object'},
        'resources': {'key': 'resources', 'type': 'JobResourceConfiguration'},
    }

    def __init__(
        self,
        *,
        command: str,
        environment_id: str,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        component_id: Optional[str] = None,
        compute_id: Optional[str] = None,
        display_name: Optional[str] = None,
        experiment_name: Optional[str] = "Default",
        identity: Optional["IdentityConfiguration"] = None,
        is_archived: Optional[bool] = False,
        services: Optional[Dict[str, "JobService"]] = None,
        autologger_settings: Optional["AutologgerSettings"] = None,
        code_id: Optional[str] = None,
        distribution: Optional["DistributionConfiguration"] = None,
        environment_variables: Optional[Dict[str, str]] = None,
        inputs: Optional[Dict[str, "JobInput"]] = None,
        limits: Optional["CommandJobLimits"] = None,
        outputs: Optional[Dict[str, "JobOutput"]] = None,
        resources: Optional["JobResourceConfiguration"] = None,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword component_id: ARM resource ID of the component resource.
        :paramtype component_id: str
        :keyword compute_id: ARM resource ID of the compute resource.
        :paramtype compute_id: str
        :keyword display_name: Display name of job.
        :paramtype display_name: str
        :keyword experiment_name: The name of the experiment the job belongs to. If not set, the job is
         placed in the "Default" experiment.
        :paramtype experiment_name: str
        :keyword identity: Identity configuration. If set, this should be one of AmlToken,
         ManagedIdentity, UserIdentity or null.
         Defaults to AmlToken if null.
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.IdentityConfiguration
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword services: List of JobEndpoints.
         For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        :paramtype services: dict[str, ~azure.mgmt.machinelearningservices.models.JobService]
        :keyword autologger_settings: Distribution configuration of the job. If set, this should be one
         of Mpi, Tensorflow, PyTorch, or null.
        :paramtype autologger_settings: ~azure.mgmt.machinelearningservices.models.AutologgerSettings
        :keyword code_id: ARM resource ID of the code asset.
        :paramtype code_id: str
        :keyword command: Required. [Required] The command to execute on startup of the job. eg.
         "python train.py".
        :paramtype command: str
        :keyword distribution: Distribution configuration of the job. If set, this should be one of
         Mpi, Tensorflow, PyTorch, or null.
        :paramtype distribution: ~azure.mgmt.machinelearningservices.models.DistributionConfiguration
        :keyword environment_id: Required. [Required] The ARM resource ID of the Environment
         specification for the job.
        :paramtype environment_id: str
        :keyword environment_variables: Environment variables included in the job.
        :paramtype environment_variables: dict[str, str]
        :keyword inputs: Mapping of input data bindings used in the job.
        :paramtype inputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobInput]
        :keyword limits: Command Job limit.
        :paramtype limits: ~azure.mgmt.machinelearningservices.models.CommandJobLimits
        :keyword outputs: Mapping of output data bindings used in the job.
        :paramtype outputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobOutput]
        :keyword resources: Compute Resource configuration for the job.
        :paramtype resources: ~azure.mgmt.machinelearningservices.models.JobResourceConfiguration
        """
        super(CommandJob, self).__init__(description=description, properties=properties, tags=tags, component_id=component_id, compute_id=compute_id, display_name=display_name, experiment_name=experiment_name, identity=identity, is_archived=is_archived, services=services, **kwargs)
        self.job_type = 'Command'  # type: str
        self.autologger_settings = autologger_settings
        self.code_id = code_id
        self.command = command
        self.distribution = distribution
        self.environment_id = environment_id
        self.environment_variables = environment_variables
        self.inputs = inputs
        self.limits = limits
        self.outputs = outputs
        self.parameters = None
        self.resources = resources


class JobLimits(msrest.serialization.Model):
    """JobLimits.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CommandJobLimits, SweepJobLimits.

    All required parameters must be populated in order to send to Azure.

    :ivar job_limits_type: Required. [Required] JobLimit type.Constant filled by server. Possible
     values include: "Command", "Sweep".
    :vartype job_limits_type: str or ~azure.mgmt.machinelearningservices.models.JobLimitsType
    :ivar timeout: The max run duration in ISO 8601 format, after which the job will be cancelled.
     Only supports duration with precision as low as Seconds.
    :vartype timeout: ~datetime.timedelta
    """

    _validation = {
        'job_limits_type': {'required': True},
    }

    _attribute_map = {
        'job_limits_type': {'key': 'jobLimitsType', 'type': 'str'},
        'timeout': {'key': 'timeout', 'type': 'duration'},
    }

    _subtype_map = {
        'job_limits_type': {'Command': 'CommandJobLimits', 'Sweep': 'SweepJobLimits'}
    }

    def __init__(
        self,
        *,
        timeout: Optional[datetime.timedelta] = None,
        **kwargs
    ):
        """
        :keyword timeout: The max run duration in ISO 8601 format, after which the job will be
         cancelled. Only supports duration with precision as low as Seconds.
        :paramtype timeout: ~datetime.timedelta
        """
        super(JobLimits, self).__init__(**kwargs)
        self.job_limits_type = None  # type: Optional[str]
        self.timeout = timeout


class CommandJobLimits(JobLimits):
    """Command Job limit class.

    All required parameters must be populated in order to send to Azure.

    :ivar job_limits_type: Required. [Required] JobLimit type.Constant filled by server. Possible
     values include: "Command", "Sweep".
    :vartype job_limits_type: str or ~azure.mgmt.machinelearningservices.models.JobLimitsType
    :ivar timeout: The max run duration in ISO 8601 format, after which the job will be cancelled.
     Only supports duration with precision as low as Seconds.
    :vartype timeout: ~datetime.timedelta
    """

    _validation = {
        'job_limits_type': {'required': True},
    }

    _attribute_map = {
        'job_limits_type': {'key': 'jobLimitsType', 'type': 'str'},
        'timeout': {'key': 'timeout', 'type': 'duration'},
    }

    def __init__(
        self,
        *,
        timeout: Optional[datetime.timedelta] = None,
        **kwargs
    ):
        """
        :keyword timeout: The max run duration in ISO 8601 format, after which the job will be
         cancelled. Only supports duration with precision as low as Seconds.
        :paramtype timeout: ~datetime.timedelta
        """
        super(CommandJobLimits, self).__init__(timeout=timeout, **kwargs)
        self.job_limits_type = 'Command'  # type: str


class ComponentContainer(Resource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.ComponentContainerProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'ComponentContainerProperties'},
    }

    def __init__(
        self,
        *,
        properties: "ComponentContainerProperties",
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.ComponentContainerProperties
        """
        super(ComponentContainer, self).__init__(**kwargs)
        self.properties = properties


class ComponentContainerProperties(AssetContainer):
    """Component container definition.


.. raw:: html

   <see href="https://learn.microsoft.com/azure/machine-learning/reference-yaml-component-command" />.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar latest_version: The latest version inside this container.
    :vartype latest_version: str
    :ivar next_version: The next auto incremental version.
    :vartype next_version: str
    :ivar provisioning_state: Provisioning state for the component container. Possible values
     include: "Succeeded", "Failed", "Canceled", "Creating", "Updating", "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.AssetProvisioningState
    """

    _validation = {
        'latest_version': {'readonly': True},
        'next_version': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'latest_version': {'key': 'latestVersion', 'type': 'str'},
        'next_version': {'key': 'nextVersion', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        is_archived: Optional[bool] = False,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        """
        super(ComponentContainerProperties, self).__init__(description=description, properties=properties, tags=tags, is_archived=is_archived, **kwargs)
        self.provisioning_state = None


class ComponentContainerResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of ComponentContainer entities.

    :ivar next_link: The link to the next page of ComponentContainer objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type ComponentContainer.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.ComponentContainer]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[ComponentContainer]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["ComponentContainer"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of ComponentContainer objects. If null, there are
         no additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type ComponentContainer.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.ComponentContainer]
        """
        super(ComponentContainerResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class ComponentVersion(Resource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.ComponentVersionProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'ComponentVersionProperties'},
    }

    def __init__(
        self,
        *,
        properties: "ComponentVersionProperties",
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.ComponentVersionProperties
        """
        super(ComponentVersion, self).__init__(**kwargs)
        self.properties = properties


class ComponentVersionProperties(AssetBase):
    """Definition of a component version: defines resources that span component types.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_anonymous: If the name version are system generated (anonymous registration).
    :vartype is_anonymous: bool
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar component_spec: Defines Component definition details.


     .. raw:: html

        <see
     href="https://learn.microsoft.com/azure/machine-learning/reference-yaml-component-command"
     />.
    :vartype component_spec: any
    :ivar provisioning_state: Provisioning state for the component version. Possible values
     include: "Succeeded", "Failed", "Canceled", "Creating", "Updating", "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.AssetProvisioningState
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_anonymous': {'key': 'isAnonymous', 'type': 'bool'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'component_spec': {'key': 'componentSpec', 'type': 'object'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        is_anonymous: Optional[bool] = False,
        is_archived: Optional[bool] = False,
        component_spec: Optional[Any] = None,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_anonymous: If the name version are system generated (anonymous registration).
        :paramtype is_anonymous: bool
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword component_spec: Defines Component definition details.


         .. raw:: html

            <see
         href="https://learn.microsoft.com/azure/machine-learning/reference-yaml-component-command"
         />.
        :paramtype component_spec: any
        """
        super(ComponentVersionProperties, self).__init__(description=description, properties=properties, tags=tags, is_anonymous=is_anonymous, is_archived=is_archived, **kwargs)
        self.component_spec = component_spec
        self.provisioning_state = None


class ComponentVersionResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of ComponentVersion entities.

    :ivar next_link: The link to the next page of ComponentVersion objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type ComponentVersion.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.ComponentVersion]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[ComponentVersion]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["ComponentVersion"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of ComponentVersion objects. If null, there are
         no additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type ComponentVersion.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.ComponentVersion]
        """
        super(ComponentVersionResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class ComputeInstanceSchema(msrest.serialization.Model):
    """Properties(top level) of ComputeInstance.

    :ivar properties: Properties of ComputeInstance.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.ComputeInstanceProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'ComputeInstanceProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["ComputeInstanceProperties"] = None,
        **kwargs
    ):
        """
        :keyword properties: Properties of ComputeInstance.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.ComputeInstanceProperties
        """
        super(ComputeInstanceSchema, self).__init__(**kwargs)
        self.properties = properties


class ComputeInstance(Compute, ComputeInstanceSchema):
    """An Azure Machine Learning compute instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar properties: Properties of ComputeInstance.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.ComputeInstanceProperties
    :ivar compute_type: Required. The type of compute.Constant filled by server. Possible values
     include: "AKS", "Kubernetes", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine",
     "HDInsight", "Databricks", "DataLakeAnalytics", "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :ivar compute_location: Location for the underlying compute.
    :vartype compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values are Unknown,
     Updating, Provisioning, Succeeded, and Failed. Possible values include: "Unknown", "Updating",
     "Creating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ComputeProvisioningState
    :ivar description: The description of the Machine Learning compute.
    :vartype description: str
    :ivar created_on: The time at which the compute was created.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: The time at which the compute was last modified.
    :vartype modified_on: ~datetime.datetime
    :ivar resource_id: ARM resource id of the underlying compute.
    :vartype resource_id: str
    :ivar provisioning_errors: Errors during provisioning.
    :vartype provisioning_errors: list[~azure.mgmt.machinelearningservices.models.ErrorResponse]
    :ivar is_attached_compute: Indicating whether the compute was provisioned by user and brought
     from outside if true, or machine learning service provisioned it if false.
    :vartype is_attached_compute: bool
    :ivar disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI
     and AAD exclusively for authentication.
    :vartype disable_local_auth: bool
    """

    _validation = {
        'compute_type': {'required': True},
        'compute_location': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'modified_on': {'readonly': True},
        'provisioning_errors': {'readonly': True},
        'is_attached_compute': {'readonly': True},
        'disable_local_auth': {'readonly': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'ComputeInstanceProperties'},
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'compute_location': {'key': 'computeLocation', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'modified_on': {'key': 'modifiedOn', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'provisioning_errors': {'key': 'provisioningErrors', 'type': '[ErrorResponse]'},
        'is_attached_compute': {'key': 'isAttachedCompute', 'type': 'bool'},
        'disable_local_auth': {'key': 'disableLocalAuth', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        properties: Optional["ComputeInstanceProperties"] = None,
        description: Optional[str] = None,
        resource_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword properties: Properties of ComputeInstance.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.ComputeInstanceProperties
        :keyword description: The description of the Machine Learning compute.
        :paramtype description: str
        :keyword resource_id: ARM resource id of the underlying compute.
        :paramtype resource_id: str
        """
        super(ComputeInstance, self).__init__(description=description, resource_id=resource_id, properties=properties, **kwargs)
        self.properties = properties
        self.compute_type = 'ComputeInstance'  # type: str
        self.compute_location = None
        self.provisioning_state = None
        self.description = description
        self.created_on = None
        self.modified_on = None
        self.resource_id = resource_id
        self.provisioning_errors = None
        self.is_attached_compute = None
        self.disable_local_auth = None


class ComputeInstanceApplication(msrest.serialization.Model):
    """Defines an Aml Instance application and its connectivity endpoint URI.

    :ivar display_name: Name of the ComputeInstance application.
    :vartype display_name: str
    :ivar endpoint_uri: Application' endpoint URI.
    :vartype endpoint_uri: str
    """

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'endpoint_uri': {'key': 'endpointUri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        endpoint_uri: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword display_name: Name of the ComputeInstance application.
        :paramtype display_name: str
        :keyword endpoint_uri: Application' endpoint URI.
        :paramtype endpoint_uri: str
        """
        super(ComputeInstanceApplication, self).__init__(**kwargs)
        self.display_name = display_name
        self.endpoint_uri = endpoint_uri


class ComputeInstanceAutologgerSettings(msrest.serialization.Model):
    """Specifies settings for autologger.

    :ivar mlflow_autologger: Indicates whether mlflow autologger is enabled for notebooks. Possible
     values include: "Enabled", "Disabled".
    :vartype mlflow_autologger: str or ~azure.mgmt.machinelearningservices.models.MlflowAutologger
    """

    _attribute_map = {
        'mlflow_autologger': {'key': 'mlflowAutologger', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        mlflow_autologger: Optional[Union[str, "MlflowAutologger"]] = None,
        **kwargs
    ):
        """
        :keyword mlflow_autologger: Indicates whether mlflow autologger is enabled for notebooks.
         Possible values include: "Enabled", "Disabled".
        :paramtype mlflow_autologger: str or
         ~azure.mgmt.machinelearningservices.models.MlflowAutologger
        """
        super(ComputeInstanceAutologgerSettings, self).__init__(**kwargs)
        self.mlflow_autologger = mlflow_autologger


class ComputeInstanceConnectivityEndpoints(msrest.serialization.Model):
    """Defines all connectivity endpoints and properties for an ComputeInstance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar public_ip_address: Public IP Address of this ComputeInstance.
    :vartype public_ip_address: str
    :ivar private_ip_address: Private IP Address of this ComputeInstance (local to the VNET in
     which the compute instance is deployed).
    :vartype private_ip_address: str
    """

    _validation = {
        'public_ip_address': {'readonly': True},
        'private_ip_address': {'readonly': True},
    }

    _attribute_map = {
        'public_ip_address': {'key': 'publicIpAddress', 'type': 'str'},
        'private_ip_address': {'key': 'privateIpAddress', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ComputeInstanceConnectivityEndpoints, self).__init__(**kwargs)
        self.public_ip_address = None
        self.private_ip_address = None


class ComputeInstanceContainer(msrest.serialization.Model):
    """Defines an Aml Instance container.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the ComputeInstance container.
    :vartype name: str
    :ivar autosave: Auto save settings. Possible values include: "None", "Local", "Remote".
    :vartype autosave: str or ~azure.mgmt.machinelearningservices.models.Autosave
    :ivar gpu: Information of GPU.
    :vartype gpu: str
    :ivar network: network of this container. Possible values include: "Bridge", "Host".
    :vartype network: str or ~azure.mgmt.machinelearningservices.models.Network
    :ivar environment: Environment information of this container.
    :vartype environment: ~azure.mgmt.machinelearningservices.models.ComputeInstanceEnvironmentInfo
    :ivar services: services of this containers.
    :vartype services: list[any]
    """

    _validation = {
        'services': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'autosave': {'key': 'autosave', 'type': 'str'},
        'gpu': {'key': 'gpu', 'type': 'str'},
        'network': {'key': 'network', 'type': 'str'},
        'environment': {'key': 'environment', 'type': 'ComputeInstanceEnvironmentInfo'},
        'services': {'key': 'services', 'type': '[object]'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        autosave: Optional[Union[str, "Autosave"]] = None,
        gpu: Optional[str] = None,
        network: Optional[Union[str, "Network"]] = None,
        environment: Optional["ComputeInstanceEnvironmentInfo"] = None,
        **kwargs
    ):
        """
        :keyword name: Name of the ComputeInstance container.
        :paramtype name: str
        :keyword autosave: Auto save settings. Possible values include: "None", "Local", "Remote".
        :paramtype autosave: str or ~azure.mgmt.machinelearningservices.models.Autosave
        :keyword gpu: Information of GPU.
        :paramtype gpu: str
        :keyword network: network of this container. Possible values include: "Bridge", "Host".
        :paramtype network: str or ~azure.mgmt.machinelearningservices.models.Network
        :keyword environment: Environment information of this container.
        :paramtype environment:
         ~azure.mgmt.machinelearningservices.models.ComputeInstanceEnvironmentInfo
        """
        super(ComputeInstanceContainer, self).__init__(**kwargs)
        self.name = name
        self.autosave = autosave
        self.gpu = gpu
        self.network = network
        self.environment = environment
        self.services = None


class ComputeInstanceCreatedBy(msrest.serialization.Model):
    """Describes information on user who created this ComputeInstance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar user_name: Name of the user.
    :vartype user_name: str
    :ivar user_org_id: Uniquely identifies user' Azure Active Directory organization.
    :vartype user_org_id: str
    :ivar user_id: Uniquely identifies the user within his/her organization.
    :vartype user_id: str
    """

    _validation = {
        'user_name': {'readonly': True},
        'user_org_id': {'readonly': True},
        'user_id': {'readonly': True},
    }

    _attribute_map = {
        'user_name': {'key': 'userName', 'type': 'str'},
        'user_org_id': {'key': 'userOrgId', 'type': 'str'},
        'user_id': {'key': 'userId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ComputeInstanceCreatedBy, self).__init__(**kwargs)
        self.user_name = None
        self.user_org_id = None
        self.user_id = None


class ComputeInstanceDataDisk(msrest.serialization.Model):
    """Defines an Aml Instance DataDisk.

    :ivar caching: Caching type of Data Disk. Possible values include: "None", "ReadOnly",
     "ReadWrite".
    :vartype caching: str or ~azure.mgmt.machinelearningservices.models.Caching
    :ivar disk_size_gb: The initial disk size in gigabytes.
    :vartype disk_size_gb: int
    :ivar lun: The lun is used to uniquely identify each data disk. If attaching multiple disks,
     each should have a distinct lun.
    :vartype lun: int
    :ivar storage_account_type: type of this storage account. Possible values include:
     "Standard_LRS", "Premium_LRS". Default value: "Standard_LRS".
    :vartype storage_account_type: str or
     ~azure.mgmt.machinelearningservices.models.StorageAccountType
    """

    _attribute_map = {
        'caching': {'key': 'caching', 'type': 'str'},
        'disk_size_gb': {'key': 'diskSizeGB', 'type': 'int'},
        'lun': {'key': 'lun', 'type': 'int'},
        'storage_account_type': {'key': 'storageAccountType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        caching: Optional[Union[str, "Caching"]] = None,
        disk_size_gb: Optional[int] = None,
        lun: Optional[int] = None,
        storage_account_type: Optional[Union[str, "StorageAccountType"]] = "Standard_LRS",
        **kwargs
    ):
        """
        :keyword caching: Caching type of Data Disk. Possible values include: "None", "ReadOnly",
         "ReadWrite".
        :paramtype caching: str or ~azure.mgmt.machinelearningservices.models.Caching
        :keyword disk_size_gb: The initial disk size in gigabytes.
        :paramtype disk_size_gb: int
        :keyword lun: The lun is used to uniquely identify each data disk. If attaching multiple disks,
         each should have a distinct lun.
        :paramtype lun: int
        :keyword storage_account_type: type of this storage account. Possible values include:
         "Standard_LRS", "Premium_LRS". Default value: "Standard_LRS".
        :paramtype storage_account_type: str or
         ~azure.mgmt.machinelearningservices.models.StorageAccountType
        """
        super(ComputeInstanceDataDisk, self).__init__(**kwargs)
        self.caching = caching
        self.disk_size_gb = disk_size_gb
        self.lun = lun
        self.storage_account_type = storage_account_type


class ComputeInstanceDataMount(msrest.serialization.Model):
    """Defines an Aml Instance DataMount.

    :ivar source: Source of the ComputeInstance data mount.
    :vartype source: str
    :ivar source_type: Data source type. Possible values include: "Dataset", "Datastore", "URI".
    :vartype source_type: str or ~azure.mgmt.machinelearningservices.models.SourceType
    :ivar mount_name: name of the ComputeInstance data mount.
    :vartype mount_name: str
    :ivar mount_action: Mount Action. Possible values include: "Mount", "Unmount".
    :vartype mount_action: str or ~azure.mgmt.machinelearningservices.models.MountAction
    :ivar created_by: who this data mount created by.
    :vartype created_by: str
    :ivar mount_path: Path of this data mount.
    :vartype mount_path: str
    :ivar mount_state: Mount state. Possible values include: "MountRequested", "Mounted",
     "MountFailed", "UnmountRequested", "UnmountFailed", "Unmounted".
    :vartype mount_state: str or ~azure.mgmt.machinelearningservices.models.MountState
    :ivar mounted_on: The time when the disk mounted.
    :vartype mounted_on: ~datetime.datetime
    :ivar error: Error of this data mount.
    :vartype error: str
    """

    _attribute_map = {
        'source': {'key': 'source', 'type': 'str'},
        'source_type': {'key': 'sourceType', 'type': 'str'},
        'mount_name': {'key': 'mountName', 'type': 'str'},
        'mount_action': {'key': 'mountAction', 'type': 'str'},
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'mount_path': {'key': 'mountPath', 'type': 'str'},
        'mount_state': {'key': 'mountState', 'type': 'str'},
        'mounted_on': {'key': 'mountedOn', 'type': 'iso-8601'},
        'error': {'key': 'error', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source: Optional[str] = None,
        source_type: Optional[Union[str, "SourceType"]] = None,
        mount_name: Optional[str] = None,
        mount_action: Optional[Union[str, "MountAction"]] = None,
        created_by: Optional[str] = None,
        mount_path: Optional[str] = None,
        mount_state: Optional[Union[str, "MountState"]] = None,
        mounted_on: Optional[datetime.datetime] = None,
        error: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword source: Source of the ComputeInstance data mount.
        :paramtype source: str
        :keyword source_type: Data source type. Possible values include: "Dataset", "Datastore", "URI".
        :paramtype source_type: str or ~azure.mgmt.machinelearningservices.models.SourceType
        :keyword mount_name: name of the ComputeInstance data mount.
        :paramtype mount_name: str
        :keyword mount_action: Mount Action. Possible values include: "Mount", "Unmount".
        :paramtype mount_action: str or ~azure.mgmt.machinelearningservices.models.MountAction
        :keyword created_by: who this data mount created by.
        :paramtype created_by: str
        :keyword mount_path: Path of this data mount.
        :paramtype mount_path: str
        :keyword mount_state: Mount state. Possible values include: "MountRequested", "Mounted",
         "MountFailed", "UnmountRequested", "UnmountFailed", "Unmounted".
        :paramtype mount_state: str or ~azure.mgmt.machinelearningservices.models.MountState
        :keyword mounted_on: The time when the disk mounted.
        :paramtype mounted_on: ~datetime.datetime
        :keyword error: Error of this data mount.
        :paramtype error: str
        """
        super(ComputeInstanceDataMount, self).__init__(**kwargs)
        self.source = source
        self.source_type = source_type
        self.mount_name = mount_name
        self.mount_action = mount_action
        self.created_by = created_by
        self.mount_path = mount_path
        self.mount_state = mount_state
        self.mounted_on = mounted_on
        self.error = error


class ComputeInstanceEnvironmentInfo(msrest.serialization.Model):
    """Environment information.

    :ivar name: name of environment.
    :vartype name: str
    :ivar version: version of environment.
    :vartype version: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        version: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: name of environment.
        :paramtype name: str
        :keyword version: version of environment.
        :paramtype version: str
        """
        super(ComputeInstanceEnvironmentInfo, self).__init__(**kwargs)
        self.name = name
        self.version = version


class ComputeInstanceLastOperation(msrest.serialization.Model):
    """The last operation on ComputeInstance.

    :ivar operation_name: Name of the last operation. Possible values include: "Create", "Start",
     "Stop", "Restart", "Reimage", "Delete".
    :vartype operation_name: str or ~azure.mgmt.machinelearningservices.models.OperationName
    :ivar operation_time: Time of the last operation.
    :vartype operation_time: ~datetime.datetime
    :ivar operation_status: Operation status. Possible values include: "InProgress", "Succeeded",
     "CreateFailed", "StartFailed", "StopFailed", "RestartFailed", "ReimageFailed", "DeleteFailed".
    :vartype operation_status: str or ~azure.mgmt.machinelearningservices.models.OperationStatus
    :ivar operation_trigger: Trigger of operation. Possible values include: "User", "Schedule",
     "IdleShutdown".
    :vartype operation_trigger: str or ~azure.mgmt.machinelearningservices.models.OperationTrigger
    """

    _attribute_map = {
        'operation_name': {'key': 'operationName', 'type': 'str'},
        'operation_time': {'key': 'operationTime', 'type': 'iso-8601'},
        'operation_status': {'key': 'operationStatus', 'type': 'str'},
        'operation_trigger': {'key': 'operationTrigger', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        operation_name: Optional[Union[str, "OperationName"]] = None,
        operation_time: Optional[datetime.datetime] = None,
        operation_status: Optional[Union[str, "OperationStatus"]] = None,
        operation_trigger: Optional[Union[str, "OperationTrigger"]] = None,
        **kwargs
    ):
        """
        :keyword operation_name: Name of the last operation. Possible values include: "Create",
         "Start", "Stop", "Restart", "Reimage", "Delete".
        :paramtype operation_name: str or ~azure.mgmt.machinelearningservices.models.OperationName
        :keyword operation_time: Time of the last operation.
        :paramtype operation_time: ~datetime.datetime
        :keyword operation_status: Operation status. Possible values include: "InProgress",
         "Succeeded", "CreateFailed", "StartFailed", "StopFailed", "RestartFailed", "ReimageFailed",
         "DeleteFailed".
        :paramtype operation_status: str or ~azure.mgmt.machinelearningservices.models.OperationStatus
        :keyword operation_trigger: Trigger of operation. Possible values include: "User", "Schedule",
         "IdleShutdown".
        :paramtype operation_trigger: str or
         ~azure.mgmt.machinelearningservices.models.OperationTrigger
        """
        super(ComputeInstanceLastOperation, self).__init__(**kwargs)
        self.operation_name = operation_name
        self.operation_time = operation_time
        self.operation_status = operation_status
        self.operation_trigger = operation_trigger


class ComputeInstanceProperties(msrest.serialization.Model):
    """Compute Instance properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar vm_size: Virtual Machine Size.
    :vartype vm_size: str
    :ivar subnet: Virtual network subnet resource ID the compute nodes belong to.
    :vartype subnet: ~azure.mgmt.machinelearningservices.models.ResourceId
    :ivar application_sharing_policy: Policy for sharing applications on this compute instance
     among users of parent workspace. If Personal, only the creator can access applications on this
     compute instance. When Shared, any workspace user can access applications on this instance
     depending on his/her assigned role. Possible values include: "Personal", "Shared". Default
     value: "Shared".
    :vartype application_sharing_policy: str or
     ~azure.mgmt.machinelearningservices.models.ApplicationSharingPolicy
    :ivar autologger_settings: Specifies settings for autologger.
    :vartype autologger_settings:
     ~azure.mgmt.machinelearningservices.models.ComputeInstanceAutologgerSettings
    :ivar ssh_settings: Specifies policy and settings for SSH access.
    :vartype ssh_settings: ~azure.mgmt.machinelearningservices.models.ComputeInstanceSshSettings
    :ivar custom_services: List of Custom Services added to the compute.
    :vartype custom_services: list[~azure.mgmt.machinelearningservices.models.CustomService]
    :ivar os_image_metadata: Returns metadata about the operating system image for this compute
     instance.
    :vartype os_image_metadata: ~azure.mgmt.machinelearningservices.models.ImageMetadata
    :ivar connectivity_endpoints: Describes all connectivity endpoints available for this
     ComputeInstance.
    :vartype connectivity_endpoints:
     ~azure.mgmt.machinelearningservices.models.ComputeInstanceConnectivityEndpoints
    :ivar applications: Describes available applications and their endpoints on this
     ComputeInstance.
    :vartype applications:
     list[~azure.mgmt.machinelearningservices.models.ComputeInstanceApplication]
    :ivar created_by: Describes information on user who created this ComputeInstance.
    :vartype created_by: ~azure.mgmt.machinelearningservices.models.ComputeInstanceCreatedBy
    :ivar errors: Collection of errors encountered on this ComputeInstance.
    :vartype errors: list[~azure.mgmt.machinelearningservices.models.ErrorResponse]
    :ivar state: The current state of this ComputeInstance. Possible values include: "Creating",
     "CreateFailed", "Deleting", "Running", "Restarting", "JobRunning", "SettingUp", "SetupFailed",
     "Starting", "Stopped", "Stopping", "UserSettingUp", "UserSetupFailed", "Unknown", "Unusable".
    :vartype state: str or ~azure.mgmt.machinelearningservices.models.ComputeInstanceState
    :ivar compute_instance_authorization_type: The Compute Instance Authorization type. Available
     values are personal (default). Possible values include: "personal". Default value: "personal".
    :vartype compute_instance_authorization_type: str or
     ~azure.mgmt.machinelearningservices.models.ComputeInstanceAuthorizationType
    :ivar personal_compute_instance_settings: Settings for a personal compute instance.
    :vartype personal_compute_instance_settings:
     ~azure.mgmt.machinelearningservices.models.PersonalComputeInstanceSettings
    :ivar setup_scripts: Details of customized scripts to execute for setting up the cluster.
    :vartype setup_scripts: ~azure.mgmt.machinelearningservices.models.SetupScripts
    :ivar last_operation: The last operation on ComputeInstance.
    :vartype last_operation:
     ~azure.mgmt.machinelearningservices.models.ComputeInstanceLastOperation
    :ivar schedules: The list of schedules to be applied on the computes.
    :vartype schedules: ~azure.mgmt.machinelearningservices.models.ComputeSchedules
    :ivar idle_time_before_shutdown: Stops compute instance after user defined period of
     inactivity. Time is defined in ISO8601 format. Minimum is 15 min, maximum is 3 days.
    :vartype idle_time_before_shutdown: str
    :ivar enable_node_public_ip: Enable or disable node public IP address provisioning. Possible
     values are: Possible values are: true - Indicates that the compute nodes will have public IPs
     provisioned. false - Indicates that the compute nodes will have a private endpoint and no
     public IPs.
    :vartype enable_node_public_ip: bool
    :ivar containers: Describes informations of containers on this ComputeInstance.
    :vartype containers: list[~azure.mgmt.machinelearningservices.models.ComputeInstanceContainer]
    :ivar data_disks: Describes informations of dataDisks on this ComputeInstance.
    :vartype data_disks: list[~azure.mgmt.machinelearningservices.models.ComputeInstanceDataDisk]
    :ivar data_mounts: Describes informations of dataMounts on this ComputeInstance.
    :vartype data_mounts: list[~azure.mgmt.machinelearningservices.models.ComputeInstanceDataMount]
    :ivar versions: ComputeInstance version.
    :vartype versions: ~azure.mgmt.machinelearningservices.models.ComputeInstanceVersion
    """

    _validation = {
        'os_image_metadata': {'readonly': True},
        'connectivity_endpoints': {'readonly': True},
        'applications': {'readonly': True},
        'created_by': {'readonly': True},
        'errors': {'readonly': True},
        'state': {'readonly': True},
        'last_operation': {'readonly': True},
        'containers': {'readonly': True},
        'data_disks': {'readonly': True},
        'data_mounts': {'readonly': True},
        'versions': {'readonly': True},
    }

    _attribute_map = {
        'vm_size': {'key': 'vmSize', 'type': 'str'},
        'subnet': {'key': 'subnet', 'type': 'ResourceId'},
        'application_sharing_policy': {'key': 'applicationSharingPolicy', 'type': 'str'},
        'autologger_settings': {'key': 'autologgerSettings', 'type': 'ComputeInstanceAutologgerSettings'},
        'ssh_settings': {'key': 'sshSettings', 'type': 'ComputeInstanceSshSettings'},
        'custom_services': {'key': 'customServices', 'type': '[CustomService]'},
        'os_image_metadata': {'key': 'osImageMetadata', 'type': 'ImageMetadata'},
        'connectivity_endpoints': {'key': 'connectivityEndpoints', 'type': 'ComputeInstanceConnectivityEndpoints'},
        'applications': {'key': 'applications', 'type': '[ComputeInstanceApplication]'},
        'created_by': {'key': 'createdBy', 'type': 'ComputeInstanceCreatedBy'},
        'errors': {'key': 'errors', 'type': '[ErrorResponse]'},
        'state': {'key': 'state', 'type': 'str'},
        'compute_instance_authorization_type': {'key': 'computeInstanceAuthorizationType', 'type': 'str'},
        'personal_compute_instance_settings': {'key': 'personalComputeInstanceSettings', 'type': 'PersonalComputeInstanceSettings'},
        'setup_scripts': {'key': 'setupScripts', 'type': 'SetupScripts'},
        'last_operation': {'key': 'lastOperation', 'type': 'ComputeInstanceLastOperation'},
        'schedules': {'key': 'schedules', 'type': 'ComputeSchedules'},
        'idle_time_before_shutdown': {'key': 'idleTimeBeforeShutdown', 'type': 'str'},
        'enable_node_public_ip': {'key': 'enableNodePublicIp', 'type': 'bool'},
        'containers': {'key': 'containers', 'type': '[ComputeInstanceContainer]'},
        'data_disks': {'key': 'dataDisks', 'type': '[ComputeInstanceDataDisk]'},
        'data_mounts': {'key': 'dataMounts', 'type': '[ComputeInstanceDataMount]'},
        'versions': {'key': 'versions', 'type': 'ComputeInstanceVersion'},
    }

    def __init__(
        self,
        *,
        vm_size: Optional[str] = None,
        subnet: Optional["ResourceId"] = None,
        application_sharing_policy: Optional[Union[str, "ApplicationSharingPolicy"]] = "Shared",
        autologger_settings: Optional["ComputeInstanceAutologgerSettings"] = None,
        ssh_settings: Optional["ComputeInstanceSshSettings"] = None,
        custom_services: Optional[List["CustomService"]] = None,
        compute_instance_authorization_type: Optional[Union[str, "ComputeInstanceAuthorizationType"]] = "personal",
        personal_compute_instance_settings: Optional["PersonalComputeInstanceSettings"] = None,
        setup_scripts: Optional["SetupScripts"] = None,
        idle_time_before_shutdown: Optional[str] = None,
        enable_node_public_ip: Optional[bool] = None,
        schedules: Optional["ComputeSchedules"] = None,
        **kwargs
    ):
        """
        :keyword vm_size: Virtual Machine Size.
        :paramtype vm_size: str
        :keyword subnet: Virtual network subnet resource ID the compute nodes belong to.
        :paramtype subnet: ~azure.mgmt.machinelearningservices.models.ResourceId
        :keyword application_sharing_policy: Policy for sharing applications on this compute instance
         among users of parent workspace. If Personal, only the creator can access applications on this
         compute instance. When Shared, any workspace user can access applications on this instance
         depending on his/her assigned role. Possible values include: "Personal", "Shared". Default
         value: "Shared".
        :paramtype application_sharing_policy: str or
         ~azure.mgmt.machinelearningservices.models.ApplicationSharingPolicy
        :keyword autologger_settings: Specifies settings for autologger.
        :paramtype autologger_settings:
         ~azure.mgmt.machinelearningservices.models.ComputeInstanceAutologgerSettings
        :keyword ssh_settings: Specifies policy and settings for SSH access.
        :paramtype ssh_settings: ~azure.mgmt.machinelearningservices.models.ComputeInstanceSshSettings
        :keyword custom_services: List of Custom Services added to the compute.
        :paramtype custom_services: list[~azure.mgmt.machinelearningservices.models.CustomService]
        :keyword compute_instance_authorization_type: The Compute Instance Authorization type.
         Available values are personal (default). Possible values include: "personal". Default value:
         "personal".
        :paramtype compute_instance_authorization_type: str or
         ~azure.mgmt.machinelearningservices.models.ComputeInstanceAuthorizationType
        :keyword personal_compute_instance_settings: Settings for a personal compute instance.
        :paramtype personal_compute_instance_settings:
         ~azure.mgmt.machinelearningservices.models.PersonalComputeInstanceSettings
        :keyword setup_scripts: Details of customized scripts to execute for setting up the cluster.
        :paramtype setup_scripts: ~azure.mgmt.machinelearningservices.models.SetupScripts
        :keyword idle_time_before_shutdown: Stops compute instance after user defined period of
         inactivity. Time is defined in ISO8601 format. Minimum is 15 min, maximum is 3 days.
        :paramtype idle_time_before_shutdown: str
        :keyword enable_node_public_ip: Enable or disable node public IP address provisioning. Possible
         values are: Possible values are: true - Indicates that the compute nodes will have public IPs
         provisioned. false - Indicates that the compute nodes will have a private endpoint and no
         public IPs.
        :paramtype enable_node_public_ip: bool
        """
        super(ComputeInstanceProperties, self).__init__(**kwargs)
        self.vm_size = vm_size
        self.subnet = subnet
        self.application_sharing_policy = application_sharing_policy
        self.autologger_settings = autologger_settings
        self.ssh_settings = ssh_settings
        self.custom_services = custom_services
        self.os_image_metadata = None
        self.connectivity_endpoints = None
        self.applications = None
        self.created_by = None
        self.errors = None
        self.state = None
        self.compute_instance_authorization_type = compute_instance_authorization_type
        self.personal_compute_instance_settings = personal_compute_instance_settings
        self.setup_scripts = setup_scripts
        self.last_operation = None
        self.schedules = schedules
        self.idle_time_before_shutdown = idle_time_before_shutdown
        self.enable_node_public_ip = enable_node_public_ip
        self.containers = None
        self.data_disks = None
        self.data_mounts = None
        self.versions = None


class ComputeInstanceSshSettings(msrest.serialization.Model):
    """Specifies policy and settings for SSH access.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar ssh_public_access: State of the public SSH port. Possible values are: Disabled -
     Indicates that the public ssh port is closed on this instance. Enabled - Indicates that the
     public ssh port is open and accessible according to the VNet/subnet policy if applicable.
     Possible values include: "Enabled", "Disabled". Default value: "Disabled".
    :vartype ssh_public_access: str or ~azure.mgmt.machinelearningservices.models.SshPublicAccess
    :ivar admin_user_name: Describes the admin user name.
    :vartype admin_user_name: str
    :ivar ssh_port: Describes the port for connecting through SSH.
    :vartype ssh_port: int
    :ivar admin_public_key: Specifies the SSH rsa public key file as a string. Use "ssh-keygen -t
     rsa -b 2048" to generate your SSH key pairs.
    :vartype admin_public_key: str
    """

    _validation = {
        'admin_user_name': {'readonly': True},
        'ssh_port': {'readonly': True},
    }

    _attribute_map = {
        'ssh_public_access': {'key': 'sshPublicAccess', 'type': 'str'},
        'admin_user_name': {'key': 'adminUserName', 'type': 'str'},
        'ssh_port': {'key': 'sshPort', 'type': 'int'},
        'admin_public_key': {'key': 'adminPublicKey', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        ssh_public_access: Optional[Union[str, "SshPublicAccess"]] = "Disabled",
        admin_public_key: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword ssh_public_access: State of the public SSH port. Possible values are: Disabled -
         Indicates that the public ssh port is closed on this instance. Enabled - Indicates that the
         public ssh port is open and accessible according to the VNet/subnet policy if applicable.
         Possible values include: "Enabled", "Disabled". Default value: "Disabled".
        :paramtype ssh_public_access: str or ~azure.mgmt.machinelearningservices.models.SshPublicAccess
        :keyword admin_public_key: Specifies the SSH rsa public key file as a string. Use "ssh-keygen
         -t rsa -b 2048" to generate your SSH key pairs.
        :paramtype admin_public_key: str
        """
        super(ComputeInstanceSshSettings, self).__init__(**kwargs)
        self.ssh_public_access = ssh_public_access
        self.admin_user_name = None
        self.ssh_port = None
        self.admin_public_key = admin_public_key


class ComputeInstanceVersion(msrest.serialization.Model):
    """Version of computeInstance.

    :ivar runtime: Runtime of compute instance.
    :vartype runtime: str
    """

    _attribute_map = {
        'runtime': {'key': 'runtime', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        runtime: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword runtime: Runtime of compute instance.
        :paramtype runtime: str
        """
        super(ComputeInstanceVersion, self).__init__(**kwargs)
        self.runtime = runtime


class ComputeResourceSchema(msrest.serialization.Model):
    """ComputeResourceSchema.

    :ivar properties: Compute properties.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.Compute
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'Compute'},
    }

    def __init__(
        self,
        *,
        properties: Optional["Compute"] = None,
        **kwargs
    ):
        """
        :keyword properties: Compute properties.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.Compute
        """
        super(ComputeResourceSchema, self).__init__(**kwargs)
        self.properties = properties


class ComputeResource(Resource, ComputeResourceSchema):
    """Machine Learning compute object wrapped into ARM resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar properties: Compute properties.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.Compute
    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
    :ivar location: Specifies the location of the resource.
    :vartype location: str
    :ivar tags: A set of tags. Contains resource tags defined as key/value pairs.
    :vartype tags: dict[str, str]
    :ivar sku: The sku of the workspace.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.Sku
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'Compute'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
    }

    def __init__(
        self,
        *,
        properties: Optional["Compute"] = None,
        identity: Optional["ManagedServiceIdentity"] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        **kwargs
    ):
        """
        :keyword properties: Compute properties.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.Compute
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
        :keyword location: Specifies the location of the resource.
        :paramtype location: str
        :keyword tags: A set of tags. Contains resource tags defined as key/value pairs.
        :paramtype tags: dict[str, str]
        :keyword sku: The sku of the workspace.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.Sku
        """
        super(ComputeResource, self).__init__(properties=properties, **kwargs)
        self.properties = properties
        self.identity = identity
        self.location = location
        self.tags = tags
        self.sku = sku
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class ComputeSchedules(msrest.serialization.Model):
    """The list of schedules to be applied on the computes.

    :ivar compute_start_stop: The list of compute start stop schedules to be applied.
    :vartype compute_start_stop:
     list[~azure.mgmt.machinelearningservices.models.ComputeStartStopSchedule]
    """

    _attribute_map = {
        'compute_start_stop': {'key': 'computeStartStop', 'type': '[ComputeStartStopSchedule]'},
    }

    def __init__(
        self,
        *,
        compute_start_stop: Optional[List["ComputeStartStopSchedule"]] = None,
        **kwargs
    ):
        """
        :keyword compute_start_stop: The list of compute start stop schedules to be applied.
        :paramtype compute_start_stop:
         list[~azure.mgmt.machinelearningservices.models.ComputeStartStopSchedule]
        """
        super(ComputeSchedules, self).__init__(**kwargs)
        self.compute_start_stop = compute_start_stop


class ComputeStartStopSchedule(msrest.serialization.Model):
    """Compute start stop schedule properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: A system assigned id for the schedule.
    :vartype id: str
    :ivar provisioning_status: The current deployment state of schedule. Possible values include:
     "Completed", "Provisioning", "Failed".
    :vartype provisioning_status: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningStatus
    :ivar status: Is the schedule enabled or disabled?. Possible values include: "Enabled",
     "Disabled".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.ScheduleStatus
    :ivar action: [Required] The compute power action. Possible values include: "Start", "Stop".
    :vartype action: str or ~azure.mgmt.machinelearningservices.models.ComputePowerAction
    :ivar trigger_type: Possible values include: "Recurrence", "Cron".
    :vartype trigger_type: str or ~azure.mgmt.machinelearningservices.models.TriggerType
    :ivar recurrence: The workflow trigger recurrence for ComputeStartStop schedule type.
    :vartype recurrence: ~azure.mgmt.machinelearningservices.models.Recurrence
    :ivar cron: The workflow trigger cron for ComputeStartStop schedule type.
    :vartype cron: ~azure.mgmt.machinelearningservices.models.Cron
    :ivar schedule: [Deprecated] Not used any more.
    :vartype schedule: ~azure.mgmt.machinelearningservices.models.ScheduleBase
    """

    _validation = {
        'id': {'readonly': True},
        'provisioning_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'provisioning_status': {'key': 'provisioningStatus', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'action': {'key': 'action', 'type': 'str'},
        'trigger_type': {'key': 'triggerType', 'type': 'str'},
        'recurrence': {'key': 'recurrence', 'type': 'Recurrence'},
        'cron': {'key': 'cron', 'type': 'Cron'},
        'schedule': {'key': 'schedule', 'type': 'ScheduleBase'},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "ScheduleStatus"]] = None,
        action: Optional[Union[str, "ComputePowerAction"]] = None,
        trigger_type: Optional[Union[str, "TriggerType"]] = None,
        recurrence: Optional["Recurrence"] = None,
        cron: Optional["Cron"] = None,
        schedule: Optional["ScheduleBase"] = None,
        **kwargs
    ):
        """
        :keyword status: Is the schedule enabled or disabled?. Possible values include: "Enabled",
         "Disabled".
        :paramtype status: str or ~azure.mgmt.machinelearningservices.models.ScheduleStatus
        :keyword action: [Required] The compute power action. Possible values include: "Start", "Stop".
        :paramtype action: str or ~azure.mgmt.machinelearningservices.models.ComputePowerAction
        :keyword trigger_type: Possible values include: "Recurrence", "Cron".
        :paramtype trigger_type: str or ~azure.mgmt.machinelearningservices.models.TriggerType
        :keyword recurrence: The workflow trigger recurrence for ComputeStartStop schedule type.
        :paramtype recurrence: ~azure.mgmt.machinelearningservices.models.Recurrence
        :keyword cron: The workflow trigger cron for ComputeStartStop schedule type.
        :paramtype cron: ~azure.mgmt.machinelearningservices.models.Cron
        :keyword schedule: [Deprecated] Not used any more.
        :paramtype schedule: ~azure.mgmt.machinelearningservices.models.ScheduleBase
        """
        super(ComputeStartStopSchedule, self).__init__(**kwargs)
        self.id = None
        self.provisioning_status = None
        self.status = status
        self.action = action
        self.trigger_type = trigger_type
        self.recurrence = recurrence
        self.cron = cron
        self.schedule = schedule


class ContainerResourceRequirements(msrest.serialization.Model):
    """Resource requirements for each container instance within an online deployment.

    :ivar container_resource_limits: Container resource limit info:.
    :vartype container_resource_limits:
     ~azure.mgmt.machinelearningservices.models.ContainerResourceSettings
    :ivar container_resource_requests: Container resource request info:.
    :vartype container_resource_requests:
     ~azure.mgmt.machinelearningservices.models.ContainerResourceSettings
    """

    _attribute_map = {
        'container_resource_limits': {'key': 'containerResourceLimits', 'type': 'ContainerResourceSettings'},
        'container_resource_requests': {'key': 'containerResourceRequests', 'type': 'ContainerResourceSettings'},
    }

    def __init__(
        self,
        *,
        container_resource_limits: Optional["ContainerResourceSettings"] = None,
        container_resource_requests: Optional["ContainerResourceSettings"] = None,
        **kwargs
    ):
        """
        :keyword container_resource_limits: Container resource limit info:.
        :paramtype container_resource_limits:
         ~azure.mgmt.machinelearningservices.models.ContainerResourceSettings
        :keyword container_resource_requests: Container resource request info:.
        :paramtype container_resource_requests:
         ~azure.mgmt.machinelearningservices.models.ContainerResourceSettings
        """
        super(ContainerResourceRequirements, self).__init__(**kwargs)
        self.container_resource_limits = container_resource_limits
        self.container_resource_requests = container_resource_requests


class ContainerResourceSettings(msrest.serialization.Model):
    """ContainerResourceSettings.

    :ivar cpu: Number of vCPUs request/limit for container. More info:
     https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/.
    :vartype cpu: str
    :ivar gpu: Number of Nvidia GPU cards request/limit for container. More info:
     https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/.
    :vartype gpu: str
    :ivar memory: Memory size request/limit for container. More info:
     https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/.
    :vartype memory: str
    """

    _attribute_map = {
        'cpu': {'key': 'cpu', 'type': 'str'},
        'gpu': {'key': 'gpu', 'type': 'str'},
        'memory': {'key': 'memory', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        cpu: Optional[str] = None,
        gpu: Optional[str] = None,
        memory: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword cpu: Number of vCPUs request/limit for container. More info:
         https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/.
        :paramtype cpu: str
        :keyword gpu: Number of Nvidia GPU cards request/limit for container. More info:
         https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/.
        :paramtype gpu: str
        :keyword memory: Memory size request/limit for container. More info:
         https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/.
        :paramtype memory: str
        """
        super(ContainerResourceSettings, self).__init__(**kwargs)
        self.cpu = cpu
        self.gpu = gpu
        self.memory = memory


class CosmosDbSettings(msrest.serialization.Model):
    """CosmosDbSettings.

    :ivar collections_throughput: The throughput of the collections in cosmosdb database.
    :vartype collections_throughput: int
    """

    _attribute_map = {
        'collections_throughput': {'key': 'collectionsThroughput', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        collections_throughput: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword collections_throughput: The throughput of the collections in cosmosdb database.
        :paramtype collections_throughput: int
        """
        super(CosmosDbSettings, self).__init__(**kwargs)
        self.collections_throughput = collections_throughput


class Cron(msrest.serialization.Model):
    """The workflow trigger cron for ComputeStartStop schedule type.

    :ivar start_time: The start time in yyyy-MM-ddTHH:mm:ss format.
    :vartype start_time: str
    :ivar time_zone: Specifies time zone in which the schedule runs.
     TimeZone should follow Windows time zone format. Refer:
     https://learn.microsoft.com/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11.
    :vartype time_zone: str
    :ivar expression: [Required] Specifies cron expression of schedule.
     The expression should follow NCronTab format.
    :vartype expression: str
    """

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'str'},
        'time_zone': {'key': 'timeZone', 'type': 'str'},
        'expression': {'key': 'expression', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        start_time: Optional[str] = None,
        time_zone: Optional[str] = "UTC",
        expression: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword start_time: The start time in yyyy-MM-ddTHH:mm:ss format.
        :paramtype start_time: str
        :keyword time_zone: Specifies time zone in which the schedule runs.
         TimeZone should follow Windows time zone format. Refer:
         https://learn.microsoft.com/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11.
        :paramtype time_zone: str
        :keyword expression: [Required] Specifies cron expression of schedule.
         The expression should follow NCronTab format.
        :paramtype expression: str
        """
        super(Cron, self).__init__(**kwargs)
        self.start_time = start_time
        self.time_zone = time_zone
        self.expression = expression


class TriggerBase(msrest.serialization.Model):
    """TriggerBase.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CronTrigger, RecurrenceTrigger.

    All required parameters must be populated in order to send to Azure.

    :ivar end_time: Specifies end time of schedule in ISO 8601, but without a UTC offset. Refer
     https://en.wikipedia.org/wiki/ISO_8601.
     Recommented format would be "2022-06-01T00:00:01"
     If not present, the schedule will run indefinitely.
    :vartype end_time: str
    :ivar start_time: Specifies start time of schedule in ISO 8601 format, but without a UTC
     offset.
    :vartype start_time: str
    :ivar time_zone: Specifies time zone in which the schedule runs.
     TimeZone should follow Windows time zone format. Refer:
     https://learn.microsoft.com/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11.
    :vartype time_zone: str
    :ivar trigger_type: Required. [Required].Constant filled by server. Possible values include:
     "Recurrence", "Cron".
    :vartype trigger_type: str or ~azure.mgmt.machinelearningservices.models.TriggerType
    """

    _validation = {
        'trigger_type': {'required': True},
    }

    _attribute_map = {
        'end_time': {'key': 'endTime', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'str'},
        'time_zone': {'key': 'timeZone', 'type': 'str'},
        'trigger_type': {'key': 'triggerType', 'type': 'str'},
    }

    _subtype_map = {
        'trigger_type': {'Cron': 'CronTrigger', 'Recurrence': 'RecurrenceTrigger'}
    }

    def __init__(
        self,
        *,
        end_time: Optional[str] = None,
        start_time: Optional[str] = None,
        time_zone: Optional[str] = "UTC",
        **kwargs
    ):
        """
        :keyword end_time: Specifies end time of schedule in ISO 8601, but without a UTC offset. Refer
         https://en.wikipedia.org/wiki/ISO_8601.
         Recommented format would be "2022-06-01T00:00:01"
         If not present, the schedule will run indefinitely.
        :paramtype end_time: str
        :keyword start_time: Specifies start time of schedule in ISO 8601 format, but without a UTC
         offset.
        :paramtype start_time: str
        :keyword time_zone: Specifies time zone in which the schedule runs.
         TimeZone should follow Windows time zone format. Refer:
         https://learn.microsoft.com/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11.
        :paramtype time_zone: str
        """
        super(TriggerBase, self).__init__(**kwargs)
        self.end_time = end_time
        self.start_time = start_time
        self.time_zone = time_zone
        self.trigger_type = None  # type: Optional[str]


class CronTrigger(TriggerBase):
    """CronTrigger.

    All required parameters must be populated in order to send to Azure.

    :ivar end_time: Specifies end time of schedule in ISO 8601, but without a UTC offset. Refer
     https://en.wikipedia.org/wiki/ISO_8601.
     Recommented format would be "2022-06-01T00:00:01"
     If not present, the schedule will run indefinitely.
    :vartype end_time: str
    :ivar start_time: Specifies start time of schedule in ISO 8601 format, but without a UTC
     offset.
    :vartype start_time: str
    :ivar time_zone: Specifies time zone in which the schedule runs.
     TimeZone should follow Windows time zone format. Refer:
     https://learn.microsoft.com/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11.
    :vartype time_zone: str
    :ivar trigger_type: Required. [Required].Constant filled by server. Possible values include:
     "Recurrence", "Cron".
    :vartype trigger_type: str or ~azure.mgmt.machinelearningservices.models.TriggerType
    :ivar expression: Required. [Required] Specifies cron expression of schedule.
     The expression should follow NCronTab format.
    :vartype expression: str
    """

    _validation = {
        'trigger_type': {'required': True},
        'expression': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'end_time': {'key': 'endTime', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'str'},
        'time_zone': {'key': 'timeZone', 'type': 'str'},
        'trigger_type': {'key': 'triggerType', 'type': 'str'},
        'expression': {'key': 'expression', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        expression: str,
        end_time: Optional[str] = None,
        start_time: Optional[str] = None,
        time_zone: Optional[str] = "UTC",
        **kwargs
    ):
        """
        :keyword end_time: Specifies end time of schedule in ISO 8601, but without a UTC offset. Refer
         https://en.wikipedia.org/wiki/ISO_8601.
         Recommented format would be "2022-06-01T00:00:01"
         If not present, the schedule will run indefinitely.
        :paramtype end_time: str
        :keyword start_time: Specifies start time of schedule in ISO 8601 format, but without a UTC
         offset.
        :paramtype start_time: str
        :keyword time_zone: Specifies time zone in which the schedule runs.
         TimeZone should follow Windows time zone format. Refer:
         https://learn.microsoft.com/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11.
        :paramtype time_zone: str
        :keyword expression: Required. [Required] Specifies cron expression of schedule.
         The expression should follow NCronTab format.
        :paramtype expression: str
        """
        super(CronTrigger, self).__init__(end_time=end_time, start_time=start_time, time_zone=time_zone, **kwargs)
        self.trigger_type = 'Cron'  # type: str
        self.expression = expression


class CsvExportSummary(ExportSummary):
    """CsvExportSummary.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar end_date_time: The time when the export was completed.
    :vartype end_date_time: ~datetime.datetime
    :ivar exported_row_count: The total number of labeled datapoints exported.
    :vartype exported_row_count: long
    :ivar format: Required. [Required] The format of exported labels, also as the
     discriminator.Constant filled by server. Possible values include: "Dataset", "Coco", "CSV".
    :vartype format: str or ~azure.mgmt.machinelearningservices.models.ExportFormatType
    :ivar labeling_job_id: Name and identifier of the job containing exported labels.
    :vartype labeling_job_id: str
    :ivar start_date_time: The time when the export was requested.
    :vartype start_date_time: ~datetime.datetime
    :ivar container_name: The container name to which the labels will be exported.
    :vartype container_name: str
    :ivar snapshot_path: The output path where the labels will be exported.
    :vartype snapshot_path: str
    """

    _validation = {
        'end_date_time': {'readonly': True},
        'exported_row_count': {'readonly': True},
        'format': {'required': True},
        'labeling_job_id': {'readonly': True},
        'start_date_time': {'readonly': True},
        'container_name': {'readonly': True},
        'snapshot_path': {'readonly': True},
    }

    _attribute_map = {
        'end_date_time': {'key': 'endDateTime', 'type': 'iso-8601'},
        'exported_row_count': {'key': 'exportedRowCount', 'type': 'long'},
        'format': {'key': 'format', 'type': 'str'},
        'labeling_job_id': {'key': 'labelingJobId', 'type': 'str'},
        'start_date_time': {'key': 'startDateTime', 'type': 'iso-8601'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'snapshot_path': {'key': 'snapshotPath', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(CsvExportSummary, self).__init__(**kwargs)
        self.format = 'CSV'  # type: str
        self.container_name = None
        self.snapshot_path = None


class CustomForecastHorizon(ForecastHorizon):
    """The desired maximum forecast horizon in units of time-series frequency.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Required. [Required] Set forecast horizon value selection mode.Constant filled by
     server. Possible values include: "Auto", "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.ForecastHorizonMode
    :ivar value: Required. [Required] Forecast horizon value.
    :vartype value: int
    """

    _validation = {
        'mode': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'value': {'key': 'value', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        value: int,
        **kwargs
    ):
        """
        :keyword value: Required. [Required] Forecast horizon value.
        :paramtype value: int
        """
        super(CustomForecastHorizon, self).__init__(**kwargs)
        self.mode = 'Custom'  # type: str
        self.value = value


class JobInput(msrest.serialization.Model):
    """Command job definition.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CustomModelJobInput, LiteralJobInput, MLFlowModelJobInput, MLTableJobInput, TritonModelJobInput, UriFileJobInput, UriFolderJobInput.

    All required parameters must be populated in order to send to Azure.

    :ivar description: Description for the input.
    :vartype description: str
    :ivar job_input_type: Required. [Required] Specifies the type of job.Constant filled by server.
     Possible values include: "literal", "uri_file", "uri_folder", "mltable", "custom_model",
     "mlflow_model", "triton_model".
    :vartype job_input_type: str or ~azure.mgmt.machinelearningservices.models.JobInputType
    """

    _validation = {
        'job_input_type': {'required': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'job_input_type': {'key': 'jobInputType', 'type': 'str'},
    }

    _subtype_map = {
        'job_input_type': {'custom_model': 'CustomModelJobInput', 'literal': 'LiteralJobInput', 'mlflow_model': 'MLFlowModelJobInput', 'mltable': 'MLTableJobInput', 'triton_model': 'TritonModelJobInput', 'uri_file': 'UriFileJobInput', 'uri_folder': 'UriFolderJobInput'}
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword description: Description for the input.
        :paramtype description: str
        """
        super(JobInput, self).__init__(**kwargs)
        self.description = description
        self.job_input_type = None  # type: Optional[str]


class CustomModelJobInput(JobInput, AssetJobInput):
    """CustomModelJobInput.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
     "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
    :ivar uri: Required. [Required] Input Asset URI.
    :vartype uri: str
    :ivar description: Description for the input.
    :vartype description: str
    :ivar job_input_type: Required. [Required] Specifies the type of job.Constant filled by server.
     Possible values include: "literal", "uri_file", "uri_folder", "mltable", "custom_model",
     "mlflow_model", "triton_model".
    :vartype job_input_type: str or ~azure.mgmt.machinelearningservices.models.JobInputType
    """

    _validation = {
        'uri': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'job_input_type': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'job_input_type': {'key': 'jobInputType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        uri: str,
        mode: Optional[Union[str, "InputDeliveryMode"]] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
         "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
        :keyword uri: Required. [Required] Input Asset URI.
        :paramtype uri: str
        :keyword description: Description for the input.
        :paramtype description: str
        """
        super(CustomModelJobInput, self).__init__(description=description, mode=mode, uri=uri, **kwargs)
        self.mode = mode
        self.uri = uri
        self.job_input_type = 'custom_model'  # type: str
        self.description = description


class JobOutput(msrest.serialization.Model):
    """Job output definition container information on where to find job output/logs.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CustomModelJobOutput, MLFlowModelJobOutput, MLTableJobOutput, TritonModelJobOutput, UriFileJobOutput, UriFolderJobOutput.

    All required parameters must be populated in order to send to Azure.

    :ivar description: Description for the output.
    :vartype description: str
    :ivar job_output_type: Required. [Required] Specifies the type of job.Constant filled by
     server. Possible values include: "uri_file", "uri_folder", "mltable", "custom_model",
     "mlflow_model", "triton_model".
    :vartype job_output_type: str or ~azure.mgmt.machinelearningservices.models.JobOutputType
    """

    _validation = {
        'job_output_type': {'required': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'job_output_type': {'key': 'jobOutputType', 'type': 'str'},
    }

    _subtype_map = {
        'job_output_type': {'custom_model': 'CustomModelJobOutput', 'mlflow_model': 'MLFlowModelJobOutput', 'mltable': 'MLTableJobOutput', 'triton_model': 'TritonModelJobOutput', 'uri_file': 'UriFileJobOutput', 'uri_folder': 'UriFolderJobOutput'}
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword description: Description for the output.
        :paramtype description: str
        """
        super(JobOutput, self).__init__(**kwargs)
        self.description = description
        self.job_output_type = None  # type: Optional[str]


class CustomModelJobOutput(JobOutput, AssetJobOutput):
    """CustomModelJobOutput.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload",
     "Direct".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
    :ivar uri: Output Asset URI.
    :vartype uri: str
    :ivar description: Description for the output.
    :vartype description: str
    :ivar job_output_type: Required. [Required] Specifies the type of job.Constant filled by
     server. Possible values include: "uri_file", "uri_folder", "mltable", "custom_model",
     "mlflow_model", "triton_model".
    :vartype job_output_type: str or ~azure.mgmt.machinelearningservices.models.JobOutputType
    """

    _validation = {
        'job_output_type': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'job_output_type': {'key': 'jobOutputType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        mode: Optional[Union[str, "OutputDeliveryMode"]] = None,
        uri: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload",
         "Direct".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
        :keyword uri: Output Asset URI.
        :paramtype uri: str
        :keyword description: Description for the output.
        :paramtype description: str
        """
        super(CustomModelJobOutput, self).__init__(description=description, mode=mode, uri=uri, **kwargs)
        self.mode = mode
        self.uri = uri
        self.job_output_type = 'custom_model'  # type: str
        self.description = description


class CustomNCrossValidations(NCrossValidations):
    """N-Cross validations are specified by user.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Required. [Required] Mode for determining N-Cross validations.Constant filled by
     server. Possible values include: "Auto", "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.NCrossValidationsMode
    :ivar value: Required. [Required] N-Cross validations value.
    :vartype value: int
    """

    _validation = {
        'mode': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'value': {'key': 'value', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        value: int,
        **kwargs
    ):
        """
        :keyword value: Required. [Required] N-Cross validations value.
        :paramtype value: int
        """
        super(CustomNCrossValidations, self).__init__(**kwargs)
        self.mode = 'Custom'  # type: str
        self.value = value


class CustomSeasonality(Seasonality):
    """CustomSeasonality.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Required. [Required] Seasonality mode.Constant filled by server. Possible values
     include: "Auto", "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.SeasonalityMode
    :ivar value: Required. [Required] Seasonality value.
    :vartype value: int
    """

    _validation = {
        'mode': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'value': {'key': 'value', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        value: int,
        **kwargs
    ):
        """
        :keyword value: Required. [Required] Seasonality value.
        :paramtype value: int
        """
        super(CustomSeasonality, self).__init__(**kwargs)
        self.mode = 'Custom'  # type: str
        self.value = value


class CustomService(msrest.serialization.Model):
    """Specifies the custom service configuration.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar name: Name of the Custom Service.
    :vartype name: str
    :ivar image: Describes the Image Specifications.
    :vartype image: ~azure.mgmt.machinelearningservices.models.Image
    :ivar environment_variables: Environment Variable for the container.
    :vartype environment_variables: dict[str,
     ~azure.mgmt.machinelearningservices.models.EnvironmentVariable]
    :ivar docker: Describes the docker settings for the image.
    :vartype docker: ~azure.mgmt.machinelearningservices.models.Docker
    :ivar endpoints: Configuring the endpoints for the container.
    :vartype endpoints: list[~azure.mgmt.machinelearningservices.models.Endpoint]
    :ivar volumes: Configuring the volumes for the container.
    :vartype volumes: list[~azure.mgmt.machinelearningservices.models.VolumeDefinition]
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'image': {'key': 'image', 'type': 'Image'},
        'environment_variables': {'key': 'environmentVariables', 'type': '{EnvironmentVariable}'},
        'docker': {'key': 'docker', 'type': 'Docker'},
        'endpoints': {'key': 'endpoints', 'type': '[Endpoint]'},
        'volumes': {'key': 'volumes', 'type': '[VolumeDefinition]'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        name: Optional[str] = None,
        image: Optional["Image"] = None,
        environment_variables: Optional[Dict[str, "EnvironmentVariable"]] = None,
        docker: Optional["Docker"] = None,
        endpoints: Optional[List["Endpoint"]] = None,
        volumes: Optional[List["VolumeDefinition"]] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword name: Name of the Custom Service.
        :paramtype name: str
        :keyword image: Describes the Image Specifications.
        :paramtype image: ~azure.mgmt.machinelearningservices.models.Image
        :keyword environment_variables: Environment Variable for the container.
        :paramtype environment_variables: dict[str,
         ~azure.mgmt.machinelearningservices.models.EnvironmentVariable]
        :keyword docker: Describes the docker settings for the image.
        :paramtype docker: ~azure.mgmt.machinelearningservices.models.Docker
        :keyword endpoints: Configuring the endpoints for the container.
        :paramtype endpoints: list[~azure.mgmt.machinelearningservices.models.Endpoint]
        :keyword volumes: Configuring the volumes for the container.
        :paramtype volumes: list[~azure.mgmt.machinelearningservices.models.VolumeDefinition]
        """
        super(CustomService, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.name = name
        self.image = image
        self.environment_variables = environment_variables
        self.docker = docker
        self.endpoints = endpoints
        self.volumes = volumes


class CustomTargetLags(TargetLags):
    """CustomTargetLags.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Required. [Required] Set target lags mode - Auto/Custom.Constant filled by server.
     Possible values include: "Auto", "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.TargetLagsMode
    :ivar values: Required. [Required] Set target lags values.
    :vartype values: list[int]
    """

    _validation = {
        'mode': {'required': True},
        'values': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'values': {'key': 'values', 'type': '[int]'},
    }

    def __init__(
        self,
        *,
        values: List[int],
        **kwargs
    ):
        """
        :keyword values: Required. [Required] Set target lags values.
        :paramtype values: list[int]
        """
        super(CustomTargetLags, self).__init__(**kwargs)
        self.mode = 'Custom'  # type: str
        self.values = values


class CustomTargetRollingWindowSize(TargetRollingWindowSize):
    """CustomTargetRollingWindowSize.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Required. [Required] TargetRollingWindowSiz detection mode.Constant filled by
     server. Possible values include: "Auto", "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.TargetRollingWindowSizeMode
    :ivar value: Required. [Required] TargetRollingWindowSize value.
    :vartype value: int
    """

    _validation = {
        'mode': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'value': {'key': 'value', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        value: int,
        **kwargs
    ):
        """
        :keyword value: Required. [Required] TargetRollingWindowSize value.
        :paramtype value: int
        """
        super(CustomTargetRollingWindowSize, self).__init__(**kwargs)
        self.mode = 'Custom'  # type: str
        self.value = value


class DatabricksSchema(msrest.serialization.Model):
    """DatabricksSchema.

    :ivar properties: Properties of Databricks.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.DatabricksProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'DatabricksProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["DatabricksProperties"] = None,
        **kwargs
    ):
        """
        :keyword properties: Properties of Databricks.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.DatabricksProperties
        """
        super(DatabricksSchema, self).__init__(**kwargs)
        self.properties = properties


class Databricks(Compute, DatabricksSchema):
    """A DataFactory compute.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar properties: Properties of Databricks.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.DatabricksProperties
    :ivar compute_type: Required. The type of compute.Constant filled by server. Possible values
     include: "AKS", "Kubernetes", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine",
     "HDInsight", "Databricks", "DataLakeAnalytics", "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :ivar compute_location: Location for the underlying compute.
    :vartype compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values are Unknown,
     Updating, Provisioning, Succeeded, and Failed. Possible values include: "Unknown", "Updating",
     "Creating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ComputeProvisioningState
    :ivar description: The description of the Machine Learning compute.
    :vartype description: str
    :ivar created_on: The time at which the compute was created.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: The time at which the compute was last modified.
    :vartype modified_on: ~datetime.datetime
    :ivar resource_id: ARM resource id of the underlying compute.
    :vartype resource_id: str
    :ivar provisioning_errors: Errors during provisioning.
    :vartype provisioning_errors: list[~azure.mgmt.machinelearningservices.models.ErrorResponse]
    :ivar is_attached_compute: Indicating whether the compute was provisioned by user and brought
     from outside if true, or machine learning service provisioned it if false.
    :vartype is_attached_compute: bool
    :ivar disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI
     and AAD exclusively for authentication.
    :vartype disable_local_auth: bool
    """

    _validation = {
        'compute_type': {'required': True},
        'compute_location': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'modified_on': {'readonly': True},
        'provisioning_errors': {'readonly': True},
        'is_attached_compute': {'readonly': True},
        'disable_local_auth': {'readonly': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'DatabricksProperties'},
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'compute_location': {'key': 'computeLocation', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'modified_on': {'key': 'modifiedOn', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'provisioning_errors': {'key': 'provisioningErrors', 'type': '[ErrorResponse]'},
        'is_attached_compute': {'key': 'isAttachedCompute', 'type': 'bool'},
        'disable_local_auth': {'key': 'disableLocalAuth', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        properties: Optional["DatabricksProperties"] = None,
        description: Optional[str] = None,
        resource_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword properties: Properties of Databricks.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.DatabricksProperties
        :keyword description: The description of the Machine Learning compute.
        :paramtype description: str
        :keyword resource_id: ARM resource id of the underlying compute.
        :paramtype resource_id: str
        """
        super(Databricks, self).__init__(description=description, resource_id=resource_id, properties=properties, **kwargs)
        self.properties = properties
        self.compute_type = 'Databricks'  # type: str
        self.compute_location = None
        self.provisioning_state = None
        self.description = description
        self.created_on = None
        self.modified_on = None
        self.resource_id = resource_id
        self.provisioning_errors = None
        self.is_attached_compute = None
        self.disable_local_auth = None


class DatabricksComputeSecretsProperties(msrest.serialization.Model):
    """Properties of Databricks Compute Secrets.

    :ivar databricks_access_token: access token for databricks account.
    :vartype databricks_access_token: str
    """

    _attribute_map = {
        'databricks_access_token': {'key': 'databricksAccessToken', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        databricks_access_token: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword databricks_access_token: access token for databricks account.
        :paramtype databricks_access_token: str
        """
        super(DatabricksComputeSecretsProperties, self).__init__(**kwargs)
        self.databricks_access_token = databricks_access_token


class DatabricksComputeSecrets(ComputeSecrets, DatabricksComputeSecretsProperties):
    """Secrets related to a Machine Learning compute based on Databricks.

    All required parameters must be populated in order to send to Azure.

    :ivar databricks_access_token: access token for databricks account.
    :vartype databricks_access_token: str
    :ivar compute_type: Required. The type of compute.Constant filled by server. Possible values
     include: "AKS", "Kubernetes", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine",
     "HDInsight", "Databricks", "DataLakeAnalytics", "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    """

    _validation = {
        'compute_type': {'required': True},
    }

    _attribute_map = {
        'databricks_access_token': {'key': 'databricksAccessToken', 'type': 'str'},
        'compute_type': {'key': 'computeType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        databricks_access_token: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword databricks_access_token: access token for databricks account.
        :paramtype databricks_access_token: str
        """
        super(DatabricksComputeSecrets, self).__init__(databricks_access_token=databricks_access_token, **kwargs)
        self.databricks_access_token = databricks_access_token
        self.compute_type = 'Databricks'  # type: str


class DatabricksProperties(msrest.serialization.Model):
    """Properties of Databricks.

    :ivar databricks_access_token: Databricks access token.
    :vartype databricks_access_token: str
    :ivar workspace_url: Workspace Url.
    :vartype workspace_url: str
    """

    _attribute_map = {
        'databricks_access_token': {'key': 'databricksAccessToken', 'type': 'str'},
        'workspace_url': {'key': 'workspaceUrl', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        databricks_access_token: Optional[str] = None,
        workspace_url: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword databricks_access_token: Databricks access token.
        :paramtype databricks_access_token: str
        :keyword workspace_url: Workspace Url.
        :paramtype workspace_url: str
        """
        super(DatabricksProperties, self).__init__(**kwargs)
        self.databricks_access_token = databricks_access_token
        self.workspace_url = workspace_url


class DataContainer(Resource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.DataContainerProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'DataContainerProperties'},
    }

    def __init__(
        self,
        *,
        properties: "DataContainerProperties",
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.DataContainerProperties
        """
        super(DataContainer, self).__init__(**kwargs)
        self.properties = properties


class DataContainerProperties(AssetContainer):
    """Container for data asset versions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar latest_version: The latest version inside this container.
    :vartype latest_version: str
    :ivar next_version: The next auto incremental version.
    :vartype next_version: str
    :ivar data_type: Required. [Required] Specifies the type of data. Possible values include:
     "uri_file", "uri_folder", "mltable".
    :vartype data_type: str or ~azure.mgmt.machinelearningservices.models.DataType
    """

    _validation = {
        'latest_version': {'readonly': True},
        'next_version': {'readonly': True},
        'data_type': {'required': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'latest_version': {'key': 'latestVersion', 'type': 'str'},
        'next_version': {'key': 'nextVersion', 'type': 'str'},
        'data_type': {'key': 'dataType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        data_type: Union[str, "DataType"],
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        is_archived: Optional[bool] = False,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword data_type: Required. [Required] Specifies the type of data. Possible values include:
         "uri_file", "uri_folder", "mltable".
        :paramtype data_type: str or ~azure.mgmt.machinelearningservices.models.DataType
        """
        super(DataContainerProperties, self).__init__(description=description, properties=properties, tags=tags, is_archived=is_archived, **kwargs)
        self.data_type = data_type


class DataContainerResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of DataContainer entities.

    :ivar next_link: The link to the next page of DataContainer objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type DataContainer.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.DataContainer]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[DataContainer]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["DataContainer"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of DataContainer objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type DataContainer.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.DataContainer]
        """
        super(DataContainerResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class DataFactory(Compute):
    """A DataFactory compute.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar compute_type: Required. The type of compute.Constant filled by server. Possible values
     include: "AKS", "Kubernetes", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine",
     "HDInsight", "Databricks", "DataLakeAnalytics", "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :ivar compute_location: Location for the underlying compute.
    :vartype compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values are Unknown,
     Updating, Provisioning, Succeeded, and Failed. Possible values include: "Unknown", "Updating",
     "Creating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ComputeProvisioningState
    :ivar description: The description of the Machine Learning compute.
    :vartype description: str
    :ivar created_on: The time at which the compute was created.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: The time at which the compute was last modified.
    :vartype modified_on: ~datetime.datetime
    :ivar resource_id: ARM resource id of the underlying compute.
    :vartype resource_id: str
    :ivar provisioning_errors: Errors during provisioning.
    :vartype provisioning_errors: list[~azure.mgmt.machinelearningservices.models.ErrorResponse]
    :ivar is_attached_compute: Indicating whether the compute was provisioned by user and brought
     from outside if true, or machine learning service provisioned it if false.
    :vartype is_attached_compute: bool
    :ivar disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI
     and AAD exclusively for authentication.
    :vartype disable_local_auth: bool
    """

    _validation = {
        'compute_type': {'required': True},
        'compute_location': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'modified_on': {'readonly': True},
        'provisioning_errors': {'readonly': True},
        'is_attached_compute': {'readonly': True},
        'disable_local_auth': {'readonly': True},
    }

    _attribute_map = {
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'compute_location': {'key': 'computeLocation', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'modified_on': {'key': 'modifiedOn', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'provisioning_errors': {'key': 'provisioningErrors', 'type': '[ErrorResponse]'},
        'is_attached_compute': {'key': 'isAttachedCompute', 'type': 'bool'},
        'disable_local_auth': {'key': 'disableLocalAuth', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        resource_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword description: The description of the Machine Learning compute.
        :paramtype description: str
        :keyword resource_id: ARM resource id of the underlying compute.
        :paramtype resource_id: str
        """
        super(DataFactory, self).__init__(description=description, resource_id=resource_id, **kwargs)
        self.compute_type = 'DataFactory'  # type: str


class DataLakeAnalyticsSchema(msrest.serialization.Model):
    """DataLakeAnalyticsSchema.

    :ivar properties:
    :vartype properties:
     ~azure.mgmt.machinelearningservices.models.DataLakeAnalyticsSchemaProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'DataLakeAnalyticsSchemaProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["DataLakeAnalyticsSchemaProperties"] = None,
        **kwargs
    ):
        """
        :keyword properties:
        :paramtype properties:
         ~azure.mgmt.machinelearningservices.models.DataLakeAnalyticsSchemaProperties
        """
        super(DataLakeAnalyticsSchema, self).__init__(**kwargs)
        self.properties = properties


class DataLakeAnalytics(Compute, DataLakeAnalyticsSchema):
    """A DataLakeAnalytics compute.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar properties:
    :vartype properties:
     ~azure.mgmt.machinelearningservices.models.DataLakeAnalyticsSchemaProperties
    :ivar compute_type: Required. The type of compute.Constant filled by server. Possible values
     include: "AKS", "Kubernetes", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine",
     "HDInsight", "Databricks", "DataLakeAnalytics", "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :ivar compute_location: Location for the underlying compute.
    :vartype compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values are Unknown,
     Updating, Provisioning, Succeeded, and Failed. Possible values include: "Unknown", "Updating",
     "Creating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ComputeProvisioningState
    :ivar description: The description of the Machine Learning compute.
    :vartype description: str
    :ivar created_on: The time at which the compute was created.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: The time at which the compute was last modified.
    :vartype modified_on: ~datetime.datetime
    :ivar resource_id: ARM resource id of the underlying compute.
    :vartype resource_id: str
    :ivar provisioning_errors: Errors during provisioning.
    :vartype provisioning_errors: list[~azure.mgmt.machinelearningservices.models.ErrorResponse]
    :ivar is_attached_compute: Indicating whether the compute was provisioned by user and brought
     from outside if true, or machine learning service provisioned it if false.
    :vartype is_attached_compute: bool
    :ivar disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI
     and AAD exclusively for authentication.
    :vartype disable_local_auth: bool
    """

    _validation = {
        'compute_type': {'required': True},
        'compute_location': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'modified_on': {'readonly': True},
        'provisioning_errors': {'readonly': True},
        'is_attached_compute': {'readonly': True},
        'disable_local_auth': {'readonly': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'DataLakeAnalyticsSchemaProperties'},
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'compute_location': {'key': 'computeLocation', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'modified_on': {'key': 'modifiedOn', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'provisioning_errors': {'key': 'provisioningErrors', 'type': '[ErrorResponse]'},
        'is_attached_compute': {'key': 'isAttachedCompute', 'type': 'bool'},
        'disable_local_auth': {'key': 'disableLocalAuth', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        properties: Optional["DataLakeAnalyticsSchemaProperties"] = None,
        description: Optional[str] = None,
        resource_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword properties:
        :paramtype properties:
         ~azure.mgmt.machinelearningservices.models.DataLakeAnalyticsSchemaProperties
        :keyword description: The description of the Machine Learning compute.
        :paramtype description: str
        :keyword resource_id: ARM resource id of the underlying compute.
        :paramtype resource_id: str
        """
        super(DataLakeAnalytics, self).__init__(description=description, resource_id=resource_id, properties=properties, **kwargs)
        self.properties = properties
        self.compute_type = 'DataLakeAnalytics'  # type: str
        self.compute_location = None
        self.provisioning_state = None
        self.description = description
        self.created_on = None
        self.modified_on = None
        self.resource_id = resource_id
        self.provisioning_errors = None
        self.is_attached_compute = None
        self.disable_local_auth = None


class DataLakeAnalyticsSchemaProperties(msrest.serialization.Model):
    """DataLakeAnalyticsSchemaProperties.

    :ivar data_lake_store_account_name: DataLake Store Account Name.
    :vartype data_lake_store_account_name: str
    """

    _attribute_map = {
        'data_lake_store_account_name': {'key': 'dataLakeStoreAccountName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        data_lake_store_account_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword data_lake_store_account_name: DataLake Store Account Name.
        :paramtype data_lake_store_account_name: str
        """
        super(DataLakeAnalyticsSchemaProperties, self).__init__(**kwargs)
        self.data_lake_store_account_name = data_lake_store_account_name


class DataPathAssetReference(AssetReferenceBase):
    """Reference to an asset via its path in a datastore.

    All required parameters must be populated in order to send to Azure.

    :ivar reference_type: Required. [Required] Specifies the type of asset reference.Constant
     filled by server. Possible values include: "Id", "DataPath", "OutputPath".
    :vartype reference_type: str or ~azure.mgmt.machinelearningservices.models.ReferenceType
    :ivar datastore_id: ARM resource ID of the datastore where the asset is located.
    :vartype datastore_id: str
    :ivar path: The path of the file/directory in the datastore.
    :vartype path: str
    """

    _validation = {
        'reference_type': {'required': True},
    }

    _attribute_map = {
        'reference_type': {'key': 'referenceType', 'type': 'str'},
        'datastore_id': {'key': 'datastoreId', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        datastore_id: Optional[str] = None,
        path: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword datastore_id: ARM resource ID of the datastore where the asset is located.
        :paramtype datastore_id: str
        :keyword path: The path of the file/directory in the datastore.
        :paramtype path: str
        """
        super(DataPathAssetReference, self).__init__(**kwargs)
        self.reference_type = 'DataPath'  # type: str
        self.datastore_id = datastore_id
        self.path = path


class DatasetExportSummary(ExportSummary):
    """DatasetExportSummary.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar end_date_time: The time when the export was completed.
    :vartype end_date_time: ~datetime.datetime
    :ivar exported_row_count: The total number of labeled datapoints exported.
    :vartype exported_row_count: long
    :ivar format: Required. [Required] The format of exported labels, also as the
     discriminator.Constant filled by server. Possible values include: "Dataset", "Coco", "CSV".
    :vartype format: str or ~azure.mgmt.machinelearningservices.models.ExportFormatType
    :ivar labeling_job_id: Name and identifier of the job containing exported labels.
    :vartype labeling_job_id: str
    :ivar start_date_time: The time when the export was requested.
    :vartype start_date_time: ~datetime.datetime
    :ivar labeled_asset_name: The unique name of the labeled data asset.
    :vartype labeled_asset_name: str
    """

    _validation = {
        'end_date_time': {'readonly': True},
        'exported_row_count': {'readonly': True},
        'format': {'required': True},
        'labeling_job_id': {'readonly': True},
        'start_date_time': {'readonly': True},
        'labeled_asset_name': {'readonly': True},
    }

    _attribute_map = {
        'end_date_time': {'key': 'endDateTime', 'type': 'iso-8601'},
        'exported_row_count': {'key': 'exportedRowCount', 'type': 'long'},
        'format': {'key': 'format', 'type': 'str'},
        'labeling_job_id': {'key': 'labelingJobId', 'type': 'str'},
        'start_date_time': {'key': 'startDateTime', 'type': 'iso-8601'},
        'labeled_asset_name': {'key': 'labeledAssetName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(DatasetExportSummary, self).__init__(**kwargs)
        self.format = 'Dataset'  # type: str
        self.labeled_asset_name = None


class Datastore(Resource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.DatastoreProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'DatastoreProperties'},
    }

    def __init__(
        self,
        *,
        properties: "DatastoreProperties",
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.DatastoreProperties
        """
        super(Datastore, self).__init__(**kwargs)
        self.properties = properties


class DatastoreResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of Datastore entities.

    :ivar next_link: The link to the next page of Datastore objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type Datastore.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.Datastore]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[Datastore]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["Datastore"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of Datastore objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type Datastore.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.Datastore]
        """
        super(DatastoreResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class DataVersionBase(Resource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.DataVersionBaseProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'DataVersionBaseProperties'},
    }

    def __init__(
        self,
        *,
        properties: "DataVersionBaseProperties",
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.DataVersionBaseProperties
        """
        super(DataVersionBase, self).__init__(**kwargs)
        self.properties = properties


class DataVersionBaseProperties(AssetBase):
    """Data version base definition.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: MLTableData, UriFileDataVersion, UriFolderDataVersion.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_anonymous: If the name version are system generated (anonymous registration).
    :vartype is_anonymous: bool
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar data_type: Required. [Required] Specifies the type of data.Constant filled by server.
     Possible values include: "uri_file", "uri_folder", "mltable".
    :vartype data_type: str or ~azure.mgmt.machinelearningservices.models.DataType
    :ivar data_uri: Required. [Required] Uri of the data. Usage/meaning depends on
     Microsoft.MachineLearning.ManagementFrontEnd.Contracts.V20221001Preview.Assets.DataVersionBase.DataType.
    :vartype data_uri: str
    """

    _validation = {
        'data_type': {'required': True},
        'data_uri': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_anonymous': {'key': 'isAnonymous', 'type': 'bool'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'data_type': {'key': 'dataType', 'type': 'str'},
        'data_uri': {'key': 'dataUri', 'type': 'str'},
    }

    _subtype_map = {
        'data_type': {'mltable': 'MLTableData', 'uri_file': 'UriFileDataVersion', 'uri_folder': 'UriFolderDataVersion'}
    }

    def __init__(
        self,
        *,
        data_uri: str,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        is_anonymous: Optional[bool] = False,
        is_archived: Optional[bool] = False,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_anonymous: If the name version are system generated (anonymous registration).
        :paramtype is_anonymous: bool
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword data_uri: Required. [Required] Uri of the data. Usage/meaning depends on
         Microsoft.MachineLearning.ManagementFrontEnd.Contracts.V20221001Preview.Assets.DataVersionBase.DataType.
        :paramtype data_uri: str
        """
        super(DataVersionBaseProperties, self).__init__(description=description, properties=properties, tags=tags, is_anonymous=is_anonymous, is_archived=is_archived, **kwargs)
        self.data_type = 'DataVersionBaseProperties'  # type: str
        self.data_uri = data_uri


class DataVersionBaseResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of DataVersionBase entities.

    :ivar next_link: The link to the next page of DataVersionBase objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type DataVersionBase.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.DataVersionBase]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[DataVersionBase]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["DataVersionBase"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of DataVersionBase objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type DataVersionBase.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.DataVersionBase]
        """
        super(DataVersionBaseResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class OnlineScaleSettings(msrest.serialization.Model):
    """Online deployment scaling configuration.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DefaultScaleSettings, TargetUtilizationScaleSettings.

    All required parameters must be populated in order to send to Azure.

    :ivar scale_type: Required. [Required] Type of deployment scaling algorithm.Constant filled by
     server. Possible values include: "Default", "TargetUtilization".
    :vartype scale_type: str or ~azure.mgmt.machinelearningservices.models.ScaleType
    """

    _validation = {
        'scale_type': {'required': True},
    }

    _attribute_map = {
        'scale_type': {'key': 'scaleType', 'type': 'str'},
    }

    _subtype_map = {
        'scale_type': {'Default': 'DefaultScaleSettings', 'TargetUtilization': 'TargetUtilizationScaleSettings'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(OnlineScaleSettings, self).__init__(**kwargs)
        self.scale_type = None  # type: Optional[str]


class DefaultScaleSettings(OnlineScaleSettings):
    """DefaultScaleSettings.

    All required parameters must be populated in order to send to Azure.

    :ivar scale_type: Required. [Required] Type of deployment scaling algorithm.Constant filled by
     server. Possible values include: "Default", "TargetUtilization".
    :vartype scale_type: str or ~azure.mgmt.machinelearningservices.models.ScaleType
    """

    _validation = {
        'scale_type': {'required': True},
    }

    _attribute_map = {
        'scale_type': {'key': 'scaleType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(DefaultScaleSettings, self).__init__(**kwargs)
        self.scale_type = 'Default'  # type: str


class DeploymentLogs(msrest.serialization.Model):
    """DeploymentLogs.

    :ivar content: The retrieved online deployment logs.
    :vartype content: str
    """

    _attribute_map = {
        'content': {'key': 'content', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        content: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword content: The retrieved online deployment logs.
        :paramtype content: str
        """
        super(DeploymentLogs, self).__init__(**kwargs)
        self.content = content


class DeploymentLogsRequest(msrest.serialization.Model):
    """DeploymentLogsRequest.

    :ivar container_type: The type of container to retrieve logs from. Possible values include:
     "StorageInitializer", "InferenceServer".
    :vartype container_type: str or ~azure.mgmt.machinelearningservices.models.ContainerType
    :ivar tail: The maximum number of lines to tail.
    :vartype tail: int
    """

    _attribute_map = {
        'container_type': {'key': 'containerType', 'type': 'str'},
        'tail': {'key': 'tail', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        container_type: Optional[Union[str, "ContainerType"]] = None,
        tail: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword container_type: The type of container to retrieve logs from. Possible values include:
         "StorageInitializer", "InferenceServer".
        :paramtype container_type: str or ~azure.mgmt.machinelearningservices.models.ContainerType
        :keyword tail: The maximum number of lines to tail.
        :paramtype tail: int
        """
        super(DeploymentLogsRequest, self).__init__(**kwargs)
        self.container_type = container_type
        self.tail = tail


class ResourceConfiguration(msrest.serialization.Model):
    """ResourceConfiguration.

    :ivar instance_count: Optional number of instances or nodes used by the compute target.
    :vartype instance_count: int
    :ivar instance_type: Optional type of VM used as supported by the compute target.
    :vartype instance_type: str
    :ivar properties: Additional properties bag.
    :vartype properties: dict[str, any]
    """

    _attribute_map = {
        'instance_count': {'key': 'instanceCount', 'type': 'int'},
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        instance_count: Optional[int] = 1,
        instance_type: Optional[str] = None,
        properties: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        """
        :keyword instance_count: Optional number of instances or nodes used by the compute target.
        :paramtype instance_count: int
        :keyword instance_type: Optional type of VM used as supported by the compute target.
        :paramtype instance_type: str
        :keyword properties: Additional properties bag.
        :paramtype properties: dict[str, any]
        """
        super(ResourceConfiguration, self).__init__(**kwargs)
        self.instance_count = instance_count
        self.instance_type = instance_type
        self.properties = properties


class DeploymentResourceConfiguration(ResourceConfiguration):
    """DeploymentResourceConfiguration.

    :ivar instance_count: Optional number of instances or nodes used by the compute target.
    :vartype instance_count: int
    :ivar instance_type: Optional type of VM used as supported by the compute target.
    :vartype instance_type: str
    :ivar properties: Additional properties bag.
    :vartype properties: dict[str, any]
    """

    _attribute_map = {
        'instance_count': {'key': 'instanceCount', 'type': 'int'},
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        instance_count: Optional[int] = 1,
        instance_type: Optional[str] = None,
        properties: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        """
        :keyword instance_count: Optional number of instances or nodes used by the compute target.
        :paramtype instance_count: int
        :keyword instance_type: Optional type of VM used as supported by the compute target.
        :paramtype instance_type: str
        :keyword properties: Additional properties bag.
        :paramtype properties: dict[str, any]
        """
        super(DeploymentResourceConfiguration, self).__init__(instance_count=instance_count, instance_type=instance_type, properties=properties, **kwargs)


class DiagnoseRequestProperties(msrest.serialization.Model):
    """DiagnoseRequestProperties.

    :ivar udr: Setting for diagnosing user defined routing.
    :vartype udr: dict[str, any]
    :ivar nsg: Setting for diagnosing network security group.
    :vartype nsg: dict[str, any]
    :ivar resource_lock: Setting for diagnosing resource lock.
    :vartype resource_lock: dict[str, any]
    :ivar dns_resolution: Setting for diagnosing dns resolution.
    :vartype dns_resolution: dict[str, any]
    :ivar storage_account: Setting for diagnosing dependent storage account.
    :vartype storage_account: dict[str, any]
    :ivar key_vault: Setting for diagnosing dependent key vault.
    :vartype key_vault: dict[str, any]
    :ivar container_registry: Setting for diagnosing dependent container registry.
    :vartype container_registry: dict[str, any]
    :ivar application_insights: Setting for diagnosing dependent application insights.
    :vartype application_insights: dict[str, any]
    :ivar others: Setting for diagnosing unclassified category of problems.
    :vartype others: dict[str, any]
    """

    _attribute_map = {
        'udr': {'key': 'udr', 'type': '{object}'},
        'nsg': {'key': 'nsg', 'type': '{object}'},
        'resource_lock': {'key': 'resourceLock', 'type': '{object}'},
        'dns_resolution': {'key': 'dnsResolution', 'type': '{object}'},
        'storage_account': {'key': 'storageAccount', 'type': '{object}'},
        'key_vault': {'key': 'keyVault', 'type': '{object}'},
        'container_registry': {'key': 'containerRegistry', 'type': '{object}'},
        'application_insights': {'key': 'applicationInsights', 'type': '{object}'},
        'others': {'key': 'others', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        udr: Optional[Dict[str, Any]] = None,
        nsg: Optional[Dict[str, Any]] = None,
        resource_lock: Optional[Dict[str, Any]] = None,
        dns_resolution: Optional[Dict[str, Any]] = None,
        storage_account: Optional[Dict[str, Any]] = None,
        key_vault: Optional[Dict[str, Any]] = None,
        container_registry: Optional[Dict[str, Any]] = None,
        application_insights: Optional[Dict[str, Any]] = None,
        others: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        """
        :keyword udr: Setting for diagnosing user defined routing.
        :paramtype udr: dict[str, any]
        :keyword nsg: Setting for diagnosing network security group.
        :paramtype nsg: dict[str, any]
        :keyword resource_lock: Setting for diagnosing resource lock.
        :paramtype resource_lock: dict[str, any]
        :keyword dns_resolution: Setting for diagnosing dns resolution.
        :paramtype dns_resolution: dict[str, any]
        :keyword storage_account: Setting for diagnosing dependent storage account.
        :paramtype storage_account: dict[str, any]
        :keyword key_vault: Setting for diagnosing dependent key vault.
        :paramtype key_vault: dict[str, any]
        :keyword container_registry: Setting for diagnosing dependent container registry.
        :paramtype container_registry: dict[str, any]
        :keyword application_insights: Setting for diagnosing dependent application insights.
        :paramtype application_insights: dict[str, any]
        :keyword others: Setting for diagnosing unclassified category of problems.
        :paramtype others: dict[str, any]
        """
        super(DiagnoseRequestProperties, self).__init__(**kwargs)
        self.udr = udr
        self.nsg = nsg
        self.resource_lock = resource_lock
        self.dns_resolution = dns_resolution
        self.storage_account = storage_account
        self.key_vault = key_vault
        self.container_registry = container_registry
        self.application_insights = application_insights
        self.others = others


class DiagnoseResponseResult(msrest.serialization.Model):
    """DiagnoseResponseResult.

    :ivar value:
    :vartype value: ~azure.mgmt.machinelearningservices.models.DiagnoseResponseResultValue
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'DiagnoseResponseResultValue'},
    }

    def __init__(
        self,
        *,
        value: Optional["DiagnoseResponseResultValue"] = None,
        **kwargs
    ):
        """
        :keyword value:
        :paramtype value: ~azure.mgmt.machinelearningservices.models.DiagnoseResponseResultValue
        """
        super(DiagnoseResponseResult, self).__init__(**kwargs)
        self.value = value


class DiagnoseResponseResultValue(msrest.serialization.Model):
    """DiagnoseResponseResultValue.

    :ivar user_defined_route_results:
    :vartype user_defined_route_results:
     list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
    :ivar network_security_rule_results:
    :vartype network_security_rule_results:
     list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
    :ivar resource_lock_results:
    :vartype resource_lock_results: list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
    :ivar dns_resolution_results:
    :vartype dns_resolution_results:
     list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
    :ivar storage_account_results:
    :vartype storage_account_results:
     list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
    :ivar key_vault_results:
    :vartype key_vault_results: list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
    :ivar container_registry_results:
    :vartype container_registry_results:
     list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
    :ivar application_insights_results:
    :vartype application_insights_results:
     list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
    :ivar other_results:
    :vartype other_results: list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
    """

    _attribute_map = {
        'user_defined_route_results': {'key': 'userDefinedRouteResults', 'type': '[DiagnoseResult]'},
        'network_security_rule_results': {'key': 'networkSecurityRuleResults', 'type': '[DiagnoseResult]'},
        'resource_lock_results': {'key': 'resourceLockResults', 'type': '[DiagnoseResult]'},
        'dns_resolution_results': {'key': 'dnsResolutionResults', 'type': '[DiagnoseResult]'},
        'storage_account_results': {'key': 'storageAccountResults', 'type': '[DiagnoseResult]'},
        'key_vault_results': {'key': 'keyVaultResults', 'type': '[DiagnoseResult]'},
        'container_registry_results': {'key': 'containerRegistryResults', 'type': '[DiagnoseResult]'},
        'application_insights_results': {'key': 'applicationInsightsResults', 'type': '[DiagnoseResult]'},
        'other_results': {'key': 'otherResults', 'type': '[DiagnoseResult]'},
    }

    def __init__(
        self,
        *,
        user_defined_route_results: Optional[List["DiagnoseResult"]] = None,
        network_security_rule_results: Optional[List["DiagnoseResult"]] = None,
        resource_lock_results: Optional[List["DiagnoseResult"]] = None,
        dns_resolution_results: Optional[List["DiagnoseResult"]] = None,
        storage_account_results: Optional[List["DiagnoseResult"]] = None,
        key_vault_results: Optional[List["DiagnoseResult"]] = None,
        container_registry_results: Optional[List["DiagnoseResult"]] = None,
        application_insights_results: Optional[List["DiagnoseResult"]] = None,
        other_results: Optional[List["DiagnoseResult"]] = None,
        **kwargs
    ):
        """
        :keyword user_defined_route_results:
        :paramtype user_defined_route_results:
         list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
        :keyword network_security_rule_results:
        :paramtype network_security_rule_results:
         list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
        :keyword resource_lock_results:
        :paramtype resource_lock_results:
         list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
        :keyword dns_resolution_results:
        :paramtype dns_resolution_results:
         list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
        :keyword storage_account_results:
        :paramtype storage_account_results:
         list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
        :keyword key_vault_results:
        :paramtype key_vault_results: list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
        :keyword container_registry_results:
        :paramtype container_registry_results:
         list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
        :keyword application_insights_results:
        :paramtype application_insights_results:
         list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
        :keyword other_results:
        :paramtype other_results: list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
        """
        super(DiagnoseResponseResultValue, self).__init__(**kwargs)
        self.user_defined_route_results = user_defined_route_results
        self.network_security_rule_results = network_security_rule_results
        self.resource_lock_results = resource_lock_results
        self.dns_resolution_results = dns_resolution_results
        self.storage_account_results = storage_account_results
        self.key_vault_results = key_vault_results
        self.container_registry_results = container_registry_results
        self.application_insights_results = application_insights_results
        self.other_results = other_results


class DiagnoseResult(msrest.serialization.Model):
    """Result of Diagnose.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Code for workspace setup error.
    :vartype code: str
    :ivar level: Level of workspace setup error. Possible values include: "Warning", "Error",
     "Information".
    :vartype level: str or ~azure.mgmt.machinelearningservices.models.DiagnoseResultLevel
    :ivar message: Message of workspace setup error.
    :vartype message: str
    """

    _validation = {
        'code': {'readonly': True},
        'level': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'level': {'key': 'level', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(DiagnoseResult, self).__init__(**kwargs)
        self.code = None
        self.level = None
        self.message = None


class DiagnoseWorkspaceParameters(msrest.serialization.Model):
    """Parameters to diagnose a workspace.

    :ivar value: Value of Parameters.
    :vartype value: ~azure.mgmt.machinelearningservices.models.DiagnoseRequestProperties
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'DiagnoseRequestProperties'},
    }

    def __init__(
        self,
        *,
        value: Optional["DiagnoseRequestProperties"] = None,
        **kwargs
    ):
        """
        :keyword value: Value of Parameters.
        :paramtype value: ~azure.mgmt.machinelearningservices.models.DiagnoseRequestProperties
        """
        super(DiagnoseWorkspaceParameters, self).__init__(**kwargs)
        self.value = value


class DistributionConfiguration(msrest.serialization.Model):
    """Base definition for job distribution configuration.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: Mpi, PyTorch, TensorFlow.

    All required parameters must be populated in order to send to Azure.

    :ivar distribution_type: Required. [Required] Specifies the type of distribution
     framework.Constant filled by server. Possible values include: "PyTorch", "TensorFlow", "Mpi".
    :vartype distribution_type: str or ~azure.mgmt.machinelearningservices.models.DistributionType
    """

    _validation = {
        'distribution_type': {'required': True},
    }

    _attribute_map = {
        'distribution_type': {'key': 'distributionType', 'type': 'str'},
    }

    _subtype_map = {
        'distribution_type': {'Mpi': 'Mpi', 'PyTorch': 'PyTorch', 'TensorFlow': 'TensorFlow'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(DistributionConfiguration, self).__init__(**kwargs)
        self.distribution_type = None  # type: Optional[str]


class Docker(msrest.serialization.Model):
    """Docker.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar privileged: Indicate whether container shall run in privileged or non-privileged mode.
    :vartype privileged: bool
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'privileged': {'key': 'privileged', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        privileged: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword privileged: Indicate whether container shall run in privileged or non-privileged mode.
        :paramtype privileged: bool
        """
        super(Docker, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.privileged = privileged


class EncryptionKeyVaultProperties(msrest.serialization.Model):
    """EncryptionKeyVaultProperties.

    All required parameters must be populated in order to send to Azure.

    :ivar key_vault_arm_id: Required. The ArmId of the keyVault where the customer owned encryption
     key is present.
    :vartype key_vault_arm_id: str
    :ivar key_identifier: Required. Key vault uri to access the encryption key.
    :vartype key_identifier: str
    :ivar identity_client_id: For future use - The client id of the identity which will be used to
     access key vault.
    :vartype identity_client_id: str
    """

    _validation = {
        'key_vault_arm_id': {'required': True},
        'key_identifier': {'required': True},
    }

    _attribute_map = {
        'key_vault_arm_id': {'key': 'keyVaultArmId', 'type': 'str'},
        'key_identifier': {'key': 'keyIdentifier', 'type': 'str'},
        'identity_client_id': {'key': 'identityClientId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_vault_arm_id: str,
        key_identifier: str,
        identity_client_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword key_vault_arm_id: Required. The ArmId of the keyVault where the customer owned
         encryption key is present.
        :paramtype key_vault_arm_id: str
        :keyword key_identifier: Required. Key vault uri to access the encryption key.
        :paramtype key_identifier: str
        :keyword identity_client_id: For future use - The client id of the identity which will be used
         to access key vault.
        :paramtype identity_client_id: str
        """
        super(EncryptionKeyVaultProperties, self).__init__(**kwargs)
        self.key_vault_arm_id = key_vault_arm_id
        self.key_identifier = key_identifier
        self.identity_client_id = identity_client_id


class EncryptionKeyVaultUpdateProperties(msrest.serialization.Model):
    """EncryptionKeyVaultUpdateProperties.

    All required parameters must be populated in order to send to Azure.

    :ivar key_identifier: Required. Key Vault uri to access the encryption key.
    :vartype key_identifier: str
    """

    _validation = {
        'key_identifier': {'required': True},
    }

    _attribute_map = {
        'key_identifier': {'key': 'keyIdentifier', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_identifier: str,
        **kwargs
    ):
        """
        :keyword key_identifier: Required. Key Vault uri to access the encryption key.
        :paramtype key_identifier: str
        """
        super(EncryptionKeyVaultUpdateProperties, self).__init__(**kwargs)
        self.key_identifier = key_identifier


class EncryptionProperty(msrest.serialization.Model):
    """EncryptionProperty.

    All required parameters must be populated in order to send to Azure.

    :ivar status: Required. Indicates whether or not the encryption is enabled for the workspace.
     Possible values include: "Enabled", "Disabled".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.EncryptionStatus
    :ivar identity: The identity that will be used to access the key vault for encryption at rest.
    :vartype identity: ~azure.mgmt.machinelearningservices.models.IdentityForCmk
    :ivar key_vault_properties: Required. Customer Key vault properties.
    :vartype key_vault_properties:
     ~azure.mgmt.machinelearningservices.models.EncryptionKeyVaultProperties
    """

    _validation = {
        'status': {'required': True},
        'key_vault_properties': {'required': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'IdentityForCmk'},
        'key_vault_properties': {'key': 'keyVaultProperties', 'type': 'EncryptionKeyVaultProperties'},
    }

    def __init__(
        self,
        *,
        status: Union[str, "EncryptionStatus"],
        key_vault_properties: "EncryptionKeyVaultProperties",
        identity: Optional["IdentityForCmk"] = None,
        **kwargs
    ):
        """
        :keyword status: Required. Indicates whether or not the encryption is enabled for the
         workspace. Possible values include: "Enabled", "Disabled".
        :paramtype status: str or ~azure.mgmt.machinelearningservices.models.EncryptionStatus
        :keyword identity: The identity that will be used to access the key vault for encryption at
         rest.
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.IdentityForCmk
        :keyword key_vault_properties: Required. Customer Key vault properties.
        :paramtype key_vault_properties:
         ~azure.mgmt.machinelearningservices.models.EncryptionKeyVaultProperties
        """
        super(EncryptionProperty, self).__init__(**kwargs)
        self.status = status
        self.identity = identity
        self.key_vault_properties = key_vault_properties


class EncryptionUpdateProperties(msrest.serialization.Model):
    """EncryptionUpdateProperties.

    All required parameters must be populated in order to send to Azure.

    :ivar key_vault_properties: Required. Customer Key vault properties.
    :vartype key_vault_properties:
     ~azure.mgmt.machinelearningservices.models.EncryptionKeyVaultUpdateProperties
    """

    _validation = {
        'key_vault_properties': {'required': True},
    }

    _attribute_map = {
        'key_vault_properties': {'key': 'keyVaultProperties', 'type': 'EncryptionKeyVaultUpdateProperties'},
    }

    def __init__(
        self,
        *,
        key_vault_properties: "EncryptionKeyVaultUpdateProperties",
        **kwargs
    ):
        """
        :keyword key_vault_properties: Required. Customer Key vault properties.
        :paramtype key_vault_properties:
         ~azure.mgmt.machinelearningservices.models.EncryptionKeyVaultUpdateProperties
        """
        super(EncryptionUpdateProperties, self).__init__(**kwargs)
        self.key_vault_properties = key_vault_properties


class Endpoint(msrest.serialization.Model):
    """Endpoint.

    :ivar protocol: Protocol over which communication will happen over this endpoint. Possible
     values include: "tcp", "udp", "http". Default value: "tcp".
    :vartype protocol: str or ~azure.mgmt.machinelearningservices.models.Protocol
    :ivar name: Name of the Endpoint.
    :vartype name: str
    :ivar target: Application port inside the container.
    :vartype target: int
    :ivar published: Port over which the application is exposed from container.
    :vartype published: int
    :ivar host_ip: Host IP over which the application is exposed from the container.
    :vartype host_ip: str
    """

    _attribute_map = {
        'protocol': {'key': 'protocol', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'target': {'key': 'target', 'type': 'int'},
        'published': {'key': 'published', 'type': 'int'},
        'host_ip': {'key': 'hostIp', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        protocol: Optional[Union[str, "Protocol"]] = "tcp",
        name: Optional[str] = None,
        target: Optional[int] = None,
        published: Optional[int] = None,
        host_ip: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword protocol: Protocol over which communication will happen over this endpoint. Possible
         values include: "tcp", "udp", "http". Default value: "tcp".
        :paramtype protocol: str or ~azure.mgmt.machinelearningservices.models.Protocol
        :keyword name: Name of the Endpoint.
        :paramtype name: str
        :keyword target: Application port inside the container.
        :paramtype target: int
        :keyword published: Port over which the application is exposed from container.
        :paramtype published: int
        :keyword host_ip: Host IP over which the application is exposed from the container.
        :paramtype host_ip: str
        """
        super(Endpoint, self).__init__(**kwargs)
        self.protocol = protocol
        self.name = name
        self.target = target
        self.published = published
        self.host_ip = host_ip


class EndpointAuthKeys(msrest.serialization.Model):
    """Keys for endpoint authentication.

    :ivar primary_key: The primary key.
    :vartype primary_key: str
    :ivar secondary_key: The secondary key.
    :vartype secondary_key: str
    """

    _attribute_map = {
        'primary_key': {'key': 'primaryKey', 'type': 'str'},
        'secondary_key': {'key': 'secondaryKey', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        primary_key: Optional[str] = None,
        secondary_key: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword primary_key: The primary key.
        :paramtype primary_key: str
        :keyword secondary_key: The secondary key.
        :paramtype secondary_key: str
        """
        super(EndpointAuthKeys, self).__init__(**kwargs)
        self.primary_key = primary_key
        self.secondary_key = secondary_key


class EndpointAuthToken(msrest.serialization.Model):
    """Service Token.

    :ivar access_token: Access token for endpoint authentication.
    :vartype access_token: str
    :ivar expiry_time_utc: Access token expiry time (UTC).
    :vartype expiry_time_utc: long
    :ivar refresh_after_time_utc: Refresh access token after time (UTC).
    :vartype refresh_after_time_utc: long
    :ivar token_type: Access token type.
    :vartype token_type: str
    """

    _attribute_map = {
        'access_token': {'key': 'accessToken', 'type': 'str'},
        'expiry_time_utc': {'key': 'expiryTimeUtc', 'type': 'long'},
        'refresh_after_time_utc': {'key': 'refreshAfterTimeUtc', 'type': 'long'},
        'token_type': {'key': 'tokenType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        access_token: Optional[str] = None,
        expiry_time_utc: Optional[int] = 0,
        refresh_after_time_utc: Optional[int] = 0,
        token_type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword access_token: Access token for endpoint authentication.
        :paramtype access_token: str
        :keyword expiry_time_utc: Access token expiry time (UTC).
        :paramtype expiry_time_utc: long
        :keyword refresh_after_time_utc: Refresh access token after time (UTC).
        :paramtype refresh_after_time_utc: long
        :keyword token_type: Access token type.
        :paramtype token_type: str
        """
        super(EndpointAuthToken, self).__init__(**kwargs)
        self.access_token = access_token
        self.expiry_time_utc = expiry_time_utc
        self.refresh_after_time_utc = refresh_after_time_utc
        self.token_type = token_type


class ScheduleActionBase(msrest.serialization.Model):
    """ScheduleActionBase.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: JobScheduleAction, EndpointScheduleAction.

    All required parameters must be populated in order to send to Azure.

    :ivar action_type: Required. [Required] Specifies the action type of the schedule.Constant
     filled by server. Possible values include: "CreateJob", "InvokeBatchEndpoint".
    :vartype action_type: str or ~azure.mgmt.machinelearningservices.models.ScheduleActionType
    """

    _validation = {
        'action_type': {'required': True},
    }

    _attribute_map = {
        'action_type': {'key': 'actionType', 'type': 'str'},
    }

    _subtype_map = {
        'action_type': {'CreateJob': 'JobScheduleAction', 'InvokeBatchEndpoint': 'EndpointScheduleAction'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ScheduleActionBase, self).__init__(**kwargs)
        self.action_type = None  # type: Optional[str]


class EndpointScheduleAction(ScheduleActionBase):
    """EndpointScheduleAction.

    All required parameters must be populated in order to send to Azure.

    :ivar action_type: Required. [Required] Specifies the action type of the schedule.Constant
     filled by server. Possible values include: "CreateJob", "InvokeBatchEndpoint".
    :vartype action_type: str or ~azure.mgmt.machinelearningservices.models.ScheduleActionType
    :ivar endpoint_invocation_definition: Required. [Required] Defines Schedule action definition
     details.


     .. raw:: html

        <see href="TBD" />.
    :vartype endpoint_invocation_definition: any
    """

    _validation = {
        'action_type': {'required': True},
        'endpoint_invocation_definition': {'required': True},
    }

    _attribute_map = {
        'action_type': {'key': 'actionType', 'type': 'str'},
        'endpoint_invocation_definition': {'key': 'endpointInvocationDefinition', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        endpoint_invocation_definition: Any,
        **kwargs
    ):
        """
        :keyword endpoint_invocation_definition: Required. [Required] Defines Schedule action
         definition details.


         .. raw:: html

            <see href="TBD" />.
        :paramtype endpoint_invocation_definition: any
        """
        super(EndpointScheduleAction, self).__init__(**kwargs)
        self.action_type = 'InvokeBatchEndpoint'  # type: str
        self.endpoint_invocation_definition = endpoint_invocation_definition


class EnvironmentContainer(Resource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.EnvironmentContainerProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'EnvironmentContainerProperties'},
    }

    def __init__(
        self,
        *,
        properties: "EnvironmentContainerProperties",
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties:
         ~azure.mgmt.machinelearningservices.models.EnvironmentContainerProperties
        """
        super(EnvironmentContainer, self).__init__(**kwargs)
        self.properties = properties


class EnvironmentContainerProperties(AssetContainer):
    """Container for environment specification versions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar latest_version: The latest version inside this container.
    :vartype latest_version: str
    :ivar next_version: The next auto incremental version.
    :vartype next_version: str
    :ivar provisioning_state: Provisioning state for the environment container. Possible values
     include: "Succeeded", "Failed", "Canceled", "Creating", "Updating", "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.AssetProvisioningState
    """

    _validation = {
        'latest_version': {'readonly': True},
        'next_version': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'latest_version': {'key': 'latestVersion', 'type': 'str'},
        'next_version': {'key': 'nextVersion', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        is_archived: Optional[bool] = False,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        """
        super(EnvironmentContainerProperties, self).__init__(description=description, properties=properties, tags=tags, is_archived=is_archived, **kwargs)
        self.provisioning_state = None


class EnvironmentContainerResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of EnvironmentContainer entities.

    :ivar next_link: The link to the next page of EnvironmentContainer objects. If null, there are
     no additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type EnvironmentContainer.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.EnvironmentContainer]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[EnvironmentContainer]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["EnvironmentContainer"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of EnvironmentContainer objects. If null, there
         are no additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type EnvironmentContainer.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.EnvironmentContainer]
        """
        super(EnvironmentContainerResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class EnvironmentVariable(msrest.serialization.Model):
    """EnvironmentVariable.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar type: Type of the Environment Variable. Possible values are: local - For local variable.
     Possible values include: "local". Default value: "local".
    :vartype type: str or ~azure.mgmt.machinelearningservices.models.EnvironmentVariableType
    :ivar value: Value of the Environment variable.
    :vartype value: str
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        type: Optional[Union[str, "EnvironmentVariableType"]] = "local",
        value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword type: Type of the Environment Variable. Possible values are: local - For local
         variable. Possible values include: "local". Default value: "local".
        :paramtype type: str or ~azure.mgmt.machinelearningservices.models.EnvironmentVariableType
        :keyword value: Value of the Environment variable.
        :paramtype value: str
        """
        super(EnvironmentVariable, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = type
        self.value = value


class EnvironmentVersion(Resource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.EnvironmentVersionProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'EnvironmentVersionProperties'},
    }

    def __init__(
        self,
        *,
        properties: "EnvironmentVersionProperties",
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.EnvironmentVersionProperties
        """
        super(EnvironmentVersion, self).__init__(**kwargs)
        self.properties = properties


class EnvironmentVersionProperties(AssetBase):
    """Environment version details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_anonymous: If the name version are system generated (anonymous registration).
    :vartype is_anonymous: bool
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar build: Configuration settings for Docker build context.
    :vartype build: ~azure.mgmt.machinelearningservices.models.BuildContext
    :ivar conda_file: Standard configuration file used by Conda that lets you install any kind of
     package, including Python, R, and C/C++ packages.


     .. raw:: html

        <see
     href="https://repo2docker.readthedocs.io/en/latest/config_files.html#environment-yml-install-a-conda-environment"
     />.
    :vartype conda_file: str
    :ivar environment_type: Environment type is either user managed or curated by the Azure ML
     service


     .. raw:: html

        <see
     href="https://learn.microsoft.com/azure/machine-learning/resource-curated-environments"
     />. Possible values include: "Curated", "UserCreated".
    :vartype environment_type: str or ~azure.mgmt.machinelearningservices.models.EnvironmentType
    :ivar image: Name of the image that will be used for the environment.


     .. raw:: html

        <seealso
     href="https://learn.microsoft.com/azure/machine-learning/how-to-deploy-custom-docker-image#use-a-custom-base-image"
     />.
    :vartype image: str
    :ivar inference_config: Defines configuration specific to inference.
    :vartype inference_config:
     ~azure.mgmt.machinelearningservices.models.InferenceContainerProperties
    :ivar os_type: The OS type of the environment. Possible values include: "Linux", "Windows".
    :vartype os_type: str or ~azure.mgmt.machinelearningservices.models.OperatingSystemType
    :ivar provisioning_state: Provisioning state for the environment version. Possible values
     include: "Succeeded", "Failed", "Canceled", "Creating", "Updating", "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.AssetProvisioningState
    """

    _validation = {
        'environment_type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_anonymous': {'key': 'isAnonymous', 'type': 'bool'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'build': {'key': 'build', 'type': 'BuildContext'},
        'conda_file': {'key': 'condaFile', 'type': 'str'},
        'environment_type': {'key': 'environmentType', 'type': 'str'},
        'image': {'key': 'image', 'type': 'str'},
        'inference_config': {'key': 'inferenceConfig', 'type': 'InferenceContainerProperties'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        is_anonymous: Optional[bool] = False,
        is_archived: Optional[bool] = False,
        build: Optional["BuildContext"] = None,
        conda_file: Optional[str] = None,
        image: Optional[str] = None,
        inference_config: Optional["InferenceContainerProperties"] = None,
        os_type: Optional[Union[str, "OperatingSystemType"]] = None,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_anonymous: If the name version are system generated (anonymous registration).
        :paramtype is_anonymous: bool
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword build: Configuration settings for Docker build context.
        :paramtype build: ~azure.mgmt.machinelearningservices.models.BuildContext
        :keyword conda_file: Standard configuration file used by Conda that lets you install any kind
         of package, including Python, R, and C/C++ packages.


         .. raw:: html

            <see
         href="https://repo2docker.readthedocs.io/en/latest/config_files.html#environment-yml-install-a-conda-environment"
         />.
        :paramtype conda_file: str
        :keyword image: Name of the image that will be used for the environment.


         .. raw:: html

            <seealso
         href="https://learn.microsoft.com/azure/machine-learning/how-to-deploy-custom-docker-image#use-a-custom-base-image"
         />.
        :paramtype image: str
        :keyword inference_config: Defines configuration specific to inference.
        :paramtype inference_config:
         ~azure.mgmt.machinelearningservices.models.InferenceContainerProperties
        :keyword os_type: The OS type of the environment. Possible values include: "Linux", "Windows".
        :paramtype os_type: str or ~azure.mgmt.machinelearningservices.models.OperatingSystemType
        """
        super(EnvironmentVersionProperties, self).__init__(description=description, properties=properties, tags=tags, is_anonymous=is_anonymous, is_archived=is_archived, **kwargs)
        self.build = build
        self.conda_file = conda_file
        self.environment_type = None
        self.image = image
        self.inference_config = inference_config
        self.os_type = os_type
        self.provisioning_state = None


class EnvironmentVersionResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of EnvironmentVersion entities.

    :ivar next_link: The link to the next page of EnvironmentVersion objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type EnvironmentVersion.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.EnvironmentVersion]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[EnvironmentVersion]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["EnvironmentVersion"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of EnvironmentVersion objects. If null, there are
         no additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type EnvironmentVersion.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.EnvironmentVersion]
        """
        super(EnvironmentVersionResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(msrest.serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.machinelearningservices.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.machinelearningservices.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetail]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ErrorDetail, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(msrest.serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.machinelearningservices.models.ErrorDetail
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDetail'},
    }

    def __init__(
        self,
        *,
        error: Optional["ErrorDetail"] = None,
        **kwargs
    ):
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.machinelearningservices.models.ErrorDetail
        """
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = error


class EstimatedVMPrice(msrest.serialization.Model):
    """The estimated price info for using a VM of a particular OS type, tier, etc.

    All required parameters must be populated in order to send to Azure.

    :ivar retail_price: Required. The price charged for using the VM.
    :vartype retail_price: float
    :ivar os_type: Required. Operating system type used by the VM. Possible values include:
     "Linux", "Windows".
    :vartype os_type: str or ~azure.mgmt.machinelearningservices.models.VMPriceOSType
    :ivar vm_tier: Required. The type of the VM. Possible values include: "Standard",
     "LowPriority", "Spot".
    :vartype vm_tier: str or ~azure.mgmt.machinelearningservices.models.VMTier
    """

    _validation = {
        'retail_price': {'required': True},
        'os_type': {'required': True},
        'vm_tier': {'required': True},
    }

    _attribute_map = {
        'retail_price': {'key': 'retailPrice', 'type': 'float'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'vm_tier': {'key': 'vmTier', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        retail_price: float,
        os_type: Union[str, "VMPriceOSType"],
        vm_tier: Union[str, "VMTier"],
        **kwargs
    ):
        """
        :keyword retail_price: Required. The price charged for using the VM.
        :paramtype retail_price: float
        :keyword os_type: Required. Operating system type used by the VM. Possible values include:
         "Linux", "Windows".
        :paramtype os_type: str or ~azure.mgmt.machinelearningservices.models.VMPriceOSType
        :keyword vm_tier: Required. The type of the VM. Possible values include: "Standard",
         "LowPriority", "Spot".
        :paramtype vm_tier: str or ~azure.mgmt.machinelearningservices.models.VMTier
        """
        super(EstimatedVMPrice, self).__init__(**kwargs)
        self.retail_price = retail_price
        self.os_type = os_type
        self.vm_tier = vm_tier


class EstimatedVMPrices(msrest.serialization.Model):
    """The estimated price info for using a VM.

    All required parameters must be populated in order to send to Azure.

    :ivar billing_currency: Required. Three lettered code specifying the currency of the VM price.
     Example: USD. Possible values include: "USD".
    :vartype billing_currency: str or ~azure.mgmt.machinelearningservices.models.BillingCurrency
    :ivar unit_of_measure: Required. The unit of time measurement for the specified VM price.
     Example: OneHour. Possible values include: "OneHour".
    :vartype unit_of_measure: str or ~azure.mgmt.machinelearningservices.models.UnitOfMeasure
    :ivar values: Required. The list of estimated prices for using a VM of a particular OS type,
     tier, etc.
    :vartype values: list[~azure.mgmt.machinelearningservices.models.EstimatedVMPrice]
    """

    _validation = {
        'billing_currency': {'required': True},
        'unit_of_measure': {'required': True},
        'values': {'required': True},
    }

    _attribute_map = {
        'billing_currency': {'key': 'billingCurrency', 'type': 'str'},
        'unit_of_measure': {'key': 'unitOfMeasure', 'type': 'str'},
        'values': {'key': 'values', 'type': '[EstimatedVMPrice]'},
    }

    def __init__(
        self,
        *,
        billing_currency: Union[str, "BillingCurrency"],
        unit_of_measure: Union[str, "UnitOfMeasure"],
        values: List["EstimatedVMPrice"],
        **kwargs
    ):
        """
        :keyword billing_currency: Required. Three lettered code specifying the currency of the VM
         price. Example: USD. Possible values include: "USD".
        :paramtype billing_currency: str or ~azure.mgmt.machinelearningservices.models.BillingCurrency
        :keyword unit_of_measure: Required. The unit of time measurement for the specified VM price.
         Example: OneHour. Possible values include: "OneHour".
        :paramtype unit_of_measure: str or ~azure.mgmt.machinelearningservices.models.UnitOfMeasure
        :keyword values: Required. The list of estimated prices for using a VM of a particular OS type,
         tier, etc.
        :paramtype values: list[~azure.mgmt.machinelearningservices.models.EstimatedVMPrice]
        """
        super(EstimatedVMPrices, self).__init__(**kwargs)
        self.billing_currency = billing_currency
        self.unit_of_measure = unit_of_measure
        self.values = values


class ExternalFQDNResponse(msrest.serialization.Model):
    """ExternalFQDNResponse.

    :ivar value:
    :vartype value: list[~azure.mgmt.machinelearningservices.models.FQDNEndpoints]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[FQDNEndpoints]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["FQDNEndpoints"]] = None,
        **kwargs
    ):
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.FQDNEndpoints]
        """
        super(ExternalFQDNResponse, self).__init__(**kwargs)
        self.value = value


class FeaturizationSettings(msrest.serialization.Model):
    """Featurization Configuration.

    :ivar dataset_language: Dataset language, useful for the text data.
    :vartype dataset_language: str
    """

    _attribute_map = {
        'dataset_language': {'key': 'datasetLanguage', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        dataset_language: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword dataset_language: Dataset language, useful for the text data.
        :paramtype dataset_language: str
        """
        super(FeaturizationSettings, self).__init__(**kwargs)
        self.dataset_language = dataset_language


class FlavorData(msrest.serialization.Model):
    """FlavorData.

    :ivar data: Model flavor-specific data.
    :vartype data: dict[str, str]
    """

    _attribute_map = {
        'data': {'key': 'data', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        data: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword data: Model flavor-specific data.
        :paramtype data: dict[str, str]
        """
        super(FlavorData, self).__init__(**kwargs)
        self.data = data


class Forecasting(AutoMLVertical, TableVertical):
    """Forecasting task in AutoML Table vertical.

    All required parameters must be populated in order to send to Azure.

    :ivar cv_split_column_names: Columns to use for CVSplit data.
    :vartype cv_split_column_names: list[str]
    :ivar featurization_settings: Featurization inputs needed for AutoML job.
    :vartype featurization_settings:
     ~azure.mgmt.machinelearningservices.models.TableVerticalFeaturizationSettings
    :ivar fixed_parameters: Model/training parameters that will remain constant throughout
     training.
    :vartype fixed_parameters: ~azure.mgmt.machinelearningservices.models.TableFixedParameters
    :ivar limit_settings: Execution constraints for AutoMLJob.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.TableVerticalLimitSettings
    :ivar n_cross_validations: Number of cross validation folds to be applied on training dataset
     when validation dataset is not provided.
    :vartype n_cross_validations: ~azure.mgmt.machinelearningservices.models.NCrossValidations
    :ivar search_space: Search space for sampling different combinations of models and their
     hyperparameters.
    :vartype search_space: list[~azure.mgmt.machinelearningservices.models.TableParameterSubspace]
    :ivar sweep_settings: Settings for model sweeping and hyperparameter tuning.
    :vartype sweep_settings: ~azure.mgmt.machinelearningservices.models.TableSweepSettings
    :ivar test_data: Test data input.
    :vartype test_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar test_data_size: The fraction of test dataset that needs to be set aside for validation
     purpose.
     Values between (0.0 , 1.0)
     Applied when validation dataset is not provided.
    :vartype test_data_size: float
    :ivar validation_data: Validation data inputs.
    :vartype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar validation_data_size: The fraction of training dataset that needs to be set aside for
     validation purpose.
     Values between (0.0 , 1.0)
     Applied when validation dataset is not provided.
    :vartype validation_data_size: float
    :ivar weight_column_name: The name of the sample weight column. Automated ML supports a
     weighted column as an input, causing rows in the data to be weighted up or down.
    :vartype weight_column_name: str
    :ivar log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
     "Info", "Warning", "Error", "Critical".
    :vartype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
    :ivar target_column_name: Target column name: This is prediction values column.
     Also known as label column name in context of classification tasks.
    :vartype target_column_name: str
    :ivar task_type: Required. [Required] Task type for AutoMLJob.Constant filled by server.
     Possible values include: "Classification", "Regression", "Forecasting", "ImageClassification",
     "ImageClassificationMultilabel", "ImageObjectDetection", "ImageInstanceSegmentation",
     "TextClassification", "TextClassificationMultilabel", "TextNER".
    :vartype task_type: str or ~azure.mgmt.machinelearningservices.models.TaskType
    :ivar training_data: Required. [Required] Training data input.
    :vartype training_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar forecasting_settings: Forecasting task specific inputs.
    :vartype forecasting_settings: ~azure.mgmt.machinelearningservices.models.ForecastingSettings
    :ivar primary_metric: Primary metric for forecasting task. Possible values include:
     "SpearmanCorrelation", "NormalizedRootMeanSquaredError", "R2Score",
     "NormalizedMeanAbsoluteError".
    :vartype primary_metric: str or
     ~azure.mgmt.machinelearningservices.models.ForecastingPrimaryMetrics
    :ivar training_settings: Inputs for training phase for an AutoML Job.
    :vartype training_settings:
     ~azure.mgmt.machinelearningservices.models.ForecastingTrainingSettings
    """

    _validation = {
        'task_type': {'required': True},
        'training_data': {'required': True},
    }

    _attribute_map = {
        'cv_split_column_names': {'key': 'cvSplitColumnNames', 'type': '[str]'},
        'featurization_settings': {'key': 'featurizationSettings', 'type': 'TableVerticalFeaturizationSettings'},
        'fixed_parameters': {'key': 'fixedParameters', 'type': 'TableFixedParameters'},
        'limit_settings': {'key': 'limitSettings', 'type': 'TableVerticalLimitSettings'},
        'n_cross_validations': {'key': 'nCrossValidations', 'type': 'NCrossValidations'},
        'search_space': {'key': 'searchSpace', 'type': '[TableParameterSubspace]'},
        'sweep_settings': {'key': 'sweepSettings', 'type': 'TableSweepSettings'},
        'test_data': {'key': 'testData', 'type': 'MLTableJobInput'},
        'test_data_size': {'key': 'testDataSize', 'type': 'float'},
        'validation_data': {'key': 'validationData', 'type': 'MLTableJobInput'},
        'validation_data_size': {'key': 'validationDataSize', 'type': 'float'},
        'weight_column_name': {'key': 'weightColumnName', 'type': 'str'},
        'log_verbosity': {'key': 'logVerbosity', 'type': 'str'},
        'target_column_name': {'key': 'targetColumnName', 'type': 'str'},
        'task_type': {'key': 'taskType', 'type': 'str'},
        'training_data': {'key': 'trainingData', 'type': 'MLTableJobInput'},
        'forecasting_settings': {'key': 'forecastingSettings', 'type': 'ForecastingSettings'},
        'primary_metric': {'key': 'primaryMetric', 'type': 'str'},
        'training_settings': {'key': 'trainingSettings', 'type': 'ForecastingTrainingSettings'},
    }

    def __init__(
        self,
        *,
        training_data: "MLTableJobInput",
        cv_split_column_names: Optional[List[str]] = None,
        featurization_settings: Optional["TableVerticalFeaturizationSettings"] = None,
        fixed_parameters: Optional["TableFixedParameters"] = None,
        limit_settings: Optional["TableVerticalLimitSettings"] = None,
        n_cross_validations: Optional["NCrossValidations"] = None,
        search_space: Optional[List["TableParameterSubspace"]] = None,
        sweep_settings: Optional["TableSweepSettings"] = None,
        test_data: Optional["MLTableJobInput"] = None,
        test_data_size: Optional[float] = None,
        validation_data: Optional["MLTableJobInput"] = None,
        validation_data_size: Optional[float] = None,
        weight_column_name: Optional[str] = None,
        log_verbosity: Optional[Union[str, "LogVerbosity"]] = None,
        target_column_name: Optional[str] = None,
        forecasting_settings: Optional["ForecastingSettings"] = None,
        primary_metric: Optional[Union[str, "ForecastingPrimaryMetrics"]] = None,
        training_settings: Optional["ForecastingTrainingSettings"] = None,
        **kwargs
    ):
        """
        :keyword cv_split_column_names: Columns to use for CVSplit data.
        :paramtype cv_split_column_names: list[str]
        :keyword featurization_settings: Featurization inputs needed for AutoML job.
        :paramtype featurization_settings:
         ~azure.mgmt.machinelearningservices.models.TableVerticalFeaturizationSettings
        :keyword fixed_parameters: Model/training parameters that will remain constant throughout
         training.
        :paramtype fixed_parameters: ~azure.mgmt.machinelearningservices.models.TableFixedParameters
        :keyword limit_settings: Execution constraints for AutoMLJob.
        :paramtype limit_settings:
         ~azure.mgmt.machinelearningservices.models.TableVerticalLimitSettings
        :keyword n_cross_validations: Number of cross validation folds to be applied on training
         dataset
         when validation dataset is not provided.
        :paramtype n_cross_validations: ~azure.mgmt.machinelearningservices.models.NCrossValidations
        :keyword search_space: Search space for sampling different combinations of models and their
         hyperparameters.
        :paramtype search_space:
         list[~azure.mgmt.machinelearningservices.models.TableParameterSubspace]
        :keyword sweep_settings: Settings for model sweeping and hyperparameter tuning.
        :paramtype sweep_settings: ~azure.mgmt.machinelearningservices.models.TableSweepSettings
        :keyword test_data: Test data input.
        :paramtype test_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword test_data_size: The fraction of test dataset that needs to be set aside for validation
         purpose.
         Values between (0.0 , 1.0)
         Applied when validation dataset is not provided.
        :paramtype test_data_size: float
        :keyword validation_data: Validation data inputs.
        :paramtype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword validation_data_size: The fraction of training dataset that needs to be set aside for
         validation purpose.
         Values between (0.0 , 1.0)
         Applied when validation dataset is not provided.
        :paramtype validation_data_size: float
        :keyword weight_column_name: The name of the sample weight column. Automated ML supports a
         weighted column as an input, causing rows in the data to be weighted up or down.
        :paramtype weight_column_name: str
        :keyword log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
         "Info", "Warning", "Error", "Critical".
        :paramtype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
        :keyword target_column_name: Target column name: This is prediction values column.
         Also known as label column name in context of classification tasks.
        :paramtype target_column_name: str
        :keyword training_data: Required. [Required] Training data input.
        :paramtype training_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword forecasting_settings: Forecasting task specific inputs.
        :paramtype forecasting_settings: ~azure.mgmt.machinelearningservices.models.ForecastingSettings
        :keyword primary_metric: Primary metric for forecasting task. Possible values include:
         "SpearmanCorrelation", "NormalizedRootMeanSquaredError", "R2Score",
         "NormalizedMeanAbsoluteError".
        :paramtype primary_metric: str or
         ~azure.mgmt.machinelearningservices.models.ForecastingPrimaryMetrics
        :keyword training_settings: Inputs for training phase for an AutoML Job.
        :paramtype training_settings:
         ~azure.mgmt.machinelearningservices.models.ForecastingTrainingSettings
        """
        super(Forecasting, self).__init__(log_verbosity=log_verbosity, target_column_name=target_column_name, training_data=training_data, cv_split_column_names=cv_split_column_names, featurization_settings=featurization_settings, fixed_parameters=fixed_parameters, limit_settings=limit_settings, n_cross_validations=n_cross_validations, search_space=search_space, sweep_settings=sweep_settings, test_data=test_data, test_data_size=test_data_size, validation_data=validation_data, validation_data_size=validation_data_size, weight_column_name=weight_column_name, **kwargs)
        self.cv_split_column_names = cv_split_column_names
        self.featurization_settings = featurization_settings
        self.fixed_parameters = fixed_parameters
        self.limit_settings = limit_settings
        self.n_cross_validations = n_cross_validations
        self.search_space = search_space
        self.sweep_settings = sweep_settings
        self.test_data = test_data
        self.test_data_size = test_data_size
        self.validation_data = validation_data
        self.validation_data_size = validation_data_size
        self.weight_column_name = weight_column_name
        self.task_type = 'Forecasting'  # type: str
        self.forecasting_settings = forecasting_settings
        self.primary_metric = primary_metric
        self.training_settings = training_settings
        self.log_verbosity = log_verbosity
        self.target_column_name = target_column_name
        self.training_data = training_data


class ForecastingSettings(msrest.serialization.Model):
    """Forecasting specific parameters.

    :ivar country_or_region_for_holidays: Country or region for holidays for forecasting tasks.
     These should be ISO 3166 two-letter country/region codes, for example 'US' or 'GB'.
    :vartype country_or_region_for_holidays: str
    :ivar cv_step_size: Number of periods between the origin time of one CV fold and the next fold.
     For
     example, if ``CVStepSize`` = 3 for daily data, the origin time for each fold will be
     three days apart.
    :vartype cv_step_size: int
    :ivar feature_lags: Flag for generating lags for the numeric features with 'auto' or null.
     Possible values include: "None", "Auto".
    :vartype feature_lags: str or ~azure.mgmt.machinelearningservices.models.FeatureLags
    :ivar forecast_horizon: The desired maximum forecast horizon in units of time-series frequency.
    :vartype forecast_horizon: ~azure.mgmt.machinelearningservices.models.ForecastHorizon
    :ivar frequency: When forecasting, this parameter represents the period with which the forecast
     is desired, for example daily, weekly, yearly, etc. The forecast frequency is dataset frequency
     by default.
    :vartype frequency: str
    :ivar seasonality: Set time series seasonality as an integer multiple of the series frequency.
     If seasonality is set to 'auto', it will be inferred.
    :vartype seasonality: ~azure.mgmt.machinelearningservices.models.Seasonality
    :ivar short_series_handling_config: The parameter defining how if AutoML should handle short
     time series. Possible values include: "None", "Auto", "Pad", "Drop".
    :vartype short_series_handling_config: str or
     ~azure.mgmt.machinelearningservices.models.ShortSeriesHandlingConfiguration
    :ivar target_aggregate_function: The function to be used to aggregate the time series target
     column to conform to a user specified frequency.
     If the TargetAggregateFunction is set i.e. not 'None', but the freq parameter is not set, the
     error is raised. The possible target aggregation functions are: "sum", "max", "min" and "mean".
     Possible values include: "None", "Sum", "Max", "Min", "Mean".
    :vartype target_aggregate_function: str or
     ~azure.mgmt.machinelearningservices.models.TargetAggregationFunction
    :ivar target_lags: The number of past periods to lag from the target column.
    :vartype target_lags: ~azure.mgmt.machinelearningservices.models.TargetLags
    :ivar target_rolling_window_size: The number of past periods used to create a rolling window
     average of the target column.
    :vartype target_rolling_window_size:
     ~azure.mgmt.machinelearningservices.models.TargetRollingWindowSize
    :ivar time_column_name: The name of the time column. This parameter is required when
     forecasting to specify the datetime column in the input data used for building the time series
     and inferring its frequency.
    :vartype time_column_name: str
    :ivar time_series_id_column_names: The names of columns used to group a timeseries. It can be
     used to create multiple series.
     If grain is not defined, the data set is assumed to be one time-series. This parameter is used
     with task type forecasting.
    :vartype time_series_id_column_names: list[str]
    :ivar use_stl: Configure STL Decomposition of the time-series target column. Possible values
     include: "None", "Season", "SeasonTrend".
    :vartype use_stl: str or ~azure.mgmt.machinelearningservices.models.UseStl
    """

    _attribute_map = {
        'country_or_region_for_holidays': {'key': 'countryOrRegionForHolidays', 'type': 'str'},
        'cv_step_size': {'key': 'cvStepSize', 'type': 'int'},
        'feature_lags': {'key': 'featureLags', 'type': 'str'},
        'forecast_horizon': {'key': 'forecastHorizon', 'type': 'ForecastHorizon'},
        'frequency': {'key': 'frequency', 'type': 'str'},
        'seasonality': {'key': 'seasonality', 'type': 'Seasonality'},
        'short_series_handling_config': {'key': 'shortSeriesHandlingConfig', 'type': 'str'},
        'target_aggregate_function': {'key': 'targetAggregateFunction', 'type': 'str'},
        'target_lags': {'key': 'targetLags', 'type': 'TargetLags'},
        'target_rolling_window_size': {'key': 'targetRollingWindowSize', 'type': 'TargetRollingWindowSize'},
        'time_column_name': {'key': 'timeColumnName', 'type': 'str'},
        'time_series_id_column_names': {'key': 'timeSeriesIdColumnNames', 'type': '[str]'},
        'use_stl': {'key': 'useStl', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        country_or_region_for_holidays: Optional[str] = None,
        cv_step_size: Optional[int] = None,
        feature_lags: Optional[Union[str, "FeatureLags"]] = None,
        forecast_horizon: Optional["ForecastHorizon"] = None,
        frequency: Optional[str] = None,
        seasonality: Optional["Seasonality"] = None,
        short_series_handling_config: Optional[Union[str, "ShortSeriesHandlingConfiguration"]] = None,
        target_aggregate_function: Optional[Union[str, "TargetAggregationFunction"]] = None,
        target_lags: Optional["TargetLags"] = None,
        target_rolling_window_size: Optional["TargetRollingWindowSize"] = None,
        time_column_name: Optional[str] = None,
        time_series_id_column_names: Optional[List[str]] = None,
        use_stl: Optional[Union[str, "UseStl"]] = None,
        **kwargs
    ):
        """
        :keyword country_or_region_for_holidays: Country or region for holidays for forecasting tasks.
         These should be ISO 3166 two-letter country/region codes, for example 'US' or 'GB'.
        :paramtype country_or_region_for_holidays: str
        :keyword cv_step_size: Number of periods between the origin time of one CV fold and the next
         fold. For
         example, if ``CVStepSize`` = 3 for daily data, the origin time for each fold will be
         three days apart.
        :paramtype cv_step_size: int
        :keyword feature_lags: Flag for generating lags for the numeric features with 'auto' or null.
         Possible values include: "None", "Auto".
        :paramtype feature_lags: str or ~azure.mgmt.machinelearningservices.models.FeatureLags
        :keyword forecast_horizon: The desired maximum forecast horizon in units of time-series
         frequency.
        :paramtype forecast_horizon: ~azure.mgmt.machinelearningservices.models.ForecastHorizon
        :keyword frequency: When forecasting, this parameter represents the period with which the
         forecast is desired, for example daily, weekly, yearly, etc. The forecast frequency is dataset
         frequency by default.
        :paramtype frequency: str
        :keyword seasonality: Set time series seasonality as an integer multiple of the series
         frequency.
         If seasonality is set to 'auto', it will be inferred.
        :paramtype seasonality: ~azure.mgmt.machinelearningservices.models.Seasonality
        :keyword short_series_handling_config: The parameter defining how if AutoML should handle short
         time series. Possible values include: "None", "Auto", "Pad", "Drop".
        :paramtype short_series_handling_config: str or
         ~azure.mgmt.machinelearningservices.models.ShortSeriesHandlingConfiguration
        :keyword target_aggregate_function: The function to be used to aggregate the time series target
         column to conform to a user specified frequency.
         If the TargetAggregateFunction is set i.e. not 'None', but the freq parameter is not set, the
         error is raised. The possible target aggregation functions are: "sum", "max", "min" and "mean".
         Possible values include: "None", "Sum", "Max", "Min", "Mean".
        :paramtype target_aggregate_function: str or
         ~azure.mgmt.machinelearningservices.models.TargetAggregationFunction
        :keyword target_lags: The number of past periods to lag from the target column.
        :paramtype target_lags: ~azure.mgmt.machinelearningservices.models.TargetLags
        :keyword target_rolling_window_size: The number of past periods used to create a rolling window
         average of the target column.
        :paramtype target_rolling_window_size:
         ~azure.mgmt.machinelearningservices.models.TargetRollingWindowSize
        :keyword time_column_name: The name of the time column. This parameter is required when
         forecasting to specify the datetime column in the input data used for building the time series
         and inferring its frequency.
        :paramtype time_column_name: str
        :keyword time_series_id_column_names: The names of columns used to group a timeseries. It can
         be used to create multiple series.
         If grain is not defined, the data set is assumed to be one time-series. This parameter is used
         with task type forecasting.
        :paramtype time_series_id_column_names: list[str]
        :keyword use_stl: Configure STL Decomposition of the time-series target column. Possible values
         include: "None", "Season", "SeasonTrend".
        :paramtype use_stl: str or ~azure.mgmt.machinelearningservices.models.UseStl
        """
        super(ForecastingSettings, self).__init__(**kwargs)
        self.country_or_region_for_holidays = country_or_region_for_holidays
        self.cv_step_size = cv_step_size
        self.feature_lags = feature_lags
        self.forecast_horizon = forecast_horizon
        self.frequency = frequency
        self.seasonality = seasonality
        self.short_series_handling_config = short_series_handling_config
        self.target_aggregate_function = target_aggregate_function
        self.target_lags = target_lags
        self.target_rolling_window_size = target_rolling_window_size
        self.time_column_name = time_column_name
        self.time_series_id_column_names = time_series_id_column_names
        self.use_stl = use_stl


class ForecastingTrainingSettings(TrainingSettings):
    """Forecasting Training related configuration.

    :ivar enable_dnn_training: Enable recommendation of DNN models.
    :vartype enable_dnn_training: bool
    :ivar enable_model_explainability: Flag to turn on explainability on best model.
    :vartype enable_model_explainability: bool
    :ivar enable_onnx_compatible_models: Flag for enabling onnx compatible models.
    :vartype enable_onnx_compatible_models: bool
    :ivar enable_stack_ensemble: Enable stack ensemble run.
    :vartype enable_stack_ensemble: bool
    :ivar enable_vote_ensemble: Enable voting ensemble run.
    :vartype enable_vote_ensemble: bool
    :ivar ensemble_model_download_timeout: During VotingEnsemble and StackEnsemble model
     generation, multiple fitted models from the previous child runs are downloaded.
     Configure this parameter with a higher value than 300 secs, if more time is needed.
    :vartype ensemble_model_download_timeout: ~datetime.timedelta
    :ivar stack_ensemble_settings: Stack ensemble settings for stack ensemble run.
    :vartype stack_ensemble_settings:
     ~azure.mgmt.machinelearningservices.models.StackEnsembleSettings
    :ivar allowed_training_algorithms: Allowed models for forecasting task.
    :vartype allowed_training_algorithms: list[str or
     ~azure.mgmt.machinelearningservices.models.ForecastingModels]
    :ivar blocked_training_algorithms: Blocked models for forecasting task.
    :vartype blocked_training_algorithms: list[str or
     ~azure.mgmt.machinelearningservices.models.ForecastingModels]
    """

    _attribute_map = {
        'enable_dnn_training': {'key': 'enableDnnTraining', 'type': 'bool'},
        'enable_model_explainability': {'key': 'enableModelExplainability', 'type': 'bool'},
        'enable_onnx_compatible_models': {'key': 'enableOnnxCompatibleModels', 'type': 'bool'},
        'enable_stack_ensemble': {'key': 'enableStackEnsemble', 'type': 'bool'},
        'enable_vote_ensemble': {'key': 'enableVoteEnsemble', 'type': 'bool'},
        'ensemble_model_download_timeout': {'key': 'ensembleModelDownloadTimeout', 'type': 'duration'},
        'stack_ensemble_settings': {'key': 'stackEnsembleSettings', 'type': 'StackEnsembleSettings'},
        'allowed_training_algorithms': {'key': 'allowedTrainingAlgorithms', 'type': '[str]'},
        'blocked_training_algorithms': {'key': 'blockedTrainingAlgorithms', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        enable_dnn_training: Optional[bool] = False,
        enable_model_explainability: Optional[bool] = True,
        enable_onnx_compatible_models: Optional[bool] = False,
        enable_stack_ensemble: Optional[bool] = True,
        enable_vote_ensemble: Optional[bool] = True,
        ensemble_model_download_timeout: Optional[datetime.timedelta] = "PT5M",
        stack_ensemble_settings: Optional["StackEnsembleSettings"] = None,
        allowed_training_algorithms: Optional[List[Union[str, "ForecastingModels"]]] = None,
        blocked_training_algorithms: Optional[List[Union[str, "ForecastingModels"]]] = None,
        **kwargs
    ):
        """
        :keyword enable_dnn_training: Enable recommendation of DNN models.
        :paramtype enable_dnn_training: bool
        :keyword enable_model_explainability: Flag to turn on explainability on best model.
        :paramtype enable_model_explainability: bool
        :keyword enable_onnx_compatible_models: Flag for enabling onnx compatible models.
        :paramtype enable_onnx_compatible_models: bool
        :keyword enable_stack_ensemble: Enable stack ensemble run.
        :paramtype enable_stack_ensemble: bool
        :keyword enable_vote_ensemble: Enable voting ensemble run.
        :paramtype enable_vote_ensemble: bool
        :keyword ensemble_model_download_timeout: During VotingEnsemble and StackEnsemble model
         generation, multiple fitted models from the previous child runs are downloaded.
         Configure this parameter with a higher value than 300 secs, if more time is needed.
        :paramtype ensemble_model_download_timeout: ~datetime.timedelta
        :keyword stack_ensemble_settings: Stack ensemble settings for stack ensemble run.
        :paramtype stack_ensemble_settings:
         ~azure.mgmt.machinelearningservices.models.StackEnsembleSettings
        :keyword allowed_training_algorithms: Allowed models for forecasting task.
        :paramtype allowed_training_algorithms: list[str or
         ~azure.mgmt.machinelearningservices.models.ForecastingModels]
        :keyword blocked_training_algorithms: Blocked models for forecasting task.
        :paramtype blocked_training_algorithms: list[str or
         ~azure.mgmt.machinelearningservices.models.ForecastingModels]
        """
        super(ForecastingTrainingSettings, self).__init__(enable_dnn_training=enable_dnn_training, enable_model_explainability=enable_model_explainability, enable_onnx_compatible_models=enable_onnx_compatible_models, enable_stack_ensemble=enable_stack_ensemble, enable_vote_ensemble=enable_vote_ensemble, ensemble_model_download_timeout=ensemble_model_download_timeout, stack_ensemble_settings=stack_ensemble_settings, **kwargs)
        self.allowed_training_algorithms = allowed_training_algorithms
        self.blocked_training_algorithms = blocked_training_algorithms


class FQDNEndpoint(msrest.serialization.Model):
    """FQDNEndpoint.

    :ivar domain_name:
    :vartype domain_name: str
    :ivar endpoint_details:
    :vartype endpoint_details: list[~azure.mgmt.machinelearningservices.models.FQDNEndpointDetail]
    """

    _attribute_map = {
        'domain_name': {'key': 'domainName', 'type': 'str'},
        'endpoint_details': {'key': 'endpointDetails', 'type': '[FQDNEndpointDetail]'},
    }

    def __init__(
        self,
        *,
        domain_name: Optional[str] = None,
        endpoint_details: Optional[List["FQDNEndpointDetail"]] = None,
        **kwargs
    ):
        """
        :keyword domain_name:
        :paramtype domain_name: str
        :keyword endpoint_details:
        :paramtype endpoint_details:
         list[~azure.mgmt.machinelearningservices.models.FQDNEndpointDetail]
        """
        super(FQDNEndpoint, self).__init__(**kwargs)
        self.domain_name = domain_name
        self.endpoint_details = endpoint_details


class FQDNEndpointDetail(msrest.serialization.Model):
    """FQDNEndpointDetail.

    :ivar port:
    :vartype port: int
    """

    _attribute_map = {
        'port': {'key': 'port', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        port: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword port:
        :paramtype port: int
        """
        super(FQDNEndpointDetail, self).__init__(**kwargs)
        self.port = port


class FQDNEndpoints(msrest.serialization.Model):
    """FQDNEndpoints.

    :ivar properties:
    :vartype properties: ~azure.mgmt.machinelearningservices.models.FQDNEndpointsProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'FQDNEndpointsProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["FQDNEndpointsProperties"] = None,
        **kwargs
    ):
        """
        :keyword properties:
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.FQDNEndpointsProperties
        """
        super(FQDNEndpoints, self).__init__(**kwargs)
        self.properties = properties


class FQDNEndpointsProperties(msrest.serialization.Model):
    """FQDNEndpointsProperties.

    :ivar category:
    :vartype category: str
    :ivar endpoints:
    :vartype endpoints: list[~azure.mgmt.machinelearningservices.models.FQDNEndpoint]
    """

    _attribute_map = {
        'category': {'key': 'category', 'type': 'str'},
        'endpoints': {'key': 'endpoints', 'type': '[FQDNEndpoint]'},
    }

    def __init__(
        self,
        *,
        category: Optional[str] = None,
        endpoints: Optional[List["FQDNEndpoint"]] = None,
        **kwargs
    ):
        """
        :keyword category:
        :paramtype category: str
        :keyword endpoints:
        :paramtype endpoints: list[~azure.mgmt.machinelearningservices.models.FQDNEndpoint]
        """
        super(FQDNEndpointsProperties, self).__init__(**kwargs)
        self.category = category
        self.endpoints = endpoints


class GridSamplingAlgorithm(SamplingAlgorithm):
    """Defines a Sampling Algorithm that exhaustively generates every value combination in the space.

    All required parameters must be populated in order to send to Azure.

    :ivar sampling_algorithm_type: Required. [Required] The algorithm used for generating
     hyperparameter values, along with configuration properties.Constant filled by server. Possible
     values include: "Grid", "Random", "Bayesian".
    :vartype sampling_algorithm_type: str or
     ~azure.mgmt.machinelearningservices.models.SamplingAlgorithmType
    """

    _validation = {
        'sampling_algorithm_type': {'required': True},
    }

    _attribute_map = {
        'sampling_algorithm_type': {'key': 'samplingAlgorithmType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(GridSamplingAlgorithm, self).__init__(**kwargs)
        self.sampling_algorithm_type = 'Grid'  # type: str


class HdfsDatastore(DatastoreProperties):
    """HdfsDatastore.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar credentials: Required. [Required] Account credentials.
    :vartype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
    :ivar datastore_type: Required. [Required] Storage type backing the datastore.Constant filled
     by server. Possible values include: "AzureBlob", "AzureDataLakeGen1", "AzureDataLakeGen2",
     "AzureFile", "Hdfs".
    :vartype datastore_type: str or ~azure.mgmt.machinelearningservices.models.DatastoreType
    :ivar is_default: Readonly property to indicate if datastore is the workspace default
     datastore.
    :vartype is_default: bool
    :ivar hdfs_server_certificate: The TLS cert of the HDFS server. Needs to be a base64 encoded
     string. Required if "Https" protocol is selected.
    :vartype hdfs_server_certificate: str
    :ivar name_node_address: Required. [Required] IP Address or DNS HostName.
    :vartype name_node_address: str
    :ivar protocol: Protocol used to communicate with the storage account (Https/Http).
    :vartype protocol: str
    """

    _validation = {
        'credentials': {'required': True},
        'datastore_type': {'required': True},
        'is_default': {'readonly': True},
        'name_node_address': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'credentials': {'key': 'credentials', 'type': 'DatastoreCredentials'},
        'datastore_type': {'key': 'datastoreType', 'type': 'str'},
        'is_default': {'key': 'isDefault', 'type': 'bool'},
        'hdfs_server_certificate': {'key': 'hdfsServerCertificate', 'type': 'str'},
        'name_node_address': {'key': 'nameNodeAddress', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        credentials: "DatastoreCredentials",
        name_node_address: str,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        hdfs_server_certificate: Optional[str] = None,
        protocol: Optional[str] = "http",
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword credentials: Required. [Required] Account credentials.
        :paramtype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
        :keyword hdfs_server_certificate: The TLS cert of the HDFS server. Needs to be a base64 encoded
         string. Required if "Https" protocol is selected.
        :paramtype hdfs_server_certificate: str
        :keyword name_node_address: Required. [Required] IP Address or DNS HostName.
        :paramtype name_node_address: str
        :keyword protocol: Protocol used to communicate with the storage account (Https/Http).
        :paramtype protocol: str
        """
        super(HdfsDatastore, self).__init__(description=description, properties=properties, tags=tags, credentials=credentials, **kwargs)
        self.datastore_type = 'Hdfs'  # type: str
        self.hdfs_server_certificate = hdfs_server_certificate
        self.name_node_address = name_node_address
        self.protocol = protocol


class HDInsightSchema(msrest.serialization.Model):
    """HDInsightSchema.

    :ivar properties: HDInsight compute properties.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.HDInsightProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'HDInsightProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["HDInsightProperties"] = None,
        **kwargs
    ):
        """
        :keyword properties: HDInsight compute properties.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.HDInsightProperties
        """
        super(HDInsightSchema, self).__init__(**kwargs)
        self.properties = properties


class HDInsight(Compute, HDInsightSchema):
    """A HDInsight compute.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar properties: HDInsight compute properties.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.HDInsightProperties
    :ivar compute_type: Required. The type of compute.Constant filled by server. Possible values
     include: "AKS", "Kubernetes", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine",
     "HDInsight", "Databricks", "DataLakeAnalytics", "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :ivar compute_location: Location for the underlying compute.
    :vartype compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values are Unknown,
     Updating, Provisioning, Succeeded, and Failed. Possible values include: "Unknown", "Updating",
     "Creating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ComputeProvisioningState
    :ivar description: The description of the Machine Learning compute.
    :vartype description: str
    :ivar created_on: The time at which the compute was created.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: The time at which the compute was last modified.
    :vartype modified_on: ~datetime.datetime
    :ivar resource_id: ARM resource id of the underlying compute.
    :vartype resource_id: str
    :ivar provisioning_errors: Errors during provisioning.
    :vartype provisioning_errors: list[~azure.mgmt.machinelearningservices.models.ErrorResponse]
    :ivar is_attached_compute: Indicating whether the compute was provisioned by user and brought
     from outside if true, or machine learning service provisioned it if false.
    :vartype is_attached_compute: bool
    :ivar disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI
     and AAD exclusively for authentication.
    :vartype disable_local_auth: bool
    """

    _validation = {
        'compute_type': {'required': True},
        'compute_location': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'modified_on': {'readonly': True},
        'provisioning_errors': {'readonly': True},
        'is_attached_compute': {'readonly': True},
        'disable_local_auth': {'readonly': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'HDInsightProperties'},
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'compute_location': {'key': 'computeLocation', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'modified_on': {'key': 'modifiedOn', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'provisioning_errors': {'key': 'provisioningErrors', 'type': '[ErrorResponse]'},
        'is_attached_compute': {'key': 'isAttachedCompute', 'type': 'bool'},
        'disable_local_auth': {'key': 'disableLocalAuth', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        properties: Optional["HDInsightProperties"] = None,
        description: Optional[str] = None,
        resource_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword properties: HDInsight compute properties.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.HDInsightProperties
        :keyword description: The description of the Machine Learning compute.
        :paramtype description: str
        :keyword resource_id: ARM resource id of the underlying compute.
        :paramtype resource_id: str
        """
        super(HDInsight, self).__init__(description=description, resource_id=resource_id, properties=properties, **kwargs)
        self.properties = properties
        self.compute_type = 'HDInsight'  # type: str
        self.compute_location = None
        self.provisioning_state = None
        self.description = description
        self.created_on = None
        self.modified_on = None
        self.resource_id = resource_id
        self.provisioning_errors = None
        self.is_attached_compute = None
        self.disable_local_auth = None


class HDInsightProperties(msrest.serialization.Model):
    """HDInsight compute properties.

    :ivar ssh_port: Port open for ssh connections on the master node of the cluster.
    :vartype ssh_port: int
    :ivar address: Public IP address of the master node of the cluster.
    :vartype address: str
    :ivar administrator_account: Admin credentials for master node of the cluster.
    :vartype administrator_account:
     ~azure.mgmt.machinelearningservices.models.VirtualMachineSshCredentials
    """

    _attribute_map = {
        'ssh_port': {'key': 'sshPort', 'type': 'int'},
        'address': {'key': 'address', 'type': 'str'},
        'administrator_account': {'key': 'administratorAccount', 'type': 'VirtualMachineSshCredentials'},
    }

    def __init__(
        self,
        *,
        ssh_port: Optional[int] = None,
        address: Optional[str] = None,
        administrator_account: Optional["VirtualMachineSshCredentials"] = None,
        **kwargs
    ):
        """
        :keyword ssh_port: Port open for ssh connections on the master node of the cluster.
        :paramtype ssh_port: int
        :keyword address: Public IP address of the master node of the cluster.
        :paramtype address: str
        :keyword administrator_account: Admin credentials for master node of the cluster.
        :paramtype administrator_account:
         ~azure.mgmt.machinelearningservices.models.VirtualMachineSshCredentials
        """
        super(HDInsightProperties, self).__init__(**kwargs)
        self.ssh_port = ssh_port
        self.address = address
        self.administrator_account = administrator_account


class IdAssetReference(AssetReferenceBase):
    """Reference to an asset via its ARM resource ID.

    All required parameters must be populated in order to send to Azure.

    :ivar reference_type: Required. [Required] Specifies the type of asset reference.Constant
     filled by server. Possible values include: "Id", "DataPath", "OutputPath".
    :vartype reference_type: str or ~azure.mgmt.machinelearningservices.models.ReferenceType
    :ivar asset_id: Required. [Required] ARM resource ID of the asset.
    :vartype asset_id: str
    """

    _validation = {
        'reference_type': {'required': True},
        'asset_id': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'reference_type': {'key': 'referenceType', 'type': 'str'},
        'asset_id': {'key': 'assetId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        asset_id: str,
        **kwargs
    ):
        """
        :keyword asset_id: Required. [Required] ARM resource ID of the asset.
        :paramtype asset_id: str
        """
        super(IdAssetReference, self).__init__(**kwargs)
        self.reference_type = 'Id'  # type: str
        self.asset_id = asset_id


class IdentityForCmk(msrest.serialization.Model):
    """Identity that will be used to access key vault for encryption at rest.

    :ivar user_assigned_identity: The ArmId of the user assigned identity that will be used to
     access the customer managed key vault.
    :vartype user_assigned_identity: str
    """

    _attribute_map = {
        'user_assigned_identity': {'key': 'userAssignedIdentity', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        user_assigned_identity: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword user_assigned_identity: The ArmId of the user assigned identity that will be used to
         access the customer managed key vault.
        :paramtype user_assigned_identity: str
        """
        super(IdentityForCmk, self).__init__(**kwargs)
        self.user_assigned_identity = user_assigned_identity


class IdleShutdownSetting(msrest.serialization.Model):
    """Stops compute instance after user defined period of inactivity.

    :ivar idle_time_before_shutdown: Time is defined in ISO8601 format. Minimum is 15 min, maximum
     is 3 days.
    :vartype idle_time_before_shutdown: str
    """

    _attribute_map = {
        'idle_time_before_shutdown': {'key': 'idleTimeBeforeShutdown', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        idle_time_before_shutdown: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword idle_time_before_shutdown: Time is defined in ISO8601 format. Minimum is 15 min,
         maximum is 3 days.
        :paramtype idle_time_before_shutdown: str
        """
        super(IdleShutdownSetting, self).__init__(**kwargs)
        self.idle_time_before_shutdown = idle_time_before_shutdown


class Image(msrest.serialization.Model):
    """Image.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar type: Type of the image. Possible values are: docker - For docker images. azureml - For
     AzureML images. Possible values include: "docker", "azureml". Default value: "docker".
    :vartype type: str or ~azure.mgmt.machinelearningservices.models.ImageType
    :ivar reference: Image reference URL.
    :vartype reference: str
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'reference': {'key': 'reference', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        type: Optional[Union[str, "ImageType"]] = "docker",
        reference: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword type: Type of the image. Possible values are: docker - For docker images. azureml -
         For AzureML images. Possible values include: "docker", "azureml". Default value: "docker".
        :paramtype type: str or ~azure.mgmt.machinelearningservices.models.ImageType
        :keyword reference: Image reference URL.
        :paramtype reference: str
        """
        super(Image, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = type
        self.reference = reference


class ImageVertical(msrest.serialization.Model):
    """Abstract class for AutoML tasks that train image (computer vision) models -
such as Image Classification / Image Classification Multilabel / Image Object Detection / Image Instance Segmentation.

    All required parameters must be populated in order to send to Azure.

    :ivar limit_settings: Required. [Required] Limit settings for the AutoML job.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
    :ivar sweep_settings: Model sweeping and hyperparameter sweeping related settings.
    :vartype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
    :ivar validation_data: Validation data inputs.
    :vartype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar validation_data_size: The fraction of training dataset that needs to be set aside for
     validation purpose.
     Values between (0.0 , 1.0)
     Applied when validation dataset is not provided.
    :vartype validation_data_size: float
    """

    _validation = {
        'limit_settings': {'required': True},
    }

    _attribute_map = {
        'limit_settings': {'key': 'limitSettings', 'type': 'ImageLimitSettings'},
        'sweep_settings': {'key': 'sweepSettings', 'type': 'ImageSweepSettings'},
        'validation_data': {'key': 'validationData', 'type': 'MLTableJobInput'},
        'validation_data_size': {'key': 'validationDataSize', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        limit_settings: "ImageLimitSettings",
        sweep_settings: Optional["ImageSweepSettings"] = None,
        validation_data: Optional["MLTableJobInput"] = None,
        validation_data_size: Optional[float] = None,
        **kwargs
    ):
        """
        :keyword limit_settings: Required. [Required] Limit settings for the AutoML job.
        :paramtype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
        :keyword sweep_settings: Model sweeping and hyperparameter sweeping related settings.
        :paramtype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
        :keyword validation_data: Validation data inputs.
        :paramtype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword validation_data_size: The fraction of training dataset that needs to be set aside for
         validation purpose.
         Values between (0.0 , 1.0)
         Applied when validation dataset is not provided.
        :paramtype validation_data_size: float
        """
        super(ImageVertical, self).__init__(**kwargs)
        self.limit_settings = limit_settings
        self.sweep_settings = sweep_settings
        self.validation_data = validation_data
        self.validation_data_size = validation_data_size


class ImageClassificationBase(ImageVertical):
    """ImageClassificationBase.

    All required parameters must be populated in order to send to Azure.

    :ivar limit_settings: Required. [Required] Limit settings for the AutoML job.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
    :ivar sweep_settings: Model sweeping and hyperparameter sweeping related settings.
    :vartype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
    :ivar validation_data: Validation data inputs.
    :vartype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar validation_data_size: The fraction of training dataset that needs to be set aside for
     validation purpose.
     Values between (0.0 , 1.0)
     Applied when validation dataset is not provided.
    :vartype validation_data_size: float
    :ivar model_settings: Settings used for training the model.
    :vartype model_settings:
     ~azure.mgmt.machinelearningservices.models.ImageModelSettingsClassification
    :ivar search_space: Search space for sampling different combinations of models and their
     hyperparameters.
    :vartype search_space:
     list[~azure.mgmt.machinelearningservices.models.ImageModelDistributionSettingsClassification]
    """

    _validation = {
        'limit_settings': {'required': True},
    }

    _attribute_map = {
        'limit_settings': {'key': 'limitSettings', 'type': 'ImageLimitSettings'},
        'sweep_settings': {'key': 'sweepSettings', 'type': 'ImageSweepSettings'},
        'validation_data': {'key': 'validationData', 'type': 'MLTableJobInput'},
        'validation_data_size': {'key': 'validationDataSize', 'type': 'float'},
        'model_settings': {'key': 'modelSettings', 'type': 'ImageModelSettingsClassification'},
        'search_space': {'key': 'searchSpace', 'type': '[ImageModelDistributionSettingsClassification]'},
    }

    def __init__(
        self,
        *,
        limit_settings: "ImageLimitSettings",
        sweep_settings: Optional["ImageSweepSettings"] = None,
        validation_data: Optional["MLTableJobInput"] = None,
        validation_data_size: Optional[float] = None,
        model_settings: Optional["ImageModelSettingsClassification"] = None,
        search_space: Optional[List["ImageModelDistributionSettingsClassification"]] = None,
        **kwargs
    ):
        """
        :keyword limit_settings: Required. [Required] Limit settings for the AutoML job.
        :paramtype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
        :keyword sweep_settings: Model sweeping and hyperparameter sweeping related settings.
        :paramtype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
        :keyword validation_data: Validation data inputs.
        :paramtype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword validation_data_size: The fraction of training dataset that needs to be set aside for
         validation purpose.
         Values between (0.0 , 1.0)
         Applied when validation dataset is not provided.
        :paramtype validation_data_size: float
        :keyword model_settings: Settings used for training the model.
        :paramtype model_settings:
         ~azure.mgmt.machinelearningservices.models.ImageModelSettingsClassification
        :keyword search_space: Search space for sampling different combinations of models and their
         hyperparameters.
        :paramtype search_space:
         list[~azure.mgmt.machinelearningservices.models.ImageModelDistributionSettingsClassification]
        """
        super(ImageClassificationBase, self).__init__(limit_settings=limit_settings, sweep_settings=sweep_settings, validation_data=validation_data, validation_data_size=validation_data_size, **kwargs)
        self.model_settings = model_settings
        self.search_space = search_space


class ImageClassification(AutoMLVertical, ImageClassificationBase):
    """Image Classification. Multi-class image classification is used when an image is classified with only a single label
from a set of classes - e.g. each image is classified as either an image of a 'cat' or a 'dog' or a 'duck'.

    All required parameters must be populated in order to send to Azure.

    :ivar limit_settings: Required. [Required] Limit settings for the AutoML job.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
    :ivar sweep_settings: Model sweeping and hyperparameter sweeping related settings.
    :vartype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
    :ivar validation_data: Validation data inputs.
    :vartype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar validation_data_size: The fraction of training dataset that needs to be set aside for
     validation purpose.
     Values between (0.0 , 1.0)
     Applied when validation dataset is not provided.
    :vartype validation_data_size: float
    :ivar model_settings: Settings used for training the model.
    :vartype model_settings:
     ~azure.mgmt.machinelearningservices.models.ImageModelSettingsClassification
    :ivar search_space: Search space for sampling different combinations of models and their
     hyperparameters.
    :vartype search_space:
     list[~azure.mgmt.machinelearningservices.models.ImageModelDistributionSettingsClassification]
    :ivar log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
     "Info", "Warning", "Error", "Critical".
    :vartype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
    :ivar target_column_name: Target column name: This is prediction values column.
     Also known as label column name in context of classification tasks.
    :vartype target_column_name: str
    :ivar task_type: Required. [Required] Task type for AutoMLJob.Constant filled by server.
     Possible values include: "Classification", "Regression", "Forecasting", "ImageClassification",
     "ImageClassificationMultilabel", "ImageObjectDetection", "ImageInstanceSegmentation",
     "TextClassification", "TextClassificationMultilabel", "TextNER".
    :vartype task_type: str or ~azure.mgmt.machinelearningservices.models.TaskType
    :ivar training_data: Required. [Required] Training data input.
    :vartype training_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar primary_metric: Primary metric to optimize for this task. Possible values include:
     "AUCWeighted", "Accuracy", "NormMacroRecall", "AveragePrecisionScoreWeighted",
     "PrecisionScoreWeighted".
    :vartype primary_metric: str or
     ~azure.mgmt.machinelearningservices.models.ClassificationPrimaryMetrics
    """

    _validation = {
        'limit_settings': {'required': True},
        'task_type': {'required': True},
        'training_data': {'required': True},
    }

    _attribute_map = {
        'limit_settings': {'key': 'limitSettings', 'type': 'ImageLimitSettings'},
        'sweep_settings': {'key': 'sweepSettings', 'type': 'ImageSweepSettings'},
        'validation_data': {'key': 'validationData', 'type': 'MLTableJobInput'},
        'validation_data_size': {'key': 'validationDataSize', 'type': 'float'},
        'model_settings': {'key': 'modelSettings', 'type': 'ImageModelSettingsClassification'},
        'search_space': {'key': 'searchSpace', 'type': '[ImageModelDistributionSettingsClassification]'},
        'log_verbosity': {'key': 'logVerbosity', 'type': 'str'},
        'target_column_name': {'key': 'targetColumnName', 'type': 'str'},
        'task_type': {'key': 'taskType', 'type': 'str'},
        'training_data': {'key': 'trainingData', 'type': 'MLTableJobInput'},
        'primary_metric': {'key': 'primaryMetric', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        limit_settings: "ImageLimitSettings",
        training_data: "MLTableJobInput",
        sweep_settings: Optional["ImageSweepSettings"] = None,
        validation_data: Optional["MLTableJobInput"] = None,
        validation_data_size: Optional[float] = None,
        model_settings: Optional["ImageModelSettingsClassification"] = None,
        search_space: Optional[List["ImageModelDistributionSettingsClassification"]] = None,
        log_verbosity: Optional[Union[str, "LogVerbosity"]] = None,
        target_column_name: Optional[str] = None,
        primary_metric: Optional[Union[str, "ClassificationPrimaryMetrics"]] = None,
        **kwargs
    ):
        """
        :keyword limit_settings: Required. [Required] Limit settings for the AutoML job.
        :paramtype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
        :keyword sweep_settings: Model sweeping and hyperparameter sweeping related settings.
        :paramtype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
        :keyword validation_data: Validation data inputs.
        :paramtype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword validation_data_size: The fraction of training dataset that needs to be set aside for
         validation purpose.
         Values between (0.0 , 1.0)
         Applied when validation dataset is not provided.
        :paramtype validation_data_size: float
        :keyword model_settings: Settings used for training the model.
        :paramtype model_settings:
         ~azure.mgmt.machinelearningservices.models.ImageModelSettingsClassification
        :keyword search_space: Search space for sampling different combinations of models and their
         hyperparameters.
        :paramtype search_space:
         list[~azure.mgmt.machinelearningservices.models.ImageModelDistributionSettingsClassification]
        :keyword log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
         "Info", "Warning", "Error", "Critical".
        :paramtype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
        :keyword target_column_name: Target column name: This is prediction values column.
         Also known as label column name in context of classification tasks.
        :paramtype target_column_name: str
        :keyword training_data: Required. [Required] Training data input.
        :paramtype training_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword primary_metric: Primary metric to optimize for this task. Possible values include:
         "AUCWeighted", "Accuracy", "NormMacroRecall", "AveragePrecisionScoreWeighted",
         "PrecisionScoreWeighted".
        :paramtype primary_metric: str or
         ~azure.mgmt.machinelearningservices.models.ClassificationPrimaryMetrics
        """
        super(ImageClassification, self).__init__(log_verbosity=log_verbosity, target_column_name=target_column_name, training_data=training_data, limit_settings=limit_settings, sweep_settings=sweep_settings, validation_data=validation_data, validation_data_size=validation_data_size, model_settings=model_settings, search_space=search_space, **kwargs)
        self.limit_settings = limit_settings
        self.sweep_settings = sweep_settings
        self.validation_data = validation_data
        self.validation_data_size = validation_data_size
        self.model_settings = model_settings
        self.search_space = search_space
        self.task_type = 'ImageClassification'  # type: str
        self.primary_metric = primary_metric
        self.log_verbosity = log_verbosity
        self.target_column_name = target_column_name
        self.training_data = training_data


class ImageClassificationMultilabel(AutoMLVertical, ImageClassificationBase):
    """Image Classification Multilabel. Multi-label image classification is used when an image could have one or more labels
from a set of labels - e.g. an image could be labeled with both 'cat' and 'dog'.

    All required parameters must be populated in order to send to Azure.

    :ivar limit_settings: Required. [Required] Limit settings for the AutoML job.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
    :ivar sweep_settings: Model sweeping and hyperparameter sweeping related settings.
    :vartype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
    :ivar validation_data: Validation data inputs.
    :vartype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar validation_data_size: The fraction of training dataset that needs to be set aside for
     validation purpose.
     Values between (0.0 , 1.0)
     Applied when validation dataset is not provided.
    :vartype validation_data_size: float
    :ivar model_settings: Settings used for training the model.
    :vartype model_settings:
     ~azure.mgmt.machinelearningservices.models.ImageModelSettingsClassification
    :ivar search_space: Search space for sampling different combinations of models and their
     hyperparameters.
    :vartype search_space:
     list[~azure.mgmt.machinelearningservices.models.ImageModelDistributionSettingsClassification]
    :ivar log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
     "Info", "Warning", "Error", "Critical".
    :vartype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
    :ivar target_column_name: Target column name: This is prediction values column.
     Also known as label column name in context of classification tasks.
    :vartype target_column_name: str
    :ivar task_type: Required. [Required] Task type for AutoMLJob.Constant filled by server.
     Possible values include: "Classification", "Regression", "Forecasting", "ImageClassification",
     "ImageClassificationMultilabel", "ImageObjectDetection", "ImageInstanceSegmentation",
     "TextClassification", "TextClassificationMultilabel", "TextNER".
    :vartype task_type: str or ~azure.mgmt.machinelearningservices.models.TaskType
    :ivar training_data: Required. [Required] Training data input.
    :vartype training_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar primary_metric: Primary metric to optimize for this task. Possible values include:
     "AUCWeighted", "Accuracy", "NormMacroRecall", "AveragePrecisionScoreWeighted",
     "PrecisionScoreWeighted", "IOU".
    :vartype primary_metric: str or
     ~azure.mgmt.machinelearningservices.models.ClassificationMultilabelPrimaryMetrics
    """

    _validation = {
        'limit_settings': {'required': True},
        'task_type': {'required': True},
        'training_data': {'required': True},
    }

    _attribute_map = {
        'limit_settings': {'key': 'limitSettings', 'type': 'ImageLimitSettings'},
        'sweep_settings': {'key': 'sweepSettings', 'type': 'ImageSweepSettings'},
        'validation_data': {'key': 'validationData', 'type': 'MLTableJobInput'},
        'validation_data_size': {'key': 'validationDataSize', 'type': 'float'},
        'model_settings': {'key': 'modelSettings', 'type': 'ImageModelSettingsClassification'},
        'search_space': {'key': 'searchSpace', 'type': '[ImageModelDistributionSettingsClassification]'},
        'log_verbosity': {'key': 'logVerbosity', 'type': 'str'},
        'target_column_name': {'key': 'targetColumnName', 'type': 'str'},
        'task_type': {'key': 'taskType', 'type': 'str'},
        'training_data': {'key': 'trainingData', 'type': 'MLTableJobInput'},
        'primary_metric': {'key': 'primaryMetric', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        limit_settings: "ImageLimitSettings",
        training_data: "MLTableJobInput",
        sweep_settings: Optional["ImageSweepSettings"] = None,
        validation_data: Optional["MLTableJobInput"] = None,
        validation_data_size: Optional[float] = None,
        model_settings: Optional["ImageModelSettingsClassification"] = None,
        search_space: Optional[List["ImageModelDistributionSettingsClassification"]] = None,
        log_verbosity: Optional[Union[str, "LogVerbosity"]] = None,
        target_column_name: Optional[str] = None,
        primary_metric: Optional[Union[str, "ClassificationMultilabelPrimaryMetrics"]] = None,
        **kwargs
    ):
        """
        :keyword limit_settings: Required. [Required] Limit settings for the AutoML job.
        :paramtype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
        :keyword sweep_settings: Model sweeping and hyperparameter sweeping related settings.
        :paramtype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
        :keyword validation_data: Validation data inputs.
        :paramtype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword validation_data_size: The fraction of training dataset that needs to be set aside for
         validation purpose.
         Values between (0.0 , 1.0)
         Applied when validation dataset is not provided.
        :paramtype validation_data_size: float
        :keyword model_settings: Settings used for training the model.
        :paramtype model_settings:
         ~azure.mgmt.machinelearningservices.models.ImageModelSettingsClassification
        :keyword search_space: Search space for sampling different combinations of models and their
         hyperparameters.
        :paramtype search_space:
         list[~azure.mgmt.machinelearningservices.models.ImageModelDistributionSettingsClassification]
        :keyword log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
         "Info", "Warning", "Error", "Critical".
        :paramtype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
        :keyword target_column_name: Target column name: This is prediction values column.
         Also known as label column name in context of classification tasks.
        :paramtype target_column_name: str
        :keyword training_data: Required. [Required] Training data input.
        :paramtype training_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword primary_metric: Primary metric to optimize for this task. Possible values include:
         "AUCWeighted", "Accuracy", "NormMacroRecall", "AveragePrecisionScoreWeighted",
         "PrecisionScoreWeighted", "IOU".
        :paramtype primary_metric: str or
         ~azure.mgmt.machinelearningservices.models.ClassificationMultilabelPrimaryMetrics
        """
        super(ImageClassificationMultilabel, self).__init__(log_verbosity=log_verbosity, target_column_name=target_column_name, training_data=training_data, limit_settings=limit_settings, sweep_settings=sweep_settings, validation_data=validation_data, validation_data_size=validation_data_size, model_settings=model_settings, search_space=search_space, **kwargs)
        self.limit_settings = limit_settings
        self.sweep_settings = sweep_settings
        self.validation_data = validation_data
        self.validation_data_size = validation_data_size
        self.model_settings = model_settings
        self.search_space = search_space
        self.task_type = 'ImageClassificationMultilabel'  # type: str
        self.primary_metric = primary_metric
        self.log_verbosity = log_verbosity
        self.target_column_name = target_column_name
        self.training_data = training_data


class ImageObjectDetectionBase(ImageVertical):
    """ImageObjectDetectionBase.

    All required parameters must be populated in order to send to Azure.

    :ivar limit_settings: Required. [Required] Limit settings for the AutoML job.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
    :ivar sweep_settings: Model sweeping and hyperparameter sweeping related settings.
    :vartype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
    :ivar validation_data: Validation data inputs.
    :vartype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar validation_data_size: The fraction of training dataset that needs to be set aside for
     validation purpose.
     Values between (0.0 , 1.0)
     Applied when validation dataset is not provided.
    :vartype validation_data_size: float
    :ivar model_settings: Settings used for training the model.
    :vartype model_settings:
     ~azure.mgmt.machinelearningservices.models.ImageModelSettingsObjectDetection
    :ivar search_space: Search space for sampling different combinations of models and their
     hyperparameters.
    :vartype search_space:
     list[~azure.mgmt.machinelearningservices.models.ImageModelDistributionSettingsObjectDetection]
    """

    _validation = {
        'limit_settings': {'required': True},
    }

    _attribute_map = {
        'limit_settings': {'key': 'limitSettings', 'type': 'ImageLimitSettings'},
        'sweep_settings': {'key': 'sweepSettings', 'type': 'ImageSweepSettings'},
        'validation_data': {'key': 'validationData', 'type': 'MLTableJobInput'},
        'validation_data_size': {'key': 'validationDataSize', 'type': 'float'},
        'model_settings': {'key': 'modelSettings', 'type': 'ImageModelSettingsObjectDetection'},
        'search_space': {'key': 'searchSpace', 'type': '[ImageModelDistributionSettingsObjectDetection]'},
    }

    def __init__(
        self,
        *,
        limit_settings: "ImageLimitSettings",
        sweep_settings: Optional["ImageSweepSettings"] = None,
        validation_data: Optional["MLTableJobInput"] = None,
        validation_data_size: Optional[float] = None,
        model_settings: Optional["ImageModelSettingsObjectDetection"] = None,
        search_space: Optional[List["ImageModelDistributionSettingsObjectDetection"]] = None,
        **kwargs
    ):
        """
        :keyword limit_settings: Required. [Required] Limit settings for the AutoML job.
        :paramtype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
        :keyword sweep_settings: Model sweeping and hyperparameter sweeping related settings.
        :paramtype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
        :keyword validation_data: Validation data inputs.
        :paramtype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword validation_data_size: The fraction of training dataset that needs to be set aside for
         validation purpose.
         Values between (0.0 , 1.0)
         Applied when validation dataset is not provided.
        :paramtype validation_data_size: float
        :keyword model_settings: Settings used for training the model.
        :paramtype model_settings:
         ~azure.mgmt.machinelearningservices.models.ImageModelSettingsObjectDetection
        :keyword search_space: Search space for sampling different combinations of models and their
         hyperparameters.
        :paramtype search_space:
         list[~azure.mgmt.machinelearningservices.models.ImageModelDistributionSettingsObjectDetection]
        """
        super(ImageObjectDetectionBase, self).__init__(limit_settings=limit_settings, sweep_settings=sweep_settings, validation_data=validation_data, validation_data_size=validation_data_size, **kwargs)
        self.model_settings = model_settings
        self.search_space = search_space


class ImageInstanceSegmentation(AutoMLVertical, ImageObjectDetectionBase):
    """Image Instance Segmentation. Instance segmentation is used to identify objects in an image at the pixel level,
drawing a polygon around each object in the image.

    All required parameters must be populated in order to send to Azure.

    :ivar limit_settings: Required. [Required] Limit settings for the AutoML job.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
    :ivar sweep_settings: Model sweeping and hyperparameter sweeping related settings.
    :vartype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
    :ivar validation_data: Validation data inputs.
    :vartype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar validation_data_size: The fraction of training dataset that needs to be set aside for
     validation purpose.
     Values between (0.0 , 1.0)
     Applied when validation dataset is not provided.
    :vartype validation_data_size: float
    :ivar model_settings: Settings used for training the model.
    :vartype model_settings:
     ~azure.mgmt.machinelearningservices.models.ImageModelSettingsObjectDetection
    :ivar search_space: Search space for sampling different combinations of models and their
     hyperparameters.
    :vartype search_space:
     list[~azure.mgmt.machinelearningservices.models.ImageModelDistributionSettingsObjectDetection]
    :ivar log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
     "Info", "Warning", "Error", "Critical".
    :vartype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
    :ivar target_column_name: Target column name: This is prediction values column.
     Also known as label column name in context of classification tasks.
    :vartype target_column_name: str
    :ivar task_type: Required. [Required] Task type for AutoMLJob.Constant filled by server.
     Possible values include: "Classification", "Regression", "Forecasting", "ImageClassification",
     "ImageClassificationMultilabel", "ImageObjectDetection", "ImageInstanceSegmentation",
     "TextClassification", "TextClassificationMultilabel", "TextNER".
    :vartype task_type: str or ~azure.mgmt.machinelearningservices.models.TaskType
    :ivar training_data: Required. [Required] Training data input.
    :vartype training_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar primary_metric: Primary metric to optimize for this task. Possible values include:
     "MeanAveragePrecision".
    :vartype primary_metric: str or
     ~azure.mgmt.machinelearningservices.models.InstanceSegmentationPrimaryMetrics
    """

    _validation = {
        'limit_settings': {'required': True},
        'task_type': {'required': True},
        'training_data': {'required': True},
    }

    _attribute_map = {
        'limit_settings': {'key': 'limitSettings', 'type': 'ImageLimitSettings'},
        'sweep_settings': {'key': 'sweepSettings', 'type': 'ImageSweepSettings'},
        'validation_data': {'key': 'validationData', 'type': 'MLTableJobInput'},
        'validation_data_size': {'key': 'validationDataSize', 'type': 'float'},
        'model_settings': {'key': 'modelSettings', 'type': 'ImageModelSettingsObjectDetection'},
        'search_space': {'key': 'searchSpace', 'type': '[ImageModelDistributionSettingsObjectDetection]'},
        'log_verbosity': {'key': 'logVerbosity', 'type': 'str'},
        'target_column_name': {'key': 'targetColumnName', 'type': 'str'},
        'task_type': {'key': 'taskType', 'type': 'str'},
        'training_data': {'key': 'trainingData', 'type': 'MLTableJobInput'},
        'primary_metric': {'key': 'primaryMetric', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        limit_settings: "ImageLimitSettings",
        training_data: "MLTableJobInput",
        sweep_settings: Optional["ImageSweepSettings"] = None,
        validation_data: Optional["MLTableJobInput"] = None,
        validation_data_size: Optional[float] = None,
        model_settings: Optional["ImageModelSettingsObjectDetection"] = None,
        search_space: Optional[List["ImageModelDistributionSettingsObjectDetection"]] = None,
        log_verbosity: Optional[Union[str, "LogVerbosity"]] = None,
        target_column_name: Optional[str] = None,
        primary_metric: Optional[Union[str, "InstanceSegmentationPrimaryMetrics"]] = None,
        **kwargs
    ):
        """
        :keyword limit_settings: Required. [Required] Limit settings for the AutoML job.
        :paramtype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
        :keyword sweep_settings: Model sweeping and hyperparameter sweeping related settings.
        :paramtype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
        :keyword validation_data: Validation data inputs.
        :paramtype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword validation_data_size: The fraction of training dataset that needs to be set aside for
         validation purpose.
         Values between (0.0 , 1.0)
         Applied when validation dataset is not provided.
        :paramtype validation_data_size: float
        :keyword model_settings: Settings used for training the model.
        :paramtype model_settings:
         ~azure.mgmt.machinelearningservices.models.ImageModelSettingsObjectDetection
        :keyword search_space: Search space for sampling different combinations of models and their
         hyperparameters.
        :paramtype search_space:
         list[~azure.mgmt.machinelearningservices.models.ImageModelDistributionSettingsObjectDetection]
        :keyword log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
         "Info", "Warning", "Error", "Critical".
        :paramtype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
        :keyword target_column_name: Target column name: This is prediction values column.
         Also known as label column name in context of classification tasks.
        :paramtype target_column_name: str
        :keyword training_data: Required. [Required] Training data input.
        :paramtype training_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword primary_metric: Primary metric to optimize for this task. Possible values include:
         "MeanAveragePrecision".
        :paramtype primary_metric: str or
         ~azure.mgmt.machinelearningservices.models.InstanceSegmentationPrimaryMetrics
        """
        super(ImageInstanceSegmentation, self).__init__(log_verbosity=log_verbosity, target_column_name=target_column_name, training_data=training_data, limit_settings=limit_settings, sweep_settings=sweep_settings, validation_data=validation_data, validation_data_size=validation_data_size, model_settings=model_settings, search_space=search_space, **kwargs)
        self.limit_settings = limit_settings
        self.sweep_settings = sweep_settings
        self.validation_data = validation_data
        self.validation_data_size = validation_data_size
        self.model_settings = model_settings
        self.search_space = search_space
        self.task_type = 'ImageInstanceSegmentation'  # type: str
        self.primary_metric = primary_metric
        self.log_verbosity = log_verbosity
        self.target_column_name = target_column_name
        self.training_data = training_data


class ImageLimitSettings(msrest.serialization.Model):
    """Limit settings for the AutoML job.

    :ivar max_concurrent_trials: Maximum number of concurrent AutoML iterations.
    :vartype max_concurrent_trials: int
    :ivar max_trials: Maximum number of AutoML iterations.
    :vartype max_trials: int
    :ivar timeout: AutoML job timeout.
    :vartype timeout: ~datetime.timedelta
    """

    _attribute_map = {
        'max_concurrent_trials': {'key': 'maxConcurrentTrials', 'type': 'int'},
        'max_trials': {'key': 'maxTrials', 'type': 'int'},
        'timeout': {'key': 'timeout', 'type': 'duration'},
    }

    def __init__(
        self,
        *,
        max_concurrent_trials: Optional[int] = 1,
        max_trials: Optional[int] = 1,
        timeout: Optional[datetime.timedelta] = "P7D",
        **kwargs
    ):
        """
        :keyword max_concurrent_trials: Maximum number of concurrent AutoML iterations.
        :paramtype max_concurrent_trials: int
        :keyword max_trials: Maximum number of AutoML iterations.
        :paramtype max_trials: int
        :keyword timeout: AutoML job timeout.
        :paramtype timeout: ~datetime.timedelta
        """
        super(ImageLimitSettings, self).__init__(**kwargs)
        self.max_concurrent_trials = max_concurrent_trials
        self.max_trials = max_trials
        self.timeout = timeout


class ImageMetadata(msrest.serialization.Model):
    """Returns metadata about the operating system image for this compute instance.

    :ivar current_image_version: Specifies the current operating system image version this compute
     instance is running on.
    :vartype current_image_version: str
    :ivar latest_image_version: Specifies the latest available operating system image version.
    :vartype latest_image_version: str
    :ivar is_latest_os_image_version: Specifies whether this compute instance is running on the
     latest operating system image.
    :vartype is_latest_os_image_version: bool
    """

    _attribute_map = {
        'current_image_version': {'key': 'currentImageVersion', 'type': 'str'},
        'latest_image_version': {'key': 'latestImageVersion', 'type': 'str'},
        'is_latest_os_image_version': {'key': 'isLatestOsImageVersion', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        current_image_version: Optional[str] = None,
        latest_image_version: Optional[str] = None,
        is_latest_os_image_version: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword current_image_version: Specifies the current operating system image version this
         compute instance is running on.
        :paramtype current_image_version: str
        :keyword latest_image_version: Specifies the latest available operating system image version.
        :paramtype latest_image_version: str
        :keyword is_latest_os_image_version: Specifies whether this compute instance is running on the
         latest operating system image.
        :paramtype is_latest_os_image_version: bool
        """
        super(ImageMetadata, self).__init__(**kwargs)
        self.current_image_version = current_image_version
        self.latest_image_version = latest_image_version
        self.is_latest_os_image_version = is_latest_os_image_version


class ImageModelDistributionSettings(msrest.serialization.Model):
    """Distribution expressions to sweep over values of model settings.

:code:`<example>
Some examples are:
<code>
ModelName = "choice('seresnext', 'resnest50')";
LearningRate = "uniform(0.001, 0.01)";
LayersToFreeze = "choice(0, 2)";
</code></example>`
All distributions can be specified as distribution_name(min, max) or choice(val1, val2, ..., valn)
where distribution name can be: uniform, quniform, loguniform, etc
For more details on how to compose distribution expressions please check the documentation:
https://learn.microsoft.com/azure/machine-learning/how-to-tune-hyperparameters
For more information on the available settings please visit the official documentation:
https://learn.microsoft.com/azure/machine-learning/how-to-auto-train-image-models.

    :ivar ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
    :vartype ams_gradient: str
    :ivar augmentations: Settings for using Augmentations.
    :vartype augmentations: str
    :ivar beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range
     [0, 1].
    :vartype beta1: str
    :ivar beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range
     [0, 1].
    :vartype beta2: str
    :ivar distributed: Whether to use distributer training.
    :vartype distributed: str
    :ivar early_stopping: Enable early stopping logic during training.
    :vartype early_stopping: str
    :ivar early_stopping_delay: Minimum number of epochs or validation evaluations to wait before
     primary metric improvement
     is tracked for early stopping. Must be a positive integer.
    :vartype early_stopping_delay: str
    :ivar early_stopping_patience: Minimum number of epochs or validation evaluations with no
     primary metric improvement before
     the run is stopped. Must be a positive integer.
    :vartype early_stopping_patience: str
    :ivar enable_onnx_normalization: Enable normalization when exporting ONNX model.
    :vartype enable_onnx_normalization: str
    :ivar evaluation_frequency: Frequency to evaluate validation dataset to get metric scores. Must
     be a positive integer.
    :vartype evaluation_frequency: str
    :ivar gradient_accumulation_step: Gradient accumulation means running a configured number of
     "GradAccumulationStep" steps without
     updating the model weights while accumulating the gradients of those steps, and then using
     the accumulated gradients to compute the weight updates. Must be a positive integer.
    :vartype gradient_accumulation_step: str
    :ivar layers_to_freeze: Number of layers to freeze for the model. Must be a positive integer.
     For instance, passing 2 as value for 'seresnext' means
     freezing layer0 and layer1. For a full list of models supported and details on layer freeze,
     please
     see: https://learn.microsoft.com/azure/machine-learning/how-to-auto-train-image-models.
    :vartype layers_to_freeze: str
    :ivar learning_rate: Initial learning rate. Must be a float in the range [0, 1].
    :vartype learning_rate: str
    :ivar learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or
     'step'.
    :vartype learning_rate_scheduler: str
    :ivar model_name: Name of the model to use for training.
     For more information on the available models please visit the official documentation:
     https://learn.microsoft.com/azure/machine-learning/how-to-auto-train-image-models.
    :vartype model_name: str
    :ivar momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
    :vartype momentum: str
    :ivar nesterov: Enable nesterov when optimizer is 'sgd'.
    :vartype nesterov: str
    :ivar number_of_epochs: Number of training epochs. Must be a positive integer.
    :vartype number_of_epochs: str
    :ivar number_of_workers: Number of data loader workers. Must be a non-negative integer.
    :vartype number_of_workers: str
    :ivar optimizer: Type of optimizer. Must be either 'sgd', 'adam', or 'adamw'.
    :vartype optimizer: str
    :ivar random_seed: Random seed to be used when using deterministic training.
    :vartype random_seed: str
    :ivar step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float in
     the range [0, 1].
    :vartype step_lr_gamma: str
    :ivar step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be a
     positive integer.
    :vartype step_lr_step_size: str
    :ivar training_batch_size: Training batch size. Must be a positive integer.
    :vartype training_batch_size: str
    :ivar validation_batch_size: Validation batch size. Must be a positive integer.
    :vartype validation_batch_size: str
    :ivar warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is
     'warmup_cosine'. Must be a float in the range [0, 1].
    :vartype warmup_cosine_lr_cycles: str
    :ivar warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is
     'warmup_cosine'. Must be a positive integer.
    :vartype warmup_cosine_lr_warmup_epochs: str
    :ivar weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be
     a float in the range[0, 1].
    :vartype weight_decay: str
    """

    _attribute_map = {
        'ams_gradient': {'key': 'amsGradient', 'type': 'str'},
        'augmentations': {'key': 'augmentations', 'type': 'str'},
        'beta1': {'key': 'beta1', 'type': 'str'},
        'beta2': {'key': 'beta2', 'type': 'str'},
        'distributed': {'key': 'distributed', 'type': 'str'},
        'early_stopping': {'key': 'earlyStopping', 'type': 'str'},
        'early_stopping_delay': {'key': 'earlyStoppingDelay', 'type': 'str'},
        'early_stopping_patience': {'key': 'earlyStoppingPatience', 'type': 'str'},
        'enable_onnx_normalization': {'key': 'enableOnnxNormalization', 'type': 'str'},
        'evaluation_frequency': {'key': 'evaluationFrequency', 'type': 'str'},
        'gradient_accumulation_step': {'key': 'gradientAccumulationStep', 'type': 'str'},
        'layers_to_freeze': {'key': 'layersToFreeze', 'type': 'str'},
        'learning_rate': {'key': 'learningRate', 'type': 'str'},
        'learning_rate_scheduler': {'key': 'learningRateScheduler', 'type': 'str'},
        'model_name': {'key': 'modelName', 'type': 'str'},
        'momentum': {'key': 'momentum', 'type': 'str'},
        'nesterov': {'key': 'nesterov', 'type': 'str'},
        'number_of_epochs': {'key': 'numberOfEpochs', 'type': 'str'},
        'number_of_workers': {'key': 'numberOfWorkers', 'type': 'str'},
        'optimizer': {'key': 'optimizer', 'type': 'str'},
        'random_seed': {'key': 'randomSeed', 'type': 'str'},
        'step_lr_gamma': {'key': 'stepLRGamma', 'type': 'str'},
        'step_lr_step_size': {'key': 'stepLRStepSize', 'type': 'str'},
        'training_batch_size': {'key': 'trainingBatchSize', 'type': 'str'},
        'validation_batch_size': {'key': 'validationBatchSize', 'type': 'str'},
        'warmup_cosine_lr_cycles': {'key': 'warmupCosineLRCycles', 'type': 'str'},
        'warmup_cosine_lr_warmup_epochs': {'key': 'warmupCosineLRWarmupEpochs', 'type': 'str'},
        'weight_decay': {'key': 'weightDecay', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        ams_gradient: Optional[str] = None,
        augmentations: Optional[str] = None,
        beta1: Optional[str] = None,
        beta2: Optional[str] = None,
        distributed: Optional[str] = None,
        early_stopping: Optional[str] = None,
        early_stopping_delay: Optional[str] = None,
        early_stopping_patience: Optional[str] = None,
        enable_onnx_normalization: Optional[str] = None,
        evaluation_frequency: Optional[str] = None,
        gradient_accumulation_step: Optional[str] = None,
        layers_to_freeze: Optional[str] = None,
        learning_rate: Optional[str] = None,
        learning_rate_scheduler: Optional[str] = None,
        model_name: Optional[str] = None,
        momentum: Optional[str] = None,
        nesterov: Optional[str] = None,
        number_of_epochs: Optional[str] = None,
        number_of_workers: Optional[str] = None,
        optimizer: Optional[str] = None,
        random_seed: Optional[str] = None,
        step_lr_gamma: Optional[str] = None,
        step_lr_step_size: Optional[str] = None,
        training_batch_size: Optional[str] = None,
        validation_batch_size: Optional[str] = None,
        warmup_cosine_lr_cycles: Optional[str] = None,
        warmup_cosine_lr_warmup_epochs: Optional[str] = None,
        weight_decay: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
        :paramtype ams_gradient: str
        :keyword augmentations: Settings for using Augmentations.
        :paramtype augmentations: str
        :keyword beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the
         range [0, 1].
        :paramtype beta1: str
        :keyword beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the
         range [0, 1].
        :paramtype beta2: str
        :keyword distributed: Whether to use distributer training.
        :paramtype distributed: str
        :keyword early_stopping: Enable early stopping logic during training.
        :paramtype early_stopping: str
        :keyword early_stopping_delay: Minimum number of epochs or validation evaluations to wait
         before primary metric improvement
         is tracked for early stopping. Must be a positive integer.
        :paramtype early_stopping_delay: str
        :keyword early_stopping_patience: Minimum number of epochs or validation evaluations with no
         primary metric improvement before
         the run is stopped. Must be a positive integer.
        :paramtype early_stopping_patience: str
        :keyword enable_onnx_normalization: Enable normalization when exporting ONNX model.
        :paramtype enable_onnx_normalization: str
        :keyword evaluation_frequency: Frequency to evaluate validation dataset to get metric scores.
         Must be a positive integer.
        :paramtype evaluation_frequency: str
        :keyword gradient_accumulation_step: Gradient accumulation means running a configured number of
         "GradAccumulationStep" steps without
         updating the model weights while accumulating the gradients of those steps, and then using
         the accumulated gradients to compute the weight updates. Must be a positive integer.
        :paramtype gradient_accumulation_step: str
        :keyword layers_to_freeze: Number of layers to freeze for the model. Must be a positive
         integer.
         For instance, passing 2 as value for 'seresnext' means
         freezing layer0 and layer1. For a full list of models supported and details on layer freeze,
         please
         see: https://learn.microsoft.com/azure/machine-learning/how-to-auto-train-image-models.
        :paramtype layers_to_freeze: str
        :keyword learning_rate: Initial learning rate. Must be a float in the range [0, 1].
        :paramtype learning_rate: str
        :keyword learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or
         'step'.
        :paramtype learning_rate_scheduler: str
        :keyword model_name: Name of the model to use for training.
         For more information on the available models please visit the official documentation:
         https://learn.microsoft.com/azure/machine-learning/how-to-auto-train-image-models.
        :paramtype model_name: str
        :keyword momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0,
         1].
        :paramtype momentum: str
        :keyword nesterov: Enable nesterov when optimizer is 'sgd'.
        :paramtype nesterov: str
        :keyword number_of_epochs: Number of training epochs. Must be a positive integer.
        :paramtype number_of_epochs: str
        :keyword number_of_workers: Number of data loader workers. Must be a non-negative integer.
        :paramtype number_of_workers: str
        :keyword optimizer: Type of optimizer. Must be either 'sgd', 'adam', or 'adamw'.
        :paramtype optimizer: str
        :keyword random_seed: Random seed to be used when using deterministic training.
        :paramtype random_seed: str
        :keyword step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float
         in the range [0, 1].
        :paramtype step_lr_gamma: str
        :keyword step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be
         a positive integer.
        :paramtype step_lr_step_size: str
        :keyword training_batch_size: Training batch size. Must be a positive integer.
        :paramtype training_batch_size: str
        :keyword validation_batch_size: Validation batch size. Must be a positive integer.
        :paramtype validation_batch_size: str
        :keyword warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is
         'warmup_cosine'. Must be a float in the range [0, 1].
        :paramtype warmup_cosine_lr_cycles: str
        :keyword warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is
         'warmup_cosine'. Must be a positive integer.
        :paramtype warmup_cosine_lr_warmup_epochs: str
        :keyword weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must
         be a float in the range[0, 1].
        :paramtype weight_decay: str
        """
        super(ImageModelDistributionSettings, self).__init__(**kwargs)
        self.ams_gradient = ams_gradient
        self.augmentations = augmentations
        self.beta1 = beta1
        self.beta2 = beta2
        self.distributed = distributed
        self.early_stopping = early_stopping
        self.early_stopping_delay = early_stopping_delay
        self.early_stopping_patience = early_stopping_patience
        self.enable_onnx_normalization = enable_onnx_normalization
        self.evaluation_frequency = evaluation_frequency
        self.gradient_accumulation_step = gradient_accumulation_step
        self.layers_to_freeze = layers_to_freeze
        self.learning_rate = learning_rate
        self.learning_rate_scheduler = learning_rate_scheduler
        self.model_name = model_name
        self.momentum = momentum
        self.nesterov = nesterov
        self.number_of_epochs = number_of_epochs
        self.number_of_workers = number_of_workers
        self.optimizer = optimizer
        self.random_seed = random_seed
        self.step_lr_gamma = step_lr_gamma
        self.step_lr_step_size = step_lr_step_size
        self.training_batch_size = training_batch_size
        self.validation_batch_size = validation_batch_size
        self.warmup_cosine_lr_cycles = warmup_cosine_lr_cycles
        self.warmup_cosine_lr_warmup_epochs = warmup_cosine_lr_warmup_epochs
        self.weight_decay = weight_decay


class ImageModelDistributionSettingsClassification(ImageModelDistributionSettings):
    """Distribution expressions to sweep over values of model settings.

:code:`<example>
Some examples are:
<code>
ModelName = "choice('seresnext', 'resnest50')";
LearningRate = "uniform(0.001, 0.01)";
LayersToFreeze = "choice(0, 2)";
</code></example>`
For more details on how to compose distribution expressions please check the documentation:
https://learn.microsoft.com/azure/machine-learning/how-to-tune-hyperparameters
For more information on the available settings please visit the official documentation:
https://learn.microsoft.com/azure/machine-learning/how-to-auto-train-image-models.

    :ivar ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
    :vartype ams_gradient: str
    :ivar augmentations: Settings for using Augmentations.
    :vartype augmentations: str
    :ivar beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range
     [0, 1].
    :vartype beta1: str
    :ivar beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range
     [0, 1].
    :vartype beta2: str
    :ivar distributed: Whether to use distributer training.
    :vartype distributed: str
    :ivar early_stopping: Enable early stopping logic during training.
    :vartype early_stopping: str
    :ivar early_stopping_delay: Minimum number of epochs or validation evaluations to wait before
     primary metric improvement
     is tracked for early stopping. Must be a positive integer.
    :vartype early_stopping_delay: str
    :ivar early_stopping_patience: Minimum number of epochs or validation evaluations with no
     primary metric improvement before
     the run is stopped. Must be a positive integer.
    :vartype early_stopping_patience: str
    :ivar enable_onnx_normalization: Enable normalization when exporting ONNX model.
    :vartype enable_onnx_normalization: str
    :ivar evaluation_frequency: Frequency to evaluate validation dataset to get metric scores. Must
     be a positive integer.
    :vartype evaluation_frequency: str
    :ivar gradient_accumulation_step: Gradient accumulation means running a configured number of
     "GradAccumulationStep" steps without
     updating the model weights while accumulating the gradients of those steps, and then using
     the accumulated gradients to compute the weight updates. Must be a positive integer.
    :vartype gradient_accumulation_step: str
    :ivar layers_to_freeze: Number of layers to freeze for the model. Must be a positive integer.
     For instance, passing 2 as value for 'seresnext' means
     freezing layer0 and layer1. For a full list of models supported and details on layer freeze,
     please
     see: https://learn.microsoft.com/azure/machine-learning/how-to-auto-train-image-models.
    :vartype layers_to_freeze: str
    :ivar learning_rate: Initial learning rate. Must be a float in the range [0, 1].
    :vartype learning_rate: str
    :ivar learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or
     'step'.
    :vartype learning_rate_scheduler: str
    :ivar model_name: Name of the model to use for training.
     For more information on the available models please visit the official documentation:
     https://learn.microsoft.com/azure/machine-learning/how-to-auto-train-image-models.
    :vartype model_name: str
    :ivar momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
    :vartype momentum: str
    :ivar nesterov: Enable nesterov when optimizer is 'sgd'.
    :vartype nesterov: str
    :ivar number_of_epochs: Number of training epochs. Must be a positive integer.
    :vartype number_of_epochs: str
    :ivar number_of_workers: Number of data loader workers. Must be a non-negative integer.
    :vartype number_of_workers: str
    :ivar optimizer: Type of optimizer. Must be either 'sgd', 'adam', or 'adamw'.
    :vartype optimizer: str
    :ivar random_seed: Random seed to be used when using deterministic training.
    :vartype random_seed: str
    :ivar step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float in
     the range [0, 1].
    :vartype step_lr_gamma: str
    :ivar step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be a
     positive integer.
    :vartype step_lr_step_size: str
    :ivar training_batch_size: Training batch size. Must be a positive integer.
    :vartype training_batch_size: str
    :ivar validation_batch_size: Validation batch size. Must be a positive integer.
    :vartype validation_batch_size: str
    :ivar warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is
     'warmup_cosine'. Must be a float in the range [0, 1].
    :vartype warmup_cosine_lr_cycles: str
    :ivar warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is
     'warmup_cosine'. Must be a positive integer.
    :vartype warmup_cosine_lr_warmup_epochs: str
    :ivar weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be
     a float in the range[0, 1].
    :vartype weight_decay: str
    :ivar training_crop_size: Image crop size that is input to the neural network for the training
     dataset. Must be a positive integer.
    :vartype training_crop_size: str
    :ivar validation_crop_size: Image crop size that is input to the neural network for the
     validation dataset. Must be a positive integer.
    :vartype validation_crop_size: str
    :ivar validation_resize_size: Image size to which to resize before cropping for validation
     dataset. Must be a positive integer.
    :vartype validation_resize_size: str
    :ivar weighted_loss: Weighted loss. The accepted values are 0 for no weighted loss.
     1 for weighted loss with sqrt.(class_weights). 2 for weighted loss with class_weights. Must be
     0 or 1 or 2.
    :vartype weighted_loss: str
    """

    _attribute_map = {
        'ams_gradient': {'key': 'amsGradient', 'type': 'str'},
        'augmentations': {'key': 'augmentations', 'type': 'str'},
        'beta1': {'key': 'beta1', 'type': 'str'},
        'beta2': {'key': 'beta2', 'type': 'str'},
        'distributed': {'key': 'distributed', 'type': 'str'},
        'early_stopping': {'key': 'earlyStopping', 'type': 'str'},
        'early_stopping_delay': {'key': 'earlyStoppingDelay', 'type': 'str'},
        'early_stopping_patience': {'key': 'earlyStoppingPatience', 'type': 'str'},
        'enable_onnx_normalization': {'key': 'enableOnnxNormalization', 'type': 'str'},
        'evaluation_frequency': {'key': 'evaluationFrequency', 'type': 'str'},
        'gradient_accumulation_step': {'key': 'gradientAccumulationStep', 'type': 'str'},
        'layers_to_freeze': {'key': 'layersToFreeze', 'type': 'str'},
        'learning_rate': {'key': 'learningRate', 'type': 'str'},
        'learning_rate_scheduler': {'key': 'learningRateScheduler', 'type': 'str'},
        'model_name': {'key': 'modelName', 'type': 'str'},
        'momentum': {'key': 'momentum', 'type': 'str'},
        'nesterov': {'key': 'nesterov', 'type': 'str'},
        'number_of_epochs': {'key': 'numberOfEpochs', 'type': 'str'},
        'number_of_workers': {'key': 'numberOfWorkers', 'type': 'str'},
        'optimizer': {'key': 'optimizer', 'type': 'str'},
        'random_seed': {'key': 'randomSeed', 'type': 'str'},
        'step_lr_gamma': {'key': 'stepLRGamma', 'type': 'str'},
        'step_lr_step_size': {'key': 'stepLRStepSize', 'type': 'str'},
        'training_batch_size': {'key': 'trainingBatchSize', 'type': 'str'},
        'validation_batch_size': {'key': 'validationBatchSize', 'type': 'str'},
        'warmup_cosine_lr_cycles': {'key': 'warmupCosineLRCycles', 'type': 'str'},
        'warmup_cosine_lr_warmup_epochs': {'key': 'warmupCosineLRWarmupEpochs', 'type': 'str'},
        'weight_decay': {'key': 'weightDecay', 'type': 'str'},
        'training_crop_size': {'key': 'trainingCropSize', 'type': 'str'},
        'validation_crop_size': {'key': 'validationCropSize', 'type': 'str'},
        'validation_resize_size': {'key': 'validationResizeSize', 'type': 'str'},
        'weighted_loss': {'key': 'weightedLoss', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        ams_gradient: Optional[str] = None,
        augmentations: Optional[str] = None,
        beta1: Optional[str] = None,
        beta2: Optional[str] = None,
        distributed: Optional[str] = None,
        early_stopping: Optional[str] = None,
        early_stopping_delay: Optional[str] = None,
        early_stopping_patience: Optional[str] = None,
        enable_onnx_normalization: Optional[str] = None,
        evaluation_frequency: Optional[str] = None,
        gradient_accumulation_step: Optional[str] = None,
        layers_to_freeze: Optional[str] = None,
        learning_rate: Optional[str] = None,
        learning_rate_scheduler: Optional[str] = None,
        model_name: Optional[str] = None,
        momentum: Optional[str] = None,
        nesterov: Optional[str] = None,
        number_of_epochs: Optional[str] = None,
        number_of_workers: Optional[str] = None,
        optimizer: Optional[str] = None,
        random_seed: Optional[str] = None,
        step_lr_gamma: Optional[str] = None,
        step_lr_step_size: Optional[str] = None,
        training_batch_size: Optional[str] = None,
        validation_batch_size: Optional[str] = None,
        warmup_cosine_lr_cycles: Optional[str] = None,
        warmup_cosine_lr_warmup_epochs: Optional[str] = None,
        weight_decay: Optional[str] = None,
        training_crop_size: Optional[str] = None,
        validation_crop_size: Optional[str] = None,
        validation_resize_size: Optional[str] = None,
        weighted_loss: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
        :paramtype ams_gradient: str
        :keyword augmentations: Settings for using Augmentations.
        :paramtype augmentations: str
        :keyword beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the
         range [0, 1].
        :paramtype beta1: str
        :keyword beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the
         range [0, 1].
        :paramtype beta2: str
        :keyword distributed: Whether to use distributer training.
        :paramtype distributed: str
        :keyword early_stopping: Enable early stopping logic during training.
        :paramtype early_stopping: str
        :keyword early_stopping_delay: Minimum number of epochs or validation evaluations to wait
         before primary metric improvement
         is tracked for early stopping. Must be a positive integer.
        :paramtype early_stopping_delay: str
        :keyword early_stopping_patience: Minimum number of epochs or validation evaluations with no
         primary metric improvement before
         the run is stopped. Must be a positive integer.
        :paramtype early_stopping_patience: str
        :keyword enable_onnx_normalization: Enable normalization when exporting ONNX model.
        :paramtype enable_onnx_normalization: str
        :keyword evaluation_frequency: Frequency to evaluate validation dataset to get metric scores.
         Must be a positive integer.
        :paramtype evaluation_frequency: str
        :keyword gradient_accumulation_step: Gradient accumulation means running a configured number of
         "GradAccumulationStep" steps without
         updating the model weights while accumulating the gradients of those steps, and then using
         the accumulated gradients to compute the weight updates. Must be a positive integer.
        :paramtype gradient_accumulation_step: str
        :keyword layers_to_freeze: Number of layers to freeze for the model. Must be a positive
         integer.
         For instance, passing 2 as value for 'seresnext' means
         freezing layer0 and layer1. For a full list of models supported and details on layer freeze,
         please
         see: https://learn.microsoft.com/azure/machine-learning/how-to-auto-train-image-models.
        :paramtype layers_to_freeze: str
        :keyword learning_rate: Initial learning rate. Must be a float in the range [0, 1].
        :paramtype learning_rate: str
        :keyword learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or
         'step'.
        :paramtype learning_rate_scheduler: str
        :keyword model_name: Name of the model to use for training.
         For more information on the available models please visit the official documentation:
         https://learn.microsoft.com/azure/machine-learning/how-to-auto-train-image-models.
        :paramtype model_name: str
        :keyword momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0,
         1].
        :paramtype momentum: str
        :keyword nesterov: Enable nesterov when optimizer is 'sgd'.
        :paramtype nesterov: str
        :keyword number_of_epochs: Number of training epochs. Must be a positive integer.
        :paramtype number_of_epochs: str
        :keyword number_of_workers: Number of data loader workers. Must be a non-negative integer.
        :paramtype number_of_workers: str
        :keyword optimizer: Type of optimizer. Must be either 'sgd', 'adam', or 'adamw'.
        :paramtype optimizer: str
        :keyword random_seed: Random seed to be used when using deterministic training.
        :paramtype random_seed: str
        :keyword step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float
         in the range [0, 1].
        :paramtype step_lr_gamma: str
        :keyword step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be
         a positive integer.
        :paramtype step_lr_step_size: str
        :keyword training_batch_size: Training batch size. Must be a positive integer.
        :paramtype training_batch_size: str
        :keyword validation_batch_size: Validation batch size. Must be a positive integer.
        :paramtype validation_batch_size: str
        :keyword warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is
         'warmup_cosine'. Must be a float in the range [0, 1].
        :paramtype warmup_cosine_lr_cycles: str
        :keyword warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is
         'warmup_cosine'. Must be a positive integer.
        :paramtype warmup_cosine_lr_warmup_epochs: str
        :keyword weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must
         be a float in the range[0, 1].
        :paramtype weight_decay: str
        :keyword training_crop_size: Image crop size that is input to the neural network for the
         training dataset. Must be a positive integer.
        :paramtype training_crop_size: str
        :keyword validation_crop_size: Image crop size that is input to the neural network for the
         validation dataset. Must be a positive integer.
        :paramtype validation_crop_size: str
        :keyword validation_resize_size: Image size to which to resize before cropping for validation
         dataset. Must be a positive integer.
        :paramtype validation_resize_size: str
        :keyword weighted_loss: Weighted loss. The accepted values are 0 for no weighted loss.
         1 for weighted loss with sqrt.(class_weights). 2 for weighted loss with class_weights. Must be
         0 or 1 or 2.
        :paramtype weighted_loss: str
        """
        super(ImageModelDistributionSettingsClassification, self).__init__(ams_gradient=ams_gradient, augmentations=augmentations, beta1=beta1, beta2=beta2, distributed=distributed, early_stopping=early_stopping, early_stopping_delay=early_stopping_delay, early_stopping_patience=early_stopping_patience, enable_onnx_normalization=enable_onnx_normalization, evaluation_frequency=evaluation_frequency, gradient_accumulation_step=gradient_accumulation_step, layers_to_freeze=layers_to_freeze, learning_rate=learning_rate, learning_rate_scheduler=learning_rate_scheduler, model_name=model_name, momentum=momentum, nesterov=nesterov, number_of_epochs=number_of_epochs, number_of_workers=number_of_workers, optimizer=optimizer, random_seed=random_seed, step_lr_gamma=step_lr_gamma, step_lr_step_size=step_lr_step_size, training_batch_size=training_batch_size, validation_batch_size=validation_batch_size, warmup_cosine_lr_cycles=warmup_cosine_lr_cycles, warmup_cosine_lr_warmup_epochs=warmup_cosine_lr_warmup_epochs, weight_decay=weight_decay, **kwargs)
        self.training_crop_size = training_crop_size
        self.validation_crop_size = validation_crop_size
        self.validation_resize_size = validation_resize_size
        self.weighted_loss = weighted_loss


class ImageModelDistributionSettingsObjectDetection(ImageModelDistributionSettings):
    """Distribution expressions to sweep over values of model settings.

:code:`<example>
Some examples are:
<code>
ModelName = "choice('seresnext', 'resnest50')";
LearningRate = "uniform(0.001, 0.01)";
LayersToFreeze = "choice(0, 2)";
</code></example>`
For more details on how to compose distribution expressions please check the documentation:
https://learn.microsoft.com/azure/machine-learning/how-to-tune-hyperparameters
For more information on the available settings please visit the official documentation:
https://learn.microsoft.com/azure/machine-learning/how-to-auto-train-image-models.

    :ivar ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
    :vartype ams_gradient: str
    :ivar augmentations: Settings for using Augmentations.
    :vartype augmentations: str
    :ivar beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range
     [0, 1].
    :vartype beta1: str
    :ivar beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range
     [0, 1].
    :vartype beta2: str
    :ivar distributed: Whether to use distributer training.
    :vartype distributed: str
    :ivar early_stopping: Enable early stopping logic during training.
    :vartype early_stopping: str
    :ivar early_stopping_delay: Minimum number of epochs or validation evaluations to wait before
     primary metric improvement
     is tracked for early stopping. Must be a positive integer.
    :vartype early_stopping_delay: str
    :ivar early_stopping_patience: Minimum number of epochs or validation evaluations with no
     primary metric improvement before
     the run is stopped. Must be a positive integer.
    :vartype early_stopping_patience: str
    :ivar enable_onnx_normalization: Enable normalization when exporting ONNX model.
    :vartype enable_onnx_normalization: str
    :ivar evaluation_frequency: Frequency to evaluate validation dataset to get metric scores. Must
     be a positive integer.
    :vartype evaluation_frequency: str
    :ivar gradient_accumulation_step: Gradient accumulation means running a configured number of
     "GradAccumulationStep" steps without
     updating the model weights while accumulating the gradients of those steps, and then using
     the accumulated gradients to compute the weight updates. Must be a positive integer.
    :vartype gradient_accumulation_step: str
    :ivar layers_to_freeze: Number of layers to freeze for the model. Must be a positive integer.
     For instance, passing 2 as value for 'seresnext' means
     freezing layer0 and layer1. For a full list of models supported and details on layer freeze,
     please
     see: https://learn.microsoft.com/azure/machine-learning/how-to-auto-train-image-models.
    :vartype layers_to_freeze: str
    :ivar learning_rate: Initial learning rate. Must be a float in the range [0, 1].
    :vartype learning_rate: str
    :ivar learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or
     'step'.
    :vartype learning_rate_scheduler: str
    :ivar model_name: Name of the model to use for training.
     For more information on the available models please visit the official documentation:
     https://learn.microsoft.com/azure/machine-learning/how-to-auto-train-image-models.
    :vartype model_name: str
    :ivar momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
    :vartype momentum: str
    :ivar nesterov: Enable nesterov when optimizer is 'sgd'.
    :vartype nesterov: str
    :ivar number_of_epochs: Number of training epochs. Must be a positive integer.
    :vartype number_of_epochs: str
    :ivar number_of_workers: Number of data loader workers. Must be a non-negative integer.
    :vartype number_of_workers: str
    :ivar optimizer: Type of optimizer. Must be either 'sgd', 'adam', or 'adamw'.
    :vartype optimizer: str
    :ivar random_seed: Random seed to be used when using deterministic training.
    :vartype random_seed: str
    :ivar step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float in
     the range [0, 1].
    :vartype step_lr_gamma: str
    :ivar step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be a
     positive integer.
    :vartype step_lr_step_size: str
    :ivar training_batch_size: Training batch size. Must be a positive integer.
    :vartype training_batch_size: str
    :ivar validation_batch_size: Validation batch size. Must be a positive integer.
    :vartype validation_batch_size: str
    :ivar warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is
     'warmup_cosine'. Must be a float in the range [0, 1].
    :vartype warmup_cosine_lr_cycles: str
    :ivar warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is
     'warmup_cosine'. Must be a positive integer.
    :vartype warmup_cosine_lr_warmup_epochs: str
    :ivar weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be
     a float in the range[0, 1].
    :vartype weight_decay: str
    :ivar box_detections_per_image: Maximum number of detections per image, for all classes. Must
     be a positive integer.
     Note: This settings is not supported for the 'yolov5' algorithm.
    :vartype box_detections_per_image: str
    :ivar box_score_threshold: During inference, only return proposals with a classification score
     greater than
     BoxScoreThreshold. Must be a float in the range[0, 1].
    :vartype box_score_threshold: str
    :ivar image_size: Image size for train and validation. Must be a positive integer.
     Note: The training run may get into CUDA OOM if the size is too big.
     Note: This settings is only supported for the 'yolov5' algorithm.
    :vartype image_size: str
    :ivar max_size: Maximum size of the image to be rescaled before feeding it to the backbone.
     Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
     Note: This settings is not supported for the 'yolov5' algorithm.
    :vartype max_size: str
    :ivar min_size: Minimum size of the image to be rescaled before feeding it to the backbone.
     Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
     Note: This settings is not supported for the 'yolov5' algorithm.
    :vartype min_size: str
    :ivar model_size: Model size. Must be 'small', 'medium', 'large', or 'xlarge'.
     Note: training run may get into CUDA OOM if the model size is too big.
     Note: This settings is only supported for the 'yolov5' algorithm.
    :vartype model_size: str
    :ivar multi_scale: Enable multi-scale image by varying image size by +/- 50%.
     Note: training run may get into CUDA OOM if no sufficient GPU memory.
     Note: This settings is only supported for the 'yolov5' algorithm.
    :vartype multi_scale: str
    :ivar nms_iou_threshold: IOU threshold used during inference in NMS post processing. Must be
     float in the range [0, 1].
    :vartype nms_iou_threshold: str
    :ivar tile_grid_size: The grid size to use for tiling each image. Note: TileGridSize must not
     be
     None to enable small object detection logic. A string containing two integers in mxn format.
     Note: This settings is not supported for the 'yolov5' algorithm.
    :vartype tile_grid_size: str
    :ivar tile_overlap_ratio: Overlap ratio between adjacent tiles in each dimension. Must be float
     in the range [0, 1).
     Note: This settings is not supported for the 'yolov5' algorithm.
    :vartype tile_overlap_ratio: str
    :ivar tile_predictions_nms_threshold: The IOU threshold to use to perform NMS while merging
     predictions from tiles and image.
     Used in validation/ inference. Must be float in the range [0, 1].
     Note: This settings is not supported for the 'yolov5' algorithm.
     NMS: Non-maximum suppression.
    :vartype tile_predictions_nms_threshold: str
    :ivar validation_iou_threshold: IOU threshold to use when computing validation metric. Must be
     float in the range [0, 1].
    :vartype validation_iou_threshold: str
    :ivar validation_metric_type: Metric computation method to use for validation metrics. Must be
     'none', 'coco', 'voc', or 'coco_voc'.
    :vartype validation_metric_type: str
    """

    _attribute_map = {
        'ams_gradient': {'key': 'amsGradient', 'type': 'str'},
        'augmentations': {'key': 'augmentations', 'type': 'str'},
        'beta1': {'key': 'beta1', 'type': 'str'},
        'beta2': {'key': 'beta2', 'type': 'str'},
        'distributed': {'key': 'distributed', 'type': 'str'},
        'early_stopping': {'key': 'earlyStopping', 'type': 'str'},
        'early_stopping_delay': {'key': 'earlyStoppingDelay', 'type': 'str'},
        'early_stopping_patience': {'key': 'earlyStoppingPatience', 'type': 'str'},
        'enable_onnx_normalization': {'key': 'enableOnnxNormalization', 'type': 'str'},
        'evaluation_frequency': {'key': 'evaluationFrequency', 'type': 'str'},
        'gradient_accumulation_step': {'key': 'gradientAccumulationStep', 'type': 'str'},
        'layers_to_freeze': {'key': 'layersToFreeze', 'type': 'str'},
        'learning_rate': {'key': 'learningRate', 'type': 'str'},
        'learning_rate_scheduler': {'key': 'learningRateScheduler', 'type': 'str'},
        'model_name': {'key': 'modelName', 'type': 'str'},
        'momentum': {'key': 'momentum', 'type': 'str'},
        'nesterov': {'key': 'nesterov', 'type': 'str'},
        'number_of_epochs': {'key': 'numberOfEpochs', 'type': 'str'},
        'number_of_workers': {'key': 'numberOfWorkers', 'type': 'str'},
        'optimizer': {'key': 'optimizer', 'type': 'str'},
        'random_seed': {'key': 'randomSeed', 'type': 'str'},
        'step_lr_gamma': {'key': 'stepLRGamma', 'type': 'str'},
        'step_lr_step_size': {'key': 'stepLRStepSize', 'type': 'str'},
        'training_batch_size': {'key': 'trainingBatchSize', 'type': 'str'},
        'validation_batch_size': {'key': 'validationBatchSize', 'type': 'str'},
        'warmup_cosine_lr_cycles': {'key': 'warmupCosineLRCycles', 'type': 'str'},
        'warmup_cosine_lr_warmup_epochs': {'key': 'warmupCosineLRWarmupEpochs', 'type': 'str'},
        'weight_decay': {'key': 'weightDecay', 'type': 'str'},
        'box_detections_per_image': {'key': 'boxDetectionsPerImage', 'type': 'str'},
        'box_score_threshold': {'key': 'boxScoreThreshold', 'type': 'str'},
        'image_size': {'key': 'imageSize', 'type': 'str'},
        'max_size': {'key': 'maxSize', 'type': 'str'},
        'min_size': {'key': 'minSize', 'type': 'str'},
        'model_size': {'key': 'modelSize', 'type': 'str'},
        'multi_scale': {'key': 'multiScale', 'type': 'str'},
        'nms_iou_threshold': {'key': 'nmsIouThreshold', 'type': 'str'},
        'tile_grid_size': {'key': 'tileGridSize', 'type': 'str'},
        'tile_overlap_ratio': {'key': 'tileOverlapRatio', 'type': 'str'},
        'tile_predictions_nms_threshold': {'key': 'tilePredictionsNmsThreshold', 'type': 'str'},
        'validation_iou_threshold': {'key': 'validationIouThreshold', 'type': 'str'},
        'validation_metric_type': {'key': 'validationMetricType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        ams_gradient: Optional[str] = None,
        augmentations: Optional[str] = None,
        beta1: Optional[str] = None,
        beta2: Optional[str] = None,
        distributed: Optional[str] = None,
        early_stopping: Optional[str] = None,
        early_stopping_delay: Optional[str] = None,
        early_stopping_patience: Optional[str] = None,
        enable_onnx_normalization: Optional[str] = None,
        evaluation_frequency: Optional[str] = None,
        gradient_accumulation_step: Optional[str] = None,
        layers_to_freeze: Optional[str] = None,
        learning_rate: Optional[str] = None,
        learning_rate_scheduler: Optional[str] = None,
        model_name: Optional[str] = None,
        momentum: Optional[str] = None,
        nesterov: Optional[str] = None,
        number_of_epochs: Optional[str] = None,
        number_of_workers: Optional[str] = None,
        optimizer: Optional[str] = None,
        random_seed: Optional[str] = None,
        step_lr_gamma: Optional[str] = None,
        step_lr_step_size: Optional[str] = None,
        training_batch_size: Optional[str] = None,
        validation_batch_size: Optional[str] = None,
        warmup_cosine_lr_cycles: Optional[str] = None,
        warmup_cosine_lr_warmup_epochs: Optional[str] = None,
        weight_decay: Optional[str] = None,
        box_detections_per_image: Optional[str] = None,
        box_score_threshold: Optional[str] = None,
        image_size: Optional[str] = None,
        max_size: Optional[str] = None,
        min_size: Optional[str] = None,
        model_size: Optional[str] = None,
        multi_scale: Optional[str] = None,
        nms_iou_threshold: Optional[str] = None,
        tile_grid_size: Optional[str] = None,
        tile_overlap_ratio: Optional[str] = None,
        tile_predictions_nms_threshold: Optional[str] = None,
        validation_iou_threshold: Optional[str] = None,
        validation_metric_type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
        :paramtype ams_gradient: str
        :keyword augmentations: Settings for using Augmentations.
        :paramtype augmentations: str
        :keyword beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the
         range [0, 1].
        :paramtype beta1: str
        :keyword beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the
         range [0, 1].
        :paramtype beta2: str
        :keyword distributed: Whether to use distributer training.
        :paramtype distributed: str
        :keyword early_stopping: Enable early stopping logic during training.
        :paramtype early_stopping: str
        :keyword early_stopping_delay: Minimum number of epochs or validation evaluations to wait
         before primary metric improvement
         is tracked for early stopping. Must be a positive integer.
        :paramtype early_stopping_delay: str
        :keyword early_stopping_patience: Minimum number of epochs or validation evaluations with no
         primary metric improvement before
         the run is stopped. Must be a positive integer.
        :paramtype early_stopping_patience: str
        :keyword enable_onnx_normalization: Enable normalization when exporting ONNX model.
        :paramtype enable_onnx_normalization: str
        :keyword evaluation_frequency: Frequency to evaluate validation dataset to get metric scores.
         Must be a positive integer.
        :paramtype evaluation_frequency: str
        :keyword gradient_accumulation_step: Gradient accumulation means running a configured number of
         "GradAccumulationStep" steps without
         updating the model weights while accumulating the gradients of those steps, and then using
         the accumulated gradients to compute the weight updates. Must be a positive integer.
        :paramtype gradient_accumulation_step: str
        :keyword layers_to_freeze: Number of layers to freeze for the model. Must be a positive
         integer.
         For instance, passing 2 as value for 'seresnext' means
         freezing layer0 and layer1. For a full list of models supported and details on layer freeze,
         please
         see: https://learn.microsoft.com/azure/machine-learning/how-to-auto-train-image-models.
        :paramtype layers_to_freeze: str
        :keyword learning_rate: Initial learning rate. Must be a float in the range [0, 1].
        :paramtype learning_rate: str
        :keyword learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or
         'step'.
        :paramtype learning_rate_scheduler: str
        :keyword model_name: Name of the model to use for training.
         For more information on the available models please visit the official documentation:
         https://learn.microsoft.com/azure/machine-learning/how-to-auto-train-image-models.
        :paramtype model_name: str
        :keyword momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0,
         1].
        :paramtype momentum: str
        :keyword nesterov: Enable nesterov when optimizer is 'sgd'.
        :paramtype nesterov: str
        :keyword number_of_epochs: Number of training epochs. Must be a positive integer.
        :paramtype number_of_epochs: str
        :keyword number_of_workers: Number of data loader workers. Must be a non-negative integer.
        :paramtype number_of_workers: str
        :keyword optimizer: Type of optimizer. Must be either 'sgd', 'adam', or 'adamw'.
        :paramtype optimizer: str
        :keyword random_seed: Random seed to be used when using deterministic training.
        :paramtype random_seed: str
        :keyword step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float
         in the range [0, 1].
        :paramtype step_lr_gamma: str
        :keyword step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be
         a positive integer.
        :paramtype step_lr_step_size: str
        :keyword training_batch_size: Training batch size. Must be a positive integer.
        :paramtype training_batch_size: str
        :keyword validation_batch_size: Validation batch size. Must be a positive integer.
        :paramtype validation_batch_size: str
        :keyword warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is
         'warmup_cosine'. Must be a float in the range [0, 1].
        :paramtype warmup_cosine_lr_cycles: str
        :keyword warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is
         'warmup_cosine'. Must be a positive integer.
        :paramtype warmup_cosine_lr_warmup_epochs: str
        :keyword weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must
         be a float in the range[0, 1].
        :paramtype weight_decay: str
        :keyword box_detections_per_image: Maximum number of detections per image, for all classes.
         Must be a positive integer.
         Note: This settings is not supported for the 'yolov5' algorithm.
        :paramtype box_detections_per_image: str
        :keyword box_score_threshold: During inference, only return proposals with a classification
         score greater than
         BoxScoreThreshold. Must be a float in the range[0, 1].
        :paramtype box_score_threshold: str
        :keyword image_size: Image size for train and validation. Must be a positive integer.
         Note: The training run may get into CUDA OOM if the size is too big.
         Note: This settings is only supported for the 'yolov5' algorithm.
        :paramtype image_size: str
        :keyword max_size: Maximum size of the image to be rescaled before feeding it to the backbone.
         Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
         Note: This settings is not supported for the 'yolov5' algorithm.
        :paramtype max_size: str
        :keyword min_size: Minimum size of the image to be rescaled before feeding it to the backbone.
         Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
         Note: This settings is not supported for the 'yolov5' algorithm.
        :paramtype min_size: str
        :keyword model_size: Model size. Must be 'small', 'medium', 'large', or 'xlarge'.
         Note: training run may get into CUDA OOM if the model size is too big.
         Note: This settings is only supported for the 'yolov5' algorithm.
        :paramtype model_size: str
        :keyword multi_scale: Enable multi-scale image by varying image size by +/- 50%.
         Note: training run may get into CUDA OOM if no sufficient GPU memory.
         Note: This settings is only supported for the 'yolov5' algorithm.
        :paramtype multi_scale: str
        :keyword nms_iou_threshold: IOU threshold used during inference in NMS post processing. Must be
         float in the range [0, 1].
        :paramtype nms_iou_threshold: str
        :keyword tile_grid_size: The grid size to use for tiling each image. Note: TileGridSize must
         not be
         None to enable small object detection logic. A string containing two integers in mxn format.
         Note: This settings is not supported for the 'yolov5' algorithm.
        :paramtype tile_grid_size: str
        :keyword tile_overlap_ratio: Overlap ratio between adjacent tiles in each dimension. Must be
         float in the range [0, 1).
         Note: This settings is not supported for the 'yolov5' algorithm.
        :paramtype tile_overlap_ratio: str
        :keyword tile_predictions_nms_threshold: The IOU threshold to use to perform NMS while merging
         predictions from tiles and image.
         Used in validation/ inference. Must be float in the range [0, 1].
         Note: This settings is not supported for the 'yolov5' algorithm.
         NMS: Non-maximum suppression.
        :paramtype tile_predictions_nms_threshold: str
        :keyword validation_iou_threshold: IOU threshold to use when computing validation metric. Must
         be float in the range [0, 1].
        :paramtype validation_iou_threshold: str
        :keyword validation_metric_type: Metric computation method to use for validation metrics. Must
         be 'none', 'coco', 'voc', or 'coco_voc'.
        :paramtype validation_metric_type: str
        """
        super(ImageModelDistributionSettingsObjectDetection, self).__init__(ams_gradient=ams_gradient, augmentations=augmentations, beta1=beta1, beta2=beta2, distributed=distributed, early_stopping=early_stopping, early_stopping_delay=early_stopping_delay, early_stopping_patience=early_stopping_patience, enable_onnx_normalization=enable_onnx_normalization, evaluation_frequency=evaluation_frequency, gradient_accumulation_step=gradient_accumulation_step, layers_to_freeze=layers_to_freeze, learning_rate=learning_rate, learning_rate_scheduler=learning_rate_scheduler, model_name=model_name, momentum=momentum, nesterov=nesterov, number_of_epochs=number_of_epochs, number_of_workers=number_of_workers, optimizer=optimizer, random_seed=random_seed, step_lr_gamma=step_lr_gamma, step_lr_step_size=step_lr_step_size, training_batch_size=training_batch_size, validation_batch_size=validation_batch_size, warmup_cosine_lr_cycles=warmup_cosine_lr_cycles, warmup_cosine_lr_warmup_epochs=warmup_cosine_lr_warmup_epochs, weight_decay=weight_decay, **kwargs)
        self.box_detections_per_image = box_detections_per_image
        self.box_score_threshold = box_score_threshold
        self.image_size = image_size
        self.max_size = max_size
        self.min_size = min_size
        self.model_size = model_size
        self.multi_scale = multi_scale
        self.nms_iou_threshold = nms_iou_threshold
        self.tile_grid_size = tile_grid_size
        self.tile_overlap_ratio = tile_overlap_ratio
        self.tile_predictions_nms_threshold = tile_predictions_nms_threshold
        self.validation_iou_threshold = validation_iou_threshold
        self.validation_metric_type = validation_metric_type


class ImageModelSettings(msrest.serialization.Model):
    """Settings used for training the model.
For more information on the available settings please visit the official documentation:
https://learn.microsoft.com/azure/machine-learning/how-to-auto-train-image-models.

    :ivar advanced_settings: Settings for advanced scenarios.
    :vartype advanced_settings: str
    :ivar ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
    :vartype ams_gradient: bool
    :ivar augmentations: Settings for using Augmentations.
    :vartype augmentations: str
    :ivar beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range
     [0, 1].
    :vartype beta1: float
    :ivar beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range
     [0, 1].
    :vartype beta2: float
    :ivar checkpoint_frequency: Frequency to store model checkpoints. Must be a positive integer.
    :vartype checkpoint_frequency: int
    :ivar checkpoint_model: The pretrained checkpoint model for incremental training.
    :vartype checkpoint_model: ~azure.mgmt.machinelearningservices.models.MLFlowModelJobInput
    :ivar checkpoint_run_id: The id of a previous run that has a pretrained checkpoint for
     incremental training.
    :vartype checkpoint_run_id: str
    :ivar distributed: Whether to use distributed training.
    :vartype distributed: bool
    :ivar early_stopping: Enable early stopping logic during training.
    :vartype early_stopping: bool
    :ivar early_stopping_delay: Minimum number of epochs or validation evaluations to wait before
     primary metric improvement
     is tracked for early stopping. Must be a positive integer.
    :vartype early_stopping_delay: int
    :ivar early_stopping_patience: Minimum number of epochs or validation evaluations with no
     primary metric improvement before
     the run is stopped. Must be a positive integer.
    :vartype early_stopping_patience: int
    :ivar enable_onnx_normalization: Enable normalization when exporting ONNX model.
    :vartype enable_onnx_normalization: bool
    :ivar evaluation_frequency: Frequency to evaluate validation dataset to get metric scores. Must
     be a positive integer.
    :vartype evaluation_frequency: int
    :ivar gradient_accumulation_step: Gradient accumulation means running a configured number of
     "GradAccumulationStep" steps without
     updating the model weights while accumulating the gradients of those steps, and then using
     the accumulated gradients to compute the weight updates. Must be a positive integer.
    :vartype gradient_accumulation_step: int
    :ivar layers_to_freeze: Number of layers to freeze for the model. Must be a positive integer.
     For instance, passing 2 as value for 'seresnext' means
     freezing layer0 and layer1. For a full list of models supported and details on layer freeze,
     please
     see: https://learn.microsoft.com/azure/machine-learning/how-to-auto-train-image-models.
    :vartype layers_to_freeze: int
    :ivar learning_rate: Initial learning rate. Must be a float in the range [0, 1].
    :vartype learning_rate: float
    :ivar learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or
     'step'. Possible values include: "None", "WarmupCosine", "Step".
    :vartype learning_rate_scheduler: str or
     ~azure.mgmt.machinelearningservices.models.LearningRateScheduler
    :ivar model_name: Name of the model to use for training.
     For more information on the available models please visit the official documentation:
     https://learn.microsoft.com/azure/machine-learning/how-to-auto-train-image-models.
    :vartype model_name: str
    :ivar momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
    :vartype momentum: float
    :ivar nesterov: Enable nesterov when optimizer is 'sgd'.
    :vartype nesterov: bool
    :ivar number_of_epochs: Number of training epochs. Must be a positive integer.
    :vartype number_of_epochs: int
    :ivar number_of_workers: Number of data loader workers. Must be a non-negative integer.
    :vartype number_of_workers: int
    :ivar optimizer: Type of optimizer. Possible values include: "None", "Sgd", "Adam", "Adamw".
    :vartype optimizer: str or ~azure.mgmt.machinelearningservices.models.StochasticOptimizer
    :ivar random_seed: Random seed to be used when using deterministic training.
    :vartype random_seed: int
    :ivar step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float in
     the range [0, 1].
    :vartype step_lr_gamma: float
    :ivar step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be a
     positive integer.
    :vartype step_lr_step_size: int
    :ivar training_batch_size: Training batch size. Must be a positive integer.
    :vartype training_batch_size: int
    :ivar validation_batch_size: Validation batch size. Must be a positive integer.
    :vartype validation_batch_size: int
    :ivar warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is
     'warmup_cosine'. Must be a float in the range [0, 1].
    :vartype warmup_cosine_lr_cycles: float
    :ivar warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is
     'warmup_cosine'. Must be a positive integer.
    :vartype warmup_cosine_lr_warmup_epochs: int
    :ivar weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be
     a float in the range[0, 1].
    :vartype weight_decay: float
    """

    _attribute_map = {
        'advanced_settings': {'key': 'advancedSettings', 'type': 'str'},
        'ams_gradient': {'key': 'amsGradient', 'type': 'bool'},
        'augmentations': {'key': 'augmentations', 'type': 'str'},
        'beta1': {'key': 'beta1', 'type': 'float'},
        'beta2': {'key': 'beta2', 'type': 'float'},
        'checkpoint_frequency': {'key': 'checkpointFrequency', 'type': 'int'},
        'checkpoint_model': {'key': 'checkpointModel', 'type': 'MLFlowModelJobInput'},
        'checkpoint_run_id': {'key': 'checkpointRunId', 'type': 'str'},
        'distributed': {'key': 'distributed', 'type': 'bool'},
        'early_stopping': {'key': 'earlyStopping', 'type': 'bool'},
        'early_stopping_delay': {'key': 'earlyStoppingDelay', 'type': 'int'},
        'early_stopping_patience': {'key': 'earlyStoppingPatience', 'type': 'int'},
        'enable_onnx_normalization': {'key': 'enableOnnxNormalization', 'type': 'bool'},
        'evaluation_frequency': {'key': 'evaluationFrequency', 'type': 'int'},
        'gradient_accumulation_step': {'key': 'gradientAccumulationStep', 'type': 'int'},
        'layers_to_freeze': {'key': 'layersToFreeze', 'type': 'int'},
        'learning_rate': {'key': 'learningRate', 'type': 'float'},
        'learning_rate_scheduler': {'key': 'learningRateScheduler', 'type': 'str'},
        'model_name': {'key': 'modelName', 'type': 'str'},
        'momentum': {'key': 'momentum', 'type': 'float'},
        'nesterov': {'key': 'nesterov', 'type': 'bool'},
        'number_of_epochs': {'key': 'numberOfEpochs', 'type': 'int'},
        'number_of_workers': {'key': 'numberOfWorkers', 'type': 'int'},
        'optimizer': {'key': 'optimizer', 'type': 'str'},
        'random_seed': {'key': 'randomSeed', 'type': 'int'},
        'step_lr_gamma': {'key': 'stepLRGamma', 'type': 'float'},
        'step_lr_step_size': {'key': 'stepLRStepSize', 'type': 'int'},
        'training_batch_size': {'key': 'trainingBatchSize', 'type': 'int'},
        'validation_batch_size': {'key': 'validationBatchSize', 'type': 'int'},
        'warmup_cosine_lr_cycles': {'key': 'warmupCosineLRCycles', 'type': 'float'},
        'warmup_cosine_lr_warmup_epochs': {'key': 'warmupCosineLRWarmupEpochs', 'type': 'int'},
        'weight_decay': {'key': 'weightDecay', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        advanced_settings: Optional[str] = None,
        ams_gradient: Optional[bool] = None,
        augmentations: Optional[str] = None,
        beta1: Optional[float] = None,
        beta2: Optional[float] = None,
        checkpoint_frequency: Optional[int] = None,
        checkpoint_model: Optional["MLFlowModelJobInput"] = None,
        checkpoint_run_id: Optional[str] = None,
        distributed: Optional[bool] = None,
        early_stopping: Optional[bool] = None,
        early_stopping_delay: Optional[int] = None,
        early_stopping_patience: Optional[int] = None,
        enable_onnx_normalization: Optional[bool] = None,
        evaluation_frequency: Optional[int] = None,
        gradient_accumulation_step: Optional[int] = None,
        layers_to_freeze: Optional[int] = None,
        learning_rate: Optional[float] = None,
        learning_rate_scheduler: Optional[Union[str, "LearningRateScheduler"]] = None,
        model_name: Optional[str] = None,
        momentum: Optional[float] = None,
        nesterov: Optional[bool] = None,
        number_of_epochs: Optional[int] = None,
        number_of_workers: Optional[int] = None,
        optimizer: Optional[Union[str, "StochasticOptimizer"]] = None,
        random_seed: Optional[int] = None,
        step_lr_gamma: Optional[float] = None,
        step_lr_step_size: Optional[int] = None,
        training_batch_size: Optional[int] = None,
        validation_batch_size: Optional[int] = None,
        warmup_cosine_lr_cycles: Optional[float] = None,
        warmup_cosine_lr_warmup_epochs: Optional[int] = None,
        weight_decay: Optional[float] = None,
        **kwargs
    ):
        """
        :keyword advanced_settings: Settings for advanced scenarios.
        :paramtype advanced_settings: str
        :keyword ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
        :paramtype ams_gradient: bool
        :keyword augmentations: Settings for using Augmentations.
        :paramtype augmentations: str
        :keyword beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the
         range [0, 1].
        :paramtype beta1: float
        :keyword beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the
         range [0, 1].
        :paramtype beta2: float
        :keyword checkpoint_frequency: Frequency to store model checkpoints. Must be a positive
         integer.
        :paramtype checkpoint_frequency: int
        :keyword checkpoint_model: The pretrained checkpoint model for incremental training.
        :paramtype checkpoint_model: ~azure.mgmt.machinelearningservices.models.MLFlowModelJobInput
        :keyword checkpoint_run_id: The id of a previous run that has a pretrained checkpoint for
         incremental training.
        :paramtype checkpoint_run_id: str
        :keyword distributed: Whether to use distributed training.
        :paramtype distributed: bool
        :keyword early_stopping: Enable early stopping logic during training.
        :paramtype early_stopping: bool
        :keyword early_stopping_delay: Minimum number of epochs or validation evaluations to wait
         before primary metric improvement
         is tracked for early stopping. Must be a positive integer.
        :paramtype early_stopping_delay: int
        :keyword early_stopping_patience: Minimum number of epochs or validation evaluations with no
         primary metric improvement before
         the run is stopped. Must be a positive integer.
        :paramtype early_stopping_patience: int
        :keyword enable_onnx_normalization: Enable normalization when exporting ONNX model.
        :paramtype enable_onnx_normalization: bool
        :keyword evaluation_frequency: Frequency to evaluate validation dataset to get metric scores.
         Must be a positive integer.
        :paramtype evaluation_frequency: int
        :keyword gradient_accumulation_step: Gradient accumulation means running a configured number of
         "GradAccumulationStep" steps without
         updating the model weights while accumulating the gradients of those steps, and then using
         the accumulated gradients to compute the weight updates. Must be a positive integer.
        :paramtype gradient_accumulation_step: int
        :keyword layers_to_freeze: Number of layers to freeze for the model. Must be a positive
         integer.
         For instance, passing 2 as value for 'seresnext' means
         freezing layer0 and layer1. For a full list of models supported and details on layer freeze,
         please
         see: https://learn.microsoft.com/azure/machine-learning/how-to-auto-train-image-models.
        :paramtype layers_to_freeze: int
        :keyword learning_rate: Initial learning rate. Must be a float in the range [0, 1].
        :paramtype learning_rate: float
        :keyword learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or
         'step'. Possible values include: "None", "WarmupCosine", "Step".
        :paramtype learning_rate_scheduler: str or
         ~azure.mgmt.machinelearningservices.models.LearningRateScheduler
        :keyword model_name: Name of the model to use for training.
         For more information on the available models please visit the official documentation:
         https://learn.microsoft.com/azure/machine-learning/how-to-auto-train-image-models.
        :paramtype model_name: str
        :keyword momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0,
         1].
        :paramtype momentum: float
        :keyword nesterov: Enable nesterov when optimizer is 'sgd'.
        :paramtype nesterov: bool
        :keyword number_of_epochs: Number of training epochs. Must be a positive integer.
        :paramtype number_of_epochs: int
        :keyword number_of_workers: Number of data loader workers. Must be a non-negative integer.
        :paramtype number_of_workers: int
        :keyword optimizer: Type of optimizer. Possible values include: "None", "Sgd", "Adam", "Adamw".
        :paramtype optimizer: str or ~azure.mgmt.machinelearningservices.models.StochasticOptimizer
        :keyword random_seed: Random seed to be used when using deterministic training.
        :paramtype random_seed: int
        :keyword step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float
         in the range [0, 1].
        :paramtype step_lr_gamma: float
        :keyword step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be
         a positive integer.
        :paramtype step_lr_step_size: int
        :keyword training_batch_size: Training batch size. Must be a positive integer.
        :paramtype training_batch_size: int
        :keyword validation_batch_size: Validation batch size. Must be a positive integer.
        :paramtype validation_batch_size: int
        :keyword warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is
         'warmup_cosine'. Must be a float in the range [0, 1].
        :paramtype warmup_cosine_lr_cycles: float
        :keyword warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is
         'warmup_cosine'. Must be a positive integer.
        :paramtype warmup_cosine_lr_warmup_epochs: int
        :keyword weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must
         be a float in the range[0, 1].
        :paramtype weight_decay: float
        """
        super(ImageModelSettings, self).__init__(**kwargs)
        self.advanced_settings = advanced_settings
        self.ams_gradient = ams_gradient
        self.augmentations = augmentations
        self.beta1 = beta1
        self.beta2 = beta2
        self.checkpoint_frequency = checkpoint_frequency
        self.checkpoint_model = checkpoint_model
        self.checkpoint_run_id = checkpoint_run_id
        self.distributed = distributed
        self.early_stopping = early_stopping
        self.early_stopping_delay = early_stopping_delay
        self.early_stopping_patience = early_stopping_patience
        self.enable_onnx_normalization = enable_onnx_normalization
        self.evaluation_frequency = evaluation_frequency
        self.gradient_accumulation_step = gradient_accumulation_step
        self.layers_to_freeze = layers_to_freeze
        self.learning_rate = learning_rate
        self.learning_rate_scheduler = learning_rate_scheduler
        self.model_name = model_name
        self.momentum = momentum
        self.nesterov = nesterov
        self.number_of_epochs = number_of_epochs
        self.number_of_workers = number_of_workers
        self.optimizer = optimizer
        self.random_seed = random_seed
        self.step_lr_gamma = step_lr_gamma
        self.step_lr_step_size = step_lr_step_size
        self.training_batch_size = training_batch_size
        self.validation_batch_size = validation_batch_size
        self.warmup_cosine_lr_cycles = warmup_cosine_lr_cycles
        self.warmup_cosine_lr_warmup_epochs = warmup_cosine_lr_warmup_epochs
        self.weight_decay = weight_decay


class ImageModelSettingsClassification(ImageModelSettings):
    """Settings used for training the model.
For more information on the available settings please visit the official documentation:
https://learn.microsoft.com/azure/machine-learning/how-to-auto-train-image-models.

    :ivar advanced_settings: Settings for advanced scenarios.
    :vartype advanced_settings: str
    :ivar ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
    :vartype ams_gradient: bool
    :ivar augmentations: Settings for using Augmentations.
    :vartype augmentations: str
    :ivar beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range
     [0, 1].
    :vartype beta1: float
    :ivar beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range
     [0, 1].
    :vartype beta2: float
    :ivar checkpoint_frequency: Frequency to store model checkpoints. Must be a positive integer.
    :vartype checkpoint_frequency: int
    :ivar checkpoint_model: The pretrained checkpoint model for incremental training.
    :vartype checkpoint_model: ~azure.mgmt.machinelearningservices.models.MLFlowModelJobInput
    :ivar checkpoint_run_id: The id of a previous run that has a pretrained checkpoint for
     incremental training.
    :vartype checkpoint_run_id: str
    :ivar distributed: Whether to use distributed training.
    :vartype distributed: bool
    :ivar early_stopping: Enable early stopping logic during training.
    :vartype early_stopping: bool
    :ivar early_stopping_delay: Minimum number of epochs or validation evaluations to wait before
     primary metric improvement
     is tracked for early stopping. Must be a positive integer.
    :vartype early_stopping_delay: int
    :ivar early_stopping_patience: Minimum number of epochs or validation evaluations with no
     primary metric improvement before
     the run is stopped. Must be a positive integer.
    :vartype early_stopping_patience: int
    :ivar enable_onnx_normalization: Enable normalization when exporting ONNX model.
    :vartype enable_onnx_normalization: bool
    :ivar evaluation_frequency: Frequency to evaluate validation dataset to get metric scores. Must
     be a positive integer.
    :vartype evaluation_frequency: int
    :ivar gradient_accumulation_step: Gradient accumulation means running a configured number of
     "GradAccumulationStep" steps without
     updating the model weights while accumulating the gradients of those steps, and then using
     the accumulated gradients to compute the weight updates. Must be a positive integer.
    :vartype gradient_accumulation_step: int
    :ivar layers_to_freeze: Number of layers to freeze for the model. Must be a positive integer.
     For instance, passing 2 as value for 'seresnext' means
     freezing layer0 and layer1. For a full list of models supported and details on layer freeze,
     please
     see: https://learn.microsoft.com/azure/machine-learning/how-to-auto-train-image-models.
    :vartype layers_to_freeze: int
    :ivar learning_rate: Initial learning rate. Must be a float in the range [0, 1].
    :vartype learning_rate: float
    :ivar learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or
     'step'. Possible values include: "None", "WarmupCosine", "Step".
    :vartype learning_rate_scheduler: str or
     ~azure.mgmt.machinelearningservices.models.LearningRateScheduler
    :ivar model_name: Name of the model to use for training.
     For more information on the available models please visit the official documentation:
     https://learn.microsoft.com/azure/machine-learning/how-to-auto-train-image-models.
    :vartype model_name: str
    :ivar momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
    :vartype momentum: float
    :ivar nesterov: Enable nesterov when optimizer is 'sgd'.
    :vartype nesterov: bool
    :ivar number_of_epochs: Number of training epochs. Must be a positive integer.
    :vartype number_of_epochs: int
    :ivar number_of_workers: Number of data loader workers. Must be a non-negative integer.
    :vartype number_of_workers: int
    :ivar optimizer: Type of optimizer. Possible values include: "None", "Sgd", "Adam", "Adamw".
    :vartype optimizer: str or ~azure.mgmt.machinelearningservices.models.StochasticOptimizer
    :ivar random_seed: Random seed to be used when using deterministic training.
    :vartype random_seed: int
    :ivar step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float in
     the range [0, 1].
    :vartype step_lr_gamma: float
    :ivar step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be a
     positive integer.
    :vartype step_lr_step_size: int
    :ivar training_batch_size: Training batch size. Must be a positive integer.
    :vartype training_batch_size: int
    :ivar validation_batch_size: Validation batch size. Must be a positive integer.
    :vartype validation_batch_size: int
    :ivar warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is
     'warmup_cosine'. Must be a float in the range [0, 1].
    :vartype warmup_cosine_lr_cycles: float
    :ivar warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is
     'warmup_cosine'. Must be a positive integer.
    :vartype warmup_cosine_lr_warmup_epochs: int
    :ivar weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be
     a float in the range[0, 1].
    :vartype weight_decay: float
    :ivar training_crop_size: Image crop size that is input to the neural network for the training
     dataset. Must be a positive integer.
    :vartype training_crop_size: int
    :ivar validation_crop_size: Image crop size that is input to the neural network for the
     validation dataset. Must be a positive integer.
    :vartype validation_crop_size: int
    :ivar validation_resize_size: Image size to which to resize before cropping for validation
     dataset. Must be a positive integer.
    :vartype validation_resize_size: int
    :ivar weighted_loss: Weighted loss. The accepted values are 0 for no weighted loss.
     1 for weighted loss with sqrt.(class_weights). 2 for weighted loss with class_weights. Must be
     0 or 1 or 2.
    :vartype weighted_loss: int
    """

    _attribute_map = {
        'advanced_settings': {'key': 'advancedSettings', 'type': 'str'},
        'ams_gradient': {'key': 'amsGradient', 'type': 'bool'},
        'augmentations': {'key': 'augmentations', 'type': 'str'},
        'beta1': {'key': 'beta1', 'type': 'float'},
        'beta2': {'key': 'beta2', 'type': 'float'},
        'checkpoint_frequency': {'key': 'checkpointFrequency', 'type': 'int'},
        'checkpoint_model': {'key': 'checkpointModel', 'type': 'MLFlowModelJobInput'},
        'checkpoint_run_id': {'key': 'checkpointRunId', 'type': 'str'},
        'distributed': {'key': 'distributed', 'type': 'bool'},
        'early_stopping': {'key': 'earlyStopping', 'type': 'bool'},
        'early_stopping_delay': {'key': 'earlyStoppingDelay', 'type': 'int'},
        'early_stopping_patience': {'key': 'earlyStoppingPatience', 'type': 'int'},
        'enable_onnx_normalization': {'key': 'enableOnnxNormalization', 'type': 'bool'},
        'evaluation_frequency': {'key': 'evaluationFrequency', 'type': 'int'},
        'gradient_accumulation_step': {'key': 'gradientAccumulationStep', 'type': 'int'},
        'layers_to_freeze': {'key': 'layersToFreeze', 'type': 'int'},
        'learning_rate': {'key': 'learningRate', 'type': 'float'},
        'learning_rate_scheduler': {'key': 'learningRateScheduler', 'type': 'str'},
        'model_name': {'key': 'modelName', 'type': 'str'},
        'momentum': {'key': 'momentum', 'type': 'float'},
        'nesterov': {'key': 'nesterov', 'type': 'bool'},
        'number_of_epochs': {'key': 'numberOfEpochs', 'type': 'int'},
        'number_of_workers': {'key': 'numberOfWorkers', 'type': 'int'},
        'optimizer': {'key': 'optimizer', 'type': 'str'},
        'random_seed': {'key': 'randomSeed', 'type': 'int'},
        'step_lr_gamma': {'key': 'stepLRGamma', 'type': 'float'},
        'step_lr_step_size': {'key': 'stepLRStepSize', 'type': 'int'},
        'training_batch_size': {'key': 'trainingBatchSize', 'type': 'int'},
        'validation_batch_size': {'key': 'validationBatchSize', 'type': 'int'},
        'warmup_cosine_lr_cycles': {'key': 'warmupCosineLRCycles', 'type': 'float'},
        'warmup_cosine_lr_warmup_epochs': {'key': 'warmupCosineLRWarmupEpochs', 'type': 'int'},
        'weight_decay': {'key': 'weightDecay', 'type': 'float'},
        'training_crop_size': {'key': 'trainingCropSize', 'type': 'int'},
        'validation_crop_size': {'key': 'validationCropSize', 'type': 'int'},
        'validation_resize_size': {'key': 'validationResizeSize', 'type': 'int'},
        'weighted_loss': {'key': 'weightedLoss', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        advanced_settings: Optional[str] = None,
        ams_gradient: Optional[bool] = None,
        augmentations: Optional[str] = None,
        beta1: Optional[float] = None,
        beta2: Optional[float] = None,
        checkpoint_frequency: Optional[int] = None,
        checkpoint_model: Optional["MLFlowModelJobInput"] = None,
        checkpoint_run_id: Optional[str] = None,
        distributed: Optional[bool] = None,
        early_stopping: Optional[bool] = None,
        early_stopping_delay: Optional[int] = None,
        early_stopping_patience: Optional[int] = None,
        enable_onnx_normalization: Optional[bool] = None,
        evaluation_frequency: Optional[int] = None,
        gradient_accumulation_step: Optional[int] = None,
        layers_to_freeze: Optional[int] = None,
        learning_rate: Optional[float] = None,
        learning_rate_scheduler: Optional[Union[str, "LearningRateScheduler"]] = None,
        model_name: Optional[str] = None,
        momentum: Optional[float] = None,
        nesterov: Optional[bool] = None,
        number_of_epochs: Optional[int] = None,
        number_of_workers: Optional[int] = None,
        optimizer: Optional[Union[str, "StochasticOptimizer"]] = None,
        random_seed: Optional[int] = None,
        step_lr_gamma: Optional[float] = None,
        step_lr_step_size: Optional[int] = None,
        training_batch_size: Optional[int] = None,
        validation_batch_size: Optional[int] = None,
        warmup_cosine_lr_cycles: Optional[float] = None,
        warmup_cosine_lr_warmup_epochs: Optional[int] = None,
        weight_decay: Optional[float] = None,
        training_crop_size: Optional[int] = None,
        validation_crop_size: Optional[int] = None,
        validation_resize_size: Optional[int] = None,
        weighted_loss: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword advanced_settings: Settings for advanced scenarios.
        :paramtype advanced_settings: str
        :keyword ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
        :paramtype ams_gradient: bool
        :keyword augmentations: Settings for using Augmentations.
        :paramtype augmentations: str
        :keyword beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the
         range [0, 1].
        :paramtype beta1: float
        :keyword beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the
         range [0, 1].
        :paramtype beta2: float
        :keyword checkpoint_frequency: Frequency to store model checkpoints. Must be a positive
         integer.
        :paramtype checkpoint_frequency: int
        :keyword checkpoint_model: The pretrained checkpoint model for incremental training.
        :paramtype checkpoint_model: ~azure.mgmt.machinelearningservices.models.MLFlowModelJobInput
        :keyword checkpoint_run_id: The id of a previous run that has a pretrained checkpoint for
         incremental training.
        :paramtype checkpoint_run_id: str
        :keyword distributed: Whether to use distributed training.
        :paramtype distributed: bool
        :keyword early_stopping: Enable early stopping logic during training.
        :paramtype early_stopping: bool
        :keyword early_stopping_delay: Minimum number of epochs or validation evaluations to wait
         before primary metric improvement
         is tracked for early stopping. Must be a positive integer.
        :paramtype early_stopping_delay: int
        :keyword early_stopping_patience: Minimum number of epochs or validation evaluations with no
         primary metric improvement before
         the run is stopped. Must be a positive integer.
        :paramtype early_stopping_patience: int
        :keyword enable_onnx_normalization: Enable normalization when exporting ONNX model.
        :paramtype enable_onnx_normalization: bool
        :keyword evaluation_frequency: Frequency to evaluate validation dataset to get metric scores.
         Must be a positive integer.
        :paramtype evaluation_frequency: int
        :keyword gradient_accumulation_step: Gradient accumulation means running a configured number of
         "GradAccumulationStep" steps without
         updating the model weights while accumulating the gradients of those steps, and then using
         the accumulated gradients to compute the weight updates. Must be a positive integer.
        :paramtype gradient_accumulation_step: int
        :keyword layers_to_freeze: Number of layers to freeze for the model. Must be a positive
         integer.
         For instance, passing 2 as value for 'seresnext' means
         freezing layer0 and layer1. For a full list of models supported and details on layer freeze,
         please
         see: https://learn.microsoft.com/azure/machine-learning/how-to-auto-train-image-models.
        :paramtype layers_to_freeze: int
        :keyword learning_rate: Initial learning rate. Must be a float in the range [0, 1].
        :paramtype learning_rate: float
        :keyword learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or
         'step'. Possible values include: "None", "WarmupCosine", "Step".
        :paramtype learning_rate_scheduler: str or
         ~azure.mgmt.machinelearningservices.models.LearningRateScheduler
        :keyword model_name: Name of the model to use for training.
         For more information on the available models please visit the official documentation:
         https://learn.microsoft.com/azure/machine-learning/how-to-auto-train-image-models.
        :paramtype model_name: str
        :keyword momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0,
         1].
        :paramtype momentum: float
        :keyword nesterov: Enable nesterov when optimizer is 'sgd'.
        :paramtype nesterov: bool
        :keyword number_of_epochs: Number of training epochs. Must be a positive integer.
        :paramtype number_of_epochs: int
        :keyword number_of_workers: Number of data loader workers. Must be a non-negative integer.
        :paramtype number_of_workers: int
        :keyword optimizer: Type of optimizer. Possible values include: "None", "Sgd", "Adam", "Adamw".
        :paramtype optimizer: str or ~azure.mgmt.machinelearningservices.models.StochasticOptimizer
        :keyword random_seed: Random seed to be used when using deterministic training.
        :paramtype random_seed: int
        :keyword step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float
         in the range [0, 1].
        :paramtype step_lr_gamma: float
        :keyword step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be
         a positive integer.
        :paramtype step_lr_step_size: int
        :keyword training_batch_size: Training batch size. Must be a positive integer.
        :paramtype training_batch_size: int
        :keyword validation_batch_size: Validation batch size. Must be a positive integer.
        :paramtype validation_batch_size: int
        :keyword warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is
         'warmup_cosine'. Must be a float in the range [0, 1].
        :paramtype warmup_cosine_lr_cycles: float
        :keyword warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is
         'warmup_cosine'. Must be a positive integer.
        :paramtype warmup_cosine_lr_warmup_epochs: int
        :keyword weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must
         be a float in the range[0, 1].
        :paramtype weight_decay: float
        :keyword training_crop_size: Image crop size that is input to the neural network for the
         training dataset. Must be a positive integer.
        :paramtype training_crop_size: int
        :keyword validation_crop_size: Image crop size that is input to the neural network for the
         validation dataset. Must be a positive integer.
        :paramtype validation_crop_size: int
        :keyword validation_resize_size: Image size to which to resize before cropping for validation
         dataset. Must be a positive integer.
        :paramtype validation_resize_size: int
        :keyword weighted_loss: Weighted loss. The accepted values are 0 for no weighted loss.
         1 for weighted loss with sqrt.(class_weights). 2 for weighted loss with class_weights. Must be
         0 or 1 or 2.
        :paramtype weighted_loss: int
        """
        super(ImageModelSettingsClassification, self).__init__(advanced_settings=advanced_settings, ams_gradient=ams_gradient, augmentations=augmentations, beta1=beta1, beta2=beta2, checkpoint_frequency=checkpoint_frequency, checkpoint_model=checkpoint_model, checkpoint_run_id=checkpoint_run_id, distributed=distributed, early_stopping=early_stopping, early_stopping_delay=early_stopping_delay, early_stopping_patience=early_stopping_patience, enable_onnx_normalization=enable_onnx_normalization, evaluation_frequency=evaluation_frequency, gradient_accumulation_step=gradient_accumulation_step, layers_to_freeze=layers_to_freeze, learning_rate=learning_rate, learning_rate_scheduler=learning_rate_scheduler, model_name=model_name, momentum=momentum, nesterov=nesterov, number_of_epochs=number_of_epochs, number_of_workers=number_of_workers, optimizer=optimizer, random_seed=random_seed, step_lr_gamma=step_lr_gamma, step_lr_step_size=step_lr_step_size, training_batch_size=training_batch_size, validation_batch_size=validation_batch_size, warmup_cosine_lr_cycles=warmup_cosine_lr_cycles, warmup_cosine_lr_warmup_epochs=warmup_cosine_lr_warmup_epochs, weight_decay=weight_decay, **kwargs)
        self.training_crop_size = training_crop_size
        self.validation_crop_size = validation_crop_size
        self.validation_resize_size = validation_resize_size
        self.weighted_loss = weighted_loss


class ImageModelSettingsObjectDetection(ImageModelSettings):
    """Settings used for training the model.
For more information on the available settings please visit the official documentation:
https://learn.microsoft.com/azure/machine-learning/how-to-auto-train-image-models.

    :ivar advanced_settings: Settings for advanced scenarios.
    :vartype advanced_settings: str
    :ivar ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
    :vartype ams_gradient: bool
    :ivar augmentations: Settings for using Augmentations.
    :vartype augmentations: str
    :ivar beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range
     [0, 1].
    :vartype beta1: float
    :ivar beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range
     [0, 1].
    :vartype beta2: float
    :ivar checkpoint_frequency: Frequency to store model checkpoints. Must be a positive integer.
    :vartype checkpoint_frequency: int
    :ivar checkpoint_model: The pretrained checkpoint model for incremental training.
    :vartype checkpoint_model: ~azure.mgmt.machinelearningservices.models.MLFlowModelJobInput
    :ivar checkpoint_run_id: The id of a previous run that has a pretrained checkpoint for
     incremental training.
    :vartype checkpoint_run_id: str
    :ivar distributed: Whether to use distributed training.
    :vartype distributed: bool
    :ivar early_stopping: Enable early stopping logic during training.
    :vartype early_stopping: bool
    :ivar early_stopping_delay: Minimum number of epochs or validation evaluations to wait before
     primary metric improvement
     is tracked for early stopping. Must be a positive integer.
    :vartype early_stopping_delay: int
    :ivar early_stopping_patience: Minimum number of epochs or validation evaluations with no
     primary metric improvement before
     the run is stopped. Must be a positive integer.
    :vartype early_stopping_patience: int
    :ivar enable_onnx_normalization: Enable normalization when exporting ONNX model.
    :vartype enable_onnx_normalization: bool
    :ivar evaluation_frequency: Frequency to evaluate validation dataset to get metric scores. Must
     be a positive integer.
    :vartype evaluation_frequency: int
    :ivar gradient_accumulation_step: Gradient accumulation means running a configured number of
     "GradAccumulationStep" steps without
     updating the model weights while accumulating the gradients of those steps, and then using
     the accumulated gradients to compute the weight updates. Must be a positive integer.
    :vartype gradient_accumulation_step: int
    :ivar layers_to_freeze: Number of layers to freeze for the model. Must be a positive integer.
     For instance, passing 2 as value for 'seresnext' means
     freezing layer0 and layer1. For a full list of models supported and details on layer freeze,
     please
     see: https://learn.microsoft.com/azure/machine-learning/how-to-auto-train-image-models.
    :vartype layers_to_freeze: int
    :ivar learning_rate: Initial learning rate. Must be a float in the range [0, 1].
    :vartype learning_rate: float
    :ivar learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or
     'step'. Possible values include: "None", "WarmupCosine", "Step".
    :vartype learning_rate_scheduler: str or
     ~azure.mgmt.machinelearningservices.models.LearningRateScheduler
    :ivar model_name: Name of the model to use for training.
     For more information on the available models please visit the official documentation:
     https://learn.microsoft.com/azure/machine-learning/how-to-auto-train-image-models.
    :vartype model_name: str
    :ivar momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
    :vartype momentum: float
    :ivar nesterov: Enable nesterov when optimizer is 'sgd'.
    :vartype nesterov: bool
    :ivar number_of_epochs: Number of training epochs. Must be a positive integer.
    :vartype number_of_epochs: int
    :ivar number_of_workers: Number of data loader workers. Must be a non-negative integer.
    :vartype number_of_workers: int
    :ivar optimizer: Type of optimizer. Possible values include: "None", "Sgd", "Adam", "Adamw".
    :vartype optimizer: str or ~azure.mgmt.machinelearningservices.models.StochasticOptimizer
    :ivar random_seed: Random seed to be used when using deterministic training.
    :vartype random_seed: int
    :ivar step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float in
     the range [0, 1].
    :vartype step_lr_gamma: float
    :ivar step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be a
     positive integer.
    :vartype step_lr_step_size: int
    :ivar training_batch_size: Training batch size. Must be a positive integer.
    :vartype training_batch_size: int
    :ivar validation_batch_size: Validation batch size. Must be a positive integer.
    :vartype validation_batch_size: int
    :ivar warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is
     'warmup_cosine'. Must be a float in the range [0, 1].
    :vartype warmup_cosine_lr_cycles: float
    :ivar warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is
     'warmup_cosine'. Must be a positive integer.
    :vartype warmup_cosine_lr_warmup_epochs: int
    :ivar weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be
     a float in the range[0, 1].
    :vartype weight_decay: float
    :ivar box_detections_per_image: Maximum number of detections per image, for all classes. Must
     be a positive integer.
     Note: This settings is not supported for the 'yolov5' algorithm.
    :vartype box_detections_per_image: int
    :ivar box_score_threshold: During inference, only return proposals with a classification score
     greater than
     BoxScoreThreshold. Must be a float in the range[0, 1].
    :vartype box_score_threshold: float
    :ivar image_size: Image size for train and validation. Must be a positive integer.
     Note: The training run may get into CUDA OOM if the size is too big.
     Note: This settings is only supported for the 'yolov5' algorithm.
    :vartype image_size: int
    :ivar max_size: Maximum size of the image to be rescaled before feeding it to the backbone.
     Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
     Note: This settings is not supported for the 'yolov5' algorithm.
    :vartype max_size: int
    :ivar min_size: Minimum size of the image to be rescaled before feeding it to the backbone.
     Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
     Note: This settings is not supported for the 'yolov5' algorithm.
    :vartype min_size: int
    :ivar model_size: Model size. Must be 'small', 'medium', 'large', or 'xlarge'.
     Note: training run may get into CUDA OOM if the model size is too big.
     Note: This settings is only supported for the 'yolov5' algorithm. Possible values include:
     "None", "Small", "Medium", "Large", "ExtraLarge".
    :vartype model_size: str or ~azure.mgmt.machinelearningservices.models.ModelSize
    :ivar multi_scale: Enable multi-scale image by varying image size by +/- 50%.
     Note: training run may get into CUDA OOM if no sufficient GPU memory.
     Note: This settings is only supported for the 'yolov5' algorithm.
    :vartype multi_scale: bool
    :ivar nms_iou_threshold: IOU threshold used during inference in NMS post processing. Must be a
     float in the range [0, 1].
    :vartype nms_iou_threshold: float
    :ivar tile_grid_size: The grid size to use for tiling each image. Note: TileGridSize must not
     be
     None to enable small object detection logic. A string containing two integers in mxn format.
     Note: This settings is not supported for the 'yolov5' algorithm.
    :vartype tile_grid_size: str
    :ivar tile_overlap_ratio: Overlap ratio between adjacent tiles in each dimension. Must be float
     in the range [0, 1).
     Note: This settings is not supported for the 'yolov5' algorithm.
    :vartype tile_overlap_ratio: float
    :ivar tile_predictions_nms_threshold: The IOU threshold to use to perform NMS while merging
     predictions from tiles and image.
     Used in validation/ inference. Must be float in the range [0, 1].
     Note: This settings is not supported for the 'yolov5' algorithm.
    :vartype tile_predictions_nms_threshold: float
    :ivar validation_iou_threshold: IOU threshold to use when computing validation metric. Must be
     float in the range [0, 1].
    :vartype validation_iou_threshold: float
    :ivar validation_metric_type: Metric computation method to use for validation metrics. Possible
     values include: "None", "Coco", "Voc", "CocoVoc".
    :vartype validation_metric_type: str or
     ~azure.mgmt.machinelearningservices.models.ValidationMetricType
    """

    _attribute_map = {
        'advanced_settings': {'key': 'advancedSettings', 'type': 'str'},
        'ams_gradient': {'key': 'amsGradient', 'type': 'bool'},
        'augmentations': {'key': 'augmentations', 'type': 'str'},
        'beta1': {'key': 'beta1', 'type': 'float'},
        'beta2': {'key': 'beta2', 'type': 'float'},
        'checkpoint_frequency': {'key': 'checkpointFrequency', 'type': 'int'},
        'checkpoint_model': {'key': 'checkpointModel', 'type': 'MLFlowModelJobInput'},
        'checkpoint_run_id': {'key': 'checkpointRunId', 'type': 'str'},
        'distributed': {'key': 'distributed', 'type': 'bool'},
        'early_stopping': {'key': 'earlyStopping', 'type': 'bool'},
        'early_stopping_delay': {'key': 'earlyStoppingDelay', 'type': 'int'},
        'early_stopping_patience': {'key': 'earlyStoppingPatience', 'type': 'int'},
        'enable_onnx_normalization': {'key': 'enableOnnxNormalization', 'type': 'bool'},
        'evaluation_frequency': {'key': 'evaluationFrequency', 'type': 'int'},
        'gradient_accumulation_step': {'key': 'gradientAccumulationStep', 'type': 'int'},
        'layers_to_freeze': {'key': 'layersToFreeze', 'type': 'int'},
        'learning_rate': {'key': 'learningRate', 'type': 'float'},
        'learning_rate_scheduler': {'key': 'learningRateScheduler', 'type': 'str'},
        'model_name': {'key': 'modelName', 'type': 'str'},
        'momentum': {'key': 'momentum', 'type': 'float'},
        'nesterov': {'key': 'nesterov', 'type': 'bool'},
        'number_of_epochs': {'key': 'numberOfEpochs', 'type': 'int'},
        'number_of_workers': {'key': 'numberOfWorkers', 'type': 'int'},
        'optimizer': {'key': 'optimizer', 'type': 'str'},
        'random_seed': {'key': 'randomSeed', 'type': 'int'},
        'step_lr_gamma': {'key': 'stepLRGamma', 'type': 'float'},
        'step_lr_step_size': {'key': 'stepLRStepSize', 'type': 'int'},
        'training_batch_size': {'key': 'trainingBatchSize', 'type': 'int'},
        'validation_batch_size': {'key': 'validationBatchSize', 'type': 'int'},
        'warmup_cosine_lr_cycles': {'key': 'warmupCosineLRCycles', 'type': 'float'},
        'warmup_cosine_lr_warmup_epochs': {'key': 'warmupCosineLRWarmupEpochs', 'type': 'int'},
        'weight_decay': {'key': 'weightDecay', 'type': 'float'},
        'box_detections_per_image': {'key': 'boxDetectionsPerImage', 'type': 'int'},
        'box_score_threshold': {'key': 'boxScoreThreshold', 'type': 'float'},
        'image_size': {'key': 'imageSize', 'type': 'int'},
        'max_size': {'key': 'maxSize', 'type': 'int'},
        'min_size': {'key': 'minSize', 'type': 'int'},
        'model_size': {'key': 'modelSize', 'type': 'str'},
        'multi_scale': {'key': 'multiScale', 'type': 'bool'},
        'nms_iou_threshold': {'key': 'nmsIouThreshold', 'type': 'float'},
        'tile_grid_size': {'key': 'tileGridSize', 'type': 'str'},
        'tile_overlap_ratio': {'key': 'tileOverlapRatio', 'type': 'float'},
        'tile_predictions_nms_threshold': {'key': 'tilePredictionsNmsThreshold', 'type': 'float'},
        'validation_iou_threshold': {'key': 'validationIouThreshold', 'type': 'float'},
        'validation_metric_type': {'key': 'validationMetricType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        advanced_settings: Optional[str] = None,
        ams_gradient: Optional[bool] = None,
        augmentations: Optional[str] = None,
        beta1: Optional[float] = None,
        beta2: Optional[float] = None,
        checkpoint_frequency: Optional[int] = None,
        checkpoint_model: Optional["MLFlowModelJobInput"] = None,
        checkpoint_run_id: Optional[str] = None,
        distributed: Optional[bool] = None,
        early_stopping: Optional[bool] = None,
        early_stopping_delay: Optional[int] = None,
        early_stopping_patience: Optional[int] = None,
        enable_onnx_normalization: Optional[bool] = None,
        evaluation_frequency: Optional[int] = None,
        gradient_accumulation_step: Optional[int] = None,
        layers_to_freeze: Optional[int] = None,
        learning_rate: Optional[float] = None,
        learning_rate_scheduler: Optional[Union[str, "LearningRateScheduler"]] = None,
        model_name: Optional[str] = None,
        momentum: Optional[float] = None,
        nesterov: Optional[bool] = None,
        number_of_epochs: Optional[int] = None,
        number_of_workers: Optional[int] = None,
        optimizer: Optional[Union[str, "StochasticOptimizer"]] = None,
        random_seed: Optional[int] = None,
        step_lr_gamma: Optional[float] = None,
        step_lr_step_size: Optional[int] = None,
        training_batch_size: Optional[int] = None,
        validation_batch_size: Optional[int] = None,
        warmup_cosine_lr_cycles: Optional[float] = None,
        warmup_cosine_lr_warmup_epochs: Optional[int] = None,
        weight_decay: Optional[float] = None,
        box_detections_per_image: Optional[int] = None,
        box_score_threshold: Optional[float] = None,
        image_size: Optional[int] = None,
        max_size: Optional[int] = None,
        min_size: Optional[int] = None,
        model_size: Optional[Union[str, "ModelSize"]] = None,
        multi_scale: Optional[bool] = None,
        nms_iou_threshold: Optional[float] = None,
        tile_grid_size: Optional[str] = None,
        tile_overlap_ratio: Optional[float] = None,
        tile_predictions_nms_threshold: Optional[float] = None,
        validation_iou_threshold: Optional[float] = None,
        validation_metric_type: Optional[Union[str, "ValidationMetricType"]] = None,
        **kwargs
    ):
        """
        :keyword advanced_settings: Settings for advanced scenarios.
        :paramtype advanced_settings: str
        :keyword ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
        :paramtype ams_gradient: bool
        :keyword augmentations: Settings for using Augmentations.
        :paramtype augmentations: str
        :keyword beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the
         range [0, 1].
        :paramtype beta1: float
        :keyword beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the
         range [0, 1].
        :paramtype beta2: float
        :keyword checkpoint_frequency: Frequency to store model checkpoints. Must be a positive
         integer.
        :paramtype checkpoint_frequency: int
        :keyword checkpoint_model: The pretrained checkpoint model for incremental training.
        :paramtype checkpoint_model: ~azure.mgmt.machinelearningservices.models.MLFlowModelJobInput
        :keyword checkpoint_run_id: The id of a previous run that has a pretrained checkpoint for
         incremental training.
        :paramtype checkpoint_run_id: str
        :keyword distributed: Whether to use distributed training.
        :paramtype distributed: bool
        :keyword early_stopping: Enable early stopping logic during training.
        :paramtype early_stopping: bool
        :keyword early_stopping_delay: Minimum number of epochs or validation evaluations to wait
         before primary metric improvement
         is tracked for early stopping. Must be a positive integer.
        :paramtype early_stopping_delay: int
        :keyword early_stopping_patience: Minimum number of epochs or validation evaluations with no
         primary metric improvement before
         the run is stopped. Must be a positive integer.
        :paramtype early_stopping_patience: int
        :keyword enable_onnx_normalization: Enable normalization when exporting ONNX model.
        :paramtype enable_onnx_normalization: bool
        :keyword evaluation_frequency: Frequency to evaluate validation dataset to get metric scores.
         Must be a positive integer.
        :paramtype evaluation_frequency: int
        :keyword gradient_accumulation_step: Gradient accumulation means running a configured number of
         "GradAccumulationStep" steps without
         updating the model weights while accumulating the gradients of those steps, and then using
         the accumulated gradients to compute the weight updates. Must be a positive integer.
        :paramtype gradient_accumulation_step: int
        :keyword layers_to_freeze: Number of layers to freeze for the model. Must be a positive
         integer.
         For instance, passing 2 as value for 'seresnext' means
         freezing layer0 and layer1. For a full list of models supported and details on layer freeze,
         please
         see: https://learn.microsoft.com/azure/machine-learning/how-to-auto-train-image-models.
        :paramtype layers_to_freeze: int
        :keyword learning_rate: Initial learning rate. Must be a float in the range [0, 1].
        :paramtype learning_rate: float
        :keyword learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or
         'step'. Possible values include: "None", "WarmupCosine", "Step".
        :paramtype learning_rate_scheduler: str or
         ~azure.mgmt.machinelearningservices.models.LearningRateScheduler
        :keyword model_name: Name of the model to use for training.
         For more information on the available models please visit the official documentation:
         https://learn.microsoft.com/azure/machine-learning/how-to-auto-train-image-models.
        :paramtype model_name: str
        :keyword momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0,
         1].
        :paramtype momentum: float
        :keyword nesterov: Enable nesterov when optimizer is 'sgd'.
        :paramtype nesterov: bool
        :keyword number_of_epochs: Number of training epochs. Must be a positive integer.
        :paramtype number_of_epochs: int
        :keyword number_of_workers: Number of data loader workers. Must be a non-negative integer.
        :paramtype number_of_workers: int
        :keyword optimizer: Type of optimizer. Possible values include: "None", "Sgd", "Adam", "Adamw".
        :paramtype optimizer: str or ~azure.mgmt.machinelearningservices.models.StochasticOptimizer
        :keyword random_seed: Random seed to be used when using deterministic training.
        :paramtype random_seed: int
        :keyword step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float
         in the range [0, 1].
        :paramtype step_lr_gamma: float
        :keyword step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be
         a positive integer.
        :paramtype step_lr_step_size: int
        :keyword training_batch_size: Training batch size. Must be a positive integer.
        :paramtype training_batch_size: int
        :keyword validation_batch_size: Validation batch size. Must be a positive integer.
        :paramtype validation_batch_size: int
        :keyword warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is
         'warmup_cosine'. Must be a float in the range [0, 1].
        :paramtype warmup_cosine_lr_cycles: float
        :keyword warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is
         'warmup_cosine'. Must be a positive integer.
        :paramtype warmup_cosine_lr_warmup_epochs: int
        :keyword weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must
         be a float in the range[0, 1].
        :paramtype weight_decay: float
        :keyword box_detections_per_image: Maximum number of detections per image, for all classes.
         Must be a positive integer.
         Note: This settings is not supported for the 'yolov5' algorithm.
        :paramtype box_detections_per_image: int
        :keyword box_score_threshold: During inference, only return proposals with a classification
         score greater than
         BoxScoreThreshold. Must be a float in the range[0, 1].
        :paramtype box_score_threshold: float
        :keyword image_size: Image size for train and validation. Must be a positive integer.
         Note: The training run may get into CUDA OOM if the size is too big.
         Note: This settings is only supported for the 'yolov5' algorithm.
        :paramtype image_size: int
        :keyword max_size: Maximum size of the image to be rescaled before feeding it to the backbone.
         Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
         Note: This settings is not supported for the 'yolov5' algorithm.
        :paramtype max_size: int
        :keyword min_size: Minimum size of the image to be rescaled before feeding it to the backbone.
         Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
         Note: This settings is not supported for the 'yolov5' algorithm.
        :paramtype min_size: int
        :keyword model_size: Model size. Must be 'small', 'medium', 'large', or 'xlarge'.
         Note: training run may get into CUDA OOM if the model size is too big.
         Note: This settings is only supported for the 'yolov5' algorithm. Possible values include:
         "None", "Small", "Medium", "Large", "ExtraLarge".
        :paramtype model_size: str or ~azure.mgmt.machinelearningservices.models.ModelSize
        :keyword multi_scale: Enable multi-scale image by varying image size by +/- 50%.
         Note: training run may get into CUDA OOM if no sufficient GPU memory.
         Note: This settings is only supported for the 'yolov5' algorithm.
        :paramtype multi_scale: bool
        :keyword nms_iou_threshold: IOU threshold used during inference in NMS post processing. Must be
         a float in the range [0, 1].
        :paramtype nms_iou_threshold: float
        :keyword tile_grid_size: The grid size to use for tiling each image. Note: TileGridSize must
         not be
         None to enable small object detection logic. A string containing two integers in mxn format.
         Note: This settings is not supported for the 'yolov5' algorithm.
        :paramtype tile_grid_size: str
        :keyword tile_overlap_ratio: Overlap ratio between adjacent tiles in each dimension. Must be
         float in the range [0, 1).
         Note: This settings is not supported for the 'yolov5' algorithm.
        :paramtype tile_overlap_ratio: float
        :keyword tile_predictions_nms_threshold: The IOU threshold to use to perform NMS while merging
         predictions from tiles and image.
         Used in validation/ inference. Must be float in the range [0, 1].
         Note: This settings is not supported for the 'yolov5' algorithm.
        :paramtype tile_predictions_nms_threshold: float
        :keyword validation_iou_threshold: IOU threshold to use when computing validation metric. Must
         be float in the range [0, 1].
        :paramtype validation_iou_threshold: float
        :keyword validation_metric_type: Metric computation method to use for validation metrics.
         Possible values include: "None", "Coco", "Voc", "CocoVoc".
        :paramtype validation_metric_type: str or
         ~azure.mgmt.machinelearningservices.models.ValidationMetricType
        """
        super(ImageModelSettingsObjectDetection, self).__init__(advanced_settings=advanced_settings, ams_gradient=ams_gradient, augmentations=augmentations, beta1=beta1, beta2=beta2, checkpoint_frequency=checkpoint_frequency, checkpoint_model=checkpoint_model, checkpoint_run_id=checkpoint_run_id, distributed=distributed, early_stopping=early_stopping, early_stopping_delay=early_stopping_delay, early_stopping_patience=early_stopping_patience, enable_onnx_normalization=enable_onnx_normalization, evaluation_frequency=evaluation_frequency, gradient_accumulation_step=gradient_accumulation_step, layers_to_freeze=layers_to_freeze, learning_rate=learning_rate, learning_rate_scheduler=learning_rate_scheduler, model_name=model_name, momentum=momentum, nesterov=nesterov, number_of_epochs=number_of_epochs, number_of_workers=number_of_workers, optimizer=optimizer, random_seed=random_seed, step_lr_gamma=step_lr_gamma, step_lr_step_size=step_lr_step_size, training_batch_size=training_batch_size, validation_batch_size=validation_batch_size, warmup_cosine_lr_cycles=warmup_cosine_lr_cycles, warmup_cosine_lr_warmup_epochs=warmup_cosine_lr_warmup_epochs, weight_decay=weight_decay, **kwargs)
        self.box_detections_per_image = box_detections_per_image
        self.box_score_threshold = box_score_threshold
        self.image_size = image_size
        self.max_size = max_size
        self.min_size = min_size
        self.model_size = model_size
        self.multi_scale = multi_scale
        self.nms_iou_threshold = nms_iou_threshold
        self.tile_grid_size = tile_grid_size
        self.tile_overlap_ratio = tile_overlap_ratio
        self.tile_predictions_nms_threshold = tile_predictions_nms_threshold
        self.validation_iou_threshold = validation_iou_threshold
        self.validation_metric_type = validation_metric_type


class ImageObjectDetection(AutoMLVertical, ImageObjectDetectionBase):
    """Image Object Detection. Object detection is used to identify objects in an image and locate each object with a
bounding box e.g. locate all dogs and cats in an image and draw a bounding box around each.

    All required parameters must be populated in order to send to Azure.

    :ivar limit_settings: Required. [Required] Limit settings for the AutoML job.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
    :ivar sweep_settings: Model sweeping and hyperparameter sweeping related settings.
    :vartype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
    :ivar validation_data: Validation data inputs.
    :vartype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar validation_data_size: The fraction of training dataset that needs to be set aside for
     validation purpose.
     Values between (0.0 , 1.0)
     Applied when validation dataset is not provided.
    :vartype validation_data_size: float
    :ivar model_settings: Settings used for training the model.
    :vartype model_settings:
     ~azure.mgmt.machinelearningservices.models.ImageModelSettingsObjectDetection
    :ivar search_space: Search space for sampling different combinations of models and their
     hyperparameters.
    :vartype search_space:
     list[~azure.mgmt.machinelearningservices.models.ImageModelDistributionSettingsObjectDetection]
    :ivar log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
     "Info", "Warning", "Error", "Critical".
    :vartype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
    :ivar target_column_name: Target column name: This is prediction values column.
     Also known as label column name in context of classification tasks.
    :vartype target_column_name: str
    :ivar task_type: Required. [Required] Task type for AutoMLJob.Constant filled by server.
     Possible values include: "Classification", "Regression", "Forecasting", "ImageClassification",
     "ImageClassificationMultilabel", "ImageObjectDetection", "ImageInstanceSegmentation",
     "TextClassification", "TextClassificationMultilabel", "TextNER".
    :vartype task_type: str or ~azure.mgmt.machinelearningservices.models.TaskType
    :ivar training_data: Required. [Required] Training data input.
    :vartype training_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar primary_metric: Primary metric to optimize for this task. Possible values include:
     "MeanAveragePrecision".
    :vartype primary_metric: str or
     ~azure.mgmt.machinelearningservices.models.ObjectDetectionPrimaryMetrics
    """

    _validation = {
        'limit_settings': {'required': True},
        'task_type': {'required': True},
        'training_data': {'required': True},
    }

    _attribute_map = {
        'limit_settings': {'key': 'limitSettings', 'type': 'ImageLimitSettings'},
        'sweep_settings': {'key': 'sweepSettings', 'type': 'ImageSweepSettings'},
        'validation_data': {'key': 'validationData', 'type': 'MLTableJobInput'},
        'validation_data_size': {'key': 'validationDataSize', 'type': 'float'},
        'model_settings': {'key': 'modelSettings', 'type': 'ImageModelSettingsObjectDetection'},
        'search_space': {'key': 'searchSpace', 'type': '[ImageModelDistributionSettingsObjectDetection]'},
        'log_verbosity': {'key': 'logVerbosity', 'type': 'str'},
        'target_column_name': {'key': 'targetColumnName', 'type': 'str'},
        'task_type': {'key': 'taskType', 'type': 'str'},
        'training_data': {'key': 'trainingData', 'type': 'MLTableJobInput'},
        'primary_metric': {'key': 'primaryMetric', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        limit_settings: "ImageLimitSettings",
        training_data: "MLTableJobInput",
        sweep_settings: Optional["ImageSweepSettings"] = None,
        validation_data: Optional["MLTableJobInput"] = None,
        validation_data_size: Optional[float] = None,
        model_settings: Optional["ImageModelSettingsObjectDetection"] = None,
        search_space: Optional[List["ImageModelDistributionSettingsObjectDetection"]] = None,
        log_verbosity: Optional[Union[str, "LogVerbosity"]] = None,
        target_column_name: Optional[str] = None,
        primary_metric: Optional[Union[str, "ObjectDetectionPrimaryMetrics"]] = None,
        **kwargs
    ):
        """
        :keyword limit_settings: Required. [Required] Limit settings for the AutoML job.
        :paramtype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
        :keyword sweep_settings: Model sweeping and hyperparameter sweeping related settings.
        :paramtype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
        :keyword validation_data: Validation data inputs.
        :paramtype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword validation_data_size: The fraction of training dataset that needs to be set aside for
         validation purpose.
         Values between (0.0 , 1.0)
         Applied when validation dataset is not provided.
        :paramtype validation_data_size: float
        :keyword model_settings: Settings used for training the model.
        :paramtype model_settings:
         ~azure.mgmt.machinelearningservices.models.ImageModelSettingsObjectDetection
        :keyword search_space: Search space for sampling different combinations of models and their
         hyperparameters.
        :paramtype search_space:
         list[~azure.mgmt.machinelearningservices.models.ImageModelDistributionSettingsObjectDetection]
        :keyword log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
         "Info", "Warning", "Error", "Critical".
        :paramtype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
        :keyword target_column_name: Target column name: This is prediction values column.
         Also known as label column name in context of classification tasks.
        :paramtype target_column_name: str
        :keyword training_data: Required. [Required] Training data input.
        :paramtype training_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword primary_metric: Primary metric to optimize for this task. Possible values include:
         "MeanAveragePrecision".
        :paramtype primary_metric: str or
         ~azure.mgmt.machinelearningservices.models.ObjectDetectionPrimaryMetrics
        """
        super(ImageObjectDetection, self).__init__(log_verbosity=log_verbosity, target_column_name=target_column_name, training_data=training_data, limit_settings=limit_settings, sweep_settings=sweep_settings, validation_data=validation_data, validation_data_size=validation_data_size, model_settings=model_settings, search_space=search_space, **kwargs)
        self.limit_settings = limit_settings
        self.sweep_settings = sweep_settings
        self.validation_data = validation_data
        self.validation_data_size = validation_data_size
        self.model_settings = model_settings
        self.search_space = search_space
        self.task_type = 'ImageObjectDetection'  # type: str
        self.primary_metric = primary_metric
        self.log_verbosity = log_verbosity
        self.target_column_name = target_column_name
        self.training_data = training_data


class ImageSweepSettings(msrest.serialization.Model):
    """Model sweeping and hyperparameter sweeping related settings.

    All required parameters must be populated in order to send to Azure.

    :ivar early_termination: Type of early termination policy.
    :vartype early_termination: ~azure.mgmt.machinelearningservices.models.EarlyTerminationPolicy
    :ivar sampling_algorithm: Required. [Required] Type of the hyperparameter sampling algorithms.
     Possible values include: "Grid", "Random", "Bayesian".
    :vartype sampling_algorithm: str or
     ~azure.mgmt.machinelearningservices.models.SamplingAlgorithmType
    """

    _validation = {
        'sampling_algorithm': {'required': True},
    }

    _attribute_map = {
        'early_termination': {'key': 'earlyTermination', 'type': 'EarlyTerminationPolicy'},
        'sampling_algorithm': {'key': 'samplingAlgorithm', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        sampling_algorithm: Union[str, "SamplingAlgorithmType"],
        early_termination: Optional["EarlyTerminationPolicy"] = None,
        **kwargs
    ):
        """
        :keyword early_termination: Type of early termination policy.
        :paramtype early_termination: ~azure.mgmt.machinelearningservices.models.EarlyTerminationPolicy
        :keyword sampling_algorithm: Required. [Required] Type of the hyperparameter sampling
         algorithms. Possible values include: "Grid", "Random", "Bayesian".
        :paramtype sampling_algorithm: str or
         ~azure.mgmt.machinelearningservices.models.SamplingAlgorithmType
        """
        super(ImageSweepSettings, self).__init__(**kwargs)
        self.early_termination = early_termination
        self.sampling_algorithm = sampling_algorithm


class InferenceContainerProperties(msrest.serialization.Model):
    """InferenceContainerProperties.

    :ivar liveness_route: The route to check the liveness of the inference server container.
    :vartype liveness_route: ~azure.mgmt.machinelearningservices.models.Route
    :ivar readiness_route: The route to check the readiness of the inference server container.
    :vartype readiness_route: ~azure.mgmt.machinelearningservices.models.Route
    :ivar scoring_route: The port to send the scoring requests to, within the inference server
     container.
    :vartype scoring_route: ~azure.mgmt.machinelearningservices.models.Route
    """

    _attribute_map = {
        'liveness_route': {'key': 'livenessRoute', 'type': 'Route'},
        'readiness_route': {'key': 'readinessRoute', 'type': 'Route'},
        'scoring_route': {'key': 'scoringRoute', 'type': 'Route'},
    }

    def __init__(
        self,
        *,
        liveness_route: Optional["Route"] = None,
        readiness_route: Optional["Route"] = None,
        scoring_route: Optional["Route"] = None,
        **kwargs
    ):
        """
        :keyword liveness_route: The route to check the liveness of the inference server container.
        :paramtype liveness_route: ~azure.mgmt.machinelearningservices.models.Route
        :keyword readiness_route: The route to check the readiness of the inference server container.
        :paramtype readiness_route: ~azure.mgmt.machinelearningservices.models.Route
        :keyword scoring_route: The port to send the scoring requests to, within the inference server
         container.
        :paramtype scoring_route: ~azure.mgmt.machinelearningservices.models.Route
        """
        super(InferenceContainerProperties, self).__init__(**kwargs)
        self.liveness_route = liveness_route
        self.readiness_route = readiness_route
        self.scoring_route = scoring_route


class InstanceTypeSchema(msrest.serialization.Model):
    """Instance type schema.

    :ivar node_selector: Node Selector.
    :vartype node_selector: dict[str, str]
    :ivar resources: Resource requests/limits for this instance type.
    :vartype resources: ~azure.mgmt.machinelearningservices.models.InstanceTypeSchemaResources
    """

    _attribute_map = {
        'node_selector': {'key': 'nodeSelector', 'type': '{str}'},
        'resources': {'key': 'resources', 'type': 'InstanceTypeSchemaResources'},
    }

    def __init__(
        self,
        *,
        node_selector: Optional[Dict[str, str]] = None,
        resources: Optional["InstanceTypeSchemaResources"] = None,
        **kwargs
    ):
        """
        :keyword node_selector: Node Selector.
        :paramtype node_selector: dict[str, str]
        :keyword resources: Resource requests/limits for this instance type.
        :paramtype resources: ~azure.mgmt.machinelearningservices.models.InstanceTypeSchemaResources
        """
        super(InstanceTypeSchema, self).__init__(**kwargs)
        self.node_selector = node_selector
        self.resources = resources


class InstanceTypeSchemaResources(msrest.serialization.Model):
    """Resource requests/limits for this instance type.

    :ivar requests: Resource requests for this instance type.
    :vartype requests: dict[str, str]
    :ivar limits: Resource limits for this instance type.
    :vartype limits: dict[str, str]
    """

    _attribute_map = {
        'requests': {'key': 'requests', 'type': '{str}'},
        'limits': {'key': 'limits', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        requests: Optional[Dict[str, str]] = None,
        limits: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword requests: Resource requests for this instance type.
        :paramtype requests: dict[str, str]
        :keyword limits: Resource limits for this instance type.
        :paramtype limits: dict[str, str]
        """
        super(InstanceTypeSchemaResources, self).__init__(**kwargs)
        self.requests = requests
        self.limits = limits


class JobBase(Resource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.JobBaseProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'JobBaseProperties'},
    }

    def __init__(
        self,
        *,
        properties: "JobBaseProperties",
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.JobBaseProperties
        """
        super(JobBase, self).__init__(**kwargs)
        self.properties = properties


class JobBaseResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of JobBase entities.

    :ivar next_link: The link to the next page of JobBase objects. If null, there are no additional
     pages.
    :vartype next_link: str
    :ivar value: An array of objects of type JobBase.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.JobBase]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[JobBase]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["JobBase"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of JobBase objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type JobBase.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.JobBase]
        """
        super(JobBaseResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class JobResourceConfiguration(ResourceConfiguration):
    """JobResourceConfiguration.

    :ivar instance_count: Optional number of instances or nodes used by the compute target.
    :vartype instance_count: int
    :ivar instance_type: Optional type of VM used as supported by the compute target.
    :vartype instance_type: str
    :ivar properties: Additional properties bag.
    :vartype properties: dict[str, any]
    :ivar docker_args: Extra arguments to pass to the Docker run command. This would override any
     parameters that have already been set by the system, or in this section. This parameter is only
     supported for Azure ML compute types.
    :vartype docker_args: str
    :ivar shm_size: Size of the docker container's shared memory block. This should be in the
     format of (number)(unit) where number as to be greater than 0 and the unit can be one of
     b(bytes), k(kilobytes), m(megabytes), or g(gigabytes).
    :vartype shm_size: str
    """

    _validation = {
        'shm_size': {'pattern': r'\d+[bBkKmMgG]'},
    }

    _attribute_map = {
        'instance_count': {'key': 'instanceCount', 'type': 'int'},
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{object}'},
        'docker_args': {'key': 'dockerArgs', 'type': 'str'},
        'shm_size': {'key': 'shmSize', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        instance_count: Optional[int] = 1,
        instance_type: Optional[str] = None,
        properties: Optional[Dict[str, Any]] = None,
        docker_args: Optional[str] = None,
        shm_size: Optional[str] = "2g",
        **kwargs
    ):
        """
        :keyword instance_count: Optional number of instances or nodes used by the compute target.
        :paramtype instance_count: int
        :keyword instance_type: Optional type of VM used as supported by the compute target.
        :paramtype instance_type: str
        :keyword properties: Additional properties bag.
        :paramtype properties: dict[str, any]
        :keyword docker_args: Extra arguments to pass to the Docker run command. This would override
         any parameters that have already been set by the system, or in this section. This parameter is
         only supported for Azure ML compute types.
        :paramtype docker_args: str
        :keyword shm_size: Size of the docker container's shared memory block. This should be in the
         format of (number)(unit) where number as to be greater than 0 and the unit can be one of
         b(bytes), k(kilobytes), m(megabytes), or g(gigabytes).
        :paramtype shm_size: str
        """
        super(JobResourceConfiguration, self).__init__(instance_count=instance_count, instance_type=instance_type, properties=properties, **kwargs)
        self.docker_args = docker_args
        self.shm_size = shm_size


class JobScheduleAction(ScheduleActionBase):
    """JobScheduleAction.

    All required parameters must be populated in order to send to Azure.

    :ivar action_type: Required. [Required] Specifies the action type of the schedule.Constant
     filled by server. Possible values include: "CreateJob", "InvokeBatchEndpoint".
    :vartype action_type: str or ~azure.mgmt.machinelearningservices.models.ScheduleActionType
    :ivar job_definition: Required. [Required] Defines Schedule action definition details.
    :vartype job_definition: ~azure.mgmt.machinelearningservices.models.JobBaseProperties
    """

    _validation = {
        'action_type': {'required': True},
        'job_definition': {'required': True},
    }

    _attribute_map = {
        'action_type': {'key': 'actionType', 'type': 'str'},
        'job_definition': {'key': 'jobDefinition', 'type': 'JobBaseProperties'},
    }

    def __init__(
        self,
        *,
        job_definition: "JobBaseProperties",
        **kwargs
    ):
        """
        :keyword job_definition: Required. [Required] Defines Schedule action definition details.
        :paramtype job_definition: ~azure.mgmt.machinelearningservices.models.JobBaseProperties
        """
        super(JobScheduleAction, self).__init__(**kwargs)
        self.action_type = 'CreateJob'  # type: str
        self.job_definition = job_definition


class JobService(msrest.serialization.Model):
    """Job endpoint definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar endpoint: Url for endpoint.
    :vartype endpoint: str
    :ivar error_message: Any error in the service.
    :vartype error_message: str
    :ivar job_service_type: Endpoint type.
    :vartype job_service_type: str
    :ivar nodes: Nodes that user would like to start the service on.
     If Nodes is not set or set to null, the service will only be started on leader node.
    :vartype nodes: ~azure.mgmt.machinelearningservices.models.Nodes
    :ivar port: Port for endpoint set by user.
    :vartype port: int
    :ivar properties: Additional properties to set on the endpoint.
    :vartype properties: dict[str, str]
    :ivar status: Status of endpoint.
    :vartype status: str
    """

    _validation = {
        'error_message': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'endpoint': {'key': 'endpoint', 'type': 'str'},
        'error_message': {'key': 'errorMessage', 'type': 'str'},
        'job_service_type': {'key': 'jobServiceType', 'type': 'str'},
        'nodes': {'key': 'nodes', 'type': 'Nodes'},
        'port': {'key': 'port', 'type': 'int'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        endpoint: Optional[str] = None,
        job_service_type: Optional[str] = None,
        nodes: Optional["Nodes"] = None,
        port: Optional[int] = None,
        properties: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword endpoint: Url for endpoint.
        :paramtype endpoint: str
        :keyword job_service_type: Endpoint type.
        :paramtype job_service_type: str
        :keyword nodes: Nodes that user would like to start the service on.
         If Nodes is not set or set to null, the service will only be started on leader node.
        :paramtype nodes: ~azure.mgmt.machinelearningservices.models.Nodes
        :keyword port: Port for endpoint set by user.
        :paramtype port: int
        :keyword properties: Additional properties to set on the endpoint.
        :paramtype properties: dict[str, str]
        """
        super(JobService, self).__init__(**kwargs)
        self.endpoint = endpoint
        self.error_message = None
        self.job_service_type = job_service_type
        self.nodes = nodes
        self.port = port
        self.properties = properties
        self.status = None


class KerberosCredentials(msrest.serialization.Model):
    """KerberosCredentials.

    All required parameters must be populated in order to send to Azure.

    :ivar kerberos_kdc_address: Required. [Required] IP Address or DNS HostName.
    :vartype kerberos_kdc_address: str
    :ivar kerberos_principal: Required. [Required] Kerberos Username.
    :vartype kerberos_principal: str
    :ivar kerberos_realm: Required. [Required] Domain over which a Kerberos authentication server
     has the authority to authenticate a user, host or service.
    :vartype kerberos_realm: str
    """

    _validation = {
        'kerberos_kdc_address': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'kerberos_principal': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'kerberos_realm': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'kerberos_kdc_address': {'key': 'kerberosKdcAddress', 'type': 'str'},
        'kerberos_principal': {'key': 'kerberosPrincipal', 'type': 'str'},
        'kerberos_realm': {'key': 'kerberosRealm', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kerberos_kdc_address: str,
        kerberos_principal: str,
        kerberos_realm: str,
        **kwargs
    ):
        """
        :keyword kerberos_kdc_address: Required. [Required] IP Address or DNS HostName.
        :paramtype kerberos_kdc_address: str
        :keyword kerberos_principal: Required. [Required] Kerberos Username.
        :paramtype kerberos_principal: str
        :keyword kerberos_realm: Required. [Required] Domain over which a Kerberos authentication
         server has the authority to authenticate a user, host or service.
        :paramtype kerberos_realm: str
        """
        super(KerberosCredentials, self).__init__(**kwargs)
        self.kerberos_kdc_address = kerberos_kdc_address
        self.kerberos_principal = kerberos_principal
        self.kerberos_realm = kerberos_realm


class KerberosKeytabCredentials(DatastoreCredentials, KerberosCredentials):
    """KerberosKeytabCredentials.

    All required parameters must be populated in order to send to Azure.

    :ivar kerberos_kdc_address: Required. [Required] IP Address or DNS HostName.
    :vartype kerberos_kdc_address: str
    :ivar kerberos_principal: Required. [Required] Kerberos Username.
    :vartype kerberos_principal: str
    :ivar kerberos_realm: Required. [Required] Domain over which a Kerberos authentication server
     has the authority to authenticate a user, host or service.
    :vartype kerberos_realm: str
    :ivar credentials_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "AccountKey", "Certificate",
     "None", "Sas", "ServicePrincipal", "KerberosKeytab", "KerberosPassword".
    :vartype credentials_type: str or ~azure.mgmt.machinelearningservices.models.CredentialsType
    :ivar secrets: Required. [Required] Keytab secrets.
    :vartype secrets: ~azure.mgmt.machinelearningservices.models.KerberosKeytabSecrets
    """

    _validation = {
        'kerberos_kdc_address': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'kerberos_principal': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'kerberos_realm': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'credentials_type': {'required': True},
        'secrets': {'required': True},
    }

    _attribute_map = {
        'kerberos_kdc_address': {'key': 'kerberosKdcAddress', 'type': 'str'},
        'kerberos_principal': {'key': 'kerberosPrincipal', 'type': 'str'},
        'kerberos_realm': {'key': 'kerberosRealm', 'type': 'str'},
        'credentials_type': {'key': 'credentialsType', 'type': 'str'},
        'secrets': {'key': 'secrets', 'type': 'KerberosKeytabSecrets'},
    }

    def __init__(
        self,
        *,
        kerberos_kdc_address: str,
        kerberos_principal: str,
        kerberos_realm: str,
        secrets: "KerberosKeytabSecrets",
        **kwargs
    ):
        """
        :keyword kerberos_kdc_address: Required. [Required] IP Address or DNS HostName.
        :paramtype kerberos_kdc_address: str
        :keyword kerberos_principal: Required. [Required] Kerberos Username.
        :paramtype kerberos_principal: str
        :keyword kerberos_realm: Required. [Required] Domain over which a Kerberos authentication
         server has the authority to authenticate a user, host or service.
        :paramtype kerberos_realm: str
        :keyword secrets: Required. [Required] Keytab secrets.
        :paramtype secrets: ~azure.mgmt.machinelearningservices.models.KerberosKeytabSecrets
        """
        super(KerberosKeytabCredentials, self).__init__(kerberos_kdc_address=kerberos_kdc_address, kerberos_principal=kerberos_principal, kerberos_realm=kerberos_realm, **kwargs)
        self.kerberos_kdc_address = kerberos_kdc_address
        self.kerberos_principal = kerberos_principal
        self.kerberos_realm = kerberos_realm
        self.credentials_type = 'KerberosKeytab'  # type: str
        self.secrets = secrets


class KerberosKeytabSecrets(DatastoreSecrets):
    """KerberosKeytabSecrets.

    All required parameters must be populated in order to send to Azure.

    :ivar secrets_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "AccountKey", "Certificate", "Sas",
     "ServicePrincipal", "KerberosPassword", "KerberosKeytab".
    :vartype secrets_type: str or ~azure.mgmt.machinelearningservices.models.SecretsType
    :ivar kerberos_keytab: Kerberos keytab secret.
    :vartype kerberos_keytab: str
    """

    _validation = {
        'secrets_type': {'required': True},
    }

    _attribute_map = {
        'secrets_type': {'key': 'secretsType', 'type': 'str'},
        'kerberos_keytab': {'key': 'kerberosKeytab', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kerberos_keytab: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kerberos_keytab: Kerberos keytab secret.
        :paramtype kerberos_keytab: str
        """
        super(KerberosKeytabSecrets, self).__init__(**kwargs)
        self.secrets_type = 'KerberosKeytab'  # type: str
        self.kerberos_keytab = kerberos_keytab


class KerberosPasswordCredentials(DatastoreCredentials, KerberosCredentials):
    """KerberosPasswordCredentials.

    All required parameters must be populated in order to send to Azure.

    :ivar kerberos_kdc_address: Required. [Required] IP Address or DNS HostName.
    :vartype kerberos_kdc_address: str
    :ivar kerberos_principal: Required. [Required] Kerberos Username.
    :vartype kerberos_principal: str
    :ivar kerberos_realm: Required. [Required] Domain over which a Kerberos authentication server
     has the authority to authenticate a user, host or service.
    :vartype kerberos_realm: str
    :ivar credentials_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "AccountKey", "Certificate",
     "None", "Sas", "ServicePrincipal", "KerberosKeytab", "KerberosPassword".
    :vartype credentials_type: str or ~azure.mgmt.machinelearningservices.models.CredentialsType
    :ivar secrets: Required. [Required] Kerberos password secrets.
    :vartype secrets: ~azure.mgmt.machinelearningservices.models.KerberosPasswordSecrets
    """

    _validation = {
        'kerberos_kdc_address': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'kerberos_principal': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'kerberos_realm': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'credentials_type': {'required': True},
        'secrets': {'required': True},
    }

    _attribute_map = {
        'kerberos_kdc_address': {'key': 'kerberosKdcAddress', 'type': 'str'},
        'kerberos_principal': {'key': 'kerberosPrincipal', 'type': 'str'},
        'kerberos_realm': {'key': 'kerberosRealm', 'type': 'str'},
        'credentials_type': {'key': 'credentialsType', 'type': 'str'},
        'secrets': {'key': 'secrets', 'type': 'KerberosPasswordSecrets'},
    }

    def __init__(
        self,
        *,
        kerberos_kdc_address: str,
        kerberos_principal: str,
        kerberos_realm: str,
        secrets: "KerberosPasswordSecrets",
        **kwargs
    ):
        """
        :keyword kerberos_kdc_address: Required. [Required] IP Address or DNS HostName.
        :paramtype kerberos_kdc_address: str
        :keyword kerberos_principal: Required. [Required] Kerberos Username.
        :paramtype kerberos_principal: str
        :keyword kerberos_realm: Required. [Required] Domain over which a Kerberos authentication
         server has the authority to authenticate a user, host or service.
        :paramtype kerberos_realm: str
        :keyword secrets: Required. [Required] Kerberos password secrets.
        :paramtype secrets: ~azure.mgmt.machinelearningservices.models.KerberosPasswordSecrets
        """
        super(KerberosPasswordCredentials, self).__init__(kerberos_kdc_address=kerberos_kdc_address, kerberos_principal=kerberos_principal, kerberos_realm=kerberos_realm, **kwargs)
        self.kerberos_kdc_address = kerberos_kdc_address
        self.kerberos_principal = kerberos_principal
        self.kerberos_realm = kerberos_realm
        self.credentials_type = 'KerberosPassword'  # type: str
        self.secrets = secrets


class KerberosPasswordSecrets(DatastoreSecrets):
    """KerberosPasswordSecrets.

    All required parameters must be populated in order to send to Azure.

    :ivar secrets_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "AccountKey", "Certificate", "Sas",
     "ServicePrincipal", "KerberosPassword", "KerberosKeytab".
    :vartype secrets_type: str or ~azure.mgmt.machinelearningservices.models.SecretsType
    :ivar kerberos_password: Kerberos password secret.
    :vartype kerberos_password: str
    """

    _validation = {
        'secrets_type': {'required': True},
    }

    _attribute_map = {
        'secrets_type': {'key': 'secretsType', 'type': 'str'},
        'kerberos_password': {'key': 'kerberosPassword', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kerberos_password: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kerberos_password: Kerberos password secret.
        :paramtype kerberos_password: str
        """
        super(KerberosPasswordSecrets, self).__init__(**kwargs)
        self.secrets_type = 'KerberosPassword'  # type: str
        self.kerberos_password = kerberos_password


class KubernetesSchema(msrest.serialization.Model):
    """Kubernetes Compute Schema.

    :ivar properties: Properties of Kubernetes.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.KubernetesProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'KubernetesProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["KubernetesProperties"] = None,
        **kwargs
    ):
        """
        :keyword properties: Properties of Kubernetes.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.KubernetesProperties
        """
        super(KubernetesSchema, self).__init__(**kwargs)
        self.properties = properties


class Kubernetes(Compute, KubernetesSchema):
    """A Machine Learning compute based on Kubernetes Compute.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar properties: Properties of Kubernetes.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.KubernetesProperties
    :ivar compute_type: Required. The type of compute.Constant filled by server. Possible values
     include: "AKS", "Kubernetes", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine",
     "HDInsight", "Databricks", "DataLakeAnalytics", "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :ivar compute_location: Location for the underlying compute.
    :vartype compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values are Unknown,
     Updating, Provisioning, Succeeded, and Failed. Possible values include: "Unknown", "Updating",
     "Creating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ComputeProvisioningState
    :ivar description: The description of the Machine Learning compute.
    :vartype description: str
    :ivar created_on: The time at which the compute was created.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: The time at which the compute was last modified.
    :vartype modified_on: ~datetime.datetime
    :ivar resource_id: ARM resource id of the underlying compute.
    :vartype resource_id: str
    :ivar provisioning_errors: Errors during provisioning.
    :vartype provisioning_errors: list[~azure.mgmt.machinelearningservices.models.ErrorResponse]
    :ivar is_attached_compute: Indicating whether the compute was provisioned by user and brought
     from outside if true, or machine learning service provisioned it if false.
    :vartype is_attached_compute: bool
    :ivar disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI
     and AAD exclusively for authentication.
    :vartype disable_local_auth: bool
    """

    _validation = {
        'compute_type': {'required': True},
        'compute_location': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'modified_on': {'readonly': True},
        'provisioning_errors': {'readonly': True},
        'is_attached_compute': {'readonly': True},
        'disable_local_auth': {'readonly': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'KubernetesProperties'},
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'compute_location': {'key': 'computeLocation', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'modified_on': {'key': 'modifiedOn', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'provisioning_errors': {'key': 'provisioningErrors', 'type': '[ErrorResponse]'},
        'is_attached_compute': {'key': 'isAttachedCompute', 'type': 'bool'},
        'disable_local_auth': {'key': 'disableLocalAuth', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        properties: Optional["KubernetesProperties"] = None,
        description: Optional[str] = None,
        resource_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword properties: Properties of Kubernetes.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.KubernetesProperties
        :keyword description: The description of the Machine Learning compute.
        :paramtype description: str
        :keyword resource_id: ARM resource id of the underlying compute.
        :paramtype resource_id: str
        """
        super(Kubernetes, self).__init__(description=description, resource_id=resource_id, properties=properties, **kwargs)
        self.properties = properties
        self.compute_type = 'Kubernetes'  # type: str
        self.compute_location = None
        self.provisioning_state = None
        self.description = description
        self.created_on = None
        self.modified_on = None
        self.resource_id = resource_id
        self.provisioning_errors = None
        self.is_attached_compute = None
        self.disable_local_auth = None


class OnlineDeploymentProperties(EndpointDeploymentPropertiesBase):
    """OnlineDeploymentProperties.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: KubernetesOnlineDeployment, ManagedOnlineDeployment.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar code_configuration: Code configuration for the endpoint deployment.
    :vartype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
    :ivar description: Description of the endpoint deployment.
    :vartype description: str
    :ivar environment_id: ARM resource ID of the environment specification for the endpoint
     deployment.
    :vartype environment_id: str
    :ivar environment_variables: Environment variables configuration for the deployment.
    :vartype environment_variables: dict[str, str]
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar app_insights_enabled: If true, enables Application Insights logging.
    :vartype app_insights_enabled: bool
    :ivar egress_public_network_access: If Enabled, allow egress public network access. If
     Disabled, this will create secure egress. Default: Enabled. Possible values include: "Enabled",
     "Disabled".
    :vartype egress_public_network_access: str or
     ~azure.mgmt.machinelearningservices.models.EgressPublicNetworkAccessType
    :ivar endpoint_compute_type: Required. [Required] The compute type of the endpoint.Constant
     filled by server. Possible values include: "Managed", "Kubernetes", "AzureMLCompute".
    :vartype endpoint_compute_type: str or
     ~azure.mgmt.machinelearningservices.models.EndpointComputeType
    :ivar instance_type: Compute instance type.
    :vartype instance_type: str
    :ivar liveness_probe: Liveness probe monitors the health of the container regularly.
    :vartype liveness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
    :ivar model: The URI path to the model.
    :vartype model: str
    :ivar model_mount_path: The path to mount the model in custom container.
    :vartype model_mount_path: str
    :ivar provisioning_state: Provisioning state for the endpoint deployment. Possible values
     include: "Creating", "Deleting", "Scaling", "Updating", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.DeploymentProvisioningState
    :ivar readiness_probe: Readiness probe validates if the container is ready to serve traffic.
     The properties and defaults are the same as liveness probe.
    :vartype readiness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
    :ivar request_settings: Request settings for the deployment.
    :vartype request_settings: ~azure.mgmt.machinelearningservices.models.OnlineRequestSettings
    :ivar scale_settings: Scale settings for the deployment.
     If it is null or not provided,
     it defaults to TargetUtilizationScaleSettings for KubernetesOnlineDeployment
     and to DefaultScaleSettings for ManagedOnlineDeployment.
    :vartype scale_settings: ~azure.mgmt.machinelearningservices.models.OnlineScaleSettings
    """

    _validation = {
        'endpoint_compute_type': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'code_configuration': {'key': 'codeConfiguration', 'type': 'CodeConfiguration'},
        'description': {'key': 'description', 'type': 'str'},
        'environment_id': {'key': 'environmentId', 'type': 'str'},
        'environment_variables': {'key': 'environmentVariables', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'app_insights_enabled': {'key': 'appInsightsEnabled', 'type': 'bool'},
        'egress_public_network_access': {'key': 'egressPublicNetworkAccess', 'type': 'str'},
        'endpoint_compute_type': {'key': 'endpointComputeType', 'type': 'str'},
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'liveness_probe': {'key': 'livenessProbe', 'type': 'ProbeSettings'},
        'model': {'key': 'model', 'type': 'str'},
        'model_mount_path': {'key': 'modelMountPath', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'readiness_probe': {'key': 'readinessProbe', 'type': 'ProbeSettings'},
        'request_settings': {'key': 'requestSettings', 'type': 'OnlineRequestSettings'},
        'scale_settings': {'key': 'scaleSettings', 'type': 'OnlineScaleSettings'},
    }

    _subtype_map = {
        'endpoint_compute_type': {'Kubernetes': 'KubernetesOnlineDeployment', 'Managed': 'ManagedOnlineDeployment'}
    }

    def __init__(
        self,
        *,
        code_configuration: Optional["CodeConfiguration"] = None,
        description: Optional[str] = None,
        environment_id: Optional[str] = None,
        environment_variables: Optional[Dict[str, str]] = None,
        properties: Optional[Dict[str, str]] = None,
        app_insights_enabled: Optional[bool] = False,
        egress_public_network_access: Optional[Union[str, "EgressPublicNetworkAccessType"]] = None,
        instance_type: Optional[str] = None,
        liveness_probe: Optional["ProbeSettings"] = None,
        model: Optional[str] = None,
        model_mount_path: Optional[str] = None,
        readiness_probe: Optional["ProbeSettings"] = None,
        request_settings: Optional["OnlineRequestSettings"] = None,
        scale_settings: Optional["OnlineScaleSettings"] = None,
        **kwargs
    ):
        """
        :keyword code_configuration: Code configuration for the endpoint deployment.
        :paramtype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
        :keyword description: Description of the endpoint deployment.
        :paramtype description: str
        :keyword environment_id: ARM resource ID of the environment specification for the endpoint
         deployment.
        :paramtype environment_id: str
        :keyword environment_variables: Environment variables configuration for the deployment.
        :paramtype environment_variables: dict[str, str]
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        :keyword app_insights_enabled: If true, enables Application Insights logging.
        :paramtype app_insights_enabled: bool
        :keyword egress_public_network_access: If Enabled, allow egress public network access. If
         Disabled, this will create secure egress. Default: Enabled. Possible values include: "Enabled",
         "Disabled".
        :paramtype egress_public_network_access: str or
         ~azure.mgmt.machinelearningservices.models.EgressPublicNetworkAccessType
        :keyword instance_type: Compute instance type.
        :paramtype instance_type: str
        :keyword liveness_probe: Liveness probe monitors the health of the container regularly.
        :paramtype liveness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
        :keyword model: The URI path to the model.
        :paramtype model: str
        :keyword model_mount_path: The path to mount the model in custom container.
        :paramtype model_mount_path: str
        :keyword readiness_probe: Readiness probe validates if the container is ready to serve traffic.
         The properties and defaults are the same as liveness probe.
        :paramtype readiness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
        :keyword request_settings: Request settings for the deployment.
        :paramtype request_settings: ~azure.mgmt.machinelearningservices.models.OnlineRequestSettings
        :keyword scale_settings: Scale settings for the deployment.
         If it is null or not provided,
         it defaults to TargetUtilizationScaleSettings for KubernetesOnlineDeployment
         and to DefaultScaleSettings for ManagedOnlineDeployment.
        :paramtype scale_settings: ~azure.mgmt.machinelearningservices.models.OnlineScaleSettings
        """
        super(OnlineDeploymentProperties, self).__init__(code_configuration=code_configuration, description=description, environment_id=environment_id, environment_variables=environment_variables, properties=properties, **kwargs)
        self.app_insights_enabled = app_insights_enabled
        self.egress_public_network_access = egress_public_network_access
        self.endpoint_compute_type = 'OnlineDeploymentProperties'  # type: str
        self.instance_type = instance_type
        self.liveness_probe = liveness_probe
        self.model = model
        self.model_mount_path = model_mount_path
        self.provisioning_state = None
        self.readiness_probe = readiness_probe
        self.request_settings = request_settings
        self.scale_settings = scale_settings


class KubernetesOnlineDeployment(OnlineDeploymentProperties):
    """Properties specific to a KubernetesOnlineDeployment.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar code_configuration: Code configuration for the endpoint deployment.
    :vartype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
    :ivar description: Description of the endpoint deployment.
    :vartype description: str
    :ivar environment_id: ARM resource ID of the environment specification for the endpoint
     deployment.
    :vartype environment_id: str
    :ivar environment_variables: Environment variables configuration for the deployment.
    :vartype environment_variables: dict[str, str]
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar app_insights_enabled: If true, enables Application Insights logging.
    :vartype app_insights_enabled: bool
    :ivar egress_public_network_access: If Enabled, allow egress public network access. If
     Disabled, this will create secure egress. Default: Enabled. Possible values include: "Enabled",
     "Disabled".
    :vartype egress_public_network_access: str or
     ~azure.mgmt.machinelearningservices.models.EgressPublicNetworkAccessType
    :ivar endpoint_compute_type: Required. [Required] The compute type of the endpoint.Constant
     filled by server. Possible values include: "Managed", "Kubernetes", "AzureMLCompute".
    :vartype endpoint_compute_type: str or
     ~azure.mgmt.machinelearningservices.models.EndpointComputeType
    :ivar instance_type: Compute instance type.
    :vartype instance_type: str
    :ivar liveness_probe: Liveness probe monitors the health of the container regularly.
    :vartype liveness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
    :ivar model: The URI path to the model.
    :vartype model: str
    :ivar model_mount_path: The path to mount the model in custom container.
    :vartype model_mount_path: str
    :ivar provisioning_state: Provisioning state for the endpoint deployment. Possible values
     include: "Creating", "Deleting", "Scaling", "Updating", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.DeploymentProvisioningState
    :ivar readiness_probe: Readiness probe validates if the container is ready to serve traffic.
     The properties and defaults are the same as liveness probe.
    :vartype readiness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
    :ivar request_settings: Request settings for the deployment.
    :vartype request_settings: ~azure.mgmt.machinelearningservices.models.OnlineRequestSettings
    :ivar scale_settings: Scale settings for the deployment.
     If it is null or not provided,
     it defaults to TargetUtilizationScaleSettings for KubernetesOnlineDeployment
     and to DefaultScaleSettings for ManagedOnlineDeployment.
    :vartype scale_settings: ~azure.mgmt.machinelearningservices.models.OnlineScaleSettings
    :ivar container_resource_requirements: The resource requirements for the container (cpu and
     memory).
    :vartype container_resource_requirements:
     ~azure.mgmt.machinelearningservices.models.ContainerResourceRequirements
    """

    _validation = {
        'endpoint_compute_type': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'code_configuration': {'key': 'codeConfiguration', 'type': 'CodeConfiguration'},
        'description': {'key': 'description', 'type': 'str'},
        'environment_id': {'key': 'environmentId', 'type': 'str'},
        'environment_variables': {'key': 'environmentVariables', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'app_insights_enabled': {'key': 'appInsightsEnabled', 'type': 'bool'},
        'egress_public_network_access': {'key': 'egressPublicNetworkAccess', 'type': 'str'},
        'endpoint_compute_type': {'key': 'endpointComputeType', 'type': 'str'},
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'liveness_probe': {'key': 'livenessProbe', 'type': 'ProbeSettings'},
        'model': {'key': 'model', 'type': 'str'},
        'model_mount_path': {'key': 'modelMountPath', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'readiness_probe': {'key': 'readinessProbe', 'type': 'ProbeSettings'},
        'request_settings': {'key': 'requestSettings', 'type': 'OnlineRequestSettings'},
        'scale_settings': {'key': 'scaleSettings', 'type': 'OnlineScaleSettings'},
        'container_resource_requirements': {'key': 'containerResourceRequirements', 'type': 'ContainerResourceRequirements'},
    }

    def __init__(
        self,
        *,
        code_configuration: Optional["CodeConfiguration"] = None,
        description: Optional[str] = None,
        environment_id: Optional[str] = None,
        environment_variables: Optional[Dict[str, str]] = None,
        properties: Optional[Dict[str, str]] = None,
        app_insights_enabled: Optional[bool] = False,
        egress_public_network_access: Optional[Union[str, "EgressPublicNetworkAccessType"]] = None,
        instance_type: Optional[str] = None,
        liveness_probe: Optional["ProbeSettings"] = None,
        model: Optional[str] = None,
        model_mount_path: Optional[str] = None,
        readiness_probe: Optional["ProbeSettings"] = None,
        request_settings: Optional["OnlineRequestSettings"] = None,
        scale_settings: Optional["OnlineScaleSettings"] = None,
        container_resource_requirements: Optional["ContainerResourceRequirements"] = None,
        **kwargs
    ):
        """
        :keyword code_configuration: Code configuration for the endpoint deployment.
        :paramtype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
        :keyword description: Description of the endpoint deployment.
        :paramtype description: str
        :keyword environment_id: ARM resource ID of the environment specification for the endpoint
         deployment.
        :paramtype environment_id: str
        :keyword environment_variables: Environment variables configuration for the deployment.
        :paramtype environment_variables: dict[str, str]
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        :keyword app_insights_enabled: If true, enables Application Insights logging.
        :paramtype app_insights_enabled: bool
        :keyword egress_public_network_access: If Enabled, allow egress public network access. If
         Disabled, this will create secure egress. Default: Enabled. Possible values include: "Enabled",
         "Disabled".
        :paramtype egress_public_network_access: str or
         ~azure.mgmt.machinelearningservices.models.EgressPublicNetworkAccessType
        :keyword instance_type: Compute instance type.
        :paramtype instance_type: str
        :keyword liveness_probe: Liveness probe monitors the health of the container regularly.
        :paramtype liveness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
        :keyword model: The URI path to the model.
        :paramtype model: str
        :keyword model_mount_path: The path to mount the model in custom container.
        :paramtype model_mount_path: str
        :keyword readiness_probe: Readiness probe validates if the container is ready to serve traffic.
         The properties and defaults are the same as liveness probe.
        :paramtype readiness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
        :keyword request_settings: Request settings for the deployment.
        :paramtype request_settings: ~azure.mgmt.machinelearningservices.models.OnlineRequestSettings
        :keyword scale_settings: Scale settings for the deployment.
         If it is null or not provided,
         it defaults to TargetUtilizationScaleSettings for KubernetesOnlineDeployment
         and to DefaultScaleSettings for ManagedOnlineDeployment.
        :paramtype scale_settings: ~azure.mgmt.machinelearningservices.models.OnlineScaleSettings
        :keyword container_resource_requirements: The resource requirements for the container (cpu and
         memory).
        :paramtype container_resource_requirements:
         ~azure.mgmt.machinelearningservices.models.ContainerResourceRequirements
        """
        super(KubernetesOnlineDeployment, self).__init__(code_configuration=code_configuration, description=description, environment_id=environment_id, environment_variables=environment_variables, properties=properties, app_insights_enabled=app_insights_enabled, egress_public_network_access=egress_public_network_access, instance_type=instance_type, liveness_probe=liveness_probe, model=model, model_mount_path=model_mount_path, readiness_probe=readiness_probe, request_settings=request_settings, scale_settings=scale_settings, **kwargs)
        self.endpoint_compute_type = 'Kubernetes'  # type: str
        self.container_resource_requirements = container_resource_requirements


class KubernetesProperties(msrest.serialization.Model):
    """Kubernetes properties.

    :ivar relay_connection_string: Relay connection string.
    :vartype relay_connection_string: str
    :ivar service_bus_connection_string: ServiceBus connection string.
    :vartype service_bus_connection_string: str
    :ivar extension_principal_id: Extension principal-id.
    :vartype extension_principal_id: str
    :ivar extension_instance_release_train: Extension instance release train.
    :vartype extension_instance_release_train: str
    :ivar vc_name: VC name.
    :vartype vc_name: str
    :ivar namespace: Compute namespace.
    :vartype namespace: str
    :ivar default_instance_type: Default instance type.
    :vartype default_instance_type: str
    :ivar instance_types: Instance Type Schema.
    :vartype instance_types: dict[str,
     ~azure.mgmt.machinelearningservices.models.InstanceTypeSchema]
    """

    _attribute_map = {
        'relay_connection_string': {'key': 'relayConnectionString', 'type': 'str'},
        'service_bus_connection_string': {'key': 'serviceBusConnectionString', 'type': 'str'},
        'extension_principal_id': {'key': 'extensionPrincipalId', 'type': 'str'},
        'extension_instance_release_train': {'key': 'extensionInstanceReleaseTrain', 'type': 'str'},
        'vc_name': {'key': 'vcName', 'type': 'str'},
        'namespace': {'key': 'namespace', 'type': 'str'},
        'default_instance_type': {'key': 'defaultInstanceType', 'type': 'str'},
        'instance_types': {'key': 'instanceTypes', 'type': '{InstanceTypeSchema}'},
    }

    def __init__(
        self,
        *,
        relay_connection_string: Optional[str] = None,
        service_bus_connection_string: Optional[str] = None,
        extension_principal_id: Optional[str] = None,
        extension_instance_release_train: Optional[str] = None,
        vc_name: Optional[str] = None,
        namespace: Optional[str] = "default",
        default_instance_type: Optional[str] = None,
        instance_types: Optional[Dict[str, "InstanceTypeSchema"]] = None,
        **kwargs
    ):
        """
        :keyword relay_connection_string: Relay connection string.
        :paramtype relay_connection_string: str
        :keyword service_bus_connection_string: ServiceBus connection string.
        :paramtype service_bus_connection_string: str
        :keyword extension_principal_id: Extension principal-id.
        :paramtype extension_principal_id: str
        :keyword extension_instance_release_train: Extension instance release train.
        :paramtype extension_instance_release_train: str
        :keyword vc_name: VC name.
        :paramtype vc_name: str
        :keyword namespace: Compute namespace.
        :paramtype namespace: str
        :keyword default_instance_type: Default instance type.
        :paramtype default_instance_type: str
        :keyword instance_types: Instance Type Schema.
        :paramtype instance_types: dict[str,
         ~azure.mgmt.machinelearningservices.models.InstanceTypeSchema]
        """
        super(KubernetesProperties, self).__init__(**kwargs)
        self.relay_connection_string = relay_connection_string
        self.service_bus_connection_string = service_bus_connection_string
        self.extension_principal_id = extension_principal_id
        self.extension_instance_release_train = extension_instance_release_train
        self.vc_name = vc_name
        self.namespace = namespace
        self.default_instance_type = default_instance_type
        self.instance_types = instance_types


class LabelCategory(msrest.serialization.Model):
    """Label category definition.

    :ivar classes: Dictionary of label classes in this category.
    :vartype classes: dict[str, ~azure.mgmt.machinelearningservices.models.LabelClass]
    :ivar display_name: Display name of the label category.
    :vartype display_name: str
    :ivar multi_select_enabled: Indicates whether it is allowed to select multiple classes in this
     category.
    :vartype multi_select_enabled: bool
    """

    _attribute_map = {
        'classes': {'key': 'classes', 'type': '{LabelClass}'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'multi_select_enabled': {'key': 'multiSelectEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        classes: Optional[Dict[str, "LabelClass"]] = None,
        display_name: Optional[str] = None,
        multi_select_enabled: Optional[bool] = False,
        **kwargs
    ):
        """
        :keyword classes: Dictionary of label classes in this category.
        :paramtype classes: dict[str, ~azure.mgmt.machinelearningservices.models.LabelClass]
        :keyword display_name: Display name of the label category.
        :paramtype display_name: str
        :keyword multi_select_enabled: Indicates whether it is allowed to select multiple classes in
         this category.
        :paramtype multi_select_enabled: bool
        """
        super(LabelCategory, self).__init__(**kwargs)
        self.classes = classes
        self.display_name = display_name
        self.multi_select_enabled = multi_select_enabled


class LabelClass(msrest.serialization.Model):
    """Label class definition.

    :ivar display_name: Display name of the label class.
    :vartype display_name: str
    :ivar subclasses: Dictionary of subclasses of the label class.
    :vartype subclasses: dict[str, ~azure.mgmt.machinelearningservices.models.LabelClass]
    """

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'subclasses': {'key': 'subclasses', 'type': '{LabelClass}'},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        subclasses: Optional[Dict[str, "LabelClass"]] = None,
        **kwargs
    ):
        """
        :keyword display_name: Display name of the label class.
        :paramtype display_name: str
        :keyword subclasses: Dictionary of subclasses of the label class.
        :paramtype subclasses: dict[str, ~azure.mgmt.machinelearningservices.models.LabelClass]
        """
        super(LabelClass, self).__init__(**kwargs)
        self.display_name = display_name
        self.subclasses = subclasses


class LabelingDataConfiguration(msrest.serialization.Model):
    """Labeling data configuration definition.

    :ivar data_id: Resource Id of the data asset to perform labeling.
    :vartype data_id: str
    :ivar incremental_data_refresh_enabled: Indicates whether to enable incremental data refresh.
    :vartype incremental_data_refresh_enabled: bool
    """

    _attribute_map = {
        'data_id': {'key': 'dataId', 'type': 'str'},
        'incremental_data_refresh_enabled': {'key': 'incrementalDataRefreshEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        data_id: Optional[str] = None,
        incremental_data_refresh_enabled: Optional[bool] = False,
        **kwargs
    ):
        """
        :keyword data_id: Resource Id of the data asset to perform labeling.
        :paramtype data_id: str
        :keyword incremental_data_refresh_enabled: Indicates whether to enable incremental data
         refresh.
        :paramtype incremental_data_refresh_enabled: bool
        """
        super(LabelingDataConfiguration, self).__init__(**kwargs)
        self.data_id = data_id
        self.incremental_data_refresh_enabled = incremental_data_refresh_enabled


class LabelingJob(Resource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.LabelingJobProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'LabelingJobProperties'},
    }

    def __init__(
        self,
        *,
        properties: "LabelingJobProperties",
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.LabelingJobProperties
        """
        super(LabelingJob, self).__init__(**kwargs)
        self.properties = properties


class LabelingJobMediaProperties(msrest.serialization.Model):
    """Properties of a labeling job.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: LabelingJobImageProperties, LabelingJobTextProperties.

    All required parameters must be populated in order to send to Azure.

    :ivar media_type: Required. [Required] Media type of the job.Constant filled by server.
     Possible values include: "Image", "Text".
    :vartype media_type: str or ~azure.mgmt.machinelearningservices.models.MediaType
    """

    _validation = {
        'media_type': {'required': True},
    }

    _attribute_map = {
        'media_type': {'key': 'mediaType', 'type': 'str'},
    }

    _subtype_map = {
        'media_type': {'Image': 'LabelingJobImageProperties', 'Text': 'LabelingJobTextProperties'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(LabelingJobMediaProperties, self).__init__(**kwargs)
        self.media_type = None  # type: Optional[str]


class LabelingJobImageProperties(LabelingJobMediaProperties):
    """Properties of a labeling job for image data.

    All required parameters must be populated in order to send to Azure.

    :ivar media_type: Required. [Required] Media type of the job.Constant filled by server.
     Possible values include: "Image", "Text".
    :vartype media_type: str or ~azure.mgmt.machinelearningservices.models.MediaType
    :ivar annotation_type: Annotation type of image labeling job. Possible values include:
     "Classification", "BoundingBox", "InstanceSegmentation".
    :vartype annotation_type: str or ~azure.mgmt.machinelearningservices.models.ImageAnnotationType
    """

    _validation = {
        'media_type': {'required': True},
    }

    _attribute_map = {
        'media_type': {'key': 'mediaType', 'type': 'str'},
        'annotation_type': {'key': 'annotationType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        annotation_type: Optional[Union[str, "ImageAnnotationType"]] = None,
        **kwargs
    ):
        """
        :keyword annotation_type: Annotation type of image labeling job. Possible values include:
         "Classification", "BoundingBox", "InstanceSegmentation".
        :paramtype annotation_type: str or
         ~azure.mgmt.machinelearningservices.models.ImageAnnotationType
        """
        super(LabelingJobImageProperties, self).__init__(**kwargs)
        self.media_type = 'Image'  # type: str
        self.annotation_type = annotation_type


class LabelingJobInstructions(msrest.serialization.Model):
    """Instructions for labeling job.

    :ivar uri: The link to a page with detailed labeling instructions for labelers.
    :vartype uri: str
    """

    _attribute_map = {
        'uri': {'key': 'uri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        uri: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword uri: The link to a page with detailed labeling instructions for labelers.
        :paramtype uri: str
        """
        super(LabelingJobInstructions, self).__init__(**kwargs)
        self.uri = uri


class LabelingJobProperties(JobBaseProperties):
    """Labeling job definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar component_id: ARM resource ID of the component resource.
    :vartype component_id: str
    :ivar compute_id: ARM resource ID of the compute resource.
    :vartype compute_id: str
    :ivar display_name: Display name of job.
    :vartype display_name: str
    :ivar experiment_name: The name of the experiment the job belongs to. If not set, the job is
     placed in the "Default" experiment.
    :vartype experiment_name: str
    :ivar identity: Identity configuration. If set, this should be one of AmlToken,
     ManagedIdentity, UserIdentity or null.
     Defaults to AmlToken if null.
    :vartype identity: ~azure.mgmt.machinelearningservices.models.IdentityConfiguration
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar job_type: Required. [Required] Specifies the type of job.Constant filled by server.
     Possible values include: "AutoML", "Command", "Labeling", "Sweep", "Pipeline", "Spark".
    :vartype job_type: str or ~azure.mgmt.machinelearningservices.models.JobType
    :ivar services: List of JobEndpoints.
     For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
    :vartype services: dict[str, ~azure.mgmt.machinelearningservices.models.JobService]
    :ivar status: Status of the job. Possible values include: "NotStarted", "Starting",
     "Provisioning", "Preparing", "Queued", "Running", "Finalizing", "CancelRequested", "Completed",
     "Failed", "Canceled", "NotResponding", "Paused", "Unknown", "Scheduled".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.JobStatus
    :ivar created_date_time: Created time of the job in UTC timezone.
    :vartype created_date_time: ~datetime.datetime
    :ivar data_configuration: Configuration of data used in the job.
    :vartype data_configuration:
     ~azure.mgmt.machinelearningservices.models.LabelingDataConfiguration
    :ivar job_instructions: Labeling instructions of the job.
    :vartype job_instructions: ~azure.mgmt.machinelearningservices.models.LabelingJobInstructions
    :ivar label_categories: Label categories of the job.
    :vartype label_categories: dict[str, ~azure.mgmt.machinelearningservices.models.LabelCategory]
    :ivar labeling_job_media_properties: Media type specific properties in the job.
    :vartype labeling_job_media_properties:
     ~azure.mgmt.machinelearningservices.models.LabelingJobMediaProperties
    :ivar ml_assist_configuration: Configuration of MLAssist feature in the job.
    :vartype ml_assist_configuration:
     ~azure.mgmt.machinelearningservices.models.MLAssistConfiguration
    :ivar progress_metrics: Progress metrics of the job.
    :vartype progress_metrics: ~azure.mgmt.machinelearningservices.models.ProgressMetrics
    :ivar project_id: Internal id of the job(Previously called project).
    :vartype project_id: str
    :ivar provisioning_state: Specifies the labeling job provisioning state. Possible values
     include: "Succeeded", "Failed", "Canceled", "InProgress".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.JobProvisioningState
    :ivar status_messages: Status messages of the job.
    :vartype status_messages: list[~azure.mgmt.machinelearningservices.models.StatusMessage]
    """

    _validation = {
        'job_type': {'required': True},
        'status': {'readonly': True},
        'created_date_time': {'readonly': True},
        'progress_metrics': {'readonly': True},
        'project_id': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'status_messages': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'component_id': {'key': 'componentId', 'type': 'str'},
        'compute_id': {'key': 'computeId', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'experiment_name': {'key': 'experimentName', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'IdentityConfiguration'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'job_type': {'key': 'jobType', 'type': 'str'},
        'services': {'key': 'services', 'type': '{JobService}'},
        'status': {'key': 'status', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'data_configuration': {'key': 'dataConfiguration', 'type': 'LabelingDataConfiguration'},
        'job_instructions': {'key': 'jobInstructions', 'type': 'LabelingJobInstructions'},
        'label_categories': {'key': 'labelCategories', 'type': '{LabelCategory}'},
        'labeling_job_media_properties': {'key': 'labelingJobMediaProperties', 'type': 'LabelingJobMediaProperties'},
        'ml_assist_configuration': {'key': 'mlAssistConfiguration', 'type': 'MLAssistConfiguration'},
        'progress_metrics': {'key': 'progressMetrics', 'type': 'ProgressMetrics'},
        'project_id': {'key': 'projectId', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'status_messages': {'key': 'statusMessages', 'type': '[StatusMessage]'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        component_id: Optional[str] = None,
        compute_id: Optional[str] = None,
        display_name: Optional[str] = None,
        experiment_name: Optional[str] = "Default",
        identity: Optional["IdentityConfiguration"] = None,
        is_archived: Optional[bool] = False,
        services: Optional[Dict[str, "JobService"]] = None,
        data_configuration: Optional["LabelingDataConfiguration"] = None,
        job_instructions: Optional["LabelingJobInstructions"] = None,
        label_categories: Optional[Dict[str, "LabelCategory"]] = None,
        labeling_job_media_properties: Optional["LabelingJobMediaProperties"] = None,
        ml_assist_configuration: Optional["MLAssistConfiguration"] = None,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword component_id: ARM resource ID of the component resource.
        :paramtype component_id: str
        :keyword compute_id: ARM resource ID of the compute resource.
        :paramtype compute_id: str
        :keyword display_name: Display name of job.
        :paramtype display_name: str
        :keyword experiment_name: The name of the experiment the job belongs to. If not set, the job is
         placed in the "Default" experiment.
        :paramtype experiment_name: str
        :keyword identity: Identity configuration. If set, this should be one of AmlToken,
         ManagedIdentity, UserIdentity or null.
         Defaults to AmlToken if null.
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.IdentityConfiguration
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword services: List of JobEndpoints.
         For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        :paramtype services: dict[str, ~azure.mgmt.machinelearningservices.models.JobService]
        :keyword data_configuration: Configuration of data used in the job.
        :paramtype data_configuration:
         ~azure.mgmt.machinelearningservices.models.LabelingDataConfiguration
        :keyword job_instructions: Labeling instructions of the job.
        :paramtype job_instructions: ~azure.mgmt.machinelearningservices.models.LabelingJobInstructions
        :keyword label_categories: Label categories of the job.
        :paramtype label_categories: dict[str,
         ~azure.mgmt.machinelearningservices.models.LabelCategory]
        :keyword labeling_job_media_properties: Media type specific properties in the job.
        :paramtype labeling_job_media_properties:
         ~azure.mgmt.machinelearningservices.models.LabelingJobMediaProperties
        :keyword ml_assist_configuration: Configuration of MLAssist feature in the job.
        :paramtype ml_assist_configuration:
         ~azure.mgmt.machinelearningservices.models.MLAssistConfiguration
        """
        super(LabelingJobProperties, self).__init__(description=description, properties=properties, tags=tags, component_id=component_id, compute_id=compute_id, display_name=display_name, experiment_name=experiment_name, identity=identity, is_archived=is_archived, services=services, **kwargs)
        self.job_type = 'Labeling'  # type: str
        self.created_date_time = None
        self.data_configuration = data_configuration
        self.job_instructions = job_instructions
        self.label_categories = label_categories
        self.labeling_job_media_properties = labeling_job_media_properties
        self.ml_assist_configuration = ml_assist_configuration
        self.progress_metrics = None
        self.project_id = None
        self.provisioning_state = None
        self.status_messages = None


class LabelingJobResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of LabelingJob entities.

    :ivar next_link: The link to the next page of LabelingJob objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type LabelingJob.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.LabelingJob]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[LabelingJob]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["LabelingJob"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of LabelingJob objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type LabelingJob.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.LabelingJob]
        """
        super(LabelingJobResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class LabelingJobTextProperties(LabelingJobMediaProperties):
    """Properties of a labeling job for text data.

    All required parameters must be populated in order to send to Azure.

    :ivar media_type: Required. [Required] Media type of the job.Constant filled by server.
     Possible values include: "Image", "Text".
    :vartype media_type: str or ~azure.mgmt.machinelearningservices.models.MediaType
    :ivar annotation_type: Annotation type of text labeling job. Possible values include:
     "Classification", "NamedEntityRecognition".
    :vartype annotation_type: str or ~azure.mgmt.machinelearningservices.models.TextAnnotationType
    """

    _validation = {
        'media_type': {'required': True},
    }

    _attribute_map = {
        'media_type': {'key': 'mediaType', 'type': 'str'},
        'annotation_type': {'key': 'annotationType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        annotation_type: Optional[Union[str, "TextAnnotationType"]] = None,
        **kwargs
    ):
        """
        :keyword annotation_type: Annotation type of text labeling job. Possible values include:
         "Classification", "NamedEntityRecognition".
        :paramtype annotation_type: str or
         ~azure.mgmt.machinelearningservices.models.TextAnnotationType
        """
        super(LabelingJobTextProperties, self).__init__(**kwargs)
        self.media_type = 'Text'  # type: str
        self.annotation_type = annotation_type


class ListAmlUserFeatureResult(msrest.serialization.Model):
    """The List Aml user feature operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of AML user facing features.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.AmlUserFeature]
    :ivar next_link: The URI to fetch the next page of AML user features information. Call
     ListNext() with this to fetch the next page of AML user features information.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AmlUserFeature]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ListAmlUserFeatureResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ListNotebookKeysResult(msrest.serialization.Model):
    """ListNotebookKeysResult.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar primary_access_key:
    :vartype primary_access_key: str
    :ivar secondary_access_key:
    :vartype secondary_access_key: str
    """

    _validation = {
        'primary_access_key': {'readonly': True},
        'secondary_access_key': {'readonly': True},
    }

    _attribute_map = {
        'primary_access_key': {'key': 'primaryAccessKey', 'type': 'str'},
        'secondary_access_key': {'key': 'secondaryAccessKey', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ListNotebookKeysResult, self).__init__(**kwargs)
        self.primary_access_key = None
        self.secondary_access_key = None


class ListStorageAccountKeysResult(msrest.serialization.Model):
    """ListStorageAccountKeysResult.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar user_storage_key:
    :vartype user_storage_key: str
    """

    _validation = {
        'user_storage_key': {'readonly': True},
    }

    _attribute_map = {
        'user_storage_key': {'key': 'userStorageKey', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ListStorageAccountKeysResult, self).__init__(**kwargs)
        self.user_storage_key = None


class ListUsagesResult(msrest.serialization.Model):
    """The List Usages operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of AML resource usages.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.Usage]
    :ivar next_link: The URI to fetch the next page of AML resource usage information. Call
     ListNext() with this to fetch the next page of AML resource usage information.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Usage]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ListUsagesResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ListWorkspaceKeysResult(msrest.serialization.Model):
    """ListWorkspaceKeysResult.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar user_storage_key:
    :vartype user_storage_key: str
    :ivar user_storage_resource_id:
    :vartype user_storage_resource_id: str
    :ivar app_insights_instrumentation_key:
    :vartype app_insights_instrumentation_key: str
    :ivar container_registry_credentials:
    :vartype container_registry_credentials:
     ~azure.mgmt.machinelearningservices.models.RegistryListCredentialsResult
    :ivar notebook_access_keys:
    :vartype notebook_access_keys:
     ~azure.mgmt.machinelearningservices.models.ListNotebookKeysResult
    """

    _validation = {
        'user_storage_key': {'readonly': True},
        'user_storage_resource_id': {'readonly': True},
        'app_insights_instrumentation_key': {'readonly': True},
        'container_registry_credentials': {'readonly': True},
        'notebook_access_keys': {'readonly': True},
    }

    _attribute_map = {
        'user_storage_key': {'key': 'userStorageKey', 'type': 'str'},
        'user_storage_resource_id': {'key': 'userStorageResourceId', 'type': 'str'},
        'app_insights_instrumentation_key': {'key': 'appInsightsInstrumentationKey', 'type': 'str'},
        'container_registry_credentials': {'key': 'containerRegistryCredentials', 'type': 'RegistryListCredentialsResult'},
        'notebook_access_keys': {'key': 'notebookAccessKeys', 'type': 'ListNotebookKeysResult'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ListWorkspaceKeysResult, self).__init__(**kwargs)
        self.user_storage_key = None
        self.user_storage_resource_id = None
        self.app_insights_instrumentation_key = None
        self.container_registry_credentials = None
        self.notebook_access_keys = None


class ListWorkspaceQuotas(msrest.serialization.Model):
    """The List WorkspaceQuotasByVMFamily operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of Workspace Quotas by VM Family.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.ResourceQuota]
    :ivar next_link: The URI to fetch the next page of workspace quota information by VM Family.
     Call ListNext() with this to fetch the next page of Workspace Quota information.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ResourceQuota]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ListWorkspaceQuotas, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class LiteralJobInput(JobInput):
    """Literal input type.

    All required parameters must be populated in order to send to Azure.

    :ivar description: Description for the input.
    :vartype description: str
    :ivar job_input_type: Required. [Required] Specifies the type of job.Constant filled by server.
     Possible values include: "literal", "uri_file", "uri_folder", "mltable", "custom_model",
     "mlflow_model", "triton_model".
    :vartype job_input_type: str or ~azure.mgmt.machinelearningservices.models.JobInputType
    :ivar value: Required. [Required] Literal value for the input.
    :vartype value: str
    """

    _validation = {
        'job_input_type': {'required': True},
        'value': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'job_input_type': {'key': 'jobInputType', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: str,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword description: Description for the input.
        :paramtype description: str
        :keyword value: Required. [Required] Literal value for the input.
        :paramtype value: str
        """
        super(LiteralJobInput, self).__init__(description=description, **kwargs)
        self.job_input_type = 'literal'  # type: str
        self.value = value


class ManagedIdentity(IdentityConfiguration):
    """Managed identity configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar identity_type: Required. [Required] Specifies the type of identity framework.Constant
     filled by server. Possible values include: "Managed", "AMLToken", "UserIdentity".
    :vartype identity_type: str or
     ~azure.mgmt.machinelearningservices.models.IdentityConfigurationType
    :ivar client_id: Specifies a user-assigned identity by client ID. For system-assigned, do not
     set this field.
    :vartype client_id: str
    :ivar object_id: Specifies a user-assigned identity by object ID. For system-assigned, do not
     set this field.
    :vartype object_id: str
    :ivar resource_id: Specifies a user-assigned identity by ARM resource ID. For system-assigned,
     do not set this field.
    :vartype resource_id: str
    """

    _validation = {
        'identity_type': {'required': True},
    }

    _attribute_map = {
        'identity_type': {'key': 'identityType', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
        'object_id': {'key': 'objectId', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        client_id: Optional[str] = None,
        object_id: Optional[str] = None,
        resource_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword client_id: Specifies a user-assigned identity by client ID. For system-assigned, do
         not set this field.
        :paramtype client_id: str
        :keyword object_id: Specifies a user-assigned identity by object ID. For system-assigned, do
         not set this field.
        :paramtype object_id: str
        :keyword resource_id: Specifies a user-assigned identity by ARM resource ID. For
         system-assigned, do not set this field.
        :paramtype resource_id: str
        """
        super(ManagedIdentity, self).__init__(**kwargs)
        self.identity_type = 'Managed'  # type: str
        self.client_id = client_id
        self.object_id = object_id
        self.resource_id = resource_id


class ManagedIdentityAuthTypeWorkspaceConnectionProperties(WorkspaceConnectionPropertiesV2):
    """ManagedIdentityAuthTypeWorkspaceConnectionProperties.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Required. Authentication type of the connection target.Constant filled by
     server. Possible values include: "PAT", "ManagedIdentity", "UsernamePassword", "None", "SAS",
     "ServicePrincipal", "AccessKey".
    :vartype auth_type: str or ~azure.mgmt.machinelearningservices.models.ConnectionAuthType
    :ivar category: Category of the connection.
    :vartype category: str
    :ivar target:
    :vartype target: str
    :ivar value: Value details of the workspace connection.
    :vartype value: str
    :ivar value_format: format for the workspace connection value. Possible values include: "JSON".
    :vartype value_format: str or ~azure.mgmt.machinelearningservices.models.ValueFormat
    :ivar credentials:
    :vartype credentials:
     ~azure.mgmt.machinelearningservices.models.WorkspaceConnectionManagedIdentity
    """

    _validation = {
        'auth_type': {'required': True},
    }

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'value_format': {'key': 'valueFormat', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'WorkspaceConnectionManagedIdentity'},
    }

    def __init__(
        self,
        *,
        category: Optional[str] = None,
        target: Optional[str] = None,
        value: Optional[str] = None,
        value_format: Optional[Union[str, "ValueFormat"]] = None,
        credentials: Optional["WorkspaceConnectionManagedIdentity"] = None,
        **kwargs
    ):
        """
        :keyword category: Category of the connection.
        :paramtype category: str
        :keyword target:
        :paramtype target: str
        :keyword value: Value details of the workspace connection.
        :paramtype value: str
        :keyword value_format: format for the workspace connection value. Possible values include:
         "JSON".
        :paramtype value_format: str or ~azure.mgmt.machinelearningservices.models.ValueFormat
        :keyword credentials:
        :paramtype credentials:
         ~azure.mgmt.machinelearningservices.models.WorkspaceConnectionManagedIdentity
        """
        super(ManagedIdentityAuthTypeWorkspaceConnectionProperties, self).__init__(category=category, target=target, value=value, value_format=value_format, **kwargs)
        self.auth_type = 'ManagedIdentity'  # type: str
        self.credentials = credentials


class ManagedOnlineDeployment(OnlineDeploymentProperties):
    """Properties specific to a ManagedOnlineDeployment.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar code_configuration: Code configuration for the endpoint deployment.
    :vartype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
    :ivar description: Description of the endpoint deployment.
    :vartype description: str
    :ivar environment_id: ARM resource ID of the environment specification for the endpoint
     deployment.
    :vartype environment_id: str
    :ivar environment_variables: Environment variables configuration for the deployment.
    :vartype environment_variables: dict[str, str]
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar app_insights_enabled: If true, enables Application Insights logging.
    :vartype app_insights_enabled: bool
    :ivar egress_public_network_access: If Enabled, allow egress public network access. If
     Disabled, this will create secure egress. Default: Enabled. Possible values include: "Enabled",
     "Disabled".
    :vartype egress_public_network_access: str or
     ~azure.mgmt.machinelearningservices.models.EgressPublicNetworkAccessType
    :ivar endpoint_compute_type: Required. [Required] The compute type of the endpoint.Constant
     filled by server. Possible values include: "Managed", "Kubernetes", "AzureMLCompute".
    :vartype endpoint_compute_type: str or
     ~azure.mgmt.machinelearningservices.models.EndpointComputeType
    :ivar instance_type: Compute instance type.
    :vartype instance_type: str
    :ivar liveness_probe: Liveness probe monitors the health of the container regularly.
    :vartype liveness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
    :ivar model: The URI path to the model.
    :vartype model: str
    :ivar model_mount_path: The path to mount the model in custom container.
    :vartype model_mount_path: str
    :ivar provisioning_state: Provisioning state for the endpoint deployment. Possible values
     include: "Creating", "Deleting", "Scaling", "Updating", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.DeploymentProvisioningState
    :ivar readiness_probe: Readiness probe validates if the container is ready to serve traffic.
     The properties and defaults are the same as liveness probe.
    :vartype readiness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
    :ivar request_settings: Request settings for the deployment.
    :vartype request_settings: ~azure.mgmt.machinelearningservices.models.OnlineRequestSettings
    :ivar scale_settings: Scale settings for the deployment.
     If it is null or not provided,
     it defaults to TargetUtilizationScaleSettings for KubernetesOnlineDeployment
     and to DefaultScaleSettings for ManagedOnlineDeployment.
    :vartype scale_settings: ~azure.mgmt.machinelearningservices.models.OnlineScaleSettings
    """

    _validation = {
        'endpoint_compute_type': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'code_configuration': {'key': 'codeConfiguration', 'type': 'CodeConfiguration'},
        'description': {'key': 'description', 'type': 'str'},
        'environment_id': {'key': 'environmentId', 'type': 'str'},
        'environment_variables': {'key': 'environmentVariables', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'app_insights_enabled': {'key': 'appInsightsEnabled', 'type': 'bool'},
        'egress_public_network_access': {'key': 'egressPublicNetworkAccess', 'type': 'str'},
        'endpoint_compute_type': {'key': 'endpointComputeType', 'type': 'str'},
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'liveness_probe': {'key': 'livenessProbe', 'type': 'ProbeSettings'},
        'model': {'key': 'model', 'type': 'str'},
        'model_mount_path': {'key': 'modelMountPath', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'readiness_probe': {'key': 'readinessProbe', 'type': 'ProbeSettings'},
        'request_settings': {'key': 'requestSettings', 'type': 'OnlineRequestSettings'},
        'scale_settings': {'key': 'scaleSettings', 'type': 'OnlineScaleSettings'},
    }

    def __init__(
        self,
        *,
        code_configuration: Optional["CodeConfiguration"] = None,
        description: Optional[str] = None,
        environment_id: Optional[str] = None,
        environment_variables: Optional[Dict[str, str]] = None,
        properties: Optional[Dict[str, str]] = None,
        app_insights_enabled: Optional[bool] = False,
        egress_public_network_access: Optional[Union[str, "EgressPublicNetworkAccessType"]] = None,
        instance_type: Optional[str] = None,
        liveness_probe: Optional["ProbeSettings"] = None,
        model: Optional[str] = None,
        model_mount_path: Optional[str] = None,
        readiness_probe: Optional["ProbeSettings"] = None,
        request_settings: Optional["OnlineRequestSettings"] = None,
        scale_settings: Optional["OnlineScaleSettings"] = None,
        **kwargs
    ):
        """
        :keyword code_configuration: Code configuration for the endpoint deployment.
        :paramtype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
        :keyword description: Description of the endpoint deployment.
        :paramtype description: str
        :keyword environment_id: ARM resource ID of the environment specification for the endpoint
         deployment.
        :paramtype environment_id: str
        :keyword environment_variables: Environment variables configuration for the deployment.
        :paramtype environment_variables: dict[str, str]
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        :keyword app_insights_enabled: If true, enables Application Insights logging.
        :paramtype app_insights_enabled: bool
        :keyword egress_public_network_access: If Enabled, allow egress public network access. If
         Disabled, this will create secure egress. Default: Enabled. Possible values include: "Enabled",
         "Disabled".
        :paramtype egress_public_network_access: str or
         ~azure.mgmt.machinelearningservices.models.EgressPublicNetworkAccessType
        :keyword instance_type: Compute instance type.
        :paramtype instance_type: str
        :keyword liveness_probe: Liveness probe monitors the health of the container regularly.
        :paramtype liveness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
        :keyword model: The URI path to the model.
        :paramtype model: str
        :keyword model_mount_path: The path to mount the model in custom container.
        :paramtype model_mount_path: str
        :keyword readiness_probe: Readiness probe validates if the container is ready to serve traffic.
         The properties and defaults are the same as liveness probe.
        :paramtype readiness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
        :keyword request_settings: Request settings for the deployment.
        :paramtype request_settings: ~azure.mgmt.machinelearningservices.models.OnlineRequestSettings
        :keyword scale_settings: Scale settings for the deployment.
         If it is null or not provided,
         it defaults to TargetUtilizationScaleSettings for KubernetesOnlineDeployment
         and to DefaultScaleSettings for ManagedOnlineDeployment.
        :paramtype scale_settings: ~azure.mgmt.machinelearningservices.models.OnlineScaleSettings
        """
        super(ManagedOnlineDeployment, self).__init__(code_configuration=code_configuration, description=description, environment_id=environment_id, environment_variables=environment_variables, properties=properties, app_insights_enabled=app_insights_enabled, egress_public_network_access=egress_public_network_access, instance_type=instance_type, liveness_probe=liveness_probe, model=model, model_mount_path=model_mount_path, readiness_probe=readiness_probe, request_settings=request_settings, scale_settings=scale_settings, **kwargs)
        self.endpoint_compute_type = 'Managed'  # type: str


class ManagedServiceIdentity(msrest.serialization.Model):
    """Managed service identity (system assigned and/or user assigned identities).

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: Required. Type of managed service identity (where both SystemAssigned and
     UserAssigned types are allowed). Possible values include: "None", "SystemAssigned",
     "UserAssigned", "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The set of user assigned identities associated with the
     resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
     The dictionary values can be empty objects ({}) in requests.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.machinelearningservices.models.UserAssignedIdentity]
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{UserAssignedIdentity}'},
    }

    def __init__(
        self,
        *,
        type: Union[str, "ManagedServiceIdentityType"],
        user_assigned_identities: Optional[Dict[str, "UserAssignedIdentity"]] = None,
        **kwargs
    ):
        """
        :keyword type: Required. Type of managed service identity (where both SystemAssigned and
         UserAssigned types are allowed). Possible values include: "None", "SystemAssigned",
         "UserAssigned", "SystemAssigned,UserAssigned".
        :paramtype type: str or ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentityType
        :keyword user_assigned_identities: The set of user assigned identities associated with the
         resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
         The dictionary values can be empty objects ({}) in requests.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.machinelearningservices.models.UserAssignedIdentity]
        """
        super(ManagedServiceIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class MedianStoppingPolicy(EarlyTerminationPolicy):
    """Defines an early termination policy based on running averages of the primary metric of all runs.

    All required parameters must be populated in order to send to Azure.

    :ivar delay_evaluation: Number of intervals by which to delay the first evaluation.
    :vartype delay_evaluation: int
    :ivar evaluation_interval: Interval (number of runs) between policy evaluations.
    :vartype evaluation_interval: int
    :ivar policy_type: Required. [Required] Name of policy configuration.Constant filled by server.
     Possible values include: "Bandit", "MedianStopping", "TruncationSelection".
    :vartype policy_type: str or
     ~azure.mgmt.machinelearningservices.models.EarlyTerminationPolicyType
    """

    _validation = {
        'policy_type': {'required': True},
    }

    _attribute_map = {
        'delay_evaluation': {'key': 'delayEvaluation', 'type': 'int'},
        'evaluation_interval': {'key': 'evaluationInterval', 'type': 'int'},
        'policy_type': {'key': 'policyType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        delay_evaluation: Optional[int] = 0,
        evaluation_interval: Optional[int] = 0,
        **kwargs
    ):
        """
        :keyword delay_evaluation: Number of intervals by which to delay the first evaluation.
        :paramtype delay_evaluation: int
        :keyword evaluation_interval: Interval (number of runs) between policy evaluations.
        :paramtype evaluation_interval: int
        """
        super(MedianStoppingPolicy, self).__init__(delay_evaluation=delay_evaluation, evaluation_interval=evaluation_interval, **kwargs)
        self.policy_type = 'MedianStopping'  # type: str


class MLAssistConfiguration(msrest.serialization.Model):
    """Labeling MLAssist configuration definition.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: MLAssistConfigurationDisabled, MLAssistConfigurationEnabled.

    All required parameters must be populated in order to send to Azure.

    :ivar ml_assist: Required. [Required] Indicates whether MLAssist feature is enabled.Constant
     filled by server. Possible values include: "Enabled", "Disabled".
    :vartype ml_assist: str or ~azure.mgmt.machinelearningservices.models.MLAssistConfigurationType
    """

    _validation = {
        'ml_assist': {'required': True},
    }

    _attribute_map = {
        'ml_assist': {'key': 'mlAssist', 'type': 'str'},
    }

    _subtype_map = {
        'ml_assist': {'Disabled': 'MLAssistConfigurationDisabled', 'Enabled': 'MLAssistConfigurationEnabled'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(MLAssistConfiguration, self).__init__(**kwargs)
        self.ml_assist = None  # type: Optional[str]


class MLAssistConfigurationDisabled(MLAssistConfiguration):
    """Labeling MLAssist configuration definition when MLAssist is disabled.

    All required parameters must be populated in order to send to Azure.

    :ivar ml_assist: Required. [Required] Indicates whether MLAssist feature is enabled.Constant
     filled by server. Possible values include: "Enabled", "Disabled".
    :vartype ml_assist: str or ~azure.mgmt.machinelearningservices.models.MLAssistConfigurationType
    """

    _validation = {
        'ml_assist': {'required': True},
    }

    _attribute_map = {
        'ml_assist': {'key': 'mlAssist', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(MLAssistConfigurationDisabled, self).__init__(**kwargs)
        self.ml_assist = 'Disabled'  # type: str


class MLAssistConfigurationEnabled(MLAssistConfiguration):
    """Labeling MLAssist configuration definition when MLAssist is enabled.

    All required parameters must be populated in order to send to Azure.

    :ivar ml_assist: Required. [Required] Indicates whether MLAssist feature is enabled.Constant
     filled by server. Possible values include: "Enabled", "Disabled".
    :vartype ml_assist: str or ~azure.mgmt.machinelearningservices.models.MLAssistConfigurationType
    :ivar inferencing_compute_binding: Required. [Required] AML compute binding used in
     inferencing.
    :vartype inferencing_compute_binding: str
    :ivar training_compute_binding: Required. [Required] AML compute binding used in training.
    :vartype training_compute_binding: str
    """

    _validation = {
        'ml_assist': {'required': True},
        'inferencing_compute_binding': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'training_compute_binding': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'ml_assist': {'key': 'mlAssist', 'type': 'str'},
        'inferencing_compute_binding': {'key': 'inferencingComputeBinding', 'type': 'str'},
        'training_compute_binding': {'key': 'trainingComputeBinding', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        inferencing_compute_binding: str,
        training_compute_binding: str,
        **kwargs
    ):
        """
        :keyword inferencing_compute_binding: Required. [Required] AML compute binding used in
         inferencing.
        :paramtype inferencing_compute_binding: str
        :keyword training_compute_binding: Required. [Required] AML compute binding used in training.
        :paramtype training_compute_binding: str
        """
        super(MLAssistConfigurationEnabled, self).__init__(**kwargs)
        self.ml_assist = 'Enabled'  # type: str
        self.inferencing_compute_binding = inferencing_compute_binding
        self.training_compute_binding = training_compute_binding


class MLFlowModelJobInput(JobInput, AssetJobInput):
    """MLFlowModelJobInput.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
     "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
    :ivar uri: Required. [Required] Input Asset URI.
    :vartype uri: str
    :ivar description: Description for the input.
    :vartype description: str
    :ivar job_input_type: Required. [Required] Specifies the type of job.Constant filled by server.
     Possible values include: "literal", "uri_file", "uri_folder", "mltable", "custom_model",
     "mlflow_model", "triton_model".
    :vartype job_input_type: str or ~azure.mgmt.machinelearningservices.models.JobInputType
    """

    _validation = {
        'uri': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'job_input_type': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'job_input_type': {'key': 'jobInputType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        uri: str,
        mode: Optional[Union[str, "InputDeliveryMode"]] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
         "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
        :keyword uri: Required. [Required] Input Asset URI.
        :paramtype uri: str
        :keyword description: Description for the input.
        :paramtype description: str
        """
        super(MLFlowModelJobInput, self).__init__(description=description, mode=mode, uri=uri, **kwargs)
        self.mode = mode
        self.uri = uri
        self.job_input_type = 'mlflow_model'  # type: str
        self.description = description


class MLFlowModelJobOutput(JobOutput, AssetJobOutput):
    """MLFlowModelJobOutput.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload",
     "Direct".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
    :ivar uri: Output Asset URI.
    :vartype uri: str
    :ivar description: Description for the output.
    :vartype description: str
    :ivar job_output_type: Required. [Required] Specifies the type of job.Constant filled by
     server. Possible values include: "uri_file", "uri_folder", "mltable", "custom_model",
     "mlflow_model", "triton_model".
    :vartype job_output_type: str or ~azure.mgmt.machinelearningservices.models.JobOutputType
    """

    _validation = {
        'job_output_type': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'job_output_type': {'key': 'jobOutputType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        mode: Optional[Union[str, "OutputDeliveryMode"]] = None,
        uri: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload",
         "Direct".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
        :keyword uri: Output Asset URI.
        :paramtype uri: str
        :keyword description: Description for the output.
        :paramtype description: str
        """
        super(MLFlowModelJobOutput, self).__init__(description=description, mode=mode, uri=uri, **kwargs)
        self.mode = mode
        self.uri = uri
        self.job_output_type = 'mlflow_model'  # type: str
        self.description = description


class MLTableData(DataVersionBaseProperties):
    """MLTable data definition.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_anonymous: If the name version are system generated (anonymous registration).
    :vartype is_anonymous: bool
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar data_type: Required. [Required] Specifies the type of data.Constant filled by server.
     Possible values include: "uri_file", "uri_folder", "mltable".
    :vartype data_type: str or ~azure.mgmt.machinelearningservices.models.DataType
    :ivar data_uri: Required. [Required] Uri of the data. Usage/meaning depends on
     Microsoft.MachineLearning.ManagementFrontEnd.Contracts.V20221001Preview.Assets.DataVersionBase.DataType.
    :vartype data_uri: str
    :ivar referenced_uris: Uris referenced in the MLTable definition (required for lineage).
    :vartype referenced_uris: list[str]
    """

    _validation = {
        'data_type': {'required': True},
        'data_uri': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_anonymous': {'key': 'isAnonymous', 'type': 'bool'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'data_type': {'key': 'dataType', 'type': 'str'},
        'data_uri': {'key': 'dataUri', 'type': 'str'},
        'referenced_uris': {'key': 'referencedUris', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        data_uri: str,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        is_anonymous: Optional[bool] = False,
        is_archived: Optional[bool] = False,
        referenced_uris: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_anonymous: If the name version are system generated (anonymous registration).
        :paramtype is_anonymous: bool
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword data_uri: Required. [Required] Uri of the data. Usage/meaning depends on
         Microsoft.MachineLearning.ManagementFrontEnd.Contracts.V20221001Preview.Assets.DataVersionBase.DataType.
        :paramtype data_uri: str
        :keyword referenced_uris: Uris referenced in the MLTable definition (required for lineage).
        :paramtype referenced_uris: list[str]
        """
        super(MLTableData, self).__init__(description=description, properties=properties, tags=tags, is_anonymous=is_anonymous, is_archived=is_archived, data_uri=data_uri, **kwargs)
        self.data_type = 'mltable'  # type: str
        self.referenced_uris = referenced_uris


class MLTableJobInput(JobInput, AssetJobInput):
    """MLTableJobInput.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
     "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
    :ivar uri: Required. [Required] Input Asset URI.
    :vartype uri: str
    :ivar description: Description for the input.
    :vartype description: str
    :ivar job_input_type: Required. [Required] Specifies the type of job.Constant filled by server.
     Possible values include: "literal", "uri_file", "uri_folder", "mltable", "custom_model",
     "mlflow_model", "triton_model".
    :vartype job_input_type: str or ~azure.mgmt.machinelearningservices.models.JobInputType
    """

    _validation = {
        'uri': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'job_input_type': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'job_input_type': {'key': 'jobInputType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        uri: str,
        mode: Optional[Union[str, "InputDeliveryMode"]] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
         "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
        :keyword uri: Required. [Required] Input Asset URI.
        :paramtype uri: str
        :keyword description: Description for the input.
        :paramtype description: str
        """
        super(MLTableJobInput, self).__init__(description=description, mode=mode, uri=uri, **kwargs)
        self.mode = mode
        self.uri = uri
        self.job_input_type = 'mltable'  # type: str
        self.description = description


class MLTableJobOutput(JobOutput, AssetJobOutput):
    """MLTableJobOutput.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload",
     "Direct".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
    :ivar uri: Output Asset URI.
    :vartype uri: str
    :ivar description: Description for the output.
    :vartype description: str
    :ivar job_output_type: Required. [Required] Specifies the type of job.Constant filled by
     server. Possible values include: "uri_file", "uri_folder", "mltable", "custom_model",
     "mlflow_model", "triton_model".
    :vartype job_output_type: str or ~azure.mgmt.machinelearningservices.models.JobOutputType
    """

    _validation = {
        'job_output_type': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'job_output_type': {'key': 'jobOutputType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        mode: Optional[Union[str, "OutputDeliveryMode"]] = None,
        uri: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload",
         "Direct".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
        :keyword uri: Output Asset URI.
        :paramtype uri: str
        :keyword description: Description for the output.
        :paramtype description: str
        """
        super(MLTableJobOutput, self).__init__(description=description, mode=mode, uri=uri, **kwargs)
        self.mode = mode
        self.uri = uri
        self.job_output_type = 'mltable'  # type: str
        self.description = description


class ModelContainer(Resource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.ModelContainerProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'ModelContainerProperties'},
    }

    def __init__(
        self,
        *,
        properties: "ModelContainerProperties",
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.ModelContainerProperties
        """
        super(ModelContainer, self).__init__(**kwargs)
        self.properties = properties


class ModelContainerProperties(AssetContainer):
    """ModelContainerProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar latest_version: The latest version inside this container.
    :vartype latest_version: str
    :ivar next_version: The next auto incremental version.
    :vartype next_version: str
    :ivar provisioning_state: Provisioning state for the model container. Possible values include:
     "Succeeded", "Failed", "Canceled", "Creating", "Updating", "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.AssetProvisioningState
    """

    _validation = {
        'latest_version': {'readonly': True},
        'next_version': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'latest_version': {'key': 'latestVersion', 'type': 'str'},
        'next_version': {'key': 'nextVersion', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        is_archived: Optional[bool] = False,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        """
        super(ModelContainerProperties, self).__init__(description=description, properties=properties, tags=tags, is_archived=is_archived, **kwargs)
        self.provisioning_state = None


class ModelContainerResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of ModelContainer entities.

    :ivar next_link: The link to the next page of ModelContainer objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type ModelContainer.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.ModelContainer]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[ModelContainer]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["ModelContainer"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of ModelContainer objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type ModelContainer.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.ModelContainer]
        """
        super(ModelContainerResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class ModelVersion(Resource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.ModelVersionProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'ModelVersionProperties'},
    }

    def __init__(
        self,
        *,
        properties: "ModelVersionProperties",
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.ModelVersionProperties
        """
        super(ModelVersion, self).__init__(**kwargs)
        self.properties = properties


class ModelVersionProperties(AssetBase):
    """Model asset version details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_anonymous: If the name version are system generated (anonymous registration).
    :vartype is_anonymous: bool
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar flavors: Mapping of model flavors to their properties.
    :vartype flavors: dict[str, ~azure.mgmt.machinelearningservices.models.FlavorData]
    :ivar job_name: Name of the training job which produced this model.
    :vartype job_name: str
    :ivar model_type: The storage format for this entity. Used for NCD.
    :vartype model_type: str
    :ivar model_uri: The URI path to the model contents.
    :vartype model_uri: str
    :ivar provisioning_state: Provisioning state for the model version. Possible values include:
     "Succeeded", "Failed", "Canceled", "Creating", "Updating", "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.AssetProvisioningState
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_anonymous': {'key': 'isAnonymous', 'type': 'bool'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'flavors': {'key': 'flavors', 'type': '{FlavorData}'},
        'job_name': {'key': 'jobName', 'type': 'str'},
        'model_type': {'key': 'modelType', 'type': 'str'},
        'model_uri': {'key': 'modelUri', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        is_anonymous: Optional[bool] = False,
        is_archived: Optional[bool] = False,
        flavors: Optional[Dict[str, "FlavorData"]] = None,
        job_name: Optional[str] = None,
        model_type: Optional[str] = None,
        model_uri: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_anonymous: If the name version are system generated (anonymous registration).
        :paramtype is_anonymous: bool
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword flavors: Mapping of model flavors to their properties.
        :paramtype flavors: dict[str, ~azure.mgmt.machinelearningservices.models.FlavorData]
        :keyword job_name: Name of the training job which produced this model.
        :paramtype job_name: str
        :keyword model_type: The storage format for this entity. Used for NCD.
        :paramtype model_type: str
        :keyword model_uri: The URI path to the model contents.
        :paramtype model_uri: str
        """
        super(ModelVersionProperties, self).__init__(description=description, properties=properties, tags=tags, is_anonymous=is_anonymous, is_archived=is_archived, **kwargs)
        self.flavors = flavors
        self.job_name = job_name
        self.model_type = model_type
        self.model_uri = model_uri
        self.provisioning_state = None


class ModelVersionResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of ModelVersion entities.

    :ivar next_link: The link to the next page of ModelVersion objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type ModelVersion.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.ModelVersion]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[ModelVersion]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["ModelVersion"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of ModelVersion objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type ModelVersion.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.ModelVersion]
        """
        super(ModelVersionResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class Mpi(DistributionConfiguration):
    """MPI distribution configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar distribution_type: Required. [Required] Specifies the type of distribution
     framework.Constant filled by server. Possible values include: "PyTorch", "TensorFlow", "Mpi".
    :vartype distribution_type: str or ~azure.mgmt.machinelearningservices.models.DistributionType
    :ivar process_count_per_instance: Number of processes per MPI node.
    :vartype process_count_per_instance: int
    """

    _validation = {
        'distribution_type': {'required': True},
    }

    _attribute_map = {
        'distribution_type': {'key': 'distributionType', 'type': 'str'},
        'process_count_per_instance': {'key': 'processCountPerInstance', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        process_count_per_instance: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword process_count_per_instance: Number of processes per MPI node.
        :paramtype process_count_per_instance: int
        """
        super(Mpi, self).__init__(**kwargs)
        self.distribution_type = 'Mpi'  # type: str
        self.process_count_per_instance = process_count_per_instance


class NlpFixedParameters(msrest.serialization.Model):
    """Fixed training parameters that won't be swept over during AutoML NLP training.

    :ivar gradient_accumulation_steps: Number of steps to accumulate gradients over before running
     a backward pass.
    :vartype gradient_accumulation_steps: int
    :ivar learning_rate: The learning rate for the training procedure.
    :vartype learning_rate: float
    :ivar learning_rate_scheduler: The type of learning rate schedule to use during the training
     procedure. Possible values include: "None", "Linear", "Cosine", "CosineWithRestarts",
     "Polynomial", "Constant", "ConstantWithWarmup".
    :vartype learning_rate_scheduler: str or
     ~azure.mgmt.machinelearningservices.models.NlpLearningRateScheduler
    :ivar model_name: The name of the model to train.
    :vartype model_name: str
    :ivar number_of_epochs: Number of training epochs.
    :vartype number_of_epochs: int
    :ivar training_batch_size: The batch size for the training procedure.
    :vartype training_batch_size: int
    :ivar validation_batch_size: The batch size to be used during evaluation.
    :vartype validation_batch_size: int
    :ivar warmup_ratio: The warmup ratio, used alongside LrSchedulerType.
    :vartype warmup_ratio: float
    :ivar weight_decay: The weight decay for the training procedure.
    :vartype weight_decay: float
    """

    _attribute_map = {
        'gradient_accumulation_steps': {'key': 'gradientAccumulationSteps', 'type': 'int'},
        'learning_rate': {'key': 'learningRate', 'type': 'float'},
        'learning_rate_scheduler': {'key': 'learningRateScheduler', 'type': 'str'},
        'model_name': {'key': 'modelName', 'type': 'str'},
        'number_of_epochs': {'key': 'numberOfEpochs', 'type': 'int'},
        'training_batch_size': {'key': 'trainingBatchSize', 'type': 'int'},
        'validation_batch_size': {'key': 'validationBatchSize', 'type': 'int'},
        'warmup_ratio': {'key': 'warmupRatio', 'type': 'float'},
        'weight_decay': {'key': 'weightDecay', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        gradient_accumulation_steps: Optional[int] = None,
        learning_rate: Optional[float] = None,
        learning_rate_scheduler: Optional[Union[str, "NlpLearningRateScheduler"]] = None,
        model_name: Optional[str] = None,
        number_of_epochs: Optional[int] = None,
        training_batch_size: Optional[int] = None,
        validation_batch_size: Optional[int] = None,
        warmup_ratio: Optional[float] = None,
        weight_decay: Optional[float] = None,
        **kwargs
    ):
        """
        :keyword gradient_accumulation_steps: Number of steps to accumulate gradients over before
         running a backward pass.
        :paramtype gradient_accumulation_steps: int
        :keyword learning_rate: The learning rate for the training procedure.
        :paramtype learning_rate: float
        :keyword learning_rate_scheduler: The type of learning rate schedule to use during the training
         procedure. Possible values include: "None", "Linear", "Cosine", "CosineWithRestarts",
         "Polynomial", "Constant", "ConstantWithWarmup".
        :paramtype learning_rate_scheduler: str or
         ~azure.mgmt.machinelearningservices.models.NlpLearningRateScheduler
        :keyword model_name: The name of the model to train.
        :paramtype model_name: str
        :keyword number_of_epochs: Number of training epochs.
        :paramtype number_of_epochs: int
        :keyword training_batch_size: The batch size for the training procedure.
        :paramtype training_batch_size: int
        :keyword validation_batch_size: The batch size to be used during evaluation.
        :paramtype validation_batch_size: int
        :keyword warmup_ratio: The warmup ratio, used alongside LrSchedulerType.
        :paramtype warmup_ratio: float
        :keyword weight_decay: The weight decay for the training procedure.
        :paramtype weight_decay: float
        """
        super(NlpFixedParameters, self).__init__(**kwargs)
        self.gradient_accumulation_steps = gradient_accumulation_steps
        self.learning_rate = learning_rate
        self.learning_rate_scheduler = learning_rate_scheduler
        self.model_name = model_name
        self.number_of_epochs = number_of_epochs
        self.training_batch_size = training_batch_size
        self.validation_batch_size = validation_batch_size
        self.warmup_ratio = warmup_ratio
        self.weight_decay = weight_decay


class NlpParameterSubspace(msrest.serialization.Model):
    """Stringified search spaces for each parameter. See below examples.

    :ivar gradient_accumulation_steps: Number of steps to accumulate gradients over before running
     a backward pass.
    :vartype gradient_accumulation_steps: str
    :ivar learning_rate: The learning rate for the training procedure.
    :vartype learning_rate: str
    :ivar learning_rate_scheduler: The type of learning rate schedule to use during the training
     procedure.
    :vartype learning_rate_scheduler: str
    :ivar model_name: The name of the model to train.
    :vartype model_name: str
    :ivar number_of_epochs: Number of training epochs.
    :vartype number_of_epochs: str
    :ivar training_batch_size: The batch size for the training procedure.
    :vartype training_batch_size: str
    :ivar validation_batch_size: The batch size to be used during evaluation.
    :vartype validation_batch_size: str
    :ivar warmup_ratio: The warmup ratio, used alongside LrSchedulerType.
    :vartype warmup_ratio: str
    :ivar weight_decay: The weight decay for the training procedure.
    :vartype weight_decay: str
    """

    _attribute_map = {
        'gradient_accumulation_steps': {'key': 'gradientAccumulationSteps', 'type': 'str'},
        'learning_rate': {'key': 'learningRate', 'type': 'str'},
        'learning_rate_scheduler': {'key': 'learningRateScheduler', 'type': 'str'},
        'model_name': {'key': 'modelName', 'type': 'str'},
        'number_of_epochs': {'key': 'numberOfEpochs', 'type': 'str'},
        'training_batch_size': {'key': 'trainingBatchSize', 'type': 'str'},
        'validation_batch_size': {'key': 'validationBatchSize', 'type': 'str'},
        'warmup_ratio': {'key': 'warmupRatio', 'type': 'str'},
        'weight_decay': {'key': 'weightDecay', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        gradient_accumulation_steps: Optional[str] = None,
        learning_rate: Optional[str] = None,
        learning_rate_scheduler: Optional[str] = None,
        model_name: Optional[str] = None,
        number_of_epochs: Optional[str] = None,
        training_batch_size: Optional[str] = None,
        validation_batch_size: Optional[str] = None,
        warmup_ratio: Optional[str] = None,
        weight_decay: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword gradient_accumulation_steps: Number of steps to accumulate gradients over before
         running a backward pass.
        :paramtype gradient_accumulation_steps: str
        :keyword learning_rate: The learning rate for the training procedure.
        :paramtype learning_rate: str
        :keyword learning_rate_scheduler: The type of learning rate schedule to use during the training
         procedure.
        :paramtype learning_rate_scheduler: str
        :keyword model_name: The name of the model to train.
        :paramtype model_name: str
        :keyword number_of_epochs: Number of training epochs.
        :paramtype number_of_epochs: str
        :keyword training_batch_size: The batch size for the training procedure.
        :paramtype training_batch_size: str
        :keyword validation_batch_size: The batch size to be used during evaluation.
        :paramtype validation_batch_size: str
        :keyword warmup_ratio: The warmup ratio, used alongside LrSchedulerType.
        :paramtype warmup_ratio: str
        :keyword weight_decay: The weight decay for the training procedure.
        :paramtype weight_decay: str
        """
        super(NlpParameterSubspace, self).__init__(**kwargs)
        self.gradient_accumulation_steps = gradient_accumulation_steps
        self.learning_rate = learning_rate
        self.learning_rate_scheduler = learning_rate_scheduler
        self.model_name = model_name
        self.number_of_epochs = number_of_epochs
        self.training_batch_size = training_batch_size
        self.validation_batch_size = validation_batch_size
        self.warmup_ratio = warmup_ratio
        self.weight_decay = weight_decay


class NlpSweepSettings(msrest.serialization.Model):
    """Model sweeping and hyperparameter tuning related settings.

    All required parameters must be populated in order to send to Azure.

    :ivar early_termination: Type of early termination policy for the sweeping job.
    :vartype early_termination: ~azure.mgmt.machinelearningservices.models.EarlyTerminationPolicy
    :ivar sampling_algorithm: Required. [Required] Type of sampling algorithm. Possible values
     include: "Grid", "Random", "Bayesian".
    :vartype sampling_algorithm: str or
     ~azure.mgmt.machinelearningservices.models.SamplingAlgorithmType
    """

    _validation = {
        'sampling_algorithm': {'required': True},
    }

    _attribute_map = {
        'early_termination': {'key': 'earlyTermination', 'type': 'EarlyTerminationPolicy'},
        'sampling_algorithm': {'key': 'samplingAlgorithm', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        sampling_algorithm: Union[str, "SamplingAlgorithmType"],
        early_termination: Optional["EarlyTerminationPolicy"] = None,
        **kwargs
    ):
        """
        :keyword early_termination: Type of early termination policy for the sweeping job.
        :paramtype early_termination: ~azure.mgmt.machinelearningservices.models.EarlyTerminationPolicy
        :keyword sampling_algorithm: Required. [Required] Type of sampling algorithm. Possible values
         include: "Grid", "Random", "Bayesian".
        :paramtype sampling_algorithm: str or
         ~azure.mgmt.machinelearningservices.models.SamplingAlgorithmType
        """
        super(NlpSweepSettings, self).__init__(**kwargs)
        self.early_termination = early_termination
        self.sampling_algorithm = sampling_algorithm


class NlpVertical(msrest.serialization.Model):
    """Abstract class for NLP related AutoML tasks.
NLP - Natural Language Processing.

    :ivar featurization_settings: Featurization inputs needed for AutoML job.
    :vartype featurization_settings:
     ~azure.mgmt.machinelearningservices.models.NlpVerticalFeaturizationSettings
    :ivar fixed_parameters: Model/training parameters that will remain constant throughout
     training.
    :vartype fixed_parameters: ~azure.mgmt.machinelearningservices.models.NlpFixedParameters
    :ivar limit_settings: Execution constraints for AutoMLJob.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.NlpVerticalLimitSettings
    :ivar search_space: Search space for sampling different combinations of models and their
     hyperparameters.
    :vartype search_space: list[~azure.mgmt.machinelearningservices.models.NlpParameterSubspace]
    :ivar sweep_settings: Settings for model sweeping and hyperparameter tuning.
    :vartype sweep_settings: ~azure.mgmt.machinelearningservices.models.NlpSweepSettings
    :ivar validation_data: Validation data inputs.
    :vartype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    """

    _attribute_map = {
        'featurization_settings': {'key': 'featurizationSettings', 'type': 'NlpVerticalFeaturizationSettings'},
        'fixed_parameters': {'key': 'fixedParameters', 'type': 'NlpFixedParameters'},
        'limit_settings': {'key': 'limitSettings', 'type': 'NlpVerticalLimitSettings'},
        'search_space': {'key': 'searchSpace', 'type': '[NlpParameterSubspace]'},
        'sweep_settings': {'key': 'sweepSettings', 'type': 'NlpSweepSettings'},
        'validation_data': {'key': 'validationData', 'type': 'MLTableJobInput'},
    }

    def __init__(
        self,
        *,
        featurization_settings: Optional["NlpVerticalFeaturizationSettings"] = None,
        fixed_parameters: Optional["NlpFixedParameters"] = None,
        limit_settings: Optional["NlpVerticalLimitSettings"] = None,
        search_space: Optional[List["NlpParameterSubspace"]] = None,
        sweep_settings: Optional["NlpSweepSettings"] = None,
        validation_data: Optional["MLTableJobInput"] = None,
        **kwargs
    ):
        """
        :keyword featurization_settings: Featurization inputs needed for AutoML job.
        :paramtype featurization_settings:
         ~azure.mgmt.machinelearningservices.models.NlpVerticalFeaturizationSettings
        :keyword fixed_parameters: Model/training parameters that will remain constant throughout
         training.
        :paramtype fixed_parameters: ~azure.mgmt.machinelearningservices.models.NlpFixedParameters
        :keyword limit_settings: Execution constraints for AutoMLJob.
        :paramtype limit_settings: ~azure.mgmt.machinelearningservices.models.NlpVerticalLimitSettings
        :keyword search_space: Search space for sampling different combinations of models and their
         hyperparameters.
        :paramtype search_space: list[~azure.mgmt.machinelearningservices.models.NlpParameterSubspace]
        :keyword sweep_settings: Settings for model sweeping and hyperparameter tuning.
        :paramtype sweep_settings: ~azure.mgmt.machinelearningservices.models.NlpSweepSettings
        :keyword validation_data: Validation data inputs.
        :paramtype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        """
        super(NlpVertical, self).__init__(**kwargs)
        self.featurization_settings = featurization_settings
        self.fixed_parameters = fixed_parameters
        self.limit_settings = limit_settings
        self.search_space = search_space
        self.sweep_settings = sweep_settings
        self.validation_data = validation_data


class NlpVerticalFeaturizationSettings(FeaturizationSettings):
    """NlpVerticalFeaturizationSettings.

    :ivar dataset_language: Dataset language, useful for the text data.
    :vartype dataset_language: str
    """

    _attribute_map = {
        'dataset_language': {'key': 'datasetLanguage', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        dataset_language: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword dataset_language: Dataset language, useful for the text data.
        :paramtype dataset_language: str
        """
        super(NlpVerticalFeaturizationSettings, self).__init__(dataset_language=dataset_language, **kwargs)


class NlpVerticalLimitSettings(msrest.serialization.Model):
    """Job execution constraints.

    :ivar max_concurrent_trials: Maximum Concurrent AutoML iterations.
    :vartype max_concurrent_trials: int
    :ivar max_nodes: Maximum nodes to leverage for training in any single trial. Controls
     multi-node distributed training.
    :vartype max_nodes: int
    :ivar max_trials: Number of AutoML iterations.
    :vartype max_trials: int
    :ivar timeout: AutoML job timeout.
    :vartype timeout: ~datetime.timedelta
    :ivar trial_timeout: Timeout for individual HD trials.
    :vartype trial_timeout: ~datetime.timedelta
    """

    _attribute_map = {
        'max_concurrent_trials': {'key': 'maxConcurrentTrials', 'type': 'int'},
        'max_nodes': {'key': 'maxNodes', 'type': 'int'},
        'max_trials': {'key': 'maxTrials', 'type': 'int'},
        'timeout': {'key': 'timeout', 'type': 'duration'},
        'trial_timeout': {'key': 'trialTimeout', 'type': 'duration'},
    }

    def __init__(
        self,
        *,
        max_concurrent_trials: Optional[int] = 1,
        max_nodes: Optional[int] = 1,
        max_trials: Optional[int] = 1,
        timeout: Optional[datetime.timedelta] = "P7D",
        trial_timeout: Optional[datetime.timedelta] = None,
        **kwargs
    ):
        """
        :keyword max_concurrent_trials: Maximum Concurrent AutoML iterations.
        :paramtype max_concurrent_trials: int
        :keyword max_nodes: Maximum nodes to leverage for training in any single trial. Controls
         multi-node distributed training.
        :paramtype max_nodes: int
        :keyword max_trials: Number of AutoML iterations.
        :paramtype max_trials: int
        :keyword timeout: AutoML job timeout.
        :paramtype timeout: ~datetime.timedelta
        :keyword trial_timeout: Timeout for individual HD trials.
        :paramtype trial_timeout: ~datetime.timedelta
        """
        super(NlpVerticalLimitSettings, self).__init__(**kwargs)
        self.max_concurrent_trials = max_concurrent_trials
        self.max_nodes = max_nodes
        self.max_trials = max_trials
        self.timeout = timeout
        self.trial_timeout = trial_timeout


class NodeStateCounts(msrest.serialization.Model):
    """Counts of various compute node states on the amlCompute.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar idle_node_count: Number of compute nodes in idle state.
    :vartype idle_node_count: int
    :ivar running_node_count: Number of compute nodes which are running jobs.
    :vartype running_node_count: int
    :ivar preparing_node_count: Number of compute nodes which are being prepared.
    :vartype preparing_node_count: int
    :ivar unusable_node_count: Number of compute nodes which are in unusable state.
    :vartype unusable_node_count: int
    :ivar leaving_node_count: Number of compute nodes which are leaving the amlCompute.
    :vartype leaving_node_count: int
    :ivar preempted_node_count: Number of compute nodes which are in preempted state.
    :vartype preempted_node_count: int
    """

    _validation = {
        'idle_node_count': {'readonly': True},
        'running_node_count': {'readonly': True},
        'preparing_node_count': {'readonly': True},
        'unusable_node_count': {'readonly': True},
        'leaving_node_count': {'readonly': True},
        'preempted_node_count': {'readonly': True},
    }

    _attribute_map = {
        'idle_node_count': {'key': 'idleNodeCount', 'type': 'int'},
        'running_node_count': {'key': 'runningNodeCount', 'type': 'int'},
        'preparing_node_count': {'key': 'preparingNodeCount', 'type': 'int'},
        'unusable_node_count': {'key': 'unusableNodeCount', 'type': 'int'},
        'leaving_node_count': {'key': 'leavingNodeCount', 'type': 'int'},
        'preempted_node_count': {'key': 'preemptedNodeCount', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(NodeStateCounts, self).__init__(**kwargs)
        self.idle_node_count = None
        self.running_node_count = None
        self.preparing_node_count = None
        self.unusable_node_count = None
        self.leaving_node_count = None
        self.preempted_node_count = None


class NoneAuthTypeWorkspaceConnectionProperties(WorkspaceConnectionPropertiesV2):
    """NoneAuthTypeWorkspaceConnectionProperties.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Required. Authentication type of the connection target.Constant filled by
     server. Possible values include: "PAT", "ManagedIdentity", "UsernamePassword", "None", "SAS",
     "ServicePrincipal", "AccessKey".
    :vartype auth_type: str or ~azure.mgmt.machinelearningservices.models.ConnectionAuthType
    :ivar category: Category of the connection.
    :vartype category: str
    :ivar target:
    :vartype target: str
    :ivar value: Value details of the workspace connection.
    :vartype value: str
    :ivar value_format: format for the workspace connection value. Possible values include: "JSON".
    :vartype value_format: str or ~azure.mgmt.machinelearningservices.models.ValueFormat
    """

    _validation = {
        'auth_type': {'required': True},
    }

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'value_format': {'key': 'valueFormat', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        category: Optional[str] = None,
        target: Optional[str] = None,
        value: Optional[str] = None,
        value_format: Optional[Union[str, "ValueFormat"]] = None,
        **kwargs
    ):
        """
        :keyword category: Category of the connection.
        :paramtype category: str
        :keyword target:
        :paramtype target: str
        :keyword value: Value details of the workspace connection.
        :paramtype value: str
        :keyword value_format: format for the workspace connection value. Possible values include:
         "JSON".
        :paramtype value_format: str or ~azure.mgmt.machinelearningservices.models.ValueFormat
        """
        super(NoneAuthTypeWorkspaceConnectionProperties, self).__init__(category=category, target=target, value=value, value_format=value_format, **kwargs)
        self.auth_type = 'None'  # type: str


class NoneDatastoreCredentials(DatastoreCredentials):
    """Empty/none datastore credentials.

    All required parameters must be populated in order to send to Azure.

    :ivar credentials_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "AccountKey", "Certificate",
     "None", "Sas", "ServicePrincipal", "KerberosKeytab", "KerberosPassword".
    :vartype credentials_type: str or ~azure.mgmt.machinelearningservices.models.CredentialsType
    """

    _validation = {
        'credentials_type': {'required': True},
    }

    _attribute_map = {
        'credentials_type': {'key': 'credentialsType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(NoneDatastoreCredentials, self).__init__(**kwargs)
        self.credentials_type = 'None'  # type: str


class NotebookAccessTokenResult(msrest.serialization.Model):
    """NotebookAccessTokenResult.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar notebook_resource_id:
    :vartype notebook_resource_id: str
    :ivar host_name:
    :vartype host_name: str
    :ivar public_dns:
    :vartype public_dns: str
    :ivar access_token:
    :vartype access_token: str
    :ivar token_type:
    :vartype token_type: str
    :ivar expires_in:
    :vartype expires_in: int
    :ivar refresh_token:
    :vartype refresh_token: str
    :ivar scope:
    :vartype scope: str
    """

    _validation = {
        'notebook_resource_id': {'readonly': True},
        'host_name': {'readonly': True},
        'public_dns': {'readonly': True},
        'access_token': {'readonly': True},
        'token_type': {'readonly': True},
        'expires_in': {'readonly': True},
        'refresh_token': {'readonly': True},
        'scope': {'readonly': True},
    }

    _attribute_map = {
        'notebook_resource_id': {'key': 'notebookResourceId', 'type': 'str'},
        'host_name': {'key': 'hostName', 'type': 'str'},
        'public_dns': {'key': 'publicDns', 'type': 'str'},
        'access_token': {'key': 'accessToken', 'type': 'str'},
        'token_type': {'key': 'tokenType', 'type': 'str'},
        'expires_in': {'key': 'expiresIn', 'type': 'int'},
        'refresh_token': {'key': 'refreshToken', 'type': 'str'},
        'scope': {'key': 'scope', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(NotebookAccessTokenResult, self).__init__(**kwargs)
        self.notebook_resource_id = None
        self.host_name = None
        self.public_dns = None
        self.access_token = None
        self.token_type = None
        self.expires_in = None
        self.refresh_token = None
        self.scope = None


class NotebookPreparationError(msrest.serialization.Model):
    """NotebookPreparationError.

    :ivar error_message:
    :vartype error_message: str
    :ivar status_code:
    :vartype status_code: int
    """

    _attribute_map = {
        'error_message': {'key': 'errorMessage', 'type': 'str'},
        'status_code': {'key': 'statusCode', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        error_message: Optional[str] = None,
        status_code: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword error_message:
        :paramtype error_message: str
        :keyword status_code:
        :paramtype status_code: int
        """
        super(NotebookPreparationError, self).__init__(**kwargs)
        self.error_message = error_message
        self.status_code = status_code


class NotebookResourceInfo(msrest.serialization.Model):
    """NotebookResourceInfo.

    :ivar fqdn:
    :vartype fqdn: str
    :ivar resource_id: the data plane resourceId that used to initialize notebook component.
    :vartype resource_id: str
    :ivar notebook_preparation_error: The error that occurs when preparing notebook.
    :vartype notebook_preparation_error:
     ~azure.mgmt.machinelearningservices.models.NotebookPreparationError
    """

    _attribute_map = {
        'fqdn': {'key': 'fqdn', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'notebook_preparation_error': {'key': 'notebookPreparationError', 'type': 'NotebookPreparationError'},
    }

    def __init__(
        self,
        *,
        fqdn: Optional[str] = None,
        resource_id: Optional[str] = None,
        notebook_preparation_error: Optional["NotebookPreparationError"] = None,
        **kwargs
    ):
        """
        :keyword fqdn:
        :paramtype fqdn: str
        :keyword resource_id: the data plane resourceId that used to initialize notebook component.
        :paramtype resource_id: str
        :keyword notebook_preparation_error: The error that occurs when preparing notebook.
        :paramtype notebook_preparation_error:
         ~azure.mgmt.machinelearningservices.models.NotebookPreparationError
        """
        super(NotebookResourceInfo, self).__init__(**kwargs)
        self.fqdn = fqdn
        self.resource_id = resource_id
        self.notebook_preparation_error = notebook_preparation_error


class Objective(msrest.serialization.Model):
    """Optimization objective.

    All required parameters must be populated in order to send to Azure.

    :ivar goal: Required. [Required] Defines supported metric goals for hyperparameter tuning.
     Possible values include: "Minimize", "Maximize".
    :vartype goal: str or ~azure.mgmt.machinelearningservices.models.Goal
    :ivar primary_metric: Required. [Required] Name of the metric to optimize.
    :vartype primary_metric: str
    """

    _validation = {
        'goal': {'required': True},
        'primary_metric': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'goal': {'key': 'goal', 'type': 'str'},
        'primary_metric': {'key': 'primaryMetric', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        goal: Union[str, "Goal"],
        primary_metric: str,
        **kwargs
    ):
        """
        :keyword goal: Required. [Required] Defines supported metric goals for hyperparameter tuning.
         Possible values include: "Minimize", "Maximize".
        :paramtype goal: str or ~azure.mgmt.machinelearningservices.models.Goal
        :keyword primary_metric: Required. [Required] Name of the metric to optimize.
        :paramtype primary_metric: str
        """
        super(Objective, self).__init__(**kwargs)
        self.goal = goal
        self.primary_metric = primary_metric


class OnlineDeployment(TrackedResource):
    """OnlineDeployment.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
    :ivar kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type.
    :vartype kind: str
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.OnlineDeploymentProperties
    :ivar sku: Sku details required for ARM contract for Autoscaling.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.Sku
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'kind': {'key': 'kind', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'OnlineDeploymentProperties'},
        'sku': {'key': 'sku', 'type': 'Sku'},
    }

    def __init__(
        self,
        *,
        location: str,
        properties: "OnlineDeploymentProperties",
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["ManagedServiceIdentity"] = None,
        kind: Optional[str] = None,
        sku: Optional["Sku"] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword identity: Managed service identity (system assigned and/or user assigned identities).
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
        :keyword kind: Metadata used by portal/tooling/etc to render different UX experiences for
         resources of the same type.
        :paramtype kind: str
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.OnlineDeploymentProperties
        :keyword sku: Sku details required for ARM contract for Autoscaling.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.Sku
        """
        super(OnlineDeployment, self).__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.kind = kind
        self.properties = properties
        self.sku = sku


class OnlineDeploymentTrackedResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of OnlineDeployment entities.

    :ivar next_link: The link to the next page of OnlineDeployment objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type OnlineDeployment.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.OnlineDeployment]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[OnlineDeployment]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["OnlineDeployment"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of OnlineDeployment objects. If null, there are
         no additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type OnlineDeployment.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.OnlineDeployment]
        """
        super(OnlineDeploymentTrackedResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class OnlineEndpoint(TrackedResource):
    """OnlineEndpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
    :ivar kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type.
    :vartype kind: str
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.OnlineEndpointProperties
    :ivar sku: Sku details required for ARM contract for Autoscaling.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.Sku
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'kind': {'key': 'kind', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'OnlineEndpointProperties'},
        'sku': {'key': 'sku', 'type': 'Sku'},
    }

    def __init__(
        self,
        *,
        location: str,
        properties: "OnlineEndpointProperties",
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["ManagedServiceIdentity"] = None,
        kind: Optional[str] = None,
        sku: Optional["Sku"] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword identity: Managed service identity (system assigned and/or user assigned identities).
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
        :keyword kind: Metadata used by portal/tooling/etc to render different UX experiences for
         resources of the same type.
        :paramtype kind: str
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.OnlineEndpointProperties
        :keyword sku: Sku details required for ARM contract for Autoscaling.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.Sku
        """
        super(OnlineEndpoint, self).__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.kind = kind
        self.properties = properties
        self.sku = sku


class OnlineEndpointProperties(EndpointPropertiesBase):
    """Online endpoint configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_mode: Required. [Required] Use 'Key' for key based authentication and 'AMLToken' for
     Azure Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken' does.
     Possible values include: "AMLToken", "Key", "AADToken".
    :vartype auth_mode: str or ~azure.mgmt.machinelearningservices.models.EndpointAuthMode
    :ivar description: Description of the inference endpoint.
    :vartype description: str
    :ivar keys: EndpointAuthKeys to set initially on an Endpoint.
     This property will always be returned as null. AuthKey values must be retrieved using the
     ListKeys API.
    :vartype keys: ~azure.mgmt.machinelearningservices.models.EndpointAuthKeys
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar scoring_uri: Endpoint URI.
    :vartype scoring_uri: str
    :ivar swagger_uri: Endpoint Swagger URI.
    :vartype swagger_uri: str
    :ivar compute: ARM resource ID of the compute if it exists.
     optional.
    :vartype compute: str
    :ivar mirror_traffic: Percentage of traffic to be mirrored to each deployment without using
     returned scoring. Traffic values need to sum to utmost 50.
    :vartype mirror_traffic: dict[str, int]
    :ivar provisioning_state: Provisioning state for the endpoint. Possible values include:
     "Creating", "Deleting", "Succeeded", "Failed", "Updating", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.EndpointProvisioningState
    :ivar public_network_access: Set to "Enabled" for endpoints that should allow public access
     when Private Link is enabled. Possible values include: "Enabled", "Disabled".
    :vartype public_network_access: str or
     ~azure.mgmt.machinelearningservices.models.PublicNetworkAccessType
    :ivar traffic: Percentage of traffic from endpoint to divert to each deployment. Traffic values
     need to sum to 100.
    :vartype traffic: dict[str, int]
    """

    _validation = {
        'auth_mode': {'required': True},
        'scoring_uri': {'readonly': True},
        'swagger_uri': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'auth_mode': {'key': 'authMode', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'keys': {'key': 'keys', 'type': 'EndpointAuthKeys'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'scoring_uri': {'key': 'scoringUri', 'type': 'str'},
        'swagger_uri': {'key': 'swaggerUri', 'type': 'str'},
        'compute': {'key': 'compute', 'type': 'str'},
        'mirror_traffic': {'key': 'mirrorTraffic', 'type': '{int}'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
        'traffic': {'key': 'traffic', 'type': '{int}'},
    }

    def __init__(
        self,
        *,
        auth_mode: Union[str, "EndpointAuthMode"],
        description: Optional[str] = None,
        keys: Optional["EndpointAuthKeys"] = None,
        properties: Optional[Dict[str, str]] = None,
        compute: Optional[str] = None,
        mirror_traffic: Optional[Dict[str, int]] = None,
        public_network_access: Optional[Union[str, "PublicNetworkAccessType"]] = None,
        traffic: Optional[Dict[str, int]] = None,
        **kwargs
    ):
        """
        :keyword auth_mode: Required. [Required] Use 'Key' for key based authentication and 'AMLToken'
         for Azure Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken'
         does. Possible values include: "AMLToken", "Key", "AADToken".
        :paramtype auth_mode: str or ~azure.mgmt.machinelearningservices.models.EndpointAuthMode
        :keyword description: Description of the inference endpoint.
        :paramtype description: str
        :keyword keys: EndpointAuthKeys to set initially on an Endpoint.
         This property will always be returned as null. AuthKey values must be retrieved using the
         ListKeys API.
        :paramtype keys: ~azure.mgmt.machinelearningservices.models.EndpointAuthKeys
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        :keyword compute: ARM resource ID of the compute if it exists.
         optional.
        :paramtype compute: str
        :keyword mirror_traffic: Percentage of traffic to be mirrored to each deployment without using
         returned scoring. Traffic values need to sum to utmost 50.
        :paramtype mirror_traffic: dict[str, int]
        :keyword public_network_access: Set to "Enabled" for endpoints that should allow public access
         when Private Link is enabled. Possible values include: "Enabled", "Disabled".
        :paramtype public_network_access: str or
         ~azure.mgmt.machinelearningservices.models.PublicNetworkAccessType
        :keyword traffic: Percentage of traffic from endpoint to divert to each deployment. Traffic
         values need to sum to 100.
        :paramtype traffic: dict[str, int]
        """
        super(OnlineEndpointProperties, self).__init__(auth_mode=auth_mode, description=description, keys=keys, properties=properties, **kwargs)
        self.compute = compute
        self.mirror_traffic = mirror_traffic
        self.provisioning_state = None
        self.public_network_access = public_network_access
        self.traffic = traffic


class OnlineEndpointTrackedResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of OnlineEndpoint entities.

    :ivar next_link: The link to the next page of OnlineEndpoint objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type OnlineEndpoint.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.OnlineEndpoint]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[OnlineEndpoint]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["OnlineEndpoint"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of OnlineEndpoint objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type OnlineEndpoint.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.OnlineEndpoint]
        """
        super(OnlineEndpointTrackedResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class OnlineRequestSettings(msrest.serialization.Model):
    """Online deployment scoring requests configuration.

    :ivar max_concurrent_requests_per_instance: The number of maximum concurrent requests per node
     allowed per deployment. Defaults to 1.
    :vartype max_concurrent_requests_per_instance: int
    :ivar max_queue_wait: The maximum amount of time a request will stay in the queue in ISO 8601
     format.
     Defaults to 500ms.
    :vartype max_queue_wait: ~datetime.timedelta
    :ivar request_timeout: The scoring timeout in ISO 8601 format.
     Defaults to 5000ms.
    :vartype request_timeout: ~datetime.timedelta
    """

    _attribute_map = {
        'max_concurrent_requests_per_instance': {'key': 'maxConcurrentRequestsPerInstance', 'type': 'int'},
        'max_queue_wait': {'key': 'maxQueueWait', 'type': 'duration'},
        'request_timeout': {'key': 'requestTimeout', 'type': 'duration'},
    }

    def __init__(
        self,
        *,
        max_concurrent_requests_per_instance: Optional[int] = 1,
        max_queue_wait: Optional[datetime.timedelta] = "PT0.5S",
        request_timeout: Optional[datetime.timedelta] = "PT5S",
        **kwargs
    ):
        """
        :keyword max_concurrent_requests_per_instance: The number of maximum concurrent requests per
         node allowed per deployment. Defaults to 1.
        :paramtype max_concurrent_requests_per_instance: int
        :keyword max_queue_wait: The maximum amount of time a request will stay in the queue in ISO
         8601 format.
         Defaults to 500ms.
        :paramtype max_queue_wait: ~datetime.timedelta
        :keyword request_timeout: The scoring timeout in ISO 8601 format.
         Defaults to 5000ms.
        :paramtype request_timeout: ~datetime.timedelta
        """
        super(OnlineRequestSettings, self).__init__(**kwargs)
        self.max_concurrent_requests_per_instance = max_concurrent_requests_per_instance
        self.max_queue_wait = max_queue_wait
        self.request_timeout = request_timeout


class OutputPathAssetReference(AssetReferenceBase):
    """Reference to an asset via its path in a job output.

    All required parameters must be populated in order to send to Azure.

    :ivar reference_type: Required. [Required] Specifies the type of asset reference.Constant
     filled by server. Possible values include: "Id", "DataPath", "OutputPath".
    :vartype reference_type: str or ~azure.mgmt.machinelearningservices.models.ReferenceType
    :ivar job_id: ARM resource ID of the job.
    :vartype job_id: str
    :ivar path: The path of the file/directory in the job output.
    :vartype path: str
    """

    _validation = {
        'reference_type': {'required': True},
    }

    _attribute_map = {
        'reference_type': {'key': 'referenceType', 'type': 'str'},
        'job_id': {'key': 'jobId', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        job_id: Optional[str] = None,
        path: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword job_id: ARM resource ID of the job.
        :paramtype job_id: str
        :keyword path: The path of the file/directory in the job output.
        :paramtype path: str
        """
        super(OutputPathAssetReference, self).__init__(**kwargs)
        self.reference_type = 'OutputPath'  # type: str
        self.job_id = job_id
        self.path = path


class PaginatedComputeResourcesList(msrest.serialization.Model):
    """Paginated list of Machine Learning compute objects wrapped in ARM resource envelope.

    :ivar value: An array of Machine Learning compute objects wrapped in ARM resource envelope.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.ComputeResource]
    :ivar next_link: A continuation link (absolute URI) to the next page of results in the list.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ComputeResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ComputeResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: An array of Machine Learning compute objects wrapped in ARM resource envelope.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.ComputeResource]
        :keyword next_link: A continuation link (absolute URI) to the next page of results in the list.
        :paramtype next_link: str
        """
        super(PaginatedComputeResourcesList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PartialBatchDeployment(msrest.serialization.Model):
    """Mutable batch inference settings per deployment.

    :ivar description: Description of the endpoint deployment.
    :vartype description: str
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword description: Description of the endpoint deployment.
        :paramtype description: str
        """
        super(PartialBatchDeployment, self).__init__(**kwargs)
        self.description = description


class PartialBatchDeploymentPartialMinimalTrackedResourceWithProperties(msrest.serialization.Model):
    """Strictly used in update requests.

    :ivar properties: Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.PartialBatchDeployment
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'PartialBatchDeployment'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        properties: Optional["PartialBatchDeployment"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword properties: Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.PartialBatchDeployment
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        """
        super(PartialBatchDeploymentPartialMinimalTrackedResourceWithProperties, self).__init__(**kwargs)
        self.properties = properties
        self.tags = tags


class PartialManagedServiceIdentity(msrest.serialization.Model):
    """Managed service identity (system assigned and/or user assigned identities).

    :ivar type: Managed service identity (system assigned and/or user assigned identities).
     Possible values include: "None", "SystemAssigned", "UserAssigned",
     "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The set of user assigned identities associated with the
     resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
     The dictionary values can be empty objects ({}) in requests.
    :vartype user_assigned_identities: dict[str, any]
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "ManagedServiceIdentityType"]] = None,
        user_assigned_identities: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        """
        :keyword type: Managed service identity (system assigned and/or user assigned identities).
         Possible values include: "None", "SystemAssigned", "UserAssigned",
         "SystemAssigned,UserAssigned".
        :paramtype type: str or ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentityType
        :keyword user_assigned_identities: The set of user assigned identities associated with the
         resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
         The dictionary values can be empty objects ({}) in requests.
        :paramtype user_assigned_identities: dict[str, any]
        """
        super(PartialManagedServiceIdentity, self).__init__(**kwargs)
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class PartialMinimalTrackedResource(msrest.serialization.Model):
    """Strictly used in update requests.

    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        """
        super(PartialMinimalTrackedResource, self).__init__(**kwargs)
        self.tags = tags


class PartialMinimalTrackedResourceWithIdentity(PartialMinimalTrackedResource):
    """Strictly used in update requests.

    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity: ~azure.mgmt.machinelearningservices.models.PartialManagedServiceIdentity
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'PartialManagedServiceIdentity'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["PartialManagedServiceIdentity"] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword identity: Managed service identity (system assigned and/or user assigned identities).
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.PartialManagedServiceIdentity
        """
        super(PartialMinimalTrackedResourceWithIdentity, self).__init__(tags=tags, **kwargs)
        self.identity = identity


class PartialMinimalTrackedResourceWithSku(PartialMinimalTrackedResource):
    """Strictly used in update requests.

    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: Sku details required for ARM contract for Autoscaling.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.PartialSku
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'PartialSku'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["PartialSku"] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: Sku details required for ARM contract for Autoscaling.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.PartialSku
        """
        super(PartialMinimalTrackedResourceWithSku, self).__init__(tags=tags, **kwargs)
        self.sku = sku


class PartialRegistryPartialTrackedResource(msrest.serialization.Model):
    """Strictly used in update requests.

    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity: ~azure.mgmt.machinelearningservices.models.PartialManagedServiceIdentity
    :ivar kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type.
    :vartype kind: str
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    :ivar properties: Additional attributes of the entity.
    :vartype properties: any
    :ivar sku: Sku details required for ARM contract for Autoscaling.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.PartialSku
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        'identity': {'key': 'identity', 'type': 'PartialManagedServiceIdentity'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'object'},
        'sku': {'key': 'sku', 'type': 'PartialSku'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        identity: Optional["PartialManagedServiceIdentity"] = None,
        kind: Optional[str] = None,
        location: Optional[str] = None,
        properties: Optional[Any] = None,
        sku: Optional["PartialSku"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword identity: Managed service identity (system assigned and/or user assigned identities).
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.PartialManagedServiceIdentity
        :keyword kind: Metadata used by portal/tooling/etc to render different UX experiences for
         resources of the same type.
        :paramtype kind: str
        :keyword location: The geo-location where the resource lives.
        :paramtype location: str
        :keyword properties: Additional attributes of the entity.
        :paramtype properties: any
        :keyword sku: Sku details required for ARM contract for Autoscaling.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.PartialSku
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        """
        super(PartialRegistryPartialTrackedResource, self).__init__(**kwargs)
        self.identity = identity
        self.kind = kind
        self.location = location
        self.properties = properties
        self.sku = sku
        self.tags = tags


class PartialSku(msrest.serialization.Model):
    """Common SKU definition.

    :ivar capacity: If the SKU supports scale out/in then the capacity integer should be included.
     If scale out/in is not possible for the resource this may be omitted.
    :vartype capacity: int
    :ivar family: If the service has different generations of hardware, for the same SKU, then that
     can be captured here.
    :vartype family: str
    :ivar name: The name of the SKU. Ex - P3. It is typically a letter+number code.
    :vartype name: str
    :ivar size: The SKU size. When the name field is the combination of tier and some other value,
     this would be the standalone code.
    :vartype size: str
    :ivar tier: This field is required to be implemented by the Resource Provider if the service
     has more than one tier, but is not required on a PUT. Possible values include: "Free", "Basic",
     "Standard", "Premium".
    :vartype tier: str or ~azure.mgmt.machinelearningservices.models.SkuTier
    """

    _attribute_map = {
        'capacity': {'key': 'capacity', 'type': 'int'},
        'family': {'key': 'family', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'size': {'key': 'size', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        capacity: Optional[int] = None,
        family: Optional[str] = None,
        name: Optional[str] = None,
        size: Optional[str] = None,
        tier: Optional[Union[str, "SkuTier"]] = None,
        **kwargs
    ):
        """
        :keyword capacity: If the SKU supports scale out/in then the capacity integer should be
         included. If scale out/in is not possible for the resource this may be omitted.
        :paramtype capacity: int
        :keyword family: If the service has different generations of hardware, for the same SKU, then
         that can be captured here.
        :paramtype family: str
        :keyword name: The name of the SKU. Ex - P3. It is typically a letter+number code.
        :paramtype name: str
        :keyword size: The SKU size. When the name field is the combination of tier and some other
         value, this would be the standalone code.
        :paramtype size: str
        :keyword tier: This field is required to be implemented by the Resource Provider if the service
         has more than one tier, but is not required on a PUT. Possible values include: "Free", "Basic",
         "Standard", "Premium".
        :paramtype tier: str or ~azure.mgmt.machinelearningservices.models.SkuTier
        """
        super(PartialSku, self).__init__(**kwargs)
        self.capacity = capacity
        self.family = family
        self.name = name
        self.size = size
        self.tier = tier


class Password(msrest.serialization.Model):
    """Password.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name:
    :vartype name: str
    :ivar value:
    :vartype value: str
    """

    _validation = {
        'name': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Password, self).__init__(**kwargs)
        self.name = None
        self.value = None


class PATAuthTypeWorkspaceConnectionProperties(WorkspaceConnectionPropertiesV2):
    """PATAuthTypeWorkspaceConnectionProperties.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Required. Authentication type of the connection target.Constant filled by
     server. Possible values include: "PAT", "ManagedIdentity", "UsernamePassword", "None", "SAS",
     "ServicePrincipal", "AccessKey".
    :vartype auth_type: str or ~azure.mgmt.machinelearningservices.models.ConnectionAuthType
    :ivar category: Category of the connection.
    :vartype category: str
    :ivar target:
    :vartype target: str
    :ivar value: Value details of the workspace connection.
    :vartype value: str
    :ivar value_format: format for the workspace connection value. Possible values include: "JSON".
    :vartype value_format: str or ~azure.mgmt.machinelearningservices.models.ValueFormat
    :ivar credentials:
    :vartype credentials:
     ~azure.mgmt.machinelearningservices.models.WorkspaceConnectionPersonalAccessToken
    """

    _validation = {
        'auth_type': {'required': True},
    }

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'value_format': {'key': 'valueFormat', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'WorkspaceConnectionPersonalAccessToken'},
    }

    def __init__(
        self,
        *,
        category: Optional[str] = None,
        target: Optional[str] = None,
        value: Optional[str] = None,
        value_format: Optional[Union[str, "ValueFormat"]] = None,
        credentials: Optional["WorkspaceConnectionPersonalAccessToken"] = None,
        **kwargs
    ):
        """
        :keyword category: Category of the connection.
        :paramtype category: str
        :keyword target:
        :paramtype target: str
        :keyword value: Value details of the workspace connection.
        :paramtype value: str
        :keyword value_format: format for the workspace connection value. Possible values include:
         "JSON".
        :paramtype value_format: str or ~azure.mgmt.machinelearningservices.models.ValueFormat
        :keyword credentials:
        :paramtype credentials:
         ~azure.mgmt.machinelearningservices.models.WorkspaceConnectionPersonalAccessToken
        """
        super(PATAuthTypeWorkspaceConnectionProperties, self).__init__(category=category, target=target, value=value, value_format=value_format, **kwargs)
        self.auth_type = 'PAT'  # type: str
        self.credentials = credentials


class PersonalComputeInstanceSettings(msrest.serialization.Model):
    """Settings for a personal compute instance.

    :ivar assigned_user: A user explicitly assigned to a personal compute instance.
    :vartype assigned_user: ~azure.mgmt.machinelearningservices.models.AssignedUser
    """

    _attribute_map = {
        'assigned_user': {'key': 'assignedUser', 'type': 'AssignedUser'},
    }

    def __init__(
        self,
        *,
        assigned_user: Optional["AssignedUser"] = None,
        **kwargs
    ):
        """
        :keyword assigned_user: A user explicitly assigned to a personal compute instance.
        :paramtype assigned_user: ~azure.mgmt.machinelearningservices.models.AssignedUser
        """
        super(PersonalComputeInstanceSettings, self).__init__(**kwargs)
        self.assigned_user = assigned_user


class PipelineJob(JobBaseProperties):
    """Pipeline Job definition: defines generic to MFE attributes.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar component_id: ARM resource ID of the component resource.
    :vartype component_id: str
    :ivar compute_id: ARM resource ID of the compute resource.
    :vartype compute_id: str
    :ivar display_name: Display name of job.
    :vartype display_name: str
    :ivar experiment_name: The name of the experiment the job belongs to. If not set, the job is
     placed in the "Default" experiment.
    :vartype experiment_name: str
    :ivar identity: Identity configuration. If set, this should be one of AmlToken,
     ManagedIdentity, UserIdentity or null.
     Defaults to AmlToken if null.
    :vartype identity: ~azure.mgmt.machinelearningservices.models.IdentityConfiguration
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar job_type: Required. [Required] Specifies the type of job.Constant filled by server.
     Possible values include: "AutoML", "Command", "Labeling", "Sweep", "Pipeline", "Spark".
    :vartype job_type: str or ~azure.mgmt.machinelearningservices.models.JobType
    :ivar services: List of JobEndpoints.
     For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
    :vartype services: dict[str, ~azure.mgmt.machinelearningservices.models.JobService]
    :ivar status: Status of the job. Possible values include: "NotStarted", "Starting",
     "Provisioning", "Preparing", "Queued", "Running", "Finalizing", "CancelRequested", "Completed",
     "Failed", "Canceled", "NotResponding", "Paused", "Unknown", "Scheduled".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.JobStatus
    :ivar inputs: Inputs for the pipeline job.
    :vartype inputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobInput]
    :ivar jobs: Jobs construct the Pipeline Job.
    :vartype jobs: dict[str, any]
    :ivar outputs: Outputs for the pipeline job.
    :vartype outputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobOutput]
    :ivar settings: Pipeline settings, for things like ContinueRunOnStepFailure etc.
    :vartype settings: any
    :ivar source_job_id: ARM resource ID of source job.
    :vartype source_job_id: str
    """

    _validation = {
        'job_type': {'required': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'component_id': {'key': 'componentId', 'type': 'str'},
        'compute_id': {'key': 'computeId', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'experiment_name': {'key': 'experimentName', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'IdentityConfiguration'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'job_type': {'key': 'jobType', 'type': 'str'},
        'services': {'key': 'services', 'type': '{JobService}'},
        'status': {'key': 'status', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '{JobInput}'},
        'jobs': {'key': 'jobs', 'type': '{object}'},
        'outputs': {'key': 'outputs', 'type': '{JobOutput}'},
        'settings': {'key': 'settings', 'type': 'object'},
        'source_job_id': {'key': 'sourceJobId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        component_id: Optional[str] = None,
        compute_id: Optional[str] = None,
        display_name: Optional[str] = None,
        experiment_name: Optional[str] = "Default",
        identity: Optional["IdentityConfiguration"] = None,
        is_archived: Optional[bool] = False,
        services: Optional[Dict[str, "JobService"]] = None,
        inputs: Optional[Dict[str, "JobInput"]] = None,
        jobs: Optional[Dict[str, Any]] = None,
        outputs: Optional[Dict[str, "JobOutput"]] = None,
        settings: Optional[Any] = None,
        source_job_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword component_id: ARM resource ID of the component resource.
        :paramtype component_id: str
        :keyword compute_id: ARM resource ID of the compute resource.
        :paramtype compute_id: str
        :keyword display_name: Display name of job.
        :paramtype display_name: str
        :keyword experiment_name: The name of the experiment the job belongs to. If not set, the job is
         placed in the "Default" experiment.
        :paramtype experiment_name: str
        :keyword identity: Identity configuration. If set, this should be one of AmlToken,
         ManagedIdentity, UserIdentity or null.
         Defaults to AmlToken if null.
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.IdentityConfiguration
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword services: List of JobEndpoints.
         For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        :paramtype services: dict[str, ~azure.mgmt.machinelearningservices.models.JobService]
        :keyword inputs: Inputs for the pipeline job.
        :paramtype inputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobInput]
        :keyword jobs: Jobs construct the Pipeline Job.
        :paramtype jobs: dict[str, any]
        :keyword outputs: Outputs for the pipeline job.
        :paramtype outputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobOutput]
        :keyword settings: Pipeline settings, for things like ContinueRunOnStepFailure etc.
        :paramtype settings: any
        :keyword source_job_id: ARM resource ID of source job.
        :paramtype source_job_id: str
        """
        super(PipelineJob, self).__init__(description=description, properties=properties, tags=tags, component_id=component_id, compute_id=compute_id, display_name=display_name, experiment_name=experiment_name, identity=identity, is_archived=is_archived, services=services, **kwargs)
        self.job_type = 'Pipeline'  # type: str
        self.inputs = inputs
        self.jobs = jobs
        self.outputs = outputs
        self.settings = settings
        self.source_job_id = source_job_id


class PrivateEndpoint(msrest.serialization.Model):
    """The Private Endpoint resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ARM identifier for Private Endpoint.
    :vartype id: str
    :ivar subnet_arm_id: The ARM identifier for Subnet resource that private endpoint links to.
    :vartype subnet_arm_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'subnet_arm_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'subnet_arm_id': {'key': 'subnetArmId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(PrivateEndpoint, self).__init__(**kwargs)
        self.id = None
        self.subnet_arm_id = None


class PrivateEndpointConnection(Resource):
    """The Private Endpoint Connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
    :ivar location: Specifies the location of the resource.
    :vartype location: str
    :ivar tags: A set of tags. Contains resource tags defined as key/value pairs.
    :vartype tags: dict[str, str]
    :ivar sku: The sku of the workspace.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.Sku
    :ivar private_endpoint: The resource of private end point.
    :vartype private_endpoint: ~azure.mgmt.machinelearningservices.models.PrivateEndpoint
    :ivar private_link_service_connection_state: A collection of information about the state of the
     connection between service consumer and provider.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.machinelearningservices.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: The provisioning state of the private endpoint connection resource.
     Possible values include: "Succeeded", "Creating", "Deleting", "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.PrivateEndpointConnectionProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpoint'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionState'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        identity: Optional["ManagedServiceIdentity"] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        private_endpoint: Optional["PrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["PrivateLinkServiceConnectionState"] = None,
        **kwargs
    ):
        """
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
        :keyword location: Specifies the location of the resource.
        :paramtype location: str
        :keyword tags: A set of tags. Contains resource tags defined as key/value pairs.
        :paramtype tags: dict[str, str]
        :keyword sku: The sku of the workspace.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.Sku
        :keyword private_endpoint: The resource of private end point.
        :paramtype private_endpoint: ~azure.mgmt.machinelearningservices.models.PrivateEndpoint
        :keyword private_link_service_connection_state: A collection of information about the state of
         the connection between service consumer and provider.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.machinelearningservices.models.PrivateLinkServiceConnectionState
        """
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.identity = identity
        self.location = location
        self.tags = tags
        self.sku = sku
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = None


class PrivateEndpointConnectionListResult(msrest.serialization.Model):
    """List of private endpoint connection associated with the specified workspace.

    :ivar value: Array of private endpoint connections.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.PrivateEndpointConnection]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateEndpointConnection]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["PrivateEndpointConnection"]] = None,
        **kwargs
    ):
        """
        :keyword value: Array of private endpoint connections.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.PrivateEndpointConnection]
        """
        super(PrivateEndpointConnectionListResult, self).__init__(**kwargs)
        self.value = value


class PrivateLinkResource(Resource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
    :ivar location: Specifies the location of the resource.
    :vartype location: str
    :ivar tags: A set of tags. Contains resource tags defined as key/value pairs.
    :vartype tags: dict[str, str]
    :ivar sku: The sku of the workspace.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.Sku
    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :ivar required_zone_names: The private link resource Private link DNS zone name.
    :vartype required_zone_names: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'group_id': {'readonly': True},
        'required_members': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'group_id': {'key': 'properties.groupId', 'type': 'str'},
        'required_members': {'key': 'properties.requiredMembers', 'type': '[str]'},
        'required_zone_names': {'key': 'properties.requiredZoneNames', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        identity: Optional["ManagedServiceIdentity"] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        required_zone_names: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
        :keyword location: Specifies the location of the resource.
        :paramtype location: str
        :keyword tags: A set of tags. Contains resource tags defined as key/value pairs.
        :paramtype tags: dict[str, str]
        :keyword sku: The sku of the workspace.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.Sku
        :keyword required_zone_names: The private link resource Private link DNS zone name.
        :paramtype required_zone_names: list[str]
        """
        super(PrivateLinkResource, self).__init__(**kwargs)
        self.identity = identity
        self.location = location
        self.tags = tags
        self.sku = sku
        self.group_id = None
        self.required_members = None
        self.required_zone_names = required_zone_names


class PrivateLinkResourceListResult(msrest.serialization.Model):
    """A list of private link resources.

    :ivar value: Array of private link resources.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.PrivateLinkResource]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateLinkResource]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["PrivateLinkResource"]] = None,
        **kwargs
    ):
        """
        :keyword value: Array of private link resources.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.PrivateLinkResource]
        """
        super(PrivateLinkResourceListResult, self).__init__(**kwargs)
        self.value = value


class PrivateLinkServiceConnectionState(msrest.serialization.Model):
    """A collection of information about the state of the connection between service consumer and provider.

    :ivar status: Indicates whether the connection has been Approved/Rejected/Removed by the owner
     of the service. Possible values include: "Pending", "Approved", "Rejected", "Disconnected",
     "Timeout".
    :vartype status: str or
     ~azure.mgmt.machinelearningservices.models.PrivateEndpointServiceConnectionStatus
    :ivar description: The reason for approval/rejection of the connection.
    :vartype description: str
    :ivar actions_required: A message indicating if changes on the service provider require any
     updates on the consumer.
    :vartype actions_required: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "PrivateEndpointServiceConnectionStatus"]] = None,
        description: Optional[str] = None,
        actions_required: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword status: Indicates whether the connection has been Approved/Rejected/Removed by the
         owner of the service. Possible values include: "Pending", "Approved", "Rejected",
         "Disconnected", "Timeout".
        :paramtype status: str or
         ~azure.mgmt.machinelearningservices.models.PrivateEndpointServiceConnectionStatus
        :keyword description: The reason for approval/rejection of the connection.
        :paramtype description: str
        :keyword actions_required: A message indicating if changes on the service provider require any
         updates on the consumer.
        :paramtype actions_required: str
        """
        super(PrivateLinkServiceConnectionState, self).__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class ProbeSettings(msrest.serialization.Model):
    """Deployment container liveness/readiness probe configuration.

    :ivar failure_threshold: The number of failures to allow before returning an unhealthy status.
    :vartype failure_threshold: int
    :ivar initial_delay: The delay before the first probe in ISO 8601 format.
    :vartype initial_delay: ~datetime.timedelta
    :ivar period: The length of time between probes in ISO 8601 format.
    :vartype period: ~datetime.timedelta
    :ivar success_threshold: The number of successful probes before returning a healthy status.
    :vartype success_threshold: int
    :ivar timeout: The probe timeout in ISO 8601 format.
    :vartype timeout: ~datetime.timedelta
    """

    _attribute_map = {
        'failure_threshold': {'key': 'failureThreshold', 'type': 'int'},
        'initial_delay': {'key': 'initialDelay', 'type': 'duration'},
        'period': {'key': 'period', 'type': 'duration'},
        'success_threshold': {'key': 'successThreshold', 'type': 'int'},
        'timeout': {'key': 'timeout', 'type': 'duration'},
    }

    def __init__(
        self,
        *,
        failure_threshold: Optional[int] = 30,
        initial_delay: Optional[datetime.timedelta] = None,
        period: Optional[datetime.timedelta] = "PT10S",
        success_threshold: Optional[int] = 1,
        timeout: Optional[datetime.timedelta] = "PT2S",
        **kwargs
    ):
        """
        :keyword failure_threshold: The number of failures to allow before returning an unhealthy
         status.
        :paramtype failure_threshold: int
        :keyword initial_delay: The delay before the first probe in ISO 8601 format.
        :paramtype initial_delay: ~datetime.timedelta
        :keyword period: The length of time between probes in ISO 8601 format.
        :paramtype period: ~datetime.timedelta
        :keyword success_threshold: The number of successful probes before returning a healthy status.
        :paramtype success_threshold: int
        :keyword timeout: The probe timeout in ISO 8601 format.
        :paramtype timeout: ~datetime.timedelta
        """
        super(ProbeSettings, self).__init__(**kwargs)
        self.failure_threshold = failure_threshold
        self.initial_delay = initial_delay
        self.period = period
        self.success_threshold = success_threshold
        self.timeout = timeout


class ProgressMetrics(msrest.serialization.Model):
    """Progress metrics definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar completed_datapoint_count: The completed datapoint count.
    :vartype completed_datapoint_count: long
    :ivar incremental_data_last_refresh_date_time: The time of last successful incremental data
     refresh in UTC.
    :vartype incremental_data_last_refresh_date_time: ~datetime.datetime
    :ivar skipped_datapoint_count: The skipped datapoint count.
    :vartype skipped_datapoint_count: long
    :ivar total_datapoint_count: The total datapoint count.
    :vartype total_datapoint_count: long
    """

    _validation = {
        'completed_datapoint_count': {'readonly': True},
        'incremental_data_last_refresh_date_time': {'readonly': True},
        'skipped_datapoint_count': {'readonly': True},
        'total_datapoint_count': {'readonly': True},
    }

    _attribute_map = {
        'completed_datapoint_count': {'key': 'completedDatapointCount', 'type': 'long'},
        'incremental_data_last_refresh_date_time': {'key': 'incrementalDataLastRefreshDateTime', 'type': 'iso-8601'},
        'skipped_datapoint_count': {'key': 'skippedDatapointCount', 'type': 'long'},
        'total_datapoint_count': {'key': 'totalDatapointCount', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ProgressMetrics, self).__init__(**kwargs)
        self.completed_datapoint_count = None
        self.incremental_data_last_refresh_date_time = None
        self.skipped_datapoint_count = None
        self.total_datapoint_count = None


class PyTorch(DistributionConfiguration):
    """PyTorch distribution configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar distribution_type: Required. [Required] Specifies the type of distribution
     framework.Constant filled by server. Possible values include: "PyTorch", "TensorFlow", "Mpi".
    :vartype distribution_type: str or ~azure.mgmt.machinelearningservices.models.DistributionType
    :ivar process_count_per_instance: Number of processes per node.
    :vartype process_count_per_instance: int
    """

    _validation = {
        'distribution_type': {'required': True},
    }

    _attribute_map = {
        'distribution_type': {'key': 'distributionType', 'type': 'str'},
        'process_count_per_instance': {'key': 'processCountPerInstance', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        process_count_per_instance: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword process_count_per_instance: Number of processes per node.
        :paramtype process_count_per_instance: int
        """
        super(PyTorch, self).__init__(**kwargs)
        self.distribution_type = 'PyTorch'  # type: str
        self.process_count_per_instance = process_count_per_instance


class QuotaBaseProperties(msrest.serialization.Model):
    """The properties for Quota update or retrieval.

    :ivar id: Specifies the resource ID.
    :vartype id: str
    :ivar type: Specifies the resource type.
    :vartype type: str
    :ivar limit: The maximum permitted quota of the resource.
    :vartype limit: long
    :ivar unit: An enum describing the unit of quota measurement. Possible values include: "Count".
    :vartype unit: str or ~azure.mgmt.machinelearningservices.models.QuotaUnit
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'limit': {'key': 'limit', 'type': 'long'},
        'unit': {'key': 'unit', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        type: Optional[str] = None,
        limit: Optional[int] = None,
        unit: Optional[Union[str, "QuotaUnit"]] = None,
        **kwargs
    ):
        """
        :keyword id: Specifies the resource ID.
        :paramtype id: str
        :keyword type: Specifies the resource type.
        :paramtype type: str
        :keyword limit: The maximum permitted quota of the resource.
        :paramtype limit: long
        :keyword unit: An enum describing the unit of quota measurement. Possible values include:
         "Count".
        :paramtype unit: str or ~azure.mgmt.machinelearningservices.models.QuotaUnit
        """
        super(QuotaBaseProperties, self).__init__(**kwargs)
        self.id = id
        self.type = type
        self.limit = limit
        self.unit = unit


class QuotaUpdateParameters(msrest.serialization.Model):
    """Quota update parameters.

    :ivar value: The list for update quota.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.QuotaBaseProperties]
    :ivar location: Region of workspace quota to be updated.
    :vartype location: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[QuotaBaseProperties]'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["QuotaBaseProperties"]] = None,
        location: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The list for update quota.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.QuotaBaseProperties]
        :keyword location: Region of workspace quota to be updated.
        :paramtype location: str
        """
        super(QuotaUpdateParameters, self).__init__(**kwargs)
        self.value = value
        self.location = location


class RandomSamplingAlgorithm(SamplingAlgorithm):
    """Defines a Sampling Algorithm that generates values randomly.

    All required parameters must be populated in order to send to Azure.

    :ivar sampling_algorithm_type: Required. [Required] The algorithm used for generating
     hyperparameter values, along with configuration properties.Constant filled by server. Possible
     values include: "Grid", "Random", "Bayesian".
    :vartype sampling_algorithm_type: str or
     ~azure.mgmt.machinelearningservices.models.SamplingAlgorithmType
    :ivar rule: The specific type of random algorithm. Possible values include: "Random", "Sobol".
    :vartype rule: str or ~azure.mgmt.machinelearningservices.models.RandomSamplingAlgorithmRule
    :ivar seed: An optional integer to use as the seed for random number generation.
    :vartype seed: int
    """

    _validation = {
        'sampling_algorithm_type': {'required': True},
    }

    _attribute_map = {
        'sampling_algorithm_type': {'key': 'samplingAlgorithmType', 'type': 'str'},
        'rule': {'key': 'rule', 'type': 'str'},
        'seed': {'key': 'seed', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        rule: Optional[Union[str, "RandomSamplingAlgorithmRule"]] = None,
        seed: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword rule: The specific type of random algorithm. Possible values include: "Random",
         "Sobol".
        :paramtype rule: str or ~azure.mgmt.machinelearningservices.models.RandomSamplingAlgorithmRule
        :keyword seed: An optional integer to use as the seed for random number generation.
        :paramtype seed: int
        """
        super(RandomSamplingAlgorithm, self).__init__(**kwargs)
        self.sampling_algorithm_type = 'Random'  # type: str
        self.rule = rule
        self.seed = seed


class Recurrence(msrest.serialization.Model):
    """The workflow trigger recurrence for ComputeStartStop schedule type.

    :ivar frequency: [Required] The frequency to trigger schedule. Possible values include:
     "Minute", "Hour", "Day", "Week", "Month".
    :vartype frequency: str or ~azure.mgmt.machinelearningservices.models.RecurrenceFrequency
    :ivar interval: [Required] Specifies schedule interval in conjunction with frequency.
    :vartype interval: int
    :ivar start_time: The start time in yyyy-MM-ddTHH:mm:ss format.
    :vartype start_time: str
    :ivar time_zone: Specifies time zone in which the schedule runs.
     TimeZone should follow Windows time zone format. Refer:
     https://learn.microsoft.com/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11.
    :vartype time_zone: str
    :ivar schedule: [Required] The recurrence schedule.
    :vartype schedule: ~azure.mgmt.machinelearningservices.models.RecurrenceSchedule
    """

    _attribute_map = {
        'frequency': {'key': 'frequency', 'type': 'str'},
        'interval': {'key': 'interval', 'type': 'int'},
        'start_time': {'key': 'startTime', 'type': 'str'},
        'time_zone': {'key': 'timeZone', 'type': 'str'},
        'schedule': {'key': 'schedule', 'type': 'RecurrenceSchedule'},
    }

    def __init__(
        self,
        *,
        frequency: Optional[Union[str, "RecurrenceFrequency"]] = None,
        interval: Optional[int] = None,
        start_time: Optional[str] = None,
        time_zone: Optional[str] = "UTC",
        schedule: Optional["RecurrenceSchedule"] = None,
        **kwargs
    ):
        """
        :keyword frequency: [Required] The frequency to trigger schedule. Possible values include:
         "Minute", "Hour", "Day", "Week", "Month".
        :paramtype frequency: str or ~azure.mgmt.machinelearningservices.models.RecurrenceFrequency
        :keyword interval: [Required] Specifies schedule interval in conjunction with frequency.
        :paramtype interval: int
        :keyword start_time: The start time in yyyy-MM-ddTHH:mm:ss format.
        :paramtype start_time: str
        :keyword time_zone: Specifies time zone in which the schedule runs.
         TimeZone should follow Windows time zone format. Refer:
         https://learn.microsoft.com/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11.
        :paramtype time_zone: str
        :keyword schedule: [Required] The recurrence schedule.
        :paramtype schedule: ~azure.mgmt.machinelearningservices.models.RecurrenceSchedule
        """
        super(Recurrence, self).__init__(**kwargs)
        self.frequency = frequency
        self.interval = interval
        self.start_time = start_time
        self.time_zone = time_zone
        self.schedule = schedule


class RecurrenceSchedule(msrest.serialization.Model):
    """RecurrenceSchedule.

    All required parameters must be populated in order to send to Azure.

    :ivar hours: Required. [Required] List of hours for the schedule.
    :vartype hours: list[int]
    :ivar minutes: Required. [Required] List of minutes for the schedule.
    :vartype minutes: list[int]
    :ivar month_days: List of month days for the schedule.
    :vartype month_days: list[int]
    :ivar week_days: List of days for the schedule.
    :vartype week_days: list[str or ~azure.mgmt.machinelearningservices.models.WeekDay]
    """

    _validation = {
        'hours': {'required': True},
        'minutes': {'required': True},
    }

    _attribute_map = {
        'hours': {'key': 'hours', 'type': '[int]'},
        'minutes': {'key': 'minutes', 'type': '[int]'},
        'month_days': {'key': 'monthDays', 'type': '[int]'},
        'week_days': {'key': 'weekDays', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        hours: List[int],
        minutes: List[int],
        month_days: Optional[List[int]] = None,
        week_days: Optional[List[Union[str, "WeekDay"]]] = None,
        **kwargs
    ):
        """
        :keyword hours: Required. [Required] List of hours for the schedule.
        :paramtype hours: list[int]
        :keyword minutes: Required. [Required] List of minutes for the schedule.
        :paramtype minutes: list[int]
        :keyword month_days: List of month days for the schedule.
        :paramtype month_days: list[int]
        :keyword week_days: List of days for the schedule.
        :paramtype week_days: list[str or ~azure.mgmt.machinelearningservices.models.WeekDay]
        """
        super(RecurrenceSchedule, self).__init__(**kwargs)
        self.hours = hours
        self.minutes = minutes
        self.month_days = month_days
        self.week_days = week_days


class RecurrenceTrigger(TriggerBase):
    """RecurrenceTrigger.

    All required parameters must be populated in order to send to Azure.

    :ivar end_time: Specifies end time of schedule in ISO 8601, but without a UTC offset. Refer
     https://en.wikipedia.org/wiki/ISO_8601.
     Recommented format would be "2022-06-01T00:00:01"
     If not present, the schedule will run indefinitely.
    :vartype end_time: str
    :ivar start_time: Specifies start time of schedule in ISO 8601 format, but without a UTC
     offset.
    :vartype start_time: str
    :ivar time_zone: Specifies time zone in which the schedule runs.
     TimeZone should follow Windows time zone format. Refer:
     https://learn.microsoft.com/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11.
    :vartype time_zone: str
    :ivar trigger_type: Required. [Required].Constant filled by server. Possible values include:
     "Recurrence", "Cron".
    :vartype trigger_type: str or ~azure.mgmt.machinelearningservices.models.TriggerType
    :ivar frequency: Required. [Required] The frequency to trigger schedule. Possible values
     include: "Minute", "Hour", "Day", "Week", "Month".
    :vartype frequency: str or ~azure.mgmt.machinelearningservices.models.RecurrenceFrequency
    :ivar interval: Required. [Required] Specifies schedule interval in conjunction with frequency.
    :vartype interval: int
    :ivar schedule: The recurrence schedule.
    :vartype schedule: ~azure.mgmt.machinelearningservices.models.RecurrenceSchedule
    """

    _validation = {
        'trigger_type': {'required': True},
        'frequency': {'required': True},
        'interval': {'required': True},
    }

    _attribute_map = {
        'end_time': {'key': 'endTime', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'str'},
        'time_zone': {'key': 'timeZone', 'type': 'str'},
        'trigger_type': {'key': 'triggerType', 'type': 'str'},
        'frequency': {'key': 'frequency', 'type': 'str'},
        'interval': {'key': 'interval', 'type': 'int'},
        'schedule': {'key': 'schedule', 'type': 'RecurrenceSchedule'},
    }

    def __init__(
        self,
        *,
        frequency: Union[str, "RecurrenceFrequency"],
        interval: int,
        end_time: Optional[str] = None,
        start_time: Optional[str] = None,
        time_zone: Optional[str] = "UTC",
        schedule: Optional["RecurrenceSchedule"] = None,
        **kwargs
    ):
        """
        :keyword end_time: Specifies end time of schedule in ISO 8601, but without a UTC offset. Refer
         https://en.wikipedia.org/wiki/ISO_8601.
         Recommented format would be "2022-06-01T00:00:01"
         If not present, the schedule will run indefinitely.
        :paramtype end_time: str
        :keyword start_time: Specifies start time of schedule in ISO 8601 format, but without a UTC
         offset.
        :paramtype start_time: str
        :keyword time_zone: Specifies time zone in which the schedule runs.
         TimeZone should follow Windows time zone format. Refer:
         https://learn.microsoft.com/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11.
        :paramtype time_zone: str
        :keyword frequency: Required. [Required] The frequency to trigger schedule. Possible values
         include: "Minute", "Hour", "Day", "Week", "Month".
        :paramtype frequency: str or ~azure.mgmt.machinelearningservices.models.RecurrenceFrequency
        :keyword interval: Required. [Required] Specifies schedule interval in conjunction with
         frequency.
        :paramtype interval: int
        :keyword schedule: The recurrence schedule.
        :paramtype schedule: ~azure.mgmt.machinelearningservices.models.RecurrenceSchedule
        """
        super(RecurrenceTrigger, self).__init__(end_time=end_time, start_time=start_time, time_zone=time_zone, **kwargs)
        self.trigger_type = 'Recurrence'  # type: str
        self.frequency = frequency
        self.interval = interval
        self.schedule = schedule


class RegenerateEndpointKeysRequest(msrest.serialization.Model):
    """RegenerateEndpointKeysRequest.

    All required parameters must be populated in order to send to Azure.

    :ivar key_type: Required. [Required] Specification for which type of key to generate. Primary
     or Secondary. Possible values include: "Primary", "Secondary".
    :vartype key_type: str or ~azure.mgmt.machinelearningservices.models.KeyType
    :ivar key_value: The value the key is set to.
    :vartype key_value: str
    """

    _validation = {
        'key_type': {'required': True},
    }

    _attribute_map = {
        'key_type': {'key': 'keyType', 'type': 'str'},
        'key_value': {'key': 'keyValue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_type: Union[str, "KeyType"],
        key_value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword key_type: Required. [Required] Specification for which type of key to generate.
         Primary or Secondary. Possible values include: "Primary", "Secondary".
        :paramtype key_type: str or ~azure.mgmt.machinelearningservices.models.KeyType
        :keyword key_value: The value the key is set to.
        :paramtype key_value: str
        """
        super(RegenerateEndpointKeysRequest, self).__init__(**kwargs)
        self.key_type = key_type
        self.key_value = key_value


class Registry(TrackedResource):
    """Registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
    :ivar kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type.
    :vartype kind: str
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.RegistryProperties
    :ivar sku: Sku details required for ARM contract for Autoscaling.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.Sku
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'kind': {'key': 'kind', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'RegistryProperties'},
        'sku': {'key': 'sku', 'type': 'Sku'},
    }

    def __init__(
        self,
        *,
        location: str,
        properties: "RegistryProperties",
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["ManagedServiceIdentity"] = None,
        kind: Optional[str] = None,
        sku: Optional["Sku"] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword identity: Managed service identity (system assigned and/or user assigned identities).
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
        :keyword kind: Metadata used by portal/tooling/etc to render different UX experiences for
         resources of the same type.
        :paramtype kind: str
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.RegistryProperties
        :keyword sku: Sku details required for ARM contract for Autoscaling.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.Sku
        """
        super(Registry, self).__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.kind = kind
        self.properties = properties
        self.sku = sku


class RegistryListCredentialsResult(msrest.serialization.Model):
    """RegistryListCredentialsResult.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location:
    :vartype location: str
    :ivar username:
    :vartype username: str
    :ivar passwords:
    :vartype passwords: list[~azure.mgmt.machinelearningservices.models.Password]
    """

    _validation = {
        'location': {'readonly': True},
        'username': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'username': {'key': 'username', 'type': 'str'},
        'passwords': {'key': 'passwords', 'type': '[Password]'},
    }

    def __init__(
        self,
        *,
        passwords: Optional[List["Password"]] = None,
        **kwargs
    ):
        """
        :keyword passwords:
        :paramtype passwords: list[~azure.mgmt.machinelearningservices.models.Password]
        """
        super(RegistryListCredentialsResult, self).__init__(**kwargs)
        self.location = None
        self.username = None
        self.passwords = passwords


class RegistryProperties(ResourceBase):
    """Details of the Registry.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar public_network_access:
    :vartype public_network_access: str
    :ivar discovery_url:
    :vartype discovery_url: str
    :ivar intellectual_property_publisher:
    :vartype intellectual_property_publisher: str
    :ivar managed_resource_group: Managed resource group created for the registry.
    :vartype managed_resource_group: ~azure.mgmt.machinelearningservices.models.ArmResourceId
    :ivar ml_flow_registry_uri:
    :vartype ml_flow_registry_uri: str
    :ivar private_link_count:
    :vartype private_link_count: int
    :ivar region_details: Details of each region the registry is in.
    :vartype region_details:
     list[~azure.mgmt.machinelearningservices.models.RegistryRegionArmDetails]
    :ivar managed_resource_group_tags: Tags to be applied to the managed resource group associated
     with this registry.
    :vartype managed_resource_group_tags: dict[str, str]
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
        'discovery_url': {'key': 'discoveryUrl', 'type': 'str'},
        'intellectual_property_publisher': {'key': 'intellectualPropertyPublisher', 'type': 'str'},
        'managed_resource_group': {'key': 'managedResourceGroup', 'type': 'ArmResourceId'},
        'ml_flow_registry_uri': {'key': 'mlFlowRegistryUri', 'type': 'str'},
        'private_link_count': {'key': 'privateLinkCount', 'type': 'int'},
        'region_details': {'key': 'regionDetails', 'type': '[RegistryRegionArmDetails]'},
        'managed_resource_group_tags': {'key': 'managedResourceGroupTags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        public_network_access: Optional[str] = None,
        discovery_url: Optional[str] = None,
        intellectual_property_publisher: Optional[str] = None,
        managed_resource_group: Optional["ArmResourceId"] = None,
        ml_flow_registry_uri: Optional[str] = None,
        private_link_count: Optional[int] = None,
        region_details: Optional[List["RegistryRegionArmDetails"]] = None,
        managed_resource_group_tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword public_network_access:
        :paramtype public_network_access: str
        :keyword discovery_url:
        :paramtype discovery_url: str
        :keyword intellectual_property_publisher:
        :paramtype intellectual_property_publisher: str
        :keyword managed_resource_group: Managed resource group created for the registry.
        :paramtype managed_resource_group: ~azure.mgmt.machinelearningservices.models.ArmResourceId
        :keyword ml_flow_registry_uri:
        :paramtype ml_flow_registry_uri: str
        :keyword private_link_count:
        :paramtype private_link_count: int
        :keyword region_details: Details of each region the registry is in.
        :paramtype region_details:
         list[~azure.mgmt.machinelearningservices.models.RegistryRegionArmDetails]
        :keyword managed_resource_group_tags: Tags to be applied to the managed resource group
         associated with this registry.
        :paramtype managed_resource_group_tags: dict[str, str]
        """
        super(RegistryProperties, self).__init__(description=description, properties=properties, tags=tags, **kwargs)
        self.public_network_access = public_network_access
        self.discovery_url = discovery_url
        self.intellectual_property_publisher = intellectual_property_publisher
        self.managed_resource_group = managed_resource_group
        self.ml_flow_registry_uri = ml_flow_registry_uri
        self.private_link_count = private_link_count
        self.region_details = region_details
        self.managed_resource_group_tags = managed_resource_group_tags


class RegistryRegionArmDetails(msrest.serialization.Model):
    """Details for each region the registry is in.

    :ivar acr_details: List of ACR accounts.
    :vartype acr_details: list[~azure.mgmt.machinelearningservices.models.AcrDetails]
    :ivar location: The location where the registry exists.
    :vartype location: str
    :ivar storage_account_details: List of storage accounts.
    :vartype storage_account_details:
     list[~azure.mgmt.machinelearningservices.models.StorageAccountDetails]
    """

    _attribute_map = {
        'acr_details': {'key': 'acrDetails', 'type': '[AcrDetails]'},
        'location': {'key': 'location', 'type': 'str'},
        'storage_account_details': {'key': 'storageAccountDetails', 'type': '[StorageAccountDetails]'},
    }

    def __init__(
        self,
        *,
        acr_details: Optional[List["AcrDetails"]] = None,
        location: Optional[str] = None,
        storage_account_details: Optional[List["StorageAccountDetails"]] = None,
        **kwargs
    ):
        """
        :keyword acr_details: List of ACR accounts.
        :paramtype acr_details: list[~azure.mgmt.machinelearningservices.models.AcrDetails]
        :keyword location: The location where the registry exists.
        :paramtype location: str
        :keyword storage_account_details: List of storage accounts.
        :paramtype storage_account_details:
         list[~azure.mgmt.machinelearningservices.models.StorageAccountDetails]
        """
        super(RegistryRegionArmDetails, self).__init__(**kwargs)
        self.acr_details = acr_details
        self.location = location
        self.storage_account_details = storage_account_details


class RegistryTrackedResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of Registry entities.

    :ivar next_link: The link to the next page of Registry objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type Registry.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.Registry]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[Registry]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["Registry"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of Registry objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type Registry.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.Registry]
        """
        super(RegistryTrackedResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class Regression(AutoMLVertical, TableVertical):
    """Regression task in AutoML Table vertical.

    All required parameters must be populated in order to send to Azure.

    :ivar cv_split_column_names: Columns to use for CVSplit data.
    :vartype cv_split_column_names: list[str]
    :ivar featurization_settings: Featurization inputs needed for AutoML job.
    :vartype featurization_settings:
     ~azure.mgmt.machinelearningservices.models.TableVerticalFeaturizationSettings
    :ivar fixed_parameters: Model/training parameters that will remain constant throughout
     training.
    :vartype fixed_parameters: ~azure.mgmt.machinelearningservices.models.TableFixedParameters
    :ivar limit_settings: Execution constraints for AutoMLJob.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.TableVerticalLimitSettings
    :ivar n_cross_validations: Number of cross validation folds to be applied on training dataset
     when validation dataset is not provided.
    :vartype n_cross_validations: ~azure.mgmt.machinelearningservices.models.NCrossValidations
    :ivar search_space: Search space for sampling different combinations of models and their
     hyperparameters.
    :vartype search_space: list[~azure.mgmt.machinelearningservices.models.TableParameterSubspace]
    :ivar sweep_settings: Settings for model sweeping and hyperparameter tuning.
    :vartype sweep_settings: ~azure.mgmt.machinelearningservices.models.TableSweepSettings
    :ivar test_data: Test data input.
    :vartype test_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar test_data_size: The fraction of test dataset that needs to be set aside for validation
     purpose.
     Values between (0.0 , 1.0)
     Applied when validation dataset is not provided.
    :vartype test_data_size: float
    :ivar validation_data: Validation data inputs.
    :vartype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar validation_data_size: The fraction of training dataset that needs to be set aside for
     validation purpose.
     Values between (0.0 , 1.0)
     Applied when validation dataset is not provided.
    :vartype validation_data_size: float
    :ivar weight_column_name: The name of the sample weight column. Automated ML supports a
     weighted column as an input, causing rows in the data to be weighted up or down.
    :vartype weight_column_name: str
    :ivar log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
     "Info", "Warning", "Error", "Critical".
    :vartype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
    :ivar target_column_name: Target column name: This is prediction values column.
     Also known as label column name in context of classification tasks.
    :vartype target_column_name: str
    :ivar task_type: Required. [Required] Task type for AutoMLJob.Constant filled by server.
     Possible values include: "Classification", "Regression", "Forecasting", "ImageClassification",
     "ImageClassificationMultilabel", "ImageObjectDetection", "ImageInstanceSegmentation",
     "TextClassification", "TextClassificationMultilabel", "TextNER".
    :vartype task_type: str or ~azure.mgmt.machinelearningservices.models.TaskType
    :ivar training_data: Required. [Required] Training data input.
    :vartype training_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar primary_metric: Primary metric for regression task. Possible values include:
     "SpearmanCorrelation", "NormalizedRootMeanSquaredError", "R2Score",
     "NormalizedMeanAbsoluteError".
    :vartype primary_metric: str or
     ~azure.mgmt.machinelearningservices.models.RegressionPrimaryMetrics
    :ivar training_settings: Inputs for training phase for an AutoML Job.
    :vartype training_settings:
     ~azure.mgmt.machinelearningservices.models.RegressionTrainingSettings
    """

    _validation = {
        'task_type': {'required': True},
        'training_data': {'required': True},
    }

    _attribute_map = {
        'cv_split_column_names': {'key': 'cvSplitColumnNames', 'type': '[str]'},
        'featurization_settings': {'key': 'featurizationSettings', 'type': 'TableVerticalFeaturizationSettings'},
        'fixed_parameters': {'key': 'fixedParameters', 'type': 'TableFixedParameters'},
        'limit_settings': {'key': 'limitSettings', 'type': 'TableVerticalLimitSettings'},
        'n_cross_validations': {'key': 'nCrossValidations', 'type': 'NCrossValidations'},
        'search_space': {'key': 'searchSpace', 'type': '[TableParameterSubspace]'},
        'sweep_settings': {'key': 'sweepSettings', 'type': 'TableSweepSettings'},
        'test_data': {'key': 'testData', 'type': 'MLTableJobInput'},
        'test_data_size': {'key': 'testDataSize', 'type': 'float'},
        'validation_data': {'key': 'validationData', 'type': 'MLTableJobInput'},
        'validation_data_size': {'key': 'validationDataSize', 'type': 'float'},
        'weight_column_name': {'key': 'weightColumnName', 'type': 'str'},
        'log_verbosity': {'key': 'logVerbosity', 'type': 'str'},
        'target_column_name': {'key': 'targetColumnName', 'type': 'str'},
        'task_type': {'key': 'taskType', 'type': 'str'},
        'training_data': {'key': 'trainingData', 'type': 'MLTableJobInput'},
        'primary_metric': {'key': 'primaryMetric', 'type': 'str'},
        'training_settings': {'key': 'trainingSettings', 'type': 'RegressionTrainingSettings'},
    }

    def __init__(
        self,
        *,
        training_data: "MLTableJobInput",
        cv_split_column_names: Optional[List[str]] = None,
        featurization_settings: Optional["TableVerticalFeaturizationSettings"] = None,
        fixed_parameters: Optional["TableFixedParameters"] = None,
        limit_settings: Optional["TableVerticalLimitSettings"] = None,
        n_cross_validations: Optional["NCrossValidations"] = None,
        search_space: Optional[List["TableParameterSubspace"]] = None,
        sweep_settings: Optional["TableSweepSettings"] = None,
        test_data: Optional["MLTableJobInput"] = None,
        test_data_size: Optional[float] = None,
        validation_data: Optional["MLTableJobInput"] = None,
        validation_data_size: Optional[float] = None,
        weight_column_name: Optional[str] = None,
        log_verbosity: Optional[Union[str, "LogVerbosity"]] = None,
        target_column_name: Optional[str] = None,
        primary_metric: Optional[Union[str, "RegressionPrimaryMetrics"]] = None,
        training_settings: Optional["RegressionTrainingSettings"] = None,
        **kwargs
    ):
        """
        :keyword cv_split_column_names: Columns to use for CVSplit data.
        :paramtype cv_split_column_names: list[str]
        :keyword featurization_settings: Featurization inputs needed for AutoML job.
        :paramtype featurization_settings:
         ~azure.mgmt.machinelearningservices.models.TableVerticalFeaturizationSettings
        :keyword fixed_parameters: Model/training parameters that will remain constant throughout
         training.
        :paramtype fixed_parameters: ~azure.mgmt.machinelearningservices.models.TableFixedParameters
        :keyword limit_settings: Execution constraints for AutoMLJob.
        :paramtype limit_settings:
         ~azure.mgmt.machinelearningservices.models.TableVerticalLimitSettings
        :keyword n_cross_validations: Number of cross validation folds to be applied on training
         dataset
         when validation dataset is not provided.
        :paramtype n_cross_validations: ~azure.mgmt.machinelearningservices.models.NCrossValidations
        :keyword search_space: Search space for sampling different combinations of models and their
         hyperparameters.
        :paramtype search_space:
         list[~azure.mgmt.machinelearningservices.models.TableParameterSubspace]
        :keyword sweep_settings: Settings for model sweeping and hyperparameter tuning.
        :paramtype sweep_settings: ~azure.mgmt.machinelearningservices.models.TableSweepSettings
        :keyword test_data: Test data input.
        :paramtype test_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword test_data_size: The fraction of test dataset that needs to be set aside for validation
         purpose.
         Values between (0.0 , 1.0)
         Applied when validation dataset is not provided.
        :paramtype test_data_size: float
        :keyword validation_data: Validation data inputs.
        :paramtype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword validation_data_size: The fraction of training dataset that needs to be set aside for
         validation purpose.
         Values between (0.0 , 1.0)
         Applied when validation dataset is not provided.
        :paramtype validation_data_size: float
        :keyword weight_column_name: The name of the sample weight column. Automated ML supports a
         weighted column as an input, causing rows in the data to be weighted up or down.
        :paramtype weight_column_name: str
        :keyword log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
         "Info", "Warning", "Error", "Critical".
        :paramtype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
        :keyword target_column_name: Target column name: This is prediction values column.
         Also known as label column name in context of classification tasks.
        :paramtype target_column_name: str
        :keyword training_data: Required. [Required] Training data input.
        :paramtype training_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword primary_metric: Primary metric for regression task. Possible values include:
         "SpearmanCorrelation", "NormalizedRootMeanSquaredError", "R2Score",
         "NormalizedMeanAbsoluteError".
        :paramtype primary_metric: str or
         ~azure.mgmt.machinelearningservices.models.RegressionPrimaryMetrics
        :keyword training_settings: Inputs for training phase for an AutoML Job.
        :paramtype training_settings:
         ~azure.mgmt.machinelearningservices.models.RegressionTrainingSettings
        """
        super(Regression, self).__init__(log_verbosity=log_verbosity, target_column_name=target_column_name, training_data=training_data, cv_split_column_names=cv_split_column_names, featurization_settings=featurization_settings, fixed_parameters=fixed_parameters, limit_settings=limit_settings, n_cross_validations=n_cross_validations, search_space=search_space, sweep_settings=sweep_settings, test_data=test_data, test_data_size=test_data_size, validation_data=validation_data, validation_data_size=validation_data_size, weight_column_name=weight_column_name, **kwargs)
        self.cv_split_column_names = cv_split_column_names
        self.featurization_settings = featurization_settings
        self.fixed_parameters = fixed_parameters
        self.limit_settings = limit_settings
        self.n_cross_validations = n_cross_validations
        self.search_space = search_space
        self.sweep_settings = sweep_settings
        self.test_data = test_data
        self.test_data_size = test_data_size
        self.validation_data = validation_data
        self.validation_data_size = validation_data_size
        self.weight_column_name = weight_column_name
        self.task_type = 'Regression'  # type: str
        self.primary_metric = primary_metric
        self.training_settings = training_settings
        self.log_verbosity = log_verbosity
        self.target_column_name = target_column_name
        self.training_data = training_data


class RegressionTrainingSettings(TrainingSettings):
    """Regression Training related configuration.

    :ivar enable_dnn_training: Enable recommendation of DNN models.
    :vartype enable_dnn_training: bool
    :ivar enable_model_explainability: Flag to turn on explainability on best model.
    :vartype enable_model_explainability: bool
    :ivar enable_onnx_compatible_models: Flag for enabling onnx compatible models.
    :vartype enable_onnx_compatible_models: bool
    :ivar enable_stack_ensemble: Enable stack ensemble run.
    :vartype enable_stack_ensemble: bool
    :ivar enable_vote_ensemble: Enable voting ensemble run.
    :vartype enable_vote_ensemble: bool
    :ivar ensemble_model_download_timeout: During VotingEnsemble and StackEnsemble model
     generation, multiple fitted models from the previous child runs are downloaded.
     Configure this parameter with a higher value than 300 secs, if more time is needed.
    :vartype ensemble_model_download_timeout: ~datetime.timedelta
    :ivar stack_ensemble_settings: Stack ensemble settings for stack ensemble run.
    :vartype stack_ensemble_settings:
     ~azure.mgmt.machinelearningservices.models.StackEnsembleSettings
    :ivar allowed_training_algorithms: Allowed models for regression task.
    :vartype allowed_training_algorithms: list[str or
     ~azure.mgmt.machinelearningservices.models.RegressionModels]
    :ivar blocked_training_algorithms: Blocked models for regression task.
    :vartype blocked_training_algorithms: list[str or
     ~azure.mgmt.machinelearningservices.models.RegressionModels]
    """

    _attribute_map = {
        'enable_dnn_training': {'key': 'enableDnnTraining', 'type': 'bool'},
        'enable_model_explainability': {'key': 'enableModelExplainability', 'type': 'bool'},
        'enable_onnx_compatible_models': {'key': 'enableOnnxCompatibleModels', 'type': 'bool'},
        'enable_stack_ensemble': {'key': 'enableStackEnsemble', 'type': 'bool'},
        'enable_vote_ensemble': {'key': 'enableVoteEnsemble', 'type': 'bool'},
        'ensemble_model_download_timeout': {'key': 'ensembleModelDownloadTimeout', 'type': 'duration'},
        'stack_ensemble_settings': {'key': 'stackEnsembleSettings', 'type': 'StackEnsembleSettings'},
        'allowed_training_algorithms': {'key': 'allowedTrainingAlgorithms', 'type': '[str]'},
        'blocked_training_algorithms': {'key': 'blockedTrainingAlgorithms', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        enable_dnn_training: Optional[bool] = False,
        enable_model_explainability: Optional[bool] = True,
        enable_onnx_compatible_models: Optional[bool] = False,
        enable_stack_ensemble: Optional[bool] = True,
        enable_vote_ensemble: Optional[bool] = True,
        ensemble_model_download_timeout: Optional[datetime.timedelta] = "PT5M",
        stack_ensemble_settings: Optional["StackEnsembleSettings"] = None,
        allowed_training_algorithms: Optional[List[Union[str, "RegressionModels"]]] = None,
        blocked_training_algorithms: Optional[List[Union[str, "RegressionModels"]]] = None,
        **kwargs
    ):
        """
        :keyword enable_dnn_training: Enable recommendation of DNN models.
        :paramtype enable_dnn_training: bool
        :keyword enable_model_explainability: Flag to turn on explainability on best model.
        :paramtype enable_model_explainability: bool
        :keyword enable_onnx_compatible_models: Flag for enabling onnx compatible models.
        :paramtype enable_onnx_compatible_models: bool
        :keyword enable_stack_ensemble: Enable stack ensemble run.
        :paramtype enable_stack_ensemble: bool
        :keyword enable_vote_ensemble: Enable voting ensemble run.
        :paramtype enable_vote_ensemble: bool
        :keyword ensemble_model_download_timeout: During VotingEnsemble and StackEnsemble model
         generation, multiple fitted models from the previous child runs are downloaded.
         Configure this parameter with a higher value than 300 secs, if more time is needed.
        :paramtype ensemble_model_download_timeout: ~datetime.timedelta
        :keyword stack_ensemble_settings: Stack ensemble settings for stack ensemble run.
        :paramtype stack_ensemble_settings:
         ~azure.mgmt.machinelearningservices.models.StackEnsembleSettings
        :keyword allowed_training_algorithms: Allowed models for regression task.
        :paramtype allowed_training_algorithms: list[str or
         ~azure.mgmt.machinelearningservices.models.RegressionModels]
        :keyword blocked_training_algorithms: Blocked models for regression task.
        :paramtype blocked_training_algorithms: list[str or
         ~azure.mgmt.machinelearningservices.models.RegressionModels]
        """
        super(RegressionTrainingSettings, self).__init__(enable_dnn_training=enable_dnn_training, enable_model_explainability=enable_model_explainability, enable_onnx_compatible_models=enable_onnx_compatible_models, enable_stack_ensemble=enable_stack_ensemble, enable_vote_ensemble=enable_vote_ensemble, ensemble_model_download_timeout=ensemble_model_download_timeout, stack_ensemble_settings=stack_ensemble_settings, **kwargs)
        self.allowed_training_algorithms = allowed_training_algorithms
        self.blocked_training_algorithms = blocked_training_algorithms


class ResourceId(msrest.serialization.Model):
    """Represents a resource ID. For example, for a subnet, it is the resource URL for the subnet.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. The ID of the resource.
    :vartype id: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: str,
        **kwargs
    ):
        """
        :keyword id: Required. The ID of the resource.
        :paramtype id: str
        """
        super(ResourceId, self).__init__(**kwargs)
        self.id = id


class ResourceName(msrest.serialization.Model):
    """The Resource Name.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The name of the resource.
    :vartype value: str
    :ivar localized_value: The localized name of the resource.
    :vartype localized_value: str
    """

    _validation = {
        'value': {'readonly': True},
        'localized_value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ResourceName, self).__init__(**kwargs)
        self.value = None
        self.localized_value = None


class ResourceQuota(msrest.serialization.Model):
    """The quota assigned to a resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Specifies the resource ID.
    :vartype id: str
    :ivar aml_workspace_location: Region of the AML workspace in the id.
    :vartype aml_workspace_location: str
    :ivar type: Specifies the resource type.
    :vartype type: str
    :ivar name: Name of the resource.
    :vartype name: ~azure.mgmt.machinelearningservices.models.ResourceName
    :ivar limit: The maximum permitted quota of the resource.
    :vartype limit: long
    :ivar unit: An enum describing the unit of quota measurement. Possible values include: "Count".
    :vartype unit: str or ~azure.mgmt.machinelearningservices.models.QuotaUnit
    """

    _validation = {
        'id': {'readonly': True},
        'aml_workspace_location': {'readonly': True},
        'type': {'readonly': True},
        'name': {'readonly': True},
        'limit': {'readonly': True},
        'unit': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'aml_workspace_location': {'key': 'amlWorkspaceLocation', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'ResourceName'},
        'limit': {'key': 'limit', 'type': 'long'},
        'unit': {'key': 'unit', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ResourceQuota, self).__init__(**kwargs)
        self.id = None
        self.aml_workspace_location = None
        self.type = None
        self.name = None
        self.limit = None
        self.unit = None


class Route(msrest.serialization.Model):
    """Route.

    All required parameters must be populated in order to send to Azure.

    :ivar path: Required. [Required] The path for the route.
    :vartype path: str
    :ivar port: Required. [Required] The port for the route.
    :vartype port: int
    """

    _validation = {
        'path': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'port': {'required': True},
    }

    _attribute_map = {
        'path': {'key': 'path', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        path: str,
        port: int,
        **kwargs
    ):
        """
        :keyword path: Required. [Required] The path for the route.
        :paramtype path: str
        :keyword port: Required. [Required] The port for the route.
        :paramtype port: int
        """
        super(Route, self).__init__(**kwargs)
        self.path = path
        self.port = port


class SASAuthTypeWorkspaceConnectionProperties(WorkspaceConnectionPropertiesV2):
    """SASAuthTypeWorkspaceConnectionProperties.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Required. Authentication type of the connection target.Constant filled by
     server. Possible values include: "PAT", "ManagedIdentity", "UsernamePassword", "None", "SAS",
     "ServicePrincipal", "AccessKey".
    :vartype auth_type: str or ~azure.mgmt.machinelearningservices.models.ConnectionAuthType
    :ivar category: Category of the connection.
    :vartype category: str
    :ivar target:
    :vartype target: str
    :ivar value: Value details of the workspace connection.
    :vartype value: str
    :ivar value_format: format for the workspace connection value. Possible values include: "JSON".
    :vartype value_format: str or ~azure.mgmt.machinelearningservices.models.ValueFormat
    :ivar credentials:
    :vartype credentials:
     ~azure.mgmt.machinelearningservices.models.WorkspaceConnectionSharedAccessSignature
    """

    _validation = {
        'auth_type': {'required': True},
    }

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'value_format': {'key': 'valueFormat', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'WorkspaceConnectionSharedAccessSignature'},
    }

    def __init__(
        self,
        *,
        category: Optional[str] = None,
        target: Optional[str] = None,
        value: Optional[str] = None,
        value_format: Optional[Union[str, "ValueFormat"]] = None,
        credentials: Optional["WorkspaceConnectionSharedAccessSignature"] = None,
        **kwargs
    ):
        """
        :keyword category: Category of the connection.
        :paramtype category: str
        :keyword target:
        :paramtype target: str
        :keyword value: Value details of the workspace connection.
        :paramtype value: str
        :keyword value_format: format for the workspace connection value. Possible values include:
         "JSON".
        :paramtype value_format: str or ~azure.mgmt.machinelearningservices.models.ValueFormat
        :keyword credentials:
        :paramtype credentials:
         ~azure.mgmt.machinelearningservices.models.WorkspaceConnectionSharedAccessSignature
        """
        super(SASAuthTypeWorkspaceConnectionProperties, self).__init__(category=category, target=target, value=value, value_format=value_format, **kwargs)
        self.auth_type = 'SAS'  # type: str
        self.credentials = credentials


class SasDatastoreCredentials(DatastoreCredentials):
    """SAS datastore credentials configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar credentials_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "AccountKey", "Certificate",
     "None", "Sas", "ServicePrincipal", "KerberosKeytab", "KerberosPassword".
    :vartype credentials_type: str or ~azure.mgmt.machinelearningservices.models.CredentialsType
    :ivar secrets: Required. [Required] Storage container secrets.
    :vartype secrets: ~azure.mgmt.machinelearningservices.models.SasDatastoreSecrets
    """

    _validation = {
        'credentials_type': {'required': True},
        'secrets': {'required': True},
    }

    _attribute_map = {
        'credentials_type': {'key': 'credentialsType', 'type': 'str'},
        'secrets': {'key': 'secrets', 'type': 'SasDatastoreSecrets'},
    }

    def __init__(
        self,
        *,
        secrets: "SasDatastoreSecrets",
        **kwargs
    ):
        """
        :keyword secrets: Required. [Required] Storage container secrets.
        :paramtype secrets: ~azure.mgmt.machinelearningservices.models.SasDatastoreSecrets
        """
        super(SasDatastoreCredentials, self).__init__(**kwargs)
        self.credentials_type = 'Sas'  # type: str
        self.secrets = secrets


class SasDatastoreSecrets(DatastoreSecrets):
    """Datastore SAS secrets.

    All required parameters must be populated in order to send to Azure.

    :ivar secrets_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "AccountKey", "Certificate", "Sas",
     "ServicePrincipal", "KerberosPassword", "KerberosKeytab".
    :vartype secrets_type: str or ~azure.mgmt.machinelearningservices.models.SecretsType
    :ivar sas_token: Storage container SAS token.
    :vartype sas_token: str
    """

    _validation = {
        'secrets_type': {'required': True},
    }

    _attribute_map = {
        'secrets_type': {'key': 'secretsType', 'type': 'str'},
        'sas_token': {'key': 'sasToken', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        sas_token: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword sas_token: Storage container SAS token.
        :paramtype sas_token: str
        """
        super(SasDatastoreSecrets, self).__init__(**kwargs)
        self.secrets_type = 'Sas'  # type: str
        self.sas_token = sas_token


class ScaleSettings(msrest.serialization.Model):
    """scale settings for AML Compute.

    All required parameters must be populated in order to send to Azure.

    :ivar max_node_count: Required. Max number of nodes to use.
    :vartype max_node_count: int
    :ivar min_node_count: Min number of nodes to use.
    :vartype min_node_count: int
    :ivar node_idle_time_before_scale_down: Node Idle Time before scaling down amlCompute. This
     string needs to be in the RFC Format.
    :vartype node_idle_time_before_scale_down: ~datetime.timedelta
    """

    _validation = {
        'max_node_count': {'required': True},
    }

    _attribute_map = {
        'max_node_count': {'key': 'maxNodeCount', 'type': 'int'},
        'min_node_count': {'key': 'minNodeCount', 'type': 'int'},
        'node_idle_time_before_scale_down': {'key': 'nodeIdleTimeBeforeScaleDown', 'type': 'duration'},
    }

    def __init__(
        self,
        *,
        max_node_count: int,
        min_node_count: Optional[int] = 0,
        node_idle_time_before_scale_down: Optional[datetime.timedelta] = None,
        **kwargs
    ):
        """
        :keyword max_node_count: Required. Max number of nodes to use.
        :paramtype max_node_count: int
        :keyword min_node_count: Min number of nodes to use.
        :paramtype min_node_count: int
        :keyword node_idle_time_before_scale_down: Node Idle Time before scaling down amlCompute. This
         string needs to be in the RFC Format.
        :paramtype node_idle_time_before_scale_down: ~datetime.timedelta
        """
        super(ScaleSettings, self).__init__(**kwargs)
        self.max_node_count = max_node_count
        self.min_node_count = min_node_count
        self.node_idle_time_before_scale_down = node_idle_time_before_scale_down


class ScaleSettingsInformation(msrest.serialization.Model):
    """Desired scale settings for the amlCompute.

    :ivar scale_settings: scale settings for AML Compute.
    :vartype scale_settings: ~azure.mgmt.machinelearningservices.models.ScaleSettings
    """

    _attribute_map = {
        'scale_settings': {'key': 'scaleSettings', 'type': 'ScaleSettings'},
    }

    def __init__(
        self,
        *,
        scale_settings: Optional["ScaleSettings"] = None,
        **kwargs
    ):
        """
        :keyword scale_settings: scale settings for AML Compute.
        :paramtype scale_settings: ~azure.mgmt.machinelearningservices.models.ScaleSettings
        """
        super(ScaleSettingsInformation, self).__init__(**kwargs)
        self.scale_settings = scale_settings


class Schedule(Resource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.ScheduleProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'ScheduleProperties'},
    }

    def __init__(
        self,
        *,
        properties: "ScheduleProperties",
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.ScheduleProperties
        """
        super(Schedule, self).__init__(**kwargs)
        self.properties = properties


class ScheduleBase(msrest.serialization.Model):
    """ScheduleBase.

    :ivar id: A system assigned id for the schedule.
    :vartype id: str
    :ivar provisioning_status: The current deployment state of schedule. Possible values include:
     "Completed", "Provisioning", "Failed".
    :vartype provisioning_status: str or
     ~azure.mgmt.machinelearningservices.models.ScheduleProvisioningState
    :ivar status: Is the schedule enabled or disabled?. Possible values include: "Enabled",
     "Disabled".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.ScheduleStatus
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'provisioning_status': {'key': 'provisioningStatus', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        provisioning_status: Optional[Union[str, "ScheduleProvisioningState"]] = None,
        status: Optional[Union[str, "ScheduleStatus"]] = None,
        **kwargs
    ):
        """
        :keyword id: A system assigned id for the schedule.
        :paramtype id: str
        :keyword provisioning_status: The current deployment state of schedule. Possible values
         include: "Completed", "Provisioning", "Failed".
        :paramtype provisioning_status: str or
         ~azure.mgmt.machinelearningservices.models.ScheduleProvisioningState
        :keyword status: Is the schedule enabled or disabled?. Possible values include: "Enabled",
         "Disabled".
        :paramtype status: str or ~azure.mgmt.machinelearningservices.models.ScheduleStatus
        """
        super(ScheduleBase, self).__init__(**kwargs)
        self.id = id
        self.provisioning_status = provisioning_status
        self.status = status


class ScheduleProperties(ResourceBase):
    """Base definition of a schedule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar action: Required. [Required] Specifies the action of the schedule.
    :vartype action: ~azure.mgmt.machinelearningservices.models.ScheduleActionBase
    :ivar display_name: Display name of schedule.
    :vartype display_name: str
    :ivar is_enabled: Is the schedule enabled?.
    :vartype is_enabled: bool
    :ivar provisioning_state: Provisioning state for the schedule. Possible values include:
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ScheduleProvisioningStatus
    :ivar trigger: Required. [Required] Specifies the trigger details.
    :vartype trigger: ~azure.mgmt.machinelearningservices.models.TriggerBase
    """

    _validation = {
        'action': {'required': True},
        'provisioning_state': {'readonly': True},
        'trigger': {'required': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'action': {'key': 'action', 'type': 'ScheduleActionBase'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'trigger': {'key': 'trigger', 'type': 'TriggerBase'},
    }

    def __init__(
        self,
        *,
        action: "ScheduleActionBase",
        trigger: "TriggerBase",
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        display_name: Optional[str] = None,
        is_enabled: Optional[bool] = True,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword action: Required. [Required] Specifies the action of the schedule.
        :paramtype action: ~azure.mgmt.machinelearningservices.models.ScheduleActionBase
        :keyword display_name: Display name of schedule.
        :paramtype display_name: str
        :keyword is_enabled: Is the schedule enabled?.
        :paramtype is_enabled: bool
        :keyword trigger: Required. [Required] Specifies the trigger details.
        :paramtype trigger: ~azure.mgmt.machinelearningservices.models.TriggerBase
        """
        super(ScheduleProperties, self).__init__(description=description, properties=properties, tags=tags, **kwargs)
        self.action = action
        self.display_name = display_name
        self.is_enabled = is_enabled
        self.provisioning_state = None
        self.trigger = trigger


class ScheduleResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of Schedule entities.

    :ivar next_link: The link to the next page of Schedule objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type Schedule.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.Schedule]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[Schedule]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["Schedule"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of Schedule objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type Schedule.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.Schedule]
        """
        super(ScheduleResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class ScriptReference(msrest.serialization.Model):
    """Script reference.

    :ivar script_source: The storage source of the script: workspace.
    :vartype script_source: str
    :ivar script_data: The location of scripts in the mounted volume.
    :vartype script_data: str
    :ivar script_arguments: Optional command line arguments passed to the script to run.
    :vartype script_arguments: str
    :ivar timeout: Optional time period passed to timeout command.
    :vartype timeout: str
    """

    _attribute_map = {
        'script_source': {'key': 'scriptSource', 'type': 'str'},
        'script_data': {'key': 'scriptData', 'type': 'str'},
        'script_arguments': {'key': 'scriptArguments', 'type': 'str'},
        'timeout': {'key': 'timeout', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        script_source: Optional[str] = None,
        script_data: Optional[str] = None,
        script_arguments: Optional[str] = None,
        timeout: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword script_source: The storage source of the script: workspace.
        :paramtype script_source: str
        :keyword script_data: The location of scripts in the mounted volume.
        :paramtype script_data: str
        :keyword script_arguments: Optional command line arguments passed to the script to run.
        :paramtype script_arguments: str
        :keyword timeout: Optional time period passed to timeout command.
        :paramtype timeout: str
        """
        super(ScriptReference, self).__init__(**kwargs)
        self.script_source = script_source
        self.script_data = script_data
        self.script_arguments = script_arguments
        self.timeout = timeout


class ScriptsToExecute(msrest.serialization.Model):
    """Customized setup scripts.

    :ivar startup_script: Script that's run every time the machine starts.
    :vartype startup_script: ~azure.mgmt.machinelearningservices.models.ScriptReference
    :ivar creation_script: Script that's run only once during provision of the compute.
    :vartype creation_script: ~azure.mgmt.machinelearningservices.models.ScriptReference
    """

    _attribute_map = {
        'startup_script': {'key': 'startupScript', 'type': 'ScriptReference'},
        'creation_script': {'key': 'creationScript', 'type': 'ScriptReference'},
    }

    def __init__(
        self,
        *,
        startup_script: Optional["ScriptReference"] = None,
        creation_script: Optional["ScriptReference"] = None,
        **kwargs
    ):
        """
        :keyword startup_script: Script that's run every time the machine starts.
        :paramtype startup_script: ~azure.mgmt.machinelearningservices.models.ScriptReference
        :keyword creation_script: Script that's run only once during provision of the compute.
        :paramtype creation_script: ~azure.mgmt.machinelearningservices.models.ScriptReference
        """
        super(ScriptsToExecute, self).__init__(**kwargs)
        self.startup_script = startup_script
        self.creation_script = creation_script


class ServiceManagedResourcesSettings(msrest.serialization.Model):
    """ServiceManagedResourcesSettings.

    :ivar cosmos_db: The settings for the service managed cosmosdb account.
    :vartype cosmos_db: ~azure.mgmt.machinelearningservices.models.CosmosDbSettings
    """

    _attribute_map = {
        'cosmos_db': {'key': 'cosmosDb', 'type': 'CosmosDbSettings'},
    }

    def __init__(
        self,
        *,
        cosmos_db: Optional["CosmosDbSettings"] = None,
        **kwargs
    ):
        """
        :keyword cosmos_db: The settings for the service managed cosmosdb account.
        :paramtype cosmos_db: ~azure.mgmt.machinelearningservices.models.CosmosDbSettings
        """
        super(ServiceManagedResourcesSettings, self).__init__(**kwargs)
        self.cosmos_db = cosmos_db


class ServicePrincipalAuthTypeWorkspaceConnectionProperties(WorkspaceConnectionPropertiesV2):
    """ServicePrincipalAuthTypeWorkspaceConnectionProperties.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Required. Authentication type of the connection target.Constant filled by
     server. Possible values include: "PAT", "ManagedIdentity", "UsernamePassword", "None", "SAS",
     "ServicePrincipal", "AccessKey".
    :vartype auth_type: str or ~azure.mgmt.machinelearningservices.models.ConnectionAuthType
    :ivar category: Category of the connection.
    :vartype category: str
    :ivar target:
    :vartype target: str
    :ivar value: Value details of the workspace connection.
    :vartype value: str
    :ivar value_format: format for the workspace connection value. Possible values include: "JSON".
    :vartype value_format: str or ~azure.mgmt.machinelearningservices.models.ValueFormat
    :ivar credentials:
    :vartype credentials:
     ~azure.mgmt.machinelearningservices.models.WorkspaceConnectionServicePrincipal
    """

    _validation = {
        'auth_type': {'required': True},
    }

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'value_format': {'key': 'valueFormat', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'WorkspaceConnectionServicePrincipal'},
    }

    def __init__(
        self,
        *,
        category: Optional[str] = None,
        target: Optional[str] = None,
        value: Optional[str] = None,
        value_format: Optional[Union[str, "ValueFormat"]] = None,
        credentials: Optional["WorkspaceConnectionServicePrincipal"] = None,
        **kwargs
    ):
        """
        :keyword category: Category of the connection.
        :paramtype category: str
        :keyword target:
        :paramtype target: str
        :keyword value: Value details of the workspace connection.
        :paramtype value: str
        :keyword value_format: format for the workspace connection value. Possible values include:
         "JSON".
        :paramtype value_format: str or ~azure.mgmt.machinelearningservices.models.ValueFormat
        :keyword credentials:
        :paramtype credentials:
         ~azure.mgmt.machinelearningservices.models.WorkspaceConnectionServicePrincipal
        """
        super(ServicePrincipalAuthTypeWorkspaceConnectionProperties, self).__init__(category=category, target=target, value=value, value_format=value_format, **kwargs)
        self.auth_type = 'ServicePrincipal'  # type: str
        self.credentials = credentials


class ServicePrincipalDatastoreCredentials(DatastoreCredentials):
    """Service Principal datastore credentials configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar credentials_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "AccountKey", "Certificate",
     "None", "Sas", "ServicePrincipal", "KerberosKeytab", "KerberosPassword".
    :vartype credentials_type: str or ~azure.mgmt.machinelearningservices.models.CredentialsType
    :ivar authority_url: Authority URL used for authentication.
    :vartype authority_url: str
    :ivar client_id: Required. [Required] Service principal client ID.
    :vartype client_id: str
    :ivar resource_url: Resource the service principal has access to.
    :vartype resource_url: str
    :ivar secrets: Required. [Required] Service principal secrets.
    :vartype secrets: ~azure.mgmt.machinelearningservices.models.ServicePrincipalDatastoreSecrets
    :ivar tenant_id: Required. [Required] ID of the tenant to which the service principal belongs.
    :vartype tenant_id: str
    """

    _validation = {
        'credentials_type': {'required': True},
        'client_id': {'required': True},
        'secrets': {'required': True},
        'tenant_id': {'required': True},
    }

    _attribute_map = {
        'credentials_type': {'key': 'credentialsType', 'type': 'str'},
        'authority_url': {'key': 'authorityUrl', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
        'resource_url': {'key': 'resourceUrl', 'type': 'str'},
        'secrets': {'key': 'secrets', 'type': 'ServicePrincipalDatastoreSecrets'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        client_id: str,
        secrets: "ServicePrincipalDatastoreSecrets",
        tenant_id: str,
        authority_url: Optional[str] = None,
        resource_url: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword authority_url: Authority URL used for authentication.
        :paramtype authority_url: str
        :keyword client_id: Required. [Required] Service principal client ID.
        :paramtype client_id: str
        :keyword resource_url: Resource the service principal has access to.
        :paramtype resource_url: str
        :keyword secrets: Required. [Required] Service principal secrets.
        :paramtype secrets: ~azure.mgmt.machinelearningservices.models.ServicePrincipalDatastoreSecrets
        :keyword tenant_id: Required. [Required] ID of the tenant to which the service principal
         belongs.
        :paramtype tenant_id: str
        """
        super(ServicePrincipalDatastoreCredentials, self).__init__(**kwargs)
        self.credentials_type = 'ServicePrincipal'  # type: str
        self.authority_url = authority_url
        self.client_id = client_id
        self.resource_url = resource_url
        self.secrets = secrets
        self.tenant_id = tenant_id


class ServicePrincipalDatastoreSecrets(DatastoreSecrets):
    """Datastore Service Principal secrets.

    All required parameters must be populated in order to send to Azure.

    :ivar secrets_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "AccountKey", "Certificate", "Sas",
     "ServicePrincipal", "KerberosPassword", "KerberosKeytab".
    :vartype secrets_type: str or ~azure.mgmt.machinelearningservices.models.SecretsType
    :ivar client_secret: Service principal secret.
    :vartype client_secret: str
    """

    _validation = {
        'secrets_type': {'required': True},
    }

    _attribute_map = {
        'secrets_type': {'key': 'secretsType', 'type': 'str'},
        'client_secret': {'key': 'clientSecret', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        client_secret: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword client_secret: Service principal secret.
        :paramtype client_secret: str
        """
        super(ServicePrincipalDatastoreSecrets, self).__init__(**kwargs)
        self.secrets_type = 'ServicePrincipal'  # type: str
        self.client_secret = client_secret


class SetupScripts(msrest.serialization.Model):
    """Details of customized scripts to execute for setting up the cluster.

    :ivar scripts: Customized setup scripts.
    :vartype scripts: ~azure.mgmt.machinelearningservices.models.ScriptsToExecute
    """

    _attribute_map = {
        'scripts': {'key': 'scripts', 'type': 'ScriptsToExecute'},
    }

    def __init__(
        self,
        *,
        scripts: Optional["ScriptsToExecute"] = None,
        **kwargs
    ):
        """
        :keyword scripts: Customized setup scripts.
        :paramtype scripts: ~azure.mgmt.machinelearningservices.models.ScriptsToExecute
        """
        super(SetupScripts, self).__init__(**kwargs)
        self.scripts = scripts


class SharedPrivateLinkResource(msrest.serialization.Model):
    """SharedPrivateLinkResource.

    :ivar name: Unique name of the private link.
    :vartype name: str
    :ivar private_link_resource_id: The resource id that private link links to.
    :vartype private_link_resource_id: str
    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar request_message: Request message.
    :vartype request_message: str
    :ivar status: Indicates whether the connection has been Approved/Rejected/Removed by the owner
     of the service. Possible values include: "Pending", "Approved", "Rejected", "Disconnected",
     "Timeout".
    :vartype status: str or
     ~azure.mgmt.machinelearningservices.models.PrivateEndpointServiceConnectionStatus
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'private_link_resource_id': {'key': 'properties.privateLinkResourceId', 'type': 'str'},
        'group_id': {'key': 'properties.groupId', 'type': 'str'},
        'request_message': {'key': 'properties.requestMessage', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        private_link_resource_id: Optional[str] = None,
        group_id: Optional[str] = None,
        request_message: Optional[str] = None,
        status: Optional[Union[str, "PrivateEndpointServiceConnectionStatus"]] = None,
        **kwargs
    ):
        """
        :keyword name: Unique name of the private link.
        :paramtype name: str
        :keyword private_link_resource_id: The resource id that private link links to.
        :paramtype private_link_resource_id: str
        :keyword group_id: The private link resource group id.
        :paramtype group_id: str
        :keyword request_message: Request message.
        :paramtype request_message: str
        :keyword status: Indicates whether the connection has been Approved/Rejected/Removed by the
         owner of the service. Possible values include: "Pending", "Approved", "Rejected",
         "Disconnected", "Timeout".
        :paramtype status: str or
         ~azure.mgmt.machinelearningservices.models.PrivateEndpointServiceConnectionStatus
        """
        super(SharedPrivateLinkResource, self).__init__(**kwargs)
        self.name = name
        self.private_link_resource_id = private_link_resource_id
        self.group_id = group_id
        self.request_message = request_message
        self.status = status


class Sku(msrest.serialization.Model):
    """The resource model definition representing SKU.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the SKU. Ex - P3. It is typically a letter+number code.
    :vartype name: str
    :ivar tier: This field is required to be implemented by the Resource Provider if the service
     has more than one tier, but is not required on a PUT. Possible values include: "Free", "Basic",
     "Standard", "Premium".
    :vartype tier: str or ~azure.mgmt.machinelearningservices.models.SkuTier
    :ivar size: The SKU size. When the name field is the combination of tier and some other value,
     this would be the standalone code.
    :vartype size: str
    :ivar family: If the service has different generations of hardware, for the same SKU, then that
     can be captured here.
    :vartype family: str
    :ivar capacity: If the SKU supports scale out/in then the capacity integer should be included.
     If scale out/in is not possible for the resource this may be omitted.
    :vartype capacity: int
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'size': {'key': 'size', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: str,
        tier: Optional[Union[str, "SkuTier"]] = None,
        size: Optional[str] = None,
        family: Optional[str] = None,
        capacity: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the SKU. Ex - P3. It is typically a letter+number code.
        :paramtype name: str
        :keyword tier: This field is required to be implemented by the Resource Provider if the service
         has more than one tier, but is not required on a PUT. Possible values include: "Free", "Basic",
         "Standard", "Premium".
        :paramtype tier: str or ~azure.mgmt.machinelearningservices.models.SkuTier
        :keyword size: The SKU size. When the name field is the combination of tier and some other
         value, this would be the standalone code.
        :paramtype size: str
        :keyword family: If the service has different generations of hardware, for the same SKU, then
         that can be captured here.
        :paramtype family: str
        :keyword capacity: If the SKU supports scale out/in then the capacity integer should be
         included. If scale out/in is not possible for the resource this may be omitted.
        :paramtype capacity: int
        """
        super(Sku, self).__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.size = size
        self.family = family
        self.capacity = capacity


class SkuCapacity(msrest.serialization.Model):
    """SKU capacity information.

    :ivar default: Gets or sets the default capacity.
    :vartype default: int
    :ivar maximum: Gets or sets the maximum.
    :vartype maximum: int
    :ivar minimum: Gets or sets the minimum.
    :vartype minimum: int
    :ivar scale_type: Gets or sets the type of the scale. Possible values include: "Automatic",
     "Manual", "None".
    :vartype scale_type: str or ~azure.mgmt.machinelearningservices.models.SkuScaleType
    """

    _attribute_map = {
        'default': {'key': 'default', 'type': 'int'},
        'maximum': {'key': 'maximum', 'type': 'int'},
        'minimum': {'key': 'minimum', 'type': 'int'},
        'scale_type': {'key': 'scaleType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        default: Optional[int] = 0,
        maximum: Optional[int] = 0,
        minimum: Optional[int] = 0,
        scale_type: Optional[Union[str, "SkuScaleType"]] = None,
        **kwargs
    ):
        """
        :keyword default: Gets or sets the default capacity.
        :paramtype default: int
        :keyword maximum: Gets or sets the maximum.
        :paramtype maximum: int
        :keyword minimum: Gets or sets the minimum.
        :paramtype minimum: int
        :keyword scale_type: Gets or sets the type of the scale. Possible values include: "Automatic",
         "Manual", "None".
        :paramtype scale_type: str or ~azure.mgmt.machinelearningservices.models.SkuScaleType
        """
        super(SkuCapacity, self).__init__(**kwargs)
        self.default = default
        self.maximum = maximum
        self.minimum = minimum
        self.scale_type = scale_type


class SkuResource(msrest.serialization.Model):
    """Fulfills ARM Contract requirement to list all available SKUS for a resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar capacity: Gets or sets the Sku Capacity.
    :vartype capacity: ~azure.mgmt.machinelearningservices.models.SkuCapacity
    :ivar resource_type: The resource type name.
    :vartype resource_type: str
    :ivar sku: Gets or sets the Sku.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.SkuSetting
    """

    _validation = {
        'resource_type': {'readonly': True},
    }

    _attribute_map = {
        'capacity': {'key': 'capacity', 'type': 'SkuCapacity'},
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'SkuSetting'},
    }

    def __init__(
        self,
        *,
        capacity: Optional["SkuCapacity"] = None,
        sku: Optional["SkuSetting"] = None,
        **kwargs
    ):
        """
        :keyword capacity: Gets or sets the Sku Capacity.
        :paramtype capacity: ~azure.mgmt.machinelearningservices.models.SkuCapacity
        :keyword sku: Gets or sets the Sku.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.SkuSetting
        """
        super(SkuResource, self).__init__(**kwargs)
        self.capacity = capacity
        self.resource_type = None
        self.sku = sku


class SkuResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of SkuResource entities.

    :ivar next_link: The link to the next page of SkuResource objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type SkuResource.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.SkuResource]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[SkuResource]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["SkuResource"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of SkuResource objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type SkuResource.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.SkuResource]
        """
        super(SkuResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class SkuSetting(msrest.serialization.Model):
    """SkuSetting fulfills the need for stripped down SKU info in ARM contract.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. [Required] The name of the SKU. Ex - P3. It is typically a letter+number
     code.
    :vartype name: str
    :ivar tier: This field is required to be implemented by the Resource Provider if the service
     has more than one tier, but is not required on a PUT. Possible values include: "Free", "Basic",
     "Standard", "Premium".
    :vartype tier: str or ~azure.mgmt.machinelearningservices.models.SkuTier
    """

    _validation = {
        'name': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        tier: Optional[Union[str, "SkuTier"]] = None,
        **kwargs
    ):
        """
        :keyword name: Required. [Required] The name of the SKU. Ex - P3. It is typically a
         letter+number code.
        :paramtype name: str
        :keyword tier: This field is required to be implemented by the Resource Provider if the service
         has more than one tier, but is not required on a PUT. Possible values include: "Free", "Basic",
         "Standard", "Premium".
        :paramtype tier: str or ~azure.mgmt.machinelearningservices.models.SkuTier
        """
        super(SkuSetting, self).__init__(**kwargs)
        self.name = name
        self.tier = tier


class SparkJob(JobBaseProperties):
    """Spark job definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar component_id: ARM resource ID of the component resource.
    :vartype component_id: str
    :ivar compute_id: ARM resource ID of the compute resource.
    :vartype compute_id: str
    :ivar display_name: Display name of job.
    :vartype display_name: str
    :ivar experiment_name: The name of the experiment the job belongs to. If not set, the job is
     placed in the "Default" experiment.
    :vartype experiment_name: str
    :ivar identity: Identity configuration. If set, this should be one of AmlToken,
     ManagedIdentity, UserIdentity or null.
     Defaults to AmlToken if null.
    :vartype identity: ~azure.mgmt.machinelearningservices.models.IdentityConfiguration
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar job_type: Required. [Required] Specifies the type of job.Constant filled by server.
     Possible values include: "AutoML", "Command", "Labeling", "Sweep", "Pipeline", "Spark".
    :vartype job_type: str or ~azure.mgmt.machinelearningservices.models.JobType
    :ivar services: List of JobEndpoints.
     For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
    :vartype services: dict[str, ~azure.mgmt.machinelearningservices.models.JobService]
    :ivar status: Status of the job. Possible values include: "NotStarted", "Starting",
     "Provisioning", "Preparing", "Queued", "Running", "Finalizing", "CancelRequested", "Completed",
     "Failed", "Canceled", "NotResponding", "Paused", "Unknown", "Scheduled".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.JobStatus
    :ivar archives: Archive files used in the job.
    :vartype archives: list[str]
    :ivar args: Arguments for the job.
    :vartype args: str
    :ivar code_id: Required. [Required] ARM resource ID of the code asset.
    :vartype code_id: str
    :ivar conf: Spark configured properties.
    :vartype conf: dict[str, str]
    :ivar entry: Required. [Required] The entry to execute on startup of the job.
    :vartype entry: ~azure.mgmt.machinelearningservices.models.SparkJobEntry
    :ivar environment_id: The ARM resource ID of the Environment specification for the job.
    :vartype environment_id: str
    :ivar files: Files used in the job.
    :vartype files: list[str]
    :ivar inputs: Mapping of input data bindings used in the job.
    :vartype inputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobInput]
    :ivar jars: Jar files used in the job.
    :vartype jars: list[str]
    :ivar outputs: Mapping of output data bindings used in the job.
    :vartype outputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobOutput]
    :ivar py_files: Python files used in the job.
    :vartype py_files: list[str]
    :ivar resources: Compute Resource configuration for the job.
    :vartype resources: ~azure.mgmt.machinelearningservices.models.SparkResourceConfiguration
    """

    _validation = {
        'job_type': {'required': True},
        'status': {'readonly': True},
        'code_id': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'entry': {'required': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'component_id': {'key': 'componentId', 'type': 'str'},
        'compute_id': {'key': 'computeId', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'experiment_name': {'key': 'experimentName', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'IdentityConfiguration'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'job_type': {'key': 'jobType', 'type': 'str'},
        'services': {'key': 'services', 'type': '{JobService}'},
        'status': {'key': 'status', 'type': 'str'},
        'archives': {'key': 'archives', 'type': '[str]'},
        'args': {'key': 'args', 'type': 'str'},
        'code_id': {'key': 'codeId', 'type': 'str'},
        'conf': {'key': 'conf', 'type': '{str}'},
        'entry': {'key': 'entry', 'type': 'SparkJobEntry'},
        'environment_id': {'key': 'environmentId', 'type': 'str'},
        'files': {'key': 'files', 'type': '[str]'},
        'inputs': {'key': 'inputs', 'type': '{JobInput}'},
        'jars': {'key': 'jars', 'type': '[str]'},
        'outputs': {'key': 'outputs', 'type': '{JobOutput}'},
        'py_files': {'key': 'pyFiles', 'type': '[str]'},
        'resources': {'key': 'resources', 'type': 'SparkResourceConfiguration'},
    }

    def __init__(
        self,
        *,
        code_id: str,
        entry: "SparkJobEntry",
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        component_id: Optional[str] = None,
        compute_id: Optional[str] = None,
        display_name: Optional[str] = None,
        experiment_name: Optional[str] = "Default",
        identity: Optional["IdentityConfiguration"] = None,
        is_archived: Optional[bool] = False,
        services: Optional[Dict[str, "JobService"]] = None,
        archives: Optional[List[str]] = None,
        args: Optional[str] = None,
        conf: Optional[Dict[str, str]] = None,
        environment_id: Optional[str] = None,
        files: Optional[List[str]] = None,
        inputs: Optional[Dict[str, "JobInput"]] = None,
        jars: Optional[List[str]] = None,
        outputs: Optional[Dict[str, "JobOutput"]] = None,
        py_files: Optional[List[str]] = None,
        resources: Optional["SparkResourceConfiguration"] = None,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword component_id: ARM resource ID of the component resource.
        :paramtype component_id: str
        :keyword compute_id: ARM resource ID of the compute resource.
        :paramtype compute_id: str
        :keyword display_name: Display name of job.
        :paramtype display_name: str
        :keyword experiment_name: The name of the experiment the job belongs to. If not set, the job is
         placed in the "Default" experiment.
        :paramtype experiment_name: str
        :keyword identity: Identity configuration. If set, this should be one of AmlToken,
         ManagedIdentity, UserIdentity or null.
         Defaults to AmlToken if null.
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.IdentityConfiguration
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword services: List of JobEndpoints.
         For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        :paramtype services: dict[str, ~azure.mgmt.machinelearningservices.models.JobService]
        :keyword archives: Archive files used in the job.
        :paramtype archives: list[str]
        :keyword args: Arguments for the job.
        :paramtype args: str
        :keyword code_id: Required. [Required] ARM resource ID of the code asset.
        :paramtype code_id: str
        :keyword conf: Spark configured properties.
        :paramtype conf: dict[str, str]
        :keyword entry: Required. [Required] The entry to execute on startup of the job.
        :paramtype entry: ~azure.mgmt.machinelearningservices.models.SparkJobEntry
        :keyword environment_id: The ARM resource ID of the Environment specification for the job.
        :paramtype environment_id: str
        :keyword files: Files used in the job.
        :paramtype files: list[str]
        :keyword inputs: Mapping of input data bindings used in the job.
        :paramtype inputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobInput]
        :keyword jars: Jar files used in the job.
        :paramtype jars: list[str]
        :keyword outputs: Mapping of output data bindings used in the job.
        :paramtype outputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobOutput]
        :keyword py_files: Python files used in the job.
        :paramtype py_files: list[str]
        :keyword resources: Compute Resource configuration for the job.
        :paramtype resources: ~azure.mgmt.machinelearningservices.models.SparkResourceConfiguration
        """
        super(SparkJob, self).__init__(description=description, properties=properties, tags=tags, component_id=component_id, compute_id=compute_id, display_name=display_name, experiment_name=experiment_name, identity=identity, is_archived=is_archived, services=services, **kwargs)
        self.job_type = 'Spark'  # type: str
        self.archives = archives
        self.args = args
        self.code_id = code_id
        self.conf = conf
        self.entry = entry
        self.environment_id = environment_id
        self.files = files
        self.inputs = inputs
        self.jars = jars
        self.outputs = outputs
        self.py_files = py_files
        self.resources = resources


class SparkJobEntry(msrest.serialization.Model):
    """Spark job entry point definition.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: SparkJobPythonEntry, SparkJobScalaEntry.

    All required parameters must be populated in order to send to Azure.

    :ivar spark_job_entry_type: Required. [Required] Type of the job's entry point.Constant filled
     by server. Possible values include: "SparkJobPythonEntry", "SparkJobScalaEntry".
    :vartype spark_job_entry_type: str or
     ~azure.mgmt.machinelearningservices.models.SparkJobEntryType
    """

    _validation = {
        'spark_job_entry_type': {'required': True},
    }

    _attribute_map = {
        'spark_job_entry_type': {'key': 'sparkJobEntryType', 'type': 'str'},
    }

    _subtype_map = {
        'spark_job_entry_type': {'SparkJobPythonEntry': 'SparkJobPythonEntry', 'SparkJobScalaEntry': 'SparkJobScalaEntry'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(SparkJobEntry, self).__init__(**kwargs)
        self.spark_job_entry_type = None  # type: Optional[str]


class SparkJobPythonEntry(SparkJobEntry):
    """SparkJobPythonEntry.

    All required parameters must be populated in order to send to Azure.

    :ivar spark_job_entry_type: Required. [Required] Type of the job's entry point.Constant filled
     by server. Possible values include: "SparkJobPythonEntry", "SparkJobScalaEntry".
    :vartype spark_job_entry_type: str or
     ~azure.mgmt.machinelearningservices.models.SparkJobEntryType
    :ivar file: Required. [Required] Relative python file path for job entry point.
    :vartype file: str
    """

    _validation = {
        'spark_job_entry_type': {'required': True},
        'file': {'required': True, 'min_length': 1, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'spark_job_entry_type': {'key': 'sparkJobEntryType', 'type': 'str'},
        'file': {'key': 'file', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        file: str,
        **kwargs
    ):
        """
        :keyword file: Required. [Required] Relative python file path for job entry point.
        :paramtype file: str
        """
        super(SparkJobPythonEntry, self).__init__(**kwargs)
        self.spark_job_entry_type = 'SparkJobPythonEntry'  # type: str
        self.file = file


class SparkJobScalaEntry(SparkJobEntry):
    """SparkJobScalaEntry.

    All required parameters must be populated in order to send to Azure.

    :ivar spark_job_entry_type: Required. [Required] Type of the job's entry point.Constant filled
     by server. Possible values include: "SparkJobPythonEntry", "SparkJobScalaEntry".
    :vartype spark_job_entry_type: str or
     ~azure.mgmt.machinelearningservices.models.SparkJobEntryType
    :ivar class_name: Required. [Required] Scala class name used as entry point.
    :vartype class_name: str
    """

    _validation = {
        'spark_job_entry_type': {'required': True},
        'class_name': {'required': True, 'min_length': 1, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'spark_job_entry_type': {'key': 'sparkJobEntryType', 'type': 'str'},
        'class_name': {'key': 'className', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        class_name: str,
        **kwargs
    ):
        """
        :keyword class_name: Required. [Required] Scala class name used as entry point.
        :paramtype class_name: str
        """
        super(SparkJobScalaEntry, self).__init__(**kwargs)
        self.spark_job_entry_type = 'SparkJobScalaEntry'  # type: str
        self.class_name = class_name


class SparkResourceConfiguration(msrest.serialization.Model):
    """SparkResourceConfiguration.

    :ivar instance_type: Optional type of VM used as supported by the compute target.
    :vartype instance_type: str
    :ivar runtime_version: Version of spark runtime used for the job.
    :vartype runtime_version: str
    """

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'runtime_version': {'key': 'runtimeVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        instance_type: Optional[str] = None,
        runtime_version: Optional[str] = "3.1",
        **kwargs
    ):
        """
        :keyword instance_type: Optional type of VM used as supported by the compute target.
        :paramtype instance_type: str
        :keyword runtime_version: Version of spark runtime used for the job.
        :paramtype runtime_version: str
        """
        super(SparkResourceConfiguration, self).__init__(**kwargs)
        self.instance_type = instance_type
        self.runtime_version = runtime_version


class SslConfiguration(msrest.serialization.Model):
    """The ssl configuration for scoring.

    :ivar status: Enable or disable ssl for scoring. Possible values include: "Disabled",
     "Enabled", "Auto".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.SslConfigStatus
    :ivar cert: Cert data.
    :vartype cert: str
    :ivar key: Key data.
    :vartype key: str
    :ivar cname: CNAME of the cert.
    :vartype cname: str
    :ivar leaf_domain_label: Leaf domain label of public endpoint.
    :vartype leaf_domain_label: str
    :ivar overwrite_existing_domain: Indicates whether to overwrite existing domain label.
    :vartype overwrite_existing_domain: bool
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'cert': {'key': 'cert', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'cname': {'key': 'cname', 'type': 'str'},
        'leaf_domain_label': {'key': 'leafDomainLabel', 'type': 'str'},
        'overwrite_existing_domain': {'key': 'overwriteExistingDomain', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "SslConfigStatus"]] = None,
        cert: Optional[str] = None,
        key: Optional[str] = None,
        cname: Optional[str] = None,
        leaf_domain_label: Optional[str] = None,
        overwrite_existing_domain: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword status: Enable or disable ssl for scoring. Possible values include: "Disabled",
         "Enabled", "Auto".
        :paramtype status: str or ~azure.mgmt.machinelearningservices.models.SslConfigStatus
        :keyword cert: Cert data.
        :paramtype cert: str
        :keyword key: Key data.
        :paramtype key: str
        :keyword cname: CNAME of the cert.
        :paramtype cname: str
        :keyword leaf_domain_label: Leaf domain label of public endpoint.
        :paramtype leaf_domain_label: str
        :keyword overwrite_existing_domain: Indicates whether to overwrite existing domain label.
        :paramtype overwrite_existing_domain: bool
        """
        super(SslConfiguration, self).__init__(**kwargs)
        self.status = status
        self.cert = cert
        self.key = key
        self.cname = cname
        self.leaf_domain_label = leaf_domain_label
        self.overwrite_existing_domain = overwrite_existing_domain


class StackEnsembleSettings(msrest.serialization.Model):
    """Advances setting to customize StackEnsemble run.

    :ivar stack_meta_learner_k_wargs: Optional parameters to pass to the initializer of the
     meta-learner.
    :vartype stack_meta_learner_k_wargs: any
    :ivar stack_meta_learner_train_percentage: Specifies the proportion of the training set (when
     choosing train and validation type of training) to be reserved for training the meta-learner.
     Default value is 0.2.
    :vartype stack_meta_learner_train_percentage: float
    :ivar stack_meta_learner_type: The meta-learner is a model trained on the output of the
     individual heterogeneous models. Possible values include: "None", "LogisticRegression",
     "LogisticRegressionCV", "LightGBMClassifier", "ElasticNet", "ElasticNetCV",
     "LightGBMRegressor", "LinearRegression".
    :vartype stack_meta_learner_type: str or
     ~azure.mgmt.machinelearningservices.models.StackMetaLearnerType
    """

    _attribute_map = {
        'stack_meta_learner_k_wargs': {'key': 'stackMetaLearnerKWargs', 'type': 'object'},
        'stack_meta_learner_train_percentage': {'key': 'stackMetaLearnerTrainPercentage', 'type': 'float'},
        'stack_meta_learner_type': {'key': 'stackMetaLearnerType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        stack_meta_learner_k_wargs: Optional[Any] = None,
        stack_meta_learner_train_percentage: Optional[float] = 0.2,
        stack_meta_learner_type: Optional[Union[str, "StackMetaLearnerType"]] = None,
        **kwargs
    ):
        """
        :keyword stack_meta_learner_k_wargs: Optional parameters to pass to the initializer of the
         meta-learner.
        :paramtype stack_meta_learner_k_wargs: any
        :keyword stack_meta_learner_train_percentage: Specifies the proportion of the training set
         (when choosing train and validation type of training) to be reserved for training the
         meta-learner. Default value is 0.2.
        :paramtype stack_meta_learner_train_percentage: float
        :keyword stack_meta_learner_type: The meta-learner is a model trained on the output of the
         individual heterogeneous models. Possible values include: "None", "LogisticRegression",
         "LogisticRegressionCV", "LightGBMClassifier", "ElasticNet", "ElasticNetCV",
         "LightGBMRegressor", "LinearRegression".
        :paramtype stack_meta_learner_type: str or
         ~azure.mgmt.machinelearningservices.models.StackMetaLearnerType
        """
        super(StackEnsembleSettings, self).__init__(**kwargs)
        self.stack_meta_learner_k_wargs = stack_meta_learner_k_wargs
        self.stack_meta_learner_train_percentage = stack_meta_learner_train_percentage
        self.stack_meta_learner_type = stack_meta_learner_type


class StatusMessage(msrest.serialization.Model):
    """Active message associated with project.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Service-defined message code.
    :vartype code: str
    :ivar created_date_time: Time in UTC at which the message was created.
    :vartype created_date_time: ~datetime.datetime
    :ivar level: Severity level of message. Possible values include: "Error", "Information",
     "Warning".
    :vartype level: str or ~azure.mgmt.machinelearningservices.models.StatusMessageLevel
    :ivar message: A human-readable representation of the message code.
    :vartype message: str
    """

    _validation = {
        'code': {'readonly': True},
        'created_date_time': {'readonly': True},
        'level': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'level': {'key': 'level', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(StatusMessage, self).__init__(**kwargs)
        self.code = None
        self.created_date_time = None
        self.level = None
        self.message = None


class StorageAccountDetails(msrest.serialization.Model):
    """Details of storage account to be used for the Registry.

    :ivar system_created_storage_account:
    :vartype system_created_storage_account:
     ~azure.mgmt.machinelearningservices.models.SystemCreatedStorageAccount
    :ivar user_created_storage_account:
    :vartype user_created_storage_account:
     ~azure.mgmt.machinelearningservices.models.UserCreatedStorageAccount
    """

    _attribute_map = {
        'system_created_storage_account': {'key': 'systemCreatedStorageAccount', 'type': 'SystemCreatedStorageAccount'},
        'user_created_storage_account': {'key': 'userCreatedStorageAccount', 'type': 'UserCreatedStorageAccount'},
    }

    def __init__(
        self,
        *,
        system_created_storage_account: Optional["SystemCreatedStorageAccount"] = None,
        user_created_storage_account: Optional["UserCreatedStorageAccount"] = None,
        **kwargs
    ):
        """
        :keyword system_created_storage_account:
        :paramtype system_created_storage_account:
         ~azure.mgmt.machinelearningservices.models.SystemCreatedStorageAccount
        :keyword user_created_storage_account:
        :paramtype user_created_storage_account:
         ~azure.mgmt.machinelearningservices.models.UserCreatedStorageAccount
        """
        super(StorageAccountDetails, self).__init__(**kwargs)
        self.system_created_storage_account = system_created_storage_account
        self.user_created_storage_account = user_created_storage_account


class SweepJob(JobBaseProperties):
    """Sweep job definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar component_id: ARM resource ID of the component resource.
    :vartype component_id: str
    :ivar compute_id: ARM resource ID of the compute resource.
    :vartype compute_id: str
    :ivar display_name: Display name of job.
    :vartype display_name: str
    :ivar experiment_name: The name of the experiment the job belongs to. If not set, the job is
     placed in the "Default" experiment.
    :vartype experiment_name: str
    :ivar identity: Identity configuration. If set, this should be one of AmlToken,
     ManagedIdentity, UserIdentity or null.
     Defaults to AmlToken if null.
    :vartype identity: ~azure.mgmt.machinelearningservices.models.IdentityConfiguration
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar job_type: Required. [Required] Specifies the type of job.Constant filled by server.
     Possible values include: "AutoML", "Command", "Labeling", "Sweep", "Pipeline", "Spark".
    :vartype job_type: str or ~azure.mgmt.machinelearningservices.models.JobType
    :ivar services: List of JobEndpoints.
     For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
    :vartype services: dict[str, ~azure.mgmt.machinelearningservices.models.JobService]
    :ivar status: Status of the job. Possible values include: "NotStarted", "Starting",
     "Provisioning", "Preparing", "Queued", "Running", "Finalizing", "CancelRequested", "Completed",
     "Failed", "Canceled", "NotResponding", "Paused", "Unknown", "Scheduled".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.JobStatus
    :ivar early_termination: Early termination policies enable canceling poor-performing runs
     before they complete.
    :vartype early_termination: ~azure.mgmt.machinelearningservices.models.EarlyTerminationPolicy
    :ivar inputs: Mapping of input data bindings used in the job.
    :vartype inputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobInput]
    :ivar limits: Sweep Job limit.
    :vartype limits: ~azure.mgmt.machinelearningservices.models.SweepJobLimits
    :ivar objective: Required. [Required] Optimization objective.
    :vartype objective: ~azure.mgmt.machinelearningservices.models.Objective
    :ivar outputs: Mapping of output data bindings used in the job.
    :vartype outputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobOutput]
    :ivar sampling_algorithm: Required. [Required] The hyperparameter sampling algorithm.
    :vartype sampling_algorithm: ~azure.mgmt.machinelearningservices.models.SamplingAlgorithm
    :ivar search_space: Required. [Required] A dictionary containing each parameter and its
     distribution. The dictionary key is the name of the parameter.
    :vartype search_space: any
    :ivar trial: Required. [Required] Trial component definition.
    :vartype trial: ~azure.mgmt.machinelearningservices.models.TrialComponent
    """

    _validation = {
        'job_type': {'required': True},
        'status': {'readonly': True},
        'objective': {'required': True},
        'sampling_algorithm': {'required': True},
        'search_space': {'required': True},
        'trial': {'required': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'component_id': {'key': 'componentId', 'type': 'str'},
        'compute_id': {'key': 'computeId', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'experiment_name': {'key': 'experimentName', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'IdentityConfiguration'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'job_type': {'key': 'jobType', 'type': 'str'},
        'services': {'key': 'services', 'type': '{JobService}'},
        'status': {'key': 'status', 'type': 'str'},
        'early_termination': {'key': 'earlyTermination', 'type': 'EarlyTerminationPolicy'},
        'inputs': {'key': 'inputs', 'type': '{JobInput}'},
        'limits': {'key': 'limits', 'type': 'SweepJobLimits'},
        'objective': {'key': 'objective', 'type': 'Objective'},
        'outputs': {'key': 'outputs', 'type': '{JobOutput}'},
        'sampling_algorithm': {'key': 'samplingAlgorithm', 'type': 'SamplingAlgorithm'},
        'search_space': {'key': 'searchSpace', 'type': 'object'},
        'trial': {'key': 'trial', 'type': 'TrialComponent'},
    }

    def __init__(
        self,
        *,
        objective: "Objective",
        sampling_algorithm: "SamplingAlgorithm",
        search_space: Any,
        trial: "TrialComponent",
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        component_id: Optional[str] = None,
        compute_id: Optional[str] = None,
        display_name: Optional[str] = None,
        experiment_name: Optional[str] = "Default",
        identity: Optional["IdentityConfiguration"] = None,
        is_archived: Optional[bool] = False,
        services: Optional[Dict[str, "JobService"]] = None,
        early_termination: Optional["EarlyTerminationPolicy"] = None,
        inputs: Optional[Dict[str, "JobInput"]] = None,
        limits: Optional["SweepJobLimits"] = None,
        outputs: Optional[Dict[str, "JobOutput"]] = None,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword component_id: ARM resource ID of the component resource.
        :paramtype component_id: str
        :keyword compute_id: ARM resource ID of the compute resource.
        :paramtype compute_id: str
        :keyword display_name: Display name of job.
        :paramtype display_name: str
        :keyword experiment_name: The name of the experiment the job belongs to. If not set, the job is
         placed in the "Default" experiment.
        :paramtype experiment_name: str
        :keyword identity: Identity configuration. If set, this should be one of AmlToken,
         ManagedIdentity, UserIdentity or null.
         Defaults to AmlToken if null.
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.IdentityConfiguration
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword services: List of JobEndpoints.
         For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        :paramtype services: dict[str, ~azure.mgmt.machinelearningservices.models.JobService]
        :keyword early_termination: Early termination policies enable canceling poor-performing runs
         before they complete.
        :paramtype early_termination: ~azure.mgmt.machinelearningservices.models.EarlyTerminationPolicy
        :keyword inputs: Mapping of input data bindings used in the job.
        :paramtype inputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobInput]
        :keyword limits: Sweep Job limit.
        :paramtype limits: ~azure.mgmt.machinelearningservices.models.SweepJobLimits
        :keyword objective: Required. [Required] Optimization objective.
        :paramtype objective: ~azure.mgmt.machinelearningservices.models.Objective
        :keyword outputs: Mapping of output data bindings used in the job.
        :paramtype outputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobOutput]
        :keyword sampling_algorithm: Required. [Required] The hyperparameter sampling algorithm.
        :paramtype sampling_algorithm: ~azure.mgmt.machinelearningservices.models.SamplingAlgorithm
        :keyword search_space: Required. [Required] A dictionary containing each parameter and its
         distribution. The dictionary key is the name of the parameter.
        :paramtype search_space: any
        :keyword trial: Required. [Required] Trial component definition.
        :paramtype trial: ~azure.mgmt.machinelearningservices.models.TrialComponent
        """
        super(SweepJob, self).__init__(description=description, properties=properties, tags=tags, component_id=component_id, compute_id=compute_id, display_name=display_name, experiment_name=experiment_name, identity=identity, is_archived=is_archived, services=services, **kwargs)
        self.job_type = 'Sweep'  # type: str
        self.early_termination = early_termination
        self.inputs = inputs
        self.limits = limits
        self.objective = objective
        self.outputs = outputs
        self.sampling_algorithm = sampling_algorithm
        self.search_space = search_space
        self.trial = trial


class SweepJobLimits(JobLimits):
    """Sweep Job limit class.

    All required parameters must be populated in order to send to Azure.

    :ivar job_limits_type: Required. [Required] JobLimit type.Constant filled by server. Possible
     values include: "Command", "Sweep".
    :vartype job_limits_type: str or ~azure.mgmt.machinelearningservices.models.JobLimitsType
    :ivar timeout: The max run duration in ISO 8601 format, after which the job will be cancelled.
     Only supports duration with precision as low as Seconds.
    :vartype timeout: ~datetime.timedelta
    :ivar max_concurrent_trials: Sweep Job max concurrent trials.
    :vartype max_concurrent_trials: int
    :ivar max_total_trials: Sweep Job max total trials.
    :vartype max_total_trials: int
    :ivar trial_timeout: Sweep Job Trial timeout value.
    :vartype trial_timeout: ~datetime.timedelta
    """

    _validation = {
        'job_limits_type': {'required': True},
    }

    _attribute_map = {
        'job_limits_type': {'key': 'jobLimitsType', 'type': 'str'},
        'timeout': {'key': 'timeout', 'type': 'duration'},
        'max_concurrent_trials': {'key': 'maxConcurrentTrials', 'type': 'int'},
        'max_total_trials': {'key': 'maxTotalTrials', 'type': 'int'},
        'trial_timeout': {'key': 'trialTimeout', 'type': 'duration'},
    }

    def __init__(
        self,
        *,
        timeout: Optional[datetime.timedelta] = None,
        max_concurrent_trials: Optional[int] = None,
        max_total_trials: Optional[int] = None,
        trial_timeout: Optional[datetime.timedelta] = None,
        **kwargs
    ):
        """
        :keyword timeout: The max run duration in ISO 8601 format, after which the job will be
         cancelled. Only supports duration with precision as low as Seconds.
        :paramtype timeout: ~datetime.timedelta
        :keyword max_concurrent_trials: Sweep Job max concurrent trials.
        :paramtype max_concurrent_trials: int
        :keyword max_total_trials: Sweep Job max total trials.
        :paramtype max_total_trials: int
        :keyword trial_timeout: Sweep Job Trial timeout value.
        :paramtype trial_timeout: ~datetime.timedelta
        """
        super(SweepJobLimits, self).__init__(timeout=timeout, **kwargs)
        self.job_limits_type = 'Sweep'  # type: str
        self.max_concurrent_trials = max_concurrent_trials
        self.max_total_trials = max_total_trials
        self.trial_timeout = trial_timeout


class SynapseSpark(Compute):
    """A SynapseSpark compute.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar compute_type: Required. The type of compute.Constant filled by server. Possible values
     include: "AKS", "Kubernetes", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine",
     "HDInsight", "Databricks", "DataLakeAnalytics", "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :ivar compute_location: Location for the underlying compute.
    :vartype compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values are Unknown,
     Updating, Provisioning, Succeeded, and Failed. Possible values include: "Unknown", "Updating",
     "Creating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ComputeProvisioningState
    :ivar description: The description of the Machine Learning compute.
    :vartype description: str
    :ivar created_on: The time at which the compute was created.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: The time at which the compute was last modified.
    :vartype modified_on: ~datetime.datetime
    :ivar resource_id: ARM resource id of the underlying compute.
    :vartype resource_id: str
    :ivar provisioning_errors: Errors during provisioning.
    :vartype provisioning_errors: list[~azure.mgmt.machinelearningservices.models.ErrorResponse]
    :ivar is_attached_compute: Indicating whether the compute was provisioned by user and brought
     from outside if true, or machine learning service provisioned it if false.
    :vartype is_attached_compute: bool
    :ivar disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI
     and AAD exclusively for authentication.
    :vartype disable_local_auth: bool
    :ivar properties:
    :vartype properties: ~azure.mgmt.machinelearningservices.models.SynapseSparkProperties
    """

    _validation = {
        'compute_type': {'required': True},
        'compute_location': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'modified_on': {'readonly': True},
        'provisioning_errors': {'readonly': True},
        'is_attached_compute': {'readonly': True},
        'disable_local_auth': {'readonly': True},
    }

    _attribute_map = {
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'compute_location': {'key': 'computeLocation', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'modified_on': {'key': 'modifiedOn', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'provisioning_errors': {'key': 'provisioningErrors', 'type': '[ErrorResponse]'},
        'is_attached_compute': {'key': 'isAttachedCompute', 'type': 'bool'},
        'disable_local_auth': {'key': 'disableLocalAuth', 'type': 'bool'},
        'properties': {'key': 'properties', 'type': 'SynapseSparkProperties'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        resource_id: Optional[str] = None,
        properties: Optional["SynapseSparkProperties"] = None,
        **kwargs
    ):
        """
        :keyword description: The description of the Machine Learning compute.
        :paramtype description: str
        :keyword resource_id: ARM resource id of the underlying compute.
        :paramtype resource_id: str
        :keyword properties:
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.SynapseSparkProperties
        """
        super(SynapseSpark, self).__init__(description=description, resource_id=resource_id, **kwargs)
        self.compute_type = 'SynapseSpark'  # type: str
        self.properties = properties


class SynapseSparkProperties(msrest.serialization.Model):
    """SynapseSparkProperties.

    :ivar auto_scale_properties: Auto scale properties.
    :vartype auto_scale_properties: ~azure.mgmt.machinelearningservices.models.AutoScaleProperties
    :ivar auto_pause_properties: Auto pause properties.
    :vartype auto_pause_properties: ~azure.mgmt.machinelearningservices.models.AutoPauseProperties
    :ivar spark_version: Spark version.
    :vartype spark_version: str
    :ivar node_count: The number of compute nodes currently assigned to the compute.
    :vartype node_count: int
    :ivar node_size: Node size.
    :vartype node_size: str
    :ivar node_size_family: Node size family.
    :vartype node_size_family: str
    :ivar subscription_id: Azure subscription identifier.
    :vartype subscription_id: str
    :ivar resource_group: Name of the resource group in which workspace is located.
    :vartype resource_group: str
    :ivar workspace_name: Name of Azure Machine Learning workspace.
    :vartype workspace_name: str
    :ivar pool_name: Pool name.
    :vartype pool_name: str
    """

    _attribute_map = {
        'auto_scale_properties': {'key': 'autoScaleProperties', 'type': 'AutoScaleProperties'},
        'auto_pause_properties': {'key': 'autoPauseProperties', 'type': 'AutoPauseProperties'},
        'spark_version': {'key': 'sparkVersion', 'type': 'str'},
        'node_count': {'key': 'nodeCount', 'type': 'int'},
        'node_size': {'key': 'nodeSize', 'type': 'str'},
        'node_size_family': {'key': 'nodeSizeFamily', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
        'workspace_name': {'key': 'workspaceName', 'type': 'str'},
        'pool_name': {'key': 'poolName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        auto_scale_properties: Optional["AutoScaleProperties"] = None,
        auto_pause_properties: Optional["AutoPauseProperties"] = None,
        spark_version: Optional[str] = None,
        node_count: Optional[int] = None,
        node_size: Optional[str] = None,
        node_size_family: Optional[str] = None,
        subscription_id: Optional[str] = None,
        resource_group: Optional[str] = None,
        workspace_name: Optional[str] = None,
        pool_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword auto_scale_properties: Auto scale properties.
        :paramtype auto_scale_properties:
         ~azure.mgmt.machinelearningservices.models.AutoScaleProperties
        :keyword auto_pause_properties: Auto pause properties.
        :paramtype auto_pause_properties:
         ~azure.mgmt.machinelearningservices.models.AutoPauseProperties
        :keyword spark_version: Spark version.
        :paramtype spark_version: str
        :keyword node_count: The number of compute nodes currently assigned to the compute.
        :paramtype node_count: int
        :keyword node_size: Node size.
        :paramtype node_size: str
        :keyword node_size_family: Node size family.
        :paramtype node_size_family: str
        :keyword subscription_id: Azure subscription identifier.
        :paramtype subscription_id: str
        :keyword resource_group: Name of the resource group in which workspace is located.
        :paramtype resource_group: str
        :keyword workspace_name: Name of Azure Machine Learning workspace.
        :paramtype workspace_name: str
        :keyword pool_name: Pool name.
        :paramtype pool_name: str
        """
        super(SynapseSparkProperties, self).__init__(**kwargs)
        self.auto_scale_properties = auto_scale_properties
        self.auto_pause_properties = auto_pause_properties
        self.spark_version = spark_version
        self.node_count = node_count
        self.node_size = node_size
        self.node_size_family = node_size_family
        self.subscription_id = subscription_id
        self.resource_group = resource_group
        self.workspace_name = workspace_name
        self.pool_name = pool_name


class SystemCreatedAcrAccount(msrest.serialization.Model):
    """SystemCreatedAcrAccount.

    :ivar acr_account_sku:
    :vartype acr_account_sku: str
    :ivar arm_resource_id: ARM ResourceId of a resource.
    :vartype arm_resource_id: ~azure.mgmt.machinelearningservices.models.ArmResourceId
    """

    _attribute_map = {
        'acr_account_sku': {'key': 'acrAccountSku', 'type': 'str'},
        'arm_resource_id': {'key': 'armResourceId', 'type': 'ArmResourceId'},
    }

    def __init__(
        self,
        *,
        acr_account_sku: Optional[str] = None,
        arm_resource_id: Optional["ArmResourceId"] = None,
        **kwargs
    ):
        """
        :keyword acr_account_sku:
        :paramtype acr_account_sku: str
        :keyword arm_resource_id: ARM ResourceId of a resource.
        :paramtype arm_resource_id: ~azure.mgmt.machinelearningservices.models.ArmResourceId
        """
        super(SystemCreatedAcrAccount, self).__init__(**kwargs)
        self.acr_account_sku = acr_account_sku
        self.arm_resource_id = arm_resource_id


class SystemCreatedStorageAccount(msrest.serialization.Model):
    """SystemCreatedStorageAccount.

    :ivar arm_resource_id: ARM ResourceId of a resource.
    :vartype arm_resource_id: ~az