/* FilenameFilter.java -- Filter a list of filenames
   Copyright (C) 1998, 1999, 2001, 2003, 2005  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.
 
GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


package java.io;

/* Written using "Java Class Libraries", 2nd edition, ISBN 0-201-31002-3
 * "The Java Language Specification", ISBN 0-201-63451-1
 * Status:  Complete to 1.1.
 */

/**
 * This interface has one method which is used for filtering filenames
 * returned in a directory listing.  It is currently used by the 
 * <code>File.list(FilenameFilter)</code> method and by the filename 
 * dialog in AWT.
 * <p>
 * The method in this interface determines if a particular file should
 * or should not be included in the file listing.
 *
 * @author Aaron M. Renn (arenn@urbanophile.com)
 * @author Tom Tromey (tromey@cygnus.com)
 *
 * @see File#listFiles(java.io.FilenameFilter)
 * @see java.awt.FileDialog#setFilenameFilter(java.io.FilenameFilter)
 */
public interface FilenameFilter
{
  /**
   * This method determines whether or not a given file should be included
   * in a directory listing.
   *
   * @param dir The <code>File</code> instance for the directory being read
   * @param name The name of the file to test
   *
   * @return <code>true</code> if the file should be included in the list,
   * <code>false</code> otherwise.
   */
  boolean accept(File dir, String name);

} // interface FilenameFilter

