
/**
 *
 *  This file is part of the kdewebdev package
 *  Copyright (c) 2002 Keith Isdale <keith@kdewebdev.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 **/

#ifndef XSLDBGOUTPUTVIEW_H
#define XSLDBGOUTPUTVIEW_H

/**
  *@author Keith Isdale
  */
#include <QTextEdit>
#include <QMessageBox>

class QDialog;
class XsldbgMsgDialogImpl;

class XsldbgOutputView : public QTextEdit {
  Q_OBJECT
  
public :
    XsldbgOutputView(QWidget *parent = 0);

   void showDialog(QMessageBox::Icon icon, QString title, QString msg);
  
public slots:	
    /** Process a copy of mesage sent to message window */
    void slotProcShowMessage(QString  msg);	
 
    /** Clear message view window of its text */
     void slotClearView();

 private:

     XsldbgMsgDialogImpl *dlg;
     
};

#endif /*  XSLDBGOUTPUTVIEW_H */
