ALLOW_THREADS = 0
BUFSIZE = 0
CLIP = 0
class ComplexWarning:
    args = None
    message = None
    

class DataSource:
    def abspath(self,path):
        """       Return absolute path of file in the DataSource directory.
               If `path` is an URL, then `abspath` will return either the location
               the file exists locally or the location it would exist when opened
               using the `open` method.
               Parameters
               ----------
               path : str
                   Can be a local file or a remote URL.
               Returns
               -------
               out : str
                   Complete path, including the `DataSource` destination directory.
               Notes
               -----
               The functionality is based on `os.path.abspath`.
               
        """
        
        
        return str()
    def exists(self,path):
        """       Test if path exists.
               Test if `path` exists as (and in this order):
               - a local file.
               - a remote URL that has been downloaded and stored locally in the
                 `DataSource` directory.
               - a remote URL that has not been downloaded, but is valid and accessible.
               Parameters
               ----------
               path : str
                   Can be a local file or a remote URL.
               Returns
               -------
               out : bool
                   True if `path` exists.
               Notes
               -----
               When `path` is an URL, `exists` will return True if it's either stored
               locally in the `DataSource` directory, or is a valid remote URL.
               `DataSource` does not discriminate between the two, the file is accessible
               if it exists in either location.
               
        """
        
        
        return bool()
    def open(self,path,mode):
        """       Open and return file-like object.
               If `path` is an URL, it will be downloaded, stored in the `DataSource`
               directory and opened from there.
               Parameters
               ----------
               path : str
                   Local file path or URL to open.
               mode : {'r', 'w', 'a'}, optional
                   Mode to open `path`.  Mode 'r' for reading, 'w' for writing, 'a' to
                   append. Available modes depend on the type of object specified by
                   `path`. Default is 'r'.
               Returns
               -------
               out : file object
                   File object.
               
        """
        
        
        return file()
    

ERR_CALL = 0
ERR_DEFAULT = 0
ERR_DEFAULT2 = 0
ERR_IGNORE = 0
ERR_LOG = 0
ERR_PRINT = 0
ERR_RAISE = 0
ERR_WARN = 0
FLOATING_POINT_SUPPORT = 0
FPE_DIVIDEBYZERO = 0
FPE_INVALID = 0
FPE_OVERFLOW = 0
FPE_UNDERFLOW = 0
False_ = False
Inf = 0.0
Infinity = 0.0
MAXDIMS = 0
class MachAr:
    pass

NAN = 0.0
NINF = 0.0
NZERO = 0.0
NaN = 0.0
PINF = 0.0
PZERO = 0.0
PackageLoader = PackageLoader()
RAISE = 0
class RankWarning:
    args = None
    message = None
    

SHIFT_DIVIDEBYZERO = 0
SHIFT_INVALID = 0
SHIFT_OVERFLOW = 0
SHIFT_UNDERFLOW = 0
ScalarType = ()
class Tester:
    def bench(self,label,verbose,extra_argv):
        """       Run benchmarks for module using nose.
               Parameters
               ----------
               label : {'fast', 'full', '', attribute identifier}, optional
                   Identifies the tests to run. This can be a string to pass to the
                   nosetests executable with the '-A' option, or one of
                   several special values.
                   Special values are:
                       'fast' - the default - which corresponds to the ``nosetests -A``
                                option of 'not slow'.
                       'full' - fast (as above) and slow tests as in the
                                'no -A' option to nosetests - this is the same as ''.
                   None or '' - run all tests.
                   attribute_identifier - string passed directly to nosetests as '-A'.
               verbose : int, optional
                   Verbosity value for test outputs, in the range 1-10. Default is 1.
               extra_argv : list, optional
                   List with any extra arguments to pass to nosetests.
               Returns
               -------
               success : bool
                   Returns True if running the benchmarks works, False if an error
                   occurred.
               Notes
               -----
               Benchmarks are like tests, but have names starting with "bench" instead
               of "test", and can be found under the "benchmarks" sub-directory of the
               module.
               Each NumPy module exposes `bench` in its namespace to run all benchmarks
               for it.
               Examples
               --------
               >>> success = np.lib.bench()
               Running benchmarks for numpy.lib
               ...
               using 562341 items:
               unique:
               0.11
               unique1d:
               0.11
               ratio: 1.0
               nUnique: 56230 == 56230
               ...
               OK
               >>> success
               True
               
        """
        
        
        return bool()
    def prepare_test_args(self):
        """       Run tests for module using nose.
               This method does the heavy lifting for the `test` method. It takes all
               the same arguments, for details see `test`.
               See Also
               --------
               test
               
        """
        
        
        return None
    def test(self,label,verbose,extra_argv,doctests,coverage):
        """       Run tests for module using nose.
               Parameters
               ----------
               label : {'fast', 'full', '', attribute identifier}, optional
                   Identifies the tests to run. This can be a string to pass to the
                   nosetests executable with the '-A' option, or one of
                   several special values.
                   Special values are:
                       'fast' - the default - which corresponds to the ``nosetests -A``
                                option of 'not slow'.
                       'full' - fast (as above) and slow tests as in the
                                'no -A' option to nosetests - this is the same as ''.
                   None or '' - run all tests.
                   attribute_identifier - string passed directly to nosetests as '-A'.
               verbose : int, optional
                   Verbosity value for test outputs, in the range 1-10. Default is 1.
               extra_argv : list, optional
                   List with any extra arguments to pass to nosetests.
               doctests : bool, optional
                   If True, run doctests in module. Default is False.
               coverage : bool, optional
                   If True, report coverage of NumPy code. Default is False.
                   (This requires the `coverage module:
                    <http://nedbatchelder.com/code/modules/coverage.html>`_).
               Returns
               -------
               result : object
                   Returns the result of running the tests as a
                   ``nose.result.TextTestResult`` object.
               Notes
               -----
               Each NumPy module exposes `test` in its namespace to run all tests for it.
               For example, to run all tests for numpy.lib::
                 >>> np.lib.test()
               Examples
               --------
               >>> result = np.lib.test()
               Running unit tests for numpy.lib
               ...
               Ran 976 tests in 3.933s
               OK
               >>> result.errors
               []
               >>> result.knownfail
               []
               
        """
        
        
        return object()
    

True_ = False
UFUNC_BUFSIZE_DEFAULT = 0
UFUNC_PYVALS_NAME = None
WRAP = 0
def abs(x):
    """absolute(x[, out])
    Calculate the absolute value element-wise.
    Parameters
    ----------
    x : array_like
       Input array.
    Returns
    -------
    absolute : ndarray
       An ndarray containing the absolute value of
       each element in `x`.  For complex input, ``a + ib``, the
       absolute value is :math:`\sqrt{ a^2 + b^2 }`.
    Examples
    --------
    >>> x = np.array([-1.2, 1.2])
    >>> np.absolute(x)
    array([ 1.2,  1.2])
    >>> np.absolute(1.2 + 1j)
    1.5620499351813308
    Plot the function over ``[-10, 10]``:
    >>> import matplotlib.pyplot as plt
    >>> x = np.linspace(-10, 10, 101)
    >>> plt.plot(x, np.absolute(x))
    >>> plt.show()
    Plot the function over the complex plane:
    >>> xx = x + 1j * x[:, np.newaxis]
    >>> plt.imshow(np.abs(xx), extent=[-10, 10, -10, 10])
    >>> plt.show()
    """
    
    
    return ndarray()
def absolute(x):
    """absolute(x[, out])
    Calculate the absolute value element-wise.
    Parameters
    ----------
    x : array_like
       Input array.
    Returns
    -------
    absolute : ndarray
       An ndarray containing the absolute value of
       each element in `x`.  For complex input, ``a + ib``, the
       absolute value is :math:`\sqrt{ a^2 + b^2 }`.
    Examples
    --------
    >>> x = np.array([-1.2, 1.2])
    >>> np.absolute(x)
    array([ 1.2,  1.2])
    >>> np.absolute(1.2 + 1j)
    1.5620499351813308
    Plot the function over ``[-10, 10]``:
    >>> import matplotlib.pyplot as plt
    >>> x = np.linspace(-10, 10, 101)
    >>> plt.plot(x, np.absolute(x))
    >>> plt.show()
    Plot the function over the complex plane:
    >>> xx = x + 1j * x[:, np.newaxis]
    >>> plt.imshow(np.abs(xx), extent=[-10, 10, -10, 10])
    >>> plt.show()
    """
    
    
    return ndarray()
def add(x1,x2):
    """add(x1, x2[, out])
    Add arguments element-wise.
    Parameters
    ----------
    x1, x2 : array_like
       The arrays to be added.  If ``x1.shape != x2.shape``, they must be
       broadcastable to a common shape (which may be the shape of one or
       the other).
    Returns
    -------
    y : ndarray or scalar
       The sum of `x1` and `x2`, element-wise.  Returns a scalar if
       both  `x1` and `x2` are scalars.
    Notes
    -----
    Equivalent to `x1` + `x2` in terms of array broadcasting.
    Examples
    --------
    >>> np.add(1.0, 4.0)
    5.0
    >>> x1 = np.arange(9.0).reshape((3, 3))
    >>> x2 = np.arange(3.0)
    >>> np.add(x1, x2)
    array([[  0.,   2.,   4.],
          [  3.,   5.,   7.],
          [  6.,   8.,  10.]])
    """
    
    
    return ndarray()
def add_docstring():
    """docstring(obj, docstring)
       Add a docstring to a built-in obj if possible.
       If the obj already has a docstring raise a RuntimeError
       If this routine does not know how to add a docstring to the object
       raise a TypeError
    """
    
    
    return None
def add_newdoc():
    """Adds documentation to obj which is in module place.
       If doc is a string add it to obj as a docstring
       If doc is a tuple, then the first element is interpreted as
          an attribute of obj and the second as the docstring
             (method, docstring)
       If doc is a list, then each element of the list should be a
          sequence of length two --> [(method1, docstring1),
          (method2, docstring2), ...]
       This routine never raises an error.
          
    """
    
    
    return None
add_newdocs = None
def alen(a):
    """   Return the length of the first dimension of the input array.
       Parameters
       ----------
       a : array_like
          Input array.
       Returns
       -------
       l : int
          Length of the first dimension of `a`.
       See Also
       --------
       shape, size
       Examples
       --------
       >>> a = np.zeros((7,4,5))
       >>> a.shape[0]
       7
       >>> np.alen(a)
       7
       
    """
    
    
    return int()
def all(a,axis,out):
    """   Test whether all array elements along a given axis evaluate to True.
       Parameters
       ----------
       a : array_like
           Input array or object that can be converted to an array.
       axis : int, optional
           Axis along which a logical AND is performed.
           The default (`axis` = `None`) is to perform a logical AND
           over a flattened input array.  `axis` may be negative, in which
           case it counts from the last to the first axis.
       out : ndarray, optional
           Alternate output array in which to place the result.
           It must have the same shape as the expected output and its
           type is preserved (e.g., if ``dtype(out)`` is float, the result
           will consist of 0.0's and 1.0's).  See `doc.ufuncs` (Section
           "Output arguments") for more details.
       Returns
       -------
       all : ndarray, bool
           A new boolean or array is returned unless `out` is specified,
           in which case a reference to `out` is returned.
       See Also
       --------
       ndarray.all : equivalent method
       any : Test whether any element along a given axis evaluates to True.
       Notes
       -----
       Not a Number (NaN), positive infinity and negative infinity
       evaluate to `True` because these are not equal to zero.
       Examples
       --------
       >>> np.all([[True,False],[True,True]])
       False
       >>> np.all([[True,False],[True,True]], axis=0)
       array([ True, False], dtype=bool)
       >>> np.all([-1, 4, 5])
       True
       >>> np.all([1.0, np.nan])
       True
       >>> o=np.array([False])
       >>> z=np.all([-1, 4, 5], out=o)
       >>> id(z), id(o), z                             # doctest: +SKIP
       (28293632, 28293632, array([ True], dtype=bool))
       
    """
    
    
    return ndarray()
def allclose(a,b,rtol,atol):
    """   Returns True if two arrays are element-wise equal within a tolerance.
       The tolerance values are positive, typically very small numbers.  The
       relative difference (`rtol` * abs(`b`)) and the absolute difference
       `atol` are added together to compare against the absolute difference
       between `a` and `b`.
       Parameters
       ----------
       a, b : array_like
           Input arrays to compare.
       rtol : float
           The relative tolerance parameter (see Notes).
       atol : float
           The absolute tolerance parameter (see Notes).
       Returns
       -------
       y : bool
           Returns True if the two arrays are equal within the given
           tolerance; False otherwise. If either array contains NaN, then
           False is returned.
       See Also
       --------
       all, any, alltrue, sometrue
       Notes
       -----
       If the following equation is element-wise True, then allclose returns
       True.
        absolute(`a` - `b`) <= (`atol` + `rtol` * absolute(`b`))
       The above equation is not symmetric in `a` and `b`, so that
       `allclose(a, b)` might be different from `allclose(b, a)` in
       some rare cases.
       Examples
       --------
       >>> np.allclose([1e10,1e-7], [1.00001e10,1e-8])
       False
       >>> np.allclose([1e10,1e-8], [1.00001e10,1e-9])
       True
       >>> np.allclose([1e10,1e-8], [1.0001e10,1e-9])
       False
       >>> np.allclose([1.0, np.nan], [1.0, np.nan])
       False
       
    """
    
    
    return bool()
def alltrue():
    """   Check if all elements of input array are true.
       See Also
       --------
       numpy.all : Equivalent function; see for details.
       
    """
    
    
    return None
def alterdot():
    """Change `dot`, `vdot`, and `innerproduct` to use accelerated BLAS functions.
       Typically, as a user of Numpy, you do not explicitly call this function. If
       Numpy is built with an accelerated BLAS, this function is automatically
       called when Numpy is imported.
       When Numpy is built with an accelerated BLAS like ATLAS, these functions
       are replaced to make use of the faster implementations.  The faster
       implementations only affect float32, float64, complex64, and complex128
       arrays. Furthermore, the BLAS API only includes matrix-matrix,
       matrix-vector, and vector-vector products. Products of arrays with larger
       dimensionalities use the built in functions and are not accelerated.
       See Also
       --------
       restoredot : `restoredot` undoes the effects of `alterdot`.
    """
    
    
    return None
def amax(a,axis,out):
    """   Return the maximum of an array or maximum along an axis.
       Parameters
       ----------
       a : array_like
           Input data.
       axis : int, optional
           Axis along which to operate.  By default flattened input is used.
       out : ndarray, optional
           Alternate output array in which to place the result.  Must be of
           the same shape and buffer length as the expected output.  See
           `doc.ufuncs` (Section "Output arguments") for more details.
       Returns
       -------
       amax : ndarray
           A new array or scalar array with the result.
       See Also
       --------
       nanmax : NaN values are ignored instead of being propagated.
       fmax : same behavior as the C99 fmax function.
       argmax : indices of the maximum values.
       Notes
       -----
       NaN values are propagated, that is if at least one item is NaN, the
       corresponding max value will be NaN as well.  To ignore NaN values
       (MATLAB behavior), please use nanmax.
       Examples
       --------
       >>> a = np.arange(4).reshape((2,2))
       >>> a
       array([[0, 1],
              [2, 3]])
       >>> np.amax(a)
       3
       >>> np.amax(a, axis=0)
       array([2, 3])
       >>> np.amax(a, axis=1)
       array([1, 3])
       >>> b = np.arange(5, dtype=np.float)
       >>> b[2] = np.NaN
       >>> np.amax(b)
       nan
       >>> np.nanmax(b)
       4.0
       
    """
    
    
    return ndarray()
def amin(a,axis,out):
    """   Return the minimum of an array or minimum along an axis.
       Parameters
       ----------
       a : array_like
           Input data.
       axis : int, optional
           Axis along which to operate.  By default a flattened input is used.
       out : ndarray, optional
           Alternative output array in which to place the result.  Must
           be of the same shape and buffer length as the expected output.
           See `doc.ufuncs` (Section "Output arguments") for more details.
       Returns
       -------
       amin : ndarray
           A new array or a scalar array with the result.
       See Also
       --------
       nanmin: nan values are ignored instead of being propagated
       fmin: same behavior as the C99 fmin function
       argmin: Return the indices of the minimum values.
       amax, nanmax, fmax
       Notes
       -----
       NaN values are propagated, that is if at least one item is nan, the
       corresponding min value will be nan as well. To ignore NaN values (matlab
       behavior), please use nanmin.
       Examples
       --------
       >>> a = np.arange(4).reshape((2,2))
       >>> a
       array([[0, 1],
              [2, 3]])
       >>> np.amin(a)           # Minimum of the flattened array
       0
       >>> np.amin(a, axis=0)         # Minima along the first axis
       array([0, 1])
       >>> np.amin(a, axis=1)         # Minima along the second axis
       array([0, 2])
       >>> b = np.arange(5, dtype=np.float)
       >>> b[2] = np.NaN
       >>> np.amin(b)
       nan
       >>> np.nanmin(b)
       0.0
       
    """
    
    
    return ndarray()
def angle(z,deg):
    """   Return the angle of the complex argument.
       Parameters
       ----------
       z : array_like
           A complex number or sequence of complex numbers.
       deg : bool, optional
           Return angle in degrees if True, radians if False (default).
       Returns
       -------
       angle : {ndarray, scalar}
           The counterclockwise angle from the positive real axis on
           the complex plane, with dtype as numpy.float64.
       See Also
       --------
       arctan2
       absolute
       Examples
       --------
       >>> np.angle([1.0, 1.0j, 1+1j])               # in radians
       array([ 0.        ,  1.57079633,  0.78539816])
       >>> np.angle(1+1j, deg=True)                  # in degrees
       45.0
       
    """
    
    
    return ndarray()
def any(a,axis,out):
    """   Test whether any array element along a given axis evaluates to True.
       Returns single boolean unless `axis` is not ``None``
       Parameters
       ----------
       a : array_like
           Input array or object that can be converted to an array.
       axis : int, optional
           Axis along which a logical OR is performed.  The default
           (`axis` = `None`) is to perform a logical OR over a flattened
           input array. `axis` may be negative, in which case it counts
           from the last to the first axis.
       out : ndarray, optional
           Alternate output array in which to place the result.  It must have
           the same shape as the expected output and its type is preserved
           (e.g., if it is of type float, then it will remain so, returning
           1.0 for True and 0.0 for False, regardless of the type of `a`).
           See `doc.ufuncs` (Section "Output arguments") for details.
       Returns
       -------
       any : bool or ndarray
           A new boolean or `ndarray` is returned unless `out` is specified,
           in which case a reference to `out` is returned.
       See Also
       --------
       ndarray.any : equivalent method
       all : Test whether all elements along a given axis evaluate to True.
       Notes
       -----
       Not a Number (NaN), positive infinity and negative infinity evaluate
       to `True` because these are not equal to zero.
       Examples
       --------
       >>> np.any([[True, False], [True, True]])
       True
       >>> np.any([[True, False], [False, False]], axis=0)
       array([ True, False], dtype=bool)
       >>> np.any([-1, 0, 5])
       True
       >>> np.any(np.nan)
       True
       >>> o=np.array([False])
       >>> z=np.any([-1, 4, 5], out=o)
       >>> z, o
       (array([ True], dtype=bool), array([ True], dtype=bool))
       >>> # Check now that z is a reference to o
       >>> z is o
       True
       >>> id(z), id(o) # identity of z and o              # doctest: +SKIP
       (191614240, 191614240)
       
    """
    
    
    return bool()
def append(arr,values,axis):
    """   Append values to the end of an array.
       Parameters
       ----------
       arr : array_like
           Values are appended to a copy of this array.
       values : array_like
           These values are appended to a copy of `arr`.  It must be of the
           correct shape (the same shape as `arr`, excluding `axis`).  If `axis`
           is not specified, `values` can be any shape and will be flattened
           before use.
       axis : int, optional
           The axis along which `values` are appended.  If `axis` is not given,
           both `arr` and `values` are flattened before use.
       Returns
       -------
       out : ndarray
           A copy of `arr` with `values` appended to `axis`.  Note that `append`
           does not occur in-place: a new array is allocated and filled.  If
           `axis` is None, `out` is a flattened array.
       See Also
       --------
       insert : Insert elements into an array.
       delete : Delete elements from an array.
       Examples
       --------
       >>> np.append([1, 2, 3], [[4, 5, 6], [7, 8, 9]])
       array([1, 2, 3, 4, 5, 6, 7, 8, 9])
       When `axis` is specified, `values` must have the correct shape.
       >>> np.append([[1, 2, 3], [4, 5, 6]], [[7, 8, 9]], axis=0)
       array([[1, 2, 3],
              [4, 5, 6],
              [7, 8, 9]])
       >>> np.append([[1, 2, 3], [4, 5, 6]], [7, 8, 9], axis=0)
       Traceback (most recent call last):
       ...
       ValueError: arrays must have same number of dimensions
       
    """
    
    
    return ndarray()
def apply_along_axis(func1d,axis,arr,args):
    """   Apply a function to 1-D slices along the given axis.
       Execute `func1d(a, *args)` where `func1d` operates on 1-D arrays and `a`
       is a 1-D slice of `arr` along `axis`.
       Parameters
       ----------
       func1d : function
           This function should accept 1-D arrays. It is applied to 1-D
           slices of `arr` along the specified axis.
       axis : integer
           Axis along which `arr` is sliced.
       arr : ndarray
           Input array.
       args : any
           Additional arguments to `func1d`.
       Returns
       -------
       outarr : ndarray
           The output array. The shape of `outarr` is identical to the shape of
           `arr`, except along the `axis` dimension, where the length of `outarr`
           is equal to the size of the return value of `func1d`.  If `func1d`
           returns a scalar `outarr` will have one fewer dimensions than `arr`.
       See Also
       --------
       apply_over_axes : Apply a function repeatedly over multiple axes.
       Examples
       --------
       >>> def my_func(a):
       ...     \"\"\"Average first and last element of a 1-D array\"\"\"
       ...     return (a[0] + a[-1]) * 0.5
       >>> b = np.array([[1,2,3], [4,5,6], [7,8,9]])
       >>> np.apply_along_axis(my_func, 0, b)
       array([ 4.,  5.,  6.])
       >>> np.apply_along_axis(my_func, 1, b)
       array([ 2.,  5.,  8.])
       For a function that doesn't return a scalar, the number of dimensions in
       `outarr` is the same as `arr`.
       >>> def new_func(a):
       ...     \"\"\"Divide elements of a by 2.\"\"\"
       ...     return a * 0.5
       >>> b = np.array([[1,2,3], [4,5,6], [7,8,9]])
       >>> np.apply_along_axis(new_func, 0, b)
       array([[ 0.5,  1. ,  1.5],
              [ 2. ,  2.5,  3. ],
              [ 3.5,  4. ,  4.5]])
       
    """
    
    
    return ndarray()
def apply_over_axes(func,a,axes):
    """   Apply a function repeatedly over multiple axes.
       `func` is called as `res = func(a, axis)`, where `axis` is the first
       element of `axes`.  The result `res` of the function call must have
       either the same dimensions as `a` or one less dimension.  If `res`
       has one less dimension than `a`, a dimension is inserted before
       `axis`.  The call to `func` is then repeated for each axis in `axes`,
       with `res` as the first argument.
       Parameters
       ----------
       func : function
           This function must take two arguments, `func(a, axis)`.
       a : array_like
           Input array.
       axes : array_like
           Axes over which `func` is applied; the elements must be integers.
       Returns
       -------
       val : ndarray
           The output array.  The number of dimensions is the same as `a`,
           but the shape can be different.  This depends on whether `func`
           changes the shape of its output with respect to its input.
       See Also
       --------
       apply_along_axis :
           Apply a function to 1-D slices of an array along the given axis.
       Examples
       --------
       >>> a = np.arange(24).reshape(2,3,4)
       >>> a
       array([[[ 0,  1,  2,  3],
               [ 4,  5,  6,  7],
               [ 8,  9, 10, 11]],
              [[12, 13, 14, 15],
               [16, 17, 18, 19],
               [20, 21, 22, 23]]])
       Sum over axes 0 and 2. The result has same number of dimensions
       as the original array:
       >>> np.apply_over_axes(np.sum, a, [0,2])
       array([[[ 60],
               [ 92],
               [124]]])
       
    """
    
    
    return ndarray()
def arange(start,stop,step,dtype):
    """arange([start,] stop[, step,], dtype=None)
       Return evenly spaced values within a given interval.
       Values are generated within the half-open interval ``[start, stop)``
       (in other words, the interval including `start` but excluding `stop`).
       For integer arguments the function is equivalent to the Python built-in
       `range <http://docs.python.org/lib/built-in-funcs.html>`_ function,
       but returns a ndarray rather than a list.
       Parameters
       ----------
       start : number, optional
           Start of interval.  The interval includes this value.  The default
           start value is 0.
       stop : number
           End of interval.  The interval does not include this value.
       step : number, optional
           Spacing between values.  For any output `out`, this is the distance
           between two adjacent values, ``out[i+1] - out[i]``.  The default
           step size is 1.  If `step` is specified, `start` must also be given.
       dtype : dtype
           The type of the output array.  If `dtype` is not given, infer the data
           type from the other input arguments.
       Returns
       -------
       out : ndarray
           Array of evenly spaced values.
           For floating point arguments, the length of the result is
           ``ceil((stop - start)/step)``.  Because of floating point overflow,
           this rule may result in the last element of `out` being greater
           than `stop`.
       See Also
       --------
       linspace : Evenly spaced numbers with careful handling of endpoints.
       ogrid: Arrays of evenly spaced numbers in N-dimensions
       mgrid: Grid-shaped arrays of evenly spaced numbers in N-dimensions
       Examples
       --------
       >>> np.arange(3)
       array([0, 1, 2])
       >>> np.arange(3.0)
       array([ 0.,  1.,  2.])
       >>> np.arange(3,7)
       array([3, 4, 5, 6])
       >>> np.arange(3,7,2)
       array([3, 5])
    """
    
    
    return ndarray()
def arccos(x,out):
    """arccos(x[, out])
    Trigonometric inverse cosine, element-wise.
    The inverse of `cos` so that, if ``y = cos(x)``, then ``x = arccos(y)``.
    Parameters
    ----------
    x : array_like
       `x`-coordinate on the unit circle.
       For real arguments, the domain is [-1, 1].
    out : ndarray, optional
       Array of the same shape as `a`, to store results in. See
       `doc.ufuncs` (Section "Output arguments") for more details.
    Returns
    -------
    angle : ndarray
       The angle of the ray intersecting the unit circle at the given
       `x`-coordinate in radians [0, pi]. If `x` is a scalar then a
       scalar is returned, otherwise an array of the same shape as `x`
       is returned.
    See Also
    --------
    cos, arctan, arcsin, emath.arccos
    Notes
    -----
    `arccos` is a multivalued function: for each `x` there are infinitely
    many numbers `z` such that `cos(z) = x`. The convention is to return
    the angle `z` whose real part lies in `[0, pi]`.
    For real-valued input data types, `arccos` always returns real output.
    For each value that cannot be expressed as a real number or infinity,
    it yields ``nan`` and sets the `invalid` floating point error flag.
    For complex-valued input, `arccos` is a complex analytic function that
    has branch cuts `[-inf, -1]` and `[1, inf]` and is continuous from
    above on the former and from below on the latter.
    The inverse `cos` is also known as `acos` or cos^-1.
    References
    ----------
    M. Abramowitz and I.A. Stegun, "Handbook of Mathematical Functions",
    10th printing, 1964, pp. 79. http://www.math.sfu.ca/~cbm/aands/
    Examples
    --------
    We expect the arccos of 1 to be 0, and of -1 to be pi:
    >>> np.arccos([1, -1])
    array([ 0.        ,  3.14159265])
    Plot arccos:
    >>> import matplotlib.pyplot as plt
    >>> x = np.linspace(-1, 1, num=100)
    >>> plt.plot(x, np.arccos(x))
    >>> plt.axis('tight')
    >>> plt.show()
    """
    
    
    return ndarray()
def arccosh(x,out):
    """arccosh(x[, out])
    Inverse hyperbolic cosine, elementwise.
    Parameters
    ----------
    x : array_like
       Input array.
    out : ndarray, optional
       Array of the same shape as `x`, to store results in.
       See `doc.ufuncs` (Section "Output arguments") for details.
    Returns
    -------
    y : ndarray
       Array of the same shape as `x`.
    See Also
    --------
    cosh, arcsinh, sinh, arctanh, tanh
    Notes
    -----
    `arccosh` is a multivalued function: for each `x` there are infinitely
    many numbers `z` such that `cosh(z) = x`. The convention is to return the
    `z` whose imaginary part lies in `[-pi, pi]` and the real part in
    ``[0, inf]``.
    For real-valued input data types, `arccosh` always returns real output.
    For each value that cannot be expressed as a real number or infinity, it
    yields ``nan`` and sets the `invalid` floating point error flag.
    For complex-valued input, `arccosh` is a complex analytical function that
    has a branch cut `[-inf, 1]` and is continuous from above on it.
    References
    ----------
    .. [1] M. Abramowitz and I.A. Stegun, "Handbook of Mathematical Functions",
          10th printing, 1964, pp. 86. http://www.math.sfu.ca/~cbm/aands/
    .. [2] Wikipedia, "Inverse hyperbolic function",
          http://en.wikipedia.org/wiki/Arccosh
    Examples
    --------
    >>> np.arccosh([np.e, 10.0])
    array([ 1.65745445,  2.99322285])
    >>> np.arccosh(1)
    0.0
    """
    
    
    return ndarray()
def arcsin(x,out):
    """arcsin(x[, out])
    Inverse sine, element-wise.
    Parameters
    ----------
    x : array_like
       `y`-coordinate on the unit circle.
    out : ndarray, optional
       Array of the same shape as `x`, in which to store the results.
       See `doc.ufuncs` (Section "Output arguments") for more details.
    Returns
    -------
    angle : ndarray
       The inverse sine of each element in `x`, in radians and in the
       closed interval ``[-pi/2, pi/2]``.  If `x` is a scalar, a scalar
       is returned, otherwise an array.
    See Also
    --------
    sin, cos, arccos, tan, arctan, arctan2, emath.arcsin
    Notes
    -----
    `arcsin` is a multivalued function: for each `x` there are infinitely
    many numbers `z` such that :math:`sin(z) = x`.  The convention is to
    return the angle `z` whose real part lies in [-pi/2, pi/2].
    For real-valued input data types, *arcsin* always returns real output.
    For each value that cannot be expressed as a real number or infinity,
    it yields ``nan`` and sets the `invalid` floating point error flag.
    For complex-valued input, `arcsin` is a complex analytic function that
    has, by convention, the branch cuts [-inf, -1] and [1, inf]  and is
    continuous from above on the former and from below on the latter.
    The inverse sine is also known as `asin` or sin^{-1}.
    References
    ----------
    Abramowitz, M. and Stegun, I. A., *Handbook of Mathematical Functions*,
    10th printing, New York: Dover, 1964, pp. 79ff.
    http://www.math.sfu.ca/~cbm/aands/
    Examples
    --------
    >>> np.arcsin(1)     # pi/2
    1.5707963267948966
    >>> np.arcsin(-1)    # -pi/2
    -1.5707963267948966
    >>> np.arcsin(0)
    0.0
    """
    
    
    return ndarray()
def arcsinh(x,out):
    """arcsinh(x[, out])
    Inverse hyperbolic sine elementwise.
    Parameters
    ----------
    x : array_like
       Input array.
    out : ndarray, optional
       Array into which the output is placed. Its type is preserved and it
       must be of the right shape to hold the output. See `doc.ufuncs`.
    Returns
    -------
    out : ndarray
       Array of of the same shape as `x`.
    Notes
    -----
    `arcsinh` is a multivalued function: for each `x` there are infinitely
    many numbers `z` such that `sinh(z) = x`. The convention is to return the
    `z` whose imaginary part lies in `[-pi/2, pi/2]`.
    For real-valued input data types, `arcsinh` always returns real output.
    For each value that cannot be expressed as a real number or infinity, it
    returns ``nan`` and sets the `invalid` floating point error flag.
    For complex-valued input, `arccos` is a complex analytical function that
    has branch cuts `[1j, infj]` and `[-1j, -infj]` and is continuous from
    the right on the former and from the left on the latter.
    The inverse hyperbolic sine is also known as `asinh` or ``sinh^-1``.
    References
    ----------
    .. [1] M. Abramowitz and I.A. Stegun, "Handbook of Mathematical Functions",
          10th printing, 1964, pp. 86. http://www.math.sfu.ca/~cbm/aands/
    .. [2] Wikipedia, "Inverse hyperbolic function",
          http://en.wikipedia.org/wiki/Arcsinh
    Examples
    --------
    >>> np.arcsinh(np.array([np.e, 10.0]))
    array([ 1.72538256,  2.99822295])
    """
    
    
    return ndarray()
def arctan(x):
    """arctan(x[, out])
    Trigonometric inverse tangent, element-wise.
    The inverse of tan, so that if ``y = tan(x)`` then ``x = arctan(y)``.
    Parameters
    ----------
    x : array_like
       Input values.  `arctan` is applied to each element of `x`.
    Returns
    -------
    out : ndarray
       Out has the same shape as `x`.  Its real part is in
       ``[-pi/2, pi/2]`` (``arctan(+/-inf)`` returns ``+/-pi/2``).
       It is a scalar if `x` is a scalar.
    See Also
    --------
    arctan2 : The "four quadrant" arctan of the angle formed by (`x`, `y`)
       and the positive `x`-axis.
    angle : Argument of complex values.
    Notes
    -----
    `arctan` is a multi-valued function: for each `x` there are infinitely
    many numbers `z` such that tan(`z`) = `x`.  The convention is to return
    the angle `z` whose real part lies in [-pi/2, pi/2].
    For real-valued input data types, `arctan` always returns real output.
    For each value that cannot be expressed as a real number or infinity,
    it yields ``nan`` and sets the `invalid` floating point error flag.
    For complex-valued input, `arctan` is a complex analytic function that
    has [`1j, infj`] and [`-1j, -infj`] as branch cuts, and is continuous
    from the left on the former and from the right on the latter.
    The inverse tangent is also known as `atan` or tan^{-1}.
    References
    ----------
    Abramowitz, M. and Stegun, I. A., *Handbook of Mathematical Functions*,
    10th printing, New York: Dover, 1964, pp. 79.
    http://www.math.sfu.ca/~cbm/aands/
    Examples
    --------
    We expect the arctan of 0 to be 0, and of 1 to be pi/4:
    >>> np.arctan([0, 1])
    array([ 0.        ,  0.78539816])
    >>> np.pi/4
    0.78539816339744828
    Plot arctan:
    >>> import matplotlib.pyplot as plt
    >>> x = np.linspace(-10, 10)
    >>> plt.plot(x, np.arctan(x))
    >>> plt.axis('tight')
    >>> plt.show()
    """
    
    
    return ndarray()
def arctan2(x1,x2):
    """arctan2(x1, x2[, out])
    Element-wise arc tangent of ``x1/x2`` choosing the quadrant correctly.
    The quadrant (i.e., branch) is chosen so that ``arctan2(x1, x2)`` is
    the signed angle in radians between the ray ending at the origin and
    passing through the point (1,0), and the ray ending at the origin and
    passing through the point (`x2`, `x1`).  (Note the role reversal: the
    "`y`-coordinate" is the first function parameter, the "`x`-coordinate"
    is the second.)  By IEEE convention, this function is defined for
    `x2` = +/-0 and for either or both of `x1` and `x2` = +/-inf (see
    Notes for specific values).
    This function is not defined for complex-valued arguments; for the
    so-called argument of complex values, use `angle`.
    Parameters
    ----------
    x1 : array_like, real-valued
       `y`-coordinates.
    x2 : array_like, real-valued
       `x`-coordinates. `x2` must be broadcastable to match the shape of
       `x1` or vice versa.
    Returns
    -------
    angle : ndarray
       Array of angles in radians, in the range ``[-pi, pi]``.
    See Also
    --------
    arctan, tan, angle
    Notes
    -----
    *arctan2* is identical to the `atan2` function of the underlying
    C library.  The following special values are defined in the C
    standard: [1]_
    ====== ====== ================
    `x1`   `x2`   `arctan2(x1,x2)`
    ====== ====== ================
    +/- 0  +0     +/- 0
    +/- 0  -0     +/- pi
    > 0   +/-inf +0 / +pi
    < 0   +/-inf -0 / -pi
    +/-inf +inf   +/- (pi/4)
    +/-inf -inf   +/- (3*pi/4)
    ====== ====== ================
    Note that +0 and -0 are distinct floating point numbers, as are +inf
    and -inf.
    References
    ----------
    .. [1] ISO/IEC standard 9899:1999, "Programming language C."
    Examples
    --------
    Consider four points in different quadrants:
    >>> x = np.array([-1, +1, +1, -1])
    >>> y = np.array([-1, -1, +1, +1])
    >>> np.arctan2(y, x) * 180 / np.pi
    array([-135.,  -45.,   45.,  135.])
    Note the order of the parameters. `arctan2` is defined also when `x2` = 0
    and at several other special points, obtaining values in
    the range ``[-pi, pi]``:
    >>> np.arctan2([1., -1.], [0., 0.])
    array([ 1.57079633, -1.57079633])
    >>> np.arctan2([0., 0., np.inf], [+0., -0., np.inf])
    array([ 0.        ,  3.14159265,  0.78539816])
    """
    
    
    return ndarray()
def arctanh(x):
    """arctanh(x[, out])
    Inverse hyperbolic tangent elementwise.
    Parameters
    ----------
    x : array_like
       Input array.
    Returns
    -------
    out : ndarray
       Array of the same shape as `x`.
    See Also
    --------
    emath.arctanh
    Notes
    -----
    `arctanh` is a multivalued function: for each `x` there are infinitely
    many numbers `z` such that `tanh(z) = x`. The convention is to return the
    `z` whose imaginary part lies in `[-pi/2, pi/2]`.
    For real-valued input data types, `arctanh` always returns real output.
    For each value that cannot be expressed as a real number or infinity, it
    yields ``nan`` and sets the `invalid` floating point error flag.
    For complex-valued input, `arctanh` is a complex analytical function that
    has branch cuts `[-1, -inf]` and `[1, inf]` and is continuous from
    above on the former and from below on the latter.
    The inverse hyperbolic tangent is also known as `atanh` or ``tanh^-1``.
    References
    ----------
    .. [1] M. Abramowitz and I.A. Stegun, "Handbook of Mathematical Functions",
          10th printing, 1964, pp. 86. http://www.math.sfu.ca/~cbm/aands/
    .. [2] Wikipedia, "Inverse hyperbolic function",
          http://en.wikipedia.org/wiki/Arctanh
    Examples
    --------
    >>> np.arctanh([0, -0.5])
    array([ 0.        , -0.54930614])
    """
    
    
    return ndarray()
def argmax(a,axis):
    """   Indices of the maximum values along an axis.
       Parameters
       ----------
       a : array_like
           Input array.
       axis : int, optional
           By default, the index is into the flattened array, otherwise
           along the specified axis.
       Returns
       -------
       index_array : ndarray of ints
           Array of indices into the array. It has the same shape as `a.shape`
           with the dimension along `axis` removed.
       See Also
       --------
       ndarray.argmax, argmin
       amax : The maximum value along a given axis.
       unravel_index : Convert a flat index into an index tuple.
       Notes
       -----
       In case of multiple occurrences of the maximum values, the indices
       corresponding to the first occurrence are returned.
       Examples
       --------
       >>> a = np.arange(6).reshape(2,3)
       >>> a
       array([[0, 1, 2],
              [3, 4, 5]])
       >>> np.argmax(a)
       5
       >>> np.argmax(a, axis=0)
       array([1, 1, 1])
       >>> np.argmax(a, axis=1)
       array([2, 2])
       >>> b = np.arange(6)
       >>> b[1] = 5
       >>> b
       array([0, 5, 2, 3, 4, 5])
       >>> np.argmax(b) # Only the first occurrence is returned.
       1
       
    """
    
    
    return ndarray()
def argmin():
    """   Return the indices of the minimum values along an axis.
       See Also
       --------
       argmax : Similar function.  Please refer to `numpy.argmax` for detailed
           documentation.
       
    """
    
    
    return None
def argsort(a,axis,kind,order):
    """   Returns the indices that would sort an array.
       Perform an indirect sort along the given axis using the algorithm specified
       by the `kind` keyword. It returns an array of indices of the same shape as
       `a` that index data along the given axis in sorted order.
       Parameters
       ----------
       a : array_like
           Array to sort.
       axis : int or None, optional
           Axis along which to sort.  The default is -1 (the last axis). If None,
           the flattened array is used.
       kind : {'quicksort', 'mergesort', 'heapsort'}, optional
           Sorting algorithm.
       order : list, optional
           When `a` is an array with fields defined, this argument specifies
           which fields to compare first, second, etc.  Not all fields need be
           specified.
       Returns
       -------
       index_array : ndarray, int
           Array of indices that sort `a` along the specified axis.
           In other words, ``a[index_array]`` yields a sorted `a`.
       See Also
       --------
       sort : Describes sorting algorithms used.
       lexsort : Indirect stable sort with multiple keys.
       ndarray.sort : Inplace sort.
       Notes
       -----
       See `sort` for notes on the different sorting algorithms.
       As of NumPy 1.4.0 `argsort` works with real/complex arrays containing
       nan values. The enhanced sort order is documented in `sort`.
       Examples
       --------
       One dimensional array:
       >>> x = np.array([3, 1, 2])
       >>> np.argsort(x)
       array([1, 2, 0])
       Two-dimensional array:
       >>> x = np.array([[0, 3], [2, 2]])
       >>> x
       array([[0, 3],
              [2, 2]])
       >>> np.argsort(x, axis=0)
       array([[0, 1],
              [1, 0]])
       >>> np.argsort(x, axis=1)
       array([[0, 1],
              [0, 1]])
       Sorting with keys:
       >>> x = np.array([(1, 0), (0, 1)], dtype=[('x', '<i4'), ('y', '<i4')])
       >>> x
       array([(1, 0), (0, 1)],
             dtype=[('x', '<i4'), ('y', '<i4')])
       >>> np.argsort(x, order=('x','y'))
       array([1, 0])
       >>> np.argsort(x, order=('y','x'))
       array([0, 1])
       
    """
    
    
    return ndarray()
def argwhere(a):
    """   Find the indices of array elements that are non-zero, grouped by element.
       Parameters
       ----------
       a : array_like
           Input data.
       Returns
       -------
       index_array : ndarray
           Indices of elements that are non-zero. Indices are grouped by element.
       See Also
       --------
       where, nonzero
       Notes
       -----
       ``np.argwhere(a)`` is the same as ``np.transpose(np.nonzero(a))``.
       The output of ``argwhere`` is not suitable for indexing arrays.
       For this purpose use ``where(a)`` instead.
       Examples
       --------
       >>> x = np.arange(6).reshape(2,3)
       >>> x
       array([[0, 1, 2],
              [3, 4, 5]])
       >>> np.argwhere(x>1)
       array([[0, 2],
              [1, 0],
              [1, 1],
              [1, 2]])
       
    """
    
    
    return ndarray()
def around(a,decimals,out):
    """   Evenly round to the given number of decimals.
       Parameters
       ----------
       a : array_like
           Input data.
       decimals : int, optional
           Number of decimal places to round to (default: 0).  If
           decimals is negative, it specifies the number of positions to
           the left of the decimal point.
       out : ndarray, optional
           Alternative output array in which to place the result. It must have
           the same shape as the expected output, but the type of the output
           values will be cast if necessary. See `doc.ufuncs` (Section
           "Output arguments") for details.
       Returns
       -------
       rounded_array : ndarray
           An array of the same type as `a`, containing the rounded values.
           Unless `out` was specified, a new array is created.  A reference to
           the result is returned.
           The real and imaginary parts of complex numbers are rounded
           separately.  The result of rounding a float is a float.
       See Also
       --------
       ndarray.round : equivalent method
       ceil, fix, floor, rint, trunc
       Notes
       -----
       For values exactly halfway between rounded decimal values, Numpy
       rounds to the nearest even value. Thus 1.5 and 2.5 round to 2.0,
       -0.5 and 0.5 round to 0.0, etc. Results may also be surprising due
       to the inexact representation of decimal fractions in the IEEE
       floating point standard [1]_ and errors introduced when scaling
       by powers of ten.
       References
       ----------
       .. [1] "Lecture Notes on the Status of  IEEE 754", William Kahan,
              http://www.cs.berkeley.edu/~wkahan/ieee754status/IEEE754.PDF
       .. [2] "How Futile are Mindless Assessments of
              Roundoff in Floating-Point Computation?", William Kahan,
              http://www.cs.berkeley.edu/~wkahan/Mindless.pdf
       Examples
       --------
       >>> np.around([0.37, 1.64])
       array([ 0.,  2.])
       >>> np.around([0.37, 1.64], decimals=1)
       array([ 0.4,  1.6])
       >>> np.around([.5, 1.5, 2.5, 3.5, 4.5]) # rounds to nearest even value
       array([ 0.,  2.,  2.,  4.,  4.])
       >>> np.around([1,2,3,11], decimals=1) # ndarray of ints is returned
       array([ 1,  2,  3, 11])
       >>> np.around([1,2,3,11], decimals=-1)
       array([ 0,  0,  0, 10])
       
    """
    
    
    return ndarray()
def array(object,dtype,copy,order,subok,ndmin):
    """array(object, dtype=None, copy=True, order=None, subok=False, ndmin=0)
       Create an array.
       Parameters
       ----------
       object : array_like
           An array, any object exposing the array interface, an
           object whose __array__ method returns an array, or any
           (nested) sequence.
       dtype : data-type, optional
           The desired data-type for the array.  If not given, then
           the type will be determined as the minimum type required
           to hold the objects in the sequence.  This argument can only
           be used to 'upcast' the array.  For downcasting, use the
           .astype(t) method.
       copy : bool, optional
           If true (default), then the object is copied.  Otherwise, a copy
           will only be made if __array__ returns a copy, if obj is a
           nested sequence, or if a copy is needed to satisfy any of the other
           requirements (`dtype`, `order`, etc.).
       order : {'C', 'F', 'A'}, optional
           Specify the order of the array.  If order is 'C' (default), then the
           array will be in C-contiguous order (last-index varies the
           fastest).  If order is 'F', then the returned array
           will be in Fortran-contiguous order (first-index varies the
           fastest).  If order is 'A', then the returned array may
           be in any order (either C-, Fortran-contiguous, or even
           discontiguous).
       subok : bool, optional
           If True, then sub-classes will be passed-through, otherwise
           the returned array will be forced to be a base-class array (default).
       ndmin : int, optional
           Specifies the minimum number of dimensions that the resulting
           array should have.  Ones will be pre-pended to the shape as
           needed to meet this requirement.
       Examples
       --------
       >>> np.array([1, 2, 3])
       array([1, 2, 3])
       Upcasting:
       >>> np.array([1, 2, 3.0])
       array([ 1.,  2.,  3.])
       More than one dimension:
       >>> np.array([[1, 2], [3, 4]])
       array([[1, 2],
              [3, 4]])
       Minimum dimensions 2:
       >>> np.array([1, 2, 3], ndmin=2)
       array([[1, 2, 3]])
       Type provided:
       >>> np.array([1, 2, 3], dtype=complex)
       array([ 1.+0.j,  2.+0.j,  3.+0.j])
       Data-type consisting of more than one element:
       >>> x = np.array([(1,2),(3,4)],dtype=[('a','<i4'),('b','<i4')])
       >>> x['a']
       array([1, 3])
       Creating an array from sub-classes:
       >>> np.array(np.mat('1 2; 3 4'))
       array([[1, 2],
              [3, 4]])
       >>> np.array(np.mat('1 2; 3 4'), subok=True)
       matrix([[1, 2],
               [3, 4]])
    """
    
    
    return None
def array2string(a,max_line_width,precision,suppress_small,separator,prefix,style):
    """   Return a string representation of an array.
       Parameters
       ----------
       a : ndarray
           Input array.
       max_line_width : int, optional
           The maximum number of columns the string should span. Newline
           characters splits the string appropriately after array elements.
       precision : int, optional
           Floating point precision. Default is the current printing
           precision (usually 8), which can be altered using `set_printoptions`.
       suppress_small : bool, optional
           Represent very small numbers as zero. A number is "very small" if it
           is smaller than the current printing precision.
       separator : str, optional
           Inserted between elements.
       prefix : str, optional
           An array is typically printed as::
             'prefix(' + array2string(a) + ')'
           The length of the prefix string is used to align the
           output correctly.
       style : function, optional
           A function that accepts an ndarray and returns a string.  Used only
           when the shape of `a` is equal to ().
       Returns
       -------
       array_str : str
           String representation of the array.
       See Also
       --------
       array_str, array_repr, set_printoptions
       Examples
       --------
       >>> x = np.array([1e-16,1,2,3])
       >>> print np.array2string(x, precision=2, separator=',',
       ...                       suppress_small=True)
       [ 0., 1., 2., 3.]
       
    """
    
    
    return str()
def array_equal(a1,a2):
    """   True if two arrays have the same shape and elements, False otherwise.
       Parameters
       ----------
       a1, a2 : array_like
           Input arrays.
       Returns
       -------
       b : bool
           Returns True if the arrays are equal.
       See Also
       --------
       allclose: Returns True if two arrays are element-wise equal within a
                 tolerance.
       array_equiv: Returns True if input arrays are shape consistent and all
                    elements equal.
       Examples
       --------
       >>> np.array_equal([1, 2], [1, 2])
       True
       >>> np.array_equal(np.array([1, 2]), np.array([1, 2]))
       True
       >>> np.array_equal([1, 2], [1, 2, 3])
       False
       >>> np.array_equal([1, 2], [1, 4])
       False
       
    """
    
    
    return bool()
def array_equiv(a1,a2):
    """   Returns True if input arrays are shape consistent and all elements equal.
       Shape consistent means they are either the same shape, or one input array
       can be broadcasted to create the same shape as the other one.
       Parameters
       ----------
       a1, a2 : array_like
           Input arrays.
       Returns
       -------
       out : bool
           True if equivalent, False otherwise.
       Examples
       --------
       >>> np.array_equiv([1, 2], [1, 2])
       True
       >>> np.array_equiv([1, 2], [1, 3])
       False
       Showing the shape equivalence:
       >>> np.array_equiv([1, 2], [[1, 2], [1, 2]])
       True
       >>> np.array_equiv([1, 2], [[1, 2, 1, 2], [1, 2, 1, 2]])
       False
       >>> np.array_equiv([1, 2], [[1, 2], [1, 3]])
       False
       
    """
    
    
    return bool()
def array_repr(arr,max_line_width,precision,suppress_small):
    """   Return the string representation of an array.
       Parameters
       ----------
       arr : ndarray
           Input array.
       max_line_width : int, optional
           The maximum number of columns the string should span. Newline
           characters split the string appropriately after array elements.
       precision : int, optional
           Floating point precision. Default is the current printing precision
           (usually 8), which can be altered using `set_printoptions`.
       suppress_small : bool, optional
           Represent very small numbers as zero, default is False. Very small
           is defined by `precision`, if the precision is 8 then
           numbers smaller than 5e-9 are represented as zero.
       Returns
       -------
       string : str
         The string representation of an array.
       See Also
       --------
       array_str, array2string, set_printoptions
       Examples
       --------
       >>> np.array_repr(np.array([1,2]))
       'array([1, 2])'
       >>> np.array_repr(np.ma.array([0.]))
       'MaskedArray([ 0.])'
       >>> np.array_repr(np.array([], np.int32))
       'array([], dtype=int32)'
       >>> x = np.array([1e-6, 4e-7, 2, 3])
       >>> np.array_repr(x, precision=6, suppress_small=True)
       'array([ 0.000001,  0.      ,  2.      ,  3.      ])'
       
    """
    
    
    return str()
def array_split():
    """   Split an array into multiple sub-arrays of equal or near-equal size.
       Please refer to the ``split`` documentation.  The only difference
       between these functions is that ``array_split`` allows
       `indices_or_sections` to be an integer that does *not* equally
       divide the axis.
       See Also
       --------
       split : Split array into multiple sub-arrays of equal size.
       Examples
       --------
       >>> x = np.arange(8.0)
       >>> np.array_split(x, 3)
           [array([ 0.,  1.,  2.]), array([ 3.,  4.,  5.]), array([ 6.,  7.])]
       
    """
    
    
    return None
def array_str(a,max_line_width,precision,suppress_small):
    """   Return a string representation of the data in an array.
       The data in the array is returned as a single string.  This function is
       similar to `array_repr`, the difference being that `array_repr` also
       returns information on the kind of array and its data type.
       Parameters
       ----------
       a : ndarray
           Input array.
       max_line_width : int, optional
           Inserts newlines if text is longer than `max_line_width`.  The
           default is, indirectly, 75.
       precision : int, optional
           Floating point precision.  Default is the current printing precision
           (usually 8), which can be altered using `set_printoptions`.
       suppress_small : bool, optional
           Represent numbers "very close" to zero as zero; default is False.
           Very close is defined by precision: if the precision is 8, e.g.,
           numbers smaller (in absolute value) than 5e-9 are represented as
           zero.
       See Also
       --------
       array2string, array_repr, set_printoptions
       Examples
       --------
       >>> np.array_str(np.arange(3))
       '[0 1 2]'
       
    """
    
    
    return None
def asanyarray(a,dtype,order):
    """   Convert the input to an ndarray, but pass ndarray subclasses through.
       Parameters
       ----------
       a : array_like
           Input data, in any form that can be converted to an array.  This
           includes scalars, lists, lists of tuples, tuples, tuples of tuples,
           tuples of lists, and ndarrays.
       dtype : data-type, optional
           By default, the data-type is inferred from the input data.
       order : {'C', 'F'}, optional
           Whether to use row-major ('C') or column-major ('F') memory
           representation.  Defaults to 'C'.
       Returns
       -------
       out : ndarray or an ndarray subclass
           Array interpretation of `a`.  If `a` is an ndarray or a subclass
           of ndarray, it is returned as-is and no copy is performed.
       See Also
       --------
       asarray : Similar function which always returns ndarrays.
       ascontiguousarray : Convert input to a contiguous array.
       asfarray : Convert input to a floating point ndarray.
       asfortranarray : Convert input to an ndarray with column-major
                        memory order.
       asarray_chkfinite : Similar function which checks input for NaNs and
                           Infs.
       fromiter : Create an array from an iterator.
       fromfunction : Construct an array by executing a function on grid
                      positions.
       Examples
       --------
       Convert a list into an array:
       >>> a = [1, 2]
       >>> np.asanyarray(a)
       array([1, 2])
       Instances of `ndarray` subclasses are passed through as-is:
       >>> a = np.matrix([1, 2])
       >>> np.asanyarray(a) is a
       True
       
    """
    
    
    return ndarray()
def asarray(a,dtype,order):
    """   Convert the input to an array.
       Parameters
       ----------
       a : array_like
           Input data, in any form that can be converted to an array.  This
           includes lists, lists of tuples, tuples, tuples of tuples, tuples
           of lists and ndarrays.
       dtype : data-type, optional
           By default, the data-type is inferred from the input data.
       order : {'C', 'F'}, optional
           Whether to use row-major ('C') or column-major ('F' for FORTRAN)
           memory representation.  Defaults to 'C'.
       Returns
       -------
       out : ndarray
           Array interpretation of `a`.  No copy is performed if the input
           is already an ndarray.  If `a` is a subclass of ndarray, a base
           class ndarray is returned.
       See Also
       --------
       asanyarray : Similar function which passes through subclasses.
       ascontiguousarray : Convert input to a contiguous array.
       asfarray : Convert input to a floating point ndarray.
       asfortranarray : Convert input to an ndarray with column-major
                        memory order.
       asarray_chkfinite : Similar function which checks input for NaNs and Infs.
       fromiter : Create an array from an iterator.
       fromfunction : Construct an array by executing a function on grid
                      positions.
       Examples
       --------
       Convert a list into an array:
       >>> a = [1, 2]
       >>> np.asarray(a)
       array([1, 2])
       Existing arrays are not copied:
       >>> a = np.array([1, 2])
       >>> np.asarray(a) is a
       True
       If `dtype` is set, array is copied only if dtype does not match:
       >>> a = np.array([1, 2], dtype=np.float32)
       >>> np.asarray(a, dtype=np.float32) is a
       True
       >>> np.asarray(a, dtype=np.float64) is a
       False
       Contrary to `asanyarray`, ndarray subclasses are not passed through:
       >>> issubclass(np.matrix, np.ndarray)
       True
       >>> a = np.matrix([[1, 2]])
       >>> np.asarray(a) is a
       False
       >>> np.asanyarray(a) is a
       True
       
    """
    
    
    return ndarray()
def asarray_chkfinite(a,dtype,order):
    """   Convert the input to an array, checking for NaNs or Infs.
       Parameters
       ----------
       a : array_like
           Input data, in any form that can be converted to an array.  This
           includes lists, lists of tuples, tuples, tuples of tuples, tuples
           of lists and ndarrays.  Success requires no NaNs or Infs.
       dtype : data-type, optional
           By default, the data-type is inferred from the input data.
       order : {'C', 'F'}, optional
           Whether to use row-major ('C') or column-major ('FORTRAN') memory
           representation.  Defaults to 'C'.
       Returns
       -------
       out : ndarray
           Array interpretation of `a`.  No copy is performed if the input
           is already an ndarray.  If `a` is a subclass of ndarray, a base
           class ndarray is returned.
       Raises
       ------
       ValueError
           Raises ValueError if `a` contains NaN (Not a Number) or Inf (Infinity).
       See Also
       --------
       asarray : Create and array.
       asanyarray : Similar function which passes through subclasses.
       ascontiguousarray : Convert input to a contiguous array.
       asfarray : Convert input to a floating point ndarray.
       asfortranarray : Convert input to an ndarray with column-major
                        memory order.
       fromiter : Create an array from an iterator.
       fromfunction : Construct an array by executing a function on grid
                      positions.
       Examples
       --------
       Convert a list into an array.  If all elements are finite
       ``asarray_chkfinite`` is identical to ``asarray``.
       >>> a = [1, 2]
       >>> np.asarray_chkfinite(a)
       array([1, 2])
       Raises ValueError if array_like contains Nans or Infs.
       >>> a = [1, 2, np.inf]
       >>> try:
       ...     np.asarray_chkfinite(a)
       ... except ValueError:
       ...     print 'ValueError'
       ...
       ValueError
       
    """
    
    
    return ndarray()
def ascontiguousarray(a,dtype):
    """   Return a contiguous array in memory (C order).
       Parameters
       ----------
       a : array_like
           Input array.
       dtype : str or dtype object, optional
           Data-type of returned array.
       Returns
       -------
       out : ndarray
           Contiguous array of same shape and content as `a`, with type `dtype`
           if specified.
       See Also
       --------
       asfortranarray : Convert input to an ndarray with column-major
                        memory order.
       require : Return an ndarray that satisfies requirements.
       ndarray.flags : Information about the memory layout of the array.
       Examples
       --------
       >>> x = np.arange(6).reshape(2,3)
       >>> np.ascontiguousarray(x, dtype=np.float32)
       array([[ 0.,  1.,  2.],
              [ 3.,  4.,  5.]], dtype=float32)
       >>> x.flags['C_CONTIGUOUS']
       True
       
    """
    
    
    return ndarray()
def asfarray(a,dtype):
    """   Return an array converted to a float type.
       Parameters
       ----------
       a : array_like
           The input array.
       dtype : str or dtype object, optional
           Float type code to coerce input array `a`.  If `dtype` is one of the
           'int' dtypes, it is replaced with float64.
       Returns
       -------
       out : ndarray
           The input `a` as a float ndarray.
       Examples
       --------
       >>> np.asfarray([2, 3])
       array([ 2.,  3.])
       >>> np.asfarray([2, 3], dtype='float')
       array([ 2.,  3.])
       >>> np.asfarray([2, 3], dtype='int8')
       array([ 2.,  3.])
       
    """
    
    
    return ndarray()
def asfortranarray(a,dtype):
    """   Return an array laid out in Fortran order in memory.
       Parameters
       ----------
       a : array_like
           Input array.
       dtype : str or dtype object, optional
           By default, the data-type is inferred from the input data.
       Returns
       -------
       out : ndarray
           The input `a` in Fortran, or column-major, order.
       See Also
       --------
       ascontiguousarray : Convert input to a contiguous (C order) array.
       asanyarray : Convert input to an ndarray with either row or
           column-major memory order.
       require : Return an ndarray that satisfies requirements.
       ndarray.flags : Information about the memory layout of the array.
       Examples
       --------
       >>> x = np.arange(6).reshape(2,3)
       >>> y = np.asfortranarray(x)
       >>> x.flags['F_CONTIGUOUS']
       False
       >>> y.flags['F_CONTIGUOUS']
       True
       
    """
    
    
    return ndarray()
def asmatrix(data):
    """   Interpret the input as a matrix.
       Unlike `matrix`, `asmatrix` does not make a copy if the input is already
       a matrix or an ndarray.  Equivalent to ``matrix(data, copy=False)``.
       Parameters
       ----------
       data : array_like
           Input data.
       Returns
       -------
       mat : matrix
           `data` interpreted as a matrix.
       Examples
       --------
       >>> x = np.array([[1, 2], [3, 4]])
       >>> m = np.asmatrix(x)
       >>> x[0,0] = 5
       >>> m
       matrix([[5, 2],
               [3, 4]])
       
    """
    
    
    return matrix()
def asscalar(a):
    """   Convert an array of size 1 to its scalar equivalent.
       Parameters
       ----------
       a : ndarray
           Input array of size 1.
       Returns
       -------
       out : scalar
           Scalar representation of `a`. The input data type is preserved.
       Examples
       --------
       >>> np.asscalar(np.array([24]))
       24
       
    """
    
    
    return scalar()
def atleast_1d(array1,array2,___):
    """   Convert inputs to arrays with at least one dimension.
       Scalar inputs are converted to 1-dimensional arrays, whilst
       higher-dimensional inputs are preserved.
       Parameters
       ----------
       array1, array2, ... : array_like
           One or more input arrays.
       Returns
       -------
       ret : ndarray
           An array, or sequence of arrays, each with ``a.ndim >= 1``.
           Copies are made only if necessary.
       See Also
       --------
       atleast_2d, atleast_3d
       Examples
       --------
       >>> np.atleast_1d(1.0)
       array([ 1.])
       >>> x = np.arange(9.0).reshape(3,3)
       >>> np.atleast_1d(x)
       array([[ 0.,  1.,  2.],
              [ 3.,  4.,  5.],
              [ 6.,  7.,  8.]])
       >>> np.atleast_1d(x) is x
       True
       >>> np.atleast_1d(1, [3, 4])
       [array([1]), array([3, 4])]
       
    """
    
    
    return ndarray()
def atleast_2d(array1,array2,___):
    """   View inputs as arrays with at least two dimensions.
       Parameters
       ----------
       array1, array2, ... : array_like
           One or more array-like sequences.  Non-array inputs are converted
           to arrays.  Arrays that already have two or more dimensions are
           preserved.
       Returns
       -------
       res, res2, ... : ndarray
           An array, or tuple of arrays, each with ``a.ndim >= 2``.
           Copies are avoided where possible, and views with two or more
           dimensions are returned.
       See Also
       --------
       atleast_1d, atleast_3d
       Examples
       --------
       >>> np.atleast_2d(3.0)
       array([[ 3.]])
       >>> x = np.arange(3.0)
       >>> np.atleast_2d(x)
       array([[ 0.,  1.,  2.]])
       >>> np.atleast_2d(x).base is x
       True
       >>> np.atleast_2d(1, [1, 2], [[1, 2]])
       [array([[1]]), array([[1, 2]]), array([[1, 2]])]
       
    """
    
    
    return ndarray()
def atleast_3d(array1,array2,___):
    """   View inputs as arrays with at least three dimensions.
       Parameters
       ----------
       array1, array2, ... : array_like
           One or more array-like sequences.  Non-array inputs are converted
           to arrays. Arrays that already have three or more dimensions are
           preserved.
       Returns
       -------
       res1, res2, ... : ndarray
           An array, or tuple of arrays, each with ``a.ndim >= 3``.
           Copies are avoided where possible, and views with three or more
           dimensions are returned.  For example, a 1-D array of shape ``N``
           becomes a view of shape ``(1, N, 1)``.  A 2-D array of shape ``(M, N)``
           becomes a view of shape ``(M, N, 1)``.
       See Also
       --------
       atleast_1d, atleast_2d
       Examples
       --------
       >>> np.atleast_3d(3.0)
       array([[[ 3.]]])
       >>> x = np.arange(3.0)
       >>> np.atleast_3d(x).shape
       (1, 3, 1)
       >>> x = np.arange(12.0).reshape(4,3)
       >>> np.atleast_3d(x).shape
       (4, 3, 1)
       >>> np.atleast_3d(x).base is x
       True
       >>> for arr in np.atleast_3d([1, 2], [[1, 2]], [[[1, 2]]]):
       ...     print arr, arr.shape
       ...
       [[[1]
         [2]]] (1, 2, 1)
       [[[1]
         [2]]] (1, 2, 1)
       [[[1 2]]] (1, 1, 2)
       
    """
    
    
    return ndarray()
def average(a,axis,weights,returned):
    """   Compute the weighted average along the specified axis.
       Parameters
       ----------
       a : array_like
           Array containing data to be averaged. If `a` is not an array, a
           conversion is attempted.
       axis : int, optional
           Axis along which to average `a`. If `None`, averaging is done over
           the flattened array.
       weights : array_like, optional
           An array of weights associated with the values in `a`. Each value in
           `a` contributes to the average according to its associated weight.
           The weights array can either be 1-D (in which case its length must be
           the size of `a` along the given axis) or of the same shape as `a`.
           If `weights=None`, then all data in `a` are assumed to have a
           weight equal to one.
       returned : bool, optional
           Default is `False`. If `True`, the tuple (`average`, `sum_of_weights`)
           is returned, otherwise only the average is returned.
           If `weights=None`, `sum_of_weights` is equivalent to the number of
           elements over which the average is taken.
       Returns
       -------
       average, [sum_of_weights] : {array_type, double}
           Return the average along the specified axis. When returned is `True`,
           return a tuple with the average as the first element and the sum
           of the weights as the second element. The return type is `Float`
           if `a` is of integer type, otherwise it is of the same type as `a`.
           `sum_of_weights` is of the same type as `average`.
       Raises
       ------
       ZeroDivisionError
           When all weights along axis are zero. See `numpy.ma.average` for a
           version robust to this type of error.
       TypeError
           When the length of 1D `weights` is not the same as the shape of `a`
           along axis.
       See Also
       --------
       mean
       ma.average : average for masked arrays
       Examples
       --------
       >>> data = range(1,5)
       >>> data
       [1, 2, 3, 4]
       >>> np.average(data)
       2.5
       >>> np.average(range(1,11), weights=range(10,0,-1))
       4.0
       >>> data = np.arange(6).reshape((3,2))
       >>> data
       array([[0, 1],
              [2, 3],
              [4, 5]])
       >>> np.average(data, axis=1, weights=[1./4, 3./4])
       array([ 0.75,  2.75,  4.75])
       >>> np.average(data, weights=[1./4, 3./4])
       Traceback (most recent call last):
       ...
       TypeError: Axis must be specified when shapes of a and weights differ.
       
    """
    
    
    return array_type()
def bartlett(M):
    """   Return the Bartlett window.
       The Bartlett window is very similar to a triangular window, except
       that the end points are at zero.  It is often used in signal
       processing for tapering a signal, without generating too much
       ripple in the frequency domain.
       Parameters
       ----------
       M : int
           Number of points in the output window. If zero or less, an
           empty array is returned.
       Returns
       -------
       out : array
           The triangular window, normalized to one (the value one
           appears only if the number of samples is odd), with the first
           and last samples equal to zero.
       See Also
       --------
       blackman, hamming, hanning, kaiser
       Notes
       -----
       The Bartlett window is defined as
       .. math:: w(n) = \frac{2}{M-1} \left(
                 \frac{M-1}{2} - \left|n - \frac{M-1}{2}\right|
                 \right)
       Most references to the Bartlett window come from the signal
       processing literature, where it is used as one of many windowing
       functions for smoothing values.  Note that convolution with this
       window produces linear interpolation.  It is also known as an
       apodization (which means"removing the foot", i.e. smoothing
       discontinuities at the beginning and end of the sampled signal) or
       tapering function. The fourier transform of the Bartlett is the product
       of two sinc functions.
       Note the excellent discussion in Kanasewich.
       References
       ----------
       .. [1] M.S. Bartlett, "Periodogram Analysis and Continuous Spectra",
              Biometrika 37, 1-16, 1950.
       .. [2] E.R. Kanasewich, "Time Sequence Analysis in Geophysics",
              The University of Alberta Press, 1975, pp. 109-110.
       .. [3] A.V. Oppenheim and R.W. Schafer, "Discrete-Time Signal
              Processing", Prentice-Hall, 1999, pp. 468-471.
       .. [4] Wikipedia, "Window function",
              http://en.wikipedia.org/wiki/Window_function
       .. [5] W.H. Press,  B.P. Flannery, S.A. Teukolsky, and W.T. Vetterling,
              "Numerical Recipes", Cambridge University Press, 1986, page 429.
       Examples
       --------
       >>> np.bartlett(12)
       array([ 0.        ,  0.18181818,  0.36363636,  0.54545455,  0.72727273,
               0.90909091,  0.90909091,  0.72727273,  0.54545455,  0.36363636,
               0.18181818,  0.        ])
       Plot the window and its frequency response (requires SciPy and matplotlib):
       >>> from numpy import clip, log10, array, bartlett, linspace
       >>> from numpy.fft import fft, fftshift
       >>> import matplotlib.pyplot as plt
       >>> window = bartlett(51)
       >>> plt.plot(window)
       [<matplotlib.lines.Line2D object at 0x...>]
       >>> plt.title("Bartlett window")
       <matplotlib.text.Text object at 0x...>
       >>> plt.ylabel("Amplitude")
       <matplotlib.text.Text object at 0x...>
       >>> plt.xlabel("Sample")
       <matplotlib.text.Text object at 0x...>
       >>> plt.show()
       >>> plt.figure()
       <matplotlib.figure.Figure object at 0x...>
       >>> A = fft(window, 2048) / 25.5
       >>> mag = abs(fftshift(A))
       >>> freq = linspace(-0.5,0.5,len(A))
       >>> response = 20*log10(mag)
       >>> response = clip(response,-100,100)
       >>> plt.plot(freq, response)
       [<matplotlib.lines.Line2D object at 0x...>]
       >>> plt.title("Frequency response of Bartlett window")
       <matplotlib.text.Text object at 0x...>
       >>> plt.ylabel("Magnitude [dB]")
       <matplotlib.text.Text object at 0x...>
       >>> plt.xlabel("Normalized frequency [cycles per sample]")
       <matplotlib.text.Text object at 0x...>
       >>> plt.axis('tight')
       (-0.5, 0.5, -100.0, ...)
       >>> plt.show()
       
    """
    
    
    return array()
def base_repr(number,base,padding):
    """   Return a string representation of a number in the given base system.
       Parameters
       ----------
       number : int
           The value to convert. Only positive values are handled.
       base : int, optional
           Convert `number` to the `base` number system. The valid range is 2-36,
           the default value is 2.
       padding : int, optional
           Number of zeros padded on the left. Default is 0 (no padding).
       Returns
       -------
       out : str
           String representation of `number` in `base` system.
       See Also
       --------
       binary_repr : Faster version of `base_repr` for base 2.
       Examples
       --------
       >>> np.base_repr(5)
       '101'
       >>> np.base_repr(6, 5)
       '11'
       >>> np.base_repr(7, base=5, padding=3)
       '00012'
       >>> np.base_repr(10, base=16)
       'A'
       >>> np.base_repr(32, base=16)
       '20'
       
    """
    
    
    return str()
def bench(label,verbose,extra_argv):
    """       Run benchmarks for module using nose.
           Parameters
           ----------
           label : {'fast', 'full', '', attribute identifier}, optional
               Identifies the tests to run. This can be a string to pass to the
               nosetests executable with the '-A' option, or one of
               several special values.
               Special values are:
                   'fast' - the default - which corresponds to the ``nosetests -A``
                            option of 'not slow'.
                   'full' - fast (as above) and slow tests as in the
                            'no -A' option to nosetests - this is the same as ''.
               None or '' - run all tests.
               attribute_identifier - string passed directly to nosetests as '-A'.
           verbose : int, optional
               Verbosity value for test outputs, in the range 1-10. Default is 1.
           extra_argv : list, optional
               List with any extra arguments to pass to nosetests.
           Returns
           -------
           success : bool
               Returns True if running the benchmarks works, False if an error
               occurred.
           Notes
           -----
           Benchmarks are like tests, but have names starting with "bench" instead
           of "test", and can be found under the "benchmarks" sub-directory of the
           module.
           Each NumPy module exposes `bench` in its namespace to run all benchmarks
           for it.
           Examples
           --------
           >>> success = np.lib.bench()
           Running benchmarks for numpy.lib
           ...
           using 562341 items:
           unique:
           0.11
           unique1d:
           0.11
           ratio: 1.0
           nUnique: 56230 == 56230
           ...
           OK
           >>> success
           True
           
    """
    
    
    return bool()
def binary_repr(num,width):
    """   Return the binary representation of the input number as a string.
       For negative numbers, if width is not given, a minus sign is added to the
       front. If width is given, the two's complement of the number is
       returned, with respect to that width.
       In a two's-complement system negative numbers are represented by the two's
       complement of the absolute value. This is the most common method of
       representing signed integers on computers [1]_. A N-bit two's-complement
       system can represent every integer in the range
       :math:`-2^{N-1}` to :math:`+2^{N-1}-1`.
       Parameters
       ----------
       num : int
           Only an integer decimal number can be used.
       width : int, optional
           The length of the returned string if `num` is positive, the length of
           the two's complement if `num` is negative.
       Returns
       -------
       bin : str
           Binary representation of `num` or two's complement of `num`.
       See Also
       --------
       base_repr: Return a string representation of a number in the given base
                  system.
       Notes
       -----
       `binary_repr` is equivalent to using `base_repr` with base 2, but about 25x
       faster.
       References
       ----------
       .. [1] Wikipedia, "Two's complement",
           http://en.wikipedia.org/wiki/Two's_complement
       Examples
       --------
       >>> np.binary_repr(3)
       '11'
       >>> np.binary_repr(-3)
       '-11'
       >>> np.binary_repr(3, width=4)
       '0011'
       The two's complement is returned when the input number is negative and
       width is specified:
       >>> np.binary_repr(-3, width=4)
       '1101'
       
    """
    
    
    return str()
def bincount(x,weights):
    """bincount(x, weights=None)
       Count number of occurrences of each value in array of non-negative ints.
       The number of bins (of size 1) is one larger than the largest value in
       `x`. Each bin gives the number of occurrences of its index value in `x`.
       If `weights` is specified the input array is weighted by it, i.e. if a
       value ``n`` is found at position ``i``, ``out[n] += weight[i]`` instead
       of ``out[n] += 1``.
       Parameters
       ----------
       x : array_like, 1 dimension, nonnegative ints
           Input array.
       weights : array_like, optional
           Weights, array of the same shape as `x`.
       Returns
       -------
       out : ndarray of ints
           The result of binning the input array.
           The length of `out` is equal to ``np.amax(x)+1``.
       Raises
       ------
       ValueError
           If the input is not 1-dimensional, or contains elements with negative
           values.
       TypeError
           If the type of the input is float or complex.
       See Also
       --------
       histogram, digitize, unique
       Examples
       --------
       >>> np.bincount(np.arange(5))
       array([1, 1, 1, 1, 1])
       >>> np.bincount(np.array([0, 1, 1, 3, 2, 1, 7]))
       array([1, 3, 1, 1, 0, 0, 0, 1])
       >>> x = np.array([0, 1, 1, 3, 2, 1, 7, 23])
       >>> np.bincount(x).size == np.amax(x)+1
       True
       >>> np.bincount(np.arange(5, dtype=np.float))
       Traceback (most recent call last):
         File "<stdin>", line 1, in <module>
       TypeError: array cannot be safely cast to required type
       A possible use of ``bincount`` is to perform sums over
       variable-size chunks of an array, using the ``weights`` keyword.
       >>> w = np.array([0.3, 0.5, 0.2, 0.7, 1., -0.6]) # weights
       >>> x = np.array([0, 1, 1, 2, 2, 2])
       >>> np.bincount(x,  weights=w)
       array([ 0.3,  0.7,  1.1])
    """
    
    
    return ndarray()
def bitwise_and(x1,x2):
    """bitwise_and(x1, x2[, out])
    Compute the bit-wise AND of two arrays element-wise.
    Computes the bit-wise AND of the underlying binary representation of
    the integers in the input arrays. This ufunc implements the C/Python
    operator ``&``.
    Parameters
    ----------
    x1, x2 : array_like
       Only integer types are handled (including booleans).
    Returns
    -------
    out : array_like
       Result.
    See Also
    --------
    logical_and
    bitwise_or
    bitwise_xor
    binary_repr :
       Return the binary representation of the input number as a string.
    Examples
    --------
    The number 13 is represented by ``00001101``.  Likewise, 17 is
    represented by ``00010001``.  The bit-wise AND of 13 and 17 is
    therefore ``000000001``, or 1:
    >>> np.bitwise_and(13, 17)
    1
    >>> np.bitwise_and(14, 13)
    12
    >>> np.binary_repr(12)
    '1100'
    >>> np.bitwise_and([14,3], 13)
    array([12,  1])
    >>> np.bitwise_and([11,7], [4,25])
    array([0, 1])
    >>> np.bitwise_and(np.array([2,5,255]), np.array([3,14,16]))
    array([ 2,  4, 16])
    >>> np.bitwise_and([True, True], [False, True])
    array([False,  True], dtype=bool)
    """
    
    
    return array_like()
def bitwise_not(x1):
    """invert(x[, out])
    Compute bit-wise inversion, or bit-wise NOT, element-wise.
    Computes the bit-wise NOT of the underlying binary representation of
    the integers in the input arrays. This ufunc implements the C/Python
    operator ``~``.
    For signed integer inputs, the two's complement is returned.
    In a two's-complement system negative numbers are represented by the two's
    complement of the absolute value. This is the most common method of
    representing signed integers on computers [1]_. A N-bit two's-complement
    system can represent every integer in the range
    :math:`-2^{N-1}` to :math:`+2^{N-1}-1`.
    Parameters
    ----------
    x1 : array_like
       Only integer types are handled (including booleans).
    Returns
    -------
    out : array_like
       Result.
    See Also
    --------
    bitwise_and, bitwise_or, bitwise_xor
    logical_not
    binary_repr :
       Return the binary representation of the input number as a string.
    Notes
    -----
    `bitwise_not` is an alias for `invert`:
    >>> np.bitwise_not is np.invert
    True
    References
    ----------
    .. [1] Wikipedia, "Two's complement",
       http://en.wikipedia.org/wiki/Two's_complement
    Examples
    --------
    We've seen that 13 is represented by ``00001101``.
    The invert or bit-wise NOT of 13 is then:
    >>> np.invert(np.array([13], dtype=uint8))
    array([242], dtype=uint8)
    >>> np.binary_repr(x, width=8)
    '00001101'
    >>> np.binary_repr(242, width=8)
    '11110010'
    The result depends on the bit-width:
    >>> np.invert(np.array([13], dtype=uint16))
    array([65522], dtype=uint16)
    >>> np.binary_repr(x, width=16)
    '0000000000001101'
    >>> np.binary_repr(65522, width=16)
    '1111111111110010'
    When using signed integer types the result is the two's complement of
    the result for the unsigned type:
    >>> np.invert(np.array([13], dtype=int8))
    array([-14], dtype=int8)
    >>> np.binary_repr(-14, width=8)
    '11110010'
    Booleans are accepted as well:
    >>> np.invert(array([True, False]))
    array([False,  True], dtype=bool)
    """
    
    
    return array_like()
def bitwise_or(x1,x2,out):
    """bitwise_or(x1, x2[, out])
    Compute the bit-wise OR of two arrays element-wise.
    Computes the bit-wise OR of the underlying binary representation of
    the integers in the input arrays. This ufunc implements the C/Python
    operator ``|``.
    Parameters
    ----------
    x1, x2 : array_like
       Only integer types are handled (including booleans).
    out : ndarray, optional
       Array into which the output is placed. Its type is preserved and it
       must be of the right shape to hold the output. See doc.ufuncs.
    Returns
    -------
    out : array_like
       Result.
    See Also
    --------
    logical_or
    bitwise_and
    bitwise_xor
    binary_repr :
       Return the binary representation of the input number as a string.
    Examples
    --------
    The number 13 has the binaray representation ``00001101``. Likewise,
    16 is represented by ``00010000``.  The bit-wise OR of 13 and 16 is
    then ``000111011``, or 29:
    >>> np.bitwise_or(13, 16)
    29
    >>> np.binary_repr(29)
    '11101'
    >>> np.bitwise_or(32, 2)
    34
    >>> np.bitwise_or([33, 4], 1)
    array([33,  5])
    >>> np.bitwise_or([33, 4], [1, 2])
    array([33,  6])
    >>> np.bitwise_or(np.array([2, 5, 255]), np.array([4, 4, 4]))
    array([  6,   5, 255])
    >>> np.array([2, 5, 255]) | np.array([4, 4, 4])
    array([  6,   5, 255])
    >>> np.bitwise_or(np.array([2, 5, 255, 2147483647L], dtype=np.int32),
    ...               np.array([4, 4, 4, 2147483647L], dtype=np.int32))
    array([         6,          5,        255, 2147483647])
    >>> np.bitwise_or([True, True], [False, True])
    array([ True,  True], dtype=bool)
    """
    
    
    return array_like()
def bitwise_xor(x1,x2):
    """bitwise_xor(x1, x2[, out])
    Compute the bit-wise XOR of two arrays element-wise.
    Computes the bit-wise XOR of the underlying binary representation of
    the integers in the input arrays. This ufunc implements the C/Python
    operator ``^``.
    Parameters
    ----------
    x1, x2 : array_like
       Only integer types are handled (including booleans).
    Returns
    -------
    out : array_like
       Result.
    See Also
    --------
    logical_xor
    bitwise_and
    bitwise_or
    binary_repr :
       Return the binary representation of the input number as a string.
    Examples
    --------
    The number 13 is represented by ``00001101``. Likewise, 17 is
    represented by ``00010001``.  The bit-wise XOR of 13 and 17 is
    therefore ``00011100``, or 28:
    >>> np.bitwise_xor(13, 17)
    28
    >>> np.binary_repr(28)
    '11100'
    >>> np.bitwise_xor(31, 5)
    26
    >>> np.bitwise_xor([31,3], 5)
    array([26,  6])
    >>> np.bitwise_xor([31,3], [5,6])
    array([26,  5])
    >>> np.bitwise_xor([True, True], [False, True])
    array([ True, False], dtype=bool)
    """
    
    
    return array_like()
def blackman(M):
    """   Return the Blackman window.
       The Blackman window is a taper formed by using the the first three
       terms of a summation of cosines. It was designed to have close to the
       minimal leakage possible.  It is close to optimal, only slightly worse
       than a Kaiser window.
       Parameters
       ----------
       M : int
           Number of points in the output window. If zero or less, an empty
           array is returned.
       Returns
       -------
       out : ndarray
           The window, normalized to one (the value one appears only if the
           number of samples is odd).
       See Also
       --------
       bartlett, hamming, hanning, kaiser
       Notes
       -----
       The Blackman window is defined as
       .. math::  w(n) = 0.42 - 0.5 \cos(2\pi n/M) + 0.08 \cos(4\pi n/M)
       Most references to the Blackman window come from the signal processing
       literature, where it is used as one of many windowing functions for
       smoothing values.  It is also known as an apodization (which means
       "removing the foot", i.e. smoothing discontinuities at the beginning
       and end of the sampled signal) or tapering function. It is known as a
       "near optimal" tapering function, almost as good (by some measures)
       as the kaiser window.
       References
       ----------
       Blackman, R.B. and Tukey, J.W., (1958) The measurement of power spectra,
       Dover Publications, New York.
       Oppenheim, A.V., and R.W. Schafer. Discrete-Time Signal Processing.
       Upper Saddle River, NJ: Prentice-Hall, 1999, pp. 468-471.
       Examples
       --------
       >>> from numpy import blackman
       >>> blackman(12)
       array([ -1.38777878e-17,   3.26064346e-02,   1.59903635e-01,
                4.14397981e-01,   7.36045180e-01,   9.67046769e-01,
                9.67046769e-01,   7.36045180e-01,   4.14397981e-01,
                1.59903635e-01,   3.26064346e-02,  -1.38777878e-17])
       Plot the window and the frequency response:
       >>> from numpy import clip, log10, array, blackman, linspace
       >>> from numpy.fft import fft, fftshift
       >>> import matplotlib.pyplot as plt
       >>> window = blackman(51)
       >>> plt.plot(window)
       [<matplotlib.lines.Line2D object at 0x...>]
       >>> plt.title("Blackman window")
       <matplotlib.text.Text object at 0x...>
       >>> plt.ylabel("Amplitude")
       <matplotlib.text.Text object at 0x...>
       >>> plt.xlabel("Sample")
       <matplotlib.text.Text object at 0x...>
       >>> plt.show()
       >>> plt.figure()
       <matplotlib.figure.Figure object at 0x...>
       >>> A = fft(window, 2048) / 25.5
       >>> mag = abs(fftshift(A))
       >>> freq = linspace(-0.5,0.5,len(A))
       >>> response = 20*log10(mag)
       >>> response = clip(response,-100,100)
       >>> plt.plot(freq, response)
       [<matplotlib.lines.Line2D object at 0x...>]
       >>> plt.title("Frequency response of Blackman window")
       <matplotlib.text.Text object at 0x...>
       >>> plt.ylabel("Magnitude [dB]")
       <matplotlib.text.Text object at 0x...>
       >>> plt.xlabel("Normalized frequency [cycles per sample]")
       <matplotlib.text.Text object at 0x...>
       >>> plt.axis('tight')
       (-0.5, 0.5, -100.0, ...)
       >>> plt.show()
       
    """
    
    
    return ndarray()
def bmat(obj):
    """   Build a matrix object from a string, nested sequence, or array.
       Parameters
       ----------
       obj : str or array_like
           Input data.  Names of variables in the current scope may be
           referenced, even if `obj` is a string.
       Returns
       -------
       out : matrix
           Returns a matrix object, which is a specialized 2-D array.
       See Also
       --------
       matrix
       Examples
       --------
       >>> A = np.mat('1 1; 1 1')
       >>> B = np.mat('2 2; 2 2')
       >>> C = np.mat('3 4; 5 6')
       >>> D = np.mat('7 8; 9 0')
       All the following expressions construct the same block matrix:
       >>> np.bmat([[A, B], [C, D]])
       matrix([[1, 1, 2, 2],
               [1, 1, 2, 2],
               [3, 4, 7, 8],
               [5, 6, 9, 0]])
       >>> np.bmat(np.r_[np.c_[A, B], np.c_[C, D]])
       matrix([[1, 1, 2, 2],
               [1, 1, 2, 2],
               [3, 4, 7, 8],
               [5, 6, 9, 0]])
       >>> np.bmat('A,B; C,D')
       matrix([[1, 1, 2, 2],
               [1, 1, 2, 2],
               [3, 4, 7, 8],
               [5, 6, 9, 0]])
       
    """
    
    
    return matrix()
class bool:
    def conjugate(self):
        """Returns self, the complex conjugate of any int.
        """
        
        
        return None
    denominator = None
    imag = None
    numerator = None
    real = None
    

class bool8:
    T = None
    def all(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def any(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmax(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmin(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argsort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def astype(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    base = None
    def byteswap(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def choose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def clip(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def compress(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def conj(self):
        """None"""
        
        
        return None
    def conjugate(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def copy(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumprod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumsum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    data = None
    def diagonal(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    dtype = None
    def dump(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def dumps(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def fill(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    flags = None
    flat = None
    def flatten(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def getfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    imag = None
    def item(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def itemset(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    itemsize = None
    def max(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def mean(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def min(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    nbytes = None
    ndim = None
    def newbyteorder(self,new_order):
        """newbyteorder(new_order='S')
           Return a new `dtype` with a different byte order.
           Changes are also made in all fields and sub-arrays of the data type.
           The `new_order` code can be any from the following:
           * {'<', 'L'} - little endian
           * {'>', 'B'} - big endian
           * {'=', 'N'} - native order
           * 'S' - swap dtype from current to opposite endian
           * {'|', 'I'} - ignore (no change to byte order)
           Parameters
           ----------
           new_order : str, optional
               Byte order to force; a value from the byte order specifications
               above.  The default value ('S') results in swapping the current
               byte order. The code does a case-insensitive check on the first
               letter of `new_order` for the alternatives above.  For example,
               any of 'B' or 'b' or 'biggish' are valid to specify big-endian.
           Returns
           -------
           new_dtype : dtype
               New `dtype` object with the given change to the byte order.
        """
        
        
        return dtype()
    def nonzero(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def prod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ptp(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def put(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ravel(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    real = None
    def repeat(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def reshape(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def resize(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def round(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def searchsorted(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setflags(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    shape = None
    size = None
    def sort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def squeeze(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def std(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    strides = None
    def sum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def swapaxes(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def take(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tofile(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tolist(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tostring(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def trace(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def transpose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def var(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def view(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    

class bool_:
    T = None
    def all(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def any(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmax(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmin(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argsort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def astype(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    base = None
    def byteswap(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def choose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def clip(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def compress(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def conj(self):
        """None"""
        
        
        return None
    def conjugate(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def copy(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumprod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumsum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    data = None
    def diagonal(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    dtype = None
    def dump(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def dumps(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def fill(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    flags = None
    flat = None
    def flatten(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def getfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    imag = None
    def item(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def itemset(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    itemsize = None
    def max(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def mean(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def min(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    nbytes = None
    ndim = None
    def newbyteorder(self,new_order):
        """newbyteorder(new_order='S')
           Return a new `dtype` with a different byte order.
           Changes are also made in all fields and sub-arrays of the data type.
           The `new_order` code can be any from the following:
           * {'<', 'L'} - little endian
           * {'>', 'B'} - big endian
           * {'=', 'N'} - native order
           * 'S' - swap dtype from current to opposite endian
           * {'|', 'I'} - ignore (no change to byte order)
           Parameters
           ----------
           new_order : str, optional
               Byte order to force; a value from the byte order specifications
               above.  The default value ('S') results in swapping the current
               byte order. The code does a case-insensitive check on the first
               letter of `new_order` for the alternatives above.  For example,
               any of 'B' or 'b' or 'biggish' are valid to specify big-endian.
           Returns
           -------
           new_dtype : dtype
               New `dtype` object with the given change to the byte order.
        """
        
        
        return dtype()
    def nonzero(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def prod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ptp(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def put(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ravel(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    real = None
    def repeat(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def reshape(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def resize(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def round(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def searchsorted(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setflags(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    shape = None
    size = None
    def sort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def squeeze(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def std(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    strides = None
    def sum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def swapaxes(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def take(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tofile(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tolist(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tostring(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def trace(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def transpose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def var(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def view(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    

class broadcast:
    index = None
    iters = None
    nd = None
    def next(self,):
        """x.next() -> the next value, or raise StopIteration
        """
        
        
        return None
    numiter = None
    def reset(self):
        """None"""
        
        
        return None
    shape = None
    size = None
    

def broadcast_arrays(args):
    """   Broadcast any number of arrays against each other.
       Parameters
       ----------
       `*args` : array_likes
           The arrays to broadcast.
       Returns
       -------
       broadcasted : list of arrays
           These arrays are views on the original arrays.  They are typically
           not contiguous.  Furthermore, more than one element of a
           broadcasted array may refer to a single memory location.  If you
           need to write to the arrays, make copies first.
       Examples
       --------
       >>> x = np.array([[1,2,3]])
       >>> y = np.array([[1],[2],[3]])
       >>> np.broadcast_arrays(x, y)
       [array([[1, 2, 3],
              [1, 2, 3],
              [1, 2, 3]]), array([[1, 1, 1],
              [2, 2, 2],
              [3, 3, 3]])]
       Here is a useful idiom for getting contiguous copies instead of
       non-contiguous views.
       >>> map(np.array, np.broadcast_arrays(x, y))
       [array([[1, 2, 3],
              [1, 2, 3],
              [1, 2, 3]]), array([[1, 1, 1],
              [2, 2, 2],
              [3, 3, 3]])]
       
    """
    
    
    return list()
class byte:
    T = None
    def all(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def any(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmax(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmin(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argsort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def astype(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    base = None
    def byteswap(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def choose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def clip(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def compress(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def conj(self):
        """None"""
        
        
        return None
    def conjugate(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def copy(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumprod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumsum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    data = None
    def diagonal(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    dtype = None
    def dump(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def dumps(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def fill(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    flags = None
    flat = None
    def flatten(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def getfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    imag = None
    def item(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def itemset(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    itemsize = None
    def max(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def mean(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def min(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    nbytes = None
    ndim = None
    def newbyteorder(self,new_order):
        """newbyteorder(new_order='S')
           Return a new `dtype` with a different byte order.
           Changes are also made in all fields and sub-arrays of the data type.
           The `new_order` code can be any from the following:
           * {'<', 'L'} - little endian
           * {'>', 'B'} - big endian
           * {'=', 'N'} - native order
           * 'S' - swap dtype from current to opposite endian
           * {'|', 'I'} - ignore (no change to byte order)
           Parameters
           ----------
           new_order : str, optional
               Byte order to force; a value from the byte order specifications
               above.  The default value ('S') results in swapping the current
               byte order. The code does a case-insensitive check on the first
               letter of `new_order` for the alternatives above.  For example,
               any of 'B' or 'b' or 'biggish' are valid to specify big-endian.
           Returns
           -------
           new_dtype : dtype
               New `dtype` object with the given change to the byte order.
        """
        
        
        return dtype()
    def nonzero(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def prod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ptp(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def put(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ravel(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    real = None
    def repeat(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def reshape(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def resize(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def round(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def searchsorted(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setflags(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    shape = None
    size = None
    def sort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def squeeze(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def std(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    strides = None
    def sum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def swapaxes(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def take(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tofile(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tolist(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tostring(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def trace(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def transpose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def var(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def view(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    

def byte_bounds(a):
    """   Returns pointers to the end-points of an array.
       Parameters
       ----------
       a : ndarray
           Input array. It must conform to the Python-side of the array interface.
       Returns
       -------
       (low, high) : tuple of 2 integers
           The first integer is the first byte of the array, the second integer is
           just past the last byte of the array.  If `a` is not contiguous it
           will not use every byte between the (`low`, `high`) values.
       Examples
       --------
       >>> I = np.eye(2, dtype='f'); I.dtype
       dtype('float32')
       >>> low, high = np.byte_bounds(I)
       >>> high - low == I.size*I.itemsize
       True
       >>> I = np.eye(2, dtype='G'); I.dtype
       dtype('complex192')
       >>> low, high = np.byte_bounds(I)
       >>> high - low == I.size*I.itemsize
       True
       
    """
    
    
    return tuple()
class bytes_:
    T = None
    def all(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def any(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmax(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmin(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argsort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def astype(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    base = None
    def byteswap(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def capitalize(self,):
        """S.capitalize() -> string
        Return a copy of the string S with only its first character
        capitalized.
        """
        
        
        return None
    def center(self,width,fillchar):
        """S.center(width[, fillchar]) -> string
        Return S centered in a string of length width. Padding is
        done using the specified fill character (default is a space)
        """
        
        
        return None
    def choose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def clip(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def compress(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def conj(self):
        """None"""
        
        
        return None
    def conjugate(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def copy(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def count(self,sub,start,end):
        """S.count(sub[, start[, end]]) -> int
        Return the number of non-overlapping occurrences of substring sub in
        string S[start:end].  Optional arguments start and end are interpreted
        as in slice notation.
        """
        
        
        return None
    def cumprod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumsum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    data = None
    def decode(self,encoding,errors):
        """S.decode([encoding[,errors]]) -> object
        Decodes S using the codec registered for encoding. encoding defaults
        to the default encoding. errors may be given to set a different error
        handling scheme. Default is 'strict' meaning that encoding errors raise
        a UnicodeDecodeError. Other possible values are 'ignore' and 'replace'
        as well as any other name registered with codecs.register_error that is
        able to handle UnicodeDecodeErrors.
        """
        
        
        return None
    def diagonal(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    dtype = None
    def dump(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def dumps(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def encode(self,encoding,errors):
        """S.encode([encoding[,errors]]) -> object
        Encodes S using the codec registered for encoding. encoding defaults
        to the default encoding. errors may be given to set a different error
        handling scheme. Default is 'strict' meaning that encoding errors raise
        a UnicodeEncodeError. Other possible values are 'ignore', 'replace' and
        'xmlcharrefreplace' as well as any other name registered with
        codecs.register_error that is able to handle UnicodeEncodeErrors.
        """
        
        
        return None
    def endswith(self,suffix,start,end):
        """S.endswith(suffix[, start[, end]]) -> bool
        Return True if S ends with the specified suffix, False otherwise.
        With optional start, test S beginning at that position.
        With optional end, stop comparing S at that position.
        suffix can also be a tuple of strings to try.
        """
        
        
        return None
    def expandtabs(self,tabsize):
        """S.expandtabs([tabsize]) -> string
        Return a copy of S where all tab characters are expanded using spaces.
        If tabsize is not given, a tab size of 8 characters is assumed.
        """
        
        
        return None
    def fill(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def find(self,sub,start,end):
        """S.find(sub [,start [,end]]) -> int
        Return the lowest index in S where substring sub is found,
        such that sub is contained within s[start:end].  Optional
        arguments start and end are interpreted as in slice notation.
        Return -1 on failure.
        """
        
        
        return None
    flags = None
    flat = None
    def flatten(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def format(self,args,kwargs):
        """S.format(*args, **kwargs) -> string
        """
        
        
        return None
    def getfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    imag = None
    def index(self,sub,start,end):
        """S.index(sub [,start [,end]]) -> int
        Like S.find() but raise ValueError when the substring is not found.
        """
        
        
        return None
    def isalnum(self,):
        """S.isalnum() -> bool
        Return True if all characters in S are alphanumeric
        and there is at least one character in S, False otherwise.
        """
        
        
        return None
    def isalpha(self,):
        """S.isalpha() -> bool
        Return True if all characters in S are alphabetic
        and there is at least one character in S, False otherwise.
        """
        
        
        return None
    def isdigit(self,):
        """S.isdigit() -> bool
        Return True if all characters in S are digits
        and there is at least one character in S, False otherwise.
        """
        
        
        return None
    def islower(self,):
        """S.islower() -> bool
        Return True if all cased characters in S are lowercase and there is
        at least one cased character in S, False otherwise.
        """
        
        
        return None
    def isspace(self,):
        """S.isspace() -> bool
        Return True if all characters in S are whitespace
        and there is at least one character in S, False otherwise.
        """
        
        
        return None
    def istitle(self,):
        """S.istitle() -> bool
        Return True if S is a titlecased string and there is at least one
        character in S, i.e. uppercase characters may only follow uncased
        characters and lowercase characters only cased ones. Return False
        otherwise.
        """
        
        
        return None
    def isupper(self,):
        """S.isupper() -> bool
        Return True if all cased characters in S are uppercase and there is
        at least one cased character in S, False otherwise.
        """
        
        
        return None
    def item(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def itemset(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    itemsize = None
    def join(self,iterable):
        """S.join(iterable) -> string
        Return a string which is the concatenation of the strings in the
        iterable.  The separator between elements is S.
        """
        
        
        return None
    def ljust(self,width,fillchar):
        """S.ljust(width[, fillchar]) -> string
        Return S left-justified in a string of length width. Padding is
        done using the specified fill character (default is a space).
        """
        
        
        return None
    def lower(self,):
        """S.lower() -> string
        Return a copy of the string S converted to lowercase.
        """
        
        
        return None
    def lstrip(self,chars):
        """S.lstrip([chars]) -> string or unicode
        Return a copy of the string S with leading whitespace removed.
        If chars is given and not None, remove characters in chars instead.
        If chars is unicode, S will be converted to unicode before stripping
        """
        
        
        return None
    def max(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def mean(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def min(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    nbytes = None
    ndim = None
    def newbyteorder(self,new_order):
        """newbyteorder(new_order='S')
           Return a new `dtype` with a different byte order.
           Changes are also made in all fields and sub-arrays of the data type.
           The `new_order` code can be any from the following:
           * {'<', 'L'} - little endian
           * {'>', 'B'} - big endian
           * {'=', 'N'} - native order
           * 'S' - swap dtype from current to opposite endian
           * {'|', 'I'} - ignore (no change to byte order)
           Parameters
           ----------
           new_order : str, optional
               Byte order to force; a value from the byte order specifications
               above.  The default value ('S') results in swapping the current
               byte order. The code does a case-insensitive check on the first
               letter of `new_order` for the alternatives above.  For example,
               any of 'B' or 'b' or 'biggish' are valid to specify big-endian.
           Returns
           -------
           new_dtype : dtype
               New `dtype` object with the given change to the byte order.
        """
        
        
        return dtype()
    def nonzero(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def partition(self,sep):
        """S.partition(sep) -> (head, sep, tail)
        Search for the separator sep in S, and return the part before it,
        the separator itself, and the part after it.  If the separator is not
        found, return S and two empty strings.
        """
        
        
        return None
    def prod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ptp(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def put(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ravel(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    real = None
    def repeat(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def replace(self,old,new,count):
        """S.replace(old, new[, count]) -> string
        Return a copy of string S with all occurrences of substring
        old replaced by new.  If the optional argument count is
        given, only the first count occurrences are replaced.
        """
        
        
        return None
    def reshape(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def resize(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def rfind(self,sub,start,end):
        """S.rfind(sub [,start [,end]]) -> int
        Return the highest index in S where substring sub is found,
        such that sub is contained within s[start:end].  Optional
        arguments start and end are interpreted as in slice notation.
        Return -1 on failure.
        """
        
        
        return None
    def rindex(self,sub,start,end):
        """S.rindex(sub [,start [,end]]) -> int
        Like S.rfind() but raise ValueError when the substring is not found.
        """
        
        
        return None
    def rjust(self,width,fillchar):
        """S.rjust(width[, fillchar]) -> string
        Return S right-justified in a string of length width. Padding is
        done using the specified fill character (default is a space)
        """
        
        
        return None
    def round(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def rpartition(self,sep):
        """S.rpartition(sep) -> (head, sep, tail)
        Search for the separator sep in S, starting at the end of S, and return
        the part before it, the separator itself, and the part after it.  If the
        separator is not found, return two empty strings and S.
        """
        
        
        return None
    def rsplit(self,sep,maxsplit):
        """S.rsplit([sep [,maxsplit]]) -> list of strings
        Return a list of the words in the string S, using sep as the
        delimiter string, starting at the end of the string and working
        to the front.  If maxsplit is given, at most maxsplit splits are
        done. If sep is not specified or is None, any whitespace string
        is a separator.
        """
        
        
        return None
    def rstrip(self,chars):
        """S.rstrip([chars]) -> string or unicode
        Return a copy of the string S with trailing whitespace removed.
        If chars is given and not None, remove characters in chars instead.
        If chars is unicode, S will be converted to unicode before stripping
        """
        
        
        return None
    def searchsorted(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setflags(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    shape = None
    size = None
    def sort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def split(self,sep,maxsplit):
        """S.split([sep [,maxsplit]]) -> list of strings
        Return a list of the words in the string S, using sep as the
        delimiter string.  If maxsplit is given, at most maxsplit
        splits are done. If sep is not specified or is None, any
        whitespace string is a separator and empty strings are removed
        from the result.
        """
        
        
        return None
    def splitlines(self,keepends):
        """S.splitlines([keepends]) -> list of strings
        Return a list of the lines in S, breaking at line boundaries.
        Line breaks are not included in the resulting list unless keepends
        is given and true.
        """
        
        
        return None
    def squeeze(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def startswith(self,prefix,start,end):
        """S.startswith(prefix[, start[, end]]) -> bool
        Return True if S starts with the specified prefix, False otherwise.
        With optional start, test S beginning at that position.
        With optional end, stop comparing S at that position.
        prefix can also be a tuple of strings to try.
        """
        
        
        return None
    def std(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    strides = None
    def strip(self,chars):
        """S.strip([chars]) -> string or unicode
        Return a copy of the string S with leading and trailing
        whitespace removed.
        If chars is given and not None, remove characters in chars instead.
        If chars is unicode, S will be converted to unicode before stripping
        """
        
        
        return None
    def sum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def swapaxes(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def swapcase(self,):
        """S.swapcase() -> string
        Return a copy of the string S with uppercase characters
        converted to lowercase and vice versa.
        """
        
        
        return None
    def take(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def title(self,):
        """S.title() -> string
        Return a titlecased version of S, i.e. words start with uppercase
        characters, all remaining cased characters have lowercase.
        """
        
        
        return None
    def tofile(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tolist(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tostring(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def trace(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def translate(self,table,deletechars):
        """S.translate(table [,deletechars]) -> string
        Return a copy of the string S, where all characters occurring
        in the optional argument deletechars are removed, and the
        remaining characters have been mapped through the given
        translation table, which must be a string of length 256.
        """
        
        
        return None
    def transpose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def upper(self,):
        """S.upper() -> string
        Return a copy of the string S converted to uppercase.
        """
        
        
        return None
    def var(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def view(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def zfill(self,width):
        """S.zfill(width) -> string
        Pad a numeric string S with zeros on the left, to fill a field
        of the specified width.  The string S is never truncated.
        """
        
        
        return None
    

c_ = None
def can_cast(fromtype,totype):
    """can_cast(fromtype, totype)
       Returns True if cast between data types can occur without losing precision.
       Parameters
       ----------
       fromtype : dtype or dtype specifier
           Data type to cast from.
       totype : dtype or dtype specifier
           Data type to cast to.
       Returns
       -------
       out : bool
           True if cast can occur without losing precision.
       Examples
       --------
       >>> np.can_cast(np.int32, np.int64)
       True
       >>> np.can_cast(np.float64, np.complex)
       True
       >>> np.can_cast(np.complex, np.float)
       False
       >>> np.can_cast('i8', 'f8')
       True
       >>> np.can_cast('i8', 'f4')
       False
       >>> np.can_cast('i4', 'S4')
       True
    """
    
    
    return bool()
cast = {}
class cdouble:
    T = None
    def all(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def any(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmax(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmin(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argsort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def astype(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    base = None
    def byteswap(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def choose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def clip(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def compress(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def conj(self):
        """None"""
        
        
        return None
    def conjugate(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def copy(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumprod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumsum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    data = None
    def diagonal(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    dtype = None
    def dump(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def dumps(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def fill(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    flags = None
    flat = None
    def flatten(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def getfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    imag = None
    def item(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def itemset(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    itemsize = None
    def max(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def mean(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def min(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    nbytes = None
    ndim = None
    def newbyteorder(self,new_order):
        """newbyteorder(new_order='S')
           Return a new `dtype` with a different byte order.
           Changes are also made in all fields and sub-arrays of the data type.
           The `new_order` code can be any from the following:
           * {'<', 'L'} - little endian
           * {'>', 'B'} - big endian
           * {'=', 'N'} - native order
           * 'S' - swap dtype from current to opposite endian
           * {'|', 'I'} - ignore (no change to byte order)
           Parameters
           ----------
           new_order : str, optional
               Byte order to force; a value from the byte order specifications
               above.  The default value ('S') results in swapping the current
               byte order. The code does a case-insensitive check on the first
               letter of `new_order` for the alternatives above.  For example,
               any of 'B' or 'b' or 'biggish' are valid to specify big-endian.
           Returns
           -------
           new_dtype : dtype
               New `dtype` object with the given change to the byte order.
        """
        
        
        return dtype()
    def nonzero(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def prod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ptp(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def put(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ravel(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    real = None
    def repeat(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def reshape(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def resize(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def round(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def searchsorted(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setflags(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    shape = None
    size = None
    def sort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def squeeze(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def std(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    strides = None
    def sum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def swapaxes(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def take(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tofile(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tolist(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tostring(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def trace(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def transpose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def var(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def view(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    

def ceil(x):
    """ceil(x[, out])
    Return the ceiling of the input, element-wise.
    The ceil of the scalar `x` is the smallest integer `i`, such that
    `i >= x`.  It is often denoted as :math:`\lceil x \rceil`.
    Parameters
    ----------
    x : array_like
       Input data.
    Returns
    -------
    y : {ndarray, scalar}
       The ceiling of each element in `x`, with `float` dtype.
    See Also
    --------
    floor, trunc, rint
    Examples
    --------
    >>> a = np.array([-1.7, -1.5, -0.2, 0.2, 1.5, 1.7, 2.0])
    >>> np.ceil(a)
    array([-1., -1., -0.,  1.,  2.,  2.,  2.])
    """
    
    
    return ndarray()
class cfloat:
    T = None
    def all(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def any(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmax(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmin(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argsort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def astype(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    base = None
    def byteswap(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def choose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def clip(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def compress(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def conj(self):
        """None"""
        
        
        return None
    def conjugate(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def copy(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumprod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumsum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    data = None
    def diagonal(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    dtype = None
    def dump(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def dumps(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def fill(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    flags = None
    flat = None
    def flatten(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def getfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    imag = None
    def item(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def itemset(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    itemsize = None
    def max(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def mean(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def min(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    nbytes = None
    ndim = None
    def newbyteorder(self,new_order):
        """newbyteorder(new_order='S')
           Return a new `dtype` with a different byte order.
           Changes are also made in all fields and sub-arrays of the data type.
           The `new_order` code can be any from the following:
           * {'<', 'L'} - little endian
           * {'>', 'B'} - big endian
           * {'=', 'N'} - native order
           * 'S' - swap dtype from current to opposite endian
           * {'|', 'I'} - ignore (no change to byte order)
           Parameters
           ----------
           new_order : str, optional
               Byte order to force; a value from the byte order specifications
               above.  The default value ('S') results in swapping the current
               byte order. The code does a case-insensitive check on the first
               letter of `new_order` for the alternatives above.  For example,
               any of 'B' or 'b' or 'biggish' are valid to specify big-endian.
           Returns
           -------
           new_dtype : dtype
               New `dtype` object with the given change to the byte order.
        """
        
        
        return dtype()
    def nonzero(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def prod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ptp(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def put(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ravel(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    real = None
    def repeat(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def reshape(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def resize(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def round(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def searchsorted(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setflags(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    shape = None
    size = None
    def sort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def squeeze(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def std(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    strides = None
    def sum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def swapaxes(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def take(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tofile(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tolist(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tostring(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def trace(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def transpose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def var(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def view(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    

char = None
class character:
    T = None
    def all(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def any(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmax(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmin(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argsort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def astype(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    base = None
    def byteswap(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def choose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def clip(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def compress(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def conj(self):
        """None"""
        
        
        return None
    def conjugate(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def copy(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumprod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumsum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    data = None
    def diagonal(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    dtype = None
    def dump(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def dumps(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def fill(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    flags = None
    flat = None
    def flatten(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def getfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    imag = None
    def item(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def itemset(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    itemsize = None
    def max(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def mean(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def min(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    nbytes = None
    ndim = None
    def newbyteorder(self,new_order):
        """newbyteorder(new_order='S')
           Return a new `dtype` with a different byte order.
           Changes are also made in all fields and sub-arrays of the data type.
           The `new_order` code can be any from the following:
           * {'<', 'L'} - little endian
           * {'>', 'B'} - big endian
           * {'=', 'N'} - native order
           * 'S' - swap dtype from current to opposite endian
           * {'|', 'I'} - ignore (no change to byte order)
           Parameters
           ----------
           new_order : str, optional
               Byte order to force; a value from the byte order specifications
               above.  The default value ('S') results in swapping the current
               byte order. The code does a case-insensitive check on the first
               letter of `new_order` for the alternatives above.  For example,
               any of 'B' or 'b' or 'biggish' are valid to specify big-endian.
           Returns
           -------
           new_dtype : dtype
               New `dtype` object with the given change to the byte order.
        """
        
        
        return dtype()
    def nonzero(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def prod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ptp(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def put(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ravel(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    real = None
    def repeat(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def reshape(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def resize(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def round(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def searchsorted(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setflags(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    shape = None
    size = None
    def sort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def squeeze(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def std(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    strides = None
    def sum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def swapaxes(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def take(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tofile(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tolist(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tostring(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def trace(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def transpose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def var(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def view(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    

class chararray:
    T = None
    def all(self,axis=None,out=None):
        """a.all(axis=None, out=None)
           Returns True if all elements evaluate to True.
           Refer to `numpy.all` for full documentation.
           See Also
           --------
           numpy.all : equivalent function
        """
        
        
        return None
    def any(self,axis=None,out=None):
        """a.any(axis=None, out=None)
           Returns True if any of the elements of `a` evaluate to True.
           Refer to `numpy.any` for full documentation.
           See Also
           --------
           numpy.any : equivalent function
        """
        
        
        return None
    def argmax(self,axis=None,out=None):
        """a.argmax(axis=None, out=None)
           Return indices of the maximum values along the given axis.
           Refer to `numpy.argmax` for full documentation.
           See Also
           --------
           numpy.argmax : equivalent function
        """
        
        
        return None
    def argmin(self,axis=None,out=None):
        """a.argmin(axis=None, out=None)
           Return indices of the minimum values along the given axis of `a`.
           Refer to `numpy.argmin` for detailed documentation.
           See Also
           --------
           numpy.argmin : equivalent function
        """
        
        
        return None
    def argsort(self):
        """None"""
        
        
        return None
    def astype(self,t):
        """a.astype(t)
           Copy of the array, cast to a specified type.
           Parameters
           ----------
           t : string or dtype
               Typecode or data-type to which the array is cast.
           Examples
           --------
           >>> x = np.array([1, 2, 2.5])
           >>> x
           array([ 1. ,  2. ,  2.5])
           >>> x.astype(int)
           array([1, 2, 2])
        """
        
        
        return None
    base = None
    def byteswap(self):
        """a.byteswap(inplace)
           Swap the bytes of the array elements
           Toggle between low-endian and big-endian data representation by
           returning a byteswapped array, optionally swapped in-place.
           Parameters
           ----------
           inplace: bool, optional
               If ``True``, swap bytes in-place, default is ``False``.
           Returns
           -------
           out: ndarray
               The byteswapped array. If `inplace` is ``True``, this is
               a view to self.
           Examples
           --------
           >>> A = np.array([1, 256, 8755], dtype=np.int16)
           >>> map(hex, A)
           ['0x1', '0x100', '0x2233']
           >>> A.byteswap(True)
           array([  256,     1, 13090], dtype=int16)
           >>> map(hex, A)
           ['0x100', '0x1', '0x3322']
           Arrays of strings are not swapped
           >>> A = np.array(['ceg', 'fac'])
           >>> A.byteswap()
           array(['ceg', 'fac'],
                 dtype='|S3')
        """
        
        
        return None
    def capitalize(self):
        """       Return a copy of `self` with only the first character of each element
               capitalized.
               See also
               --------
               char.capitalize
               
        """
        
        
        return None
    def center(self):
        """           Return a copy of `self` with its elements centered in a
                   string of length `width`.
                   See also
                   --------
                   center
                   
        """
        
        
        return None
    def choose(self,choices,out=None,mode='raise'):
        """a.choose(choices, out=None, mode='raise')
           Use an index array to construct a new array from a set of choices.
           Refer to `numpy.choose` for full documentation.
           See Also
           --------
           numpy.choose : equivalent function
        """
        
        
        return None
    def clip(self,a_min,a_max,out=None):
        """a.clip(a_min, a_max, out=None)
           Return an array whose values are limited to ``[a_min, a_max]``.
           Refer to `numpy.clip` for full documentation.
           See Also
           --------
           numpy.clip : equivalent function
        """
        
        
        return None
    def compress(self,condition,axis=None,out=None):
        """a.compress(condition, axis=None, out=None)
           Return selected slices of this array along given axis.
           Refer to `numpy.compress` for full documentation.
           See Also
           --------
           numpy.compress : equivalent function
        """
        
        
        return None
    def conj(self,):
        """a.conj()
           Complex-conjugate all elements.
           Refer to `numpy.conjugate` for full documentation.
           See Also
           --------
           numpy.conjugate : equivalent function
        """
        
        
        return None
    def conjugate(self,):
        """a.conjugate()
           Return the complex conjugate, element-wise.
           Refer to `numpy.conjugate` for full documentation.
           See Also
           --------
           numpy.conjugate : equivalent function
        """
        
        
        return None
    def copy(self,order):
        """a.copy(order='C')
           Return a copy of the array.
           Parameters
           ----------
           order : {'C', 'F', 'A'}, optional
               By default, the result is stored in C-contiguous (row-major) order in
               memory.  If `order` is `F`, the result has 'Fortran' (column-major)
               order.  If order is 'A' ('Any'), then the result has the same order
               as the input.
           Examples
           --------
           >>> x = np.array([[1,2,3],[4,5,6]], order='F')
           >>> y = x.copy()
           >>> x.fill(0)
           >>> x
           array([[0, 0, 0],
                  [0, 0, 0]])
           >>> y
           array([[1, 2, 3],
                  [4, 5, 6]])
           >>> y.flags['C_CONTIGUOUS']
           True
        """
        
        
        return None
    def count(self):
        """       Returns an array with the number of non-overlapping occurrences of
               substring `sub` in the range [`start`, `end`].
               See also
               --------
               char.count
               
        """
        
        
        return None
    ctypes = None
    def cumprod(self,axis=None,dtype=None,out=None):
        """a.cumprod(axis=None, dtype=None, out=None)
           Return the cumulative product of the elements along the given axis.
           Refer to `numpy.cumprod` for full documentation.
           See Also
           --------
           numpy.cumprod : equivalent function
        """
        
        
        return None
    def cumsum(self,axis=None,dtype=None,out=None):
        """a.cumsum(axis=None, dtype=None, out=None)
           Return the cumulative sum of the elements along the given axis.
           Refer to `numpy.cumsum` for full documentation.
           See Also
           --------
           numpy.cumsum : equivalent function
        """
        
        
        return None
    data = None
    def decode(self):
        """       Calls `str.decode` element-wise.
               See also
               --------
               char.decode
               
        """
        
        
        return None
    def diagonal(self,offset=0,axis1=0,axis2=1):
        """a.diagonal(offset=0, axis1=0, axis2=1)
           Return specified diagonals.
           Refer to `numpy.diagonal` for full documentation.
           See Also
           --------
           numpy.diagonal : equivalent function
        """
        
        
        return None
    def dot(self):
        """None"""
        
        
        return None
    dtype = None
    def dump(self,file):
        """a.dump(file)
           Dump a pickle of the array to the specified file.
           The array can be read back with pickle.load or numpy.load.
           Parameters
           ----------
           file : str
               A string naming the dump file.
        """
        
        
        return None
    def dumps(self,):
        """a.dumps()
           Returns the pickle of the array as a string.
           pickle.loads or numpy.loads will convert the string back to an array.
           Parameters
           ----------
           None
        """
        
        
        return None
    def encode(self):
        """       Calls `str.encode` element-wise.
               See also
               --------
               char.encode
               
        """
        
        
        return None
    def endswith(self):
        """       Returns a boolean array which is `True` where the string element
               in `self` ends with `suffix`, otherwise `False`.
               See also
               --------
               char.endswith
               
        """
        
        
        return None
    def expandtabs(self):
        """       Return a copy of each string element where all tab characters are
               replaced by one or more spaces.
               See also
               --------
               char.expandtabs
               
        """
        
        
        return None
    def fill(self,value):
        """a.fill(value)
           Fill the array with a scalar value.
           Parameters
           ----------
           value : scalar
               All elements of `a` will be assigned this value.
           Examples
           --------
           >>> a = np.array([1, 2])
           >>> a.fill(0)
           >>> a
           array([0, 0])
           >>> a = np.empty(2)
           >>> a.fill(1)
           >>> a
           array([ 1.,  1.])
        """
        
        
        return None
    def find(self):
        """       For each element, return the lowest index in the string where
               substring `sub` is found.
               See also
               --------
               char.find
               
        """
        
        
        return None
    flags = None
    flat = None
    def flatten(self,order):
        """a.flatten(order='C')
           Return a copy of the array collapsed into one dimension.
           Parameters
           ----------
           order : {'C', 'F'}, optional
               Whether to flatten in C (row-major) or Fortran (column-major) order.
               The default is 'C'.
           Returns
           -------
           y : ndarray
               A copy of the input array, flattened to one dimension.
           See Also
           --------
           ravel : Return a flattened array.
           flat : A 1-D flat iterator over the array.
           Examples
           --------
           >>> a = np.array([[1,2], [3,4]])
           >>> a.flatten()
           array([1, 2, 3, 4])
           >>> a.flatten('F')
           array([1, 3, 2, 4])
        """
        
        
        return ndarray()
    def getfield(self,dtype,offset):
        """a.getfield(dtype, offset)
           Returns a field of the given array as a certain type.
           A field is a view of the array data with each itemsize determined
           by the given type and the offset into the current array, i.e. from
           ``offset * dtype.itemsize`` to ``(offset+1) * dtype.itemsize``.
           Parameters
           ----------
           dtype : str
               String denoting the data type of the field.
           offset : int
               Number of `dtype.itemsize`'s to skip before beginning the element view.
           Examples
           --------
           >>> x = np.diag([1.+1.j]*2)
           >>> x
           array([[ 1.+1.j,  0.+0.j],
                  [ 0.+0.j,  1.+1.j]])
           >>> x.dtype
           dtype('complex128')
           >>> x.getfield('complex64', 0) # Note how this != x
           array([[ 0.+1.875j,  0.+0.j   ],
                  [ 0.+0.j   ,  0.+1.875j]], dtype=complex64)
           >>> x.getfield('complex64',1) # Note how different this is than x
           array([[ 0. +5.87173204e-39j,  0. +0.00000000e+00j],
                  [ 0. +0.00000000e+00j,  0. +5.87173204e-39j]], dtype=complex64)
           >>> x.getfield('complex128', 0) # == x
           array([[ 1.+1.j,  0.+0.j],
                  [ 0.+0.j,  1.+1.j]])
           If the argument dtype is the same as x.dtype, then offset != 0 raises
           a ValueError:
           >>> x.getfield('complex128', 1)
           Traceback (most recent call last):
             File "<stdin>", line 1, in <module>
           ValueError: Need 0 <= offset <= 0 for requested type but received offset = 1
           >>> x.getfield('float64', 0)
           array([[ 1.,  0.],
                  [ 0.,  1.]])
           >>> x.getfield('float64', 1)
           array([[  1.77658241e-307,   0.00000000e+000],
                  [  0.00000000e+000,   1.77658241e-307]])
        """
        
        
        return None
    imag = None
    def index(self):
        """       Like `find`, but raises `ValueError` when the substring is not found.
               See also
               --------
               char.index
               
        """
        
        
        return None
    def isalnum(self):
        """       Returns true for each element if all characters in the string
               are alphanumeric and there is at least one character, false
               otherwise.
               See also
               --------
               char.isalnum
               
        """
        
        
        return None
    def isalpha(self):
        """       Returns true for each element if all characters in the string
               are alphabetic and there is at least one character, false
               otherwise.
               See also
               --------
               char.isalpha
               
        """
        
        
        return None
    def isdecimal(self):
        """       For each element in `self`, return True if there are only
               decimal characters in the element.
               See also
               --------
               char.isdecimal
               
        """
        
        
        return None
    def isdigit(self):
        """       Returns true for each element if all characters in the string are
               digits and there is at least one character, false otherwise.
               See also
               --------
               char.isdigit
               
        """
        
        
        return None
    def islower(self):
        """       Returns true for each element if all cased characters in the
               string are lowercase and there is at least one cased character,
               false otherwise.
               See also
               --------
               char.islower
               
        """
        
        
        return None
    def isnumeric(self):
        """       For each element in `self`, return True if there are only
               numeric characters in the element.
               See also
               --------
               char.isnumeric
               
        """
        
        
        return None
    def isspace(self):
        """       Returns true for each element if there are only whitespace
               characters in the string and there is at least one character,
               false otherwise.
               See also
               --------
               char.isspace
               
        """
        
        
        return None
    def istitle(self):
        """       Returns true for each element if the element is a titlecased
               string and there is at least one character, false otherwise.
               See also
               --------
               char.istitle
               
        """
        
        
        return None
    def isupper(self):
        """       Returns true for each element if all cased characters in the
               string are uppercase and there is at least one character, false
               otherwise.
               See also
               --------
               char.isupper
               
        """
        
        
        return None
    def item(self,args):
        """a.item(*args)
           Copy an element of an array to a standard Python scalar and return it.
           Parameters
           ----------
           \*args : Arguments (variable number and type)
               * none: in this case, the method only works for arrays
                 with one element (`a.size == 1`), which element is
                 copied into a standard Python scalar object and returned.
               * int_type: this argument is interpreted as a flat index into
                 the array, specifying which element to copy and return.
               * tuple of int_types: functions as does a single int_type argument,
                 except that the argument is interpreted as an nd-index into the
                 array.
           Returns
           -------
           z : Standard Python scalar object
               A copy of the specified element of the array as a suitable
               Python scalar
           Notes
           -----
           When the data type of `a` is longdouble or clongdouble, item() returns
           a scalar array object because there is no available Python scalar that
           would not lose information. Void arrays return a buffer object for item(),
           unless fields are defined, in which case a tuple is returned.
           `item` is very similar to a[args], except, instead of an array scalar,
           a standard Python scalar is returned. This can be useful for speeding up
           access to elements of the array and doing arithmetic on elements of the
           array using Python's optimized math.
           Examples
           --------
           >>> x = np.random.randint(9, size=(3, 3))
           >>> x
           array([[3, 1, 7],
                  [2, 8, 3],
                  [8, 5, 3]])
           >>> x.item(3)
           2
           >>> x.item(7)
           5
           >>> x.item((0, 1))
           1
           >>> x.item((2, 2))
           3
        """
        
        
        return Standard()
    def itemset(self,args):
        """a.itemset(*args)
           Insert scalar into an array (scalar is cast to array's dtype, if possible)
           There must be at least 1 argument, and define the last argument
           as *item*.  Then, ``a.itemset(*args)`` is equivalent to but faster
           than ``a[args] = item``.  The item should be a scalar value and `args`
           must select a single item in the array `a`.
           Parameters
           ----------
           \*args : Arguments
               If one argument: a scalar, only used in case `a` is of size 1.
               If two arguments: the last argument is the value to be set
               and must be a scalar, the first argument specifies a single array
               element location. It is either an int or a tuple.
           Notes
           -----
           Compared to indexing syntax, `itemset` provides some speed increase
           for placing a scalar into a particular location in an `ndarray`,
           if you must do this.  However, generally this is discouraged:
           among other problems, it complicates the appearance of the code.
           Also, when using `itemset` (and `item`) inside a loop, be sure
           to assign the methods to a local variable to avoid the attribute
           look-up at each loop iteration.
           Examples
           --------
           >>> x = np.random.randint(9, size=(3, 3))
           >>> x
           array([[3, 1, 7],
                  [2, 8, 3],
                  [8, 5, 3]])
           >>> x.itemset(4, 0)
           >>> x.itemset((2, 2), 9)
           >>> x
           array([[3, 1, 7],
                  [2, 0, 3],
                  [8, 5, 9]])
        """
        
        
        return None
    itemsize = None
    def join(self):
        """       Return a string which is the concatenation of the strings in the
               sequence `seq`.
               See also
               --------
               char.join
               
        """
        
        
        return None
    def ljust(self):
        """           Return an array with the elements of `self` left-justified in a
                   string of length `width`.
                   See also
                   --------
                   char.ljust
                   
        """
        
        
        return None
    def lower(self):
        """       Return an array with the elements of `self` converted to
               lowercase.
               See also
               --------
               char.lower
               
        """
        
        
        return None
    def lstrip(self):
        """       For each element in `self`, return a copy with the leading characters
               removed.
               See also
               --------
               char.lstrip
               
        """
        
        
        return None
    def max(self,axis=None,out=None):
        """a.max(axis=None, out=None)
           Return the maximum along a given axis.
           Refer to `numpy.amax` for full documentation.
           See Also
           --------
           numpy.amax : equivalent function
        """
        
        
        return None
    def mean(self,axis=None,dtype=None,out=None):
        """a.mean(axis=None, dtype=None, out=None)
           Returns the average of the array elements along given axis.
           Refer to `numpy.mean` for full documentation.
           See Also
           --------
           numpy.mean : equivalent function
        """
        
        
        return None
    def min(self,axis=None,out=None):
        """a.min(axis=None, out=None)
           Return the minimum along a given axis.
           Refer to `numpy.amin` for full documentation.
           See Also
           --------
           numpy.amin : equivalent function
        """
        
        
        return None
    nbytes = None
    ndim = None
    def newbyteorder(self,new_order):
        """arr.newbyteorder(new_order='S')
           Return the array with the same data viewed with a different byte order.
           Equivalent to::
               arr.view(arr.dtype.newbytorder(new_order))
           Changes are also made in all fields and sub-arrays of the array data
           type.
           Parameters
           ----------
           new_order : string, optional
               Byte order to force; a value from the byte order specifications
               above. `new_order` codes can be any of::
                * 'S' - swap dtype from current to opposite endian
                * {'<', 'L'} - little endian
                * {'>', 'B'} - big endian
                * {'=', 'N'} - native order
                * {'|', 'I'} - ignore (no change to byte order)
               The default value ('S') results in swapping the current
               byte order. The code does a case-insensitive check on the first
               letter of `new_order` for the alternatives above.  For example,
               any of 'B' or 'b' or 'biggish' are valid to specify big-endian.
           Returns
           -------
           new_arr : array
               New array object with the dtype reflecting given change to the
               byte order.
        """
        
        
        return array()
    def nonzero(self,):
        """a.nonzero()
           Return the indices of the elements that are non-zero.
           Refer to `numpy.nonzero` for full documentation.
           See Also
           --------
           numpy.nonzero : equivalent function
        """
        
        
        return None
    def partition(self):
        """           Partition each element in `self` around `sep`.
                   See also
                   --------
                   partition
                   
        """
        
        
        return None
    def prod(self,axis=None,dtype=None,out=None):
        """a.prod(axis=None, dtype=None, out=None)
           Return the product of the array elements over the given axis
           Refer to `numpy.prod` for full documentation.
           See Also
           --------
           numpy.prod : equivalent function
        """
        
        
        return None
    def ptp(self,axis=None,out=None):
        """a.ptp(axis=None, out=None)
           Peak to peak (maximum - minimum) value along a given axis.
           Refer to `numpy.ptp` for full documentation.
           See Also
           --------
           numpy.ptp : equivalent function
        """
        
        
        return None
    def put(self,indices,values,mode='raise'):
        """a.put(indices, values, mode='raise')
           Set ``a.flat[n] = values[n]`` for all `n` in indices.
           Refer to `numpy.put` for full documentation.
           See Also
           --------
           numpy.put : equivalent function
        """
        
        
        return None
    def ravel(self,order):
        """a.ravel([order])
           Return a flattened array.
           Refer to `numpy.ravel` for full documentation.
           See Also
           --------
           numpy.ravel : equivalent function
           ndarray.flat : a flat iterator on the array.
        """
        
        
        return None
    real = None
    def repeat(self,repeats,axis=None):
        """a.repeat(repeats, axis=None)
           Repeat elements of an array.
           Refer to `numpy.repeat` for full documentation.
           See Also
           --------
           numpy.repeat : equivalent function
        """
        
        
        return None
    def replace(self):
        """       For each element in `self`, return a copy of the string with all
               occurrences of substring `old` replaced by `new`.
               See also
               --------
               char.replace
               
        """
        
        
        return None
    def reshape(self,shape,order='C'):
        """a.reshape(shape, order='C')
           Returns an array containing the same data with a new shape.
           Refer to `numpy.reshape` for full documentation.
           See Also
           --------
           numpy.reshape : equivalent function
        """
        
        
        return None
    def resize(self,new_shape,refcheck):
        """a.resize(new_shape, refcheck=True)
           Change shape and size of array in-place.
           Parameters
           ----------
           new_shape : tuple of ints, or `n` ints
               Shape of resized array.
           refcheck : bool, optional
               If False, reference count will not be checked. Default is True.
           Returns
           -------
           None
           Raises
           ------
           ValueError
               If `a` does not own its own data or references or views to it exist,
               and the data memory must be changed.
           SystemError
               If the `order` keyword argument is specified. This behaviour is a
               bug in NumPy.
           See Also
           --------
           resize : Return a new array with the specified shape.
           Notes
           -----
           This reallocates space for the data area if necessary.
           Only contiguous arrays (data elements consecutive in memory) can be
           resized.
           The purpose of the reference count check is to make sure you
           do not use this array as a buffer for another Python object and then
           reallocate the memory. However, reference counts can increase in
           other ways so if you are sure that you have not shared the memory
           for this array with another Python object, then you may safely set
           `refcheck` to False.
           Examples
           --------
           Shrinking an array: array is flattened (in the order that the data are
           stored in memory), resized, and reshaped:
           >>> a = np.array([[0, 1], [2, 3]], order='C')
           >>> a.resize((2, 1))
           >>> a
           array([[0],
                  [1]])
           >>> a = np.array([[0, 1], [2, 3]], order='F')
           >>> a.resize((2, 1))
           >>> a
           array([[0],
                  [2]])
           Enlarging an array: as above, but missing entries are filled with zeros:
           >>> b = np.array([[0, 1], [2, 3]])
           >>> b.resize(2, 3) # new_shape parameter doesn't have to be a tuple
           >>> b
           array([[0, 1, 2],
                  [3, 0, 0]])
           Referencing an array prevents resizing...
           >>> c = a
           >>> a.resize((1, 1))
           Traceback (most recent call last):
           ...
           ValueError: cannot resize an array that has been referenced ...
           Unless `refcheck` is False:
           >>> a.resize((1, 1), refcheck=False)
           >>> a
           array([[0]])
           >>> c
           array([[0]])
        """
        
        
        return None
    def rfind(self):
        """       For each element in `self`, return the highest index in the string
               where substring `sub` is found, such that `sub` is contained
               within [`start`, `end`].
               See also
               --------
               char.rfind
               
        """
        
        
        return None
    def rindex(self):
        """       Like `rfind`, but raises `ValueError` when the substring `sub` is
               not found.
               See also
               --------
               char.rindex
               
        """
        
        
        return None
    def rjust(self):
        """           Return an array with the elements of `self`
                   right-justified in a string of length `width`.
                   See also
                   --------
                   char.rjust
                   
        """
        
        
        return None
    def round(self,decimals=0,out=None):
        """a.round(decimals=0, out=None)
           Return `a` with each element rounded to the given number of decimals.
           Refer to `numpy.around` for full documentation.
           See Also
           --------
           numpy.around : equivalent function
        """
        
        
        return None
    def rpartition(self):
        """           Partition each element in `self` around `sep`.
                   See also
                   --------
                   rpartition
                   
        """
        
        
        return None
    def rsplit(self):
        """           For each element in `self`, return a list of the words in
                   the string, using `sep` as the delimiter string.
                   See also
                   --------
                   char.rsplit
                   
        """
        
        
        return None
    def rstrip(self):
        """       For each element in `self`, return a copy with the trailing
               characters removed.
               See also
               --------
               char.rstrip
               
        """
        
        
        return None
    def searchsorted(self,v,side='left'):
        """a.searchsorted(v, side='left')
           Find indices where elements of v should be inserted in a to maintain order.
           For full documentation, see `numpy.searchsorted`
           See Also
           --------
           numpy.searchsorted : equivalent function
        """
        
        
        return None
    def setfield(self,val,dtype,offset):
        """a.setfield(val, dtype, offset=0)
           Put a value into a specified place in a field defined by a data-type.
           Place `val` into `a`'s field defined by `dtype` and beginning `offset`
           bytes into the field.
           Parameters
           ----------
           val : object
               Value to be placed in field.
           dtype : dtype object
               Data-type of the field in which to place `val`.
           offset : int, optional
               The number of bytes into the field at which to place `val`.
           Returns
           -------
           None
           See Also
           --------
           getfield
           Examples
           --------
           >>> x = np.eye(3)
           >>> x.getfield(np.float64)
           array([[ 1.,  0.,  0.],
                  [ 0.,  1.,  0.],
                  [ 0.,  0.,  1.]])
           >>> x.setfield(3, np.int32)
           >>> x.getfield(np.int32)
           array([[3, 3, 3],
                  [3, 3, 3],
                  [3, 3, 3]])
           >>> x
           array([[  1.00000000e+000,   1.48219694e-323,   1.48219694e-323],
                  [  1.48219694e-323,   1.00000000e+000,   1.48219694e-323],
                  [  1.48219694e-323,   1.48219694e-323,   1.00000000e+000]])
           >>> x.setfield(np.eye(3), np.int32)
           >>> x
           array([[ 1.,  0.,  0.],
                  [ 0.,  1.,  0.],
                  [ 0.,  0.,  1.]])
        """
        
        
        return None
    def setflags(self,write,align,uic):
        """a.setflags(write=None, align=None, uic=None)
           Set array flags WRITEABLE, ALIGNED, and UPDATEIFCOPY, respectively.
           These Boolean-valued flags affect how numpy interprets the memory
           area used by `a` (see Notes below). The ALIGNED flag can only
           be set to True if the data is actually aligned according to the type.
           The UPDATEIFCOPY flag can never be set to True. The flag WRITEABLE
           can only be set to True if the array owns its own memory, or the
           ultimate owner of the memory exposes a writeable buffer interface,
           or is a string. (The exception for string is made so that unpickling
           can be done without copying memory.)
           Parameters
           ----------
           write : bool, optional
               Describes whether or not `a` can be written to.
           align : bool, optional
               Describes whether or not `a` is aligned properly for its type.
           uic : bool, optional
               Describes whether or not `a` is a copy of another "base" array.
           Notes
           -----
           Array flags provide information about how the memory area used
           for the array is to be interpreted. There are 6 Boolean flags
           in use, only three of which can be changed by the user:
           UPDATEIFCOPY, WRITEABLE, and ALIGNED.
           WRITEABLE (W) the data area can be written to;
           ALIGNED (A) the data and strides are aligned appropriately for the hardware
           (as determined by the compiler);
           UPDATEIFCOPY (U) this array is a copy of some other array (referenced
           by .base). When this array is deallocated, the base array will be
           updated with the contents of this array.
           All flags can be accessed using their first (upper case) letter as well
           as the full name.
           Examples
           --------
           >>> y
           array([[3, 1, 7],
                  [2, 0, 0],
                  [8, 5, 9]])
           >>> y.flags
             C_CONTIGUOUS : True
             F_CONTIGUOUS : False
             OWNDATA : True
             WRITEABLE : True
             ALIGNED : True
             UPDATEIFCOPY : False
           >>> y.setflags(write=0, align=0)
           >>> y.flags
             C_CONTIGUOUS : True
             F_CONTIGUOUS : False
             OWNDATA : True
             WRITEABLE : False
             ALIGNED : False
             UPDATEIFCOPY : False
           >>> y.setflags(uic=1)
           Traceback (most recent call last):
             File "<stdin>", line 1, in <module>
           ValueError: cannot set UPDATEIFCOPY flag to True
        """
        
        
        return None
    shape = None
    size = None
    def sort(self,axis,kind,order):
        """a.sort(axis=-1, kind='quicksort', order=None)
           Sort an array, in-place.
           Parameters
           ----------
           axis : int, optional
               Axis along which to sort. Default is -1, which means sort along the
               last axis.
           kind : {'quicksort', 'mergesort', 'heapsort'}, optional
               Sorting algorithm. Default is 'quicksort'.
           order : list, optional
               When `a` is an array with fields defined, this argument specifies
               which fields to compare first, second, etc.  Not all fields need be
               specified.
           See Also
           --------
           numpy.sort : Return a sorted copy of an array.
           argsort : Indirect sort.
           lexsort : Indirect stable sort on multiple keys.
           searchsorted : Find elements in sorted array.
           Notes
           -----
           See ``sort`` for notes on the different sorting algorithms.
           Examples
           --------
           >>> a = np.array([[1,4], [3,1]])
           >>> a.sort(axis=1)
           >>> a
           array([[1, 4],
                  [1, 3]])
           >>> a.sort(axis=0)
           >>> a
           array([[1, 3],
                  [1, 4]])
           Use the `order` keyword to specify a field to use when sorting a
           structured array:
           >>> a = np.array([('a', 2), ('c', 1)], dtype=[('x', 'S1'), ('y', int)])
           >>> a.sort(order='y')
           >>> a
           array([('c', 1), ('a', 2)],
                 dtype=[('x', '|S1'), ('y', '<i4')])
        """
        
        
        return None
    def split(self):
        """       For each element in `self`, return a list of the words in the
               string, using `sep` as the delimiter string.
               See also
               --------
               char.split
               
        """
        
        
        return None
    def splitlines(self):
        """       For each element in `self`, return a list of the lines in the
               element, breaking at line boundaries.
               See also
               --------
               char.splitlines
               
        """
        
        
        return None
    def squeeze(self,):
        """a.squeeze()
           Remove single-dimensional entries from the shape of `a`.
           Refer to `numpy.squeeze` for full documentation.
           See Also
           --------
           numpy.squeeze : equivalent function
        """
        
        
        return None
    def startswith(self):
        """       Returns a boolean array which is `True` where the string element
               in `self` starts with `prefix`, otherwise `False`.
               See also
               --------
               char.startswith
               
        """
        
        
        return None
    def std(self,axis=None,dtype=None,out=None,ddof=0):
        """a.std(axis=None, dtype=None, out=None, ddof=0)
           Returns the standard deviation of the array elements along given axis.
           Refer to `numpy.std` for full documentation.
           See Also
           --------
           numpy.std : equivalent function
        """
        
        
        return None
    strides = None
    def strip(self):
        """       For each element in `self`, return a copy with the leading and
               trailing characters removed.
               See also
               --------
               char.strip
               
        """
        
        
        return None
    def sum(self,axis=None,dtype=None,out=None):
        """a.sum(axis=None, dtype=None, out=None)
           Return the sum of the array elements over the given axis.
           Refer to `numpy.sum` for full documentation.
           See Also
           --------
           numpy.sum : equivalent function
        """
        
        
        return None
    def swapaxes(self,axis1,axis2):
        """a.swapaxes(axis1, axis2)
           Return a view of the array with `axis1` and `axis2` interchanged.
           Refer to `numpy.swapaxes` for full documentation.
           See Also
           --------
           numpy.swapaxes : equivalent function
        """
        
        
        return None
    def swapcase(self):
        """       For each element in `self`, return a copy of the string with
               uppercase characters converted to lowercase and vice versa.
               See also
               --------
               char.swapcase
               
        """
        
        
        return None
    def take(self,indices,axis=None,out=None,mode='raise'):
        """a.take(indices, axis=None, out=None, mode='raise')
           Return an array formed from the elements of `a` at the given indices.
           Refer to `numpy.take` for full documentation.
           See Also
           --------
           numpy.take : equivalent function
        """
        
        
        return None
    def title(self):
        """       For each element in `self`, return a titlecased version of the
               string: words start with uppercase characters, all remaining cased
               characters are lowercase.
               See also
               --------
               char.title
               
        """
        
        
        return None
    def tofile(self,fid,sep,format):
        """a.tofile(fid, sep="", format="%s")
           Write array to a file as text or binary (default).
           Data is always written in 'C' order, independent of the order of `a`.
           The data produced by this method can be recovered using the function
           fromfile().
           Parameters
           ----------
           fid : file or str
               An open file object, or a string containing a filename.
           sep : str
               Separator between array items for text output.
               If "" (empty), a binary file is written, equivalent to
               ``file.write(a.tostring())``.
           format : str
               Format string for text file output.
               Each entry in the array is formatted to text by first converting
               it to the closest Python type, and then using "format" % item.
           Notes
           -----
           This is a convenience function for quick storage of array data.
           Information on endianness and precision is lost, so this method is not a
           good choice for files intended to archive data or transport data between
           machines with different endianness. Some of these problems can be overcome
           by outputting the data as text files, at the expense of speed and file
           size.
        """
        
        
        return None
    def tolist(self):
        """a.tolist()
           Return the array as a (possibly nested) list.
           Return a copy of the array data as a (nested) Python list.
           Data items are converted to the nearest compatible Python type.
           Parameters
           ----------
           none
           Returns
           -------
           y : list
               The possibly nested list of array elements.
           Notes
           -----
           The array may be recreated, ``a = np.array(a.tolist())``.
           Examples
           --------
           >>> a = np.array([1, 2])
           >>> a.tolist()
           [1, 2]
           >>> a = np.array([[1, 2], [3, 4]])
           >>> list(a)
           [array([1, 2]), array([3, 4])]
           >>> a.tolist()
           [[1, 2], [3, 4]]
        """
        
        
        return list()
    def tostring(self,order):
        """a.tostring(order='C')
           Construct a Python string containing the raw data bytes in the array.
           Constructs a Python string showing a copy of the raw contents of
           data memory. The string can be produced in either 'C' or 'Fortran',
           or 'Any' order (the default is 'C'-order). 'Any' order means C-order
           unless the F_CONTIGUOUS flag in the array is set, in which case it
           means 'Fortran' order.
           Parameters
           ----------
           order : {'C', 'F', None}, optional
               Order of the data for multidimensional arrays:
               C, Fortran, or the same as for the original array.
           Returns
           -------
           s : str
               A Python string exhibiting a copy of `a`'s raw data.
           Examples
           --------
           >>> x = np.array([[0, 1], [2, 3]])
           >>> x.tostring()
           '\x00\x00\x00\x00\x01\x00\x00\x00\x02\x00\x00\x00\x03\x00\x00\x00'
           >>> x.tostring('C') == x.tostring()
           True
           >>> x.tostring('F')
           '\x00\x00\x00\x00\x02\x00\x00\x00\x01\x00\x00\x00\x03\x00\x00\x00'
        """
        
        
        return str()
    def trace(self,offset=0,axis1=0,axis2=1,dtype=None,out=None):
        """a.trace(offset=0, axis1=0, axis2=1, dtype=None, out=None)
           Return the sum along diagonals of the array.
           Refer to `numpy.trace` for full documentation.
           See Also
           --------
           numpy.trace : equivalent function
        """
        
        
        return None
    def translate(self):
        """       For each element in `self`, return a copy of the string where
               all characters occurring in the optional argument
               `deletechars` are removed, and the remaining characters have
               been mapped through the given translation table.
               See also
               --------
               char.translate
               
        """
        
        
        return None
    def transpose(self,axes):
        """a.transpose(*axes)
           Returns a view of the array with axes transposed.
           For a 1-D array, this has no effect. (To change between column and
           row vectors, first cast the 1-D array into a matrix object.)
           For a 2-D array, this is the usual matrix transpose.
           For an n-D array, if axes are given, their order indicates how the
           axes are permuted (see Examples). If axes are not provided and
           ``a.shape = (i[0], i[1], ... i[n-2], i[n-1])``, then
           ``a.transpose().shape = (i[n-1], i[n-2], ... i[1], i[0])``.
           Parameters
           ----------
           axes : None, tuple of ints, or `n` ints
            * None or no argument: reverses the order of the axes.
            * tuple of ints: `i` in the `j`-th place in the tuple means `a`'s
              `i`-th axis becomes `a.transpose()`'s `j`-th axis.
            * `n` ints: same as an n-tuple of the same ints (this form is
              intended simply as a "convenience" alternative to the tuple form)
           Returns
           -------
           out : ndarray
               View of `a`, with axes suitably permuted.
           See Also
           --------
           ndarray.T : Array property returning the array transposed.
           Examples
           --------
           >>> a = np.array([[1, 2], [3, 4]])
           >>> a
           array([[1, 2],
                  [3, 4]])
           >>> a.transpose()
           array([[1, 3],
                  [2, 4]])
           >>> a.transpose((1, 0))
           array([[1, 3],
                  [2, 4]])
           >>> a.transpose(1, 0)
           array([[1, 3],
                  [2, 4]])
        """
        
        
        return ndarray()
    def upper(self):
        """       Return an array with the elements of `self` converted to
               uppercase.
               See also
               --------
               char.upper
               
        """
        
        
        return None
    def var(self,axis=None,dtype=None,out=None,ddof=0):
        """a.var(axis=None, dtype=None, out=None, ddof=0)
           Returns the variance of the array elements, along given axis.
           Refer to `numpy.var` for full documentation.
           See Also
           --------
           numpy.var : equivalent function
        """
        
        
        return None
    def view(self,dtype,type):
        """a.view(dtype=None, type=None)
           New view of array with the same data.
           Parameters
           ----------
           dtype : data-type, optional
               Data-type descriptor of the returned view, e.g., float32 or int16.
               The default, None, results in the view having the same data-type
               as `a`.
           type : Python type, optional
               Type of the returned view, e.g., ndarray or matrix.  Again, the
               default None results in type preservation.
           Notes
           -----
           ``a.view()`` is used two different ways:
           ``a.view(some_dtype)`` or ``a.view(dtype=some_dtype)`` constructs a view
           of the array's memory with a different data-type.  This can cause a
           reinterpretation of the bytes of memory.
           ``a.view(ndarray_subclass)`` or ``a.view(type=ndarray_subclass)`` just
           returns an instance of `ndarray_subclass` that looks at the same array
           (same shape, dtype, etc.)  This does not cause a reinterpretation of the
           memory.
           Examples
           --------
           >>> x = np.array([(1, 2)], dtype=[('a', np.int8), ('b', np.int8)])
           Viewing array data using a different type and dtype:
           >>> y = x.view(dtype=np.int16, type=np.matrix)
           >>> y
           matrix([[513]], dtype=int16)
           >>> print type(y)
           <class 'numpy.matrixlib.defmatrix.matrix'>
           Creating a view on a structured array so it can be used in calculations
           >>> x = np.array([(1, 2),(3,4)], dtype=[('a', np.int8), ('b', np.int8)])
           >>> xv = x.view(dtype=np.int8).reshape(-1,2)
           >>> xv
           array([[1, 2],
                  [3, 4]], dtype=int8)
           >>> xv.mean(0)
           array([ 2.,  3.])
           Making changes to the view changes the underlying array
           >>> xv[0,1] = 20
           >>> print x
           [(1, 20) (3, 4)]
           Using a view to convert an array to a record array:
           >>> z = x.view(np.recarray)
           >>> z.a
           array([1], dtype=int8)
           Views share data:
           >>> x[0] = (9, 10)
           >>> z[0]
           (9, 10)
        """
        
        
        return None
    def zfill(self):
        """       Return the numeric string left-filled with zeros in a string of
               length `width`.
               See also
               --------
               char.zfill
               
        """
        
        
        return None
    

def choose(a,choices,out,mode):
    """   Construct an array from an index array and a set of arrays to choose from.
       First of all, if confused or uncertain, definitely look at the Examples -
       in its full generality, this function is less simple than it might
       seem from the following code description (below ndi =
       `numpy.lib.index_tricks`):
       ``np.choose(a,c) == np.array([c[a[I]][I] for I in ndi.ndindex(a.shape)])``.
       But this omits some subtleties.  Here is a fully general summary:
       Given an "index" array (`a`) of integers and a sequence of `n` arrays
       (`choices`), `a` and each choice array are first broadcast, as necessary,
       to arrays of a common shape; calling these *Ba* and *Bchoices[i], i =
       0,...,n-1* we have that, necessarily, ``Ba.shape == Bchoices[i].shape``
       for each `i`.  Then, a new array with shape ``Ba.shape`` is created as
       follows:
       * if ``mode=raise`` (the default), then, first of all, each element of
         `a` (and thus `Ba`) must be in the range `[0, n-1]`; now, suppose that
         `i` (in that range) is the value at the `(j0, j1, ..., jm)` position
         in `Ba` - then the value at the same position in the new array is the
         value in `Bchoices[i]` at that same position;
       * if ``mode=wrap``, values in `a` (and thus `Ba`) may be any (signed)
         integer; modular arithmetic is used to map integers outside the range
         `[0, n-1]` back into that range; and then the new array is constructed
         as above;
       * if ``mode=clip``, values in `a` (and thus `Ba`) may be any (signed)
         integer; negative integers are mapped to 0; values greater than `n-1`
         are mapped to `n-1`; and then the new array is constructed as above.
       Parameters
       ----------
       a : int array
           This array must contain integers in `[0, n-1]`, where `n` is the number
           of choices, unless ``mode=wrap`` or ``mode=clip``, in which cases any
           integers are permissible.
       choices : sequence of arrays
           Choice arrays. `a` and all of the choices must be broadcastable to the
           same shape.  If `choices` is itself an array (not recommended), then
           its outermost dimension (i.e., the one corresponding to
           ``choices.shape[0]``) is taken as defining the "sequence".
       out : array, optional
           If provided, the result will be inserted into this array. It should
           be of the appropriate shape and dtype.
       mode : {'raise' (default), 'wrap', 'clip'}, optional
           Specifies how indices outside `[0, n-1]` will be treated:
             * 'raise' : an exception is raised
             * 'wrap' : value becomes value mod `n`
             * 'clip' : values < 0 are mapped to 0, values > n-1 are mapped to n-1
       Returns
       -------
       merged_array : array
           The merged result.
       Raises
       ------
       ValueError: shape mismatch
           If `a` and each choice array are not all broadcastable to the same
           shape.
       See Also
       --------
       ndarray.choose : equivalent method
       Notes
       -----
       To reduce the chance of misinterpretation, even though the following
       "abuse" is nominally supported, `choices` should neither be, nor be
       thought of as, a single array, i.e., the outermost sequence-like container
       should be either a list or a tuple.
       Examples
       --------
       >>> choices = [[0, 1, 2, 3], [10, 11, 12, 13],
       ...   [20, 21, 22, 23], [30, 31, 32, 33]]
       >>> np.choose([2, 3, 1, 0], choices
       ... # the first element of the result will be the first element of the
       ... # third (2+1) "array" in choices, namely, 20; the second element
       ... # will be the second element of the fourth (3+1) choice array, i.e.,
       ... # 31, etc.
       ... )
       array([20, 31, 12,  3])
       >>> np.choose([2, 4, 1, 0], choices, mode='clip') # 4 goes to 3 (4-1)
       array([20, 31, 12,  3])
       >>> # because there are 4 choice arrays
       >>> np.choose([2, 4, 1, 0], choices, mode='wrap') # 4 goes to (4 mod 4)
       array([20,  1, 12,  3])
       >>> # i.e., 0
       A couple examples illustrating how choose broadcasts:
       >>> a = [[1, 0, 1], [0, 1, 0], [1, 0, 1]]
       >>> choices = [-10, 10]
       >>> np.choose(a, choices)
       array([[ 10, -10,  10],
              [-10,  10, -10],
              [ 10, -10,  10]])
       >>> # With thanks to Anne Archibald
       >>> a = np.array([0, 1]).reshape((2,1,1))
       >>> c1 = np.array([1, 2, 3]).reshape((1,3,1))
       >>> c2 = np.array([-1, -2, -3, -4, -5]).reshape((1,1,5))
       >>> np.choose(a, (c1, c2)) # result is 2x3x5, res[0,:,:]=c1, res[1,:,:]=c2
       array([[[ 1,  1,  1,  1,  1],
               [ 2,  2,  2,  2,  2],
               [ 3,  3,  3,  3,  3]],
              [[-1, -2, -3, -4, -5],
               [-1, -2, -3, -4, -5],
               [-1, -2, -3, -4, -5]]])
       
    """
    
    
    return array()
def clip(a,a_min,a_max,out):
    """   Clip (limit) the values in an array.
       Given an interval, values outside the interval are clipped to
       the interval edges.  For example, if an interval of ``[0, 1]``
       is specified, values smaller than 0 become 0, and values larger
       than 1 become 1.
       Parameters
       ----------
       a : array_like
           Array containing elements to clip.
       a_min : scalar or array_like
           Minimum value.
       a_max : scalar or array_like
           Maximum value.  If `a_min` or `a_max` are array_like, then they will
           be broadcasted to the shape of `a`.
       out : ndarray, optional
           The results will be placed in this array. It may be the input
           array for in-place clipping.  `out` must be of the right shape
           to hold the output.  Its type is preserved.
       Returns
       -------
       clipped_array : ndarray
           An array with the elements of `a`, but where values
           < `a_min` are replaced with `a_min`, and those > `a_max`
           with `a_max`.
       See Also
       --------
       numpy.doc.ufuncs : Section "Output arguments"
       Examples
       --------
       >>> a = np.arange(10)
       >>> np.clip(a, 1, 8)
       array([1, 1, 2, 3, 4, 5, 6, 7, 8, 8])
       >>> a
       array([0, 1, 2, 3, 4, 5, 6, 7, 8, 9])
       >>> np.clip(a, 3, 6, out=a)
       array([3, 3, 3, 3, 4, 5, 6, 6, 6, 6])
       >>> a = np.arange(10)
       >>> a
       array([0, 1, 2, 3, 4, 5, 6, 7, 8, 9])
       >>> np.clip(a, [3,4,1,1,1,4,4,4,4,4], 8)
       array([3, 4, 2, 3, 4, 5, 6, 7, 8, 8])
       
    """
    
    
    return ndarray()
class clongdouble:
    T = None
    def all(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def any(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmax(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmin(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argsort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def astype(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    base = None
    def byteswap(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def choose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def clip(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def compress(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def conj(self):
        """None"""
        
        
        return None
    def conjugate(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def copy(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumprod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumsum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    data = None
    def diagonal(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    dtype = None
    def dump(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def dumps(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def fill(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    flags = None
    flat = None
    def flatten(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def getfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    imag = None
    def item(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def itemset(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    itemsize = None
    def max(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def mean(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def min(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    nbytes = None
    ndim = None
    def newbyteorder(self,new_order):
        """newbyteorder(new_order='S')
           Return a new `dtype` with a different byte order.
           Changes are also made in all fields and sub-arrays of the data type.
           The `new_order` code can be any from the following:
           * {'<', 'L'} - little endian
           * {'>', 'B'} - big endian
           * {'=', 'N'} - native order
           * 'S' - swap dtype from current to opposite endian
           * {'|', 'I'} - ignore (no change to byte order)
           Parameters
           ----------
           new_order : str, optional
               Byte order to force; a value from the byte order specifications
               above.  The default value ('S') results in swapping the current
               byte order. The code does a case-insensitive check on the first
               letter of `new_order` for the alternatives above.  For example,
               any of 'B' or 'b' or 'biggish' are valid to specify big-endian.
           Returns
           -------
           new_dtype : dtype
               New `dtype` object with the given change to the byte order.
        """
        
        
        return dtype()
    def nonzero(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def prod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ptp(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def put(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ravel(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    real = None
    def repeat(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def reshape(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def resize(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def round(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def searchsorted(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setflags(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    shape = None
    size = None
    def sort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def squeeze(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def std(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    strides = None
    def sum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def swapaxes(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def take(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tofile(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tolist(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tostring(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def trace(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def transpose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def var(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def view(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    

class clongfloat:
    T = None
    def all(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def any(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmax(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmin(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argsort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def astype(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    base = None
    def byteswap(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def choose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def clip(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def compress(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def conj(self):
        """None"""
        
        
        return None
    def conjugate(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def copy(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumprod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumsum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    data = None
    def diagonal(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    dtype = None
    def dump(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def dumps(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def fill(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    flags = None
    flat = None
    def flatten(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def getfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    imag = None
    def item(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def itemset(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    itemsize = None
    def max(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def mean(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def min(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    nbytes = None
    ndim = None
    def newbyteorder(self,new_order):
        """newbyteorder(new_order='S')
           Return a new `dtype` with a different byte order.
           Changes are also made in all fields and sub-arrays of the data type.
           The `new_order` code can be any from the following:
           * {'<', 'L'} - little endian
           * {'>', 'B'} - big endian
           * {'=', 'N'} - native order
           * 'S' - swap dtype from current to opposite endian
           * {'|', 'I'} - ignore (no change to byte order)
           Parameters
           ----------
           new_order : str, optional
               Byte order to force; a value from the byte order specifications
               above.  The default value ('S') results in swapping the current
               byte order. The code does a case-insensitive check on the first
               letter of `new_order` for the alternatives above.  For example,
               any of 'B' or 'b' or 'biggish' are valid to specify big-endian.
           Returns
           -------
           new_dtype : dtype
               New `dtype` object with the given change to the byte order.
        """
        
        
        return dtype()
    def nonzero(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def prod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ptp(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def put(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ravel(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    real = None
    def repeat(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def reshape(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def resize(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def round(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def searchsorted(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setflags(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    shape = None
    size = None
    def sort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def squeeze(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def std(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    strides = None
    def sum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def swapaxes(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def take(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tofile(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tolist(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tostring(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def trace(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def transpose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def var(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def view(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    

def column_stack(tup):
    """   Stack 1-D arrays as columns into a 2-D array.
       Take a sequence of 1-D arrays and stack them as columns
       to make a single 2-D array. 2-D arrays are stacked as-is,
       just like with `hstack`.  1-D arrays are turned into 2-D columns
       first.
       Parameters
       ----------
       tup : sequence of 1-D or 2-D arrays.
           Arrays to stack. All of them must have the same first dimension.
       Returns
       -------
       stacked : 2-D array
           The array formed by stacking the given arrays.
       See Also
       --------
       hstack, vstack, concatenate
       Notes
       -----
       This function is equivalent to ``np.vstack(tup).T``.
       Examples
       --------
       >>> a = np.array((1,2,3))
       >>> b = np.array((2,3,4))
       >>> np.column_stack((a,b))
       array([[1, 2],
              [2, 3],
              [3, 4]])
       
    """
    
    
    return _2_D()
def common_type(array1,array2,___):
    """   Return a scalar type which is common to the input arrays.
       The return type will always be an inexact (i.e. floating point) scalar
       type, even if all the arrays are integer arrays. If one of the inputs is
       an integer array, the minimum precision type that is returned is a
       64-bit floating point dtype.
       All input arrays can be safely cast to the returned dtype without loss
       of information.
       Parameters
       ----------
       array1, array2, ... : ndarrays
           Input arrays.
       Returns
       -------
       out : data type code
           Data type code.
       See Also
       --------
       dtype, mintypecode
       Examples
       --------
       >>> np.common_type(np.arange(2, dtype=np.float32))
       <type 'numpy.float32'>
       >>> np.common_type(np.arange(2, dtype=np.float32), np.arange(2))
       <type 'numpy.float64'>
       >>> np.common_type(np.arange(4), np.array([45, 6.j]), np.array([45.0]))
       <type 'numpy.complex128'>
       
    """
    
    
    return data()
def compare_chararrays():
    """None"""
    
    
    return None
compat = None
class complex:
    def conjugate(self,):
        """complex.conjugate() -> complex
        Returns the complex conjugate of its argument. (3-4j).conjugate() == 3+4j.
        """
        
        
        return None
    imag = None
    real = None
    

class complex128:
    T = None
    def all(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def any(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmax(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmin(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argsort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def astype(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    base = None
    def byteswap(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def choose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def clip(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def compress(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def conj(self):
        """None"""
        
        
        return None
    def conjugate(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def copy(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumprod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumsum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    data = None
    def diagonal(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    dtype = None
    def dump(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def dumps(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def fill(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    flags = None
    flat = None
    def flatten(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def getfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    imag = None
    def item(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def itemset(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    itemsize = None
    def max(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def mean(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def min(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    nbytes = None
    ndim = None
    def newbyteorder(self,new_order):
        """newbyteorder(new_order='S')
           Return a new `dtype` with a different byte order.
           Changes are also made in all fields and sub-arrays of the data type.
           The `new_order` code can be any from the following:
           * {'<', 'L'} - little endian
           * {'>', 'B'} - big endian
           * {'=', 'N'} - native order
           * 'S' - swap dtype from current to opposite endian
           * {'|', 'I'} - ignore (no change to byte order)
           Parameters
           ----------
           new_order : str, optional
               Byte order to force; a value from the byte order specifications
               above.  The default value ('S') results in swapping the current
               byte order. The code does a case-insensitive check on the first
               letter of `new_order` for the alternatives above.  For example,
               any of 'B' or 'b' or 'biggish' are valid to specify big-endian.
           Returns
           -------
           new_dtype : dtype
               New `dtype` object with the given change to the byte order.
        """
        
        
        return dtype()
    def nonzero(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def prod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ptp(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def put(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ravel(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    real = None
    def repeat(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def reshape(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def resize(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def round(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def searchsorted(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setflags(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    shape = None
    size = None
    def sort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def squeeze(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def std(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    strides = None
    def sum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def swapaxes(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def take(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tofile(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tolist(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tostring(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def trace(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def transpose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def var(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def view(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    

class complex192:
    T = None
    def all(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def any(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmax(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmin(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argsort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def astype(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    base = None
    def byteswap(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def choose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def clip(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def compress(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def conj(self):
        """None"""
        
        
        return None
    def conjugate(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def copy(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumprod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumsum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    data = None
    def diagonal(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    dtype = None
    def dump(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def dumps(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def fill(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    flags = None
    flat = None
    def flatten(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def getfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    imag = None
    def item(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def itemset(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    itemsize = None
    def max(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def mean(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def min(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    nbytes = None
    ndim = None
    def newbyteorder(self,new_order):
        """newbyteorder(new_order='S')
           Return a new `dtype` with a different byte order.
           Changes are also made in all fields and sub-arrays of the data type.
           The `new_order` code can be any from the following:
           * {'<', 'L'} - little endian
           * {'>', 'B'} - big endian
           * {'=', 'N'} - native order
           * 'S' - swap dtype from current to opposite endian
           * {'|', 'I'} - ignore (no change to byte order)
           Parameters
           ----------
           new_order : str, optional
               Byte order to force; a value from the byte order specifications
               above.  The default value ('S') results in swapping the current
               byte order. The code does a case-insensitive check on the first
               letter of `new_order` for the alternatives above.  For example,
               any of 'B' or 'b' or 'biggish' are valid to specify big-endian.
           Returns
           -------
           new_dtype : dtype
               New `dtype` object with the given change to the byte order.
        """
        
        
        return dtype()
    def nonzero(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def prod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ptp(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def put(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ravel(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    real = None
    def repeat(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def reshape(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def resize(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def round(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def searchsorted(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setflags(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    shape = None
    size = None
    def sort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def squeeze(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def std(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    strides = None
    def sum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def swapaxes(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def take(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tofile(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tolist(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tostring(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def trace(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def transpose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def var(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def view(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    

class complex64:
    T = None
    def all(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def any(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmax(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmin(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argsort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def astype(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    base = None
    def byteswap(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def choose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def clip(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def compress(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def conj(self):
        """None"""
        
        
        return None
    def conjugate(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def copy(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumprod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumsum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    data = None
    def diagonal(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    dtype = None
    def dump(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def dumps(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def fill(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    flags = None
    flat = None
    def flatten(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def getfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    imag = None
    def item(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def itemset(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    itemsize = None
    def max(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def mean(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def min(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    nbytes = None
    ndim = None
    def newbyteorder(self,new_order):
        """newbyteorder(new_order='S')
           Return a new `dtype` with a different byte order.
           Changes are also made in all fields and sub-arrays of the data type.
           The `new_order` code can be any from the following:
           * {'<', 'L'} - little endian
           * {'>', 'B'} - big endian
           * {'=', 'N'} - native order
           * 'S' - swap dtype from current to opposite endian
           * {'|', 'I'} - ignore (no change to byte order)
           Parameters
           ----------
           new_order : str, optional
               Byte order to force; a value from the byte order specifications
               above.  The default value ('S') results in swapping the current
               byte order. The code does a case-insensitive check on the first
               letter of `new_order` for the alternatives above.  For example,
               any of 'B' or 'b' or 'biggish' are valid to specify big-endian.
           Returns
           -------
           new_dtype : dtype
               New `dtype` object with the given change to the byte order.
        """
        
        
        return dtype()
    def nonzero(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def prod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ptp(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def put(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ravel(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    real = None
    def repeat(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def reshape(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def resize(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def round(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def searchsorted(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setflags(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    shape = None
    size = None
    def sort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def squeeze(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def std(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    strides = None
    def sum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def swapaxes(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def take(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tofile(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tolist(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tostring(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def trace(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def transpose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def var(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def view(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    

class complex_:
    T = None
    def all(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def any(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmax(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmin(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argsort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def astype(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    base = None
    def byteswap(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def choose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def clip(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def compress(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def conj(self):
        """None"""
        
        
        return None
    def conjugate(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def copy(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumprod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumsum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    data = None
    def diagonal(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    dtype = None
    def dump(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def dumps(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def fill(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    flags = None
    flat = None
    def flatten(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def getfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    imag = None
    def item(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def itemset(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    itemsize = None
    def max(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def mean(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def min(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    nbytes = None
    ndim = None
    def newbyteorder(self,new_order):
        """newbyteorder(new_order='S')
           Return a new `dtype` with a different byte order.
           Changes are also made in all fields and sub-arrays of the data type.
           The `new_order` code can be any from the following:
           * {'<', 'L'} - little endian
           * {'>', 'B'} - big endian
           * {'=', 'N'} - native order
           * 'S' - swap dtype from current to opposite endian
           * {'|', 'I'} - ignore (no change to byte order)
           Parameters
           ----------
           new_order : str, optional
               Byte order to force; a value from the byte order specifications
               above.  The default value ('S') results in swapping the current
               byte order. The code does a case-insensitive check on the first
               letter of `new_order` for the alternatives above.  For example,
               any of 'B' or 'b' or 'biggish' are valid to specify big-endian.
           Returns
           -------
           new_dtype : dtype
               New `dtype` object with the given change to the byte order.
        """
        
        
        return dtype()
    def nonzero(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def prod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ptp(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def put(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ravel(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    real = None
    def repeat(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def reshape(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def resize(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def round(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def searchsorted(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setflags(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    shape = None
    size = None
    def sort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def squeeze(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def std(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    strides = None
    def sum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def swapaxes(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def take(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tofile(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tolist(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tostring(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def trace(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def transpose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def var(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def view(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    

class complexfloating:
    T = None
    def all(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def any(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmax(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmin(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argsort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def astype(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    base = None
    def byteswap(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def choose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def clip(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def compress(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def conj(self):
        """None"""
        
        
        return None
    def conjugate(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def copy(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumprod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumsum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    data = None
    def diagonal(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    dtype = None
    def dump(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def dumps(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def fill(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    flags = None
    flat = None
    def flatten(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def getfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    imag = None
    def item(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def itemset(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    itemsize = None
    def max(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def mean(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def min(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    nbytes = None
    ndim = None
    def newbyteorder(self,new_order):
        """newbyteorder(new_order='S')
           Return a new `dtype` with a different byte order.
           Changes are also made in all fields and sub-arrays of the data type.
           The `new_order` code can be any from the following:
           * {'<', 'L'} - little endian
           * {'>', 'B'} - big endian
           * {'=', 'N'} - native order
           * 'S' - swap dtype from current to opposite endian
           * {'|', 'I'} - ignore (no change to byte order)
           Parameters
           ----------
           new_order : str, optional
               Byte order to force; a value from the byte order specifications
               above.  The default value ('S') results in swapping the current
               byte order. The code does a case-insensitive check on the first
               letter of `new_order` for the alternatives above.  For example,
               any of 'B' or 'b' or 'biggish' are valid to specify big-endian.
           Returns
           -------
           new_dtype : dtype
               New `dtype` object with the given change to the byte order.
        """
        
        
        return dtype()
    def nonzero(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def prod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ptp(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def put(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ravel(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    real = None
    def repeat(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def reshape(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def resize(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def round(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def searchsorted(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setflags(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    shape = None
    size = None
    def sort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def squeeze(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def std(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    strides = None
    def sum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def swapaxes(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def take(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tofile(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tolist(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tostring(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def trace(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def transpose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def var(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def view(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    

def compress(condition,a,axis,out):
    """   Return selected slices of an array along given axis.
       When working along a given axis, a slice along that axis is returned in
       `output` for each index where `condition` evaluates to True. When
       working on a 1-D array, `compress` is equivalent to `extract`.
       Parameters
       ----------
       condition : 1-D array of bools
           Array that selects which entries to return. If len(condition)
           is less than the size of `a` along the given axis, then output is
           truncated to the length of the condition array.
       a : array_like
           Array from which to extract a part.
       axis : int, optional
           Axis along which to take slices. If None (default), work on the
           flattened array.
       out : ndarray, optional
           Output array.  Its type is preserved and it must be of the right
           shape to hold the output.
       Returns
       -------
       compressed_array : ndarray
           A copy of `a` without the slices along axis for which `condition`
           is false.
       See Also
       --------
       take, choose, diag, diagonal, select
       ndarray.compress : Equivalent method.
       numpy.doc.ufuncs : Section "Output arguments"
       Examples
       --------
       >>> a = np.array([[1, 2], [3, 4], [5, 6]])
       >>> a
       array([[1, 2],
              [3, 4],
              [5, 6]])
       >>> np.compress([0, 1], a, axis=0)
       array([[3, 4]])
       >>> np.compress([False, True, True], a, axis=0)
       array([[3, 4],
              [5, 6]])
       >>> np.compress([False, True], a, axis=1)
       array([[2],
              [4],
              [6]])
       Working on the flattened array does not return slices along an axis but
       selects elements.
       >>> np.compress([False, True], a)
       array([2])
       
    """
    
    
    return ndarray()
def concatenate(a1,a2,___,axis):
    """concatenate((a1, a2, ...), axis=0)
       Join a sequence of arrays together.
       Parameters
       ----------
       a1, a2, ... : sequence of array_like
           The arrays must have the same shape, except in the dimension
           corresponding to `axis` (the first, by default).
       axis : int, optional
           The axis along which the arrays will be joined.  Default is 0.
       Returns
       -------
       res : ndarray
           The concatenated array.
       See Also
       --------
       ma.concatenate : Concatenate function that preserves input masks.
       array_split : Split an array into multiple sub-arrays of equal or
                     near-equal size.
       split : Split array into a list of multiple sub-arrays of equal size.
       hsplit : Split array into multiple sub-arrays horizontally (column wise)
       vsplit : Split array into multiple sub-arrays vertically (row wise)
       dsplit : Split array into multiple sub-arrays along the 3rd axis (depth).
       hstack : Stack arrays in sequence horizontally (column wise)
       vstack : Stack arrays in sequence vertically (row wise)
       dstack : Stack arrays in sequence depth wise (along third dimension)
       Notes
       -----
       When one or more of the arrays to be concatenated is a MaskedArray,
       this function will return a MaskedArray object instead of an ndarray,
       but the input masks are *not* preserved. In cases where a MaskedArray
       is expected as input, use the ma.concatenate function from the masked
       array module instead.
       Examples
       --------
       >>> a = np.array([[1, 2], [3, 4]])
       >>> b = np.array([[5, 6]])
       >>> np.concatenate((a, b), axis=0)
       array([[1, 2],
              [3, 4],
              [5, 6]])
       >>> np.concatenate((a, b.T), axis=1)
       array([[1, 2, 5],
              [3, 4, 6]])
       This function will not preserve masking of MaskedArray inputs.
       >>> a = np.ma.arange(3)
       >>> a[1] = np.ma.masked
       >>> b = np.arange(2, 5)
       >>> a
       masked_array(data = [0 -- 2],
                    mask = [False  True False],
              fill_value = 999999)
       >>> b
       array([2, 3, 4])
       >>> np.concatenate([a, b])
       masked_array(data = [0 1 2 2 3 4],
                    mask = False,
              fill_value = 999999)
       >>> np.ma.concatenate([a, b])
       masked_array(data = [0 -- 2 2 3 4],
                    mask = [False  True False False False False],
              fill_value = 999999)
    """
    
    
    return ndarray()
def conj(x):
    """conjugate(x[, out])
    Return the complex conjugate, element-wise.
    The complex conjugate of a complex number is obtained by changing the
    sign of its imaginary part.
    Parameters
    ----------
    x : array_like
       Input value.
    Returns
    -------
    y : ndarray
       The complex conjugate of `x`, with same dtype as `y`.
    Examples
    --------
    >>> np.conjugate(1+2j)
    (1-2j)
    >>> x = np.eye(2) + 1j * np.eye(2)
    >>> np.conjugate(x)
    array([[ 1.-1.j,  0.-0.j],
          [ 0.-0.j,  1.-1.j]])
    """
    
    
    return ndarray()
def conjugate(x):
    """conjugate(x[, out])
    Return the complex conjugate, element-wise.
    The complex conjugate of a complex number is obtained by changing the
    sign of its imaginary part.
    Parameters
    ----------
    x : array_like
       Input value.
    Returns
    -------
    y : ndarray
       The complex conjugate of `x`, with same dtype as `y`.
    Examples
    --------
    >>> np.conjugate(1+2j)
    (1-2j)
    >>> x = np.eye(2) + 1j * np.eye(2)
    >>> np.conjugate(x)
    array([[ 1.-1.j,  0.-0.j],
          [ 0.-0.j,  1.-1.j]])
    """
    
    
    return ndarray()
def convolve(a,v,mode):
    """   Returns the discrete, linear convolution of two one-dimensional sequences.
       The convolution operator is often seen in signal processing, where it
       models the effect of a linear time-invariant system on a signal [1]_.  In
       probability theory, the sum of two independent random variables is
       distributed according to the convolution of their individual
       distributions.
       Parameters
       ----------
       a : (N,) array_like
           First one-dimensional input array.
       v : (M,) array_like
           Second one-dimensional input array.
       mode : {'full', 'valid', 'same'}, optional
           'full':
             By default, mode is 'full'.  This returns the convolution
             at each point of overlap, with an output shape of (N+M-1,). At
             the end-points of the convolution, the signals do not overlap
             completely, and boundary effects may be seen.
           'same':
             Mode `same` returns output of length ``max(M, N)``.  Boundary
             effects are still visible.
           'valid':
             Mode `valid` returns output of length
             ``max(M, N) - min(M, N) + 1``.  The convolution product is only given
             for points where the signals overlap completely.  Values outside
             the signal boundary have no effect.
       Returns
       -------
       out : ndarray
           Discrete, linear convolution of `a` and `v`.
       See Also
       --------
       scipy.signal.fftconvolve : Convolve two arrays using the Fast Fourier
                                  Transform.
       scipy.linalg.toeplitz : Used to construct the convolution operator.
       Notes
       -----
       The discrete convolution operation is defined as
       .. math:: (f * g)[n] = \sum_{m = -\infty}^{\infty} f[m] g[n - m]
       It can be shown that a convolution :math:`x(t) * y(t)` in time/space
       is equivalent to the multiplication :math:`X(f) Y(f)` in the Fourier
       domain, after appropriate padding (padding is necessary to prevent
       circular convolution).  Since multiplication is more efficient (faster)
       than convolution, the function `scipy.signal.fftconvolve` exploits the
       FFT to calculate the convolution of large data-sets.
       References
       ----------
       .. [1] Wikipedia, "Convolution", http://en.wikipedia.org/wiki/Convolution.
       Examples
       --------
       Note how the convolution operator flips the second array
       before "sliding" the two across one another:
       >>> np.convolve([1, 2, 3], [0, 1, 0.5])
       array([ 0. ,  1. ,  2.5,  4. ,  1.5])
       Only return the middle values of the convolution.
       Contains boundary effects, where zeros are taken
       into account:
       >>> np.convolve([1,2,3],[0,1,0.5], 'same')
       array([ 1. ,  2.5,  4. ])
       The two arrays are of the same length, so there
       is only one position where they completely overlap:
       >>> np.convolve([1,2,3],[0,1,0.5], 'valid')
       array([ 2.5])
       
    """
    
    
    return ndarray()
def copy(a):
    """   Return an array copy of the given object.
       Parameters
       ----------
       a : array_like
           Input data.
       Returns
       -------
       arr : ndarray
           Array interpretation of `a`.
       Notes
       -----
       This is equivalent to
       >>> np.array(a, copy=True)                              #doctest: +SKIP
       Examples
       --------
       Create an array x, with a reference y and a copy z:
       >>> x = np.array([1, 2, 3])
       >>> y = x
       >>> z = np.copy(x)
       Note that, when we modify x, y changes, but not z:
       >>> x[0] = 10
       >>> x[0] == y[0]
       True
       >>> x[0] == z[0]
       False
       
    """
    
    
    return ndarray()
def copysign(out):
    """copysign(x1, x2[, out])
    Change the sign of x1 to that of x2, element-wise.
    If both arguments are arrays or sequences, they have to be of the same
    length. If `x2` is a scalar, its sign will be copied to all elements of
    `x1`.
    Parameters
    ----------
    x1: array_like
       Values to change the sign of.
    x2: array_like
       The sign of `x2` is copied to `x1`.
    out : ndarray, optional
       Array into which the output is placed. Its type is preserved and it
       must be of the right shape to hold the output. See doc.ufuncs.
    Returns
    -------
    out : array_like
       The values of `x1` with the sign of `x2`.
    Examples
    --------
    >>> np.copysign(1.3, -1)
    -1.3
    >>> 1/np.copysign(0, 1)
    inf
    >>> 1/np.copysign(0, -1)
    -inf
    >>> np.copysign([-1, 0, 1], -1.1)
    array([-1., -0., -1.])
    >>> np.copysign([-1, 0, 1], np.arange(3)-1)
    array([-1.,  0.,  1.])
    """
    
    
    return array_like()
core = None
def corrcoef(m,y,rowvar,bias,ddof):
    """   Return correlation coefficients.
       Please refer to the documentation for `cov` for more detail.  The
       relationship between the correlation coefficient matrix, `P`, and the
       covariance matrix, `C`, is
       .. math:: P_{ij} = \frac{ C_{ij} } { \sqrt{ C_{ii} * C_{jj} } }
       The values of `P` are between -1 and 1, inclusive.
       Parameters
       ----------
       m : array_like
           A 1-D or 2-D array containing multiple variables and observations.
           Each row of `m` represents a variable, and each column a single
           observation of all those variables. Also see `rowvar` below.
       y : array_like, optional
           An additional set of variables and observations. `y` has the same
           shape as `m`.
       rowvar : int, optional
           If `rowvar` is non-zero (default), then each row represents a
           variable, with observations in the columns. Otherwise, the relationship
           is transposed: each column represents a variable, while the rows
           contain observations.
       bias : int, optional
           Default normalization is by ``(N - 1)``, where ``N`` is the number of
           observations (unbiased estimate). If `bias` is 1, then
           normalization is by ``N``. These values can be overridden by using
           the keyword ``ddof`` in numpy versions >= 1.5.
       ddof : {None, int}, optional
           .. versionadded:: 1.5
           If not ``None`` normalization is by ``(N - ddof)``, where ``N`` is
           the number of observations; this overrides the value implied by
           ``bias``. The default value is ``None``.
       Returns
       -------
       out : ndarray
           The correlation coefficient matrix of the variables.
       See Also
       --------
       cov : Covariance matrix
       
    """
    
    
    return ndarray()
def correlate(a,v,mode,old_behavior):
    """   Cross-correlation of two 1-dimensional sequences.
       This function computes the correlation as generally defined in signal
       processing texts::
           z[k] = sum_n a[n] * conj(v[n+k])
       with a and v sequences being zero-padded where necessary and conj being
       the conjugate.
       Parameters
       ----------
       a, v : array_like
           Input sequences.
       mode : {'valid', 'same', 'full'}, optional
           Refer to the `convolve` docstring.  Note that the default
           is `valid`, unlike `convolve`, which uses `full`.
       old_behavior : bool
           If True, uses the old behavior from Numeric, (correlate(a,v) == correlate(v,
           a), and the conjugate is not taken for complex arrays). If False, uses
           the conventional signal processing definition (see note).
       See Also
       --------
       convolve : Discrete, linear convolution of two one-dimensional sequences.
       Examples
       --------
       >>> np.correlate([1, 2, 3], [0, 1, 0.5])
       array([ 3.5])
       >>> np.correlate([1, 2, 3], [0, 1, 0.5], "same")
       array([ 2. ,  3.5,  3. ])
       >>> np.correlate([1, 2, 3], [0, 1, 0.5], "full")
       array([ 0.5,  2. ,  3.5,  3. ,  0. ])
       
    """
    
    
    return None
def cos(x,out):
    """cos(x[, out])
    Cosine elementwise.
    Parameters
    ----------
    x : array_like
       Input array in radians.
    out : ndarray, optional
       Output array of same shape as `x`.
    Returns
    -------
    y : ndarray
       The corresponding cosine values.
    Raises
    ------
    ValueError: invalid return array shape
       if `out` is provided and `out.shape` != `x.shape` (See Examples)
    Notes
    -----
    If `out` is provided, the function writes the result into it,
    and returns a reference to `out`.  (See Examples)
    References
    ----------
    M. Abramowitz and I. A. Stegun, Handbook of Mathematical Functions.
    New York, NY: Dover, 1972.
    Examples
    --------
    >>> np.cos(np.array([0, np.pi/2, np.pi]))
    array([  1.00000000e+00,   6.12303177e-17,  -1.00000000e+00])
    >>>
    >>> # Example of providing the optional output parameter
    >>> out2 = np.cos([0.1], out1)
    >>> out2 is out1
    True
    >>>
    >>> # Example of ValueError due to provision of shape mis-matched `out`
    >>> np.cos(np.zeros((3,3)),np.zeros((2,2)))
    Traceback (most recent call last):
     File "<stdin>", line 1, in <module>
    ValueError: invalid return array shape
    """
    
    
    return ndarray()
def cosh(x):
    """cosh(x[, out])
    Hyperbolic cosine, element-wise.
    Equivalent to ``1/2 * (np.exp(x) + np.exp(-x))`` and ``np.cos(1j*x)``.
    Parameters
    ----------
    x : array_like
       Input array.
    Returns
    -------
    out : ndarray
       Output array of same shape as `x`.
    Examples
    --------
    >>> np.cosh(0)
    1.0
    The hyperbolic cosine describes the shape of a hanging cable:
    >>> import matplotlib.pyplot as plt
    >>> x = np.linspace(-4, 4, 1000)
    >>> plt.plot(x, np.cosh(x))
    >>> plt.show()
    """
    
    
    return ndarray()
def cov(m,y,rowvar,bias,ddof):
    """   Estimate a covariance matrix, given data.
       Covariance indicates the level to which two variables vary together.
       If we examine N-dimensional samples, :math:`X = [x_1, x_2, ... x_N]^T`,
       then the covariance matrix element :math:`C_{ij}` is the covariance of
       :math:`x_i` and :math:`x_j`. The element :math:`C_{ii}` is the variance
       of :math:`x_i`.
       Parameters
       ----------
       m : array_like
           A 1-D or 2-D array containing multiple variables and observations.
           Each row of `m` represents a variable, and each column a single
           observation of all those variables. Also see `rowvar` below.
       y : array_like, optional
           An additional set of variables and observations. `y` has the same
           form as that of `m`.
       rowvar : int, optional
           If `rowvar` is non-zero (default), then each row represents a
           variable, with observations in the columns. Otherwise, the relationship
           is transposed: each column represents a variable, while the rows
           contain observations.
       bias : int, optional
           Default normalization is by ``(N - 1)``, where ``N`` is the number of
           observations given (unbiased estimate). If `bias` is 1, then
           normalization is by ``N``. These values can be overridden by using
           the keyword ``ddof`` in numpy versions >= 1.5.
       ddof : int, optional
           .. versionadded:: 1.5
           If not ``None`` normalization is by ``(N - ddof)``, where ``N`` is
           the number of observations; this overrides the value implied by
           ``bias``. The default value is ``None``.
       Returns
       -------
       out : ndarray
           The covariance matrix of the variables.
       See Also
       --------
       corrcoef : Normalized covariance matrix
       Examples
       --------
       Consider two variables, :math:`x_0` and :math:`x_1`, which
       correlate perfectly, but in opposite directions:
       >>> x = np.array([[0, 2], [1, 1], [2, 0]]).T
       >>> x
       array([[0, 1, 2],
              [2, 1, 0]])
       Note how :math:`x_0` increases while :math:`x_1` decreases. The covariance
       matrix shows this clearly:
       >>> np.cov(x)
       array([[ 1., -1.],
              [-1.,  1.]])
       Note that element :math:`C_{0,1}`, which shows the correlation between
       :math:`x_0` and :math:`x_1`, is negative.
       Further, note how `x` and `y` are combined:
       >>> x = [-2.1, -1,  4.3]
       >>> y = [3,  1.1,  0.12]
       >>> X = np.vstack((x,y))
       >>> print np.cov(X)
       [[ 11.71        -4.286     ]
        [ -4.286        2.14413333]]
       >>> print np.cov(x, y)
       [[ 11.71        -4.286     ]
        [ -4.286        2.14413333]]
       >>> print np.cov(x)
       11.71
       
    """
    
    
    return ndarray()
def cross(a,b,axisa,axisb,axisc,axis):
    """   Return the cross product of two (arrays of) vectors.
       The cross product of `a` and `b` in :math:`R^3` is a vector perpendicular
       to both `a` and `b`.  If `a` and `b` are arrays of vectors, the vectors
       are defined by the last axis of `a` and `b` by default, and these axes
       can have dimensions 2 or 3.  Where the dimension of either `a` or `b` is
       2, the third component of the input vector is assumed to be zero and the
       cross product calculated accordingly.  In cases where both input vectors
       have dimension 2, the z-component of the cross product is returned.
       Parameters
       ----------
       a : array_like
           Components of the first vector(s).
       b : array_like
           Components of the second vector(s).
       axisa : int, optional
           Axis of `a` that defines the vector(s).  By default, the last axis.
       axisb : int, optional
           Axis of `b` that defines the vector(s).  By default, the last axis.
       axisc : int, optional
           Axis of `c` containing the cross product vector(s).  By default, the
           last axis.
       axis : int, optional
           If defined, the axis of `a`, `b` and `c` that defines the vector(s)
           and cross product(s).  Overrides `axisa`, `axisb` and `axisc`.
       Returns
       -------
       c : ndarray
           Vector cross product(s).
       Raises
       ------
       ValueError
           When the dimension of the vector(s) in `a` and/or `b` does not
           equal 2 or 3.
       See Also
       --------
       inner : Inner product
       outer : Outer product.
       ix_ : Construct index arrays.
       Examples
       --------
       Vector cross-product.
       >>> x = [1, 2, 3]
       >>> y = [4, 5, 6]
       >>> np.cross(x, y)
       array([-3,  6, -3])
       One vector with dimension 2.
       >>> x = [1, 2]
       >>> y = [4, 5, 6]
       >>> np.cross(x, y)
       array([12, -6, -3])
       Equivalently:
       >>> x = [1, 2, 0]
       >>> y = [4, 5, 6]
       >>> np.cross(x, y)
       array([12, -6, -3])
       Both vectors with dimension 2.
       >>> x = [1,2]
       >>> y = [4,5]
       >>> np.cross(x, y)
       -3
       Multiple vector cross-products. Note that the direction of the cross
       product vector is defined by the `right-hand rule`.
       >>> x = np.array([[1,2,3], [4,5,6]])
       >>> y = np.array([[4,5,6], [1,2,3]])
       >>> np.cross(x, y)
       array([[-3,  6, -3],
              [ 3, -6,  3]])
       The orientation of `c` can be changed using the `axisc` keyword.
       >>> np.cross(x, y, axisc=0)
       array([[-3,  3],
              [ 6, -6],
              [-3,  3]])
       Change the vector definition of `x` and `y` using `axisa` and `axisb`.
       >>> x = np.array([[1,2,3], [4,5,6], [7, 8, 9]])
       >>> y = np.array([[7, 8, 9], [4,5,6], [1,2,3]])
       >>> np.cross(x, y)
       array([[ -6,  12,  -6],
              [  0,   0,   0],
              [  6, -12,   6]])
       >>> np.cross(x, y, axisa=0, axisb=0)
       array([[-24,  48, -24],
              [-30,  60, -30],
              [-36,  72, -36]])
       
    """
    
    
    return ndarray()
class csingle:
    T = None
    def all(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def any(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmax(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmin(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argsort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def astype(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    base = None
    def byteswap(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def choose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def clip(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def compress(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def conj(self):
        """None"""
        
        
        return None
    def conjugate(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def copy(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumprod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumsum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    data = None
    def diagonal(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    dtype = None
    def dump(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def dumps(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def fill(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    flags = None
    flat = None
    def flatten(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def getfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    imag = None
    def item(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def itemset(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    itemsize = None
    def max(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def mean(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def min(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    nbytes = None
    ndim = None
    def newbyteorder(self,new_order):
        """newbyteorder(new_order='S')
           Return a new `dtype` with a different byte order.
           Changes are also made in all fields and sub-arrays of the data type.
           The `new_order` code can be any from the following:
           * {'<', 'L'} - little endian
           * {'>', 'B'} - big endian
           * {'=', 'N'} - native order
           * 'S' - swap dtype from current to opposite endian
           * {'|', 'I'} - ignore (no change to byte order)
           Parameters
           ----------
           new_order : str, optional
               Byte order to force; a value from the byte order specifications
               above.  The default value ('S') results in swapping the current
               byte order. The code does a case-insensitive check on the first
               letter of `new_order` for the alternatives above.  For example,
               any of 'B' or 'b' or 'biggish' are valid to specify big-endian.
           Returns
           -------
           new_dtype : dtype
               New `dtype` object with the given change to the byte order.
        """
        
        
        return dtype()
    def nonzero(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def prod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ptp(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def put(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ravel(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    real = None
    def repeat(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def reshape(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def resize(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def round(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def searchsorted(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setflags(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    shape = None
    size = None
    def sort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def squeeze(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def std(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    strides = None
    def sum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def swapaxes(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def take(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tofile(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tolist(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tostring(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def trace(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def transpose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def var(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def view(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    

ctypeslib = None
def cumprod(a,axis,dtype,out):
    """   Return the cumulative product of elements along a given axis.
       Parameters
       ----------
       a : array_like
           Input array.
       axis : int, optional
           Axis along which the cumulative product is computed.  By default
           the input is flattened.
       dtype : dtype, optional
           Type of the returned array, as well as of the accumulator in which
           the elements are multiplied.  If *dtype* is not specified, it
           defaults to the dtype of `a`, unless `a` has an integer dtype with
           a precision less than that of the default platform integer.  In
           that case, the default platform integer is used instead.
       out : ndarray, optional
           Alternative output array in which to place the result. It must
           have the same shape and buffer length as the expected output
           but the type of the resulting values will be cast if necessary.
       Returns
       -------
       cumprod : ndarray
           A new array holding the result is returned unless `out` is
           specified, in which case a reference to out is returned.
       See Also
       --------
       numpy.doc.ufuncs : Section "Output arguments"
       Notes
       -----
       Arithmetic is modular when using integer types, and no error is
       raised on overflow.
       Examples
       --------
       >>> a = np.array([1,2,3])
       >>> np.cumprod(a) # intermediate results 1, 1*2
       ...               # total product 1*2*3 = 6
       array([1, 2, 6])
       >>> a = np.array([[1, 2, 3], [4, 5, 6]])
       >>> np.cumprod(a, dtype=float) # specify type of output
       array([   1.,    2.,    6.,   24.,  120.,  720.])
       The cumulative product for each column (i.e., over the rows) of `a`:
       >>> np.cumprod(a, axis=0)
       array([[ 1,  2,  3],
              [ 4, 10, 18]])
       The cumulative product for each row (i.e. over the columns) of `a`:
       >>> np.cumprod(a,axis=1)
       array([[  1,   2,   6],
              [  4,  20, 120]])
       
    """
    
    
    return ndarray()
def cumproduct():
    """   Return the cumulative product over the given axis.
       See Also
       --------
       cumprod : equivalent function; see for details.
       
    """
    
    
    return None
def cumsum(a,axis,dtype,out):
    """   Return the cumulative sum of the elements along a given axis.
       Parameters
       ----------
       a : array_like
           Input array.
       axis : int, optional
           Axis along which the cumulative sum is computed. The default
           (None) is to compute the cumsum over the flattened array.
       dtype : dtype, optional
           Type of the returned array and of the accumulator in which the
           elements are summed.  If `dtype` is not specified, it defaults
           to the dtype of `a`, unless `a` has an integer dtype with a
           precision less than that of the default platform integer.  In
           that case, the default platform integer is used.
       out : ndarray, optional
           Alternative output array in which to place the result. It must
           have the same shape and buffer length as the expected output
           but the type will be cast if necessary. See `doc.ufuncs`
           (Section "Output arguments") for more details.
       Returns
       -------
       cumsum_along_axis : ndarray.
           A new array holding the result is returned unless `out` is
           specified, in which case a reference to `out` is returned. The
           result has the same size as `a`, and the same shape as `a` if
           `axis` is not None or `a` is a 1-d array.
       See Also
       --------
       sum : Sum array elements.
       trapz : Integration of array values using the composite trapezoidal rule.
       Notes
       -----
       Arithmetic is modular when using integer types, and no error is
       raised on overflow.
       Examples
       --------
       >>> a = np.array([[1,2,3], [4,5,6]])
       >>> a
       array([[1, 2, 3],
              [4, 5, 6]])
       >>> np.cumsum(a)
       array([ 1,  3,  6, 10, 15, 21])
       >>> np.cumsum(a, dtype=float)     # specifies type of output value(s)
       array([  1.,   3.,   6.,  10.,  15.,  21.])
       >>> np.cumsum(a,axis=0)      # sum over rows for each of the 3 columns
       array([[1, 2, 3],
              [5, 7, 9]])
       >>> np.cumsum(a,axis=1)      # sum over columns for each of the 2 rows
       array([[ 1,  3,  6],
              [ 4,  9, 15]])
       
    """
    
    
    return ndarray_()
def datetime_data():
    """Return (unit, numerator, denominator, events) from a datetime dtype
       
    """
    
    
    return None
def deg2rad(x):
    """deg2rad(x[, out])
    Convert angles from degrees to radians.
    Parameters
    ----------
    x : array_like
       Angles in degrees.
    Returns
    -------
    y : ndarray
       The corresponding angle in radians.
    See Also
    --------
    rad2deg : Convert angles from radians to degrees.
    unwrap : Remove large jumps in angle by wrapping.
    Notes
    -----
    .. versionadded:: 1.3.0
    ``deg2rad(x)`` is ``x * pi / 180``.
    Examples
    --------
    >>> np.deg2rad(180)
    3.1415926535897931
    """
    
    
    return ndarray()
def degrees(x,out):
    """degrees(x[, out])
    Convert angles from radians to degrees.
    Parameters
    ----------
    x : array_like
       Input array in radians.
    out : ndarray, optional
       Output array of same shape as x.
    Returns
    -------
    y : ndarray of floats
       The corresponding degree values; if `out` was supplied this is a
       reference to it.
    See Also
    --------
    rad2deg : equivalent function
    Examples
    --------
    Convert a radian array to degrees
    >>> rad = np.arange(12.)*np.pi/6
    >>> np.degrees(rad)
    array([   0.,   30.,   60.,   90.,  120.,  150.,  180.,  210.,  240.,
           270.,  300.,  330.])
    >>> out = np.zeros((rad.shape))
    >>> r = degrees(rad, out)
    >>> np.all(r == out)
    True
    """
    
    
    return ndarray()
def delete(arr,obj,axis):
    """   Return a new array with sub-arrays along an axis deleted.
       Parameters
       ----------
       arr : array_like
         Input array.
       obj : slice, int or array of ints
         Indicate which sub-arrays to remove.
       axis : int, optional
         The axis along which to delete the subarray defined by `obj`.
         If `axis` is None, `obj` is applied to the flattened array.
       Returns
       -------
       out : ndarray
           A copy of `arr` with the elements specified by `obj` removed. Note
           that `delete` does not occur in-place. If `axis` is None, `out` is
           a flattened array.
       See Also
       --------
       insert : Insert elements into an array.
       append : Append elements at the end of an array.
       Examples
       --------
       >>> arr = np.array([[1,2,3,4], [5,6,7,8], [9,10,11,12]])
       >>> arr
       array([[ 1,  2,  3,  4],
              [ 5,  6,  7,  8],
              [ 9, 10, 11, 12]])
       >>> np.delete(arr, 1, 0)
       array([[ 1,  2,  3,  4],
              [ 9, 10, 11, 12]])
       >>> np.delete(arr, np.s_[::2], 1)
       array([[ 2,  4],
              [ 6,  8],
              [10, 12]])
       >>> np.delete(arr, [1,3,5], None)
       array([ 1,  3,  5,  7,  8,  9, 10, 11, 12])
       
    """
    
    
    return ndarray()
def deprecate(func,old_name,new_name,message):
    """   Issues a DeprecationWarning, adds warning to `old_name`'s
       docstring, rebinds ``old_name.__name__`` and returns the new
       function object.
       This function may also be used as a decorator.
       Parameters
       ----------
       func : function
           The function to be deprecated.
       old_name : str, optional
           The name of the function to be deprecated. Default is None, in which
           case the name of `func` is used.
       new_name : str, optional
           The new name for the function. Default is None, in which case
           the deprecation message is that `old_name` is deprecated. If given,
           the deprecation message is that `old_name` is deprecated and `new_name`
           should be used instead.
       message : str, optional
           Additional explanation of the deprecation.  Displayed in the docstring
           after the warning.
       Returns
       -------
       old_func : function
           The deprecated function.
       Examples
       --------
       Note that ``olduint`` returns a value after printing Deprecation Warning:
       >>> olduint = np.deprecate(np.uint)
       >>> olduint(6)
       /usr/lib/python2.5/site-packages/numpy/lib/utils.py:114:
       DeprecationWarning: uint32 is deprecated
         warnings.warn(str1, DeprecationWarning)
       6
       
    """
    
    
    return function()
def deprecate_with_doc():
    """message
    """
    
    
    return None
def diag(v,k):
    """   Extract a diagonal or construct a diagonal array.
       Parameters
       ----------
       v : array_like
           If `v` is a 2-D array, return a copy of its `k`-th diagonal.
           If `v` is a 1-D array, return a 2-D array with `v` on the `k`-th
           diagonal.
       k : int, optional
           Diagonal in question. The default is 0. Use `k>0` for diagonals
           above the main diagonal, and `k<0` for diagonals below the main
           diagonal.
       Returns
       -------
       out : ndarray
           The extracted diagonal or constructed diagonal array.
       See Also
       --------
       diagonal : Return specified diagonals.
       diagflat : Create a 2-D array with the flattened input as a diagonal.
       trace : Sum along diagonals.
       triu : Upper triangle of an array.
       tril : Lower triange of an array.
       Examples
       --------
       >>> x = np.arange(9).reshape((3,3))
       >>> x
       array([[0, 1, 2],
              [3, 4, 5],
              [6, 7, 8]])
       >>> np.diag(x)
       array([0, 4, 8])
       >>> np.diag(x, k=1)
       array([1, 5])
       >>> np.diag(x, k=-1)
       array([3, 7])
       >>> np.diag(np.diag(x))
       array([[0, 0, 0],
              [0, 4, 0],
              [0, 0, 8]])
       
    """
    
    
    return ndarray()
def diag_indices(n,ndim):
    """   Return the indices to access the main diagonal of an array.
       This returns a tuple of indices that can be used to access the main
       diagonal of an array `a` with ``a.ndim >= 2`` dimensions and shape
       (n, n, ..., n). For ``a.ndim = 2`` this is the usual diagonal, for
       ``a.ndim > 2`` this is the set of indices to access ``a[i, i, ..., i]``
       for ``i = [0..n-1]``.
       Parameters
       ----------
       n : int
         The size, along each dimension, of the arrays for which the returned
         indices can be used.
       ndim : int, optional
         The number of dimensions.
       See also
       --------
       diag_indices_from
       Notes
       -----
       .. versionadded:: 1.4.0
       Examples
       --------
       Create a set of indices to access the diagonal of a (4, 4) array:
       >>> di = np.diag_indices(4)
       >>> di
       (array([0, 1, 2, 3]), array([0, 1, 2, 3]))
       >>> a = np.arange(16).reshape(4, 4)
       >>> a
       array([[ 0,  1,  2,  3],
              [ 4,  5,  6,  7],
              [ 8,  9, 10, 11],
              [12, 13, 14, 15]])
       >>> a[di] = 100
       >>> a
       array([[100,   1,   2,   3],
              [  4, 100,   6,   7],
              [  8,   9, 100,  11],
              [ 12,  13,  14, 100]])
       Now, we create indices to manipulate a 3-D array:
       >>> d3 = np.diag_indices(2, 3)
       >>> d3
       (array([0, 1]), array([0, 1]), array([0, 1]))
       And use it to set the diagonal of an array of zeros to 1:
       >>> a = np.zeros((2, 2, 2), dtype=np.int)
       >>> a[d3] = 1
       >>> a
       array([[[1, 0],
               [0, 0]],
              [[0, 0],
               [0, 1]]])
       
    """
    
    
    return None
def diag_indices_from(arr):
    """   Return the indices to access the main diagonal of an n-dimensional array.
       See `diag_indices` for full details.
       Parameters
       ----------
       arr : array, at least 2-D
       See Also
       --------
       diag_indices
       Notes
       -----
       .. versionadded:: 1.4.0
       
    """
    
    
    return None
def diagflat(v,k):
    """   Create a two-dimensional array with the flattened input as a diagonal.
       Parameters
       ----------
       v : array_like
           Input data, which is flattened and set as the `k`-th
           diagonal of the output.
       k : int, optional
           Diagonal to set; 0, the default, corresponds to the "main" diagonal,
           a positive (negative) `k` giving the number of the diagonal above
           (below) the main.
       Returns
       -------
       out : ndarray
           The 2-D output array.
       See Also
       --------
       diag : MATLAB work-alike for 1-D and 2-D arrays.
       diagonal : Return specified diagonals.
       trace : Sum along diagonals.
       Examples
       --------
       >>> np.diagflat([[1,2], [3,4]])
       array([[1, 0, 0, 0],
              [0, 2, 0, 0],
              [0, 0, 3, 0],
              [0, 0, 0, 4]])
       >>> np.diagflat([1,2], 1)
       array([[0, 1, 0],
              [0, 0, 2],
              [0, 0, 0]])
       
    """
    
    
    return ndarray()
def diagonal(a,offset,axis1,axis2):
    """   Return specified diagonals.
       If `a` is 2-D, returns the diagonal of `a` with the given offset,
       i.e., the collection of elements of the form ``a[i, i+offset]``.  If
       `a` has more than two dimensions, then the axes specified by `axis1`
       and `axis2` are used to determine the 2-D sub-array whose diagonal is
       returned.  The shape of the resulting array can be determined by
       removing `axis1` and `axis2` and appending an index to the right equal
       to the size of the resulting diagonals.
       Parameters
       ----------
       a : array_like
           Array from which the diagonals are taken.
       offset : int, optional
           Offset of the diagonal from the main diagonal.  Can be positive or
           negative.  Defaults to main diagonal (0).
       axis1 : int, optional
           Axis to be used as the first axis of the 2-D sub-arrays from which
           the diagonals should be taken.  Defaults to first axis (0).
       axis2 : int, optional
           Axis to be used as the second axis of the 2-D sub-arrays from
           which the diagonals should be taken. Defaults to second axis (1).
       Returns
       -------
       array_of_diagonals : ndarray
           If `a` is 2-D, a 1-D array containing the diagonal is returned.
           If the dimension of `a` is larger, then an array of diagonals is
           returned, "packed" from left-most dimension to right-most (e.g.,
           if `a` is 3-D, then the diagonals are "packed" along rows).
       Raises
       ------
       ValueError
           If the dimension of `a` is less than 2.
       See Also
       --------
       diag : MATLAB work-a-like for 1-D and 2-D arrays.
       diagflat : Create diagonal arrays.
       trace : Sum along diagonals.
       Examples
       --------
       >>> a = np.arange(4).reshape(2,2)
       >>> a
       array([[0, 1],
              [2, 3]])
       >>> a.diagonal()
       array([0, 3])
       >>> a.diagonal(1)
       array([1])
       A 3-D example:
       >>> a = np.arange(8).reshape(2,2,2); a
       array([[[0, 1],
               [2, 3]],
              [[4, 5],
               [6, 7]]])
       >>> a.diagonal(0, # Main diagonals of two arrays created by skipping
       ...            0, # across the outer(left)-most axis last and
       ...            1) # the "middle" (row) axis first.
       array([[0, 6],
              [1, 7]])
       The sub-arrays whose main diagonals we just obtained; note that each
       corresponds to fixing the right-most (column) axis, and that the
       diagonals are "packed" in rows.
       >>> a[:,:,0] # main diagonal is [0 6]
       array([[0, 2],
              [4, 6]])
       >>> a[:,:,1] # main diagonal is [1 7]
       array([[1, 3],
              [5, 7]])
       
    """
    
    
    return ndarray()
def diff(a,n,axis):
    """   Calculate the n-th order discrete difference along given axis.
       The first order difference is given by ``out[n] = a[n+1] - a[n]`` along
       the given axis, higher order differences are calculated by using `diff`
       recursively.
       Parameters
       ----------
       a : array_like
           Input array
       n : int, optional
           The number of times values are differenced.
       axis : int, optional
           The axis along which the difference is taken, default is the last axis.
       Returns
       -------
       out : ndarray
           The `n` order differences. The shape of the output is the same as `a`
           except along `axis` where the dimension is smaller by `n`.
       See Also
       --------
       gradient, ediff1d
       Examples
       --------
       >>> x = np.array([1, 2, 4, 7, 0])
       >>> np.diff(x)
       array([ 1,  2,  3, -7])
       >>> np.diff(x, n=2)
       array([  1,   1, -10])
       >>> x = np.array([[1, 3, 6, 10], [0, 5, 6, 8]])
       >>> np.diff(x)
       array([[2, 3, 4],
              [5, 1, 2]])
       >>> np.diff(x, axis=0)
       array([[-1,  2,  0, -2]])
       
    """
    
    
    return ndarray()
def digitize(x,bins):
    """digitize(x, bins)
       Return the indices of the bins to which each value in input array belongs.
       Each index ``i`` returned is such that ``bins[i-1] <= x < bins[i]`` if
       `bins` is monotonically increasing, or ``bins[i-1] > x >= bins[i]`` if
       `bins` is monotonically decreasing. If values in `x` are beyond the
       bounds of `bins`, 0 or ``len(bins)`` is returned as appropriate.
       Parameters
       ----------
       x : array_like
           Input array to be binned. It has to be 1-dimensional.
       bins : array_like
           Array of bins. It has to be 1-dimensional and monotonic.
       Returns
       -------
       out : ndarray of ints
           Output array of indices, of same shape as `x`.
       Raises
       ------
       ValueError
           If the input is not 1-dimensional, or if `bins` is not monotonic.
       TypeError
           If the type of the input is complex.
       See Also
       --------
       bincount, histogram, unique
       Notes
       -----
       If values in `x` are such that they fall outside the bin range,
       attempting to index `bins` with the indices that `digitize` returns
       will result in an IndexError.
       Examples
       --------
       >>> x = np.array([0.2, 6.4, 3.0, 1.6])
       >>> bins = np.array([0.0, 1.0, 2.5, 4.0, 10.0])
       >>> inds = np.digitize(x, bins)
       >>> inds
       array([1, 4, 3, 2])
       >>> for n in range(x.size):
       ...   print bins[inds[n]-1], "<=", x[n], "<", bins[inds[n]]
       ...
       0.0 <= 0.2 < 1.0
       4.0 <= 6.4 < 10.0
       2.5 <= 3.0 < 4.0
       1.0 <= 1.6 < 2.5
    """
    
    
    return ndarray()
def disp(mesg,device,linefeed):
    """   Display a message on a device.
       Parameters
       ----------
       mesg : str
           Message to display.
       device : object
           Device to write message. If None, defaults to ``sys.stdout`` which is
           very similar to ``print``. `device` needs to have ``write()`` and
           ``flush()`` methods.
       linefeed : bool, optional
           Option whether to print a line feed or not. Defaults to True.
       Raises
       ------
       AttributeError
           If `device` does not have a ``write()`` or ``flush()`` method.
       Examples
       --------
       Besides ``sys.stdout``, a file-like object can also be used as it has
       both required methods:
       >>> from StringIO import StringIO
       >>> buf = StringIO()
       >>> np.disp('"Display" in a file', device=buf)
       >>> buf.getvalue()
       '"Display" in a file\n'
       
    """
    
    
    return None
def divide(x1,x2,out):
    """divide(x1, x2[, out])
    Divide arguments element-wise.
    Parameters
    ----------
    x1 : array_like
       Dividend array.
    x2 : array_like
       Divisor array.
    out : ndarray, optional
       Array into which the output is placed. Its type is preserved and it
       must be of the right shape to hold the output. See doc.ufuncs.
    Returns
    -------
    y : {ndarray, scalar}
       The quotient `x1/x2`, element-wise. Returns a scalar if
       both  `x1` and `x2` are scalars.
    See Also
    --------
    seterr : Set whether to raise or warn on overflow, underflow and division
            by zero.
    Notes
    -----
    Equivalent to `x1` / `x2` in terms of array-broadcasting.
    Behavior on division by zero can be changed using `seterr`.
    When both `x1` and `x2` are of an integer type, `divide` will return
    integers and throw away the fractional part. Moreover, division by zero
    always yields zero in integer arithmetic.
    Examples
    --------
    >>> np.divide(2.0, 4.0)
    0.5
    >>> x1 = np.arange(9.0).reshape((3, 3))
    >>> x2 = np.arange(3.0)
    >>> np.divide(x1, x2)
    array([[ NaN,  1. ,  1. ],
          [ Inf,  4. ,  2.5],
          [ Inf,  7. ,  4. ]])
    Note the behavior with integer types:
    >>> np.divide(2, 4)
    0
    >>> np.divide(2, 4.)
    0.5
    Division by zero always yields zero in integer arithmetic, and does not
    raise an exception or a warning:
    >>> np.divide(np.array([0, 1], dtype=int), np.array([0, 0], dtype=int))
    array([0, 0])
    Division by zero can, however, be caught using `seterr`:
    >>> old_err_state = np.seterr(divide='raise')
    >>> np.divide(1, 0)
    Traceback (most recent call last):
     File "<stdin>", line 1, in <module>
    FloatingPointError: divide by zero encountered in divide
    >>> ignored_states = np.seterr(**old_err_state)
    >>> np.divide(1, 0)
    0
    """
    
    
    return ndarray()
def dot(a,b):
    """dot(a, b)
       Dot product of two arrays.
       For 2-D arrays it is equivalent to matrix multiplication, and for 1-D
       arrays to inner product of vectors (without complex conjugation). For
       N dimensions it is a sum product over the last axis of `a` and
       the second-to-last of `b`::
           dot(a, b)[i,j,k,m] = sum(a[i,j,:] * b[k,:,m])
       Parameters
       ----------
       a : array_like
           First argument.
       b : array_like
           Second argument.
       Returns
       -------
       output : ndarray
           Returns the dot product of `a` and `b`.  If `a` and `b` are both
           scalars or both 1-D arrays then a scalar is returned; otherwise
           an array is returned.
       Raises
       ------
       ValueError
           If the last dimension of `a` is not the same size as
           the second-to-last dimension of `b`.
       See Also
       --------
       vdot : Complex-conjugating dot product.
       tensordot : Sum products over arbitrary axes.
       Examples
       --------
       >>> np.dot(3, 4)
       12
       Neither argument is complex-conjugated:
       >>> np.dot([2j, 3j], [2j, 3j])
       (-13+0j)
       For 2-D arrays it's the matrix product:
       >>> a = [[1, 0], [0, 1]]
       >>> b = [[4, 1], [2, 2]]
       >>> np.dot(a, b)
       array([[4, 1],
              [2, 2]])
       >>> a = np.arange(3*4*5*6).reshape((3,4,5,6))
       >>> b = np.arange(3*4*5*6)[::-1].reshape((5,4,6,3))
       >>> np.dot(a, b)[2,3,2,1,2,2]
       499128
       >>> sum(a[2,3,2,:] * b[1,2,:,2])
       499128
    """
    
    
    return ndarray()
class double:
    T = None
    def all(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def any(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmax(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmin(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argsort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def as_integer_ratio(self,):
        """float.as_integer_ratio() -> (int, int)
        Returns a pair of integers, whose ratio is exactly equal to the original
        float and with a positive denominator.
        Raises OverflowError on infinities and a ValueError on NaNs.
        >>> (10.0).as_integer_ratio()
        (10, 1)
        >>> (0.0).as_integer_ratio()
        (0, 1)
        >>> (-.25).as_integer_ratio()
        (-1, 4)
        """
        
        
        return None
    def astype(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    base = None
    def byteswap(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def choose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def clip(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def compress(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def conj(self):
        """None"""
        
        
        return None
    def conjugate(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def copy(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumprod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumsum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    data = None
    def diagonal(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    dtype = None
    def dump(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def dumps(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def fill(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    flags = None
    flat = None
    def flatten(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def fromhex(self,string):
        """float.fromhex(string) -> float
        Create a floating-point number from a hexadecimal string.
        >>> float.fromhex('0x1.ffffp10')
        2047.984375
        >>> float.fromhex('-0x1p-1074')
        -4.9406564584124654e-324
        """
        
        
        return None
    def getfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def hex(self,):
        """float.hex() -> string
        Return a hexadecimal representation of a floating-point number.
        >>> (-0.1).hex()
        '-0x1.999999999999ap-4'
        >>> 3.14159.hex()
        '0x1.921f9f01b866ep+1'
        """
        
        
        return None
    imag = None
    def is_integer(self):
        """Returns True if the float is an integer.
        """
        
        
        return None
    def item(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def itemset(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    itemsize = None
    def max(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def mean(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def min(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    nbytes = None
    ndim = None
    def newbyteorder(self,new_order):
        """newbyteorder(new_order='S')
           Return a new `dtype` with a different byte order.
           Changes are also made in all fields and sub-arrays of the data type.
           The `new_order` code can be any from the following:
           * {'<', 'L'} - little endian
           * {'>', 'B'} - big endian
           * {'=', 'N'} - native order
           * 'S' - swap dtype from current to opposite endian
           * {'|', 'I'} - ignore (no change to byte order)
           Parameters
           ----------
           new_order : str, optional
               Byte order to force; a value from the byte order specifications
               above.  The default value ('S') results in swapping the current
               byte order. The code does a case-insensitive check on the first
               letter of `new_order` for the alternatives above.  For example,
               any of 'B' or 'b' or 'biggish' are valid to specify big-endian.
           Returns
           -------
           new_dtype : dtype
               New `dtype` object with the given change to the byte order.
        """
        
        
        return dtype()
    def nonzero(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def prod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ptp(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def put(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ravel(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    real = None
    def repeat(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def reshape(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def resize(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def round(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def searchsorted(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setflags(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    shape = None
    size = None
    def sort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def squeeze(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def std(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    strides = None
    def sum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def swapaxes(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def take(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tofile(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tolist(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tostring(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def trace(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def transpose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def var(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def view(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    

def dsplit():
    """   Split array into multiple sub-arrays along the 3rd axis (depth).
       Please refer to the `split` documentation.  `dsplit` is equivalent
       to `split` with ``axis=2``, the array is always split along the third
       axis provided the array dimension is greater than or equal to 3.
       See Also
       --------
       split : Split an array into multiple sub-arrays of equal size.
       Examples
       --------
       >>> x = np.arange(16.0).reshape(2, 2, 4)
       >>> x
       array([[[  0.,   1.,   2.,   3.],
               [  4.,   5.,   6.,   7.]],
              [[  8.,   9.,  10.,  11.],
               [ 12.,  13.,  14.,  15.]]])
       >>> np.dsplit(x, 2)
       [array([[[  0.,   1.],
               [  4.,   5.]],
              [[  8.,   9.],
               [ 12.,  13.]]]),
        array([[[  2.,   3.],
               [  6.,   7.]],
              [[ 10.,  11.],
               [ 14.,  15.]]])]
       >>> np.dsplit(x, np.array([3, 6]))
       [array([[[  0.,   1.,   2.],
               [  4.,   5.,   6.]],
              [[  8.,   9.,  10.],
               [ 12.,  13.,  14.]]]),
        array([[[  3.],
               [  7.]],
              [[ 11.],
               [ 15.]]]),
        array([], dtype=float64)]
       
    """
    
    
    return None
def dstack(tup):
    """   Stack arrays in sequence depth wise (along third axis).
       Takes a sequence of arrays and stack them along the third axis
       to make a single array. Rebuilds arrays divided by `dsplit`.
       This is a simple way to stack 2D arrays (images) into a single
       3D array for processing.
       Parameters
       ----------
       tup : sequence of arrays
           Arrays to stack. All of them must have the same shape along all
           but the third axis.
       Returns
       -------
       stacked : ndarray
           The array formed by stacking the given arrays.
       See Also
       --------
       vstack : Stack along first axis.
       hstack : Stack along second axis.
       concatenate : Join arrays.
       dsplit : Split array along third axis.
       Notes
       -----
       Equivalent to ``np.concatenate(tup, axis=2)``.
       Examples
       --------
       >>> a = np.array((1,2,3))
       >>> b = np.array((2,3,4))
       >>> np.dstack((a,b))
       array([[[1, 2],
               [2, 3],
               [3, 4]]])
       >>> a = np.array([[1],[2],[3]])
       >>> b = np.array([[2],[3],[4]])
       >>> np.dstack((a,b))
       array([[[1, 2]],
              [[2, 3]],
              [[3, 4]]])
       
    """
    
    
    return ndarray()
class dtype:
    alignment = None
    base = None
    byteorder = None
    char = None
    descr = None
    fields = None
    flags = None
    hasobject = None
    isbuiltin = None
    isnative = None
    itemsize = None
    kind = None
    metadata = None
    name = None
    names = None
    def newbyteorder(self,new_order):
        """newbyteorder(new_order='S')
           Return a new dtype with a different byte order.
           Changes are also made in all fields and sub-arrays of the data type.
           Parameters
           ----------
           new_order : string, optional
               Byte order to force; a value from the byte order
               specifications below.  The default value ('S') results in
               swapping the current byte order.
               `new_order` codes can be any of::
                * 'S' - swap dtype from current to opposite endian
                * {'<', 'L'} - little endian
                * {'>', 'B'} - big endian
                * {'=', 'N'} - native order
                * {'|', 'I'} - ignore (no change to byte order)
               The code does a case-insensitive check on the first letter of
               `new_order` for these alternatives.  For example, any of '>'
               or 'B' or 'b' or 'brian' are valid to specify big-endian.
           Returns
           -------
           new_dtype : dtype
               New dtype object with the given change to the byte order.
           Notes
           -----
           Changes are also made in all fields and sub-arrays of the data type.
           Examples
           --------
           >>> import sys
           >>> sys_is_le = sys.byteorder == 'little'
           >>> native_code = sys_is_le and '<' or '>'
           >>> swapped_code = sys_is_le and '>' or '<'
           >>> native_dt = np.dtype(native_code+'i2')
           >>> swapped_dt = np.dtype(swapped_code+'i2')
           >>> native_dt.newbyteorder('S') == swapped_dt
           True
           >>> native_dt.newbyteorder() == swapped_dt
           True
           >>> native_dt == swapped_dt.newbyteorder('S')
           True
           >>> native_dt == swapped_dt.newbyteorder('=')
           True
           >>> native_dt == swapped_dt.newbyteorder('N')
           True
           >>> native_dt == native_dt.newbyteorder('|')
           True
           >>> np.dtype('<i2') == native_dt.newbyteorder('<')
           True
           >>> np.dtype('<i2') == native_dt.newbyteorder('L')
           True
           >>> np.dtype('>i2') == native_dt.newbyteorder('>')
           True
           >>> np.dtype('>i2') == native_dt.newbyteorder('B')
           True
        """
        
        
        return dtype()
    num = None
    shape = None
    str = None
    subdtype = None
    type = None
    

e = 0.0
def ediff1d(ary,to_end,to_begin):
    """   The differences between consecutive elements of an array.
       Parameters
       ----------
       ary : array_like
           If necessary, will be flattened before the differences are taken.
       to_end : array_like, optional
           Number(s) to append at the end of the returned differences.
       to_begin : array_like, optional
           Number(s) to prepend at the beginning of the returned differences.
       Returns
       -------
       ed : ndarray
           The differences. Loosely, this is ``ary.flat[1:] - ary.flat[:-1]``.
       See Also
       --------
       diff, gradient
       Notes
       -----
       When applied to masked arrays, this function drops the mask information
       if the `to_begin` and/or `to_end` parameters are used.
       Examples
       --------
       >>> x = np.array([1, 2, 4, 7, 0])
       >>> np.ediff1d(x)
       array([ 1,  2,  3, -7])
       >>> np.ediff1d(x, to_begin=-99, to_end=np.array([88, 99]))
       array([-99,   1,   2,   3,  -7,  88,  99])
       The returned array is always 1D.
       >>> y = [[1, 2, 4], [1, 6, 24]]
       >>> np.ediff1d(y)
       array([ 1,  2, -3,  5, 18])
       
    """
    
    
    return ndarray()
emath = None
def empty(shape,dtype,order):
    """empty(shape, dtype=float, order='C')
       Return a new array of given shape and type, without initializing entries.
       Parameters
       ----------
       shape : int or tuple of int
           Shape of the empty array
       dtype : data-type, optional
           Desired output data-type.
       order : {'C', 'F'}, optional
           Whether to store multi-dimensional data in C (row-major) or
           Fortran (column-major) order in memory.
       See Also
       --------
       empty_like, zeros, ones
       Notes
       -----
       `empty`, unlike `zeros`, does not set the array values to zero,
       and may therefore be marginally faster.  On the other hand, it requires
       the user to manually set all the values in the array, and should be
       used with caution.
       Examples
       --------
       >>> np.empty([2, 2])
       array([[ -9.74499359e+001,   6.69583040e-309],
              [  2.13182611e-314,   3.06959433e-309]])         #random
       >>> np.empty([2, 2], dtype=int)
       array([[-1073741821, -1067949133],
              [  496041986,    19249760]])                     #random
    """
    
    
    return None
def empty_like(a):
    """   Return a new array with the same shape and type as a given array.
       Parameters
       ----------
       a : array_like
           The shape and data-type of `a` define these same attributes of the
           returned array.
       Returns
       -------
       out : ndarray
           Array of random data with the same shape and type as `a`.
       See Also
       --------
       ones_like : Return an array of ones with shape and type of input.
       zeros_like : Return an array of zeros with shape and type of input.
       empty : Return a new uninitialized array.
       ones : Return a new array setting values to one.
       zeros : Return a new array setting values to zero.
       Notes
       -----
       This function does *not* initialize the returned array; to do that use
       `zeros_like` or `ones_like` instead.  It may be marginally faster than
       the functions that do set the array values.
       Examples
       --------
       >>> a = ([1,2,3], [4,5,6])                         # a is array-like
       >>> np.empty_like(a)
       array([[-1073741821, -1073741821,           3],    #random
              [          0,           0, -1073741821]])
       >>> a = np.array([[1., 2., 3.],[4.,5.,6.]])
       >>> np.empty_like(a)
       array([[ -2.00000715e+000,   1.48219694e-323,  -2.00000572e+000],#random
              [  4.38791518e-305,  -2.00000715e+000,   4.17269252e-309]])
       
    """
    
    
    return ndarray()
def equal(x1,x2):
    """equal(x1, x2[, out])
    Return (x1 == x2) element-wise.
    Parameters
    ----------
    x1, x2 : array_like
       Input arrays of the same shape.
    Returns
    -------
    out : {ndarray, bool}
       Output array of bools, or a single bool if x1 and x2 are scalars.
    See Also
    --------
    not_equal, greater_equal, less_equal, greater, less
    Examples
    --------
    >>> np.equal([0, 1, 3], np.arange(3))
    array([ True,  True, False], dtype=bool)
    What is compared are values, not types. So an int (1) and an array of
    length one can evaluate as True:
    >>> np.equal(1, np.ones(1))
    array([ True], dtype=bool)
    """
    
    
    return ndarray()
class errstate:
    pass

def exp(x):
    """exp(x[, out])
    Calculate the exponential of all elements in the input array.
    Parameters
    ----------
    x : array_like
       Input values.
    Returns
    -------
    out : ndarray
       Output array, element-wise exponential of `x`.
    See Also
    --------
    expm1 : Calculate ``exp(x) - 1`` for all elements in the array.
    exp2  : Calculate ``2**x`` for all elements in the array.
    Notes
    -----
    The irrational number ``e`` is also known as Euler's number.  It is
    approximately 2.718281, and is the base of the natural logarithm,
    ``ln`` (this means that, if :math:`x = \ln y = \log_e y`,
    then :math:`e^x = y`. For real input, ``exp(x)`` is always positive.
    For complex arguments, ``x = a + ib``, we can write
    :math:`e^x = e^a e^{ib}`.  The first term, :math:`e^a`, is already
    known (it is the real argument, described above).  The second term,
    :math:`e^{ib}`, is :math:`\cos b + i \sin b`, a function with magnitude
    1 and a periodic phase.
    References
    ----------
    .. [1] Wikipedia, "Exponential function",
          http://en.wikipedia.org/wiki/Exponential_function
    .. [2] M. Abramovitz and I. A. Stegun, "Handbook of Mathematical Functions
          with Formulas, Graphs, and Mathematical Tables," Dover, 1964, p. 69,
          http://www.math.sfu.ca/~cbm/aands/page_69.htm
    Examples
    --------
    Plot the magnitude and phase of ``exp(x)`` in the complex plane:
    >>> import matplotlib.pyplot as plt
    >>> x = np.linspace(-2*np.pi, 2*np.pi, 100)
    >>> xx = x + 1j * x[:, np.newaxis] # a + ib over complex plane
    >>> out = np.exp(xx)
    >>> plt.subplot(121)
    >>> plt.imshow(np.abs(out),
    ...            extent=[-2*np.pi, 2*np.pi, -2*np.pi, 2*np.pi])
    >>> plt.title('Magnitude of exp(x)')
    >>> plt.subplot(122)
    >>> plt.imshow(np.angle(out),
    ...            extent=[-2*np.pi, 2*np.pi, -2*np.pi, 2*np.pi])
    >>> plt.title('Phase (angle) of exp(x)')
    >>> plt.show()
    """
    
    
    return ndarray()
def exp2(x,out):
    """exp2(x[, out])
    Calculate `2**p` for all `p` in the input array.
    Parameters
    ----------
    x : array_like
       Input values.
    out : ndarray, optional
       Array to insert results into.
    Returns
    -------
    out : ndarray
       Element-wise 2 to the power `x`.
    See Also
    --------
    exp : calculate x**p.
    Notes
    -----
    .. versionadded:: 1.3.0
    Examples
    --------
    >>> np.exp2([2, 3])
    array([ 4.,  8.])
    """
    
    
    return ndarray()
def expand_dims(a,axis):
    """   Expand the shape of an array.
       Insert a new axis, corresponding to a given position in the array shape.
       Parameters
       ----------
       a : array_like
           Input array.
       axis : int
           Position (amongst axes) where new axis is to be inserted.
       Returns
       -------
       res : ndarray
           Output array. The number of dimensions is one greater than that of
           the input array.
       See Also
       --------
       doc.indexing, atleast_1d, atleast_2d, atleast_3d
       Examples
       --------
       >>> x = np.array([1,2])
       >>> x.shape
       (2,)
       The following is equivalent to ``x[np.newaxis,:]`` or ``x[np.newaxis]``:
       >>> y = np.expand_dims(x, axis=0)
       >>> y
       array([[1, 2]])
       >>> y.shape
       (1, 2)
       >>> y = np.expand_dims(x, axis=1)  # Equivalent to x[:,newaxis]
       >>> y
       array([[1],
              [2]])
       >>> y.shape
       (2, 1)
       Note that some examples may use ``None`` instead of ``np.newaxis``.  These
       are the same objects:
       >>> np.newaxis is None
       True
       
    """
    
    
    return ndarray()
def expm1(x):
    """expm1(x[, out])
    Calculate ``exp(x) - 1`` for all elements in the array.
    Parameters
    ----------
    x : array_like
      Input values.
    Returns
    -------
    out : ndarray
       Element-wise exponential minus one: ``out = exp(x) - 1``.
    See Also
    --------
    log1p : ``log(1 + x)``, the inverse of expm1.
    Notes
    -----
    This function provides greater precision than the formula ``exp(x) - 1``
    for small values of ``x``.
    Examples
    --------
    The true value of ``exp(1e-10) - 1`` is ``1.00000000005e-10`` to
    about 32 significant digits. This example shows the superiority of
    expm1 in this case.
    >>> np.expm1(1e-10)
    1.00000000005e-10
    >>> np.exp(1e-10) - 1
    1.000000082740371e-10
    """
    
    
    return ndarray()
def extract(condition,arr):
    """   Return the elements of an array that satisfy some condition.
       This is equivalent to ``np.compress(ravel(condition), ravel(arr))``.  If
       `condition` is boolean ``np.extract`` is equivalent to ``arr[condition]``.
       Parameters
       ----------
       condition : array_like
           An array whose nonzero or True entries indicate the elements of `arr`
           to extract.
       arr : array_like
           Input array of the same size as `condition`.
       See Also
       --------
       take, put, putmask, compress
       Examples
       --------
       >>> arr = np.arange(12).reshape((3, 4))
       >>> arr
       array([[ 0,  1,  2,  3],
              [ 4,  5,  6,  7],
              [ 8,  9, 10, 11]])
       >>> condition = np.mod(arr, 3)==0
       >>> condition
       array([[ True, False, False,  True],
              [False, False,  True, False],
              [False,  True, False, False]], dtype=bool)
       >>> np.extract(condition, arr)
       array([0, 3, 6, 9])
       If `condition` is boolean:
       >>> arr[condition]
       array([0, 3, 6, 9])
       
    """
    
    
    return None
def eye(N,M,k,dtype):
    """   Return a 2-D array with ones on the diagonal and zeros elsewhere.
       Parameters
       ----------
       N : int
         Number of rows in the output.
       M : int, optional
         Number of columns in the output. If None, defaults to `N`.
       k : int, optional
         Index of the diagonal: 0 (the default) refers to the main diagonal,
         a positive value refers to an upper diagonal, and a negative value
         to a lower diagonal.
       dtype : data-type, optional
         Data-type of the returned array.
       Returns
       -------
       I : ndarray of shape (N,M)
         An array where all elements are equal to zero, except for the `k`-th
         diagonal, whose values are equal to one.
       See Also
       --------
       identity : (almost) equivalent function
       diag : diagonal 2-D array from a 1-D array specified by the user.
       Examples
       --------
       >>> np.eye(2, dtype=int)
       array([[1, 0],
              [0, 1]])
       >>> np.eye(3, k=1)
       array([[ 0.,  1.,  0.],
              [ 0.,  0.,  1.],
              [ 0.,  0.,  0.]])
       
    """
    
    
    return ndarray()
def fabs(x,out):
    """fabs(x[, out])
    Compute the absolute values elementwise.
    This function returns the absolute values (positive magnitude) of the data
    in `x`. Complex values are not handled, use `absolute` to find the
    absolute values of complex data.
    Parameters
    ----------
    x : array_like
       The array of numbers for which the absolute values are required. If
       `x` is a scalar, the result `y` will also be a scalar.
    out : ndarray, optional
       Array into which the output is placed. Its type is preserved and it
       must be of the right shape to hold the output. See doc.ufuncs.
    Returns
    -------
    y : {ndarray, scalar}
       The absolute values of `x`, the returned values are always floats.
    See Also
    --------
    absolute : Absolute values including `complex` types.
    Examples
    --------
    >>> np.fabs(-1)
    1.0
    >>> np.fabs([-1.2, 1.2])
    array([ 1.2,  1.2])
    """
    
    
    return ndarray()
def fastCopyAndTranspose(a):
    """_fastCopyAndTranspose(a)
    """
    
    
    return None
fft = None
def fill_diagonal(a,val):
    """   Fill the main diagonal of the given array of any dimensionality.
       For an array `a` with ``a.ndim > 2``, the diagonal is the list of
       locations with indices ``a[i, i, ..., i]`` all identical. This function
       modifies the input array in-place, it does not return a value.
       Parameters
       ----------
       a : array, at least 2-D.
         Array whose diagonal is to be filled, it gets modified in-place.
       val : scalar
         Value to be written on the diagonal, its type must be compatible with
         that of the array a.
       See also
       --------
       diag_indices, diag_indices_from
       Notes
       -----
       .. versionadded:: 1.4.0
       This functionality can be obtained via `diag_indices`, but internally
       this version uses a much faster implementation that never constructs the
       indices and uses simple slicing.
       Examples
       --------
       >>> a = np.zeros((3, 3), int)
       >>> np.fill_diagonal(a, 5)
       >>> a
       array([[5, 0, 0],
              [0, 5, 0],
              [0, 0, 5]])
       The same function can operate on a 4-D array:
       >>> a = np.zeros((3, 3, 3, 3), int)
       >>> np.fill_diagonal(a, 4)
       We only show a few blocks for clarity:
       >>> a[0, 0]
       array([[4, 0, 0],
              [0, 0, 0],
              [0, 0, 0]])
       >>> a[1, 1]
       array([[0, 0, 0],
              [0, 4, 0],
              [0, 0, 0]])
       >>> a[2, 2]
       array([[0, 0, 0],
              [0, 0, 0],
              [0, 0, 4]])
       
    """
    
    
    return None
def find_common_type(array_types,scalar_types):
    """   Determine common type following standard coercion rules.
       Parameters
       ----------
       array_types : sequence
           A list of dtypes or dtype convertible objects representing arrays.
       scalar_types : sequence
           A list of dtypes or dtype convertible objects representing scalars.
       Returns
       -------
       datatype : dtype
           The common data type, which is the maximum of `array_types` ignoring
           `scalar_types`, unless the maximum of `scalar_types` is of a
           different kind (`dtype.kind`). If the kind is not understood, then
           None is returned.
       See Also
       --------
       dtype, common_type, can_cast, mintypecode
       Examples
       --------
       >>> np.find_common_type([], [np.int64, np.float32, np.complex])
       dtype('complex128')
       >>> np.find_common_type([np.int64, np.float32], [])
       dtype('float64')
       The standard casting rules ensure that a scalar cannot up-cast an
       array unless the scalar is of a fundamentally different kind of data
       (i.e. under a different hierarchy in the data type hierarchy) then
       the array:
       >>> np.find_common_type([np.float32], [np.int64, np.float64])
       dtype('float32')
       Complex is of a different type, so it up-casts the float in the
       `array_types` argument:
       >>> np.find_common_type([np.float32], [np.complex])
       dtype('complex128')
       Type specifier strings are convertible to dtypes and can therefore
       be used instead of dtypes:
       >>> np.find_common_type(['f4', 'f4', 'i4'], ['c8'])
       dtype('complex128')
       
    """
    
    
    return dtype()
class finfo:
    pass

def fix(x,y):
    """   Round to nearest integer towards zero.
       Round an array of floats element-wise to nearest integer towards zero.
       The rounded values are returned as floats.
       Parameters
       ----------
       x : array_like
           An array of floats to be rounded
       y : ndarray, optional
           Output array
       Returns
       -------
       out : ndarray of floats
           The array of rounded numbers
       See Also
       --------
       trunc, floor, ceil
       around : Round to given number of decimals
       Examples
       --------
       >>> np.fix(3.14)
       3.0
       >>> np.fix(3)
       3.0
       >>> np.fix([2.1, 2.9, -2.1, -2.9])
       array([ 2.,  2., -2., -2.])
       
    """
    
    
    return ndarray()
class flatiter:
    base = None
    coords = None
    def copy(self,):
        """copy()
           Get a copy of the iterator as a 1-D array.
           Examples
           --------
           >>> x = np.arange(6).reshape(2, 3)
           >>> x
           array([[0, 1, 2],
                  [3, 4, 5]])
           >>> fl = x.flat
           >>> fl.copy()
           array([0, 1, 2, 3, 4, 5])
        """
        
        
        return None
    index = None
    def next(self,):
        """x.next() -> the next value, or raise StopIteration
        """
        
        
        return None
    

def flatnonzero(a):
    """   Return indices that are non-zero in the flattened version of a.
       This is equivalent to a.ravel().nonzero()[0].
       Parameters
       ----------
       a : ndarray
           Input array.
       Returns
       -------
       res : ndarray
           Output array, containing the indices of the elements of `a.ravel()`
           that are non-zero.
       See Also
       --------
       nonzero : Return the indices of the non-zero elements of the input array.
       ravel : Return a 1-D array containing the elements of the input array.
       Examples
       --------
       >>> x = np.arange(-2, 3)
       >>> x
       array([-2, -1,  0,  1,  2])
       >>> np.flatnonzero(x)
       array([0, 1, 3, 4])
       Use the indices of the non-zero elements as an index array to extract
       these elements:
       >>> x.ravel()[np.flatnonzero(x)]
       array([-2, -1,  1,  2])
       
    """
    
    
    return ndarray()
class flexible:
    T = None
    def all(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def any(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmax(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmin(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argsort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def astype(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    base = None
    def byteswap(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def choose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def clip(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def compress(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def conj(self):
        """None"""
        
        
        return None
    def conjugate(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def copy(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumprod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumsum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    data = None
    def diagonal(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    dtype = None
    def dump(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def dumps(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def fill(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    flags = None
    flat = None
    def flatten(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def getfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    imag = None
    def item(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def itemset(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    itemsize = None
    def max(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def mean(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def min(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    nbytes = None
    ndim = None
    def newbyteorder(self,new_order):
        """newbyteorder(new_order='S')
           Return a new `dtype` with a different byte order.
           Changes are also made in all fields and sub-arrays of the data type.
           The `new_order` code can be any from the following:
           * {'<', 'L'} - little endian
           * {'>', 'B'} - big endian
           * {'=', 'N'} - native order
           * 'S' - swap dtype from current to opposite endian
           * {'|', 'I'} - ignore (no change to byte order)
           Parameters
           ----------
           new_order : str, optional
               Byte order to force; a value from the byte order specifications
               above.  The default value ('S') results in swapping the current
               byte order. The code does a case-insensitive check on the first
               letter of `new_order` for the alternatives above.  For example,
               any of 'B' or 'b' or 'biggish' are valid to specify big-endian.
           Returns
           -------
           new_dtype : dtype
               New `dtype` object with the given change to the byte order.
        """
        
        
        return dtype()
    def nonzero(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def prod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ptp(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def put(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ravel(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    real = None
    def repeat(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def reshape(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def resize(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def round(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def searchsorted(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setflags(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    shape = None
    size = None
    def sort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def squeeze(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def std(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    strides = None
    def sum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def swapaxes(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def take(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tofile(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tolist(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tostring(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def trace(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def transpose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def var(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def view(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    

def fliplr(m):
    """   Flip array in the left/right direction.
       Flip the entries in each row in the left/right direction.
       Columns are preserved, but appear in a different order than before.
       Parameters
       ----------
       m : array_like
           Input array.
       Returns
       -------
       f : ndarray
           A view of `m` with the columns reversed.  Since a view
           is returned, this operation is :math:`\mathcal O(1)`.
       See Also
       --------
       flipud : Flip array in the up/down direction.
       rot90 : Rotate array counterclockwise.
       Notes
       -----
       Equivalent to A[:,::-1]. Does not require the array to be
       two-dimensional.
       Examples
       --------
       >>> A = np.diag([1.,2.,3.])
       >>> A
       array([[ 1.,  0.,  0.],
              [ 0.,  2.,  0.],
              [ 0.,  0.,  3.]])
       >>> np.fliplr(A)
       array([[ 0.,  0.,  1.],
              [ 0.,  2.,  0.],
              [ 3.,  0.,  0.]])
       >>> A = np.random.randn(2,3,5)
       >>> np.all(np.fliplr(A)==A[:,::-1,...])
       True
       
    """
    
    
    return ndarray()
def flipud(m):
    """   Flip array in the up/down direction.
       Flip the entries in each column in the up/down direction.
       Rows are preserved, but appear in a different order than before.
       Parameters
       ----------
       m : array_like
           Input array.
       Returns
       -------
       out : array_like
           A view of `m` with the rows reversed.  Since a view is
           returned, this operation is :math:`\mathcal O(1)`.
       See Also
       --------
       fliplr : Flip array in the left/right direction.
       rot90 : Rotate array counterclockwise.
       Notes
       -----
       Equivalent to ``A[::-1,...]``.
       Does not require the array to be two-dimensional.
       Examples
       --------
       >>> A = np.diag([1.0, 2, 3])
       >>> A
       array([[ 1.,  0.,  0.],
              [ 0.,  2.,  0.],
              [ 0.,  0.,  3.]])
       >>> np.flipud(A)
       array([[ 0.,  0.,  3.],
              [ 0.,  2.,  0.],
              [ 1.,  0.,  0.]])
       >>> A = np.random.randn(2,3,5)
       >>> np.all(np.flipud(A)==A[::-1,...])
       True
       >>> np.flipud([1,2])
       array([2, 1])
       
    """
    
    
    return array_like()
class float:
    def as_integer_ratio(self,):
        """float.as_integer_ratio() -> (int, int)
        Returns a pair of integers, whose ratio is exactly equal to the original
        float and with a positive denominator.
        Raises OverflowError on infinities and a ValueError on NaNs.
        >>> (10.0).as_integer_ratio()
        (10, 1)
        >>> (0.0).as_integer_ratio()
        (0, 1)
        >>> (-.25).as_integer_ratio()
        (-1, 4)
        """
        
        
        return None
    def conjugate(self):
        """Returns self, the complex conjugate of any float.
        """
        
        
        return None
    def fromhex(self,string):
        """float.fromhex(string) -> float
        Create a floating-point number from a hexadecimal string.
        >>> float.fromhex('0x1.ffffp10')
        2047.984375
        >>> float.fromhex('-0x1p-1074')
        -4.9406564584124654e-324
        """
        
        
        return None
    def hex(self,):
        """float.hex() -> string
        Return a hexadecimal representation of a floating-point number.
        >>> (-0.1).hex()
        '-0x1.999999999999ap-4'
        >>> 3.14159.hex()
        '0x1.921f9f01b866ep+1'
        """
        
        
        return None
    imag = None
    def is_integer(self):
        """Returns True if the float is an integer.
        """
        
        
        return None
    real = None
    

class float32:
    T = None
    def all(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def any(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmax(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmin(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argsort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def astype(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    base = None
    def byteswap(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def choose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def clip(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def compress(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def conj(self):
        """None"""
        
        
        return None
    def conjugate(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def copy(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumprod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumsum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    data = None
    def diagonal(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    dtype = None
    def dump(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def dumps(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def fill(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    flags = None
    flat = None
    def flatten(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def getfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    imag = None
    def item(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def itemset(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    itemsize = None
    def max(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def mean(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def min(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    nbytes = None
    ndim = None
    def newbyteorder(self,new_order):
        """newbyteorder(new_order='S')
           Return a new `dtype` with a different byte order.
           Changes are also made in all fields and sub-arrays of the data type.
           The `new_order` code can be any from the following:
           * {'<', 'L'} - little endian
           * {'>', 'B'} - big endian
           * {'=', 'N'} - native order
           * 'S' - swap dtype from current to opposite endian
           * {'|', 'I'} - ignore (no change to byte order)
           Parameters
           ----------
           new_order : str, optional
               Byte order to force; a value from the byte order specifications
               above.  The default value ('S') results in swapping the current
               byte order. The code does a case-insensitive check on the first
               letter of `new_order` for the alternatives above.  For example,
               any of 'B' or 'b' or 'biggish' are valid to specify big-endian.
           Returns
           -------
           new_dtype : dtype
               New `dtype` object with the given change to the byte order.
        """
        
        
        return dtype()
    def nonzero(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def prod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ptp(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def put(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ravel(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    real = None
    def repeat(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def reshape(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def resize(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def round(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def searchsorted(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setflags(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    shape = None
    size = None
    def sort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def squeeze(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def std(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    strides = None
    def sum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def swapaxes(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def take(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tofile(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tolist(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tostring(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def trace(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def transpose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def var(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def view(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    

class float64:
    T = None
    def all(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def any(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmax(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmin(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argsort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def as_integer_ratio(self,):
        """float.as_integer_ratio() -> (int, int)
        Returns a pair of integers, whose ratio is exactly equal to the original
        float and with a positive denominator.
        Raises OverflowError on infinities and a ValueError on NaNs.
        >>> (10.0).as_integer_ratio()
        (10, 1)
        >>> (0.0).as_integer_ratio()
        (0, 1)
        >>> (-.25).as_integer_ratio()
        (-1, 4)
        """
        
        
        return None
    def astype(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    base = None
    def byteswap(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def choose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def clip(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def compress(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def conj(self):
        """None"""
        
        
        return None
    def conjugate(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def copy(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumprod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumsum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    data = None
    def diagonal(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    dtype = None
    def dump(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def dumps(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def fill(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    flags = None
    flat = None
    def flatten(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def fromhex(self,string):
        """float.fromhex(string) -> float
        Create a floating-point number from a hexadecimal string.
        >>> float.fromhex('0x1.ffffp10')
        2047.984375
        >>> float.fromhex('-0x1p-1074')
        -4.9406564584124654e-324
        """
        
        
        return None
    def getfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def hex(self,):
        """float.hex() -> string
        Return a hexadecimal representation of a floating-point number.
        >>> (-0.1).hex()
        '-0x1.999999999999ap-4'
        >>> 3.14159.hex()
        '0x1.921f9f01b866ep+1'
        """
        
        
        return None
    imag = None
    def is_integer(self):
        """Returns True if the float is an integer.
        """
        
        
        return None
    def item(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def itemset(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    itemsize = None
    def max(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def mean(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def min(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    nbytes = None
    ndim = None
    def newbyteorder(self,new_order):
        """newbyteorder(new_order='S')
           Return a new `dtype` with a different byte order.
           Changes are also made in all fields and sub-arrays of the data type.
           The `new_order` code can be any from the following:
           * {'<', 'L'} - little endian
           * {'>', 'B'} - big endian
           * {'=', 'N'} - native order
           * 'S' - swap dtype from current to opposite endian
           * {'|', 'I'} - ignore (no change to byte order)
           Parameters
           ----------
           new_order : str, optional
               Byte order to force; a value from the byte order specifications
               above.  The default value ('S') results in swapping the current
               byte order. The code does a case-insensitive check on the first
               letter of `new_order` for the alternatives above.  For example,
               any of 'B' or 'b' or 'biggish' are valid to specify big-endian.
           Returns
           -------
           new_dtype : dtype
               New `dtype` object with the given change to the byte order.
        """
        
        
        return dtype()
    def nonzero(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def prod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ptp(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def put(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ravel(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    real = None
    def repeat(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def reshape(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def resize(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def round(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def searchsorted(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setflags(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    shape = None
    size = None
    def sort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def squeeze(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def std(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    strides = None
    def sum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def swapaxes(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def take(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tofile(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tolist(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tostring(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def trace(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def transpose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def var(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def view(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    

class float96:
    T = None
    def all(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def any(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmax(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmin(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argsort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def astype(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    base = None
    def byteswap(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def choose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def clip(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def compress(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def conj(self):
        """None"""
        
        
        return None
    def conjugate(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def copy(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumprod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumsum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    data = None
    def diagonal(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    dtype = None
    def dump(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def dumps(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def fill(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    flags = None
    flat = None
    def flatten(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def getfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    imag = None
    def item(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def itemset(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    itemsize = None
    def max(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def mean(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def min(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    nbytes = None
    ndim = None
    def newbyteorder(self,new_order):
        """newbyteorder(new_order='S')
           Return a new `dtype` with a different byte order.
           Changes are also made in all fields and sub-arrays of the data type.
           The `new_order` code can be any from the following:
           * {'<', 'L'} - little endian
           * {'>', 'B'} - big endian
           * {'=', 'N'} - native order
           * 'S' - swap dtype from current to opposite endian
           * {'|', 'I'} - ignore (no change to byte order)
           Parameters
           ----------
           new_order : str, optional
               Byte order to force; a value from the byte order specifications
               above.  The default value ('S') results in swapping the current
               byte order. The code does a case-insensitive check on the first
               letter of `new_order` for the alternatives above.  For example,
               any of 'B' or 'b' or 'biggish' are valid to specify big-endian.
           Returns
           -------
           new_dtype : dtype
               New `dtype` object with the given change to the byte order.
        """
        
        
        return dtype()
    def nonzero(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def prod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ptp(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def put(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ravel(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    real = None
    def repeat(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def reshape(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def resize(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def round(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def searchsorted(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setflags(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    shape = None
    size = None
    def sort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def squeeze(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def std(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    strides = None
    def sum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def swapaxes(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def take(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tofile(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tolist(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tostring(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def trace(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def transpose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def var(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def view(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    

class float_:
    T = None
    def all(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def any(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmax(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmin(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argsort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def as_integer_ratio(self,):
        """float.as_integer_ratio() -> (int, int)
        Returns a pair of integers, whose ratio is exactly equal to the original
        float and with a positive denominator.
        Raises OverflowError on infinities and a ValueError on NaNs.
        >>> (10.0).as_integer_ratio()
        (10, 1)
        >>> (0.0).as_integer_ratio()
        (0, 1)
        >>> (-.25).as_integer_ratio()
        (-1, 4)
        """
        
        
        return None
    def astype(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    base = None
    def byteswap(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def choose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def clip(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def compress(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def conj(self):
        """None"""
        
        
        return None
    def conjugate(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def copy(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumprod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumsum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    data = None
    def diagonal(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    dtype = None
    def dump(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def dumps(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def fill(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    flags = None
    flat = None
    def flatten(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def fromhex(self,string):
        """float.fromhex(string) -> float
        Create a floating-point number from a hexadecimal string.
        >>> float.fromhex('0x1.ffffp10')
        2047.984375
        >>> float.fromhex('-0x1p-1074')
        -4.9406564584124654e-324
        """
        
        
        return None
    def getfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def hex(self,):
        """float.hex() -> string
        Return a hexadecimal representation of a floating-point number.
        >>> (-0.1).hex()
        '-0x1.999999999999ap-4'
        >>> 3.14159.hex()
        '0x1.921f9f01b866ep+1'
        """
        
        
        return None
    imag = None
    def is_integer(self):
        """Returns True if the float is an integer.
        """
        
        
        return None
    def item(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def itemset(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    itemsize = None
    def max(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def mean(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def min(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    nbytes = None
    ndim = None
    def newbyteorder(self,new_order):
        """newbyteorder(new_order='S')
           Return a new `dtype` with a different byte order.
           Changes are also made in all fields and sub-arrays of the data type.
           The `new_order` code can be any from the following:
           * {'<', 'L'} - little endian
           * {'>', 'B'} - big endian
           * {'=', 'N'} - native order
           * 'S' - swap dtype from current to opposite endian
           * {'|', 'I'} - ignore (no change to byte order)
           Parameters
           ----------
           new_order : str, optional
               Byte order to force; a value from the byte order specifications
               above.  The default value ('S') results in swapping the current
               byte order. The code does a case-insensitive check on the first
               letter of `new_order` for the alternatives above.  For example,
               any of 'B' or 'b' or 'biggish' are valid to specify big-endian.
           Returns
           -------
           new_dtype : dtype
               New `dtype` object with the given change to the byte order.
        """
        
        
        return dtype()
    def nonzero(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def prod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ptp(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def put(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ravel(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    real = None
    def repeat(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def reshape(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def resize(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def round(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def searchsorted(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setflags(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    shape = None
    size = None
    def sort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def squeeze(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def std(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    strides = None
    def sum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def swapaxes(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def take(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tofile(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tolist(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tostring(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def trace(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def transpose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def var(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def view(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    

class floating:
    T = None
    def all(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def any(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmax(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmin(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argsort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def astype(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    base = None
    def byteswap(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def choose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def clip(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def compress(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def conj(self):
        """None"""
        
        
        return None
    def conjugate(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def copy(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumprod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumsum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    data = None
    def diagonal(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    dtype = None
    def dump(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def dumps(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def fill(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    flags = None
    flat = None
    def flatten(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def getfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    imag = None
    def item(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def itemset(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    itemsize = None
    def max(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def mean(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def min(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    nbytes = None
    ndim = None
    def newbyteorder(self,new_order):
        """newbyteorder(new_order='S')
           Return a new `dtype` with a different byte order.
           Changes are also made in all fields and sub-arrays of the data type.
           The `new_order` code can be any from the following:
           * {'<', 'L'} - little endian
           * {'>', 'B'} - big endian
           * {'=', 'N'} - native order
           * 'S' - swap dtype from current to opposite endian
           * {'|', 'I'} - ignore (no change to byte order)
           Parameters
           ----------
           new_order : str, optional
               Byte order to force; a value from the byte order specifications
               above.  The default value ('S') results in swapping the current
               byte order. The code does a case-insensitive check on the first
               letter of `new_order` for the alternatives above.  For example,
               any of 'B' or 'b' or 'biggish' are valid to specify big-endian.
           Returns
           -------
           new_dtype : dtype
               New `dtype` object with the given change to the byte order.
        """
        
        
        return dtype()
    def nonzero(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def prod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ptp(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def put(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ravel(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    real = None
    def repeat(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def reshape(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def resize(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def round(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def searchsorted(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setflags(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    shape = None
    size = None
    def sort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def squeeze(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def std(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    strides = None
    def sum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def swapaxes(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def take(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tofile(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tolist(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tostring(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def trace(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def transpose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def var(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def view(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    

def floor(x):
    """floor(x[, out])
    Return the floor of the input, element-wise.
    The floor of the scalar `x` is the largest integer `i`, such that
    `i <= x`.  It is often denoted as :math:`\lfloor x \rfloor`.
    Parameters
    ----------
    x : array_like
       Input data.
    Returns
    -------
    y : {ndarray, scalar}
       The floor of each element in `x`.
    See Also
    --------
    ceil, trunc, rint
    Notes
    -----
    Some spreadsheet programs calculate the "floor-towards-zero", in other
    words ``floor(-2.5) == -2``.  NumPy, however, uses the a definition of
    `floor` such that `floor(-2.5) == -3`.
    Examples
    --------
    >>> a = np.array([-1.7, -1.5, -0.2, 0.2, 1.5, 1.7, 2.0])
    >>> np.floor(a)
    array([-2., -2., -1.,  0.,  1.,  1.,  2.])
    """
    
    
    return ndarray()
def floor_divide(x1,x2):
    """floor_divide(x1, x2[, out])
    Return the largest integer smaller or equal to the division of the inputs.
    Parameters
    ----------
    x1 : array_like
       Numerator.
    x2 : array_like
       Denominator.
    Returns
    -------
    y : ndarray
       y = floor(`x1`/`x2`)
    See Also
    --------
    divide : Standard division.
    floor : Round a number to the nearest integer toward minus infinity.
    ceil : Round a number to the nearest integer toward infinity.
    Examples
    --------
    >>> np.floor_divide(7,3)
    2
    >>> np.floor_divide([1., 2., 3., 4.], 2.5)
    array([ 0.,  0.,  1.,  1.])
    """
    
    
    return ndarray()
def fmax(x1,x2):
    """fmax(x1, x2[, out])
    Element-wise maximum of array elements.
    Compare two arrays and returns a new array containing the element-wise
    maxima. If one of the elements being compared is a nan, then the non-nan
    element is returned. If both elements are nans then the first is returned.
    The latter distinction is important for complex nans, which are defined as
    at least one of the real or imaginary parts being a nan. The net effect is
    that nans are ignored when possible.
    Parameters
    ----------
    x1, x2 : array_like
       The arrays holding the elements to be compared. They must have
       the same shape.
    Returns
    -------
    y : {ndarray, scalar}
       The minimum of `x1` and `x2`, element-wise.  Returns scalar if
       both  `x1` and `x2` are scalars.
    See Also
    --------
    fmin :
     element-wise minimum that ignores nans unless both inputs are nans.
    maximum :
     element-wise maximum that propagates nans.
    minimum :
     element-wise minimum that propagates nans.
    Notes
    -----
    .. versionadded:: 1.3.0
    The fmax is equivalent to ``np.where(x1 >= x2, x1, x2)`` when neither
    x1 nor x2 are nans, but it is faster and does proper broadcasting.
    Examples
    --------
    >>> np.fmax([2, 3, 4], [1, 5, 2])
    array([ 2.,  5.,  4.])
    >>> np.fmax(np.eye(2), [0.5, 2])
    array([[ 1. ,  2. ],
          [ 0.5,  2. ]])
    >>> np.fmax([np.nan, 0, np.nan],[0, np.nan, np.nan])
    array([  0.,   0.,  NaN])
    """
    
    
    return ndarray()
def fmin(x1,x2):
    """fmin(x1, x2[, out])
    fmin(x1, x2[, out])
    Element-wise minimum of array elements.
    Compare two arrays and returns a new array containing the element-wise
    minima. If one of the elements being compared is a nan, then the non-nan
    element is returned. If both elements are nans then the first is returned.
    The latter distinction is important for complex nans, which are defined as
    at least one of the real or imaginary parts being a nan. The net effect is
    that nans are ignored when possible.
    Parameters
    ----------
    x1, x2 : array_like
       The arrays holding the elements to be compared. They must have
       the same shape.
    Returns
    -------
    y : {ndarray, scalar}
       The minimum of `x1` and `x2`, element-wise.  Returns scalar if
       both  `x1` and `x2` are scalars.
    See Also
    --------
    fmax :
     element-wise maximum that ignores nans unless both inputs are nans.
    maximum :
     element-wise maximum that propagates nans.
    minimum :
     element-wise minimum that propagates nans.
    Notes
    -----
    .. versionadded:: 1.3.0
    The fmin is equivalent to ``np.where(x1 <= x2, x1, x2)`` when neither
    x1 nor x2 are nans, but it is faster and does proper broadcasting.
    Examples
    --------
    >>> np.fmin([2, 3, 4], [1, 5, 2])
    array([2, 5, 4])
    >>> np.fmin(np.eye(2), [0.5, 2])
    array([[ 1. ,  2. ],
          [ 0.5,  2. ]])
    >>> np.fmin([np.nan, 0, np.nan],[0, np.nan, np.nan])
    array([  0.,   0.,  NaN])
    """
    
    
    return ndarray()
def fmod(x1,x2):
    """fmod(x1, x2[, out])
    Return the element-wise remainder of division.
    This is the NumPy implementation of the Python modulo operator `%`.
    Parameters
    ----------
    x1 : array_like
     Dividend.
    x2 : array_like
     Divisor.
    Returns
    -------
    y : array_like
     The remainder of the division of `x1` by `x2`.
    See Also
    --------
    remainder : Modulo operation where the quotient is `floor(x1/x2)`.
    divide
    Notes
    -----
    The result of the modulo operation for negative dividend and divisors is
    bound by conventions. In `fmod`, the sign of the remainder is the sign of
    the dividend. In `remainder`, the sign of the divisor does not affect the
    sign of the result.
    Examples
    --------
    >>> np.fmod([-3, -2, -1, 1, 2, 3], 2)
    array([-1,  0, -1,  1,  0,  1])
    >>> np.remainder([-3, -2, -1, 1, 2, 3], 2)
    array([1, 0, 1, 1, 0, 1])
    >>> np.fmod([5, 3], [2, 2.])
    array([ 1.,  1.])
    >>> a = np.arange(-3, 3).reshape(3, 2)
    >>> a
    array([[-3, -2],
          [-1,  0],
          [ 1,  2]])
    >>> np.fmod(a, [2,2])
    array([[-1,  0],
          [-1,  0],
          [ 1,  0]])
    """
    
    
    return array_like()
format_parser = format_parser()
def frexp(x,out1,out2):
    """frexp(x[, out1, out2])
    Split the number, x, into a normalized fraction (y1) and exponent (y2)
    """
    
    
    return None
def frombuffer(dtype,count,offset):
    """frombuffer(buffer, dtype=float, count=-1, offset=0)
       Interpret a buffer as a 1-dimensional array.
       Parameters
       ----------
       buffer
           An object that exposes the buffer interface.
       dtype : data-type, optional
           Data type of the returned array.
       count : int, optional
           Number of items to read. ``-1`` means all data in the buffer.
       offset : int, optional
           Start reading the buffer from this offset.
       Notes
       -----
       If the buffer has data that is not in machine byte-order, this
       should be specified as part of the data-type, e.g.::
         >>> dt = np.dtype(int)
         >>> dt = dt.newbyteorder('>')
         >>> np.frombuffer(buf, dtype=dt)
       The data of the resulting array will not be byteswapped,
       but will be interpreted correctly.
       Examples
       --------
       >>> s = 'hello world'
       >>> np.frombuffer(s, dtype='S1', count=5, offset=6)
       array(['w', 'o', 'r', 'l', 'd'],
             dtype='|S1')
    """
    
    
    return None
def fromfile(file,dtype,count,sep):
    """fromfile(file, dtype=float, count=-1, sep='')
       Construct an array from data in a text or binary file.
       A highly efficient way of reading binary data with a known data-type,
       as well as parsing simply formatted text files.  Data written using the
       `tofile` method can be read using this function.
       Parameters
       ----------
       file : file or str
           Open file object or filename.
       dtype : data-type
           Data type of the returned array.
           For binary files, it is used to determine the size and byte-order
           of the items in the file.
       count : int
           Number of items to read. ``-1`` means all items (i.e., the complete
           file).
       sep : str
           Separator between items if file is a text file.
           Empty ("") separator means the file should be treated as binary.
           Spaces (" ") in the separator match zero or more whitespace characters.
           A separator consisting only of spaces must match at least one
           whitespace.
       See also
       --------
       load, save
       ndarray.tofile
       loadtxt : More flexible way of loading data from a text file.
       Notes
       -----
       Do not rely on the combination of `tofile` and `fromfile` for
       data storage, as the binary files generated are are not platform
       independent.  In particular, no byte-order or data-type information is
       saved.  Data can be stored in the platform independent ``.npy`` format
       using `save` and `load` instead.
       Examples
       --------
       Construct an ndarray:
       >>> dt = np.dtype([('time', [('min', int), ('sec', int)]),
       ...                ('temp', float)])
       >>> x = np.zeros((1,), dtype=dt)
       >>> x['time']['min'] = 10; x['temp'] = 98.25
       >>> x
       array([((10, 0), 98.25)],
             dtype=[('time', [('min', '<i4'), ('sec', '<i4')]), ('temp', '<f8')])
       Save the raw data to disk:
       >>> import os
       >>> fname = os.tmpnam()
       >>> x.tofile(fname)
       Read the raw data from disk:
       >>> np.fromfile(fname, dtype=dt)
       array([((10, 0), 98.25)],
             dtype=[('time', [('min', '<i4'), ('sec', '<i4')]), ('temp', '<f8')])
       The recommended way to store and load data:
       >>> np.save(fname, x)
       >>> np.load(fname + '.npy')
       array([((10, 0), 98.25)],
             dtype=[('time', [('min', '<i4'), ('sec', '<i4')]), ('temp', '<f8')])
    """
    
    
    return None
def fromfunction(function,shape,dtype):
    """   Construct an array by executing a function over each coordinate.
       The resulting array therefore has a value ``fn(x, y, z)`` at
       coordinate ``(x, y, z)``.
       Parameters
       ----------
       function : callable
           The function is called with N parameters, each of which
           represents the coordinates of the array varying along a
           specific axis.  For example, if `shape` were ``(2, 2)``, then
           the parameters would be two arrays, ``[[0, 0], [1, 1]]`` and
           ``[[0, 1], [0, 1]]``.  `function` must be capable of operating on
           arrays, and should return a scalar value.
       shape : (N,) tuple of ints
           Shape of the output array, which also determines the shape of
           the coordinate arrays passed to `function`.
       dtype : data-type, optional
           Data-type of the coordinate arrays passed to `function`.
           By default, `dtype` is float.
       Returns
       -------
       out : any
           The result of the call to `function` is passed back directly.
           Therefore the type and shape of `out` is completely determined by
           `function`.
       See Also
       --------
       indices, meshgrid
       Notes
       -----
       Keywords other than `shape` and `dtype` are passed to `function`.
       Examples
       --------
       >>> np.fromfunction(lambda i, j: i == j, (3, 3), dtype=int)
       array([[ True, False, False],
              [False,  True, False],
              [False, False,  True]], dtype=bool)
       >>> np.fromfunction(lambda i, j: i + j, (3, 3), dtype=int)
       array([[0, 1, 2],
              [1, 2, 3],
              [2, 3, 4]])
       
    """
    
    
    return any()
def fromiter(iterable,dtype,count):
    """fromiter(iterable, dtype, count=-1)
       Create a new 1-dimensional array from an iterable object.
       Parameters
       ----------
       iterable : iterable object
           An iterable object providing data for the array.
       dtype : data-type
           The data type of the returned array.
       count : int, optional
           The number of items to read from iterable. The default is -1,
           which means all data is read.
       Returns
       -------
       out : ndarray
           The output array.
       Notes
       -----
       Specify ``count`` to improve performance.  It allows
       ``fromiter`` to pre-allocate the output array, instead of
       resizing it on demand.
       Examples
       --------
       >>> iterable = (x*x for x in range(5))
       >>> np.fromiter(iterable, np.float)
       array([  0.,   1.,   4.,   9.,  16.])
    """
    
    
    return ndarray()
def frompyfunc(func,nin,nout):
    """frompyfunc(func, nin, nout)
       Takes an arbitrary Python function and returns a Numpy ufunc.
       Can be used, for example, to add broadcasting to a built-in Python
       function (see Examples section).
       Parameters
       ----------
       func : Python function object
           An arbitrary Python function.
       nin : int
           The number of input arguments.
       nout : int
           The number of objects returned by `func`.
       Returns
       -------
       out : ufunc
           Returns a Numpy universal function (``ufunc``) object.
       Notes
       -----
       The returned ufunc always returns PyObject arrays.
       Examples
       --------
       Use frompyfunc to add broadcasting to the Python function ``oct``:
       >>> oct_array = np.frompyfunc(oct, 1, 1)
       >>> oct_array(np.array((10, 30, 100)))
       array([012, 036, 0144], dtype=object)
       >>> np.array((oct(10), oct(30), oct(100))) # for comparison
       array(['012', '036', '0144'],
             dtype='|S4')
    """
    
    
    return ufunc()
def fromregex(file,regexp,dtype):
    """   Construct an array from a text file, using regular expression parsing.
       The returned array is always a structured array, and is constructed from
       all matches of the regular expression in the file. Groups in the regular
       expression are converted to fields of the structured array.
       Parameters
       ----------
       file : str or file
           File name or file object to read.
       regexp : str or regexp
           Regular expression used to parse the file.
           Groups in the regular expression correspond to fields in the dtype.
       dtype : dtype or list of dtypes
           Dtype for the structured array.
       Returns
       -------
       output : ndarray
           The output array, containing the part of the content of `file` that
           was matched by `regexp`. `output` is always a structured array.
       Raises
       ------
       TypeError
           When `dtype` is not a valid dtype for a structured array.
       See Also
       --------
       fromstring, loadtxt
       Notes
       -----
       Dtypes for structured arrays can be specified in several forms, but all
       forms specify at least the data type and field name. For details see
       `doc.structured_arrays`.
       Examples
       --------
       >>> f = open('test.dat', 'w')
       >>> f.write("1312 foo\n1534  bar\n444   qux")
       >>> f.close()
       >>> regexp = r"(\d+)\s+(...)"  # match [digits, whitespace, anything]
       >>> output = np.fromregex('test.dat', regexp,
       ...                       [('num', np.int64), ('key', 'S3')])
       >>> output
       array([(1312L, 'foo'), (1534L, 'bar'), (444L, 'qux')],
             dtype=[('num', '<i8'), ('key', '|S3')])
       >>> output['num']
       array([1312, 1534,  444], dtype=int64)
       
    """
    
    
    return ndarray()
def fromstring(string,dtype,count,sep):
    """fromstring(string, dtype=float, count=-1, sep='')
       Return a new 1-D array initialized from raw binary or text data in string.
       Parameters
       ----------
       string : str
           A string containing the data.
       dtype : dtype, optional
           The data type of the array. For binary input data, the data must be
           in exactly this format.
       count : int, optional
           Read this number of `dtype` elements from the data. If this is
           negative, then the size will be determined from the length of the
           data.
       sep : str, optional
           If provided and not empty, then the data will be interpreted as
           ASCII text with decimal numbers. This argument is interpreted as the
           string separating numbers in the data. Extra whitespace between
           elements is also ignored.
       Returns
       -------
       arr : array
           The constructed array.
       Raises
       ------
       ValueError
           If the string is not the correct size to satisfy the requested
           `dtype` and `count`.
       Examples
       --------
       >>> np.fromstring('\x01\x02', dtype=np.uint8)
       array([1, 2], dtype=uint8)
       >>> np.fromstring('1 2', dtype=int, sep=' ')
       array([1, 2])
       >>> np.fromstring('1, 2', dtype=int, sep=',')
       array([1, 2])
       >>> np.fromstring('\x01\x02\x03\x04\x05', dtype=np.uint8, count=3)
       array([1, 2, 3], dtype=uint8)
       Invalid inputs:
       >>> np.fromstring('\x01\x02\x03\x04\x05', dtype=np.int32)
       Traceback (most recent call last):
         File "<stdin>", line 1, in <module>
       ValueError: string size must be a multiple of element size
       >>> np.fromstring('\x01\x02', dtype=np.uint8, count=3)
       Traceback (most recent call last):
         File "<stdin>", line 1, in <module>
       ValueError: string is smaller than requested size
    """
    
    
    return array()
def fv(rate,nper,pmt,pv,when):
    """   Compute the future value.
       Given:
        * a present value, `pv`
        * an interest `rate` compounded once per period, of which
          there are
        * `nper` total
        * a (fixed) payment, `pmt`, paid either
        * at the beginning (`when` = {'begin', 1}) or the end
          (`when` = {'end', 0}) of each period
       Return:
          the value at the end of the `nper` periods
       Parameters
       ----------
       rate : scalar or array_like of shape(M, )
           Rate of interest as decimal (not per cent) per period
       nper : scalar or array_like of shape(M, )
           Number of compounding periods
       pmt : scalar or array_like of shape(M, )
           Payment
       pv : scalar or array_like of shape(M, )
           Present value
       when : {{'begin', 1}, {'end', 0}}, {string, int}, optional
           When payments are due ('begin' (1) or 'end' (0)).
           Defaults to {'end', 0}.
       Returns
       -------
       out : ndarray
           Future values.  If all input is scalar, returns a scalar float.  If
           any input is array_like, returns future values for each input element.
           If multiple inputs are array_like, they all must have the same shape.
       Notes
       -----
       The future value is computed by solving the equation::
        fv +
        pv*(1+rate)**nper +
        pmt*(1 + rate*when)/rate*((1 + rate)**nper - 1) == 0
       or, when ``rate == 0``::
        fv + pv + pmt * nper == 0
       References
       ----------
       .. [WRW] Wheeler, D. A., E. Rathke, and R. Weir (Eds.) (2009, May).
          Open Document Format for Office Applications (OpenDocument)v1.2,
          Part 2: Recalculated Formula (OpenFormula) Format - Annotated Version,
          Pre-Draft 12. Organization for the Advancement of Structured Information
          Standards (OASIS). Billerica, MA, USA. [ODT Document].
          Available:
          http://www.oasis-open.org/committees/documents.php?wg_abbrev=office-formula
          OpenDocument-formula-20090508.odt
       Examples
       --------
       What is the future value after 10 years of saving $100 now, with
       an additional monthly savings of $100.  Assume the interest rate is
       5% (annually) compounded monthly?
       >>> np.fv(0.05/12, 10*12, -100, -100)
       15692.928894335748
       By convention, the negative sign represents cash flow out (i.e. money not
       available today).  Thus, saving $100 a month at 5% annual interest leads
       to $15,692.93 available to spend in 10 years.
       If any input is array_like, returns an array of equal shape.  Let's
       compare different interest rates from the example above.
       >>> a = np.array((0.05, 0.06, 0.07))/12
       >>> np.fv(a, 10*12, -100, -100)
       array([ 15692.92889434,  16569.87435405,  17509.44688102])
       
    """
    
    
    return ndarray()
class generic:
    T = None
    def all(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def any(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmax(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmin(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argsort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def astype(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    base = None
    def byteswap(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def choose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def clip(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def compress(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def conj(self):
        """None"""
        
        
        return None
    def conjugate(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def copy(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumprod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumsum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    data = None
    def diagonal(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    dtype = None
    def dump(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def dumps(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def fill(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    flags = None
    flat = None
    def flatten(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def getfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    imag = None
    def item(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def itemset(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    itemsize = None
    def max(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def mean(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def min(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    nbytes = None
    ndim = None
    def newbyteorder(self,new_order):
        """newbyteorder(new_order='S')
           Return a new `dtype` with a different byte order.
           Changes are also made in all fields and sub-arrays of the data type.
           The `new_order` code can be any from the following:
           * {'<', 'L'} - little endian
           * {'>', 'B'} - big endian
           * {'=', 'N'} - native order
           * 'S' - swap dtype from current to opposite endian
           * {'|', 'I'} - ignore (no change to byte order)
           Parameters
           ----------
           new_order : str, optional
               Byte order to force; a value from the byte order specifications
               above.  The default value ('S') results in swapping the current
               byte order. The code does a case-insensitive check on the first
               letter of `new_order` for the alternatives above.  For example,
               any of 'B' or 'b' or 'biggish' are valid to specify big-endian.
           Returns
           -------
           new_dtype : dtype
               New `dtype` object with the given change to the byte order.
        """
        
        
        return dtype()
    def nonzero(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def prod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ptp(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def put(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ravel(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    real = None
    def repeat(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def reshape(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def resize(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def round(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def searchsorted(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setflags(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    shape = None
    size = None
    def sort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def squeeze(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def std(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    strides = None
    def sum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def swapaxes(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def take(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tofile(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tolist(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tostring(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def trace(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def transpose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def var(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def view(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    

def genfromtxt(fname,dtype,comments,delimiter,skip_header,skip_footer,converters,missing_values,filling_values,usecols,names,excludelist,deletechars,defaultfmt,autostrip,replace_space,case_sensitive,unpack,usemask,invalid_raise):
    """   Load data from a text file, with missing values handled as specified.
       Each line past the first `skiprows` lines is split at the `delimiter`
       character, and characters following the `comments` character are discarded.
       Parameters
       ----------
       fname : file or str
           File or filename to read.  If the filename extension is `.gz` or
           `.bz2`, the file is first decompressed.
       dtype : dtype, optional
           Data type of the resulting array.
           If None, the dtypes will be determined by the contents of each
           column, individually.
       comments : str, optional
           The character used to indicate the start of a comment.
           All the characters occurring on a line after a comment are discarded
       delimiter : str, int, or sequence, optional
           The string used to separate values.  By default, any consecutive
           whitespaces act as delimiter.  An integer or sequence of integers
           can also be provided as width(s) of each field.
       skip_header : int, optional
           The numbers of lines to skip at the beginning of the file.
       skip_footer : int, optional
           The numbers of lines to skip at the end of the file
       converters : variable or None, optional
           The set of functions that convert the data of a column to a value.
           The converters can also be used to provide a default value
           for missing data: ``converters = {3: lambda s: float(s or 0)}``.
       missing_values : variable or None, optional
           The set of strings corresponding to missing data.
       filling_values : variable or None, optional
           The set of values to be used as default when the data are missing.
       usecols : sequence or None, optional
           Which columns to read, with 0 being the first.  For example,
           ``usecols = (1, 4, 5)`` will extract the 2nd, 5th and 6th columns.
       names : {None, True, str, sequence}, optional
           If `names` is True, the field names are read from the first valid line
           after the first `skiprows` lines.
           If `names` is a sequence or a single-string of comma-separated names,
           the names will be used to define the field names in a structured dtype.
           If `names` is None, the names of the dtype fields will be used, if any.
       excludelist : sequence, optional
           A list of names to exclude. This list is appended to the default list
           ['return','file','print']. Excluded names are appended an underscore:
           for example, `file` would become `file_`.
       deletechars : str, optional
           A string combining invalid characters that must be deleted from the
           names.
       defaultfmt : str, optional
           A format used to define default field names, such as "f%i" or "f_%02i".
       autostrip : bool, optional
           Whether to automatically strip white spaces from the variables.
       replace_space : char, optional
           Character(s) used in replacement of white spaces in the variables names.
           By default, use a '_'.
       case_sensitive : {True, False, 'upper', 'lower'}, optional
           If True, field names are case sensitive.
           If False or 'upper', field names are converted to upper case.
           If 'lower', field names are converted to lower case.
       unpack : bool, optional
           If True, the returned array is transposed, so that arguments may be
           unpacked using ``x, y, z = loadtxt(...)``
       usemask : bool, optional
           If True, return a masked array.
           If False, return a regular array.
       invalid_raise : bool, optional
           If True, an exception is raised if an inconsistency is detected in the
           number of columns.
           If False, a warning is emitted and the offending lines are skipped.
       Returns
       -------
       out : ndarray
           Data read from the text file. If `usemask` is True, this is a
           masked array.
       See Also
       --------
       numpy.loadtxt : equivalent function when no data is missing.
       Notes
       -----
       * When spaces are used as delimiters, or when no delimiter has been given
         as input, there should not be any missing data between two fields.
       * When the variables are named (either by a flexible dtype or with `names`,
         there must not be any header in the file (else a ValueError
         exception is raised).
       * Individual values are not stripped of spaces by default.
         When using a custom converter, make sure the function does remove spaces.
       Examples
       ---------
       >>> from StringIO import StringIO
       >>> import numpy as np
       Comma delimited file with mixed dtype
       >>> s = StringIO("1,1.3,abcde")
       >>> data = np.genfromtxt(s, dtype=[('myint','i8'),('myfloat','f8'),
       ... ('mystring','S5')], delimiter=",")
       >>> data
       array((1, 1.3, 'abcde'),
             dtype=[('myint', '<i8'), ('myfloat', '<f8'), ('mystring', '|S5')])
       Using dtype = None
       >>> s.seek(0) # needed for StringIO example only
       >>> data = np.genfromtxt(s, dtype=None,
       ... names = ['myint','myfloat','mystring'], delimiter=",")
       >>> data
       array((1, 1.3, 'abcde'),
             dtype=[('myint', '<i8'), ('myfloat', '<f8'), ('mystring', '|S5')])
       Specifying dtype and names
       >>> s.seek(0)
       >>> data = np.genfromtxt(s, dtype="i8,f8,S5",
       ... names=['myint','myfloat','mystring'], delimiter=",")
       >>> data
       array((1, 1.3, 'abcde'),
             dtype=[('myint', '<i8'), ('myfloat', '<f8'), ('mystring', '|S5')])
       An example with fixed-width columns
       >>> s = StringIO("11.3abcde")
       >>> data = np.genfromtxt(s, dtype=None, names=['intvar','fltvar','strvar'],
       ...     delimiter=[1,3,5])
       >>> data
       array((1, 1.3, 'abcde'),
             dtype=[('intvar', '<i8'), ('fltvar', '<f8'), ('strvar', '|S5')])
       
    """
    
    
    return ndarray()
def get_array_wrap():
    """Find the wrapper for the array with the highest priority.
       In case of ties, leftmost wins. If no wrapper is found, return None
       
    """
    
    
    return None
def get_include():
    """   Return the directory that contains the NumPy \*.h header files.
       Extension modules that need to compile against NumPy should use this
       function to locate the appropriate include directory.
       Notes
       -----
       When using ``distutils``, for example in ``setup.py``.
       ::
           import numpy as np
           ...
           Extension('extension_name', ...
                   include_dirs=[np.get_include()])
           ...
       
    """
    
    
    return None
def get_numarray_include(type):
    """   Return the directory that contains the numarray \*.h header files.
       Extension modules that need to compile against numarray should use this
       function to locate the appropriate include directory.
       Parameters
       ----------
       type : any, optional
           If `type` is not None, the location of the NumPy headers is returned
           as well.
       Returns
       -------
       dirs : str or list of str
           If `type` is None, `dirs` is a string containing the path to the
           numarray headers.
           If `type` is not None, `dirs` is a list of strings with first the
           path(s) to the numarray headers, followed by the path to the NumPy
           headers.
       Notes
       -----
       Useful when using ``distutils``, for example in ``setup.py``.
       ::
           import numpy as np
           ...
           Extension('extension_name', ...
                   include_dirs=[np.get_numarray_include()])
           ...
       
    """
    
    
    return str()
def get_numpy_include():
    """`get_numpy_include` is deprecated, use `get_include` instead!
       Return the directory that contains the NumPy \*.h header files.
       Extension modules that need to compile against NumPy should use this
       function to locate the appropriate include directory.
       Notes
       -----
       When using ``distutils``, for example in ``setup.py``.
       ::
           import numpy as np
           ...
           Extension('extension_name', ...
                   include_dirs=[np.get_include()])
           ...
       
    """
    
    
    return None
def get_printoptions():
    """   Return the current print options.
       Returns
       -------
       print_opts : dict
           Dictionary of current print options with keys
             - precision : int
             - threshold : int
             - edgeitems : int
             - linewidth : int
             - suppress : bool
             - nanstr : str
             - infstr : str
           For a full description of these options, see `set_printoptions`.
       See Also
       --------
       set_printoptions, set_string_function
       
    """
    
    
    return None
def getbuffer(obj,offset,size):
    """getbuffer(obj [,offset[, size]])
       Create a buffer object from the given object referencing a slice of
       length size starting at offset.
       Default is the entire buffer. A read-write buffer is attempted followed
       by a read-only buffer.
       Parameters
       ----------
       obj : object
       offset : int, optional
       size : int, optional
       Returns
       -------
       buffer_obj : buffer
       Examples
       --------
       >>> buf = np.getbuffer(np.ones(5), 1, 3)
       >>> len(buf)
       3
       >>> buf[0]
       '\x00'
       >>> buf
       <read-write buffer for 0x8af1e70, size 3, offset 1 at 0x8ba4ec0>
    """
    
    
    return buffer()
def getbufsize():
    """Return the size of the buffer used in ufuncs.
       
    """
    
    
    return None
def geterr():
    """   Get the current way of handling floating-point errors.
       Returns
       -------
       res : dict
           A dictionary with keys "divide", "over", "under", and "invalid",
           whose values are from the strings "ignore", "print", "log", "warn",
           "raise", and "call". The keys represent possible floating-point
           exceptions, and the values define how these exceptions are handled.
       See Also
       --------
       geterrcall, seterr, seterrcall
       Notes
       -----
       For complete documentation of the types of floating-point exceptions and
       treatment options, see `seterr`.
       Examples
       --------
       >>> np.geterr()  # default is all set to 'ignore'
       {'over': 'ignore', 'divide': 'ignore', 'invalid': 'ignore',
       'under': 'ignore'}
       >>> np.arange(3.) / np.arange(3.)
       array([ NaN,   1.,   1.])
       >>> oldsettings = np.seterr(all='warn', over='raise')
       >>> np.geterr()
       {'over': 'raise', 'divide': 'warn', 'invalid': 'warn', 'under': 'warn'}
       >>> np.arange(3.) / np.arange(3.)
       __main__:1: RuntimeWarning: invalid value encountered in divide
       array([ NaN,   1.,   1.])
       
    """
    
    
    return None
def geterrcall():
    """   Return the current callback function used on floating-point errors.
       When the error handling for a floating-point error (one of "divide",
       "over", "under", or "invalid") is set to 'call' or 'log', the function
       that is called or the log instance that is written to is returned by
       `geterrcall`. This function or log instance has been set with
       `seterrcall`.
       Returns
       -------
       errobj : callable, log instance or None
           The current error handler. If no handler was set through `seterrcall`,
           ``None`` is returned.
       See Also
       --------
       seterrcall, seterr, geterr
       Notes
       -----
       For complete documentation of the types of floating-point exceptions and
       treatment options, see `seterr`.
       Examples
       --------
       >>> np.geterrcall()  # we did not yet set a handler, returns None
       >>> oldsettings = np.seterr(all='call')
       >>> def err_handler(type, flag):
       ...     print "Floating point error (%s), with flag %s" % (type, flag)
       >>> oldhandler = np.seterrcall(err_handler)
       >>> np.array([1, 2, 3]) / 0.0
       Floating point error (divide by zero), with flag 1
       array([ Inf,  Inf,  Inf])
       >>> cur_handler = np.geterrcall()
       >>> cur_handler is err_handler
       True
       
    """
    
    
    return None
def geterrobj():
    """geterrobj()
       Return the current object that defines floating-point error handling.
       The error object contains all information that defines the error handling
       behavior in Numpy. `geterrobj` is used internally by the other
       functions that get and set error handling behavior (`geterr`, `seterr`,
       `geterrcall`, `seterrcall`).
       Returns
       -------
       errobj : list
           The error object, a list containing three elements:
           [internal numpy buffer size, error mask, error callback function].
           The error mask is a single integer that holds the treatment information
           on all four floating point errors. The information for each error type
           is contained in three bits of the integer. If we print it in base 8, we
           can see what treatment is set for "invalid", "under", "over", and
           "divide" (in that order). The printed string can be interpreted with
           * 0 : 'ignore'
           * 1 : 'warn'
           * 2 : 'raise'
           * 3 : 'call'
           * 4 : 'print'
           * 5 : 'log'
       See Also
       --------
       seterrobj, seterr, geterr, seterrcall, geterrcall
       getbufsize, setbufsize
       Notes
       -----
       For complete documentation of the types of floating-point exceptions and
       treatment options, see `seterr`.
       Examples
       --------
       >>> np.geterrobj()  # first get the defaults
       [10000, 0, None]
       >>> def err_handler(type, flag):
       ...     print "Floating point error (%s), with flag %s" % (type, flag)
       ...
       >>> old_bufsize = np.setbufsize(20000)
       >>> old_err = np.seterr(divide='raise')
       >>> old_handler = np.seterrcall(err_handler)
       >>> np.geterrobj()
       [20000, 2, <function err_handler at 0x91dcaac>]
       >>> old_err = np.seterr(all='ignore')
       >>> np.base_repr(np.geterrobj()[1], 8)
       '0'
       >>> old_err = np.seterr(divide='warn', over='log', under='call',
                               invalid='print')
       >>> np.base_repr(np.geterrobj()[1], 8)
       '4351'
    """
    
    
    return None
def gradient(f,varargs):
    """   Return the gradient of an N-dimensional array.
       The gradient is computed using central differences in the interior
       and first differences at the boundaries. The returned gradient hence has
       the same shape as the input array.
       Parameters
       ----------
       f : array_like
         An N-dimensional array containing samples of a scalar function.
       `*varargs` : scalars
         0, 1, or N scalars specifying the sample distances in each direction,
         that is: `dx`, `dy`, `dz`, ... The default distance is 1.
       Returns
       -------
       g : ndarray
         N arrays of the same shape as `f` giving the derivative of `f` with
         respect to each dimension.
       Examples
       --------
       >>> x = np.array([1, 2, 4, 7, 11, 16], dtype=np.float)
       >>> np.gradient(x)
       array([ 1. ,  1.5,  2.5,  3.5,  4.5,  5. ])
       >>> np.gradient(x, 2)
       array([ 0.5 ,  0.75,  1.25,  1.75,  2.25,  2.5 ])
       >>> np.gradient(np.array([[1, 2, 6], [3, 4, 5]], dtype=np.float))
       [array([[ 2.,  2., -1.],
              [ 2.,  2., -1.]]),
       array([[ 1. ,  2.5,  4. ],
              [ 1. ,  1. ,  1. ]])]
       
    """
    
    
    return ndarray()
def greater(x1,x2):
    """greater(x1, x2[, out])
    Return the truth value of (x1 > x2) element-wise.
    Parameters
    ----------
    x1, x2 : array_like
       Input arrays.  If ``x1.shape != x2.shape``, they must be
       broadcastable to a common shape (which may be the shape of one or
       the other).
    Returns
    -------
    out : bool or ndarray of bool
       Array of bools, or a single bool if `x1` and `x2` are scalars.
    See Also
    --------
    greater_equal, less, less_equal, equal, not_equal
    Examples
    --------
    >>> np.greater([4,2],[2,2])
    array([ True, False], dtype=bool)
    If the inputs are ndarrays, then np.greater is equivalent to '>'.
    >>> a = np.array([4,2])
    >>> b = np.array([2,2])
    >>> a > b
    array([ True, False], dtype=bool)
    """
    
    
    return bool()
def greater_equal(x1,x2):
    """greater_equal(x1, x2[, out])
    Return the truth value of (x1 >= x2) element-wise.
    Parameters
    ----------
    x1, x2 : array_like
       Input arrays.  If ``x1.shape != x2.shape``, they must be
       broadcastable to a common shape (which may be the shape of one or
       the other).
    Returns
    -------
    out : bool or ndarray of bool
       Array of bools, or a single bool if `x1` and `x2` are scalars.
    See Also
    --------
    greater, less, less_equal, equal, not_equal
    Examples
    --------
    >>> np.greater_equal([4, 2, 1], [2, 2, 2])
    array([ True, True, False], dtype=bool)
    """
    
    
    return bool()
def hamming(M):
    """   Return the Hamming window.
       The Hamming window is a taper formed by using a weighted cosine.
       Parameters
       ----------
       M : int
           Number of points in the output window. If zero or less, an
           empty array is returned.
       Returns
       -------
       out : ndarray
           The window, normalized to one (the value one
           appears only if the number of samples is odd).
       See Also
       --------
       bartlett, blackman, hanning, kaiser
       Notes
       -----
       The Hamming window is defined as
       .. math::  w(n) = 0.54 + 0.46cos\left(\frac{2\pi{n}}{M-1}\right)
                  \qquad 0 \leq n \leq M-1
       The Hamming was named for R. W. Hamming, an associate of J. W. Tukey and
       is described in Blackman and Tukey. It was recommended for smoothing the
       truncated autocovariance function in the time domain.
       Most references to the Hamming window come from the signal processing
       literature, where it is used as one of many windowing functions for
       smoothing values.  It is also known as an apodization (which means
       "removing the foot", i.e. smoothing discontinuities at the beginning
       and end of the sampled signal) or tapering function.
       References
       ----------
       .. [1] Blackman, R.B. and Tukey, J.W., (1958) The measurement of power
              spectra, Dover Publications, New York.
       .. [2] E.R. Kanasewich, "Time Sequence Analysis in Geophysics", The
              University of Alberta Press, 1975, pp. 109-110.
       .. [3] Wikipedia, "Window function",
              http://en.wikipedia.org/wiki/Window_function
       .. [4] W.H. Press,  B.P. Flannery, S.A. Teukolsky, and W.T. Vetterling,
              "Numerical Recipes", Cambridge University Press, 1986, page 425.
       Examples
       --------
       >>> np.hamming(12)
       array([ 0.08      ,  0.15302337,  0.34890909,  0.60546483,  0.84123594,
               0.98136677,  0.98136677,  0.84123594,  0.60546483,  0.34890909,
               0.15302337,  0.08      ])
       Plot the window and the frequency response:
       >>> from numpy.fft import fft, fftshift
       >>> import matplotlib.pyplot as plt
       >>> window = np.hamming(51)
       >>> plt.plot(window)
       [<matplotlib.lines.Line2D object at 0x...>]
       >>> plt.title("Hamming window")
       <matplotlib.text.Text object at 0x...>
       >>> plt.ylabel("Amplitude")
       <matplotlib.text.Text object at 0x...>
       >>> plt.xlabel("Sample")
       <matplotlib.text.Text object at 0x...>
       >>> plt.show()
       >>> plt.figure()
       <matplotlib.figure.Figure object at 0x...>
       >>> A = fft(window, 2048) / 25.5
       >>> mag = np.abs(fftshift(A))
       >>> freq = np.linspace(-0.5, 0.5, len(A))
       >>> response = 20 * np.log10(mag)
       >>> response = np.clip(response, -100, 100)
       >>> plt.plot(freq, response)
       [<matplotlib.lines.Line2D object at 0x...>]
       >>> plt.title("Frequency response of Hamming window")
       <matplotlib.text.Text object at 0x...>
       >>> plt.ylabel("Magnitude [dB]")
       <matplotlib.text.Text object at 0x...>
       >>> plt.xlabel("Normalized frequency [cycles per sample]")
       <matplotlib.text.Text object at 0x...>
       >>> plt.axis('tight')
       (-0.5, 0.5, -100.0, ...)
       >>> plt.show()
       
    """
    
    
    return ndarray()
def hanning(M):
    """   Return the Hanning window.
       The Hanning window is a taper formed by using a weighted cosine.
       Parameters
       ----------
       M : int
           Number of points in the output window. If zero or less, an
           empty array is returned.
       Returns
       -------
       out : ndarray, shape(M,)
           The window, normalized to one (the value one
           appears only if `M` is odd).
       See Also
       --------
       bartlett, blackman, hamming, kaiser
       Notes
       -----
       The Hanning window is defined as
       .. math::  w(n) = 0.5 - 0.5cos\left(\frac{2\pi{n}}{M-1}\right)
                  \qquad 0 \leq n \leq M-1
       The Hanning was named for Julius van Hann, an Austrian meterologist. It is
       also known as the Cosine Bell. Some authors prefer that it be called a
       Hann window, to help avoid confusion with the very similar Hamming window.
       Most references to the Hanning window come from the signal processing
       literature, where it is used as one of many windowing functions for
       smoothing values.  It is also known as an apodization (which means
       "removing the foot", i.e. smoothing discontinuities at the beginning
       and end of the sampled signal) or tapering function.
       References
       ----------
       .. [1] Blackman, R.B. and Tukey, J.W., (1958) The measurement of power
              spectra, Dover Publications, New York.
       .. [2] E.R. Kanasewich, "Time Sequence Analysis in Geophysics",
              The University of Alberta Press, 1975, pp. 106-108.
       .. [3] Wikipedia, "Window function",
              http://en.wikipedia.org/wiki/Window_function
       .. [4] W.H. Press,  B.P. Flannery, S.A. Teukolsky, and W.T. Vetterling,
              "Numerical Recipes", Cambridge University Press, 1986, page 425.
       Examples
       --------
       >>> from numpy import hanning
       >>> hanning(12)
       array([ 0.        ,  0.07937323,  0.29229249,  0.57115742,  0.82743037,
               0.97974649,  0.97974649,  0.82743037,  0.57115742,  0.29229249,
               0.07937323,  0.        ])
       Plot the window and its frequency response:
       >>> from numpy.fft import fft, fftshift
       >>> import matplotlib.pyplot as plt
       >>> window = np.hanning(51)
       >>> plt.plot(window)
       [<matplotlib.lines.Line2D object at 0x...>]
       >>> plt.title("Hann window")
       <matplotlib.text.Text object at 0x...>
       >>> plt.ylabel("Amplitude")
       <matplotlib.text.Text object at 0x...>
       >>> plt.xlabel("Sample")
       <matplotlib.text.Text object at 0x...>
       >>> plt.show()
       >>> plt.figure()
       <matplotlib.figure.Figure object at 0x...>
       >>> A = fft(window, 2048) / 25.5
       >>> mag = abs(fftshift(A))
       >>> freq = np.linspace(-0.5,0.5,len(A))
       >>> response = 20*np.log10(mag)
       >>> response = np.clip(response,-100,100)
       >>> plt.plot(freq, response)
       [<matplotlib.lines.Line2D object at 0x...>]
       >>> plt.title("Frequency response of the Hann window")
       <matplotlib.text.Text object at 0x...>
       >>> plt.ylabel("Magnitude [dB]")
       <matplotlib.text.Text object at 0x...>
       >>> plt.xlabel("Normalized frequency [cycles per sample]")
       <matplotlib.text.Text object at 0x...>
       >>> plt.axis('tight')
       (-0.5, 0.5, -100.0, ...)
       >>> plt.show()
       
    """
    
    
    return ndarray()
def histogram(a,bins,range,normed,weights):
    """   Compute the histogram of a set of data.
       Parameters
       ----------
       a : array_like
           Input data. The histogram is computed over the flattened array.
       bins : int or sequence of scalars, optional
           If `bins` is an int, it defines the number of equal-width
           bins in the given range (10, by default). If `bins` is a sequence,
           it defines the bin edges, including the rightmost edge, allowing
           for non-uniform bin widths.
       range : (float, float), optional
           The lower and upper range of the bins.  If not provided, range
           is simply ``(a.min(), a.max())``.  Values outside the range are
           ignored.
       normed : bool, optional
           If False, the result will contain the number of samples
           in each bin.  If True, the result is the value of the
           probability *density* function at the bin, normalized such that
           the *integral* over the range is 1. Note that the sum of the
           histogram values will not be equal to 1 unless bins of unity
           width are chosen; it is not a probability *mass* function.
       weights : array_like, optional
           An array of weights, of the same shape as `a`.  Each value in `a`
           only contributes its associated weight towards the bin count
           (instead of 1).  If `normed` is True, the weights are normalized,
           so that the integral of the density over the range remains 1
       Returns
       -------
       hist : array
           The values of the histogram. See `normed` and `weights` for a
           description of the possible semantics.
       bin_edges : array of dtype float
           Return the bin edges ``(length(hist)+1)``.
       See Also
       --------
       histogramdd, bincount, searchsorted
       Notes
       -----
       All but the last (righthand-most) bin is half-open.  In other words, if
       `bins` is::
         [1, 2, 3, 4]
       then the first bin is ``[1, 2)`` (including 1, but excluding 2) and the
       second ``[2, 3)``.  The last bin, however, is ``[3, 4]``, which *includes*
       4.
       Examples
       --------
       >>> np.histogram([1, 2, 1], bins=[0, 1, 2, 3])
       (array([0, 2, 1]), array([0, 1, 2, 3]))
       >>> np.histogram(np.arange(4), bins=np.arange(5), normed=True)
       (array([ 0.25,  0.25,  0.25,  0.25]), array([0, 1, 2, 3, 4]))
       >>> np.histogram([[1, 2, 1], [1, 0, 1]], bins=[0,1,2,3])
       (array([1, 4, 1]), array([0, 1, 2, 3]))
       >>> a = np.arange(5)
       >>> hist, bin_edges = np.histogram(a, normed=True)
       >>> hist
       array([ 0.5,  0. ,  0.5,  0. ,  0. ,  0.5,  0. ,  0.5,  0. ,  0.5])
       >>> hist.sum()
       2.4999999999999996
       >>> np.sum(hist*np.diff(bin_edges))
       1.0
       
    """
    
    
    return array()
def histogram2d(x,y,bins,range,normed,weights):
    """   Compute the bi-dimensional histogram of two data samples.
       Parameters
       ----------
       x : array_like, shape(N,)
           A sequence of values to be histogrammed along the first dimension.
       y : array_like, shape(M,)
           A sequence of values to be histogrammed along the second dimension.
       bins : int or [int, int] or array_like or [array, array], optional
           The bin specification:
             * If int, the number of bins for the two dimensions (nx=ny=bins).
             * If [int, int], the number of bins in each dimension (nx, ny = bins).
             * If array_like, the bin edges for the two dimensions (x_edges=y_edges=bins).
             * If [array, array], the bin edges in each dimension (x_edges, y_edges = bins).
       range : array_like, shape(2,2), optional
           The leftmost and rightmost edges of the bins along each dimension
           (if not specified explicitly in the `bins` parameters):
           ``[[xmin, xmax], [ymin, ymax]]``. All values outside of this range
           will be considered outliers and not tallied in the histogram.
       normed : bool, optional
           If False, returns the number of samples in each bin. If True, returns
           the bin density, i.e. the bin count divided by the bin area.
       weights : array_like, shape(N,), optional
           An array of values ``w_i`` weighing each sample ``(x_i, y_i)``. Weights
           are normalized to 1 if `normed` is True. If `normed` is False, the
           values of the returned histogram are equal to the sum of the weights
           belonging to the samples falling into each bin.
       Returns
       -------
       H : ndarray, shape(nx, ny)
           The bi-dimensional histogram of samples `x` and `y`. Values in `x`
           are histogrammed along the first dimension and values in `y` are
           histogrammed along the second dimension.
       xedges : ndarray, shape(nx,)
           The bin edges along the first dimension.
       yedges : ndarray, shape(ny,)
           The bin edges along the second dimension.
       See Also
       --------
       histogram: 1D histogram
       histogramdd: Multidimensional histogram
       Notes
       -----
       When `normed` is True, then the returned histogram is the sample density,
       defined such that:
       .. math::
         \sum_{i=0}^{nx-1} \sum_{j=0}^{ny-1} H_{i,j} \Delta x_i \Delta y_j = 1
       where `H` is the histogram array and :math:`\Delta x_i \Delta y_i`
       the area of bin `{i,j}`.
       Please note that the histogram does not follow the Cartesian convention
       where `x` values are on the abcissa and `y` values on the ordinate axis.
       Rather, `x` is histogrammed along the first dimension of the array
       (vertical), and `y` along the second dimension of the array (horizontal).
       This ensures compatibility with `histogramdd`.
       Examples
       --------
       >>> x, y = np.random.randn(2, 100)
       >>> H, xedges, yedges = np.histogram2d(x, y, bins=(5, 8))
       >>> H.shape, xedges.shape, yedges.shape
       ((5, 8), (6,), (9,))
       We can now use the Matplotlib to visualize this 2-dimensional histogram:
       >>> extent = [yedges[0], yedges[-1], xedges[-1], xedges[0]]
       >>> import matplotlib.pyplot as plt
       >>> plt.imshow(H, extent=extent, interpolation='nearest')
       <matplotlib.image.AxesImage object at ...>
       >>> plt.colorbar()
       <matplotlib.colorbar.Colorbar instance at ...>
       >>> plt.show()
       
    """
    
    
    return ndarray()
def histogramdd(sample,bins,range,normed,weights):
    """   Compute the multidimensional histogram of some data.
       Parameters
       ----------
       sample : array_like
           The data to be histogrammed. It must be an (N,D) array or data
           that can be converted to such. The rows of the resulting array
           are the coordinates of points in a D dimensional polytope.
       bins : sequence or int, optional
           The bin specification:
           * A sequence of arrays describing the bin edges along each dimension.
           * The number of bins for each dimension (nx, ny, ... =bins)
           * The number of bins for all dimensions (nx=ny=...=bins).
       range : sequence, optional
           A sequence of lower and upper bin edges to be used if the edges are
           not given explicitely in `bins`. Defaults to the minimum and maximum
           values along each dimension.
       normed : boolean, optional
           If False, returns the number of samples in each bin. If True, returns
           the bin density, ie, the bin count divided by the bin hypervolume.
       weights : array_like (N,), optional
           An array of values `w_i` weighing each sample `(x_i, y_i, z_i, ...)`.
           Weights are normalized to 1 if normed is True. If normed is False, the
           values of the returned histogram are equal to the sum of the weights
           belonging to the samples falling into each bin.
       Returns
       -------
       H : ndarray
           The multidimensional histogram of sample x. See normed and weights for
           the different possible semantics.
       edges : list
           A list of D arrays describing the bin edges for each dimension.
       See Also
       --------
       histogram: 1D histogram
       histogram2d: 2D histogram
       Examples
       --------
       >>> r = np.random.randn(100,3)
       >>> H, edges = np.histogramdd(r, bins = (5, 8, 4))
       >>> H.shape, edges[0].size, edges[1].size, edges[2].size
       ((5, 8, 4), 6, 9, 5)
       
    """
    
    
    return ndarray()
def hsplit():
    """   Split an array into multiple sub-arrays horizontally (column-wise).
       Please refer to the `split` documentation.  `hsplit` is equivalent
       to `split` with ``axis=1``, the array is always split along the second
       axis regardless of the array dimension.
       See Also
       --------
       split : Split an array into multiple sub-arrays of equal size.
       Examples
       --------
       >>> x = np.arange(16.0).reshape(4, 4)
       >>> x
       array([[  0.,   1.,   2.,   3.],
              [  4.,   5.,   6.,   7.],
              [  8.,   9.,  10.,  11.],
              [ 12.,  13.,  14.,  15.]])
       >>> np.hsplit(x, 2)
       [array([[  0.,   1.],
              [  4.,   5.],
              [  8.,   9.],
              [ 12.,  13.]]),
        array([[  2.,   3.],
              [  6.,   7.],
              [ 10.,  11.],
              [ 14.,  15.]])]
       >>> np.hsplit(x, np.array([3, 6]))
       [array([[  0.,   1.,   2.],
              [  4.,   5.,   6.],
              [  8.,   9.,  10.],
              [ 12.,  13.,  14.]]),
        array([[  3.],
              [  7.],
              [ 11.],
              [ 15.]]),
        array([], dtype=float64)]
       With a higher dimensional array the split is still along the second axis.
       >>> x = np.arange(8.0).reshape(2, 2, 2)
       >>> x
       array([[[ 0.,  1.],
               [ 2.,  3.]],
              [[ 4.,  5.],
               [ 6.,  7.]]])
       >>> np.hsplit(x, 2)
       [array([[[ 0.,  1.]],
              [[ 4.,  5.]]]),
        array([[[ 2.,  3.]],
              [[ 6.,  7.]]])]
       
    """
    
    
    return None
def hstack(tup):
    """   Stack arrays in sequence horizontally (column wise).
       Take a sequence of arrays and stack them horizontally to make
       a single array. Rebuild arrays divided by `hsplit`.
       Parameters
       ----------
       tup : sequence of ndarrays
           All arrays must have the same shape along all but the second axis.
       Returns
       -------
       stacked : ndarray
           The array formed by stacking the given arrays.
       See Also
       --------
       vstack : Stack arrays in sequence vertically (row wise).
       dstack : Stack arrays in sequence depth wise (along third axis).
       concatenate : Join a sequence of arrays together.
       hsplit : Split array along second axis.
       Notes
       -----
       Equivalent to ``np.concatenate(tup, axis=1)``
       Examples
       --------
       >>> a = np.array((1,2,3))
       >>> b = np.array((2,3,4))
       >>> np.hstack((a,b))
       array([1, 2, 3, 2, 3, 4])
       >>> a = np.array([[1],[2],[3]])
       >>> b = np.array([[2],[3],[4]])
       >>> np.hstack((a,b))
       array([[1, 2],
              [2, 3],
              [3, 4]])
       
    """
    
    
    return ndarray()
def hypot(x1,x2,out):
    """hypot(x1, x2[, out])
    Given the "legs" of a right triangle, return its hypotenuse.
    Equivalent to ``sqrt(x1**2 + x2**2)``, element-wise.  If `x1` or
    `x2` is scalar_like (i.e., unambiguously cast-able to a scalar type),
    it is broadcast for use with each element of the other argument.
    (See Examples)
    Parameters
    ----------
    x1, x2 : array_like
       Leg of the triangle(s).
    out : ndarray, optional
       Array into which the output is placed. Its type is preserved and it
       must be of the right shape to hold the output. See doc.ufuncs.
    Returns
    -------
    z : ndarray
       The hypotenuse of the triangle(s).
    Examples
    --------
    >>> np.hypot(3*np.ones((3, 3)), 4*np.ones((3, 3)))
    array([[ 5.,  5.,  5.],
          [ 5.,  5.,  5.],
          [ 5.,  5.,  5.]])
    Example showing broadcast of scalar_like argument:
    >>> np.hypot(3*np.ones((3, 3)), [4])
    array([[ 5.,  5.,  5.],
          [ 5.,  5.,  5.],
          [ 5.,  5.,  5.]])
    """
    
    
    return ndarray()
def i0(x):
    """   Modified Bessel function of the first kind, order 0.
       Usually denoted :math:`I_0`.  This function does broadcast, but will *not*
       "up-cast" int dtype arguments unless accompanied by at least one float or
       complex dtype argument (see Raises below).
       Parameters
       ----------
       x : array_like, dtype float or complex
           Argument of the Bessel function.
       Returns
       -------
       out : ndarray, shape = x.shape, dtype = x.dtype
           The modified Bessel function evaluated at each of the elements of `x`.
       Raises
       ------
       TypeError: array cannot be safely cast to required type
           If argument consists exclusively of int dtypes.
       See Also
       --------
       scipy.special.iv, scipy.special.ive
       Notes
       -----
       We use the algorithm published by Clenshaw [1]_ and referenced by
       Abramowitz and Stegun [2]_, for which the function domain is partitioned
       into the two intervals [0,8] and (8,inf), and Chebyshev polynomial
       expansions are employed in each interval. Relative error on the domain
       [0,30] using IEEE arithmetic is documented [3]_ as having a peak of 5.8e-16
       with an rms of 1.4e-16 (n = 30000).
       References
       ----------
       .. [1] C. W. Clenshaw, "Chebyshev series for mathematical functions," in
              *National Physical Laboratory Mathematical Tables*, vol. 5, London:
              Her Majesty's Stationery Office, 1962.
       .. [2] M. Abramowitz and I. A. Stegun, *Handbook of Mathematical
              Functions*, 10th printing, New York: Dover, 1964, pp. 379.
              http://www.math.sfu.ca/~cbm/aands/page_379.htm
       .. [3] http://kobesearch.cpan.org/htdocs/Math-Cephes/Math/Cephes.html
       Examples
       --------
       >>> np.i0([0.])
       array(1.0)
       >>> np.i0([0., 1. + 2j])
       array([ 1.00000000+0.j        ,  0.18785373+0.64616944j])
       
    """
    
    
    return ndarray()
def identity(n,dtype):
    """   Return the identity array.
       The identity array is a square array with ones on
       the main diagonal.
       Parameters
       ----------
       n : int
           Number of rows (and columns) in `n` x `n` output.
       dtype : data-type, optional
           Data-type of the output.  Defaults to ``float``.
       Returns
       -------
       out : ndarray
           `n` x `n` array with its main diagonal set to one,
           and all other elements 0.
       Examples
       --------
       >>> np.identity(3)
       array([[ 1.,  0.,  0.],
              [ 0.,  1.,  0.],
              [ 0.,  0.,  1.]])
       
    """
    
    
    return ndarray()
iinfo = iinfo()
def imag(val):
    """   Return the imaginary part of the elements of the array.
       Parameters
       ----------
       val : array_like
           Input array.
       Returns
       -------
       out : ndarray
           Output array. If `val` is real, the type of `val` is used for the
           output.  If `val` has complex elements, the returned type is float.
       See Also
       --------
       real, angle, real_if_close
       Examples
       --------
       >>> a = np.array([1+2j, 3+4j, 5+6j])
       >>> a.imag
       array([ 2.,  4.,  6.])
       >>> a.imag = np.array([8, 10, 12])
       >>> a
       array([ 1. +8.j,  3.+10.j,  5.+12.j])
       
    """
    
    
    return ndarray()
def in1d(ar1,ar2,assume_unique):
    """   Test whether each element of a 1D array is also present in a second array.
       Returns a boolean array the same length as `ar1` that is True
       where an element of `ar1` is in `ar2` and False otherwise.
       Parameters
       ----------
       ar1 : array_like, shape (M,)
           Input array.
       ar2 : array_like
           The values against which to test each value of `ar1`.
       assume_unique : bool, optional
           If True, the input arrays are both assumed to be unique, which
           can speed up the calculation.  Default is False.
       Returns
       -------
       mask : ndarray of bools, shape(M,)
           The values `ar1[mask]` are in `ar2`.
       See Also
       --------
       numpy.lib.arraysetops : Module with a number of other functions for
                               performing set operations on arrays.
       Notes
       -----
       `in1d` can be considered as an element-wise function version of the
       python keyword `in`, for 1D sequences. ``in1d(a, b)`` is roughly
       equivalent to ``np.array([item in b for item in a])``.
       .. versionadded:: 1.4.0
       Examples
       --------
       >>> test = np.array([0, 1, 2, 5, 0])
       >>> states = [0, 2]
       >>> mask = np.in1d(test, states)
       >>> mask
       array([ True, False,  True, False,  True], dtype=bool)
       >>> test[mask]
       array([0, 2, 0])
       
    """
    
    
    return ndarray()
index_exp = None
def indices(dimensions,dtype):
    """   Return an array representing the indices of a grid.
       Compute an array where the subarrays contain index values 0,1,...
       varying only along the corresponding axis.
       Parameters
       ----------
       dimensions : sequence of ints
           The shape of the grid.
       dtype : dtype, optional
           Data type of the result.
       Returns
       -------
       grid : ndarray
           The array of grid indices,
           ``grid.shape = (len(dimensions),) + tuple(dimensions)``.
       See Also
       --------
       mgrid, meshgrid
       Notes
       -----
       The output shape is obtained by prepending the number of dimensions
       in front of the tuple of dimensions, i.e. if `dimensions` is a tuple
       ``(r0, ..., rN-1)`` of length ``N``, the output shape is
       ``(N,r0,...,rN-1)``.
       The subarrays ``grid[k]`` contains the N-D array of indices along the
       ``k-th`` axis. Explicitly::
           grid[k,i0,i1,...,iN-1] = ik
       Examples
       --------
       >>> grid = np.indices((2, 3))
       >>> grid.shape
       (2, 2, 3)
       >>> grid[0]        # row indices
       array([[0, 0, 0],
              [1, 1, 1]])
       >>> grid[1]        # column indices
       array([[0, 1, 2],
              [0, 1, 2]])
       The indices can be used as an index into an array.
       >>> x = np.arange(20).reshape(5, 4)
       >>> row, col = np.indices((2, 3))
       >>> x[row, col]
       array([[0, 1, 2],
              [4, 5, 6]])
       Note that it would be more straightforward in the above example to
       extract the required elements directly with ``x[:2, :3]``.
       
    """
    
    
    return ndarray()
class inexact:
    T = None
    def all(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def any(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmax(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmin(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argsort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def astype(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    base = None
    def byteswap(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def choose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def clip(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def compress(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def conj(self):
        """None"""
        
        
        return None
    def conjugate(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def copy(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumprod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumsum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    data = None
    def diagonal(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    dtype = None
    def dump(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def dumps(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def fill(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    flags = None
    flat = None
    def flatten(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def getfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    imag = None
    def item(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def itemset(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    itemsize = None
    def max(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def mean(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def min(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    nbytes = None
    ndim = None
    def newbyteorder(self,new_order):
        """newbyteorder(new_order='S')
           Return a new `dtype` with a different byte order.
           Changes are also made in all fields and sub-arrays of the data type.
           The `new_order` code can be any from the following:
           * {'<', 'L'} - little endian
           * {'>', 'B'} - big endian
           * {'=', 'N'} - native order
           * 'S' - swap dtype from current to opposite endian
           * {'|', 'I'} - ignore (no change to byte order)
           Parameters
           ----------
           new_order : str, optional
               Byte order to force; a value from the byte order specifications
               above.  The default value ('S') results in swapping the current
               byte order. The code does a case-insensitive check on the first
               letter of `new_order` for the alternatives above.  For example,
               any of 'B' or 'b' or 'biggish' are valid to specify big-endian.
           Returns
           -------
           new_dtype : dtype
               New `dtype` object with the given change to the byte order.
        """
        
        
        return dtype()
    def nonzero(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def prod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ptp(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def put(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ravel(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    real = None
    def repeat(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def reshape(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def resize(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def round(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def searchsorted(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setflags(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    shape = None
    size = None
    def sort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def squeeze(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def std(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    strides = None
    def sum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def swapaxes(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def take(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tofile(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tolist(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tostring(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def trace(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def transpose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def var(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def view(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    

inf = 0.0
def info(object,maxwidth,output,toplevel):
    """   Get help information for a function, class, or module.
       Parameters
       ----------
       object : object or str, optional
           Input object or name to get information about. If `object` is a
           numpy object, its docstring is given. If it is a string, available
           modules are searched for matching objects.
           If None, information about `info` itself is returned.
       maxwidth : int, optional
           Printing width.
       output : file like object, optional
           File like object that the output is written to, default is ``stdout``.
           The object has to be opened in 'w' or 'a' mode.
       toplevel : str, optional
           Start search at this level.
       See Also
       --------
       source, lookfor
       Notes
       -----
       When used interactively with an object, ``np.info(obj)`` is equivalent to
       ``help(obj)`` on the Python prompt or ``obj?`` on the IPython prompt.
       Examples
       --------
       >>> np.info(np.polyval) # doctest: +SKIP
          polyval(p, x)
            Evaluate the polynomial p at x.
            ...
       When using a string for `object` it is possible to get multiple results.
       >>> np.info('fft') # doctest: +SKIP
            *** Found in numpy ***
       Core FFT routines
       ...
            *** Found in numpy.fft ***
        fft(a, n=None, axis=-1)
       ...
            *** Repeat reference found in numpy.fft.fftpack ***
            *** Total of 3 references found. ***
       
    """
    
    
    return None
infty = 0.0
def inner(a,b):
    """inner(a, b)
       Inner product of two arrays.
       Ordinary inner product of vectors for 1-D arrays (without complex
       conjugation), in higher dimensions a sum product over the last axes.
       Parameters
       ----------
       a, b : array_like
           If `a` and `b` are nonscalar, their last dimensions of must match.
       Returns
       -------
       out : ndarray
           `out.shape = a.shape[:-1] + b.shape[:-1]`
       Raises
       ------
       ValueError
           If the last dimension of `a` and `b` has different size.
       See Also
       --------
       tensordot : Sum products over arbitrary axes.
       dot : Generalised matrix product, using second last dimension of `b`.
       Notes
       -----
       For vectors (1-D arrays) it computes the ordinary inner-product::
           np.inner(a, b) = sum(a[:]*b[:])
       More generally, if `ndim(a) = r > 0` and `ndim(b) = s > 0`::
           np.inner(a, b) = np.tensordot(a, b, axes=(-1,-1))
       or explicitly::
           np.inner(a, b)[i0,...,ir-1,j0,...,js-1]
                = sum(a[i0,...,ir-1,:]*b[j0,...,js-1,:])
       In addition `a` or `b` may be scalars, in which case::
          np.inner(a,b) = a*b
       Examples
       --------
       Ordinary inner product for vectors:
       >>> a = np.array([1,2,3])
       >>> b = np.array([0,1,0])
       >>> np.inner(a, b)
       2
       A multidimensional example:
       >>> a = np.arange(24).reshape((2,3,4))
       >>> b = np.arange(4)
       >>> np.inner(a, b)
       array([[ 14,  38,  62],
              [ 86, 110, 134]])
       An example where `b` is a scalar:
       >>> np.inner(np.eye(2), 7)
       array([[ 7.,  0.],
              [ 0.,  7.]])
    """
    
    
    return ndarray()
def insert(arr,obj,values,axis):
    """   Insert values along the given axis before the given indices.
       Parameters
       ----------
       arr : array_like
           Input array.
       obj : int, slice or sequence of ints
           Object that defines the index or indices before which `values` is
           inserted.
       values : array_like
           Values to insert into `arr`. If the type of `values` is different
           from that of `arr`, `values` is converted to the type of `arr`.
       axis : int, optional
           Axis along which to insert `values`.  If `axis` is None then `arr`
           is flattened first.
       Returns
       -------
       out : ndarray
           A copy of `arr` with `values` inserted.  Note that `insert`
           does not occur in-place: a new array is returned. If
           `axis` is None, `out` is a flattened array.
       See Also
       --------
       append : Append elements at the end of an array.
       delete : Delete elements from an array.
       Examples
       --------
       >>> a = np.array([[1, 1], [2, 2], [3, 3]])
       >>> a
       array([[1, 1],
              [2, 2],
              [3, 3]])
       >>> np.insert(a, 1, 5)
       array([1, 5, 1, 2, 2, 3, 3])
       >>> np.insert(a, 1, 5, axis=1)
       array([[1, 5, 1],
              [2, 5, 2],
              [3, 5, 3]])
       >>> b = a.flatten()
       >>> b
       array([1, 1, 2, 2, 3, 3])
       >>> np.insert(b, [2, 2], [5, 6])
       array([1, 1, 5, 6, 2, 2, 3, 3])
       >>> np.insert(b, slice(2, 4), [5, 6])
       array([1, 1, 5, 2, 6, 2, 3, 3])
       >>> np.insert(b, [2, 2], [7.13, False]) # type casting
       array([1, 1, 7, 0, 2, 2, 3, 3])
       >>> x = np.arange(8).reshape(2, 4)
       >>> idx = (1, 3)
       >>> np.insert(x, idx, 999, axis=1)
       array([[  0, 999,   1,   2, 999,   3],
              [  4, 999,   5,   6, 999,   7]])
       
    """
    
    
    return ndarray()
class int:
    def conjugate(self):
        """Returns self, the complex conjugate of any int.
        """
        
        
        return None
    denominator = None
    imag = None
    numerator = None
    real = None
    

class int0:
    T = None
    def all(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def any(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmax(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmin(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argsort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def astype(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    base = None
    def byteswap(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def choose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def clip(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def compress(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def conj(self):
        """None"""
        
        
        return None
    def conjugate(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def copy(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumprod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumsum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    data = None
    denominator = None
    def diagonal(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    dtype = None
    def dump(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def dumps(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def fill(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    flags = None
    flat = None
    def flatten(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def getfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    imag = None
    def item(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def itemset(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    itemsize = None
    def max(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def mean(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def min(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    nbytes = None
    ndim = None
    def newbyteorder(self,new_order):
        """newbyteorder(new_order='S')
           Return a new `dtype` with a different byte order.
           Changes are also made in all fields and sub-arrays of the data type.
           The `new_order` code can be any from the following:
           * {'<', 'L'} - little endian
           * {'>', 'B'} - big endian
           * {'=', 'N'} - native order
           * 'S' - swap dtype from current to opposite endian
           * {'|', 'I'} - ignore (no change to byte order)
           Parameters
           ----------
           new_order : str, optional
               Byte order to force; a value from the byte order specifications
               above.  The default value ('S') results in swapping the current
               byte order. The code does a case-insensitive check on the first
               letter of `new_order` for the alternatives above.  For example,
               any of 'B' or 'b' or 'biggish' are valid to specify big-endian.
           Returns
           -------
           new_dtype : dtype
               New `dtype` object with the given change to the byte order.
        """
        
        
        return dtype()
    def nonzero(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    numerator = None
    def prod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ptp(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def put(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ravel(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    real = None
    def repeat(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def reshape(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def resize(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def round(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def searchsorted(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setflags(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    shape = None
    size = None
    def sort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def squeeze(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def std(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    strides = None
    def sum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def swapaxes(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def take(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tofile(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tolist(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tostring(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def trace(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def transpose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def var(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def view(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    

class int16:
    T = None
    def all(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def any(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmax(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmin(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argsort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def astype(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    base = None
    def byteswap(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def choose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def clip(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def compress(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def conj(self):
        """None"""
        
        
        return None
    def conjugate(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def copy(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumprod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumsum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    data = None
    def diagonal(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    dtype = None
    def dump(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def dumps(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def fill(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    flags = None
    flat = None
    def flatten(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def getfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    imag = None
    def item(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def itemset(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    itemsize = None
    def max(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def mean(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def min(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    nbytes = None
    ndim = None
    def newbyteorder(self,new_order):
        """newbyteorder(new_order='S')
           Return a new `dtype` with a different byte order.
           Changes are also made in all fields and sub-arrays of the data type.
           The `new_order` code can be any from the following:
           * {'<', 'L'} - little endian
           * {'>', 'B'} - big endian
           * {'=', 'N'} - native order
           * 'S' - swap dtype from current to opposite endian
           * {'|', 'I'} - ignore (no change to byte order)
           Parameters
           ----------
           new_order : str, optional
               Byte order to force; a value from the byte order specifications
               above.  The default value ('S') results in swapping the current
               byte order. The code does a case-insensitive check on the first
               letter of `new_order` for the alternatives above.  For example,
               any of 'B' or 'b' or 'biggish' are valid to specify big-endian.
           Returns
           -------
           new_dtype : dtype
               New `dtype` object with the given change to the byte order.
        """
        
        
        return dtype()
    def nonzero(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def prod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ptp(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def put(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ravel(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    real = None
    def repeat(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def reshape(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def resize(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def round(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def searchsorted(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setflags(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    shape = None
    size = None
    def sort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def squeeze(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def std(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    strides = None
    def sum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def swapaxes(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def take(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tofile(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tolist(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tostring(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def trace(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def transpose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def var(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def view(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    

class int32:
    T = None
    def all(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def any(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmax(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmin(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argsort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def astype(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    base = None
    def byteswap(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def choose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def clip(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def compress(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def conj(self):
        """None"""
        
        
        return None
    def conjugate(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def copy(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumprod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumsum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    data = None
    denominator = None
    def diagonal(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    dtype = None
    def dump(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def dumps(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def fill(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    flags = None
    flat = None
    def flatten(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def getfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    imag = None
    def item(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def itemset(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    itemsize = None
    def max(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def mean(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def min(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    nbytes = None
    ndim = None
    def newbyteorder(self,new_order):
        """newbyteorder(new_order='S')
           Return a new `dtype` with a different byte order.
           Changes are also made in all fields and sub-arrays of the data type.
           The `new_order` code can be any from the following:
           * {'<', 'L'} - little endian
           * {'>', 'B'} - big endian
           * {'=', 'N'} - native order
           * 'S' - swap dtype from current to opposite endian
           * {'|', 'I'} - ignore (no change to byte order)
           Parameters
           ----------
           new_order : str, optional
               Byte order to force; a value from the byte order specifications
               above.  The default value ('S') results in swapping the current
               byte order. The code does a case-insensitive check on the first
               letter of `new_order` for the alternatives above.  For example,
               any of 'B' or 'b' or 'biggish' are valid to specify big-endian.
           Returns
           -------
           new_dtype : dtype
               New `dtype` object with the given change to the byte order.
        """
        
        
        return dtype()
    def nonzero(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    numerator = None
    def prod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ptp(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def put(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ravel(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    real = None
    def repeat(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def reshape(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def resize(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def round(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def searchsorted(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setflags(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    shape = None
    size = None
    def sort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def squeeze(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def std(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    strides = None
    def sum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def swapaxes(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def take(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tofile(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tolist(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tostring(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def trace(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def transpose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def var(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def view(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    

class int64:
    T = None
    def all(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def any(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmax(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmin(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argsort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def astype(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    base = None
    def byteswap(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def choose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def clip(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def compress(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def conj(self):
        """None"""
        
        
        return None
    def conjugate(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def copy(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumprod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumsum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    data = None
    def diagonal(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    dtype = None
    def dump(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def dumps(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def fill(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    flags = None
    flat = None
    def flatten(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def getfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    imag = None
    def item(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def itemset(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    itemsize = None
    def max(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def mean(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def min(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    nbytes = None
    ndim = None
    def newbyteorder(self,new_order):
        """newbyteorder(new_order='S')
           Return a new `dtype` with a different byte order.
           Changes are also made in all fields and sub-arrays of the data type.
           The `new_order` code can be any from the following:
           * {'<', 'L'} - little endian
           * {'>', 'B'} - big endian
           * {'=', 'N'} - native order
           * 'S' - swap dtype from current to opposite endian
           * {'|', 'I'} - ignore (no change to byte order)
           Parameters
           ----------
           new_order : str, optional
               Byte order to force; a value from the byte order specifications
               above.  The default value ('S') results in swapping the current
               byte order. The code does a case-insensitive check on the first
               letter of `new_order` for the alternatives above.  For example,
               any of 'B' or 'b' or 'biggish' are valid to specify big-endian.
           Returns
           -------
           new_dtype : dtype
               New `dtype` object with the given change to the byte order.
        """
        
        
        return dtype()
    def nonzero(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def prod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ptp(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def put(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ravel(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    real = None
    def repeat(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def reshape(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def resize(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def round(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def searchsorted(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setflags(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    shape = None
    size = None
    def sort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def squeeze(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def std(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    strides = None
    def sum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def swapaxes(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def take(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tofile(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tolist(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tostring(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def trace(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def transpose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def var(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def view(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    

class int8:
    T = None
    def all(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def any(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmax(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmin(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argsort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def astype(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    base = None
    def byteswap(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def choose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def clip(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def compress(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def conj(self):
        """None"""
        
        
        return None
    def conjugate(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def copy(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumprod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumsum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    data = None
    def diagonal(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    dtype = None
    def dump(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def dumps(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def fill(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    flags = None
    flat = None
    def flatten(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def getfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    imag = None
    def item(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def itemset(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    itemsize = None
    def max(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def mean(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def min(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    nbytes = None
    ndim = None
    def newbyteorder(self,new_order):
        """newbyteorder(new_order='S')
           Return a new `dtype` with a different byte order.
           Changes are also made in all fields and sub-arrays of the data type.
           The `new_order` code can be any from the following:
           * {'<', 'L'} - little endian
           * {'>', 'B'} - big endian
           * {'=', 'N'} - native order
           * 'S' - swap dtype from current to opposite endian
           * {'|', 'I'} - ignore (no change to byte order)
           Parameters
           ----------
           new_order : str, optional
               Byte order to force; a value from the byte order specifications
               above.  The default value ('S') results in swapping the current
               byte order. The code does a case-insensitive check on the first
               letter of `new_order` for the alternatives above.  For example,
               any of 'B' or 'b' or 'biggish' are valid to specify big-endian.
           Returns
           -------
           new_dtype : dtype
               New `dtype` object with the given change to the byte order.
        """
        
        
        return dtype()
    def nonzero(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def prod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ptp(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def put(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def ravel(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    real = None
    def repeat(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def reshape(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def resize(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def round(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def searchsorted(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def setflags(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    shape = None
    size = None
    def sort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def squeeze(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def std(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    strides = None
    def sum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def swapaxes(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def take(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tofile(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tolist(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def tostring(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def trace(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def transpose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def var(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def view(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    

class int_:
    T = None
    def all(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def any(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmax(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argmin(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def argsort(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def astype(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    base = None
    def byteswap(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class so as to
           provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def choose(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def clip(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def compress(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def conj(self):
        """None"""
        
        
        return None
    def conjugate(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def copy(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumprod(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def cumsum(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    data = None
    denominator = None
    def diagonal(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    dtype = None
    def dump(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def dumps(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def fill(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    flags = None
    flat = None
    def flatten(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def getfield(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    imag = None
    def item(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
        
        return None
    def itemset(self):
        """Not implemented (virtual attribute)
           Class generic exists solely to derive numpy scalars from, and possesses,
           albeit unimplemented, all the attributes of the ndarray class
           so as to provide a uniform API.
           See Also
           --------
           The corresponding attribute of the derived class of interest.
        """
        
     