/*
 * Copyright (c) 2010 Broadcom Corporation
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
 * SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef _WLC_RPC_H_
#define _WLC_RPC_H_

#include <wlc_types.h>

/* RPC IDs, reordering is OK. This needs to be in sync with RPC_ID_TABLE below */
typedef enum {
	WLRPC_NULL_ID = 0,
	WLRPC_WLC_REG_READ_ID,
	WLRPC_WLC_REG_WRITE_ID,
	WLRPC_WLC_MHF_SET_ID,
	WLRPC_WLC_MHF_GET_ID,
	WLRPC_WLC_BMAC_UP_PREP_ID,
	WLRPC_WLC_BMAC_UP_FINISH_ID,
	WLRPC_WLC_BMAC_DOWN_PREP_ID,
	WLRPC_WLC_BMAC_DOWN_FINISH_ID,
	WLRPC_WLC_BMAC_WRITE_HW_BCNTEMPLATES_ID,
	WLRPC_WLC_BMAC_RESET_ID,
	WLRPC_WLC_DNGL_REBOOT_ID,
	WLRPC_WLC_BMAC_RPC_TXQ_WM_SET_ID,
	WLRPC_WLC_BMAC_RPC_TXQ_WM_GET_ID,
	WLRPC_WLC_BMAC_RPC_AGG_SET_ID,
	WLRPC_WLC_BMAC_RPC_MSGLEVEL_SET_ID,
	WLRPC_WLC_BMAC_RPC_AGG_LIMIT_SET_ID,
	WLRPC_WLC_BMAC_RPC_AGG_LIMIT_GET_ID,
	WLRPC_WLC_BMAC_INIT_ID,
	WLRPC_WLC_BMAC_SET_CWMIN_ID,
	WLRPC_WLC_BMAC_MUTE_ID,
	WLRPC_WLC_PHY_DOIOVAR_ID,
	WLRPC_WLC_PHY_HOLD_UPD_ID,
	WLRPC_WLC_PHY_MUTE_UPD_ID,
	WLRPC_WLC_PHY_CLEAR_TSSI_ID,
	WLRPC_WLC_PHY_ANT_RXDIV_GET_ID,
	WLRPC_WLC_PHY_ANT_RXDIV_SET_ID,
	WLRPC_WLC_PHY_PREAMBLE_SET_ID,
	WLRPC_WLC_PHY_FREQTRACK_END_ID,
	WLRPC_WLC_PHY_FREQTRACK_START_ID,
	WLRPC_WLC_PHY_IOCTL_ID,
	WLRPC_WLC_PHY_NOISE_SAMPLE_REQUEST_ID,
	WLRPC_WLC_PHY_CAL_PERICAL_ID,
	WLRPC_WLC_PHY_TXPOWER_GET_ID,
	WLRPC_WLC_PHY_TXPOWER_SET_ID,
	WLRPC_WLC_PHY_TXPOWER_SROMLIMIT_ID,
	WLRPC_WLC_PHY_RADAR_DETECT_ENABLE_ID,
	WLRPC_WLC_PHY_RADAR_DETECT_RUN_ID,
	WLRPC_WLC_PHY_TEST_ISON_ID,
	WLRPC_WLC_BMAC_COPYFROM_OBJMEM_ID,
	WLRPC_WLC_BMAC_COPYTO_OBJMEM_ID,
	WLRPC_WLC_ENABLE_MAC_ID,
	WLRPC_WLC_MCTRL_ID,
	WLRPC_WLC_CORERESET_ID,
	WLRPC_WLC_BMAC_READ_SHM_ID,
	WLRPC_WLC_BMAC_READ_TSF_ID,
	WLRPC_WLC_BMAC_SET_ADDRMATCH_ID,
	WLRPC_WLC_BMAC_SET_CWMAX_ID,
	WLRPC_WLC_BMAC_SET_RCMTA_ID,
	WLRPC_WLC_BMAC_SET_SHM_ID,
	WLRPC_WLC_SUSPEND_MAC_AND_WAIT_ID,
	WLRPC_WLC_BMAC_WRITE_SHM_ID,
	WLRPC_WLC_BMAC_WRITE_TEMPLATE_RAM_ID,
	WLRPC_WLC_TX_FIFO_SUSPEND_ID,
	WLRPC_WLC_TX_FIFO_RESUME_ID,
	WLRPC_WLC_TX_FIFO_SUSPENDED_ID,
	WLRPC_WLC_HW_ETHERADDR_ID,
	WLRPC_WLC_SET_HW_ETHERADDR_ID,
	WLRPC_WLC_BMAC_CHANSPEC_SET_ID,
	WLRPC_WLC_BMAC_TXANT_SET_ID,
	WLRPC_WLC_BMAC_ANTSEL_TYPE_SET_ID,
	WLRPC_WLC_BMAC_TXFIFO_ID,
	WLRPC_WLC_RADIO_READ_HWDISABLED_ID,
	WLRPC_WLC_RM_CCA_MEASURE_ID,
	WLRPC_WLC_SET_SHORTSLOT_ID,
	WLRPC_WLC_WAIT_FOR_WAKE_ID,
	WLRPC_WLC_PHY_TXPOWER_GET_CURRENT_ID,
	WLRPC_WLC_PHY_TXPOWER_HW_CTRL_GET_ID,
	WLRPC_WLC_PHY_TXPOWER_HW_CTRL_SET_ID,
	WLRPC_WLC_PHY_BSSINIT_ID,
	WLRPC_WLC_BAND_STF_SS_SET_ID,
	WLRPC_WLC_PHY_BAND_FIRST_CHANSPEC_ID,
	WLRPC_WLC_PHY_TXPOWER_LIMIT_SET_ID,
	WLRPC_WLC_PHY_BAND_CHANNELS_ID,
	WLRPC_WLC_BMAC_REVINFO_GET_ID,
	WLRPC_WLC_BMAC_STATE_GET_ID,
	WLRPC_WLC_BMAC_XMTFIFO_SZ_GET_ID,
	WLRPC_WLC_BMAC_XMTFIFO_SZ_SET_ID,
	WLRPC_WLC_BMAC_VALIDATE_CHIP_ACCESS_ID,
	WLRPC_WLC_RM_CCA_COMPLETE_ID,
	WLRPC_WLC_RECV_ID,
	WLRPC_WLC_DOTXSTATUS_ID,
	WLRPC_WLC_HIGH_DPC_ID,
	WLRPC_WLC_FATAL_ERROR_ID,
	WLRPC_WLC_PHY_SET_CHANNEL_14_WIDE_FILTER_ID,
	WLRPC_WLC_PHY_NOISE_AVG_ID,
	WLRPC_WLC_PHYCHAIN_INIT_ID,
	WLRPC_WLC_PHYCHAIN_SET_ID,
	WLRPC_WLC_PHYCHAIN_GET_ID,
	WLRPC_WLC_PHY_TKIP_RIFS_WAR_ID,
	WLRPC_WLC_BMAC_COPYFROM_VARS_ID,
	WLRPC_WLC_BMAC_RETRYLIMIT_UPD_ID,
	WLRPC_WLC_BMAC_BTC_MODE_SET_ID,
	WLRPC_WLC_BMAC_BTC_MODE_GET_ID,
	WLRPC_WLC_BMAC_BTC_WIRE_SET_ID,
	WLRPC_WLC_BMAC_BTC_WIRE_GET_ID,
	WLRPC_WLC_BMAC_SET_NORESET_ID,
	WLRPC_WLC_AMPDU_TXSTATUS_COMPLETE_ID,
	WLRPC_WLC_BMAC_FIFOERRORS_ID,
	WLRPC_WLC_PHY_TXPOWER_GET_TARGET_MIN_ID,
	WLRPC_WLC_PHY_TXPOWER_GET_TARGET_MAX_ID,
	WLRPC_WLC_NOISE_CB_ID,
	WLRPC_WLC_BMAC_LED_HW_DEINIT_ID,
	WLRPC_WLC_BMAC_LED_HW_MASK_INIT_ID,
	WLRPC_WLC_PLLREQ_ID,
	WLRPC_WLC_BMAC_TACLEAR_ID,
	WLRPC_WLC_BMAC_SET_CLK_ID,
	WLRPC_WLC_PHY_OFDM_RATESET_WAR_ID,
	WLRPC_WLC_PHY_BF_PREEMPT_ENABLE_ID,
	WLRPC_WLC_BMAC_DOIOVARS_ID,
	WLRPC_WLC_BMAC_DUMP_ID,
	WLRPC_WLC_CISWRITE_ID,
	WLRPC_WLC_CISDUMP_ID,
	WLRPC_WLC_UPDATE_PHY_MODE_ID,
	WLRPC_WLC_RESET_BMAC_DONE_ID,
	WLRPC_WLC_BMAC_LED_BLINK_EVENT_ID,
	WLRPC_WLC_BMAC_LED_SET_ID,
	WLRPC_WLC_BMAC_LED_BLINK_ID,
	WLRPC_WLC_BMAC_LED_ID,
	WLRPC_WLC_BMAC_RATE_SHM_OFFSET_ID,
	WLRPC_SI_ISCORE_UP_ID,
	WLRPC_WLC_BMAC_PS_SWITCH_ID,
	WLRPC_WLC_PHY_STF_SSMODE_GET_ID,
	WLRPC_WLC_BMAC_DEBUG_ID,
	WLRPC_WLC_EXTLOG_MSG_ID,
	WLRPC_WLC_EXTLOG_CFG_ID,
	WLRPC_BCM_ASSERT_LOG_ID,
	WLRPC_BCM_ASSERT_TYPE_ID,
	WLRPC_WLC_BMAC_SET_PHYCAL_CACHE_FLAG_ID,
	WLRPC_WLC_BMAC_GET_PHYCAL_CACHE_FLAG_ID,
	WLRPC_WLC_PHY_CAL_CACHE_INIT_ID,
	WLRPC_WLC_PHY_CAL_CACHE_DEINIT_ID,
	WLRPC_WLC_BMAC_HW_UP_ID,
	WLRPC_WLC_BMAC_SET_TXPWR_PERCENT_ID,
	WLRPC_WLC_PHYCHAIN_ACTIVE_GET_ID,
	WLRPC_WLC_BMAC_BLINK_SYNC_ID,
	WLRPC_WLC_BMAC_UCODE_DBGSEL_SET_ID,
	WLRPC_WLC_BMAC_UCODE_DBGSEL_GET_ID,
	WLRPC_WLC_PHY_RADAR_DETECT_MODE_SET_ID,
	WLRPC_WLC_PHY_ACIM_NOISEM_RESET_NPHY_ID,
	WLRPC_WLC_PHY_INTERFER_SET_NPHY_ID,
	WLRPC_WLC_BMAC_IFSCTL_EDCRS_SET_ID,
	WLRPC_WLC_PKTENGTX,
	WLRPC_WLC_BMAC_SET_DEAF,
	WLRPC_WLC_BMAC_CLEAR_DEAF,
	WLRPC_WLC_BMAC_BTC_FLAGS_SET_ID,
	WLRPC_WLC_BMAC_BTC_FLAGS_GET_ID,
	WLRPC_WLC_BMAC_SET_RCMTA_TYPE_ID,
	WLRPC_WLC_BMAC_BTC_FLAGS_UPD_ID,
	WLRPC_WLC_BMAC_BTC_STUCKWAR_ID,
	WLRPC_WLC_BMAC_CCA_STATS_READ_ID,
	WLRPC_WLC_BMAC_ANTSEL_SET_ID,
	WLRPC_WLC_BMAC_SET_UCODE_LOADED,
	WLRPC_WLC_PHY_LDPC_SET_ID,

	WLRPC_LAST
} wlc_rpc_id_t;

#if defined(BCMDBG) | 0
struct name_entry {
	int id;
	char *name;
};

#define NAME_ENTRY(x) {x, #x}

#define RPC_ID_TABLE { \
	NAME_ENTRY(WLRPC_WLC_REG_READ_ID),	\
	NAME_ENTRY(WLRPC_WLC_REG_WRITE_ID),	\
	NAME_ENTRY(WLRPC_WLC_MHF_SET_ID),	\
	NAME_ENTRY(WLRPC_WLC_MHF_GET_ID),	\
	NAME_ENTRY(WLRPC_WLC_BMAC_UP_PREP_ID),	\
	NAME_ENTRY(WLRPC_WLC_BMAC_UP_FINISH_ID),	\
	NAME_ENTRY(WLRPC_WLC_BMAC_DOWN_PREP_ID),	\
	NAME_ENTRY(WLRPC_WLC_BMAC_DOWN_FINISH_ID),	\
	NAME_ENTRY(WLRPC_WLC_BMAC_WRITE_HW_BCNTEMPLATES_ID),	\
	NAME_ENTRY(WLRPC_WLC_BMAC_RESET_ID),	\
	NAME_ENTRY(WLRPC_WLC_DNGL_REBOOT_ID),	\
	NAME_ENTRY(WLRPC_WLC_BMAC_RPC_TXQ_WM_SET_ID),	\
	NAME_ENTRY(WLRPC_WLC_BMAC_RPC_TXQ_WM_GET_ID),	\
	NAME_ENTRY(WLRPC_WLC_BMAC_RPC_AGG_SET_ID),	\
	NAME_ENTRY(WLRPC_WLC_BMAC_RPC_MSGLEVEL_SET_ID),	\
	NAME_ENTRY(WLRPC_WLC_BMAC_RPC_AGG_LIMIT_SET_ID),	\
	NAME_ENTRY(WLRPC_WLC_BMAC_RPC_AGG_LIMIT_GET_ID),	\
	NAME_ENTRY(WLRPC_WLC_BMAC_INIT_ID),	\
	NAME_ENTRY(WLRPC_WLC_BMAC_SET_CWMIN_ID),	\
	NAME_ENTRY(WLRPC_WLC_BMAC_MUTE_ID),	\
	NAME_ENTRY(WLRPC_WLC_PHY_DOIOVAR_ID),	\
	NAME_ENTRY(WLRPC_WLC_PHY_HOLD_UPD_ID),	\
	NAME_ENTRY(WLRPC_WLC_PHY_MUTE_UPD_ID),	\
	NAME_ENTRY(WLRPC_WLC_PHY_CLEAR_TSSI_ID),	\
	NAME_ENTRY(WLRPC_WLC_PHY_ANT_RXDIV_GET_ID),	\
	NAME_ENTRY(WLRPC_WLC_PHY_ANT_RXDIV_SET_ID),	\
	NAME_ENTRY(WLRPC_WLC_PHY_PREAMBLE_SET_ID),	\
	NAME_ENTRY(WLRPC_WLC_PHY_FREQTRACK_END_ID),	\
	NAME_ENTRY(WLRPC_WLC_PHY_FREQTRACK_START_ID),	\
	NAME_ENTRY(WLRPC_WLC_PHY_IOCTL_ID),	\
	NAME_ENTRY(WLRPC_WLC_PHY_NOISE_SAMPLE_REQUEST_ID),	\
	NAME_ENTRY(WLRPC_WLC_PHY_CAL_PERICAL_ID),	\
	NAME_ENTRY(WLRPC_WLC_PHY_TXPOWER_GET_ID),	\
	NAME_ENTRY(WLRPC_WLC_PHY_TXPOWER_SET_ID),	\
	NAME_ENTRY(WLRPC_WLC_PHY_TXPOWER_SROMLIMIT_ID),	\
	NAME_ENTRY(WLRPC_WLC_PHY_RADAR_DETECT_ENABLE_ID),	\
	NAME_ENTRY(WLRPC_WLC_PHY_RADAR_DETECT_RUN_ID),	\
	NAME_ENTRY(WLRPC_WLC_PHY_TEST_ISON_ID),	\
	NAME_ENTRY(WLRPC_WLC_BMAC_COPYFROM_OBJMEM_ID),	\
	NAME_ENTRY(WLRPC_WLC_BMAC_COPYTO_OBJMEM_ID),	\
	NAME_ENTRY(WLRPC_WLC_ENABLE_MAC_ID),	\
	NAME_ENTRY(WLRPC_WLC_MCTRL_ID),	\
	NAME_ENTRY(WLRPC_WLC_CORERESET_ID), \
	NAME_ENTRY(WLRPC_WLC_BMAC_READ_SHM_ID),	\
	NAME_ENTRY(WLRPC_WLC_BMAC_READ_TSF_ID),	\
	NAME_ENTRY(WLRPC_WLC_BMAC_SET_ADDRMATCH_ID),	\
	NAME_ENTRY(WLRPC_WLC_BMAC_SET_CWMAX_ID),	\
	NAME_ENTRY(WLRPC_WLC_BMAC_SET_RCMTA_ID),	\
	NAME_ENTRY(WLRPC_WLC_BMAC_SET_SHM_ID),	\
	NAME_ENTRY(WLRPC_WLC_SUSPEND_MAC_AND_WAIT_ID),	\
	NAME_ENTRY(WLRPC_WLC_BMAC_WRITE_SHM_ID),	\
	NAME_ENTRY(WLRPC_WLC_BMAC_WRITE_TEMPLATE_RAM_ID),	\
	NAME_ENTRY(WLRPC_WLC_TX_FIFO_SUSPEND_ID),	\
	NAME_ENTRY(WLRPC_WLC_TX_FIFO_RESUME_ID),	\
	NAME_ENTRY(WLRPC_WLC_TX_FIFO_SUSPENDED_ID),	\
	NAME_ENTRY(WLRPC_WLC_HW_ETHERADDR_ID),	\
	NAME_ENTRY(WLRPC_WLC_SET_HW_ETHERADDR_ID),	\
	NAME_ENTRY(WLRPC_WLC_BMAC_CHANSPEC_SET_ID),	\
	NAME_ENTRY(WLRPC_WLC_BMAC_TXANT_SET_ID),	\
	NAME_ENTRY(WLRPC_WLC_BMAC_ANTSEL_TYPE_SET_ID),	\
	NAME_ENTRY(WLRPC_WLC_BMAC_TXFIFO_ID),	\
	NAME_ENTRY(WLRPC_WLC_RADIO_READ_HWDISABLED_ID),	\
	NAME_ENTRY(WLRPC_WLC_RM_CCA_MEASURE_ID),	\
	NAME_ENTRY(WLRPC_WLC_SET_SHORTSLOT_ID),	\
	NAME_ENTRY(WLRPC_WLC_WAIT_FOR_WAKE_ID),	\
	NAME_ENTRY(WLRPC_WLC_PHY_TXPOWER_GET_CURRENT_ID),	\
	NAME_ENTRY(WLRPC_WLC_PHY_TXPOWER_HW_CTRL_GET_ID),	\
	NAME_ENTRY(WLRPC_WLC_PHY_TXPOWER_HW_CTRL_SET_ID),	\
	NAME_ENTRY(WLRPC_WLC_PHY_BSSINIT_ID),	\
	NAME_ENTRY(WLRPC_WLC_BAND_STF_SS_SET_ID),	\
	NAME_ENTRY(WLRPC_WLC_PHY_BAND_FIRST_CHANSPEC_ID),	\
	NAME_ENTRY(WLRPC_WLC_PHY_TXPOWER_LIMIT_SET_ID),	\
	NAME_ENTRY(WLRPC_WLC_PHY_BAND_CHANNELS_ID),	\
	NAME_ENTRY(WLRPC_WLC_BMAC_REVINFO_GET_ID),	\
	NAME_ENTRY(WLRPC_WLC_BMAC_STATE_GET_ID),	\
	NAME_ENTRY(WLRPC_WLC_BMAC_XMTFIFO_SZ_GET_ID),	\
	NAME_ENTRY(WLRPC_WLC_BMAC_XMTFIFO_SZ_SET_ID),	\
	NAME_ENTRY(WLRPC_WLC_BMAC_VALIDATE_CHIP_ACCESS_ID),	\
	NAME_ENTRY(WLRPC_WLC_RM_CCA_COMPLETE_ID),	\
	NAME_ENTRY(WLRPC_WLC_RECV_ID),	\
	NAME_ENTRY(WLRPC_WLC_DOTXSTATUS_ID),	\
	NAME_ENTRY(WLRPC_WLC_HIGH_DPC_ID),	\
	NAME_ENTRY(WLRPC_WLC_FATAL_ERROR_ID),	\
	NAME_ENTRY(WLRPC_WLC_PHY_SET_CHANNEL_14_WIDE_FILTER_ID), \
	NAME_ENTRY(WLRPC_WLC_PHY_NOISE_AVG_ID),	\
	NAME_ENTRY(WLRPC_WLC_PHYCHAIN_INIT_ID), \
	NAME_ENTRY(WLRPC_WLC_PHYCHAIN_SET_ID), \
	NAME_ENTRY(WLRPC_WLC_PHYCHAIN_GET_ID), \
	NAME_ENTRY(WLRPC_WLC_PHY_TKIP_RIFS_WAR_ID), \
	NAME_ENTRY(WLRPC_WLC_BMAC_COPYFROM_VARS_ID), \
	NAME_ENTRY(WLRPC_WLC_BMAC_RETRYLIMIT_UPD_ID), \
	NAME_ENTRY(WLRPC_WLC_BMAC_BTC_MODE_SET_ID), \
	NAME_ENTRY(WLRPC_WLC_BMAC_BTC_MODE_GET_ID), \
	NAME_ENTRY(WLRPC_WLC_BMAC_BTC_WIRE_SET_ID), \
	NAME_ENTRY(WLRPC_WLC_BMAC_BTC_WIRE_GET_ID), \
	NAME_ENTRY(WLRPC_WLC_BMAC_SET_NORESET_ID), \
	NAME_ENTRY(WLRPC_WLC_AMPDU_TXSTATUS_COMPLETE_ID), \
	NAME_ENTRY(WLRPC_WLC_BMAC_FIFOERRORS_ID), \
	NAME_ENTRY(WLRPC_WLC_PHY_TXPOWER_GET_TARGET_MIN_ID), \
	NAME_ENTRY(WLRPC_WLC_PHY_TXPOWER_GET_TARGET_MAX_ID), \
	NAME_ENTRY(WLRPC_WLC_NOISE_CB_ID), \
	NAME_ENTRY(WLRPC_WLC_BMAC_LED_HW_DEINIT_ID), \
	NAME_ENTRY(WLRPC_WLC_BMAC_LED_HW_MASK_INIT_ID), \
	NAME_ENTRY(WLRPC_WLC_PLLREQ_ID), \
	NAME_ENTRY(WLRPC_WLC_BMAC_TACLEAR_ID), \
	NAME_ENTRY(WLRPC_WLC_BMAC_SET_CLK_ID), \
	NAME_ENTRY(WLRPC_WLC_PHY_OFDM_RATESET_WAR_ID), \
	NAME_ENTRY(WLRPC_WLC_PHY_BF_PREEMPT_ENABLE_ID), \
	NAME_ENTRY(WLRPC_WLC_BMAC_DOIOVARS_ID), \
	NAME_ENTRY(WLRPC_WLC_BMAC_DUMP_ID), \
	NAME_ENTRY(WLRPC_WLC_CISWRITE_ID), \
	NAME_ENTRY(WLRPC_WLC_CISDUMP_ID), \
	NAME_ENTRY(WLRPC_WLC_UPDATE_PHY_MODE_ID), \
	NAME_ENTRY(WLRPC_WLC_RESET_BMAC_DONE_ID), \
	NAME_ENTRY(WLRPC_WLC_BMAC_LED_BLINK_EVENT_ID), \
	NAME_ENTRY(WLRPC_WLC_BMAC_LED_SET_ID), \
	NAME_ENTRY(WLRPC_WLC_BMAC_LED_BLINK_ID), \
	NAME_ENTRY(WLRPC_WLC_BMAC_LED_ID), \
	NAME_ENTRY(WLRPC_WLC_BMAC_RATE_SHM_OFFSET_ID), \
	NAME_ENTRY(WLRPC_SI_ISCORE_UP_ID), \
	NAME_ENTRY(WLRPC_WLC_BMAC_PS_SWITCH_ID),	\
	NAME_ENTRY(WLRPC_WLC_PHY_STF_SSMODE_GET_ID), \
	NAME_ENTRY(WLRPC_WLC_BMAC_DEBUG_ID), \
	NAME_ENTRY(WLRPC_WLC_EXTLOG_MSG_ID), \
	NAME_ENTRY(WLRPC_WLC_EXTLOG_CFG_ID), \
	NAME_ENTRY(WLRPC_BCM_ASSERT_LOG_ID), \
	NAME_ENTRY(WLRPC_BCM_ASSERT_TYPE_ID), \
	NAME_ENTRY(WLRPC_WLC_BMAC_SET_PHYCAL_CACHE_FLAG_ID), \
	NAME_ENTRY(WLRPC_WLC_BMAC_GET_PHYCAL_CACHE_FLAG_ID), \
	NAME_ENTRY(WLRPC_WLC_PHY_CAL_CACHE_INIT_ID), \
	NAME_ENTRY(WLRPC_WLC_PHY_CAL_CACHE_DEINIT_ID), \
	NAME_ENTRY(WLRPC_WLC_BMAC_HW_UP_ID), \
	NAME_ENTRY(WLRPC_WLC_BMAC_SET_TXPWR_PERCENT_ID), \
	NAME_ENTRY(WLRPC_WLC_PHYCHAIN_ACTIVE_GET_ID), \
	NAME_ENTRY(WLRPC_WLC_BMAC_BLINK_SYNC_ID), \
	NAME_ENTRY(WLRPC_WLC_BMAC_UCODE_DBGSEL_SET_ID), \
	NAME_ENTRY(WLRPC_WLC_BMAC_UCODE_DBGSEL_GET_ID), \
	NAME_ENTRY(WLRPC_WLC_PHY_RADAR_DETECT_MODE_SET_ID), \
	NAME_ENTRY(WLRPC_WLC_PHY_ACIM_NOISEM_RESET_NPHY_ID), \
	NAME_ENTRY(WLRPC_WLC_PHY_INTERFER_SET_NPHY_ID), \
	NAME_ENTRY(WLRPC_WLC_BMAC_IFSCTL_EDCRS_SET_ID), \
	NAME_ENTRY(WLRPC_WLC_PKTENGTX), \
	NAME_ENTRY(WLRPC_WLC_BMAC_SET_DEAF), \
	NAME_ENTRY(WLRPC_WLC_BMAC_CLEAR_DEAF), \
	NAME_ENTRY(WLRPC_WLC_BMAC_BTC_FLAGS_SET_ID), \
	NAME_ENTRY(WLRPC_WLC_BMAC_BTC_FLAGS_GET_ID), \
	NAME_ENTRY(WLRPC_WLC_BMAC_SET_RCMTA_TYPE_ID), \
	NAME_ENTRY(WLRPC_WLC_BMAC_CCA_STATS_READ_ID), \
	NAME_ENTRY(WLRPC_WLC_BMAC_ANTSEL_SET_ID), \
	NAME_ENTRY(WLRPC_WLC_BMAC_SET_UCODE_LOADED), \
	NAME_ENTRY(WLRPC_WLC_PHY_LDPC_SET_ID),	\
	{0, NULL} \
	}

static __inline char *_wlc_rpc_id_lookup(const struct name_entry *tbl, int _id)
{
	const struct name_entry *elt = tbl;
	static char __unknown[64];
	for (; elt->name != NULL; elt++) {
		if (_id == elt->id)
			break;
	}
	if (_id == elt->id)
		strncpy(__unknown, elt->name, sizeof(__unknown));
	else
		snprintf(__unknown, sizeof(__unknown), "ID:%d", _id);
	return __unknown;
}

#define WLC_RPC_ID_LOOKUP(tbl, _id) (_wlc_rpc_id_lookup(tbl, _id))

#endif				/* BCMDBG */

/* refer to txpwr_limits_t for each elements, mcs32 is the at the end for 1 byte */
#define TXPOWER_XDR_SZ	(roundup(WLC_NUM_RATES_CCK, 4) + roundup(WLC_NUM_RATES_OFDM, 4) * 4 + \
	roundup(WLC_NUM_RATES_MCS_1_STREAM, 4) * 6 + roundup(WLC_NUM_RATES_MCS_2_STREAM, 4) * 2 + \
	roundup(1, 4))

#define wlc_rpc_txpwr_limits(b, txpwr, op, err)	\
	do {											\
		(err) = bcm_xdr_##op##_u8_vec((b), (txpwr)->cck, WLC_NUM_RATES_CCK);		\
		ASSERT(!(err));									\
												\
		/* 20 MHz Legacy OFDM rates with SISO transmission */				\
		(err) = bcm_xdr_##op##_u8_vec((b), (txpwr)->ofdm, WLC_NUM_RATES_OFDM);	\
		ASSERT(!(err));									\
												\
		/* 20 MHz Legacy OFDM rates with CDD transmission */				\
		(err) = bcm_xdr_##op##_u8_vec((b), (txpwr)->ofdm_cdd, WLC_NUM_RATES_OFDM);   \
		ASSERT(!(err));									\
												\
		/* 40 MHz Legacy OFDM rates with SISO transmission */				\
		(err) = bcm_xdr_##op##_u8_vec((b), (txpwr)->ofdm_40_siso, WLC_NUM_RATES_OFDM); \
		ASSERT(!(err));									\
												\
		/* 40 MHz Legacy OFDM rates with CDD transmission */				\
		(err) = bcm_xdr_##op##_u8_vec((b), (txpwr)->ofdm_40_cdd, WLC_NUM_RATES_OFDM); \
		ASSERT(!(err));									\
												\
		/* 20MHz MCS rates SISO/CDD/STBC/SDM */							 \
		(err) = bcm_xdr_##op##_u8_vec((b), (txpwr)->mcs_20_siso, WLC_NUM_RATES_MCS_1_STREAM); \
		ASSERT(!(err));									\
												\
		(err) = bcm_xdr_##op##_u8_vec((b), (txpwr)->mcs_20_cdd, WLC_NUM_RATES_MCS_1_STREAM); \
		ASSERT(!(err));									\
												\
		(err) = bcm_xdr_##op##_u8_vec((b), (txpwr)->mcs_20_stbc, WLC_NUM_RATES_MCS_1_STREAM); \
		ASSERT(!(err));									\
												\
		(err) = bcm_xdr_##op##_u8_vec((b), (txpwr)->mcs_20_mimo, WLC_NUM_RATES_MCS_2_STREAM); \
		ASSERT(!(err));									\
												\
		/* 40MHz MCS rates SISO/CDD/STBC/SDM */							 \
		(err) = bcm_xdr_##op##_u8_vec((b), (txpwr)->mcs_40_siso, WLC_NUM_RATES_MCS_1_STREAM); \
		ASSERT(!(err));									\
												\
		(err) = bcm_xdr_##op##_u8_vec((b), (txpwr)->mcs_40_cdd, WLC_NUM_RATES_MCS_1_STREAM); \
		ASSERT(!(err));									\
												\
		(err) = bcm_xdr_##op##_u8_vec((b), (txpwr)->mcs_40_stbc, WLC_NUM_RATES_MCS_1_STREAM); \
		ASSERT(!(err));									\
												\
		(err) = bcm_xdr_##op##_u8_vec((b), (txpwr)->mcs_40_mimo, WLC_NUM_RATES_MCS_2_STREAM); \
		ASSERT(!(err));									\
	} while (0)

typedef struct wlc_rpc_ctx {
	rpc_info_t *rpc;
	wlc_info_t *wlc;
	wlc_hw_info_t *wlc_hw;
} wlc_rpc_ctx_t;

static inline rpc_buf_t *wlc_rpc_buf_alloc(rpc_info_t *rpc, bcm_xdr_buf_t *b,
					   uint len, wlc_rpc_id_t rpc_id)
{
	rpc_buf_t *rpc_buf;

	rpc_buf = bcm_rpc_buf_alloc(rpc, len + sizeof(u32));

	if (!rpc_buf)
		return NULL;

	bcm_xdr_buf_init(b, bcm_rpc_buf_data(bcm_rpc_tp_get(rpc), rpc_buf),
			 len + sizeof(u32));

	bcm_xdr_pack_u32(b, rpc_id);

	return rpc_buf;
}

#if defined(BCMDBG)
static __inline wlc_rpc_id_t
wlc_rpc_id_get(struct rpc_info *rpc, rpc_buf_t *buf)
{
	wlc_rpc_id_t rpc_id;
	bcm_xdr_buf_t b;

	bcm_xdr_buf_init(&b, bcm_rpc_buf_data(bcm_rpc_tp_get(rpc), buf),
			 sizeof(u32));

	bcm_xdr_unpack_u32(&b, (u32 *)((unsigned long) & rpc_id));
	return rpc_id;
}
#endif

static __inline int _wlc_rpc_call(struct rpc_info *rpc, rpc_buf_t *send)
{
	int _err = 0;
#if defined(BCMDBG)
	wlc_rpc_id_t rpc_id = wlc_rpc_id_get(rpc, send);
	/* const struct name_entry rpc_name_tbl[] = RPC_ID_TABLE; */
	static struct name_entry rpc_name_tbl[] = RPC_ID_TABLE;
	WL_TRACE(("%s: Called id %s\n", __func__,
		  WLC_RPC_ID_LOOKUP(rpc_name_tbl, rpc_id)));
#endif
	_err = bcm_rpc_call(rpc, send);
	if (_err) {
#if defined(BCMDBG)
		WL_ERROR(("%s: Call id %s FAILED\n", __func__,
			  WLC_RPC_ID_LOOKUP(rpc_name_tbl, rpc_id)));
#endif
		_err = 0;
	}
	return _err;
}

#define wlc_rpc_call(rpc, send) (_wlc_rpc_call(rpc, send))

#include <sbhnddma.h>
#include <sbhndpio.h>
#include <d11.h>

#ifdef WLC_LOW
extern void wlc_rpc_bmac_dispatch(wlc_rpc_ctx_t *rpc_ctx, struct rpc_buf *buf);
extern void wlc_rpc_bmac_dump_txfifohist(wlc_hw_info_t *wlc_hw,
					 bool dump_clear);
#else
extern void wlc_rpc_high_dispatch(wlc_rpc_ctx_t *ctx, struct rpc_buf *buf);
#endif

/* Packed structure for ease of transport across RPC bus along u32 boundary */
typedef struct wlc_rpc_txstatus {
	u32 PAD_framelen;
	u32 status_frameid;
	u32 sequence_lasttxtime;
	u32 ackphyrxsh_phyerr;
} wlc_rpc_txstatus_t;

static inline
    void txstatus2rpc_txstatus(tx_status_t *txstatus,
			       wlc_rpc_txstatus_t *rpc_txstatus)
{
	rpc_txstatus->PAD_framelen = txstatus->framelen;
	rpc_txstatus->status_frameid =
	    (txstatus->status << 16) | txstatus->frameid;
	rpc_txstatus->sequence_lasttxtime =
	    (txstatus->sequence << 16) | txstatus->lasttxtime;
	rpc_txstatus->ackphyrxsh_phyerr =
	    (txstatus->ackphyrxsh << 16) | txstatus->phyerr;
}

static inline
    void rpc_txstatus2txstatus(wlc_rpc_txstatus_t *rpc_txstatus,
			       tx_status_t *txstatus)
{
	txstatus->framelen = rpc_txstatus->PAD_framelen & 0xffff;
	txstatus->status = (rpc_txstatus->status_frameid >> 16) & 0xffff;
	txstatus->frameid = rpc_txstatus->status_frameid & 0xffff;
	txstatus->sequence = (rpc_txstatus->sequence_lasttxtime >> 16) & 0xffff;
	txstatus->lasttxtime = rpc_txstatus->sequence_lasttxtime & 0xffff;
	txstatus->ackphyrxsh = (rpc_txstatus->ackphyrxsh_phyerr >> 16) & 0xffff;
	txstatus->phyerr = rpc_txstatus->ackphyrxsh_phyerr & 0xffff;
}

extern void wlc_bmac_dngl_reboot(rpc_info_t *rpc);

#endif				/* WLC_RPC_H */
