/*
 * Decompiled with CFR 0.152.
 */
package java.awt.dnd;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.peer.DropTargetContextPeer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.List;

public class DropTargetContext {
    private DropTarget dropTarget;
    private DropTargetContextPeer dropTargetContextPeer;
    private Transferable transferable;

    DropTargetContext(DropTarget dropTarget) {
        this.dropTarget = dropTarget;
    }

    public DropTarget getDropTarget() {
        return this.dropTarget;
    }

    public Component getComponent() {
        return this.dropTarget.getComponent();
    }

    public synchronized void addNotify(DropTargetContextPeer dropTargetContextPeer) {
        this.dropTargetContextPeer = dropTargetContextPeer;
    }

    public synchronized void removeNotify() {
        this.dropTargetContextPeer = null;
        this.transferable = null;
    }

    protected void setTargetActions(int n) {
        if (this.dropTargetContextPeer != null) {
            this.dropTargetContextPeer.setTargetActions(n);
        }
    }

    protected int getTargetActions() {
        return this.dropTargetContextPeer != null ? this.dropTargetContextPeer.getTargetActions() : this.dropTarget.getDefaultActions();
    }

    public void dropComplete(boolean bl) throws InvalidDnDOperationException {
        if (this.dropTargetContextPeer != null) {
            this.dropTargetContextPeer.dropComplete(bl);
        }
    }

    protected void acceptDrag(int n) {
        if (this.dropTargetContextPeer != null) {
            this.dropTargetContextPeer.acceptDrag(n);
        }
    }

    protected void rejectDrag() {
        if (this.dropTargetContextPeer != null) {
            this.dropTargetContextPeer.rejectDrag();
        }
    }

    protected void acceptDrop(int n) {
        if (this.dropTargetContextPeer != null) {
            this.dropTargetContextPeer.acceptDrop(n);
        }
    }

    protected void rejectDrop() {
        if (this.dropTargetContextPeer != null) {
            this.dropTargetContextPeer.rejectDrop();
        }
    }

    protected DataFlavor[] getCurrentDataFlavors() {
        return this.dropTargetContextPeer != null ? this.dropTargetContextPeer.getTransferDataFlavors() : new DataFlavor[]{};
    }

    protected List getCurrentDataFlavorsAsList() {
        return Arrays.asList(this.getCurrentDataFlavors());
    }

    protected boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return this.getCurrentDataFlavorsAsList().contains(dataFlavor);
    }

    protected synchronized Transferable getTransferable() throws InvalidDnDOperationException {
        if (this.dropTargetContextPeer == null) {
            throw new InvalidDnDOperationException();
        }
        if (this.transferable == null) {
            this.transferable = this.createTransferableProxy(this.dropTargetContextPeer.getTransferable(), this.dropTargetContextPeer.isTransferableJVMLocal());
        }
        return this.transferable;
    }

    DropTargetContextPeer getDropTargetContextPeer() {
        return this.dropTargetContextPeer;
    }

    protected Transferable createTransferableProxy(Transferable transferable, boolean bl) {
        return new TransferableProxy(transferable, bl);
    }

    protected class TransferableProxy
    implements Transferable {
        protected Transferable transferable;
        protected boolean isLocal;

        TransferableProxy(Transferable transferable, boolean bl) {
            this.transferable = transferable;
            this.isLocal = bl;
        }

        public synchronized DataFlavor[] getTransferDataFlavors() {
            return this.transferable.getTransferDataFlavors();
        }

        public synchronized boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            DataFlavor[] dataFlavorArray = this.getTransferDataFlavors();
            if (dataFlavorArray != null && dataFlavorArray.length != 0) {
                int n = 0;
                while (n < dataFlavorArray.length) {
                    if (dataFlavorArray[n].equals(dataFlavor)) {
                        return true;
                    }
                    ++n;
                }
            }
            return false;
        }

        public synchronized Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            Object object;
            if (!this.isDataFlavorSupported(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            Object var3_2 = null;
            try {
                object = this.transferable.getTransferData(dataFlavor);
            }
            catch (Exception exception) {
                throw new IOException(exception.getClass() + ":" + exception.getMessage() + " caught while getting Data");
            }
            if (this.isLocal && dataFlavor.isFlavorSerializedObjectType()) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                new ObjectOutputStream(byteArrayOutputStream).writeObject(object);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                try {
                    object = new ObjectInputStream(byteArrayInputStream).readObject();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new IOException(classNotFoundException.getMessage());
                }
            }
            return object;
        }
    }
}

