(* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is JavaScript Bridge.
 *
 * The Initial Developer of the Original Code is
 * Sterling Bates.
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Theo Lustenberger <theo@theo.ch>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** *)

(*
 *	Please send comments for enhancements, fixes, etc, to whoelse@sterlingbates.com
 *
 *	Contents: Native-code functions that can be called from inside javascript itself.
 *
 * 	Revision history:
 *		July 15, 2003 - Initial release
 *	 August 5, 2003 - Updated file notes
 *		 Nov 25, 2003 - The GetString sample crashes for some reason.  Haven't figured out why yet.
 *      Dec 7, 2003 - All code here works now
 *)

unit jssamples_natives;

(*
 * Notes
 *		- The cdecl modifier at the end of the function header is critical, since it's called from a C function
 *		- Native functions are disadvantaged because they don't have a reference to the calling TJSEngine.
 *			This requires native functions to call JS_* engine functions found in jsdecl.pas for now.
 *)

interface

uses js15decl, Dialogs;

{$I jsconfig.inc}

procedure Error_Reporter(cx: PJSContext; message: PChar; report: PJSErrorReport); cdecl;
function GetNumber(cx: PJSContext; obj: PJSObject; argc: uintN; argv, rval: pjsval): JSBool; cdecl;
function GetString(cx: PJSContext; obj: PJSObject; argc: uintN; argv, rval: pjsval): JSBool; cdecl;
function AppendString(cx: PJSContext; obj: PJSObject; argc: uintN; argv, rval: pjsval): JSBool; cdecl;

implementation

procedure Error_Reporter(cx: PJSContext; message: PChar; report: PJSErrorReport); cdecl;
begin
  ShowMessage('Error: ' +message);
end;

function GetNumber(cx: PJSContext; obj: PJSObject; argc: uintN; argv, rval: pjsval): JSBool;
begin
  JS_NewNumberValue(cx, 10, rval);
  Result := JS_TRUE;
end;

function GetString(cx: PJSContext; obj: PJSObject; argc: uintN; argv, rval: pjsval): JSBool; cdecl;
begin
	rval^ := StringToJSVal(cx, 'Howdy');
	Result := JS_TRUE;
end;

function AppendString(cx: PJSContext; obj: PJSObject; argc: uintN; argv, rval: pjsval): JSBool; cdecl;
var
  s1, s2 : TBridgeString;
begin
  if argc = 2 then
  begin
    s1 := JSStringToString(JSValToJSString(argv^));
    Inc(argv);
    s2 := JSStringToString(JSValToJSString(argv^));
    rval^ := StringToJSVal(cx, PBridgeChar(s1 + s2));
    Result := JS_TRUE;
  end
  else
    Result := JS_FALSE;
end;

end.

