/* FILEMANAGER  --  An FREE CROSS-PLATFORM XUL-BASED FILE MANAGEMENT TOOL
*  Author: Duong Thanh An - technical@anisolution.com (core)
*  Co-author: Le Phong "Apache" Bao Vuong - apache@7bit.biz (php module)
*	
*  Copyright (C) 2004 Anisolution.com
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*  Anisolution.com
*  http://www.anisolution.com
*  HCMC Vietnam
*  info@anisolution.com
*/
/*		
	 Copyright notice:
	 XUL File Manager is freeware with open source code. 
	 As long as you keep the copyright message, you can 
	 play with the code for your own purposes but you can
	 not distribute the altered version. You can not sell 
	 XUL File Manager or use it for commercial purposes.
	 Please contact us for commercial uses.

	 BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY FOR THE PROGRAM
*/

/**
 * Class XHttpConnection handles XMLHttpConnection to server
 *
 */

var DEBUG_MODE = 0;

var console = null;
if(DEBUG_MODE > 0) {
	if(!(window.opener && window.opener != window))	console = window.open("console.xul", "", "chrome,resizable=yes");
}
function debug(s) {
	if(DEBUG_MODE > 0) {
		window.opener.console.document.getElementById("content").value = s;
	}
}

function XHttpConnection(){
	 this.url = "";
	 this.method = "get";
	 this.async = false;
	 this.postData = null;
	 this.asyncHandler = null;

     this.httpError = new Object();
	 this.resetError = function () {
		 this.httpError.code = 0;
		 this.httpError.description = "";
	 };
	 this.setAsyncHandler = function (asyncHandler) {
		 this.asyncHandler = asyncHandler;
	 }

	 this.execute = function () {
		this.resetError();
		if(!this.asyncHandler && this.async) {
			this.httpError.code = 1;
			this.httpError.description = "Asynchronous Handler Required";
			return null;
		}
		if(this.async && (!this.asyncHandler.onError || !this.asyncHandler.onLoad)) {
			this.httpError.code = 2;
			this.httpError.description = "Invalid Asynchronous Handler";
			return null;
		}
		var dom = null;
		try{
			var mainRequest = new XMLHttpRequest();
			mainRequest.open(this.method, this.url, this.async);
			mainRequest.setRequestHeader("Content-Type","application/x-www-form-urlencoded");
			if(this.async) {
				var thiz = this;
				mainRequest.onerror = function(){
					thiz.httpError.code = 3;
					thiz.httpError.description = "Invalid response from server: " + mainRequest.statusText;
					thiz.asyncHandler.onError(thiz);
				};
				mainRequest.onload = function(){
					var xmlDoc = mainRequest.responseXML;
					if(xmlDoc) {
						var response = xmlDoc.getElementsByTagName("response")[0];
						if(response) {
							if (response.getAttribute("status") == "OK") {
								dom = response;
								thiz.asyncHandler.onLoad(dom);
							} else {
								var des = "";
								try{
									des = response.getElementsByTagName("errorDescription")[0].childNodes[0].nodeValue;
								}catch(e){}
								thiz.httpError.code = 4;
								thiz.httpError.description = "Operation was not successful due to the following error:\n" + des;
								thiz.asyncHandler.onError(thiz);
							}
						} else {
							thiz.httpError.code = 7;
							thiz.httpError.description = "Invalid response";
							thiz.asyncHandler.onError(thiz);
							debug(mainRequest.responseText);
						}
					} else {
						thiz.httpError.code = 6;
						thiz.httpError.description = "Invalid response from server: " + mainRequest.statusText;
						thiz.asyncHandler.onError(thiz);
						debug(mainRequest.responseText);

					}
				};
				mainRequest.send(this.postData);
			} else {
				mainRequest.send(this.postData);
				if(mainRequest.readyState == 4) { //4 = load complete
					var xmlDoc = mainRequest.responseXML;
					var response = xmlDoc.getElementsByTagName("response")[0];
					if (response.getAttribute("status") == "OK") {
						dom = response;
					}
				}
			}
		}catch(e){
			this.httpError.code = 5;
			this.httpError.description = "Unknown error: " + e;
			if(this.async) this.asyncHandler.onError(this);
		}finally{}
		if(!this.async) return dom;
	 };
 } // ~ class XHttpConnection