/* 
	FILEMANAGER  --  A FREE CROSS-PLATFORM XUL-BASED FILE MANAGEMENT TOOL
	Author: Duong Thanh An - dgthanhan@gmail.com (core)
	Co-author: Le Phong "Apache" Bao Vuong - apache@7bit.biz (php module)

	Copyright (C) 2004 Anisolution.com

	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 2.1 of the License, or (at your option) any later version.

	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	Anisolution.com
	http://www.anisolution.com
	HCMC Vietnam
	Duong Thanh An
	dgthanhan@gmail.com


	$Id: filemanager.js,v 1.1 2004/11/27 11:58:09 thanh.an Exp $

*/

const T_PROPERTY = "p";
const T_NODE = "n";
const A_NAME = "n";

var treeLoaded = false;
var currentPath = null;
var loadingPath = "/"
var windowCursor = null;
var backupCursor = null;
var isLoadingContent = false;
var currentSelection = null;
var currentContent = null;
var currentSortAsc = true;
var currentOrderBy = "name";

var navHistory = new History();
var ext = new Array(
					"java", "gif", "asp", "jsp", "js", "css", "zip", "gz", "rar", 
					"jar", "mdb", "doc", "rtf", "psd", "txt", "text", "htm", "html", 
					"php", "exe", "msi", "chm", "swf", "xls", "cpp", "c", "dsp", 
					"bmp", "jpg", "jpeg", "jpe", "png", "mp3", 
					"dsw", "h", "hpp", "cxx", "hxx", "rc", "reg", "pdf", "ps"
					);

function getExtImageForFile(name) {
	var term = "file";
	if(name.match(/\.([a-zA-Z0-9]+)$/)) {
		var t = RegExp.$1;
		for(var i = 0; i < ext.length; i++){
			if(ext[i] == t) {
				term = t;
				break;
			}
		}
	}
	return "images/types/" + term + ".png?";
}

function window_onLoad() {
	setWindowTitle("File Manager");
	setReadyStatus("Ready.");
	updateFileDescription(null);

	extensionInstallation();

	setTimeout("startReloadFolderTree(loadingPath);", 300);
	setInterval("startReloadFolderTree(loadingPath);", 3 * 60 * 1000 );
	controlToolbarButtons();
	this.isMainWindow = true;
	controlCommands();
	try{
		if(window.opener.location.href.match(/splash\.xul/)) window.opener.close();
	}catch(e){}
}

function controlToolbarButtons() {
	document.getElementById("backButton").disabled = !(navHistory.canGoBack());
	document.getElementById("nextButton").disabled = !(navHistory.canGoNext());
}
var forceSelectPath = false;
function startReloadFolderTree(path, forceReloadContent) {
	setBusyStatus("Loading folders...");
	treeLoaded = false;
	var tree = document.getElementById("folderTree");
	var xHttpConnection = new XHttpConnection();
	xHttpConnection.url = SERVER_FOLDER_TREE_PATH + "?token=" + escape(new Date());
	xHttpConnection.async = true;
	var handler = new Object();
	handler.onError = function(connection) {
		alert(connection.httpError.description);
		setReadyStatus("Failed to load folders");
	};
	handler.onLoad = function(dom) {
		constructFolderTree(dom);
		if(forceReloadContent) forceSelectPath = true;
		setReadyStatus("Ready.");
		treeLoaded = true;
		if(path) {
			if(path == currentPath) navHistory.enable = false;
			forceSelectPath = true;
			selectPath(path, true);
		}
	};
	xHttpConnection.setAsyncHandler(handler);
	xHttpConnection.execute();
}
	function constructFolderTree(dom) {
		var tree = document.getElementById("folderTree");
		var children = tree.getElementsByTagName("treechildren")[0];
		for(var i = children.childNodes.length - 1; i >=0; i--) children.removeChild(children.childNodes[i]);
		var nodes = dom.getElementsByTagName(T_NODE);
		if(nodes.length <= 0) return;
		processFolderNode(nodes[0], tree, true);
	}
	function processFolderNode(xmlNode, treeNode, first ) {
		//create the tree item
		var item = document.createElement("treeitem");
		var newChildren = document.createElement("treechildren");
		var row = document.createElement("treerow");
		var cell = document.createElement("treecell");
		item.appendChild(row);
		item.appendChild(newChildren);
		row.appendChild(cell);
		item.fsData = new Object();

		var i = 0;
		var a = null;

		item.fsData.name = "unknown";
		item.isRoot = first;
		var hasChild = false;

		a = xmlNode.childNodes;
		for(i = 0; i < a.length; i++) {
			var node = a[i];
			if(node.nodeName == T_PROPERTY){
				var name = node.getAttribute(A_NAME);
				var value = "";
				if(node.childNodes.length > 0) value = node.childNodes[0].nodeValue;

				if(name == "name") {
					item.fsData.name = value;

					if(first) item.fsData.absolutePath = "/";
					else {
						if(treeNode.isRoot) item.fsData.absolutePath = treeNode.fsData.absolutePath + value;
						else item.fsData.absolutePath = treeNode.fsData.absolutePath + "/" + value;
					}
				}

				if(name == "attributes") item.fsData.attributes = value;
				if(name == "dateCreated") item.fsData.dateCreated = value;
				if(name == "dateLastAccessed") item.fsData.dateLastAccessed = value;
				if(name == "dateLastModified ") item.fsData.dateLastModified  = value;
				if(name == "size") item.fsData.size = value;
				if(name == "type") item.fsData.type = value;
				if(name == "fstype") item.fsData.fstype = value;
			} else if(node.nodeName == T_NODE){
				hasChild = true;
				processFolderNode(node, item, false);
			}
		}
		if(!first) {
			cell.setAttribute("label", item.fsData.name);
			cell.setAttribute("src", "images/types/folder.png");
		} else {
			cell.setAttribute("label", "Root");
			cell.setAttribute("src", "images/types/root.png");
		}

		var items = treeNode.getElementsByTagName("treechildren")[0];
		items.appendChild(item);


		item.setAttribute("container" , false);
		item.setAttribute("open", false);

		if(hasChild){
			item.setAttribute("container" , true);
			item.setAttribute("class" , "FirstTreeItem");
			if(first) item.setAttribute("open" , true);
		}

	}

function location_onKeyUp(event, target) {
	if(event.keyCode == 13) goButton_onCommand(event, target);
	if(event.keyCode == 36) {	//shift home
		target.setSelectionRange(0, event.shiftKey ? target.selectionStart : 0);
	}
	if(event.keyCode == 35) {	//shift end
		target.setSelectionRange(event.shiftKey ? target.selectionStart : target.value.length, target.value.length);
	}
}
function goButton_onCommand(event, target) {
	selectPath(document.getElementById("location").value);
}
function selectPath(path, isLoadingTree) {
	var p = path;
	if(!treeLoaded) return;
	if(!p.match(/\/$/)) p += "/";	//adding last splash

	//selecting the first node
	if(p.match(/^\//)) p = p.substring(1); // remove first splash
	var tree = document.getElementById("folderTree");
	var root = getRootTreeNode();
	var node = root;
	while(p.length > 0) {
		p.match(/^([^\/]+)\/(.*)$/);
		var name = RegExp.$1;
		p = RegExp.$2;
		node = selectChildNode(node, name);
		if(!node) {
			if(isLoadingTree) showError("Path not found:\n" + path);
			else startReloadFolderTree(path);
			return;
		}
	}
	var n = node;
	while(node != root) {
		node = node.parentNode.parentNode;
		openNode(node);
	}

	var index = tree.view.getIndexOfItem(n);
	tree.view.selection.select(index);
}
	function openNode(node) {
		if(node.getAttribute("container") == "true") node.setAttribute("open", true);
	}
function getRootTreeNode(){
	if(!treeLoaded) return null;
	var tree = document.getElementById("folderTree");
	if(tree.view.rowCount <= 0) return null;
	return tree.view.getItemAtIndex(0);
}
function selectChildNode(parentNode, name) {
	//search for treechildren
	for(var i = 0; i < parentNode.childNodes.length; i++) {
		if(parentNode.childNodes[i].nodeName == "treechildren") {
			for(var j = 0; j < parentNode.childNodes[i].childNodes.length; j++){
				var node = parentNode.childNodes[i].childNodes[j];
				if(node.fsData.name == name) return node;
			}
			break;
		}
	}
}
function showError(message) {
	alert(message);
}

var lastOpenedNode = null;
function folderTree_onSelect(event, target) {
	//start building the path
	var tree = document.getElementById("folderTree");
	var list = document.getElementById("contentList");
	var index = tree.view.selection.currentIndex;
	if(index < 0) return;
	var node = tree.view.getItemAtIndex(index);
	if(lastOpenedNode) {
		lastOpenedNode.childNodes[0].childNodes[0].setAttribute("src", "images/types/folder.png");
	}
	if(!node.isRoot) {
		node.childNodes[0].childNodes[0].setAttribute("src", "images/types/folder-open.png");
		lastOpenedNode = node;
	}
	var path = "";
	do{
		path = ( node.isRoot ? "" : node.fsData.name ) + "/" + path;
		if(!node.isRoot) node = node.parentNode.parentNode;
		else break;
	}
	while (true);
	if(path == currentPath && !forceSelectPath) return;
	forceSelectPath = false;
	var locationInput = document.getElementById("location");
	locationInput.value = path;
	locationInput.select();
	loadingPath = path;
	list.focus();
	startLoadingContentList();
	navHistory.put(path);
	controlToolbarButtons();
}
function startLoadingContentList(selection) {
	if(isLoadingContent) return;
	isLoadingContent = true;
	setBusyStatus("Browsing " + loadingPath + "...");
	var list = document.getElementById("contentList");
	var currentFolderName = document.getElementById("currentFolderName");
	var name = "";
	if(loadingPath == "/") name = "Root";
	else {
		loadingPath.match(/([^\/]+)\/$/);
		name = RegExp.$1;
	}

	var xHttpConnection = new XHttpConnection();
	xHttpConnection.url = SERVER_FOLDER_CONTENT_PATH + "?token=" + escape(new Date()) + "&path=" + encodeURIComponent(loadingPath);
	xHttpConnection.async = true;
	var handler = new Object();
	handler.onError = function(connection) {
		alert(connection.httpError.description);
		setReadyStatus("Failed to load folder content");
		isLoadingContent = false;
	};
	handler.onLoad = function(dom) {
		constructFolderContent(dom, list);
		setReadyStatus("Ready.");
		currentFolderName.setAttribute("value", name);
		currentFolderName.setAttribute("tooltiptext", name);
		setWindowTitle(name + " - " + getServerName() + " - File Manager");
		currentPath = loadingPath;
		
		if(contentSelection && contentSelection.split) {
			//alert(selection);
			var a = contentSelection.split("\n");
			list.view.selection.clearSelection();
			for(var i = 0; i < a.length; i++) {
				var j = getIndexOfPath(list, a[i]);
				if(j >= 0) list.view.selection.rangedSelect(j, j, true);
			}
			contentSelection = "";
			
		}
		isLoadingContent = false;
		controlCommands();
	};
	xHttpConnection.setAsyncHandler(handler);
	xHttpConnection.execute();
}
	function getIndexOfPath(list, path) {
		for(i = 0; i < list.view.rowCount; i++) {
			var item = list.view.getItemAtIndex(i);
			if(item.fsData && item.fsData.absolutePath == path) return i;
		}
		return -1;
	}
	function parseDate(d) {
		d.match(/^([0-9]+)_([0-9]+)_([0-9]+)_([0-9]+)_([0-9]+)_([0-9]+)$/);
		return new Date(parseInt(RegExp.$1, 10), parseInt(RegExp.$2, 10), parseInt(RegExp.$3, 10), parseInt(RegExp.$4, 10), parseInt(RegExp.$5, 10), parseInt(RegExp.$6, 10))
	}
	function loadFolderContent(dom) {
		var i;
		var count = 0;
		currentContent = new Array();
		for(i = 0; i < dom.childNodes.length; i++) {
			var node = dom.childNodes[i];
			if(node.nodeName != T_NODE) continue;

			fsData = new Object();

			for(var j = 0; j < node.childNodes.length; j ++) {
				var p = node.childNodes[j];
				if(p.nodeName == T_PROPERTY) {
					var name = p.getAttribute(A_NAME);
					var value = "";
					if(p.childNodes.length > 0) value = p.childNodes[0].nodeValue;

					if(name == "name") {
						fsData.name = value;
						fsData.absolutePath = loadingPath + value;
					}
					if(name == "attributes") {
						fsData.attributes = value;
					}
					if(name == "dateCreated") {
						fsData.dateCreated = parseDate(value);
					}
					if(name == "dateLastAccessed") {
						fsData.dateLastAccessed = parseDate(value);
					}
					if(name == "dateLastModified ") {
						fsData.dateLastModified  = parseDate(value);
					}
					if(name == "size") {
						fsData.size = value;
					}
					if(name == "type") {
						fsData.type = value;
					}
					if(name == "fstype") {
						fsData.fstype = value;
					}
				}
			}
			//add this item into list
			count ++;
			currentContent.lengh = count;
			currentContent[count - 1] = fsData;
		}
	}
	//return 1 for >, 0 for == and -1 for <
	// so: 1 --->  fsData1 > fsData2
	function compareContentItem(fsData1, fsData2) {
		if(fsData1.fstype == fsData2.fstype) {
			var value1 = null;
			var value2 = null;
			var type = "string";
			if(currentOrderBy == "name") {
				value1 = fsData1.name;
				value2 = fsData2.name;
			}
			else if(currentOrderBy == "att") {
				value1 = fsData1.attributes;
				value2 = fsData2.attributes;
			}
			else if(currentOrderBy == "created") {
				value1 = fsData1.dateCreated;
				value2 = fsData2.dateCreated;
				type = "date";
			}
			else if(currentOrderBy == "accessed") {
				value1 = fsData1.dateLastAccessed;
				value2 = fsData2.dateLastAccessed;
				type = "date";
			}
			else if(currentOrderBy == "modified") {
				value1 = fsData1.dateLastModified;
				value2 = fsData2.dateLastModified;
				type = "date";
			}
			else if(currentOrderBy == "size") {
				value1 = fsData1.size;
				value2 = fsData2.size;
				type = "number";
			}
			else if(currentOrderBy == "type") {
				value1 = fsData1.type;
				value2 = fsData2.type;
			} else return 0;

			//do the comparation
			if(type == "number") {
				var v1 = parseInt(value1);
				var v2 = parseInt(value2);
				if(v1 > v2) return 1;
				if(v1 < v2) return -1;
				return 0;

			} else if ( type == "date" ) {
				var d1 = value1.getTime();
				var d2 = value2.getTime();
				if(d1 > d2) return 1;
				if(d1 < d2) return -1;
				return 0;
			} else {
				if(value1.toUpperCase() > value2.toUpperCase()) return -1;
				if(value1.toUpperCase() < value2.toUpperCase()) return 1;
				return 0;
			}

		} else {
			var factor = currentSortAsc ? 1 : -1;
			if(fsData1.fstype == "folder") return factor;
			else return -1 * factor;
		}
	}
	function treeCols_onClick(event, target) {
		if(!event.originalTarget.id.match(/^(.+)ListColumn$/)) return;
		var field = RegExp.$1;
		if(field == currentOrderBy) sortContent(currentOrderBy, !currentSortAsc);
		else sortContent(field, true);
	}
	function sortContent(fieldName, asc) {
		currentOrderBy = fieldName;
		currentSortAsc = asc;

		var listColumns = document.getElementById("listColumns");
		for(var k = 0; k < listColumns.childNodes.length; k++) {
			var col = listColumns.childNodes[k];
			if(col.nodeName != "treecol") continue;
			col.setAttribute("sortDirection", "none");
		}
		document.getElementById(currentOrderBy + "ListColumn").setAttribute("sortDirection", asc ? "ascending" : "descending");

		/*
		document.getElementById("nameOrderImage").src = "images/order-none.png";
		document.getElementById("attOrderImage").src = "images/order-none.png";
		document.getElementById("createdOrderImage").src = "images/order-none.png";
		document.getElementById("accessedOrderImage").src = "images/order-none.png";
		document.getElementById("modifiedOrderImage").src = "images/order-none.png";
		document.getElementById("sizeOrderImage").src = "images/order-none.png";
		document.getElementById("typeOrderImage").src = "images/order-none.png";

		document.getElementById(currentOrderBy + "OrderImage").src = asc ? "images/order-asc.png" : "images/order-desc.png";
		*/

		var factor = asc ? 1 : -1;
		//just a bubbling :D
		for(var i = 0; i < currentContent.length - 1; i++)
			for(var j = currentContent.length - 1; j > i; j--)
				if(compareContentItem(currentContent[i], currentContent[j]) * factor < 0) {
					var obj = currentContent[i];
					currentContent[i] = currentContent[j];
					currentContent[j] = obj;
				}
		reBuildContentList();
	}
	function padding(s, n){
		var t = "" + s;
		for(var i = ("" + s).length; i < n; i++) t = "0" + t;
		return t;
	}
	function formatDate(d) {
		var t = "";
		t += (padding(d.getMonth(), 2)) + "/";
		t += (padding(d.getDate(), 2)) + "/";		
		t += "" + d.getFullYear() + " ";		
		t += (padding(d.getHours(), 2)) + ":";
		t += (padding(d.getMinutes(), 2));
		//t += ":" + (padding(d.getSeconds() + 1, 2));
		return t;
	}
	function paddingBlank(s, n){
		var t = "" + s;
		for(var i = ("" + s).length; i < n; i++) t = " " + t;
		return t;
	}
	function reBuildContentList() {
		var list = document.getElementById("contentList");
		var children = list.getElementsByTagName("treechildren")[0];
		var i;
		for(i = children.childNodes.length - 1; i >= 0; i--) children.removeChild(children.childNodes[0]);

		for(i = 0; i < currentContent.length; i++) {
			var fsData = currentContent[i];
			
			var item = document.createElement("treeitem");
			var newChildren = document.createElement("treechildren");
			var row = document.createElement("treerow");

			var nameCell = document.createElement("treecell");
			var attCell = document.createElement("treecell");
			var dateCreatedCell = document.createElement("treecell");
			var dateAccessedCell = document.createElement("treecell");
			var dateModifiedCell = document.createElement("treecell");
			var sizeCell = document.createElement("treecell");

			sizeCell.setAttribute("properties", "sizeCell");
			nameCell.setAttribute("properties", "nameCell");
			var typeCell = document.createElement("treecell");

			item.appendChild(row);
			item.appendChild(newChildren);

			row.appendChild(nameCell);
			row.appendChild(sizeCell);
			row.appendChild(typeCell);
			row.appendChild(dateModifiedCell);
			row.appendChild(dateCreatedCell);
			row.appendChild(dateAccessedCell);
			row.appendChild(attCell);

			item.fsData = fsData;
			children.appendChild(item);

			nameCell.setAttribute("label", fsData.name);
			attCell.setAttribute("label", formatAttributes(fsData.attributes));
			dateCreatedCell.setAttribute("label", formatDate(fsData.dateCreated));
			dateAccessedCell.setAttribute("label", formatDate(fsData.dateLastAccessed));
			dateModifiedCell.setAttribute("label", formatDate(fsData.dateLastModified));
			sizeCell.setAttribute("label", formatSizeGroup3("" + Math.ceil(fsData.size / 1024)) + " KB ");
			typeCell.setAttribute("label", fsData.type);

			if(item.fsData.fstype == "folder") nameCell.setAttribute("src", "images/types/folder.png");
			else nameCell.setAttribute("src", getExtImageForFile(item.fsData.name));
		}
	}
	function formatSizeGroup3(s) {
		var t = "";
		for(var i = s.length - 1; i >= 0; i--) {
			t = s[i] + t;
			if(i < s.length - 1 && i > 0 && ((s.length - i) % 3 == 0)) t = "," + t;
		}
		return t;
	}
	function constructFolderContent(dom) {
		loadFolderContent(dom);
		sortContent("name", true);
	}
function updateFileDescription(fsData) {
	var fileName = document.getElementById("fileName");
	var fileType = document.getElementById("fileType");
	var fileModified = document.getElementById("fileModified");
	var fileSize = document.getElementById("fileSize");
	var fileAttributes = document.getElementById("fileAttributes");

	var hidden = true;
	if(fsData) hidden = false;

	fileType.setAttribute("hidden", hidden);
	fileModified.setAttribute("hidden", hidden);
	fileSize.setAttribute("hidden", hidden);
	fileAttributes.setAttribute("hidden", hidden);

	if(hidden) {
		fileName.setAttribute("value", "Please select an item.");
		fileName.setAttribute("style", "padding-left: 5px; font-weight: 400;");
		return;
	}

	fileName.setAttribute("value", fsData.name);
	fileName.setAttribute("style", "padding-left: 5px; font-weight: 900;");
	fileType.setAttribute("value", fsData.type);
	fileModified.setAttribute("value", "Modified: " + formatDate(fsData.dateLastModified));
	fileSize.setAttribute("value", "Size: " + formatSize(fsData.size));
	fileAttributes.setAttribute("value", "Attributes: " + formatAttributes(fsData.attributes));
}
function contentList_onSelect(event, target) {
	var index = target.view.selection.currentIndex;
	if(index >= 0) {
		if(target.view.selection.count == 1) {
			var item = target.view.getItemAtIndex(index);
			updateFileDescription(item.fsData);
		} else {
			updateFileDescription(null);
			var fileCount = 0;
			var folderCount = 0;
			var totalSize = 0;
			for(var i = 0 ; i < target.view.rowCount; i++){
				if(target.view.selection.isSelected(i)) {
					var item = target.view.getItemAtIndex(i);

					if(item.fsData.fstype == "file") fileCount ++;
					else folderCount ++;
					
					totalSize += parseInt(item.fsData.size);
				}
			}

			var fileName = document.getElementById("fileName");
			var fileType = document.getElementById("fileType");
			
			var selectionDes = "";
			if(fileCount > 0) {
				selectionDes += fileCount;
				selectionDes += (fileCount > 1) ? " files" : " file";
			}

			if(fileCount > 0 && folderCount > 0) {
				selectionDes +=  " and ";
			}

			if(folderCount > 0) {
				selectionDes += folderCount;
				selectionDes += (folderCount > 1) ? " folders" : " folder";
			}
			selectionDes +=  " selected";

			fileName.setAttribute("value", selectionDes);
			fileName.setAttribute("style", "padding-left: 5px; font-weight: 900;");

			fileType.setAttribute("hidden", false);
			fileType.setAttribute("value", "Total size: " + formatSize(totalSize));

			
		}
	} else {
		updateFileDescription(null);
	}
	controlCommands(event, target);
}
	function formatSize(size){
		var value = size;
		var unit = size > 1 ? "Bytes" : "Byte";
		if(value > 1024) {
			value = Math.round(value / 1024);
			unit = "KB";
			if(value > 1024) {
				value = Math.round(value / 1024);
				unit = "MB";
				if(value > 1024) {
					value = Math.round(value / 1024);
					unit = "GB";
					if(value > 1024) {
						value = Math.round(value / 1024);
						unit = "TB";
					}
				}
			}
		}

		return value + " " + unit;

	}
	function formatAttributes(att) {
		var a = parseInt(att);
		if(a == 0) return "Normal";
		var s = "";
		if((a & 1) > 0) s += "R";
		if((a & 2) > 0) s += "H";
		if((a & 4) > 0) s += "S";
		if((a & 8) > 0) s += "D";
		if((a & 16) > 0) s += "F";
		if((a & 32) > 0) s += "A";
		if((a & 64) > 0) s += "L";
		if((a & 128) > 0) s += "Z";

		return s;
	}
function contentTree_onDblClick(event, target) {
	if(event.button != 0) return;
	var index = target.parentNode.view.selection.currentIndex;
	if(index < 0) return;
	var item = target.parentNode.view.getItemAtIndex(index);
	if(!item) return;
	invokeDefaultCommand(item);
}
function openSelectedFolder() {
	var list = document.getElementById("contentList");
	var index = list.view.selection.currentIndex;
	if(index < 0) return;
	var item = list.view.getItemAtIndex(index);
	invokeDefaultCommand(item);
}
function invokeDefaultCommand(item) {
	if(item.fsData.fstype == "folder") { //navigate
		selectPath(item.fsData.absolutePath);
	} else { //file, edit or view
		runEditContentCommand();
	}
}

function navigateTo(path) {
	selectPath(path, false);
}

function goBack() {
	var path = navHistory.back();
	navHistory.enable = false;
	if(path) selectPath(path, true);
}
function goNext() {
	var path = navHistory.next();
	navHistory.enable = false;
	if(path) selectPath(path, true);
}

function goUp() {
	if(! currentPath.match(/(.*\/)([^\/]+)\/$/)) return;
	selectPath(RegExp.$1);
}

function runCopyCommand(event, target) {
	var object = getTargetObject(event);
	if(object.view.selection.count <= 0) return;
	var s = "";
	for(var i = 0; i < object.view.rowCount; i++) {
		if(object.view.selection.isSelected(i)) {
			var item = object.view.getItemAtIndex(i);
			if(s.length > 0) s += "\n";
			s += item.fsData.absolutePath;
		}
	}
	copyToClipboard(s);
	splashCursor();
	controlCommands(event, target);
}
function runCutCommand(event, target) {
	var object = getTargetObject(event);
	if(object.view.selection.count <= 0) return;
	var s = "";
	for(var i = 0; i < object.view.rowCount; i++) {
		if(object.view.selection.isSelected(i)) {
			var item = object.view.getItemAtIndex(i);
			if(s.length > 0) s += "\n";
			s += item.fsData.absolutePath;
		}
	}
	cutToClipboard(s);
	splashCursor();
	controlCommands(event, target);
}
	function getTargetObject(event) {
		var tree = document.getElementById("folderTree");
		var list = document.getElementById("contentList");
		if(event.originalTarget == tree) return tree;
		if(event.originalTarget == list) return list;

		return list;
	}

var contentSelection = "";

function runRefreshCommand(selection) {
	var locationInput = document.getElementById("location");
	var list = document.getElementById("contentList");
	locationInput.value = currentPath;
	locationInput.select();
	loadingPath = currentPath;
	list.focus();
	contentSelection = selection;
	startLoadingContentList();
	controlToolbarButtons();
}

function startInvokeCommonCommand(action, path1, path2, handler) {
	setBusyStatus("Executing " + action + "...");
	var list = document.getElementById("contentList");

	var xHttpConnection = new XHttpConnection();
	xHttpConnection.url = SERVER_COMMNON_ACTIONS_PATH;
	xHttpConnection.url +=  "?path1=" + encodeURIComponent(path1);
	xHttpConnection.url +=  "&path2=" + encodeURIComponent(path2);
	xHttpConnection.url +=  "&action=" + encodeURIComponent(action);
	xHttpConnection.url += "&token=" + escape(new Date());
	xHttpConnection.async = true;
	xHttpConnection.setAsyncHandler(handler);

	xHttpConnection.execute();
}
function fileExistsInCurrentView(name) {
	var object = getTargetObject("contentList");
	if(object.view.rowCount <= 0) return false;
	var s = "";
	for(var i = 0; i < object.view.rowCount; i++) {
		if(object.view.getItemAtIndex(i).fsData.name == name) return true;
	}
	return false;
}
function runPasteCommand(event, target) {
	if(isClipboardEmpty()) return;
	var handler = new Object();

	var content = getClipboard().content;
	var action = getClipboard().action;

	var paths = content.split("\n");
	var selection = "";
	var existingFiles = "";
	var existingCount = 0;
	for(var i = 0; i < paths.length; i++) {
		paths[i].match(/\/([^\/]+)$/);
		var name = RegExp.$1;
		selection += ( (i > 0) ? "\n" : "" ) + currentPath + name;

		//check for overwrite here
		if((currentPath + name) != paths[i] && fileExistsInCurrentView(name)) {
			if(existingFiles.length > 0 && existingCount <= 15) existingFiles += "\n";
			if(existingCount < 15) existingFiles += "    - " + name;
			else if(existingCount == 15) existingFiles += "...";
			existingCount ++;
		}
	}
	if(existingFiles.length > 0) {
		if(existingCount == 1) {
			if(!confirm("The following file/folder already exists in the destination folder:\n" + existingFiles + "\nWould you like to overwrite it?")) return;
		} else {
			if(!confirm("The following files/folders already exist in the destination folder:\n" + existingFiles + "\nWould you like to overwrite them?")) return;
		}
	}

	handler.onLoad = function(dom){
		setReadyStatus("File pasted");
		var newSel = selection;
		try{
			var selectionNode = dom.getElementsByTagName("selection")[0];
			var s = "";
			for(var i = 0; i < selectionNode.childNodes.length; i++) 
				if(selectionNode.childNodes[i].nodeName == "#text") s += selectionNode.childNodes[i].nodeValue;
			newSel = s;
		}catch(e) {}
		runRefreshCommand(newSel);
	};
	handler.onError = function(connection) {
		alert(connection.httpError.description);
		setReadyStatus("Failed to paste file(s).");
	};
	if(action == CUT) action = "move"; 
	else action = "copy";

	setBusyStatus(action == CUT ? "Moving files/folders..." : "Copying files/folders...");
	startInvokeCommonCommand(action, content, currentPath, handler);
}
function splashCursor() {
	window.setCursor("wait");
	setTimeout("window.setCursor('auto');", 200);
}

function runNewFileCommand() {
	var name = prompt("File name:");
	if(!name) return;
	if(name.match(/[\\\/:\*\?<>|"]+/)) {
		alert("\/:*?<>|\" characters cannot be used in file name.");
		return;
	}

	var filePath = currentPath + name;

	var handler = new Object();
	handler.onLoad = function(){
		setReadyStatus("File created");
		runRefreshCommand(filePath);
	};
	handler.onError = function(connection) {
		alert(connection.httpError.description);
		setReadyStatus("Failed to create empty text file.");
	};
	setBusyStatus("Creating empty text file...");
	startInvokeCommonCommand("createFile", filePath, null, handler);
}
function runNewFolderCommand() {
	var name = prompt("Folder name:");
	if(!name) return;
	if(name.match(/[\\\/:\*\?<>|"]+/)) {
		alert("\/:*?<>|\" characters cannot be used in folder name.");
		return;
	}

	var filePath = currentPath + name;

	var handler = new Object();
	handler.onLoad = function(){
		contentSelection = filePath;
		startReloadFolderTree(currentPath, true);
		setReadyStatus("Folder created");
	};
	handler.onError = function(connection) {
		alert(connection.httpError.description);
		setReadyStatus("Failed to create empty folder file.");
	};
	setBusyStatus("Creating folder file...");
	startInvokeCommonCommand("createFolder", filePath, null, handler);
}
function selectFilesFolders(names) {
}
function runDeleteCommand(event, target) {
	var object = getTargetObject(event);
	if(object.view.selection.count <= 0) return;
	if(!confirm("Are you sure you want to delete selected files/folders?")) return;
	var s = "";
	for(var i = 0; i < object.view.rowCount; i++) {
		if(object.view.selection.isSelected(i)) {
			var item = object.view.getItemAtIndex(i);
			if(s.length > 0) s += "\n";
			s += item.fsData.absolutePath;
		}
	}
	var handler = new Object();
	handler.onLoad = function(){
		runRefreshCommand();
		setReadyStatus("Files/folders deleted");
	};
	handler.onError = function(connection) {
		alert(connection.httpError.description);
		setReadyStatus("Failed to delete files/folders.");
	};
	var action = "delete";
	setBusyStatus("Deleting files/folders...");
	startInvokeCommonCommand(action, s, null, handler);
}
function runRenameCommand(event, target) {
	var object = getTargetObject(event);
	if(object.view.selection.count <= 0) return;
	var item = object.view.getItemAtIndex(object.view.selection.currentIndex);
	var name = prompt("Enter new name:", item.fsData.name);
	var oldPath = item.fsData.absolutePath;
	if(!name) return;
	if(name.match(/[\\\/:\*\?<>|"]+/)) {
		alert("\/:*?<>|\" characters cannot be used in file/folder name.");
		return;
	}
	var newPath = oldPath.replace(/\/[^\/]+$/, "") + "/" + name;
	var handler = new Object();
	handler.onLoad = function(){
		runRefreshCommand(newPath);
		setReadyStatus("File/folder renamed");
	};
	handler.onError = function(connection) {
		alert(connection.httpError.description);
		setReadyStatus("Failed to rename file/folder.");
	};
	var action = "moveWithNewName";
	setBusyStatus("Renaming file/folder...");
	startInvokeCommonCommand(action, oldPath, newPath, handler);
}

function processContextMenu(event, target) {
	var list = document.getElementById("contentList");
	var totalFiles = 0;
	var totalFolders = 0;
	for(var i = 0 ; i < list.view.rowCount; i++){
		if(list.view.selection.isSelected(i)) {
			var item = list.view.getItemAtIndex(i);
			if(item.fsData.fstype == "file") totalFiles ++;
			else totalFolders ++;
		}
	}
	var contentContextMenu = document.getElementById("contentContextMenu");
	for(var i = 0; i < contentContextMenu.childNodes.length; i++) {
		var menuItem = contentContextMenu.childNodes[i];
		if(menuItem.nodeName != "menuitem") continue;
		var fstype = menuItem.getAttribute("fstype");
		if(fstype == "file") menuItem.setAttribute("disabled", !(totalFiles > 0 && totalFolders == 0));
		if(fstype == "folder") menuItem.setAttribute("disabled", !(totalFiles == 0 && totalFolders > 0));
		if(fstype == "any") menuItem.setAttribute("disabled", !(totalFiles + totalFolders > 0));
		if(fstype == "none") menuItem.setAttribute("disabled", !(totalFiles == 0 && totalFolders == 0));
	}
}
function controlCommands(event, target) {
	var list = document.getElementById("contentList");
	var totalFiles = 0;
	var totalFolders = 0;
	var ext = "";
	for(var i = 0 ; i < list.view.rowCount; i++){
		if(list.view.selection.isSelected(i)) {
			var item = list.view.getItemAtIndex(i);
			if(item.fsData.fstype == "file") {
				if(item.fsData.name.match(/\.([^\.]+)$/)) ext = RegExp.$1;
				totalFiles ++;
			}
			else totalFolders ++;
		}
	}
	var set = document.getElementsByTagName("commandset")[0];
	for(var i = 0; i < set.childNodes.length; i++) {
		var item = set.childNodes[i];
		var fstype = item.getAttribute("fstype");
		if(fstype == "file") {
			var disabled = !(totalFiles > 0 && totalFolders == 0);
			item.setAttribute("disabled", disabled);

			if(item.hasAttribute("count") && !disabled) {
				var count = item.getAttribute("count");
				if(count == "1") {
					if(list.view.selection.count != 1) item.setAttribute("disabled", true);
					else if(item.hasAttribute("exts")) {
						if(!ext.match(new RegExp(item.getAttribute("exts"), "i"))) item.setAttribute("disabled", true);
					}
				} 
			}
		}
		if(fstype == "folder") item.setAttribute("disabled", !(totalFiles == 0 && totalFolders > 0));
		if(fstype == "any") item.setAttribute("disabled", !(totalFiles + totalFolders > 0));
		if(fstype == "none") item.setAttribute("disabled", !(totalFiles == 0 && totalFolders == 0));
	}
	var pasteCommand = document.getElementById("pasteCommand");
	pasteCommand.setAttribute("disabled", isClipboardEmpty()) ;

	var goUpCommand = document.getElementById("goUpCommand");
	goUpCommand.setAttribute("disabled", currentPath == "/") ;

}
function runPasteIntoCommand(event, target) {
	var list = document.getElementById("contentList");
	var index = list.view.selection.currentIndex;
	if(index < 0) return;
	var item = list.view.getItemAtIndex(index);
	if(item.fsData.fstype != "folder") return;

	if(isClipboardEmpty()) return;

	var handler = new Object();
	handler.onLoad = function(){
		runRefreshCommand();
		setReadyStatus("File pasted");
	};
	handler.onError = function(connection) {
		alert(connection.httpError.description);
		setReadyStatus("Failed to paste file(s).");
	};

	var action = "copy";
	if(getClipboard().action == CUT) action = "move";

	setBusyStatus(getClipboard().action == CUT ? "Moving files/folders..." : "Copying files/folders...");
	startInvokeCommonCommand(action, getClipboard().content, item.fsData.absolutePath, handler);
}
function runUploadCommand() {
	window.open(CLIENT_UPLOAD_DIALOG_PATH, "", "chrome,status=yes,dependent");
}
function runDownloadCommand() {
	var list = document.getElementById("contentList");
	var index = list.view.selection.currentIndex;
	if(index < 0) return;
	var item = list.view.getItemAtIndex(index);
	if(item.fsData.fstype != "file") return;
	window.open(SERVER_DONWLOADER_PATH + "?path=" + encodeURIComponent(item.fsData.absolutePath) + "&token=" + escape(new Date()), "_self");
}
function runEnterCommand() {
	var list = document.getElementById("contentList");
	var index = list.view.selection.currentIndex;
	if(index < 0) return;
	var item = list.view.getItemAtIndex(index);
	if(item.fsData.fstype != "file") openSelectedFolder();
	else runEditContentCommand();
}

function toolbarButton_onMouseOver(event, target) {
	var image = target.getAttribute("image");
	if(image.match(/\-hover\.png$/)) {
		image = image.replace(/\-hover\.png$/, ".png");
	} else {
		if(target.disabled) return;
		image = image.replace(/\.png$/, "-hover.png");
	}
	target.setAttribute("image", image);
}
function contentTree_onMouseDown(event, target) {
	if(event.ctrlKey || event.shiftKey || event.button == 2) return;
	target.parentNode.view.selection.clearSelection();
	target.blur();
	updateFileDescription(null);
}