/*
 * License: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Gesso, an extension for Mozilla Firefox
 *
 * The Initial Developer of the Original Code is Ningjie (Jim) Chen.
 * Portions created by the Initial Developer are Copyright (C) 2007
 * the Initial Developer. All Rights Reserved.
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the License, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the License, the GPL or the LGPL.
 *
 * See MPL.txt for terms of the Mozilla Public License Version 1.1
 * See GPL.txt for terms of the GNU General Public License Version 2.0
 * See LGPL.txt for terms of the GNU Lesser General Public License Version 2.1
 */

#pragma once


extern const nsIID nsISupportsIID;

template <typename I>
class CGessoSupports : public I {
protected:
	nsrefcnt m_ref;
public:
	NS_IMETHODIMP_(nsrefcnt) AddRef() {
		return ++m_ref;
	}
	NS_IMETHODIMP_(nsrefcnt) Release() {
		nsrefcnt tmp = --m_ref;
		if (tmp <= 0) delete this;
		return tmp;
	}
	CGessoSupports<I>() {
	}
};

template <typename I, typename T>
class CGessoUtilBase : public CGessoSupports<I> {
private:
	void *m_unused;
public:
	T *m_ptr;
	typedef I Interface;
	typedef T Type;
	NS_IMETHODIMP QueryInterface(REFNSIID iid, void **pp) {
		if (memcmp(&iid, &I::GetIID(), sizeof(nsIID)) == 0 ||
			memcmp(&iid, &iGessoUtil::GetIID(), sizeof(nsIID)) == 0 ||
			memcmp(&iid, &nsISupportsIID, sizeof(nsIID)) == 0) {
			(*pp) = reinterpret_cast<void*>(static_cast<I*>(this));
			reinterpret_cast<I*>(*pp)->AddRef();
			return NS_OK;
		}
		return NS_NOINTERFACE;
	}
	NS_IMETHODIMP GetIsNull(BOOL *aIsNull) {
		*aIsNull = m_ptr == NULL ? TRUE : FALSE;
		return NS_OK;
	}
};

// outter wrapper for convenience
//  enables usages such as pObj->Method(CGessoOutLONG(pLong));
template <typename C>
class CGessoUtil {
public:
	C &m_obj;
	typedef typename C::Interface Interface;
	typedef typename C::Type Type;
	operator Interface *() {
		return static_cast<C::Interface*>(&m_obj);
	}
	CGessoUtil<C>(Type *p) : m_obj(*new C()) {
		m_obj.m_ptr = p;
		m_obj.AddRef();
		memset(p, 0, sizeof(typename C::Type));
	}
	CGessoUtil<C>(const Type *p) : m_obj(*new C()) {
		m_obj = *new C();
		m_obj.m_ptr = const_cast<typename C::Type*>(p);
		m_obj.AddRef();
	}
	~CGessoUtil<C>() {
		m_obj.m_ptr = NULL;
		m_obj.Release();
	}
};


template <typename I, typename T>
class CGessoOutBase : public CGessoUtilBase<I, T> {
public:
	NS_IMETHODIMP GetValue(T *aValue) {*aValue = *m_ptr; return NS_OK;}
	NS_IMETHODIMP SetValue(T aValue) {*m_ptr = aValue; return NS_OK;}
};
typedef CGessoUtil<CGessoOutBase<iGessoOutLONG, LONG> >		CGessoOutLONG;
typedef CGessoUtil<CGessoOutBase<iGessoOutBOOL, BOOL> >		CGessoOutBOOL;
typedef CGessoUtil<CGessoOutBase<iGessoOutULONG, ULONG> >	CGessoOutULONG;
typedef CGessoUtil<CGessoOutBase<iGessoOutDWORD, DWORD> >	CGessoOutDWORD;
typedef CGessoUtil<CGessoOutBase<iGessoOutWORD, WORD> >		CGessoOutWORD;

class CGessoOutAStringBase : public CGessoUtilBase<iGessoOutAString, nsAString> {
public:
	NS_IMETHODIMP GetValue(nsAString & aValue) {aValue.Assign(*m_ptr); return NS_OK;}
	NS_IMETHODIMP SetValue(const nsAString & aValue) {m_ptr->Assign(aValue); return NS_OK;}
};
class CGessoOutAString : public CGessoUtil<CGessoOutAStringBase> {
public:
	CGessoOutAString(nsAString &p) : 
		CGessoUtil<CGessoOutAStringBase>(static_cast<const nsAString*>(&p)) { }
};

class CGessoStatusBase : public CGessoUtilBase<iGessoStatus, TS_STATUS> {
public:
	NS_IMETHODIMP GetDynamicFlags(DWORD *aDynamic) {*aDynamic = m_ptr->dwDynamicFlags; return NS_OK;}
	NS_IMETHODIMP SetDynamicFlags(DWORD aDynamic) {m_ptr->dwDynamicFlags = aDynamic; return NS_OK;}
	NS_IMETHODIMP GetStaticFlags(DWORD *aStatic) {*aStatic = m_ptr->dwStaticFlags; return NS_OK;}
	NS_IMETHODIMP SetStaticFlags(DWORD aStatic) {m_ptr->dwStaticFlags = aStatic; return NS_OK;}
};
typedef CGessoUtil<CGessoStatusBase> CGessoStatus;

class CGessoSelectionBase : public CGessoUtilBase<iGessoSelection, TS_SELECTION_ACP> {
public:
	NS_IMETHODIMP GetStart(LONG *aStart) {*aStart = m_ptr->acpStart; return NS_OK;}
	NS_IMETHODIMP SetStart(LONG aStart) {m_ptr->acpStart = aStart; return NS_OK;}
	NS_IMETHODIMP GetEnd(LONG *aEnd) {*aEnd = m_ptr->acpEnd; return NS_OK;}
	NS_IMETHODIMP SetEnd(LONG aEnd) {m_ptr->acpEnd = aEnd; return NS_OK;}
	NS_IMETHODIMP GetSelend(LONG *aSelend) {*aSelend = m_ptr->style.ase; return NS_OK;}
	NS_IMETHODIMP SetSelend(LONG aSelend) {m_ptr->style.ase = static_cast<TsActiveSelEnd>(aSelend); return NS_OK;}
	NS_IMETHODIMP GetInterimChar(BOOL *aInterimChar) {*aInterimChar = m_ptr->style.fInterimChar; return NS_OK;}
	NS_IMETHODIMP SetInterimChar(BOOL aInterimChar) {m_ptr->style.fInterimChar = aInterimChar; return NS_OK;}
};
typedef CGessoUtil<CGessoSelectionBase> CGessoSelection;

class CGessoRunInfoBase : public CGessoUtilBase<iGessoRunInfo, TS_RUNINFO> {
public:
	NS_IMETHODIMP GetCount(ULONG *aCount) {*aCount = m_ptr->uCount; return NS_OK;}
	NS_IMETHODIMP SetCount(ULONG aCount) {m_ptr->uCount = aCount; return NS_OK;}
	NS_IMETHODIMP GetType(LONG *aType) {*aType = m_ptr->type; return NS_OK;}
	NS_IMETHODIMP SetType(LONG aType) {m_ptr->type = static_cast<TsRunType>(aType); return NS_OK;}
};
class CGessoRunInfo : public CGessoUtil<CGessoRunInfoBase> {
public:
	CGessoRunInfo() : CGessoUtil<CGessoRunInfoBase>(static_cast<const TS_RUNINFO*>(NULL)) {}
};

class CGessoTextChangeBase : public CGessoUtilBase<iGessoTextChange, TS_TEXTCHANGE> {
public:
	NS_IMETHODIMP GetStart(LONG *aStart) {*aStart = m_ptr->acpStart; return NS_OK;}
	NS_IMETHODIMP SetStart(LONG aStart) {m_ptr->acpStart = aStart; return NS_OK;}
	NS_IMETHODIMP GetOldEnd(LONG *aOldEnd) {*aOldEnd = m_ptr->acpOldEnd; return NS_OK;}
	NS_IMETHODIMP SetOldEnd(LONG aOldEnd) {m_ptr->acpOldEnd = aOldEnd; return NS_OK;}
	NS_IMETHODIMP GetNewEnd(LONG *aNewEnd) {*aNewEnd = m_ptr->acpNewEnd; return NS_OK;}
	NS_IMETHODIMP SetNewEnd(LONG aNewEnd) {m_ptr->acpNewEnd = aNewEnd; return NS_OK;}
};
typedef CGessoUtil<CGessoTextChangeBase> CGessoTextChange;

class CGessoAttrValBase : public CGessoUtilBase<iGessoAttrVal, TS_ATTRVAL> {
public:
	NS_IMETHODIMP GetId(iGessoAttrID *aId) {*aId = m_ptr->idAttr; return NS_OK;}
	NS_IMETHODIMP SetId(iGessoAttrID aId) {m_ptr->idAttr = aId; return NS_OK;}
	NS_IMETHODIMP GetStrVal(nsAString & /*aStrVal*/) {return NS_ERROR_NOT_IMPLEMENTED;}
	NS_IMETHODIMP SetStrVal(const nsAString & aStrVal) {
		VariantClear(&m_ptr->varValue); m_ptr->varValue.vt = VT_BSTR;
		m_ptr->varValue.bstrVal = SysAllocStringLen(aStrVal.BeginReading(), aStrVal.Length());
		return NS_OK;
	}
	NS_IMETHODIMP GetBoolVal(BOOL * /*aBoolVal*/) {return NS_ERROR_NOT_IMPLEMENTED;}
	NS_IMETHODIMP SetBoolVal(BOOL aBoolVal) {
		VariantClear(&m_ptr->varValue); m_ptr->varValue.vt = VT_BOOL;
		m_ptr->varValue.boolVal = aBoolVal ? VARIANT_TRUE : VARIANT_FALSE;
		return NS_OK;
	}
	NS_IMETHODIMP GetLongVal(LONG * /*aLongVal*/) {return NS_ERROR_NOT_IMPLEMENTED;}
	NS_IMETHODIMP SetLongVal(LONG aLongVal) {
		VariantClear(&m_ptr->varValue); m_ptr->varValue.vt = VT_I4;
		m_ptr->varValue.lVal = aLongVal; return NS_OK;
	}
	NS_IMETHODIMP GetUlongVal(ULONG * /*aUlongVal*/) {return NS_ERROR_NOT_IMPLEMENTED;}
	NS_IMETHODIMP SetUlongVal(ULONG aUlongVal) {
		VariantClear(&m_ptr->varValue); m_ptr->varValue.vt = VT_UI4;
		m_ptr->varValue.ulVal = aUlongVal; return NS_OK;
	}
	NS_IMETHODIMP GetDoubleVal(DOUBLE * /*aDoubleVal*/) {; return NS_ERROR_NOT_IMPLEMENTED;}
	NS_IMETHODIMP SetDoubleVal(DOUBLE aDoubleVal) {
		VariantClear(&m_ptr->varValue); m_ptr->varValue.vt = VT_R8;
		m_ptr->varValue.dblVal = aDoubleVal; return NS_OK;
	}
};
class CGessoAttrVal : public CGessoUtil<CGessoAttrValBase> {
public:
	CGessoAttrVal() : CGessoUtil<CGessoAttrValBase>(static_cast<const TS_ATTRVAL*>(NULL)) {}
};

class CGessoPointBase : public CGessoUtilBase<iGessoPoint, POINT> {
public:
	NS_IMETHODIMP GetX(LONG *aX) {*aX = m_ptr->x; return NS_OK;}
	NS_IMETHODIMP SetX(LONG aX) {m_ptr->x = aX; return NS_OK;}
	NS_IMETHODIMP GetY(LONG *aY) {*aY = m_ptr->y; return NS_OK;}
	NS_IMETHODIMP SetY(LONG aY) {m_ptr->y = aY; return NS_OK;}
};
typedef CGessoUtil<CGessoPointBase> CGessoPoint;

class CGessoRectBase : public CGessoUtilBase<iGessoRect, RECT> {
public:
	NS_IMETHODIMP GetLeft(LONG *aLeft) {*aLeft = m_ptr->left; return NS_OK;}
	NS_IMETHODIMP SetLeft(LONG aLeft) {m_ptr->left = aLeft; return NS_OK;}
	NS_IMETHODIMP GetTop(LONG *aTop) {*aTop = m_ptr->top; return NS_OK;}
	NS_IMETHODIMP SetTop(LONG aTop) {m_ptr->top = aTop; return NS_OK;}
	NS_IMETHODIMP GetRight(LONG *aRight) {*aRight = m_ptr->right; return NS_OK;}
	NS_IMETHODIMP SetRight(LONG aRight) {m_ptr->right = aRight; return NS_OK;}
	NS_IMETHODIMP GetBottom(LONG *aBottom) {*aBottom = m_ptr->bottom; return NS_OK;}
	NS_IMETHODIMP SetBottom(LONG aBottom) {m_ptr->bottom = aBottom; return NS_OK;}
};
typedef CGessoUtil<CGessoRectBase> CGessoRect;

// for AccTextGetBounds
class CGessoRealRect : public CGessoSupports<iGessoRect>, public RECT {
public:
	NS_IMETHODIMP QueryInterface(REFNSIID iid, void **pp) {
		if (memcmp(&iid, &GetIID(), sizeof(nsIID)) == 0 ||
			memcmp(&iid, &iGessoUtil::GetIID(), sizeof(nsIID)) == 0 ||
			memcmp(&iid, &nsISupportsIID, sizeof(nsIID)) == 0) {
			(*pp) = reinterpret_cast<void*>(static_cast<iGessoRect*>(this));
			reinterpret_cast<iGessoRect*>(*pp)->AddRef();
			return NS_OK;
		}
		return NS_NOINTERFACE;
	}
	NS_IMETHODIMP GetIsNull(BOOL *aIsNull) {*aIsNull = FALSE; return NS_OK;}
	NS_IMETHODIMP GetLeft(LONG *aLeft) {*aLeft = left; return NS_OK;}
	NS_IMETHODIMP GetTop(LONG *aTop) {*aTop = top; return NS_OK;}
	NS_IMETHODIMP GetRight(LONG *aRight) {*aRight = right; return NS_OK;}
	NS_IMETHODIMP GetBottom(LONG *aBottom) {*aBottom = bottom; return NS_OK;}
	NS_IMETHODIMP SetLeft(LONG aLeft) {left = aLeft; return NS_OK;}
	NS_IMETHODIMP SetTop(LONG aTop) {top = aTop; return NS_OK;}
	NS_IMETHODIMP SetRight(LONG aRight) {right = aRight; return NS_OK;}
	NS_IMETHODIMP SetBottom(LONG aBottom) {bottom = aBottom; return NS_OK;}
};

