var gCallLogFile = null;
var gCallLogOutputStream = null;
var gCallDatabaseFile = null;
var gArguments = window.arguments[0];

function start_profiling() {
  try {
    gCallLogFile = tmpfile('hrprofiler.call-log', 0600);
    gCallLogOutputStream = open_output_stream(
      gCallLogFile, PR_WRONLY | PR_CREATE_FILE | PR_TRUNCATE, 0600);

    dump("turning on profiling\n");
    try {
      gHrp.startProfiling(gCallLogOutputStream, gArguments.timer);
    } catch(ex if ex.name === 'NS_ERROR_NOT_AVAILABLE') {
      gPrompts.alert(window, 'HRProfiler',
                     'Something already has already hooked into the Javascript ' +
                     'debugging framework, and hrprofiler cannot run.\n' +
                     '\n' +
                     'In particular, Venkman is incompatible with hrprofiler. ' +
                     'Please uninstall or disable this extension, then try again.');
      window.close();
    }
  } catch(ex) {
    gPrompts.alert(window, 'HRProfiler', ex);
    window.close();
  }
}

function stop_profiling() {
  dump("turning off profiling\n");
  gHrp.endProfiling();
  gCallLogOutputStream.close();
  gCallLogOutputStream = null;

  // Parse what we've recorded into a temporary database file. The
  // user can save this database file elsewhere later.
  gCallDatabaseFile = tmpfile('hrprofilertmp.hrprofiler', 0600);
  var db = new HRPCallTree(gCallDatabaseFile);

  var ret = {};
  var input = open_input_stream(gCallLogFile, PR_RDONLY);

  try {
    var ss = input.QueryInterface(Ci.nsISeekableStream);
    ss.seek(2, 0);
    var total_size = ss.tell();
    ss.seek(0, 0);


    var iterator = db.parseCallLog(input, 500);
    window.openDialog('chrome://ffhrtimer/content/ffhrprofiler_progress.xul',
                      '_blank',
                      'modal,centerscreen',
                      {
                        iterator: iterator,
                        get_progress_func: function() ss.tell(),
                        get_total_func: function() total_size,
                        message: "Analyzing…"
                      },
                      ret);
  } finally {
    if(iterator) {
      iterator.close();
    }
    
    input.close();
  }

  if(!ret.canceled) {
    hrp_open(gCallDatabaseFile, true);
    gCallDatabaseFile = null; // so onunload doesn't delete it. That
                              // is the responsibility of the result
                              // window we just launched.
  }

  db.close();
  window.close();
}

function hrp_handleclose(e) {
  if(gHrp.profiling) {
    if(! gPrompts.confirm(
      window, "HRProfiler",
      "Closing window will cancel profiling. Continue?"))
    {
      e.preventDefault();
    }
  }
}

function hrp_onunload() {
  if(gHrp.profiling) {
    gHrp.endProfiling();
  }

  if(gCallLogOutputStream) {
    gCallLogOutputStream.close();
  }

  if(gCallLogFile) {
    gCallLogFile.remove(false /*nonrecursive*/);
  }

  if(gCallDatabaseFile) {
    gCallDatabaseFile.remove(false /*nonrecursive*/);
  }
}

window.addEventListener('close', hrp_handleclose, false);
window.addEventListener('unload', hrp_onunload, false);

