var Cc = Components.classes;
var Ci = Components.interfaces;
var Cr = Components.results;

var XHTML = "http://www.w3.org/1999/xhtml";

/* Services */
var gHrp = Cc["@merrillpress.com/hrprofiler;1"]
  .getService();
var gPrompts = Cc["@mozilla.org/embedcomp/prompt-service;1"]
  .getService(Ci.nsIPromptService);
var gStorageService = Cc["@mozilla.org/storage/service;1"]
  .getService(Ci.mozIStorageService);
var gThreadManager = Cc["@mozilla.org/thread-manager;1"].getService();
var gStatementWrapper = Cc["@mozilla.org/storage/statement-wrapper;1"];
var gHrc = Cc["@merrillpress.com/hrcov;1"].getService();
var gIO = Cc["@mozilla.org/network/io-service;1"]
  .getService(Ci.nsIIOService);

function AsyncURLFetcherListener(context, uri) {
  this.context = context;
  this.uri = uri;
}

AsyncURLFetcherListener.prototype = {
  constructor: AsyncURLFetcherListener,

  toString: function() {
    return '[object ' + this.constructor.name + ']';
  },
  
  // nsIUnicharStreamLoaderObserver
  onDetermineCharset: function(loader, ignored, firstsegment, len) {
    var charset = this.getDefaultCharset();
    if(loader.channel.contentCharset) {
      charset = loader.channel.contentCharset;
    }

    return charset;
  },

  // nsIUnicharStreamLoaderObserver
  onStreamComplete: function(loader, ignored, status, data) {
    this.context.numLeft--;
    this.context.source[this.uri] = null;

    if(status === Cr.NS_OK && data) {
      var parts = [];
      var chars_read = 1;
      var tmp = {};

      for(;;) {
        chars_read = data.readString(4096, tmp);
        if(chars_read) {
          parts.push(tmp.value);
        } else {
          break;
        }
      }

      this.context.source[this.uri] = parts.join('');
    } else if(status !== Cr.NS_OK) {
      dump('ERROR fetching "' + this.uri + '": ' + status + '\n');
    } else if(!data) {
      dump('no data for "' + this.uri + '"\n');
    }

    if(!this.context.numLeft) {
      this.context._onDone();
    }
  },

  getDefaultCharset: function() {
    var pref_svc = Cc["@mozilla.org/preferences-service;1"]
      .getService(Ci.nsIPrefService);
  
    var branch = pref_svc.getBranch(null);
    var prefVal = branch.getComplexValue("intl.charset.default",
                                         Ci.nsIPrefLocalizedString);
    if(prefVal) {
      return prefVal.toString();
    }

    return 'ISO-8859-1';
  }
}

function ASyncURLFetcher(urls, done_callback) {
  this.numLeft = 0;
  this.source = {};
  this.doneCallback = done_callback;

  for(var i = 0; i < urls.length; ++i) {
    var url_s = urls[i];

    try {
      var uri = gIO.newURI(url_s, null, null);
    } catch(ex) {
      this.source[url_s] = null;
      continue;
    }
    
    var channel = gIO.newChannelFromURI(uri);
    var listener = new AsyncURLFetcherListener(this, url_s);

    var sl = Cc["@mozilla.org/network/unichar-stream-loader;1"]
      .createInstance(Ci.nsIUnicharStreamLoader);
    sl.init(listener, Ci.nsIUnicharStreamLoader.DEFAULT_SEGMENT_SIZE);
    this.numLeft++;
    
    try {
      channel.asyncOpen(sl, listener);
    } catch(ex) {
      dump('cannot open channel, ignoring\n');
      this.source[url_s] = null;
      this.numLeft--;
    }
  }
}

ASyncURLFetcher.prototype = {
  constructor: ASyncURLFetcher,

  cancel: function() {
    this.doneCallback = function() {}
  },

  _onDone: function() {
    this.doneCallback(this.source);
  }
};

function clear_children(elem) {
  var c;
  while((c = elem.firstChild)) {
    elem.removeChild(c);
  }
}

function quote_regexp(s) {
  return s.replace(/[\\^$*+?.(){}\[\]]/g, "\\$1");
}

function update_tree_sorting(tree_element) {
  var sort_resource = tree_element.getAttribute('sortResource');
  var sort_direction = tree_element.getAttribute('sortDirection');

  // Make columns reflect dimension
  var cols = tree_element.getElementsByTagName('treecol');
  for(var i = 0; i < cols.length; ++i) {
    var col = cols[i];
    if(col.id === sort_resource) {
      col.setAttribute('sortDirection', sort_direction);
    } else {
      col.removeAttribute('sortDirection');
    }
  }

  return [sort_resource, sort_direction];
}

function assert(func, thisp) {
  if(!func.call(thisp)) {
    throw new Error('assertion failed: ' + func.toSource());
  }
}

function force_redraw() {
  window
    .QueryInterface(Ci.nsIInterfaceRequestor)
    .getInterface(Ci.nsIWebNavigation)
    .QueryInterface(Ci.nsIBaseWindow)
    .repaint(true);
}

function pump_events() {
  var thread = gThreadManager.currentThread;
  while(thread.processNextEvent(false)) {
    ;
  }
}

/**
  * Set the script timeout pref to the given number of seconds and
  * return the old value.
  * 
  */
function set_script_timeout(value) {
  var pref_svc = Cc["@mozilla.org/preferences-service;1"]
    .getService(Ci.nsIPrefService);
  
  var branch = pref_svc.getBranch(null);
  var pref = "dom.max_chrome_script_run_time";
  var old_value = branch.getIntPref(pref);
  branch.setIntPref(pref, value);
  return old_value;
}

var PR_RDONLY      = 0x01
var PR_WRONLY      = 0x02
var PR_RDWR        = 0x04;
var PR_CREATE_FILE = 0x08;
var PR_APPEND      = 0x10;
var PR_TRUNCATE    = 0x20;
var PR_SYNC        = 0x40;
var PR_EXCL        = 0x80;

/**
  * Open the given file as an output stream
  *
  * @param file: nsIFile naming file
  * @param mode: bitfield, PR_* constants
  * @param perms: octal unix permission bits
  * @return: nsIOutputStream
  */
function open_output_stream(file, mode, perms) {
  var s = Components.classes["@mozilla.org/network/file-output-stream;1"]
    .createInstance(Ci.nsIFileOutputStream);

  s.init(file, mode, perms, 0);
  return s;
}

/**
  * Open the given file as an input stream
  *
  * @param file: nsIFile naming the file
  * @param mode: bitfield, PR_* constants
  * @param perm: defaults to 0600
  * @param flags: defaults to 0
  * @return: nsIInputStream
  */
function open_input_stream(file, mode, perm, flags) {
  var s = Components.classes["@mozilla.org/network/file-input-stream;1"]
    .createInstance(Ci.nsIFileInputStream);
  s.init(file, mode, perm || 0600, flags || 0);
  return s;
}

/**
  * Create a temporary file that includes the given template-name.
  * 
  * @param perms: unix permission mask
  * @return: nsIFile
  */
function tmpfile(template, perms) {
  var tmp = Components.classes["@mozilla.org/file/directory_service;1"]
    .getService(Ci.nsIProperties)
    .get("TmpD", Ci.nsIFile);
  tmp.append(template);
  tmp.createUnique(Ci.nsIFile.NORMAL_FILE_TYPE, 0600);
  return tmp;
}

