/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jrex.window;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.mozilla.jrex.JRexFactory;
import org.mozilla.jrex.exception.JRexException;
import org.mozilla.jrex.log.JRexL;
import org.mozilla.jrex.ui.JRexCanvas;
import org.mozilla.jrex.ui.JRexMenuBar;
import org.mozilla.jrex.ui.JRexPopupMenu;
import org.mozilla.jrex.ui.JRexResource;
import org.mozilla.jrex.ui.JRexStatusBar;
import org.mozilla.jrex.ui.JRexToolBar;
import org.mozilla.jrex.window.JRexBaseBrowser;
import org.mozilla.jrex.window.JRexBrowserData;
import org.mozilla.jrex.window.JRexWindowManager;

public class JRexTabbedBrowser
extends JRexBaseBrowser
implements ChangeListener,
ActionListener {
    private static final String className;
    private static final String TB_NEW_TAB;
    private static final String TB_RELOAD_TAB;
    private static final String TB_CLOSE_TAB;
    private static final String TB_CANCEL;
    private Hashtable dressTable = new Hashtable();
    JMenuItem closeItem;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected JRexTabbedBrowser() {
    }

    public void init(JComponent comp) {
        if (JRexL.on) {
            JRexL.log(className, "**** init()-->comp<" + comp + ">");
        }
        this.rootComponent = comp;
        if (this.rootComponent == null) {
            if (JRexL.on) {
                JRexL.log(className, "**** init()-->rootComponent is null ");
            }
            JFrame frame = new JFrame("JRex - ");
            frame.setIconImage(JRexResource.getIcon("jrex").getImage());
            this.rootComponent = new JPanel();
            frame.setContentPane(this.rootComponent);
            this.rootWindow = frame;
            this.rootCreated = true;
        } else {
            this.rootWindow = SwingUtilities.windowForComponent(this.rootComponent);
        }
        this.rootComponent.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        final JTabbedPane tabPane = new JTabbedPane();
        final JPopupMenu pMenu = this.createTabPopupMenu();
        tabPane.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                this.handleIt(e);
            }

            public void mouseReleased(MouseEvent e) {
                this.handleIt(e);
            }

            private final void handleIt(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JRexTabbedBrowser.this.closeItem.setEnabled(tabPane.getTabCount() > 1);
                    pMenu.show(tabPane, e.getX(), e.getY());
                }
            }
        });
        tabPane.addChangeListener(this);
        tabPane.addTab("[Untitlied]", panel);
        this.rootComponent.add(tabPane);
        JRexCanvas browser = JRexCanvas.createBrowserComponent(1L);
        JRexBrowserData browserData = this.setupBrowser(panel, this.rootComponent, this.rootWindow, 4094L, browser);
        browserData.setAdditionalData(tabPane);
        this.dressUP(this.rootComponent, browserData, 2);
        if (JRexL.on) {
            JRexL.log(className, "**** init()-->Dressup Done!!");
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (JRexTabbedBrowser.this.rootCreated) {
                    ((Frame)JRexTabbedBrowser.this.rootWindow).setExtendedState(6);
                }
                if (!JRexTabbedBrowser.this.rootWindow.isVisible()) {
                    JRexTabbedBrowser.this.rootWindow.setVisible(true);
                } else {
                    JRexTabbedBrowser.this.rootWindow.validate();
                }
                if (JRexL.on) {
                    JRexL.log(className, "**** init()--> Set visible Done!!");
                }
            }
        });
        if (JRexL.on) {
            JRexL.log(className, "**** init()--> Done!!");
        }
    }

    private JPopupMenu createTabPopupMenu() {
        JPopupMenu mainPopupMenu = new JPopupMenu();
        mainPopupMenu.setLightWeightPopupEnabled(false);
        JMenuItem item = this.createMenuItem(TB_NEW_TAB);
        mainPopupMenu.add(item);
        mainPopupMenu.addSeparator();
        item = this.createMenuItem(TB_RELOAD_TAB);
        mainPopupMenu.add(item);
        this.closeItem = item = this.createMenuItem(TB_CLOSE_TAB);
        mainPopupMenu.add(item);
        mainPopupMenu.addSeparator();
        item = this.createMenuItem(TB_CANCEL);
        mainPopupMenu.add(item);
        return mainPopupMenu;
    }

    private final JMenuItem createMenuItem(String itemCmd) {
        JMenuItem menuItem = new JMenuItem(itemCmd);
        menuItem.setMnemonic(JRexResource.getMnemonicChar(itemCmd));
        menuItem.addActionListener(this);
        return menuItem;
    }

    protected void dressUP(JComponent mainPanel, JRexBrowserData browserData, int mode) {
        JRexCanvas browser = browserData.getBrowser();
        long chromeFlags = browserData.getChromeFlags();
        Dress dress = (Dress)this.dressTable.get(browserData.getWindow());
        if (JRexL.on) {
            JRexL.log(className, "**** dressUP() --> Checking for Dress ****");
        }
        if (dress == null) {
            if (JRexL.on) {
                JRexL.log(className, "**** dressUP() --> Creating new Dress ****");
            }
            JRexToolBar toolBar = null;
            if ((0x20L & chromeFlags) == 32L) {
                toolBar = (JRexToolBar)JRexFactory.getInstance().getImplNewInstance("JRexToolBar");
                toolBar.setModeAndChrome(mode, chromeFlags);
                toolBar.setBrowser(browser);
            }
            JRexMenuBar menuBar = null;
            if ((0x10L & chromeFlags) == 16L) {
                menuBar = (JRexMenuBar)JRexFactory.getInstance().getImplNewInstance("JRexMenuBar");
                menuBar.setBrowser(browser);
                menuBar.setMode(mode);
            }
            JRexStatusBar statusBar = null;
            if ((0x80L & chromeFlags) == 128L) {
                statusBar = (JRexStatusBar)JRexFactory.getInstance().getImplNewInstance("JRexStatusBar");
                statusBar.setBrowser(browser);
                statusBar.setMode(mode);
            }
            JRexPopupMenu popupMenu = (JRexPopupMenu)JRexFactory.getInstance().getImplNewInstance("JRexPopupMenu");
            popupMenu.setMode(mode);
            popupMenu.setBrowser(browser);
            dress = new Dress(toolBar, menuBar, statusBar, popupMenu);
            this.dressTable.put(browserData.getWindow(), dress);
            if (JRexL.on) {
                JRexL.log(className, "**** dressUP() --> Creating new Dress Done****");
            }
        }
        if (JRexL.on) {
            JRexL.log(className, "**** dressUP() --> Adding Menubar ****");
        }
        JPanel menuPanel = new JPanel(new BorderLayout());
        if ((0x10L & chromeFlags) == 16L) {
            menuPanel.add((Component)dress.getMenuBar().getMenuBar(), "North");
            dress.getMenuBar().setBrowser(browser);
        }
        if (JRexL.on) {
            JRexL.log(className, "**** dressUP() --> Adding toolBar ****");
        }
        if ((0x20L & chromeFlags) == 32L) {
            JComponent myToolBar = dress.getToolBar().getToolBar();
            dress.getToolBar().setBrowser(browser);
            if (myToolBar != null) {
                menuPanel.add(myToolBar);
            }
        }
        if (menuPanel.getComponentCount() > 0) {
            mainPanel.add((Component)menuPanel, "North");
        }
        if (JRexL.on) {
            JRexL.log(className, "**** dressUP() --> Adding StatusBar ****");
        }
        if ((0x80L & chromeFlags) == 128L) {
            mainPanel.add((Component)dress.getStatusBar().getStatusBar(), "South");
            dress.getStatusBar().setBrowser(browser);
        }
        if (JRexL.on) {
            JRexL.log(className, "**** dressUP() --> Adding PopupMenu ****");
        }
        dress.getPopupMenu().setBrowser(browser);
    }

    public void openNewWindow(final int parentPeer, String uri, int loadFlags) {
        block4: {
            if (JRexL.on) {
                JRexL.log(className, "**** openNewWindow()-->parentPeer<" + parentPeer + "> uri<" + uri + "> loadFlags<" + loadFlags + ">");
            }
            final JFrame frame = new JFrame("JRex - ");
            frame.setIconImage(JRexResource.getIcon("jrex").getImage());
            JPanel mainPanel = new JPanel(new BorderLayout());
            mainPanel.setBorder(BorderFactory.createEmptyBorder());
            frame.setContentPane(mainPanel);
            final JTabbedPane tabPane = new JTabbedPane();
            final JPopupMenu pMenu = this.createTabPopupMenu();
            tabPane.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    this.handleIt(e);
                }

                public void mouseReleased(MouseEvent e) {
                    this.handleIt(e);
                }

                private final void handleIt(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        JRexTabbedBrowser.this.closeItem.setEnabled(tabPane.getTabCount() > 1);
                        pMenu.show(tabPane, e.getX(), e.getY());
                    }
                }
            });
            tabPane.addChangeListener(this);
            JPanel panel = new JPanel();
            tabPane.addTab("[Untitlied]", panel);
            mainPanel.add(tabPane);
            JRexCanvas browser = JRexCanvas.createBrowserComponent(1L);
            JRexBrowserData browserData = this.setupBrowser(panel, mainPanel, frame, 4094L, browser);
            browserData.setAdditionalData(tabPane);
            this.dressUP(mainPanel, browserData, 2);
            if (JRexL.on) {
                JRexL.log(className, "**** OpenNewWindow()-->Dressup Done!!");
            }
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    Window parent;
                    JRexBrowserData browserData = (JRexBrowserData)JRexTabbedBrowser.this.windowTable.get(new Integer(parentPeer));
                    if (JRexL.on) {
                        JRexL.log(className, "**** OpenNewWindow()-->parentWindow browserData <" + browserData + ">");
                    }
                    Window window = parent = browserData != null ? browserData.getWindow() : JRexTabbedBrowser.this.rootWindow;
                    if (JRexL.on) {
                        JRexL.log(className, "**** OpenNewWindow()--> parent <" + parent + ">");
                    }
                    if (parent != null) {
                        frame.setLocationRelativeTo(parent);
                    }
                    frame.setExtendedState(6);
                    frame.setVisible(true);
                }
            });
            try {
                URI myURI = new URI(uri);
                browser.getNavigator().loadURI(myURI.toASCIIString(), loadFlags, null, null, null);
            }
            catch (Exception uex) {
                if (!JRexL.on) break block4;
                JRexL.printStackTrace(uex);
            }
        }
    }

    public void openNewTab(int parentPeer, String uri, int loadFlags) {
        block5: {
            if (JRexL.on) {
                JRexL.log(className, "**** openNewTab()-->parentPeer<" + parentPeer + "> uri<" + uri + "> loadFlags<" + loadFlags + ">");
            }
            JRexBrowserData parentBrowserData = (JRexBrowserData)this.windowTable.get(new Integer(parentPeer));
            if (JRexL.on) {
                JRexL.log(className, "**** openNewTab()--> parentBrowserData <" + parentBrowserData + ">");
            }
            if (!$assertionsDisabled && parentBrowserData == null) {
                throw new AssertionError();
            }
            JTabbedPane tabPane = (JTabbedPane)parentBrowserData.getAdditionalData();
            JPanel panel = new JPanel(new BorderLayout());
            panel.setBorder(BorderFactory.createEmptyBorder());
            JRexCanvas browser = JRexCanvas.createBrowserComponent(1L);
            panel.add(browser);
            tabPane.addTab("[Untitlied]", panel);
            parentBrowserData.getWindow().pack();
            JRexBrowserData browserData = this.addWindow(browser, panel, parentBrowserData.getParent(), parentBrowserData.getWindow(), 4094L);
            browserData.setAdditionalData(tabPane);
            tabPane.setSelectedIndex(tabPane.getTabCount() - 1);
            tabPane.validate();
            try {
                URI myURI = new URI(uri);
                browser.getNavigator().loadURI(myURI.toASCIIString(), loadFlags, null, null, null);
            }
            catch (Exception uex) {
                if (!JRexL.on) break block5;
                JRexL.printStackTrace(uex);
            }
        }
    }

    public int createWindow(final int parentPeer, long chromeFlags) {
        if (JRexL.on) {
            JRexL.log(className, "**** createWindow()-->parentPeer<" + parentPeer + "> chromeFlags<" + chromeFlags + ">");
        }
        if ((chromeFlags & 0x80000000L) == 0x80000000L) {
            boolean isModal;
            boolean bl = isModal = (chromeFlags & 0x20000000L) == 0x20000000L;
            if (JRexL.on) {
                JRexL.log(className, "**** createWindow()--> ITS A DIALOG!!!! isModal<" + isModal + ">");
            }
            return this.makeDialog(parentPeer, chromeFlags, isModal);
        }
        if (JRexL.on) {
            JRexL.log(className, "**** createWindow()--> ITS A FRAME!!!!");
        }
        final JFrame frame = new JFrame("JRex - ");
        frame.setIconImage(JRexResource.getIcon("jrex").getImage());
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder());
        frame.setContentPane(mainPanel);
        final JTabbedPane tabPane = new JTabbedPane();
        final JPopupMenu pMenu = this.createTabPopupMenu();
        tabPane.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                this.handleIt(e);
            }

            public void mouseReleased(MouseEvent e) {
                this.handleIt(e);
            }

            private final void handleIt(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JRexTabbedBrowser.this.closeItem.setEnabled(tabPane.getTabCount() > 1);
                    pMenu.show(tabPane, e.getX(), e.getY());
                }
            }
        });
        tabPane.addChangeListener(this);
        JPanel panel = new JPanel();
        tabPane.addTab("[Untitlied]", panel);
        mainPanel.add(tabPane);
        JRexCanvas browser = JRexCanvas.createBrowserComponent(chromeFlags);
        JRexBrowserData browserData = this.setupBrowser(panel, mainPanel, frame, chromeFlags, browser);
        browserData.setAdditionalData(tabPane);
        this.dressUP(mainPanel, browserData, 2);
        if (JRexL.on) {
            JRexL.log(className, "**** createWindow()-->Dressup Done!!");
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Window parent;
                JRexBrowserData browserData = (JRexBrowserData)JRexTabbedBrowser.this.windowTable.get(new Integer(parentPeer));
                if (JRexL.on) {
                    JRexL.log(className, "**** createWindow()-->parentWindow browserData <" + browserData + ">");
                }
                Window window = parent = browserData != null ? browserData.getWindow() : JRexTabbedBrowser.this.rootWindow;
                if (JRexL.on) {
                    JRexL.log(className, "**** createWindow()--> parent <" + parent + ">");
                }
                if (parent != null) {
                    frame.setLocationRelativeTo(parent);
                }
                frame.setExtendedState(6);
                frame.setVisible(true);
            }
        });
        return browser.getJRexPeer();
    }

    public void setTitle(int browserPeer, final String title) {
        if (JRexL.on) {
            JRexL.log(className, "**** setTitle()-->browserPeer<" + browserPeer + "> title<" + title + ">");
        }
        JRexBrowserData browserData = (JRexBrowserData)this.windowTable.get(new Integer(browserPeer));
        if (JRexL.on) {
            JRexL.log(className, "**** setTitle()-->browserData<" + browserData + ">");
        }
        if (!$assertionsDisabled && browserData == null) {
            throw new AssertionError();
        }
        if (!(browserData.getWindow() instanceof Dialog)) {
            final JTabbedPane tabPane = (JTabbedPane)browserData.getAdditionalData();
            final int index = this.getTabIndex(tabPane, browserPeer);
            if (JRexL.on) {
                JRexL.log(className, "**** setTitle()-->index<" + index + ">");
            }
            if (!$assertionsDisabled && index == -1) {
                throw new AssertionError();
            }
            if (index == -1) {
                return;
            }
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    tabPane.setTitleAt(index, title);
                }
            });
            if (index == tabPane.getSelectedIndex()) {
                super.setTitle(browserPeer, title);
            }
        } else {
            super.setTitle(browserPeer, title);
        }
    }

    public void destroyWindow(final int browserPeer) {
        if (JRexL.on) {
            JRexL.log(className, "**** destroyWindow()-->browserPeer<" + browserPeer + ">");
        }
        final JRexBrowserData browserData = (JRexBrowserData)this.windowTable.get(new Integer(browserPeer));
        if (JRexL.on) {
            JRexL.log(className, "**** destroyWindow()-->browserData<" + browserData + ">");
        }
        if (!$assertionsDisabled && browserData == null) {
            throw new AssertionError();
        }
        if (!(browserData.getWindow() instanceof Dialog)) {
            JTabbedPane tabPane = (JTabbedPane)browserData.getAdditionalData();
            tabPane.removeChangeListener(this);
            while (tabPane.getTabCount() > 0) {
                JRexCanvas browser = this.getBrowserForParent((JPanel)tabPane.getComponentAt(0));
                if (JRexL.on) {
                    JRexL.log(className, "**** destroyWindow()-->destroying tab with browserPeer<" + browser.getJRexPeer() + ">");
                }
                this.destroyTab(browser.getJRexPeer());
            }
        }
        if (JRexL.on) {
            JRexL.log(className, "**** destroyWindow()-->tabPane removeAll() done!!!");
        }
        if (EventQueue.isDispatchThread()) {
            this.destroyWindowInternal(browserData.getWindow(), browserPeer);
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    JRexTabbedBrowser.this.destroyWindowInternal(browserData.getWindow(), browserPeer);
                }
            });
        }
    }

    public void destroyTab(int browserPeer) {
        if (JRexL.on) {
            JRexL.log(className, "**** destroyTab()-->browserPeer<" + browserPeer + ">");
        }
        JRexBrowserData browserData = (JRexBrowserData)this.windowTable.get(new Integer(browserPeer));
        if (JRexL.on) {
            JRexL.log(className, "**** destroyTab()-->browserData<" + browserData + ">");
        }
        if (!$assertionsDisabled && browserData == null) {
            throw new AssertionError();
        }
        JTabbedPane tabPane = (JTabbedPane)browserData.getAdditionalData();
        int index = this.getTabIndex(tabPane, browserPeer);
        if (JRexL.on) {
            JRexL.log(className, "**** destroyTab()-->index<" + index + ">");
        }
        this.removeWindow(browserPeer);
        if (index > -1) {
            tabPane.remove(index);
        }
    }

    private final int getTabIndex(JTabbedPane tabPane, int browserPeer) {
        int tabCount = tabPane.getTabCount();
        if (JRexL.on) {
            JRexL.log(className, "**** getTabIndex()-->tabCount<" + tabCount + ">");
        }
        for (int i = 0; i < tabCount; ++i) {
            JRexCanvas temp = this.getBrowserForParent((JPanel)tabPane.getComponentAt(i));
            if (JRexL.on) {
                JRexL.log(className, "**** getTabIndex()-->temp<" + temp + ">");
            }
            if (temp == null || browserPeer != temp.getJRexPeer()) continue;
            return i;
        }
        return -1;
    }

    public void stateChanged(ChangeEvent e) {
        Window window;
        Dress dress;
        JTabbedPane tabPane = (JTabbedPane)e.getSource();
        int index = tabPane.getSelectedIndex();
        if (JRexL.on) {
            JRexL.log(className, "**** stateChanged()-->index <" + index + ">");
        }
        if (index < 0) {
            return;
        }
        Window root = SwingUtilities.windowForComponent(tabPane);
        if (root instanceof Frame) {
            ((Frame)root).setTitle(tabPane.getTitleAt(index));
        } else if (root instanceof Dialog) {
            ((Dialog)root).setTitle(tabPane.getTitleAt(index));
        }
        int tabCount = tabPane.getTabCount();
        JRexCanvas browser = this.getBrowserForParent((JPanel)tabPane.getComponentAt(index));
        if (JRexL.on) {
            JRexL.log(className, "**** stateChanged()--> tabCount <" + tabCount + "> browser <" + browser + ">");
        }
        if (browser != null && (dress = (Dress)this.dressTable.get(window = this.getBrowserWindow(browser.getJRexPeer()))) != null) {
            if (dress.getToolBar() != null) {
                dress.getToolBar().setBrowser(browser);
            }
            if (dress.getMenuBar() != null) {
                dress.getMenuBar().setBrowser(browser);
            }
            if (dress.getStatusBar() != null) {
                dress.getStatusBar().setBrowser(browser);
            }
            if (dress.getPopupMenu() != null) {
                dress.getPopupMenu().setBrowser(browser);
            }
        }
    }

    public void actionPerformed(ActionEvent ae) {
        String action = ae.getActionCommand();
        if (JRexL.on) {
            JRexL.log(className, "**** actionPerformed() -->action <" + action + ">  ****");
        }
        try {
            JRexCanvas temp;
            JTabbedPane tabPane = (JTabbedPane)((JPopupMenu)((Component)ae.getSource()).getParent()).getInvoker();
            int index = tabPane.getSelectedIndex();
            if (JRexL.on) {
                JRexL.log(className, "**** actionPerformed()-->index<" + index + ">");
            }
            if (index < 0) {
                return;
            }
            if (action.equals(TB_NEW_TAB)) {
                JRexCanvas temp2 = this.getBrowserForParent((JPanel)tabPane.getComponentAt(index));
                if (temp2 == null) {
                    return;
                }
                ((JRexWindowManager)JRexFactory.getInstance().getImplInstance("WindowManager")).openNewTab(temp2.getJRexPeer(), "", 0);
            } else if (action.equals(TB_RELOAD_TAB)) {
                JRexCanvas temp3 = this.getBrowserForParent((JPanel)tabPane.getComponentAt(index));
                if (temp3 != null) {
                    temp3.getNavigator().reload(0);
                }
            } else if (action.equals(TB_CLOSE_TAB) && (temp = this.getBrowserForParent((JPanel)tabPane.getComponentAt(index))) != null) {
                this.destroyTab(temp.getJRexPeer());
            }
        }
        catch (JRexException ex) {
            JRexL.printStackTrace(ex);
        }
    }

    static {
        $assertionsDisabled = !JRexTabbedBrowser.class.desiredAssertionStatus();
        className = JRexTabbedBrowser.class.getName();
        TB_NEW_TAB = JRexResource.getString("TB_NEW_TAB");
        TB_RELOAD_TAB = JRexResource.getString("TB_RELOAD_TAB");
        TB_CLOSE_TAB = JRexResource.getString("TB_CLOSE_TAB");
        TB_CANCEL = JRexResource.getString("TB_CANCEL");
    }

    private static class Dress {
        private JRexToolBar toolBar;
        private JRexMenuBar menuBar;
        private JRexStatusBar statusBar;
        private JRexPopupMenu popupMenu;

        private Dress(JRexToolBar toolBar, JRexMenuBar menuBar, JRexStatusBar statusBar, JRexPopupMenu popupMenu) {
            this.toolBar = toolBar;
            this.menuBar = menuBar;
            this.statusBar = statusBar;
            this.popupMenu = popupMenu;
        }

        private JRexToolBar getToolBar() {
            return this.toolBar;
        }

        private JRexMenuBar getMenuBar() {
            return this.menuBar;
        }

        private JRexStatusBar getStatusBar() {
            return this.statusBar;
        }

        private JRexPopupMenu getPopupMenu() {
            return this.popupMenu;
        }
    }
}

