/*
 * Decompiled with CFR 0.152.
 */
package org.l10nZilla.writer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.l10nZilla.Phrase;
import org.l10nZilla.TranslationFile;
import org.l10nZilla.writer.contentRdfWriter;
import org.l10nZilla.writer.translationsWriter;

public class mozJarWriter
extends translationsWriter {
    private String zipPrefix;
    private String targetLanguage;
    private File zipFile;
    private FileOutputStream fos;
    private ZipOutputStream zos;
    private BufferedOutputStream bos;
    private String currentEntryFileName;
    private int fileType;
    private static final int FILETYPE_PROPERTIES = 1;
    private static final int FILETYPE_DTD = 7;
    private static final int FILETYPE_UNKNOWN = 8;
    private File tempFile;
    private FileOutputStream tempos;
    private OutputStreamWriter osw;
    private BufferedWriter bw;
    private Properties propsFile;
    private contentRdfWriter myContentRdfWriter = new contentRdfWriter();

    public mozJarWriter(String install, String destination) {
        super(install, destination);
        try {
            this.zipPrefix = "locale/".concat(String.valueOf(String.valueOf(this.myContentRdfWriter.getLocaleName())));
            this.zipFile = new File(destination);
            this.fos = new FileOutputStream(this.zipFile);
            this.zos = new ZipOutputStream(this.fos);
            this.bos = new BufferedOutputStream(this.zos);
        }
        catch (Exception e) {
            System.out.println("Error writing jar file ");
            System.exit(1);
        }
    }

    public String getTargetLanguageCode() {
        return this.targetLanguage;
    }

    public void setTargetLanguageCode(String trgtLanguageCode) {
        this.targetLanguage = trgtLanguageCode;
    }

    public void exportFile(TranslationFile file) {
        try {
            this.currentEntryFileName = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.zipPrefix))).append("/").append(file.getComponentPath()).append(file.getFileName())));
            this.tempFile = File.createTempFile("MTT_", null);
            this.tempFile.deleteOnExit();
            this.tempos = new FileOutputStream(this.tempFile);
            if (this.currentEntryFileName.endsWith(".properties")) {
                this.setupWritePropertiesFile();
            } else if (this.currentEntryFileName.endsWith(".dtd")) {
                this.setupWriteDTDFile();
            } else if (file.getFileName().equalsIgnoreCase("contents.rdf")) {
                this.createRDFFile(file);
            } else if (this.currentEntryFileName.endsWith(".gif")) {
                this.writeGifFile(file.getBinaryFile());
            } else {
                this.writeUnsupportedTextFileType(file.getRawContent());
            }
        }
        catch (Exception e) {
            System.out.println("Error in exporting file");
            System.exit(1);
        }
    }

    public void exportPhrase(Phrase phrase) {
        if (this.currentEntryFileName.endsWith(".properties")) {
            this.writeToPropertiesFile(phrase);
        } else if (this.currentEntryFileName.endsWith(".dtd")) {
            this.writeToDTDFile(phrase);
        }
    }

    public void concludeExportFile() {
        try {
            if (this.currentEntryFileName.endsWith(".properties")) {
                this.propsFile.store(this.tempos, "");
            } else if (this.currentEntryFileName.endsWith(".dtd")) {
                this.bw.close();
            } else if (this.currentEntryFileName.endsWith(".rdf")) {
                this.bw.close();
            } else {
                this.bw.close();
            }
            this.copyFile(this.tempFile, this.currentEntryFileName);
            this.tempFile.delete();
        }
        catch (Exception e) {
            System.out.println("Exception in closing up export file");
            System.exit(1);
        }
    }

    public void prepareExportFile() {
    }

    public void close() {
        try {
            this.bos.close();
        }
        catch (Exception e) {
            System.out.println("Exception in closing");
            System.exit(1);
        }
    }

    private void setupWritePropertiesFile() {
        this.propsFile = new Properties();
    }

    private void setupWriteDTDFile() {
        try {
            this.osw = new OutputStreamWriter((OutputStream)this.tempos, "UTF-8");
            this.bw = new BufferedWriter(this.osw);
            this.bw.newLine();
        }
        catch (Exception e) {
            System.out.println("Exception occurred in setting up DTD file export");
            System.exit(1);
        }
    }

    private void writeToPropertiesFile(Phrase phrase) {
        if (phrase.isTranslationNeeded()) {
            this.propsFile.setProperty(phrase.getKey(), phrase.getTranslatedText());
        } else {
            this.propsFile.setProperty(phrase.getKey(), phrase.getTranslatedText());
        }
    }

    private void writeToDTDFile(Phrase phrase) {
        String line = "";
        try {
            line = phrase.getTranslatedText().indexOf("\"") == -1 ? String.valueOf(String.valueOf(new StringBuffer("<!ENTITY ").append(phrase.getKey()).append(" \"").append(phrase.getTranslatedText()).append("\">"))) : String.valueOf(String.valueOf(new StringBuffer("<!ENTITY ").append(phrase.getKey()).append(" '").append(phrase.getTranslatedText()).append("'>")));
            this.bw.write(line, 0, line.length());
            this.bw.newLine();
        }
        catch (Exception e) {
            System.out.println("Exception occured in writing dtd entry");
            System.exit(1);
        }
    }

    private void createRDFFile(TranslationFile file) {
        try {
            this.osw = new OutputStreamWriter((OutputStream)this.tempos, "UTF-8");
            this.bw = new BufferedWriter(this.osw);
            String rdfString = this.myContentRdfWriter.getContentRdfString(file);
            this.bw.write(rdfString);
        }
        catch (Exception e) {
            System.out.println("Exception occured in writing content rdf entry");
            System.exit(1);
        }
    }

    private void copyFile(File tempFile, String eName) throws IOException {
        ZipEntry ze = new ZipEntry(eName);
        this.zos.putNextEntry(ze);
        FileInputStream fis = new FileInputStream(tempFile);
        BufferedInputStream bis = new BufferedInputStream(fis);
        boolean theEnd = false;
        while (!theEnd) {
            int trans = bis.read();
            if (trans == -1) {
                theEnd = true;
                continue;
            }
            this.bos.write(trans);
        }
        bis.close();
        this.bos.flush();
    }

    private void writeUnsupportedTextFileType(String rawContent) {
        try {
            this.osw = new OutputStreamWriter(this.tempos);
            this.bw = new BufferedWriter(this.osw);
            this.bw.write(rawContent, 0, rawContent.length());
        }
        catch (Exception e) {
            System.out.println("Exception occurred in writing unsupported file export");
            System.exit(1);
        }
    }

    private void writeGifFile(File tempGifFile) {
        try {
            this.osw = new OutputStreamWriter(this.tempos);
            this.bw = new BufferedWriter(this.osw);
            FileInputStream temp_fis = new FileInputStream(tempGifFile);
            InputStreamReader temp_isr = new InputStreamReader(temp_fis);
            BufferedReader temp_br = new BufferedReader(temp_isr);
            boolean theEnd = false;
            while (!theEnd) {
                int number = temp_br.read();
                if (number == -1) {
                    theEnd = true;
                    continue;
                }
                this.bw.write(number);
            }
        }
        catch (Exception e) {
            System.out.println("Exception occurred in writing GIF file");
            System.exit(1);
        }
    }

    public boolean needTranslatorObject() {
        return true;
    }

    static {
        FILETYPE_PROPERTIES = 1;
        FILETYPE_DTD = 7;
        FILETYPE_UNKNOWN = 8;
    }
}

