/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is MacroTracker Bug Tracking System Source Code
 *
 * The Initial Developer of the Original Code is
 * R.J. Keller.
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */
package org.mozdev.MacroTracker.toolkit.guiPanels;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import org.mozdev.MacroTracker.toolkit.*;
import org.mozdev.MacroTracker.toolkit.guiPanels.*;
import org.mozdev.MacroTracker.main.MacroTracker;
import org.mozdev.MacroTracker.classes.*;

/**
 *This form displays GUI for either product editing or creation.
 *
 *<p>Use the <code>getProduct()</code> method to retrieve the product generated by this
 *form.</p>
 *
 *<p>To detect if the user hit the cancel button or not, use the
 *<code>getUserResponse()</code> function which will return APPROVE_OPTION or
 *CANCEL_OPTION.</p>
 *
 *@author R.J. Keller
 */
public class ProductEditorPanel extends JPanel implements ActionListener
{
	java.util.Queue q;
	private addRemovePanel mComponents;
	private addRemovePanel mVersion;
	private addRemovePanel mOS;
	private addRemovePanel mPlatform;
	
	private JButton btnOK;
	private JButton btnCancel;
	private JButton btnHelp;
	
	private MTextField txtOwner;
	private MTextField txtQA;
	
	private String mProductName;
	
	public static final byte APPROVE_OPTION = 2;
	public static final byte CANCEL_OPTION = 3;
	
	private byte mWindowOption;
	
	//ToDo: Implement help button for frmProductCreation.
	public ProductEditorPanel(String productName)
	{		
		mProductName = productName;
		
		mComponents = new addRemovePanel("Components");
		mVersion = new addRemovePanel("Versions");
		mOS = new addRemovePanel("OS");
		mPlatform = new addRemovePanel("Platform");
		
		JPanel mainContent = new JPanel(new GridLayout(3,2));
		mainContent.add(mComponents);
		mainContent.add(mVersion);
		mainContent.add(mOS);
		mainContent.add(mPlatform);
		
		setLayout(new BorderLayout());
		add(mainContent, BorderLayout.CENTER);
		
		//add buttons that appear at the bottom.
		JPanel pnlBottomButtons = new JPanel(new FlowLayout());
		btnOK = new JButton("OK");
		btnCancel = new JButton("Cancel");
		btnHelp = new JButton("Help");
		
		//adding action listeners
		btnOK.addActionListener(this);
		btnCancel.addActionListener(this);
		btnHelp.addActionListener(this);
		
		//adding buttons to GUI.
		pnlBottomButtons.add(btnOK);
		pnlBottomButtons.add(btnCancel);
		pnlBottomButtons.add(btnHelp);
		
		JPanel pnlOwner = new JPanel(new GridLayout(2,2));
		txtOwner = new MTextField();
		pnlOwner.add(new JLabel("Owner:", JLabel.RIGHT), BorderLayout.WEST);
		pnlOwner.add(txtOwner, BorderLayout.CENTER);
		
		pnlOwner.add(new JLabel("QA Contact:", JLabel.RIGHT), BorderLayout.WEST);
		txtQA = new MTextField();
		pnlOwner.add(txtQA, BorderLayout.CENTER);
		
		mainContent.add(pnlOwner);
		mainContent.add(new JPanel());

		add(pnlBottomButtons, BorderLayout.SOUTH);
	}
	
	/**
	 *Returns the product generated by the form.
	 */
	public Product getProduct()
	{
		Product product = new Product();
		product.name = mProductName;
		
		//Add components
//		for (Iterator i = mComponents.getData(); i.hasNext(); )
//		{
			//ToDo: The owner is set to null and cannot be changed. We need to make this work once more is implemented.
//			product.components.add(new product.component((String)i.next(), null, null));
//		}
		
		//Add Versions
		for (Iterator i = mVersion.getData(); i.hasNext(); )
		{
			String version = (String)i.next();
			try
			{
				product.addVersion(Double.parseDouble(version));
			}
			catch (Exception ex)
			{
				JOptionPane.showMessageDialog(this, "Cannot generate version " + version + ", so it will not be added to the list.");
			}
		}
		
		//Add Operating Systems
		for (Iterator i = mOS.getData(); i.hasNext(); )
		{
			product.addOS((String)i.next());
		}
		
		//Add Platforms
		for (Iterator i = mPlatform.getData(); i.hasNext(); )
		{
			product.addPlatform((String)i.next());
		}
		
		//ToDo: Make owner and QA setting for a product connect with the database better.
		return product;
	}
	
	/**
	 *Returns whether or not the user hit the OK or Cancel button on the dialog.
	 *
	 *<p>If the user hit OK and created a product successfully, APPROVE_OPTION
	 *will be returned. If the user hit the Cancel button, CANCEL_OPTION is
	 *returned.</p>
	 *
	 *@return What button the user hit in the dialog box (OK or Cancel).
	 */
	public byte getUserResponse()
	{
		return mWindowOption;
	}
	
	/**
	 *Updates the GUI of the panel to what is contained in this product.
	 *
	 *<p>This is useful if you want to edit a previous product.</p>
	 *
	 *@param product The product to set for editing.
	 */
	public void setProduct(Product product)
	{
		mComponents.clear();
		mVersion.clear();
		mOS.clear();
		mPlatform.clear();
		
		for (int i = 0; i < product.componentSize(); i++)
		{
			mComponents.addItem(product.getComponent(i).getName());
		}
		
		for (int i = 0; i < product.versionSize(); i++)
		{
			mVersion.addItem(String.valueOf(product.getVersion(i)));
		}
		
		for (int i = 0; i < product.OSSize(); i++)
		{
			mOS.addItem(product.getOS(i));
		}
		
		for (int i = 0; i < product.platformSize(); i++)
		{
			mPlatform.addItem(product.getPlatform(i));
		}
	}
	
	public void actionPerformed(ActionEvent e)
	{
		if (e.getSource() == btnCancel)
		{
			mWindowOption = ProductEditorPanel.CANCEL_OPTION;
			setVisible(false);
		}
		else if (e.getSource() == btnOK)
		{
			mWindowOption = ProductEditorPanel.APPROVE_OPTION;
			setVisible(false);
		}
	}
}
