/*** -*- Mode: Javascript; tab-width: 2;
The contents of this file are subject to the Mozilla Public
License Version 1.1 (the "License"); you may not use this file
except in compliance with the License. You may obtain a copy of
the License at http://www.mozilla.org/MPL/
                                                                                                    
Software distributed under the License is distributed on an "AS
IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
implied. See the License for the specific language governing
rights and limitations under the License.
                                                                                                    
The Original Code is jslib code.
The Initial Developer of the Original Code is jslib team.
                                                                                                    
Portions created by jslib team are
Copyright (C) 2000 jslib team.  All
Rights Reserved.
                                                                                                    
Contributor(s): Rajeev J Sebastian <rajeev_jsv@yahoo.com)> (original author)
                                                                                                    
*************************************/


//string keys and values

if (typeof(JS_LIB_LOADED)=='boolean') {

if (typeof(JS_DICTIONARY_LOADED)!='boolean')
  include(jslib_ds_dictionary);

const JS_CHAINDICTIONARY_FILE     = "chainDictionary.js";
const JS_CHAINDICTIONARY_LOADED   = true;


function ChainDictionary()
{
  this._default = new Dictionary();
  this._chained = new Array();
  this.put(_default); //add the default to the chain as well
}

ChainDictionary.prototype =
{
  _default: null,
  _chained: null,

  //iterator related
  _chainind: null,

  //if key exists, will replace current value with value arg
  put: function(key,value)
  {
    if( key == null || value == null) return this;

    for( var i = 0; i < this._chained.size(); i++ )
    {
      if( this._chained.hasKey(key) )
      {
        this._chained[i].put(key, value);
        dictind = i;
        break;
      }
    }
    if( dictind == -1 )
    {
      this._default.put(key, value);
    }
    return this;
  },

  put: function(dictionary)
  {
    if( dictionary == null ) return this;

    this._chained.push(dictionary);
    return this;
  }

  get: function(key)
  {
    for( var i = 0; i < this._chained.size(); i++ )
    {
        var value = this._chained[i].get(key);
        if( value ) return value;
    }
    return null;
  },

  remove: function(key)
  {
    for(var i = 0; i < this._chained.size(); i++ )
      remove(key);
  },

  keys: function()
  {
    var list = new Array();
    for(var i = 0; i < this._chained.length; i++ )
      list.concat(this._chained.keys());

    return list;
  },

  toString: function()
  {
    var size;
    for(var i = 0; i < this._chained.length; i++ )
      size += this._chained.size();

    return "Array :" + size;
  },

  get size()
  {
    var size;
    for(var i = 0; i < this._chained.length; i++ )
      size += this._chained.size();

    return size;
  },

  //iterator
  //iterates over each Parameter
  resetIterator: function()
  {
    this._chainind = 0;
    for(var i = 0; i < this._chained.length; i++ )
      this._chained[i].resetIterator();
  },

  hasMoreElements: function()
  {
    //if there are more dicts after the current in the chain
    if ( this._chainind < this._chained.length -1 )
      return true;
    //if there are more elements in the current dict
    else return this._chained[_chainind].hasMoreElements();
  },

  next: function()
  {
    if( !this._chained[_chainind].hasMoreElements() )
      this._chainind++;
    return this._chained[_chainin].getNext();
  }
}
jslibDebug('*** load: '+JS_CHAINDICTIONARY_FILE+' OK');

} // END BLOCK JS_LIB_LOADED CHECK

// If jslib base library is not loaded, dump this error.
else {
   dump("JS_BASE library not loaded:\n"
        + " \tTo load use: chrome://jslib/content/jslib.js\n"

        + " \tThen: include(jslib_chaindictionary);\n\n");

};
