/*** -*- Mode: Javascript; tab-width: 2;

The contents of this file are subject to the Mozilla Public
License Version 1.1 (the "License"); you may not use this file
except in compliance with the License. You may obtain a copy of
the License at http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS
IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
implied. See the License for the specific language governing
rights and limitations under the License.

The Original Code is Mozdev Group, Inc. code.
The Initial Developer of the Original Code is Pete Collins.

Portions created by Mozdev Group, Inc. are
Copyright (C) 2003 Mozdev Group, Inc.  All
Rights Reserved.

Contributor(s):
Pete Collins <pete@mozdev.org)> (original author)

***/

/****************** Globals **********************/

if (typeof(JS_LIB_LOADED)=='boolean') {

const JS_REMOTEFILE_FILE     = "remoteFile.js";
const JS_REMOTEFILE_LOADED   = true;

const JS_REMOTEFILE_URI_CID  = "@mozilla.org/network/simple-uri;1";
const JS_REMOTEFILE_URI_I_ID = jslibI.nsIURI;

const JS_REMOTEFILE_IOSERVICE_CID  = "@mozilla.org/network/io-service;1";
const JS_REMOTEFILE_I_IOSERVICE    = jslibI.nsIIOService;
const JS_REMOTEFILE_IOSERVICE      = jslibGetService(JS_REMOTEFILE_IOSERVICE_CID,
                                                     "nsIIOService");
                                                                                                    
/****************** Remote File Object Class *********************/

function RemoteFile(aURL) 
{
  if (!aURL)
    return jslibError("NS_ERROR_XPC_NOT_ENOUGH_ARGS");

  try {
    var url = jslibCreateInstance(JS_REMOTEFILE_URI_CID, 
                                  "nsIURI");

    url.spec = aURL;

    var protocol = url.scheme;

    if (protocol != "http") {
      jslibDebug("RemoteFile URL: "+aURL);
      jslibDebug("RemoteFile: Sorry, only http is implemented! not ["+protocol+"]");
      return null;
    }

    this.mURI = aURL;
  } catch (e) { jslibError(e); }

  return JS_LIB_OK; 
} // constructor

RemoteFile.prototype  = 
{
  mURI : null,
  mInputStream : null,
  mOutputStream : null,
  mContent : null,
  mContentType : null,

open : function () 
{
  var rf = new XMLHttpRequest();
  rf.open("GET", this.mURI, false);
  // to prevent leaks see Mozilla bug #206947
  rf.overrideMimeType("text/xml");
  rf.send(null);
                                                                                                    
  if (rf.status!=200)
    jslibDebug("Status Code: "+rf.status);
                                                                                                    
  this.mContent = rf.responseText;
  this.mContentType = rf.getResponseHeader("Content-type");
  return true;
},

read : function () 
{
  if (!this.mContent)
    throw "No remote file instance available you must use open first";

  return this.mContent;
},

get nsIURI () 
{
  if (!this.mURI)
    return "";
  return (JS_REMOTEFILE_IOSERVICE.newURI(this.mURI, null, null));
},

get contentType () 
{
  if (!this.mURI)
    return "";
  if (this.mContentType)
    return this.mContentType;

  var xml = new XMLHttpRequest();
  xml.open("HEAD", this.mURI, false);
  xml.overrideMimeType("text/xml");
  xml.send(null);
                                                                                                    
  return xml.getResponseHeader("Content-type");
},

exists : function () 
{
  if (!this.mURI)
    return false;;

  var rv = false;
  var xml = new XMLHttpRequest();
  xml.open("HEAD", this.mURI, false);
  xml.overrideMimeType("text/xml");
  xml.send(null);

  if (xml.status != 404)
    rv = true;

  return rv;
},

/**
 * returns a javascript Date object
 * for the Last-Modified timestamp of the 
 * remote url
 */
get dateModified () { return this.lastModified; },

get lastModified () 
{
  if (!this.mURI)
    return null;

  var rv = null;
  var xml = new XMLHttpRequest();
  xml.open("HEAD", this.mURI, false);
  xml.overrideMimeType("text/xml");
  xml.send(null);
                                                                                                    
  rv = xml.getAllResponseHeaders();
  rv = rv.match(/Last-Modified: .*/);

  if (!rv)
    return null;

  rv = rv[0];

  return (new Date(rv.substring(15, rv.length)));
},

/********************* help *****************************
* void getter help
*
*   Returns the methods in this object
*
* return values on success and failure
*   aStr   The methods in this object
*
* useage:
*   <string> = obj.help;
****************************************************/
get help() 
{

  const help =

    "\n\nFunction and Attribute List:\n"                  +
    "nsIURI\n"                                            +
    "open()\n"                                            +
    "read()\n"                                            +
    "contentType\n"                                       +
    "exists()\n"                                          +
    "\n";                  

  return help;
} 

} 

jslibDebug('*** load: '+JS_REMOTEFILE_FILE+' OK');

} // END BLOCK JS_LIB_LOADED CHECK

// If jslib base library is not loaded, dump this error.
else {
   dump("JS_BASE library not loaded:\n"
        + " \tTo load use: chrome://jslib/content/jslib.js\n" 

        + " \tThen: include(jslib_remotefile);\n\n");

}; // END FileSystem Class
