

/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozdom4java
 *
 * The Initial Developer of the Original Code is
 * Peter Szinek, Lixto Software GmbH, http://www.lixto.com.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *  Peter Szinek (peter@rubyrailways.com)
 *  Michal Ceresna (michal.ceresna@gmail.com)
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */


package org.mozilla.dom.html;

//Java imports
import java.util.*;

//org.w3c imports
import org.w3c.dom.*;
import org.w3c.dom.html2.*;
import org.w3c.dom.html.*;
import org.w3c.dom.events.*;
import org.w3c.dom.traversal.*;
import org.w3c.dom.ranges.*;
import org.w3c.dom.views.*;

//mozdom4java imports
import org.mozilla.dom.*;
import org.mozilla.dom.views.*;

//XPCOM import
import org.mozilla.xpcom.*;
import org.mozilla.interfaces.*;


public class HTMLSelectElementImpl extends HTMLElementImpl implements org.w3c.dom.html.HTMLSelectElement
{
    protected HTMLSelectElementImpl(nsIDOMHTMLSelectElement mozInst)
    {
        super( mozInst );
    }

    public static HTMLSelectElementImpl getDOMInstance(nsIDOMHTMLSelectElement mozInst)
    {
        HTMLSelectElementImpl node = (HTMLSelectElementImpl) instances.get(mozInst);
        return node == null ? new HTMLSelectElementImpl(mozInst) : node;
    }
    
    public nsIDOMHTMLSelectElement getInstance()
    {
        //This was already queryinterfaced, so safe to cast
        return (nsIDOMHTMLSelectElement) moz;
    }
    
    public HTMLFormElement getForm()
    {
        nsIDOMHTMLFormElement result = getInstance().getForm();
        return (HTMLFormElement) NodeFactory.getNodeInstance(result);
    }
    
    public void focus()
    {
        getInstance().focus();
    }
    
    public int getSize()
    {
        int result = getInstance().getSize();
        return result;
    }
    
    public HTMLCollection getOptions()
    {
        throw new UnsupportedException();
    }
    
    public void setMultiple(boolean multiple)
    {
        getInstance().setMultiple(multiple);
    }
    
    public int getLength()
    {
        long result = getInstance().getLength();
        return (int) result;        
    }
    
    public String getName()
    {
        String result = getInstance().getName();
        return result;
    }
    
    public boolean getMultiple()
    {
        boolean result = getInstance().getMultiple();
        return result;
    }
    
    public void add(HTMLElement element, HTMLElement before)
    {
        nsIDOMHTMLElement mozElement = ((HTMLElementImpl) element).getInstance();
        nsIDOMHTMLElement mozBefore = ((HTMLElementImpl) before).getInstance();
        getInstance().add(mozElement, mozBefore);
    }
    
    public void blur()
    {
        getInstance().blur();
    }
    
    public void setTabIndex(int tabIndex)
    {
        getInstance().setTabIndex(tabIndex);
    }
    
    public void setValue(String value)
    {
        getInstance().setValue(value);
    }
    
    public void setName(String name)
    {
        getInstance().setName(name);
    }
    
    public int getSelectedIndex()
    {
        int result = getInstance().getSelectedIndex();
        return result;
    }
    
    public String getType()
    {
        String result = getInstance().getType();
        return result;
    }
    
    public int getTabIndex()
    {
        int result = getInstance().getTabIndex();
        return result;
    }
    
    public void setSelectedIndex(int selectedIndex)
    {
        getInstance().setSelectedIndex(selectedIndex);
    }
    
    public void remove(int index)
    {
        getInstance().remove(index);
    }
    
    public String getValue()
    {
        String result = getInstance().getValue();
        return result;
    }
    
    public void setDisabled(boolean disabled)
    {
        getInstance().setDisabled(disabled);
    }
    
    public boolean getDisabled()
    {
        boolean result = getInstance().getDisabled();
        return result;
    }
    
    public void setSize(int size)
    {
        getInstance().setSize(size);
    }
    
}
