

/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozdom4java
 *
 * The Initial Developer of the Original Code is
 * Peter Szinek, Lixto Software GmbH, http://www.lixto.com.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *  Peter Szinek (peter@rubyrailways.com)
 *  Michal Ceresna (michal.ceresna@gmail.com)
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */


package org.mozilla.dom.html;

//Java imports
import java.util.*;
import java.util.concurrent.*;

//org.w3c imports
import org.w3c.dom.*;
import org.w3c.dom.html2.*;
import org.w3c.dom.html.*;
import org.w3c.dom.events.*;
import org.w3c.dom.traversal.*;
import org.w3c.dom.ranges.*;
import org.w3c.dom.views.*;

//mozdom4java imports
import org.mozilla.dom.*;
import org.mozilla.dom.views.*;
import org.mozilla.dom.events.*;
import org.mozilla.dom.ranges.*;
import org.mozilla.dom.traversal.*;

//XPCOM import
import org.mozilla.xpcom.*;
import org.mozilla.interfaces.*;


public class HTMLTableElementImpl extends HTMLElementImpl implements org.w3c.dom.html.HTMLTableElement
{


    public nsIDOMHTMLTableElement getInstance()
    {
	return getInstanceAsnsIDOMHTMLTableElement();
    }

    /***************************************************************
     *
     * HTMLTableElement implementation code
     *
     ***************************************************************/

    public HTMLTableElementImpl(nsIDOMHTMLTableElement mozInst)
    {
        super( mozInst );
    }

    public static HTMLTableElementImpl getDOMInstance(nsIDOMHTMLTableElement mozInst)
    {
        
        HTMLTableElementImpl node = (HTMLTableElementImpl) instances.get(mozInst);
        return node == null ? new HTMLTableElementImpl(mozInst) : node;
    }

    public nsIDOMHTMLTableElement getInstanceAsnsIDOMHTMLTableElement()
    {
        if (moz==null)
            return null;
        else
            return (nsIDOMHTMLTableElement) moz.queryInterface(nsIDOMHTMLTableElement.NS_IDOMHTMLTABLEELEMENT_IID);
    }

    public void deleteTHead()
    {
        //METHOD-BODY-START - autogenerated code
        final Runnable r = new Runnable() { public void run() {
            getInstanceAsnsIDOMHTMLTableElement().deleteTHead();
        }};
        ThreadProxy.getSingleton().syncExec(r);
        //METHOD-BODY-END - autogenerated code
    }

    public HTMLCollection getRows()
    {
        //METHOD-BODY-START - autogenerated code
        Callable<HTMLCollection> c = new Callable<HTMLCollection>() { public HTMLCollection call() {
            nsIDOMHTMLCollection result = getInstanceAsnsIDOMHTMLTableElement().getRows();
            return new HTMLCollectionImpl(result);
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public HTMLTableCaptionElement getCaption()
    {
        //METHOD-BODY-START - autogenerated code
        Callable<HTMLTableCaptionElement> c = new Callable<HTMLTableCaptionElement>() { public HTMLTableCaptionElement call() {
            nsIDOMHTMLTableCaptionElement result = getInstanceAsnsIDOMHTMLTableElement().getCaption();
            return (HTMLTableCaptionElement) NodeFactory.getNodeInstance(result);
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public HTMLElement createCaption()
    {
        //METHOD-BODY-START - autogenerated code
        Callable<HTMLElement> c = new Callable<HTMLElement>() { public HTMLElement call() {
            nsIDOMHTMLElement result = getInstanceAsnsIDOMHTMLTableElement().createCaption();
            return (HTMLElement) NodeFactory.getNodeInstance(result);
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public void setWidth(final String width)
    {
        //METHOD-BODY-START - autogenerated code
        final Runnable r = new Runnable() { public void run() {
            getInstanceAsnsIDOMHTMLTableElement().setWidth(width);
        }};
        ThreadProxy.getSingleton().syncExec(r);
        //METHOD-BODY-END - autogenerated code
    }

    public void setRules(final String rules)
    {
        //METHOD-BODY-START - autogenerated code
        final Runnable r = new Runnable() { public void run() {
            getInstanceAsnsIDOMHTMLTableElement().setRules(rules);
        }};
        ThreadProxy.getSingleton().syncExec(r);
        //METHOD-BODY-END - autogenerated code
    }

    public HTMLElement createTFoot()
    {
        //METHOD-BODY-START - autogenerated code
        Callable<HTMLElement> c = new Callable<HTMLElement>() { public HTMLElement call() {
            nsIDOMHTMLElement result = getInstanceAsnsIDOMHTMLTableElement().createTFoot();
            return (HTMLElement) NodeFactory.getNodeInstance(result);
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public String getRules()
    {
        //METHOD-BODY-START - autogenerated code
        Callable<String> c = new Callable<String>() { public String call() {
            String result = getInstanceAsnsIDOMHTMLTableElement().getRules();
            return result;
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public String getFrame()
    {
        //METHOD-BODY-START - autogenerated code
        Callable<String> c = new Callable<String>() { public String call() {
            String result = getInstanceAsnsIDOMHTMLTableElement().getFrame();
            return result;
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public void deleteRow(final int index)
    {
        //METHOD-BODY-START - autogenerated code
        final Runnable r = new Runnable() { public void run() {
            getInstanceAsnsIDOMHTMLTableElement().deleteRow(index);
        }};
        ThreadProxy.getSingleton().syncExec(r);
        //METHOD-BODY-END - autogenerated code
    }

    public void setTHead(final HTMLTableSectionElement tHead)
    {
        //METHOD-BODY-START - autogenerated code
        final nsIDOMHTMLTableSectionElement mozThead = tHead!=null ? ((HTMLTableSectionElementImpl) tHead).getInstance() : null;
        final Runnable r = new Runnable() { public void run() {
            getInstanceAsnsIDOMHTMLTableElement().setTHead(mozThead);
        }};
        ThreadProxy.getSingleton().syncExec(r);
        //METHOD-BODY-END - autogenerated code
    }

    public void setTFoot(final HTMLTableSectionElement tFoot)
    {
        //METHOD-BODY-START - autogenerated code
        final nsIDOMHTMLTableSectionElement mozTfoot = tFoot!=null ? ((HTMLTableSectionElementImpl) tFoot).getInstance() : null;
        final Runnable r = new Runnable() { public void run() {
            getInstanceAsnsIDOMHTMLTableElement().setTFoot(mozTfoot);
        }};
        ThreadProxy.getSingleton().syncExec(r);
        //METHOD-BODY-END - autogenerated code
    }

    public void setCellSpacing(final String cellSpacing)
    {
        //METHOD-BODY-START - autogenerated code
        final Runnable r = new Runnable() { public void run() {
            getInstanceAsnsIDOMHTMLTableElement().setCellSpacing(cellSpacing);
        }};
        ThreadProxy.getSingleton().syncExec(r);
        //METHOD-BODY-END - autogenerated code
    }

    public HTMLCollection getTBodies()
    {
        //METHOD-BODY-START - autogenerated code
        Callable<HTMLCollection> c = new Callable<HTMLCollection>() { public HTMLCollection call() {
            nsIDOMHTMLCollection result = getInstanceAsnsIDOMHTMLTableElement().getTBodies();
            return new HTMLCollectionImpl(result);
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public void setBgColor(final String bgColor)
    {
        //METHOD-BODY-START - autogenerated code
        final Runnable r = new Runnable() { public void run() {
            getInstanceAsnsIDOMHTMLTableElement().setBgColor(bgColor);
        }};
        ThreadProxy.getSingleton().syncExec(r);
        //METHOD-BODY-END - autogenerated code
    }

    public HTMLElement createTHead()
    {
        //METHOD-BODY-START - autogenerated code
        Callable<HTMLElement> c = new Callable<HTMLElement>() { public HTMLElement call() {
            nsIDOMHTMLElement result = getInstanceAsnsIDOMHTMLTableElement().createTHead();
            return (HTMLElement) NodeFactory.getNodeInstance(result);
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public void setSummary(final String summary)
    {
        //METHOD-BODY-START - autogenerated code
        final Runnable r = new Runnable() { public void run() {
            getInstanceAsnsIDOMHTMLTableElement().setSummary(summary);
        }};
        ThreadProxy.getSingleton().syncExec(r);
        //METHOD-BODY-END - autogenerated code
    }

    public HTMLTableSectionElement getTHead()
    {
        //METHOD-BODY-START - autogenerated code
        Callable<HTMLTableSectionElement> c = new Callable<HTMLTableSectionElement>() { public HTMLTableSectionElement call() {
            nsIDOMHTMLTableSectionElement result = getInstanceAsnsIDOMHTMLTableElement().getTHead();
            return (HTMLTableSectionElement) NodeFactory.getNodeInstance(result);
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public void setAlign(final String align)
    {
        //METHOD-BODY-START - autogenerated code
        final Runnable r = new Runnable() { public void run() {
            getInstanceAsnsIDOMHTMLTableElement().setAlign(align);
        }};
        ThreadProxy.getSingleton().syncExec(r);
        //METHOD-BODY-END - autogenerated code
    }

    public HTMLTableSectionElement getTFoot()
    {
        //METHOD-BODY-START - autogenerated code
        Callable<HTMLTableSectionElement> c = new Callable<HTMLTableSectionElement>() { public HTMLTableSectionElement call() {
            nsIDOMHTMLTableSectionElement result = getInstanceAsnsIDOMHTMLTableElement().getTFoot();
            return (HTMLTableSectionElement) NodeFactory.getNodeInstance(result);
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public String getSummary()
    {
        //METHOD-BODY-START - autogenerated code
        Callable<String> c = new Callable<String>() { public String call() {
            String result = getInstanceAsnsIDOMHTMLTableElement().getSummary();
            return result;
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public String getAlign()
    {
        //METHOD-BODY-START - autogenerated code
        Callable<String> c = new Callable<String>() { public String call() {
            String result = getInstanceAsnsIDOMHTMLTableElement().getAlign();
            return result;
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public void setCaption(final HTMLTableCaptionElement caption)
    {
        //METHOD-BODY-START - autogenerated code
        final nsIDOMHTMLTableCaptionElement mozCaption = caption!=null ? ((HTMLTableCaptionElementImpl) caption).getInstance() : null;
        final Runnable r = new Runnable() { public void run() {
            getInstanceAsnsIDOMHTMLTableElement().setCaption(mozCaption);
        }};
        ThreadProxy.getSingleton().syncExec(r);
        //METHOD-BODY-END - autogenerated code
    }

    public void deleteTFoot()
    {
        //METHOD-BODY-START - autogenerated code
        final Runnable r = new Runnable() { public void run() {
            getInstanceAsnsIDOMHTMLTableElement().deleteTFoot();
        }};
        ThreadProxy.getSingleton().syncExec(r);
        //METHOD-BODY-END - autogenerated code
    }

    public String getWidth()
    {
        //METHOD-BODY-START - autogenerated code
        Callable<String> c = new Callable<String>() { public String call() {
            String result = getInstanceAsnsIDOMHTMLTableElement().getWidth();
            return result;
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public void setFrame(final String frame)
    {
        //METHOD-BODY-START - autogenerated code
        final Runnable r = new Runnable() { public void run() {
            getInstanceAsnsIDOMHTMLTableElement().setFrame(frame);
        }};
        ThreadProxy.getSingleton().syncExec(r);
        //METHOD-BODY-END - autogenerated code
    }

    public String getCellPadding()
    {
        //METHOD-BODY-START - autogenerated code
        Callable<String> c = new Callable<String>() { public String call() {
            String result = getInstanceAsnsIDOMHTMLTableElement().getCellPadding();
            return result;
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public String getBorder()
    {
        //METHOD-BODY-START - autogenerated code
        Callable<String> c = new Callable<String>() { public String call() {
            String result = getInstanceAsnsIDOMHTMLTableElement().getBorder();
            return result;
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public HTMLElement insertRow(final int index)
    {
        //METHOD-BODY-START - autogenerated code
        Callable<HTMLElement> c = new Callable<HTMLElement>() { public HTMLElement call() {
            nsIDOMHTMLElement result = getInstanceAsnsIDOMHTMLTableElement().insertRow(index);
            return (HTMLElement) NodeFactory.getNodeInstance(result);
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public void setBorder(final String border)
    {
        //METHOD-BODY-START - autogenerated code
        final Runnable r = new Runnable() { public void run() {
            getInstanceAsnsIDOMHTMLTableElement().setBorder(border);
        }};
        ThreadProxy.getSingleton().syncExec(r);
        //METHOD-BODY-END - autogenerated code
    }

    public void deleteCaption()
    {
        //METHOD-BODY-START - autogenerated code
        final Runnable r = new Runnable() { public void run() {
            getInstanceAsnsIDOMHTMLTableElement().deleteCaption();
        }};
        ThreadProxy.getSingleton().syncExec(r);
        //METHOD-BODY-END - autogenerated code
    }

    public String getCellSpacing()
    {
        //METHOD-BODY-START - autogenerated code
        Callable<String> c = new Callable<String>() { public String call() {
            String result = getInstanceAsnsIDOMHTMLTableElement().getCellSpacing();
            return result;
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public String getBgColor()
    {
        //METHOD-BODY-START - autogenerated code
        Callable<String> c = new Callable<String>() { public String call() {
            String result = getInstanceAsnsIDOMHTMLTableElement().getBgColor();
            return result;
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public void setCellPadding(final String cellPadding)
    {
        //METHOD-BODY-START - autogenerated code
        final Runnable r = new Runnable() { public void run() {
            getInstanceAsnsIDOMHTMLTableElement().setCellPadding(cellPadding);
        }};
        ThreadProxy.getSingleton().syncExec(r);
        //METHOD-BODY-END - autogenerated code
    }



}
